# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `actionmailer` gem.
# Please instead update this file by running `bin/tapioca gem actionmailer`.


# :include: ../README.rdoc
#
# source://actionmailer//lib/action_mailer/gem_version.rb#3
module ActionMailer
  extend ::ActiveSupport::Autoload

  class << self
    # source://actionmailer//lib/action_mailer/deprecator.rb#4
    def deprecator; end

    # source://actionmailer//lib/action_mailer.rb#61
    def eager_load!; end

    # Returns the currently loaded version of Action Mailer as a +Gem::Version+.
    #
    # source://actionmailer//lib/action_mailer/gem_version.rb#5
    def gem_version; end

    # Returns the currently loaded version of Action Mailer as a
    # +Gem::Version+.
    #
    # source://actionmailer//lib/action_mailer/version.rb#8
    def version; end
  end
end

# = Action Mailer \Base
#
# Action Mailer allows you to send email from your application using a mailer model and views.
#
# == Mailer Models
#
# To use Action Mailer, you need to create a mailer model.
#
#   $ bin/rails generate mailer Notifier
#
# The generated model inherits from <tt>ApplicationMailer</tt> which in turn
# inherits from +ActionMailer::Base+. A mailer model defines methods
# used to generate an email message. In these methods, you can set up variables to be used in
# the mailer views, options on the mail itself such as the <tt>:from</tt> address, and attachments.
#
#   class ApplicationMailer < ActionMailer::Base
#     default from: 'from@example.com'
#     layout 'mailer'
#   end
#
#   class NotifierMailer < ApplicationMailer
#     default from: 'no-reply@example.com',
#             return_path: 'system@example.com'
#
#     def welcome(recipient)
#       @account = recipient
#       mail(to: recipient.email_address_with_name,
#            bcc: ["bcc@example.com", "Order Watcher <watcher@example.com>"])
#     end
#   end
#
# Within the mailer method, you have access to the following methods:
#
# * <tt>attachments[]=</tt> - Allows you to add attachments to your email in an intuitive
#   manner; <tt>attachments['filename.png'] = File.read('path/to/filename.png')</tt>
#
# * <tt>attachments.inline[]=</tt> - Allows you to add an inline attachment to your email
#   in the same manner as <tt>attachments[]=</tt>
#
# * <tt>headers[]=</tt> - Allows you to specify any header field in your email such
#   as <tt>headers['X-No-Spam'] = 'True'</tt>. Note that declaring a header multiple times
#   will add many fields of the same name. Read #headers doc for more information.
#
# * <tt>headers(hash)</tt> - Allows you to specify multiple headers in your email such
#   as <tt>headers({'X-No-Spam' => 'True', 'In-Reply-To' => '1234@message.id'})</tt>
#
# * <tt>mail</tt> - Allows you to specify email to be sent.
#
# The hash passed to the mail method allows you to specify any header that a +Mail::Message+
# will accept (any valid email header including optional fields).
#
# The +mail+ method, if not passed a block, will inspect your views and send all the views with
# the same name as the method, so the above action would send the +welcome.text.erb+ view
# file as well as the +welcome.html.erb+ view file in a +multipart/alternative+ email.
#
# If you want to explicitly render only certain templates, pass a block:
#
#   mail(to: user.email) do |format|
#     format.text
#     format.html
#   end
#
# The block syntax is also useful in providing information specific to a part:
#
#   mail(to: user.email) do |format|
#     format.html
#   end
#
# Or even to render a special view:
#
#   mail(to: user.email) do |format|
#     format.text
#     format.html { render "some_other_template" }
#   end
#
# == Mailer views
#
# Like Action Controller, each mailer class has a corresponding view directory in which each
# method of the class looks for a template with its name.
#
# To define a template to be used with a mailer, create an <tt>.erb</tt> file with the same
# name as the method in your mailer model. For example, in the mailer defined above, the template at
# <tt>app/views/notifier_mailer/welcome.text.erb</tt> would be used to generate the email.
#
# Variables defined in the methods of your mailer model are accessible as instance variables in their
# corresponding view.
#
# Emails by default are sent in plain text, so a sample view for our model example might look like this:
#
#   Hi <%= @account.name %>,
#   Thanks for joining our service! Please check back often.
#
# You can even use Action View helpers in these views. For example:
#
#   You got a new note!
#   <%= truncate(@note.body, length: 25) %>
#
# If you need to access the subject, from, or the recipients in the view, you can do that through message object:
#
#   You got a new note from <%= message.from %>!
#   <%= truncate(@note.body, length: 25) %>
#
#
# == Generating URLs
#
# URLs can be generated in mailer views using <tt>url_for</tt> or named routes. Unlike controllers from
# Action Pack, the mailer instance doesn't have any context about the incoming request, so you'll need
# to provide all of the details needed to generate a URL.
#
# When using <tt>url_for</tt> you'll need to provide the <tt>:host</tt>, <tt>:controller</tt>, and <tt>:action</tt>:
#
#   <%= url_for(host: "example.com", controller: "welcome", action: "greeting") %>
#
# When using named routes you only need to supply the <tt>:host</tt>:
#
#   <%= users_url(host: "example.com") %>
#
# You should use the <tt>named_route_url</tt> style (which generates absolute URLs) and avoid using the
# <tt>named_route_path</tt> style (which generates relative URLs), since clients reading the mail will
# have no concept of a current URL from which to determine a relative path.
#
# It is also possible to set a default host that will be used in all mailers by setting the <tt>:host</tt>
# option as a configuration option in <tt>config/application.rb</tt>:
#
#   config.action_mailer.default_url_options = { host: "example.com" }
#
# You can also define a <tt>default_url_options</tt> method on individual mailers to override these
# default settings per-mailer.
#
# By default when <tt>config.force_ssl</tt> is +true+, URLs generated for hosts will use the HTTPS protocol.
#
# == Sending mail
#
# Once a mailer action and template are defined, you can deliver your message or defer its creation and
# delivery for later:
#
#   NotifierMailer.welcome(User.first).deliver_now # sends the email
#   mail = NotifierMailer.welcome(User.first)      # => an ActionMailer::MessageDelivery object
#   mail.deliver_now                               # generates and sends the email now
#
# The ActionMailer::MessageDelivery class is a wrapper around a delegate that will call
# your method to generate the mail. If you want direct access to the delegator, or +Mail::Message+,
# you can call the <tt>message</tt> method on the ActionMailer::MessageDelivery object.
#
#   NotifierMailer.welcome(User.first).message     # => a Mail::Message object
#
# Action Mailer is nicely integrated with Active Job so you can generate and send emails in the background
# (example: outside of the request-response cycle, so the user doesn't have to wait on it):
#
#   NotifierMailer.welcome(User.first).deliver_later # enqueue the email sending to Active Job
#
# Note that <tt>deliver_later</tt> will execute your method from the background job.
#
# You never instantiate your mailer class. Rather, you just call the method you defined on the class itself.
# All instance methods are expected to return a message object to be sent.
#
# == Multipart Emails
#
# Multipart messages can also be used implicitly because Action Mailer will automatically detect and use
# multipart templates, where each template is named after the name of the action, followed by the content
# type. Each such detected template will be added to the message, as a separate part.
#
# For example, if the following templates exist:
# * signup_notification.text.erb
# * signup_notification.html.erb
# * signup_notification.xml.builder
# * signup_notification.yml.erb
#
# Each would be rendered and added as a separate part to the message, with the corresponding content
# type. The content type for the entire message is automatically set to <tt>multipart/alternative</tt>,
# which indicates that the email contains multiple different representations of the same email
# body. The same instance variables defined in the action are passed to all email templates.
#
# Implicit template rendering is not performed if any attachments or parts have been added to the email.
# This means that you'll have to manually add each part to the email and set the content type of the email
# to <tt>multipart/alternative</tt>.
#
# == Attachments
#
# Sending attachment in emails is easy:
#
#   class NotifierMailer < ApplicationMailer
#     def welcome(recipient)
#       attachments['free_book.pdf'] = File.read('path/to/file.pdf')
#       mail(to: recipient, subject: "New account information")
#     end
#   end
#
# Which will (if it had both a <tt>welcome.text.erb</tt> and <tt>welcome.html.erb</tt>
# template in the view directory), send a complete <tt>multipart/mixed</tt> email with two parts,
# the first part being a <tt>multipart/alternative</tt> with the text and HTML email parts inside,
# and the second being a <tt>application/pdf</tt> with a Base64 encoded copy of the file.pdf book
# with the filename +free_book.pdf+.
#
# If you need to send attachments with no content, you need to create an empty view for it,
# or add an empty body parameter like this:
#
#     class NotifierMailer < ApplicationMailer
#       def welcome(recipient)
#         attachments['free_book.pdf'] = File.read('path/to/file.pdf')
#         mail(to: recipient, subject: "New account information", body: "")
#       end
#     end
#
# You can also send attachments with HTML template, in this case you need to add body, attachments,
# and custom content type like this:
#
#     class NotifierMailer < ApplicationMailer
#       def welcome(recipient)
#         attachments["free_book.pdf"] = File.read("path/to/file.pdf")
#         mail(to: recipient,
#              subject: "New account information",
#              content_type: "text/html",
#              body: "<html><body>Hello there</body></html>")
#       end
#     end
#
# == Inline Attachments
#
# You can also specify that a file should be displayed inline with other HTML. This is useful
# if you want to display a corporate logo or a photo.
#
#   class NotifierMailer < ApplicationMailer
#     def welcome(recipient)
#       attachments.inline['photo.png'] = File.read('path/to/photo.png')
#       mail(to: recipient, subject: "Here is what we look like")
#     end
#   end
#
# And then to reference the image in the view, you create a <tt>welcome.html.erb</tt> file and
# make a call to +image_tag+ passing in the attachment you want to display and then call
# +url+ on the attachment to get the relative content id path for the image source:
#
#   <h1>Please Don't Cringe</h1>
#
#   <%= image_tag attachments['photo.png'].url -%>
#
# As we are using Action View's +image_tag+ method, you can pass in any other options you want:
#
#   <h1>Please Don't Cringe</h1>
#
#   <%= image_tag attachments['photo.png'].url, alt: 'Our Photo', class: 'photo' -%>
#
# == Observing and Intercepting Mails
#
# Action Mailer provides hooks into the Mail observer and interceptor methods. These allow you to
# register classes that are called during the mail delivery life cycle.
#
# An observer class must implement the <tt>:delivered_email(message)</tt> method which will be
# called once for every email sent after the email has been sent.
#
# An interceptor class must implement the <tt>:delivering_email(message)</tt> method which will be
# called before the email is sent, allowing you to make modifications to the email before it hits
# the delivery agents. Your class should make any needed modifications directly to the passed
# in +Mail::Message+ instance.
#
# == Default \Hash
#
# Action Mailer provides some intelligent defaults for your emails, these are usually specified in a
# default method inside the class definition:
#
#   class NotifierMailer < ApplicationMailer
#     default sender: 'system@example.com'
#   end
#
# You can pass in any header value that a +Mail::Message+ accepts. Out of the box,
# +ActionMailer::Base+ sets the following:
#
# * <tt>mime_version: "1.0"</tt>
# * <tt>charset:      "UTF-8"</tt>
# * <tt>content_type: "text/plain"</tt>
# * <tt>parts_order:  [ "text/plain", "text/enriched", "text/html" ]</tt>
#
# <tt>parts_order</tt> and <tt>charset</tt> are not actually valid +Mail::Message+ header fields,
# but Action Mailer translates them appropriately and sets the correct values.
#
# As you can pass in any header, you need to either quote the header as a string, or pass it in as
# an underscored symbol, so the following will work:
#
#   class NotifierMailer < ApplicationMailer
#     default 'Content-Transfer-Encoding' => '7bit',
#             content_description: 'This is a description'
#   end
#
# Finally, Action Mailer also supports passing <tt>Proc</tt> and <tt>Lambda</tt> objects into the default hash,
# so you can define methods that evaluate as the message is being generated:
#
#   class NotifierMailer < ApplicationMailer
#     default 'X-Special-Header' => Proc.new { my_method }, to: -> { @inviter.email_address }
#
#     private
#       def my_method
#         'some complex call'
#       end
#   end
#
# Note that the proc/lambda is evaluated right at the start of the mail message generation, so if you
# set something in the default hash using a proc, and then set the same thing inside of your
# mailer method, it will get overwritten by the mailer method.
#
# It is also possible to set these default options that will be used in all mailers through
# the <tt>default_options=</tt> configuration in <tt>config/application.rb</tt>:
#
#    config.action_mailer.default_options = { from: "no-reply@example.org" }
#
# == \Callbacks
#
# You can specify callbacks using <tt>before_action</tt> and <tt>after_action</tt> for configuring your messages,
# and using <tt>before_deliver</tt> and <tt>after_deliver</tt> for wrapping the delivery process.
# For example, when you want to add default inline attachments and log delivery for all messages
# sent out by a certain mailer class:
#
#   class NotifierMailer < ApplicationMailer
#     before_action :add_inline_attachment!
#     after_deliver :log_delivery
#
#     def welcome
#       mail
#     end
#
#     private
#       def add_inline_attachment!
#         attachments.inline["footer.jpg"] = File.read('/path/to/filename.jpg')
#       end
#
#       def log_delivery
#         Rails.logger.info "Sent email with message id '#{message.message_id}' at #{Time.current}."
#       end
#   end
#
# Action callbacks in Action Mailer are implemented using
# AbstractController::Callbacks, so you can define and configure
# callbacks in the same manner that you would use callbacks in classes that
# inherit from ActionController::Base.
#
# Note that unless you have a specific reason to do so, you should prefer
# using <tt>before_action</tt> rather than <tt>after_action</tt> in your
# Action Mailer classes so that headers are parsed properly.
#
# == Rescuing Errors
#
# +rescue+ blocks inside of a mailer method cannot rescue errors that occur
# outside of rendering -- for example, record deserialization errors in a
# background job, or errors from a third-party mail delivery service.
#
# To rescue errors that occur during any part of the mailing process, use
# {rescue_from}[rdoc-ref:ActiveSupport::Rescuable::ClassMethods#rescue_from]:
#
#   class NotifierMailer < ApplicationMailer
#     rescue_from ActiveJob::DeserializationError do
#       # ...
#     end
#
#     rescue_from "SomeThirdPartyService::ApiError" do
#       # ...
#     end
#
#     def notify(recipient)
#       mail(to: recipient, subject: "Notification")
#     end
#   end
#
# == Previewing emails
#
# You can preview your email templates visually by adding a mailer preview file to the
# <tt>ActionMailer::Base.preview_paths</tt>. Since most emails do something interesting
# with database data, you'll need to write some scenarios to load messages with fake data:
#
#   class NotifierMailerPreview < ActionMailer::Preview
#     def welcome
#       NotifierMailer.welcome(User.first)
#     end
#   end
#
# Methods must return a +Mail::Message+ object which can be generated by calling the mailer
# method without the additional <tt>deliver_now</tt> / <tt>deliver_later</tt>. The location of the
# mailer preview directories can be configured using the <tt>preview_paths</tt> option which has a default
# of <tt>test/mailers/previews</tt>:
#
#   config.action_mailer.preview_paths << "#{Rails.root}/lib/mailer_previews"
#
# An overview of all previews is accessible at <tt>http://localhost:3000/rails/mailers</tt>
# on a running development server instance.
#
# Previews can also be intercepted in a similar manner as deliveries can be by registering
# a preview interceptor that has a <tt>previewing_email</tt> method:
#
#   class CssInlineStyler
#     def self.previewing_email(message)
#       # inline CSS styles
#     end
#   end
#
#   config.action_mailer.preview_interceptors :css_inline_styler
#
# Note that interceptors need to be registered both with <tt>register_interceptor</tt>
# and <tt>register_preview_interceptor</tt> if they should operate on both sending and
# previewing emails.
#
# == Configuration options
#
# These options are specified on the class level, like
# <tt>ActionMailer::Base.raise_delivery_errors = true</tt>
#
# * <tt>default_options</tt> - You can pass this in at a class level as well as within the class itself as
#   per the above section.
#
# * <tt>logger</tt> - the logger is used for generating information on the mailing run if available.
#   Can be set to +nil+ for no logging. Compatible with both Ruby's own +Logger+ and Log4r loggers.
#
# * <tt>smtp_settings</tt> - Allows detailed configuration for <tt>:smtp</tt> delivery method:
#   * <tt>:address</tt> - Allows you to use a remote mail server. Just change it from its default
#     "localhost" setting.
#   * <tt>:port</tt> - On the off chance that your mail server doesn't run on port 25, you can change it.
#   * <tt>:domain</tt> - If you need to specify a HELO domain, you can do it here.
#   * <tt>:user_name</tt> - If your mail server requires authentication, set the username in this setting.
#   * <tt>:password</tt> - If your mail server requires authentication, set the password in this setting.
#   * <tt>:authentication</tt> - If your mail server requires authentication, you need to specify the
#     authentication type here.
#     This is a symbol and one of <tt>:plain</tt> (will send the password Base64 encoded), <tt>:login</tt> (will
#     send the password Base64 encoded) or <tt>:cram_md5</tt> (combines a Challenge/Response mechanism to exchange
#     information and a cryptographic Message Digest 5 algorithm to hash important information)
#   * <tt>:enable_starttls</tt> - Use STARTTLS when connecting to your SMTP server and fail if unsupported. Defaults
#     to <tt>false</tt>. Requires at least version 2.7 of the Mail gem.
#   * <tt>:enable_starttls_auto</tt> - Detects if STARTTLS is enabled in your SMTP server and starts
#     to use it. Defaults to <tt>true</tt>.
#   * <tt>:openssl_verify_mode</tt> - When using TLS, you can set how OpenSSL checks the certificate. This is
#     really useful if you need to validate a self-signed and/or a wildcard certificate. You can use the name
#     of an OpenSSL verify constant (<tt>'none'</tt> or <tt>'peer'</tt>) or directly the constant
#     (+OpenSSL::SSL::VERIFY_NONE+ or +OpenSSL::SSL::VERIFY_PEER+).
#   * <tt>:ssl/:tls</tt> Enables the SMTP connection to use SMTP/TLS (SMTPS: SMTP over direct TLS connection)
#   * <tt>:open_timeout</tt> Number of seconds to wait while attempting to open a connection.
#   * <tt>:read_timeout</tt> Number of seconds to wait until timing-out a read(2) call.
#
# * <tt>sendmail_settings</tt> - Allows you to override options for the <tt>:sendmail</tt> delivery method.
#   * <tt>:location</tt> - The location of the sendmail executable. Defaults to <tt>/usr/sbin/sendmail</tt>.
#   * <tt>:arguments</tt> - The command line arguments. Defaults to <tt>%w[ -i ]</tt> with <tt>-f sender@address</tt>
#     added automatically before the message is sent.
#
# * <tt>file_settings</tt> - Allows you to override options for the <tt>:file</tt> delivery method.
#   * <tt>:location</tt> - The directory into which emails will be written. Defaults to the application
#     <tt>tmp/mails</tt>.
#
# * <tt>raise_delivery_errors</tt> - Whether or not errors should be raised if the email fails to be delivered.
#
# * <tt>delivery_method</tt> - Defines a delivery method. Possible values are <tt>:smtp</tt> (default),
#   <tt>:sendmail</tt>, <tt>:test</tt>, and <tt>:file</tt>. Or you may provide a custom delivery method
#   object e.g. +MyOwnDeliveryMethodClass+. See the Mail gem documentation on the interface you need to
#   implement for a custom delivery agent.
#
# * <tt>perform_deliveries</tt> - Determines whether emails are actually sent from Action Mailer when you
#   call <tt>.deliver</tt> on an email message or on an Action Mailer method. This is on by default but can
#   be turned off to aid in functional testing.
#
# * <tt>deliveries</tt> - Keeps an array of all the emails sent out through the Action Mailer with
#   <tt>delivery_method :test</tt>. Most useful for unit and functional testing.
#
# * <tt>delivery_job</tt> - The job class used with <tt>deliver_later</tt>. Mailers can set this to use a
#   custom delivery job. Defaults to +ActionMailer::MailDeliveryJob+.
#
# * <tt>deliver_later_queue_name</tt> - The queue name used by <tt>deliver_later</tt> with the default
#   <tt>delivery_job</tt>. Mailers can set this to use a custom queue name.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://actionmailer//lib/action_mailer/base.rb#476
class ActionMailer::Base < ::AbstractController::Base
  include ::ActionMailer::Callbacks
  include ::ActiveSupport::Callbacks
  include ::ActionMailer::DeliveryMethods
  include ::ActionMailer::QueuedDelivery
  include ::ActiveSupport::Rescuable
  include ::ActionMailer::Rescuable
  include ::ActionMailer::Parameterized
  include ::ActionMailer::Previews
  include ::ActionMailer::FormBuilder
  include ::ActionView::ViewPaths
  include ::AbstractController::Rendering
  include ::AbstractController::Logger
  include ::ActiveSupport::Benchmarkable
  include ::AbstractController::Helpers
  include ::AbstractController::Translation
  include ::AbstractController::AssetPaths
  include ::AbstractController::Callbacks
  include ::AbstractController::Caching::Fragments
  include ::AbstractController::Caching::ConfigMethods
  include ::AbstractController::Caching
  include ::ActionView::Rendering
  include ::ActionView::Layouts
  extend ::ActionMailer::Callbacks::ClassMethods
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActionMailer::DeliveryMethods::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods
  extend ::ActionMailer::Rescuable::ClassMethods
  extend ::ActionMailer::Parameterized::ClassMethods
  extend ::ActionMailer::Previews::ClassMethods
  extend ::ActionMailer::FormBuilder::ClassMethods
  extend ::ActionView::ViewPaths::ClassMethods
  extend ::AbstractController::Helpers::Resolution
  extend ::AbstractController::Helpers::ClassMethods
  extend ::AbstractController::Callbacks::ClassMethods
  extend ::AbstractController::Caching::Fragments::ClassMethods
  extend ::AbstractController::Caching::ClassMethods
  extend ::AbstractController::Caching::ConfigMethods
  extend ::ActionView::Rendering::ClassMethods
  extend ::ActionView::Layouts::ClassMethods

  # @return [Base] a new instance of Base
  #
  # source://actionmailer//lib/action_mailer/base.rb#643
  def initialize; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _deliver_callbacks; end

  # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
  def _helper_methods; end

  # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
  def _helper_methods=(_arg0); end

  # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
  def _helper_methods?; end

  # source://actionview/7.2.1/lib/action_view/layouts.rb#212
  def _layout_conditions; end

  # source://actionview/7.2.1/lib/action_view/layouts.rb#212
  def _layout_conditions?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _process_action_callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_deliver_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_process_action_callbacks(&block); end

  # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies; end

  # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies=(_arg0); end

  # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def asset_host; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def asset_host=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def assets_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def assets_dir=(value); end

  # Allows you to add attachments to an email, like so:
  #
  #  mail.attachments['filename.jpg'] = File.read('/path/to/filename.jpg')
  #
  # If you do this, then Mail will take the file name and work out the mime type.
  # It will also set the +Content-Type+, +Content-Disposition+, and +Content-Transfer-Encoding+,
  # and encode the contents of the attachment in Base64.
  #
  # You can also specify overrides if you want by passing a hash instead of a string:
  #
  #  mail.attachments['filename.jpg'] = {mime_type: 'application/gzip',
  #                                      content: File.read('/path/to/filename.jpg')}
  #
  # If you want to use encoding other than Base64 then you will need to pass encoding
  # type along with the pre-encoded content as Mail doesn't know how to decode the
  # data:
  #
  #  file_content = SpecialEncode(File.read('/path/to/filename.jpg'))
  #  mail.attachments['filename.jpg'] = {mime_type: 'application/gzip',
  #                                      content: file_content }
  #
  # You can also search for specific attachments:
  #
  #  # By Filename
  #  mail.attachments['filename.jpg']   # => Mail::Part object or nil
  #
  #  # or by index
  #  mail.attachments[0]                # => Mail::Part (first attachment)
  #
  # source://actionmailer//lib/action_mailer/base.rb#760
  def attachments; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def default_asset_host_protocol; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def default_asset_host_protocol=(value); end

  # source://actionmailer//lib/action_mailer/base.rb#502
  def default_params; end

  # source://actionmailer//lib/action_mailer/base.rb#502
  def default_params=(_arg0); end

  # source://actionmailer//lib/action_mailer/base.rb#502
  def default_params?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def default_static_extension; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def default_static_extension=(value); end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
  def deliver_later_queue_name; end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
  def deliver_later_queue_name=(_arg0); end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
  def deliver_later_queue_name?; end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
  def delivery_job; end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
  def delivery_job=(_arg0); end

  # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
  def delivery_job?; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
  def delivery_method; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
  def delivery_method=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
  def delivery_method?; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
  def delivery_methods; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
  def delivery_methods=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
  def delivery_methods?; end

  # Returns an email in the format "Name <email@example.com>".
  #
  # If the name is a blank string, it returns just the address.
  #
  # source://actionmailer//lib/action_mailer/base.rb#684
  def email_address_with_name(address, name); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def enable_fragment_cache_logging; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def enable_fragment_cache_logging=(value); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def file_settings; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def file_settings=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def file_settings?; end

  # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys; end

  # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys=(_arg0); end

  # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys?; end

  # Allows you to pass random and unusual headers to the new +Mail::Message+
  # object which will add them to itself.
  #
  #   headers['X-Special-Domain-Specific-Header'] = "SecretValue"
  #
  # You can also pass a hash into headers of header field names and values,
  # which will then be set on the +Mail::Message+ object:
  #
  #   headers 'X-Special-Domain-Specific-Header' => "SecretValue",
  #           'In-Reply-To' => incoming.message_id
  #
  # The resulting +Mail::Message+ will have the following in its header:
  #
  #   X-Special-Domain-Specific-Header: SecretValue
  #
  # Note about replacing already defined headers:
  #
  # * +subject+
  # * +sender+
  # * +from+
  # * +to+
  # * +cc+
  # * +bcc+
  # * +reply-to+
  # * +orig-date+
  # * +message-id+
  # * +references+
  #
  # Fields can only appear once in email headers while other fields such as
  # <tt>X-Anything</tt> can appear multiple times.
  #
  # If you want to replace any header which already exists, first set it to
  # +nil+ in order to reset the value otherwise another field will be added
  # for the same header.
  #
  # source://actionmailer//lib/action_mailer/base.rb#722
  def headers(args = T.unsafe(nil)); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def javascripts_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def javascripts_dir=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def logger; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def logger=(value); end

  # The main method that creates the message and renders the email templates. There are
  # two ways to call this method, with a block, or without a block.
  #
  # It accepts a headers hash. This hash allows you to specify
  # the most used headers in an email message, these are:
  #
  # * +:subject+ - The subject of the message, if this is omitted, Action Mailer will
  #   ask the \Rails I18n class for a translated +:subject+ in the scope of
  #   <tt>[mailer_scope, action_name]</tt> or if this is missing, will translate the
  #   humanized version of the +action_name+
  # * +:to+ - Who the message is destined for, can be a string of addresses, or an array
  #   of addresses.
  # * +:from+ - Who the message is from
  # * +:cc+ - Who you would like to Carbon-Copy on this email, can be a string of addresses,
  #   or an array of addresses.
  # * +:bcc+ - Who you would like to Blind-Carbon-Copy on this email, can be a string of
  #   addresses, or an array of addresses.
  # * +:reply_to+ - Who to set the +Reply-To+ header of the email to.
  # * +:date+ - The date to say the email was sent on.
  #
  # You can set default values for any of the above headers (except +:date+)
  # by using the ::default class method:
  #
  #  class Notifier < ActionMailer::Base
  #    default from: 'no-reply@test.lindsaar.net',
  #            bcc: 'email_logger@test.lindsaar.net',
  #            reply_to: 'bounces@test.lindsaar.net'
  #  end
  #
  # If you need other headers not listed above, you can either pass them in
  # as part of the headers hash or use the <tt>headers['name'] = value</tt>
  # method.
  #
  # When a +:return_path+ is specified as header, that value will be used as
  # the 'envelope from' address for the Mail message. Setting this is useful
  # when you want delivery notifications sent to a different address than the
  # one in +:from+. Mail will actually use the +:return_path+ in preference
  # to the +:sender+ in preference to the +:from+ field for the 'envelope
  # from' value.
  #
  # If you do not pass a block to the +mail+ method, it will find all
  # templates in the view paths using by default the mailer name and the
  # method name that it is being called from, it will then create parts for
  # each of these templates intelligently, making educated guesses on correct
  # content type and sequence, and return a fully prepared +Mail::Message+
  # ready to call <tt>:deliver</tt> on to send.
  #
  # For example:
  #
  #   class Notifier < ActionMailer::Base
  #     default from: 'no-reply@test.lindsaar.net'
  #
  #     def welcome
  #       mail(to: 'mikel@test.lindsaar.net')
  #     end
  #   end
  #
  # Will look for all templates at "app/views/notifier" with name "welcome".
  # If no welcome template exists, it will raise an ActionView::MissingTemplate error.
  #
  # However, those can be customized:
  #
  #   mail(template_path: 'notifications', template_name: 'another')
  #
  # And now it will look for all templates at "app/views/notifications" with name "another".
  #
  # If you do pass a block, you can render specific templates of your choice:
  #
  #   mail(to: 'mikel@test.lindsaar.net') do |format|
  #     format.text
  #     format.html
  #   end
  #
  # You can even render plain text directly without using a template:
  #
  #   mail(to: 'mikel@test.lindsaar.net') do |format|
  #     format.text { render plain: "Hello Mikel!" }
  #     format.html { render html: "<h1>Hello Mikel!</h1>".html_safe }
  #   end
  #
  # Which will render a +multipart/alternative+ email with +text/plain+ and
  # +text/html+ parts.
  #
  # The block syntax also allows you to customize the part headers if desired:
  #
  #   mail(to: 'mikel@test.lindsaar.net') do |format|
  #     format.html
  #   end
  #
  # source://actionmailer//lib/action_mailer/base.rb#869
  def mail(headers = T.unsafe(nil), &block); end

  # Returns the name of the mailer object.
  #
  # source://actionmailer//lib/action_mailer/base.rb#677
  def mailer_name; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def message; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def message=(_arg0); end

  # source://actionmailer//lib/action_mailer/parameterized.rb#95
  def params; end

  # source://actionmailer//lib/action_mailer/parameterized.rb#93
  def params=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def perform_caching; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def perform_caching=(value); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#16
  def perform_deliveries; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#16
  def perform_deliveries=(val); end

  # source://actionmailer//lib/action_mailer/preview.rb#25
  def preview_interceptors; end

  # source://actionmailer//lib/action_mailer/preview.rb#14
  def preview_paths; end

  # source://actionmailer//lib/action_mailer/base.rb#649
  def process(method_name, *args, **_arg2); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#15
  def raise_delivery_errors; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#15
  def raise_delivery_errors=(val); end

  # source://actionpack/7.2.1/lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions; end

  # source://actionpack/7.2.1/lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions=(val); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def relative_url_root; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def relative_url_root=(value); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers; end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers?; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def sendmail_settings; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def sendmail_settings=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def sendmail_settings?; end

  # source://actionmailer//lib/action_mailer/preview.rb#22
  def show_previews; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def smtp_settings; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def smtp_settings=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def smtp_settings?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def stylesheets_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def stylesheets_dir=(value); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def test_settings; end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def test_settings=(_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
  def test_settings?; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://actionmailer//lib/action_mailer/base.rb#1070
  def _protected_ivars; end

  # source://actionmailer//lib/action_mailer/base.rb#946
  def apply_defaults(headers); end

  # source://actionmailer//lib/action_mailer/base.rb#966
  def assign_headers_to_message(message, headers); end

  # source://actionmailer//lib/action_mailer/base.rb#972
  def collect_responses(headers, &block); end

  # @yield [collector]
  #
  # source://actionmailer//lib/action_mailer/base.rb#982
  def collect_responses_from_block(headers); end

  # source://actionmailer//lib/action_mailer/base.rb#996
  def collect_responses_from_templates(headers); end

  # source://actionmailer//lib/action_mailer/base.rb#989
  def collect_responses_from_text(headers); end

  # source://actionmailer//lib/action_mailer/base.rb#956
  def compute_default(value); end

  # source://actionmailer//lib/action_mailer/base.rb#1039
  def create_parts_from_responses(m, responses); end

  # Translates the +subject+ using \Rails I18n class under <tt>[mailer_scope, action_name]</tt> scope.
  # If it does not find a translation for the +subject+ under the specified scope it will default to a
  # humanized version of the <tt>action_name</tt>.
  # If the subject has interpolations, you can pass them through the +interpolations+ parameter.
  #
  # source://actionmailer//lib/action_mailer/base.rb#936
  def default_i18n_subject(interpolations = T.unsafe(nil)); end

  # source://actionmailer//lib/action_mailer/base.rb#1009
  def each_template(paths, name, &block); end

  # source://actionmailer//lib/action_mailer/base.rb#1052
  def insert_part(container, response, charset); end

  # source://actionmailer//lib/action_mailer/base.rb#1066
  def instrument_name; end

  # This and #instrument_name is for caching instrument
  #
  # source://actionmailer//lib/action_mailer/base.rb#1059
  def instrument_payload(key); end

  # Used by #mail to set the content type of the message.
  #
  # It will use the given +user_content_type+, or multipart if the mail
  # message has any attachments. If the attachments are inline, the content
  # type will be "multipart/related", otherwise "multipart/mixed".
  #
  # If there is no content type passed in via headers, and there are no
  # attachments, or the message is multipart, then the default content type is
  # used.
  #
  # source://actionmailer//lib/action_mailer/base.rb#914
  def set_content_type(m, user_content_type, class_default); end

  # source://actionmailer//lib/action_mailer/base.rb#1018
  def wrap_inline_attachments(message); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://actionmailer//lib/action_mailer/form_builder.rb#18
    def _default_form_builder; end

    # source://actionmailer//lib/action_mailer/form_builder.rb#18
    def _default_form_builder=(value); end

    # source://actionmailer//lib/action_mailer/form_builder.rb#18
    def _default_form_builder?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _deliver_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _deliver_callbacks=(value); end

    # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
    def _helper_methods; end

    # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
    def _helper_methods=(value); end

    # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
    def _helper_methods?; end

    # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#17
    def _helpers; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout=(value); end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout?; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions=(value); end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _process_action_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _process_action_callbacks=(value); end

    # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies; end

    # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies=(value); end

    # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def asset_host; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def asset_host=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def assets_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def assets_dir=(value); end

    # Returns the name of the current mailer. This method is also being used as a path for a view lookup.
    # If this is an anonymous mailer, this method will return +anonymous+ instead.
    #
    # source://actionmailer//lib/action_mailer/base.rb#570
    def controller_path; end

    # Sets the defaults through app configuration:
    #
    #     config.action_mailer.default(from: "no-reply@example.org")
    #
    # Aliased by ::default_options=
    #
    # source://actionmailer//lib/action_mailer/base.rb#582
    def default(value = T.unsafe(nil)); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def default_asset_host_protocol; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def default_asset_host_protocol=(value); end

    # Sets the defaults through app configuration:
    #
    #     config.action_mailer.default(from: "no-reply@example.org")
    #
    # Aliased by ::default_options=
    # Allows to set defaults through app configuration:
    #
    #    config.action_mailer.default_options = { from: "no-reply@example.org" }
    #
    # source://actionmailer//lib/action_mailer/base.rb#582
    def default_options=(value = T.unsafe(nil)); end

    # source://actionmailer//lib/action_mailer/base.rb#502
    def default_params; end

    # source://actionmailer//lib/action_mailer/base.rb#502
    def default_params=(value); end

    # source://actionmailer//lib/action_mailer/base.rb#502
    def default_params?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def default_static_extension; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def default_static_extension=(value); end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
    def deliver_later_queue_name; end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
    def deliver_later_queue_name=(value); end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#9
    def deliver_later_queue_name?; end

    # Wraps an email delivery inside of ActiveSupport::Notifications instrumentation.
    #
    # This method is actually called by the +Mail::Message+ object itself
    # through a callback when you call <tt>:deliver</tt> on the +Mail::Message+,
    # calling +deliver_mail+ directly and passing a +Mail::Message+ will do
    # nothing except tell the logger you sent the email.
    #
    # source://actionmailer//lib/action_mailer/base.rb#597
    def deliver_mail(mail); end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
    def delivery_job; end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
    def delivery_job=(value); end

    # source://actionmailer//lib/action_mailer/queued_delivery.rb#8
    def delivery_job?; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
    def delivery_method; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
    def delivery_method=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#19
    def delivery_method?; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
    def delivery_methods; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
    def delivery_methods=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#18
    def delivery_methods?; end

    # Returns an email in the format "Name <email@example.com>".
    #
    # If the name is a blank string, it returns just the address.
    #
    # source://actionmailer//lib/action_mailer/base.rb#607
    def email_address_with_name(address, name); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def enable_fragment_cache_logging; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def enable_fragment_cache_logging=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def file_settings; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def file_settings=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def file_settings?; end

    # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys; end

    # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys=(value); end

    # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def javascripts_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def javascripts_dir=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def logger; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def logger=(value); end

    # Returns the name of the current mailer. This method is also being used as a path for a view lookup.
    # If this is an anonymous mailer, this method will return +anonymous+ instead.
    #
    # source://actionmailer//lib/action_mailer/base.rb#570
    def mailer_name; end

    # Allows to set the name of current mailer.
    #
    # source://actionmailer//lib/action_mailer/base.rb#574
    def mailer_name=(_arg0); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def perform_caching; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def perform_caching=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#16
    def perform_deliveries; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#16
    def perform_deliveries=(val); end

    # source://actionmailer//lib/action_mailer/preview.rb#25
    def preview_interceptors; end

    # source://actionmailer//lib/action_mailer/preview.rb#25
    def preview_interceptors=(val); end

    # source://actionmailer//lib/action_mailer/preview.rb#14
    def preview_paths; end

    # source://actionmailer//lib/action_mailer/preview.rb#14
    def preview_paths=(val); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#15
    def raise_delivery_errors; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#15
    def raise_delivery_errors=(val); end

    # source://actionpack/7.2.1/lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions; end

    # source://actionpack/7.2.1/lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions=(val); end

    # Register an Interceptor which will be called before mail is sent.
    # Either a class, string, or symbol can be passed in as the Interceptor.
    # If a string or symbol is passed in it will be camelized and constantized.
    #
    # source://actionmailer//lib/action_mailer/base.rb#547
    def register_interceptor(interceptor); end

    # Register one or more Interceptors which will be called before mail is sent.
    #
    # source://actionmailer//lib/action_mailer/base.rb#521
    def register_interceptors(*interceptors); end

    # Register an Observer which will be notified when mail is delivered.
    # Either a class, string, or symbol can be passed in as the Observer.
    # If a string or symbol is passed in it will be camelized and constantized.
    #
    # source://actionmailer//lib/action_mailer/base.rb#533
    def register_observer(observer); end

    # Register one or more Observers which will be notified when mail is delivered.
    #
    # source://actionmailer//lib/action_mailer/base.rb#511
    def register_observers(*observers); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def relative_url_root; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def relative_url_root=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers?; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def sendmail_settings; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def sendmail_settings=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def sendmail_settings?; end

    # source://actionmailer//lib/action_mailer/preview.rb#22
    def show_previews; end

    # source://actionmailer//lib/action_mailer/preview.rb#22
    def show_previews=(val); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def smtp_settings; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def smtp_settings=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def smtp_settings?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def stylesheets_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def stylesheets_dir=(value); end

    # Emails do not support relative path links.
    #
    # @return [Boolean]
    #
    # source://actionmailer//lib/action_mailer/base.rb#942
    def supports_path?; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def test_settings; end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def test_settings=(value); end

    # source://actionmailer//lib/action_mailer/delivery_methods.rb#52
    def test_settings?; end

    # Unregister a previously registered Interceptor.
    # Either a class, string, or symbol can be passed in as the Interceptor.
    # If a string or symbol is passed in it will be camelized and constantized.
    #
    # source://actionmailer//lib/action_mailer/base.rb#554
    def unregister_interceptor(interceptor); end

    # Unregister one or more previously registered Interceptors.
    #
    # source://actionmailer//lib/action_mailer/base.rb#526
    def unregister_interceptors(*interceptors); end

    # Unregister a previously registered Observer.
    # Either a class, string, or symbol can be passed in as the Observer.
    # If a string or symbol is passed in it will be camelized and constantized.
    #
    # source://actionmailer//lib/action_mailer/base.rb#540
    def unregister_observer(observer); end

    # Unregister one or more previously registered Observers.
    #
    # source://actionmailer//lib/action_mailer/base.rb#516
    def unregister_observers(*observers); end

    private

    # source://actionmailer//lib/action_mailer/base.rb#628
    def method_missing(method_name, *_arg1, **_arg2, &_arg3); end

    # source://actionmailer//lib/action_mailer/base.rb#558
    def observer_class_for(value); end

    # @return [Boolean]
    #
    # source://actionmailer//lib/action_mailer/base.rb#636
    def respond_to_missing?(method, include_all = T.unsafe(nil)); end

    # source://actionmailer//lib/action_mailer/base.rb#615
    def set_payload_for_mail(payload, mail); end
  end
end

# source://actionmailer//lib/action_mailer/base.rb#0
module ActionMailer::Base::HelperMethods
  include ::ActionMailer::MailHelper
  include ::ActionText::ContentHelper
  include ::ActionText::TagHelper

  # source://actionpack/7.2.1/lib/abstract_controller/caching/fragments.rb#34
  def combined_fragment_cache_key(*_arg0, **_arg1, &_arg2); end

  # source://actionpack/7.2.1/lib/abstract_controller/caching.rb#45
  def view_cache_dependencies(*_arg0, **_arg1, &_arg2); end
end

# source://actionmailer//lib/action_mailer/base.rb#768
class ActionMailer::Base::LateAttachmentsProxy < ::SimpleDelegator
  # source://actionmailer//lib/action_mailer/base.rb#770
  def []=(_name, _content); end

  # source://actionmailer//lib/action_mailer/base.rb#769
  def inline; end

  private

  # @raise [RuntimeError]
  #
  # source://actionmailer//lib/action_mailer/base.rb#773
  def _raise_error; end
end

# source://actionmailer//lib/action_mailer/base.rb#663
class ActionMailer::Base::NullMail
  # source://actionmailer//lib/action_mailer/base.rb#664
  def body; end

  # source://actionmailer//lib/action_mailer/base.rb#665
  def header; end

  # source://actionmailer//lib/action_mailer/base.rb#671
  def method_missing(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://actionmailer//lib/action_mailer/base.rb#667
  def respond_to?(string, include_all = T.unsafe(nil)); end
end

# source://actionmailer//lib/action_mailer/base.rb#498
ActionMailer::Base::PROTECTED_IVARS = T.let(T.unsafe(nil), Array)

# source://actionmailer//lib/action_mailer/callbacks.rb#4
module ActionMailer::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionMailer::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://actionmailer//lib/action_mailer/callbacks.rb#12
module ActionMailer::Callbacks::ClassMethods
  # Defines a callback that will get called right after the
  # message's delivery method is finished.
  #
  # source://actionmailer//lib/action_mailer/callbacks.rb#21
  def after_deliver(*filters, &blk); end

  # Defines a callback that will get called around the message's deliver method.
  #
  # source://actionmailer//lib/action_mailer/callbacks.rb#26
  def around_deliver(*filters, &blk); end

  # Defines a callback that will get called right before the
  # message is sent to the delivery method.
  #
  # source://actionmailer//lib/action_mailer/callbacks.rb#15
  def before_deliver(*filters, &blk); end
end

# source://actionmailer//lib/action_mailer/collector.rb#8
class ActionMailer::Collector
  include ::AbstractController::Collector

  # @return [Collector] a new instance of Collector
  #
  # source://actionmailer//lib/action_mailer/collector.rb#12
  def initialize(context, &block); end

  # @raise [ArgumentError]
  #
  # source://actionmailer//lib/action_mailer/collector.rb#18
  def all(*args, &block); end

  # @raise [ArgumentError]
  #
  # source://actionmailer//lib/action_mailer/collector.rb#18
  def any(*args, &block); end

  # source://actionmailer//lib/action_mailer/collector.rb#25
  def custom(mime, options = T.unsafe(nil)); end

  # Returns the value of attribute responses.
  #
  # source://actionmailer//lib/action_mailer/collector.rb#10
  def responses; end
end

# = Action Mailer \DeliveryMethods
#
# This module handles everything related to mail delivery, from registering
# new delivery methods to configuring the mail object to be sent.
#
# source://actionmailer//lib/action_mailer/delivery_methods.rb#10
module ActionMailer::DeliveryMethods
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionMailer::DeliveryMethods::ClassMethods

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#79
  def wrap_delivery_behavior!(*args); end

  module GeneratedClassMethods
    def delivery_method; end
    def delivery_method=(value); end
    def delivery_method?; end
    def delivery_methods; end
    def delivery_methods=(value); end
    def delivery_methods?; end
    def file_settings; end
    def file_settings=(value); end
    def file_settings?; end
    def sendmail_settings; end
    def sendmail_settings=(value); end
    def sendmail_settings?; end
    def smtp_settings; end
    def smtp_settings=(value); end
    def smtp_settings?; end
    def test_settings; end
    def test_settings=(value); end
    def test_settings?; end
  end

  module GeneratedInstanceMethods
    def delivery_method; end
    def delivery_method=(value); end
    def delivery_method?; end
    def delivery_methods; end
    def delivery_methods=(value); end
    def delivery_methods?; end
    def file_settings; end
    def file_settings=(value); end
    def file_settings?; end
    def sendmail_settings; end
    def sendmail_settings=(value); end
    def sendmail_settings?; end
    def smtp_settings; end
    def smtp_settings=(value); end
    def smtp_settings?; end
    def test_settings; end
    def test_settings=(value); end
    def test_settings?; end
  end
end

# Helpers for creating and wrapping delivery behavior, used by DeliveryMethods.
#
# source://actionmailer//lib/action_mailer/delivery_methods.rb#41
module ActionMailer::DeliveryMethods::ClassMethods
  # Adds a new delivery method through the given class using the given
  # symbol as alias and the default options supplied.
  #
  #   add_delivery_method :sendmail, Mail::Sendmail,
  #     location:  '/usr/sbin/sendmail',
  #     arguments: %w[ -i ]
  #
  # source://actionmailer//lib/action_mailer/delivery_methods.rb#51
  def add_delivery_method(symbol, klass, default_options = T.unsafe(nil)); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#43
  def deliveries(&_arg0); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#43
  def deliveries=(arg); end

  # source://actionmailer//lib/action_mailer/delivery_methods.rb#57
  def wrap_delivery_behavior(mail, method = T.unsafe(nil), options = T.unsafe(nil)); end
end

# = Action Mailer Form Builder
#
# Override the default form builder for all views rendered by this
# mailer and any of its descendants. Accepts a subclass of
# ActionView::Helpers::FormBuilder.
#
# While emails typically will not include forms, this can be used
# by views that are shared between controllers and mailers.
#
# For more information, see +ActionController::FormBuilder+.
#
# source://actionmailer//lib/action_mailer/form_builder.rb#14
module ActionMailer::FormBuilder
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionMailer::FormBuilder::ClassMethods

  # Default form builder for the mailer
  #
  # source://actionmailer//lib/action_mailer/form_builder.rb#33
  def default_form_builder; end

  module GeneratedClassMethods
    def _default_form_builder; end
    def _default_form_builder=(value); end
    def _default_form_builder?; end
  end

  module GeneratedInstanceMethods; end
end

# source://actionmailer//lib/action_mailer/form_builder.rb#21
module ActionMailer::FormBuilder::ClassMethods
  # Set the form builder to be used as the default for all forms
  # in the views rendered by this mailer and its subclasses.
  #
  # ==== Parameters
  # * <tt>builder</tt> - Default form builder, an instance of ActionView::Helpers::FormBuilder
  #
  # source://actionmailer//lib/action_mailer/form_builder.rb#27
  def default_form_builder(builder); end
end

# = Action Mailer \InlinePreviewInterceptor
#
# Implements a mailer preview interceptor that converts image tag src attributes
# that use inline cid: style URLs to data: style URLs so that they are visible
# when previewing an HTML email in a web browser.
#
# This interceptor is enabled by default. To disable it, delete it from the
# <tt>ActionMailer::Base.preview_interceptors</tt> array:
#
#   ActionMailer::Base.preview_interceptors.delete(ActionMailer::InlinePreviewInterceptor)
#
# source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#17
class ActionMailer::InlinePreviewInterceptor
  include ::Base64

  # @return [InlinePreviewInterceptor] a new instance of InlinePreviewInterceptor
  #
  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#26
  def initialize(message); end

  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#30
  def transform!; end

  private

  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#51
  def data_url(part); end

  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#55
  def find_part(cid); end

  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#47
  def html_part; end

  # Returns the value of attribute message.
  #
  # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#45
  def message; end

  class << self
    # source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#22
    def previewing_email(message); end
  end
end

# source://actionmailer//lib/action_mailer/inline_preview_interceptor.rb#18
ActionMailer::InlinePreviewInterceptor::PATTERN = T.let(T.unsafe(nil), Regexp)

# = Action Mailer \LogSubscriber
#
# Implements the ActiveSupport::LogSubscriber for logging notifications when
# email is delivered or received.
#
# source://actionmailer//lib/action_mailer/log_subscriber.rb#10
class ActionMailer::LogSubscriber < ::ActiveSupport::LogSubscriber
  # An email was delivered.
  #
  # source://actionmailer//lib/action_mailer/log_subscriber.rb#12
  def deliver(event); end

  # Use the logger configured for ActionMailer::Base.
  #
  # source://actionmailer//lib/action_mailer/log_subscriber.rb#38
  def logger; end

  # An email was generated.
  #
  # source://actionmailer//lib/action_mailer/log_subscriber.rb#28
  def process(event); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/log_subscriber.rb#84
    def log_levels; end
  end
end

# = Action Mailer \MailDeliveryJob
#
# The +ActionMailer::MailDeliveryJob+ class is used when you
# want to send emails outside of the request-response cycle. It supports
# sending either parameterized or normal mail.
#
# Exceptions are rescued and handled by the mailer class.
#
# source://actionmailer//lib/action_mailer/mail_delivery_job.rb#13
class ActionMailer::MailDeliveryJob < ::ActiveJob::Base
  # source://actionmailer//lib/action_mailer/mail_delivery_job.rb#21
  def perform(mailer, mail_method, delivery_method, args:, kwargs: T.unsafe(nil), params: T.unsafe(nil)); end

  private

  # source://actionmailer//lib/action_mailer/mail_delivery_job.rb#40
  def handle_exception_with_mailer_class(exception); end

  # "Deserialize" the mailer class name by hand in case another argument
  # (like a Global ID reference) raised DeserializationError.
  #
  # source://actionmailer//lib/action_mailer/mail_delivery_job.rb#34
  def mailer_class; end

  class << self
    # source://activejob/7.2.1/lib/active_job/queue_name.rb#55
    def queue_name; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end
  end
end

# = Action Mailer \MailHelper
#
# Provides helper methods for ActionMailer::Base that can be used for easily
# formatting messages, accessing mailer or message instances, and the
# attachments list.
#
# source://actionmailer//lib/action_mailer/mail_helper.rb#9
module ActionMailer::MailHelper
  # Access the message attachments list.
  #
  # source://actionmailer//lib/action_mailer/mail_helper.rb#45
  def attachments; end

  # Take the text and format it, indented two spaces for each line, and
  # wrapped at 72 columns:
  #
  #   text = <<-TEXT
  #     This is
  #     the      paragraph.
  #
  #     * item1 * item2
  #   TEXT
  #
  #   block_format text
  #   # => "  This is the paragraph.\n\n  * item1\n  * item2\n"
  #
  # source://actionmailer//lib/action_mailer/mail_helper.rb#22
  def block_format(text); end

  # Returns +text+ wrapped at +len+ columns and indented +indent+ spaces.
  # By default column length +len+ equals 72 characters and indent
  # +indent+ equal two spaces.
  #
  #   my_text = 'Here is a sample text with more than 40 characters'
  #
  #   format_paragraph(my_text, 25, 4)
  #   # => "    Here is a sample text with\n    more than 40 characters"
  #
  # source://actionmailer//lib/action_mailer/mail_helper.rb#57
  def format_paragraph(text, len = T.unsafe(nil), indent = T.unsafe(nil)); end

  # Access the mailer instance.
  #
  # source://actionmailer//lib/action_mailer/mail_helper.rb#35
  def mailer; end

  # Access the message instance.
  #
  # source://actionmailer//lib/action_mailer/mail_helper.rb#40
  def message; end
end

# = Action Mailer \MessageDelivery
#
# The +ActionMailer::MessageDelivery+ class is used by
# ActionMailer::Base when creating a new mailer.
# <tt>MessageDelivery</tt> is a wrapper (+Delegator+ subclass) around a lazy
# created +Mail::Message+. You can get direct access to the
# +Mail::Message+, deliver the email or schedule the email to be sent
# through Active Job.
#
#   Notifier.welcome(User.first)               # an ActionMailer::MessageDelivery object
#   Notifier.welcome(User.first).deliver_now   # sends the email
#   Notifier.welcome(User.first).deliver_later # enqueue email delivery as a job through Active Job
#   Notifier.welcome(User.first).message       # a Mail::Message object
#
# source://actionmailer//lib/action_mailer/message_delivery.rb#19
class ActionMailer::MessageDelivery
  # @return [MessageDelivery] a new instance of MessageDelivery
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#20
  def initialize(mailer_class, action, *args, **_arg3); end

  # Method calls are delegated to the Mail::Message that's ready to deliver.
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#31
  def __getobj__; end

  # Unused except for delegator internals (dup, marshalling).
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#36
  def __setobj__(mail_message); end

  # Enqueues the email to be delivered through Active Job. When the
  # job runs it will send the email using +deliver_now+.
  #
  #   Notifier.welcome(User.first).deliver_later
  #   Notifier.welcome(User.first).deliver_later(wait: 1.hour)
  #   Notifier.welcome(User.first).deliver_later(wait_until: 10.hours.from_now)
  #   Notifier.welcome(User.first).deliver_later(priority: 10)
  #
  # Options:
  #
  # * <tt>:wait</tt> - Enqueue the email to be delivered with a delay.
  # * <tt>:wait_until</tt> - Enqueue the email to be delivered at (after) a specific date / time.
  # * <tt>:queue</tt> - Enqueue the email on the specified queue.
  # * <tt>:priority</tt> - Enqueues the email with the specified priority
  #
  # By default, the email will be enqueued using ActionMailer::MailDeliveryJob on
  # the default queue. Mailer classes can customize the queue name used for the default
  # job by assigning a +deliver_later_queue_name+ class variable, or provide a custom job
  # by assigning a +delivery_job+. When a custom job is used, it controls the queue name.
  #
  #   class AccountRegistrationMailer < ApplicationMailer
  #     self.delivery_job = RegistrationDeliveryJob
  #   end
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#102
  def deliver_later(options = T.unsafe(nil)); end

  # Enqueues the email to be delivered through Active Job. When the
  # job runs it will send the email using +deliver_now!+. That means
  # that the message will be sent bypassing checking +perform_deliveries+
  # and +raise_delivery_errors+, so use with caution.
  #
  #   Notifier.welcome(User.first).deliver_later!
  #   Notifier.welcome(User.first).deliver_later!(wait: 1.hour)
  #   Notifier.welcome(User.first).deliver_later!(wait_until: 10.hours.from_now)
  #   Notifier.welcome(User.first).deliver_later!(priority: 10)
  #
  # Options:
  #
  # * <tt>:wait</tt> - Enqueue the email to be delivered with a delay
  # * <tt>:wait_until</tt> - Enqueue the email to be delivered at (after) a specific date / time
  # * <tt>:queue</tt> - Enqueue the email on the specified queue
  # * <tt>:priority</tt> - Enqueues the email with the specified priority
  #
  # By default, the email will be enqueued using ActionMailer::MailDeliveryJob on
  # the default queue. Mailer classes can customize the queue name used for the default
  # job by assigning a +deliver_later_queue_name+ class variable, or provide a custom job
  # by assigning a +delivery_job+. When a custom job is used, it controls the queue name.
  #
  #   class AccountRegistrationMailer < ApplicationMailer
  #     self.delivery_job = RegistrationDeliveryJob
  #   end
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#75
  def deliver_later!(options = T.unsafe(nil)); end

  # Delivers an email:
  #
  #   Notifier.welcome(User.first).deliver_now
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#123
  def deliver_now; end

  # Delivers an email without checking +perform_deliveries+ and +raise_delivery_errors+,
  # so use with caution.
  #
  #   Notifier.welcome(User.first).deliver_now!
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#111
  def deliver_now!; end

  # Returns the resulting Mail::Message
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#41
  def message; end

  # Was the delegate loaded, causing the mailer action to be processed?
  #
  # @return [Boolean]
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#46
  def processed?; end

  private

  # source://actionmailer//lib/action_mailer/message_delivery.rb#140
  def enqueue_delivery(delivery_method, options = T.unsafe(nil)); end

  # Returns the processed Mailer instance. We keep this instance
  # on hand so we can run callbacks and delegate exception handling to it.
  #
  # source://actionmailer//lib/action_mailer/message_delivery.rb#134
  def processed_mailer; end
end

# source://actionmailer//lib/action_mailer/test_case.rb#7
class ActionMailer::NonInferrableMailerError < ::StandardError
  # @return [NonInferrableMailerError] a new instance of NonInferrableMailerError
  #
  # source://actionmailer//lib/action_mailer/test_case.rb#8
  def initialize(name); end
end

# = Action Mailer \Parameterized
#
# Provides the option to parameterize mailers in order to share instance variable
# setup, processing, and common headers.
#
# Consider this example that does not use parameterization:
#
#   class InvitationsMailer < ApplicationMailer
#     def account_invitation(inviter, invitee)
#       @account = inviter.account
#       @inviter = inviter
#       @invitee = invitee
#
#       subject = "#{@inviter.name} invited you to their Basecamp (#{@account.name})"
#
#       mail \
#         subject:   subject,
#         to:        invitee.email_address,
#         from:      common_address(inviter),
#         reply_to:  inviter.email_address_with_name
#     end
#
#     def project_invitation(project, inviter, invitee)
#       @account = inviter.account
#       @project = project
#       @inviter = inviter
#       @invitee = invitee
#       @summarizer = ProjectInvitationSummarizer.new(@project.bucket)
#
#       subject = "#{@inviter.name.familiar} added you to a project in Basecamp (#{@account.name})"
#
#       mail \
#         subject:   subject,
#         to:        invitee.email_address,
#         from:      common_address(inviter),
#         reply_to:  inviter.email_address_with_name
#     end
#
#     def bulk_project_invitation(projects, inviter, invitee)
#       @account  = inviter.account
#       @projects = projects.sort_by(&:name)
#       @inviter  = inviter
#       @invitee  = invitee
#
#       subject = "#{@inviter.name.familiar} added you to some new stuff in Basecamp (#{@account.name})"
#
#       mail \
#         subject:   subject,
#         to:        invitee.email_address,
#         from:      common_address(inviter),
#         reply_to:  inviter.email_address_with_name
#     end
#   end
#
#   InvitationsMailer.account_invitation(person_a, person_b).deliver_later
#
# Using parameterized mailers, this can be rewritten as:
#
#   class InvitationsMailer < ApplicationMailer
#     before_action { @inviter, @invitee = params[:inviter], params[:invitee] }
#     before_action { @account = params[:inviter].account }
#
#     default to:       -> { @invitee.email_address },
#             from:     -> { common_address(@inviter) },
#             reply_to: -> { @inviter.email_address_with_name }
#
#     def account_invitation
#       mail subject: "#{@inviter.name} invited you to their Basecamp (#{@account.name})"
#     end
#
#     def project_invitation
#       @project    = params[:project]
#       @summarizer = ProjectInvitationSummarizer.new(@project.bucket)
#
#       mail subject: "#{@inviter.name.familiar} added you to a project in Basecamp (#{@account.name})"
#     end
#
#     def bulk_project_invitation
#       @projects = params[:projects].sort_by(&:name)
#
#       mail subject: "#{@inviter.name.familiar} added you to some new stuff in Basecamp (#{@account.name})"
#     end
#   end
#
#   InvitationsMailer.with(inviter: person_a, invitee: person_b).account_invitation.deliver_later
#
# source://actionmailer//lib/action_mailer/parameterized.rb#89
module ActionMailer::Parameterized
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionMailer::Parameterized::ClassMethods
end

# source://actionmailer//lib/action_mailer/parameterized.rb#100
module ActionMailer::Parameterized::ClassMethods
  # Provide the parameters to the mailer in order to use them in the instance methods and callbacks.
  #
  #   InvitationsMailer.with(inviter: person_a, invitee: person_b).account_invitation.deliver_later
  #
  # See Parameterized documentation for full example.
  #
  # source://actionmailer//lib/action_mailer/parameterized.rb#106
  def with(params); end
end

# source://actionmailer//lib/action_mailer/parameterized.rb#111
class ActionMailer::Parameterized::Mailer
  # @return [Mailer] a new instance of Mailer
  #
  # source://actionmailer//lib/action_mailer/parameterized.rb#112
  def initialize(mailer, params); end

  private

  # source://actionmailer//lib/action_mailer/parameterized.rb#117
  def method_missing(method_name, *_arg1, **_arg2, &_arg3); end

  # @return [Boolean]
  #
  # source://actionmailer//lib/action_mailer/parameterized.rb#125
  def respond_to_missing?(method, include_all = T.unsafe(nil)); end
end

# source://actionmailer//lib/action_mailer/parameterized.rb#130
class ActionMailer::Parameterized::MessageDelivery < ::ActionMailer::MessageDelivery
  # @return [MessageDelivery] a new instance of MessageDelivery
  #
  # source://actionmailer//lib/action_mailer/parameterized.rb#131
  def initialize(mailer_class, action, params, *_arg3, **_arg4, &_arg5); end

  private

  # source://actionmailer//lib/action_mailer/parameterized.rb#144
  def enqueue_delivery(delivery_method, options = T.unsafe(nil)); end

  # source://actionmailer//lib/action_mailer/parameterized.rb#137
  def processed_mailer; end
end

# source://actionmailer//lib/action_mailer/preview.rb#69
class ActionMailer::Preview
  extend ::ActiveSupport::DescendantsTracker

  # @return [Preview] a new instance of Preview
  #
  # source://actionmailer//lib/action_mailer/preview.rb#74
  def initialize(params = T.unsafe(nil)); end

  # Returns the value of attribute params.
  #
  # source://actionmailer//lib/action_mailer/preview.rb#72
  def params; end

  class << self
    # Returns all mailer preview classes.
    #
    # source://actionmailer//lib/action_mailer/preview.rb#80
    def all; end

    # Returns the mail object for the given email name. The registered preview
    # interceptors will be informed so that they can transform the message
    # as they would if the mail was actually being delivered.
    #
    # source://actionmailer//lib/action_mailer/preview.rb#88
    def call(email, params = T.unsafe(nil)); end

    # Returns +true+ if the email exists.
    #
    # @return [Boolean]
    #
    # source://actionmailer//lib/action_mailer/preview.rb#101
    def email_exists?(email); end

    # Returns all of the available email previews.
    #
    # source://actionmailer//lib/action_mailer/preview.rb#96
    def emails; end

    # Returns +true+ if the preview exists.
    #
    # @return [Boolean]
    #
    # source://actionmailer//lib/action_mailer/preview.rb#106
    def exists?(preview); end

    # Find a mailer preview by its underscored class name.
    #
    # source://actionmailer//lib/action_mailer/preview.rb#111
    def find(preview); end

    # Returns the underscored name of the mailer preview without the suffix.
    #
    # source://actionmailer//lib/action_mailer/preview.rb#116
    def preview_name; end

    private

    # source://actionmailer//lib/action_mailer/preview.rb#135
    def inform_preview_interceptors(message); end

    # source://actionmailer//lib/action_mailer/preview.rb#121
    def load_previews; end

    # source://actionmailer//lib/action_mailer/preview.rb#127
    def preview_paths; end

    # source://actionmailer//lib/action_mailer/preview.rb#131
    def show_previews; end
  end
end

# source://actionmailer//lib/action_mailer/preview.rb#6
module ActionMailer::Previews
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionMailer::Previews::ClassMethods
end

# source://actionmailer//lib/action_mailer/preview.rb#28
module ActionMailer::Previews::ClassMethods
  # Register an Interceptor which will be called before mail is previewed.
  # Either a class or a string can be passed in as the Interceptor. If a
  # string is passed in it will be constantized.
  #
  # source://actionmailer//lib/action_mailer/preview.rb#42
  def register_preview_interceptor(interceptor); end

  # Register one or more Interceptors which will be called before mail is previewed.
  #
  # source://actionmailer//lib/action_mailer/preview.rb#30
  def register_preview_interceptors(*interceptors); end

  # Unregister a previously registered Interceptor.
  # Either a class or a string can be passed in as the Interceptor. If a
  # string is passed in it will be constantized.
  #
  # source://actionmailer//lib/action_mailer/preview.rb#53
  def unregister_preview_interceptor(interceptor); end

  # Unregister one or more previously registered Interceptors.
  #
  # source://actionmailer//lib/action_mailer/preview.rb#35
  def unregister_preview_interceptors(*interceptors); end

  private

  # source://actionmailer//lib/action_mailer/preview.rb#58
  def interceptor_class_for(interceptor); end
end

# source://actionmailer//lib/action_mailer/queued_delivery.rb#4
module ActionMailer::QueuedDelivery
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods

  module GeneratedClassMethods
    def deliver_later_queue_name; end
    def deliver_later_queue_name=(value); end
    def deliver_later_queue_name?; end
    def delivery_job; end
    def delivery_job=(value); end
    def delivery_job?; end
  end

  module GeneratedInstanceMethods
    def deliver_later_queue_name; end
    def deliver_later_queue_name=(value); end
    def deliver_later_queue_name?; end
    def delivery_job; end
    def delivery_job=(value); end
    def delivery_job?; end
  end
end

# source://actionmailer//lib/action_mailer/railtie.rb#9
class ActionMailer::Railtie < ::Rails::Railtie; end

# = Action Mailer \Rescuable
#
# Provides
# {rescue_from}[rdoc-ref:ActiveSupport::Rescuable::ClassMethods#rescue_from]
# for mailers. Wraps mailer action processing, mail job processing, and mail
# delivery to handle configured errors.
#
# source://actionmailer//lib/action_mailer/rescuable.rb#10
module ActionMailer::Rescuable
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Rescuable

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Rescuable::ClassMethods
  mixes_in_class_methods ::ActionMailer::Rescuable::ClassMethods

  # source://actionmailer//lib/action_mailer/rescuable.rb#20
  def handle_exceptions; end

  private

  # source://actionmailer//lib/action_mailer/rescuable.rb#27
  def process(*_arg0, **_arg1, &_arg2); end

  module GeneratedClassMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end

  module GeneratedInstanceMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end
end

# source://actionmailer//lib/action_mailer/rescuable.rb#0
module ActionMailer::Rescuable::ClassMethods
  # source://actionmailer//lib/action_mailer/rescuable.rb#15
  def handle_exception(exception); end
end

# source://actionmailer//lib/action_mailer/test_case.rb#15
class ActionMailer::TestCase < ::ActiveSupport::TestCase
  include ::ActiveSupport::Testing::ConstantLookup
  include ::ActiveJob::TestHelper
  include ::ActionMailer::TestHelper
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::ActionMailer::TestCase::Behavior
  extend ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  extend ::ActionMailer::TestCase::Behavior::ClassMethods

  # source://actionmailer//lib/action_mailer/test_case.rb#41
  def _mailer_class; end

  # source://actionmailer//lib/action_mailer/test_case.rb#41
  def _mailer_class=(_arg0); end

  # source://actionmailer//lib/action_mailer/test_case.rb#41
  def _mailer_class?; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionmailer//lib/action_mailer/test_case.rb#41
    def _mailer_class; end

    # source://actionmailer//lib/action_mailer/test_case.rb#41
    def _mailer_class=(value); end

    # source://actionmailer//lib/action_mailer/test_case.rb#41
    def _mailer_class?; end
  end
end

# source://actionmailer//lib/action_mailer/test_case.rb#32
module ActionMailer::TestCase::Behavior
  include ::ActiveSupport::Testing::Assertions
  include ::ActiveJob::TestHelper
  include ::ActionMailer::TestHelper
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Testing::ConstantLookup

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  mixes_in_class_methods ::ActionMailer::TestCase::Behavior::ClassMethods

  # Reads the fixture file for the given mailer.
  #
  # This is useful when testing mailers by being able to write the body of
  # an email inside a fixture. See the testing guide for a concrete example:
  # https://guides.rubyonrails.org/testing.html#revenge-of-the-fixtures
  #
  # source://actionmailer//lib/action_mailer/test_case.rb#82
  def read_fixture(action); end

  private

  # source://actionmailer//lib/action_mailer/test_case.rb#115
  def charset; end

  # source://actionmailer//lib/action_mailer/test_case.rb#119
  def encode(subject); end

  # source://actionmailer//lib/action_mailer/test_case.rb#87
  def initialize_test_deliveries; end

  # source://actionmailer//lib/action_mailer/test_case.rb#104
  def restore_delivery_method; end

  # source://actionmailer//lib/action_mailer/test_case.rb#94
  def restore_test_deliveries; end

  # source://actionmailer//lib/action_mailer/test_case.rb#99
  def set_delivery_method(method); end

  # source://actionmailer//lib/action_mailer/test_case.rb#109
  def set_expected_mail; end

  module GeneratedClassMethods
    def _mailer_class; end
    def _mailer_class=(value); end
    def _mailer_class?; end
  end

  module GeneratedInstanceMethods
    def _mailer_class; end
    def _mailer_class=(value); end
    def _mailer_class?; end
  end
end

# source://actionmailer//lib/action_mailer/test_case.rb#48
module ActionMailer::TestCase::Behavior::ClassMethods
  # @raise [NonInferrableMailerError]
  #
  # source://actionmailer//lib/action_mailer/test_case.rb#68
  def determine_default_mailer(name); end

  # source://actionmailer//lib/action_mailer/test_case.rb#60
  def mailer_class; end

  # source://actionmailer//lib/action_mailer/test_case.rb#49
  def tests(mailer); end
end

# source://actionmailer//lib/action_mailer/test_case.rb#16
module ActionMailer::TestCase::ClearTestDeliveries
  extend ::ActiveSupport::Concern

  private

  # source://actionmailer//lib/action_mailer/test_case.rb#25
  def clear_test_deliveries; end
end

# Provides helper methods for testing Action Mailer, including #assert_emails
# and #assert_no_emails.
#
# source://actionmailer//lib/action_mailer/test_helper.rb#9
module ActionMailer::TestHelper
  include ::ActiveSupport::Testing::Assertions
  include ::ActiveJob::TestHelper

  # Asserts that the number of emails sent matches the given number.
  #
  #   def test_emails
  #     assert_emails 0
  #     ContactMailer.welcome.deliver_now
  #     assert_emails 1
  #     ContactMailer.welcome.deliver_now
  #     assert_emails 2
  #   end
  #
  # If a block is passed, that block should cause the specified number of
  # emails to be sent.
  #
  #   def test_emails_again
  #     assert_emails 1 do
  #       ContactMailer.welcome.deliver_now
  #     end
  #
  #     assert_emails 2 do
  #       ContactMailer.welcome.deliver_now
  #       ContactMailer.welcome.deliver_later
  #     end
  #   end
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#35
  def assert_emails(number, &block); end

  # Asserts that a specific email has been enqueued, optionally
  # matching arguments and/or params.
  #
  #   def test_email
  #     ContactMailer.welcome.deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome
  #   end
  #
  #   def test_email_with_parameters
  #     ContactMailer.with(greeting: "Hello").welcome.deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome, args: { greeting: "Hello" }
  #   end
  #
  #   def test_email_with_arguments
  #     ContactMailer.welcome("Hello", "Goodbye").deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome, args: ["Hello", "Goodbye"]
  #   end
  #
  #   def test_email_with_named_arguments
  #     ContactMailer.welcome(greeting: "Hello", farewell: "Goodbye").deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome, args: [{ greeting: "Hello", farewell: "Goodbye" }]
  #   end
  #
  #   def test_email_with_parameters_and_arguments
  #     ContactMailer.with(greeting: "Hello").welcome("Cheers", "Goodbye").deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome, params: { greeting: "Hello" }, args: ["Cheers", "Goodbye"]
  #   end
  #
  #   def test_email_with_parameters_and_named_arguments
  #     ContactMailer.with(greeting: "Hello").welcome(farewell: "Goodbye").deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome, params: { greeting: "Hello" }, args: [{farewell: "Goodbye"}]
  #   end
  #
  #   def test_email_with_parameterized_mailer
  #     ContactMailer.with(greeting: "Hello").welcome.deliver_later
  #     assert_enqueued_email_with ContactMailer.with(greeting: "Hello"), :welcome
  #   end
  #
  #   def test_email_with_matchers
  #     ContactMailer.with(greeting: "Hello").welcome("Cheers", "Goodbye").deliver_later
  #     assert_enqueued_email_with ContactMailer, :welcome,
  #       params: ->(params) { /hello/i.match?(params[:greeting]) },
  #       args: ->(args) { /cheers/i.match?(args[0]) }
  #   end
  #
  # If a block is passed, that block should cause the specified email
  # to be enqueued.
  #
  #   def test_email_in_block
  #     assert_enqueued_email_with ContactMailer, :welcome do
  #       ContactMailer.welcome.deliver_later
  #     end
  #   end
  #
  # If +args+ is provided as a Hash, a parameterized email is matched.
  #
  #   def test_parameterized_email
  #     assert_enqueued_email_with ContactMailer, :welcome,
  #       args: {email: 'user@example.com'} do
  #       ContactMailer.with(email: 'user@example.com').welcome.deliver_later
  #     end
  #   end
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#157
  def assert_enqueued_email_with(mailer, method, params: T.unsafe(nil), args: T.unsafe(nil), queue: T.unsafe(nil), &block); end

  # Asserts that the number of emails enqueued for later delivery matches
  # the given number.
  #
  #   def test_emails
  #     assert_enqueued_emails 0
  #     ContactMailer.welcome.deliver_later
  #     assert_enqueued_emails 1
  #     ContactMailer.welcome.deliver_later
  #     assert_enqueued_emails 2
  #   end
  #
  # If a block is passed, that block should cause the specified number of
  # emails to be enqueued.
  #
  #   def test_emails_again
  #     assert_enqueued_emails 1 do
  #       ContactMailer.welcome.deliver_later
  #     end
  #
  #     assert_enqueued_emails 2 do
  #       ContactMailer.welcome.deliver_later
  #       ContactMailer.welcome.deliver_later
  #     end
  #   end
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#91
  def assert_enqueued_emails(number, &block); end

  # Asserts that no emails have been sent.
  #
  #   def test_emails
  #     assert_no_emails
  #     ContactMailer.welcome.deliver_now
  #     assert_emails 1
  #   end
  #
  # If a block is passed, that block should not cause any emails to be sent.
  #
  #   def test_emails_again
  #     assert_no_emails do
  #       # No emails should be sent from this block
  #     end
  #   end
  #
  # Note: This assertion is simply a shortcut for:
  #
  #   assert_emails 0, &block
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#63
  def assert_no_emails(&block); end

  # Asserts that no emails are enqueued for later delivery.
  #
  #   def test_no_emails
  #     assert_no_enqueued_emails
  #     ContactMailer.welcome.deliver_later
  #     assert_enqueued_emails 1
  #   end
  #
  # If a block is provided, it should not cause any emails to be enqueued.
  #
  #   def test_no_emails
  #     assert_no_enqueued_emails do
  #       # No emails should be enqueued from this block
  #     end
  #   end
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#191
  def assert_no_enqueued_emails(&block); end

  # Returns any emails that are sent in the block.
  #
  #   def test_emails
  #     emails = capture_emails do
  #       ContactMailer.welcome.deliver_now
  #     end
  #     assert_equal "Hi there", emails.first.subject
  #
  #     emails = capture_emails do
  #       ContactMailer.welcome.deliver_now
  #       ContactMailer.welcome.deliver_later
  #     end
  #     assert_equal "Hi there", emails.first.subject
  #   end
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#249
  def capture_emails(&block); end

  # Delivers all enqueued emails. If a block is given, delivers all of the emails
  # that were enqueued throughout the duration of the block. If a block is
  # not given, delivers all the enqueued emails up to this point in the test.
  #
  #   def test_deliver_enqueued_emails
  #     deliver_enqueued_emails do
  #       ContactMailer.welcome.deliver_later
  #     end
  #
  #     assert_emails 1
  #   end
  #
  #   def test_deliver_enqueued_emails_without_block
  #     ContactMailer.welcome.deliver_later
  #
  #     deliver_enqueued_emails
  #
  #     assert_emails 1
  #   end
  #
  # If the +:queue+ option is specified,
  # then only the emails(s) enqueued to a specific queue will be performed.
  #
  #   def test_deliver_enqueued_emails_with_queue
  #     deliver_enqueued_emails queue: :external_mailers do
  #       CustomerMailer.deliver_later_queue_name = :external_mailers
  #       CustomerMailer.welcome.deliver_later # will be performed
  #       EmployeeMailer.deliver_later_queue_name = :internal_mailers
  #       EmployeeMailer.welcome.deliver_later # will not be performed
  #     end
  #
  #     assert_emails 1
  #   end
  #
  # If the +:at+ option is specified, then only delivers emails enqueued to deliver
  # immediately or before the given time.
  #
  # source://actionmailer//lib/action_mailer/test_helper.rb#231
  def deliver_enqueued_emails(queue: T.unsafe(nil), at: T.unsafe(nil), &block); end

  private

  # source://actionmailer//lib/action_mailer/test_helper.rb#258
  def delivery_job_filter(job); end
end

# source://actionmailer//lib/action_mailer/gem_version.rb#9
module ActionMailer::VERSION; end

# source://actionmailer//lib/action_mailer/gem_version.rb#10
ActionMailer::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://actionmailer//lib/action_mailer/gem_version.rb#11
ActionMailer::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://actionmailer//lib/action_mailer/gem_version.rb#13
ActionMailer::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://actionmailer//lib/action_mailer/gem_version.rb#15
ActionMailer::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://actionmailer//lib/action_mailer/gem_version.rb#12
ActionMailer::VERSION::TINY = T.let(T.unsafe(nil), Integer)
