# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `actionpack` gem.
# Please instead update this file by running `bin/tapioca gem actionpack`.


# :markup: markdown
#
# source://actionpack//lib/abstract_controller/deprecator.rb#5
module AbstractController
  extend ::ActiveSupport::Autoload

  class << self
    # source://actionpack//lib/abstract_controller/deprecator.rb#6
    def deprecator; end

    # source://actionpack//lib/abstract_controller.rb#27
    def eager_load!; end
  end
end

# Raised when a non-existing controller action is triggered.
#
# source://actionpack//lib/abstract_controller/base.rb#13
class AbstractController::ActionNotFound < ::StandardError
  include ::DidYouMean::Correctable

  # @return [ActionNotFound] a new instance of ActionNotFound
  #
  # source://actionpack//lib/abstract_controller/base.rb#16
  def initialize(message = T.unsafe(nil), controller = T.unsafe(nil), action = T.unsafe(nil)); end

  # source://actionpack//lib/abstract_controller/base.rb#14
  def action; end

  # source://actionpack//lib/abstract_controller/base.rb#14
  def controller; end

  # source://actionpack//lib/abstract_controller/base.rb#25
  def corrections; end
end

# source://actionpack//lib/abstract_controller/asset_paths.rb#6
module AbstractController::AssetPaths
  extend ::ActiveSupport::Concern
end

# # Abstract Controller Base
#
# AbstractController::Base is a low-level API. Nobody should be using it
# directly, and subclasses (like ActionController::Base) are expected to provide
# their own `render` method, since rendering means different things depending on
# the context.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://actionpack//lib/abstract_controller/base.rb#37
class AbstractController::Base
  include ::ActiveSupport::Configurable
  extend ::ActiveSupport::Configurable::ClassMethods
  extend ::ActiveSupport::DescendantsTracker

  # Delegates to the class's ::action_methods.
  #
  # source://actionpack//lib/abstract_controller/base.rb#172
  def action_methods; end

  # Returns the name of the action this controller is processing.
  #
  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def action_name; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def action_name=(_arg0); end

  # Returns true if a method for the action is available and can be dispatched,
  # false otherwise.
  #
  # Notice that `action_methods.include?("foo")` may return false and
  # `available_action?("foo")` returns true because this method considers actions
  # that are also available through other means, for example, implicit render
  # ones.
  #
  # #### Parameters
  # *   `action_name` - The name of an action to be tested
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/base.rb#187
  def available_action?(action_name); end

  # Delegates to the class's ::controller_path.
  #
  # source://actionpack//lib/abstract_controller/base.rb#167
  def controller_path; end

  # Returns the formats that can be processed by the controller.
  #
  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def formats; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def formats=(_arg0); end

  # source://actionpack//lib/abstract_controller/base.rb#204
  def inspect; end

  # Tests if a response body is set. Used to determine if the `process_action`
  # callback needs to be terminated in AbstractController::Callbacks.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/base.rb#193
  def performed?; end

  # Calls the action going through the entire Action Dispatch stack.
  #
  # The actual method that is called is determined by calling #method_for_action.
  # If no method can handle the action, then an AbstractController::ActionNotFound
  # error is raised.
  #
  # #### Returns
  # *   `self`
  #
  # source://actionpack//lib/abstract_controller/base.rb#154
  def process(action, *_arg1, **_arg2, &_arg3); end

  # Returns the body of the HTTP response sent by the controller.
  #
  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def response_body; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def response_body=(_arg0); end

  # Actually call the method associated with the action. Override this method if
  # you wish to change how action methods are called, not to add additional
  # behavior around it. For example, you would override #send_action if you want
  # to inject arguments into the method.
  def send_action(*_arg0); end

  private

  # Takes an action name and returns the name of the method that will handle the
  # action.
  #
  # It checks if the action name is valid and returns false otherwise.
  #
  # See method_for_action for more information.
  #
  # #### Parameters
  # *   `action_name` - An action name to find a method name for
  #
  #
  # #### Returns
  # *   `string` - The name of the method that handles the action
  # *   false           - No valid method name could be found.
  #
  # Raise `AbstractController::ActionNotFound`.
  #
  # source://actionpack//lib/abstract_controller/base.rb#258
  def _find_action_name(action_name); end

  # If the action name was not found, but a method called "action_missing" was
  # found, #method_for_action will return "_handle_action_missing". This method
  # calls #action_missing with the current action name.
  #
  # source://actionpack//lib/abstract_controller/base.rb#238
  def _handle_action_missing(*args); end

  # Checks if the action name is valid and returns false otherwise.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/base.rb#295
  def _valid_action_name?(action_name); end

  # Returns true if the name can be considered an action because it has a method
  # defined in the controller.
  #
  # #### Parameters
  # *   `name` - The name of an action to be tested
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/base.rb#215
  def action_method?(name); end

  # Takes an action name and returns the name of the method that will handle the
  # action. In normal cases, this method returns the same name as it receives. By
  # default, if #method_for_action receives a name that is not an action, it will
  # look for an #action_missing method and return "_handle_action_missing" if one
  # is found.
  #
  # Subclasses may override this method to add additional conditions that should
  # be considered an action. For instance, an HTTP controller with a template
  # matching the action name is considered to exist.
  #
  # If you override this method to handle additional cases, you may also provide a
  # method (like `_handle_method_missing`) to handle the case.
  #
  # If none of these conditions are true, and `method_for_action` returns `nil`,
  # an `AbstractController::ActionNotFound` exception will be raised.
  #
  # #### Parameters
  # *   `action_name` - An action name to find a method name for
  #
  #
  # #### Returns
  # *   `string` - The name of the method that handles the action
  # *   `nil`    - No method name could be found.
  #
  # source://actionpack//lib/abstract_controller/base.rb#286
  def method_for_action(action_name); end

  # Call the action. Override this in a subclass to modify the behavior around
  # processing an action. This, and not #process, is the intended way to override
  # action dispatching.
  #
  # Notice that the first argument is the method to be dispatched which is **not**
  # necessarily the same as the action name.
  #
  # source://actionpack//lib/abstract_controller/base.rb#225
  def process_action(*_arg0, **_arg1, &_arg2); end

  class << self
    # Returns the value of attribute abstract.
    #
    # source://actionpack//lib/abstract_controller/base.rb#54
    def abstract; end

    # Define a controller as abstract. See internal_methods for more details.
    #
    # source://actionpack//lib/abstract_controller/base.rb#58
    def abstract!; end

    # Returns the value of attribute abstract.
    #
    # source://actionpack//lib/abstract_controller/base.rb#54
    def abstract?; end

    # A list of method names that should be considered actions. This includes all
    # public instance methods on a controller, less any internal methods (see
    # internal_methods), adding back in any methods that are internal, but still
    # exist on the class itself.
    #
    # #### Returns
    # *   `Set` - A set of all methods that should be considered actions.
    #
    # source://actionpack//lib/abstract_controller/base.rb#97
    def action_methods; end

    # action_methods are cached and there is sometimes a need to refresh them.
    # ::clear_action_methods! allows you to do that, so next time you run
    # action_methods, they will be recalculated.
    #
    # source://actionpack//lib/abstract_controller/base.rb#112
    def clear_action_methods!; end

    # Returns the full controller name, underscored, without the ending Controller.
    #
    #     class MyApp::MyPostsController < AbstractController::Base
    #
    #     end
    #
    #     MyApp::MyPostsController.controller_path # => "my_app/my_posts"
    #
    # #### Returns
    # *   `String`
    #
    # source://actionpack//lib/abstract_controller/base.rb#127
    def controller_path; end

    # source://actionpack//lib/abstract_controller/base.rb#137
    def eager_load!; end

    # source://actionpack//lib/abstract_controller/base.rb#62
    def inherited(klass); end

    # A list of all internal methods for a controller. This finds the first abstract
    # superclass of a controller, and gets a list of all public instance methods on
    # that abstract class. Public instance methods of a controller would normally be
    # considered action methods, so methods declared on abstract classes are being
    # removed. (ActionController::Metal and ActionController::Base are defined as
    # abstract)
    #
    # source://actionpack//lib/abstract_controller/base.rb#77
    def internal_methods; end

    # Refresh the cached action_methods when a new action_method is added.
    #
    # source://actionpack//lib/abstract_controller/base.rb#132
    def method_added(name); end

    # Returns true if the given controller is capable of rendering a path. A
    # subclass of `AbstractController::Base` may return false. An Email controller
    # for example does not support paths, only full URLs.
    #
    # @return [Boolean]
    #
    # source://actionpack//lib/abstract_controller/base.rb#200
    def supports_path?; end
  end
end

# source://actionpack//lib/abstract_controller/caching.rb#6
module AbstractController::Caching
  include ::AbstractController::Caching::ConfigMethods
  extend ::ActiveSupport::Concern
  extend ::ActiveSupport::Autoload
  include GeneratedInstanceMethods
  include ::AbstractController::Caching::Fragments

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Caching::Fragments::ClassMethods
  mixes_in_class_methods ::AbstractController::Caching::ClassMethods
  mixes_in_class_methods ::AbstractController::Caching::ConfigMethods

  # source://actionpack//lib/abstract_controller/caching.rb#54
  def view_cache_dependencies; end

  private

  # Convenience accessor.
  #
  # source://actionpack//lib/abstract_controller/caching.rb#60
  def cache(key, options = T.unsafe(nil), &block); end

  module GeneratedClassMethods
    def _view_cache_dependencies; end
    def _view_cache_dependencies=(value); end
    def _view_cache_dependencies?; end
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end

  module GeneratedInstanceMethods
    def _view_cache_dependencies; end
    def _view_cache_dependencies=(value); end
    def _view_cache_dependencies?; end
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end
end

# source://actionpack//lib/abstract_controller/caching.rb#48
module AbstractController::Caching::ClassMethods
  # source://actionpack//lib/abstract_controller/caching.rb#49
  def view_cache_dependency(&dependency); end
end

# source://actionpack//lib/abstract_controller/caching.rb#14
module AbstractController::Caching::ConfigMethods
  # source://actionpack//lib/abstract_controller/caching.rb#15
  def cache_store; end

  # source://actionpack//lib/abstract_controller/caching.rb#19
  def cache_store=(store); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/caching.rb#24
  def cache_configured?; end
end

# # Abstract Controller Caching Fragments
#
# Fragment caching is used for caching various blocks within views without
# caching the entire action as a whole. This is useful when certain elements of
# an action change frequently or depend on complicated state while other parts
# rarely change or can be shared amongst multiple parties. The caching is done
# using the `cache` helper available in the Action View. See
# ActionView::Helpers::CacheHelper for more information.
#
# While it's strongly recommended that you use key-based cache expiration (see
# links in CacheHelper for more information), it is also possible to manually
# expire caches. For example:
#
#     expire_fragment('name_of_cache')
#
# source://actionpack//lib/abstract_controller/caching/fragments.rb#21
module AbstractController::Caching::Fragments
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Caching::Fragments::ClassMethods

  # Given a key (as described in `expire_fragment`), returns a key array suitable
  # for use in reading, writing, or expiring a cached fragment. All keys begin
  # with `:views`, followed by `ENV["RAILS_CACHE_ID"]` or
  # `ENV["RAILS_APP_VERSION"]` if set, followed by any controller-wide key prefix
  # values, ending with the specified `key` value.
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#68
  def combined_fragment_cache_key(key); end

  # Removes fragments from the cache.
  #
  # `key` can take one of three forms:
  #
  # *   String - This would normally take the form of a path, like
  #     `pages/45/notes`.
  # *   Hash - Treated as an implicit call to `url_for`, like `{ controller:
  #     'pages', action: 'notes', id: 45}`
  # *   Regexp - Will remove any fragment that matches, so `%r{pages/\d*/notes}`
  #     might remove all notes. Make sure you don't use anchors in the regex (`^`
  #     or `$`) because the actual filename matched looks like
  #     `./cache/filename/path.cache`. Note: Regexp expiration is only supported
  #     on caches that can iterate over all keys (unlike memcached).
  #
  #
  # `options` is passed through to the cache store's `delete` method (or
  # `delete_matched`, for Regexp keys).
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#131
  def expire_fragment(key, options = T.unsafe(nil)); end

  # Check if a cached fragment from the location signified by `key` exists (see
  # `expire_fragment` for acceptable formats).
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#105
  def fragment_exist?(key, options = T.unsafe(nil)); end

  # source://actionpack//lib/abstract_controller/caching/fragments.rb#144
  def instrument_fragment_cache(name, key, &block); end

  # Reads a cached fragment from the location signified by `key` (see
  # `expire_fragment` for acceptable formats).
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#93
  def read_fragment(key, options = T.unsafe(nil)); end

  # Writes `content` to the location signified by `key` (see `expire_fragment` for
  # acceptable formats).
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#80
  def write_fragment(key, content, options = T.unsafe(nil)); end

  module GeneratedClassMethods
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end

  module GeneratedInstanceMethods
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end
end

# source://actionpack//lib/abstract_controller/caching/fragments.rb#38
module AbstractController::Caching::Fragments::ClassMethods
  # Allows you to specify controller-wide key prefixes for cache fragments. Pass
  # either a constant `value`, or a block which computes a value each time a cache
  # key is generated.
  #
  # For example, you may want to prefix all fragment cache keys with a global
  # version identifier, so you can easily invalidate all caches.
  #
  #     class ApplicationController
  #       fragment_cache_key "v1"
  #     end
  #
  # When it's time to invalidate all fragments, simply change the string constant.
  # Or, progressively roll out the cache invalidation using a computed value:
  #
  #     class ApplicationController
  #       fragment_cache_key do
  #         @account.id.odd? ? "v1" : "v2"
  #       end
  #     end
  #
  # source://actionpack//lib/abstract_controller/caching/fragments.rb#58
  def fragment_cache_key(value = T.unsafe(nil), &key); end
end

# # Abstract Controller Callbacks
#
# Abstract Controller provides hooks during the life cycle of a controller
# action. Callbacks allow you to trigger logic during this cycle. Available
# callbacks are:
#
# *   `after_action`
# *   `append_after_action`
# *   `append_around_action`
# *   `append_before_action`
# *   `around_action`
# *   `before_action`
# *   `prepend_after_action`
# *   `prepend_around_action`
# *   `prepend_before_action`
# *   `skip_after_action`
# *   `skip_around_action`
# *   `skip_before_action`
#
# source://actionpack//lib/abstract_controller/callbacks.rb#24
module AbstractController::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::AbstractController::Callbacks::ClassMethods

  private

  # Override `AbstractController::Base#process_action` to run the `process_action`
  # callbacks around the normal behavior.
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#259
  def process_action(*_arg0, **_arg1, &_arg2); end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://actionpack//lib/abstract_controller/callbacks.rb#39
class AbstractController::Callbacks::ActionFilter
  # @return [ActionFilter] a new instance of ActionFilter
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#40
  def initialize(filters, conditional_key, actions); end

  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#46
  def after(controller); end

  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#46
  def around(controller); end

  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#46
  def before(controller); end

  # @return [Boolean]
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#46
  def match?(controller); end
end

# source://actionpack//lib/abstract_controller/callbacks.rb#74
module AbstractController::Callbacks::ClassMethods
  # Take callback names and an optional callback proc, normalize them, then call
  # the block with each callback. This allows us to abstract the normalization
  # across several methods that use it.
  #
  # #### Parameters
  # *   `callbacks` - An array of callbacks, with an optional options hash as the
  #     last parameter.
  # *   `block`    - A proc that should be added to the callbacks.
  #
  #
  # #### Block Parameters
  # *   `name`     - The callback to be added.
  # *   `options`  - A hash of options to be used when adding the callback.
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#120
  def _insert_callbacks(callbacks, block = T.unsafe(nil)); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#98
  def _normalize_callback_option(options, from, to); end

  # If `:only` or `:except` are used, convert the options into the `:if` and
  # `:unless` options of ActiveSupport::Callbacks.
  #
  # The basic idea is that `:only => :index` gets converted to `:if => proc {|c|
  # c.action_name == "index" }`.
  #
  # Note that `:only` has priority over `:if` in case they are used together.
  #
  #     only: :index, if: -> { true } # the :if option will be ignored.
  #
  # Note that `:if` has priority over `:except` in case they are used together.
  #
  #     except: :index, if: -> { true } # the :except option will be ignored.
  #
  # #### Options
  # *   `only`   - The callback should be run only for this action.
  # *   `except`  - The callback should be run for all actions except this action.
  #
  # source://actionpack//lib/abstract_controller/callbacks.rb#93
  def _normalize_callback_options(options); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def after_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def append_after_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def append_around_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def append_before_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def around_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#231
  def before_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#237
  def prepend_after_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#237
  def prepend_around_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#237
  def prepend_before_action(*names, &blk); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#245
  def skip_after_action(*names); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#245
  def skip_around_action(*names); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#245
  def skip_before_action(*names); end
end

# source://actionpack//lib/abstract_controller/collector.rb#8
module AbstractController::Collector
  # source://actionpack//lib/abstract_controller/collector.rb#12
  def atom(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def bmp(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def css(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def csv(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def gif(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def gzip(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def html(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def ics(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def jpeg(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def js(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def json(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def m4a(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def mp3(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def mp4(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def mpeg(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def multipart_form(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def ogg(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def otf(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def pdf(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def png(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def rss(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def svg(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def text(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def tiff(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def ttf(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def url_encoded_form(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def vcf(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def vtt(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def webm(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def webp(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def woff(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def woff2(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def xml(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def yaml(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/collector.rb#12
  def zip(*_arg0, **_arg1, &_arg2); end

  private

  # source://actionpack//lib/abstract_controller/collector.rb#27
  def method_missing(symbol, *_arg1, **_arg2, &_arg3); end

  class << self
    # source://actionpack//lib/abstract_controller/collector.rb#9
    def generate_method_for_mime(mime); end
  end
end

# source://actionpack//lib/abstract_controller/rendering.rb#11
class AbstractController::DoubleRenderError < ::AbstractController::Error
  # @return [DoubleRenderError] a new instance of DoubleRenderError
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#14
  def initialize(message = T.unsafe(nil)); end
end

# source://actionpack//lib/abstract_controller/rendering.rb#12
AbstractController::DoubleRenderError::DEFAULT_MESSAGE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/abstract_controller/error.rb#6
class AbstractController::Error < ::StandardError; end

# source://actionpack//lib/abstract_controller/helpers.rb#9
module AbstractController::Helpers
  extend ::ActiveSupport::Concern
  extend ::AbstractController::Helpers::Resolution
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Helpers::ClassMethods

  # source://actionpack//lib/abstract_controller/helpers.rb#28
  def _helpers; end

  module GeneratedClassMethods
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end

  module GeneratedInstanceMethods
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end
end

# source://actionpack//lib/abstract_controller/helpers.rb#64
module AbstractController::Helpers::ClassMethods
  include ::AbstractController::Helpers::Resolution

  # Sets the attribute _helpers
  #
  # @param value the value to set the attribute _helpers to.
  #
  # source://actionpack//lib/abstract_controller/helpers.rb#76
  def _helpers=(_arg0); end

  # source://actionpack//lib/abstract_controller/helpers.rb#216
  def _helpers_for_modification; end

  # Clears up all existing helpers in this class, only keeping the helper with the
  # same name as this class.
  #
  # source://actionpack//lib/abstract_controller/helpers.rb#207
  def clear_helpers; end

  # Includes the given modules in the template class.
  #
  # Modules can be specified in different ways. All of the following calls include
  # `FooHelper`:
  #
  #     # Module, recommended.
  #     helper FooHelper
  #
  #     # String/symbol without the "helper" suffix, camel or snake case.
  #     helper "Foo"
  #     helper :Foo
  #     helper "foo"
  #     helper :foo
  #
  # The last two assume that `"foo".camelize` returns "Foo".
  #
  # When strings or symbols are passed, the method finds the actual module object
  # using String#constantize. Therefore, if the module has not been yet loaded, it
  # has to be autoloadable, which is normally the case.
  #
  # Namespaces are supported. The following calls include `Foo::BarHelper`:
  #
  #     # Module, recommended.
  #     helper Foo::BarHelper
  #
  #     # String/symbol without the "helper" suffix, camel or snake case.
  #     helper "Foo::Bar"
  #     helper :"Foo::Bar"
  #     helper "foo/bar"
  #     helper :"foo/bar"
  #
  # The last two assume that `"foo/bar".camelize` returns "Foo::Bar".
  #
  # The method accepts a block too. If present, the block is evaluated in the
  # context of the controller helper module. This simple call makes the `wadus`
  # method available in templates of the enclosing controller:
  #
  #     helper do
  #       def wadus
  #         "wadus"
  #       end
  #     end
  #
  # Furthermore, all the above styles can be mixed together:
  #
  #     helper FooHelper, "woo", "bar/baz" do
  #       def wadus
  #         "wadus"
  #       end
  #     end
  #
  # source://actionpack//lib/abstract_controller/helpers.rb#196
  def helper(*args, &block); end

  # Declare a controller method as a helper. For example, the following
  # makes the `current_user` and `logged_in?` controller methods available
  # to the view:
  #     class ApplicationController < ActionController::Base
  #       helper_method :current_user, :logged_in?
  #
  #       private
  #         def current_user
  #           @current_user ||= User.find_by(id: session[:user])
  #         end
  #
  #         def logged_in?
  #           current_user != nil
  #         end
  #     end
  #
  # In a view:
  #     <% if logged_in? -%>Welcome, <%= current_user.name %><% end -%>
  #
  # #### Parameters
  # *   `method[, method]` - A name or names of a method on the controller to be
  #     made available on the view.
  #
  # source://actionpack//lib/abstract_controller/helpers.rb#126
  def helper_method(*methods); end

  # When a class is inherited, wrap its helper module in a new module. This
  # ensures that the parent class's module can be changed independently of the
  # child class's.
  #
  # source://actionpack//lib/abstract_controller/helpers.rb#68
  def inherited(klass); end

  private

  # source://actionpack//lib/abstract_controller/helpers.rb#235
  def default_helper_module!; end

  # source://actionpack//lib/abstract_controller/helpers.rb#224
  def define_helpers_module(klass, helpers = T.unsafe(nil)); end
end

# source://actionpack//lib/abstract_controller/helpers.rb#32
module AbstractController::Helpers::Resolution
  # source://actionpack//lib/abstract_controller/helpers.rb#48
  def all_helpers_from_path(path); end

  # source://actionpack//lib/abstract_controller/helpers.rb#57
  def helper_modules_from_paths(paths); end

  # source://actionpack//lib/abstract_controller/helpers.rb#33
  def modules_for_helpers(modules_or_helper_prefixes); end
end

# source://actionpack//lib/abstract_controller/logger.rb#8
module AbstractController::Logger
  extend ::ActiveSupport::Concern
  include ::ActiveSupport::Benchmarkable
end

# source://actionpack//lib/abstract_controller/railties/routes_helpers.rb#8
module AbstractController::Railties; end

# source://actionpack//lib/abstract_controller/railties/routes_helpers.rb#9
module AbstractController::Railties::RoutesHelpers
  class << self
    # source://actionpack//lib/abstract_controller/railties/routes_helpers.rb#10
    def with(routes, include_path_helpers = T.unsafe(nil)); end
  end
end

# source://actionpack//lib/abstract_controller/rendering.rb#19
module AbstractController::Rendering
  extend ::ActiveSupport::Concern
  include ::ActionView::ViewPaths

  mixes_in_class_methods ::ActionView::ViewPaths::ClassMethods

  # Normalizes arguments and options, and then delegates to render_to_body and
  # sticks the result in `self.response_body`.
  #
  # Supported options depend on the underlying `render_to_body` implementation.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#27
  def render(*args, &block); end

  # Performs the actual template rendering.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#51
  def render_to_body(options = T.unsafe(nil)); end

  # Similar to #render, but only returns the rendered template as a string,
  # instead of setting `self.response_body`.
  #
  # If a component extends the semantics of `response_body` (as ActionController
  # extends it to be anything that responds to the method each), this method needs
  # to be overridden in order to still return a string.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#45
  def render_to_string(*args, &block); end

  # Returns `Content-Type` of rendered content.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#55
  def rendered_format; end

  # This method should return a hash with assigns. You can overwrite this
  # configuration per controller.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#63
  def view_assigns; end

  private

  # Normalize args by converting `render "foo"` to `render action: "foo"` and
  # `render "foo/bar"` to `render file: "foo/bar"`.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#74
  def _normalize_args(action = T.unsafe(nil), options = T.unsafe(nil)); end

  # Normalize options.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#89
  def _normalize_options(options); end

  # Normalize args and options.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#115
  def _normalize_render(*args, &block); end

  # Process the rendered format.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#99
  def _process_format(format); end

  # Process extra options.
  #
  # source://actionpack//lib/abstract_controller/rendering.rb#94
  def _process_options(options); end

  # source://actionpack//lib/abstract_controller/rendering.rb#102
  def _process_variant(options); end

  # source://actionpack//lib/abstract_controller/rendering.rb#122
  def _protected_ivars; end

  # source://actionpack//lib/abstract_controller/rendering.rb#105
  def _set_html_content_type; end

  # source://actionpack//lib/abstract_controller/rendering.rb#111
  def _set_rendered_content_type(format); end

  # source://actionpack//lib/abstract_controller/rendering.rb#108
  def _set_vary_header; end
end

# source://actionpack//lib/abstract_controller/rendering.rb#59
AbstractController::Rendering::DEFAULT_PROTECTED_INSTANCE_VARIABLES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/abstract_controller/translation.rb#8
module AbstractController::Translation
  # Delegates to `I18n.localize`.
  #
  # source://actionpack//lib/abstract_controller/translation.rb#37
  def l(object, **options); end

  # Delegates to `I18n.localize`.
  #
  # source://actionpack//lib/abstract_controller/translation.rb#37
  def localize(object, **options); end

  # Delegates to `I18n.translate`.
  #
  # When the given key starts with a period, it will be scoped by the current
  # controller and action. So if you call `translate(".foo")` from
  # `PeopleController#index`, it will convert the call to
  # `I18n.translate("people.index.foo")`. This makes it less repetitive to
  # translate many keys within the same controller / action and gives you a simple
  # framework for scoping them consistently.
  #
  # source://actionpack//lib/abstract_controller/translation.rb#17
  def t(key, **options); end

  # Delegates to `I18n.translate`.
  #
  # When the given key starts with a period, it will be scoped by the current
  # controller and action. So if you call `translate(".foo")` from
  # `PeopleController#index`, it will convert the call to
  # `I18n.translate("people.index.foo")`. This makes it less repetitive to
  # translate many keys within the same controller / action and gives you a simple
  # framework for scoping them consistently.
  #
  # source://actionpack//lib/abstract_controller/translation.rb#17
  def translate(key, **options); end
end

# # URL For
#
# Includes `url_for` into the host class (e.g. an abstract controller or
# mailer). The class has to provide a `RouteSet` by implementing the `_routes`
# methods. Otherwise, an exception will be raised.
#
# Note that this module is completely decoupled from HTTP - the only requirement
# is a valid `_routes` implementation.
#
# source://actionpack//lib/abstract_controller/url_for.rb#14
module AbstractController::UrlFor
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionDispatch::Routing::UrlFor

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::UrlFor::ClassMethods

  # source://actionpack//lib/abstract_controller/url_for.rb#18
  def _routes; end

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

# source://actionpack//lib/abstract_controller/url_for.rb#23
module AbstractController::UrlFor::ClassMethods
  # source://actionpack//lib/abstract_controller/url_for.rb#24
  def _routes; end

  # source://actionpack//lib/abstract_controller/url_for.rb#28
  def action_methods; end
end

# # Action Controller
#
# Action Controller is a module of Action Pack.
#
# Action Controller provides a base controller class that can be subclassed to
# implement filters and actions to handle requests. The result of an action is
# typically content generated from views.
#
# source://actionpack//lib/action_controller/deprecator.rb#5
module ActionController
  extend ::ActiveSupport::Autoload

  class << self
    # See Renderers.add
    #
    # source://actionpack//lib/action_controller/metal/renderers.rb#9
    def add_renderer(key, &block); end

    # source://actionpack//lib/action_controller/deprecator.rb#6
    def deprecator; end

    # See Renderers.remove
    #
    # source://actionpack//lib/action_controller/metal/renderers.rb#14
    def remove_renderer(key); end
  end
end

# # Action Controller API
#
# API Controller is a lightweight version of ActionController::Base, created for
# applications that don't require all functionalities that a complete Rails
# controller provides, allowing you to create controllers with just the features
# that you need for API only applications.
#
# An API Controller is different from a normal controller in the sense that by
# default it doesn't include a number of features that are usually required by
# browser access only: layouts and templates rendering, flash, assets, and so
# on. This makes the entire controller stack thinner, suitable for API
# applications. It doesn't mean you won't have such features if you need them:
# they're all available for you to include in your application, they're just not
# part of the default API controller stack.
#
# Normally, `ApplicationController` is the only controller that inherits from
# `ActionController::API`. All other controllers in turn inherit from
# `ApplicationController`.
#
# A sample controller could look like this:
#
#     class PostsController < ApplicationController
#       def index
#         posts = Post.all
#         render json: posts
#       end
#     end
#
# Request, response, and parameters objects all work the exact same way as
# ActionController::Base.
#
# ## Renders
#
# The default API Controller stack includes all renderers, which means you can
# use `render :json` and siblings freely in your controllers. Keep in mind that
# templates are not going to be rendered, so you need to ensure your controller
# is calling either `render` or `redirect_to` in all actions, otherwise it will
# return `204 No Content`.
#
#     def show
#       post = Post.find(params[:id])
#       render json: post
#     end
#
# ## Redirects
#
# Redirects are used to move from one action to another. You can use the
# `redirect_to` method in your controllers in the same way as in
# ActionController::Base. For example:
#
#     def create
#       redirect_to root_url and return if not_authorized?
#       # do stuff here
#     end
#
# ## Adding New Behavior
#
# In some scenarios you may want to add back some functionality provided by
# ActionController::Base that is not present by default in
# `ActionController::API`, for instance `MimeResponds`. This module gives you
# the `respond_to` method. Adding it is quite simple, you just need to include
# the module in a specific controller or in `ApplicationController` in case you
# want it available in your entire application:
#
#     class ApplicationController < ActionController::API
#       include ActionController::MimeResponds
#     end
#
#     class PostsController < ApplicationController
#       def index
#         posts = Post.all
#
#         respond_to do |format|
#           format.json { render json: posts }
#           format.xml  { render xml: posts }
#         end
#       end
#     end
#
# Make sure to check the modules included in ActionController::Base if you want
# to use any other functionality that is not provided by `ActionController::API`
# out of the box.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://actionpack//lib/action_controller/api.rb#92
class ActionController::API < ::ActionController::Metal
  include ::ActionView::ViewPaths
  include ::AbstractController::Rendering
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor
  include ::AbstractController::UrlFor
  include ::ActionController::UrlFor
  include ::AbstractController::Logger
  include ::ActiveSupport::Benchmarkable
  include ::ActionController::Redirecting
  include ::ActionController::ApiRendering
  include ::ActionController::Rendering
  include ::ActionController::Renderers
  include ::ActionController::Renderers::All
  include ::ActionController::Head
  include ::ActionController::ConditionalGet
  include ::ActionController::BasicImplicitRender
  include ::ActionController::StrongParameters
  include ::ActionController::RateLimiting
  include ::ActionController::DataStreaming
  include ::ActionController::DefaultHeaders
  include ::ActionController::Logging
  include ::ActiveSupport::Callbacks
  include ::AbstractController::Callbacks
  include ::ActiveSupport::Rescuable
  include ::ActionController::Rescue
  include ::ActionController::Instrumentation
  include ::ActionController::ParamsWrapper
  extend ::ActionView::ViewPaths::ClassMethods
  extend ::AbstractController::UrlFor::ClassMethods
  extend ::ActionController::Rendering::ClassMethods
  extend ::ActionController::Renderers::ClassMethods
  extend ::ActionController::ConditionalGet::ClassMethods
  extend ::ActionController::RateLimiting::ClassMethods
  extend ::ActionController::DefaultHeaders::ClassMethods
  extend ::ActionController::Logging::ClassMethods
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::AbstractController::Callbacks::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods
  extend ::ActionController::Instrumentation::ClassMethods
  extend ::ActionController::ParamsWrapper::ClassMethods

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _process_action_callbacks; end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers; end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers=(_arg0); end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_process_action_callbacks(&block); end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options; end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options=(_arg0); end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options?; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options?; end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers; end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers=(_arg0); end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def logger; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def logger=(value); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions; end

  # source://actionpack//lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions=(val); end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#17
  def raise_on_open_redirects; end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#17
  def raise_on_open_redirects=(val); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers; end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers?; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _process_action_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _process_action_callbacks=(value); end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers; end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers=(value); end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers?; end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options; end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options=(value); end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options?; end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options; end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options=(value); end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options?; end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers; end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers=(value); end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def logger; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def logger=(value); end

    # source://actionpack//lib/action_controller/metal.rb#288
    def middleware_stack; end

    # source://actionpack//lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions; end

    # source://actionpack//lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions=(val); end

    # source://actionpack//lib/action_controller/metal/redirecting.rb#17
    def raise_on_open_redirects; end

    # source://actionpack//lib/action_controller/metal/redirecting.rb#17
    def raise_on_open_redirects=(val); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers?; end

    # Shortcut helper that returns all the ActionController::API modules except the
    # ones passed as arguments:
    #
    #     class MyAPIBaseController < ActionController::Metal
    #       ActionController::API.without_modules(:UrlFor).each do |left|
    #         include left
    #       end
    #     end
    #
    # This gives better control over what you want to exclude and makes it easier to
    # create an API controller class, instead of listing the modules required
    # manually.
    #
    # source://actionpack//lib/action_controller/api.rb#107
    def without_modules(*modules); end
  end
end

# source://actionpack//lib/action_controller/api.rb#115
ActionController::API::MODULES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/metal/exceptions.rb#6
class ActionController::ActionControllerError < ::StandardError; end

# source://actionpack//lib/action_controller/metal/allow_browser.rb#6
module ActionController::AllowBrowser
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::AllowBrowser::ClassMethods

  private

  # source://actionpack//lib/action_controller/metal/allow_browser.rb#53
  def allow_browser(versions:, block:); end
end

# source://actionpack//lib/action_controller/metal/allow_browser.rb#63
class ActionController::AllowBrowser::BrowserBlocker
  # @return [BrowserBlocker] a new instance of BrowserBlocker
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#70
  def initialize(request, versions:); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#74
  def blocked?; end

  # Returns the value of attribute request.
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#68
  def request; end

  # Returns the value of attribute versions.
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#68
  def versions; end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#95
  def bot?; end

  # source://actionpack//lib/action_controller/metal/allow_browser.rb#111
  def expanded_versions; end

  # source://actionpack//lib/action_controller/metal/allow_browser.rb#107
  def minimum_browser_version_for_browser; end

  # source://actionpack//lib/action_controller/metal/allow_browser.rb#115
  def normalized_browser_name; end

  # source://actionpack//lib/action_controller/metal/allow_browser.rb#79
  def parsed_user_agent; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#87
  def unsupported_browser?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#83
  def user_agent_version_reported?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#99
  def version_below_minimum_required?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#91
  def version_guarded_browser?; end
end

# source://actionpack//lib/action_controller/metal/allow_browser.rb#64
ActionController::AllowBrowser::BrowserBlocker::SETS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/metal/allow_browser.rb#9
module ActionController::AllowBrowser::ClassMethods
  # Specify the browser versions that will be allowed to access all actions (or
  # some, as limited by `only:` or `except:`). Only browsers matched in the hash
  # or named set passed to `versions:` will be blocked if they're below the
  # versions specified. This means that all other browsers, as well as agents that
  # aren't reporting a user-agent header, will be allowed access.
  #
  # A browser that's blocked will by default be served the file in
  # public/406-unsupported-browser.html with a HTTP status code of "406 Not
  # Acceptable".
  #
  # In addition to specifically named browser versions, you can also pass
  # `:modern` as the set to restrict support to browsers natively supporting webp
  # images, web push, badges, import maps, CSS nesting, and CSS :has. This
  # includes Safari 17.2+, Chrome 120+, Firefox 121+, Opera 106+.
  #
  # You can use https://caniuse.com to check for browser versions supporting the
  # features you use.
  #
  # You can use `ActiveSupport::Notifications` to subscribe to events of browsers
  # being blocked using the `browser_block.action_controller` event name.
  #
  # Examples:
  #
  #     class ApplicationController < ActionController::Base
  #       # Allow only browsers natively supporting webp images, web push, badges, import maps, CSS nesting, and CSS :has
  #       allow_browser versions: :modern
  #     end
  #
  #     class ApplicationController < ActionController::Base
  #       # All versions of Chrome and Opera will be allowed, but no versions of "internet explorer" (ie). Safari needs to be 16.4+ and Firefox 121+.
  #       allow_browser versions: { safari: 16.4, firefox: 121, ie: false }
  #     end
  #
  #     class MessagesController < ApplicationController
  #       # In addition to the browsers blocked by ApplicationController, also block Opera below 104 and Chrome below 119 for the show action.
  #       allow_browser versions: { opera: 104, chrome: 119 }, only: :show
  #     end
  #
  # source://actionpack//lib/action_controller/metal/allow_browser.rb#47
  def allow_browser(versions:, block: T.unsafe(nil), **options); end
end

# source://actionpack//lib/action_controller/api/api_rendering.rb#6
module ActionController::ApiRendering
  extend ::ActiveSupport::Concern
  include ::ActionController::Rendering

  mixes_in_class_methods ::ActionController::Rendering::ClassMethods

  # source://actionpack//lib/action_controller/api/api_rendering.rb#13
  def render_to_body(options = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#9
class ActionController::BadRequest < ::ActionController::ActionControllerError
  # @return [BadRequest] a new instance of BadRequest
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#10
  def initialize(msg = T.unsafe(nil)); end
end

# # Action Controller Base
#
# Action Controllers are the core of a web request in Rails. They are made up of
# one or more actions that are executed on request and then either it renders a
# template or redirects to another action. An action is defined as a public
# method on the controller, which will automatically be made accessible to the
# web-server through Rails Routes.
#
# By default, only the ApplicationController in a Rails application inherits
# from `ActionController::Base`. All other controllers inherit from
# ApplicationController. This gives you one class to configure things such as
# request forgery protection and filtering of sensitive request parameters.
#
# A sample controller could look like this:
#
#     class PostsController < ApplicationController
#       def index
#         @posts = Post.all
#       end
#
#       def create
#         @post = Post.create params[:post]
#         redirect_to posts_path
#       end
#     end
#
# Actions, by default, render a template in the `app/views` directory
# corresponding to the name of the controller and action after executing code in
# the action. For example, the `index` action of the PostsController would
# render the template `app/views/posts/index.html.erb` by default after
# populating the `@posts` instance variable.
#
# Unlike index, the create action will not render a template. After performing
# its main purpose (creating a new post), it initiates a redirect instead. This
# redirect works by returning an external `302 Moved` HTTP response that takes
# the user to the index action.
#
# These two methods represent the two basic action archetypes used in Action
# Controllers: Get-and-show and do-and-redirect. Most actions are variations on
# these themes.
#
# ## Requests
#
# For every request, the router determines the value of the `controller` and
# `action` keys. These determine which controller and action are called. The
# remaining request parameters, the session (if one is available), and the full
# request with all the HTTP headers are made available to the action through
# accessor methods. Then the action is performed.
#
# The full request object is available via the request accessor and is primarily
# used to query for HTTP headers:
#
#     def server_ip
#       location = request.env["REMOTE_ADDR"]
#       render plain: "This server hosted at #{location}"
#     end
#
# ## Parameters
#
# All request parameters, whether they come from a query string in the URL or
# form data submitted through a POST request are available through the `params`
# method which returns a hash. For example, an action that was performed through
# `/posts?category=All&limit=5` will include `{ "category" => "All", "limit" =>
# "5" }` in `params`.
#
# It's also possible to construct multi-dimensional parameter hashes by
# specifying keys using brackets, such as:
#
#     <input type="text" name="post[name]" value="david">
#     <input type="text" name="post[address]" value="hyacintvej">
#
# A request coming from a form holding these inputs will include `{ "post" => {
# "name" => "david", "address" => "hyacintvej" } }`. If the address input had
# been named `post[address][street]`, the `params` would have included `{ "post"
# => { "address" => { "street" => "hyacintvej" } } }`. There's no limit to the
# depth of the nesting.
#
# ## Sessions
#
# Sessions allow you to store objects in between requests. This is useful for
# objects that are not yet ready to be persisted, such as a Signup object
# constructed in a multi-paged process, or objects that don't change much and
# are needed all the time, such as a User object for a system that requires
# login. The session should not be used, however, as a cache for objects where
# it's likely they could be changed unknowingly. It's usually too much work to
# keep it all synchronized -- something databases already excel at.
#
# You can place objects in the session by using the `session` method, which
# accesses a hash:
#
#     session[:person] = Person.authenticate(user_name, password)
#
# You can retrieve it again through the same hash:
#
#     "Hello #{session[:person]}"
#
# For removing objects from the session, you can either assign a single key to
# `nil`:
#
#     # removes :person from session
#     session[:person] = nil
#
# or you can remove the entire session with `reset_session`.
#
# By default, sessions are stored in an encrypted browser cookie (see
# ActionDispatch::Session::CookieStore). Thus the user will not be able to read
# or edit the session data. However, the user can keep a copy of the cookie even
# after it has expired, so you should avoid storing sensitive information in
# cookie-based sessions.
#
# ## Responses
#
# Each action results in a response, which holds the headers and document to be
# sent to the user's browser. The actual response object is generated
# automatically through the use of renders and redirects and requires no user
# intervention.
#
# ## Renders
#
# Action Controller sends content to the user by using one of five rendering
# methods. The most versatile and common is the rendering of a template.
# Included in the Action Pack is the Action View, which enables rendering of ERB
# templates. It's automatically configured. The controller passes objects to the
# view by assigning instance variables:
#
#     def show
#       @post = Post.find(params[:id])
#     end
#
# Which are then automatically available to the view:
#
#     Title: <%= @post.title %>
#
# You don't have to rely on the automated rendering. For example, actions that
# could result in the rendering of different templates will use the manual
# rendering methods:
#
#     def search
#       @results = Search.find(params[:query])
#       case @results.count
#         when 0 then render action: "no_results"
#         when 1 then render action: "show"
#         when 2..10 then render action: "show_many"
#       end
#     end
#
# Read more about writing ERB and Builder templates in ActionView::Base.
#
# ## Redirects
#
# Redirects are used to move from one action to another. For example, after a
# `create` action, which stores a blog entry to the database, we might like to
# show the user the new entry. Because we're following good DRY principles
# (Don't Repeat Yourself), we're going to reuse (and redirect to) a `show`
# action that we'll assume has already been created. The code might look like
# this:
#
#     def create
#       @entry = Entry.new(params[:entry])
#       if @entry.save
#         # The entry was saved correctly, redirect to show
#         redirect_to action: 'show', id: @entry.id
#       else
#         # things didn't go so well, do something else
#       end
#     end
#
# In this case, after saving our new entry to the database, the user is
# redirected to the `show` method, which is then executed. Note that this is an
# external HTTP-level redirection which will cause the browser to make a second
# request (a GET to the show action), and not some internal re-routing which
# calls both "create" and then "show" within one request.
#
# Learn more about `redirect_to` and what options you have in
# ActionController::Redirecting.
#
# ## Calling multiple redirects or renders
#
# An action may perform only a single render or a single redirect. Attempting to
# do either again will result in a DoubleRenderError:
#
#     def do_something
#       redirect_to action: "elsewhere"
#       render action: "overthere" # raises DoubleRenderError
#     end
#
# If you need to redirect on the condition of something, then be sure to add
# "return" to halt execution.
#
#     def do_something
#       if monkeys.nil?
#         redirect_to(action: "elsewhere")
#         return
#       end
#       render action: "overthere" # won't be called if monkeys is nil
#     end
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://actionpack//lib/action_controller/base.rb#207
class ActionController::Base < ::ActionController::Metal
  include ::ActionView::ViewPaths
  include ::AbstractController::Rendering
  include ::AbstractController::Translation
  include ::AbstractController::AssetPaths
  include ::AbstractController::Helpers
  include ::ActionController::Helpers
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor
  include ::AbstractController::UrlFor
  include ::ActionController::UrlFor
  include ::AbstractController::Logger
  include ::ActiveSupport::Benchmarkable
  include ::ActionController::Redirecting
  include ::ActionView::Rendering
  include ::ActionView::Layouts
  include ::ActionController::Rendering
  include ::ActionController::Renderers
  include ::ActionController::Renderers::All
  include ::ActionController::Head
  include ::ActionController::ConditionalGet
  include ::ActionController::EtagWithTemplateDigest
  include ::ActionController::EtagWithFlash
  include ::ActionController::Caching
  include ::AbstractController::Caching::Fragments
  include ::AbstractController::Caching::ConfigMethods
  include ::AbstractController::Caching
  include ::ActionController::MimeResponds
  include ::ActionController::BasicImplicitRender
  include ::ActionController::ImplicitRender
  include ::ActionController::StrongParameters
  include ::ActionController::ParameterEncoding
  include ::ActionController::Cookies
  include ::ActionController::Flash
  include ::ActionController::FormBuilder
  include ::ActiveSupport::Callbacks
  include ::AbstractController::Callbacks
  include ::ActionController::RequestForgeryProtection
  include ::ActionController::ContentSecurityPolicy
  include ::ActionController::PermissionsPolicy
  include ::ActionController::RateLimiting
  include ::ActionController::AllowBrowser
  include ::ActionController::Streaming
  include ::ActionController::DataStreaming
  include ::ActionController::HttpAuthentication::Basic::ControllerMethods
  include ::ActionController::HttpAuthentication::Digest::ControllerMethods
  include ::ActionController::HttpAuthentication::Token::ControllerMethods
  include ::ActionController::DefaultHeaders
  include ::ActionController::Logging
  include ::ActiveSupport::Rescuable
  include ::ActionController::Rescue
  include ::ActionController::Instrumentation
  include ::ActionController::ParamsWrapper
  extend ::ActionView::ViewPaths::ClassMethods
  extend ::AbstractController::Helpers::Resolution
  extend ::AbstractController::Helpers::ClassMethods
  extend ::ActionController::Helpers::ClassMethods
  extend ::AbstractController::UrlFor::ClassMethods
  extend ::ActionView::Rendering::ClassMethods
  extend ::ActionView::Layouts::ClassMethods
  extend ::ActionController::Rendering::ClassMethods
  extend ::ActionController::Renderers::ClassMethods
  extend ::ActionController::ConditionalGet::ClassMethods
  extend ::AbstractController::Caching::Fragments::ClassMethods
  extend ::AbstractController::Caching::ClassMethods
  extend ::AbstractController::Caching::ConfigMethods
  extend ::ActionController::ParameterEncoding::ClassMethods
  extend ::ActionController::Flash::ClassMethods
  extend ::ActionController::FormBuilder::ClassMethods
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::AbstractController::Callbacks::ClassMethods
  extend ::ActionController::RequestForgeryProtection::ClassMethods
  extend ::ActionController::ContentSecurityPolicy::ClassMethods
  extend ::ActionController::PermissionsPolicy::ClassMethods
  extend ::ActionController::RateLimiting::ClassMethods
  extend ::ActionController::AllowBrowser::ClassMethods
  extend ::ActionController::HttpAuthentication::Basic::ControllerMethods::ClassMethods
  extend ::ActionController::DefaultHeaders::ClassMethods
  extend ::ActionController::Logging::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods
  extend ::ActionController::Instrumentation::ClassMethods
  extend ::ActionController::ParamsWrapper::ClassMethods

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://actionpack//lib/abstract_controller/helpers.rb#13
  def _helper_methods; end

  # source://actionpack//lib/abstract_controller/helpers.rb#13
  def _helper_methods=(_arg0); end

  # source://actionpack//lib/abstract_controller/helpers.rb#13
  def _helper_methods?; end

  # source://actionview/7.2.1/lib/action_view/layouts.rb#212
  def _layout_conditions; end

  # source://actionview/7.2.1/lib/action_view/layouts.rb#212
  def _layout_conditions?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _process_action_callbacks; end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers; end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers=(_arg0); end

  # source://actionpack//lib/action_controller/metal/renderers.rb#33
  def _renderers?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_process_action_callbacks(&block); end

  # source://actionpack//lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies; end

  # source://actionpack//lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies=(_arg0); end

  # source://actionpack//lib/abstract_controller/caching.rb#44
  def _view_cache_dependencies?; end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options; end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options=(_arg0); end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
  def _wrapper_options?; end

  # source://actionpack//lib/action_controller/metal/flash.rb#38
  def alert; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def allow_forgery_protection; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def allow_forgery_protection=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def asset_host; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def asset_host=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def assets_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def assets_dir=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def csrf_token_storage_strategy; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def csrf_token_storage_strategy=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def default_asset_host_protocol; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def default_asset_host_protocol=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def default_static_extension; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def default_static_extension=(value); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def enable_fragment_cache_logging; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def enable_fragment_cache_logging=(value); end

  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
  def etag_with_template_digest; end

  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
  def etag_with_template_digest=(_arg0); end

  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
  def etag_with_template_digest?; end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers; end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers=(_arg0); end

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
  def etaggers?; end

  # source://actionpack//lib/action_controller/metal/flash.rb#12
  def flash(*_arg0, **_arg1, &_arg2); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def forgery_protection_origin_check; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def forgery_protection_origin_check=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def forgery_protection_strategy; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def forgery_protection_strategy=(value); end

  # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys; end

  # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys=(_arg0); end

  # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
  def fragment_cache_keys?; end

  # source://actionpack//lib/action_controller/metal/helpers.rb#70
  def helpers_path; end

  # source://actionpack//lib/action_controller/metal/helpers.rb#70
  def helpers_path=(_arg0); end

  # source://actionpack//lib/action_controller/metal/helpers.rb#70
  def helpers_path?; end

  # source://actionpack//lib/action_controller/metal/helpers.rb#71
  def include_all_helpers; end

  # source://actionpack//lib/action_controller/metal/helpers.rb#71
  def include_all_helpers=(_arg0); end

  # source://actionpack//lib/action_controller/metal/helpers.rb#71
  def include_all_helpers?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def javascripts_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def javascripts_dir=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def log_warning_on_csrf_failure; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def log_warning_on_csrf_failure=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def logger; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def logger=(value); end

  # source://actionpack//lib/action_controller/metal/flash.rb#38
  def notice; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def per_form_csrf_tokens; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def per_form_csrf_tokens=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def perform_caching; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def perform_caching=(value); end

  # source://actionpack//lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions; end

  # source://actionpack//lib/abstract_controller/callbacks.rb#36
  def raise_on_missing_callback_actions=(val); end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#17
  def raise_on_open_redirects; end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#17
  def raise_on_open_redirects=(val); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def relative_url_root; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def relative_url_root=(value); end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def request_forgery_protection_token; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def request_forgery_protection_token=(value); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers; end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers?; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
  def stylesheets_dir; end

  # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
  def stylesheets_dir=(value); end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://actionpack//lib/action_controller/base.rb#324
  def _protected_ivars; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://actionpack//lib/action_controller/form_builder.rb#35
    def _default_form_builder; end

    # source://actionpack//lib/action_controller/form_builder.rb#35
    def _default_form_builder=(value); end

    # source://actionpack//lib/action_controller/form_builder.rb#35
    def _default_form_builder?; end

    # source://actionpack//lib/action_controller/metal/flash.rb#10
    def _flash_types; end

    # source://actionpack//lib/action_controller/metal/flash.rb#10
    def _flash_types=(value); end

    # source://actionpack//lib/action_controller/metal/flash.rb#10
    def _flash_types?; end

    # source://actionpack//lib/abstract_controller/helpers.rb#13
    def _helper_methods; end

    # source://actionpack//lib/abstract_controller/helpers.rb#13
    def _helper_methods=(value); end

    # source://actionpack//lib/abstract_controller/helpers.rb#13
    def _helper_methods?; end

    # source://actionpack//lib/abstract_controller/helpers.rb#17
    def _helpers; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout=(value); end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout?; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions=(value); end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _process_action_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _process_action_callbacks=(value); end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers; end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers=(value); end

    # source://actionpack//lib/action_controller/metal/renderers.rb#33
    def _renderers?; end

    # source://actionpack//lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies; end

    # source://actionpack//lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies=(value); end

    # source://actionpack//lib/abstract_controller/caching.rb#44
    def _view_cache_dependencies?; end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options; end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options=(value); end

    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#185
    def _wrapper_options?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def allow_forgery_protection; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def allow_forgery_protection=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def asset_host; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def asset_host=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def assets_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def assets_dir=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def csrf_token_storage_strategy; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def csrf_token_storage_strategy=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def default_asset_host_protocol; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def default_asset_host_protocol=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def default_static_extension; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def default_static_extension=(value); end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options; end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options=(value); end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def enable_fragment_cache_logging; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def enable_fragment_cache_logging=(value); end

    # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
    def etag_with_template_digest; end

    # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
    def etag_with_template_digest=(value); end

    # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#31
    def etag_with_template_digest?; end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers; end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers=(value); end

    # source://actionpack//lib/action_controller/metal/conditional_get.rb#15
    def etaggers?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def forgery_protection_origin_check; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def forgery_protection_origin_check=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def forgery_protection_strategy; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def forgery_protection_strategy=(value); end

    # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys; end

    # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys=(value); end

    # source://actionpack//lib/abstract_controller/caching/fragments.rb#26
    def fragment_cache_keys?; end

    # source://actionpack//lib/action_controller/metal/helpers.rb#70
    def helpers_path; end

    # source://actionpack//lib/action_controller/metal/helpers.rb#70
    def helpers_path=(value); end

    # source://actionpack//lib/action_controller/metal/helpers.rb#70
    def helpers_path?; end

    # source://actionpack//lib/action_controller/metal/helpers.rb#71
    def include_all_helpers; end

    # source://actionpack//lib/action_controller/metal/helpers.rb#71
    def include_all_helpers=(value); end

    # source://actionpack//lib/action_controller/metal/helpers.rb#71
    def include_all_helpers?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def javascripts_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def javascripts_dir=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def log_warning_on_csrf_failure; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def log_warning_on_csrf_failure=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def logger; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def logger=(value); end

    # source://actionpack//lib/action_controller/metal.rb#288
    def middleware_stack; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def per_form_csrf_tokens; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def per_form_csrf_tokens=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def perform_caching; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def perform_caching=(value); end

    # source://actionpack//lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions; end

    # source://actionpack//lib/abstract_controller/callbacks.rb#36
    def raise_on_missing_callback_actions=(val); end

    # source://actionpack//lib/action_controller/metal/redirecting.rb#17
    def raise_on_open_redirects; end

    # source://actionpack//lib/action_controller/metal/redirecting.rb#17
    def raise_on_open_redirects=(val); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def relative_url_root; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def relative_url_root=(value); end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def request_forgery_protection_token; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def request_forgery_protection_token=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers?; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#115
    def stylesheets_dir; end

    # source://activesupport/7.2.1/lib/active_support/configurable.rb#116
    def stylesheets_dir=(value); end

    # Shortcut helper that returns all the modules included in
    # ActionController::Base except the ones passed as arguments:
    #
    #     class MyBaseController < ActionController::Metal
    #       ActionController::Base.without_modules(:ParamsWrapper, :Streaming).each do |left|
    #         include left
    #       end
    #     end
    #
    # This gives better control over what you want to exclude and makes it easier to
    # create a bare controller class, instead of listing the modules required
    # manually.
    #
    # source://actionpack//lib/action_controller/base.rb#222
    def without_modules(*modules); end
  end
end

# source://actionpack//lib/action_controller/base.rb#0
module ActionController::Base::HelperMethods
  include ::ActionText::ContentHelper
  include ::ActionText::TagHelper

  # source://actionpack//lib/action_controller/metal/flash.rb#41
  def alert(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/caching/fragments.rb#34
  def combined_fragment_cache_key(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#13
  def content_security_policy?(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#14
  def content_security_policy_nonce(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/cookies.rb#10
  def cookies(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#102
  def form_authenticity_token(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/flash.rb#41
  def notice(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#103
  def protect_against_forgery?(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/abstract_controller/caching.rb#45
  def view_cache_dependencies(*_arg0, **_arg1, &_arg2); end
end

# source://actionpack//lib/action_controller/base.rb#230
ActionController::Base::MODULES = T.let(T.unsafe(nil), Array)

# Define some internal variables that should not be propagated to the view.
#
# source://actionpack//lib/action_controller/base.rb#318
ActionController::Base::PROTECTED_IVARS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/metal/basic_implicit_render.rb#6
module ActionController::BasicImplicitRender
  # source://actionpack//lib/action_controller/metal/basic_implicit_render.rb#13
  def default_render; end

  # source://actionpack//lib/action_controller/metal/basic_implicit_render.rb#7
  def send_action(method, *args); end
end

# # Action Controller Caching
#
# Caching is a cheap way of speeding up slow applications by keeping the result
# of calculations, renderings, and database calls around for subsequent
# requests.
#
# You can read more about each approach by clicking the modules below.
#
# Note: To turn off all caching provided by Action Controller, set
#     config.action_controller.perform_caching = false
#
# ## Caching stores
#
# All the caching stores from ActiveSupport::Cache are available to be used as
# backends for Action Controller caching.
#
# Configuration examples (FileStore is the default):
#
#     config.action_controller.cache_store = :memory_store
#     config.action_controller.cache_store = :file_store, '/path/to/cache/directory'
#     config.action_controller.cache_store = :mem_cache_store, 'localhost'
#     config.action_controller.cache_store = :mem_cache_store, Memcached::Rails.new('localhost:11211')
#     config.action_controller.cache_store = MyOwnStore.new('parameter')
#
# source://actionpack//lib/action_controller/caching.rb#29
module ActionController::Caching
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::AbstractController::Caching::Fragments
  include ::AbstractController::Caching

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Caching::Fragments::ClassMethods
  mixes_in_class_methods ::AbstractController::Caching::ClassMethods
  mixes_in_class_methods ::AbstractController::Caching::ConfigMethods

  private

  # source://actionpack//lib/action_controller/caching.rb#45
  def instrument_name; end

  # source://actionpack//lib/action_controller/caching.rb#37
  def instrument_payload(key); end

  module GeneratedClassMethods
    def _view_cache_dependencies; end
    def _view_cache_dependencies=(value); end
    def _view_cache_dependencies?; end
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end

  module GeneratedInstanceMethods
    def _view_cache_dependencies; end
    def _view_cache_dependencies=(value); end
    def _view_cache_dependencies?; end
    def fragment_cache_keys; end
    def fragment_cache_keys=(value); end
    def fragment_cache_keys?; end
  end
end

# source://actionpack//lib/action_controller/metal/conditional_get.rb#9
module ActionController::ConditionalGet
  include ::ActionController::Head
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::ConditionalGet::ClassMethods

  # Sets the `Cache-Control` header, overwriting existing directives. This method
  # will also ensure an HTTP `Date` header for client compatibility.
  #
  # Defaults to issuing the `private` directive, so that intermediate caches must
  # not cache the response.
  #
  # #### Options
  #
  # `:public`
  # :   If true, replaces the default `private` directive with the `public`
  #     directive.
  #
  # `:must_revalidate`
  # :   If true, adds the `must-revalidate` directive.
  #
  # `:stale_while_revalidate`
  # :   Sets the value of the `stale-while-revalidate` directive.
  #
  # `:stale_if_error`
  # :   Sets the value of the `stale-if-error` directive.
  #
  #
  # Any additional key-value pairs are concatenated as directives. For a list of
  # supported `Cache-Control` directives, see the [article on
  # MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control).
  #
  # #### Examples
  #
  #     expires_in 10.minutes
  #     # => Cache-Control: max-age=600, private
  #
  #     expires_in 10.minutes, public: true
  #     # => Cache-Control: max-age=600, public
  #
  #     expires_in 10.minutes, public: true, must_revalidate: true
  #     # => Cache-Control: max-age=600, public, must-revalidate
  #
  #     expires_in 1.hour, stale_while_revalidate: 60.seconds
  #     # => Cache-Control: max-age=3600, private, stale-while-revalidate=60
  #
  #     expires_in 1.hour, stale_if_error: 5.minutes
  #     # => Cache-Control: max-age=3600, private, stale-if-error=300
  #
  #     expires_in 1.hour, public: true, "s-maxage": 3.hours, "no-transform": true
  #     # => Cache-Control: max-age=3600, public, s-maxage=10800, no-transform=true
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#288
  def expires_in(seconds, options = T.unsafe(nil)); end

  # Sets an HTTP 1.1 `Cache-Control` header of `no-cache`. This means the resource
  # will be marked as stale, so clients must always revalidate.
  # Intermediate/browser caches may still store the asset.
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#306
  def expires_now; end

  # Sets the `etag`, `last_modified`, or both on the response, and renders a `304
  # Not Modified` response if the request is already fresh.
  #
  # #### Options
  #
  # `:etag`
  # :   Sets a "weak" ETag validator on the response. See the `:weak_etag` option.
  #
  # `:weak_etag`
  # :   Sets a "weak" ETag validator on the response. Requests that specify an
  #     `If-None-Match` header may receive a `304 Not Modified` response if the
  #     ETag matches exactly.
  #
  # :   A weak ETag indicates semantic equivalence, not byte-for-byte equality, so
  #     they're good for caching HTML pages in browser caches. They can't be used
  #     for responses that must be byte-identical, like serving `Range` requests
  #     within a PDF file.
  #
  # `:strong_etag`
  # :   Sets a "strong" ETag validator on the response. Requests that specify an
  #     `If-None-Match` header may receive a `304 Not Modified` response if the
  #     ETag matches exactly.
  #
  # :   A strong ETag implies exact equality -- the response must match byte for
  #     byte. This is necessary for serving `Range` requests within a large video
  #     or PDF file, for example, or for compatibility with some CDNs that don't
  #     support weak ETags.
  #
  # `:last_modified`
  # :   Sets a "weak" last-update validator on the response. Subsequent requests
  #     that specify an `If-Modified-Since` header may receive a `304 Not
  #     Modified` response if `last_modified` <= `If-Modified-Since`.
  #
  # `:public`
  # :   By default the `Cache-Control` header is private. Set this option to
  #     `true` if you want your application to be cacheable by other devices, such
  #     as proxy caches.
  #
  # `:cache_control`
  # :   When given, will overwrite an existing `Cache-Control` header. For a list
  #     of `Cache-Control` directives, see the [article on
  #     MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Contr
  #     ol).
  #
  # `:template`
  # :   By default, the template digest for the current controller/action is
  #     included in ETags. If the action renders a different template, you can
  #     include its digest instead. If the action doesn't render a template at
  #     all, you can pass `template: false` to skip any attempt to check for a
  #     template digest.
  #
  #
  # #### Examples
  #
  #     def show
  #       @article = Article.find(params[:id])
  #       fresh_when(etag: @article, last_modified: @article.updated_at, public: true)
  #     end
  #
  # This will send a `304 Not Modified` response if the request specifies a
  # matching ETag and `If-Modified-Since` header. Otherwise, it will render the
  # `show` template.
  #
  # You can also just pass a record:
  #
  #     def show
  #       @article = Article.find(params[:id])
  #       fresh_when(@article)
  #     end
  #
  # `etag` will be set to the record, and `last_modified` will be set to the
  # record's `updated_at`.
  #
  # You can also pass an object that responds to `maximum`, such as a collection
  # of records:
  #
  #     def index
  #       @articles = Article.all
  #       fresh_when(@articles)
  #     end
  #
  # In this case, `etag` will be set to the collection, and `last_modified` will
  # be set to `maximum(:updated_at)` (the timestamp of the most recently updated
  # record).
  #
  # When passing a record or a collection, you can still specify other options,
  # such as `:public` and `:cache_control`:
  #
  #     def show
  #       @article = Article.find(params[:id])
  #       fresh_when(@article, public: true, cache_control: { no_cache: true })
  #     end
  #
  # The above will set `Cache-Control: public, no-cache` in the response.
  #
  # When rendering a different template than the controller/action's default
  # template, you can indicate which digest to include in the ETag:
  #
  #     before_action { fresh_when @article, template: "widgets/show" }
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#138
  def fresh_when(object = T.unsafe(nil), etag: T.unsafe(nil), weak_etag: T.unsafe(nil), strong_etag: T.unsafe(nil), last_modified: T.unsafe(nil), public: T.unsafe(nil), cache_control: T.unsafe(nil), template: T.unsafe(nil)); end

  # Cache or yield the block. The cache is supposed to never expire.
  #
  # You can use this method when you have an HTTP response that never changes, and
  # the browser and proxies should cache it indefinitely.
  #
  # *   `public`: By default, HTTP responses are private, cached only on the
  #     user's web browser. To allow proxies to cache the response, set `true` to
  #     indicate that they can serve the cached response to all users.
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#318
  def http_cache_forever(public: T.unsafe(nil)); end

  # Sets an HTTP 1.1 `Cache-Control` header of `no-store`. This means the resource
  # may not be stored in any cache.
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#328
  def no_store; end

  # Sets the `etag` and/or `last_modified` on the response and checks them against
  # the request. If the request doesn't match the provided options, it is
  # considered stale, and the response should be rendered from scratch. Otherwise,
  # it is fresh, and a `304 Not Modified` is sent.
  #
  # #### Options
  #
  # See #fresh_when for supported options.
  #
  # #### Examples
  #
  #     def show
  #       @article = Article.find(params[:id])
  #
  #       if stale?(etag: @article, last_modified: @article.updated_at)
  #         @statistics = @article.really_expensive_call
  #         respond_to do |format|
  #           # all the supported formats
  #         end
  #       end
  #     end
  #
  # You can also just pass a record:
  #
  #     def show
  #       @article = Article.find(params[:id])
  #
  #       if stale?(@article)
  #         @statistics = @article.really_expensive_call
  #         respond_to do |format|
  #           # all the supported formats
  #         end
  #       end
  #     end
  #
  # `etag` will be set to the record, and `last_modified` will be set to the
  # record's `updated_at`.
  #
  # You can also pass an object that responds to `maximum`, such as a collection
  # of records:
  #
  #     def index
  #       @articles = Article.all
  #
  #       if stale?(@articles)
  #         @statistics = @articles.really_expensive_call
  #         respond_to do |format|
  #           # all the supported formats
  #         end
  #       end
  #     end
  #
  # In this case, `etag` will be set to the collection, and `last_modified` will
  # be set to `maximum(:updated_at)` (the timestamp of the most recently updated
  # record).
  #
  # When passing a record or a collection, you can still specify other options,
  # such as `:public` and `:cache_control`:
  #
  #     def show
  #       @article = Article.find(params[:id])
  #
  #       if stale?(@article, public: true, cache_control: { no_cache: true })
  #         @statistics = @articles.really_expensive_call
  #         respond_to do |format|
  #           # all the supported formats
  #         end
  #       end
  #     end
  #
  # The above will set `Cache-Control: public, no-cache` in the response.
  #
  # When rendering a different template than the controller/action's default
  # template, you can indicate which digest to include in the ETag:
  #
  #     def show
  #       super if stale?(@article, template: "widgets/show")
  #     end
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#237
  def stale?(object = T.unsafe(nil), **freshness_kwargs); end

  private

  # source://actionpack//lib/action_controller/metal/conditional_get.rb#333
  def combine_etags(validator, options); end

  module GeneratedClassMethods
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end

  module GeneratedInstanceMethods
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end
end

# source://actionpack//lib/action_controller/metal/conditional_get.rb#18
module ActionController::ConditionalGet::ClassMethods
  # Allows you to consider additional controller-wide information when generating
  # an ETag. For example, if you serve pages tailored depending on who's logged in
  # at the moment, you may want to add the current user id to be part of the ETag
  # to prevent unauthorized displaying of cached pages.
  #
  #     class InvoicesController < ApplicationController
  #       etag { current_user&.id }
  #
  #       def show
  #         # Etag will differ even for the same invoice when it's viewed by a different current_user
  #         @invoice = Invoice.find(params[:id])
  #         fresh_when etag: @invoice
  #       end
  #     end
  #
  # source://actionpack//lib/action_controller/metal/conditional_get.rb#33
  def etag(&etagger); end
end

# source://actionpack//lib/action_controller/metal/content_security_policy.rb#6
module ActionController::ContentSecurityPolicy
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::AbstractController::Helpers
  include ::ActiveSupport::Callbacks
  include ::AbstractController::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Helpers::ClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::AbstractController::Callbacks::ClassMethods
  mixes_in_class_methods ::ActionController::ContentSecurityPolicy::ClassMethods

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#74
  def content_security_policy?; end

  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#78
  def content_security_policy_nonce; end

  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#82
  def current_content_security_policy; end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end
end

# source://actionpack//lib/action_controller/metal/content_security_policy.rb#17
module ActionController::ContentSecurityPolicy::ClassMethods
  # Overrides parts of the globally configured `Content-Security-Policy` header:
  #
  #     class PostsController < ApplicationController
  #       content_security_policy do |policy|
  #         policy.base_uri "https://www.example.com"
  #       end
  #     end
  #
  # Options can be passed similar to `before_action`. For example, pass `only:
  # :index` to override the header on the index action only:
  #
  #     class PostsController < ApplicationController
  #       content_security_policy(only: :index) do |policy|
  #         policy.default_src :self, :https
  #       end
  #     end
  #
  # Pass `false` to remove the `Content-Security-Policy` header:
  #
  #     class PostsController < ApplicationController
  #       content_security_policy false, only: :index
  #     end
  #
  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#40
  def content_security_policy(enabled = T.unsafe(nil), **options, &block); end

  # Overrides the globally configured `Content-Security-Policy-Report-Only`
  # header:
  #
  #     class PostsController < ApplicationController
  #       content_security_policy_report_only only: :index
  #     end
  #
  # Pass `false` to remove the `Content-Security-Policy-Report-Only` header:
  #
  #     class PostsController < ApplicationController
  #       content_security_policy_report_only false, only: :index
  #     end
  #
  # source://actionpack//lib/action_controller/metal/content_security_policy.rb#66
  def content_security_policy_report_only(report_only = T.unsafe(nil), **options); end
end

# source://actionpack//lib/action_controller/metal/cookies.rb#6
module ActionController::Cookies
  extend ::ActiveSupport::Concern

  private

  # The cookies for the current request. See ActionDispatch::Cookies for more
  # information.
  #
  # source://actionpack//lib/action_controller/metal/cookies.rb#16
  def cookies; end
end

# # Action Controller Data Streaming
#
# Methods for sending arbitrary data and for streaming files to the browser,
# instead of rendering.
#
# source://actionpack//lib/action_controller/metal/data_streaming.rb#13
module ActionController::DataStreaming
  extend ::ActiveSupport::Concern
  include ::ActionController::Rendering

  mixes_in_class_methods ::ActionController::Rendering::ClassMethods

  private

  # Sends the given binary data to the browser. This method is similar to `render
  # plain: data`, but also allows you to specify whether the browser should
  # display the response as a file attachment (i.e. in a download dialog) or as
  # inline data. You may also set the content type, the file name, and other
  # things.
  #
  # Options:
  # *   `:filename` - suggests a filename for the browser to use.
  # *   `:type` - specifies an HTTP content type. Defaults to
  #     `application/octet-stream`. You can specify either a string or a symbol
  #     for a registered type with `Mime::Type.register`, for example `:json`. If
  #     omitted, type will be inferred from the file extension specified in
  #     `:filename`. If no content type is registered for the extension, the
  #     default type `application/octet-stream` will be used.
  # *   `:disposition` - specifies whether the file will be shown inline or
  #     downloaded. Valid values are `"inline"` and `"attachment"` (default).
  # *   `:status` - specifies the status code to send with the response. Defaults
  #     to 200.
  #
  #
  # Generic data download:
  #
  #     send_data buffer
  #
  # Download a dynamically-generated tarball:
  #
  #     send_data generate_tgz('dir'), filename: 'dir.tgz'
  #
  # Display an image Active Record in the browser:
  #
  #     send_data image.data, type: image.content_type, disposition: 'inline'
  #
  # See `send_file` for more information on HTTP `Content-*` headers and caching.
  #
  # source://actionpack//lib/action_controller/metal/data_streaming.rb#120
  def send_data(data, options = T.unsafe(nil)); end

  # Sends the file. This uses a server-appropriate method (such as `X-Sendfile`)
  # via the `Rack::Sendfile` middleware. The header to use is set via
  # `config.action_dispatch.x_sendfile_header`. Your server can also configure
  # this for you by setting the `X-Sendfile-Type` header.
  #
  # Be careful to sanitize the path parameter if it is coming from a web page.
  # `send_file(params[:path])` allows a malicious user to download any file on
  # your server.
  #
  # Options:
  # *   `:filename` - suggests a filename for the browser to use. Defaults to
  #     `File.basename(path)`.
  # *   `:type` - specifies an HTTP content type. You can specify either a string
  #     or a symbol for a registered type with `Mime::Type.register`, for example
  #     `:json`. If omitted, the type will be inferred from the file extension
  #     specified in `:filename`. If no content type is registered for the
  #     extension, the default type `application/octet-stream` will be used.
  # *   `:disposition` - specifies whether the file will be shown inline or
  #     downloaded. Valid values are `"inline"` and `"attachment"` (default).
  # *   `:status` - specifies the status code to send with the response. Defaults
  #     to 200.
  # *   `:url_based_filename` - set to `true` if you want the browser to guess the
  #     filename from the URL, which is necessary for i18n filenames on certain
  #     browsers (setting `:filename` overrides this option).
  #
  #
  # The default `Content-Type` and `Content-Disposition` headers are set to
  # download arbitrary binary files in as many browsers as possible. IE versions
  # 4, 5, 5.5, and 6 are all known to have a variety of quirks (especially when
  # downloading over SSL).
  #
  # Simple download:
  #
  #     send_file '/path/to.zip'
  #
  # Show a JPEG in the browser:
  #
  #     send_file '/path/to.jpeg', type: 'image/jpeg', disposition: 'inline'
  #
  # Show a 404 page in the browser:
  #
  #     send_file '/path/to/404.html', type: 'text/html; charset=utf-8', disposition: 'inline', status: 404
  #
  # You can use other `Content-*` HTTP headers to provide additional information
  # to the client. See MDN for a [list of HTTP
  # headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers).
  #
  # Also be aware that the document may be cached by proxies and browsers. The
  # `Pragma` and `Cache-Control` headers declare how the file may be cached by
  # intermediaries. They default to require clients to validate with the server
  # before releasing cached responses. See https://www.mnot.net/cache_docs/ for an
  # overview of web caching and [RFC
  # 9111](https://www.rfc-editor.org/rfc/rfc9111.html#name-cache-control) for the
  # `Cache-Control` header spec.
  #
  # @raise [MissingFile]
  #
  # source://actionpack//lib/action_controller/metal/data_streaming.rb#76
  def send_file(path, options = T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_controller/metal/data_streaming.rb#125
  def send_file_headers!(options); end
end

# source://actionpack//lib/action_controller/metal/data_streaming.rb#19
ActionController::DataStreaming::DEFAULT_SEND_FILE_DISPOSITION = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/data_streaming.rb#18
ActionController::DataStreaming::DEFAULT_SEND_FILE_TYPE = T.let(T.unsafe(nil), String)

# # Action Controller Default Headers
#
# Allows configuring default headers that will be automatically merged into each
# response.
#
# source://actionpack//lib/action_controller/metal/default_headers.rb#10
module ActionController::DefaultHeaders
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::DefaultHeaders::ClassMethods
end

# source://actionpack//lib/action_controller/metal/default_headers.rb#13
module ActionController::DefaultHeaders::ClassMethods
  # source://actionpack//lib/action_controller/metal/default_headers.rb#14
  def make_response!(request); end
end

# # Action Controller Etag With Flash
#
# When you're using the flash, it's generally used as a conditional on the view.
# This means the content of the view depends on the flash. Which in turn means
# that the ETag for a response should be computed with the content of the flash
# in mind. This does that by including the content of the flash as a component
# in the ETag that's generated for a response.
#
# source://actionpack//lib/action_controller/metal/etag_with_flash.rb#13
module ActionController::EtagWithFlash
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionController::ConditionalGet

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::ConditionalGet::ClassMethods

  module GeneratedClassMethods
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end

  module GeneratedInstanceMethods
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end
end

# # Action Controller Etag With Template Digest
#
# When our views change, they should bubble up into HTTP cache freshness and
# bust browser caches. So the template digest for the current action is
# automatically included in the ETag.
#
# Enabled by default for apps that use Action View. Disable by setting
#
#     config.action_controller.etag_with_template_digest = false
#
# Override the template to digest by passing `:template` to `fresh_when` and
# `stale?` calls. For example:
#
#     # We're going to render widgets/show, not posts/show
#     fresh_when @post, template: 'widgets/show'
#
#     # We're not going to render a template, so omit it from the ETag.
#     fresh_when @post, template: false
#
# source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#25
module ActionController::EtagWithTemplateDigest
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionController::ConditionalGet

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::ConditionalGet::ClassMethods

  private

  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#39
  def determine_template_etag(options); end

  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#55
  def lookup_and_digest_template(template); end

  # Pick the template digest to include in the ETag. If the `:template` option is
  # present, use the named template. If `:template` is `nil` or absent, use the
  # default controller/action template. If `:template` is false, omit the template
  # digest from the ETag.
  #
  # source://actionpack//lib/action_controller/metal/etag_with_template_digest.rb#49
  def pick_template_for_etag(options); end

  module GeneratedClassMethods
    def etag_with_template_digest; end
    def etag_with_template_digest=(value); end
    def etag_with_template_digest?; end
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end

  module GeneratedInstanceMethods
    def etag_with_template_digest; end
    def etag_with_template_digest=(value); end
    def etag_with_template_digest?; end
    def etaggers; end
    def etaggers=(value); end
    def etaggers?; end
  end
end

# source://actionpack//lib/action_controller/metal/flash.rb#6
module ActionController::Flash
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::Flash::ClassMethods

  private

  # source://actionpack//lib/action_controller/metal/flash.rb#53
  def redirect_to(options = T.unsafe(nil), response_options_and_flash = T.unsafe(nil)); end

  module GeneratedClassMethods
    def _flash_types; end
    def _flash_types=(value); end
    def _flash_types?; end
  end

  module GeneratedInstanceMethods; end
end

# source://actionpack//lib/action_controller/metal/flash.rb#16
module ActionController::Flash::ClassMethods
  # source://actionpack//lib/action_controller/metal/flash.rb#47
  def action_methods; end

  # Creates new flash types. You can pass as many types as you want to create
  # flash types other than the default `alert` and `notice` in your controllers
  # and views. For instance:
  #
  #     # in application_controller.rb
  #     class ApplicationController < ActionController::Base
  #       add_flash_types :warning
  #     end
  #
  #     # in your controller
  #     redirect_to user_path(@user), warning: "Incomplete profile"
  #
  #     # in your view
  #     <%= warning %>
  #
  # This method will automatically define a new method for each of the given
  # names, and it will be available in your views.
  #
  # source://actionpack//lib/action_controller/metal/flash.rb#34
  def add_flash_types(*types); end
end

# # Action Controller Form Builder
#
# Override the default form builder for all views rendered by this controller
# and any of its descendants. Accepts a subclass of
# ActionView::Helpers::FormBuilder.
#
# For example, given a form builder:
#
#     class AdminFormBuilder < ActionView::Helpers::FormBuilder
#       def special_field(name)
#       end
#     end
#
# The controller specifies a form builder as its default:
#
#     class AdminAreaController < ApplicationController
#       default_form_builder AdminFormBuilder
#     end
#
# Then in the view any form using `form_for` will be an instance of the
# specified form builder:
#
#     <%= form_for(@instance) do |builder| %>
#       <%= builder.special_field(:name) %>
#     <% end %>
#
# source://actionpack//lib/action_controller/form_builder.rb#31
module ActionController::FormBuilder
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::FormBuilder::ClassMethods

  # Default form builder for the controller
  #
  # source://actionpack//lib/action_controller/form_builder.rb#51
  def default_form_builder; end

  module GeneratedClassMethods
    def _default_form_builder; end
    def _default_form_builder=(value); end
    def _default_form_builder?; end
  end

  module GeneratedInstanceMethods; end
end

# source://actionpack//lib/action_controller/form_builder.rb#38
module ActionController::FormBuilder::ClassMethods
  # Set the form builder to be used as the default for all forms in the views
  # rendered by this controller and its subclasses.
  #
  # #### Parameters
  # *   `builder` - Default form builder, an instance of
  #     ActionView::Helpers::FormBuilder
  #
  # source://actionpack//lib/action_controller/form_builder.rb#45
  def default_form_builder(builder); end
end

# source://actionpack//lib/action_controller/metal/head.rb#6
module ActionController::Head
  # Returns a response that has no content (merely headers). The options argument
  # is interpreted to be a hash of header names and values. This allows you to
  # easily return a response that consists only of significant headers:
  #
  #     head :created, location: person_path(@person)
  #
  #     head :created, location: @person
  #
  # It can also be used to return exceptional conditions:
  #
  #     return head(:method_not_allowed) unless request.post?
  #     return head(:bad_request) unless valid_request?
  #     render
  #
  # See `Rack::Utils::SYMBOL_TO_STATUS_CODE` for a full list of valid `status`
  # symbols.
  #
  # source://actionpack//lib/action_controller/metal/head.rb#23
  def head(status, options = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/head.rb#56
  def include_content?(status); end
end

# # Action Controller Helpers
#
# The Rails framework provides a large number of helpers for working with
# assets, dates, forms, numbers and model objects, to name a few. These helpers
# are available to all templates by default.
#
# In addition to using the standard template helpers provided, creating custom
# helpers to extract complicated logic or reusable functionality is strongly
# encouraged. By default, each controller will include all helpers. These
# helpers are only accessible on the controller through `#helpers`
#
# In previous versions of Rails the controller will include a helper which
# matches the name of the controller, e.g., `MyController` will automatically
# include `MyHelper`. You can revert to the old behavior with the following:
#
#     # config/application.rb
#     class Application < Rails::Application
#       config.action_controller.include_all_helpers = false
#     end
#
# Additional helpers can be specified using the `helper` class method in
# ActionController::Base or any controller which inherits from it.
#
# The `to_s` method from the Time class can be wrapped in a helper method to
# display a custom message if a Time object is blank:
#
#     module FormattedTimeHelper
#       def format_time(time, format=:long, blank_message="&nbsp;")
#         time.blank? ? blank_message : time.to_fs(format)
#       end
#     end
#
# FormattedTimeHelper can now be included in a controller, using the `helper`
# class method:
#
#     class EventsController < ActionController::Base
#       helper FormattedTimeHelper
#       def index
#         @events = Event.all
#       end
#     end
#
# Then, in any view rendered by `EventsController`, the `format_time` method can
# be called:
#
#     <% @events.each do |event| -%>
#       <p>
#         <%= format_time(event.time, :short, "N/A") %> | <%= event.name %>
#       </p>
#     <% end -%>
#
# Finally, assuming we have two event instances, one which has a time and one
# which does not, the output might look like this:
#
#     23 Aug 11:30 | Carolina Railhawks Soccer Match
#     N/A | Carolina Railhawks Training Workshop
#
# source://actionpack//lib/action_controller/metal/helpers.rb#63
module ActionController::Helpers
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::AbstractController::Helpers

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Helpers::ClassMethods
  mixes_in_class_methods ::ActionController::Helpers::ClassMethods

  # Provides a proxy to access helper methods from outside the view.
  #
  # source://actionpack//lib/action_controller/metal/helpers.rb#125
  def helpers; end

  class << self
    # Returns the value of attribute helpers_path.
    #
    # source://actionpack//lib/action_controller/metal/helpers.rb#66
    def helpers_path; end

    # Sets the attribute helpers_path
    #
    # @param value the value to set the attribute helpers_path to.
    #
    # source://actionpack//lib/action_controller/metal/helpers.rb#66
    def helpers_path=(_arg0); end
  end

  module GeneratedClassMethods
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
    def helpers_path; end
    def helpers_path=(value); end
    def helpers_path?; end
    def include_all_helpers; end
    def include_all_helpers=(value); end
    def include_all_helpers?; end
  end

  module GeneratedInstanceMethods
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
    def helpers_path; end
    def helpers_path=(value); end
    def helpers_path?; end
    def include_all_helpers; end
    def include_all_helpers=(value); end
    def include_all_helpers?; end
  end
end

# source://actionpack//lib/action_controller/metal/helpers.rb#74
module ActionController::Helpers::ClassMethods
  # Declares helper accessors for controller attributes. For example, the
  # following adds new `name` and `name=` instance methods to a controller and
  # makes them available to the view:
  #     attr_accessor :name
  #     helper_attr :name
  #
  # #### Parameters
  # *   `attrs` - Names of attributes to be converted into helpers.
  #
  # source://actionpack//lib/action_controller/metal/helpers.rb#84
  def helper_attr(*attrs); end

  # Provides a proxy to access helper methods from outside the view.
  #
  # Note that the proxy is rendered under a different view context. This may cause
  # incorrect behavior with capture methods. Consider using
  # [helper](rdoc-ref:AbstractController::Helpers::ClassMethods#helper) instead
  # when using `capture`.
  #
  # source://actionpack//lib/action_controller/metal/helpers.rb#94
  def helpers; end

  # Override modules_for_helpers to accept `:all` as argument, which loads all
  # helpers in helpers_path.
  #
  # #### Parameters
  # *   `args` - A list of helpers
  #
  #
  # #### Returns
  # *   `array` - A normalized list of modules for the list of helpers provided.
  #
  # source://actionpack//lib/action_controller/metal/helpers.rb#112
  def modules_for_helpers(args); end

  private

  # Extract helper names from files in `app/helpers/***/**_helper.rb`
  #
  # source://actionpack//lib/action_controller/metal/helpers.rb#119
  def all_application_helpers; end
end

# HTTP Basic, Digest, and Token authentication.
#
# source://actionpack//lib/action_controller/metal/http_authentication.rb#11
module ActionController::HttpAuthentication; end

# # HTTP Basic authentication
#
# ### Simple Basic example
#
#     class PostsController < ApplicationController
#       http_basic_authenticate_with name: "dhh", password: "secret", except: :index
#
#       def index
#         render plain: "Everyone can see me!"
#       end
#
#       def edit
#         render plain: "I'm only accessible if you know the password"
#       end
#     end
#
# ### Advanced Basic example
#
# Here is a more advanced Basic example where only Atom feeds and the XML API
# are protected by HTTP authentication. The regular HTML interface is protected
# by a session approach:
#
#     class ApplicationController < ActionController::Base
#       before_action :set_account, :authenticate
#
#       private
#         def set_account
#           @account = Account.find_by(url_name: request.subdomains.first)
#         end
#
#         def authenticate
#           case request.format
#           when Mime[:xml], Mime[:atom]
#             if user = authenticate_with_http_basic { |u, p| @account.users.authenticate(u, p) }
#               @current_user = user
#             else
#               request_http_basic_authentication
#             end
#           else
#             if session_authenticated?
#               @current_user = @account.users.find(session[:authenticated][:user_id])
#             else
#               redirect_to(login_url) and return false
#             end
#           end
#         end
#     end
#
# In your integration tests, you can do something like this:
#
#     def test_access_granted_from_xml
#       authorization = ActionController::HttpAuthentication::Basic.encode_credentials(users(:dhh).name, users(:dhh).password)
#
#       get "/notes/1.xml", headers: { 'HTTP_AUTHORIZATION' => authorization }
#
#       assert_equal 200, status
#     end
#
# source://actionpack//lib/action_controller/metal/http_authentication.rb#69
module ActionController::HttpAuthentication::Basic
  extend ::ActionController::HttpAuthentication::Basic

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#130
  def auth_param(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#126
  def auth_scheme(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#108
  def authenticate(request, &login_procedure); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#138
  def authentication_request(controller, realm, message); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#122
  def decode_credentials(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#134
  def encode_credentials(user_name, password); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#114
  def has_basic_credentials?(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#118
  def user_name_and_password(request); end
end

# source://actionpack//lib/action_controller/metal/http_authentication.rb#72
module ActionController::HttpAuthentication::Basic::ControllerMethods
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::HttpAuthentication::Basic::ControllerMethods::ClassMethods

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#95
  def authenticate_or_request_with_http_basic(realm = T.unsafe(nil), message = T.unsafe(nil), &login_procedure); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#99
  def authenticate_with_http_basic(&login_procedure); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#86
  def http_basic_authenticate_or_request_with(name:, password:, realm: T.unsafe(nil), message: T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#103
  def request_http_basic_authentication(realm = T.unsafe(nil), message = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/http_authentication.rb#75
module ActionController::HttpAuthentication::Basic::ControllerMethods::ClassMethods
  # Enables HTTP Basic authentication.
  #
  # See ActionController::HttpAuthentication::Basic for example usage.
  #
  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#79
  def http_basic_authenticate_with(name:, password:, realm: T.unsafe(nil), **options); end
end

# # HTTP Digest authentication
#
# ### Simple Digest example
#
#     require "openssl"
#     class PostsController < ApplicationController
#       REALM = "SuperSecret"
#       USERS = {"dhh" => "secret", #plain text password
#                "dap" => OpenSSL::Digest::MD5.hexdigest(["dap",REALM,"secret"].join(":"))}  #ha1 digest password
#
#       before_action :authenticate, except: [:index]
#
#       def index
#         render plain: "Everyone can see me!"
#       end
#
#       def edit
#         render plain: "I'm only accessible if you know the password"
#       end
#
#       private
#         def authenticate
#           authenticate_or_request_with_http_digest(REALM) do |username|
#             USERS[username]
#           end
#         end
#     end
#
# ### Notes
#
# The `authenticate_or_request_with_http_digest` block must return the user's
# password or the ha1 digest hash so the framework can appropriately hash to
# check the user's credentials. Returning `nil` will cause authentication to
# fail.
#
# Storing the ha1 hash: MD5(username:realm:password), is better than storing a
# plain password. If the password file or database is compromised, the attacker
# would be able to use the ha1 hash to authenticate as the user at this `realm`,
# but would not have the user's password to try using at other sites.
#
# In rare instances, web servers or front proxies strip authorization headers
# before they reach your application. You can debug this situation by logging
# all environment variables, and check for HTTP_AUTHORIZATION, amongst others.
#
# source://actionpack//lib/action_controller/metal/http_authentication.rb#189
module ActionController::HttpAuthentication::Digest
  extend ::ActionController::HttpAuthentication::Digest

  # Returns false on a valid response, true otherwise.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#215
  def authenticate(request, realm, &password_procedure); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#274
  def authentication_header(controller, realm); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#281
  def authentication_request(controller, realm, message = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#267
  def decode_credentials(header); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#263
  def decode_credentials_header(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#258
  def encode_credentials(http_method, credentials, password, password_is_ha1); end

  # Returns the expected response for a request of `http_method` to `uri` with the
  # decoded `credentials` and the expected `password` Optional parameter
  # `password_is_ha1` is set to `true` by default, since best practice is to store
  # ha1 digest instead of a plain-text password.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#248
  def expected_response(http_method, uri, credentials, password, password_is_ha1 = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#254
  def ha1(credentials, password); end

  # Uses an MD5 digest based on time to generate a value to be used only once.
  #
  # A server-specified data string which should be uniquely generated each time a
  # 401 response is made. It is recommended that this string be base64 or
  # hexadecimal data. Specifically, since the string is passed in the header lines
  # as a quoted string, the double-quote character is not allowed.
  #
  # The contents of the nonce are implementation dependent. The quality of the
  # implementation depends on a good choice. A nonce might, for example, be
  # constructed as the base 64 encoding of
  #
  #     time-stamp H(time-stamp ":" ETag ":" private-key)
  #
  # where time-stamp is a server-generated time or other non-repeating value, ETag
  # is the value of the HTTP ETag header associated with the requested entity, and
  # private-key is data known only to the server. With a nonce of this form a
  # server would recalculate the hash portion after receiving the client
  # authentication header and reject the request if it did not match the nonce
  # from that header or if the time-stamp value is not recent enough. In this way
  # the server can limit the time of the nonce's validity. The inclusion of the
  # ETag prevents a replay request for an updated version of the resource. (Note:
  # including the IP address of the client in the nonce would appear to offer the
  # server the ability to limit the reuse of the nonce to the same client that
  # originally got it. However, that would break proxy farms, where requests from
  # a single user often go through different proxies in the farm. Also, IP address
  # spoofing is not that hard.)
  #
  # An implementation might choose not to accept a previously used nonce or a
  # previously used digest, in order to protect against a replay attack. Or, an
  # implementation might choose to use one-time nonces or digests for POST, PUT,
  # or PATCH requests, and a time-stamp for GET requests. For more details on the
  # issues involved see Section 4 of this document.
  #
  # The nonce is opaque to the client. Composed of Time, and hash of Time with
  # secret key from the Rails session secret generated upon creation of project.
  # Ensures the time cannot be modified by client.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#330
  def nonce(secret_key, time = T.unsafe(nil)); end

  # Opaque based on digest of secret key
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#348
  def opaque(secret_key); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#288
  def secret_token(request); end

  # Returns false unless the request credentials response value matches the
  # expected value. First try the password as a ha1 digest password. If this
  # fails, then try it as a plain text password.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#222
  def validate_digest_response(request, realm, &password_procedure); end

  # Might want a shorter timeout depending on whether the request is a PATCH, PUT,
  # or POST, and if the client is a browser or web service. Can be much shorter if
  # the Stale directive is implemented. This would allow a user to use new nonce
  # without prompting the user again for their username and password.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#341
  def validate_nonce(secret_key, request, value, seconds_to_timeout = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/http_authentication.rb#192
module ActionController::HttpAuthentication::Digest::ControllerMethods
  # Authenticate using an HTTP Digest, or otherwise render an HTTP header
  # requesting the client to send a Digest.
  #
  # See ActionController::HttpAuthentication::Digest for example usage.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#197
  def authenticate_or_request_with_http_digest(realm = T.unsafe(nil), message = T.unsafe(nil), &password_procedure); end

  # Authenticate using an HTTP Digest. Returns true if authentication is
  # successful, false otherwise.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#203
  def authenticate_with_http_digest(realm = T.unsafe(nil), &password_procedure); end

  # Render an HTTP header requesting the client to send a Digest for
  # authentication.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#209
  def request_http_digest_authentication(realm = T.unsafe(nil), message = T.unsafe(nil)); end
end

# # HTTP Token authentication
#
# ### Simple Token example
#
#     class PostsController < ApplicationController
#       TOKEN = "secret"
#
#       before_action :authenticate, except: [ :index ]
#
#       def index
#         render plain: "Everyone can see me!"
#       end
#
#       def edit
#         render plain: "I'm only accessible if you know the password"
#       end
#
#       private
#         def authenticate
#           authenticate_or_request_with_http_token do |token, options|
#             # Compare the tokens in a time-constant manner, to mitigate
#             # timing attacks.
#             ActiveSupport::SecurityUtils.secure_compare(token, TOKEN)
#           end
#         end
#     end
#
# Here is a more advanced Token example where only Atom feeds and the XML API
# are protected by HTTP token authentication. The regular HTML interface is
# protected by a session approach:
#
#     class ApplicationController < ActionController::Base
#       before_action :set_account, :authenticate
#
#       private
#         def set_account
#           @account = Account.find_by(url_name: request.subdomains.first)
#         end
#
#         def authenticate
#           case request.format
#           when Mime[:xml], Mime[:atom]
#             if user = authenticate_with_http_token { |t, o| @account.users.authenticate(t, o) }
#               @current_user = user
#             else
#               request_http_token_authentication
#             end
#           else
#             if session_authenticated?
#               @current_user = @account.users.find(session[:authenticated][:user_id])
#             else
#               redirect_to(login_url) and return false
#             end
#           end
#         end
#     end
#
# In your integration tests, you can do something like this:
#
#     def test_access_granted_from_xml
#       authorization = ActionController::HttpAuthentication::Token.encode_credentials(users(:dhh).token)
#
#       get "/notes/1.xml", headers: { 'HTTP_AUTHORIZATION' => authorization }
#
#       assert_equal 200, status
#     end
#
# On shared hosts, Apache sometimes doesn't pass authentication headers to FCGI
# instances. If your environment matches this description and you cannot
# authenticate, try this rule in your Apache setup:
#
#     RewriteRule ^(.*)$ dispatch.fcgi [E=X-HTTP_AUTHORIZATION:%{HTTP:Authorization},QSA,L]
#
# source://actionpack//lib/action_controller/metal/http_authentication.rb#425
module ActionController::HttpAuthentication::Token
  extend ::ActionController::HttpAuthentication::Token

  # If token Authorization header is present, call the login procedure with the
  # present token and options.
  #
  # Returns the return value of `login_procedure` if a token is found. Returns
  # `nil` if no token is found.
  #
  # #### Parameters
  #
  # *   `controller` - ActionController::Base instance for the current request.
  # *   `login_procedure` - Proc to call if a token is present. The Proc should
  #     take two arguments:
  #
  #         authenticate(controller) { |token, options| ... }
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#472
  def authenticate(controller, &login_procedure); end

  # Sets a WWW-Authenticate header to let the client know a token is desired.
  #
  # Returns nothing.
  #
  # #### Parameters
  #
  # *   `controller` - ActionController::Base instance for the outgoing response.
  # *   `realm` - String realm to use in the header.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#558
  def authentication_request(controller, realm, message = T.unsafe(nil)); end

  # Encodes the given token and options into an Authorization header value.
  #
  # Returns String.
  #
  # #### Parameters
  #
  # *   `token` - String token.
  # *   `options` - Optional Hash of the options.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#542
  def encode_credentials(token, options = T.unsafe(nil)); end

  # Takes `raw_params` and turns it into an array of parameters.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#507
  def params_array_from(raw_params); end

  # This method takes an authorization body and splits up the key-value pairs by
  # the standardized `:`, `;`, or `\t` delimiters defined in
  # `AUTHN_PAIR_DELIMITERS`.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#522
  def raw_params(auth); end

  # This removes the `"` characters wrapping the value.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#512
  def rewrite_param_values(array_params); end

  # Parses the token and options out of the token Authorization header. The value
  # for the Authorization header is expected to have the prefix `"Token"` or
  # `"Bearer"`. If the header looks like this:
  #
  #     Authorization: Token token="abc", nonce="def"
  #
  # Then the returned token is `"abc"`, and the options are `{nonce: "def"}`.
  #
  # Returns an `Array` of `[String, Hash]` if a token is present. Returns `nil` if
  # no token is found.
  #
  # #### Parameters
  #
  # *   `request` - ActionDispatch::Request instance with the current headers.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#494
  def token_and_options(request); end

  # source://actionpack//lib/action_controller/metal/http_authentication.rb#502
  def token_params_from(auth); end
end

# source://actionpack//lib/action_controller/metal/http_authentication.rb#428
ActionController::HttpAuthentication::Token::AUTHN_PAIR_DELIMITERS = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_controller/metal/http_authentication.rb#431
module ActionController::HttpAuthentication::Token::ControllerMethods
  # Authenticate using an HTTP Bearer token, or otherwise render an HTTP header
  # requesting the client to send a Bearer token. For the authentication to be
  # considered successful, `login_procedure` should return a non-nil value.
  # Typically, the authenticated user is returned.
  #
  # See ActionController::HttpAuthentication::Token for example usage.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#438
  def authenticate_or_request_with_http_token(realm = T.unsafe(nil), message = T.unsafe(nil), &login_procedure); end

  # Authenticate using an HTTP Bearer token. Returns the return value of
  # `login_procedure` if a token is found. Returns `nil` if no token is found.
  #
  # See ActionController::HttpAuthentication::Token for example usage.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#446
  def authenticate_with_http_token(&login_procedure); end

  # Render an HTTP header requesting the client to send a Bearer token for
  # authentication.
  #
  # source://actionpack//lib/action_controller/metal/http_authentication.rb#452
  def request_http_token_authentication(realm = T.unsafe(nil), message = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/http_authentication.rb#426
ActionController::HttpAuthentication::Token::TOKEN_KEY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/http_authentication.rb#427
ActionController::HttpAuthentication::Token::TOKEN_REGEX = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_controller/metal/http_authentication.rb#516
ActionController::HttpAuthentication::Token::WHITESPACED_AUTHN_PAIR_DELIMITERS = T.let(T.unsafe(nil), Regexp)

# # Action Controller Implicit Render
#
# Handles implicit rendering for a controller action that does not explicitly
# respond with `render`, `respond_to`, `redirect`, or `head`.
#
# For API controllers, the implicit response is always `204 No Content`.
#
# For all other controllers, we use these heuristics to decide whether to render
# a template, raise an error for a missing template, or respond with `204 No
# Content`:
#
# First, if we DO find a template, it's rendered. Template lookup accounts for
# the action name, locales, format, variant, template handlers, and more (see
# `render` for details).
#
# Second, if we DON'T find a template but the controller action does have
# templates for other formats, variants, etc., then we trust that you meant to
# provide a template for this response, too, and we raise
# ActionController::UnknownFormat with an explanation.
#
# Third, if we DON'T find a template AND the request is a page load in a web
# browser (technically, a non-XHR GET request for an HTML response) where you
# reasonably expect to have rendered a template, then we raise
# ActionController::MissingExactTemplate with an explanation.
#
# Finally, if we DON'T find a template AND the request isn't a browser page
# load, then we implicitly respond with `204 No Content`.
#
# source://actionpack//lib/action_controller/metal/implicit_render.rb#33
module ActionController::ImplicitRender
  include ::ActionController::BasicImplicitRender

  # source://actionpack//lib/action_controller/metal/implicit_render.rb#37
  def default_render; end

  # source://actionpack//lib/action_controller/metal/implicit_render.rb#56
  def method_for_action(action_name); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/implicit_render.rb#63
  def interactive_browser_request?; end
end

# # Action Controller Instrumentation
#
# Adds instrumentation to several ends in ActionController::Base. It also
# provides some hooks related with process_action. This allows an ORM like
# Active Record and/or DataMapper to plug in ActionController and show related
# information.
#
# Check ActiveRecord::Railties::ControllerRuntime for an example.
#
# source://actionpack//lib/action_controller/metal/instrumentation.rb#17
module ActionController::Instrumentation
  extend ::ActiveSupport::Concern
  include ::ActiveSupport::Benchmarkable
  include ::AbstractController::Logger

  mixes_in_class_methods ::ActionController::Instrumentation::ClassMethods

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#24
  def initialize(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#50
  def redirect_to(*_arg0); end

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#29
  def render(*_arg0); end

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#44
  def send_data(data, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#37
  def send_file(path, options = T.unsafe(nil)); end

  def view_runtime; end
  def view_runtime=(_arg0); end

  private

  # Every time after an action is processed, this method is invoked with the
  # payload, so you can add more information.
  #
  # source://actionpack//lib/action_controller/metal/instrumentation.rb#106
  def append_info_to_payload(payload); end

  # A hook which allows you to clean up any time, wrongly taken into account in
  # views, like database querying time.
  #
  #     def cleanup_view_runtime
  #       super - time_taken_in_something_expensive
  #     end
  #
  # source://actionpack//lib/action_controller/metal/instrumentation.rb#100
  def cleanup_view_runtime; end

  # A hook invoked every time a before callback is halted.
  #
  # source://actionpack//lib/action_controller/metal/instrumentation.rb#90
  def halted_callback_hook(filter, _); end

  # source://actionpack//lib/action_controller/metal/instrumentation.rb#60
  def process_action(*_arg0); end
end

# source://actionpack//lib/action_controller/metal/instrumentation.rb#110
module ActionController::Instrumentation::ClassMethods
  # A hook which allows other frameworks to log what happened during controller
  # process action. This method should return an array with the messages to be
  # added.
  #
  # source://actionpack//lib/action_controller/metal/instrumentation.rb#114
  def log_process_action(payload); end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#10
class ActionController::InvalidAuthenticityToken < ::ActionController::ActionControllerError; end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#13
class ActionController::InvalidCrossOriginRequest < ::ActionController::ActionControllerError; end

# Raised when initializing Parameters with keys that aren't strings or symbols.
#
#     ActionController::Parameters.new(123 => 456)
#     # => ActionController::InvalidParameterKey: all keys must be Strings or Symbols, got: Integer
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#74
class ActionController::InvalidParameterKey < ::ArgumentError; end

# # Action Controller Live
#
# Mix this module into your controller, and all actions in that controller will
# be able to stream data to the client as it's written.
#
#     class MyController < ActionController::Base
#       include ActionController::Live
#
#       def stream
#         response.headers['Content-Type'] = 'text/event-stream'
#         100.times {
#           response.stream.write "hello world\n"
#           sleep 1
#         }
#       ensure
#         response.stream.close
#       end
#     end
#
# There are a few caveats with this module. You **cannot** write headers after
# the response has been committed (Response#committed? will return truthy).
# Calling `write` or `close` on the response stream will cause the response
# object to be committed. Make sure all headers are set before calling write or
# close on your stream.
#
# You **must** call close on your stream when you're finished, otherwise the
# socket may be left open forever.
#
# The final caveat is that your actions are executed in a separate thread than
# the main thread. Make sure your actions are thread safe, and this shouldn't be
# a problem (don't share state across threads, etc).
#
# Note that Rails includes `Rack::ETag` by default, which will buffer your
# response. As a result, streaming responses may not work properly with Rack
# 2.2.x, and you may need to implement workarounds in your application. You can
# either set the `ETag` or `Last-Modified` response headers or remove
# `Rack::ETag` from the middleware stack to address this issue.
#
# Here's an example of how you can set the `Last-Modified` header if your Rack
# version is 2.2.x:
#
#     def stream
#       response.headers["Content-Type"] = "text/event-stream"
#       response.headers["Last-Modified"] = Time.now.httpdate # Add this line if your Rack version is 2.2.x
#       ...
#     end
#
# source://actionpack//lib/action_controller/metal/live.rb#56
module ActionController::Live
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::Live::ClassMethods

  # source://actionpack//lib/action_controller/test_case.rb#26
  def new_controller_thread; end

  # source://actionpack//lib/action_controller/metal/live.rb#273
  def process(name); end

  # source://actionpack//lib/action_controller/metal/live.rb#319
  def response_body=(body); end

  # Sends a stream to the browser, which is helpful when you're generating exports
  # or other running data where you don't want the entire file buffered in memory
  # first. Similar to send_data, but where the data is generated live.
  #
  # Options:
  # *   `:filename` - suggests a filename for the browser to use.
  # *   `:type` - specifies an HTTP content type. You can specify either a string
  #     or a symbol for a registered type with `Mime::Type.register`, for example
  #     :json. If omitted, type will be inferred from the file extension specified
  #     in `:filename`. If no content type is registered for the extension, the
  #     default type 'application/octet-stream' will be used.
  # *   `:disposition` - specifies whether the file will be shown inline or
  #     downloaded. Valid values are 'inline' and 'attachment' (default).
  #
  #
  # Example of generating a csv export:
  #
  #     send_stream(filename: "subscribers.csv") do |stream|
  #       stream.write "email_address,updated_at\n"
  #
  #       @subscribers.find_each do |subscriber|
  #         stream.write "#{subscriber.email_address},#{subscriber.updated_at}\n"
  #       end
  #     end
  #
  # source://actionpack//lib/action_controller/metal/live.rb#348
  def send_stream(filename:, disposition: T.unsafe(nil), type: T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_controller/metal/live.rb#378
  def log_error(exception); end
end

# source://actionpack//lib/action_controller/metal/live.rb#148
class ActionController::Live::Buffer < ::ActionDispatch::Response::Buffer
  include ::MonitorMixin

  # @return [Buffer] a new instance of Buffer
  #
  # source://actionpack//lib/action_controller/metal/live.rb#163
  def initialize(response); end

  # Inform the producer/writing thread that the client has disconnected; the
  # reading thread is no longer interested in anything that's being written.
  #
  # See also #close.
  #
  # source://actionpack//lib/action_controller/metal/live.rb#217
  def abort; end

  # source://actionpack//lib/action_controller/metal/live.rb#236
  def call_on_error; end

  # Write a 'close' event to the buffer; the producer/writing thread uses this to
  # notify us that it's finished supplying content.
  #
  # See also #abort.
  #
  # source://actionpack//lib/action_controller/metal/live.rb#205
  def close; end

  # Is the client still connected and waiting for content?
  #
  # The result of calling `write` when this is `false` is determined by
  # `ignore_disconnect`.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/live.rb#228
  def connected?; end

  # Ignore that the client has disconnected.
  #
  # If this value is `true`, calling `write` after the client disconnects will
  # result in the written content being silently discarded. If this value is
  # `false` (the default), a ClientDisconnected exception will be raised.
  #
  # source://actionpack//lib/action_controller/metal/live.rb#161
  def ignore_disconnect; end

  # Ignore that the client has disconnected.
  #
  # If this value is `true`, calling `write` after the client disconnects will
  # result in the written content being silently discarded. If this value is
  # `false` (the default), a ClientDisconnected exception will be raised.
  #
  # source://actionpack//lib/action_controller/metal/live.rb#161
  def ignore_disconnect=(_arg0); end

  # source://actionpack//lib/action_controller/metal/live.rb#232
  def on_error(&block); end

  # source://actionpack//lib/action_controller/metal/live.rb#177
  def write(string); end

  # Same as `write` but automatically include a newline at the end of the string.
  #
  # source://actionpack//lib/action_controller/metal/live.rb#197
  def writeln(string); end

  private

  # source://actionpack//lib/action_controller/metal/live.rb#252
  def build_queue(queue_size); end

  # source://actionpack//lib/action_controller/metal/live.rb#241
  def each_chunk(&block); end

  class << self
    # Returns the value of attribute queue_size.
    #
    # source://actionpack//lib/action_controller/metal/live.rb#152
    def queue_size; end

    # Sets the attribute queue_size
    #
    # @param value the value to set the attribute queue_size to.
    #
    # source://actionpack//lib/action_controller/metal/live.rb#152
    def queue_size=(_arg0); end
  end
end

# source://actionpack//lib/action_controller/metal/live.rb#59
module ActionController::Live::ClassMethods
  # source://actionpack//lib/action_controller/metal/live.rb#60
  def make_response!(request); end
end

# source://actionpack//lib/action_controller/metal/live.rb#145
class ActionController::Live::ClientDisconnected < ::RuntimeError; end

# source://actionpack//lib/action_controller/metal/live.rb#257
class ActionController::Live::Response < ::ActionDispatch::Response
  private

  # source://actionpack//lib/action_controller/metal/live.rb#259
  def before_committed; end

  # source://actionpack//lib/action_controller/metal/live.rb#266
  def build_buffer(response, body); end
end

# # Action Controller Live Server Sent Events
#
# This class provides the ability to write an SSE (Server Sent Event) to an IO
# stream. The class is initialized with a stream and can be used to either write
# a JSON string or an object which can be converted to JSON.
#
# Writing an object will convert it into standard SSE format with whatever
# options you have configured. You may choose to set the following options:
#
#     1) Event. If specified, an event with this name will be dispatched on
#     the browser.
#     2) Retry. The reconnection time in milliseconds used when attempting
#     to send the event.
#     3) Id. If the connection dies while sending an SSE to the browser, then
#     the server will receive a +Last-Event-ID+ header with value equal to +id+.
#
# After setting an option in the constructor of the SSE object, all future SSEs
# sent across the stream will use those options unless overridden.
#
# Example Usage:
#
#     class MyController < ActionController::Base
#       include ActionController::Live
#
#       def index
#         response.headers['Content-Type'] = 'text/event-stream'
#         sse = SSE.new(response.stream, retry: 300, event: "event-name")
#         sse.write({ name: 'John'})
#         sse.write({ name: 'John'}, id: 10)
#         sse.write({ name: 'John'}, id: 10, event: "other-event")
#         sse.write({ name: 'John'}, id: 10, event: "other-event", retry: 500)
#       ensure
#         sse.close
#       end
#     end
#
# Note: SSEs are not currently supported by IE. However, they are supported by
# Chrome, Firefox, Opera, and Safari.
#
# source://actionpack//lib/action_controller/metal/live.rb#109
class ActionController::Live::SSE
  # @return [SSE] a new instance of SSE
  #
  # source://actionpack//lib/action_controller/metal/live.rb#112
  def initialize(stream, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/live.rb#117
  def close; end

  # source://actionpack//lib/action_controller/metal/live.rb#121
  def write(object, options = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_controller/metal/live.rb#131
  def perform_write(json, options); end
end

# source://actionpack//lib/action_controller/metal/live.rb#110
ActionController::Live::SSE::PERMITTED_OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/test_case.rb#174
class ActionController::LiveTestResponse < ::ActionController::Live::Response
  # Was there a server-side error?
  #
  # source://rack/3.1.7/lib/rack/response.rb#187
  def error?; end

  # Was the URL not found?
  #
  # source://rack/3.1.7/lib/rack/response.rb#197
  def missing?; end

  # Was the response successful?
  #
  # source://rack/3.1.7/lib/rack/response.rb#184
  def success?; end
end

# source://actionpack//lib/action_controller/log_subscriber.rb#6
class ActionController::LogSubscriber < ::ActiveSupport::LogSubscriber
  # source://actionpack//lib/action_controller/log_subscriber.rb#80
  def exist_fragment?(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#80
  def expire_fragment(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#47
  def halted_callback(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#90
  def logger; end

  # source://actionpack//lib/action_controller/log_subscriber.rb#26
  def process_action(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#80
  def read_fragment(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#57
  def redirect_to(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#62
  def send_data(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#52
  def send_file(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#9
  def start_processing(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#67
  def unpermitted_parameters(event); end

  # source://actionpack//lib/action_controller/log_subscriber.rb#80
  def write_fragment(event); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/log_subscriber.rb#84
    def log_levels; end
  end
end

# source://actionpack//lib/action_controller/log_subscriber.rb#7
ActionController::LogSubscriber::INTERNAL_PARAMS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/metal/logging.rb#6
module ActionController::Logging
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::Logging::ClassMethods
end

# source://actionpack//lib/action_controller/metal/logging.rb#9
module ActionController::Logging::ClassMethods
  # Set a different log level per request.
  #
  #     # Use the debug log level if a particular cookie is set.
  #     class ApplicationController < ActionController::Base
  #       log_at :debug, if: -> { cookies[:debug] }
  #     end
  #
  # source://actionpack//lib/action_controller/metal/logging.rb#17
  def log_at(level, **options); end
end

# # Action Controller Metal
#
# `ActionController::Metal` is the simplest possible controller, providing a
# valid Rack interface without the additional niceties provided by
# ActionController::Base.
#
# A sample metal controller might look like this:
#
#     class HelloController < ActionController::Metal
#       def index
#         self.response_body = "Hello World!"
#       end
#     end
#
# And then to route requests to your metal controller, you would add something
# like this to `config/routes.rb`:
#
#     get 'hello', to: HelloController.action(:index)
#
# The ::action method returns a valid Rack application for the Rails router to
# dispatch to.
#
# ## Rendering Helpers
#
# By default, `ActionController::Metal` provides no utilities for rendering
# views, partials, or other responses aside from some low-level setters such
# as #response_body=, #content_type=, and #status=. To add the render helpers
# you're used to having in a normal controller, you can do the following:
#
#     class HelloController < ActionController::Metal
#       include AbstractController::Rendering
#       include ActionView::Layouts
#       append_view_path "#{Rails.root}/app/views"
#
#       def index
#         render "hello/index"
#       end
#     end
#
# ## Redirection Helpers
#
# To add redirection helpers to your metal controller, do the following:
#
#     class HelloController < ActionController::Metal
#       include ActionController::Redirecting
#       include Rails.application.routes.url_helpers
#
#       def index
#         redirect_to root_url
#       end
#     end
#
# ## Other Helpers
#
# You can refer to the modules included in ActionController::Base to see other
# features you can bring into your metal controller.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://actionpack//lib/action_controller/metal.rb#121
class ActionController::Metal < ::AbstractController::Base
  include ::ActionController::Testing::Functional

  # @return [Metal] a new instance of Metal
  #
  # source://actionpack//lib/action_controller/metal.rb#210
  def initialize; end

  # Delegates to ActionDispatch::Response#content_type
  #
  # source://actionpack//lib/action_controller/metal.rb#204
  def content_type(*_arg0, **_arg1, &_arg2); end

  # Delegates to ActionDispatch::Response#content_type=
  #
  # source://actionpack//lib/action_controller/metal.rb#192
  def content_type=(arg); end

  # Delegates to the class's ::controller_name.
  #
  # source://actionpack//lib/action_controller/metal.rb#156
  def controller_name; end

  # source://actionpack//lib/action_controller/metal.rb#249
  def dispatch(name, request, response); end

  # Delegates to ActionDispatch::Response#headers.
  #
  # source://actionpack//lib/action_controller/metal.rb#180
  def headers(*_arg0, **_arg1, &_arg2); end

  # Delegates to ActionDispatch::Response#location
  #
  # source://actionpack//lib/action_controller/metal.rb#200
  def location(*_arg0, **_arg1, &_arg2); end

  # Delegates to ActionDispatch::Response#location=
  #
  # source://actionpack//lib/action_controller/metal.rb#188
  def location=(arg); end

  # Delegates to ActionDispatch::Response#media_type
  #
  # source://actionpack//lib/action_controller/metal.rb#208
  def media_type(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal.rb#288
  def middleware_stack; end

  # source://actionpack//lib/action_controller/metal.rb#288
  def middleware_stack=(_arg0); end

  # source://actionpack//lib/action_controller/metal.rb#288
  def middleware_stack?; end

  # source://actionpack//lib/action_controller/metal.rb#219
  def params; end

  # source://actionpack//lib/action_controller/metal.rb#223
  def params=(val); end

  # Tests if render or redirect has already happened.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal.rb#245
  def performed?; end

  # :attr_reader: request
  #
  # The ActionDispatch::Request instance for the current request.
  #
  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def request; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def request=(_arg0); end

  # source://actionpack//lib/action_controller/metal.rb#284
  def reset_session; end

  # :attr_reader: response
  #
  # The ActionDispatch::Response instance for the current response.
  #
  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attr_internal.rb#44
  def response; end

  # Assign the response and mark it as committed. No further processing will
  # occur.
  #
  # source://actionpack//lib/action_controller/metal.rb#268
  def response=(response); end

  # source://actionpack//lib/action_controller/metal.rb#234
  def response_body=(body); end

  # Delegates to ActionDispatch::Response#status
  #
  # source://actionpack//lib/action_controller/metal.rb#196
  def response_code(*_arg0, **_arg1, &_arg2); end

  # The ActionDispatch::Request::Session instance for the current request.
  # See further details in the
  # [Active Controller Session guide](https://guides.rubyonrails.org/action_controller_overview.html#session).
  #
  # source://actionpack//lib/action_controller/metal.rb#176
  def session(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal.rb#275
  def set_request!(request); end

  # source://actionpack//lib/action_controller/metal.rb#257
  def set_response!(response); end

  # Delegates to ActionDispatch::Response#status
  #
  # source://actionpack//lib/action_controller/metal.rb#196
  def status(*_arg0, **_arg1, &_arg2); end

  # Delegates to ActionDispatch::Response#status=
  #
  # source://actionpack//lib/action_controller/metal.rb#184
  def status=(arg); end

  # source://actionpack//lib/action_controller/metal.rb#280
  def to_a; end

  # Basic `url_for` that can be overridden for more robust functionality.
  #
  # source://actionpack//lib/action_controller/metal.rb#230
  def url_for(string); end

  class << self
    # Returns a Rack endpoint for the given action name.
    #
    # source://actionpack//lib/action_controller/metal.rb#315
    def action(name); end

    # source://actionpack//lib/action_controller/metal.rb#140
    def action_encoding_template(action); end

    # Returns the last part of the controller's name, underscored, without the
    # ending `Controller`. For instance, `PostsController` returns `posts`.
    # Namespaces are left out, so `Admin::PostsController` returns `posts` as well.
    #
    # #### Returns
    # *   `string`
    #
    # source://actionpack//lib/action_controller/metal.rb#130
    def controller_name; end

    # Direct dispatch to the controller. Instantiates the controller, then executes
    # the action named `name`.
    #
    # source://actionpack//lib/action_controller/metal.rb#331
    def dispatch(name, req, res); end

    # source://actionpack//lib/action_controller/metal.rb#134
    def make_response!(request); end

    # The middleware stack used by this controller.
    #
    # By default uses a variation of ActionDispatch::MiddlewareStack which allows
    # for the following syntax:
    #
    #     class PostsController < ApplicationController
    #       use AuthenticationMiddleware, except: [:index, :show]
    #     end
    #
    # Read more about [Rails middleware stack]
    # (https://guides.rubyonrails.org/rails_on_rack.html#action-dispatcher-middleware-stack)
    # in the guides.
    #
    # source://actionpack//lib/action_controller/metal.rb#310
    def middleware; end

    # source://actionpack//lib/action_controller/metal.rb#288
    def middleware_stack; end

    # source://actionpack//lib/action_controller/metal.rb#288
    def middleware_stack=(value); end

    # source://actionpack//lib/action_controller/metal.rb#288
    def middleware_stack?; end

    # Pushes the given Rack middleware and its arguments to the bottom of the
    # middleware stack.
    #
    # source://actionpack//lib/action_controller/metal.rb#293
    def use(*_arg0, **_arg1, &_arg2); end

    private

    # @private
    #
    # source://actionpack//lib/action_controller/metal.rb#146
    def inherited(subclass); end
  end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#52
class ActionController::MethodNotAllowed < ::ActionController::ActionControllerError
  # @return [MethodNotAllowed] a new instance of MethodNotAllowed
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#53
  def initialize(*allowed_methods); end
end

# # Action Controller MiddlewareStack
#
# Extend ActionDispatch middleware stack to make it aware of options allowing
# the following syntax in controllers:
#
#     class PostsController < ApplicationController
#       use AuthenticationMiddleware, except: [:index, :show]
#     end
#
# source://actionpack//lib/action_controller/metal.rb#18
class ActionController::MiddlewareStack < ::ActionDispatch::MiddlewareStack
  # source://actionpack//lib/action_controller/metal.rb#31
  def build(action, app = T.unsafe(nil), &block); end

  private

  # source://actionpack//lib/action_controller/metal.rb#44
  def build_middleware(klass, args, block); end
end

# source://actionpack//lib/action_controller/metal.rb#41
ActionController::MiddlewareStack::EXCLUDE = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_controller/metal.rb#40
ActionController::MiddlewareStack::INCLUDE = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_controller/metal.rb#19
class ActionController::MiddlewareStack::Middleware < ::ActionDispatch::MiddlewareStack::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://actionpack//lib/action_controller/metal.rb#20
  def initialize(klass, args, actions, strategy, block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal.rb#26
  def valid?(action); end
end

# source://actionpack//lib/action_controller/metal.rb#42
ActionController::MiddlewareStack::NULL = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_controller/metal/mime_responds.rb#8
module ActionController::MimeResponds
  # Without web-service support, an action which collects the data for displaying
  # a list of people might look something like this:
  #
  #     def index
  #       @people = Person.all
  #     end
  #
  # That action implicitly responds to all formats, but formats can also be
  # explicitly enumerated:
  #
  #     def index
  #       @people = Person.all
  #       respond_to :html, :js
  #     end
  #
  # Here's the same action, with web-service support baked in:
  #
  #     def index
  #       @people = Person.all
  #
  #       respond_to do |format|
  #         format.html
  #         format.js
  #         format.xml { render xml: @people }
  #       end
  #     end
  #
  # What that says is, "if the client wants HTML or JS in response to this action,
  # just respond as we would have before, but if the client wants XML, return them
  # the list of people in XML format." (Rails determines the desired response
  # format from the HTTP Accept header submitted by the client.)
  #
  # Supposing you have an action that adds a new person, optionally creating their
  # company (by name) if it does not already exist, without web-services, it might
  # look like this:
  #
  #     def create
  #       @company = Company.find_or_create_by(name: params[:company][:name])
  #       @person  = @company.people.create(params[:person])
  #
  #       redirect_to(person_list_url)
  #     end
  #
  # Here's the same action, with web-service support baked in:
  #
  #     def create
  #       company  = params[:person].delete(:company)
  #       @company = Company.find_or_create_by(name: company[:name])
  #       @person  = @company.people.create(params[:person])
  #
  #       respond_to do |format|
  #         format.html { redirect_to(person_list_url) }
  #         format.js
  #         format.xml  { render xml: @person.to_xml(include: @company) }
  #       end
  #     end
  #
  # If the client wants HTML, we just redirect them back to the person list. If
  # they want JavaScript, then it is an Ajax request and we render the JavaScript
  # template associated with this action. Lastly, if the client wants XML, we
  # render the created person as XML, but with a twist: we also include the
  # person's company in the rendered XML, so you get something like this:
  #
  #     <person>
  #       <id>...</id>
  #       ...
  #       <company>
  #         <id>...</id>
  #         <name>...</name>
  #         ...
  #       </company>
  #     </person>
  #
  # Note, however, the extra bit at the top of that action:
  #
  #     company  = params[:person].delete(:company)
  #     @company = Company.find_or_create_by(name: company[:name])
  #
  # This is because the incoming XML document (if a web-service request is in
  # process) can only contain a single root-node. So, we have to rearrange things
  # so that the request looks like this (url-encoded):
  #
  #     person[name]=...&person[company][name]=...&...
  #
  # And, like this (xml-encoded):
  #
  #     <person>
  #       <name>...</name>
  #       <company>
  #         <name>...</name>
  #       </company>
  #     </person>
  #
  # In other words, we make the request so that it operates on a single entity's
  # person. Then, in the action, we extract the company data from the request,
  # find or create the company, and then create the new person with the remaining
  # data.
  #
  # Note that you can define your own XML parameter parser which would allow you
  # to describe multiple entities in a single request (i.e., by wrapping them all
  # in a single root node), but if you just go with the flow and accept Rails'
  # defaults, life will be much easier.
  #
  # If you need to use a MIME type which isn't supported by default, you can
  # register your own handlers in `config/initializers/mime_types.rb` as follows.
  #
  #     Mime::Type.register "image/jpeg", :jpg
  #
  # `respond_to` also allows you to specify a common block for different formats
  # by using `any`:
  #
  #     def index
  #       @people = Person.all
  #
  #       respond_to do |format|
  #         format.html
  #         format.any(:xml, :json) { render request.format.to_sym => @people }
  #       end
  #     end
  #
  # In the example above, if the format is xml, it will render:
  #
  #     render xml: @people
  #
  # Or if the format is json:
  #
  #     render json: @people
  #
  # `any` can also be used with no arguments, in which case it will be used for
  # any format requested by the user:
  #
  #     respond_to do |format|
  #       format.html
  #       format.any { redirect_to support_path }
  #     end
  #
  # Formats can have different variants.
  #
  # The request variant is a specialization of the request format, like `:tablet`,
  # `:phone`, or `:desktop`.
  #
  # We often want to render different html/json/xml templates for phones, tablets,
  # and desktop browsers. Variants make it easy.
  #
  # You can set the variant in a `before_action`:
  #
  #     request.variant = :tablet if /iPad/.match?(request.user_agent)
  #
  # Respond to variants in the action just like you respond to formats:
  #
  #     respond_to do |format|
  #       format.html do |variant|
  #         variant.tablet # renders app/views/projects/show.html+tablet.erb
  #         variant.phone { extra_setup; render ... }
  #         variant.none  { special_setup } # executed only if there is no variant set
  #       end
  #     end
  #
  # Provide separate templates for each format and variant:
  #
  #     app/views/projects/show.html.erb
  #     app/views/projects/show.html+tablet.erb
  #     app/views/projects/show.html+phone.erb
  #
  # When you're not sharing any code within the format, you can simplify defining
  # variants using the inline syntax:
  #
  #     respond_to do |format|
  #       format.js         { render "trash" }
  #       format.html.phone { redirect_to progress_path }
  #       format.html.none  { render "trash" }
  #     end
  #
  # Variants also support common `any`/`all` block that formats have.
  #
  # It works for both inline:
  #
  #     respond_to do |format|
  #       format.html.any   { render html: "any"   }
  #       format.html.phone { render html: "phone" }
  #     end
  #
  # and block syntax:
  #
  #     respond_to do |format|
  #       format.html do |variant|
  #         variant.any(:tablet, :phablet){ render html: "any" }
  #         variant.phone { render html: "phone" }
  #       end
  #     end
  #
  # You can also set an array of variants:
  #
  #     request.variant = [:tablet, :phone]
  #
  # This will work similarly to formats and MIME types negotiation. If there is no
  # `:tablet` variant declared, the `:phone` variant will be used:
  #
  #     respond_to do |format|
  #       format.html.none
  #       format.html.phone # this gets rendered
  #     end
  #
  # @raise [ArgumentError]
  # @yield [collector]
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#211
  def respond_to(*mimes); end
end

# A container for responses available from the current controller for requests
# for different mime-types sent to a particular action.
#
# The public controller methods `respond_to` may be called with a block that is
# used to define responses to different mime-types, e.g. for `respond_to` :
#
#     respond_to do |format|
#       format.html
#       format.xml { render xml: @people }
#     end
#
# In this usage, the argument passed to the block (`format` above) is an
# instance of the ActionController::MimeResponds::Collector class. This object
# serves as a container in which available responses can be stored by calling
# any of the dynamically generated, mime-type-specific methods such as `html`,
# `xml` etc on the Collector. Each response is represented by a corresponding
# block if present.
#
# A subsequent call to #negotiate_format(request) will enable the Collector to
# determine which specific mime-type it should respond with for the current
# request, with this response then being accessible by calling #response.
#
# source://actionpack//lib/action_controller/metal/mime_responds.rb#251
class ActionController::MimeResponds::Collector
  include ::AbstractController::Collector

  # @return [Collector] a new instance of Collector
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#255
  def initialize(mimes, variant = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#262
  def all(*args, &block); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#262
  def any(*args, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#280
  def any_response?; end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#271
  def custom(mime_type, &block); end

  # Returns the value of attribute format.
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#253
  def format; end

  # Sets the attribute format
  #
  # @param value the value to set the attribute format to.
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#253
  def format=(_arg0); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#297
  def negotiate_format(request); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#284
  def response; end
end

# source://actionpack//lib/action_controller/metal/mime_responds.rb#301
class ActionController::MimeResponds::Collector::VariantCollector
  # @return [VariantCollector] a new instance of VariantCollector
  #
  # source://actionpack//lib/action_controller/metal/mime_responds.rb#302
  def initialize(variant = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#307
  def all(*args, &block); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#307
  def any(*args, &block); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#318
  def method_missing(name, *_arg1, &block); end

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#322
  def variant; end

  private

  # source://actionpack//lib/action_controller/metal/mime_responds.rb#331
  def variant_key; end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#96
class ActionController::MissingExactTemplate < ::ActionController::UnknownFormat
  # @return [MissingExactTemplate] a new instance of MissingExactTemplate
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#99
  def initialize(message, controller, action_name); end

  # Returns the value of attribute action_name.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#97
  def action_name; end

  # Returns the value of attribute controller.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#97
  def controller; end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#61
class ActionController::MissingFile < ::ActionController::ActionControllerError; end

# See `Responder#api_behavior`
#
# source://actionpack//lib/action_controller/metal/renderers.rb#19
class ActionController::MissingRenderer < ::LoadError
  # @return [MissingRenderer] a new instance of MissingRenderer
  #
  # source://actionpack//lib/action_controller/metal/renderers.rb#20
  def initialize(format); end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#58
class ActionController::NotImplemented < ::ActionController::MethodNotAllowed; end

# Specify binary encoding for parameters for a given action.
#
# source://actionpack//lib/action_controller/metal/parameter_encoding.rb#7
module ActionController::ParameterEncoding
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::ParameterEncoding::ClassMethods
end

# source://actionpack//lib/action_controller/metal/parameter_encoding.rb#10
module ActionController::ParameterEncoding::ClassMethods
  # source://actionpack//lib/action_controller/metal/parameter_encoding.rb#20
  def action_encoding_template(action); end

  # source://actionpack//lib/action_controller/metal/parameter_encoding.rb#11
  def inherited(klass); end

  # Specify the encoding for a parameter on an action. If not specified the
  # default is UTF-8.
  #
  # You can specify a binary (ASCII_8BIT) parameter with:
  #
  #     class RepositoryController < ActionController::Base
  #       # This specifies that file_path is not UTF-8 and is instead ASCII_8BIT
  #       param_encoding :show, :file_path, Encoding::ASCII_8BIT
  #
  #       def show
  #         @repo = Repository.find_by_filesystem_path params[:file_path]
  #
  #         # params[:repo_name] remains UTF-8 encoded
  #         @repo_name = params[:repo_name]
  #       end
  #
  #       def index
  #         @repositories = Repository.all
  #       end
  #     end
  #
  # The file_path parameter on the show action would be encoded as ASCII-8BIT, but
  # all other arguments will remain UTF-8 encoded. This is useful in the case
  # where an application must handle data but encoding of the data is unknown,
  # like file system data.
  #
  # source://actionpack//lib/action_controller/metal/parameter_encoding.rb#79
  def param_encoding(action, param, encoding); end

  # source://actionpack//lib/action_controller/metal/parameter_encoding.rb#16
  def setup_param_encode; end

  # Specify that a given action's parameters should all be encoded as ASCII-8BIT
  # (it "skips" the encoding default of UTF-8).
  #
  # For example, a controller would use it like this:
  #
  #     class RepositoryController < ActionController::Base
  #       skip_parameter_encoding :show
  #
  #       def show
  #         @repo = Repository.find_by_filesystem_path params[:file_path]
  #
  #         # `repo_name` is guaranteed to be UTF-8, but was ASCII-8BIT, so
  #         # tag it as such
  #         @repo_name = params[:repo_name].force_encoding 'UTF-8'
  #       end
  #
  #       def index
  #         @repositories = Repository.all
  #       end
  #     end
  #
  # The show action in the above controller would have all parameter values
  # encoded as ASCII-8BIT. This is useful in the case where an application must
  # handle data but encoding of the data is unknown, like file system data.
  #
  # source://actionpack//lib/action_controller/metal/parameter_encoding.rb#50
  def skip_parameter_encoding(action); end
end

# Raised when a required parameter is missing.
#
#     params = ActionController::Parameters.new(a: {})
#     params.fetch(:b)
#     # => ActionController::ParameterMissing: param is missing or the value is empty: b
#     params.require(:a)
#     # => ActionController::ParameterMissing: param is missing or the value is empty: a
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#24
class ActionController::ParameterMissing < ::KeyError
  # @return [ParameterMissing] a new instance of ParameterMissing
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#27
  def initialize(param, keys = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#36
  def corrections; end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#25
  def keys; end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#25
  def param; end
end

# # Action Controller Parameters
#
# Allows you to choose which attributes should be permitted for mass updating
# and thus prevent accidentally exposing that which shouldn't be exposed.
# Provides two methods for this purpose: #require and #permit. The former is
# used to mark parameters as required. The latter is used to set the parameter
# as permitted and limit which attributes should be allowed for mass updating.
#
#     params = ActionController::Parameters.new({
#       person: {
#         name: "Francesco",
#         age:  22,
#         role: "admin"
#       }
#     })
#
#     permitted = params.require(:person).permit(:name, :age)
#     permitted            # => #<ActionController::Parameters {"name"=>"Francesco", "age"=>22} permitted: true>
#     permitted.permitted? # => true
#
#     Person.first.update!(permitted)
#     # => #<Person id: 1, name: "Francesco", age: 22, role: "user">
#
# It provides two options that controls the top-level behavior of new instances:
#
# *   `permit_all_parameters` - If it's `true`, all the parameters will be
#     permitted by default. The default is `false`.
# *   `action_on_unpermitted_parameters` - Controls behavior when parameters
#     that are not explicitly permitted are found. The default value is `:log`
#     in test and development environments, `false` otherwise. The values can
#     be:
#     *   `false` to take no action.
#     *   `:log` to emit an `ActiveSupport::Notifications.instrument` event on
#         the `unpermitted_parameters.action_controller` topic and log at the
#         DEBUG level.
#     *   `:raise` to raise an ActionController::UnpermittedParameters
#         exception.
#
#
#
# Examples:
#
#     params = ActionController::Parameters.new
#     params.permitted? # => false
#
#     ActionController::Parameters.permit_all_parameters = true
#
#     params = ActionController::Parameters.new
#     params.permitted? # => true
#
#     params = ActionController::Parameters.new(a: "123", b: "456")
#     params.permit(:c)
#     # => #<ActionController::Parameters {} permitted: true>
#
#     ActionController::Parameters.action_on_unpermitted_parameters = :raise
#
#     params = ActionController::Parameters.new(a: "123", b: "456")
#     params.permit(:c)
#     # => ActionController::UnpermittedParameters: found unpermitted keys: a, b
#
# Please note that these options *are not thread-safe*. In a multi-threaded
# environment they should only be set once at boot-time and never mutated at
# runtime.
#
# You can fetch values of `ActionController::Parameters` using either `:key` or
# `"key"`.
#
#     params = ActionController::Parameters.new(key: "value")
#     params[:key]  # => "value"
#     params["key"] # => "value"
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#147
class ActionController::Parameters
  include ::ActiveSupport::DeepMergeable

  # Returns a new `ActionController::Parameters` instance. Also, sets the
  # `permitted` attribute to the default value of
  # `ActionController::Parameters.permit_all_parameters`.
  #
  #     class Person < ActiveRecord::Base
  #     end
  #
  #     params = ActionController::Parameters.new(name: "Francesco")
  #     params.permitted?  # => false
  #     Person.new(params) # => ActiveModel::ForbiddenAttributesError
  #
  #     ActionController::Parameters.permit_all_parameters = true
  #
  #     params = ActionController::Parameters.new(name: "Francesco")
  #     params.permitted?  # => true
  #     Person.new(params) # => #<Person id: nil, name: "Francesco">
  #
  # @return [Parameters] a new instance of Parameters
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#288
  def initialize(parameters = T.unsafe(nil), logging_context = T.unsafe(nil)); end

  # Returns true if another `Parameters` object contains the same content and
  # permitted flag.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#302
  def ==(other); end

  # Returns a parameter for the given `key`. If not found, returns `nil`.
  #
  #     params = ActionController::Parameters.new(person: { name: "Francesco" })
  #     params[:person] # => #<ActionController::Parameters {"name"=>"Francesco"} permitted: false>
  #     params[:none]   # => nil
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#670
  def [](key); end

  # Assigns a value to a given `key`. The given key may still get filtered out
  # when #permit is called.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#676
  def []=(key, value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#250
  def always_permitted_parameters; end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#250
  def always_permitted_parameters=(val); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def as_json(*_arg0, **_arg1, &_arg2); end

  # Returns a new `ActionController::Parameters` instance with `nil` values
  # removed.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#847
  def compact; end

  # Removes all `nil` values in place and returns `self`, or `nil` if no changes
  # were made.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#853
  def compact!; end

  # Returns a new `ActionController::Parameters` instance without the blank
  # values. Uses Object#blank? for determining if a value is blank.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#859
  def compact_blank; end

  # Removes all blank values in place and returns self. Uses Object#blank? for
  # determining if a value is blank.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#865
  def compact_blank!; end

  # Attribute that keeps track of converted arrays, if any, to avoid double
  # looping in the common use case permit + mass-assignment. Defined in a method
  # to instantiate it only if needed.
  #
  # Testing membership still loops, but it's going to be faster than our own loop
  # that converts values. Also, we are not going to build a new array object per
  # fetch.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#436
  def converted_arrays; end

  # Returns a duplicate `ActionController::Parameters` instance with the same
  # permitted parameters.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#965
  def deep_dup; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#900
  def deep_merge?(other_hash); end

  # Returns a new `ActionController::Parameters` instance with the results of
  # running `block` once for every key. This includes the keys from the root hash
  # and from all nested hashes and arrays. The values are unchanged.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#797
  def deep_transform_keys(&block); end

  # Returns the same `ActionController::Parameters` instance with changed keys.
  # This includes the keys from the root hash and from all nested hashes and
  # arrays. The values are unchanged.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#806
  def deep_transform_keys!(&block); end

  # Deletes a key-value pair from `Parameters` and returns the value. If `key` is
  # not found, returns `nil` (or, with optional code block, yields `key` and
  # returns the result). This method is similar to #extract!, which returns the
  # corresponding `ActionController::Parameters` object.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#815
  def delete(key, &block); end

  # Removes items that the block evaluates to true and returns self.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#839
  def delete_if(&block); end

  # Extracts the nested parameter from the given `keys` by calling `dig` at each
  # step. Returns `nil` if any intermediate step is `nil`.
  #
  #     params = ActionController::Parameters.new(foo: { bar: { baz: 1 } })
  #     params.dig(:foo, :bar, :baz) # => 1
  #     params.dig(:foo, :zot, :xyz) # => nil
  #
  #     params2 = ActionController::Parameters.new(foo: [10, 11, 12])
  #     params2.dig(:foo, 1) # => 11
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#714
  def dig(*keys); end

  # Convert all hashes in values into parameters, then yield each pair in the same
  # way as `Hash#each_pair`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#403
  def each(&block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def each_key(*_arg0, **_arg1, &_arg2); end

  # Convert all hashes in values into parameters, then yield each pair in the same
  # way as `Hash#each_pair`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#403
  def each_pair(&block); end

  # Convert all hashes in values into parameters, then yield each value in the
  # same way as `Hash#each_value`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#415
  def each_value(&block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def empty?(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#959
  def encode_with(coder); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#310
  def eql?(other); end

  # Returns a new `ActionController::Parameters` instance that filters out the
  # given `keys`.
  #
  #     params = ActionController::Parameters.new(a: 1, b: 2, c: 3)
  #     params.except(:a, :b) # => #<ActionController::Parameters {"c"=>3} permitted: false>
  #     params.except(:d)     # => #<ActionController::Parameters {"a"=>1, "b"=>2, "c"=>3} permitted: false>
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#742
  def except(*keys); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def exclude?(*_arg0, **_arg1, &_arg2); end

  # Removes and returns the key/value pairs matching the given keys.
  #
  #     params = ActionController::Parameters.new(a: 1, b: 2, c: 3)
  #     params.extract!(:a, :b) # => #<ActionController::Parameters {"a"=>1, "b"=>2} permitted: false>
  #     params                  # => #<ActionController::Parameters {"c"=>3} permitted: false>
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#752
  def extract!(*keys); end

  # Returns parameter value for the given `key` separated by `delimiter`.
  #
  #     params = ActionController::Parameters.new(id: "1_123", tags: "ruby,rails")
  #     params.extract_value(:id) # => ["1", "123"]
  #     params.extract_value(:tags, delimiter: ",") # => ["ruby", "rails"]
  #     params.extract_value(:non_existent_key) # => nil
  #
  # Note that if the given `key`'s value contains blank elements, then the
  # returned array will include empty strings.
  #
  #     params = ActionController::Parameters.new(tags: "ruby,rails,,web")
  #     params.extract_value(:tags, delimiter: ",") # => ["ruby", "rails", "", "web"]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#983
  def extract_value(key, delimiter: T.unsafe(nil)); end

  # Returns a parameter for the given `key`. If the `key` can't be found, there
  # are several options: With no other arguments, it will raise an
  # ActionController::ParameterMissing error; if a second argument is given, then
  # that is returned (converted to an instance of `ActionController::Parameters`
  # if possible); if a block is given, then that will be run and its result
  # returned.
  #
  #     params = ActionController::Parameters.new(person: { name: "Francesco" })
  #     params.fetch(:person)               # => #<ActionController::Parameters {"name"=>"Francesco"} permitted: false>
  #     params.fetch(:none)                 # => ActionController::ParameterMissing: param is missing or the value is empty: none
  #     params.fetch(:none, {})             # => #<ActionController::Parameters {} permitted: false>
  #     params.fetch(:none, "Francesco")    # => "Francesco"
  #     params.fetch(:none) { "Francesco" } # => "Francesco"
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#693
  def fetch(key, *args); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def has_key?(*_arg0, **_arg1, &_arg2); end

  # Returns true if the given value is present for some key in the parameters.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#870
  def has_value?(value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#316
  def hash; end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def include?(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#941
  def init_with(coder); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#928
  def inspect; end

  # Equivalent to Hash#keep_if, but returns `nil` if no changes were made.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#826
  def keep_if(&block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def key?(*_arg0, **_arg1, &_arg2); end

  # :method: to_s
  #
  # :call-seq:
  #     to_s()
  #
  # Returns the content of the parameters as a string.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def keys(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def member?(*_arg0, **_arg1, &_arg2); end

  # Returns a new `ActionController::Parameters` instance with all keys from
  # `other_hash` merged into current hash.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#884
  def merge(other_hash); end

  # :call-seq: merge!(other_hash)
  #
  # Returns the current `ActionController::Parameters` instance with `other_hash`
  # merged into current hash.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#895
  def merge!(other_hash, &block); end

  # Returns a new `ActionController::Parameters` instance that includes only the
  # given `filters` and sets the `permitted` attribute for the object to `true`.
  # This is useful for limiting which attributes should be allowed for mass
  # updating.
  #
  #     params = ActionController::Parameters.new(user: { name: "Francesco", age: 22, role: "admin" })
  #     permitted = params.require(:user).permit(:name, :age)
  #     permitted.permitted?      # => true
  #     permitted.has_key?(:name) # => true
  #     permitted.has_key?(:age)  # => true
  #     permitted.has_key?(:role) # => false
  #
  # Only permitted scalars pass the filter. For example, given
  #
  #     params.permit(:name)
  #
  # `:name` passes if it is a key of `params` whose associated value is of type
  # `String`, `Symbol`, `NilClass`, `Numeric`, `TrueClass`, `FalseClass`, `Date`,
  # `Time`, `DateTime`, `StringIO`, `IO`, ActionDispatch::Http::UploadedFile or
  # `Rack::Test::UploadedFile`. Otherwise, the key `:name` is filtered out.
  #
  # You may declare that the parameter should be an array of permitted scalars by
  # mapping it to an empty array:
  #
  #     params = ActionController::Parameters.new(tags: ["rails", "parameters"])
  #     params.permit(tags: [])
  #
  # Sometimes it is not possible or convenient to declare the valid keys of a hash
  # parameter or its internal structure. Just map to an empty hash:
  #
  #     params.permit(preferences: {})
  #
  # Be careful because this opens the door to arbitrary input. In this case,
  # `permit` ensures values in the returned structure are permitted scalars and
  # filters out anything else.
  #
  # You can also use `permit` on nested parameters, like:
  #
  #     params = ActionController::Parameters.new({
  #       person: {
  #         name: "Francesco",
  #         age:  22,
  #         pets: [{
  #           name: "Purplish",
  #           category: "dogs"
  #         }]
  #       }
  #     })
  #
  #     permitted = params.permit(person: [ :name, { pets: :name } ])
  #     permitted.permitted?                    # => true
  #     permitted[:person][:name]               # => "Francesco"
  #     permitted[:person][:age]                # => nil
  #     permitted[:person][:pets][0][:name]     # => "Purplish"
  #     permitted[:person][:pets][0][:category] # => nil
  #
  # Note that if you use `permit` in a key that points to a hash, it won't allow
  # all the hash. You also need to specify which attributes inside the hash should
  # be permitted.
  #
  #     params = ActionController::Parameters.new({
  #       person: {
  #         contact: {
  #           email: "none@test.com",
  #           phone: "555-1234"
  #         }
  #       }
  #     })
  #
  #     params.require(:person).permit(:contact)
  #     # => #<ActionController::Parameters {} permitted: true>
  #
  #     params.require(:person).permit(contact: :phone)
  #     # => #<ActionController::Parameters {"contact"=>#<ActionController::Parameters {"phone"=>"555-1234"} permitted: true>} permitted: true>
  #
  #     params.require(:person).permit(contact: [ :email, :phone ])
  #     # => #<ActionController::Parameters {"contact"=>#<ActionController::Parameters {"email"=>"none@test.com", "phone"=>"555-1234"} permitted: true>} permitted: true>
  #
  # If your parameters specify multiple parameters indexed by a number, you can
  # permit each set of parameters under the numeric key to be the same using the
  # same syntax as permitting a single item.
  #
  #     params = ActionController::Parameters.new({
  #       person: {
  #         '0': {
  #           email: "none@test.com",
  #           phone: "555-1234"
  #         },
  #         '1': {
  #           email: "nothing@test.com",
  #           phone: "555-6789"
  #         },
  #       }
  #     })
  #     params.permit(person: [:email]).to_h
  #     # => {"person"=>{"0"=>{"email"=>"none@test.com"}, "1"=>{"email"=>"nothing@test.com"}}}
  #
  # If you want to specify what keys you want from each numeric key, you can
  # instead specify each one individually
  #
  #     params = ActionController::Parameters.new({
  #       person: {
  #         '0': {
  #           email: "none@test.com",
  #           phone: "555-1234"
  #         },
  #         '1': {
  #           email: "nothing@test.com",
  #           phone: "555-6789"
  #         },
  #       }
  #     })
  #     params.permit(person: { '0': [:email], '1': [:phone]}).to_h
  #     # => {"person"=>{"0"=>{"email"=>"none@test.com"}, "1"=>{"phone"=>"555-6789"}}}
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#648
  def permit(*filters); end

  # Sets the `permitted` attribute to `true`. This can be used to pass mass
  # assignment. Returns `self`.
  #
  #     class Person < ActiveRecord::Base
  #     end
  #
  #     params = ActionController::Parameters.new(name: "Francesco")
  #     params.permitted?  # => false
  #     Person.new(params) # => ActiveModel::ForbiddenAttributesError
  #     params.permit!
  #     params.permitted?  # => true
  #     Person.new(params) # => #<Person id: nil, name: "Francesco">
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#462
  def permit!; end

  # Returns `true` if the parameter is permitted, `false` otherwise.
  #
  #     params = ActionController::Parameters.new
  #     params.permitted? # => false
  #     params.permit!
  #     params.permitted? # => true
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#446
  def permitted?; end

  # Returns a new `ActionController::Parameters` instance with items that the
  # block evaluates to true removed.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#834
  def reject(&block); end

  # Removes items that the block evaluates to true and returns self.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#839
  def reject!(&block); end

  # This method accepts both a single key and an array of keys.
  #
  # When passed a single key, if it exists and its associated value is either
  # present or the singleton `false`, returns said value:
  #
  #     ActionController::Parameters.new(person: { name: "Francesco" }).require(:person)
  #     # => #<ActionController::Parameters {"name"=>"Francesco"} permitted: false>
  #
  # Otherwise raises ActionController::ParameterMissing:
  #
  #     ActionController::Parameters.new.require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: nil).require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: "\t").require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: {}).require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  # When given an array of keys, the method tries to require each one of them in
  # order. If it succeeds, an array with the respective return values is returned:
  #
  #     params = ActionController::Parameters.new(user: { ... }, profile: { ... })
  #     user_params, profile_params = params.require([:user, :profile])
  #
  # Otherwise, the method re-raises the first exception found:
  #
  #     params = ActionController::Parameters.new(user: {}, profile: {})
  #     user_params, profile_params = params.require([:user, :profile])
  #     # ActionController::ParameterMissing: param is missing or the value is empty: user
  #
  # Technically this method can be used to fetch terminal values:
  #
  #     # CAREFUL
  #     params = ActionController::Parameters.new(person: { name: "Finn" })
  #     name = params.require(:person).require(:name) # CAREFUL
  #
  # but take into account that at some point those ones have to be permitted:
  #
  #     def person_params
  #       params.require(:person).permit(:name).tap do |person_params|
  #         person_params.require(:name) # SAFER
  #       end
  #     end
  #
  # for example.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#522
  def require(key); end

  # This method accepts both a single key and an array of keys.
  #
  # When passed a single key, if it exists and its associated value is either
  # present or the singleton `false`, returns said value:
  #
  #     ActionController::Parameters.new(person: { name: "Francesco" }).require(:person)
  #     # => #<ActionController::Parameters {"name"=>"Francesco"} permitted: false>
  #
  # Otherwise raises ActionController::ParameterMissing:
  #
  #     ActionController::Parameters.new.require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: nil).require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: "\t").require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  #     ActionController::Parameters.new(person: {}).require(:person)
  #     # ActionController::ParameterMissing: param is missing or the value is empty: person
  #
  # When given an array of keys, the method tries to require each one of them in
  # order. If it succeeds, an array with the respective return values is returned:
  #
  #     params = ActionController::Parameters.new(user: { ... }, profile: { ... })
  #     user_params, profile_params = params.require([:user, :profile])
  #
  # Otherwise, the method re-raises the first exception found:
  #
  #     params = ActionController::Parameters.new(user: {}, profile: {})
  #     user_params, profile_params = params.require([:user, :profile])
  #     # ActionController::ParameterMissing: param is missing or the value is empty: user
  #
  # Technically this method can be used to fetch terminal values:
  #
  #     # CAREFUL
  #     params = ActionController::Parameters.new(person: { name: "Finn" })
  #     name = params.require(:person).require(:name) # CAREFUL
  #
  # but take into account that at some point those ones have to be permitted:
  #
  #     def person_params
  #       params.require(:person).permit(:name).tap do |person_params|
  #         person_params.require(:name) # SAFER
  #       end
  #     end
  #
  # for example.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#522
  def required(key); end

  # Returns a new `ActionController::Parameters` instance with all keys from
  # current hash merged into `other_hash`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#906
  def reverse_merge(other_hash); end

  # Returns the current `ActionController::Parameters` instance with current hash
  # merged into `other_hash`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#915
  def reverse_merge!(other_hash); end

  # Returns a new `ActionController::Parameters` instance with only items that the
  # block evaluates to true.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#821
  def select(&block); end

  # Equivalent to Hash#keep_if, but returns `nil` if no changes were made.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#826
  def select!(&block); end

  # Returns a new `ActionController::Parameters` instance that includes only the
  # given `keys`. If the given `keys` don't exist, returns an empty hash.
  #
  #     params = ActionController::Parameters.new(a: 1, b: 2, c: 3)
  #     params.slice(:a, :b) # => #<ActionController::Parameters {"a"=>1, "b"=>2} permitted: false>
  #     params.slice(:d)     # => #<ActionController::Parameters {} permitted: false>
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#725
  def slice(*keys); end

  # Returns the current `ActionController::Parameters` instance which contains
  # only the given `keys`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#731
  def slice!(*keys); end

  # This is required by ActiveModel attribute assignment, so that user can pass
  # `Parameters` to a mass assignment methods in a model. It should not matter as
  # we are using `HashWithIndifferentAccess` internally.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#924
  def stringify_keys; end

  # Returns a safe ActiveSupport::HashWithIndifferentAccess representation of the
  # parameters with all unpermitted keys removed.
  #
  #     params = ActionController::Parameters.new({
  #       name: "Senjougahara Hitagi",
  #       oddity: "Heavy stone crab"
  #     })
  #     params.to_h
  #     # => ActionController::UnfilteredParameters: unable to convert unpermitted parameters to hash
  #
  #     safe_params = params.permit(:name)
  #     safe_params.to_h # => {"name"=>"Senjougahara Hitagi"}
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#332
  def to_h(&block); end

  # Returns a safe `Hash` representation of the parameters with all unpermitted
  # keys removed.
  #
  #     params = ActionController::Parameters.new({
  #       name: "Senjougahara Hitagi",
  #       oddity: "Heavy stone crab"
  #     })
  #     params.to_hash
  #     # => ActionController::UnfilteredParameters: unable to convert unpermitted parameters to hash
  #
  #     safe_params = params.permit(:name)
  #     safe_params.to_hash # => {"name"=>"Senjougahara Hitagi"}
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#352
  def to_hash; end

  # Returns a string representation of the receiver suitable for use as a URL
  # query string:
  #
  #     params = ActionController::Parameters.new({
  #       name: "David",
  #       nationality: "Danish"
  #     })
  #     params.to_query
  #     # => ActionController::UnfilteredParameters: unable to convert unpermitted parameters to hash
  #
  #     safe_params = params.permit(:name, :nationality)
  #     safe_params.to_query
  #     # => "name=David&nationality=Danish"
  #
  # An optional namespace can be passed to enclose key names:
  #
  #     params = ActionController::Parameters.new({
  #       name: "David",
  #       nationality: "Danish"
  #     })
  #     safe_params = params.permit(:name, :nationality)
  #     safe_params.to_query("user")
  #     # => "user%5Bname%5D=David&user%5Bnationality%5D=Danish"
  #
  # The string pairs `"key=value"` that conform the query string are sorted
  # lexicographically in ascending order.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#382
  def to_param(*args); end

  # Returns a string representation of the receiver suitable for use as a URL
  # query string:
  #
  #     params = ActionController::Parameters.new({
  #       name: "David",
  #       nationality: "Danish"
  #     })
  #     params.to_query
  #     # => ActionController::UnfilteredParameters: unable to convert unpermitted parameters to hash
  #
  #     safe_params = params.permit(:name, :nationality)
  #     safe_params.to_query
  #     # => "name=David&nationality=Danish"
  #
  # An optional namespace can be passed to enclose key names:
  #
  #     params = ActionController::Parameters.new({
  #       name: "David",
  #       nationality: "Danish"
  #     })
  #     safe_params = params.permit(:name, :nationality)
  #     safe_params.to_query("user")
  #     # => "user%5Bname%5D=David&user%5Bnationality%5D=Danish"
  #
  # The string pairs `"key=value"` that conform the query string are sorted
  # lexicographically in ascending order.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#382
  def to_query(*args); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#237
  def to_s(*_arg0, **_arg1, &_arg2); end

  # Returns an unsafe, unfiltered ActiveSupport::HashWithIndifferentAccess
  # representation of the parameters.
  #
  #     params = ActionController::Parameters.new({
  #       name: "Senjougahara Hitagi",
  #       oddity: "Heavy stone crab"
  #     })
  #     params.to_unsafe_h
  #     # => {"name"=>"Senjougahara Hitagi", "oddity" => "Heavy stone crab"}
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#396
  def to_unsafe_h; end

  # Returns an unsafe, unfiltered ActiveSupport::HashWithIndifferentAccess
  # representation of the parameters.
  #
  #     params = ActionController::Parameters.new({
  #       name: "Senjougahara Hitagi",
  #       oddity: "Heavy stone crab"
  #     })
  #     params.to_unsafe_h
  #     # => {"name"=>"Senjougahara Hitagi", "oddity" => "Heavy stone crab"}
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#396
  def to_unsafe_hash; end

  # Returns a new `ActionController::Parameters` instance with the results of
  # running `block` once for every key. The values are unchanged.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#779
  def transform_keys(&block); end

  # Performs keys transformation and returns the altered
  # `ActionController::Parameters` instance.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#788
  def transform_keys!(&block); end

  # Returns a new `ActionController::Parameters` instance with the results of
  # running `block` once for every value. The keys are unchanged.
  #
  #     params = ActionController::Parameters.new(a: 1, b: 2, c: 3)
  #     params.transform_values { |x| x * 2 }
  #     # => #<ActionController::Parameters {"a"=>2, "b"=>4, "c"=>6} permitted: false>
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#762
  def transform_values; end

  # Performs values transformation and returns the altered
  # `ActionController::Parameters` instance.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#771
  def transform_values!; end

  # Returns true if the given value is present for some key in the parameters.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#870
  def value?(value); end

  # Returns a new array of the values of the parameters.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#425
  def values; end

  # Returns values that were assigned to the given `keys`. Note that all the
  # `Hash` objects will be converted to `ActionController::Parameters`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#878
  def values_at(*keys); end

  # Returns a new `ActionController::Parameters` instance with all keys from
  # current hash merged into `other_hash`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#906
  def with_defaults(other_hash); end

  # Returns the current `ActionController::Parameters` instance with current hash
  # merged into `other_hash`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#915
  def with_defaults!(other_hash); end

  # Returns a new `ActionController::Parameters` instance that filters out the
  # given `keys`.
  #
  #     params = ActionController::Parameters.new(a: 1, b: 2, c: 3)
  #     params.except(:a, :b) # => #<ActionController::Parameters {"c"=>3} permitted: false>
  #     params.except(:d)     # => #<ActionController::Parameters {"a"=>1, "b"=>2, "c"=>3} permitted: false>
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#742
  def without(*keys); end

  protected

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#996
  def each_nested_attribute; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#992
  def nested_attributes?; end

  # Returns the value of attribute parameters.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#988
  def parameters; end

  # Sets the attribute permitted
  #
  # @param value the value to set the attribute permitted to.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#990
  def permitted=(_arg0); end

  private

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1045
  def _deep_transform_keys_in_object(object, &block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1064
  def _deep_transform_keys_in_object!(object, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1177
  def array_of_permitted_scalars?(value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1025
  def convert_hashes_to_parameters(key, value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1009
  def convert_parameters_to_hashes(value, using, &block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1031
  def convert_value_to_parameters(value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1091
  def each_element(object, filter, &block); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1189
  def hash_filter(params, filter); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1250
  def initialize_copy(source); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1003
  def new_instance_with_inherited_permitted_status(hash); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1183
  def non_scalar?(value); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1233
  def permit_any_in_array(array); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1216
  def permit_any_in_parameters(params); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1148
  def permitted_scalar?(value); end

  # Adds existing keys to the params if their values are scalar.
  #
  # For example:
  #
  #     puts self.keys #=> ["zipcode(90210i)"]
  #     params = {}
  #
  #     permitted_scalar_filter(params, "zipcode")
  #
  #     puts params.keys # => ["zipcode"]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1162
  def permitted_scalar_filter(params, permitted_key); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1085
  def specify_numeric_keys?(filter); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1117
  def unpermitted_keys(params); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1104
  def unpermitted_parameters!(params); end

  class << self
    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#152
    def action_on_unpermitted_parameters; end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#152
    def action_on_unpermitted_parameters=(val); end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#253
    def allow_deprecated_parameters_hash_equality; end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#260
    def allow_deprecated_parameters_hash_equality=(value); end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#250
    def always_permitted_parameters; end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#250
    def always_permitted_parameters=(val); end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#932
    def hook_into_yaml_loading; end

    # @return [Boolean]
    #
    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#267
    def nested_attribute?(key, value); end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#150
    def permit_all_parameters; end

    # source://actionpack//lib/action_controller/metal/strong_parameters.rb#150
    def permit_all_parameters=(val); end
  end
end

# source://actionpack//lib/action_controller/metal/strong_parameters.rb#1187
ActionController::Parameters::EMPTY_ARRAY = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/metal/strong_parameters.rb#1188
ActionController::Parameters::EMPTY_HASH = T.let(T.unsafe(nil), Hash)

# --- Filtering ----------------------------------------------------------
#
# This is a list of permitted scalar types that includes the ones supported in
# XML and JSON requests.
#
# This list is in particular used to filter ordinary requests, String goes as
# first element to quickly short-circuit the common case.
#
# If you modify this collection please update the one in the #permit doc as
# well.
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#1132
ActionController::Parameters::PERMITTED_SCALAR_TYPES = T.let(T.unsafe(nil), Array)

# # Action Controller Params Wrapper
#
# Wraps the parameters hash into a nested hash. This will allow clients to
# submit requests without having to specify any root elements.
#
# This functionality is enabled by default for JSON, and can be customized by
# setting the format array:
#
#     class ApplicationController < ActionController::Base
#       wrap_parameters format: [:json, :xml]
#     end
#
# You could also turn it on per controller:
#
#     class UsersController < ApplicationController
#       wrap_parameters format: [:json, :xml, :url_encoded_form, :multipart_form]
#     end
#
# If you enable `ParamsWrapper` for `:json` format, instead of having to send
# JSON parameters like this:
#
#     {"user": {"name": "Konata"}}
#
# You can send parameters like this:
#
#     {"name": "Konata"}
#
# And it will be wrapped into a nested hash with the key name matching the
# controller's name. For example, if you're posting to `UsersController`, your
# new `params` hash will look like this:
#
#     {"name" => "Konata", "user" => {"name" => "Konata"}}
#
# You can also specify the key in which the parameters should be wrapped to, and
# also the list of attributes it should wrap by using either `:include` or
# `:exclude` options like this:
#
#     class UsersController < ApplicationController
#       wrap_parameters :person, include: [:username, :password]
#     end
#
# On Active Record models with no `:include` or `:exclude` option set, it will
# only wrap the parameters returned by the class method `attribute_names`.
#
# If you're going to pass the parameters to an `ActiveModel` object (such as
# `User.new(params[:user])`), you might consider passing the model class to the
# method instead. The `ParamsWrapper` will actually try to determine the list of
# attribute names from the model and only wrap those attributes:
#
#     class UsersController < ApplicationController
#       wrap_parameters Person
#     end
#
# You still could pass `:include` and `:exclude` to set the list of attributes
# you want to wrap.
#
# By default, if you don't specify the key in which the parameters would be
# wrapped to, `ParamsWrapper` will actually try to determine if there's a model
# related to it or not. This controller, for example:
#
#     class Admin::UsersController < ApplicationController
#     end
#
# will try to check if `Admin::User` or `User` model exists, and use it to
# determine the wrapper key respectively. If both models don't exist, it will
# then fall back to use `user` as the key.
#
# To disable this functionality for a controller:
#
#     class UsersController < ApplicationController
#       wrap_parameters false
#     end
#
# source://actionpack//lib/action_controller/metal/params_wrapper.rb#83
module ActionController::ParamsWrapper
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::ParamsWrapper::ClassMethods

  private

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#277
  def _extract_parameters(parameters); end

  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#299
  def _perform_parameter_wrapping; end

  # Returns the list of parameters which will be selected for wrapped.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#273
  def _wrap_parameters(parameters); end

  # Checks if we should perform parameters wrapping.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#289
  def _wrapper_enabled?; end

  # Returns the list of enabled formats.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#268
  def _wrapper_formats; end

  # Returns the wrapper key which will be used to store wrapped parameters.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#263
  def _wrapper_key; end

  # Performs parameters wrapping upon the request. Called automatically by the
  # metal call stack.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#257
  def process_action(*_arg0); end

  module GeneratedClassMethods
    def _wrapper_options; end
    def _wrapper_options=(value); end
    def _wrapper_options?; end
  end

  module GeneratedInstanceMethods
    def _wrapper_options; end
    def _wrapper_options=(value); end
    def _wrapper_options?; end
  end
end

# source://actionpack//lib/action_controller/metal/params_wrapper.rb#188
module ActionController::ParamsWrapper::ClassMethods
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#189
  def _set_wrapper_options(options); end

  # Sets the default wrapper key or model which will be used to determine wrapper
  # key and attribute names. Called automatically when the module is inherited.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#244
  def inherited(klass); end

  # Sets the name of the wrapper key, or the model which `ParamsWrapper` would use
  # to determine the attribute names from.
  #
  # #### Examples
  #     wrap_parameters format: :xml
  #       # enables the parameter wrapper for XML format
  #
  #     wrap_parameters :person
  #       # wraps parameters into +params[:person]+ hash
  #
  #     wrap_parameters Person
  #       # wraps parameters by determining the wrapper key from Person class
  #       # (+person+, in this case) and the list of attribute names
  #
  #     wrap_parameters include: [:username, :title]
  #       # wraps only +:username+ and +:title+ attributes from parameters.
  #
  #     wrap_parameters false
  #       # disables parameters wrapping for this controller altogether.
  #
  # #### Options
  # *   `:format` - The list of formats in which the parameters wrapper will be
  #     enabled.
  # *   `:include` - The list of attribute names which parameters wrapper will
  #     wrap into a nested hash.
  # *   `:exclude` - The list of attribute names which parameters wrapper will
  #     exclude from a nested hash.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#221
  def wrap_parameters(name_or_model_or_options, options = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/params_wrapper.rb#86
ActionController::ParamsWrapper::EXCLUDE_PARAMETERS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_controller/metal/params_wrapper.rb#88
class ActionController::ParamsWrapper::Options < ::Struct
  # @return [Options] a new instance of Options
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#97
  def initialize(name, format, include, exclude, klass, model); end

  # Returns the value of attribute include
  #
  # @return [Object] the current value of include
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#108
  def include; end

  # Returns the value of attribute model
  #
  # @return [Object] the current value of model
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#104
  def model; end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#141
  def name; end

  private

  # Determine the wrapper model from the controller's name. By convention, this
  # could be done by trying to find the defined model that has the same singular
  # name as the controller. For example, `UsersController` will try to find if the
  # `User` model exists.
  #
  # This method also does namespace lookup. Foo::Bar::UsersController will try to
  # find Foo::Bar::User, Foo::User and finally User.
  #
  # source://actionpack//lib/action_controller/metal/params_wrapper.rb#165
  def _default_wrap_model; end

  class << self
    # source://actionpack//lib/action_controller/metal/params_wrapper.rb#89
    def from_hash(hash); end
  end
end

# source://actionpack//lib/action_controller/metal/permissions_policy.rb#6
module ActionController::PermissionsPolicy
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::PermissionsPolicy::ClassMethods
end

# source://actionpack//lib/action_controller/metal/permissions_policy.rb#9
module ActionController::PermissionsPolicy::ClassMethods
  # Overrides parts of the globally configured `Feature-Policy` header:
  #
  #     class PagesController < ApplicationController
  #       permissions_policy do |policy|
  #         policy.geolocation "https://example.com"
  #       end
  #     end
  #
  # Options can be passed similar to `before_action`. For example, pass `only:
  # :index` to override the header on the index action only:
  #
  #     class PagesController < ApplicationController
  #       permissions_policy(only: :index) do |policy|
  #         policy.camera :self
  #       end
  #     end
  #
  # source://actionpack//lib/action_controller/metal/permissions_policy.rb#27
  def permissions_policy(**options, &block); end
end

# source://actionpack//lib/action_controller/railtie.rb#13
class ActionController::Railtie < ::Rails::Railtie; end

# source://actionpack//lib/action_controller/railties/helpers.rb#6
module ActionController::Railties; end

# source://actionpack//lib/action_controller/railties/helpers.rb#7
module ActionController::Railties::Helpers
  # source://actionpack//lib/action_controller/railties/helpers.rb#8
  def inherited(klass); end
end

# source://actionpack//lib/action_controller/metal/rate_limiting.rb#6
module ActionController::RateLimiting
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::RateLimiting::ClassMethods

  private

  # source://actionpack//lib/action_controller/metal/rate_limiting.rb#53
  def rate_limiting(to:, within:, by:, with:, store:); end
end

# source://actionpack//lib/action_controller/metal/rate_limiting.rb#9
module ActionController::RateLimiting::ClassMethods
  # Applies a rate limit to all actions or those specified by the normal
  # `before_action` filters with `only:` and `except:`.
  #
  # The maximum number of requests allowed is specified `to:` and constrained to
  # the window of time given by `within:`.
  #
  # Rate limits are by default unique to the ip address making the request, but
  # you can provide your own identity function by passing a callable in the `by:`
  # parameter. It's evaluated within the context of the controller processing the
  # request.
  #
  # Requests that exceed the rate limit are refused with a `429 Too Many Requests`
  # response. You can specialize this by passing a callable in the `with:`
  # parameter. It's evaluated within the context of the controller processing the
  # request.
  #
  # Rate limiting relies on a backing `ActiveSupport::Cache` store and defaults to
  # `config.action_controller.cache_store`, which itself defaults to the global
  # `config.cache_store`. If you don't want to store rate limits in the same
  # datastore as your general caches, you can pass a custom store in the `store`
  # parameter.
  #
  # Examples:
  #
  #     class SessionsController < ApplicationController
  #       rate_limit to: 10, within: 3.minutes, only: :create
  #     end
  #
  #     class SignupsController < ApplicationController
  #       rate_limit to: 1000, within: 10.seconds,
  #         by: -> { request.domain }, with: -> { redirect_to busy_controller_url, alert: "Too many signups on domain!" }, only: :new
  #     end
  #
  #     class APIController < ApplicationController
  #       RATE_LIMIT_STORE = ActiveSupport::Cache::RedisCacheStore.new(url: ENV["REDIS_URL"])
  #       rate_limit to: 10, within: 3.minutes, store: RATE_LIMIT_STORE
  #     end
  #
  # source://actionpack//lib/action_controller/metal/rate_limiting.rb#47
  def rate_limit(to:, within:, by: T.unsafe(nil), with: T.unsafe(nil), store: T.unsafe(nil), **options); end
end

# source://actionpack//lib/action_controller/metal/redirecting.rb#6
module ActionController::Redirecting
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Benchmarkable
  include ::AbstractController::Logger
  include ::ActionDispatch::Routing::UrlFor
  include ::AbstractController::UrlFor
  include ::ActionController::UrlFor

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::UrlFor::ClassMethods

  # source://actionpack//lib/action_controller/metal/redirecting.rb#158
  def _compute_redirect_to_location(request, options); end

  # Soft deprecated alias for #redirect_back_or_to where the `fallback_location`
  # location is supplied as a keyword argument instead of the first positional
  # argument.
  #
  # source://actionpack//lib/action_controller/metal/redirecting.rb#121
  def redirect_back(fallback_location:, allow_other_host: T.unsafe(nil), **args); end

  # Redirects the browser to the page that issued the request (the referrer) if
  # possible, otherwise redirects to the provided default fallback location.
  #
  # The referrer information is pulled from the HTTP `Referer` (sic) header on the
  # request. This is an optional header and its presence on the request is subject
  # to browser security settings and user preferences. If the request is missing
  # this header, the `fallback_location` will be used.
  #
  #     redirect_back_or_to({ action: "show", id: 5 })
  #     redirect_back_or_to @post
  #     redirect_back_or_to "http://www.rubyonrails.org"
  #     redirect_back_or_to "/images/screenshot.jpg"
  #     redirect_back_or_to posts_url
  #     redirect_back_or_to proc { edit_post_url(@post) }
  #     redirect_back_or_to '/', allow_other_host: false
  #
  # #### Options
  # *   `:allow_other_host` - Allow or disallow redirection to the host that is
  #     different to the current host, defaults to true.
  #
  #
  # All other options that can be passed to #redirect_to are accepted as options,
  # and the behavior is identical.
  #
  # source://actionpack//lib/action_controller/metal/redirecting.rb#148
  def redirect_back_or_to(fallback_location, allow_other_host: T.unsafe(nil), **options); end

  # Redirects the browser to the target specified in `options`. This parameter can
  # be any one of:
  #
  # *   `Hash` - The URL will be generated by calling url_for with the `options`.
  # *   `Record` - The URL will be generated by calling url_for with the
  #     `options`, which will reference a named URL for that record.
  # *   `String` starting with `protocol://` (like `http://`) or a protocol
  #     relative reference (like `//`) - Is passed straight through as the target
  #     for redirection.
  # *   `String` not containing a protocol - The current protocol and host is
  #     prepended to the string.
  # *   `Proc` - A block that will be executed in the controller's context. Should
  #     return any option accepted by `redirect_to`.
  #
  #
  # ### Examples
  #
  #     redirect_to action: "show", id: 5
  #     redirect_to @post
  #     redirect_to "http://www.rubyonrails.org"
  #     redirect_to "/images/screenshot.jpg"
  #     redirect_to posts_url
  #     redirect_to proc { edit_post_url(@post) }
  #
  # The redirection happens as a `302 Found` header unless otherwise specified
  # using the `:status` option:
  #
  #     redirect_to post_url(@post), status: :found
  #     redirect_to action: 'atom', status: :moved_permanently
  #     redirect_to post_url(@post), status: 301
  #     redirect_to action: 'atom', status: 302
  #
  # The status code can either be a standard [HTTP Status
  # code](https://www.iana.org/assignments/http-status-codes) as an integer, or a
  # symbol representing the downcased, underscored and symbolized description.
  # Note that the status code must be a 3xx HTTP code, or redirection will not
  # occur.
  #
  # If you are using XHR requests other than GET or POST and redirecting after the
  # request then some browsers will follow the redirect using the original request
  # method. This may lead to undesirable behavior such as a double DELETE. To work
  # around this you can return a `303 See Other` status code which will be
  # followed using a GET request.
  #
  #     redirect_to posts_url, status: :see_other
  #     redirect_to action: 'index', status: 303
  #
  # It is also possible to assign a flash message as part of the redirection.
  # There are two special accessors for the commonly used flash names `alert` and
  # `notice` as well as a general purpose `flash` bucket.
  #
  #     redirect_to post_url(@post), alert: "Watch it, mister!"
  #     redirect_to post_url(@post), status: :found, notice: "Pay attention to the road"
  #     redirect_to post_url(@post), status: 301, flash: { updated_post_id: @post.id }
  #     redirect_to({ action: 'atom' }, alert: "Something serious happened")
  #
  # Statements after `redirect_to` in our controller get executed, so
  # `redirect_to` doesn't stop the execution of the function. To terminate the
  # execution of the function immediately after the `redirect_to`, use return.
  #
  #     redirect_to post_url(@post) and return
  #
  # ### Open Redirect protection
  #
  # By default, Rails protects against redirecting to external hosts for your
  # app's safety, so called open redirects. Note: this was a new default in Rails
  # 7.0, after upgrading opt-in by uncommenting the line with
  # `raise_on_open_redirects` in
  # `config/initializers/new_framework_defaults_7_0.rb`
  #
  # Here #redirect_to automatically validates the potentially-unsafe URL:
  #
  #     redirect_to params[:redirect_url]
  #
  # Raises UnsafeRedirectError in the case of an unsafe redirect.
  #
  # To allow any external redirects pass `allow_other_host: true`, though using a
  # user-provided param in that case is unsafe.
  #
  #     redirect_to "https://rubyonrails.org", allow_other_host: true
  #
  # See #url_from for more information on what an internal and safe URL is, or how
  # to fall back to an alternate redirect URL in the unsafe case.
  #
  # @raise [ActionControllerError]
  #
  # source://actionpack//lib/action_controller/metal/redirecting.rb#103
  def redirect_to(options = T.unsafe(nil), response_options = T.unsafe(nil)); end

  # Verifies the passed `location` is an internal URL that's safe to redirect to
  # and returns it, or nil if not. Useful to wrap a params provided redirect URL
  # and fall back to an alternate URL to redirect to:
  #
  #     redirect_to url_from(params[:redirect_url]) || root_url
  #
  # The `location` is considered internal, and safe, if it's on the same host as
  # `request.host`:
  #
  #     # If request.host is example.com:
  #     url_from("https://example.com/profile") # => "https://example.com/profile"
  #     url_from("http://example.com/profile")  # => "http://example.com/profile"
  #     url_from("http://evil.com/profile")     # => nil
  #
  # Subdomains are considered part of the host:
  #
  #     # If request.host is on https://example.com or https://app.example.com, you'd get:
  #     url_from("https://dev.example.com/profile") # => nil
  #
  # NOTE: there's a similarity with
  # [url_for](rdoc-ref:ActionDispatch::Routing::UrlFor#url_for), which generates
  # an internal URL from various options from within the app, e.g.
  # `url_for(@post)`. However, #url_from is meant to take an external parameter to
  # verify as in `url_from(params[:redirect_url])`.
  #
  # source://actionpack//lib/action_controller/metal/redirecting.rb#202
  def url_from(location); end

  private

  # source://actionpack//lib/action_controller/metal/redirecting.rb#208
  def _allow_other_host; end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#222
  def _enforce_open_redirect_protection(location, allow_other_host:); end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#241
  def _ensure_url_is_http_header_safe(url); end

  # source://actionpack//lib/action_controller/metal/redirecting.rb#212
  def _extract_redirect_to_status(options, response_options); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/redirecting.rb#230
  def _url_host_allowed?(url); end

  class << self
    # source://actionpack//lib/action_controller/metal/redirecting.rb#158
    def _compute_redirect_to_location(request, options); end
  end

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

# source://actionpack//lib/action_controller/metal/redirecting.rb#14
ActionController::Redirecting::ILLEGAL_HEADER_VALUE_REGEX = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_controller/metal/redirecting.rb#12
class ActionController::Redirecting::UnsafeRedirectError < ::StandardError; end

# source://actionpack//lib/action_controller/metal/exceptions.rb#16
class ActionController::RenderError < ::ActionController::ActionControllerError; end

# # Action Controller Renderer
#
# ActionController::Renderer allows you to render arbitrary templates without
# being inside a controller action.
#
# You can get a renderer instance by calling `renderer` on a controller class:
#
#     ApplicationController.renderer
#     PostsController.renderer
#
# and render a template by calling the #render method:
#
#     ApplicationController.renderer.render template: "posts/show", assigns: { post: Post.first }
#     PostsController.renderer.render :show, assigns: { post: Post.first }
#
# As a shortcut, you can also call `render` directly on the controller class
# itself:
#
#     ApplicationController.render template: "posts/show", assigns: { post: Post.first }
#     PostsController.render :show, assigns: { post: Post.first }
#
# source://actionpack//lib/action_controller/renderer.rb#27
class ActionController::Renderer
  # Initializes a new Renderer.
  #
  # #### Parameters
  #
  # *   `controller` - The controller class to instantiate for rendering.
  # *   `env` - The Rack env to use for mocking a request when rendering. Entries
  #     can be typical Rack env keys and values, or they can be any of the
  #     following, which will be converted appropriately:
  #     *   `:http_host` - The HTTP host for the incoming request. Converts to
  #         Rack's `HTTP_HOST`.
  #     *   `:https` - Boolean indicating whether the incoming request uses HTTPS.
  #         Converts to Rack's `HTTPS`.
  #     *   `:method` - The HTTP method for the incoming request,
  #         case-insensitive. Converts to Rack's `REQUEST_METHOD`.
  #     *   `:script_name` - The portion of the incoming request's URL path that
  #         corresponds to the application. Converts to Rack's `SCRIPT_NAME`.
  #     *   `:input` - The input stream. Converts to Rack's `rack.input`.
  #
  # *   `defaults` - Default values for the Rack env. Entries are specified in the
  #     same format as `env`. `env` will be merged on top of these values.
  #     `defaults` will be retained when calling #new on a renderer instance.
  #
  #
  # If no `http_host` is specified, the env HTTP host will be derived from the
  # routes' `default_url_options`. In this case, the `https` boolean and the
  # `script_name` will also be derived from `default_url_options` if they were not
  # specified. Additionally, the `https` boolean will fall back to
  # `Rails.application.config.force_ssl` if `default_url_options` does not specify
  # a `protocol`.
  #
  # @return [Renderer] a new instance of Renderer
  #
  # source://actionpack//lib/action_controller/renderer.rb#111
  def initialize(controller, env, defaults); end

  # Returns the value of attribute controller.
  #
  # source://actionpack//lib/action_controller/renderer.rb#28
  def controller; end

  # source://actionpack//lib/action_controller/renderer.rb#122
  def defaults; end

  # Creates a new renderer using the same controller, but with a new Rack env.
  #
  #     ApplicationController.renderer.new(method: "post")
  #
  # source://actionpack//lib/action_controller/renderer.rb#72
  def new(env = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/renderer.rb#151
  def normalize_env(env, &_arg1); end

  # Renders a template to a string, just like
  # ActionController::Rendering#render_to_string.
  #
  # source://actionpack//lib/action_controller/renderer.rb#129
  def render(*args); end

  # Renders a template to a string, just like
  # ActionController::Rendering#render_to_string.
  #
  # source://actionpack//lib/action_controller/renderer.rb#129
  def render_to_string(*args); end

  # Creates a new renderer using the same controller, but with the given defaults
  # merged on top of the previous defaults.
  #
  # source://actionpack//lib/action_controller/renderer.rb#78
  def with_defaults(defaults); end

  private

  # source://actionpack//lib/action_controller/renderer.rb#153
  def env_for_request; end

  class << self
    # Creates a new renderer using the given controller class. See ::new.
    #
    # source://actionpack//lib/action_controller/renderer.rb#64
    def for(controller, env = T.unsafe(nil), defaults = T.unsafe(nil)); end

    # source://actionpack//lib/action_controller/renderer.rb#35
    def normalize_env(env); end
  end
end

# source://actionpack//lib/action_controller/renderer.rb#30
ActionController::Renderer::DEFAULTS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/renderer.rb#149
ActionController::Renderer::DEFAULT_ENV = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/renderer.rb#141
ActionController::Renderer::RACK_KEY_TRANSLATION = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/metal/renderers.rb#25
module ActionController::Renderers
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::Renderers::ClassMethods

  # source://actionpack//lib/action_controller/metal/renderers.rb#145
  def _render_to_body_with_renderer(options); end

  # source://actionpack//lib/action_controller/metal/renderers.rb#171
  def _render_with_renderer_js(js, options); end

  # source://actionpack//lib/action_controller/metal/renderers.rb#156
  def _render_with_renderer_json(json, options); end

  # source://actionpack//lib/action_controller/metal/renderers.rb#176
  def _render_with_renderer_xml(xml, options); end

  # Called by `render` in AbstractController::Rendering which sets the return
  # value as the `response_body`.
  #
  # If no renderer is found, `super` returns control to
  # `ActionView::Rendering.render_to_body`, if present.
  #
  # source://actionpack//lib/action_controller/metal/renderers.rb#141
  def render_to_body(options); end

  class << self
    # source://actionpack//lib/action_controller/metal/renderers.rb#91
    def _render_with_renderer_method_name(key); end

    # Adds a new renderer to call within controller actions. A renderer is invoked
    # by passing its name as an option to AbstractController::Rendering#render. To
    # create a renderer pass it a name and a block. The block takes two arguments,
    # the first is the value paired with its key and the second is the remaining
    # hash of options passed to `render`.
    #
    # Create a csv renderer:
    #
    #     ActionController::Renderers.add :csv do |obj, options|
    #       filename = options[:filename] || 'data'
    #       str = obj.respond_to?(:to_csv) ? obj.to_csv : obj.to_s
    #       send_data str, type: Mime[:csv],
    #         disposition: "attachment; filename=#{filename}.csv"
    #     end
    #
    # Note that we used [Mime](:csv) for the csv mime type as it comes with Rails.
    # For a custom renderer, you'll need to register a mime type with
    # `Mime::Type.register`.
    #
    # To use the csv renderer in a controller action:
    #
    #     def show
    #       @csvable = Csvable.find(params[:id])
    #       respond_to do |format|
    #         format.html
    #         format.csv { render csv: @csvable, filename: @csvable.name }
    #       end
    #     end
    #
    # source://actionpack//lib/action_controller/metal/renderers.rb#75
    def add(key, &block); end

    # This method is the opposite of add method.
    #
    # To remove a csv renderer:
    #
    #     ActionController::Renderers.remove(:csv)
    #
    # source://actionpack//lib/action_controller/metal/renderers.rb#85
    def remove(key); end
  end

  module GeneratedClassMethods
    def _renderers; end
    def _renderers=(value); end
    def _renderers?; end
  end

  module GeneratedInstanceMethods
    def _renderers; end
    def _renderers=(value); end
    def _renderers?; end
  end
end

# Used in ActionController::Base and ActionController::API to include all
# renderers by default.
#
# source://actionpack//lib/action_controller/metal/renderers.rb#38
module ActionController::Renderers::All
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionController::Renderers

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionController::Renderers::ClassMethods

  module GeneratedClassMethods
    def _renderers; end
    def _renderers=(value); end
    def _renderers?; end
  end

  module GeneratedInstanceMethods
    def _renderers; end
    def _renderers=(value); end
    def _renderers?; end
  end
end

# source://actionpack//lib/action_controller/metal/renderers.rb#95
module ActionController::Renderers::ClassMethods
  # Adds, by name, a renderer or renderers to the `_renderers` available to call
  # within controller actions.
  #
  # It is useful when rendering from an ActionController::Metal controller or
  # otherwise to add an available renderer proc to a specific controller.
  #
  # Both ActionController::Base and ActionController::API include
  # ActionController::Renderers::All, making all renderers available in the
  # controller. See Renderers::RENDERERS and Renderers.add.
  #
  # Since ActionController::Metal controllers cannot render, the controller must
  # include AbstractController::Rendering, ActionController::Rendering, and
  # ActionController::Renderers, and have at least one renderer.
  #
  # Rather than including ActionController::Renderers::All and including all
  # renderers, you may specify which renderers to include by passing the renderer
  # name or names to `use_renderers`. For example, a controller that includes only
  # the `:json` renderer (`_render_with_renderer_json`) might look like:
  #
  #     class MetalRenderingController < ActionController::Metal
  #       include AbstractController::Rendering
  #       include ActionController::Rendering
  #       include ActionController::Renderers
  #
  #       use_renderers :json
  #
  #       def show
  #         render json: record
  #       end
  #     end
  #
  # You must specify a `use_renderer`, else the `controller.renderer` and
  # `controller._renderers` will be `nil`, and the action will fail.
  #
  # source://actionpack//lib/action_controller/metal/renderers.rb#129
  def use_renderer(*args); end

  # Adds, by name, a renderer or renderers to the `_renderers` available to call
  # within controller actions.
  #
  # It is useful when rendering from an ActionController::Metal controller or
  # otherwise to add an available renderer proc to a specific controller.
  #
  # Both ActionController::Base and ActionController::API include
  # ActionController::Renderers::All, making all renderers available in the
  # controller. See Renderers::RENDERERS and Renderers.add.
  #
  # Since ActionController::Metal controllers cannot render, the controller must
  # include AbstractController::Rendering, ActionController::Rendering, and
  # ActionController::Renderers, and have at least one renderer.
  #
  # Rather than including ActionController::Renderers::All and including all
  # renderers, you may specify which renderers to include by passing the renderer
  # name or names to `use_renderers`. For example, a controller that includes only
  # the `:json` renderer (`_render_with_renderer_json`) might look like:
  #
  #     class MetalRenderingController < ActionController::Metal
  #       include AbstractController::Rendering
  #       include ActionController::Rendering
  #       include ActionController::Renderers
  #
  #       use_renderers :json
  #
  #       def show
  #         render json: record
  #       end
  #     end
  #
  # You must specify a `use_renderer`, else the `controller.renderer` and
  # `controller._renderers` will be `nil`, and the action will fail.
  #
  # source://actionpack//lib/action_controller/metal/renderers.rb#129
  def use_renderers(*args); end
end

# A Set containing renderer names that correspond to available renderer procs.
# Default values are `:json`, `:js`, `:xml`.
#
# source://actionpack//lib/action_controller/metal/renderers.rb#30
ActionController::Renderers::RENDERERS = T.let(T.unsafe(nil), Set)

# source://actionpack//lib/action_controller/metal/rendering.rb#6
module ActionController::Rendering
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionController::Rendering::ClassMethods

  # Renders a template and assigns the result to `self.response_body`.
  #
  # If no rendering mode option is specified, the template will be derived from
  # the first argument.
  #
  #     render "posts/show"
  #     # => renders app/views/posts/show.html.erb
  #
  #     # In a PostsController action...
  #     render :show
  #     # => renders app/views/posts/show.html.erb
  #
  # If the first argument responds to `render_in`, the template will be rendered
  # by calling `render_in` with the current view context.
  #
  #     class Greeting
  #       def render_in(view_context)
  #         view_context.render html: "<h1>Hello, World</h1>"
  #       end
  #
  #       def format
  #         :html
  #       end
  #     end
  #
  #     render(Greeting.new)
  #     # => "<h1>Hello, World</h1>"
  #
  #     render(renderable: Greeting.new)
  #     # => "<h1>Hello, World</h1>"
  #
  # #### Rendering Mode
  #
  # `:partial`
  # :   See ActionView::PartialRenderer for details.
  #
  #         render partial: "posts/form", locals: { post: Post.new }
  #         # => renders app/views/posts/_form.html.erb
  #
  # `:file`
  # :   Renders the contents of a file. This option should **not** be used with
  #     unsanitized user input.
  #
  #         render file: "/path/to/some/file"
  #         # => renders /path/to/some/file
  #
  # `:inline`
  # :   Renders an ERB template string.
  #
  #         @name = "World"
  #         render inline: "<h1>Hello, <%= @name %>!</h1>"
  #         # => renders "<h1>Hello, World!</h1>"
  #
  # `:body`
  # :   Renders the provided text, and sets the content type as `text/plain`.
  #
  #         render body: "Hello, World!"
  #         # => renders "Hello, World!"
  #
  # `:plain`
  # :   Renders the provided text, and sets the content type as `text/plain`.
  #
  #         render plain: "Hello, World!"
  #         # => renders "Hello, World!"
  #
  # `:html`
  # :   Renders the provided HTML string, and sets the content type as
  #     `text/html`. If the string is not `html_safe?`, performs HTML escaping on
  #     the string before rendering.
  #
  #         render html: "<h1>Hello, World!</h1>".html_safe
  #         # => renders "<h1>Hello, World!</h1>"
  #
  #         render html: "<h1>Hello, World!</h1>"
  #         # => renders "&lt;h1&gt;Hello, World!&lt;/h1&gt;"
  #
  # `:json`
  # :   Renders the provided object as JSON, and sets the content type as
  #     `application/json`. If the object is not a string, it will be converted to
  #     JSON by calling `to_json`.
  #
  #         render json: { hello: "world" }
  #         # => renders "{\"hello\":\"world\"}"
  #
  # `:renderable`
  # :   Renders the provided object by calling `render_in` with the current view
  #     context. The response format is determined by calling `format` on the
  #     renderable if it responds to `format`, falling back to `text/html` by
  #     default.
  #
  #         render renderable: Greeting.new
  #         # => renders "<h1>Hello, World</h1>"
  #
  #
  # By default, when a rendering mode is specified, no layout template is
  # rendered.
  #
  # #### Options
  #
  # `:assigns`
  # :   Hash of instance variable assignments for the template.
  #
  #         render inline: "<h1>Hello, <%= @name %>!</h1>", assigns: { name: "World" }
  #         # => renders "<h1>Hello, World!</h1>"
  #
  # `:locals`
  # :   Hash of local variable assignments for the template.
  #
  #         render inline: "<h1>Hello, <%= name %>!</h1>", locals: { name: "World" }
  #         # => renders "<h1>Hello, World!</h1>"
  #
  # `:layout`
  # :   The layout template to render. Can also be `false` or `true` to disable or
  #     (re)enable the default layout template.
  #
  #         render "posts/show", layout: "holiday"
  #         # => renders app/views/posts/show.html.erb with the app/views/layouts/holiday.html.erb layout
  #
  #         render "posts/show", layout: false
  #         # => renders app/views/posts/show.html.erb with no layout
  #
  #         render inline: "<h1>Hello, World!</h1>", layout: true
  #         # => renders "<h1>Hello, World!</h1>" with the default layout
  #
  # `:status`
  # :   The HTTP status code to send with the response. Can be specified as a
  #     number or as the status name in Symbol form. Defaults to 200.
  #
  #         render "posts/new", status: 422
  #         # => renders app/views/posts/new.html.erb with HTTP status code 422
  #
  #         render "posts/new", status: :unprocessable_entity
  #         # => renders app/views/posts/new.html.erb with HTTP status code 422
  #
  # --
  # Check for double render errors and set the content_type after rendering.
  #
  # @raise [::AbstractController::DoubleRenderError]
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#165
  def render(*args); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#185
  def render_to_body(options = T.unsafe(nil)); end

  # Similar to #render, but only returns the rendered template as a string,
  # instead of setting `self.response_body`.
  # --
  # Override render_to_string because body can now be set to a Rack body.
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#174
  def render_to_string(*_arg0); end

  private

  # Normalize both text and status options.
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#227
  def _normalize_options(options); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#241
  def _normalize_text(options); end

  # Process controller specific options, as status, content-type and location.
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#250
  def _process_options(options); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#196
  def _process_variant(options); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#202
  def _render_in_priorities(options); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#210
  def _set_html_content_type; end

  # source://actionpack//lib/action_controller/metal/rendering.rb#214
  def _set_rendered_content_type(format); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#220
  def _set_vary_header; end

  # Before processing, set the request formats in current controller formats.
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#191
  def process_action(*_arg0); end
end

# source://actionpack//lib/action_controller/metal/rendering.rb#11
module ActionController::Rendering::ClassMethods
  # source://actionpack//lib/action_controller/metal/rendering.rb#23
  def inherited(klass); end

  # source://actionpack//lib/action_controller/metal/rendering.rb#13
  def render(*_arg0, **_arg1, &_arg2); end

  # Returns a renderer instance (inherited from ActionController::Renderer) for
  # the controller.
  #
  # source://actionpack//lib/action_controller/metal/rendering.rb#17
  def renderer; end

  # source://actionpack//lib/action_controller/metal/rendering.rb#19
  def setup_renderer!; end
end

# source://actionpack//lib/action_controller/metal/rendering.rb#9
ActionController::Rendering::RENDER_FORMATS_IN_PRIORITY = T.let(T.unsafe(nil), Array)

# # Action Controller Request Forgery Protection
#
# Controller actions are protected from Cross-Site Request Forgery (CSRF)
# attacks by including a token in the rendered HTML for your application. This
# token is stored as a random string in the session, to which an attacker does
# not have access. When a request reaches your application, Rails verifies the
# received token with the token in the session. All requests are checked except
# GET requests as these should be idempotent. Keep in mind that all
# session-oriented requests are CSRF protected by default, including JavaScript
# and HTML requests.
#
# Since HTML and JavaScript requests are typically made from the browser, we
# need to ensure to verify request authenticity for the web browser. We can use
# session-oriented authentication for these types of requests, by using the
# `protect_from_forgery` method in our controllers.
#
# GET requests are not protected since they don't have side effects like writing
# to the database and don't leak sensitive information. JavaScript requests are
# an exception: a third-party site can use a <script> tag to reference a
# JavaScript URL on your site. When your JavaScript response loads on their
# site, it executes. With carefully crafted JavaScript on their end, sensitive
# data in your JavaScript response may be extracted. To prevent this, only
# XmlHttpRequest (known as XHR or Ajax) requests are allowed to make requests
# for JavaScript responses.
#
# Subclasses of ActionController::Base are protected by default with the
# `:exception` strategy, which raises an
# ActionController::InvalidAuthenticityToken error on unverified requests.
#
# APIs may want to disable this behavior since they are typically designed to be
# state-less: that is, the request API client handles the session instead of
# Rails. One way to achieve this is to use the `:null_session` strategy instead,
# which allows unverified requests to be handled, but with an empty session:
#
#     class ApplicationController < ActionController::Base
#       protect_from_forgery with: :null_session
#     end
#
# Note that API only applications don't include this module or a session
# middleware by default, and so don't require CSRF protection to be configured.
#
# The token parameter is named `authenticity_token` by default. The name and
# value of this token must be added to every layout that renders forms by
# including `csrf_meta_tags` in the HTML `head`.
#
# Learn more about CSRF attacks and securing your application in the [Ruby on
# Rails Security Guide](https://guides.rubyonrails.org/security.html).
#
# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#63
module ActionController::RequestForgeryProtection
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::AbstractController::Helpers
  include ::ActiveSupport::Callbacks
  include ::AbstractController::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::Helpers::ClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::AbstractController::Callbacks::ClassMethods
  mixes_in_class_methods ::ActionController::RequestForgeryProtection::ClassMethods

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#364
  def initialize(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#374
  def commit_csrf_token(request); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#369
  def reset_csrf_token(request); end

  private

  # Checks if any of the authenticity tokens from the request are valid.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#467
  def any_authenticity_token_valid?; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#548
  def compare_with_global_token(token, session = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#544
  def compare_with_real_token(token, session = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#585
  def csrf_token_hmac(session, identifier); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#663
  def decode_csrf_token(encoded_csrf_token); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#659
  def encode_csrf_token(csrf_token); end

  # The form's authenticity parameter. Override to provide your own.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#605
  def form_authenticity_param; end

  # Creates the authenticity token for the current request.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#479
  def form_authenticity_token(form_options: T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#655
  def generate_csrf_token; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#581
  def global_csrf_token(session = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#399
  def handle_unverified_request; end

  # GET requests are checked for cross-origin JavaScript after rendering.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#437
  def mark_for_same_origin_verification!; end

  # If the `verify_authenticity_token` before_action ran, verify that JavaScript
  # responses are only served to same-origin GET requests.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#443
  def marked_for_same_origin_verification?; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#537
  def mask_token(raw_token); end

  # Creates a masked version of the authenticity token that varies on each
  # request. The masking is used to mitigate SSL attacks like BREACH.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#485
  def masked_authenticity_token(form_options: T.unsafe(nil)); end

  # Check for cross-origin JavaScript responses.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#448
  def non_xhr_javascript_response?; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#635
  def normalize_action_path(action_path); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#645
  def normalize_relative_action_path(rel_action_path); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#574
  def per_form_csrf_token(session, action_path, method); end

  # Checks if the controller allows forgery protection.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#610
  def protect_against_forgery?; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#566
  def real_csrf_token(_session = T.unsafe(nil)); end

  # Possible authenticity tokens sent in the request.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#474
  def request_authenticity_tokens; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#530
  def unmask_token(masked_token); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#409
  def unverified_request_warning_message; end

  # Checks the client's masked token to see if it matches the session token.
  # Essentially the inverse of `masked_authenticity_token`.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#500
  def valid_authenticity_token?(session, encoded_masked_token); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#552
  def valid_per_form_csrf_token?(token, session = T.unsafe(nil)); end

  # Checks if the request originated from the same origin by looking at the Origin
  # header.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#625
  def valid_request_origin?; end

  # Returns true or false if a request is verified. Checks:
  #
  # *   Is it a GET or HEAD request? GETs should be safe and idempotent
  # *   Does the form_authenticity_token match the given token value from the
  #     params?
  # *   Does the `X-CSRF-Token` header match the form_authenticity_token?
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#461
  def verified_request?; end

  # The actual before_action that is used to verify the CSRF token. Don't override
  # this directly. Provide your own forgery protection strategy instead. If you
  # override, you'll disable same-origin `<script>` verification.
  #
  # Lean on the protect_from_forgery declaration to mark which actions are due for
  # same-origin request verification. If protect_from_forgery is enabled on an
  # action, this before_action flags its after_action to verify that JavaScript
  # responses are for XHR requests, ensuring they follow the browser's same-origin
  # policy.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#389
  def verify_authenticity_token; end

  # If `verify_authenticity_token` was run (indicating that we have
  # forgery protection enabled for this request) then also verify that we aren't
  # serving an unauthorized cross-origin response.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#427
  def verify_same_origin_request; end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#593
  def xor_byte_strings(s1, s2); end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
    def _helper_methods; end
    def _helper_methods=(value); end
    def _helper_methods?; end
  end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#452
ActionController::RequestForgeryProtection::AUTHENTICITY_TOKEN_LENGTH = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#417
ActionController::RequestForgeryProtection::CROSS_ORIGIN_JAVASCRIPT_WARNING = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#64
ActionController::RequestForgeryProtection::CSRF_TOKEN = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#106
module ActionController::RequestForgeryProtection::ClassMethods
  # Turn on request forgery protection. Bear in mind that GET and HEAD requests
  # are not checked.
  #
  #     class ApplicationController < ActionController::Base
  #       protect_from_forgery
  #     end
  #
  #     class FooController < ApplicationController
  #       protect_from_forgery except: :index
  #     end
  #
  # You can disable forgery protection on a controller using
  # skip_forgery_protection:
  #
  #     class BarController < ApplicationController
  #       skip_forgery_protection
  #     end
  #
  # Valid Options:
  #
  # *   `:only` / `:except` - Only apply forgery protection to a subset of
  #     actions. For example `only: [ :create, :create_all ]`.
  # *   `:if` / `:unless` - Turn off the forgery protection entirely depending on
  #     the passed Proc or method reference.
  # *   `:prepend` - By default, the verification of the authentication token will
  #     be added at the position of the protect_from_forgery call in your
  #     application. This means any callbacks added before are run first. This is
  #     useful when you want your forgery protection to depend on other callbacks,
  #     like authentication methods (Oauth vs Cookie auth).
  #
  #     If you need to add verification to the beginning of the callback chain,
  #     use `prepend: true`.
  # *   `:with` - Set the method to handle unverified request. Note if
  #     `default_protect_from_forgery` is true, Rails call protect_from_forgery
  #     with `with :exception`.
  #
  #
  # Built-in unverified request handling methods are:
  # *   `:exception` - Raises ActionController::InvalidAuthenticityToken
  #     exception.
  # *   `:reset_session` - Resets the session.
  # *   `:null_session` - Provides an empty session during request but doesn't
  #     reset it completely. Used as default if `:with` option is not specified.
  #
  #
  # You can also implement custom strategy classes for unverified request
  # handling:
  #
  #     class CustomStrategy
  #       def initialize(controller)
  #         @controller = controller
  #       end
  #
  #       def handle_unverified_request
  #         # Custom behavior for unverfied request
  #       end
  #     end
  #
  #     class ApplicationController < ActionController::Base
  #       protect_from_forgery with: CustomStrategy
  #     end
  #
  # *   `:store` - Set the strategy to store and retrieve CSRF tokens.
  #
  #
  # Built-in session token strategies are:
  # *   `:session` - Store the CSRF token in the session.  Used as default if
  #     `:store` option is not specified.
  # *   `:cookie` - Store the CSRF token in an encrypted cookie.
  #
  #
  # You can also implement custom strategy classes for CSRF token storage:
  #
  #     class CustomStore
  #       def fetch(request)
  #         # Return the token from a custom location
  #       end
  #
  #       def store(request, csrf_token)
  #         # Store the token in a custom location
  #       end
  #
  #       def reset(request)
  #         # Delete the stored session token
  #       end
  #     end
  #
  #     class ApplicationController < ActionController::Base
  #       protect_from_forgery store: CustomStore.new
  #     end
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#197
  def protect_from_forgery(options = T.unsafe(nil)); end

  # Turn off request forgery protection. This is a wrapper for:
  #
  #     skip_before_action :verify_authenticity_token
  #
  # See `skip_before_action` for allowed options.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#214
  def skip_forgery_protection(options = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#246
  def is_storage_strategy?(object); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#219
  def protection_method_class(name); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#234
  def storage_strategy(name); end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#331
class ActionController::RequestForgeryProtection::CookieStore
  # @return [CookieStore] a new instance of CookieStore
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#332
  def initialize(cookie = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#336
  def fetch(request); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#359
  def reset(request); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#348
  def store(request, csrf_token); end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#578
ActionController::RequestForgeryProtection::GLOBAL_CSRF_TOKEN_IDENTIFIER = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#614
ActionController::RequestForgeryProtection::NULL_ORIGIN_MESSAGE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#251
module ActionController::RequestForgeryProtection::ProtectionMethods; end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#304
class ActionController::RequestForgeryProtection::ProtectionMethods::Exception
  # @return [Exception] a new instance of Exception
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#307
  def initialize(controller); end

  # @raise [ActionController::InvalidAuthenticityToken]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#311
  def handle_unverified_request; end

  # Returns the value of attribute warning_message.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#305
  def warning_message; end

  # Sets the attribute warning_message
  #
  # @param value the value to set the attribute warning_message to.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#305
  def warning_message=(_arg0); end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#252
class ActionController::RequestForgeryProtection::ProtectionMethods::NullSession
  # @return [NullSession] a new instance of NullSession
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#253
  def initialize(controller); end

  # This is the method that defines the application behavior when a request is
  # found to be unverified.
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#259
  def handle_unverified_request; end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#287
class ActionController::RequestForgeryProtection::ProtectionMethods::NullSession::NullCookieJar < ::ActionDispatch::Cookies::CookieJar
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#288
  def write(*_arg0); end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#268
class ActionController::RequestForgeryProtection::ProtectionMethods::NullSession::NullSessionHash < ::Rack::Session::Abstract::SessionHash
  # @return [NullSessionHash] a new instance of NullSessionHash
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#269
  def initialize(req); end

  # no-op
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#276
  def destroy; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#282
  def enabled?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#278
  def exists?; end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#294
class ActionController::RequestForgeryProtection::ProtectionMethods::ResetSession
  # @return [ResetSession] a new instance of ResetSession
  #
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#295
  def initialize(controller); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#299
  def handle_unverified_request; end
end

# source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#317
class ActionController::RequestForgeryProtection::SessionStore
  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#318
  def fetch(request); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#326
  def reset(request); end

  # source://actionpack//lib/action_controller/metal/request_forgery_protection.rb#322
  def store(request, csrf_token); end
end

# # Action Controller Rescue
#
# This module is responsible for providing
# [rescue_from](rdoc-ref:ActiveSupport::Rescuable::ClassMethods#rescue_from) to
# controllers, wrapping actions to handle configured errors, and configuring
# when detailed exceptions must be shown.
#
# source://actionpack//lib/action_controller/metal/rescue.rb#12
module ActionController::Rescue
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Rescuable

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Rescuable::ClassMethods

  # Override this method if you want to customize when detailed exceptions must be
  # shown. This method is only called when `consider_all_requests_local` is
  # `false`. By default, it returns `false`, but someone may set it to
  # `request.local?` so local requests in production still show the detailed
  # exception pages.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/metal/rescue.rb#21
  def show_detailed_exceptions?; end

  private

  # source://actionpack//lib/action_controller/metal/rescue.rb#26
  def process_action(*_arg0); end

  module GeneratedClassMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end

  module GeneratedInstanceMethods
    def rescue_handlers; end
    def rescue_handlers=(value); end
    def rescue_handlers?; end
  end
end

# Raised when a nested respond_to is triggered and the content types of each are
# incompatible. For example:
#
#     respond_to do |outer_type|
#       outer_type.js do
#         respond_to do |inner_type|
#           inner_type.html { render body: "HTML" }
#         end
#       end
#     end
#
# source://actionpack//lib/action_controller/metal/exceptions.rb#88
class ActionController::RespondToMismatchError < ::ActionController::ActionControllerError
  # @return [RespondToMismatchError] a new instance of RespondToMismatchError
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#91
  def initialize(message = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#89
ActionController::RespondToMismatchError::DEFAULT_MESSAGE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/exceptions.rb#19
class ActionController::RoutingError < ::ActionController::ActionControllerError
  # @return [RoutingError] a new instance of RoutingError
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#21
  def initialize(message, failures = T.unsafe(nil)); end

  # Returns the value of attribute failures.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#20
  def failures; end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#64
class ActionController::SessionOverflowError < ::ActionController::ActionControllerError
  # @return [SessionOverflowError] a new instance of SessionOverflowError
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#67
  def initialize(message = T.unsafe(nil)); end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#65
ActionController::SessionOverflowError::DEFAULT_MESSAGE = T.let(T.unsafe(nil), String)

# # Action Controller Streaming
#
# Allows views to be streamed back to the client as they are rendered.
#
# By default, Rails renders views by first rendering the template and then the
# layout. The response is sent to the client after the whole template is
# rendered, all queries are made, and the layout is processed.
#
# Streaming inverts the rendering flow by rendering the layout first and
# subsequently each part of the layout as they are processed. This allows the
# header of the HTML (which is usually in the layout) to be streamed back to
# client very quickly, enabling JavaScripts and stylesheets to be loaded earlier
# than usual.
#
# Several Rack middlewares may not work and you need to be careful when
# streaming. This is covered in more detail below, see the Streaming@Middlewares
# section.
#
# Streaming can be added to a given template easily, all you need to do is to
# pass the `:stream` option to `render`.
#
#     class PostsController
#       def index
#         @posts = Post.all
#         render stream: true
#       end
#     end
#
# ## When to use streaming
#
# Streaming may be considered to be overkill for lightweight actions like `new`
# or `edit`. The real benefit of streaming is on expensive actions that, for
# example, do a lot of queries on the database.
#
# In such actions, you want to delay queries execution as much as you can. For
# example, imagine the following `dashboard` action:
#
#     def dashboard
#       @posts = Post.all
#       @pages = Page.all
#       @articles = Article.all
#     end
#
# Most of the queries here are happening in the controller. In order to benefit
# from streaming you would want to rewrite it as:
#
#     def dashboard
#       # Allow lazy execution of the queries
#       @posts = Post.all
#       @pages = Page.all
#       @articles = Article.all
#       render stream: true
#     end
#
# Notice that `:stream` only works with templates. Rendering `:json` or `:xml`
# with `:stream` won't work.
#
# ## Communication between layout and template
#
# When streaming, rendering happens top-down instead of inside-out. Rails starts
# with the layout, and the template is rendered later, when its `yield` is
# reached.
#
# This means that, if your application currently relies on instance variables
# set in the template to be used in the layout, they won't work once you move to
# streaming. The proper way to communicate between layout and template,
# regardless of whether you use streaming or not, is by using `content_for`,
# `provide`, and `yield`.
#
# Take a simple example where the layout expects the template to tell which
# title to use:
#
#     <html>
#       <head><title><%= yield :title %></title></head>
#       <body><%= yield %></body>
#     </html>
#
# You would use `content_for` in your template to specify the title:
#
#     <%= content_for :title, "Main" %>
#     Hello
#
# And the final result would be:
#
#     <html>
#       <head><title>Main</title></head>
#       <body>Hello</body>
#     </html>
#
# However, if `content_for` is called several times, the final result would have
# all calls concatenated. For instance, if we have the following template:
#
#     <%= content_for :title, "Main" %>
#     Hello
#     <%= content_for :title, " page" %>
#
# The final result would be:
#
#     <html>
#       <head><title>Main page</title></head>
#       <body>Hello</body>
#     </html>
#
# This means that, if you have `yield :title` in your layout and you want to use
# streaming, you would have to render the whole template (and eventually trigger
# all queries) before streaming the title and all assets, which defeats the
# purpose of streaming. Alternatively, you can use a helper called `provide`
# that does the same as `content_for` but tells the layout to stop searching for
# other entries and continue rendering.
#
# For instance, the template above using `provide` would be:
#
#     <%= provide :title, "Main" %>
#     Hello
#     <%= content_for :title, " page" %>
#
# Resulting in:
#
#     <html>
#       <head><title>Main</title></head>
#       <body>Hello</body>
#     </html>
#
# That said, when streaming, you need to properly check your templates and
# choose when to use `provide` and `content_for`.
#
# See also ActionView::Helpers::CaptureHelper for more information.
#
# ## Headers, cookies, session, and flash
#
# When streaming, the HTTP headers are sent to the client right before it
# renders the first line. This means that, modifying headers, cookies, session
# or flash after the template starts rendering will not propagate to the client.
#
# ## Middlewares
#
# Middlewares that need to manipulate the body won't work with streaming. You
# should disable those middlewares whenever streaming in development or
# production. For instance, `Rack::Bug` won't work when streaming as it needs to
# inject contents in the HTML body.
#
# Also `Rack::Cache` won't work with streaming as it does not support streaming
# bodies yet. Whenever streaming `Cache-Control` is automatically set to
# "no-cache".
#
# ## Errors
#
# When it comes to streaming, exceptions get a bit more complicated. This
# happens because part of the template was already rendered and streamed to the
# client, making it impossible to render a whole exception page.
#
# Currently, when an exception happens in development or production, Rails will
# automatically stream to the client:
#
#     "><script>window.location = "/500.html"</script></html>
#
# The first two characters (`">`) are required in case the exception happens
# while rendering attributes for a given tag. You can check the real cause for
# the exception in your logger.
#
# ## Web server support
#
# Not all web servers support streaming out-of-the-box. You need to check the
# instructions for each of them.
#
# #### Unicorn
#
# Unicorn supports streaming but it needs to be configured. For this, you need
# to create a config file as follow:
#
#     # unicorn.config.rb
#     listen 3000, tcp_nopush: false
#
# And use it on initialization:
#
#     unicorn_rails --config-file unicorn.config.rb
#
# You may also want to configure other parameters like `:tcp_nodelay`.
#
# For more information, please check the
# [documentation](https://bogomips.org/unicorn/Unicorn/Configurator.html#method-
# i-listen).
#
# If you are using Unicorn with NGINX, you may need to tweak NGINX. Streaming
# should work out of the box on Rainbows.
#
# #### Passenger
#
# Phusion Passenger with NGINX, offers two streaming mechanisms out of the box.
#
# 1.  NGINX response buffering mechanism which is dependent on the value of
#     `passenger_buffer_response` option (default is "off").
# 2.  Passenger buffering system which is always 'on' irrespective of the value
#     of `passenger_buffer_response`.
#
#
# When `passenger_buffer_response` is turned "on", then streaming would be done
# at the NGINX level which waits until the application is done sending the
# response back to the client.
#
# For more information, please check the [documentation]
# (https://www.phusionpassenger.com/docs/references/config_reference/nginx/#passenger_buffer_response).
#
# source://actionpack//lib/action_controller/metal/streaming.rb#208
module ActionController::Streaming
  private

  # Set proper cache control and transfer encoding when streaming
  #
  # source://actionpack//lib/action_controller/metal/streaming.rb#240
  def _process_options(options); end

  # Call render_body if we are streaming instead of usual `render`.
  #
  # source://actionpack//lib/action_controller/metal/streaming.rb#254
  def _render_template(options); end
end

# source://actionpack//lib/action_controller/metal/streaming.rb#209
class ActionController::Streaming::Body
  # Store the response body to be chunked.
  #
  # @return [Body] a new instance of Body
  #
  # source://actionpack//lib/action_controller/metal/streaming.rb#214
  def initialize(body); end

  # Close the response body if the response body supports it.
  #
  # source://actionpack//lib/action_controller/metal/streaming.rb#233
  def close; end

  # For each element yielded by the response body, yield the element in chunked
  # encoding.
  #
  # @yield [TAIL]
  #
  # source://actionpack//lib/action_controller/metal/streaming.rb#220
  def each(&block); end
end

# source://actionpack//lib/action_controller/metal/streaming.rb#211
ActionController::Streaming::Body::TAIL = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_controller/metal/streaming.rb#210
ActionController::Streaming::Body::TERM = T.let(T.unsafe(nil), String)

# # Strong Parameters
#
# It provides an interface for protecting attributes from end-user assignment.
# This makes Action Controller parameters forbidden to be used in Active Model
# mass assignment until they have been explicitly enumerated.
#
# In addition, parameters can be marked as required and flow through a
# predefined raise/rescue flow to end up as a `400 Bad Request` with no effort.
#
#     class PeopleController < ActionController::Base
#       # Using "Person.create(params[:person])" would raise an
#       # ActiveModel::ForbiddenAttributesError exception because it'd
#       # be using mass assignment without an explicit permit step.
#       # This is the recommended form:
#       def create
#         Person.create(person_params)
#       end
#
#       # This will pass with flying colors as long as there's a person key in the
#       # parameters, otherwise it'll raise an ActionController::ParameterMissing
#       # exception, which will get caught by ActionController::Base and turned
#       # into a 400 Bad Request reply.
#       def update
#         redirect_to current_account.people.find(params[:id]).tap { |person|
#           person.update!(person_params)
#         }
#       end
#
#       private
#         # Using a private method to encapsulate the permissible parameters is
#         # a good pattern since you'll be able to reuse the same permit
#         # list between create and update. Also, you can specialize this method
#         # with per-user checking of permissible attributes.
#         def person_params
#           params.require(:person).permit(:name, :age)
#         end
#     end
#
# In order to use `accepts_nested_attributes_for` with Strong Parameters, you
# will need to specify which nested attributes should be permitted. You might
# want to allow `:id` and `:_destroy`, see ActiveRecord::NestedAttributes for
# more information.
#
#     class Person
#       has_many :pets
#       accepts_nested_attributes_for :pets
#     end
#
#     class PeopleController < ActionController::Base
#       def create
#         Person.create(person_params)
#       end
#
#       ...
#
#       private
#
#         def person_params
#           # It's mandatory to specify the nested attributes that should be permitted.
#           # If you use `permit` with just the key that points to the nested attributes hash,
#           # it will return an empty hash.
#           params.require(:person).permit(:name, :age, pets_attributes: [ :id, :name, :category ])
#         end
#     end
#
# See ActionController::Parameters.require and
# ActionController::Parameters.permit for more information.
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#1323
module ActionController::StrongParameters
  # Returns a new ActionController::Parameters object that has been instantiated
  # with the `request.parameters`.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1326
  def params; end

  # Assigns the given `value` to the `params` hash. If `value` is a Hash, this
  # will create an ActionController::Parameters object that has been instantiated
  # with the given `value` hash.
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#1341
  def params=(value); end
end

# source://actionpack//lib/action_controller/template_assertions.rb#6
module ActionController::TemplateAssertions
  # @raise [NoMethodError]
  #
  # source://actionpack//lib/action_controller/template_assertions.rb#7
  def assert_template(options = T.unsafe(nil), message = T.unsafe(nil)); end
end

# # Action Controller Test Case
#
# Superclass for ActionController functional tests. Functional tests allow you
# to test a single controller action per test method.
#
# ## Use integration style controller tests over functional style controller tests.
#
# Rails discourages the use of functional tests in favor of integration tests
# (use ActionDispatch::IntegrationTest).
#
# New Rails applications no longer generate functional style controller tests
# and they should only be used for backward compatibility. Integration style
# controller tests perform actual requests, whereas functional style controller
# tests merely simulate a request. Besides, integration tests are as fast as
# functional tests and provide lot of helpers such as `as`, `parsed_body` for
# effective testing of controller actions including even API endpoints.
#
# ## Basic example
#
# Functional tests are written as follows:
# 1.  First, one uses the `get`, `post`, `patch`, `put`, `delete`, or `head`
#     method to simulate an HTTP request.
# 2.  Then, one asserts whether the current state is as expected. "State" can be
#     anything: the controller's HTTP response, the database contents, etc.
#
#
# For example:
#
#     class BooksControllerTest < ActionController::TestCase
#       def test_create
#         # Simulate a POST response with the given HTTP parameters.
#         post(:create, params: { book: { title: "Love Hina" }})
#
#         # Asserts that the controller tried to redirect us to
#         # the created book's URI.
#         assert_response :found
#
#         # Asserts that the controller really put the book in the database.
#         assert_not_nil Book.find_by(title: "Love Hina")
#       end
#     end
#
# You can also send a real document in the simulated HTTP request.
#
#     def test_create
#       json = {book: { title: "Love Hina" }}.to_json
#       post :create, body: json
#     end
#
# ## Special instance variables
#
# ActionController::TestCase will also automatically provide the following
# instance variables for use in the tests:
#
# :   The controller instance that will be tested.
#
# :   An ActionController::TestRequest, representing the current HTTP request.
#     You can modify this object before sending the HTTP request. For example,
#     you might want to set some session properties before sending a GET
#     request.
#
# :   An ActionDispatch::TestResponse object, representing the response of the
#     last HTTP response. In the above example, `@response` becomes valid after
#     calling `post`. If the various assert methods are not sufficient, then you
#     may use this object to inspect the HTTP response in detail.
#
#
# ## Controller is automatically inferred
#
# ActionController::TestCase will automatically infer the controller under test
# from the test class name. If the controller cannot be inferred from the test
# class name, you can explicitly set it with `tests`.
#
#     class SpecialEdgeCaseWidgetsControllerTest < ActionController::TestCase
#       tests WidgetController
#     end
#
# ## Testing controller internals
#
# In addition to these specific assertions, you also have easy access to various
# collections that the regular test/unit assertions can be used against. These
# collections are:
#
# *   session: Objects being saved in the session.
# *   flash: The flash objects currently in the session.
# *   cookies: Cookies being sent to the user on this request.
#
#
# These collections can be used just like any other hash:
#
#     assert_equal "Dave", cookies[:name] # makes sure that a cookie called :name was set as "Dave"
#     assert flash.empty? # makes sure that there's nothing in the flash
#
# On top of the collections, you have the complete URL that a given action
# redirected to available in `redirect_to_url`.
#
# For redirects within the same controller, you can even call follow_redirect
# and the redirect will be followed, triggering another action call which can
# then be asserted against.
#
# ## Manipulating session and cookie variables
#
# Sometimes you need to set up the session and cookie variables for a test. To
# do this just assign a value to the session or cookie collection:
#
#     session[:key] = "value"
#     cookies[:key] = "value"
#
# To clear the cookies for a test just clear the cookie collection:
#
#     cookies.clear
#
# ## Testing named routes
#
# If you're using named routes, they can be easily tested using the original
# named routes' methods straight in the test case.
#
#     assert_redirected_to page_url(title: 'foo')
#
# source://actionpack//lib/action_controller/test_case.rb#358
class ActionController::TestCase < ::ActiveSupport::TestCase
  include ::ActiveSupport::Testing::ConstantLookup
  include ::ActionDispatch::TestProcess::FixtureFile
  include ::ActionDispatch::TestProcess
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  include ::ActionController::TestCase::Behavior
  include ::ActionController::TemplateAssertions
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions
  extend ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  extend ::ActionController::TestCase::Behavior::ClassMethods
  extend ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # source://actionpack//lib/action_controller/test_case.rb#591
  def _controller_class; end

  # source://actionpack//lib/action_controller/test_case.rb#591
  def _controller_class=(_arg0); end

  # source://actionpack//lib/action_controller/test_case.rb#591
  def _controller_class?; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionpack//lib/action_controller/test_case.rb#591
    def _controller_class; end

    # source://actionpack//lib/action_controller/test_case.rb#591
    def _controller_class=(value); end

    # source://actionpack//lib/action_controller/test_case.rb#591
    def _controller_class?; end

    # source://actionpack//lib/action_controller/test_case.rb#359
    def executor_around_each_request; end

    # source://actionpack//lib/action_controller/test_case.rb#359
    def executor_around_each_request=(_arg0); end
  end
end

# source://actionpack//lib/action_controller/test_case.rb#361
module ActionController::TestCase::Behavior
  include ::ActionDispatch::TestProcess::FixtureFile
  include ::ActionDispatch::TestProcess
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Testing::ConstantLookup
  include ::ActionController::TemplateAssertions
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  mixes_in_class_methods ::ActionController::TestCase::Behavior::ClassMethods
  mixes_in_class_methods ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # source://actionpack//lib/action_controller/test_case.rb#584
  def build_response(klass); end

  # source://actionpack//lib/action_controller/test_case.rb#544
  def controller_class_name; end

  # Simulate a DELETE request with the given parameters and set/volley the
  # response. See `get` for more details.
  #
  # source://actionpack//lib/action_controller/test_case.rb#455
  def delete(action, **args); end

  # source://actionpack//lib/action_controller/test_case.rb#548
  def generated_path(generated_extras); end

  # Simulate a GET request with the given parameters.
  #
  # *   `action`: The controller action to call.
  # *   `params`: The hash with HTTP parameters that you want to pass. This may be
  #     `nil`.
  # *   `body`: The request body with a string that is appropriately encoded
  #     (`application/x-www-form-urlencoded` or `multipart/form-data`).
  # *   `session`: A hash of parameters to store in the session. This may be
  #     `nil`.
  # *   `flash`: A hash of parameters to store in the flash. This may be `nil`.
  #
  #
  # You can also simulate POST, PATCH, PUT, DELETE, and HEAD requests with `post`,
  # `patch`, `put`, `delete`, and `head`. Example sending parameters, session, and
  # setting a flash message:
  #
  #     get :show,
  #       params: { id: 7 },
  #       session: { user_id: 1 },
  #       flash: { notice: 'This is flash message' }
  #
  # Note that the request method is not verified. The different methods are
  # available to make the tests more expressive.
  #
  # source://actionpack//lib/action_controller/test_case.rb#429
  def get(action, **args); end

  # Simulate a HEAD request with the given parameters and set/volley the response.
  # See `get` for more details.
  #
  # source://actionpack//lib/action_controller/test_case.rb#461
  def head(action, **args); end

  # Simulate a PATCH request with the given parameters and set/volley the
  # response. See `get` for more details.
  #
  # source://actionpack//lib/action_controller/test_case.rb#443
  def patch(action, **args); end

  # Simulate a POST request with the given parameters and set/volley the response.
  # See `get` for more details.
  #
  # source://actionpack//lib/action_controller/test_case.rb#437
  def post(action, **args); end

  # Simulate an HTTP request to `action` by specifying request method, parameters
  # and set/volley the response.
  #
  # *   `action`: The controller action to call.
  # *   `method`: Request method used to send the HTTP request. Possible values
  #     are `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, `HEAD`. Defaults to `GET`.
  #     Can be a symbol.
  # *   `params`: The hash with HTTP parameters that you want to pass. This may be
  #     `nil`.
  # *   `body`: The request body with a string that is appropriately encoded
  #     (`application/x-www-form-urlencoded` or `multipart/form-data`).
  # *   `session`: A hash of parameters to store in the session. This may be
  #     `nil`.
  # *   `flash`: A hash of parameters to store in the flash. This may be `nil`.
  # *   `format`: Request format. Defaults to `nil`. Can be string or symbol.
  # *   `as`: Content type. Defaults to `nil`. Must be a symbol that corresponds
  #     to a mime type.
  #
  #
  # Example calling `create` action and sending two params:
  #
  #     process :create,
  #       method: 'POST',
  #       params: {
  #         user: { name: 'Gaurish Sharma', email: 'user@example.com' }
  #       },
  #       session: { user_id: 1 },
  #       flash: { notice: 'This is flash message' }
  #
  # To simulate `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, and `HEAD` requests
  # prefer using #get, #post, #patch, #put, #delete and #head methods respectively
  # which will make tests more expressive.
  #
  # It's not recommended to make more than one request in the same test. Instance
  # variables that are set in one request will not persist to the next request,
  # but it's not guaranteed that all Rails internal state will be reset. Prefer
  # ActionDispatch::IntegrationTest for making multiple requests in the same test.
  #
  # Note that the request method is not verified.
  #
  # source://actionpack//lib/action_controller/test_case.rb#504
  def process(action, method: T.unsafe(nil), params: T.unsafe(nil), session: T.unsafe(nil), body: T.unsafe(nil), flash: T.unsafe(nil), format: T.unsafe(nil), xhr: T.unsafe(nil), as: T.unsafe(nil)); end

  # Simulate a PUT request with the given parameters and set/volley the response.
  # See `get` for more details.
  #
  # source://actionpack//lib/action_controller/test_case.rb#449
  def put(action, **args); end

  # source://actionpack//lib/action_controller/test_case.rb#552
  def query_parameter_names(generated_extras); end

  # Returns the value of attribute request.
  #
  # source://actionpack//lib/action_controller/test_case.rb#367
  def request; end

  # Returns the value of attribute response.
  #
  # source://actionpack//lib/action_controller/test_case.rb#367
  def response; end

  # source://actionpack//lib/action_controller/test_case.rb#556
  def setup_controller_request_and_response; end

  private

  # source://actionpack//lib/action_controller/test_case.rb#676
  def check_required_ivars; end

  # source://actionpack//lib/action_controller/test_case.rb#672
  def document_root_element; end

  # source://actionpack//lib/action_controller/test_case.rb#627
  def process_controller_response(action, cookies, xhr); end

  # source://actionpack//lib/action_controller/test_case.rb#662
  def scrub_env!(env); end

  # source://actionpack//lib/action_controller/test_case.rb#597
  def setup_request(controller_class_name, action, parameters, session, flash, xhr); end

  # source://actionpack//lib/action_controller/test_case.rb#619
  def wrap_execution(&block); end

  module GeneratedClassMethods
    def _controller_class; end
    def _controller_class=(value); end
    def _controller_class?; end
  end

  module GeneratedInstanceMethods
    def _controller_class; end
    def _controller_class=(value); end
    def _controller_class?; end
  end
end

# source://actionpack//lib/action_controller/test_case.rb#369
module ActionController::TestCase::Behavior::ClassMethods
  # source://actionpack//lib/action_controller/test_case.rb#391
  def controller_class; end

  # source://actionpack//lib/action_controller/test_case.rb#387
  def controller_class=(new_class); end

  # source://actionpack//lib/action_controller/test_case.rb#399
  def determine_default_controller_class(name); end

  # Sets the controller class name. Useful if the name can't be inferred from test
  # class. Normalizes `controller_class` before using.
  #
  #     tests WidgetController
  #     tests :widget
  #     tests 'widget'
  #
  # source://actionpack//lib/action_controller/test_case.rb#376
  def tests(controller_class); end
end

# ActionController::TestCase will be deprecated and moved to a gem in the
# future. Please use ActionDispatch::IntegrationTest going forward.
#
# source://actionpack//lib/action_controller/test_case.rb#36
class ActionController::TestRequest < ::ActionDispatch::TestRequest
  # @return [TestRequest] a new instance of TestRequest
  #
  # source://actionpack//lib/action_controller/test_case.rb#59
  def initialize(env, session, controller_class); end

  # source://actionpack//lib/action_controller/test_case.rb#78
  def assign_parameters(routes, controller_path, action, parameters, generated_path, query_string_keys); end

  # source://actionpack//lib/action_controller/test_case.rb#74
  def content_type=(type); end

  # Returns the value of attribute controller_class.
  #
  # source://actionpack//lib/action_controller/test_case.rb#44
  def controller_class; end

  # source://actionpack//lib/action_controller/test_case.rb#70
  def query_string=(string); end

  private

  # source://actionpack//lib/action_controller/test_case.rb#169
  def params_parsers; end

  class << self
    # Create a new test request with default `env` values.
    #
    # source://actionpack//lib/action_controller/test_case.rb#47
    def create(controller_class); end

    # source://actionpack//lib/action_controller/test_case.rb#40
    def new_session; end

    private

    # source://actionpack//lib/action_controller/test_case.rb#54
    def default_env; end
  end
end

# source://actionpack//lib/action_controller/test_case.rb#37
ActionController::TestRequest::DEFAULT_ENV = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/test_case.rb#141
ActionController::TestRequest::ENCODER = T.let(T.unsafe(nil), T.untyped)

# Methods #destroy and #load! are overridden to avoid calling methods on the
#
# source://actionpack//lib/action_controller/test_case.rb#187
class ActionController::TestSession < ::Rack::Session::Abstract::PersistedSecure::SecureSessionHash
  # @return [TestSession] a new instance of TestSession
  #
  # source://actionpack//lib/action_controller/test_case.rb#190
  def initialize(session = T.unsafe(nil), id = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/test_case.rb#210
  def destroy; end

  # source://actionpack//lib/action_controller/test_case.rb#214
  def dig(*keys); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/test_case.rb#223
  def enabled?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_controller/test_case.rb#198
  def exists?; end

  # source://actionpack//lib/action_controller/test_case.rb#219
  def fetch(key, *args, &block); end

  # source://actionpack//lib/action_controller/test_case.rb#227
  def id_was; end

  # source://actionpack//lib/action_controller/test_case.rb#202
  def keys; end

  # source://actionpack//lib/action_controller/test_case.rb#206
  def values; end

  private

  # source://actionpack//lib/action_controller/test_case.rb#232
  def load!; end
end

# source://actionpack//lib/action_controller/test_case.rb#188
ActionController::TestSession::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_controller/metal/testing.rb#6
module ActionController::Testing; end

# Behavior specific to functional tests
#
# source://actionpack//lib/action_controller/metal/testing.rb#8
module ActionController::Testing::Functional
  # source://actionpack//lib/action_controller/metal/testing.rb#9
  def clear_instance_variables_between_requests; end

  # source://actionpack//lib/action_controller/metal/testing.rb#18
  def recycle!; end
end

# Raised when a Parameters instance is not marked as permitted and an operation
# to transform it to hash is called.
#
#     params = ActionController::Parameters.new(a: "123", b: "456")
#     params.to_h
#     # => ActionController::UnfilteredParameters: unable to convert unpermitted parameters to hash
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#64
class ActionController::UnfilteredParameters < ::ArgumentError
  # @return [UnfilteredParameters] a new instance of UnfilteredParameters
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#65
  def initialize; end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#75
class ActionController::UnknownFormat < ::ActionController::ActionControllerError; end

# source://actionpack//lib/action_controller/metal/exceptions.rb#72
class ActionController::UnknownHttpMethod < ::ActionController::ActionControllerError; end

# Raised when a supplied parameter is not expected and
# ActionController::Parameters.action_on_unpermitted_parameters is set to
# `:raise`.
#
#     params = ActionController::Parameters.new(a: "123", b: "456")
#     params.permit(:c)
#     # => ActionController::UnpermittedParameters: found unpermitted parameters: :a, :b
#
# source://actionpack//lib/action_controller/metal/strong_parameters.rb#49
class ActionController::UnpermittedParameters < ::IndexError
  # @return [UnpermittedParameters] a new instance of UnpermittedParameters
  #
  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#52
  def initialize(params); end

  # source://actionpack//lib/action_controller/metal/strong_parameters.rb#50
  def params; end
end

# # Action Controller UrlFor
#
# Includes `url_for` into the host class. The class has to provide a `RouteSet`
# by implementing the `_routes` method. Otherwise, an exception will be raised.
#
# In addition to AbstractController::UrlFor, this module accesses the HTTP layer
# to define URL options like the `host`. In order to do so, this module requires
# the host class to implement `env` which needs to be Rack-compatible, and
# `request` which returns an ActionDispatch::Request instance.
#
#     class RootUrl
#       include ActionController::UrlFor
#       include Rails.application.routes.url_helpers
#
#       delegate :env, :request, to: :controller
#
#       def initialize(controller)
#         @controller = controller
#         @url        = root_path # named route from the application.
#       end
#     end
#
# source://actionpack//lib/action_controller/metal/url_for.rb#27
module ActionController::UrlFor
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionDispatch::Routing::UrlFor
  include ::AbstractController::UrlFor

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::AbstractController::UrlFor::ClassMethods

  # source://actionpack//lib/action_controller/metal/url_for.rb#32
  def initialize(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_controller/metal/url_for.rb#37
  def url_options; end

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

# source://actionpack//lib/action_controller/metal/exceptions.rb#27
class ActionController::UrlGenerationError < ::ActionController::ActionControllerError
  include ::DidYouMean::Correctable

  # @return [UrlGenerationError] a new instance of UrlGenerationError
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#30
  def initialize(message, routes = T.unsafe(nil), route_name = T.unsafe(nil), method_name = T.unsafe(nil)); end

  # source://actionpack//lib/action_controller/metal/exceptions.rb#41
  def corrections; end

  # Returns the value of attribute method_name.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#28
  def method_name; end

  # Returns the value of attribute route_name.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#28
  def route_name; end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_controller/metal/exceptions.rb#28
  def routes; end
end

# # Action Dispatch
#
# Action Dispatch is a module of Action Pack.
#
# Action Dispatch parses information about the web request, handles routing as
# defined by the user, and does advanced processing related to HTTP such as
# MIME-type negotiation, decoding parameters in POST, PATCH, or PUT bodies,
# handling HTTP caching logic, cookies and sessions.
#
# source://actionpack//lib/action_dispatch/deprecator.rb#5
module ActionDispatch
  extend ::ActiveSupport::Autoload

  # source://actionpack//lib/action_dispatch.rb#135
  def eager_load!; end

  # source://actionpack//lib/action_dispatch.rb#121
  def test_app; end

  # source://actionpack//lib/action_dispatch.rb#121
  def test_app=(val); end

  class << self
    # source://actionpack//lib/action_dispatch/deprecator.rb#6
    def deprecator; end

    # source://actionpack//lib/action_dispatch.rb#121
    def test_app; end

    # source://actionpack//lib/action_dispatch.rb#121
    def test_app=(val); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#9
class ActionDispatch::ActionableExceptions
  # @return [ActionableExceptions] a new instance of ActionableExceptions
  #
  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#12
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#16
  def call(env); end

  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#10
  def endpoint; end

  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#10
  def endpoint=(val); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#26
  def actionable_request?(request); end

  # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#30
  def redirect_to(location); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#10
    def endpoint; end

    # source://actionpack//lib/action_dispatch/middleware/actionable_exceptions.rb#10
    def endpoint=(val); end
  end
end

# This is a class that abstracts away an asserted response. It purposely does
# not inherit from Response because it doesn't need it. That means it does not
# have headers or a body.
#
# source://actionpack//lib/action_dispatch/testing/assertion_response.rb#9
class ActionDispatch::AssertionResponse
  # Accepts a specific response status code as an Integer (404) or String ('404')
  # or a response status range as a Symbol pseudo-code (:success, indicating any
  # 200-299 status code).
  #
  # @raise [ArgumentError]
  # @return [AssertionResponse] a new instance of AssertionResponse
  #
  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#22
  def initialize(code_or_name); end

  # Returns the value of attribute code.
  #
  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#10
  def code; end

  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#35
  def code_and_name; end

  # Returns the value of attribute name.
  #
  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#10
  def name; end

  private

  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#40
  def code_from_name(name); end

  # source://actionpack//lib/action_dispatch/testing/assertion_response.rb#44
  def name_from_code(code); end
end

# source://actionpack//lib/action_dispatch/testing/assertion_response.rb#12
ActionDispatch::AssertionResponse::GENERIC_RESPONSE_CODES = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/testing/assertions/response.rb#6
module ActionDispatch::Assertions
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  extend ::ActiveSupport::Concern
  include ::ActionDispatch::Assertions::RoutingAssertions

  mixes_in_class_methods ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # source://actionpack//lib/action_dispatch/testing/assertions.rb#17
  def html_document; end
end

# A small suite of assertions that test responses from Rails applications.
#
# source://actionpack//lib/action_dispatch/testing/assertions/response.rb#8
module ActionDispatch::Assertions::ResponseAssertions
  # Asserts that the response is a redirect to a URL matching the given options.
  #
  #     # Asserts that the redirection was to the "index" action on the WeblogController
  #     assert_redirected_to controller: "weblog", action: "index"
  #
  #     # Asserts that the redirection was to the named route login_url
  #     assert_redirected_to login_url
  #
  #     # Asserts that the redirection was to the URL for @customer
  #     assert_redirected_to @customer
  #
  #     # Asserts that the redirection matches the regular expression
  #     assert_redirected_to %r(\Ahttp://example.org)
  #
  #     # Asserts that the redirection has the HTTP status code 301 (Moved
  #     # Permanently).
  #     assert_redirected_to "/some/path", status: :moved_permanently
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#60
  def assert_redirected_to(url_options = T.unsafe(nil), options = T.unsafe(nil), message = T.unsafe(nil)); end

  # Asserts that the response is one of the following types:
  #
  # *   `:success`   - Status code was in the 200-299 range
  # *   `:redirect`  - Status code was in the 300-399 range
  # *   `:missing`   - Status code was 404
  # *   `:error`     - Status code was in the 500-599 range
  #
  #
  # You can also pass an explicit status number like `assert_response(501)` or its
  # symbolic equivalent `assert_response(:not_implemented)`. See
  # `Rack::Utils::SYMBOL_TO_STATUS_CODE` for a full list.
  #
  #     # Asserts that the response was a redirection
  #     assert_response :redirect
  #
  #     # Asserts that the response code was status code 401 (unauthorized)
  #     assert_response 401
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#33
  def assert_response(type, message = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#105
  def code_with_name(code_or_name); end

  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#89
  def generate_response_message(expected, actual = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#99
  def location_if_redirected; end

  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#80
  def normalize_argument_to_redirection(fragment); end

  # Proxy to to_param if the object will respond to it.
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#76
  def parameterize(value); end

  # source://actionpack//lib/action_dispatch/testing/assertions/response.rb#94
  def response_body_if_short; end
end

# source://actionpack//lib/action_dispatch/testing/assertions/response.rb#9
ActionDispatch::Assertions::ResponseAssertions::RESPONSE_PREDICATES = T.let(T.unsafe(nil), Hash)

# Suite of assertions to test routes generated by Rails and the handling of
# requests made to them.
#
# source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#14
module ActionDispatch::Assertions::RoutingAssertions
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # Asserts that the provided options can be used to generate the provided path.
  # This is the inverse of `assert_recognizes`. The `extras` parameter is used to
  # tell the request the names and values of additional request parameters that
  # would be in a query string. The `message` parameter allows you to specify a
  # custom error message for assertion failures.
  #
  # The `defaults` parameter is unused.
  #
  #     # Asserts that the default action is generated for a route with no action
  #     assert_generates "/items", controller: "items", action: "index"
  #
  #     # Tests that the list action is properly routed
  #     assert_generates "/items/list", controller: "items", action: "list"
  #
  #     # Tests the generation of a route with a parameter
  #     assert_generates "/items/list/1", { controller: "items", action: "list", id: "1" }
  #
  #     # Asserts that the generated route gives us our custom route
  #     assert_generates "changesets/12", { controller: 'scm', action: 'show_diff', revision: "12" }
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#204
  def assert_generates(expected_path, options, defaults = T.unsafe(nil), extras = T.unsafe(nil), message = T.unsafe(nil)); end

  # Asserts that the routing of the given `path` was handled correctly and that
  # the parsed options (given in the `expected_options` hash) match `path`.
  # Basically, it asserts that Rails recognizes the route given by
  # `expected_options`.
  #
  # Pass a hash in the second argument (`path`) to specify the request method.
  # This is useful for routes requiring a specific HTTP method. The hash should
  # contain a `:path` with the incoming request path and a `:method` containing
  # the required HTTP verb.
  #
  #     # Asserts that POSTing to /items will call the create action on ItemsController
  #     assert_recognizes({controller: 'items', action: 'create'}, {path: 'items', method: :post})
  #
  # You can also pass in `extras` with a hash containing URL parameters that would
  # normally be in the query string. This can be used to assert that values in the
  # query string will end up in the params hash correctly. To test query strings
  # you must use the extras argument because appending the query string on the
  # path directly will not work. For example:
  #
  #     # Asserts that a path of '/items/list/1?view=print' returns the correct options
  #     assert_recognizes({controller: 'items', action: 'list', id: '1', view: 'print'}, 'items/list/1', { view: "print" })
  #
  # The `message` parameter allows you to pass in an error message that is
  # displayed upon failure.
  #
  #     # Check the default route (i.e., the index action)
  #     assert_recognizes({controller: 'items', action: 'index'}, 'items')
  #
  #     # Test a specific action
  #     assert_recognizes({controller: 'items', action: 'list'}, 'items/list')
  #
  #     # Test an action with a parameter
  #     assert_recognizes({controller: 'items', action: 'destroy', id: '1'}, 'items/destroy/1')
  #
  #     # Test a custom route
  #     assert_recognizes({controller: 'items', action: 'show', id: '1'}, 'view/item1')
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#164
  def assert_recognizes(expected_options, path, extras = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Asserts that path and options match both ways; in other words, it verifies
  # that `path` generates `options` and then that `options` generates `path`. This
  # essentially combines `assert_recognizes` and `assert_generates` into one step.
  #
  # The `extras` hash allows you to specify options that would normally be
  # provided as a query string to the action. The `message` parameter allows you
  # to specify a custom error message to display upon failure.
  #
  #     # Asserts a basic route: a controller with the default action (index)
  #     assert_routing '/home', controller: 'home', action: 'index'
  #
  #     # Test a route generated with a specific controller, action, and parameter (id)
  #     assert_routing '/entries/show/23', controller: 'entries', action: 'show', id: 23
  #
  #     # Asserts a basic route (controller + default action), with an error message if it fails
  #     assert_routing '/store', { controller: 'store', action: 'index' }, {}, {}, 'Route for store index not generated properly'
  #
  #     # Tests a route, providing a defaults hash
  #     assert_routing 'controller/action/9', {id: "9", item: "square"}, {controller: "controller", action: "action"}, {}, {item: "square"}
  #
  #     # Tests a route with an HTTP method
  #     assert_routing({ method: 'put', path: '/product/321' }, { controller: "product", action: "update", id: "321" })
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#248
  def assert_routing(path, options, defaults = T.unsafe(nil), extras = T.unsafe(nil), message = T.unsafe(nil)); end

  # ROUTES TODO: These assertions should really work in an integration context
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#261
  def method_missing(selector, *_arg1, **_arg2, &_arg3); end

  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#103
  def setup; end

  # A helper to make it easier to test different route configurations. This method
  # temporarily replaces @routes with a new RouteSet instance.
  #
  # The new instance is yielded to the passed block. Typically the block will
  # create some routes using `set.draw { match ... }`:
  #
  #     with_routing do |set|
  #       set.draw do
  #         resources :users
  #       end
  #       assert_equal "/users", users_path
  #     end
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#121
  def with_routing(&block); end

  private

  # @yield [@routes]
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#270
  def create_routes; end

  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#336
  def fail_on(exception_class, message); end

  # Recognizes the route for a given path.
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#302
  def recognized_request_for(path, extras = T.unsafe(nil), msg); end

  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#294
  def reset_routes(old_routes, old_controller); end
end

# source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#76
module ActionDispatch::Assertions::RoutingAssertions::ClassMethods
  # A helper to make it easier to test different route configurations. This method
  # temporarily replaces @routes with a new RouteSet instance before each test.
  #
  # The new instance is yielded to the passed block. Typically the block will
  # create some routes using `set.draw { match ... }`:
  #
  #     with_routing do |set|
  #       set.draw do
  #         resources :users
  #       end
  #     end
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#89
  def with_routing(&block); end
end

# source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#17
module ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting::ClassMethods

  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#37
  def with_routing(&block); end

  private

  # @yield [routes]
  #
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#46
  def create_routes; end

  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#66
  def reset_routes(old_routes, old_integration_session); end
end

# source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#20
module ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting::ClassMethods
  # source://actionpack//lib/action_dispatch/testing/assertions/routing.rb#21
  def with_routing(&block); end
end

# # Action Dispatch AssumeSSL
#
# When proxying through a load balancer that terminates SSL, the forwarded
# request will appear as though it's HTTP instead of HTTPS to the application.
# This makes redirects and cookie security target HTTP instead of HTTPS. This
# middleware makes the server assume that the proxy already terminated SSL, and
# that the request really is HTTPS.
#
# source://actionpack//lib/action_dispatch/middleware/assume_ssl.rb#13
class ActionDispatch::AssumeSSL
  # @return [AssumeSSL] a new instance of AssumeSSL
  #
  # source://actionpack//lib/action_dispatch/middleware/assume_ssl.rb#14
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/middleware/assume_ssl.rb#18
  def call(env); end
end

# # Action Dispatch Callbacks
#
# Provides callbacks to be executed before and after dispatching the request.
#
# source://actionpack//lib/action_dispatch/middleware/callbacks.rb#9
class ActionDispatch::Callbacks
  include ::ActiveSupport::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker

  # @return [Callbacks] a new instance of Callbacks
  #
  # source://actionpack//lib/action_dispatch/middleware/callbacks.rb#24
  def initialize(app); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _call_callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_call_callbacks(&block); end

  # source://actionpack//lib/action_dispatch/middleware/callbacks.rb#28
  def call(env); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _call_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _call_callbacks=(value); end

    # source://actionpack//lib/action_dispatch/middleware/callbacks.rb#19
    def after(*args, &block); end

    # source://actionpack//lib/action_dispatch/middleware/callbacks.rb#15
    def before(*args, &block); end
  end
end

# source://actionpack//lib/action_dispatch/constants.rb#8
module ActionDispatch::Constants; end

# source://actionpack//lib/action_dispatch/constants.rb#23
ActionDispatch::Constants::CONTENT_ENCODING = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#24
ActionDispatch::Constants::CONTENT_SECURITY_POLICY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#25
ActionDispatch::Constants::CONTENT_SECURITY_POLICY_REPORT_ONLY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#27
ActionDispatch::Constants::FEATURE_POLICY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#26
ActionDispatch::Constants::LOCATION = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#30
ActionDispatch::Constants::SERVER_TIMING = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#31
ActionDispatch::Constants::STRICT_TRANSPORT_SECURITY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#22
ActionDispatch::Constants::VARY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#29
ActionDispatch::Constants::X_CASCADE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/constants.rb#28
ActionDispatch::Constants::X_REQUEST_ID = T.let(T.unsafe(nil), String)

# # Action Dispatch Content Security Policy
#
# Configures the HTTP [Content-Security-Policy]
# (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy)
# response header to help protect against XSS and
# injection attacks.
#
# Example global policy:
#
#     Rails.application.config.content_security_policy do |policy|
#       policy.default_src :self, :https
#       policy.font_src    :self, :https, :data
#       policy.img_src     :self, :https, :data
#       policy.object_src  :none
#       policy.script_src  :self, :https
#       policy.style_src   :self, :https
#
#       # Specify URI for violation reports
#       policy.report_uri "/csp-violation-report-endpoint"
#     end
#
# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#29
class ActionDispatch::ContentSecurityPolicy
  # @return [ContentSecurityPolicy] a new instance of ContentSecurityPolicy
  # @yield [_self]
  # @yieldparam _self [ActionDispatch::ContentSecurityPolicy] the object that the method was called on
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#177
  def initialize; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def base_uri(*sources); end

  # Specify whether to prevent the user agent from loading any assets over HTTP
  # when the page uses HTTPS:
  #
  #     policy.block_all_mixed_content
  #
  # Pass `false` to allow it again:
  #
  #     policy.block_all_mixed_content false
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#205
  def block_all_mixed_content(enabled = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#297
  def build(context = T.unsafe(nil), nonce = T.unsafe(nil), nonce_directives = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def child_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def connect_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def default_src(*sources); end

  # Returns the value of attribute directives.
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#175
  def directives; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def font_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def form_action(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def frame_ancestors(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def frame_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def img_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def manifest_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def media_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def object_src(*sources); end

  # Restricts the set of plugins that can be embedded:
  #
  #     policy.plugin_types "application/x-shockwave-flash"
  #
  # Leave empty to allow all plugins:
  #
  #     policy.plugin_types
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#221
  def plugin_types(*types); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def prefetch_src(*sources); end

  # Enable the [report-uri]
  # (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/report-uri)
  # directive. Violation reports will be sent to the
  # specified URI:
  #
  #     policy.report_uri "/csp-violation-report-endpoint"
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#236
  def report_uri(uri); end

  # Specify asset types for which [Subresource Integrity]
  # (https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity) is required:
  #
  #     policy.require_sri_for :script, :style
  #
  # Leave empty to not require Subresource Integrity:
  #
  #     policy.require_sri_for
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#249
  def require_sri_for(*types); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def require_trusted_types_for(*sources); end

  # Specify whether a [sandbox]
  # (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/sandbox)
  # should be enabled for the requested resource:
  #
  #     policy.sandbox
  #
  # Values can be passed as arguments:
  #
  #     policy.sandbox "allow-scripts", "allow-modals"
  #
  # Pass `false` to disable the sandbox:
  #
  #     policy.sandbox false
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#271
  def sandbox(*values); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def script_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def script_src_attr(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def script_src_elem(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def style_src(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def style_src_attr(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def style_src_elem(*sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def trusted_types(*sources); end

  # Specify whether user agents should treat any assets over HTTP as HTTPS:
  #
  #     policy.upgrade_insecure_requests
  #
  # Pass `false` to disable it:
  #
  #     policy.upgrade_insecure_requests false
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#289
  def upgrade_insecure_requests(enabled = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#187
  def worker_src(*sources); end

  private

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#316
  def apply_mapping(source); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#303
  def apply_mappings(sources); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#338
  def build_directive(sources, context); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#322
  def build_directives(context, nonce, nonce_directives); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#182
  def initialize_copy(other); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#360
  def nonce_directive?(directive, nonce_directives); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#342
  def resolve_source(source, context); end
end

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#171
ActionDispatch::ContentSecurityPolicy::DEFAULT_NONCE_DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#146
ActionDispatch::ContentSecurityPolicy::DIRECTIVES = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#126
ActionDispatch::ContentSecurityPolicy::MAPPINGS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#30
class ActionDispatch::ContentSecurityPolicy::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#31
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#35
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#57
  def header_name(request); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#65
  def policy_present?(headers); end
end

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#71
module ActionDispatch::ContentSecurityPolicy::Request
  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#78
  def content_security_policy; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#82
  def content_security_policy=(policy); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#110
  def content_security_policy_nonce; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#102
  def content_security_policy_nonce_directives; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#106
  def content_security_policy_nonce_directives=(generator); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#94
  def content_security_policy_nonce_generator; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#98
  def content_security_policy_nonce_generator=(generator); end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#86
  def content_security_policy_report_only; end

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#90
  def content_security_policy_report_only=(value); end

  private

  # source://actionpack//lib/action_dispatch/http/content_security_policy.rb#121
  def generate_content_security_policy_nonce; end
end

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#75
ActionDispatch::ContentSecurityPolicy::Request::NONCE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#76
ActionDispatch::ContentSecurityPolicy::Request::NONCE_DIRECTIVES = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#74
ActionDispatch::ContentSecurityPolicy::Request::NONCE_GENERATOR = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#72
ActionDispatch::ContentSecurityPolicy::Request::POLICY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/content_security_policy.rb#73
ActionDispatch::ContentSecurityPolicy::Request::POLICY_REPORT_ONLY = T.let(T.unsafe(nil), String)

# Read and write data to cookies through ActionController::Cookies#cookies.
#
# When reading cookie data, the data is read from the HTTP request header,
# Cookie. When writing cookie data, the data is sent out in the HTTP response
# header, `Set-Cookie`.
#
# Examples of writing:
#
#     # Sets a simple session cookie.
#     # This cookie will be deleted when the user's browser is closed.
#     cookies[:user_name] = "david"
#
#     # Cookie values are String-based. Other data types need to be serialized.
#     cookies[:lat_lon] = JSON.generate([47.68, -122.37])
#
#     # Sets a cookie that expires in 1 hour.
#     cookies[:login] = { value: "XJ-122", expires: 1.hour }
#
#     # Sets a cookie that expires at a specific time.
#     cookies[:login] = { value: "XJ-122", expires: Time.utc(2020, 10, 15, 5) }
#
#     # Sets a signed cookie, which prevents users from tampering with its value.
#     # It can be read using the signed method `cookies.signed[:name]`
#     cookies.signed[:user_id] = current_user.id
#
#     # Sets an encrypted cookie value before sending it to the client which
#     # prevent users from reading and tampering with its value.
#     # It can be read using the encrypted method `cookies.encrypted[:name]`
#     cookies.encrypted[:discount] = 45
#
#     # Sets a "permanent" cookie (which expires in 20 years from now).
#     cookies.permanent[:login] = "XJ-122"
#
#     # You can also chain these methods:
#     cookies.signed.permanent[:login] = "XJ-122"
#
# Examples of reading:
#
#     cookies[:user_name]           # => "david"
#     cookies.size                  # => 2
#     JSON.parse(cookies[:lat_lon]) # => [47.68, -122.37]
#     cookies.signed[:login]        # => "XJ-122"
#     cookies.encrypted[:discount]  # => 45
#
# Example for deleting:
#
#     cookies.delete :user_name
#
# Please note that if you specify a `:domain` when setting a cookie, you must
# also specify the domain when deleting the cookie:
#
#     cookies[:name] = {
#       value: 'a yummy cookie',
#       expires: 1.year,
#       domain: 'domain.com'
#     }
#
#     cookies.delete(:name, domain: 'domain.com')
#
# The option symbols for setting cookies are:
#
# *   `:value` - The cookie's value.
# *   `:path` - The path for which this cookie applies. Defaults to the root of
#     the application.
# *   `:domain` - The domain for which this cookie applies so you can restrict
#     to the domain level. If you use a schema like www.example.com and want to
#     share session with user.example.com set `:domain` to `:all`. To support
#     multiple domains, provide an array, and the first domain matching
#     `request.host` will be used. Make sure to specify the `:domain` option
#     with `:all` or `Array` again when deleting cookies. For more flexibility
#     you can set the domain on a per-request basis by specifying `:domain` with
#     a proc.
#
#         domain: nil  # Does not set cookie domain. (default)
#         domain: :all # Allow the cookie for the top most level
#                      # domain and subdomains.
#         domain: %w(.example.com .example.org) # Allow the cookie
#                                               # for concrete domain names.
#         domain: proc { Tenant.current.cookie_domain } # Set cookie domain dynamically
#         domain: proc { |req| ".sub.#{req.host}" }     # Set cookie domain dynamically based on request
#
# *   `:tld_length` - When using `:domain => :all`, this option can be used to
#     explicitly set the TLD length when using a short (<= 3 character) domain
#     that is being interpreted as part of a TLD. For example, to share cookies
#     between user1.lvh.me and user2.lvh.me, set `:tld_length` to 2.
# *   `:expires` - The time at which this cookie expires, as a Time or
#     ActiveSupport::Duration object.
# *   `:secure` - Whether this cookie is only transmitted to HTTPS servers.
#     Default is `false`.
# *   `:httponly` - Whether this cookie is accessible via scripting or only
#     HTTP. Defaults to `false`.
# *   `:same_site` - The value of the `SameSite` cookie attribute, which
#     determines how this cookie should be restricted in cross-site contexts.
#     Possible values are `nil`, `:none`, `:lax`, and `:strict`. Defaults to
#     `:lax`.
#
# source://actionpack//lib/action_dispatch/middleware/cookies.rb#193
class ActionDispatch::Cookies
  # @return [Cookies] a new instance of Cookies
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#698
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#702
  def call(env); end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#199
ActionDispatch::Cookies::AUTHENTICATED_ENCRYPTED_COOKIE_SALT = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#504
class ActionDispatch::Cookies::AbstractCookieJar
  include ::ActionDispatch::Cookies::ChainedCookieJars

  # @return [AbstractCookieJar] a new instance of AbstractCookieJar
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#507
  def initialize(parent_jar); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#511
  def [](name); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#523
  def []=(name, options); end

  protected

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#535
  def request; end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#553
  def commit(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#546
  def cookie_metadata(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#538
  def expiry_options(options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#552
  def parse(name, data, purpose: T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#205
ActionDispatch::Cookies::COOKIES_DIGEST = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#206
ActionDispatch::Cookies::COOKIES_ROTATIONS = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#207
ActionDispatch::Cookies::COOKIES_SAME_SITE_PROTECTION = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#204
ActionDispatch::Cookies::COOKIES_SERIALIZER = T.let(T.unsafe(nil), String)

# Include in a cookie jar to allow chaining, e.g. `cookies.permanent.signed`.
#
# source://actionpack//lib/action_dispatch/middleware/cookies.rb#217
module ActionDispatch::Cookies::ChainedCookieJars
  # Returns a jar that'll automatically encrypt cookie values before sending them
  # to the client and will decrypt them for read. If the cookie was tampered with
  # by the user (or a 3rd party), `nil` will be returned.
  #
  # If `config.action_dispatch.encrypted_cookie_salt` and
  # `config.action_dispatch.encrypted_signed_cookie_salt` are both set, legacy
  # cookies encrypted with HMAC AES-256-CBC will be transparently upgraded.
  #
  # This jar requires that you set a suitable secret for the verification on your
  # app's `secret_key_base`.
  #
  # Example:
  #
  #     cookies.encrypted[:discount] = 45
  #     # => Set-Cookie: discount=DIQ7fw==--K3n//8vvnSbGq9dA--7Xh91HfLpwzbj1czhBiwOg==; path=/
  #
  #     cookies.encrypted[:discount] # => 45
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#272
  def encrypted; end

  # Returns a jar that'll automatically set the assigned cookies to have an
  # expiration date 20 years from now. Example:
  #
  #     cookies.permanent[:prefers_open_id] = true
  #     # => Set-Cookie: prefers_open_id=true; path=/; expires=Sun, 16-Dec-2029 03:24:16 GMT
  #
  # This jar is only meant for writing. You'll read permanent cookies through the
  # regular accessor.
  #
  # This jar allows chaining with the signed jar as well, so you can set
  # permanent, signed cookies. Examples:
  #
  #     cookies.permanent.signed[:remember_me] = current_user.id
  #     # => Set-Cookie: remember_me=BAhU--848956038e692d7046deab32b7131856ab20e14e; path=/; expires=Sun, 16-Dec-2029 03:24:16 GMT
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#232
  def permanent; end

  # Returns a jar that'll automatically generate a signed representation of cookie
  # value and verify it when reading from the cookie again. This is useful for
  # creating cookies with values that the user is not supposed to change. If a
  # signed cookie was tampered with by the user (or a 3rd party), `nil` will be
  # returned.
  #
  # This jar requires that you set a suitable secret for the verification on your
  # app's `secret_key_base`.
  #
  # Example:
  #
  #     cookies.signed[:discount] = 45
  #     # => Set-Cookie: discount=BAhpMg==--2c1c6906c90a3bc4fd54a51ffb41dffa4bf6b5f7; path=/
  #
  #     cookies.signed[:discount] # => 45
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#251
  def signed; end

  # Returns the `signed` or `encrypted` jar, preferring `encrypted` if
  # `secret_key_base` is set. Used by ActionDispatch::Session::CookieStore to
  # avoid the need to introduce new cookie stores.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#279
  def signed_or_encrypted; end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#302
  def encrypted_cookie_cipher; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#296
  def prepare_upgrade_legacy_hmac_aes_cbc_cookies?; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#306
  def signed_cookie_digest; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#289
  def upgrade_legacy_hmac_aes_cbc_cookies?; end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#311
class ActionDispatch::Cookies::CookieJar
  include ::ActionDispatch::Cookies::ChainedCookieJars
  include ::Enumerable

  # @return [CookieJar] a new instance of CookieJar
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#322
  def initialize(request); end

  # Returns the value of the cookie by `name`, or `nil` if no such cookie exists.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#343
  def [](name); end

  # Sets the cookie named `name`. The second argument may be the cookie's value or
  # a hash of options as documented above.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#377
  def []=(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#439
  def always_write_cookie; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#439
  def always_write_cookie=(val); end

  # Removes all cookies on the client machine by calling `delete` for each cookie.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#423
  def clear(options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#332
  def commit!; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#330
  def committed?; end

  # Removes the cookie on the client machine by setting the value to an empty
  # string and the expiration date in the past. Like `[]=`, you can pass in an
  # options hash to delete cookies with extra data such as a `:path`.
  #
  # Returns the value of the cookie, or `nil` if the cookie does not exist.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#402
  def delete(name, options = T.unsafe(nil)); end

  # Whether the given cookie is to be deleted by this CookieJar. Like `[]=`, you
  # can pass in an options hash to test if a deletion applies to a specific
  # `:path`, `:domain` etc.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#416
  def deleted?(name, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#338
  def each(&block); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#347
  def fetch(name, *args, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#351
  def has_key?(name); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#351
  def key?(name); end

  # Returns the value of attribute request.
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#320
  def request; end

  # Returns the cookies as Hash.
  def to_hash(*_arg0); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#371
  def to_header; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#359
  def update(other_hash); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#364
  def update_cookies_from_jar; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#427
  def write(response); end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#442
  def escape(string); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#450
  def handle_options(options); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#446
  def write_cookie?(cookie); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/cookies.rb#439
    def always_write_cookie; end

    # source://actionpack//lib/action_dispatch/middleware/cookies.rb#439
    def always_write_cookie=(val); end

    # source://actionpack//lib/action_dispatch/middleware/cookies.rb#314
    def build(req, cookies); end
  end
end

# Raised when storing more than 4K of session data.
#
# source://actionpack//lib/action_dispatch/middleware/cookies.rb#214
class ActionDispatch::Cookies::CookieOverflow < ::StandardError; end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#201
ActionDispatch::Cookies::ENCRYPTED_COOKIE_CIPHER = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#197
ActionDispatch::Cookies::ENCRYPTED_COOKIE_SALT = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#198
ActionDispatch::Cookies::ENCRYPTED_SIGNED_COOKIE_SALT = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#646
class ActionDispatch::Cookies::EncryptedKeyRotatingCookieJar < ::ActionDispatch::Cookies::AbstractCookieJar
  include ::ActionDispatch::Cookies::SerializedCookieJars

  # @return [EncryptedKeyRotatingCookieJar] a new instance of EncryptedKeyRotatingCookieJar
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#649
  def initialize(parent_jar); end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#691
  def commit(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#683
  def parse(name, encrypted_message, purpose: T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#195
ActionDispatch::Cookies::GENERATOR_KEY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#194
ActionDispatch::Cookies::HTTP_HEADER = T.let(T.unsafe(nil), String)

# Cookies can typically store 4096 bytes.
#
# source://actionpack//lib/action_dispatch/middleware/cookies.rb#211
ActionDispatch::Cookies::MAX_COOKIE_SIZE = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#556
class ActionDispatch::Cookies::PermanentCookieJar < ::ActionDispatch::Cookies::AbstractCookieJar
  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#558
  def commit(name, options); end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#203
ActionDispatch::Cookies::SECRET_KEY_BASE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#202
ActionDispatch::Cookies::SIGNED_COOKIE_DIGEST = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#196
ActionDispatch::Cookies::SIGNED_COOKIE_SALT = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#563
module ActionDispatch::Cookies::SerializedCookieJars
  protected

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#567
  def digest; end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#610
  def check_for_overflow!(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#606
  def commit(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#592
  def parse(name, dumped, force_reserialize: T.unsafe(nil), **_arg3); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#586
  def reserialize?(dumped); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#572
  def serializer; end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#564
ActionDispatch::Cookies::SerializedCookieJars::SERIALIZER = ActiveSupport::MessageEncryptor::NullSerializer

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#617
class ActionDispatch::Cookies::SignedKeyRotatingCookieJar < ::ActionDispatch::Cookies::AbstractCookieJar
  include ::ActionDispatch::Cookies::SerializedCookieJars

  # @return [SignedKeyRotatingCookieJar] a new instance of SignedKeyRotatingCookieJar
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#620
  def initialize(parent_jar); end

  private

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#639
  def commit(name, options); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#633
  def parse(name, signed_message, purpose: T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#200
ActionDispatch::Cookies::USE_AUTHENTICATED_COOKIE_ENCRYPTION = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#208
ActionDispatch::Cookies::USE_COOKIES_WITH_METADATA = T.let(T.unsafe(nil), String)

# # Action Dispatch DebugExceptions
#
# This middleware is responsible for logging exceptions and showing a debugging
# page in case the request is local.
#
# source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#15
class ActionDispatch::DebugExceptions
  # @return [DebugExceptions] a new instance of DebugExceptions
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#23
  def initialize(app, routes_app = T.unsafe(nil), response_format = T.unsafe(nil), interceptors = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#30
  def call(env); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#185
  def api_request?(content_type); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#116
  def create_template(request, wrapper); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#50
  def invoke_interceptors(request, exception, wrapper); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#159
  def log_array(logger, lines, request); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#135
  def log_error(request, wrapper); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#189
  def log_rescued_responses?(request); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#171
  def logger(request); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#131
  def render(status, body, format); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#58
  def render_exception(request, exception, wrapper); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#92
  def render_for_api_request(content_type, wrapper); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#78
  def render_for_browser_request(request, wrapper); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#179
  def routes_inspector(exception); end

  # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#175
  def stderr_logger; end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#16
    def interceptors; end

    # source://actionpack//lib/action_dispatch/middleware/debug_exceptions.rb#18
    def register_interceptor(object = T.unsafe(nil), &block); end
  end
end

# # Action Dispatch DebugLocks
#
# This middleware can be used to diagnose deadlocks in the autoload interlock.
#
# To use it, insert it near the top of the middleware stack, using
# `config/application.rb`:
#
#     config.middleware.insert_before Rack::Sendfile, ActionDispatch::DebugLocks
#
# After restarting the application and re-triggering the deadlock condition, the
# route `/rails/locks` will show a summary of all threads currently known to the
# interlock, which lock level they are holding or awaiting, and their current
# backtrace.
#
# Generally a deadlock will be caused by the interlock conflicting with some
# other external lock or blocking I/O call. These cannot be automatically
# identified, but should be visible in the displayed backtraces.
#
# NOTE: The formatting and content of this middleware's output is intended for
# human consumption, and should be expected to change between releases.
#
# This middleware exposes operational details of the server, with no access
# control. It should only be enabled when in use, and removed thereafter.
#
# source://actionpack//lib/action_dispatch/middleware/debug_locks.rb#29
class ActionDispatch::DebugLocks
  # @return [DebugLocks] a new instance of DebugLocks
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_locks.rb#30
  def initialize(app, path = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/debug_locks.rb#35
  def call(env); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_locks.rb#108
  def blocked_by?(victim, blocker, all_threads); end

  # source://actionpack//lib/action_dispatch/middleware/debug_locks.rb#49
  def render_details(req); end
end

# source://actionpack//lib/action_dispatch/middleware/debug_view.rb#11
class ActionDispatch::DebugView < ::ActionView::Base
  # @return [DebugView] a new instance of DebugView
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#14
  def initialize(assigns); end

  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#21
  def compiled_method_container; end

  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#49
  def debug_hash(object); end

  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#41
  def debug_headers(headers); end

  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#29
  def debug_params(params); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#25
  def error_highlight_available?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#67
  def params_valid?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#63
  def protect_against_forgery?; end

  # source://actionpack//lib/action_dispatch/middleware/debug_view.rb#53
  def render(*_arg0); end
end

# source://actionpack//lib/action_dispatch/middleware/debug_view.rb#12
ActionDispatch::DebugView::RESCUES_TEMPLATE_PATHS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#11
class ActionDispatch::ExceptionWrapper
  # @return [ExceptionWrapper] a new instance of ExceptionWrapper
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#50
  def initialize(backtrace_cleaner, exception); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#101
  def actions; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#113
  def annotated_source_code; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#135
  def application_trace; end

  # Returns the value of attribute backtrace_cleaner.
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#48
  def backtrace_cleaner; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#89
  def corrections; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#204
  def error_highlight_available?; end

  # Returns the value of attribute exception.
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#48
  def exception; end

  # Returns the value of attribute exception_class_name.
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#48
  def exception_class_name; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#234
  def exception_id; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#230
  def exception_inspect; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#222
  def exception_name; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#129
  def exception_trace; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#77
  def failures; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#93
  def file_name; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#139
  def framework_trace; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#143
  def full_trace; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#73
  def has_cause?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#81
  def has_corrections?; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#97
  def line_number; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#226
  def message; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#85
  def original_message; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#194
  def rescue_response?; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#12
  def rescue_responses; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#12
  def rescue_responses=(val); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#121
  def rescue_template; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#30
  def rescue_templates; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#30
  def rescue_templates=(val); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#61
  def routing_error?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#179
  def show?(request); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#43
  def silent_exceptions; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#43
  def silent_exceptions=(val); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#198
  def source_extracts; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#218
  def source_to_show_id; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#125
  def status_code; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#69
  def sub_template_message; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#65
  def template_error?; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#210
  def trace_to_show; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#147
  def traces; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#105
  def unwrapped_exception; end

  # Returns the value of attribute wrapped_causes.
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#48
  def wrapped_causes; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#39
  def wrapper_exceptions; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#39
  def wrapper_exceptions=(val); end

  private

  # Returns the value of attribute backtrace.
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#258
  def backtrace; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#260
  def build_backtrace; end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#283
  def causes_for(exception); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#293
  def clean_backtrace(*args); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#346
  def extract_file_and_line_number(trace); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#301
  def extract_source(trace); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#330
  def extract_source_fragment_lines(source_lines, line); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#336
  def source_fragment(path, line); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#289
  def wrapped_causes_for(exception, backtrace_cleaner); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#12
    def rescue_responses; end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#12
    def rescue_responses=(val); end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#30
    def rescue_templates; end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#30
    def rescue_templates=(val); end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#43
    def silent_exceptions; end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#43
    def silent_exceptions=(val); end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#175
    def status_code_for_exception(class_name); end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#39
    def wrapper_exceptions; end

    # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#39
    def wrapper_exceptions=(val); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#239
class ActionDispatch::ExceptionWrapper::SourceMapLocation
  # @return [SourceMapLocation] a new instance of SourceMapLocation
  #
  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#240
  def initialize(location, template); end

  # source://actionpack//lib/action_dispatch/middleware/exception_wrapper.rb#245
  def spot(exc); end
end

# source://actionpack//lib/action_dispatch/middleware/executor.rb#8
class ActionDispatch::Executor
  # @return [Executor] a new instance of Executor
  #
  # source://actionpack//lib/action_dispatch/middleware/executor.rb#9
  def initialize(app, executor); end

  # source://actionpack//lib/action_dispatch/middleware/executor.rb#13
  def call(env); end
end

# # Action Dispatch FileHandler
#
# This endpoint serves static files from disk using `Rack::Files`.
#
# URL paths are matched with static files according to expected conventions:
# `path`, `path`.html, `path`/index.html.
#
# Precompressed versions of these files are checked first. Brotli (.br) and gzip
# (.gz) files are supported. If `path`.br exists, this endpoint returns that
#
# If no matching file is found, this endpoint responds `404 Not Found`.
#
# Pass the `root` directory to search for matching files, an optional `index:
# "index"` to change the default `path`/index.html, and optional additional
# response headers.
#
# source://actionpack//lib/action_dispatch/middleware/static.rb#47
class ActionDispatch::FileHandler
  # @return [FileHandler] a new instance of FileHandler
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#55
  def initialize(root, index: T.unsafe(nil), headers: T.unsafe(nil), precompressed: T.unsafe(nil), compressible_content_types: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#69
  def attempt(env); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#65
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/middleware/static.rb#185
  def clean_path(path_info); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#149
  def compressible?(content_type); end

  # @yield [path, content_type || "text/plain"]
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#162
  def each_candidate_filepath(path_info); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#153
  def each_precompressed_filepath(filepath); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#144
  def file_readable?(path); end

  # Match a URI path to a static file to be served.
  #
  # Used by the `Static` class to negotiate a servable file in the `public/`
  # directory (see Static#call).
  #
  # Checks for `path`, `path`.html, and `path`/index.html files, in that order,
  # including .br and .gzip compressed extensions.
  #
  # If a matching file is found, the path and necessary response headers
  # (Content-Type, Content-Encoding) are returned.
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#104
  def find_file(path_info, accept_encoding:); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#80
  def serve(request, filepath, content_headers); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#112
  def try_files(filepath, content_type, accept_encoding:); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#122
  def try_precompressed_files(filepath, headers, accept_encoding:); end
end

# `Accept-Encoding` value -> file extension
#
# source://actionpack//lib/action_dispatch/middleware/static.rb#49
ActionDispatch::FileHandler::PRECOMPRESSED = T.let(T.unsafe(nil), Hash)

# # Action Dispatch Flash
#
# The flash provides a way to pass temporary primitive-types (String, Array,
# Hash) between actions. Anything you place in the flash will be exposed to the
# very next action and then cleared out. This is a great way of doing notices
# and alerts, such as a create action that sets `flash[:notice] = "Post
# successfully created"` before redirecting to a display action that can then
# expose the flash to its template. Actually, that exposure is automatically
# done.
#
#     class PostsController < ActionController::Base
#       def create
#         # save post
#         flash[:notice] = "Post successfully created"
#         redirect_to @post
#       end
#
#       def show
#         # doesn't need to assign the flash notice to the template, that's done automatically
#       end
#     end
#
# Then in `show.html.erb`:
#
#     <% if flash[:notice] %>
#       <div class="notice"><%= flash[:notice] %></div>
#     <% end %>
#
# Since the `notice` and `alert` keys are a common idiom, convenience accessors
# are available:
#
#     flash.alert = "You must be logged in"
#     flash.notice = "Post successfully created"
#
# This example places a string in the flash. And of course, you can put as many
# as you like at a time too. If you want to pass non-primitive types, you will
# have to handle that in your application. Example: To show messages with links,
# you will have to use sanitize helper.
#
# Just remember: They'll be gone by the time the next action has been performed.
#
# See docs on the FlashHash class for more details about the flash.
#
# source://actionpack//lib/action_dispatch/middleware/flash.rb#50
class ActionDispatch::Flash
  class << self
    # source://actionpack//lib/action_dispatch/middleware/flash.rb#312
    def new(app); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/flash.rb#119
class ActionDispatch::Flash::FlashHash
  include ::Enumerable

  # @return [FlashHash] a new instance of FlashHash
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#149
  def initialize(flashes = T.unsafe(nil), discard = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#169
  def [](k); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#163
  def []=(k, v); end

  # Convenience accessor for `flash[:alert]`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#280
  def alert; end

  # Convenience accessor for `flash[:alert]=`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#285
  def alert=(message); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#204
  def clear; end

  # Immediately deletes the single flash entry. Use this method when you want
  # remove the message within the current action. See also #discard.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#189
  def delete(key); end

  # Marks the entire flash or a single flash entry to be discarded by the end of
  # the current action:
  #
  #     flash.discard              # discard the entire flash at the end of the current action
  #     flash.discard(:warning)    # discard only the "warning" entry at the end of the current action
  #
  # Use this method when you want to display the message in the current action but
  # not in the next one. See also #delete.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#264
  def discard(k = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#209
  def each(&block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#200
  def empty?; end

  # Keeps either the entire current flash or a specific flash entry available for
  # the next action:
  #
  #     flash.keep            # keeps the entire flash
  #     flash.keep(:notice)   # keeps only the "notice" entry, the rest of the flash is discarded
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#250
  def keep(k = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#183
  def key?(name); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#179
  def keys; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#173
  def merge!(h); end

  # Convenience accessor for `flash[:notice]`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#290
  def notice; end

  # Convenience accessor for `flash[:notice]=`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#295
  def notice=(message); end

  # Sets a flash that will not be available to the next action, only to the
  # current.
  #
  #     flash.now[:message] = "Hello current action"
  #
  # This method enables you to use the flash as a central messaging system in your
  # app. When you need to pass an object to the next action, you use the standard
  # flash assign (`[]=`). When you need to pass an object to the current action,
  # you use `now`, and your object will vanish when the current action is done.
  #
  # Entries set via `now` are accessed the same way as standard entries:
  # `flash['my-key']`.
  #
  # Also, brings two convenience accessors:
  #
  #     flash.now.alert = "Beware now!"
  #     # Equivalent to flash.now[:alert] = "Beware now!"
  #
  #     flash.now.notice = "Good luck now!"
  #     # Equivalent to flash.now[:notice] = "Good luck now!"
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#241
  def now; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#215
  def replace(h); end

  # Mark for removal entries that were kept, and delete unkept ones.
  #
  # This method is called automatically by filters, so you generally don't need to
  # care about it.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#274
  def sweep; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#196
  def to_hash; end

  # Builds a hash containing the flashes to keep for the next request. If there
  # are none to keep, returns `nil`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#143
  def to_session_value; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#173
  def update(h); end

  protected

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#300
  def now_is_loaded?; end

  private

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#155
  def initialize_copy(other); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#305
  def stringify_array(array); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/flash.rb#122
    def from_session_value(value); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/flash.rb#90
class ActionDispatch::Flash::FlashNow
  # @return [FlashNow] a new instance of FlashNow
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#93
  def initialize(flash); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#104
  def [](k); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#97
  def []=(k, v); end

  # Convenience accessor for `flash.now[:alert]=`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#109
  def alert=(message); end

  # Returns the value of attribute flash.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#91
  def flash; end

  # Sets the attribute flash
  #
  # @param value the value to set the attribute flash to.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#91
  def flash=(_arg0); end

  # Convenience accessor for `flash.now[:notice]=`.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#114
  def notice=(message); end
end

# source://actionpack//lib/action_dispatch/middleware/flash.rb#51
ActionDispatch::Flash::KEY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/flash.rb#53
module ActionDispatch::Flash::RequestMethods
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#71
  def commit_flash; end

  # Access the contents of the flash. Returns a ActionDispatch::Flash::FlashHash.
  #
  # See ActionDispatch::Flash for example usage.
  #
  # source://actionpack//lib/action_dispatch/middleware/flash.rb#57
  def flash; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#63
  def flash=(flash); end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#67
  def flash_hash; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#84
  def reset_session; end
end

# # Action Dispatch HostAuthorization
#
# This middleware guards from DNS rebinding attacks by explicitly permitting the
# hosts a request can be sent to, and is passed the options set in
# `config.host_authorization`.
#
# Requests can opt-out of Host Authorization with `exclude`:
#
#     config.host_authorization = { exclude: ->(request) { request.path =~ /healthcheck/ } }
#
# When a request comes to an unauthorized host, the `response_app` application
# will be executed and rendered. If no `response_app` is given, a default one
# will run. The default response app logs blocked host info with level 'error'
# and responds with `403 Forbidden`. The body of the response contains debug
# info if `config.consider_all_requests_local` is set to true, otherwise the
# body is empty.
#
# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#22
class ActionDispatch::HostAuthorization
  # @return [HostAuthorization] a new instance of HostAuthorization
  #
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#127
  def initialize(app, hosts, exclude: T.unsafe(nil), response_app: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#135
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#151
  def blocked_hosts(request); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#163
  def excluded?(request); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#167
  def mark_as_authorized(request); end
end

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#23
ActionDispatch::HostAuthorization::ALLOWED_HOSTS_IN_DEVELOPMENT = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#88
class ActionDispatch::HostAuthorization::DefaultResponseApp
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#91
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#122
  def available_logger(request); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#114
  def log_error(request); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#107
  def response(format, body); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#100
  def response_body(request); end
end

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#89
ActionDispatch::HostAuthorization::DefaultResponseApp::RESPONSE_STATUS = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#26
ActionDispatch::HostAuthorization::IPV4_HOSTNAME = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#27
ActionDispatch::HostAuthorization::IPV6_HOSTNAME = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#28
ActionDispatch::HostAuthorization::IPV6_HOSTNAME_WITH_PORT = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#24
ActionDispatch::HostAuthorization::PORT_REGEX = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#35
class ActionDispatch::HostAuthorization::Permissions
  # @return [Permissions] a new instance of Permissions
  #
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#36
  def initialize(hosts); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#44
  def allows?(host); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#40
  def empty?; end

  private

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#83
  def extract_hostname(host); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#61
  def sanitize_hosts(hosts); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#71
  def sanitize_regexp(host); end

  # source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#75
  def sanitize_string(host); end
end

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#25
ActionDispatch::HostAuthorization::SUBDOMAIN_REGEX = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/middleware/host_authorization.rb#29
ActionDispatch::HostAuthorization::VALID_IP_HOSTNAME = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch.rb#89
module ActionDispatch::Http
  extend ::ActiveSupport::Autoload
end

# source://actionpack//lib/action_dispatch/http/cache.rb#7
module ActionDispatch::Http::Cache; end

# source://actionpack//lib/action_dispatch/http/cache.rb#8
module ActionDispatch::Http::Cache::Request
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#30
  def etag_matches?(etag); end

  # Check response freshness (`Last-Modified` and ETag) against request
  # `If-Modified-Since` and `If-None-Match` conditions. If both headers are
  # supplied, both must match, or the request is not considered fresh.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#40
  def fresh?(response); end

  # source://actionpack//lib/action_dispatch/http/cache.rb#12
  def if_modified_since; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#18
  def if_none_match; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#22
  def if_none_match_etags; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#26
  def not_modified?(modified_at); end
end

# source://actionpack//lib/action_dispatch/http/cache.rb#9
ActionDispatch::Http::Cache::Request::HTTP_IF_MODIFIED_SINCE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#10
ActionDispatch::Http::Cache::Request::HTTP_IF_NONE_MATCH = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#53
module ActionDispatch::Http::Cache::Response
  # Returns the value of attribute cache_control.
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#54
  def cache_control; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#70
  def date; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#80
  def date=(utc_time); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#76
  def date?; end

  # This method sets a weak ETag validator on the response so browsers and proxies
  # may cache the response, keyed on the ETag. On subsequent requests, the
  # `If-None-Match` header is set to the cached ETag. If it matches the current
  # ETag, we can return a `304 Not Modified` response with no body, letting the
  # browser or proxy know that their cache is current. Big savings in request time
  # and network bandwidth.
  #
  # Weak ETags are considered to be semantically equivalent but not byte-for-byte
  # identical. This is perfect for browser caching of HTML pages where we don't
  # care about exact equality, just what the user is viewing.
  #
  # Strong ETags are considered byte-for-byte identical. They allow a browser or
  # proxy cache to support `Range` requests, useful for paging through a PDF file
  # or scrubbing through a video. Some CDNs only support strong ETags and will
  # ignore weak ETags entirely.
  #
  # Weak ETags are what we almost always need, so they're the default. Check out
  # #strong_etag= to provide a strong ETag validator.
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#102
  def etag=(weak_validators); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#114
  def etag?; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#56
  def last_modified; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#66
  def last_modified=(utc_time); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#62
  def last_modified?; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#110
  def strong_etag=(strong_validators); end

  # True if an ETag is set, and it isn't a weak validator (not preceded with
  # `W/`).
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#123
  def strong_etag?; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#106
  def weak_etag=(weak_validators); end

  # True if an ETag is set, and it's a weak validator (preceded with `W/`).
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/cache.rb#117
  def weak_etag?; end

  private

  # source://actionpack//lib/action_dispatch/http/cache.rb#146
  def cache_control_headers; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#140
  def cache_control_segments; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#136
  def generate_strong_etag(validators); end

  # source://actionpack//lib/action_dispatch/http/cache.rb#132
  def generate_weak_etag(validators); end

  # source://actionpack//lib/action_dispatch/http/cache.rb#175
  def handle_conditional_get!; end

  # source://actionpack//lib/action_dispatch/http/cache.rb#184
  def merge_and_normalize_cache_control!(cache_control); end

  # source://actionpack//lib/action_dispatch/http/cache.rb#164
  def prepare_cache_control!; end
end

# source://actionpack//lib/action_dispatch/http/cache.rb#128
ActionDispatch::Http::Cache::Response::DATE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#168
ActionDispatch::Http::Cache::Response::DEFAULT_CACHE_CONTROL = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#129
ActionDispatch::Http::Cache::Response::LAST_MODIFIED = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#173
ActionDispatch::Http::Cache::Response::MUST_REVALIDATE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#170
ActionDispatch::Http::Cache::Response::NO_CACHE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#169
ActionDispatch::Http::Cache::Response::NO_STORE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#172
ActionDispatch::Http::Cache::Response::PRIVATE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#171
ActionDispatch::Http::Cache::Response::PUBLIC = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/cache.rb#130
ActionDispatch::Http::Cache::Response::SPECIAL_KEYS = T.let(T.unsafe(nil), Set)

# source://actionpack//lib/action_dispatch/http/content_disposition.rb#7
class ActionDispatch::Http::ContentDisposition
  # @return [ContentDisposition] a new instance of ContentDisposition
  #
  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#14
  def initialize(disposition:, filename:); end

  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#21
  def ascii_filename; end

  # Returns the value of attribute disposition.
  #
  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#12
  def disposition; end

  # Returns the value of attribute filename.
  #
  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#12
  def filename; end

  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#31
  def to_s; end

  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#27
  def utf8_filename; end

  private

  # source://actionpack//lib/action_dispatch/http/content_disposition.rb#40
  def percent_escape(string, pattern); end

  class << self
    # source://actionpack//lib/action_dispatch/http/content_disposition.rb#8
    def format(disposition:, filename:); end
  end
end

# source://actionpack//lib/action_dispatch/http/content_disposition.rb#25
ActionDispatch::Http::ContentDisposition::RFC_5987_ESCAPED_CHAR = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/content_disposition.rb#19
ActionDispatch::Http::ContentDisposition::TRADITIONAL_ESCAPED_CHAR = T.let(T.unsafe(nil), Regexp)

# # Action Dispatch HTTP Filter Parameters
#
# Allows you to specify sensitive query string and POST parameters to filter
# from the request log.
#
#     # Replaces values with "[FILTERED]" for keys that match /foo|bar/i.
#     env["action_dispatch.parameter_filter"] = [:foo, "bar"]
#
# For more information about filter behavior, see
# ActiveSupport::ParameterFilter.
#
# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#19
module ActionDispatch::Http::FilterParameters
  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#24
  def initialize; end

  # Returns a hash of request.env with all sensitive data replaced.
  #
  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#40
  def filtered_env; end

  # Returns a hash of parameters with all sensitive data replaced.
  #
  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#33
  def filtered_parameters; end

  # Reconstructs a path with all sensitive GET parameters replaced.
  #
  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#45
  def filtered_path; end

  # Returns the `ActiveSupport::ParameterFilter` object used to filter in this
  # request.
  #
  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#51
  def parameter_filter; end

  private

  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#60
  def env_filter; end

  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#73
  def filtered_query_string; end

  # source://actionpack//lib/action_dispatch/http/filter_parameters.rb#67
  def parameter_filter_for(filters); end
end

# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#20
ActionDispatch::Http::FilterParameters::ENV_MATCH = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#71
ActionDispatch::Http::FilterParameters::KV_RE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#22
ActionDispatch::Http::FilterParameters::NULL_ENV_FILTER = T.let(T.unsafe(nil), ActiveSupport::ParameterFilter)

# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#21
ActionDispatch::Http::FilterParameters::NULL_PARAM_FILTER = T.let(T.unsafe(nil), ActiveSupport::ParameterFilter)

# source://actionpack//lib/action_dispatch/http/filter_parameters.rb#72
ActionDispatch::Http::FilterParameters::PAIR_RE = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/filter_redirect.rb#7
module ActionDispatch::Http::FilterRedirect
  # source://actionpack//lib/action_dispatch/http/filter_redirect.rb#10
  def filtered_location; end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/filter_redirect.rb#27
  def location_filter_match?; end

  # source://actionpack//lib/action_dispatch/http/filter_redirect.rb#19
  def location_filters; end

  # source://actionpack//lib/action_dispatch/http/filter_redirect.rb#37
  def parameter_filtered_location; end
end

# source://actionpack//lib/action_dispatch/http/filter_redirect.rb#8
ActionDispatch::Http::FilterRedirect::FILTERED = T.let(T.unsafe(nil), String)

# # Action Dispatch HTTP Headers
#
# Provides access to the request's HTTP headers from the environment.
#
#     env     = { "CONTENT_TYPE" => "text/plain", "HTTP_USER_AGENT" => "curl/7.43.0" }
#     headers = ActionDispatch::Http::Headers.from_hash(env)
#     headers["Content-Type"] # => "text/plain"
#     headers["User-Agent"] # => "curl/7.43.0"
#
# Also note that when headers are mapped to CGI-like variables by the Rack
# server, both dashes and underscores are converted to underscores. This
# ambiguity cannot be resolved at this stage anymore. Both underscores and
# dashes have to be interpreted as if they were originally sent as dashes.
#
#     # GET / HTTP/1.1
#     # ...
#     # User-Agent: curl/7.43.0
#     # X_Custom_Header: token
#
#     headers["X_Custom_Header"] # => nil
#     headers["X-Custom-Header"] # => "token"
#
# source://actionpack//lib/action_dispatch/http/headers.rb#28
class ActionDispatch::Http::Headers
  include ::Enumerable

  # @return [Headers] a new instance of Headers
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#58
  def initialize(request); end

  # Returns the value for the given key mapped to @env.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#63
  def [](key); end

  # Sets the given value for the key mapped to @env.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#68
  def []=(key, value); end

  # Add a value to a multivalued header like `Vary` or `Accept-Encoding`.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#73
  def add(key, value); end

  # source://actionpack//lib/action_dispatch/http/headers.rb#98
  def each(&block); end

  # source://actionpack//lib/action_dispatch/http/headers.rb#118
  def env; end

  # Returns the value for the given key mapped to @env.
  #
  # If the key is not found and an optional code block is not provided, raises a
  # `KeyError` exception.
  #
  # If the code block is provided, then it will be run and its result returned.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#90
  def fetch(key, default = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#77
  def include?(key); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#77
  def key?(key); end

  # Returns a new Http::Headers instance containing the contents of
  # `headers_or_env` and the original instance.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#104
  def merge(headers_or_env); end

  # Adds the contents of `headers_or_env` to original instance entries; duplicate
  # keys are overwritten with the values from `headers_or_env`.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#112
  def merge!(headers_or_env); end

  private

  # Converts an HTTP header name to an environment variable name if it is not
  # contained within the headers hash.
  #
  # source://actionpack//lib/action_dispatch/http/headers.rb#123
  def env_name(key); end

  class << self
    # source://actionpack//lib/action_dispatch/http/headers.rb#54
    def from_hash(hash); end
  end
end

# source://actionpack//lib/action_dispatch/http/headers.rb#29
ActionDispatch::Http::Headers::CGI_VARIABLES = T.let(T.unsafe(nil), Set)

# source://actionpack//lib/action_dispatch/http/headers.rb#82
ActionDispatch::Http::Headers::DEFAULT = T.let(T.unsafe(nil), Object)

# source://actionpack//lib/action_dispatch/http/headers.rb#50
ActionDispatch::Http::Headers::HTTP_HEADER = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#9
module ActionDispatch::Http::MimeNegotiation
  extend ::ActiveSupport::Concern

  # Returns the accepted MIME type for the request.
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#42
  def accepts; end

  # The MIME type of the HTTP request, such as [Mime](:xml).
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#24
  def content_mime_type; end

  # Returns the MIME type for the format used in the request.
  #
  #     GET /posts/5.xml   | request.format => Mime[:xml]
  #     GET /posts/5.xhtml | request.format => Mime[:html]
  #     GET /posts/5       | request.format => Mime[:html] or Mime[:js], or request.accepts.first
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#63
  def format(_view_path = T.unsafe(nil)); end

  # Sets the format by string extension, which can be used to force custom formats
  # that are not controlled by the extension.
  #
  #     class ApplicationController < ActionController::Base
  #       before_action :adjust_format_for_iphone
  #
  #       private
  #         def adjust_format_for_iphone
  #           request.format = :iphone if request.env["HTTP_USER_AGENT"][/iPhone/]
  #         end
  #     end
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#115
  def format=(extension); end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#67
  def formats; end

  # Sets the formats by string extensions. This differs from #format= by allowing
  # you to set multiple, ordered formats, which is useful when you want to have a
  # fallback.
  #
  # In this example, the `:iphone` format will be used if it's available,
  # otherwise it'll fall back to the `:html` format.
  #
  #     class ApplicationController < ActionController::Base
  #       before_action :adjust_format_for_iphone_with_html_fallback
  #
  #       private
  #         def adjust_format_for_iphone_with_html_fallback
  #           request.formats = [ :iphone, :html ] if request.env["HTTP_USER_AGENT"][/iPhone/]
  #         end
  #     end
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#135
  def formats=(extensions); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#37
  def has_content_type?; end

  # Returns the first MIME type that matches the provided array of MIME types.
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#143
  def negotiate_mime(order); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#155
  def should_apply_vary_header?; end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#100
  def variant; end

  # Sets the variant for template.
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#90
  def variant=(variant); end

  private

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#179
  def format_from_path_extension; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#164
  def params_readable?; end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#175
  def use_accept_header; end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#170
  def valid_accept_header; end
end

# We use normal content negotiation unless you include **/** in your list, in
# which case we assume you're a browser and send HTML.
#
# source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#162
ActionDispatch::Http::MimeNegotiation::BROWSER_LIKE_ACCEPTS = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#12
class ActionDispatch::Http::MimeNegotiation::InvalidType < ::Mime::Type::InvalidMimeType; end

# source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#14
ActionDispatch::Http::MimeNegotiation::RESCUABLE_MIME_FORMAT_ERRORS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/parameters.rb#7
module ActionDispatch::Http::Parameters
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionDispatch::Http::Parameters::ClassMethods

  # Returns both GET and POST parameters in a single hash.
  #
  # source://actionpack//lib/action_dispatch/http/parameters.rb#52
  def parameters; end

  # Returns both GET and POST parameters in a single hash.
  #
  # source://actionpack//lib/action_dispatch/http/parameters.rb#52
  def params; end

  # Returns a hash with the parameters used to form the path of the request.
  # Returned hash keys are symbols:
  #
  #     { action: "my_action", controller: "my_controller" }
  #
  # source://actionpack//lib/action_dispatch/http/parameters.rb#84
  def path_parameters; end

  # source://actionpack//lib/action_dispatch/http/parameters.rb#67
  def path_parameters=(parameters); end

  private

  # source://actionpack//lib/action_dispatch/http/parameters.rb#102
  def log_parse_error_once; end

  # source://actionpack//lib/action_dispatch/http/parameters.rb#114
  def params_parsers; end

  # source://actionpack//lib/action_dispatch/http/parameters.rb#89
  def parse_formatted_parameters(parsers); end
end

# source://actionpack//lib/action_dispatch/http/parameters.rb#36
module ActionDispatch::Http::Parameters::ClassMethods
  # Configure the parameter parser for a given MIME type.
  #
  # It accepts a hash where the key is the symbol of the MIME type and the value
  # is a proc.
  #
  #     original_parsers = ActionDispatch::Request.parameter_parsers
  #     xml_parser = -> (raw_post) { Hash.from_xml(raw_post) || {} }
  #     new_parsers = original_parsers.merge(xml: xml_parser)
  #     ActionDispatch::Request.parameter_parsers = new_parsers
  #
  # source://actionpack//lib/action_dispatch/http/parameters.rb#46
  def parameter_parsers=(parsers); end
end

# source://actionpack//lib/action_dispatch/http/parameters.rb#12
ActionDispatch::Http::Parameters::DEFAULT_PARSERS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/parameters.rb#10
ActionDispatch::Http::Parameters::PARAMETERS_KEY = T.let(T.unsafe(nil), String)

# Raised when raw data from the request cannot be parsed by the parser defined
# for request's content MIME type.
#
# source://actionpack//lib/action_dispatch/http/parameters.rb#21
class ActionDispatch::Http::Parameters::ParseError < ::StandardError
  # @return [ParseError] a new instance of ParseError
  #
  # source://actionpack//lib/action_dispatch/http/parameters.rb#22
  def initialize(message = T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/http/url.rb#9
module ActionDispatch::Http::URL
  # source://actionpack//lib/action_dispatch/http/url.rb#181
  def initialize; end

  # Returns the domain part of a host, such as "rubyonrails.org" in
  # "www.rubyonrails.org". You can specify a different `tld_length`, such as 2 to
  # catch rubyonrails.co.uk in "www.rubyonrails.co.uk".
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#324
  def domain(tld_length = T.unsafe(nil)); end

  # Returns the host for this request, such as "example.com".
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.host # => "example.com"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#228
  def host; end

  # Returns a host:port string for this request, such as "example.com" or
  # "example.com:8080". Port is only included if it is not a default port (80 or
  # 443)
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com'
  #     req.host_with_port # => "example.com"
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:80'
  #     req.host_with_port # => "example.com"
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.host_with_port # => "example.com:8080"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#244
  def host_with_port; end

  # Returns a number port suffix like 8080 if the port number of this request is
  # not the default HTTP port 80 or HTTPS port 443.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:80'
  #     req.optional_port # => nil
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.optional_port # => 8080
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#294
  def optional_port; end

  # Returns the port number of this request as an integer.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com'
  #     req.port # => 80
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.port # => 8080
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#255
  def port; end

  # Returns a string port suffix, including colon, like ":8080" if the port number
  # of this request is not the default HTTP port 80 or HTTPS port 443.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:80'
  #     req.port_string # => ""
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.port_string # => ":8080"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#306
  def port_string; end

  # Returns 'https://' if this is an SSL request and 'http://' otherwise.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com'
  #     req.protocol # => "http://"
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com', 'HTTPS' => 'on'
  #     req.protocol # => "https://"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#202
  def protocol; end

  # Returns the host and port for this request, such as "example.com:8080".
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com'
  #     req.raw_host_with_port # => "example.com"
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:80'
  #     req.raw_host_with_port # => "example.com:80"
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.raw_host_with_port # => "example.com:8080"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#216
  def raw_host_with_port; end

  # source://actionpack//lib/action_dispatch/http/url.rb#14
  def secure_protocol; end

  # source://actionpack//lib/action_dispatch/http/url.rb#14
  def secure_protocol=(val); end

  # Returns the requested port, such as 8080, based on SERVER_PORT
  #
  #     req = ActionDispatch::Request.new 'SERVER_PORT' => '80'
  #     req.server_port # => 80
  #
  #     req = ActionDispatch::Request.new 'SERVER_PORT' => '8080'
  #     req.server_port # => 8080
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#317
  def server_port; end

  # Returns the standard port number for this request's protocol.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.standard_port # => 80
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#267
  def standard_port; end

  # Returns whether this request is using the standard port
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:80'
  #     req.standard_port? # => true
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com:8080'
  #     req.standard_port? # => false
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#282
  def standard_port?; end

  # Returns all the subdomains as a string, so `"dev.www"` would be returned for
  # "dev.www.rubyonrails.org". You can specify a different `tld_length`, such as 2
  # to catch `"www"` instead of `"www.rubyonrails"` in "www.rubyonrails.co.uk".
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#339
  def subdomain(tld_length = T.unsafe(nil)); end

  # Returns all the subdomains as an array, so `["dev", "www"]` would be returned
  # for "dev.www.rubyonrails.org". You can specify a different `tld_length`, such
  # as 2 to catch `["www"]` instead of `["www", "rubyonrails"]` in
  # "www.rubyonrails.co.uk".
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#332
  def subdomains(tld_length = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/url.rb#15
  def tld_length; end

  # source://actionpack//lib/action_dispatch/http/url.rb#15
  def tld_length=(val); end

  # Returns the complete URL used for this request.
  #
  #     req = ActionDispatch::Request.new 'HTTP_HOST' => 'example.com'
  #     req.url # => "http://example.com"
  #
  # source://actionpack//lib/action_dispatch/http/url.rb#191
  def url; end

  class << self
    # Returns the domain part of a host given the domain level.
    #
    #     # Top-level domain example
    #     extract_domain('www.example.com', 1) # => "example.com"
    #     # Second-level domain example
    #     extract_domain('dev.www.example.co.uk', 2) # => "example.co.uk"
    #
    # source://actionpack//lib/action_dispatch/http/url.rb#24
    def extract_domain(host, tld_length); end

    # Returns the subdomains of a host as a String given the domain level.
    #
    #     # Top-level domain example
    #     extract_subdomain('www.example.com', 1) # => "www"
    #     # Second-level domain example
    #     extract_subdomain('dev.www.example.co.uk', 2) # => "dev.www"
    #
    # source://actionpack//lib/action_dispatch/http/url.rb#48
    def extract_subdomain(host, tld_length); end

    # Returns the subdomains of a host as an Array given the domain level.
    #
    #     # Top-level domain example
    #     extract_subdomains('www.example.com', 1) # => ["www"]
    #     # Second-level domain example
    #     extract_subdomains('dev.www.example.co.uk', 2) # => ["dev", "www"]
    #
    # source://actionpack//lib/action_dispatch/http/url.rb#34
    def extract_subdomains(host, tld_length); end

    # source://actionpack//lib/action_dispatch/http/url.rb#60
    def full_url_for(options); end

    # source://actionpack//lib/action_dispatch/http/url.rb#72
    def path_for(options); end

    # source://actionpack//lib/action_dispatch/http/url.rb#14
    def secure_protocol; end

    # source://actionpack//lib/action_dispatch/http/url.rb#14
    def secure_protocol=(val); end

    # source://actionpack//lib/action_dispatch/http/url.rb#15
    def tld_length; end

    # source://actionpack//lib/action_dispatch/http/url.rb#15
    def tld_length=(val); end

    # source://actionpack//lib/action_dispatch/http/url.rb#52
    def url_for(options); end

    private

    # source://actionpack//lib/action_dispatch/http/url.rb#92
    def add_anchor(path, anchor); end

    # source://actionpack//lib/action_dispatch/http/url.rb#85
    def add_params(path, params); end

    # source://actionpack//lib/action_dispatch/http/url.rb#107
    def build_host_url(host, port, protocol, options, path); end

    # source://actionpack//lib/action_dispatch/http/url.rb#98
    def extract_domain_from(host, tld_length); end

    # source://actionpack//lib/action_dispatch/http/url.rb#102
    def extract_subdomains_from(host, tld_length); end

    # @return [Boolean]
    #
    # source://actionpack//lib/action_dispatch/http/url.rb#131
    def named_host?(host); end

    # source://actionpack//lib/action_dispatch/http/url.rb#148
    def normalize_host(_host, options); end

    # source://actionpack//lib/action_dispatch/http/url.rb#168
    def normalize_port(port, protocol); end

    # source://actionpack//lib/action_dispatch/http/url.rb#135
    def normalize_protocol(protocol); end
  end
end

# source://actionpack//lib/action_dispatch/http/url.rb#11
ActionDispatch::Http::URL::HOST_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/url.rb#10
ActionDispatch::Http::URL::IP_HOST_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/url.rb#12
ActionDispatch::Http::URL::PROTOCOL_REGEXP = T.let(T.unsafe(nil), Regexp)

# # Action Dispatch HTTP UploadedFile
#
# Models uploaded files.
#
# The actual file is accessible via the `tempfile` accessor, though some of its
# interface is available directly for convenience.
#
# Uploaded files are temporary files whose lifespan is one request. When the
# object is finalized Ruby unlinks the file, so there is no need to clean them
# with a separate maintenance task.
#
# source://actionpack//lib/action_dispatch/http/upload.rb#17
class ActionDispatch::Http::UploadedFile
  # @raise [ArgumentError]
  # @return [UploadedFile] a new instance of UploadedFile
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#31
  def initialize(hash); end

  # Shortcut for `tempfile.close`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#73
  def close(unlink_now = T.unsafe(nil)); end

  # A string with the MIME type of the file.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#22
  def content_type; end

  # A string with the MIME type of the file.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#22
  def content_type=(_arg0); end

  # Shortcut for `tempfile.eof?`.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#98
  def eof?; end

  # A string with the headers of the multipart request.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#29
  def headers; end

  # A string with the headers of the multipart request.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#29
  def headers=(_arg0); end

  # Shortcut for `tempfile.open`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#68
  def open; end

  # The basename of the file in the client.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#19
  def original_filename; end

  # The basename of the file in the client.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#19
  def original_filename=(_arg0); end

  # Shortcut for `tempfile.path`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#78
  def path; end

  # Shortcut for `tempfile.read`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#63
  def read(length = T.unsafe(nil), buffer = T.unsafe(nil)); end

  # Shortcut for `tempfile.rewind`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#88
  def rewind; end

  # Shortcut for `tempfile.size`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#93
  def size; end

  # A `Tempfile` object with the actual uploaded file. Note that some of its
  # interface is available directly.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#26
  def tempfile; end

  # A `Tempfile` object with the actual uploaded file. Note that some of its
  # interface is available directly.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#26
  def tempfile=(_arg0); end

  # source://actionpack//lib/action_dispatch/http/upload.rb#102
  def to_io; end

  # Shortcut for `tempfile.to_path`.
  #
  # source://actionpack//lib/action_dispatch/http/upload.rb#83
  def to_path; end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#14
module ActionDispatch::Integration; end

# source://actionpack//lib/action_dispatch/testing/integration.rb#15
module ActionDispatch::Integration::RequestHelpers
  # Performs a DELETE request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#42
  def delete(path, **args); end

  # Follow a single redirect response. If the last response was not a redirect, an
  # exception will be raised. Otherwise, the redirect is performed on the location
  # header. If the redirection is a 307 or 308 redirect, the same HTTP verb will
  # be used when redirecting, otherwise a GET request will be performed. Any
  # arguments are passed to the underlying request.
  #
  # The HTTP_REFERER header will be set to the previous url.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#65
  def follow_redirect!(headers: T.unsafe(nil), **args); end

  # Performs a GET request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#18
  def get(path, **args); end

  # Performs a HEAD request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#48
  def head(path, **args); end

  # Performs an OPTIONS request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#54
  def options(path, **args); end

  # Performs a PATCH request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#30
  def patch(path, **args); end

  # Performs a POST request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#24
  def post(path, **args); end

  # Performs a PUT request with the given parameters. See
  # ActionDispatch::Integration::Session#process for more details.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#36
  def put(path, **args); end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#324
module ActionDispatch::Integration::Runner
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  include ::ActionDispatch::Assertions
  extend ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # source://actionpack//lib/action_dispatch/testing/integration.rb#332
  def initialize(*args, &blk); end

  # Returns the value of attribute app.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#329
  def app; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#402
  def assertions; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#406
  def assertions=(assertions); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def assigns(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#337
  def before_setup; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def cookies(*_arg0, **_arg1, &_arg2); end

  # Copy the instance variables from the current session instance into the test
  # instance.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#412
  def copy_session_variables!; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#352
  def create_session(app); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#418
  def default_url_options; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#422
  def default_url_options=(options); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def delete(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def follow_redirect!(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def get(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def head(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#342
  def integration_session; end

  # Open a new session instance. If a block is given, the new session is yielded
  # to the block before being returned.
  #
  #     session = open_session do |sess|
  #       sess.extend(CustomAssertions)
  #     end
  #
  # By default, a single session is automatically created for you, but you can use
  # this method to open multiple sessions that ought to be tested simultaneously.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#394
  def open_session; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def patch(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def post(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#375
  def put(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#364
  def remove!; end

  # Reset the current session. This is useful for testing multiple sessions in a
  # single test case.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#348
  def reset!; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#330
  def root_session; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#330
  def root_session=(_arg0); end

  private

  # Delegate unhandled messages to the current session instance.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#432
  def method_missing(method, *_arg1, **_arg2, &_arg3); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#427
  def respond_to_missing?(method, _); end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#327
ActionDispatch::Integration::Runner::APP_SESSIONS = T.let(T.unsafe(nil), Hash)

# An instance of this class represents a set of requests and responses performed
# sequentially by a test process. Because you can instantiate multiple sessions
# and run them side-by-side, you can also mimic (to some limited extent)
# multiple simultaneous users interacting with your system.
#
# Typically, you will instantiate a new session using Runner#open_session,
# rather than instantiating a Session directly.
#
# source://actionpack//lib/action_dispatch/testing/integration.rb#91
class ActionDispatch::Integration::Session
  include ::Minitest::Assertions
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  include ::ActionDispatch::Assertions
  include ::ActionDispatch::Integration::RequestHelpers
  include ::ActionDispatch::TestProcess::FixtureFile
  include ::ActionDispatch::TestProcess
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor
  extend ::ActionDispatch::Assertions::RoutingAssertions::ClassMethods

  # Create and initialize a new Session instance.
  #
  # @return [Session] a new instance of Session
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#133
  def initialize(app); end

  # The Accept header to send.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#110
  def accept; end

  # The Accept header to send.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#110
  def accept=(_arg0); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#97
  def body(*_arg0, **_arg1, &_arg2); end

  # A reference to the controller instance used by the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#119
  def controller; end

  # A map of the cookies returned by the last response, and which will be sent
  # with the next request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#114
  def cookies; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options?; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#97
  def headers(*_arg0, **_arg1, &_arg2); end

  # The hostname used in the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#101
  def host; end

  # Sets the attribute host
  # Set the host name to use in the next request.
  #
  #     session.host! "www.example.com"
  #
  # @param value the value to set the attribute host to.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#104
  def host!(_arg0); end

  # Sets the attribute host
  #
  # @param value the value to set the attribute host to.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#104
  def host=(_arg0); end

  # Specify whether or not the session should mimic a secure HTTPS request.
  #
  #     session.https!
  #     session.https!(false)
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#180
  def https!(flag = T.unsafe(nil)); end

  # Returns `true` if the session is mimicking a secure HTTPS request.
  #
  #     if session.https?
  #       ...
  #     end
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#189
  def https?; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#98
  def path(*_arg0, **_arg1, &_arg2); end

  # Performs the actual request.
  #
  # *   `method`: The HTTP method (GET, POST, PATCH, PUT, DELETE, HEAD, OPTIONS)
  #     as a symbol.
  # *   `path`: The URI (as a String) on which you want to perform the request.
  # *   `params`: The HTTP parameters that you want to pass. This may be `nil`, a
  #     Hash, or a String that is appropriately encoded
  #     (`application/x-www-form-urlencoded` or `multipart/form-data`).
  # *   `headers`: Additional headers to pass, as a Hash. The headers will be
  #     merged into the Rack env hash.
  # *   `env`: Additional env to pass, as a Hash. The headers will be merged into
  #     the Rack env hash.
  # *   `xhr`: Set to `true` if you want to make an Ajax request. Adds request
  #     headers characteristic of XMLHttpRequest e.g. HTTP_X_REQUESTED_WITH. The
  #     headers will be merged into the Rack env hash.
  # *   `as`: Used for encoding the request with different content type. Supports
  #     `:json` by default and will set the appropriate request headers. The
  #     headers will be merged into the Rack env hash.
  #
  #
  # This method is rarely used directly. Use RequestHelpers#get,
  # RequestHelpers#post, or other standard HTTP methods in integration tests.
  # `#process` is only required when using a request method that doesn't have a
  # method defined in the integration tests.
  #
  # This method returns the response status, after performing the request.
  # Furthermore, if this method was called from an ActionDispatch::IntegrationTest
  # object, then that object's `@response` instance variable will point to a
  # Response object which one can use to inspect the details of the response.
  #
  # Example:
  #     process :get, '/author', params: { since: 201501011400 }
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#225
  def process(method, path, params: T.unsafe(nil), headers: T.unsafe(nil), env: T.unsafe(nil), xhr: T.unsafe(nil), as: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#97
  def redirect?(*_arg0, **_arg1, &_arg2); end

  # The remote_addr used in the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#107
  def remote_addr; end

  # The remote_addr used in the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#107
  def remote_addr=(_arg0); end

  # A reference to the request instance used by the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#122
  def request; end

  # A running counter of the number of requests processed.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#128
  def request_count; end

  # A running counter of the number of requests processed.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#128
  def request_count=(_arg0); end

  # Resets the instance. This can be used to reset the state information in an
  # existing session instance, so it can be used from a clean-slate condition.
  #
  #     session.reset!
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#156
  def reset!; end

  # A reference to the response instance used by the last request.
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#125
  def response; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#97
  def status(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#97
  def status_message(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#140
  def url_options; end

  private

  # source://actionpack//lib/action_dispatch/testing/integration.rb#308
  def _mock_session; end

  # @yield [location]
  #
  # source://actionpack//lib/action_dispatch/testing/integration.rb#316
  def build_expanded_path(path); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#312
  def build_full_uri(path, env); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options; end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options=(value); end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options?; end
  end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#92
ActionDispatch::Integration::Session::DEFAULT_HOST = T.let(T.unsafe(nil), String)

# An integration test spans multiple controllers and actions, tying them all
# together to ensure they work together as expected. It tests more completely
# than either unit or functional tests do, exercising the entire stack, from the
# dispatcher to the database.
#
# At its simplest, you simply extend `IntegrationTest` and write your tests
# using the Integration::RequestHelpers#get and/or
# Integration::RequestHelpers#post methods:
#
#     require "test_helper"
#
#     class ExampleTest < ActionDispatch::IntegrationTest
#       fixtures :people
#
#       def test_login
#         # get the login page
#         get "/login"
#         assert_equal 200, status
#
#         # post the login and follow through to the home page
#         post "/login", params: { username: people(:jamis).username,
#           password: people(:jamis).password }
#         follow_redirect!
#         assert_equal 200, status
#         assert_equal "/home", path
#       end
#     end
#
# However, you can also have multiple session instances open per test, and even
# extend those instances with assertions and methods to create a very powerful
# testing DSL that is specific for your application. You can even reference any
# named routes you happen to have defined.
#
#     require "test_helper"
#
#     class AdvancedTest < ActionDispatch::IntegrationTest
#       fixtures :people, :rooms
#
#       def test_login_and_speak
#         jamis, david = login(:jamis), login(:david)
#         room = rooms(:office)
#
#         jamis.enter(room)
#         jamis.speak(room, "anybody home?")
#
#         david.enter(room)
#         david.speak(room, "hello!")
#       end
#
#       private
#
#         module CustomAssertions
#           def enter(room)
#             # reference a named route, for maximum internal consistency!
#             get(room_url(id: room.id))
#             assert(...)
#             ...
#           end
#
#           def speak(room, message)
#             post "/say/#{room.id}", xhr: true, params: { message: message }
#             assert(...)
#             ...
#           end
#         end
#
#         def login(who)
#           open_session do |sess|
#             sess.extend(CustomAssertions)
#             who = people(who)
#             sess.post "/login", params: { username: who.username,
#               password: who.password }
#             assert(...)
#           end
#         end
#     end
#
# Another longer example would be:
#
# A simple integration test that exercises multiple controllers:
#
#     require "test_helper"
#
#     class UserFlowsTest < ActionDispatch::IntegrationTest
#       test "login and browse site" do
#         # login via https
#         https!
#         get "/login"
#         assert_response :success
#
#         post "/login", params: { username: users(:david).username, password: users(:david).password }
#         follow_redirect!
#         assert_equal '/welcome', path
#         assert_equal 'Welcome david!', flash[:notice]
#
#         https!(false)
#         get "/articles/all"
#         assert_response :success
#         assert_select 'h1', 'Articles'
#       end
#     end
#
# As you can see the integration test involves multiple controllers and
# exercises the entire stack from database to dispatcher. In addition you can
# have multiple session instances open simultaneously in a test and extend those
# instances with assertion methods to create a very powerful testing DSL
# (domain-specific language) just for your application.
#
# Here's an example of multiple sessions and custom DSL in an integration test
#
#     require "test_helper"
#
#     class UserFlowsTest < ActionDispatch::IntegrationTest
#       test "login and browse site" do
#         # User david logs in
#         david = login(:david)
#         # User guest logs in
#         guest = login(:guest)
#
#         # Both are now available in different sessions
#         assert_equal 'Welcome david!', david.flash[:notice]
#         assert_equal 'Welcome guest!', guest.flash[:notice]
#
#         # User david can browse site
#         david.browses_site
#         # User guest can browse site as well
#         guest.browses_site
#
#         # Continue with other assertions
#       end
#
#       private
#
#         module CustomDsl
#           def browses_site
#             get "/products/all"
#             assert_response :success
#             assert_select 'h1', 'Products'
#           end
#         end
#
#         def login(user)
#           open_session do |sess|
#             sess.extend(CustomDsl)
#             u = users(user)
#             sess.https!
#             sess.post "/login", params: { username: u.username, password: u.password }
#             assert_equal '/welcome', sess.path
#             sess.https!(false)
#           end
#         end
#     end
#
# See the [request helpers documentation]
# (rdoc-ref:ActionDispatch::Integration::RequestHelpers) for help
# on how to use `get`, etc.
#
# ### Changing the request encoding
#
# You can also test your JSON API easily by setting what the request should be
# encoded as:
#
#     require "test_helper"
#
#     class ApiTest < ActionDispatch::IntegrationTest
#       test "creates articles" do
#         assert_difference -> { Article.count } do
#           post articles_path, params: { article: { title: "Ahoy!" } }, as: :json
#         end
#
#         assert_response :success
#         assert_equal({ id: Article.last.id, title: "Ahoy!" }, response.parsed_body)
#       end
#     end
#
# The `as` option passes an "application/json" Accept header (thereby setting
# the request format to JSON unless overridden), sets the content type to
# "application/json" and encodes the parameters as JSON.
#
# Calling TestResponse#parsed_body on the response parses the response body
# based on the last response MIME type.
#
# Out of the box, only `:json` is supported. But for any custom MIME types
# you've registered, you can add your own encoders with:
#
#     ActionDispatch::IntegrationTest.register_encoder :wibble,
#       param_encoder: -> params { params.to_wibble },
#       response_parser: -> body { body }
#
# Where `param_encoder` defines how the params should be encoded and
# `response_parser` defines how the response body should be parsed through
# TestResponse#parsed_body.
#
# Consult the [Rails Testing Guide](https://guides.rubyonrails.org/testing.html)
# for more.
#
# source://actionpack//lib/action_dispatch/testing/integration.rb#640
class ActionDispatch::IntegrationTest < ::ActiveSupport::TestCase
  include ::ActionDispatch::TestProcess::FixtureFile
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  include ::ActionDispatch::Assertions
  include ::ActionDispatch::Integration::Runner
  include ::ActionController::TemplateAssertions
  include ::ActionDispatch::TestHelpers::PageDumpHelper
  include ::ActionDispatch::IntegrationTest::Behavior
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor
  include ::ActionDispatch::IntegrationTest::UrlOptions
  include ::ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting
  extend ::ActionDispatch::IntegrationTest::Behavior::ClassMethods
  extend ::ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting::ClassMethods
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#650
module ActionDispatch::IntegrationTest::Behavior
  include ::ActionDispatch::Assertions::RoutingAssertions
  include ::ActionDispatch::Assertions::ResponseAssertions
  include ::Rails::Dom::Testing::Assertions::DomAssertions
  include ::Rails::Dom::Testing::Assertions::SelectorAssertions
  include ::Rails::Dom::Testing::Assertions
  include ::ActionDispatch::Assertions
  include ::ActionDispatch::Integration::Runner
  include ::ActionController::TemplateAssertions
  include ::ActionDispatch::TestHelpers::PageDumpHelper
  extend ::ActiveSupport::Concern
  include ::ActionDispatch::Routing::UrlFor
  include ::ActionDispatch::IntegrationTest::UrlOptions
  include ::ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting

  mixes_in_class_methods ::ActionDispatch::IntegrationTest::Behavior::ClassMethods
  mixes_in_class_methods ::ActionDispatch::Assertions::RoutingAssertions::WithIntegrationRouting::ClassMethods

  # source://actionpack//lib/action_dispatch/testing/integration.rb#683
  def app; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#687
  def document_root_element; end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#665
module ActionDispatch::IntegrationTest::Behavior::ClassMethods
  # source://actionpack//lib/action_dispatch/testing/integration.rb#666
  def app; end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#674
  def app=(app); end

  # source://actionpack//lib/action_dispatch/testing/integration.rb#678
  def register_encoder(*args, **options); end
end

# source://actionpack//lib/action_dispatch/testing/integration.rb#643
module ActionDispatch::IntegrationTest::UrlOptions
  extend ::ActiveSupport::Concern

  # source://actionpack//lib/action_dispatch/testing/integration.rb#645
  def url_options; end
end

# :stopdoc:
#
# source://actionpack//lib/action_dispatch/journey/router/utils.rb#6
module ActionDispatch::Journey; end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#9
class ActionDispatch::Journey::Ast
  # @return [Ast] a new instance of Ast
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#13
  def initialize(tree, formatted); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#38
  def glob?; end

  # Returns the value of attribute names.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def names; end

  # Returns the value of attribute path_params.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def path_params; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#25
  def requirements=(requirements); end

  # Returns the value of attribute tree.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def root; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#34
  def route=(route); end

  # Returns the value of attribute terminals.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def terminals; end

  # Returns the value of attribute tree.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def tree; end

  # Returns the value of attribute wildcard_options.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#10
  def wildcard_options; end

  private

  # Returns the value of attribute stars.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#43
  def stars; end

  # Returns the value of attribute symbols.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#43
  def symbols; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#45
  def visit_tree(formatted); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#8
class ActionDispatch::Journey::Format
  # @return [Format] a new instance of Format
  #
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#24
  def initialize(parts); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#39
  def evaluate(hash); end

  class << self
    # source://actionpack//lib/action_dispatch/journey/visitors.rb#16
    def required_path(symbol); end

    # source://actionpack//lib/action_dispatch/journey/visitors.rb#20
    def required_segment(symbol); end
  end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#9
ActionDispatch::Journey::Format::ESCAPE_PATH = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/journey/visitors.rb#10
ActionDispatch::Journey::Format::ESCAPE_SEGMENT = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/journey/visitors.rb#12
class ActionDispatch::Journey::Format::Parameter < ::Struct
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#13
  def escape(value); end

  # Returns the value of attribute escaper
  #
  # @return [Object] the current value of escaper
  def escaper; end

  # Sets the attribute escaper
  #
  # @param value [Object] the value to set the attribute escaper to.
  # @return [Object] the newly set value
  def escaper=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# The Formatter class is used for formatting URLs. For example, parameters
# passed to `url_for` in Rails will eventually call Formatter#generate.
#
# source://actionpack//lib/action_dispatch/journey/formatter.rb#12
class ActionDispatch::Journey::Formatter
  # @return [Formatter] a new instance of Formatter
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#15
  def initialize(routes); end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#105
  def clear; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#109
  def eager_load!; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#61
  def generate(name, options, path_parameters); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#13
  def routes; end

  private

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#209
  def build_cache; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#220
  def cache; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#115
  def extract_parameterized_parts(route, options, recall); end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#142
  def match_route(name, options); end

  # Returns an array populated with missing keys if any are present.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#181
  def missing_keys(route, parts); end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#138
  def named_routes; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#164
  def non_recursive(cache, options); end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#201
  def possibles(cache, options, depth = T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/journey/formatter.rb#34
class ActionDispatch::Journey::Formatter::MissingRoute
  # @return [MissingRoute] a new instance of MissingRoute
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#37
  def initialize(constraints, missing_keys, unmatched_keys, routes, name); end

  # Returns the value of attribute constraints.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#35
  def constraints; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#53
  def message; end

  # Returns the value of attribute missing_keys.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#35
  def missing_keys; end

  # Returns the value of attribute name.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#35
  def name; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#49
  def params; end

  # @raise [ActionController::UrlGenerationError]
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#45
  def path(method_name); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#35
  def routes; end

  # Returns the value of attribute unmatched_keys.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#35
  def unmatched_keys; end
end

# source://actionpack//lib/action_dispatch/journey/formatter.rb#20
class ActionDispatch::Journey::Formatter::RouteWithParams
  # @return [RouteWithParams] a new instance of RouteWithParams
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#23
  def initialize(route, parameterized_parts, params); end

  # Returns the value of attribute params.
  #
  # source://actionpack//lib/action_dispatch/journey/formatter.rb#21
  def params; end

  # source://actionpack//lib/action_dispatch/journey/formatter.rb#29
  def path(_); end
end

# source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#9
module ActionDispatch::Journey::GTG; end

# source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#10
class ActionDispatch::Journey::GTG::Builder
  # @return [Builder] a new instance of Builder
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#15
  def initialize(root); end

  # Returns the value of attribute ast.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#13
  def ast; end

  # Returns the value of attribute endpoints.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#13
  def endpoints; end

  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#87
  def firstpos(node); end

  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#108
  def lastpos(node); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#66
  def nullable?(node); end

  # Returns the value of attribute root.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#13
  def root; end

  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#21
  def transition_table; end

  private

  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#130
  def build_followpos; end

  # source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#143
  def symbol(edge); end
end

# source://actionpack//lib/action_dispatch/journey/gtg/builder.rb#11
ActionDispatch::Journey::GTG::Builder::DUMMY_END_NODE = T.let(T.unsafe(nil), ActionDispatch::Journey::Nodes::Dummy)

# source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#10
class ActionDispatch::Journey::GTG::MatchData
  # @return [MatchData] a new instance of MatchData
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#13
  def initialize(memos); end

  # Returns the value of attribute memos.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#11
  def memos; end
end

# source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#18
class ActionDispatch::Journey::GTG::Simulator
  # @return [Simulator] a new instance of Simulator
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#23
  def initialize(transition_table); end

  # source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#27
  def memos(string); end

  # Returns the value of attribute tt.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#21
  def tt; end
end

# source://actionpack//lib/action_dispatch/journey/gtg/simulator.rb#19
ActionDispatch::Journey::GTG::Simulator::INITIAL_STATE = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#10
class ActionDispatch::Journey::GTG::TransitionTable
  include ::ActionDispatch::Journey::NFA::Dot

  # @return [TransitionTable] a new instance of TransitionTable
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#18
  def initialize; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#165
  def []=(from, to, sym); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#34
  def accepting?(state); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#30
  def accepting_states; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#26
  def add_accepting(state); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#38
  def add_memo(idx, memo); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#100
  def as_json(options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#46
  def eclosure(t); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#42
  def memo(idx); end

  # Returns the value of attribute memos.
  #
  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#13
  def memos; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#50
  def move(t, full_string, start_index, end_index); end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#182
  def states; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#117
  def to_svg; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#189
  def transitions; end

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#127
  def visualizer(paths, title = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#200
  def states_hash_for(sym); end
end

# source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#15
ActionDispatch::Journey::GTG::TransitionTable::DEFAULT_EXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/gtg/transition_table.rb#16
ActionDispatch::Journey::GTG::TransitionTable::DEFAULT_EXP_ANCHORED = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/nfa/dot.rb#7
module ActionDispatch::Journey::NFA; end

# source://actionpack//lib/action_dispatch/journey/nfa/dot.rb#8
module ActionDispatch::Journey::NFA::Dot
  # source://actionpack//lib/action_dispatch/journey/nfa/dot.rb#9
  def to_dot; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#68
module ActionDispatch::Journey::Nodes; end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#181
class ActionDispatch::Journey::Nodes::Binary < ::ActionDispatch::Journey::Nodes::Node
  # @return [Binary] a new instance of Binary
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#184
  def initialize(left, right); end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#189
  def children; end

  # Returns the value of attribute right.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#182
  def right; end

  # Sets the attribute right
  #
  # @param value the value to set the attribute right to.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#182
  def right=(_arg0); end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#192
class ActionDispatch::Journey::Nodes::Cat < ::ActionDispatch::Journey::Nodes::Binary
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#193
  def cat?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#194
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#133
class ActionDispatch::Journey::Nodes::Dot < ::ActionDispatch::Journey::Nodes::Terminal
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#134
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#121
class ActionDispatch::Journey::Nodes::Dummy < ::ActionDispatch::Journey::Nodes::Literal
  # @return [Dummy] a new instance of Dummy
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#122
  def initialize(x = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#126
  def literal?; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#158
class ActionDispatch::Journey::Nodes::Group < ::ActionDispatch::Journey::Nodes::Unary
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#160
  def group?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#159
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#116
class ActionDispatch::Journey::Nodes::Literal < ::ActionDispatch::Journey::Nodes::Terminal
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#117
  def literal?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#118
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#69
class ActionDispatch::Journey::Nodes::Node
  include ::Enumerable

  # @return [Node] a new instance of Node
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#74
  def initialize(left); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#107
  def cat?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#79
  def each(&block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#108
  def group?; end

  # Returns the value of attribute left.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#72
  def left; end

  # Sets the attribute left
  #
  # @param value the value to set the attribute left to.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#72
  def left=(_arg0); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#104
  def literal?; end

  # Returns the value of attribute memo.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#72
  def memo; end

  # Sets the attribute memo
  #
  # @param value the value to set the attribute memo to.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#72
  def memo=(_arg0); end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#95
  def name; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#106
  def star?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#103
  def symbol?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#105
  def terminal?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#87
  def to_dot; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#83
  def to_s; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#91
  def to_sym; end

  # @raise [NotImplementedError]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#99
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#197
class ActionDispatch::Journey::Nodes::Or < ::ActionDispatch::Journey::Nodes::Node
  # @return [Or] a new instance of Or
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#200
  def initialize(children); end

  # Returns the value of attribute children.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#198
  def children; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#204
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#129
class ActionDispatch::Journey::Nodes::Slash < ::ActionDispatch::Journey::Nodes::Terminal
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#130
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#163
class ActionDispatch::Journey::Nodes::Star < ::ActionDispatch::Journey::Nodes::Unary
  # @return [Star] a new instance of Star
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#166
  def initialize(left); end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#176
  def name; end

  # Returns the value of attribute regexp.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#164
  def regexp; end

  # Sets the attribute regexp
  #
  # @param value the value to set the attribute regexp to.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#164
  def regexp=(_arg0); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#173
  def star?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#174
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#137
class ActionDispatch::Journey::Nodes::Symbol < ::ActionDispatch::Journey::Nodes::Terminal
  # @return [Symbol] a new instance of Symbol
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#144
  def initialize(left, regexp = T.unsafe(nil)); end

  # Returns the value of attribute name.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#140
  def name; end

  # Returns the value of attribute regexp.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#138
  def regexp; end

  # Sets the attribute regexp
  #
  # @param value the value to set the attribute regexp to.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#138
  def regexp=(_arg0); end

  # Returns the value of attribute regexp.
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#138
  def symbol; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#151
  def symbol?; end

  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#150
  def type; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#142
ActionDispatch::Journey::Nodes::Symbol::DEFAULT_EXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#143
ActionDispatch::Journey::Nodes::Symbol::GREEDY_EXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#111
class ActionDispatch::Journey::Nodes::Terminal < ::ActionDispatch::Journey::Nodes::Node
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#72
  def symbol; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#113
  def terminal?; end
end

# source://actionpack//lib/action_dispatch/journey/nodes/node.rb#154
class ActionDispatch::Journey::Nodes::Unary < ::ActionDispatch::Journey::Nodes::Node
  # source://actionpack//lib/action_dispatch/journey/nodes/node.rb#155
  def children; end
end

# source://actionpack//lib/action_dispatch/journey/parser_extras.rb#11
class ActionDispatch::Journey::Parser < ::Racc::Parser
  include ::ActionDispatch::Journey::Nodes

  # @return [Parser] a new instance of Parser
  #
  # source://actionpack//lib/action_dispatch/journey/parser_extras.rb#18
  def initialize; end

  # reduce 0 omitted
  #
  # source://actionpack//lib/action_dispatch/journey/parser.rb#138
  def _reduce_1(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#166
  def _reduce_10(val, _values); end

  # reduce 14 omitted
  #
  # source://actionpack//lib/action_dispatch/journey/parser.rb#178
  def _reduce_15(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#182
  def _reduce_16(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#186
  def _reduce_17(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#190
  def _reduce_18(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#142
  def _reduce_2(val, _values); end

  # reduce 6 omitted
  #
  # source://actionpack//lib/action_dispatch/journey/parser.rb#154
  def _reduce_7(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#158
  def _reduce_8(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#162
  def _reduce_9(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser.rb#194
  def _reduce_none(val, _values); end

  # source://actionpack//lib/action_dispatch/journey/parser_extras.rb#27
  def next_token; end

  # source://actionpack//lib/action_dispatch/journey/parser_extras.rb#22
  def parse(string); end

  class << self
    # source://actionpack//lib/action_dispatch/journey/parser_extras.rb#14
    def parse(string); end
  end
end

# source://actionpack//lib/action_dispatch/journey/parser.rb#93
ActionDispatch::Journey::Parser::Racc_arg = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/journey/parser.rb#132
ActionDispatch::Journey::Parser::Racc_debug_parser = T.let(T.unsafe(nil), FalseClass)

# source://actionpack//lib/action_dispatch/journey/parser.rb#109
ActionDispatch::Journey::Parser::Racc_token_to_s_table = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/journey/path/pattern.rb#7
module ActionDispatch::Journey::Path; end

# source://actionpack//lib/action_dispatch/journey/path/pattern.rb#8
class ActionDispatch::Journey::Path::Pattern
  # @return [Pattern] a new instance of Pattern
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#11
  def initialize(ast, requirements, separators, anchored); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#159
  def =~(other); end

  # Returns the value of attribute anchored.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#9
  def anchored; end

  # Returns the value of attribute ast.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#9
  def ast; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#25
  def build_formatter; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#29
  def eager_load!; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#159
  def match(other); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#165
  def match?(other); end

  # Returns the value of attribute names.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#9
  def names; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#62
  def optional_names; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#58
  def required_names; end

  # Returns the value of attribute requirements.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#9
  def requirements; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#36
  def requirements_anchored?; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#177
  def requirements_for_missing_keys_check; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#169
  def source; end

  # Returns the value of attribute spec.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#9
  def spec; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#173
  def to_regexp; end

  private

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#188
  def offsets; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#184
  def regexp_visitor; end
end

# source://actionpack//lib/action_dispatch/journey/path/pattern.rb#68
class ActionDispatch::Journey::Path::Pattern::AnchoredRegexp < ::ActionDispatch::Journey::Visitors::Visitor
  # @return [AnchoredRegexp] a new instance of AnchoredRegexp
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#69
  def initialize(separator, matchers); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#76
  def accept(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#80
  def visit_CAT(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#97
  def visit_DOT(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#93
  def visit_GROUP(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#97
  def visit_LITERAL(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#111
  def visit_OR(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#102
  def visit_SLASH(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#106
  def visit_STAR(node); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#84
  def visit_SYMBOL(node); end
end

# source://actionpack//lib/action_dispatch/journey/path/pattern.rb#124
class ActionDispatch::Journey::Path::Pattern::MatchData
  # @return [MatchData] a new instance of MatchData
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#127
  def initialize(names, offsets, match); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#141
  def [](x); end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#133
  def captures; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#146
  def length; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#137
  def named_captures; end

  # Returns the value of attribute names.
  #
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#125
  def names; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#150
  def post_match; end

  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#154
  def to_s; end
end

# source://actionpack//lib/action_dispatch/journey/path/pattern.rb#117
class ActionDispatch::Journey::Path::Pattern::UnanchoredRegexp < ::ActionDispatch::Journey::Path::Pattern::AnchoredRegexp
  # source://actionpack//lib/action_dispatch/journey/path/pattern.rb#118
  def accept(node); end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#8
class ActionDispatch::Journey::Route
  # +path+ is a path constraint.
  # `constraints` is a hash of constraints to be applied to this route.
  #
  # @return [Route] a new instance of Route
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#58
  def initialize(name:, path:, app: T.unsafe(nil), constraints: T.unsafe(nil), required_defaults: T.unsafe(nil), defaults: T.unsafe(nil), request_method_match: T.unsafe(nil), precedence: T.unsafe(nil), scope_options: T.unsafe(nil), internal: T.unsafe(nil), source_location: T.unsafe(nil)); end

  # Returns the value of attribute app.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def app; end

  # Returns the value of attribute ast.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def ast; end

  # Returns the value of attribute constraints.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def conditions; end

  # Returns the value of attribute constraints.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def constraints; end

  # Returns the value of attribute defaults.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def defaults; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#144
  def dispatcher?; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#80
  def eager_load!; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#122
  def format(path_options); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#140
  def glob?; end

  # Returns the value of attribute internal.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def internal; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#166
  def ip; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#148
  def matches?(request); end

  # Returns the value of attribute name.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def name; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#117
  def parts; end

  # Returns the value of attribute path.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def path; end

  # Returns the value of attribute precedence.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def precedence; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#130
  def required_default?(key); end

  # source://actionpack//lib/action_dispatch/journey/route.rb#134
  def required_defaults; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#105
  def required_keys; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#126
  def required_parts; end

  # Needed for `bin/rails routes`. Picks up succinctly defined requirements for a
  # route, for example route
  #
  #     get 'photo/:id', :controller => 'photos', :action => 'show',
  #       :id => /[A-Z]\d{5}/
  #
  # will have {:controller=>"photos", :action=>"show", :[id=>/](A-Z){5}/} as
  # requirements.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#95
  def requirements; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#170
  def requires_matching_verb?; end

  # Returns the value of attribute scope_options.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def scope_options; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#109
  def score(supplied_keys); end

  # source://actionpack//lib/action_dispatch/journey/route.rb#117
  def segment_keys; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#101
  def segments; end

  # Returns the value of attribute source_location.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#9
  def source_location; end

  # source://actionpack//lib/action_dispatch/journey/route.rb#174
  def verb; end

  private

  # source://actionpack//lib/action_dispatch/journey/route.rb#183
  def match_verb(request); end

  # source://actionpack//lib/action_dispatch/journey/route.rb#179
  def verbs; end

  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#49
    def verb_matcher(verb); end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#14
module ActionDispatch::Journey::Route::VerbMatchers; end

# source://actionpack//lib/action_dispatch/journey/route.rb#36
class ActionDispatch::Journey::Route::VerbMatchers::All
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#37
    def call(_); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#38
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::DELETE
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::GET
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::HEAD
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::LINK
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::OPTIONS
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::PATCH
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::POST
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::PUT
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::TRACE
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#19
class ActionDispatch::Journey::Route::VerbMatchers::UNLINK
  class << self
    # source://actionpack//lib/action_dispatch/journey/route.rb#21
    def call(req); end

    # source://actionpack//lib/action_dispatch/journey/route.rb#20
    def verb; end
  end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#26
class ActionDispatch::Journey::Route::VerbMatchers::Unknown
  # @return [Unknown] a new instance of Unknown
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#29
  def initialize(verb); end

  # source://actionpack//lib/action_dispatch/journey/route.rb#33
  def call(request); end

  # Returns the value of attribute verb.
  #
  # source://actionpack//lib/action_dispatch/journey/route.rb#27
  def verb; end
end

# source://actionpack//lib/action_dispatch/journey/route.rb#15
ActionDispatch::Journey::Route::VerbMatchers::VERBS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/journey/route.rb#41
ActionDispatch::Journey::Route::VerbMatchers::VERB_TO_CLASS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#7
class ActionDispatch::Journey::Router
  # @return [Router] a new instance of Router
  #
  # source://actionpack//lib/action_dispatch/journey/router.rb#22
  def initialize(routes); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#26
  def eager_load!; end

  # source://actionpack//lib/action_dispatch/journey/router.rb#68
  def recognize(rails_req); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/journey/router.rb#20
  def routes; end

  # Sets the attribute routes
  #
  # @param value the value to set the attribute routes to.
  #
  # source://actionpack//lib/action_dispatch/journey/router.rb#20
  def routes=(_arg0); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#33
  def serve(req); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#81
  def visualizer; end

  private

  # source://actionpack//lib/action_dispatch/journey/router.rb#95
  def ast; end

  # source://actionpack//lib/action_dispatch/journey/router.rb#103
  def custom_routes; end

  # source://actionpack//lib/action_dispatch/journey/router.rb#107
  def filter_routes(path); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#112
  def find_routes(req); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#137
  def match_head_routes(routes, req); end

  # source://actionpack//lib/action_dispatch/journey/router.rb#89
  def partitioned_routes; end

  # source://actionpack//lib/action_dispatch/journey/router.rb#99
  def simulator; end
end

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#8
class ActionDispatch::Journey::Router::Utils
  class << self
    # source://actionpack//lib/action_dispatch/journey/router/utils.rb#91
    def escape_fragment(fragment); end

    # source://actionpack//lib/action_dispatch/journey/router/utils.rb#83
    def escape_path(path); end

    # source://actionpack//lib/action_dispatch/journey/router/utils.rb#87
    def escape_segment(segment); end

    # Normalizes URI path.
    #
    # Strips off trailing slash and ensures there is a leading slash. Also converts
    # downcase URL encoded string to uppercase.
    #
    #     normalize_path("/foo")  # => "/foo"
    #     normalize_path("/foo/") # => "/foo"
    #     normalize_path("foo")   # => "/foo"
    #     normalize_path("")      # => "/"
    #     normalize_path("/%ab")  # => "/%AB"
    #
    # source://actionpack//lib/action_dispatch/journey/router/utils.rb#19
    def normalize_path(path); end

    # Replaces any escaped sequences with their unescaped representations.
    #
    #     uri = "/topics?title=Ruby%20on%20Rails"
    #     unescape_uri(uri)  #=> "/topics?title=Ruby on Rails"
    #
    # source://actionpack//lib/action_dispatch/journey/router/utils.rb#99
    def unescape_uri(uri); end
  end
end

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#81
ActionDispatch::Journey::Router::Utils::ENCODER = T.let(T.unsafe(nil), ActionDispatch::Journey::Router::Utils::UriEncoder)

# URI path and fragment escaping https://tools.ietf.org/html/rfc3986
#
# source://actionpack//lib/action_dispatch/journey/router/utils.rb#34
class ActionDispatch::Journey::Router::Utils::UriEncoder
  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#52
  def escape_fragment(fragment); end

  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#56
  def escape_path(path); end

  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#60
  def escape_segment(segment); end

  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#64
  def unescape_uri(uri); end

  private

  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#70
  def escape(component, pattern); end

  # source://actionpack//lib/action_dispatch/journey/router/utils.rb#74
  def percent_encode(unsafe); end
end

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#41
ActionDispatch::Journey::Router::Utils::UriEncoder::ALPHA = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#39
ActionDispatch::Journey::Router::Utils::UriEncoder::DEC2HEX = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#42
ActionDispatch::Journey::Router::Utils::UriEncoder::DIGIT = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#38
ActionDispatch::Journey::Router::Utils::UriEncoder::EMPTY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#35
ActionDispatch::Journey::Router::Utils::UriEncoder::ENCODE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#46
ActionDispatch::Journey::Router::Utils::UriEncoder::ESCAPED = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#48
ActionDispatch::Journey::Router::Utils::UriEncoder::FRAGMENT = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#50
ActionDispatch::Journey::Router::Utils::UriEncoder::PATH = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#49
ActionDispatch::Journey::Router::Utils::UriEncoder::SEGMENT = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#44
ActionDispatch::Journey::Router::Utils::UriEncoder::SUB_DELIMS = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#43
ActionDispatch::Journey::Router::Utils::UriEncoder::UNRESERVED = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#36
ActionDispatch::Journey::Router::Utils::UriEncoder::US_ASCII = T.let(T.unsafe(nil), Encoding)

# source://actionpack//lib/action_dispatch/journey/router/utils.rb#37
ActionDispatch::Journey::Router::Utils::UriEncoder::UTF_8 = T.let(T.unsafe(nil), Encoding)

# The Routing table. Contains all routes for a system. Routes can be added to
# the table by calling Routes#add_route.
#
# source://actionpack//lib/action_dispatch/journey/routes.rb#9
class ActionDispatch::Journey::Routes
  include ::Enumerable

  # @return [Routes] a new instance of Routes
  #
  # source://actionpack//lib/action_dispatch/journey/routes.rb#14
  def initialize(routes = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#67
  def add_route(name, mapping); end

  # Returns the value of attribute anchored_routes.
  #
  # source://actionpack//lib/action_dispatch/journey/routes.rb#12
  def anchored_routes; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#53
  def ast; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#39
  def clear; end

  # Returns the value of attribute custom_routes.
  #
  # source://actionpack//lib/action_dispatch/journey/routes.rb#12
  def custom_routes; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#35
  def each(&block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/routes.rb#22
  def empty?; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#31
  def last; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#26
  def length; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#45
  def partition_route(route); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/journey/routes.rb#12
  def routes; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#60
  def simulator; end

  # source://actionpack//lib/action_dispatch/journey/routes.rb#26
  def size; end

  private

  # source://actionpack//lib/action_dispatch/journey/routes.rb#76
  def clear_cache!; end
end

# source://actionpack//lib/action_dispatch/journey/scanner.rb#9
class ActionDispatch::Journey::Scanner
  # @return [Scanner] a new instance of Scanner
  #
  # source://actionpack//lib/action_dispatch/journey/scanner.rb#10
  def initialize; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/journey/scanner.rb#18
  def eos?; end

  # source://actionpack//lib/action_dispatch/journey/scanner.rb#30
  def next_token; end

  # source://actionpack//lib/action_dispatch/journey/scanner.rb#22
  def pos; end

  # source://actionpack//lib/action_dispatch/journey/scanner.rb#26
  def pre_match; end

  # source://actionpack//lib/action_dispatch/journey/scanner.rb#14
  def scan_setup(str); end

  private

  # takes advantage of String @- deduping capabilities in Ruby 2.5 upwards see:
  # https://bugs.ruby-lang.org/issues/13077
  #
  # source://actionpack//lib/action_dispatch/journey/scanner.rb#40
  def dedup_scan(regex); end

  # source://actionpack//lib/action_dispatch/journey/scanner.rb#45
  def scan; end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#55
module ActionDispatch::Journey::Visitors; end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#196
class ActionDispatch::Journey::Visitors::Dot < ::ActionDispatch::Journey::Visitors::FunctionalVisitor
  # @return [Dot] a new instance of Dot
  #
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#197
  def initialize; end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#202
  def accept(node, seed = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#217
  def binary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#224
  def nary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#256
  def terminal(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#231
  def unary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#241
  def visit_CAT(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#236
  def visit_GROUP(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#251
  def visit_OR(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#246
  def visit_STAR(node, seed); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#262
ActionDispatch::Journey::Visitors::Dot::INSTANCE = T.let(T.unsafe(nil), ActionDispatch::Journey::Visitors::Dot)

# Loop through the requirements AST.
#
# source://actionpack//lib/action_dispatch/journey/visitors.rb#161
class ActionDispatch::Journey::Visitors::Each < ::ActionDispatch::Journey::Visitors::FunctionalVisitor
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#162
  def visit(node, block); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#167
ActionDispatch::Journey::Visitors::Each::INSTANCE = T.let(T.unsafe(nil), ActionDispatch::Journey::Visitors::Each)

# source://actionpack//lib/action_dispatch/journey/visitors.rb#136
class ActionDispatch::Journey::Visitors::FormatBuilder < ::ActionDispatch::Journey::Visitors::Visitor
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#137
  def accept(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#140
  def binary(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#138
  def terminal(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#144
  def visit_GROUP(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#146
  def visit_STAR(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#150
  def visit_SYMBOL(n); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#97
class ActionDispatch::Journey::Visitors::FunctionalVisitor
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#100
  def accept(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#108
  def binary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#113
  def nary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#124
  def terminal(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#118
  def unary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#104
  def visit(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#111
  def visit_CAT(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#128
  def visit_DOT(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#121
  def visit_GROUP(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#125
  def visit_LITERAL(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#116
  def visit_OR(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#127
  def visit_SLASH(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#122
  def visit_STAR(n, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#126
  def visit_SYMBOL(n, seed); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#98
ActionDispatch::Journey::Visitors::FunctionalVisitor::DISPATCH_CACHE = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/journey/visitors.rb#170
class ActionDispatch::Journey::Visitors::String < ::ActionDispatch::Journey::Visitors::FunctionalVisitor
  private

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#172
  def binary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#176
  def nary(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#185
  def terminal(node, seed); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#189
  def visit_GROUP(node, seed); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#193
ActionDispatch::Journey::Visitors::String::INSTANCE = T.let(T.unsafe(nil), ActionDispatch::Journey::Visitors::String)

# source://actionpack//lib/action_dispatch/journey/visitors.rb#56
class ActionDispatch::Journey::Visitors::Visitor
  # source://actionpack//lib/action_dispatch/journey/visitors.rb#59
  def accept(node); end

  private

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#68
  def binary(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#74
  def nary(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#85
  def terminal(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#79
  def unary(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#64
  def visit(node); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#72
  def visit_CAT(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#89
  def visit_DOT(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#82
  def visit_GROUP(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#86
  def visit_LITERAL(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#77
  def visit_OR(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#88
  def visit_SLASH(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#83
  def visit_STAR(n); end

  # source://actionpack//lib/action_dispatch/journey/visitors.rb#87
  def visit_SYMBOL(n); end
end

# source://actionpack//lib/action_dispatch/journey/visitors.rb#57
ActionDispatch::Journey::Visitors::Visitor::DISPATCH_CACHE = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/log_subscriber.rb#6
class ActionDispatch::LogSubscriber < ::ActiveSupport::LogSubscriber
  # source://actionpack//lib/action_dispatch/log_subscriber.rb#7
  def redirect(event); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/log_subscriber.rb#84
    def log_levels; end
  end
end

# # Action Dispatch MiddlewareStack
#
# Read more about [Rails middleware
# stack](https://guides.rubyonrails.org/rails_on_rack.html#action-dispatcher-middleware-stack)
# in the guides.
#
# source://actionpack//lib/action_dispatch/middleware/stack.rb#14
class ActionDispatch::MiddlewareStack
  include ::Enumerable

  # @return [MiddlewareStack] a new instance of MiddlewareStack
  # @yield [_self]
  # @yieldparam _self [ActionDispatch::MiddlewareStack] the object that the method was called on
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#76
  def initialize(*args); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#93
  def [](i); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#166
  def build(app = T.unsafe(nil), &block); end

  # Deletes a middleware from the middleware stack.
  #
  # Returns the array of middlewares not including the deleted item, or returns
  # nil if the target is not found.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#131
  def delete(target); end

  # Deletes a middleware from the middleware stack.
  #
  # Returns the array of middlewares not including the deleted item, or raises
  # `RuntimeError` if the target is not found.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#139
  def delete!(target); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#81
  def each(&block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#106
  def insert(index, klass, *args, **_arg3, &block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#114
  def insert_after(index, *args, **_arg2, &block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#106
  def insert_before(index, klass, *args, **_arg3, &block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#89
  def last; end

  # Returns the value of attribute middlewares.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#74
  def middlewares; end

  # Sets the attribute middlewares
  #
  # @param value the value to set the attribute middlewares to.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#74
  def middlewares=(_arg0); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#143
  def move(target, source); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#153
  def move_after(target, source); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#143
  def move_before(target, source); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#85
  def size; end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#120
  def swap(target, *args, **_arg2, &block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#97
  def unshift(klass, *args, **_arg2, &block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#161
  def use(klass, *args, **_arg2, &block); end

  private

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#178
  def assert_index(index, where); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#184
  def build_middleware(klass, args, block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#188
  def index_of(klass); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#102
  def initialize_copy(other); end
end

# This class is used to instrument the execution of a single middleware. It
# proxies the `call` method transparently and instruments the method call.
#
# source://actionpack//lib/action_dispatch/middleware/stack.rb#54
class ActionDispatch::MiddlewareStack::InstrumentationProxy
  # @return [InstrumentationProxy] a new instance of InstrumentationProxy
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#57
  def initialize(middleware, class_name); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#65
  def call(env); end
end

# source://actionpack//lib/action_dispatch/middleware/stack.rb#55
ActionDispatch::MiddlewareStack::InstrumentationProxy::EVENT_NAME = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/middleware/stack.rb#15
class ActionDispatch::MiddlewareStack::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#18
  def initialize(klass, args, block); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#26
  def ==(middleware); end

  # Returns the value of attribute args.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#16
  def args; end

  # Returns the value of attribute block.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#16
  def block; end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#43
  def build(app); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#47
  def build_instrumented(app); end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#35
  def inspect; end

  # Returns the value of attribute klass.
  #
  # source://actionpack//lib/action_dispatch/middleware/stack.rb#16
  def klass; end

  # source://actionpack//lib/action_dispatch/middleware/stack.rb#24
  def name; end
end

# source://actionpack//lib/action_dispatch.rb#50
class ActionDispatch::MissingController < ::NameError; end

# # Action Dispatch PermissionsPolicy
#
# Configures the HTTP
# [Feature-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Feature-Policy)
# response header to specify which browser features the current
# document and its iframes can use.
#
# Example global policy:
#
#     Rails.application.config.permissions_policy do |policy|
#       policy.camera      :none
#       policy.gyroscope   :none
#       policy.microphone  :none
#       policy.usb         :none
#       policy.fullscreen  :self
#       policy.payment     :self, "https://secure.example.com"
#     end
#
# The Feature-Policy header has been renamed to Permissions-Policy. The
# Permissions-Policy requires a different implementation and isn't yet supported
# by all browsers. To avoid having to rename this middleware in the future we
# use the new name for the middleware but keep the old header name and
# implementation for now.
#
# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#31
class ActionDispatch::PermissionsPolicy
  # @return [PermissionsPolicy] a new instance of PermissionsPolicy
  # @yield [_self]
  # @yieldparam _self [ActionDispatch::PermissionsPolicy] the object that the method was called on
  #
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#111
  def initialize; end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def accelerometer(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def ambient_light_sensor(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def autoplay(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#130
  def build(context = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def camera(*sources); end

  # Returns the value of attribute directives.
  #
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#109
  def directives; end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def encrypted_media(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def fullscreen(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def geolocation(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def gyroscope(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def hid(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def idle_detection(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def magnetometer(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def microphone(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def midi(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def payment(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def picture_in_picture(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def screen_wake_lock(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def serial(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def sync_xhr(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def usb(*sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#121
  def web_share(*sources); end

  private

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#148
  def apply_mapping(source); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#135
  def apply_mappings(sources); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#166
  def build_directive(sources, context); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#154
  def build_directives(context); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#116
  def initialize_copy(other); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#170
  def resolve_source(source, context); end
end

# List of available permissions can be found at
# https://github.com/w3c/webappsec-permissions-policy/blob/main/features.md#policy-controlled-features
#
# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#84
ActionDispatch::PermissionsPolicy::DIRECTIVES = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#77
ActionDispatch::PermissionsPolicy::MAPPINGS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#32
class ActionDispatch::PermissionsPolicy::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#33
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#37
  def call(env); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#60
  def policy_empty?(policy); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#56
  def policy_present?(headers); end
end

# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#65
module ActionDispatch::PermissionsPolicy::Request
  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#68
  def permissions_policy; end

  # source://actionpack//lib/action_dispatch/http/permissions_policy.rb#72
  def permissions_policy=(policy); end
end

# source://actionpack//lib/action_dispatch/http/permissions_policy.rb#66
ActionDispatch::PermissionsPolicy::Request::POLICY = T.let(T.unsafe(nil), String)

# # Action Dispatch PublicExceptions
#
# When called, this middleware renders an error page. By default if an HTML
# response is expected it will render static error pages from the `/public`
# directory. For example when this middleware receives a 500 response it will
# render the template found in `/public/500.html`. If an internationalized
# locale is set, this middleware will attempt to render the template in
# `/public/500.<locale>.html`. If an internationalized template is not found it
# will fall back on `/public/500.html`.
#
# When a request with a content type other than HTML is made, this middleware
# will attempt to convert error information into the appropriate response type.
#
# source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#18
class ActionDispatch::PublicExceptions
  # @return [PublicExceptions] a new instance of PublicExceptions
  #
  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#21
  def initialize(public_path); end

  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#25
  def call(env); end

  # Returns the value of attribute public_path.
  #
  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#19
  def public_path; end

  # Sets the attribute public_path
  #
  # @param value the value to set the attribute public_path to.
  #
  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#19
  def public_path=(_arg0); end

  private

  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#39
  def render(status, content_type, body); end

  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#48
  def render_format(status, content_type, body); end

  # source://actionpack//lib/action_dispatch/middleware/public_exceptions.rb#53
  def render_html(status); end
end

# source://actionpack//lib/action_dispatch/railtie.rb#10
class ActionDispatch::Railtie < ::Rails::Railtie; end

# # Action Dispatch Reloader
#
# ActionDispatch::Reloader wraps the request with callbacks provided by
# ActiveSupport::Reloader, intended to assist with code reloading during
# development.
#
# ActionDispatch::Reloader is included in the middleware stack only if reloading
# is enabled, which it is by the default in `development` mode.
#
# source://actionpack//lib/action_dispatch/middleware/reloader.rb#14
class ActionDispatch::Reloader < ::ActionDispatch::Executor; end

# # Action Dispatch RemoteIp
#
# This middleware calculates the IP address of the remote client that is making
# the request. It does this by checking various headers that could contain the
# address, and then picking the last-set address that is not on the list of
# trusted IPs. This follows the precedent set by e.g. [the Tomcat
# server](https://issues.apache.org/bugzilla/show_bug.cgi?id=50453). A more
# detailed explanation of the algorithm is given at GetIp#calculate_ip.
#
# Some Rack servers concatenate repeated headers, like [HTTP RFC
# 2616](https://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2) requires.
# Some Rack servers simply drop preceding headers, and only report the value
# that was [given in the last
# header](https://andre.arko.net/2011/12/26/repeated-headers-and-ruby-web-server
# s). If you are behind multiple proxy servers (like NGINX to HAProxy to
# Unicorn) then you should test your Rack server to make sure your data is good.
#
# IF YOU DON'T USE A PROXY, THIS MAKES YOU VULNERABLE TO IP SPOOFING. This
# middleware assumes that there is at least one proxy sitting around and setting
# headers with the client's remote IP address. If you don't use a proxy, because
# you are hosted on e.g. Heroku without SSL, any client can claim to have any IP
# address by setting the `X-Forwarded-For` header. If you care about that, then
# you need to explicitly drop or ignore those headers sometime before this
# middleware runs. Alternatively, remove this middleware to avoid inadvertently
# relying on it.
#
# source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#33
class ActionDispatch::RemoteIp
  # Create a new `RemoteIp` middleware instance.
  #
  # The `ip_spoofing_check` option is on by default. When on, an exception is
  # raised if it looks like the client is trying to lie about its own IP address.
  # It makes sense to turn off this check on sites aimed at non-IP clients (like
  # WAP devices), or behind proxies that set headers in an incorrect or confusing
  # way (like AWS ELB).
  #
  # The `custom_proxies` argument can take an enumerable which will be used
  # instead of `TRUSTED_PROXIES`. Any proxy setup will put the value you want in
  # the middle (or at the beginning) of the `X-Forwarded-For` list, with your
  # proxy servers after it. If your proxies aren't removed, pass them in via the
  # `custom_proxies` parameter. That way, the middleware will ignore those IP
  # addresses, and return the one that you want.
  #
  # @return [RemoteIp] a new instance of RemoteIp
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#65
  def initialize(app, ip_spoofing_check = T.unsafe(nil), custom_proxies = T.unsafe(nil)); end

  # Since the IP address may not be needed, we store the object here without
  # calculating the IP to keep from slowing down the majority of requests. For
  # those requests that do need to know the IP, the GetIp#calculate_ip method will
  # calculate the memoized client IP address.
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#93
  def call(env); end

  # Returns the value of attribute check_ip.
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#49
  def check_ip; end

  # Returns the value of attribute proxies.
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#49
  def proxies; end
end

# The GetIp class exists as a way to defer processing of the request data into
# an actual IP address. If the ActionDispatch::Request#remote_ip method is
# called, this class will calculate the value and then memoize it.
#
# source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#102
class ActionDispatch::RemoteIp::GetIp
  # @return [GetIp] a new instance of GetIp
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#103
  def initialize(req, check_ip, proxies); end

  # Sort through the various IP address headers, looking for the IP most likely to
  # be the address of the actual remote client making this request.
  #
  # REMOTE_ADDR will be correct if the request is made directly against the Ruby
  # process, on e.g. Heroku. When the request is proxied by another server like
  # HAProxy or NGINX, the IP address that made the original request will be put in
  # an `X-Forwarded-For` header. If there are multiple proxies, that header may
  # contain a list of IPs. Other proxy services set the `Client-Ip` header
  # instead, so we check that too.
  #
  # As discussed in [this post about Rails IP
  # Spoofing](https://web.archive.org/web/20170626095448/https://blog.gingerlime.c
  # om/2012/rails-ip-spoofing-vulnerabilities-and-protection/), while the first IP
  # in the list is likely to be the "originating" IP, it could also have been set
  # by the client maliciously.
  #
  # In order to find the first address that is (probably) accurate, we take the
  # list of IPs, remove known and trusted proxies, and then take the last address
  # left, which was presumably set by one of those proxies.
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#128
  def calculate_ip; end

  # Memoizes the value returned by #calculate_ip and returns it for
  # ActionDispatch::Request to use.
  #
  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#172
  def to_s; end

  private

  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#192
  def filter_proxies(ips); end

  # source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#177
  def ips_from(header); end
end

# source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#34
class ActionDispatch::RemoteIp::IpSpoofAttackError < ::StandardError; end

# The default trusted IPs list simply includes IP addresses that are guaranteed
# by the IP specification to be private addresses. Those will not be the
# ultimate client IP in production, and so are discarded. See
# https://en.wikipedia.org/wiki/Private_network for details.
#
# source://actionpack//lib/action_dispatch/middleware/remote_ip.rb#40
ActionDispatch::RemoteIp::TRUSTED_PROXIES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/request.rb#20
class ActionDispatch::Request
  include ::ActionDispatch::Flash::RequestMethods
  include ::Rack::Request::Helpers
  include ::ActionDispatch::Http::Cache::Request
  include ::ActionDispatch::Http::MimeNegotiation
  include ::ActionDispatch::Http::Parameters
  include ::ActionDispatch::Http::FilterParameters
  include ::ActionDispatch::Http::URL
  include ::ActionDispatch::ContentSecurityPolicy::Request
  include ::ActionDispatch::PermissionsPolicy::Request
  include ::Rack::Request::Env
  include ::ActionDispatch::RequestCookieMethods
  extend ::ActionDispatch::Http::Parameters::ClassMethods

  # @return [Request] a new instance of Request
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#62
  def initialize(env); end

  # Override Rack's GET method to support indifferent access.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#387
  def GET; end

  # Override Rack's POST method to support indifferent access.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#403
  def POST; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def accept; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def accept_charset; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def accept_encoding; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def accept_language; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def auth_type; end

  # Returns the authorization header regardless of whether it was specified
  # directly or through one of the proxy alternatives.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#419
  def authorization; end

  # The request body is an IO input stream. If the RAW_POST_DATA environment
  # variable is already set, wrap it in a StringIO.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#349
  def body; end

  # source://actionpack//lib/action_dispatch/http/request.rb#369
  def body_stream; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def cache_control; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def client_ip; end

  # source://actionpack//lib/action_dispatch/http/request.rb#72
  def commit_cookie_jar!; end

  # source://actionpack//lib/action_dispatch/http/request.rb#451
  def commit_csrf_token; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#71
  def commit_flash; end

  # Returns the content length of the request as an integer.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#284
  def content_length; end

  # source://actionpack//lib/action_dispatch/http/request.rb#81
  def controller_class; end

  # source://actionpack//lib/action_dispatch/http/request.rb#87
  def controller_class_for(name); end

  # source://actionpack//lib/action_dispatch/http/request.rb#183
  def controller_instance; end

  # source://actionpack//lib/action_dispatch/http/request.rb#187
  def controller_instance=(controller); end

  # source://actionpack//lib/action_dispatch/http/request.rb#169
  def engine_script_name(_routes); end

  # source://actionpack//lib/action_dispatch/http/request.rb#173
  def engine_script_name=(name); end

  # Determine whether the request body contains form-data by checking the request
  # `Content-Type` for one of the media-types: `application/x-www-form-urlencoded`
  # or `multipart/form-data`. The list of form-data media types can be modified
  # through the `FORM_DATA_MEDIA_TYPES` array.
  #
  # A request body is not assumed to contain form-data when no `Content-Type`
  # header is provided and the request_method is POST.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#365
  def form_data?; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def from; end

  # Returns the `String` full path including params of the last URL requested.
  #
  #     # get "/articles"
  #     request.fullpath # => "/articles"
  #
  #     # get "/articles?page=2"
  #     request.fullpath # => "/articles?page=2"
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#263
  def fullpath; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def gateway_interface; end

  # Provides access to the request's HTTP headers, for example:
  #
  #     request.headers["Content-Type"] # => "text/plain"
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#225
  def headers; end

  # source://actionpack//lib/action_dispatch/http/request.rb#191
  def http_auth_salt; end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#20
  def ignore_accept_header; end

  # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#20
  def ignore_accept_header=(val); end

  # source://actionpack//lib/action_dispatch/http/request.rb#443
  def inspect; end

  # Returns the IP address of client as a `String`.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#298
  def ip; end

  # Returns true if the request has a header matching the given key parameter.
  #
  #     request.key? :ip_spoofing_check # => true
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#108
  def key?(key); end

  # True if the request came from localhost, 127.0.0.1, or ::1.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#427
  def local?; end

  # source://actionpack//lib/action_dispatch/http/request.rb#436
  def logger; end

  # The `String` MIME type of the request.
  #
  #     # get "/articles"
  #     request.media_type # => "application/x-www-form-urlencoded"
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#279
  def media_type; end

  # Returns the original value of the environment's REQUEST_METHOD, even if it was
  # overridden by middleware. See #request_method for more information.
  #
  # For debugging purposes, when called with arguments this method will fall back
  # to Object#method
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#205
  def method(*args, **_arg1); end

  # Returns a symbol form of the #method.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#218
  def method_symbol; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def negotiate; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def origin; end

  # Returns a `String` with the last requested path including their params.
  #
  #     # get '/foo'
  #     request.original_fullpath # => '/foo'
  #
  #     # get '/foo?bar'
  #     request.original_fullpath # => '/foo?bar'
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#252
  def original_fullpath; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def original_script_name; end

  # Returns the original request URL as a `String`.
  #
  #     # get "/articles?page=2"
  #     request.original_url # => "http://www.example.com/articles?page=2"
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#271
  def original_url; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def path_translated; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def pragma; end

  # Override Rack's GET method to support indifferent access.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#387
  def query_parameters; end

  # Read the request body. This is useful for web services that need to work with
  # raw requests directly.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#340
  def raw_post; end

  # source://rack/3.1.7/lib/rack/request.rb#197
  def raw_request_method; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def remote_addr; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def remote_host; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def remote_ident; end

  # Returns the IP address of client as a `String`, usually set by the RemoteIp
  # middleware.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#304
  def remote_ip; end

  # source://actionpack//lib/action_dispatch/http/request.rb#308
  def remote_ip=(remote_ip); end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def remote_user; end

  # Returns the unique request id, which is based on either the `X-Request-Id`
  # header that can be generated by a firewall, load balancer, or web server, or
  # by the RequestId middleware (which sets the `action_dispatch.request_id`
  # environment variable).
  #
  # This unique ID is useful for tracing a request from end-to-end as part of
  # logging or debugging. This relies on the Rack variable set by the
  # ActionDispatch::RequestId middleware.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#323
  def request_id; end

  # source://actionpack//lib/action_dispatch/http/request.rb#327
  def request_id=(id); end

  # Returns the HTTP method that the application should see. In the case where the
  # method was overridden by a middleware (for instance, if a HEAD request was
  # converted to a GET, or if a _method parameter was used to determine the method
  # the application should use), this method returns the overridden value, not the
  # original.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#145
  def request_method; end

  # source://actionpack//lib/action_dispatch/http/request.rb#177
  def request_method=(request_method); end

  # Returns a symbol form of the #request_method.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#196
  def request_method_symbol; end

  # Override Rack's POST method to support indifferent access.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#403
  def request_parameters; end

  # source://actionpack//lib/action_dispatch/http/request.rb#431
  def request_parameters=(params); end

  # source://actionpack//lib/action_dispatch/http/request.rb#447
  def reset_csrf_token; end

  # source://actionpack//lib/action_dispatch/middleware/flash.rb#84
  def reset_session; end

  # Returns the URI pattern of the matched route for the request, using the same
  # format as `bin/rails routes`:
  #
  #     request.route_uri_pattern # => "/:controller(/:action(/:id))(.:format)"
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#153
  def route_uri_pattern; end

  # source://actionpack//lib/action_dispatch/http/request.rb#157
  def route_uri_pattern=(pattern); end

  # source://actionpack//lib/action_dispatch/http/request.rb#161
  def routes; end

  # source://actionpack//lib/action_dispatch/http/request.rb#165
  def routes=(routes); end

  # Early Hints is an HTTP/2 status code that indicates hints to help a client
  # start making preparations for processing the final response.
  #
  # If the env contains `rack.early_hints` then the server accepts HTTP2 push for
  # link headers.
  #
  # The `send_early_hints` method accepts a hash of links as follows:
  #
  #     send_early_hints("link" => "</style.css>; rel=preload; as=style,</script.js>; rel=preload")
  #
  # If you are using `javascript_include_tag` or `stylesheet_link_tag` the Early
  # Hints headers are included by default if supported.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#241
  def send_early_hints(links); end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def server_name; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def server_protocol; end

  # Returns the lowercase name of the HTTP server software.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#334
  def server_software; end

  # source://actionpack//lib/action_dispatch/http/request.rb#378
  def session=(session); end

  # source://actionpack//lib/action_dispatch/http/request.rb#382
  def session_options=(options); end

  # Returns the unique request id, which is based on either the `X-Request-Id`
  # header that can be generated by a firewall, load balancer, or web server, or
  # by the RequestId middleware (which sets the `action_dispatch.request_id`
  # environment variable).
  #
  # This unique ID is useful for tracing a request from end-to-end as part of
  # logging or debugging. This relies on the Rack variable set by the
  # ActionDispatch::RequestId middleware.
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#323
  def uuid; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def version; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def x_csrf_token; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def x_forwarded_for; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def x_forwarded_host; end

  # source://actionpack//lib/action_dispatch/http/request.rb#52
  def x_request_id; end

  # Returns true if the `X-Requested-With` header contains "XMLHttpRequest"
  # (case-insensitive), which may need to be manually added depending on the
  # choice of JavaScript libraries and frameworks.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#292
  def xhr?; end

  # Returns true if the `X-Requested-With` header contains "XMLHttpRequest"
  # (case-insensitive), which may need to be manually added depending on the
  # choice of JavaScript libraries and frameworks.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/request.rb#292
  def xml_http_request?; end

  private

  # source://actionpack//lib/action_dispatch/http/request.rb#456
  def check_method(name); end

  # source://actionpack//lib/action_dispatch/http/request.rb#464
  def default_session; end

  # source://actionpack//lib/action_dispatch/http/request.rb#468
  def read_body_stream; end

  # source://actionpack//lib/action_dispatch/http/request.rb#480
  def reset_stream(body_stream); end

  class << self
    # source://actionpack//lib/action_dispatch/http/request.rb#58
    def empty; end

    # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#20
    def ignore_accept_header; end

    # source://actionpack//lib/action_dispatch/http/mime_negotiation.rb#20
    def ignore_accept_header=(val); end

    # source://actionpack//lib/action_dispatch/http/parameters.rb#30
    def parameter_parsers; end
  end
end

# source://actionpack//lib/action_dispatch/http/request.rb#313
ActionDispatch::Request::ACTION_DISPATCH_REQUEST_ID = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/request.rb#36
ActionDispatch::Request::ENV_METHODS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/request.rb#129
ActionDispatch::Request::HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/request.rb#131
ActionDispatch::Request::HTTP_METHOD_LOOKUP = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/request.rb#34
ActionDispatch::Request::LOCALHOST = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/request.rb#75
class ActionDispatch::Request::PASS_NOT_FOUND
  class << self
    # source://actionpack//lib/action_dispatch/http/request.rb#76
    def action(_); end

    # source://actionpack//lib/action_dispatch/http/request.rb#78
    def action_encoding_template(action); end

    # source://actionpack//lib/action_dispatch/http/request.rb#77
    def call(_); end
  end
end

# HTTP methods from [RFC 2518: HTTP Extensions for Distributed Authoring -- WEBDAV](https://www.ietf.org/rfc/rfc2518.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#115
ActionDispatch::Request::RFC2518 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 2616: Hypertext Transfer Protocol -- HTTP/1.1](https://www.ietf.org/rfc/rfc2616.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#113
ActionDispatch::Request::RFC2616 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 3253: Versioning Extensions to WebDAV](https://www.ietf.org/rfc/rfc3253.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#117
ActionDispatch::Request::RFC3253 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 3648: WebDAV Ordered Collections Protocol](https://www.ietf.org/rfc/rfc3648.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#119
ActionDispatch::Request::RFC3648 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 3744: WebDAV Access Control Protocol](https://www.ietf.org/rfc/rfc3744.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#121
ActionDispatch::Request::RFC3744 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 4791: Calendaring Extensions to WebDAV](https://www.ietf.org/rfc/rfc4791.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#125
ActionDispatch::Request::RFC4791 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 5323: WebDAV SEARCH](https://www.ietf.org/rfc/rfc5323.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#123
ActionDispatch::Request::RFC5323 = T.let(T.unsafe(nil), Array)

# HTTP methods from [RFC 5789: PATCH Method for HTTP](https://www.ietf.org/rfc/rfc5789.txt)
#
# source://actionpack//lib/action_dispatch/http/request.rb#127
ActionDispatch::Request::RFC5789 = T.let(T.unsafe(nil), Array)

# Session is responsible for lazily loading the session from store.
#
# source://actionpack//lib/action_dispatch/request/session.rb#10
class ActionDispatch::Request::Session
  # @return [Session] a new instance of Session
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#76
  def initialize(by, req, enabled: T.unsafe(nil)); end

  # Returns value of the key stored in the session or `nil` if the given key is
  # not found in the session.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#114
  def [](key); end

  # Writes given value to given key of the session.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#154
  def []=(key, value); end

  # Clears the session.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#160
  def clear; end

  # Deletes given key from the session.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#193
  def delete(key); end

  # source://actionpack//lib/action_dispatch/request/session.rb#99
  def destroy; end

  # Returns the nested value specified by the sequence of keys, returning `nil` if
  # any intermediate step is `nil`.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#127
  def dig(*keys); end

  # source://actionpack//lib/action_dispatch/request/session.rb#244
  def each(&block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#239
  def empty?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#91
  def enabled?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#229
  def exists?; end

  # Returns value of the given key from the session, or raises `KeyError` if can't
  # find the given key and no default value is set. Returns default value if
  # specified.
  #
  #     session.fetch(:foo)
  #     # => KeyError: key not found: "foo"
  #
  #     session.fetch(:foo, :bar)
  #     # => :bar
  #
  #     session.fetch(:foo) do
  #       :bar
  #     end
  #     # => :bar
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#212
  def fetch(key, default = T.unsafe(nil), &block); end

  # Returns true if the session has the given key or false.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#134
  def has_key?(key); end

  # source://actionpack//lib/action_dispatch/request/session.rb#87
  def id; end

  # source://actionpack//lib/action_dispatch/request/session.rb#248
  def id_was; end

  # Returns true if the session has the given key or false.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#134
  def include?(key); end

  # source://actionpack//lib/action_dispatch/request/session.rb#221
  def inspect; end

  # Returns true if the session has the given key or false.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#134
  def key?(key); end

  # Returns keys of the session as Array.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#142
  def keys; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#235
  def loaded?; end

  # Updates the session with given Hash.
  #
  #     session.to_hash
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2"}
  #
  #     session.update({ "foo" => "bar" })
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2", "foo" => "bar"}
  #
  #     session.to_hash
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2", "foo" => "bar"}
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#182
  def merge!(hash); end

  # source://actionpack//lib/action_dispatch/request/session.rb#95
  def options; end

  # Returns the session as Hash.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#166
  def to_h; end

  # Returns the session as Hash.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#166
  def to_hash; end

  # Updates the session with given Hash.
  #
  #     session.to_hash
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2"}
  #
  #     session.update({ "foo" => "bar" })
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2", "foo" => "bar"}
  #
  #     session.to_hash
  #     # => {"session_id"=>"e29b9ea315edf98aad94cc78c34cc9b2", "foo" => "bar"}
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#182
  def update(hash); end

  # Returns values of the session as Array.
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#148
  def values; end

  private

  # source://actionpack//lib/action_dispatch/request/session.rb#270
  def load!; end

  # source://actionpack//lib/action_dispatch/request/session.rb#266
  def load_for_delete!; end

  # source://actionpack//lib/action_dispatch/request/session.rb#254
  def load_for_read!; end

  # source://actionpack//lib/action_dispatch/request/session.rb#258
  def load_for_write!; end

  class << self
    # Creates a session hash, merging the properties of the previous session if any.
    #
    # source://actionpack//lib/action_dispatch/request/session.rb#19
    def create(store, req, default_options); end

    # source://actionpack//lib/action_dispatch/request/session.rb#43
    def delete(req); end

    # source://actionpack//lib/action_dispatch/request/session.rb#29
    def disabled(req); end

    # source://actionpack//lib/action_dispatch/request/session.rb#35
    def find(req); end

    # source://actionpack//lib/action_dispatch/request/session.rb#39
    def set(req, session); end
  end
end

# source://actionpack//lib/action_dispatch/request/session.rb#11
class ActionDispatch::Request::Session::DisabledSessionError < ::StandardError; end

# source://actionpack//lib/action_dispatch/request/session.rb#12
ActionDispatch::Request::Session::ENV_SESSION_KEY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/request/session.rb#13
ActionDispatch::Request::Session::ENV_SESSION_OPTIONS_KEY = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/request/session.rb#47
class ActionDispatch::Request::Session::Options
  # @return [Options] a new instance of Options
  #
  # source://actionpack//lib/action_dispatch/request/session.rb#56
  def initialize(by, default_options); end

  # source://actionpack//lib/action_dispatch/request/session.rb#61
  def [](key); end

  # source://actionpack//lib/action_dispatch/request/session.rb#71
  def []=(k, v); end

  # source://actionpack//lib/action_dispatch/request/session.rb#65
  def id(req); end

  # source://actionpack//lib/action_dispatch/request/session.rb#72
  def to_hash; end

  # source://actionpack//lib/action_dispatch/request/session.rb#73
  def values_at(*args); end

  class << self
    # source://actionpack//lib/action_dispatch/request/session.rb#52
    def find(req); end

    # source://actionpack//lib/action_dispatch/request/session.rb#48
    def set(req, options); end
  end
end

# Singleton object used to determine if an optional param wasn't specified.
#
# source://actionpack//lib/action_dispatch/request/session.rb#16
ActionDispatch::Request::Session::Unspecified = T.let(T.unsafe(nil), Object)

# source://actionpack//lib/action_dispatch/request/utils.rb#9
class ActionDispatch::Request::Utils
  # source://actionpack//lib/action_dispatch/request/utils.rb#10
  def perform_deep_munge; end

  # source://actionpack//lib/action_dispatch/request/utils.rb#10
  def perform_deep_munge=(val); end

  class << self
    # source://actionpack//lib/action_dispatch/request/utils.rb#31
    def check_param_encoding(params); end

    # source://actionpack//lib/action_dispatch/request/utils.rb#12
    def each_param_value(params, &block); end

    # source://actionpack//lib/action_dispatch/request/utils.rb#23
    def normalize_encode_params(params); end

    # source://actionpack//lib/action_dispatch/request/utils.rb#10
    def perform_deep_munge; end

    # source://actionpack//lib/action_dispatch/request/utils.rb#10
    def perform_deep_munge=(val); end

    # source://actionpack//lib/action_dispatch/request/utils.rb#46
    def set_binary_encoding(request, params, controller, action); end
  end
end

# source://actionpack//lib/action_dispatch/request/utils.rb#85
class ActionDispatch::Request::Utils::CustomParamEncoder
  class << self
    # source://actionpack//lib/action_dispatch/request/utils.rb#101
    def action_encoding_template(request, controller, action); end

    # source://actionpack//lib/action_dispatch/request/utils.rb#86
    def encode(request, params, controller, action); end
  end
end

# Remove nils from the params hash.
#
# source://actionpack//lib/action_dispatch/request/utils.rb#77
class ActionDispatch::Request::Utils::NoNilParamEncoder < ::ActionDispatch::Request::Utils::ParamEncoder
  class << self
    # source://actionpack//lib/action_dispatch/request/utils.rb#78
    def handle_array(params); end
  end
end

# source://actionpack//lib/action_dispatch/request/utils.rb#50
class ActionDispatch::Request::Utils::ParamEncoder
  class << self
    # source://actionpack//lib/action_dispatch/request/utils.rb#71
    def handle_array(params); end

    # Convert nested Hash to HashWithIndifferentAccess.
    #
    # source://actionpack//lib/action_dispatch/request/utils.rb#52
    def normalize_encode_params(params); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/cookies.rb#12
module ActionDispatch::RequestCookieMethods
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#50
  def authenticated_encrypted_cookie_salt; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#13
  def cookie_jar; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#30
  def cookie_jar=(jar); end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#78
  def cookies_digest; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#82
  def cookies_rotations; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#74
  def cookies_same_site_protection; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#70
  def cookies_serializer; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#58
  def encrypted_cookie_cipher; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#42
  def encrypted_cookie_salt; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#46
  def encrypted_signed_cookie_salt; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#26
  def have_cookie_jar?; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#34
  def key_generator; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#66
  def secret_key_base; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#62
  def signed_cookie_digest; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#38
  def signed_cookie_salt; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#54
  def use_authenticated_cookie_encryption; end

  # source://actionpack//lib/action_dispatch/middleware/cookies.rb#86
  def use_cookies_with_metadata; end
end

# source://actionpack//lib/action_dispatch/testing/request_encoder.rb#8
class ActionDispatch::RequestEncoder
  # @return [RequestEncoder] a new instance of RequestEncoder
  #
  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#20
  def initialize(mime_name, param_encoder, response_parser); end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#36
  def accept_header; end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#32
  def content_type; end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#40
  def encode_params(params); end

  # Returns the value of attribute response_parser.
  #
  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#18
  def response_parser; end

  class << self
    # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#49
    def encoder(name); end

    # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#44
    def parser(content_type); end

    # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#53
    def register_encoder(mime_name, param_encoder: T.unsafe(nil), response_parser: T.unsafe(nil)); end
  end
end

# source://actionpack//lib/action_dispatch/testing/request_encoder.rb#9
class ActionDispatch::RequestEncoder::IdentityEncoder
  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#11
  def accept_header; end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#10
  def content_type; end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#12
  def encode_params(params); end

  # source://actionpack//lib/action_dispatch/testing/request_encoder.rb#13
  def response_parser; end
end

# # Action Dispatch RequestId
#
# Makes a unique request id available to the `action_dispatch.request_id` env
# variable (which is then accessible through ActionDispatch::Request#request_id
# or the alias ActionDispatch::Request#uuid) and sends the same id to the client
# via the `X-Request-Id` header.
#
# The unique request id is either based on the `X-Request-Id` header in the
# request, which would typically be generated by a firewall, load balancer, or
# the web server, or, if this header is not available, a random uuid. If the
# header is accepted from the outside world, we sanitize it to a max of 255
# chars and alphanumeric and dashes only.
#
# The unique request id can be used to trace a request end-to-end and would
# typically end up being part of log files from multiple pieces of the stack.
#
# source://actionpack//lib/action_dispatch/middleware/request_id.rb#24
class ActionDispatch::RequestId
  # @return [RequestId] a new instance of RequestId
  #
  # source://actionpack//lib/action_dispatch/middleware/request_id.rb#25
  def initialize(app, header:); end

  # source://actionpack//lib/action_dispatch/middleware/request_id.rb#30
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/middleware/request_id.rb#45
  def internal_request_id; end

  # source://actionpack//lib/action_dispatch/middleware/request_id.rb#37
  def make_request_id(request_id); end
end

# # Action Dispatch Response
#
# Represents an HTTP response generated by a controller action. Use it to
# retrieve the current state of the response, or customize the response. It can
# either represent a real HTTP response (i.e. one that is meant to be sent back
# to the web browser) or a TestResponse (i.e. one that is generated from
# integration tests).
#
# The Response object for the current request is exposed on controllers as
# ActionController::Metal#response. ActionController::Metal also provides a few
# additional methods that delegate to attributes of the Response such as
# ActionController::Metal#headers.
#
# Integration tests will likely also want to inspect responses in more detail.
# Methods such as Integration::RequestHelpers#get and
# Integration::RequestHelpers#post return instances of TestResponse (which
# inherits from Response) for this purpose.
#
# For example, the following demo integration test prints the body of the
# controller response to the console:
#
#     class DemoControllerTest < ActionDispatch::IntegrationTest
#       def test_print_root_path_to_console
#         get('/')
#         puts response.body
#       end
#     end
#
# source://actionpack//lib/action_dispatch/http/response.rb#38
class ActionDispatch::Response
  include ::Rack::Response::Helpers
  include ::ActionDispatch::Http::FilterRedirect
  include ::ActionDispatch::Http::Cache::Response
  include ::MonitorMixin

  # @return [Response] a new instance of Response
  # @yield [_self]
  # @yieldparam _self [ActionDispatch::Response] the object that the method was called on
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#171
  def initialize(status = T.unsafe(nil), headers = T.unsafe(nil), body = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/response.rb#75
  def [](*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/http/response.rb#75
  def []=(*_arg0, **_arg1, &_arg2); end

  # Aliasing these off because AD::Http::Cache::Response defines them.
  #
  # source://rack/3.1.7/lib/rack/response.rb#290
  def _cache_control; end

  # source://rack/3.1.7/lib/rack/response.rb#294
  def _cache_control=(value); end

  # source://actionpack//lib/action_dispatch/http/response.rb#396
  def abort; end

  # source://actionpack//lib/action_dispatch/http/response.rb#197
  def await_commit; end

  # source://actionpack//lib/action_dispatch/http/response.rb#203
  def await_sent; end

  # Returns the content of the response as a string. This contains the contents of
  # any calls to `render`.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#330
  def body; end

  # Allows you to manually set or override the response body.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#339
  def body=(body); end

  # source://actionpack//lib/action_dispatch/http/response.rb#383
  def body_parts; end

  # The charset of the response. HTML wants to know the encoding of the content
  # you're giving them, so we need to send that along.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#300
  def charset; end

  # Sets the HTTP character set. In case of `nil` parameter it sets the charset to
  # `default_charset`.
  #
  #     response.charset = 'utf-16' # => 'utf-16'
  #     response.charset = nil      # => 'utf-8'
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#289
  def charset=(charset); end

  # source://actionpack//lib/action_dispatch/http/response.rb#392
  def close; end

  # Returns a string to ensure compatibility with `Net::HTTPResponse`.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#311
  def code; end

  # source://actionpack//lib/action_dispatch/http/response.rb#207
  def commit!; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#231
  def committed?; end

  # Content type of response.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#269
  def content_type; end

  # Sets the HTTP response's content MIME type. For example, in the controller you
  # could write this:
  #
  #     response.content_type = "text/plain"
  #
  # If a character set has been defined for this response (see #charset=) then the
  # character set information will also be included in the content type
  # information.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#259
  def content_type=(content_type); end

  # Returns the response cookies, converted to a Hash of (name => value) pairs
  #
  #     assert_equal 'AuthorOfNewPage', r.cookies['author']
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#419
  def cookies; end

  # source://actionpack//lib/action_dispatch/http/response.rb#88
  def default_charset; end

  # source://actionpack//lib/action_dispatch/http/response.rb#88
  def default_charset=(val); end

  # source://actionpack//lib/action_dispatch/http/response.rb#89
  def default_headers; end

  # source://actionpack//lib/action_dispatch/http/response.rb#89
  def default_headers=(val); end

  # source://actionpack//lib/action_dispatch/http/response.rb#195
  def delete_header(key); end

  # source://actionpack//lib/action_dispatch/http/response.rb#77
  def each(&block); end

  # source://actionpack//lib/action_dispatch/http/response.rb#193
  def get_header(key); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#192
  def has_header?(key); end

  # The headers for the response.
  #
  #     header["Content-Type"] # => "text/plain"
  #     header["Content-Type"] = "application/json"
  #     header["Content-Type"] # => "application/json"
  #
  # Also aliased as `headers`.
  #
  #     headers["Content-Type"] # => "text/plain"
  #     headers["Content-Type"] = "application/json"
  #     headers["Content-Type"] # => "application/json"
  #
  # Also aliased as `header` for compatibility.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#71
  def header; end

  # The headers for the response.
  #
  #     header["Content-Type"] # => "text/plain"
  #     header["Content-Type"] = "application/json"
  #     header["Content-Type"] # => "application/json"
  #
  # Also aliased as `headers`.
  #
  #     headers["Content-Type"] # => "text/plain"
  #     headers["Content-Type"] = "application/json"
  #     headers["Content-Type"] # => "application/json"
  #
  # Also aliased as `header` for compatibility.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#71
  def headers; end

  # Media type of response.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#274
  def media_type; end

  # Returns the corresponding message for the current HTTP status code:
  #
  #     response.status = 200
  #     response.message # => "OK"
  #
  #     response.status = 404
  #     response.message # => "Not Found"
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#323
  def message; end

  # Turns the Response into a Rack-compatible array of the status, headers, and
  # body. Allows explicit splatting:
  #
  #     status, headers, body = *response
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#410
  def prepare!; end

  # The location header we'll be responding with.
  #
  # source://rack/3.1.7/lib/rack/response.rb#262
  def redirect_url; end

  # The request that the response is responding to.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#53
  def request; end

  # The request that the response is responding to.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#53
  def request=(_arg0); end

  # source://actionpack//lib/action_dispatch/http/response.rb#379
  def reset_body!; end

  # The response code of the request.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#306
  def response_code; end

  # Send the file stored at `path` as the response body.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#374
  def send_file(path); end

  # source://actionpack//lib/action_dispatch/http/response.rb#215
  def sending!; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#230
  def sending?; end

  # source://actionpack//lib/action_dispatch/http/response.rb#278
  def sending_file=(v); end

  # source://actionpack//lib/action_dispatch/http/response.rb#223
  def sent!; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#232
  def sent?; end

  # source://actionpack//lib/action_dispatch/http/response.rb#194
  def set_header(key, v); end

  # The HTTP status code.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#56
  def status; end

  # Sets the HTTP status code.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#247
  def status=(status); end

  # Returns the corresponding message for the current HTTP status code:
  #
  #     response.status = 200
  #     response.message # => "OK"
  #
  #     response.status = 404
  #     response.message # => "Not Found"
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#323
  def status_message; end

  # The underlying body, as a streamable object.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#169
  def stream; end

  # Turns the Response into a Rack-compatible array of the status, headers, and
  # body. Allows explicit splatting:
  #
  #     status, headers, body = *response
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#410
  def to_a; end

  # source://actionpack//lib/action_dispatch/http/response.rb#334
  def write(string); end

  private

  # source://actionpack//lib/action_dispatch/http/response.rb#489
  def assign_default_content_type_and_charset!; end

  # source://actionpack//lib/action_dispatch/http/response.rb#463
  def before_committed; end

  # source://actionpack//lib/action_dispatch/http/response.rb#471
  def before_sending; end

  # source://actionpack//lib/action_dispatch/http/response.rb#481
  def build_buffer(response, body); end

  # source://actionpack//lib/action_dispatch/http/response.rb#539
  def handle_no_content!; end

  # source://actionpack//lib/action_dispatch/http/response.rb#485
  def munge_body_object(body); end

  # source://actionpack//lib/action_dispatch/http/response.rb#443
  def parse_content_type(content_type); end

  # Small internal convenience method to get the parsed version of the current
  # content type header.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#453
  def parsed_content_type_header; end

  # source://actionpack//lib/action_dispatch/http/response.rb#546
  def rack_response(status, headers); end

  # source://actionpack//lib/action_dispatch/http/response.rb#457
  def set_content_type(content_type, charset); end

  class << self
    # source://actionpack//lib/action_dispatch/http/response.rb#159
    def create(status = T.unsafe(nil), headers = T.unsafe(nil), body = T.unsafe(nil), default_headers: T.unsafe(nil)); end

    # source://actionpack//lib/action_dispatch/http/response.rb#88
    def default_charset; end

    # source://actionpack//lib/action_dispatch/http/response.rb#88
    def default_charset=(val); end

    # source://actionpack//lib/action_dispatch/http/response.rb#89
    def default_headers; end

    # source://actionpack//lib/action_dispatch/http/response.rb#89
    def default_headers=(val); end

    # source://actionpack//lib/action_dispatch/http/response.rb#164
    def merge_default_headers(original, default); end
  end
end

# source://actionpack//lib/action_dispatch/http/response.rb#100
class ActionDispatch::Response::Buffer
  # @return [Buffer] a new instance of Buffer
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#101
  def initialize(response, buf); end

  # @raise [IOError]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#122
  def <<(string); end

  # source://actionpack//lib/action_dispatch/http/response.rb#141
  def abort; end

  # source://actionpack//lib/action_dispatch/http/response.rb#114
  def body; end

  # source://actionpack//lib/action_dispatch/http/response.rb#144
  def close; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#149
  def closed?; end

  # source://actionpack//lib/action_dispatch/http/response.rb#131
  def each(&block); end

  # source://actionpack//lib/action_dispatch/http/response.rb#108
  def to_ary; end

  # @raise [IOError]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#122
  def write(string); end

  private

  # source://actionpack//lib/action_dispatch/http/response.rb#154
  def each_chunk(&block); end
end

# source://actionpack//lib/action_dispatch/http/response.rb#84
ActionDispatch::Response::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/response.rb#437
ActionDispatch::Response::CONTENT_TYPE_PARSER = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/http/response.rb#434
class ActionDispatch::Response::ContentTypeHeader < ::Struct
  # Returns the value of attribute charset
  #
  # @return [Object] the current value of charset
  def charset; end

  # Sets the attribute charset
  #
  # @param value [Object] the value to set the attribute charset to.
  # @return [Object] the newly set value
  def charset=(_); end

  # Returns the value of attribute mime_type
  #
  # @return [Object] the current value of mime_type
  def mime_type; end

  # Sets the attribute mime_type
  #
  # @param value [Object] the value to set the attribute mime_type to.
  # @return [Object] the newly set value
  def mime_type=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Avoid having to pass an open file handle as the response body. Rack::Sendfile
# will usually intercept the response and uses the path directly, so there is no
# reason to open the file.
#
# source://actionpack//lib/action_dispatch/http/response.rb#352
class ActionDispatch::Response::FileBody
  # @return [FileBody] a new instance of FileBody
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#355
  def initialize(path); end

  # source://actionpack//lib/action_dispatch/http/response.rb#359
  def body; end

  # Stream the file's contents if Rack::Sendfile isn't present.
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#364
  def each; end

  # source://actionpack//lib/action_dispatch/http/response.rb#353
  def to_path; end
end

# To be deprecated:
#
# source://actionpack//lib/action_dispatch/http/response.rb#50
ActionDispatch::Response::Header = Rack::Headers

# source://actionpack//lib/action_dispatch/http/response.rb#42
ActionDispatch::Response::Headers = Rack::Headers

# source://actionpack//lib/action_dispatch/http/response.rb#86
ActionDispatch::Response::NO_CONTENT_CODES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/http/response.rb#435
ActionDispatch::Response::NullContentTypeHeader = T.let(T.unsafe(nil), ActionDispatch::Response::ContentTypeHeader)

# source://actionpack//lib/action_dispatch/http/response.rb#497
class ActionDispatch::Response::RackBody
  # @return [RackBody] a new instance of RackBody
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#498
  def initialize(response); end

  # source://actionpack//lib/action_dispatch/http/response.rb#508
  def body; end

  # source://actionpack//lib/action_dispatch/http/response.rb#530
  def call(*arguments, &block); end

  # source://actionpack//lib/action_dispatch/http/response.rb#502
  def close; end

  # source://actionpack//lib/action_dispatch/http/response.rb#526
  def each(*args, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/response.rb#514
  def respond_to?(method, include_private = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/response.rb#522
  def to_ary; end

  # source://actionpack//lib/action_dispatch/http/response.rb#534
  def to_path; end
end

# source://actionpack//lib/action_dispatch/http/response.rb#512
ActionDispatch::Response::RackBody::BODY_METHODS = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/response.rb#85
ActionDispatch::Response::SET_COOKIE = T.let(T.unsafe(nil), String)

# The routing module provides URL rewriting in native Ruby. It's a way to
# redirect incoming requests to controllers and actions. This replaces
# mod_rewrite rules. Best of all, Rails' Routing works with any web server.
# Routes are defined in `config/routes.rb`.
#
# Think of creating routes as drawing a map for your requests. The map tells
# them where to go based on some predefined pattern:
#
#     Rails.application.routes.draw do
#       Pattern 1 tells some request to go to one place
#       Pattern 2 tell them to go to another
#       ...
#     end
#
# The following symbols are special:
#
#     :controller maps to your controller name
#     :action     maps to an action with your controllers
#
# Other names simply map to a parameter as in the case of `:id`.
#
# ## Resources
#
# Resource routing allows you to quickly declare all of the common routes for a
# given resourceful controller. Instead of declaring separate routes for your
# `index`, `show`, `new`, `edit`, `create`, `update`, and `destroy` actions, a
# resourceful route declares them in a single line of code:
#
#     resources :photos
#
# Sometimes, you have a resource that clients always look up without referencing
# an ID. A common example, /profile always shows the profile of the currently
# logged in user. In this case, you can use a singular resource to map /profile
# (rather than /profile/:id) to the show action.
#
#     resource :profile
#
# It's common to have resources that are logically children of other resources:
#
#     resources :magazines do
#       resources :ads
#     end
#
# You may wish to organize groups of controllers under a namespace. Most
# commonly, you might group a number of administrative controllers under an
# `admin` namespace. You would place these controllers under the
# `app/controllers/admin` directory, and you can group them together in your
# router:
#
#     namespace "admin" do
#       resources :posts, :comments
#     end
#
# Alternatively, you can add prefixes to your path without using a separate
# directory by using `scope`. `scope` takes additional options which apply to
# all enclosed routes.
#
#     scope path: "/cpanel", as: 'admin' do
#       resources :posts, :comments
#     end
#
# For more, see Routing::Mapper::Resources#resources,
# Routing::Mapper::Scoping#namespace, and Routing::Mapper::Scoping#scope.
#
# ## Non-resourceful routes
#
# For routes that don't fit the `resources` mold, you can use the HTTP helper
# methods `get`, `post`, `patch`, `put` and `delete`.
#
#     get 'post/:id', to: 'posts#show'
#     post 'post/:id', to: 'posts#create_comment'
#
# Now, if you POST to `/posts/:id`, it will route to the `create_comment`
# action. A GET on the same URL will route to the `show` action.
#
# If your route needs to respond to more than one HTTP method (or all methods)
# then using the `:via` option on `match` is preferable.
#
#     match 'post/:id', to: 'posts#show', via: [:get, :post]
#
# ## Named routes
#
# Routes can be named by passing an `:as` option, allowing for easy reference
# within your source as `name_of_route_url` for the full URL and
# `name_of_route_path` for the URI path.
#
# Example:
#
#     # In config/routes.rb
#     get '/login', to: 'accounts#login', as: 'login'
#
#     # With render, redirect_to, tests, etc.
#     redirect_to login_url
#
# Arguments can be passed as well.
#
#     redirect_to show_item_path(id: 25)
#
# Use `root` as a shorthand to name a route for the root path "/".
#
#     # In config/routes.rb
#     root to: 'blogs#index'
#
#     # would recognize http://www.example.com/ as
#     params = { controller: 'blogs', action: 'index' }
#
#     # and provide these named routes
#     root_url   # => 'http://www.example.com/'
#     root_path  # => '/'
#
# Note: when using `controller`, the route is simply named after the method you
# call on the block parameter rather than map.
#
#     # In config/routes.rb
#     controller :blog do
#       get 'blog/show'    => :list
#       get 'blog/delete'  => :delete
#       get 'blog/edit'    => :edit
#     end
#
#     # provides named routes for show, delete, and edit
#     link_to @article.title, blog_show_path(id: @article.id)
#
# ## Pretty URLs
#
# Routes can generate pretty URLs. For example:
#
#     get '/articles/:year/:month/:day', to: 'articles#find_by_id', constraints: {
#       year:       /\d{4}/,
#       month:      /\d{1,2}/,
#       day:        /\d{1,2}/
#     }
#
# Using the route above, the URL "http://localhost:3000/articles/2005/11/06"
# maps to
#
#     params = {year: '2005', month: '11', day: '06'}
#
# ## Regular Expressions and parameters
# You can specify a regular expression to define a format for a parameter.
#
#     controller 'geocode' do
#       get 'geocode/:postalcode', to: :show, constraints: {
#         postalcode: /\d{5}(-\d{4})?/
#       }
#     end
#
# Constraints can include the 'ignorecase' and 'extended syntax' regular
# expression modifiers:
#
#     controller 'geocode' do
#       get 'geocode/:postalcode', to: :show, constraints: {
#         postalcode: /hx\d\d\s\d[a-z]{2}/i
#       }
#     end
#
#     controller 'geocode' do
#       get 'geocode/:postalcode', to: :show, constraints: {
#         postalcode: /# Postalcode format
#            \d{5} #Prefix
#            (-\d{4})? #Suffix
#            /x
#       }
#     end
#
# Using the multiline modifier will raise an `ArgumentError`. Encoding regular
# expression modifiers are silently ignored. The match will always use the
# default encoding or ASCII.
#
# ## External redirects
#
# You can redirect any path to another path using the redirect helper in your
# router:
#
#     get "/stories", to: redirect("/posts")
#
# ## Unicode character routes
#
# You can specify unicode character routes in your router:
#
#     get "こんにちは", to: "welcome#index"
#
# ## Routing to Rack Applications
#
# Instead of a String, like `posts#index`, which corresponds to the index action
# in the PostsController, you can specify any Rack application as the endpoint
# for a matcher:
#
#     get "/application.js", to: Sprockets
#
# ## Reloading routes
#
# You can reload routes if you feel you must:
#
#     Rails.application.reload_routes!
#
# This will clear all named routes and reload config/routes.rb if the file has
# been modified from last load. To absolutely force reloading, use `reload!`.
#
# ## Testing Routes
#
# The two main methods for testing your routes:
#
# ### `assert_routing`
#
#     def test_movie_route_properly_splits
#       opts = {controller: "plugin", action: "checkout", id: "2"}
#       assert_routing "plugin/checkout/2", opts
#     end
#
# `assert_routing` lets you test whether or not the route properly resolves into
# options.
#
# ### `assert_recognizes`
#
#     def test_route_has_options
#       opts = {controller: "plugin", action: "show", id: "12"}
#       assert_recognizes opts, "/plugins/show/12"
#     end
#
# Note the subtle difference between the two: `assert_routing` tests that a URL
# fits options while `assert_recognizes` tests that a URL breaks into parameters
# properly.
#
# In tests you can simply pass the URL or named route to `get` or `post`.
#
#     def send_to_jail
#       get '/jail'
#       assert_response :success
#     end
#
#     def goes_to_login
#       get login_url
#       #...
#     end
#
# ## View a list of all your routes
#
#     $ bin/rails routes
#
# Target a specific controller with `-c`, or grep routes using `-g`. Useful in
# conjunction with `--expanded` which displays routes vertically.
#
# source://actionpack//lib/action_dispatch/routing.rb#248
module ActionDispatch::Routing
  extend ::ActiveSupport::Autoload
end

# source://actionpack//lib/action_dispatch/routing/inspector.rb#155
module ActionDispatch::Routing::ConsoleFormatter; end

# source://actionpack//lib/action_dispatch/routing/inspector.rb#156
class ActionDispatch::Routing::ConsoleFormatter::Base
  # @return [Base] a new instance of Base
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#157
  def initialize; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#171
  def header(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#174
  def no_routes(routes, filter); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#161
  def result; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#168
  def section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#165
  def section_title(title); end
end

# source://actionpack//lib/action_dispatch/routing/inspector.rb#228
class ActionDispatch::Routing::ConsoleFormatter::Expanded < ::ActionDispatch::Routing::ConsoleFormatter::Base
  # @return [Expanded] a new instance of Expanded
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#229
  def initialize(width: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#238
  def section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#234
  def section_title(title); end

  private

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#243
  def draw_expanded_section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#258
  def route_header(index:); end
end

# source://actionpack//lib/action_dispatch/routing/inspector.rb#192
class ActionDispatch::Routing::ConsoleFormatter::Sheet < ::ActionDispatch::Routing::ConsoleFormatter::Base
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#201
  def header(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#197
  def section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#193
  def section_title(title); end

  private

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#215
  def draw_header(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#206
  def draw_section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#221
  def widths(routes); end
end

# source://actionpack//lib/action_dispatch/routing/inspector.rb#263
class ActionDispatch::Routing::ConsoleFormatter::Unused < ::ActionDispatch::Routing::ConsoleFormatter::Sheet
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#264
  def header(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#272
  def no_routes(routes, filter); end
end

# source://actionpack//lib/action_dispatch/routing/endpoint.rb#7
class ActionDispatch::Routing::Endpoint
  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#11
  def app; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#8
  def dispatcher?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#14
  def engine?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#10
  def matches?(req); end

  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#12
  def rack_app; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/endpoint.rb#9
  def redirect?; end
end

# source://actionpack//lib/action_dispatch/routing.rb#260
ActionDispatch::Routing::HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/inspector.rb#285
class ActionDispatch::Routing::HtmlTableFormatter
  # @return [HtmlTableFormatter] a new instance of HtmlTableFormatter
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#286
  def initialize(view); end

  # The header is part of the HTML page, so we don't construct it here.
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#300
  def header(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#303
  def no_routes(*_arg0); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#316
  def result; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#295
  def section(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#291
  def section_title(title); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#14
class ActionDispatch::Routing::Mapper
  include ::ActionDispatch::Routing::Mapper::Base
  include ::ActionDispatch::Routing::Mapper::HttpHelpers
  include ::ActionDispatch::Routing::Redirection
  include ::ActionDispatch::Routing::Mapper::Scoping
  include ::ActionDispatch::Routing::Mapper::Concerns
  include ::ActionDispatch::Routing::Mapper::Resources
  include ::ActionDispatch::Routing::Mapper::CustomUrls

  # @return [Mapper] a new instance of Mapper
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2348
  def initialize(set); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/mapper.rb#27
    def backtrace_cleaner; end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#27
    def backtrace_cleaner=(val); end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#429
    def normalize_name(name); end

    # Invokes Journey::Router::Utils.normalize_path, then ensures that /(:locale)
    # becomes (/:locale). Except for root cases, where the former is the correct
    # one.
    #
    # source://actionpack//lib/action_dispatch/routing/mapper.rb#414
    def normalize_path(path); end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#26
    def route_source_locations; end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#26
    def route_source_locations=(val); end
  end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#15
class ActionDispatch::Routing::Mapper::BacktraceCleaner < ::ActiveSupport::BacktraceCleaner
  # @return [BacktraceCleaner] a new instance of BacktraceCleaner
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#16
  def initialize; end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#433
module ActionDispatch::Routing::Mapper::Base
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#662
  def default_url_options(options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#662
  def default_url_options=(options); end

  # Query if the following named route was already defined.
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#674
  def has_named_route?(name); end

  # Matches a URL pattern to one or more routes.
  #
  # You should not use the `match` method in your router without specifying an
  # HTTP method.
  #
  # If you want to expose your action to both GET and POST, use:
  #
  #     # sets :controller, :action, and :id in params
  #     match ':controller/:action/:id', via: [:get, :post]
  #
  # Note that `:controller`, `:action`, and `:id` are interpreted as URL query
  # parameters and thus available through `params` in an action.
  #
  # If you want to expose your action to GET, use `get` in the router:
  #
  # Instead of:
  #
  #     match ":controller/:action/:id"
  #
  # Do:
  #
  #     get ":controller/:action/:id"
  #
  # Two of these symbols are special, `:controller` maps to the controller and
  # `:action` to the controller's action. A pattern can also map wildcard segments
  # (globs) to params:
  #
  #     get 'songs/*category/:title', to: 'songs#show'
  #
  #     # 'songs/rock/classic/stairway-to-heaven' sets
  #     #  params[:category] = 'rock/classic'
  #     #  params[:title] = 'stairway-to-heaven'
  #
  # To match a wildcard parameter, it must have a name assigned to it. Without a
  # variable name to attach the glob parameter to, the route can't be parsed.
  #
  # When a pattern points to an internal route, the route's `:action` and
  # `:controller` should be set in options or hash shorthand. Examples:
  #
  #     match 'photos/:id' => 'photos#show', via: :get
  #     match 'photos/:id', to: 'photos#show', via: :get
  #     match 'photos/:id', controller: 'photos', action: 'show', via: :get
  #
  # A pattern can also point to a `Rack` endpoint i.e. anything that responds to
  # `call`:
  #
  #     match 'photos/:id', to: -> (hash) { [200, {}, ["Coming soon"]] }, via: :get
  #     match 'photos/:id', to: PhotoRackApp, via: :get
  #     # Yes, controller actions are just rack endpoints
  #     match 'photos/:id', to: PhotosController.action(:show), via: :get
  #
  # Because requesting various HTTP verbs with a single action has security
  # implications, you must either specify the actions in the via options or use
  # one of the [HttpHelpers](rdoc-ref:HttpHelpers) instead `match`
  #
  # ### Options
  #
  # Any options not seen here are passed on as params with the URL.
  #
  # :controller
  # :   The route's controller.
  #
  # :action
  # :   The route's action.
  #
  # :param
  # :   Overrides the default resource identifier `:id` (name of the dynamic
  #     segment used to generate the routes). You can access that segment from
  #     your controller using `params[<:param>]`. In your router:
  #
  #         resources :users, param: :name
  #
  #     The `users` resource here will have the following routes generated for it:
  #
  #         GET       /users(.:format)
  #         POST      /users(.:format)
  #         GET       /users/new(.:format)
  #         GET       /users/:name/edit(.:format)
  #         GET       /users/:name(.:format)
  #         PATCH/PUT /users/:name(.:format)
  #         DELETE    /users/:name(.:format)
  #
  #     You can override `ActiveRecord::Base#to_param` of a related model to
  #     construct a URL:
  #
  #         class User < ActiveRecord::Base
  #           def to_param
  #             name
  #           end
  #         end
  #
  #         user = User.find_by(name: 'Phusion')
  #         user_path(user)  # => "/users/Phusion"
  #
  # :path
  # :   The path prefix for the routes.
  #
  # :module
  # :   The namespace for :controller.
  #
  #         match 'path', to: 'c#a', module: 'sekret', controller: 'posts', via: :get
  #         # => Sekret::PostsController
  #
  #     See `Scoping#namespace` for its scope equivalent.
  #
  # :as
  # :   The name used to generate routing helpers.
  #
  # :via
  # :   Allowed HTTP verb(s) for route.
  #
  #         match 'path', to: 'c#a', via: :get
  #         match 'path', to: 'c#a', via: [:get, :post]
  #         match 'path', to: 'c#a', via: :all
  #
  # :to
  # :   Points to a `Rack` endpoint. Can be an object that responds to `call` or a
  #     string representing a controller's action.
  #
  #         match 'path', to: 'controller#action', via: :get
  #         match 'path', to: -> (env) { [200, {}, ["Success!"]] }, via: :get
  #         match 'path', to: RackApp, via: :get
  #
  # :on
  # :   Shorthand for wrapping routes in a specific RESTful context. Valid values
  #     are `:member`, `:collection`, and `:new`. Only use within `resource(s)`
  #     block. For example:
  #
  #         resource :bar do
  #           match 'foo', to: 'c#a', on: :member, via: [:get, :post]
  #         end
  #
  #     Is equivalent to:
  #
  #         resource :bar do
  #           member do
  #             match 'foo', to: 'c#a', via: [:get, :post]
  #           end
  #         end
  #
  # :constraints
  # :   Constrains parameters with a hash of regular expressions or an object that
  #     responds to `matches?`. In addition, constraints other than path can also
  #     be specified with any object that responds to `===` (e.g. String, Array,
  #     Range, etc.).
  #
  #         match 'path/:id', constraints: { id: /[A-Z]\d{5}/ }, via: :get
  #
  #         match 'json_only', constraints: { format: 'json' }, via: :get
  #
  #         class PermitList
  #           def matches?(request) request.remote_ip == '1.2.3.4' end
  #         end
  #         match 'path', to: 'c#a', constraints: PermitList.new, via: :get
  #
  #     See `Scoping#constraints` for more examples with its scope equivalent.
  #
  # :defaults
  # :   Sets defaults for parameters
  #
  #         # Sets params[:format] to 'jpg' by default
  #         match 'path', to: 'c#a', defaults: { format: 'jpg' }, via: :get
  #
  #     See `Scoping#defaults` for its scope equivalent.
  #
  # :anchor
  # :   Boolean to anchor a `match` pattern. Default is true. When set to false,
  #     the pattern matches any request prefixed with the given path.
  #
  #         # Matches any request starting with 'path'
  #         match 'path', to: 'c#a', anchor: false, via: :get
  #
  # :format
  # :   Allows you to specify the default value for optional `format` segment or
  #     disable it by supplying `false`.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#610
  def match(path, options = T.unsafe(nil)); end

  # Mount a Rack-based application to be used within the application.
  #
  #     mount SomeRackApp, at: "some_route"
  #
  # Alternatively:
  #
  #     mount(SomeRackApp => "some_route")
  #
  # For options, see `match`, as `mount` uses it internally.
  #
  # All mounted applications come with routing helpers to access them. These are
  # named after the class specified, so for the above example the helper is either
  # `some_rack_app_path` or `some_rack_app_url`. To customize this helper's name,
  # use the `:as` option:
  #
  #     mount(SomeRackApp => "some_route", as: "exciting")
  #
  # This will generate the `exciting_path` and `exciting_url` helpers which can be
  # used to navigate to this mounted app.
  #
  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#632
  def mount(app, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#667
  def with_default_scope(scope, &block); end

  private

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#683
  def app_name(app, rails_app); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#692
  def define_generate_prefix(app, name); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#679
  def rails_app?(app); end
end

# Routing Concerns allow you to declare common routes that can be reused inside
# others resources and routes.
#
#     concern :commentable do
#       resources :comments
#     end
#
#     concern :image_attachable do
#       resources :images, only: :index
#     end
#
# These concerns are used in Resources routing:
#
#     resources :messages, concerns: [:commentable, :image_attachable]
#
# or in a scope or namespace:
#
#     namespace :posts do
#       concerns :commentable
#     end
#
# source://actionpack//lib/action_dispatch/routing/mapper.rb#2060
module ActionDispatch::Routing::Mapper::Concerns
  # Define a routing concern using a name.
  #
  # Concerns may be defined inline, using a block, or handled by another object,
  # by passing that object as the second parameter.
  #
  # The concern object, if supplied, should respond to `call`, which will receive
  # two parameters:
  #
  #     * The current mapper
  #     * A hash of options which the concern object may use
  #
  # Options may also be used by concerns defined in a block by accepting a block
  # parameter. So, using a block, you might do something as simple as limit the
  # actions available on certain resources, passing standard resource options
  # through the concern:
  #
  #     concern :commentable do |options|
  #       resources :comments, options
  #     end
  #
  #     resources :posts, concerns: :commentable
  #     resources :archived_posts do
  #       # Don't allow comments on archived posts
  #       concerns :commentable, only: [:index, :show]
  #     end
  #
  # Or, using a callable object, you might implement something more specific to
  # your application, which would be out of place in your routes file.
  #
  #     # purchasable.rb
  #     class Purchasable
  #       def initialize(defaults = {})
  #         @defaults = defaults
  #       end
  #
  #       def call(mapper, options = {})
  #         options = @defaults.merge(options)
  #         mapper.resources :purchases
  #         mapper.resources :receipts
  #         mapper.resources :returns if options[:returnable]
  #       end
  #     end
  #
  #     # routes.rb
  #     concern :purchasable, Purchasable.new(returnable: true)
  #
  #     resources :toys, concerns: :purchasable
  #     resources :electronics, concerns: :purchasable
  #     resources :pets do
  #       concerns :purchasable, returnable: false
  #     end
  #
  # Any routing helpers can be used inside a concern. If using a callable, they're
  # accessible from the Mapper that's passed to `call`.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2115
  def concern(name, callable = T.unsafe(nil), &block); end

  # Use the named concerns
  #
  #     resources :posts do
  #       concerns :commentable
  #     end
  #
  # Concerns also work in any routes helper that you want to use:
  #
  #     namespace :posts do
  #       concerns :commentable
  #     end
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2131
  def concerns(*args); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#29
class ActionDispatch::Routing::Mapper::Constraints < ::ActionDispatch::Routing::Endpoint
  # @return [Constraints] a new instance of Constraints
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#35
  def initialize(app, constraints, strategy); end

  # Returns the value of attribute app.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#30
  def app; end

  # Returns the value of attribute constraints.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#30
  def constraints; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#50
  def dispatcher?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#52
  def matches?(req); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#59
  def serve(req); end

  private

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#66
  def constraint_args(constraint, request); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#33
ActionDispatch::Routing::Mapper::Constraints::CALL = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#32
ActionDispatch::Routing::Mapper::Constraints::SERVE = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2143
module ActionDispatch::Routing::Mapper::CustomUrls
  # Define custom URL helpers that will be added to the application's routes. This
  # allows you to override and/or replace the default behavior of routing helpers,
  # e.g:
  #
  #     direct :homepage do
  #       "https://rubyonrails.org"
  #     end
  #
  #     direct :commentable do |model|
  #       [ model, anchor: model.dom_id ]
  #     end
  #
  #     direct :main do
  #       { controller: "pages", action: "index", subdomain: "www" }
  #     end
  #
  # The return value from the block passed to `direct` must be a valid set of
  # arguments for `url_for` which will actually build the URL string. This can be
  # one of the following:
  #
  # *   A string, which is treated as a generated URL
  # *   A hash, e.g. `{ controller: "pages", action: "index" }`
  # *   An array, which is passed to `polymorphic_url`
  # *   An Active Model instance
  # *   An Active Model class
  #
  #
  # NOTE: Other URL helpers can be called in the block but be careful not to
  # invoke your custom URL helper again otherwise it will result in a stack
  # overflow error.
  #
  # You can also specify default options that will be passed through to your URL
  # helper definition, e.g:
  #
  #     direct :browse, page: 1, size: 10 do |options|
  #       [ :products, options.merge(params.permit(:page, :size).to_h.symbolize_keys) ]
  #     end
  #
  # In this instance the `params` object comes from the context in which the block
  # is executed, e.g. generating a URL inside a controller action or a view. If
  # the block is executed where there isn't a `params` object such as this:
  #
  #     Rails.application.routes.url_helpers.browse_path
  #
  # then it will raise a `NameError`. Because of this you need to be aware of the
  # context in which you will use your custom URL helper when defining it.
  #
  # NOTE: The `direct` method can't be used inside of a scope block such as
  # `namespace` or `scope` and will raise an error if it detects that it is.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2193
  def direct(name, options = T.unsafe(nil), &block); end

  # Define custom polymorphic mappings of models to URLs. This alters the behavior
  # of `polymorphic_url` and consequently the behavior of `link_to` and `form_for`
  # when passed a model instance, e.g:
  #
  #     resource :basket
  #
  #     resolve "Basket" do
  #       [:basket]
  #     end
  #
  # This will now generate "/basket" when a `Basket` instance is passed to
  # `link_to` or `form_for` instead of the standard "/baskets/:id".
  #
  # NOTE: This custom behavior only applies to simple polymorphic URLs where a
  # single model instance is passed and not more complicated forms, e.g:
  #
  #     # config/routes.rb
  #     resource :profile
  #     namespace :admin do
  #       resources :users
  #     end
  #
  #     resolve("User") { [:profile] }
  #
  #     # app/views/application/_menu.html.erb
  #     link_to "Profile", @current_user
  #     link_to "Profile", [:admin, @current_user]
  #
  # The first `link_to` will generate "/profile" but the second will generate the
  # standard polymorphic URL of "/admin/users/1".
  #
  # You can pass options to a polymorphic mapping - the arity for the block needs
  # to be two as the instance is passed as the first argument, e.g:
  #
  #     resolve "Basket", anchor: "items" do |basket, options|
  #       [:basket, options]
  #     end
  #
  # This generates the URL "/basket#items" because when the last item in an array
  # passed to `polymorphic_url` is a hash then it's treated as options to the URL
  # helper that gets called.
  #
  # NOTE: The `resolve` method can't be used inside of a scope block such as
  # `namespace` or `scope` and will raise an error if it detects that it is.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2245
  def resolve(*args, &block); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#727
module ActionDispatch::Routing::Mapper::HttpHelpers
  # Define a route that only recognizes HTTP DELETE. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     delete 'broccoli', to: 'food#broccoli'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#764
  def delete(*args, &block); end

  # Define a route that only recognizes HTTP GET. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     get 'bacon', to: 'food#bacon'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#732
  def get(*args, &block); end

  # Define a route that only recognizes HTTP OPTIONS. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     options 'carrots', to: 'food#carrots'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#772
  def options(*args, &block); end

  # Define a route that only recognizes HTTP PATCH. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     patch 'bacon', to: 'food#bacon'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#748
  def patch(*args, &block); end

  # Define a route that only recognizes HTTP POST. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     post 'bacon', to: 'food#bacon'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#740
  def post(*args, &block); end

  # Define a route that only recognizes HTTP PUT. For supported arguments, see
  # [match](rdoc-ref:Base#match)
  #
  #     put 'bacon', to: 'food#bacon'
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#756
  def put(*args, &block); end

  private

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#777
  def map_method(method, args, &block); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#83
class ActionDispatch::Routing::Mapper::Mapping
  # @return [Mapping] a new instance of Mapping
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#132
  def initialize(set:, ast:, controller:, default_action:, to:, formatted:, via:, options_constraints:, anchor:, scope_params:, options:); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#190
  def application; end

  # Returns the value of attribute ast.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def ast; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#194
  def conditions; end

  # Returns the value of attribute default_action.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def default_action; end

  # Returns the value of attribute default_controller.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def default_controller; end

  # Returns the value of attribute defaults.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def defaults; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#183
  def make_route(name, precedence); end

  # Returns the value of attribute path.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def path; end

  # Returns the value of attribute required_defaults.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def required_defaults; end

  # Returns the value of attribute requirements.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def requirements; end

  # Returns the value of attribute scope_options.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def scope_options; end

  # Returns the value of attribute to.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#87
  def to; end

  private

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#334
  def add_controller_module(controller, modyoule); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#295
  def app(blocks); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#353
  def blocks(callable_constraint); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#198
  def build_conditions(current_conditions, request_class); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#307
  def check_controller_and_action(path_params, controller, action); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#322
  def check_part(name, part, path_params, hash); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#360
  def constraints(options, path_params); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#374
  def dispatcher(raise_on_name_error); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#213
  def intern(object); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#291
  def normalize_defaults(options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#259
  def normalize_format(formatted); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#217
  def normalize_options!(options, path_params, modyoule); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#207
  def request_method; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#379
  def route_source_location; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#253
  def split_constraints(path_params, constraints); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#346
  def translate_controller(controller); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#275
  def verify_regexp_requirements(requirements, wildcard_options); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/mapper.rb#90
    def build(scope, set, ast, controller, default_action, to, via, formatted, options_constraints, anchor, options); end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#104
    def check_via(via); end

    # source://actionpack//lib/action_dispatch/routing/mapper.rb#116
    def normalize_path(path, format); end

    # @return [Boolean]
    #
    # source://actionpack//lib/action_dispatch/routing/mapper.rb#128
    def optional_format?(path, format); end
  end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#84
ActionDispatch::Routing::Mapper::Mapping::ANCHOR_CHARACTERS_REGEX = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#181
ActionDispatch::Routing::Mapper::Mapping::JOINED_SEPARATORS = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#85
ActionDispatch::Routing::Mapper::Mapping::OPTIONAL_FORMAT_REGEX = T.let(T.unsafe(nil), Regexp)

# Resource routing allows you to quickly declare all of the common routes for a
# given resourceful controller. Instead of declaring separate routes for your
# `index`, `show`, `new`, `edit`, `create`, `update`, and `destroy` actions, a
# resourceful route declares them in a single line of code:
#
#     resources :photos
#
# Sometimes, you have a resource that clients always look up without referencing
# an ID. A common example, /profile always shows the profile of the currently
# logged in user. In this case, you can use a singular resource to map /profile
# (rather than /profile/:id) to the show action.
#
#     resource :profile
#
# It's common to have resources that are logically children of other resources:
#
#     resources :magazines do
#       resources :ads
#     end
#
# You may wish to organize groups of controllers under a namespace. Most
# commonly, you might group a number of administrative controllers under an
# `admin` namespace. You would place these controllers under the
# `app/controllers/admin` directory, and you can group them together in your
# router:
#
#     namespace "admin" do
#       resources :posts, :comments
#     end
#
# By default the `:id` parameter doesn't accept dots. If you need to use dots as
# part of the `:id` parameter add a constraint which overrides this restriction,
# e.g:
#
#     resources :articles, id: /[^\/]+/
#
# This allows any character other than a slash as part of your `:id`.
#
# source://actionpack//lib/action_dispatch/routing/mapper.rb#1168
module ActionDispatch::Routing::Mapper::Resources
  # To add a route to the collection:
  #
  #     resources :photos do
  #       collection do
  #         get 'search'
  #       end
  #     end
  #
  # This will enable Rails to recognize paths such as `/photos/search` with GET,
  # and route to the search action of `PhotosController`. It will also create the
  # `search_photos_url` and `search_photos_path` route helpers.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1547
  def collection(&block); end

  # Loads another routes file with the given `name` located inside the
  # `config/routes` directory. In that file, you can use the normal routing DSL,
  # but *do not* surround it with a `Rails.application.routes.draw` block.
  #
  #     # config/routes.rb
  #     Rails.application.routes.draw do
  #       draw :admin                 # Loads `config/routes/admin.rb`
  #       draw "third_party/some_gem" # Loads `config/routes/third_party/some_gem.rb`
  #     end
  #
  #     # config/routes/admin.rb
  #     namespace :admin do
  #       resources :accounts
  #     end
  #
  #     # config/routes/third_party/some_gem.rb
  #     mount SomeGem::Engine, at: "/some_gem"
  #
  # **CAUTION:** Use this feature with care. Having multiple routes files can
  # negatively impact discoverability and readability. For most applications —
  # even those with a few hundred routes — it's easier for developers to have a
  # single routes file.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1656
  def draw(name); end

  # Matches a URL pattern to one or more routes. For more information, see
  # [match](rdoc-ref:Base#match).
  #
  #     match 'path' => 'controller#action', via: :patch
  #     match 'path', to: 'controller#action', via: :post
  #     match 'path', 'otherpath', on: :member, via: :get
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1678
  def match(path, *rest, &block); end

  # To add a member route, add a member block into the resource block:
  #
  #     resources :photos do
  #       member do
  #         get 'preview'
  #       end
  #     end
  #
  # This will recognize `/photos/1/preview` with GET, and route to the preview
  # action of `PhotosController`. It will also create the `preview_photo_url` and
  # `preview_photo_path` helpers.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1568
  def member(&block); end

  # See ActionDispatch::Routing::Mapper::Scoping#namespace.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1615
  def namespace(path, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1594
  def nested(&block); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1584
  def new(&block); end

  # Sometimes, you have a resource that clients always look up without referencing
  # an ID. A common example, /profile always shows the profile of the currently
  # logged in user. In this case, you can use a singular resource to map /profile
  # (rather than /profile/:id) to the show action:
  #
  #     resource :profile
  #
  # This creates six different routes in your application, all mapping to the
  # `Profiles` controller (note that the controller is named after the plural):
  #
  #     GET       /profile/new
  #     GET       /profile
  #     GET       /profile/edit
  #     PATCH/PUT /profile
  #     DELETE    /profile
  #     POST      /profile
  #
  # If you want instances of a model to work with this resource via record
  # identification (e.g. in `form_with` or `redirect_to`), you will need to call
  # [resolve](rdoc-ref:CustomUrls#resolve):
  #
  #     resource :profile
  #     resolve('Profile') { [:profile] }
  #
  #     # Enables this to work with singular routes:
  #     form_with(model: @profile) {}
  #
  # ### Options
  # Takes same options as [resources](rdoc-ref:#resources)
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1336
  def resource(*resources, &block); end

  # In Rails, a resourceful route provides a mapping between HTTP verbs and URLs
  # and controller actions. By convention, each action also maps to particular
  # CRUD operations in a database. A single entry in the routing file, such as
  #
  #     resources :photos
  #
  # creates seven different routes in your application, all mapping to the
  # `Photos` controller:
  #
  #     GET       /photos
  #     GET       /photos/new
  #     POST      /photos
  #     GET       /photos/:id
  #     GET       /photos/:id/edit
  #     PATCH/PUT /photos/:id
  #     DELETE    /photos/:id
  #
  # Resources can also be nested infinitely by using this block syntax:
  #
  #     resources :photos do
  #       resources :comments
  #     end
  #
  # This generates the following comments routes:
  #
  #     GET       /photos/:photo_id/comments
  #     GET       /photos/:photo_id/comments/new
  #     POST      /photos/:photo_id/comments
  #     GET       /photos/:photo_id/comments/:id
  #     GET       /photos/:photo_id/comments/:id/edit
  #     PATCH/PUT /photos/:photo_id/comments/:id
  #     DELETE    /photos/:photo_id/comments/:id
  #
  # ### Options
  # Takes same options as [match](rdoc-ref:Base#match) as well as:
  #
  # :path_names
  # :   Allows you to change the segment component of the `edit` and `new`
  #     actions. Actions not specified are not changed.
  #
  #         resources :posts, path_names: { new: "brand_new" }
  #
  #     The above example will now change /posts/new to /posts/brand_new.
  #
  # :path
  # :   Allows you to change the path prefix for the resource.
  #
  #         resources :posts, path: 'postings'
  #
  #     The resource and all segments will now route to /postings instead of
  #     /posts.
  #
  # :only
  # :   Only generate routes for the given actions.
  #
  #         resources :cows, only: :show
  #         resources :cows, only: [:show, :index]
  #
  # :except
  # :   Generate all routes except for the given actions.
  #
  #         resources :cows, except: :show
  #         resources :cows, except: [:show, :index]
  #
  # :shallow
  # :   Generates shallow routes for nested resource(s). When placed on a parent
  #     resource, generates shallow routes for all nested resources.
  #
  #         resources :posts, shallow: true do
  #           resources :comments
  #         end
  #
  #     Is the same as:
  #
  #         resources :posts do
  #           resources :comments, except: [:show, :edit, :update, :destroy]
  #         end
  #         resources :comments, only: [:show, :edit, :update, :destroy]
  #
  #     This allows URLs for resources that otherwise would be deeply nested such
  #     as a comment on a blog post like `/posts/a-long-permalink/comments/1234`
  #     to be shortened to just `/comments/1234`.
  #
  #     Set `shallow: false` on a child resource to ignore a parent's shallow
  #     parameter.
  #
  # :shallow_path
  # :   Prefixes nested shallow routes with the specified path.
  #
  #         scope shallow_path: "sekret" do
  #           resources :posts do
  #             resources :comments, shallow: true
  #           end
  #         end
  #
  #     The `comments` resource here will have the following routes generated for
  #     it:
  #
  #         post_comments    GET       /posts/:post_id/comments(.:format)
  #         post_comments    POST      /posts/:post_id/comments(.:format)
  #         new_post_comment GET       /posts/:post_id/comments/new(.:format)
  #         edit_comment     GET       /sekret/comments/:id/edit(.:format)
  #         comment          GET       /sekret/comments/:id(.:format)
  #         comment          PATCH/PUT /sekret/comments/:id(.:format)
  #         comment          DELETE    /sekret/comments/:id(.:format)
  #
  # :shallow_prefix
  # :   Prefixes nested shallow route names with specified prefix.
  #
  #         scope shallow_prefix: "sekret" do
  #           resources :posts do
  #             resources :comments, shallow: true
  #           end
  #         end
  #
  #     The `comments` resource here will have the following routes generated for
  #     it:
  #
  #         post_comments           GET       /posts/:post_id/comments(.:format)
  #         post_comments           POST      /posts/:post_id/comments(.:format)
  #         new_post_comment        GET       /posts/:post_id/comments/new(.:format)
  #         edit_sekret_comment     GET       /comments/:id/edit(.:format)
  #         sekret_comment          GET       /comments/:id(.:format)
  #         sekret_comment          PATCH/PUT /comments/:id(.:format)
  #         sekret_comment          DELETE    /comments/:id(.:format)
  #
  # :format
  # :   Allows you to specify the default value for optional `format` segment or
  #     disable it by supplying `false`.
  #
  # :param
  # :   Allows you to override the default param name of `:id` in the URL.
  #
  #
  # ### Examples
  #
  #     # routes call +Admin::PostsController+
  #     resources :posts, module: "admin"
  #
  #     # resource actions are at /admin/posts.
  #     resources :posts, path: "admin/posts"
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1506
  def resources(*resources, &block); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1303
  def resources_path_names(options); end

  # You can specify what Rails should route "/" to with the root method:
  #
  #     root to: 'pages#main'
  #
  # For options, see `match`, as `root` uses it internally.
  #
  # You can also pass a string which will expand
  #
  #     root 'pages#main'
  #
  # You should put the root route at the top of `config/routes.rb`, because this
  # means it will be matched first. As this is the most popular route of most
  # Rails applications, this is beneficial.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1725
  def root(path, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1623
  def shallow; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1630
  def shallow?; end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1789
  def action_options?(options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1871
  def action_path(name); end

  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2007
  def add_route(action, controller, options, _path, to, via, formatted, anchor, options_constraints); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1925
  def api_only?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1784
  def apply_action_options(options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1750
  def apply_common_behavior_for(method, resources, options, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1847
  def canonical_action?(action); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1992
  def decomposed_match(path, controller, options, _path, to, via, formatted, anchor, options_constraints); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1977
  def get_to_from_path(path, to, action); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1936
  def map_match(paths, options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2034
  def match_root_route(options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1887
  def name_for_action(as, action); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1824
  def nested_options; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1805
  def nested_scope?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1843
  def param_constraint; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1839
  def param_constraint?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1746
  def parent_resource; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1861
  def path_for_action(action, path); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1929
  def path_scope(path); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1875
  def prefix_name_for_action(as, action); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1801
  def resource_method_scope?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1816
  def resource_scope(resource, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1797
  def resource_scope?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1793
  def scope_action_options; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1913
  def set_member_mappings_for_resource; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1833
  def shallow_nesting_depth; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1851
  def shallow_scope; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1988
  def using_match_shorthand?(path); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1809
  def with_scope_level(kind); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#1173
ActionDispatch::Routing::Mapper::Resources::CANONICAL_ACTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#1172
ActionDispatch::Routing::Mapper::Resources::RESOURCE_OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#1175
class ActionDispatch::Routing::Mapper::Resources::Resource
  # @return [Resource] a new instance of Resource
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1178
  def initialize(entities, api_only, shallow, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1203
  def actions; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1211
  def available_actions; end

  # Checks for uncountable plurals, and appends "_index" if the plural and
  # singular form are the same.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1235
  def collection_name; end

  # Returns the value of attribute path.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def collection_scope; end

  # Returns the value of attribute controller.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def controller; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1195
  def default_actions; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1227
  def member_name; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1245
  def member_scope; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1219
  def name; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1255
  def nested_param; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1259
  def nested_scope; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1251
  def new_scope(new_path); end

  # Returns the value of attribute param.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def param; end

  # Returns the value of attribute path.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def path; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1223
  def plural; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1239
  def resource_scope; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1263
  def shallow?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1245
  def shallow_scope; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1267
  def singleton?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1227
  def singular; end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#1270
class ActionDispatch::Routing::Mapper::Resources::SingletonResource < ::ActionDispatch::Routing::Mapper::Resources::Resource
  # @return [SingletonResource] a new instance of SingletonResource
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1271
  def initialize(entities, api_only, shallow, options); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1290
  def collection_name; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1278
  def default_actions; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1290
  def member_name; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def member_scope; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1176
  def nested_scope; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1286
  def plural; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1300
  def singleton?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1290
  def singular; end
end

# CANONICAL_ACTIONS holds all actions that does not need a prefix or a path
# appended since they fit properly in their scope level.
#
# source://actionpack//lib/action_dispatch/routing/mapper.rb#1171
ActionDispatch::Routing::Mapper::Resources::VALID_ON_OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2259
class ActionDispatch::Routing::Mapper::Scope
  include ::Enumerable

  # @return [Scope] a new instance of Scope
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2269
  def initialize(hash, parent = T.unsafe(nil), scope_level = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2328
  def [](key); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2295
  def action_name(name_prefix, prefix, collection_name, member_name); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2335
  def each; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2343
  def frame; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2275
  def nested?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2320
  def new(hash); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2324
  def new_level(level); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2279
  def null?; end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2316
  def options; end

  # Returns the value of attribute parent.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2267
  def parent; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2291
  def resource_method_scope?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2312
  def resource_scope?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2287
  def resources?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2283
  def root?; end

  # Returns the value of attribute scope_level.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#2267
  def scope_level; end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2345
ActionDispatch::Routing::Mapper::Scope::NULL = T.let(T.unsafe(nil), ActionDispatch::Routing::Mapper::Scope)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2260
ActionDispatch::Routing::Mapper::Scope::OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2265
ActionDispatch::Routing::Mapper::Scope::RESOURCE_METHOD_SCOPES = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#2264
ActionDispatch::Routing::Mapper::Scope::RESOURCE_SCOPES = T.let(T.unsafe(nil), Array)

# You may wish to organize groups of controllers under a namespace. Most
# commonly, you might group a number of administrative controllers under an
# `admin` namespace. You would place these controllers under the
# `app/controllers/admin` directory, and you can group them together in your
# router:
#
#     namespace "admin" do
#       resources :posts, :comments
#     end
#
# This will create a number of routes for each of the posts and comments
# controller. For `Admin::PostsController`, Rails will create:
#
#     GET       /admin/posts
#     GET       /admin/posts/new
#     POST      /admin/posts
#     GET       /admin/posts/1
#     GET       /admin/posts/1/edit
#     PATCH/PUT /admin/posts/1
#     DELETE    /admin/posts/1
#
# If you want to route /posts (without the prefix /admin) to
# `Admin::PostsController`, you could use
#
#     scope module: "admin" do
#       resources :posts
#     end
#
# or, for a single case
#
#     resources :posts, module: "admin"
#
# If you want to route /admin/posts to `PostsController` (without the `Admin::`
# module prefix), you could use
#
#     scope "/admin" do
#       resources :posts
#     end
#
# or, for a single case
#
#     resources :posts, path: "/admin/posts"
#
# In each of these cases, the named routes remain the same as if you did not use
# scope. In the last case, the following paths map to `PostsController`:
#
#     GET       /admin/posts
#     GET       /admin/posts/new
#     POST      /admin/posts
#     GET       /admin/posts/1
#     GET       /admin/posts/1/edit
#     PATCH/PUT /admin/posts/1
#     DELETE    /admin/posts/1
#
# source://actionpack//lib/action_dispatch/routing/mapper.rb#838
module ActionDispatch::Routing::Mapper::Scoping
  # ### Parameter Restriction
  # Allows you to constrain the nested routes based on a set of rules. For
  # instance, in order to change the routes to allow for a dot character in the
  # `id` parameter:
  #
  #     constraints(id: /\d+\.\d+/) do
  #       resources :posts
  #     end
  #
  # Now routes such as `/posts/1` will no longer be valid, but `/posts/1.1` will
  # be. The `id` parameter must match the constraint passed in for this example.
  #
  # You may use this to also restrict other parameters:
  #
  #     resources :posts do
  #       constraints(post_id: /\d+\.\d+/) do
  #         resources :comments
  #       end
  #     end
  #
  # ### Restricting based on IP
  #
  # Routes can also be constrained to an IP or a certain range of IP addresses:
  #
  #     constraints(ip: /192\.168\.\d+\.\d+/) do
  #       resources :posts
  #     end
  #
  # Any user connecting from the 192.168.* range will be able to see this
  # resource, where as any user connecting outside of this range will be told
  # there is no such route.
  #
  # ### Dynamic request matching
  #
  # Requests to routes can be constrained based on specific criteria:
  #
  #     constraints(-> (req) { /iPhone/.match?(req.env["HTTP_USER_AGENT"]) }) do
  #       resources :iphones
  #     end
  #
  # You are able to move this logic out into a class if it is too complex for
  # routes. This class must have a `matches?` method defined on it which either
  # returns `true` if the user should be given access to that route, or `false` if
  # the user should not.
  #
  #     class Iphone
  #       def self.matches?(request)
  #         /iPhone/.match?(request.env["HTTP_USER_AGENT"])
  #       end
  #     end
  #
  # An expected place for this code would be `lib/constraints`.
  #
  # This class is then used like this:
  #
  #     constraints(Iphone) do
  #       resources :iphones
  #     end
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1046
  def constraints(constraints = T.unsafe(nil), &block); end

  # Scopes routes to a specific controller
  #
  #     controller "food" do
  #       match "bacon", action: :bacon, via: :get
  #     end
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#928
  def controller(controller); end

  # Allows you to set default parameters for a route, such as this:
  #     defaults id: 'home' do
  #       match 'scoped_pages/(:id)', to: 'pages#show'
  #     end
  #
  # Using this, the `:id` parameter here will default to 'home'.
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1056
  def defaults(defaults = T.unsafe(nil)); end

  # Scopes routes to a specific namespace. For example:
  #
  #     namespace :admin do
  #       resources :posts
  #     end
  #
  # This generates the following routes:
  #
  #         admin_posts GET       /admin/posts(.:format)          admin/posts#index
  #         admin_posts POST      /admin/posts(.:format)          admin/posts#create
  #      new_admin_post GET       /admin/posts/new(.:format)      admin/posts#new
  #     edit_admin_post GET       /admin/posts/:id/edit(.:format) admin/posts#edit
  #          admin_post GET       /admin/posts/:id(.:format)      admin/posts#show
  #          admin_post PATCH/PUT /admin/posts/:id(.:format)      admin/posts#update
  #          admin_post DELETE    /admin/posts/:id(.:format)      admin/posts#destroy
  #
  # ### Options
  #
  # The `:path`, `:as`, `:module`, `:shallow_path`, and `:shallow_prefix` options
  # all default to the name of the namespace.
  #
  # For options, see `Base#match`. For `:shallow_path` option, see
  # `Resources#resources`.
  #
  #     # accessible through /sekret/posts rather than /admin/posts
  #     namespace :admin, path: "sekret" do
  #       resources :posts
  #     end
  #
  #     # maps to +Sekret::PostsController+ rather than +Admin::PostsController+
  #     namespace :admin, module: "sekret" do
  #       resources :posts
  #     end
  #
  #     # generates +sekret_posts_path+ rather than +admin_posts_path+
  #     namespace :admin, as: "sekret" do
  #       resources :posts
  #     end
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#973
  def namespace(path, options = T.unsafe(nil), &block); end

  # Scopes a set of routes to the given default options.
  #
  # Take the following route definition as an example:
  #
  #     scope path: ":account_id", as: "account" do
  #       resources :projects
  #     end
  #
  # This generates helpers such as `account_projects_path`, just like `resources`
  # does. The difference here being that the routes generated are like
  # /:account_id/projects, rather than /accounts/:account_id/projects.
  #
  # ### Options
  #
  # Takes same options as `Base#match` and `Resources#resources`.
  #
  #     # route /posts (without the prefix /admin) to +Admin::PostsController+
  #     scope module: "admin" do
  #       resources :posts
  #     end
  #
  #     # prefix the posts resource's requests with '/admin'
  #     scope path: "/admin" do
  #       resources :posts
  #     end
  #
  #     # prefix the routing helper name: +sekret_posts_path+ instead of +posts_path+
  #     scope as: "sekret" do
  #       resources :posts
  #     end
  #
  # source://actionpack//lib/action_dispatch/routing/mapper.rb#869
  def scope(*args); end

  private

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1088
  def merge_action_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1072
  def merge_as_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1112
  def merge_blocks_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1104
  def merge_constraints_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1084
  def merge_controller_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1108
  def merge_defaults_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1096
  def merge_format_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1080
  def merge_module_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1118
  def merge_options_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1100
  def merge_path_names_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1064
  def merge_path_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1068
  def merge_shallow_path_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1076
  def merge_shallow_prefix_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1122
  def merge_shallow_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1126
  def merge_to_scope(parent, child); end

  # source://actionpack//lib/action_dispatch/routing/mapper.rb#1092
  def merge_via_scope(parent, child); end
end

# source://actionpack//lib/action_dispatch/routing/mapper.rb#921
ActionDispatch::Routing::Mapper::Scoping::POISON = T.let(T.unsafe(nil), Object)

# source://actionpack//lib/action_dispatch/routing/mapper.rb#24
ActionDispatch::Routing::Mapper::URL_OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/redirection.rb#114
class ActionDispatch::Routing::OptionRedirect < ::ActionDispatch::Routing::Redirect
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#143
  def inspect; end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#13
  def options; end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#117
  def path(params, request); end
end

# source://actionpack//lib/action_dispatch/routing/redirection.rb#89
class ActionDispatch::Routing::PathRedirect < ::ActionDispatch::Routing::Redirect
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#104
  def inspect; end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#92
  def path(params, request); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#109
  def interpolation_required?(string, params); end
end

# source://actionpack//lib/action_dispatch/routing/redirection.rb#90
ActionDispatch::Routing::PathRedirect::URL_PARTS = T.let(T.unsafe(nil), Regexp)

# # Action Dispatch Routing PolymorphicRoutes
#
# Polymorphic URL helpers are methods for smart resolution to a named route call
# when given an Active Record model instance. They are to be used in combination
# with ActionController::Resources.
#
# These methods are useful when you want to generate the correct URL or path to
# a RESTful resource without having to know the exact type of the record in
# question.
#
# Nested resources and/or namespaces are also supported, as illustrated in the
# example:
#
#     polymorphic_url([:admin, @article, @comment])
#
# results in:
#
#     admin_article_comment_url(@article, @comment)
#
# ## Usage within the framework
#
# Polymorphic URL helpers are used in a number of places throughout the Rails
# framework:
#
# *   `url_for`, so you can use it with a record as the argument, e.g.
#     `url_for(@article)`;
# *   ActionView::Helpers::FormHelper uses `polymorphic_path`, so you can write
#     `form_for(@article)` without having to specify `:url` parameter for the
#     form action;
# *   `redirect_to` (which, in fact, uses `url_for`) so you can write
#     `redirect_to(post)` in your controllers;
# *   ActionView::Helpers::AtomFeedHelper, so you don't have to explicitly
#     specify URLs for feed entries.
#
#
# ## Prefixed polymorphic helpers
#
# In addition to `polymorphic_url` and `polymorphic_path` methods, a number of
# prefixed helpers are available as a shorthand to `action: "..."` in options.
# Those are:
#
# *   `edit_polymorphic_url`, `edit_polymorphic_path`
# *   `new_polymorphic_url`, `new_polymorphic_path`
#
#
# Example usage:
#
#     edit_polymorphic_path(@post)           # => "/posts/1/edit"
#     polymorphic_path(@post, format: :pdf)  # => "/posts/1.pdf"
#
# ## Usage with mounted engines
#
# If you are using a mounted engine and you need to use a polymorphic_url
# pointing at the engine's routes, pass in the engine's route proxy as the first
# argument to the method. For example:
#
#     polymorphic_url([blog, @post])  # calls blog.post_path(@post)
#     form_for([blog, @post])         # => "/blog/posts/1"
#
# source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#66
module ActionDispatch::Routing::PolymorphicRoutes
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#162
  def edit_polymorphic_path(record_or_hash, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#158
  def edit_polymorphic_url(record_or_hash, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#162
  def new_polymorphic_path(record_or_hash, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#158
  def new_polymorphic_url(record_or_hash, options = T.unsafe(nil)); end

  # Returns the path component of a URL for the given record.
  #
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#133
  def polymorphic_path(record_or_hash_or_array, options = T.unsafe(nil)); end

  # Constructs a call to a named RESTful route for the given record and returns
  # the resulting URL string. For example:
  #
  #     # calls post_url(post)
  #     polymorphic_url(post) # => "http://example.com/posts/1"
  #     polymorphic_url([blog, post]) # => "http://example.com/blogs/1/posts/1"
  #     polymorphic_url([:admin, blog, post]) # => "http://example.com/admin/blogs/1/posts/1"
  #     polymorphic_url([user, :blog, post]) # => "http://example.com/users/1/blog/posts/1"
  #     polymorphic_url(Comment) # => "http://example.com/comments"
  #
  # #### Options
  #
  # *   `:action` - Specifies the action prefix for the named route: `:new` or
  #     `:edit`. Default is no prefix.
  # *   `:routing_type` - Allowed values are `:path` or `:url`. Default is `:url`.
  #
  #
  # Also includes all the options from `url_for`. These include such things as
  # `:anchor` or `:trailing_slash`. Example usage is given below:
  #
  #     polymorphic_url([blog, post], anchor: 'my_anchor')
  #       # => "http://example.com/blogs/1/posts/1#my_anchor"
  #     polymorphic_url([blog, post], anchor: 'my_anchor', script_name: "/my_app")
  #       # => "http://example.com/my_app/blogs/1/posts/1#my_anchor"
  #
  # For all of these options, see the documentation for
  # [url_for](rdoc-ref:ActionDispatch::Routing::UrlFor).
  #
  # #### Functionality
  #
  #     # an Article record
  #     polymorphic_url(record)  # same as article_url(record)
  #
  #     # a Comment record
  #     polymorphic_url(record)  # same as comment_url(record)
  #
  #     # it recognizes new records and maps to the collection
  #     record = Comment.new
  #     polymorphic_url(record)  # same as comments_url()
  #
  #     # the class of a record will also map to the collection
  #     polymorphic_url(Comment) # same as comments_url()
  #
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#110
  def polymorphic_url(record_or_hash_or_array, options = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#177
  def polymorphic_mapping(record); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#173
  def polymorphic_path_for_action(action, record_or_hash, options); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#169
  def polymorphic_url_for_action(action, record_or_hash, options); end
end

# source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#185
class ActionDispatch::Routing::PolymorphicRoutes::HelperMethodBuilder
  # @return [HelperMethodBuilder] a new instance of HelperMethodBuilder
  #
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#248
  def initialize(key_strategy, prefix, suffix); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#262
  def handle_class(klass); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#266
  def handle_class_call(target, klass); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#293
  def handle_list(list); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#270
  def handle_model(record); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#284
  def handle_model_call(target, record); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#254
  def handle_string(record); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#258
  def handle_string_call(target, str); end

  # Returns the value of attribute prefix.
  #
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#246
  def prefix; end

  # Returns the value of attribute suffix.
  #
  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#246
  def suffix; end

  private

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#347
  def get_method_for_class(klass); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#352
  def get_method_for_string(str); end

  # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#339
  def polymorphic_mapping(target, record); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#196
    def build(action, type); end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#188
    def get(action, type); end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#194
    def path; end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#210
    def plural(prefix, suffix); end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#214
    def polymorphic_method(recipient, record_or_hash_or_array, action, type, options); end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#206
    def singular(prefix, suffix); end

    # source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#193
    def url; end
  end
end

# source://actionpack//lib/action_dispatch/routing/polymorphic_routes.rb#186
ActionDispatch::Routing::PolymorphicRoutes::HelperMethodBuilder::CACHE = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/routing/redirection.rb#12
class ActionDispatch::Routing::Redirect < ::ActionDispatch::Routing::Endpoint
  # @return [Redirect] a new instance of Redirect
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#15
  def initialize(status, block); end

  # Returns the value of attribute block.
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#13
  def block; end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#35
  def build_response(req); end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#22
  def call(env); end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#67
  def inspect; end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#63
  def path(params, request); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#20
  def redirect?; end

  # Returns the value of attribute status.
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#13
  def status; end

  private

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#76
  def escape(params); end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#80
  def escape_fragment(params); end

  # source://actionpack//lib/action_dispatch/routing/redirection.rb#84
  def escape_path(params); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#72
  def relative_path?(path); end
end

# source://actionpack//lib/action_dispatch/routing/redirection.rb#148
module ActionDispatch::Routing::Redirection
  # Redirect any path to another path:
  #
  #     get "/stories" => redirect("/posts")
  #
  # This will redirect the user, while ignoring certain parts of the request,
  # including query string, etc. `/stories`, `/stories?foo=bar`, etc all redirect
  # to `/posts`.
  #
  # The redirect will use a `301 Moved Permanently` status code by default. This
  # can be overridden with the `:status` option:
  #
  #     get "/stories" => redirect("/posts", status: 307)
  #
  # You can also use interpolation in the supplied redirect argument:
  #
  #     get 'docs/:article', to: redirect('/wiki/%{article}')
  #
  # Note that if you return a path without a leading slash then the URL is
  # prefixed with the current SCRIPT_NAME environment variable. This is typically
  # '/' but may be different in a mounted engine or where the application is
  # deployed to a subdirectory of a website.
  #
  # Alternatively you can use one of the other syntaxes:
  #
  # The block version of redirect allows for the easy encapsulation of any logic
  # associated with the redirect in question. Either the params and request are
  # supplied as arguments, or just params, depending of how many arguments your
  # block accepts. A string is required as a return value.
  #
  #     get 'jokes/:number', to: redirect { |params, request|
  #       path = (params[:number].to_i.even? ? "wheres-the-beef" : "i-love-lamp")
  #       "http://#{request.host_with_port}/#{path}"
  #     }
  #
  # Note that the `do end` syntax for the redirect block wouldn't work, as Ruby
  # would pass the block to `get` instead of `redirect`. Use `{ ... }` instead.
  #
  # The options version of redirect allows you to supply only the parts of the URL
  # which need to change, it also supports interpolation of the path similar to
  # the first example.
  #
  #     get 'stores/:name',       to: redirect(subdomain: 'stores', path: '/%{name}')
  #     get 'stores/:name(*all)', to: redirect(subdomain: 'stores', path: '/%{name}%{all}')
  #     get '/stories', to: redirect(path: '/posts')
  #
  # This will redirect the user, while changing only the specified parts of the
  # request, for example the `path` option in the last example. `/stories`,
  # `/stories?foo=bar`, redirect to `/posts` and `/posts?foo=bar` respectively.
  #
  # Finally, an object which responds to call can be supplied to redirect,
  # allowing you to reuse common redirect routes. The call method must accept two
  # arguments, params and request, and return a string.
  #
  #     get 'accounts/:name' => redirect(SubdomainRedirector.new('api'))
  #
  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_dispatch/routing/redirection.rb#204
  def redirect(*args, &block); end
end

# The RouteSet contains a collection of Route instances, representing the routes
# typically defined in `config/routes.rb`.
#
# source://actionpack//lib/action_dispatch/routing/route_set.rb#17
class ActionDispatch::Routing::RouteSet
  # @return [RouteSet] a new instance of RouteSet
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#384
  def initialize(config = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#664
  def add_polymorphic_mapping(klass, options, &block); end

  # @raise [ArgumentError]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#633
  def add_route(mapping, name); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#668
  def add_url_helper(name, options, &block); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#415
  def api_only?; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#454
  def append(&block); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#893
  def call(env); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#478
  def clear!; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#428
  def default_env; end

  # Returns the value of attribute default_scope.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def default_scope; end

  # Sets the attribute default_scope
  #
  # @param value the value to set the attribute default_scope to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def default_scope=(_arg0); end

  # Returns the value of attribute default_url_options.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#356
  def default_url_options; end

  # Sets the attribute default_url_options
  #
  # @param value the value to set the attribute default_url_options to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#356
  def default_url_options=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#499
  def define_mounted_helper(name, script_namer = T.unsafe(nil)); end

  # Returns the value of attribute disable_clear_and_finalize.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#355
  def disable_clear_and_finalize; end

  # Sets the attribute disable_clear_and_finalize
  #
  # @param value the value to set the attribute disable_clear_and_finalize to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#355
  def disable_clear_and_finalize=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#447
  def draw(&block); end

  # Returns the value of attribute draw_paths.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#356
  def draw_paths; end

  # Sets the attribute draw_paths
  #
  # @param value the value to set the attribute draw_paths to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#356
  def draw_paths=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#404
  def eager_load!; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#629
  def empty?; end

  # Returns the value of attribute env_key.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#357
  def env_key; end

  # Generate the path indicated by the arguments, and return an array of the keys
  # that were not used to generate it.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#808
  def extra_keys(options, recall = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#472
  def finalize!; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#836
  def find_script_name(options); end

  # Returns the value of attribute formatter.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def formatter; end

  # Sets the attribute formatter
  #
  # @param value the value to set the attribute formatter to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def formatter=(_arg0); end

  # Returns a Route matching the given requirements, or `nil` if none are found.
  #
  # This is intended for use by tools such as Language Servers.
  #
  # Given the routes are defined as:
  #
  #   resources :posts
  #
  # Then the following will return the Route for the `show` action:
  #
  #   Rails.application.routes.from_requirements(controller: "posts", action: "show")
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#29
  def from_requirements(requirements); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#812
  def generate_extras(options, recall = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#526
  def generate_url_helpers(supports_path); end

  # Since the router holds references to many parts of the system like engines,
  # controllers and the application itself, inspecting the route set can actually
  # be really slow, therefore we default alias inspect to to_s.
  def inspect; end

  # Contains all the mounted helpers across different engines and the `main_app`
  # helper for the application. You can include this in your classes if you want
  # to access routes for other engines.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#495
  def mounted_helpers; end

  # Returns the value of attribute named_routes.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def named_routes; end

  # Sets the attribute named_routes
  #
  # @param value the value to set the attribute named_routes to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def named_routes=(_arg0); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#832
  def optimize_routes_generation?; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#840
  def path_for(options, route_name = T.unsafe(nil), reserved = T.unsafe(nil)); end

  # Returns the value of attribute polymorphic_mappings.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#357
  def polymorphic_mappings; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#458
  def prepend(&block); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#899
  def recognize_path(path, environment = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#914
  def recognize_path_with_request(req, path, extras, raise_on_missing: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#411
  def relative_url_root; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#419
  def request_class; end

  # Returns the value of attribute resources_path_names.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#355
  def resources_path_names; end

  # Sets the attribute resources_path_names
  #
  # @param value the value to set the attribute resources_path_names to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#355
  def resources_path_names=(_arg0); end

  # Returns the value of attribute router.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def router; end

  # Sets the attribute router
  #
  # @param value the value to set the attribute router to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def router=(_arg0); end

  # Returns the value of attribute set.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def routes; end

  # Returns the value of attribute set.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def set; end

  # Sets the attribute set
  #
  # @param value the value to set the attribute set to.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#354
  def set=(_arg0); end

  # The `options` argument must be a hash whose keys are **symbols**.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#845
  def url_for(options, route_name = T.unsafe(nil), url_strategy = T.unsafe(nil), method_name = T.unsafe(nil), reserved = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#518
  def url_helpers(supports_path = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#462
  def eval_block(block); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#823
  def generate(route_name, options, recall = T.unsafe(nil), method_name = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#423
  def make_request(env); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/route_set.rb#361
    def default_resources_path_names; end

    # source://actionpack//lib/action_dispatch/routing/route_set.rb#365
    def new_with_config(config); end
  end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#380
class ActionDispatch::Routing::RouteSet::Config < ::Struct
  # Returns the value of attribute api_only
  #
  # @return [Object] the current value of api_only
  def api_only; end

  # Sets the attribute api_only
  #
  # @param value [Object] the value to set the attribute api_only to.
  # @return [Object] the newly set value
  def api_only=(_); end

  # Returns the value of attribute relative_url_root
  #
  # @return [Object] the current value of relative_url_root
  def relative_url_root; end

  # Sets the attribute relative_url_root
  #
  # @param value [Object] the value to set the attribute relative_url_root to.
  # @return [Object] the newly set value
  def relative_url_root=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#672
class ActionDispatch::Routing::RouteSet::CustomUrlHelper
  # @return [CustomUrlHelper] a new instance of CustomUrlHelper
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#675
  def initialize(name, defaults, &block); end

  # Returns the value of attribute block.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#673
  def block; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#681
  def call(t, args, only_path = T.unsafe(nil)); end

  # Returns the value of attribute defaults.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#673
  def defaults; end

  # Returns the value of attribute name.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#673
  def name; end

  private

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#693
  def eval_block(t, args, options); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#697
  def merge_defaults(options); end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#382
ActionDispatch::Routing::RouteSet::DEFAULT_CONFIG = T.let(T.unsafe(nil), ActionDispatch::Routing::RouteSet::Config)

# source://actionpack//lib/action_dispatch/routing/route_set.rb#39
class ActionDispatch::Routing::RouteSet::Dispatcher < ::ActionDispatch::Routing::Endpoint
  # @return [Dispatcher] a new instance of Dispatcher
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#40
  def initialize(raise_on_name_error); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#44
  def dispatcher?; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#46
  def serve(req); end

  private

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#60
  def controller(req); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#66
  def dispatch(controller, action, req, res); end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#702
class ActionDispatch::Routing::RouteSet::Generator
  # @return [Generator] a new instance of Generator
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#705
  def initialize(named_route, options, recall, set); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#717
  def controller; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#721
  def current_controller; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#791
  def different_controller?; end

  # Generates a path from routes, returns a RouteWithParams or MissingRoute.
  # MissingRoute will raise ActionController::UrlGenerationError.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#787
  def generate; end

  # Returns the value of attribute named_route.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#703
  def named_route; end

  # Remove leading slashes from controllers
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#775
  def normalize_controller!; end

  # This pulls :controller, :action, and :id out of the recall. The recall key is
  # only used if there is no key in the options or if the key in the options is
  # identical. If any of :controller, :action or :id is not found, don't pull any
  # more keys from the recall.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#757
  def normalize_controller_action_id!; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#733
  def normalize_options!; end

  # Returns the value of attribute options.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#703
  def options; end

  # Returns the value of attribute recall.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#703
  def recall; end

  # Returns the value of attribute set.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#703
  def set; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#725
  def use_recall_for(key); end

  # if the current controller is "foo/bar/baz" and controller: "baz/bat" is
  # specified, the controller becomes "foo/baz/bat"
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#765
  def use_relative_controller!; end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#797
  def named_route_exists?; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#801
  def segment_keys; end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#487
module ActionDispatch::Routing::RouteSet::MountedHelpers
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActionDispatch::Routing::UrlFor

  mixes_in_class_methods GeneratedClassMethods

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

# A NamedRouteCollection instance is a collection of named routes, and also
# maintains an anonymous module that can be used to install helpers for the
# named routes.
#
# source://actionpack//lib/action_dispatch/routing/route_set.rb#84
class ActionDispatch::Routing::RouteSet::NamedRouteCollection
  include ::Enumerable

  # @return [NamedRouteCollection] a new instance of NamedRouteCollection
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#89
  def initialize; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#139
  def [](name); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#120
  def []=(name, route); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#120
  def add(name, route); end

  # Given a `name`, defines name_path and name_url helpers. Used by 'direct',
  # 'resolve', and 'polymorphic' route helpers.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#167
  def add_url_helper(name, defaults, &block); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#106
  def clear; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#106
  def clear!; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#152
  def each(&block); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#139
  def get(name); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#102
  def helper_names; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#143
  def key?(name); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#161
  def length; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#157
  def names; end

  # Returns the value of attribute path_helpers_module.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#86
  def path_helpers_module; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#97
  def route_defined?(name); end

  # Returns the value of attribute url_helpers_module.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#86
  def url_helpers_module; end

  private

  # Create a URL helper allowing ordered parameters to be associated with
  # corresponding dynamic segments, so you can do:
  #
  #     foo_url(bar, baz, bang)
  #
  # Instead of:
  #
  #     foo_url(bar: bar, baz: baz, bang: bang)
  #
  # Also allow options hash, so you can do:
  #
  #     foo_url(bar, baz, bang, sort_by: 'baz')
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#335
  def define_url_helper(mod, name, helper, url_strategy); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#86
  def routes; end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#190
class ActionDispatch::Routing::RouteSet::NamedRouteCollection::UrlHelper
  # @return [UrlHelper] a new instance of UrlHelper
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#273
  def initialize(route, options, route_name); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#280
  def call(t, method_name, args, inner_options, url_strategy); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#292
  def handle_positional_args(controller_options, inner_options, args, result, path_params); end

  # Returns the value of attribute route_name.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#203
  def route_name; end

  class << self
    # source://actionpack//lib/action_dispatch/routing/route_set.rb#191
    def create(route, options, route_name); end

    # @return [Boolean]
    #
    # source://actionpack//lib/action_dispatch/routing/route_set.rb#199
    def optimize_helper?(route); end
  end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#205
class ActionDispatch::Routing::RouteSet::NamedRouteCollection::UrlHelper::OptimizedUrlHelper < ::ActionDispatch::Routing::RouteSet::NamedRouteCollection::UrlHelper
  # @return [OptimizedUrlHelper] a new instance of OptimizedUrlHelper
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#208
  def initialize(route, options, route_name); end

  # Returns the value of attribute arg_size.
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#206
  def arg_size; end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#214
  def call(t, method_name, args, inner_options, url_strategy); end

  private

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#245
  def optimize_routes_generation?(t); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#237
  def optimized_helper(args); end

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#249
  def parameterize_args(args); end

  # @raise [ActionController::UrlGenerationError]
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#260
  def raise_generation_error(args); end
end

# strategy for building URLs to send to the client
#
# source://actionpack//lib/action_dispatch/routing/route_set.rb#351
ActionDispatch::Routing::RouteSet::PATH = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/routing/route_set.rb#828
ActionDispatch::Routing::RouteSet::RESERVED_OPTIONS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/routing/route_set.rb#71
class ActionDispatch::Routing::RouteSet::StaticDispatcher < ::ActionDispatch::Routing::RouteSet::Dispatcher
  # @return [StaticDispatcher] a new instance of StaticDispatcher
  #
  # source://actionpack//lib/action_dispatch/routing/route_set.rb#72
  def initialize(controller_class); end

  private

  # source://actionpack//lib/action_dispatch/routing/route_set.rb#78
  def controller(_); end
end

# source://actionpack//lib/action_dispatch/routing/route_set.rb#352
ActionDispatch::Routing::RouteSet::UNKNOWN = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/routing/inspector.rb#10
class ActionDispatch::Routing::RouteWrapper < ::SimpleDelegator
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#56
  def action; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#28
  def constraints; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#52
  def controller; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#17
  def endpoint; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#64
  def engine?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#60
  def internal?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#11
  def matches_filter?(filter, value); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#40
  def name; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#36
  def path; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#32
  def rack_app; end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#44
  def reqs; end
end

# This class is just used for displaying route information when someone
# executes `bin/rails routes` or looks at the RoutingError page. People should
# not use this class.
#
# source://actionpack//lib/action_dispatch/routing/inspector.rb#73
class ActionDispatch::Routing::RoutesInspector
  # @return [RoutesInspector] a new instance of RoutesInspector
  #
  # source://actionpack//lib/action_dispatch/routing/inspector.rb#74
  def initialize(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#79
  def format(formatter, filter = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#143
  def collect_engine_routes(route); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#129
  def collect_routes(routes); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#118
  def filter_routes(filter); end

  # source://actionpack//lib/action_dispatch/routing/inspector.rb#99
  def normalize_filter(filter); end
end

# source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#9
class ActionDispatch::Routing::RoutesProxy
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor

  # @return [RoutesProxy] a new instance of RoutesProxy
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#15
  def initialize(routes, scope, helpers, script_namer = T.unsafe(nil)); end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#12
  def _routes; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
  def default_url_options?; end

  # Returns the value of attribute routes.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#12
  def routes; end

  # Sets the attribute routes
  #
  # @param value the value to set the attribute routes to.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#12
  def routes=(_arg0); end

  # Returns the value of attribute scope.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#12
  def scope; end

  # Sets the attribute scope
  #
  # @param value the value to set the attribute scope to.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#12
  def scope=(_arg0); end

  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#21
  def url_options; end

  private

  # Keeps the part of the script name provided by the global context via
  # [ENV]("SCRIPT_NAME"), which `mount` doesn't know about since it depends on the
  # specific request, but use our script name resolver for the mount point
  # dependent part.
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#55
  def merge_script_names(previous_script_name, new_script_name); end

  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#32
  def method_missing(method, *args); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/routes_proxy.rb#28
  def respond_to_missing?(method, _); end

  class << self
    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options; end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options=(value); end

    # source://actionpack//lib/action_dispatch/routing/url_for.rb#100
    def default_url_options?; end
  end
end

# source://actionpack//lib/action_dispatch/routing.rb#259
ActionDispatch::Routing::SEPARATORS = T.let(T.unsafe(nil), Array)

# # Action Dispatch Routing UrlFor
#
# In `config/routes.rb` you define URL-to-controller mappings, but the reverse
# is also possible: a URL can be generated from one of your routing definitions.
# URL generation functionality is centralized in this module.
#
# See ActionDispatch::Routing for general information about routing and
# `config/routes.rb`.
#
# **Tip:** If you need to generate URLs from your models or some other place,
# then ActionDispatch::Routing::UrlFor is what you're looking for. Read on for
# an introduction. In general, this module should not be included on its own, as
# it is usually included by `url_helpers` (as in
# `Rails.application.routes.url_helpers`).
#
# ## URL generation from parameters
#
# As you may know, some functions, such as `ActionController::Base#url_for` and
# ActionView::Helpers::UrlHelper#link_to, can generate URLs given a set of
# parameters. For example, you've probably had the chance to write code like
# this in one of your views:
#
#     <%= link_to('Click here', controller: 'users',
#             action: 'new', message: 'Welcome!') %>
#     # => <a href="/users/new?message=Welcome%21">Click here</a>
#
# `link_to`, and all other functions that require URL generation functionality,
# actually use ActionDispatch::Routing::UrlFor under the hood. And in
# particular, they use the ActionDispatch::Routing::UrlFor#url_for method. One
# can generate the same path as the above example by using the following code:
#
#     include ActionDispatch::Routing::UrlFor
#     url_for(controller: 'users',
#             action: 'new',
#             message: 'Welcome!',
#             only_path: true)
#     # => "/users/new?message=Welcome%21"
#
# Notice the `only_path: true` part. This is because UrlFor has no information
# about the website hostname that your Rails app is serving. So if you want to
# include the hostname as well, then you must also pass the `:host` argument:
#
#     include UrlFor
#     url_for(controller: 'users',
#             action: 'new',
#             message: 'Welcome!',
#             host: 'www.example.com')
#     # => "http://www.example.com/users/new?message=Welcome%21"
#
# By default, all controllers and views have access to a special version of
# `url_for`, that already knows what the current hostname is. So if you use
# `url_for` in your controllers or your views, then you don't need to explicitly
# pass the `:host` argument.
#
# For convenience, mailers also include ActionDispatch::Routing::UrlFor. So
# within mailers, you can use url_for. However, mailers cannot access incoming
# web requests in order to derive hostname information, so you have to provide
# the `:host` option or set the default host using `default_url_options`. For
# more information on url_for in mailers see the ActionMailer::Base
# documentation.
#
# ## URL generation for named routes
#
# UrlFor also allows one to access methods that have been auto-generated from
# named routes. For example, suppose that you have a 'users' resource in your
# `config/routes.rb`:
#
#     resources :users
#
# This generates, among other things, the method `users_path`. By default, this
# method is accessible from your controllers, views, and mailers. If you need to
# access this auto-generated method from other places (such as a model), then
# you can do that by including `Rails.application.routes.url_helpers` in your
# class:
#
#     class User < ActiveRecord::Base
#       include Rails.application.routes.url_helpers
#
#       def base_uri
#         user_path(self)
#       end
#     end
#
#     User.find(1).base_uri # => "/users/1"
#
# source://actionpack//lib/action_dispatch/routing/url_for.rb#92
module ActionDispatch::Routing::UrlFor
  include ::ActionDispatch::Routing::PolymorphicRoutes
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#111
  def initialize(*_arg0, **_arg1, &_arg2); end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#182
  def full_url_for(options = T.unsafe(nil)); end

  # Allows calling direct or regular named route.
  #
  #     resources :buckets
  #
  #     direct :recordable do |recording|
  #       route_for(:bucket, recording.bucket)
  #     end
  #
  #     direct :threadable do |threadable|
  #       route_for(:recordable, threadable.parent)
  #     end
  #
  # This maintains the context of the original caller on whether to return a path
  # or full URL, e.g:
  #
  #     threadable_path(threadable)  # => "/buckets/1"
  #     threadable_url(threadable)   # => "http://example.com/buckets/1"
  #
  # source://actionpack//lib/action_dispatch/routing/url_for.rb#222
  def route_for(name, *args); end

  # Generate a URL based on the options provided, `default_url_options`, and the
  # routes defined in `config/routes.rb`. The following options are supported:
  #
  # *   `:only_path` - If true, the relative URL is returned. Defaults to `false`.
  # *   `:protocol` - The protocol to connect to. Defaults to `"http"`.
  # *   `:host` - Specifies the host the link should be targeted at. If
  #     `:only_path` is false, this option must be provided either explicitly, or
  #     via `default_url_options`.
  # *   `:subdomain` - Specifies the subdomain of the link, using the `tld_length`
  #     to split the subdomain from the host. If false, removes all subdomains
  #     from the host part of the link.
  # *   `:domain` - Specifies the domain of the link, using the `tld_length` to
  #     split the domain from the host.
  # *   `:tld_length` - Number of labels the TLD id composed of, only used if
  #     `:subdomain` or `:domain` are supplied. Defaults to
  #     `ActionDispatch::Http::URL.tld_length`, which in turn defaults to 1.
  # *   `:port` - Optionally specify the port to connect to.
  # *   `:anchor` - An anchor name to be appended to the path.
  # *   `:params` - The query parameters to be appended to the path.
  # *   `:path_params` - The query parameters that will only be used for the named
  #     dynamic segments of path. If unused, they will be discarded.
  # *   `:trailing_slash` - If true, adds a trailing slash, as in
  #     `"/archive/2009/"`.
  # *   `:script_name` - Specifies application path relative to domain root. If
  #     provided, prepends application path.
  #
  #
  # Any other key (`:controller`, `:action`, etc.) given to `url_for` is forwarded
  # to the Routes module.
  #
  #     url_for controller: 'tasks', action: 'testing', host: 'somehost.org', port: '8080'
  #     # => 'http://somehost.org:8080/tasks/testing'
  #     url_for controller: 'tasks', action: 'testing', host: 'somehost.org', anchor: 'ok', only_path: true
  #     # => '/tasks/testing#ok'
  #     url_for controller: 'tasks', action: 'testing', trailing_slash: true
  #     # => 'http://somehost.org/tasks/testing/'
  #     url_for controller: 'tasks', action: 'testing', host: 'somehost.org', number: '33'
  #     # => 'http://somehost.org/tasks/testing?number=33'
  #     url_for controller: 'tasks', action: 'testing', host: 'somehost.org', script_name: "/myapp"
  #     # => 'http://somehost.org/myapp/tasks/testing'
  #     url_for controller: 'tasks', action: 'testing', host: 'somehost.org', script_name: "/myapp", only_path: true
  #     # => '/myapp/tasks/testing'
  #
  # Missing routes keys may be filled in from the current request's parameters
  # (e.g. `:controller`, `:action`, `:id`, and any other parameters that are
  # placed in the path). Given that the current action has been reached through
  # `GET /users/1`:
  #
  #     url_for(only_path: true)                        # => '/users/1'
  #     url_for(only_path: true, action: 'edit')        # => '/users/1/edit'
  #     url_for(only_path: true, action: 'edit', id: 2) # => '/users/2/edit'
  #
  # Notice that no `:id` parameter was provided to the first `url_for` call and
  # the helper used the one from the route's path. Any path parameter implicitly
  # used by `url_for` can always be overwritten like shown on the last `url_for`
  # calls.
  #
  # source://actionpack//lib/action_dispatch/routing/url_for.rb#178
  def url_for(options = T.unsafe(nil)); end

  # Hook overridden in controller to add request information with
  # `default_url_options`. Application logic should not go into url_options.
  #
  # source://actionpack//lib/action_dispatch/routing/url_for.rb#118
  def url_options; end

  protected

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/routing/url_for.rb#227
  def optimize_routes_generation?; end

  private

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#239
  def _routes_context; end

  # source://actionpack//lib/action_dispatch/routing/url_for.rb#232
  def _with_routes(routes); end

  module GeneratedClassMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end

  module GeneratedInstanceMethods
    def default_url_options; end
    def default_url_options=(value); end
    def default_url_options?; end
  end
end

# # Action Dispatch SSL
#
# This middleware is added to the stack when `config.force_ssl = true`, and is
# passed the options set in `config.ssl_options`. It does three jobs to enforce
# secure HTTP requests:
#
# 1.  **TLS redirect**: Permanently redirects `http://` requests to `https://`
#     with the same URL host, path, etc. Enabled by default. Set
#     `config.ssl_options` to modify the destination URL (e.g. `redirect: {
#     host: "secure.widgets.com", port: 8080 }`), or set `redirect: false` to
#     disable this feature.
#
#     Requests can opt-out of redirection with `exclude`:
#
#         config.ssl_options = { redirect: { exclude: -> request { /healthcheck/.match?(request.path) } } }
#
#     Cookies will not be flagged as secure for excluded requests.
#
# 2.  **Secure cookies**: Sets the `secure` flag on cookies to tell browsers
#     they must not be sent along with `http://` requests. Enabled by default.
#     Set `config.ssl_options` with `secure_cookies: false` to disable this
#     feature.
#
# 3.  **HTTP Strict Transport Security (HSTS)**: Tells the browser to remember
#     this site as TLS-only and automatically redirect non-TLS requests. Enabled
#     by default. Configure `config.ssl_options` with `hsts: false` to disable.
#
#     Set `config.ssl_options` with `hsts: { ... }` to configure HSTS:
#
#     *   `expires`: How long, in seconds, these settings will stick. The
#         minimum required to qualify for browser preload lists is 1 year.
#         Defaults to 2 years (recommended).
#
#     *   `subdomains`: Set to `true` to tell the browser to apply these
#         settings to all subdomains. This protects your cookies from
#         interception by a vulnerable site on a subdomain. Defaults to `true`.
#
#     *   `preload`: Advertise that this site may be included in browsers'
#         preloaded HSTS lists. HSTS protects your site on every visit *except
#         the first visit* since it hasn't seen your HSTS header yet. To close
#         this gap, browser vendors include a baked-in list of HSTS-enabled
#         sites. Go to https://hstspreload.org to submit your site for
#         inclusion. Defaults to `false`.
#
#
#     To turn off HSTS, omitting the header is not enough. Browsers will
#     remember the original HSTS directive until it expires. Instead, use the
#     header to tell browsers to expire HSTS immediately. Setting `hsts: false`
#     is a shortcut for `hsts: { expires: 0 }`.
#
# source://actionpack//lib/action_dispatch/middleware/ssl.rb#56
class ActionDispatch::SSL
  # @return [SSL] a new instance of SSL
  #
  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#66
  def initialize(app, redirect: T.unsafe(nil), hsts: T.unsafe(nil), secure_cookies: T.unsafe(nil), ssl_default_redirect_status: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#78
  def call(env); end

  private

  # https://tools.ietf.org/html/rfc6797#section-6.1
  #
  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#112
  def build_hsts_header(hsts); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#119
  def flag_cookies_as_secure!(headers); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#160
  def https_location_for(request); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#97
  def normalize_hsts_options(options); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#143
  def redirect_to_https(request); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#150
  def redirection_status(request); end

  # source://actionpack//lib/action_dispatch/middleware/ssl.rb#93
  def set_hsts_header!(headers); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/ssl.rb#62
    def default_hsts_options; end
  end
end

# :stopdoc: Default to 2 years as recommended on hstspreload.org.
#
# source://actionpack//lib/action_dispatch/middleware/ssl.rb#58
ActionDispatch::SSL::HSTS_EXPIRES_IN = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_dispatch/middleware/ssl.rb#60
ActionDispatch::SSL::PERMANENT_REDIRECT_REQUEST_METHODS = T.let(T.unsafe(nil), Array)

# source://actionpack//lib/action_dispatch/middleware/server_timing.rb#8
class ActionDispatch::ServerTiming
  # @return [ServerTiming] a new instance of ServerTiming
  #
  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#52
  def initialize(app); end

  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#58
  def call(env); end

  class << self
    # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#48
    def unsubscribe; end
  end
end

# source://actionpack//lib/action_dispatch/middleware/server_timing.rb#9
class ActionDispatch::ServerTiming::Subscriber
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # @return [Subscriber] a new instance of Subscriber
  #
  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#13
  def initialize; end

  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#17
  def call(event); end

  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#23
  def collect_events; end

  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#32
  def ensure_subscribed; end

  # source://actionpack//lib/action_dispatch/middleware/server_timing.rb#40
  def unsubscribe; end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/server_timing.rb#11
ActionDispatch::ServerTiming::Subscriber::KEY = T.let(T.unsafe(nil), Symbol)

# source://actionpack//lib/action_dispatch.rb#100
module ActionDispatch::Session
  class << self
    # source://actionpack//lib/action_dispatch.rb#107
    def resolve_store(session_store); end
  end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#97
class ActionDispatch::Session::AbstractSecureStore < ::Rack::Session::Abstract::PersistedSecure
  include ::ActionDispatch::Session::Compatibility
  include ::ActionDispatch::Session::StaleSessionCheck
  include ::ActionDispatch::Session::SessionObject

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#102
  def generate_sid; end

  private

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#107
  def set_cookie(request, response, cookie); end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#86
class ActionDispatch::Session::AbstractStore < ::Rack::Session::Abstract::Persisted
  include ::ActionDispatch::Session::Compatibility
  include ::ActionDispatch::Session::StaleSessionCheck
  include ::ActionDispatch::Session::SessionObject

  private

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#92
  def set_cookie(request, response, cookie); end
end

# # Action Dispatch Session CacheStore
#
# A session store that uses an ActiveSupport::Cache::Store to store the
# sessions. This store is most useful if you don't store critical data in your
# sessions and you don't need them to live for extended periods of time.
#
# #### Options
# *   `cache`         - The cache to use. If it is not specified, `Rails.cache`
#     will be used.
# *   `expire_after`  - The length of time a session will be stored before
#     automatically expiring. By default, the `:expires_in` option of the cache
#     is used.
#
# source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#22
class ActionDispatch::Session::CacheStore < ::ActionDispatch::Session::AbstractSecureStore
  # @return [CacheStore] a new instance of CacheStore
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#23
  def initialize(app, options = T.unsafe(nil)); end

  # Remove a session from the cache.
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#49
  def delete_session(env, sid, options); end

  # Get a session from the cache.
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#30
  def find_session(env, sid); end

  # Set a session in the cache.
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#38
  def write_session(env, sid, session, options); end

  private

  # Turn the session id into a cache key.
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#57
  def cache_key(id); end

  # source://actionpack//lib/action_dispatch/middleware/session/cache_store.rb#61
  def get_session_with_fallback(sid); end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#22
module ActionDispatch::Session::Compatibility
  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#23
  def initialize(app, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#28
  def generate_sid; end

  private

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#35
  def initialize_sid; end

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#40
  def make_request(env); end
end

# # Action Dispatch Session CookieStore
#
# This cookie-based session store is the Rails default. It is dramatically
# faster than the alternatives.
#
# Sessions typically contain at most a user ID and flash message; both fit
# within the 4096 bytes cookie size limit. A `CookieOverflow` exception is
# raised if you attempt to store more than 4096 bytes of data.
#
# The cookie jar used for storage is automatically configured to be the best
# possible option given your application's configuration.
#
# Your cookies will be encrypted using your application's `secret_key_base`.
# This goes a step further than signed cookies in that encrypted cookies cannot
# be altered or read by users. This is the default starting in Rails 4.
#
# Configure your session store in an initializer:
#
#     Rails.application.config.session_store :cookie_store, key: '_your_app_session'
#
# In the development and test environments your application's `secret_key_base`
# is generated by Rails and stored in a temporary file in
# `tmp/local_secret.txt`. In all other environments, it is stored encrypted in
# the `config/credentials.yml.enc` file.
#
# If your application was not updated to Rails 5.2 defaults, the
# `secret_key_base` will be found in the old `config/secrets.yml` file.
#
# Note that changing your `secret_key_base` will invalidate all existing
# session. Additionally, you should take care to make sure you are not relying
# on the ability to decode signed cookies generated by your app in external
# applications or JavaScript before changing it.
#
# Because CookieStore extends `Rack::Session::Abstract::Persisted`, many of the
# options described there can be used to customize the session cookie that is
# generated. For example:
#
#     Rails.application.config.session_store :cookie_store, expire_after: 14.days
#
# would set the session cookie to expire automatically 14 days after creation.
# Other useful options include `:key`, `:secure`, `:httponly`, and `:same_site`.
#
# source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#52
class ActionDispatch::Session::CookieStore < ::ActionDispatch::Session::AbstractSecureStore
  # @return [CookieStore] a new instance of CookieStore
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#64
  def initialize(app, options = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#70
  def delete_session(req, session_id, options); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#77
  def load_session(req); end

  private

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#124
  def cookie_jar(request); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#86
  def extract_session_id(req); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#120
  def get_cookie(req); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#105
  def persistent_session_id!(data, sid = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#116
  def set_cookie(request, session_id, cookie); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#93
  def unpacked_cookie_data(req); end

  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#111
  def write_session(req, sid, session_data, options); end
end

# source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#62
ActionDispatch::Session::CookieStore::DEFAULT_SAME_SITE = T.let(T.unsafe(nil), Proc)

# source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#53
class ActionDispatch::Session::CookieStore::SessionId
  # @return [SessionId] a new instance of SessionId
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#56
  def initialize(session_id, cookie_value = T.unsafe(nil)); end

  # Returns the value of attribute cookie_value.
  #
  # source://actionpack//lib/action_dispatch/middleware/session/cookie_store.rb#54
  def cookie_value; end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#71
module ActionDispatch::Session::SessionObject
  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#72
  def commit_session(req, res); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#81
  def loaded_session?(session); end

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#77
  def prepare_session(req); end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#13
class ActionDispatch::Session::SessionRestoreError < ::StandardError
  # @return [SessionRestoreError] a new instance of SessionRestoreError
  #
  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#14
  def initialize; end
end

# source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#45
module ActionDispatch::Session::StaleSessionCheck
  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#50
  def extract_session_id(env); end

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#46
  def load_session(env); end

  # source://actionpack//lib/action_dispatch/middleware/session/abstract_store.rb#54
  def stale_session_check!; end
end

# # Action Dispatch ShowExceptions
#
# This middleware rescues any exception returned by the application and calls an
# exceptions app that will wrap it in a format for the end user.
#
# The exceptions app should be passed as a parameter on initialization of
# `ShowExceptions`. Every time there is an exception, `ShowExceptions` will
# store the exception in `env["action_dispatch.exception"]`, rewrite the
# `PATH_INFO` to the exception status code, and call the Rack app.
#
# In Rails applications, the exceptions app can be configured with
# `config.exceptions_app`, which defaults to ActionDispatch::PublicExceptions.
#
# If the application returns a response with the `X-Cascade` header set to
# `"pass"`, this middleware will send an empty response as a result with the
# correct status code. If any exception happens inside the exceptions app, this
# middleware catches the exceptions and returns a failsafe response.
#
# source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#25
class ActionDispatch::ShowExceptions
  # @return [ShowExceptions] a new instance of ShowExceptions
  #
  # source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#26
  def initialize(app, exceptions_app); end

  # source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#31
  def call(env); end

  private

  # source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#67
  def fallback_to_html_format_if_invalid_mime_type(request); end

  # source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#83
  def pass_response(status); end

  # source://actionpack//lib/action_dispatch/middleware/show_exceptions.rb#48
  def render_exception(request, wrapper); end
end

# # Action Dispatch Static
#
# This middleware serves static files from disk, if available. If no file is
# found, it hands off to the main app.
#
# In Rails apps, this middleware is configured to serve assets from the
# `public/` directory.
#
# Only GET and HEAD requests are served. POST and other HTTP methods are handed
# off to the main app.
#
# Only files in the root directory are served; path traversal is denied.
#
# source://actionpack//lib/action_dispatch/middleware/static.rb#20
class ActionDispatch::Static
  # @return [Static] a new instance of Static
  #
  # source://actionpack//lib/action_dispatch/middleware/static.rb#21
  def initialize(app, path, index: T.unsafe(nil), headers: T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/middleware/static.rb#26
  def call(env); end
end

# source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#4
module ActionDispatch::TestHelpers; end

# source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#5
module ActionDispatch::TestHelpers::PageDumpHelper
  # Saves the content of response body to a file and tries to open it in your browser.
  # Launchy must be present in your Gemfile for the page to open automatically.
  #
  # source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#10
  def save_and_open_page(path = T.unsafe(nil)); end

  private

  # source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#30
  def html_dump_default_path; end

  # source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#23
  def open_file(path); end

  # @raise [InvalidResponse]
  #
  # source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#15
  def save_page(path = T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/testing/test_helpers/page_dump_helper.rb#6
class ActionDispatch::TestHelpers::PageDumpHelper::InvalidResponse < ::StandardError; end

# source://actionpack//lib/action_dispatch/testing/test_process.rb#9
module ActionDispatch::TestProcess
  include ::ActionDispatch::TestProcess::FixtureFile

  # @raise [NoMethodError]
  #
  # source://actionpack//lib/action_dispatch/testing/test_process.rb#35
  def assigns(key = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/testing/test_process.rb#49
  def cookies; end

  # source://actionpack//lib/action_dispatch/testing/test_process.rb#45
  def flash; end

  # source://actionpack//lib/action_dispatch/testing/test_process.rb#53
  def redirect_to_url; end

  # source://actionpack//lib/action_dispatch/testing/test_process.rb#41
  def session; end
end

# source://actionpack//lib/action_dispatch/testing/test_process.rb#10
module ActionDispatch::TestProcess::FixtureFile
  # Shortcut for
  # `Rack::Test::UploadedFile.new(File.join(ActionDispatch::IntegrationTest.file_f
  # ixture_path, path), type)`:
  #
  #     post :change_avatar, params: { avatar: file_fixture_upload('david.png', 'image/png') }
  #
  # Default fixture files location is `test/fixtures/files`.
  #
  # To upload binary files on Windows, pass `:binary` as the last parameter. This
  # will not affect other platforms:
  #
  #     post :change_avatar, params: { avatar: file_fixture_upload('david.png', 'image/png', :binary) }
  #
  # source://actionpack//lib/action_dispatch/testing/test_process.rb#23
  def file_fixture_upload(path, mime_type = T.unsafe(nil), binary = T.unsafe(nil)); end

  # Shortcut for
  # `Rack::Test::UploadedFile.new(File.join(ActionDispatch::IntegrationTest.file_f
  # ixture_path, path), type)`:
  #
  #     post :change_avatar, params: { avatar: file_fixture_upload('david.png', 'image/png') }
  #
  # Default fixture files location is `test/fixtures/files`.
  #
  # To upload binary files on Windows, pass `:binary` as the last parameter. This
  # will not affect other platforms:
  #
  #     post :change_avatar, params: { avatar: file_fixture_upload('david.png', 'image/png', :binary) }
  #
  # source://actionpack//lib/action_dispatch/testing/test_process.rb#23
  def fixture_file_upload(path, mime_type = T.unsafe(nil), binary = T.unsafe(nil)); end
end

# source://actionpack//lib/action_dispatch/testing/test_request.rb#9
class ActionDispatch::TestRequest < ::ActionDispatch::Request
  # source://actionpack//lib/action_dispatch/testing/test_request.rb#68
  def accept=(mime_types); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#48
  def action=(action_name); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#32
  def host=(host); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#52
  def if_modified_since=(last_modified); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#56
  def if_none_match=(etag); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#44
  def path=(path); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#36
  def port=(number); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#60
  def remote_addr=(addr); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#28
  def request_method=(method); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#40
  def request_uri=(uri); end

  # source://actionpack//lib/action_dispatch/testing/test_request.rb#64
  def user_agent=(user_agent); end

  class << self
    # Create a new test request with default `env` values.
    #
    # source://actionpack//lib/action_dispatch/testing/test_request.rb#17
    def create(env = T.unsafe(nil)); end

    private

    # source://actionpack//lib/action_dispatch/testing/test_request.rb#23
    def default_env; end
  end
end

# source://actionpack//lib/action_dispatch/testing/test_request.rb#10
ActionDispatch::TestRequest::DEFAULT_ENV = T.let(T.unsafe(nil), Hash)

# Integration test methods such as Integration::RequestHelpers#get and
# Integration::RequestHelpers#post return objects of class TestResponse, which
# represent the HTTP response results of the requested controller actions.
#
# See Response for more information on controller response objects.
#
# source://actionpack//lib/action_dispatch/testing/test_response.rb#13
class ActionDispatch::TestResponse < ::ActionDispatch::Response
  # Returns a parsed body depending on the response MIME type. When a parser
  # corresponding to the MIME type is not found, it returns the raw body.
  #
  # #### Examples
  #     get "/posts"
  #     response.content_type         # => "text/html; charset=utf-8"
  #     response.parsed_body.class    # => Nokogiri::HTML5::Document
  #     response.parsed_body.to_html  # => "<!DOCTYPE html>\n<html>\n..."
  #
  #     assert_pattern { response.parsed_body.at("main") => { content: "Hello, world" } }
  #
  #     response.parsed_body.at("main") => {name:, content:}
  #     assert_equal "main", name
  #     assert_equal "Some main content", content
  #
  #     get "/posts.json"
  #     response.content_type         # => "application/json; charset=utf-8"
  #     response.parsed_body.class    # => Array
  #     response.parsed_body          # => [{"id"=>42, "title"=>"Title"},...
  #
  #     assert_pattern { response.parsed_body => [{ id: 42 }] }
  #
  #     get "/posts/42.json"
  #     response.content_type         # => "application/json; charset=utf-8"
  #     response.parsed_body.class    # => ActiveSupport::HashWithIndifferentAccess
  #     response.parsed_body          # => {"id"=>42, "title"=>"Title"}
  #
  #     assert_pattern { response.parsed_body => [{ title: /title/i }] }
  #
  #     response.parsed_body => {id:, title:}
  #     assert_equal 42, id
  #     assert_equal "Title", title
  #
  # source://actionpack//lib/action_dispatch/testing/test_response.rb#50
  def parsed_body; end

  # source://actionpack//lib/action_dispatch/testing/test_response.rb#54
  def response_parser; end

  class << self
    # source://actionpack//lib/action_dispatch/testing/test_response.rb#14
    def from_response(response); end
  end
end

# :markup: markdown
#
# source://actionpack//lib/action_pack/gem_version.rb#5
module ActionPack
  class << self
    # Returns the currently loaded version of Action Pack as a `Gem::Version`.
    #
    # source://actionpack//lib/action_pack/gem_version.rb#7
    def gem_version; end

    # Returns the currently loaded version of Action Pack as a `Gem::Version`.
    #
    # source://actionpack//lib/action_pack/version.rb#9
    def version; end
  end
end

# source://actionpack//lib/action_pack/gem_version.rb#11
module ActionPack::VERSION; end

# source://actionpack//lib/action_pack/gem_version.rb#12
ActionPack::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_pack/gem_version.rb#13
ActionPack::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://actionpack//lib/action_pack/gem_version.rb#15
ActionPack::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://actionpack//lib/action_pack/gem_version.rb#17
ActionPack::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_pack/gem_version.rb#14
ActionPack::VERSION::TINY = T.let(T.unsafe(nil), Integer)

module ActionView::RoutingUrlFor
  include ::ActionDispatch::Routing::PolymorphicRoutes
  include ::ActionDispatch::Routing::UrlFor
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#7
module Mime
  class << self
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#51
    def [](type); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#64
    def fetch(type, &block); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#56
    def symbols; end

    # @return [Boolean]
    #
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#60
    def valid_symbols?(symbols); end
  end
end

# ALL isn't a real MIME type, so we don't register it for lookup with the other
# concrete types. It's a wildcard match that we use for `respond_to` negotiation
# internals.
#
# source://actionpack//lib/action_dispatch/http/mime_type.rb#363
Mime::ALL = T.let(T.unsafe(nil), Mime::AllType)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#349
class Mime::AllType < ::Mime::Type
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # @return [AllType] a new instance of AllType
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#352
  def initialize; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#356
  def all?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#357
  def html?; end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#47
Mime::EXTENSION_LOOKUP = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#48
Mime::LOOKUP = T.let(T.unsafe(nil), Hash)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#8
class Mime::Mimes
  include ::Enumerable

  # @return [Mimes] a new instance of Mimes
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#13
  def initialize; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#23
  def <<(type); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#30
  def delete_if; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#19
  def each(&block); end

  # Returns the value of attribute symbols.
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#9
  def symbols; end

  # :nodoc
  #
  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#41
  def valid_symbols?(symbols); end
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#365
class Mime::NullType
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#368
  def nil?; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#376
  def ref; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#372
  def to_s; end

  private

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#383
  def method_missing(method, *_arg1, **_arg2, &_arg3); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#379
  def respond_to_missing?(method, _); end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#46
Mime::SET = T.let(T.unsafe(nil), Mime::Mimes)

# Encapsulates the notion of a MIME type. Can be used at render time, for
# example, with:
#
#     class PostsController < ActionController::Base
#       def show
#         @post = Post.find(params[:id])
#
#         respond_to do |format|
#           format.html
#           format.ics { render body: @post.to_ics, mime_type: Mime::Type.lookup("text/calendar")  }
#           format.xml { render xml: @post }
#         end
#       end
#     end
#
# source://actionpack//lib/action_dispatch/http/mime_type.rb#84
class Mime::Type
  # @return [Type] a new instance of Type
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#264
  def initialize(string, symbol = T.unsafe(nil), synonyms = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#297
  def ==(mime_type); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#289
  def ===(list); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#311
  def =~(mime_type); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#327
  def all?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#304
  def eql?(other); end

  # Returns the value of attribute hash.
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#255
  def hash; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#323
  def html?; end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#317
  def match?(mime_type); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#285
  def ref; end

  # Returns the value of attribute symbol.
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#85
  def symbol; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#273
  def to_s; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#277
  def to_str; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#281
  def to_sym; end

  protected

  # Returns the value of attribute string.
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#330
  def string; end

  # Returns the value of attribute synonyms.
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#330
  def synonyms; end

  private

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#336
  def method_missing(method, *_arg1, **_arg2, &_arg3); end

  # @return [Boolean]
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#344
  def respond_to_missing?(method, include_private = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#334
  def to_a; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#333
  def to_ary; end

  class << self
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#167
    def lookup(string); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#175
    def lookup_by_extension(extension); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#200
    def parse(accept_header); end

    # For an input of `'text'`, returns `[Mime[:json], Mime[:xml], Mime[:ics],
    # Mime[:html], Mime[:css], Mime[:csv], Mime[:js], Mime[:yaml], Mime[:text]]`.
    #
    # For an input of `'application'`, returns `[Mime[:html], Mime[:js], Mime[:xml],
    # Mime[:yaml], Mime[:atom], Mime[:json], Mime[:rss], Mime[:url_encoded_form]]`.
    #
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#236
    def parse_data_with_trailing_star(type); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#227
    def parse_trailing_star(accept_header); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#186
    def register(string, symbol, mime_type_synonyms = T.unsafe(nil), extension_synonyms = T.unsafe(nil), skip_lookup = T.unsafe(nil)); end

    # Registers an alias that's not used on MIME type lookup, but can be referenced
    # directly. Especially useful for rendering different HTML versions depending on
    # the user agent, like an iPhone.
    #
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#182
    def register_alias(string, symbol, extension_synonyms = T.unsafe(nil)); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#163
    def register_callback(&block); end

    # This method is opposite of register method.
    #
    # To unregister a MIME type:
    #
    #     Mime::Type.unregister(:mobile)
    #
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#245
    def unregister(symbol); end
  end
end

# A simple helper class used in parsing the accept header.
#
# source://actionpack//lib/action_dispatch/http/mime_type.rb#90
class Mime::Type::AcceptItem
  # @return [AcceptItem] a new instance of AcceptItem
  #
  # source://actionpack//lib/action_dispatch/http/mime_type.rb#94
  def initialize(index, name, q = T.unsafe(nil)); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#101
  def <=>(item); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def index; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def index=(_arg0); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def name; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def name=(_arg0); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def q; end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def q=(_arg0); end

  # source://actionpack//lib/action_dispatch/http/mime_type.rb#91
  def to_s; end
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#108
class Mime::Type::AcceptList
  class << self
    # source://actionpack//lib/action_dispatch/http/mime_type.rb#151
    def find_item_by_name(array, name); end

    # source://actionpack//lib/action_dispatch/http/mime_type.rb#109
    def sort!(list); end
  end
end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#262
class Mime::Type::InvalidMimeType < ::StandardError; end

# source://actionpack//lib/action_dispatch/http/mime_type.rb#257
Mime::Type::MIME_NAME = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#259
Mime::Type::MIME_PARAMETER = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#258
Mime::Type::MIME_PARAMETER_VALUE = T.let(T.unsafe(nil), String)

# source://actionpack//lib/action_dispatch/http/mime_type.rb#260
Mime::Type::MIME_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://actionpack//lib/action_dispatch.rb#35
module Rack
  class << self
    # source://rack/3.1.7/lib/rack/version.rb#18
    def release; end
  end
end
