# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `actiontext` gem.
# Please instead update this file by running `bin/tapioca gem actiontext`.


# :markup: markdown
# :include: ../README.md
#
# source://actiontext//lib/action_text/gem_version.rb#5
module ActionText
  extend ::ActiveSupport::Autoload

  class << self
    # source://actiontext//lib/action_text/deprecator.rb#6
    def deprecator; end

    # Returns the currently loaded version of Action Text as a `Gem::Version`.
    #
    # source://actiontext//lib/action_text/gem_version.rb#7
    def gem_version; end

    # source://actiontext//lib/action_text.rb#47
    def html_document_class; end

    # source://actiontext//lib/action_text.rb#53
    def html_document_fragment_class; end

    # source://railties/7.2.1/lib/rails/engine.rb#412
    def railtie_helpers_paths; end

    # source://railties/7.2.1/lib/rails/engine.rb#395
    def railtie_namespace; end

    # source://railties/7.2.1/lib/rails/engine.rb#416
    def railtie_routes_url_helpers(include_path_helpers = T.unsafe(nil)); end

    # source://railties/7.2.1/lib/rails/engine.rb#401
    def table_name_prefix; end

    # source://railties/7.2.1/lib/rails/engine.rb#408
    def use_relative_model_naming?; end

    # Returns the currently loaded version of Action Text as a `Gem::Version`.
    #
    # source://actiontext//lib/action_text/version.rb#9
    def version; end
  end
end

# # Action Text Attachable
#
# Include this module to make a record attachable to an ActionText::Content.
#
#     class Person < ApplicationRecord
#       include ActionText::Attachable
#     end
#
#     person = Person.create! name: "Javan"
#     html = %Q(<action-text-attachment sgid="#{person.attachable_sgid}"></action-text-attachment>)
#     content = ActionText::Content.new(html)
#     content.attachables # => [person]
#
# source://actiontext//lib/action_text/attachable.rb#18
module ActionText::Attachable
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Attachable::ClassMethods

  # source://actiontext//lib/action_text/attachable.rb#83
  def attachable_content_type; end

  # source://actiontext//lib/action_text/attachable.rb#87
  def attachable_filename; end

  # source://actiontext//lib/action_text/attachable.rb#91
  def attachable_filesize; end

  # source://actiontext//lib/action_text/attachable.rb#95
  def attachable_metadata; end

  # Returns the Signed Global ID for the attachable. The purpose of the ID is set
  # to 'attachable' so it can't be reused for other purposes.
  #
  # source://actiontext//lib/action_text/attachable.rb#79
  def attachable_sgid; end

  # @return [Boolean]
  #
  # source://actiontext//lib/action_text/attachable.rb#99
  def previewable_attachable?; end

  # Returns the path to the partial that is used for rendering the attachable.
  # Defaults to `to_partial_path`.
  #
  # Override to render a different partial:
  #
  #     class User < ApplicationRecord
  #       def to_attachable_partial_path
  #         "users/attachable"
  #       end
  #     end
  #
  # source://actiontext//lib/action_text/attachable.rb#127
  def to_attachable_partial_path; end

  # source://actiontext//lib/action_text/attachable.rb#131
  def to_rich_text_attributes(attributes = T.unsafe(nil)); end

  # Returns the path to the partial that is used for rendering the attachable in
  # Trix. Defaults to `to_partial_path`.
  #
  # Override to render a different partial:
  #
  #     class User < ApplicationRecord
  #       def to_trix_content_attachment_partial_path
  #         "users/trix_content_attachment"
  #       end
  #     end
  #
  # source://actiontext//lib/action_text/attachable.rb#113
  def to_trix_content_attachment_partial_path; end

  private

  # source://actiontext//lib/action_text/attachable.rb#144
  def attribute_names_for_serialization; end

  # source://actiontext//lib/action_text/attachable.rb#148
  def read_attribute_for_serialization(key); end

  class << self
    # source://actiontext//lib/action_text/attachable.rb#43
    def from_attachable_sgid(sgid, options = T.unsafe(nil)); end

    # Extracts the `ActionText::Attachable` from the attachment HTML node:
    #
    #     person = Person.create! name: "Javan"
    #     html = %Q(<action-text-attachment sgid="#{person.attachable_sgid}"></action-text-attachment>)
    #     fragment = ActionText::Fragment.wrap(html)
    #     attachment_node = fragment.find_all(ActionText::Attachment.tag_name).first
    #     ActionText::Attachable.from_node(attachment_node) # => person
    #
    # source://actiontext//lib/action_text/attachable.rb#31
    def from_node(node); end

    private

    # source://actiontext//lib/action_text/attachable.rb#50
    def attachable_from_sgid(sgid); end
  end
end

# source://actiontext//lib/action_text/attachable.rb#0
module ActionText::Attachable::ClassMethods
  # source://actiontext//lib/action_text/attachable.rb#58
  def from_attachable_sgid(sgid); end

  # source://actiontext//lib/action_text/attachable.rb#72
  def to_missing_attachable_partial_path; end
end

# source://actiontext//lib/action_text/attachable.rb#21
ActionText::Attachable::LOCATOR_NAME = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text.rb#30
module ActionText::Attachables
  extend ::ActiveSupport::Autoload
end

# source://actiontext//lib/action_text/attachables/content_attachment.rb#7
class ActionText::Attachables::ContentAttachment
  include ::ActiveModel::Validations
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods
  include ::ActiveModel::Conversion
  include ::ActiveModel::ForbiddenAttributesProtection
  include ::ActiveModel::AttributeAssignment
  include ::ActiveModel::API
  include ::ActiveModel::Access
  include ::ActiveModel::Model
  extend ::ActiveModel::Validations::ClassMethods
  extend ::ActiveModel::Naming
  extend ::ActiveModel::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActiveModel::Translation
  extend ::ActiveModel::Validations::HelperMethods
  extend ::ActiveModel::Conversion::ClassMethods

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_validate_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _validate_callbacks; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#71
  def _validators; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#71
  def _validators?; end

  # source://actiontext//lib/action_text/attachables/content_attachment.rb#20
  def attachable_plain_text_representation(caption); end

  # Returns the value of attribute content.
  #
  # source://actiontext//lib/action_text/attachables/content_attachment.rb#15
  def content; end

  # Sets the attribute content
  #
  # @param value the value to set the attribute content to.
  #
  # source://actiontext//lib/action_text/attachables/content_attachment.rb#15
  def content=(_arg0); end

  # Returns the value of attribute content_type.
  #
  # source://actiontext//lib/action_text/attachables/content_attachment.rb#15
  def content_type; end

  # Sets the attribute content_type
  #
  # @param value the value to set the attribute content_type to.
  #
  # source://actiontext//lib/action_text/attachables/content_attachment.rb#15
  def content_type=(_arg0); end

  # source://activemodel/7.2.1/lib/active_model/naming.rb#255
  def model_name(&_arg0); end

  # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
  def param_delimiter=(_arg0); end

  # source://actiontext//lib/action_text/attachables/content_attachment.rb#24
  def to_html; end

  # source://actiontext//lib/action_text/attachables/content_attachment.rb#32
  def to_partial_path; end

  # source://actiontext//lib/action_text/attachables/content_attachment.rb#28
  def to_s; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#67
  def validation_context; end

  private

  # source://actiontext//lib/action_text/attachables/content_attachment.rb#37
  def content_instance; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#67
  def validation_context=(_arg0); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _validate_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _validate_callbacks=(value); end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators; end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators=(value); end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators?; end

    # source://actiontext//lib/action_text/attachables/content_attachment.rb#10
    def from_node(node); end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter; end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter=(value); end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter?; end
  end
end

# source://actiontext//lib/action_text/attachables/missing_attachable.rb#7
class ActionText::Attachables::MissingAttachable
  extend ::ActiveModel::Naming

  # @return [MissingAttachable] a new instance of MissingAttachable
  #
  # source://actiontext//lib/action_text/attachables/missing_attachable.rb#12
  def initialize(sgid); end

  # source://actiontext//lib/action_text/attachables/missing_attachable.rb#24
  def model; end

  # source://activemodel/7.2.1/lib/active_model/naming.rb#255
  def model_name(&_arg0); end

  # source://actiontext//lib/action_text/attachables/missing_attachable.rb#16
  def to_partial_path; end
end

# source://actiontext//lib/action_text/attachables/missing_attachable.rb#10
ActionText::Attachables::MissingAttachable::DEFAULT_PARTIAL_PATH = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text/attachables/remote_image.rb#7
class ActionText::Attachables::RemoteImage
  extend ::ActiveModel::Naming

  # @return [RemoteImage] a new instance of RemoteImage
  #
  # source://actiontext//lib/action_text/attachables/remote_image.rb#32
  def initialize(attributes = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/attachables/remote_image.rb#39
  def attachable_plain_text_representation(caption); end

  # Returns the value of attribute content_type.
  #
  # source://actiontext//lib/action_text/attachables/remote_image.rb#30
  def content_type; end

  # Returns the value of attribute height.
  #
  # source://actiontext//lib/action_text/attachables/remote_image.rb#30
  def height; end

  # source://activemodel/7.2.1/lib/active_model/naming.rb#255
  def model_name(&_arg0); end

  # source://actiontext//lib/action_text/attachables/remote_image.rb#43
  def to_partial_path; end

  # Returns the value of attribute url.
  #
  # source://actiontext//lib/action_text/attachables/remote_image.rb#30
  def url; end

  # Returns the value of attribute width.
  #
  # source://actiontext//lib/action_text/attachables/remote_image.rb#30
  def width; end

  class << self
    # source://actiontext//lib/action_text/attachables/remote_image.rb#11
    def from_node(node); end

    private

    # source://actiontext//lib/action_text/attachables/remote_image.rb#22
    def attributes_from_node(node); end

    # @return [Boolean]
    #
    # source://actiontext//lib/action_text/attachables/remote_image.rb#18
    def content_type_is_image?(content_type); end
  end
end

# # Action Text Attachment
#
# Attachments serialize attachables to HTML or plain text.
#
#     class Person < ApplicationRecord
#       include ActionText::Attachable
#     end
#
#     attachable = Person.create! name: "Javan"
#     attachment = ActionText::Attachment.from_attachable(attachable)
#     attachment.to_html # => "<action-text-attachment sgid=\"BAh7CEk..."
#
# source://actiontext//lib/action_text/attachment.rb#19
class ActionText::Attachment
  include ::ActionText::Attachments::Caching
  include ::ActionText::Attachments::Minification
  include ::ActionText::Attachments::TrixConversion
  extend ::ActionText::Attachments::Minification::ClassMethods
  extend ::ActionText::Attachments::TrixConversion::ClassMethods

  # @return [Attachment] a new instance of Attachment
  #
  # source://actiontext//lib/action_text/attachment.rb#68
  def initialize(node, attachable); end

  # Returns the value of attribute attachable.
  #
  # source://actiontext//lib/action_text/attachment.rb#63
  def attachable; end

  # source://actiontext//lib/action_text/attachment.rb#73
  def caption; end

  # source://actiontext//lib/action_text/attachment.rb#77
  def full_attributes; end

  # source://actiontext//lib/action_text/attachment.rb#131
  def inspect; end

  # source://activesupport/7.2.1/lib/active_support/delegation.rb#187
  def method_missing(method, *_arg1, **_arg2, &_arg3); end

  # Returns the value of attribute node.
  #
  # source://actiontext//lib/action_text/attachment.rb#63
  def node; end

  # source://actiontext//lib/action_text/attachment.rb#22
  def tag_name; end

  # source://actiontext//lib/action_text/attachment.rb#22
  def tag_name=(val); end

  # Converts the attachment to HTML.
  #
  #     attachable = Person.create! name: "Javan"
  #     attachment = ActionText::Attachment.from_attachable(attachable)
  #     attachment.to_html # => "<action-text-attachment sgid=\"BAh7CEk...
  #
  # source://actiontext//lib/action_text/attachment.rb#123
  def to_html; end

  # source://actiontext//lib/action_text/attachment.rb#65
  def to_param(*_arg0, **_arg1, &_arg2); end

  # Converts the attachment to plain text.
  #
  #     attachable = ActiveStorage::Blob.find_by filename: "racecar.jpg"
  #     attachment = ActionText::Attachment.from_attachable(attachable)
  #     attachment.to_plain_text # => "[racecar.jpg]"
  #
  # Use the `caption` when set:
  #
  #     attachment = ActionText::Attachment.from_attachable(attachable, caption: "Vroom vroom")
  #     attachment.to_plain_text # => "[Vroom vroom]"
  #
  # The presentation can be overridden by implementing the
  # `attachable_plain_text_representation` method:
  #
  #     class Person < ApplicationRecord
  #       include ActionText::Attachable
  #
  #       def attachable_plain_text_representation
  #         "[#{name}]"
  #       end
  #     end
  #
  #     attachable = Person.create! name: "Javan"
  #     attachment = ActionText::Attachment.from_attachable(attachable)
  #     attachment.to_plain_text # => "[Javan]"
  #
  # source://actiontext//lib/action_text/attachment.rb#110
  def to_plain_text; end

  # source://actiontext//lib/action_text/attachment.rb#127
  def to_s; end

  # source://actiontext//lib/action_text/attachment.rb#81
  def with_full_attributes; end

  private

  # source://actiontext//lib/action_text/attachment.rb#140
  def attachable_attributes; end

  # source://actiontext//lib/action_text/attachment.rb#136
  def node_attributes; end

  # source://activesupport/7.2.1/lib/active_support/delegation.rb#179
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/attachment.rb#144
  def sgid_attributes; end

  class << self
    # source://actiontext//lib/action_text/attachment.rb#27
    def fragment_by_canonicalizing_attachments(content); end

    # source://actiontext//lib/action_text/attachment.rb#39
    def from_attachable(attachable, attributes = T.unsafe(nil)); end

    # source://actiontext//lib/action_text/attachment.rb#35
    def from_attachables(attachables); end

    # source://actiontext//lib/action_text/attachment.rb#45
    def from_attributes(attributes, attachable = T.unsafe(nil)); end

    # source://actiontext//lib/action_text/attachment.rb#31
    def from_node(node, attachable = T.unsafe(nil)); end

    # source://actiontext//lib/action_text/attachment.rb#22
    def tag_name; end

    # source://actiontext//lib/action_text/attachment.rb#22
    def tag_name=(val); end

    private

    # source://actiontext//lib/action_text/attachment.rb#52
    def node_from_attributes(attributes); end

    # source://actiontext//lib/action_text/attachment.rb#58
    def process_attributes(attributes); end
  end
end

# source://actiontext//lib/action_text/attachment.rb#24
ActionText::Attachment::ATTRIBUTES = T.let(T.unsafe(nil), Array)

# source://actiontext//lib/action_text/attachment_gallery.rb#6
class ActionText::AttachmentGallery
  include ::ActiveModel::Validations
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods
  include ::ActiveModel::Conversion
  include ::ActiveModel::ForbiddenAttributesProtection
  include ::ActiveModel::AttributeAssignment
  include ::ActiveModel::API
  include ::ActiveModel::Access
  include ::ActiveModel::Model
  extend ::ActiveModel::Validations::ClassMethods
  extend ::ActiveModel::Naming
  extend ::ActiveModel::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActiveModel::Translation
  extend ::ActiveModel::Validations::HelperMethods
  extend ::ActiveModel::Conversion::ClassMethods

  # @return [AttachmentGallery] a new instance of AttachmentGallery
  #
  # source://actiontext//lib/action_text/attachment_gallery.rb#54
  def initialize(node); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_validate_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _validate_callbacks; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#71
  def _validators; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#71
  def _validators?; end

  # source://actiontext//lib/action_text/attachment_gallery.rb#58
  def attachments; end

  # source://actiontext//lib/action_text/attachment_gallery.rb#68
  def inspect; end

  # source://activemodel/7.2.1/lib/active_model/naming.rb#255
  def model_name(&_arg0); end

  # Returns the value of attribute node.
  #
  # source://actiontext//lib/action_text/attachment_gallery.rb#52
  def node; end

  # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
  def param_delimiter=(_arg0); end

  # source://actiontext//lib/action_text/attachment_gallery.rb#64
  def size; end

  # source://activemodel/7.2.1/lib/active_model/validations.rb#67
  def validation_context; end

  private

  # source://activemodel/7.2.1/lib/active_model/validations.rb#67
  def validation_context=(_arg0); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _validate_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _validate_callbacks=(value); end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators; end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators=(value); end

    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators?; end

    # source://actiontext//lib/action_text/attachment_gallery.rb#43
    def attachment_selector; end

    # source://actiontext//lib/action_text/attachment_gallery.rb#27
    def find_attachment_gallery_nodes(content); end

    # source://actiontext//lib/action_text/attachment_gallery.rb#13
    def fragment_by_canonicalizing_attachment_galleries(content); end

    # source://actiontext//lib/action_text/attachment_gallery.rb#19
    def fragment_by_replacing_attachment_gallery_nodes(content); end

    # source://actiontext//lib/action_text/attachment_gallery.rb#39
    def from_node(node); end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter; end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter=(value); end

    # source://activemodel/7.2.1/lib/active_model/conversion.rb#32
    def param_delimiter?; end

    # source://actiontext//lib/action_text/attachment_gallery.rb#47
    def selector; end
  end
end

# source://actiontext//lib/action_text/attachment_gallery.rb#9
ActionText::AttachmentGallery::TAG_NAME = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text.rb#38
module ActionText::Attachments
  extend ::ActiveSupport::Autoload
end

# source://actiontext//lib/action_text/attachments/caching.rb#7
module ActionText::Attachments::Caching
  # source://actiontext//lib/action_text/attachments/caching.rb#8
  def cache_key(*args); end

  private

  # source://actiontext//lib/action_text/attachments/caching.rb#13
  def cache_digest; end
end

# source://actiontext//lib/action_text/attachments/minification.rb#7
module ActionText::Attachments::Minification
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Attachments::Minification::ClassMethods
end

# source://actiontext//lib/action_text/attachments/minification.rb#0
module ActionText::Attachments::Minification::ClassMethods
  # source://actiontext//lib/action_text/attachments/minification.rb#11
  def fragment_by_minifying_attachments(content); end
end

# source://actiontext//lib/action_text/attachments/trix_conversion.rb#9
module ActionText::Attachments::TrixConversion
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Attachments::TrixConversion::ClassMethods

  # source://actiontext//lib/action_text/attachments/trix_conversion.rb#24
  def to_trix_attachment(content = T.unsafe(nil)); end

  private

  # source://actiontext//lib/action_text/attachments/trix_conversion.rb#31
  def trix_attachment_content; end
end

# source://actiontext//lib/action_text/attachments/trix_conversion.rb#0
module ActionText::Attachments::TrixConversion::ClassMethods
  # source://actiontext//lib/action_text/attachments/trix_conversion.rb#13
  def fragment_by_converting_trix_attachments(content); end

  # source://actiontext//lib/action_text/attachments/trix_conversion.rb#19
  def from_trix_attachment(trix_attachment); end
end

# source://actiontext//lib/action_text/attribute.rb#6
module ActionText::Attribute
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Attribute::ClassMethods
end

# source://actiontext//lib/action_text/attribute.rb#0
module ActionText::Attribute::ClassMethods
  # source://actiontext//lib/action_text/attribute.rb#50
  def has_rich_text(name, encrypted: T.unsafe(nil), strict_loading: T.unsafe(nil)); end

  # source://actiontext//lib/action_text/attribute.rb#80
  def rich_text_association_names; end

  # source://actiontext//lib/action_text/attribute.rb#75
  def with_all_rich_text; end
end

# # Action Text Content
#
# The `ActionText::Content` class wraps an HTML fragment to add support for
# parsing, rendering and serialization. It can be used to extract links and
# attachments, convert the fragment to plain text, or serialize the fragment to
# the database.
#
# The ActionText::RichText record serializes the `body` attribute as
# `ActionText::Content`.
#
#     class Message < ActiveRecord::Base
#       has_rich_text :content
#     end
#
#     message = Message.create!(content: "<h1>Funny times!</h1>")
#     body = message.content.body # => #<ActionText::Content "<div class=\"trix-conte...">
#     body.to_s # => "<h1>Funny times!</h1>"
#     body.to_plain_text # => "Funny times!"
#
# source://actiontext//lib/action_text/content.rb#24
class ActionText::Content
  include ::ActionText::ContentHelper
  include ::ActionText::Serialization
  include ::ActionText::Rendering
  extend ::ActionText::Serialization::ClassMethods
  extend ::ActionText::Rendering::ClassMethods

  # @return [Content] a new instance of Content
  #
  # source://actiontext//lib/action_text/content.rb#40
  def initialize(content = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/content.rb#169
  def ==(other); end

  # source://actiontext//lib/action_text/content.rb#93
  def append_attachables(attachables); end

  # source://actiontext//lib/action_text/content.rb#161
  def as_json(*_arg0); end

  # Extracts +ActionText::Attachable+s from the HTML fragment:
  #
  #     attachable = ActiveStorage::Blob.first
  #     html = %Q(<action-text-attachment sgid="#{attachable.attachable_sgid}" caption="Captioned"></action-text-attachment>)
  #     content = ActionText::Content.new(html)
  #     content.attachables # => [attachable]
  #
  # source://actiontext//lib/action_text/content.rb#87
  def attachables; end

  # source://actiontext//lib/action_text/content.rb#71
  def attachment_galleries; end

  # Extracts +ActionText::Attachment+s from the HTML fragment:
  #
  #     attachable = ActiveStorage::Blob.first
  #     html = %Q(<action-text-attachment sgid="#{attachable.attachable_sgid}" caption="Captioned"></action-text-attachment>)
  #     content = ActionText::Content.new(html)
  #     content.attachments # => [#<ActionText::Attachment attachable=#<ActiveStorage::Blob...
  #
  # source://actiontext//lib/action_text/content.rb#65
  def attachments; end

  # source://actiontext//lib/action_text/content.rb#30
  def blank?(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/content.rb#29
  def deconstruct(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/content.rb#30
  def empty?(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute fragment.
  #
  # source://actiontext//lib/action_text/content.rb#27
  def fragment; end

  # source://actiontext//lib/action_text/content.rb#77
  def gallery_attachments; end

  # source://actiontext//lib/action_text/content.rb#30
  def html_safe(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/content.rb#165
  def inspect; end

  # Extracts links from the HTML fragment:
  #
  #     html = '<a href="http://example.com/">Example</a>'
  #     content = ActionText::Content.new(html)
  #     content.links # => ["http://example.com/"]
  #
  # source://actiontext//lib/action_text/content.rb#55
  def links; end

  # source://actiontext//lib/action_text/content.rb#30
  def present?(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/rendering.rb#14
  def render(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/content.rb#109
  def render_attachment_galleries(&block); end

  # source://actiontext//lib/action_text/content.rb#98
  def render_attachments(**options, &block); end

  # source://actiontext//lib/action_text/content.rb#138
  def to_html; end

  # source://actiontext//lib/action_text/content.rb#146
  def to_partial_path; end

  # Returns a plain-text version of the markup contained by the content, with tags
  # removed but HTML entities encoded.
  #
  #     content = ActionText::Content.new("<h1>Funny times!</h1>")
  #     content.to_plain_text # => "Funny times!"
  #
  #     content = ActionText::Content.new("<div onclick='action()'>safe<script>unsafe</script></div>")
  #     content.to_plain_text # => "safeunsafe"
  #
  # NOTE: that the returned string is not HTML safe and should not be rendered in
  # browsers.
  #
  #     content = ActionText::Content.new("&lt;script&gt;alert()&lt;/script&gt;")
  #     content.to_plain_text # => "<script>alert()</script>"
  #
  # source://actiontext//lib/action_text/content.rb#130
  def to_plain_text; end

  # source://actiontext//lib/action_text/content.rb#142
  def to_rendered_html_with_layout; end

  # Safely transforms Content into an HTML String.
  #
  #     content = ActionText::Content.new(content: "<h1>Funny times!</h1>")
  #     content.to_s # => "<h1>Funny times!</h1>"
  #
  #     content = ActionText::Content.new("<div onclick='action()'>safe<script>unsafe</script></div>")
  #     content.to_s # => "<div>safeunsafe</div>"
  #
  # source://actiontext//lib/action_text/content.rb#157
  def to_s; end

  # source://actiontext//lib/action_text/content.rb#134
  def to_trix_html; end

  private

  # source://actiontext//lib/action_text/content.rb#186
  def attachment_for_node(node, with_full_attributes: T.unsafe(nil)); end

  # source://actiontext//lib/action_text/content.rb#191
  def attachment_gallery_for_node(node); end

  # source://actiontext//lib/action_text/content.rb#182
  def attachment_gallery_nodes; end

  # source://actiontext//lib/action_text/content.rb#178
  def attachment_nodes; end

  class << self
    # source://actiontext//lib/action_text/content.rb#33
    def fragment_by_canonicalizing_content(content); end

    # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#49
    def renderer; end

    # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#108
    def renderer=(obj); end
  end
end

module ActionText::ContentHelper
  def allowed_attributes; end
  def allowed_attributes=(val); end
  def allowed_tags; end
  def allowed_tags=(val); end
  def render_action_text_attachment(attachment, locals: T.unsafe(nil)); end
  def render_action_text_attachments(content); end
  def render_action_text_content(content); end
  def sanitize_action_text_content(content); end
  def sanitize_content_attachment(content_attachment); end
  def sanitizer; end
  def sanitizer=(val); end
  def sanitizer_allowed_attributes; end
  def sanitizer_allowed_tags; end
  def scrubber; end
  def scrubber=(val); end

  class << self
    def allowed_attributes; end
    def allowed_attributes=(val); end
    def allowed_tags; end
    def allowed_tags=(val); end
    def sanitizer; end
    def sanitizer=(val); end
    def scrubber; end
    def scrubber=(val); end
  end
end

# source://actiontext//lib/action_text/encryption.rb#6
module ActionText::Encryption
  # source://actiontext//lib/action_text/encryption.rb#14
  def decrypt; end

  # source://actiontext//lib/action_text/encryption.rb#7
  def encrypt; end

  private

  # source://actiontext//lib/action_text/encryption.rb#26
  def decrypt_rich_texts; end

  # source://actiontext//lib/action_text/encryption.rb#22
  def encrypt_rich_texts; end

  # source://actiontext//lib/action_text/encryption.rb#34
  def encryptable_rich_texts; end

  # @return [Boolean]
  #
  # source://actiontext//lib/action_text/encryption.rb#30
  def has_encrypted_rich_texts?; end
end

# source://actiontext//lib/action_text/engine.rb#13
class ActionText::Engine < ::Rails::Engine
  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end
  end
end

# # Action Text FixtureSet
#
# Fixtures are a way of organizing data that you want to test against; in short,
# sample data.
#
# To learn more about fixtures, read the ActiveRecord::FixtureSet documentation.
#
# ### YAML
#
# Like other Active Record-backed models, ActionText::RichText records inherit
# from ActiveRecord::Base instances and can therefore be populated by fixtures.
#
# Consider an `Article` class:
#
#     class Article < ApplicationRecord
#       has_rich_text :content
#     end
#
# To declare fixture data for the related `content`, first declare fixture data
# for `Article` instances in `test/fixtures/articles.yml`:
#
#     first:
#       title: An Article
#
# Then declare the ActionText::RichText fixture data in
# `test/fixtures/action_text/rich_texts.yml`, making sure to declare each
# entry's `record:` key as a polymorphic relationship:
#
#     first:
#       record: first (Article)
#       name: content
#       body: <div>Hello, world.</div>
#
# When processed, Active Record will insert database records for each fixture
# entry and will ensure the Action Text relationship is intact.
#
# source://actiontext//lib/action_text/fixture_set.rb#41
class ActionText::FixtureSet
  class << self
    # Fixtures support Action Text attachments as part of their `body` HTML.
    #
    # ### Examples
    #
    # For example, consider a second `Article` fixture declared in
    # `test/fixtures/articles.yml`:
    #
    #     second:
    #       title: Another Article
    #
    # You can attach a mention of `articles(:first)` to `second`'s `content` by
    # embedding a call to `ActionText::FixtureSet.attachment` in the `body:` value
    # in `test/fixtures/action_text/rich_texts.yml`:
    #
    #     second:
    #       record: second (Article)
    #       name: content
    #       body: <div>Hello, <%= ActionText::FixtureSet.attachment("articles", :first) %></div>
    #
    # source://actiontext//lib/action_text/fixture_set.rb#61
    def attachment(fixture_set_name, label, column_type: T.unsafe(nil)); end
  end
end

# source://actiontext//lib/action_text/fragment.rb#6
class ActionText::Fragment
  # @return [Fragment] a new instance of Fragment
  #
  # source://actiontext//lib/action_text/fragment.rb#28
  def initialize(source); end

  # source://actiontext//lib/action_text/fragment.rb#26
  def deconstruct(*_arg0, **_arg1, &_arg2); end

  # source://actiontext//lib/action_text/fragment.rb#32
  def find_all(selector); end

  # source://actiontext//lib/action_text/fragment.rb#41
  def replace(selector); end

  # Returns the value of attribute source.
  #
  # source://actiontext//lib/action_text/fragment.rb#24
  def source; end

  # source://actiontext//lib/action_text/fragment.rb#54
  def to_html; end

  # source://actiontext//lib/action_text/fragment.rb#50
  def to_plain_text; end

  # source://actiontext//lib/action_text/fragment.rb#58
  def to_s; end

  # @yield [source = self.source.dup]
  #
  # source://actiontext//lib/action_text/fragment.rb#36
  def update; end

  class << self
    # source://actiontext//lib/action_text/fragment.rb#19
    def from_html(html); end

    # source://actiontext//lib/action_text/fragment.rb#8
    def wrap(fragment_or_html); end
  end
end

# source://actiontext//lib/action_text/html_conversion.rb#6
module ActionText::HtmlConversion
  extend ::ActionText::HtmlConversion

  # source://actiontext//lib/action_text/html_conversion.rb#17
  def create_element(tag_name, attributes = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/html_conversion.rb#13
  def fragment_for_html(html); end

  # source://actiontext//lib/action_text/html_conversion.rb#9
  def node_to_html(node); end

  private

  # source://actiontext//lib/action_text/html_conversion.rb#22
  def document; end
end

# source://actiontext//lib/action_text/plain_text_conversion.rb#6
module ActionText::PlainTextConversion
  extend ::ActionText::PlainTextConversion

  # source://actiontext//lib/action_text/plain_text_conversion.rb#9
  def node_to_plain_text(node); end

  private

  # source://actiontext//lib/action_text/plain_text_conversion.rb#106
  def break_if_nested_list(node, text); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#83
  def bullet_for_li_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#95
  def indentation_for_li_node(node); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#102
  def list_node_depth_for_node(node); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#91
  def list_node_name_for_li_node(node); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#34
  def plain_text_for_block(node, index = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#66
  def plain_text_for_blockquote_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#50
  def plain_text_for_br_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#58
  def plain_text_for_div_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#62
  def plain_text_for_figcaption_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#34
  def plain_text_for_h1_node(node, index = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#71
  def plain_text_for_li_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#42
  def plain_text_for_list(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#14
  def plain_text_for_node(node, index = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#22
  def plain_text_for_node_children(node); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#42
  def plain_text_for_ol_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#34
  def plain_text_for_p_node(node, index = T.unsafe(nil)); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#54
  def plain_text_for_text_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#42
  def plain_text_for_ul_node(node, index); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#30
  def plain_text_method_for_node(node); end

  # source://actiontext//lib/action_text/plain_text_conversion.rb#79
  def remove_trailing_newlines(text); end
end

class ActionText::Record < ::ActiveRecord::Base
  include ::ActionText::Record::GeneratedAttributeMethods
  include ::ActionText::Record::GeneratedAssociationMethods
  include ::Kaminari::ActiveRecordModelExtension
  include ::Kaminari::ConfigurationMethods
  extend ::Kaminari::ConfigurationMethods::ClassMethods

  class << self
    # source://activemodel/7.2.1/lib/active_model/validations.rb#71
    def _validators; end

    # source://activerecord/7.2.1/lib/active_record/enum.rb#167
    def defined_enums; end

    # source://kaminari-activerecord/1.2.2/lib/kaminari/activerecord/active_record_model_extension.rb#15
    def page(num = T.unsafe(nil)); end
  end
end

module ActionText::Record::GeneratedAssociationMethods; end
module ActionText::Record::GeneratedAttributeMethods; end

# source://actiontext//lib/action_text/rendering.rb#9
module ActionText::Rendering
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Rendering::ClassMethods
end

# source://actiontext//lib/action_text/rendering.rb#0
module ActionText::Rendering::ClassMethods
  # source://actiontext//lib/action_text/rendering.rb#18
  def action_controller_renderer; end

  # source://actiontext//lib/action_text/rendering.rb#30
  def render(*args, &block); end

  # source://actiontext//lib/action_text/rendering.rb#22
  def with_renderer(renderer); end
end

# source://actiontext//lib/action_text/serialization.rb#6
module ActionText::Serialization
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionText::Serialization::ClassMethods

  # source://actiontext//lib/action_text/serialization.rb#34
  def _dump(*_arg0); end
end

# source://actiontext//lib/action_text/serialization.rb#0
module ActionText::Serialization::ClassMethods
  # source://actiontext//lib/action_text/serialization.rb#10
  def _load(content); end

  # source://actiontext//lib/action_text/serialization.rb#14
  def dump(content); end

  # source://actiontext//lib/action_text/serialization.rb#10
  def load(content); end
end

module ActionText::TagHelper
  def rich_text_area_tag(name, value = T.unsafe(nil), options = T.unsafe(nil)); end

  class << self
    def id; end
    def id=(val); end
  end
end

# source://actiontext//lib/action_text/trix_attachment.rb#6
class ActionText::TrixAttachment
  # @return [TrixAttachment] a new instance of TrixAttachment
  #
  # source://actiontext//lib/action_text/trix_attachment.rb#53
  def initialize(node); end

  # source://actiontext//lib/action_text/trix_attachment.rb#57
  def attributes; end

  # Returns the value of attribute node.
  #
  # source://actiontext//lib/action_text/trix_attachment.rb#51
  def node; end

  # source://actiontext//lib/action_text/trix_attachment.rb#61
  def to_html; end

  # source://actiontext//lib/action_text/trix_attachment.rb#65
  def to_s; end

  private

  # source://actiontext//lib/action_text/trix_attachment.rb#70
  def attachment_attributes; end

  # source://actiontext//lib/action_text/trix_attachment.rb#74
  def composed_attributes; end

  # source://actiontext//lib/action_text/trix_attachment.rb#82
  def read_json_attribute(name); end

  # source://actiontext//lib/action_text/trix_attachment.rb#78
  def read_json_object_attribute(name); end

  class << self
    # source://actiontext//lib/action_text/trix_attachment.rb#21
    def from_attributes(attributes); end

    private

    # source://actiontext//lib/action_text/trix_attachment.rb#35
    def process_attributes(attributes); end

    # source://actiontext//lib/action_text/trix_attachment.rb#39
    def transform_attribute_keys(attributes); end

    # source://actiontext//lib/action_text/trix_attachment.rb#43
    def typecast_attribute_values(attributes); end
  end
end

# source://actiontext//lib/action_text/trix_attachment.rb#11
ActionText::TrixAttachment::ATTRIBUTES = T.let(T.unsafe(nil), Array)

# source://actiontext//lib/action_text/trix_attachment.rb#12
ActionText::TrixAttachment::ATTRIBUTE_TYPES = T.let(T.unsafe(nil), Hash)

# source://actiontext//lib/action_text/trix_attachment.rb#10
ActionText::TrixAttachment::COMPOSED_ATTRIBUTES = T.let(T.unsafe(nil), Array)

# source://actiontext//lib/action_text/trix_attachment.rb#8
ActionText::TrixAttachment::SELECTOR = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text/trix_attachment.rb#7
ActionText::TrixAttachment::TAG_NAME = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text/gem_version.rb#11
module ActionText::VERSION; end

# source://actiontext//lib/action_text/gem_version.rb#12
ActionText::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://actiontext//lib/action_text/gem_version.rb#13
ActionText::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://actiontext//lib/action_text/gem_version.rb#15
ActionText::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://actiontext//lib/action_text/gem_version.rb#17
ActionText::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://actiontext//lib/action_text/gem_version.rb#14
ActionText::VERSION::TINY = T.let(T.unsafe(nil), Integer)

module ActionView::Helpers
  include ::ActionView::Helpers::SanitizeHelper
  include ::ActionView::Helpers::TextHelper
  include ::ActionView::Helpers::UrlHelper
  include ::ActionView::Helpers::SanitizeHelper
  include ::ActionView::Helpers::TextHelper
  include ::ActionView::Helpers::FormTagHelper
  include ::ActionView::Helpers::FormHelper
  include ::ActionView::Helpers::TranslationHelper

  mixes_in_class_methods ::ActionView::Helpers::UrlHelper::ClassMethods
  mixes_in_class_methods ::ActionView::Helpers::SanitizeHelper::ClassMethods

  class << self
    # source://actionview/7.2.1/lib/action_view/helpers.rb#35
    def eager_load!; end
  end
end

class ActionView::Helpers::FormBuilder
  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1717
  def initialize(object_name, object, template, options); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2649
  def button(value = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2474
  def check_box(method, options = T.unsafe(nil), checked_value = T.unsafe(nil), unchecked_value = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#908
  def collection_check_boxes(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#920
  def collection_radio_buttons(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#860
  def collection_select(method, collection, value_method, text_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2042
  def color_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2070
  def date_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/date_helper.rb#1237
  def date_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2084
  def datetime_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2091
  def datetime_local_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/date_helper.rb#1261
  def datetime_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2119
  def email_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2670
  def emitted_hidden_id?; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
  def field_helpers; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
  def field_helpers=(_arg0); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
  def field_helpers?; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1774
  def field_id(method, *suffixes, namespace: T.unsafe(nil), index: T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1794
  def field_name(method, *methods, multiple: T.unsafe(nil), index: T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2328
  def fields(scope = T.unsafe(nil), model: T.unsafe(nil), **options, &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2290
  def fields_for(record_name, record_object = T.unsafe(nil), fields_options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2557
  def file_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#872
  def grouped_collection_select(method, collection, group_method, group_label_method, option_key_method, option_value_method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2518
  def hidden_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1754
  def id; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1694
  def index; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2405
  def label(method, text = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2098
  def month_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1694
  def multipart; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1697
  def multipart=(multipart); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1694
  def multipart?; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2126
  def number_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def object; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def object=(_arg0); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def object_name; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def object_name=(_arg0); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def options; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1692
  def options=(_arg0); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2028
  def password_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2063
  def phone_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2496
  def radio_button(method, tag_value, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2133
  def range_field(method, options = T.unsafe(nil)); end

  def rich_text_area(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2049
  def search_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#848
  def select(method, choices = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2589
  def submit(value = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2056
  def telephone_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2035
  def text_area(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2021
  def text_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2077
  def time_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/date_helper.rb#1249
  def time_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#884
  def time_zone_select(method, priority_zones = T.unsafe(nil), options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1713
  def to_model; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1709
  def to_partial_path; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2112
  def url_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2105
  def week_field(method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_options_helper.rb#896
  def weekday_select(method, options = T.unsafe(nil), html_options = T.unsafe(nil)); end

  private

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2755
  def convert_to_legacy_options(options); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2737
  def fields_for_nested_model(name, object, fields_options, block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2708
  def fields_for_with_nested_attributes(association_name, association, options, block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2704
  def nested_attributes_association?(association_name); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2750
  def nested_child_index(name); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2675
  def objectify_options(options); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#2681
  def submit_default_value; end

  class << self
    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1705
    def _to_partial_path; end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
    def field_helpers; end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
    def field_helpers=(value); end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1682
    def field_helpers?; end
  end
end

module ActionView::Helpers::FormHelper
  include ::ActionView::Helpers::UrlHelper
  include ::ActionView::Helpers::SanitizeHelper
  include ::ActionView::Helpers::TextHelper
  include ::ActionView::Helpers::FormTagHelper

  mixes_in_class_methods ::ActionView::Helpers::UrlHelper::ClassMethods
  mixes_in_class_methods ::ActionView::Helpers::SanitizeHelper::ClassMethods

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1588
  def _object_for_form_builder(object); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1345
  def check_box(object_name, method, options = T.unsafe(nil), checked_value = T.unsafe(nil), unchecked_value = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1375
  def color_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1439
  def date_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1512
  def datetime_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1512
  def datetime_local_field(object_name, method, options = T.unsafe(nil)); end

  def default_form_builder; end
  def default_form_builder=(_arg0); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1566
  def email_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1079
  def fields(scope = T.unsafe(nil), model: T.unsafe(nil), **options, &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1028
  def fields_for(record_name, record_object = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1247
  def file_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#435
  def form_for(record, options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#755
  def form_with(model: T.unsafe(nil), scope: T.unsafe(nil), url: T.unsafe(nil), format: T.unsafe(nil), **options, &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#481
  def form_with_generates_ids; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#481
  def form_with_generates_ids=(val); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#479
  def form_with_generates_remote_forms; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#479
  def form_with_generates_remote_forms=(val); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1214
  def hidden_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1151
  def label(object_name, method, content_or_options = T.unsafe(nil), options = T.unsafe(nil), &block); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1531
  def month_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#483
  def multiple_file_field_include_hidden; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#483
  def multiple_file_field_include_hidden=(val); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1575
  def number_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1196
  def password_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1407
  def phone_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1367
  def radio_button(object_name, method, tag_value, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1584
  def range_field(object_name, method, options = T.unsafe(nil)); end

  def rich_text_area(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1398
  def search_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1407
  def telephone_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1277
  def text_area(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1175
  def text_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1477
  def time_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1557
  def url_field(object_name, method, options = T.unsafe(nil)); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1548
  def week_field(object_name, method, options = T.unsafe(nil)); end

  private

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#465
  def apply_form_for_options!(object, options); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1622
  def default_form_builder_class; end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1593
  def html_options_for_form_with(url_for_options = T.unsafe(nil), model = T.unsafe(nil), html: T.unsafe(nil), local: T.unsafe(nil), skip_enforcing_utf8: T.unsafe(nil), **options); end

  # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#1608
  def instantiate_builder(record_name, record_object, options); end

  class << self
    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#481
    def form_with_generates_ids; end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#481
    def form_with_generates_ids=(val); end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#479
    def form_with_generates_remote_forms; end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#479
    def form_with_generates_remote_forms=(val); end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#483
    def multiple_file_field_include_hidden; end

    # source://actionview/7.2.1/lib/action_view/helpers/form_helper.rb#483
    def multiple_file_field_include_hidden=(val); end
  end
end

module ActionView::Helpers::Tags; end

class ActionView::Helpers::Tags::ActionText < ::ActionView::Helpers::Tags::Base
  include ::ActionView::Helpers::Tags::Placeholderable

  def dom_id(*_arg0, **_arg1, &_arg2); end
  def render; end
end
