# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `activemodel` gem.
# Please instead update this file by running `bin/tapioca gem activemodel`.


# :include: ../README.rdoc
#
# source://activemodel//lib/active_model/gem_version.rb#3
module ActiveModel
  extend ::ActiveSupport::Autoload

  class << self
    # source://activemodel//lib/active_model/deprecator.rb#4
    def deprecator; end

    # source://activemodel//lib/active_model.rb#76
    def eager_load!; end

    # Returns the currently loaded version of \Active \Model as a +Gem::Version+.
    #
    # source://activemodel//lib/active_model/gem_version.rb#5
    def gem_version; end

    # Returns the currently loaded version of \Active \Model as a +Gem::Version+.
    #
    # source://activemodel//lib/active_model/version.rb#7
    def version; end
  end
end

# = Active \Model \API
#
# Includes the required interface for an object to interact with
# Action Pack and Action View, using different Active \Model modules.
# It includes model name introspections, conversions, translations, and
# validations. Besides that, it allows you to initialize the object with a
# hash of attributes, pretty much like Active Record does.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::API
#     attr_accessor :name, :age
#   end
#
#   person = Person.new(name: 'bob', age: '18')
#   person.name # => "bob"
#   person.age  # => "18"
#
# Note that, by default, +ActiveModel::API+ implements #persisted?
# to return +false+, which is the most common case. You may want to override
# it in your class to simulate a different scenario:
#
#   class Person
#     include ActiveModel::API
#     attr_accessor :id, :name
#
#     def persisted?
#       self.id.present?
#     end
#   end
#
#   person = Person.new(id: 1, name: 'bob')
#   person.persisted? # => true
#
# Also, if for some reason you need to run code on initialize ( ::new ), make
# sure you call +super+ if you want the attributes hash initialization to
# happen.
#
#   class Person
#     include ActiveModel::API
#     attr_accessor :id, :name, :omg
#
#     def initialize(attributes={})
#       super
#       @omg ||= true
#     end
#   end
#
#   person = Person.new(id: 1, name: 'bob')
#   person.omg # => true
#
# For more detailed information on other functionalities available, please
# refer to the specific modules included in +ActiveModel::API+
# (see below).
#
# source://activemodel//lib/active_model/api.rb#59
module ActiveModel::API
  include ::ActiveModel::ForbiddenAttributesProtection
  include ::ActiveModel::AttributeAssignment
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods
  include ::ActiveModel::Validations
  include ::ActiveModel::Conversion

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Validations::ClassMethods
  mixes_in_class_methods ::ActiveModel::Callbacks
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::ActiveModel::Translation
  mixes_in_class_methods ::ActiveModel::Validations::HelperMethods
  mixes_in_class_methods ::ActiveModel::Conversion::ClassMethods

  # Initializes a new model with the given +params+.
  #
  #   class Person
  #     include ActiveModel::API
  #     attr_accessor :name, :age
  #   end
  #
  #   person = Person.new(name: 'bob', age: '18')
  #   person.name # => "bob"
  #   person.age  # => "18"
  #
  # source://activemodel//lib/active_model/api.rb#80
  def initialize(attributes = T.unsafe(nil)); end

  # Indicates if the model is persisted. Default is +false+.
  #
  #  class Person
  #    include ActiveModel::API
  #    attr_accessor :id, :name
  #  end
  #
  #  person = Person.new(id: 1, name: 'bob')
  #  person.persisted? # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/api.rb#95
  def persisted?; end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
    def _validators; end
    def _validators=(value); end
    def _validators?; end
    def param_delimiter; end
    def param_delimiter=(value); end
    def param_delimiter?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
    def _validators; end
    def _validators?; end
    def param_delimiter=(value); end
  end
end

# source://activemodel//lib/active_model/access.rb#7
module ActiveModel::Access
  # source://activemodel//lib/active_model/access.rb#8
  def slice(*methods); end

  # source://activemodel//lib/active_model/access.rb#12
  def values_at(*methods); end
end

# source://activemodel//lib/active_model/attribute.rb#6
class ActiveModel::Attribute
  # This method should not be called directly.
  # Use #from_database or #from_user
  #
  # @return [Attribute] a new instance of Attribute
  #
  # source://activemodel//lib/active_model/attribute.rb#33
  def initialize(name, value_before_type_cast, type, original_attribute = T.unsafe(nil), value = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute.rb#115
  def ==(other); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#107
  def came_from_user?; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#66
  def changed?; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#70
  def changed_in_place?; end

  # source://activemodel//lib/active_model/attribute.rb#135
  def encode_with(coder); end

  # source://activemodel//lib/active_model/attribute.rb#115
  def eql?(other); end

  # source://activemodel//lib/active_model/attribute.rb#74
  def forgetting_assignment; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#111
  def has_been_read?; end

  # source://activemodel//lib/active_model/attribute.rb#123
  def hash; end

  # source://activemodel//lib/active_model/attribute.rb#127
  def init_with(coder); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#103
  def initialized?; end

  # Returns the value of attribute name.
  #
  # source://activemodel//lib/active_model/attribute.rb#29
  def name; end

  # source://activemodel//lib/active_model/attribute.rb#47
  def original_value; end

  # source://activemodel//lib/active_model/attribute.rb#143
  def original_value_for_database; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#62
  def serializable?(&block); end

  # Returns the value of attribute type.
  #
  # source://activemodel//lib/active_model/attribute.rb#29
  def type; end

  # @raise [NotImplementedError]
  #
  # source://activemodel//lib/active_model/attribute.rb#99
  def type_cast(*_arg0); end

  # source://activemodel//lib/active_model/attribute.rb#41
  def value; end

  # Returns the value of attribute value_before_type_cast.
  #
  # source://activemodel//lib/active_model/attribute.rb#29
  def value_before_type_cast; end

  # source://activemodel//lib/active_model/attribute.rb#55
  def value_for_database; end

  # source://activemodel//lib/active_model/attribute.rb#87
  def with_cast_value(value); end

  # source://activemodel//lib/active_model/attribute.rb#91
  def with_type(type); end

  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#7
  def with_user_default(value); end

  # source://activemodel//lib/active_model/attribute.rb#83
  def with_value_from_database(value); end

  # source://activemodel//lib/active_model/attribute.rb#78
  def with_value_from_user(value); end

  private

  # source://activemodel//lib/active_model/attribute.rb#169
  def _original_value_for_database; end

  # source://activemodel//lib/active_model/attribute.rb#165
  def _value_for_database; end

  # Returns the value of attribute original_attribute.
  #
  # source://activemodel//lib/active_model/attribute.rb#152
  def assigned?; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#161
  def changed_from_assignment?; end

  # source://activemodel//lib/active_model/attribute.rb#155
  def initialize_dup(other); end

  # Returns the value of attribute original_attribute.
  #
  # source://activemodel//lib/active_model/attribute.rb#152
  def original_attribute; end

  class << self
    # source://activemodel//lib/active_model/attribute.rb#8
    def from_database(name, value_before_type_cast, type, value = T.unsafe(nil)); end

    # source://activemodel//lib/active_model/attribute.rb#12
    def from_user(name, value_before_type_cast, type, original_attribute = T.unsafe(nil)); end

    # source://activemodel//lib/active_model/attribute.rb#20
    def null(name); end

    # source://activemodel//lib/active_model/attribute.rb#24
    def uninitialized(name, type); end

    # source://activemodel//lib/active_model/attribute.rb#16
    def with_cast_value(name, value_before_type_cast, type); end
  end
end

# source://activemodel//lib/active_model/attribute.rb#173
class ActiveModel::Attribute::FromDatabase < ::ActiveModel::Attribute
  # source://activemodel//lib/active_model/attribute.rb#178
  def forgetting_assignment; end

  # source://activemodel//lib/active_model/attribute.rb#174
  def type_cast(value); end

  private

  # source://activemodel//lib/active_model/attribute.rb#192
  def _original_value_for_database; end
end

# source://activemodel//lib/active_model/attribute.rb#197
class ActiveModel::Attribute::FromUser < ::ActiveModel::Attribute
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#202
  def came_from_user?; end

  # source://activemodel//lib/active_model/attribute.rb#198
  def type_cast(value); end

  private

  # source://activemodel//lib/active_model/attribute.rb#207
  def _value_for_database; end
end

# source://activemodel//lib/active_model/attribute.rb#222
class ActiveModel::Attribute::Null < ::ActiveModel::Attribute
  # @return [Null] a new instance of Null
  #
  # source://activemodel//lib/active_model/attribute.rb#223
  def initialize(name); end

  # source://activemodel//lib/active_model/attribute.rb#227
  def type_cast(*_arg0); end

  # @raise [ActiveModel::MissingAttributeError]
  #
  # source://activemodel//lib/active_model/attribute.rb#235
  def with_cast_value(value); end

  # source://activemodel//lib/active_model/attribute.rb#231
  def with_type(type); end

  # @raise [ActiveModel::MissingAttributeError]
  #
  # source://activemodel//lib/active_model/attribute.rb#235
  def with_value_from_database(value); end

  # @raise [ActiveModel::MissingAttributeError]
  #
  # source://activemodel//lib/active_model/attribute.rb#235
  def with_value_from_user(value); end
end

# source://activemodel//lib/active_model/attribute.rb#242
class ActiveModel::Attribute::Uninitialized < ::ActiveModel::Attribute
  # @return [Uninitialized] a new instance of Uninitialized
  #
  # source://activemodel//lib/active_model/attribute.rb#245
  def initialize(name, type); end

  # source://activemodel//lib/active_model/attribute.rb#266
  def forgetting_assignment; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#262
  def initialized?; end

  # source://activemodel//lib/active_model/attribute.rb#255
  def original_value; end

  # source://activemodel//lib/active_model/attribute.rb#249
  def value; end

  # source://activemodel//lib/active_model/attribute.rb#259
  def value_for_database; end

  # source://activemodel//lib/active_model/attribute.rb#270
  def with_type(type); end
end

# source://activemodel//lib/active_model/attribute.rb#243
ActiveModel::Attribute::Uninitialized::UNINITIALIZED_ORIGINAL_VALUE = T.let(T.unsafe(nil), Object)

# source://activemodel//lib/active_model/attribute/user_provided_default.rb#11
class ActiveModel::Attribute::UserProvidedDefault < ::ActiveModel::Attribute::FromUser
  # @return [UserProvidedDefault] a new instance of UserProvidedDefault
  #
  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#12
  def initialize(name, value, type, database_default); end

  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#29
  def marshal_dump; end

  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#40
  def marshal_load(values); end

  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#17
  def value_before_type_cast; end

  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#25
  def with_type(type); end

  private

  # Returns the value of attribute user_provided_value.
  #
  # source://activemodel//lib/active_model/attribute/user_provided_default.rb#52
  def user_provided_value; end
end

# source://activemodel//lib/active_model/attribute.rb#212
class ActiveModel::Attribute::WithCastValue < ::ActiveModel::Attribute
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute.rb#217
  def changed_in_place?; end

  # source://activemodel//lib/active_model/attribute.rb#213
  def type_cast(value); end
end

# source://activemodel//lib/active_model/attribute_assignment.rb#6
module ActiveModel::AttributeAssignment
  include ::ActiveModel::ForbiddenAttributesProtection

  # Allows you to set all the attributes by passing in a hash of attributes with
  # keys matching the attribute names.
  #
  # If the passed hash responds to <tt>permitted?</tt> method and the return value
  # of this method is +false+ an ActiveModel::ForbiddenAttributesError
  # exception is raised.
  #
  #   class Cat
  #     include ActiveModel::AttributeAssignment
  #     attr_accessor :name, :status
  #   end
  #
  #   cat = Cat.new
  #   cat.assign_attributes(name: "Gorby", status: "yawning")
  #   cat.name # => 'Gorby'
  #   cat.status # => 'yawning'
  #   cat.assign_attributes(status: "sleeping")
  #   cat.name # => 'Gorby'
  #   cat.status # => 'sleeping'
  #
  # source://activemodel//lib/active_model/attribute_assignment.rb#28
  def assign_attributes(new_attributes); end

  # Allows you to set all the attributes by passing in a hash of attributes with
  # keys matching the attribute names.
  #
  # If the passed hash responds to <tt>permitted?</tt> method and the return value
  # of this method is +false+ an ActiveModel::ForbiddenAttributesError
  # exception is raised.
  #
  #   class Cat
  #     include ActiveModel::AttributeAssignment
  #     attr_accessor :name, :status
  #   end
  #
  #   cat = Cat.new
  #   cat.assign_attributes(name: "Gorby", status: "yawning")
  #   cat.name # => 'Gorby'
  #   cat.status # => 'yawning'
  #   cat.assign_attributes(status: "sleeping")
  #   cat.name # => 'Gorby'
  #   cat.status # => 'sleeping'
  #
  # source://activemodel//lib/active_model/attribute_assignment.rb#28
  def attributes=(new_attributes); end

  private

  # source://activemodel//lib/active_model/attribute_assignment.rb#46
  def _assign_attribute(k, v); end

  # source://activemodel//lib/active_model/attribute_assignment.rb#40
  def _assign_attributes(attributes); end
end

# = Active \Model \Attribute \Methods
#
# Provides a way to add prefixes and suffixes to your methods as
# well as handling the creation of ActiveRecord::Base - like
# class methods such as +table_name+.
#
# The requirements to implement +ActiveModel::AttributeMethods+ are to:
#
# * <tt>include ActiveModel::AttributeMethods</tt> in your class.
# * Call each of its methods you want to add, such as +attribute_method_suffix+
#   or +attribute_method_prefix+.
# * Call +define_attribute_methods+ after the other methods are called.
# * Define the various generic +_attribute+ methods that you have declared.
# * Define an +attributes+ method which returns a hash with each
#   attribute name in your model as hash key and the attribute value as hash value.
#   Hash keys must be strings.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::AttributeMethods
#
#     attribute_method_affix  prefix: 'reset_', suffix: '_to_default!'
#     attribute_method_suffix '_contrived?'
#     attribute_method_prefix 'clear_'
#     define_attribute_methods :name
#
#     attr_accessor :name
#
#     def attributes
#       { 'name' => @name }
#     end
#
#     private
#       def attribute_contrived?(attr)
#         true
#       end
#
#       def clear_attribute(attr)
#         send("#{attr}=", nil)
#       end
#
#       def reset_attribute_to_default!(attr)
#         send("#{attr}=", 'Default Name')
#       end
#   end
#
# source://activemodel//lib/active_model/attribute_methods.rb#64
module ActiveModel::AttributeMethods
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeMethods::ClassMethods

  # +attribute_missing+ is like +method_missing+, but for attributes. When
  # +method_missing+ is called we check to see if there is a matching
  # attribute method. If so, we tell +attribute_missing+ to dispatch the
  # attribute. This method can be overloaded to customize the behavior.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#515
  def attribute_missing(match, *_arg1, **_arg2, &_arg3); end

  # Allows access to the object attributes, which are held in the hash
  # returned by <tt>attributes</tt>, as though they were first-class
  # methods. So a +Person+ class with a +name+ attribute can for example use
  # <tt>Person#name</tt> and <tt>Person#name=</tt> and never directly use
  # the attributes hash -- except for multiple assignments with
  # <tt>ActiveRecord::Base#attributes=</tt>.
  #
  # It's also possible to instantiate related objects, so a <tt>Client</tt>
  # class belonging to the +clients+ table with a +master_id+ foreign key
  # can instantiate master through <tt>Client#master</tt>.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#502
  def method_missing(method, *_arg1, **_arg2, &_arg3); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#523
  def respond_to?(method, include_private_methods = T.unsafe(nil)); end

  # A +Person+ instance with a +name+ attribute can ask
  # <tt>person.respond_to?(:name)</tt>, <tt>person.respond_to?(:name=)</tt>,
  # and <tt>person.respond_to?(:name?)</tt> which will all return +true+.
  def respond_to_without_attributes?(*_arg0); end

  private

  # source://activemodel//lib/active_model/attribute_methods.rb#551
  def _read_attribute(attr); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#536
  def attribute_method?(attr_name); end

  # Returns a struct representing the matching attribute method.
  # The struct's attributes are prefix, base and suffix.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#542
  def matched_attribute_method(method_name); end

  # @raise [ActiveModel::MissingAttributeError]
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#547
  def missing_attribute(attr_name, stack); end

  module GeneratedClassMethods
    def attribute_aliases; end
    def attribute_aliases=(value); end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns=(value); end
    def attribute_method_patterns?; end
  end

  module GeneratedInstanceMethods
    def attribute_aliases; end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns?; end
  end
end

# source://activemodel//lib/active_model/attribute_methods.rb#555
module ActiveModel::AttributeMethods::AttrNames
  class << self
    # We want to generate the methods via module_eval rather than
    # define_method, because define_method is slower on dispatch.
    #
    # But sometimes the database might return columns with
    # characters that are not allowed in normal method names (like
    # 'my_column(omg)'. So to work around this we first define with
    # the __temp__ identifier, and then use alias method to rename
    # it to what we want.
    #
    # We are also defining a constant to hold the frozen string of
    # the attribute name. Using a constant means that we do not have
    # to allocate an object on each call to the attribute method.
    # Making it frozen means that it doesn't get duped when used to
    # key the @attributes in read_attribute.
    #
    # source://activemodel//lib/active_model/attribute_methods.rb#572
    def define_attribute_accessor_method(owner, attr_name, writer: T.unsafe(nil)); end
  end
end

# source://activemodel//lib/active_model/attribute_methods.rb#556
ActiveModel::AttributeMethods::AttrNames::DEF_SAFE_NAME = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/attribute_methods.rb#68
ActiveModel::AttributeMethods::CALL_COMPILABLE_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/attribute_methods.rb#75
module ActiveModel::AttributeMethods::ClassMethods
  # Allows you to make aliases for attributes.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_suffix '_short?'
  #     define_attribute_methods :name
  #
  #     alias_attribute :nickname, :name
  #
  #     private
  #       def attribute_short?(attr)
  #         send(attr).length < 5
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = 'Bob'
  #   person.name            # => "Bob"
  #   person.nickname        # => "Bob"
  #   person.name_short?     # => true
  #   person.nickname_short? # => true
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#203
  def alias_attribute(new_name, old_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#221
  def alias_attribute_method_definition(code_generator, pattern, new_name, old_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#377
  def aliases_by_attribute_name; end

  # Returns the original name for the alias +name+
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#240
  def attribute_alias(name); end

  # Is +new_name+ an alias?
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#235
  def attribute_alias?(new_name); end

  # Declares a method available for all attributes with the given prefix
  # and suffix. Uses +method_missing+ and <tt>respond_to?</tt> to rewrite
  # the method.
  #
  #   #{prefix}#{attr}#{suffix}(*args, &block)
  #
  # to
  #
  #   #{prefix}attribute#{suffix}(#{attr}, *args, &block)
  #
  # An <tt>#{prefix}attribute#{suffix}</tt> instance method must exist and
  # accept at least the +attr+ argument.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_affix prefix: 'reset_', suffix: '_to_default!'
  #     define_attribute_methods :name
  #
  #     private
  #       def reset_attribute_to_default!(attr)
  #         send("#{attr}=", 'Default Name')
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name                         # => 'Gem'
  #   person.reset_name_to_default!
  #   person.name                         # => 'Default Name'
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#175
  def attribute_method_affix(*affixes); end

  # Declares a method available for all attributes with the given prefix.
  # Uses +method_missing+ and <tt>respond_to?</tt> to rewrite the method.
  #
  #   #{prefix}#{attr}(*args, &block)
  #
  # to
  #
  #   #{prefix}attribute(#{attr}, *args, &block)
  #
  # An instance method <tt>#{prefix}attribute</tt> must exist and accept
  # at least the +attr+ argument.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_prefix 'clear_'
  #     define_attribute_methods :name
  #
  #     private
  #       def clear_attribute(attr)
  #         send("#{attr}=", nil)
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = 'Bob'
  #   person.name          # => "Bob"
  #   person.clear_name
  #   person.name          # => nil
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#106
  def attribute_method_prefix(*prefixes, parameters: T.unsafe(nil)); end

  # Declares a method available for all attributes with the given suffix.
  # Uses +method_missing+ and <tt>respond_to?</tt> to rewrite the method.
  #
  #   #{attr}#{suffix}(*args, &block)
  #
  # to
  #
  #   attribute#{suffix}(#{attr}, *args, &block)
  #
  # An <tt>attribute#{suffix}</tt> instance method must exist and accept at
  # least the +attr+ argument.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_suffix '_short?'
  #     define_attribute_methods :name
  #
  #     private
  #       def attribute_short?(attr)
  #         send(attr).length < 5
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = 'Bob'
  #   person.name          # => "Bob"
  #   person.name_short?   # => true
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#140
  def attribute_method_suffix(*suffixes, parameters: T.unsafe(nil)); end

  # Declares an attribute that should be prefixed and suffixed by
  # +ActiveModel::AttributeMethods+.
  #
  # To use, pass an attribute name (as string or symbol). Be sure to declare
  # +define_attribute_method+ after you define any prefix, suffix or affix
  # method, or they will not hook in.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_suffix '_short?'
  #
  #     # Call to define_attribute_method must appear after the
  #     # attribute_method_prefix, attribute_method_suffix or
  #     # attribute_method_affix declarations.
  #     define_attribute_method :name
  #
  #     private
  #       def attribute_short?(attr)
  #         send(attr).length < 5
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = 'Bob'
  #   person.name        # => "Bob"
  #   person.name_short? # => true
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#306
  def define_attribute_method(attr_name, _owner: T.unsafe(nil), as: T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_methods.rb#315
  def define_attribute_method_pattern(pattern, attr_name, owner:, as:, override: T.unsafe(nil)); end

  # Declares the attributes that should be prefixed and suffixed by
  # +ActiveModel::AttributeMethods+.
  #
  # To use, pass attribute names (as strings or symbols). Be sure to declare
  # +define_attribute_methods+ after you define any prefix, suffix, or affix
  # methods, or they will not hook in.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name, :age, :address
  #     attribute_method_prefix 'clear_'
  #
  #     # Call to define_attribute_methods must appear after the
  #     # attribute_method_prefix, attribute_method_suffix or
  #     # attribute_method_affix declarations.
  #     define_attribute_methods :name, :age, :address
  #
  #     private
  #       def clear_attribute(attr)
  #         send("#{attr}=", nil)
  #       end
  #   end
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#267
  def define_attribute_methods(*attr_names); end

  # source://activemodel//lib/active_model/attribute_methods.rb#211
  def eagerly_generate_alias_attribute_methods(new_name, old_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#217
  def generate_alias_attribute_methods(code_generator, new_name, old_name); end

  # Removes all the previously dynamically defined methods from the class, including alias attribute methods.
  #
  #   class Person
  #     include ActiveModel::AttributeMethods
  #
  #     attr_accessor :name
  #     attribute_method_suffix '_short?'
  #     define_attribute_method :name
  #     alias_attribute :first_name, :name
  #
  #     private
  #       def attribute_short?(attr)
  #         send(attr).length < 5
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = 'Bob'
  #   person.first_name  # => "Bob"
  #   person.name_short? # => true
  #
  #   Person.undefine_attribute_methods
  #
  #   person.name_short? # => NoMethodError
  #   person.first_name  # => NoMethodError
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#370
  def undefine_attribute_methods; end

  private

  # The methods +method_missing+ and +respond_to?+ of this module are
  # invoked often in a typical rails, both of which invoke the method
  # +matched_attribute_method+. The latter method iterates through an
  # array doing regular expression matches, which results in a lot of
  # object creations. Most of the time it returns a +nil+ match. As the
  # match result is always the same given a +method_name+, this cache is
  # used to alleviate the GC, which ultimately also speeds up the app
  # significantly (in our case our test suite finishes 10% faster with
  # this cache).
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#412
  def attribute_method_patterns_cache; end

  # source://activemodel//lib/active_model/attribute_methods.rb#416
  def attribute_method_patterns_matching(method_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#440
  def build_mangled_name(name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#450
  def define_call(code_generator, name, target_name, mangled_name, parameters, call_args, namespace:, as:); end

  # Define a method `name` in `mod` that dispatches to `send`
  # using the given `extra` args. This falls back on `send`
  # if the called name cannot be compiled.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#425
  def define_proxy_call(code_generator, name, proxy_target, parameters, *call_args, namespace:, as: T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_methods.rb#395
  def generated_attribute_methods; end

  # source://activemodel//lib/active_model/attribute_methods.rb#382
  def inherited(base); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#399
  def instance_method_already_implemented?(method_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#391
  def resolve_attribute_name(name); end
end

# source://activemodel//lib/active_model/attribute_methods.rb#466
class ActiveModel::AttributeMethods::ClassMethods::AttributeMethodPattern
  # @return [AttributeMethodPattern] a new instance of AttributeMethodPattern
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#471
  def initialize(prefix: T.unsafe(nil), suffix: T.unsafe(nil), parameters: T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_methods.rb#480
  def match(method_name); end

  # source://activemodel//lib/active_model/attribute_methods.rb#486
  def method_name(attr_name); end

  # Returns the value of attribute parameters.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#467
  def parameters; end

  # Returns the value of attribute prefix.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#467
  def prefix; end

  # Returns the value of attribute proxy_target.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#467
  def proxy_target; end

  # Returns the value of attribute suffix.
  #
  # source://activemodel//lib/active_model/attribute_methods.rb#467
  def suffix; end
end

# source://activemodel//lib/active_model/attribute_methods.rb#469
class ActiveModel::AttributeMethods::ClassMethods::AttributeMethodPattern::AttributeMethod < ::Struct
  # Returns the value of attribute attr_name
  #
  # @return [Object] the current value of attr_name
  def attr_name; end

  # Sets the attribute attr_name
  #
  # @param value [Object] the value to set the attribute attr_name to.
  # @return [Object] the newly set value
  def attr_name=(_); end

  # Returns the value of attribute proxy_target
  #
  # @return [Object] the current value of proxy_target
  def proxy_target; end

  # Sets the attribute proxy_target
  #
  # @param value [Object] the value to set the attribute proxy_target to.
  # @return [Object] the newly set value
  def proxy_target=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://activemodel//lib/active_model/attribute_methods.rb#67
ActiveModel::AttributeMethods::NAME_COMPILABLE_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/attribute_mutation_tracker.rb#7
class ActiveModel::AttributeMutationTracker
  # @return [AttributeMutationTracker] a new instance of AttributeMutationTracker
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#10
  def initialize(attributes); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#40
  def any_changes?; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#34
  def change_to_attribute(attr_name); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#44
  def changed?(attr_name, from: T.unsafe(nil), to: T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#14
  def changed_attribute_names; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#50
  def changed_in_place?(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#18
  def changed_values; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#26
  def changes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#63
  def force_change(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#54
  def forget_change(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#59
  def original_value(attr_name); end

  private

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#74
  def attr_names; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#78
  def attribute_changed?(attr_name); end

  # Returns the value of attribute attributes.
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#68
  def attributes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#82
  def fetch_value(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#70
  def forced_changes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#86
  def type_cast(attr_name, value); end
end

# source://activemodel//lib/active_model/attribute_mutation_tracker.rb#8
ActiveModel::AttributeMutationTracker::OPTION_NOT_GIVEN = T.let(T.unsafe(nil), Object)

# source://activemodel//lib/active_model/attribute_registration.rb#8
module ActiveModel::AttributeRegistration
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveModel::AttributeRegistration::ClassMethods
end

# source://activemodel//lib/active_model/attribute_registration.rb#11
module ActiveModel::AttributeRegistration::ClassMethods
  # source://activemodel//lib/active_model/attribute_registration.rb#31
  def _default_attributes; end

  # source://activemodel//lib/active_model/attribute_registration.rb#12
  def attribute(name, type = T.unsafe(nil), default: T.unsafe(nil), **options); end

  # source://activemodel//lib/active_model/attribute_registration.rb#37
  def attribute_types; end

  # source://activemodel//lib/active_model/attribute_registration.rb#23
  def decorate_attributes(names = T.unsafe(nil), &decorator); end

  # source://activemodel//lib/active_model/attribute_registration.rb#43
  def type_for_attribute(attribute_name, &block); end

  private

  # source://activemodel//lib/active_model/attribute_registration.rb#81
  def apply_pending_attribute_modifications(attribute_set); end

  # Hook for other modules to override. The attribute type is passed
  # through this method immediately after it is resolved, before any type
  # decorations are applied.
  #
  # source://activemodel//lib/active_model/attribute_registration.rb#112
  def hook_attribute_type(attribute, type); end

  # source://activemodel//lib/active_model/attribute_registration.rb#77
  def pending_attribute_modifications; end

  # source://activemodel//lib/active_model/attribute_registration.rb#91
  def reset_default_attributes; end

  # source://activemodel//lib/active_model/attribute_registration.rb#96
  def reset_default_attributes!; end

  # source://activemodel//lib/active_model/attribute_registration.rb#101
  def resolve_attribute_name(name); end

  # source://activemodel//lib/active_model/attribute_registration.rb#105
  def resolve_type_name(name, **options); end
end

# source://activemodel//lib/active_model/attribute_registration.rb#67
class ActiveModel::AttributeRegistration::ClassMethods::PendingDecorator < ::Struct
  # source://activemodel//lib/active_model/attribute_registration.rb#68
  def apply_to(attribute_set); end

  # Returns the value of attribute decorator
  #
  # @return [Object] the current value of decorator
  def decorator; end

  # Sets the attribute decorator
  #
  # @param value [Object] the value to set the attribute decorator to.
  # @return [Object] the newly set value
  def decorator=(_); end

  # Returns the value of attribute names
  #
  # @return [Object] the current value of names
  def names; end

  # Sets the attribute names
  #
  # @param value [Object] the value to set the attribute names to.
  # @return [Object] the newly set value
  def names=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://activemodel//lib/active_model/attribute_registration.rb#61
class ActiveModel::AttributeRegistration::ClassMethods::PendingDefault < ::Struct
  # source://activemodel//lib/active_model/attribute_registration.rb#62
  def apply_to(attribute_set); end

  # Returns the value of attribute default
  #
  # @return [Object] the current value of default
  def default; end

  # Sets the attribute default
  #
  # @param value [Object] the value to set the attribute default to.
  # @return [Object] the newly set value
  def default=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://activemodel//lib/active_model/attribute_registration.rb#54
class ActiveModel::AttributeRegistration::ClassMethods::PendingType < ::Struct
  # source://activemodel//lib/active_model/attribute_registration.rb#55
  def apply_to(attribute_set); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  # Returns the value of attribute type
  #
  # @return [Object] the current value of type
  def type; end

  # Sets the attribute type
  #
  # @param value [Object] the value to set the attribute type to.
  # @return [Object] the newly set value
  def type=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://activemodel//lib/active_model/attribute_set/builder.rb#6
class ActiveModel::AttributeSet
  # @return [AttributeSet] a new instance of AttributeSet
  #
  # source://activemodel//lib/active_model/attribute_set.rb#12
  def initialize(attributes); end

  # source://activemodel//lib/active_model/attribute_set.rb#106
  def ==(other); end

  # source://activemodel//lib/active_model/attribute_set.rb#16
  def [](name); end

  # source://activemodel//lib/active_model/attribute_set.rb#20
  def []=(name, value); end

  # source://activemodel//lib/active_model/attribute_set.rb#93
  def accessed; end

  # source://activemodel//lib/active_model/attribute_set.rb#24
  def cast_types; end

  # source://activemodel//lib/active_model/attribute_set.rb#73
  def deep_dup; end

  # source://activemodel//lib/active_model/attribute_set.rb#10
  def each_value(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/attribute_set.rb#10
  def except(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/attribute_set.rb#10
  def fetch(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/attribute_set.rb#50
  def fetch_value(name, &block); end

  # source://activemodel//lib/active_model/attribute_set.rb#68
  def freeze; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_set.rb#41
  def include?(name); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_set.rb#41
  def key?(name); end

  # source://activemodel//lib/active_model/attribute_set.rb#46
  def keys; end

  # source://activemodel//lib/active_model/attribute_set.rb#97
  def map(&block); end

  # source://activemodel//lib/active_model/attribute_set.rb#87
  def reset(key); end

  # source://activemodel//lib/active_model/attribute_set.rb#102
  def reverse_merge!(target_attributes); end

  # source://activemodel//lib/active_model/attribute_set.rb#36
  def to_h; end

  # source://activemodel//lib/active_model/attribute_set.rb#36
  def to_hash; end

  # source://activemodel//lib/active_model/attribute_set.rb#28
  def values_before_type_cast; end

  # source://activemodel//lib/active_model/attribute_set.rb#32
  def values_for_database; end

  # source://activemodel//lib/active_model/attribute_set.rb#64
  def write_cast_value(name, value); end

  # source://activemodel//lib/active_model/attribute_set.rb#54
  def write_from_database(name, value); end

  # @raise [FrozenError]
  #
  # source://activemodel//lib/active_model/attribute_set.rb#58
  def write_from_user(name, value); end

  protected

  # Returns the value of attribute attributes.
  #
  # source://activemodel//lib/active_model/attribute_set.rb#111
  def attributes; end

  private

  # source://activemodel//lib/active_model/attribute_set.rb#114
  def default_attribute(name); end

  # source://activemodel//lib/active_model/attribute_set.rb#82
  def initialize_clone(_); end

  # source://activemodel//lib/active_model/attribute_set.rb#77
  def initialize_dup(_); end
end

# source://activemodel//lib/active_model/attribute_set/builder.rb#7
class ActiveModel::AttributeSet::Builder
  # @return [Builder] a new instance of Builder
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#10
  def initialize(types, default_attributes = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#15
  def build_from_database(values = T.unsafe(nil), additional_types = T.unsafe(nil)); end

  # Returns the value of attribute default_attributes.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#8
  def default_attributes; end

  # Returns the value of attribute types.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#8
  def types; end
end

# Attempts to do more intelligent YAML dumping of an
# ActiveModel::AttributeSet to reduce the size of the resulting string
#
# source://activemodel//lib/active_model/attribute_set/yaml_encoder.rb#7
class ActiveModel::AttributeSet::YAMLEncoder
  # @return [YAMLEncoder] a new instance of YAMLEncoder
  #
  # source://activemodel//lib/active_model/attribute_set/yaml_encoder.rb#8
  def initialize(default_types); end

  # source://activemodel//lib/active_model/attribute_set/yaml_encoder.rb#22
  def decode(coder); end

  # source://activemodel//lib/active_model/attribute_set/yaml_encoder.rb#12
  def encode(attribute_set, coder); end

  private

  # Returns the value of attribute default_types.
  #
  # source://activemodel//lib/active_model/attribute_set/yaml_encoder.rb#37
  def default_types; end
end

# = Active \Model \Attributes
#
# The Attributes module allows models to define attributes beyond simple Ruby
# readers and writers. Similar to Active Record attributes, which are
# typically inferred from the database schema, Active Model Attributes are
# aware of data types, can have default values, and can handle casting and
# serialization.
#
# To use Attributes, include the module in your model class and define your
# attributes using the +attribute+ macro. It accepts a name, a type, a default
# value, and any other options supported by the attribute type.
#
# ==== Examples
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :name, :string
#     attribute :active, :boolean, default: true
#   end
#
#   person = Person.new
#   person.name = "Volmer"
#
#   person.name # => "Volmer"
#   person.active # => true
#
# source://activemodel//lib/active_model/attributes.rb#30
module ActiveModel::Attributes
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveModel::AttributeRegistration
  include ::ActiveModel::AttributeMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeRegistration::ClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeMethods::ClassMethods
  mixes_in_class_methods ::ActiveModel::Attributes::ClassMethods

  # source://activemodel//lib/active_model/attributes.rb#106
  def initialize(*_arg0); end

  # Returns an array of attribute names as strings.
  #
  #   class Person
  #     include ActiveModel::Attributes
  #
  #     attribute :name, :string
  #     attribute :age, :integer
  #   end
  #
  #   person = Person.new
  #   person.attribute_names # => ["name", "age"]
  #
  # source://activemodel//lib/active_model/attributes.rb#146
  def attribute_names; end

  # Returns a hash of all the attributes with their names as keys and the
  # values of the attributes as values.
  #
  #   class Person
  #     include ActiveModel::Attributes
  #
  #     attribute :name, :string
  #     attribute :age, :integer
  #   end
  #
  #   person = Person.new
  #   person.name = "Francesco"
  #   person.age = 22
  #
  #   person.attributes # => { "name" => "Francesco", "age" => 22}
  #
  # source://activemodel//lib/active_model/attributes.rb#131
  def attributes; end

  # source://activemodel//lib/active_model/attributes.rb#150
  def freeze; end

  private

  # source://activemodel//lib/active_model/attributes.rb#156
  def _write_attribute(attr_name, value); end

  # source://activemodel//lib/active_model/attributes.rb#161
  def attribute(attr_name); end

  # source://activemodel//lib/active_model/attributes.rb#156
  def attribute=(attr_name, value); end

  # source://activemodel//lib/active_model/attributes.rb#111
  def initialize_dup(other); end

  module GeneratedClassMethods
    def attribute_aliases; end
    def attribute_aliases=(value); end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns=(value); end
    def attribute_method_patterns?; end
  end

  module GeneratedInstanceMethods
    def attribute_aliases; end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns?; end
  end
end

# source://activemodel//lib/active_model/attributes.rb#39
module ActiveModel::Attributes::ClassMethods
  # :call-seq: attribute(name, cast_type = nil, default: nil, **options)
  #
  # Defines a model attribute. In addition to the attribute name, a cast
  # type and default value may be specified, as well as any options
  # supported by the given cast type.
  #
  #   class Person
  #     include ActiveModel::Attributes
  #
  #     attribute :name, :string
  #     attribute :active, :boolean, default: true
  #   end
  #
  #   person = Person.new
  #   person.name = "Volmer"
  #
  #   person.name   # => "Volmer"
  #   person.active # => true
  #
  # source://activemodel//lib/active_model/attributes.rb#59
  def attribute(name, *_arg1, **_arg2, &_arg3); end

  # Returns an array of attribute names as strings.
  #
  #   class Person
  #     include ActiveModel::Attributes
  #
  #     attribute :name, :string
  #     attribute :age, :integer
  #   end
  #
  #   Person.attribute_names # => ["name", "age"]
  #
  # source://activemodel//lib/active_model/attributes.rb#74
  def attribute_names; end

  private

  # source://activemodel//lib/active_model/attributes.rb#92
  def define_method_attribute=(canonical_name, owner:, as: T.unsafe(nil)); end
end

# +BlockValidator+ is a special +EachValidator+ which receives a block on initialization
# and call this block for each attribute being validated. +validates_each+ uses this validator.
#
# source://activemodel//lib/active_model/validator.rb#179
class ActiveModel::BlockValidator < ::ActiveModel::EachValidator
  # @return [BlockValidator] a new instance of BlockValidator
  #
  # source://activemodel//lib/active_model/validator.rb#180
  def initialize(options, &block); end

  private

  # source://activemodel//lib/active_model/validator.rb#186
  def validate_each(record, attribute, value); end
end

# = Active \Model \Callbacks
#
# Provides an interface for any class to have Active Record like callbacks.
#
# Like the Active Record methods, the callback chain is aborted as soon as
# one of the methods throws +:abort+.
#
# First, extend +ActiveModel::Callbacks+ from the class you are creating:
#
#   class MyModel
#     extend ActiveModel::Callbacks
#   end
#
# Then define a list of methods that you want callbacks attached to:
#
#   define_model_callbacks :create, :update
#
# This will provide all three standard callbacks (before, around and after)
# for both the <tt>:create</tt> and <tt>:update</tt> methods. To implement,
# you need to wrap the methods you want callbacks on in a block so that the
# callbacks get a chance to fire:
#
#   def create
#     run_callbacks :create do
#       # Your create action methods here
#     end
#   end
#
# Then in your class, you can use the +before_create+, +after_create+, and
# +around_create+ methods, just as you would in an Active Record model.
#
#   before_create :action_before_create
#
#   def action_before_create
#     # Your code here
#   end
#
# When defining an around callback remember to yield to the block, otherwise
# it won't be executed:
#
#  around_create :log_status
#
#  def log_status
#    puts 'going to call the block...'
#    yield
#    puts 'block successfully called.'
#  end
#
# You can choose to have only specific callbacks by passing a hash to the
# +define_model_callbacks+ method.
#
#   define_model_callbacks :create, only: [:after, :before]
#
# Would only create the +after_create+ and +before_create+ callback methods in
# your class.
#
# NOTE: Defining the same callback multiple times will overwrite previous callback definitions.
#
# source://activemodel//lib/active_model/callbacks.rb#65
module ActiveModel::Callbacks
  # +define_model_callbacks+ accepts the same options +define_callbacks+ does,
  # in case you want to overwrite a default. Besides that, it also accepts an
  # <tt>:only</tt> option, where you can choose if you want all types (before,
  # around or after) or just some.
  #
  #   define_model_callbacks :initialize, only: :after
  #
  # Note, the <tt>only: <type></tt> hash will apply to all callbacks defined
  # on that method call. To get around this you can call the +define_model_callbacks+
  # method as many times as you need.
  #
  #   define_model_callbacks :create,  only: :after
  #   define_model_callbacks :update,  only: :before
  #   define_model_callbacks :destroy, only: :around
  #
  # Would create +after_create+, +before_update+, and +around_destroy+ methods
  # only.
  #
  # You can pass in a class to before_<type>, after_<type> and around_<type>,
  # in which case the callback will call that class's <action>_<type> method
  # passing the object that the callback is being called on.
  #
  #   class MyModel
  #     extend ActiveModel::Callbacks
  #     define_model_callbacks :create
  #
  #     before_create AnotherClass
  #   end
  #
  #   class AnotherClass
  #     def self.before_create( obj )
  #       # obj is the MyModel instance that the callback is being called on
  #     end
  #   end
  #
  # NOTE: +method_name+ passed to +define_model_callbacks+ must not end with
  # <tt>!</tt>, <tt>?</tt> or <tt>=</tt>.
  #
  # source://activemodel//lib/active_model/callbacks.rb#109
  def define_model_callbacks(*callbacks); end

  private

  # source://activemodel//lib/active_model/callbacks.rb#143
  def _define_after_model_callback(klass, callback); end

  # source://activemodel//lib/active_model/callbacks.rb#136
  def _define_around_model_callback(klass, callback); end

  # source://activemodel//lib/active_model/callbacks.rb#129
  def _define_before_model_callback(klass, callback); end

  class << self
    # source://activemodel//lib/active_model/callbacks.rb#66
    def extended(base); end
  end
end

# = Active \Model \Conversion
#
# Handles default conversions: to_model, to_key, to_param, and to_partial_path.
#
# Let's take for example this non-persisted object.
#
#   class ContactMessage
#     include ActiveModel::Conversion
#
#     # ContactMessage are never persisted in the DB
#     def persisted?
#       false
#     end
#   end
#
#   cm = ContactMessage.new
#   cm.to_model == cm  # => true
#   cm.to_key          # => nil
#   cm.to_param        # => nil
#   cm.to_partial_path # => "contact_messages/contact_message"
#
# source://activemodel//lib/active_model/conversion.rb#24
module ActiveModel::Conversion
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Conversion::ClassMethods

  # Returns an Array of all key attributes if any of the attributes is set, whether or not
  # the object is persisted. Returns +nil+ if there are no key attributes.
  #
  #   class Person
  #     include ActiveModel::Conversion
  #     attr_accessor :id
  #
  #     def initialize(id)
  #       @id = id
  #     end
  #   end
  #
  #   person = Person.new(1)
  #   person.to_key # => [1]
  #
  # source://activemodel//lib/active_model/conversion.rb#67
  def to_key; end

  # If your object is already designed to implement all of the \Active \Model
  # you can use the default <tt>:to_model</tt> implementation, which simply
  # returns +self+.
  #
  #   class Person
  #     include ActiveModel::Conversion
  #   end
  #
  #   person = Person.new
  #   person.to_model == person # => true
  #
  # If your model does not act like an \Active \Model object, then you should
  # define <tt>:to_model</tt> yourself returning a proxy object that wraps
  # your object with \Active \Model compliant methods.
  #
  # source://activemodel//lib/active_model/conversion.rb#49
  def to_model; end

  # Returns a +string+ representing the object's key suitable for use in URLs,
  # or +nil+ if <tt>persisted?</tt> is +false+.
  #
  #   class Person
  #     include ActiveModel::Conversion
  #     attr_accessor :id
  #
  #     def initialize(id)
  #       @id = id
  #     end
  #
  #     def persisted?
  #       true
  #     end
  #   end
  #
  #   person = Person.new(1)
  #   person.to_param # => "1"
  #
  # source://activemodel//lib/active_model/conversion.rb#90
  def to_param; end

  # Returns a +string+ identifying the path associated with the object.
  # ActionPack uses this to find a suitable partial to represent the object.
  #
  #   class Person
  #     include ActiveModel::Conversion
  #   end
  #
  #   person = Person.new
  #   person.to_partial_path # => "people/person"
  #
  # source://activemodel//lib/active_model/conversion.rb#103
  def to_partial_path; end

  module GeneratedClassMethods
    def param_delimiter; end
    def param_delimiter=(value); end
    def param_delimiter?; end
  end

  module GeneratedInstanceMethods
    def param_delimiter=(value); end
  end
end

# source://activemodel//lib/active_model/conversion.rb#107
module ActiveModel::Conversion::ClassMethods
  # Provide a class level cache for #to_partial_path. This is an
  # internal method and should not be accessed directly.
  #
  # source://activemodel//lib/active_model/conversion.rb#110
  def _to_partial_path; end
end

# = Active \Model \Dirty
#
# Provides a way to track changes in your object in the same way as
# Active Record does.
#
# The requirements for implementing ActiveModel::Dirty are:
#
# * <tt>include ActiveModel::Dirty</tt> in your object.
# * Call <tt>define_attribute_methods</tt> passing each method you want to
#   track.
# * Call <tt>*_will_change!</tt> before each change to the tracked attribute.
# * Call <tt>changes_applied</tt> after the changes are persisted.
# * Call <tt>clear_changes_information</tt> when you want to reset the changes
#   information.
# * Call <tt>restore_attributes</tt> when you want to restore previous data.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::Dirty
#
#     define_attribute_methods :name
#
#     def initialize
#       @name = nil
#     end
#
#     def name
#       @name
#     end
#
#     def name=(val)
#       name_will_change! unless val == @name
#       @name = val
#     end
#
#     def save
#       # do persistence work
#
#       changes_applied
#     end
#
#     def reload!
#       # get the values from the persistence layer
#
#       clear_changes_information
#     end
#
#     def rollback!
#       restore_attributes
#     end
#   end
#
# A newly instantiated +Person+ object is unchanged:
#
#   person = Person.new
#   person.changed? # => false
#
# Change the name:
#
#   person.name = 'Bob'
#   person.changed?       # => true
#   person.name_changed?  # => true
#   person.name_changed?(from: nil, to: "Bob") # => true
#   person.name_was       # => nil
#   person.name_change    # => [nil, "Bob"]
#   person.name = 'Bill'
#   person.name_change    # => [nil, "Bill"]
#
# Save the changes:
#
#   person.save
#   person.changed?      # => false
#   person.name_changed? # => false
#
# Reset the changes:
#
#   person.previous_changes         # => {"name" => [nil, "Bill"]}
#   person.name_previously_changed? # => true
#   person.name_previously_changed?(from: nil, to: "Bill") # => true
#   person.name_previous_change     # => [nil, "Bill"]
#   person.name_previously_was      # => nil
#   person.reload!
#   person.previous_changes         # => {}
#
# Rollback the changes:
#
#   person.name = "Uncle Bob"
#   person.rollback!
#   person.name          # => "Bill"
#   person.name_changed? # => false
#
# Assigning the same value leaves the attribute unchanged:
#
#   person.name = 'Bill'
#   person.name_changed? # => false
#   person.name_change   # => nil
#
# Which attributes have changed?
#
#   person.name = 'Bob'
#   person.changed # => ["name"]
#   person.changes # => {"name" => ["Bill", "Bob"]}
#
# If an attribute is modified in-place then make use of
# {*_will_change!}[rdoc-label:method-i-2A_will_change-21] to mark that the attribute is changing.
# Otherwise \Active \Model can't track changes to in-place attributes. Note
# that Active Record can detect in-place modifications automatically. You do
# not need to call <tt>*_will_change!</tt> on Active Record models.
#
#   person.name_will_change!
#   person.name_change # => ["Bill", "Bill"]
#   person.name << 'y'
#   person.name_change # => ["Bill", "Billy"]
#
# Methods can be invoked as +name_changed?+ or by passing an argument to the
# generic method <tt>attribute_changed?("name")</tt>.
#
# source://activemodel//lib/active_model/dirty.rb#123
module ActiveModel::Dirty
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveModel::AttributeMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::AttributeMethods::ClassMethods

  # source://activemodel//lib/active_model/dirty.rb#258
  def as_json(options = T.unsafe(nil)); end

  # Dispatch target for {*_changed?}[rdoc-label:method-i-2A_changed-3F] attribute methods.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/dirty.rb#293
  def attribute_changed?(attr_name, **options); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/dirty.rb#360
  def attribute_changed_in_place?(attr_name); end

  # Dispatch target for {*_previously_changed?}[rdoc-label:method-i-2A_previously_changed-3F] attribute methods.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/dirty.rb#303
  def attribute_previously_changed?(attr_name, **options); end

  # Dispatch target for {*_previously_was}[rdoc-label:method-i-2A_previously_was] attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#308
  def attribute_previously_was(attr_name); end

  # Dispatch target for {*_was}[rdoc-label:method-i-2A_was] attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#298
  def attribute_was(attr_name); end

  # Returns an array with the name of the attributes with unsaved changes.
  #
  #   person.changed # => []
  #   person.name = 'bob'
  #   person.changed # => ["name"]
  #
  # source://activemodel//lib/active_model/dirty.rb#288
  def changed; end

  # Returns +true+ if any of the attributes has unsaved changes, +false+ otherwise.
  #
  #   person.changed? # => false
  #   person.name = 'bob'
  #   person.changed? # => true
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/dirty.rb#279
  def changed?; end

  # Returns a hash of the attributes with unsaved changes indicating their original
  # values like <tt>attr => original value</tt>.
  #
  #   person.name # => "bob"
  #   person.name = 'robert'
  #   person.changed_attributes # => {"name" => "bob"}
  #
  # source://activemodel//lib/active_model/dirty.rb#336
  def changed_attributes; end

  # Returns a hash of changed attributes indicating their original
  # and new values like <tt>attr => [original value, new value]</tt>.
  #
  #   person.changes # => {}
  #   person.name = 'bob'
  #   person.changes # => { "name" => ["bill", "bob"] }
  #
  # source://activemodel//lib/active_model/dirty.rb#346
  def changes; end

  # Clears dirty data and moves +changes+ to +previous_changes+ and
  # +mutations_from_database+ to +mutations_before_last_save+ respectively.
  #
  # source://activemodel//lib/active_model/dirty.rb#265
  def changes_applied; end

  # source://activemodel//lib/active_model/dirty.rb#324
  def clear_attribute_changes(attr_names); end

  # Clears all dirty data: current changes and previous changes.
  #
  # source://activemodel//lib/active_model/dirty.rb#318
  def clear_changes_information; end

  # Returns a hash of attributes that were changed before the model was saved.
  #
  #   person.name # => "bob"
  #   person.name = 'robert'
  #   person.save
  #   person.previous_changes # => {"name" => ["bob", "robert"]}
  #
  # source://activemodel//lib/active_model/dirty.rb#356
  def previous_changes; end

  # Restore all previous data of the provided attributes.
  #
  # source://activemodel//lib/active_model/dirty.rb#313
  def restore_attributes(attr_names = T.unsafe(nil)); end

  private

  # Dispatch target for <tt>*_change</tt> attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#392
  def attribute_change(attr_name); end

  # Dispatch target for <tt>*_previous_change</tt> attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#397
  def attribute_previous_change(attr_name); end

  # Dispatch target for <tt>*_will_change!</tt> attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#402
  def attribute_will_change!(attr_name); end

  # source://activemodel//lib/active_model/dirty.rb#371
  def clear_attribute_change(attr_name); end

  # source://activemodel//lib/active_model/dirty.rb#383
  def forget_attribute_assignments; end

  # source://activemodel//lib/active_model/dirty.rb#365
  def init_internals; end

  # source://activemodel//lib/active_model/dirty.rb#248
  def initialize_dup(other); end

  # source://activemodel//lib/active_model/dirty.rb#387
  def mutations_before_last_save; end

  # source://activemodel//lib/active_model/dirty.rb#375
  def mutations_from_database; end

  # Dispatch target for <tt>restore_*!</tt> attribute methods.
  #
  # source://activemodel//lib/active_model/dirty.rb#407
  def restore_attribute!(attr_name); end

  module GeneratedClassMethods
    def attribute_aliases; end
    def attribute_aliases=(value); end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns=(value); end
    def attribute_method_patterns?; end
  end

  module GeneratedInstanceMethods
    def attribute_aliases; end
    def attribute_aliases?; end
    def attribute_method_patterns; end
    def attribute_method_patterns?; end
  end
end

# = Active \Model \EachValidator
#
# +EachValidator+ is a validator which iterates through the attributes given
# in the options hash invoking the <tt>validate_each</tt> method passing in the
# record, attribute, and value.
#
# All \Active \Model validations are built on top of this validator.
#
# source://activemodel//lib/active_model/validator.rb#134
class ActiveModel::EachValidator < ::ActiveModel::Validator
  # Returns a new validator instance. All options will be available via the
  # +options+ reader, however the <tt>:attributes</tt> option will be removed
  # and instead be made available through the +attributes+ reader.
  #
  # @raise [ArgumentError]
  # @return [EachValidator] a new instance of EachValidator
  #
  # source://activemodel//lib/active_model/validator.rb#140
  def initialize(options); end

  # Returns the value of attribute attributes.
  #
  # source://activemodel//lib/active_model/validator.rb#135
  def attributes; end

  # Hook method that gets called by the initializer allowing verification
  # that the arguments supplied are valid. You could for example raise an
  # +ArgumentError+ when invalid options are supplied.
  #
  # source://activemodel//lib/active_model/validator.rb#168
  def check_validity!; end

  # Performs validation on the supplied record. By default this will call
  # +validate_each+ to determine validity therefore subclasses should
  # override +validate_each+ with validation logic.
  #
  # source://activemodel//lib/active_model/validator.rb#150
  def validate(record); end

  # Override this method in subclasses with the validation logic, adding
  # errors to the records +errors+ array where necessary.
  #
  # @raise [NotImplementedError]
  #
  # source://activemodel//lib/active_model/validator.rb#161
  def validate_each(record, attribute, value); end

  private

  # source://activemodel//lib/active_model/validator.rb#172
  def prepare_value_for_validation(value, record, attr_name); end
end

# = Active \Model \Error
#
# Represents one single error
#
# source://activemodel//lib/active_model/error.rb#9
class ActiveModel::Error
  # @return [Error] a new instance of Error
  #
  # source://activemodel//lib/active_model/error.rb#103
  def initialize(base, attribute, type = T.unsafe(nil), **options); end

  # source://activemodel//lib/active_model/error.rb#190
  def ==(other); end

  # The attribute of +base+ which the error belongs to
  #
  # source://activemodel//lib/active_model/error.rb#121
  def attribute; end

  # The object which the error belongs to
  #
  # source://activemodel//lib/active_model/error.rb#119
  def base; end

  # Returns the error details.
  #
  #   error = ActiveModel::Error.new(person, :name, :too_short, count: 5)
  #   error.details
  #   # => { error: :too_short, count: 5 }
  #
  # source://activemodel//lib/active_model/error.rb#149
  def detail; end

  # Returns the error details.
  #
  #   error = ActiveModel::Error.new(person, :name, :too_short, count: 5)
  #   error.details
  #   # => { error: :too_short, count: 5 }
  #
  # source://activemodel//lib/active_model/error.rb#149
  def details; end

  # source://activemodel//lib/active_model/error.rb#190
  def eql?(other); end

  # Returns the full error message.
  #
  #   error = ActiveModel::Error.new(person, :name, :too_short, count: 5)
  #   error.full_message
  #   # => "Name is too short (minimum is 5 characters)"
  #
  # source://activemodel//lib/active_model/error.rb#159
  def full_message; end

  # source://activemodel//lib/active_model/error.rb#195
  def hash; end

  # source://activemodel//lib/active_model/error.rb#13
  def i18n_customize_full_message; end

  # source://activemodel//lib/active_model/error.rb#13
  def i18n_customize_full_message=(_arg0); end

  # source://activemodel//lib/active_model/error.rb#13
  def i18n_customize_full_message?; end

  # source://activemodel//lib/active_model/error.rb#199
  def inspect; end

  # See if error matches provided +attribute+, +type+, and +options+.
  #
  # Omitted params are not checked for a match.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/error.rb#166
  def match?(attribute, type = T.unsafe(nil), **options); end

  # Returns the error message.
  #
  #   error = ActiveModel::Error.new(person, :name, :too_short, count: 5)
  #   error.message
  #   # => "is too short (minimum is 5 characters)"
  #
  # source://activemodel//lib/active_model/error.rb#135
  def message; end

  # The options provided when calling <tt>errors#add</tt>
  #
  # source://activemodel//lib/active_model/error.rb#128
  def options; end

  # The raw value provided as the second parameter when calling
  # <tt>errors#add</tt>
  #
  # source://activemodel//lib/active_model/error.rb#126
  def raw_type; end

  # See if error matches provided +attribute+, +type+, and +options+ exactly.
  #
  # All params must be equal to Error's own attributes to be considered a
  # strict match.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/error.rb#184
  def strict_match?(attribute, type, **options); end

  # The type of error, defaults to +:invalid+ unless specified
  #
  # source://activemodel//lib/active_model/error.rb#123
  def type; end

  protected

  # source://activemodel//lib/active_model/error.rb#204
  def attributes_for_hash; end

  private

  # source://activemodel//lib/active_model/error.rb#111
  def initialize_dup(other); end

  class << self
    # source://activemodel//lib/active_model/error.rb#15
    def full_message(attribute, message, base); end

    # source://activemodel//lib/active_model/error.rb#64
    def generate_message(attribute, type, base, options); end

    # source://activemodel//lib/active_model/error.rb#13
    def i18n_customize_full_message; end

    # source://activemodel//lib/active_model/error.rb#13
    def i18n_customize_full_message=(value); end

    # source://activemodel//lib/active_model/error.rb#13
    def i18n_customize_full_message?; end
  end
end

# source://activemodel//lib/active_model/error.rb#10
ActiveModel::Error::CALLBACKS_OPTIONS = T.let(T.unsafe(nil), Array)

# source://activemodel//lib/active_model/error.rb#11
ActiveModel::Error::MESSAGE_OPTIONS = T.let(T.unsafe(nil), Array)

# = Active \Model \Errors
#
# Provides error related functionalities you can include in your object
# for handling error messages and interacting with Action View helpers.
#
# A minimal implementation could be:
#
#   class Person
#     # Required dependency for ActiveModel::Errors
#     extend ActiveModel::Naming
#
#     def initialize
#       @errors = ActiveModel::Errors.new(self)
#     end
#
#     attr_accessor :name
#     attr_reader   :errors
#
#     def validate!
#       errors.add(:name, :blank, message: "cannot be nil") if name.nil?
#     end
#
#     # The following methods are needed to be minimally implemented
#
#     def read_attribute_for_validation(attr)
#       send(attr)
#     end
#
#     def self.human_attribute_name(attr, options = {})
#       attr
#     end
#
#     def self.lookup_ancestors
#       [self]
#     end
#   end
#
# The last three methods are required in your object for +Errors+ to be
# able to generate error messages correctly and also handle multiple
# languages. Of course, if you extend your object with ActiveModel::Translation
# you will not need to implement the last two. Likewise, using
# ActiveModel::Validations will handle the validation related methods
# for you.
#
# The above allows you to do:
#
#   person = Person.new
#   person.validate!            # => ["cannot be nil"]
#   person.errors.full_messages # => ["name cannot be nil"]
#   # etc..
#
# source://activemodel//lib/active_model/errors.rb#61
class ActiveModel::Errors
  include ::Enumerable
  extend ::Forwardable

  # Pass in the instance of the object that is using the errors object.
  #
  #   class Person
  #     def initialize
  #       @errors = ActiveModel::Errors.new(self)
  #     end
  #   end
  #
  # @return [Errors] a new instance of Errors
  #
  # source://activemodel//lib/active_model/errors.rb#117
  def initialize(base); end

  # When passed a symbol or a name of a method, returns an array of errors
  # for the method.
  #
  #   person.errors[:name]  # => ["cannot be nil"]
  #   person.errors['name'] # => ["cannot be nil"]
  #
  # source://activemodel//lib/active_model/errors.rb#229
  def [](attribute); end

  # Adds a new error of +type+ on +attribute+.
  # More than one error can be added to the same +attribute+.
  # If no +type+ is supplied, <tt>:invalid</tt> is assumed.
  #
  #   person.errors.add(:name)
  #   # Adds <#ActiveModel::Error attribute=name, type=invalid>
  #   person.errors.add(:name, :not_implemented, message: "must be implemented")
  #   # Adds <#ActiveModel::Error attribute=name, type=not_implemented,
  #                               options={:message=>"must be implemented"}>
  #
  #   person.errors.messages
  #   # => {:name=>["is invalid", "must be implemented"]}
  #
  # If +type+ is a string, it will be used as error message.
  #
  # If +type+ is a symbol, it will be translated using the appropriate
  # scope (see +generate_message+).
  #
  #   person.errors.add(:name, :blank)
  #   person.errors.messages
  #   # => {:name=>["can't be blank"]}
  #
  #   person.errors.add(:name, :too_long, count: 25)
  #   person.errors.messages
  #   # => ["is too long (maximum is 25 characters)"]
  #
  # If +type+ is a proc, it will be called, allowing for things like
  # <tt>Time.now</tt> to be used within an error.
  #
  # If the <tt>:strict</tt> option is set to +true+, it will raise
  # ActiveModel::StrictValidationFailed instead of adding the error.
  # <tt>:strict</tt> option can also be set to any other exception.
  #
  #   person.errors.add(:name, :invalid, strict: true)
  #   # => ActiveModel::StrictValidationFailed: Name is invalid
  #   person.errors.add(:name, :invalid, strict: NameIsInvalid)
  #   # => NameIsInvalid: Name is invalid
  #
  #   person.errors.messages # => {}
  #
  # +attribute+ should be set to <tt>:base</tt> if the error is not
  # directly associated with a single attribute.
  #
  #   person.errors.add(:base, :name_or_email_blank,
  #     message: "either name or email must be present")
  #   person.errors.messages
  #   # => {:base=>["either name or email must be present"]}
  #   person.errors.details
  #   # => {:base=>[{error: :name_or_email_blank}]}
  #
  # source://activemodel//lib/active_model/errors.rb#342
  def add(attribute, type = T.unsafe(nil), **options); end

  # Returns +true+ if an error matches provided +attribute+ and +type+,
  # or +false+ otherwise. +type+ is treated the same as for +add+.
  #
  #   person.errors.add :name, :blank
  #   person.errors.added? :name, :blank           # => true
  #   person.errors.added? :name, "can't be blank" # => true
  #
  # If the error requires options, then it returns +true+ with
  # the correct options, or +false+ with incorrect or missing options.
  #
  #   person.errors.add :name, :too_long, count: 25
  #   person.errors.added? :name, :too_long, count: 25                     # => true
  #   person.errors.added? :name, "is too long (maximum is 25 characters)" # => true
  #   person.errors.added? :name, :too_long, count: 24                     # => false
  #   person.errors.added? :name, :too_long                                # => false
  #   person.errors.added? :name, "is too long"                            # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/errors.rb#372
  def added?(attribute, type = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a Hash that can be used as the JSON representation for this
  # object. You can pass the <tt>:full_messages</tt> option. This determines
  # if the JSON object should contain full messages or not (false by default).
  #
  #   person.errors.as_json                      # => {:name=>["cannot be nil"]}
  #   person.errors.as_json(full_messages: true) # => {:name=>["name cannot be nil"]}
  #
  # source://activemodel//lib/active_model/errors.rb#247
  def as_json(options = T.unsafe(nil)); end

  # Returns all error attribute names
  #
  #   person.errors.messages        # => {:name=>["cannot be nil", "must be specified"]}
  #   person.errors.attribute_names # => [:name]
  #
  # source://activemodel//lib/active_model/errors.rb#237
  def attribute_names; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def clear(*args, **_arg1, &block); end

  # Copies the errors from <tt>other</tt>.
  # For copying errors but keep <tt>@base</tt> as is.
  #
  # ==== Parameters
  #
  # * +other+ - The ActiveModel::Errors instance.
  #
  # ==== Examples
  #
  #   person.errors.copy!(other)
  #
  # source://activemodel//lib/active_model/errors.rb#138
  def copy!(other); end

  # Delete messages for +key+. Returns the deleted messages.
  #
  #   person.errors[:name]        # => ["cannot be nil"]
  #   person.errors.delete(:name) # => ["cannot be nil"]
  #   person.errors[:name]        # => []
  #
  # source://activemodel//lib/active_model/errors.rb#215
  def delete(attribute, type = T.unsafe(nil), **options); end

  # Returns a Hash of attributes with an array of their error details.
  #
  # source://activemodel//lib/active_model/errors.rb#276
  def details; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def each(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def empty?(*args, **_arg1, &block); end

  # The actual array of +Error+ objects
  # This method is aliased to <tt>objects</tt>.
  #
  # source://activemodel//lib/active_model/errors.rb#107
  def errors; end

  # Returns a full message for a given attribute.
  #
  #   person.errors.full_message(:name, 'is invalid') # => "Name is invalid"
  #
  # source://activemodel//lib/active_model/errors.rb#451
  def full_message(attribute, message); end

  # Returns all the full error messages in an array.
  #
  #   class Person
  #     validates_presence_of :name, :address, :email
  #     validates_length_of :name, in: 5..30
  #   end
  #
  #   person = Person.create(address: '123 First St.')
  #   person.errors.full_messages
  #   # => ["Name is too short (minimum is 5 characters)", "Name can't be blank", "Email can't be blank"]
  #
  # source://activemodel//lib/active_model/errors.rb#415
  def full_messages; end

  # Returns all the full error messages for a given attribute in an array.
  #
  #   class Person
  #     validates_presence_of :name, :email
  #     validates_length_of :name, in: 5..30
  #   end
  #
  #   person = Person.create()
  #   person.errors.full_messages_for(:name)
  #   # => ["Name is too short (minimum is 5 characters)", "Name can't be blank"]
  #
  # source://activemodel//lib/active_model/errors.rb#430
  def full_messages_for(attribute); end

  # Translates an error message in its default scope
  # (<tt>activemodel.errors.messages</tt>).
  #
  # Error messages are first looked up in <tt>activemodel.errors.models.MODEL.attributes.ATTRIBUTE.MESSAGE</tt>,
  # if it's not there, it's looked up in <tt>activemodel.errors.models.MODEL.MESSAGE</tt> and if
  # that is not there also, it returns the translation of the default message
  # (e.g. <tt>activemodel.errors.messages.MESSAGE</tt>). The translated model
  # name, translated attribute name, and the value are available for
  # interpolation.
  #
  # When using inheritance in your models, it will check all the inherited
  # models too, but only if the model itself hasn't been found. Say you have
  # <tt>class Admin < User; end</tt> and you wanted the translation for
  # the <tt>:blank</tt> error message for the <tt>title</tt> attribute,
  # it looks for these translations:
  #
  # * <tt>activemodel.errors.models.admin.attributes.title.blank</tt>
  # * <tt>activemodel.errors.models.admin.blank</tt>
  # * <tt>activemodel.errors.models.user.attributes.title.blank</tt>
  # * <tt>activemodel.errors.models.user.blank</tt>
  # * any default you provided through the +options+ hash (in the <tt>activemodel.errors</tt> scope)
  # * <tt>activemodel.errors.messages.blank</tt>
  # * <tt>errors.attributes.title.blank</tt>
  # * <tt>errors.messages.blank</tt>
  #
  # source://activemodel//lib/active_model/errors.rb#479
  def generate_message(attribute, type = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns a Hash of attributes with an array of their Error objects.
  #
  #   person.errors.group_by_attribute
  #   # => {:name=>[<#ActiveModel::Error>, <#ActiveModel::Error>]}
  #
  # source://activemodel//lib/active_model/errors.rb#289
  def group_by_attribute; end

  # Returns +true+ if the error messages include an error for the given key
  # +attribute+, +false+ otherwise.
  #
  #   person.errors.messages        # => {:name=>["cannot be nil"]}
  #   person.errors.include?(:name) # => true
  #   person.errors.include?(:age)  # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/errors.rb#202
  def has_key?(attribute); end

  # Imports one error.
  # Imported errors are wrapped as a NestedError,
  # providing access to original error object.
  # If attribute or type needs to be overridden, use +override_options+.
  #
  # ==== Options
  #
  # * +:attribute+ - Override the attribute the error belongs to.
  # * +:type+ - Override type of the error.
  #
  # source://activemodel//lib/active_model/errors.rb#154
  def import(error, override_options = T.unsafe(nil)); end

  # Returns +true+ if the error messages include an error for the given key
  # +attribute+, +false+ otherwise.
  #
  #   person.errors.messages        # => {:name=>["cannot be nil"]}
  #   person.errors.include?(:name) # => true
  #   person.errors.include?(:age)  # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/errors.rb#202
  def include?(attribute); end

  # source://activemodel//lib/active_model/errors.rb#483
  def inspect; end

  # Returns +true+ if the error messages include an error for the given key
  # +attribute+, +false+ otherwise.
  #
  #   person.errors.messages        # => {:name=>["cannot be nil"]}
  #   person.errors.include?(:name) # => true
  #   person.errors.include?(:age)  # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/errors.rb#202
  def key?(attribute); end

  # Merges the errors from <tt>other</tt>,
  # each Error wrapped as NestedError.
  #
  # ==== Parameters
  #
  # * +other+ - The ActiveModel::Errors instance.
  #
  # ==== Examples
  #
  #   person.errors.merge!(other)
  #
  # source://activemodel//lib/active_model/errors.rb#174
  def merge!(other); end

  # Returns a Hash of attributes with an array of their error messages.
  #
  # source://activemodel//lib/active_model/errors.rb#268
  def messages; end

  # Returns all the error messages for a given attribute in an array.
  #
  #   class Person
  #     validates_presence_of :name, :email
  #     validates_length_of :name, in: 5..30
  #   end
  #
  #   person = Person.create()
  #   person.errors.messages_for(:name)
  #   # => ["is too short (minimum is 5 characters)", "can't be blank"]
  #
  # source://activemodel//lib/active_model/errors.rb#444
  def messages_for(attribute); end

  # The actual array of +Error+ objects
  # This method is aliased to <tt>objects</tt>.
  #
  # source://activemodel//lib/active_model/errors.rb#107
  def objects; end

  # Returns +true+ if an error on the attribute with the given type is
  # present, or +false+ otherwise. +type+ is treated the same as for +add+.
  #
  #   person.errors.add :age
  #   person.errors.add :name, :too_long, count: 25
  #   person.errors.of_kind? :age                                            # => true
  #   person.errors.of_kind? :name                                           # => false
  #   person.errors.of_kind? :name, :too_long                                # => true
  #   person.errors.of_kind? :name, "is too long (maximum is 25 characters)" # => true
  #   person.errors.of_kind? :name, :not_too_long                            # => false
  #   person.errors.of_kind? :name, "is too long"                            # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/errors.rb#395
  def of_kind?(attribute, type = T.unsafe(nil)); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def size(*args, **_arg1, &block); end

  # Returns all the full error messages in an array.
  #
  #   class Person
  #     validates_presence_of :name, :address, :email
  #     validates_length_of :name, in: 5..30
  #   end
  #
  #   person = Person.create(address: '123 First St.')
  #   person.errors.full_messages
  #   # => ["Name is too short (minimum is 5 characters)", "Name can't be blank", "Email can't be blank"]
  #
  # source://activemodel//lib/active_model/errors.rb#415
  def to_a; end

  # Returns a Hash of attributes with their error messages. If +full_messages+
  # is +true+, it will contain full messages (see +full_message+).
  #
  #   person.errors.to_hash       # => {:name=>["cannot be nil"]}
  #   person.errors.to_hash(true) # => {:name=>["name cannot be nil"]}
  #
  # source://activemodel//lib/active_model/errors.rb#256
  def to_hash(full_messages = T.unsafe(nil)); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def uniq!(*args, **_arg1, &block); end

  # Search for errors matching +attribute+, +type+, or +options+.
  #
  # Only supplied params will be matched.
  #
  #   person.errors.where(:name) # => all name errors.
  #   person.errors.where(:name, :too_short) # => all name errors being too short
  #   person.errors.where(:name, :too_short, minimum: 2) # => all name errors being too short and minimum is 2
  #
  # source://activemodel//lib/active_model/errors.rb#189
  def where(attribute, type = T.unsafe(nil), **options); end

  private

  # source://activemodel//lib/active_model/errors.rb#122
  def initialize_dup(other); end

  # source://activemodel//lib/active_model/errors.rb#490
  def normalize_arguments(attribute, type, **options); end
end

# source://activemodel//lib/active_model/errors.rb#265
ActiveModel::Errors::EMPTY_ARRAY = T.let(T.unsafe(nil), Array)

# = Active \Model \ForbiddenAttributesError
#
# Raised when forbidden attributes are used for mass assignment.
#
#   class Person < ActiveRecord::Base
#   end
#
#   params = ActionController::Parameters.new(name: 'Bob')
#   Person.new(params)
#   # => ActiveModel::ForbiddenAttributesError
#
#   params.permit!
#   Person.new(params)
#   # => #<Person id: nil, name: "Bob">
#
# source://activemodel//lib/active_model/forbidden_attributes_protection.rb#18
class ActiveModel::ForbiddenAttributesError < ::StandardError; end

# source://activemodel//lib/active_model/forbidden_attributes_protection.rb#21
module ActiveModel::ForbiddenAttributesProtection
  private

  # source://activemodel//lib/active_model/forbidden_attributes_protection.rb#23
  def sanitize_for_mass_assignment(attributes); end

  # source://activemodel//lib/active_model/forbidden_attributes_protection.rb#23
  def sanitize_forbidden_attributes(attributes); end
end

# source://activemodel//lib/active_model/attribute_mutation_tracker.rb#91
class ActiveModel::ForcedMutationTracker < ::ActiveModel::AttributeMutationTracker
  # @return [ForcedMutationTracker] a new instance of ForcedMutationTracker
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#92
  def initialize(attributes); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#101
  def change_to_attribute(attr_name); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#97
  def changed_in_place?(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#125
  def finalize_changes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#121
  def force_change(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#109
  def forget_change(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#113
  def original_value(attr_name); end

  private

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#132
  def attr_names; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#136
  def attribute_changed?(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#144
  def clone_value(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#140
  def fetch_value(attr_name); end

  # Returns the value of attribute finalized_changes.
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#130
  def finalized_changes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#151
  def type_cast(attr_name, value); end
end

# source://activemodel//lib/active_model/attribute_set/builder.rb#94
class ActiveModel::LazyAttributeHash
  # @return [LazyAttributeHash] a new instance of LazyAttributeHash
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#97
  def initialize(types, values, additional_types, default_attributes, delegate_hash = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#134
  def ==(other); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#110
  def [](key); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#114
  def []=(key, value); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#118
  def deep_dup; end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#129
  def each_key(&block); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#95
  def each_value(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#95
  def except(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#95
  def fetch(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#106
  def key?(key); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#142
  def marshal_dump; end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#146
  def marshal_load(values); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#95
  def transform_values(*_arg0, **_arg1, &_arg2); end

  protected

  # source://activemodel//lib/active_model/attribute_set/builder.rb#151
  def materialize; end

  private

  # Returns the value of attribute additional_types.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#163
  def additional_types; end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#165
  def assign_default_value(name); end

  # Returns the value of attribute default_attributes.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#163
  def default_attributes; end

  # Returns the value of attribute delegate_hash.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#163
  def delegate_hash; end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#124
  def initialize_dup(_); end

  # Returns the value of attribute types.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#163
  def types; end

  # Returns the value of attribute values.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#163
  def values; end
end

# source://activemodel//lib/active_model/attribute_set/builder.rb#21
class ActiveModel::LazyAttributeSet < ::ActiveModel::AttributeSet
  # @return [LazyAttributeSet] a new instance of LazyAttributeSet
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#22
  def initialize(values, types, additional_types, default_attributes, attributes = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#41
  def fetch_value(name, &block); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#32
  def key?(name); end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#36
  def keys; end

  protected

  # source://activemodel//lib/active_model/attribute_set/builder.rb#61
  def attributes; end

  private

  # Returns the value of attribute additional_types.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#71
  def additional_types; end

  # source://activemodel//lib/active_model/attribute_set/builder.rb#73
  def default_attribute(name, value_present = T.unsafe(nil), value = T.unsafe(nil)); end

  # Returns the value of attribute default_attributes.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#71
  def default_attributes; end

  # Returns the value of attribute types.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#71
  def types; end

  # Returns the value of attribute values.
  #
  # source://activemodel//lib/active_model/attribute_set/builder.rb#71
  def values; end
end

# source://activemodel//lib/active_model/lint.rb#4
module ActiveModel::Lint; end

# == Active \Model \Lint \Tests
#
# You can test whether an object is compliant with the Active \Model API by
# including +ActiveModel::Lint::Tests+ in your TestCase. It will
# include tests that tell you whether your object is fully compliant,
# or if not, which aspects of the API are not implemented.
#
# Note an object is not required to implement all APIs in order to work
# with Action Pack. This module only intends to provide guidance in case
# you want all features out of the box.
#
# These tests do not attempt to determine the semantic correctness of the
# returned values. For instance, you could implement <tt>valid?</tt> to
# always return +true+, and the tests would pass. It is up to you to ensure
# that the values are semantically meaningful.
#
# Objects you pass in are expected to return a compliant object from a call
# to <tt>to_model</tt>. It is perfectly fine for <tt>to_model</tt> to return
# +self+.
#
# source://activemodel//lib/active_model/lint.rb#24
module ActiveModel::Lint::Tests
  # Passes if the object's model responds to <tt>errors</tt> and if calling
  # <tt>[](attribute)</tt> on the result of this method returns an array.
  # Fails otherwise.
  #
  # <tt>errors[attribute]</tt> is used to retrieve the errors of a model
  # for a given attribute. If errors are present, the method should return
  # an array of strings that are the errors for the attribute in question.
  # If localization is used, the strings should be localized for the current
  # locale. If no error is present, the method should return an empty array.
  #
  # source://activemodel//lib/active_model/lint.rb#102
  def test_errors_aref; end

  # Passes if the object's model responds to <tt>model_name</tt> both as
  # an instance method and as a class method, and if calling this method
  # returns a string with some convenience methods: <tt>:human</tt>,
  # <tt>:singular</tt> and <tt>:plural</tt>.
  #
  # Check ActiveModel::Naming for more information.
  #
  # source://activemodel//lib/active_model/lint.rb#81
  def test_model_naming; end

  # Passes if the object's model responds to <tt>persisted?</tt> and if
  # calling this method returns either +true+ or +false+. Fails otherwise.
  #
  # <tt>persisted?</tt> is used when calculating the URL for an object.
  # If the object is not persisted, a form for that object, for instance,
  # will route to the create action. If it is persisted, a form for the
  # object will route to the update action.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/lint.rb#70
  def test_persisted?; end

  # Passes if the object's model responds to <tt>to_key</tt> and if calling
  # this method returns +nil+ when the object is not persisted.
  # Fails otherwise.
  #
  # <tt>to_key</tt> returns an Enumerable of all (primary) key attributes
  # of the model, and is used to a generate unique DOM id for the object.
  #
  # source://activemodel//lib/active_model/lint.rb#31
  def test_to_key; end

  # Passes if the object's model responds to <tt>to_param</tt> and if
  # calling this method returns +nil+ when the object is not persisted.
  # Fails otherwise.
  #
  # <tt>to_param</tt> is used to represent the object's key in URLs.
  # Implementers can decide to either raise an exception or provide a
  # default in case the record uses a composite primary key. There are no
  # tests for this behavior in lint because it doesn't make sense to force
  # any of the possible implementation strategies on the implementer.
  #
  # source://activemodel//lib/active_model/lint.rb#46
  def test_to_param; end

  # Passes if the object's model responds to <tt>to_partial_path</tt> and if
  # calling this method returns a string. Fails otherwise.
  #
  # <tt>to_partial_path</tt> is used for looking up partials. For example,
  # a BlogPost model might return "blog_posts/blog_post".
  #
  # source://activemodel//lib/active_model/lint.rb#58
  def test_to_partial_path; end

  private

  # source://activemodel//lib/active_model/lint.rb#113
  def assert_boolean(result, name); end

  # source://activemodel//lib/active_model/lint.rb#108
  def model; end
end

# Raised when an attribute is not defined.
#
#   class User < ActiveRecord::Base
#     has_many :pets
#   end
#
#   user = User.first
#   user.pets.select(:id).first.user_id
#   # => ActiveModel::MissingAttributeError: missing attribute 'user_id' for Pet
#
# source://activemodel//lib/active_model/attribute_methods.rb#15
class ActiveModel::MissingAttributeError < ::NoMethodError; end

# = Active \Model \Basic \Model
#
# Allows implementing models similar to ActiveRecord::Base.
# Includes ActiveModel::API for the required interface for an
# object to interact with Action Pack and Action View, but can be
# extended with other functionalities.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::Model
#     attr_accessor :name, :age
#   end
#
#   person = Person.new(name: 'bob', age: '18')
#   person.name # => "bob"
#   person.age  # => "18"
#
# If for some reason you need to run code on <tt>initialize</tt>, make
# sure you call +super+ if you want the attributes hash initialization to
# happen.
#
#   class Person
#     include ActiveModel::Model
#     attr_accessor :id, :name, :omg
#
#     def initialize(attributes={})
#       super
#       @omg ||= true
#     end
#   end
#
#   person = Person.new(id: 1, name: 'bob')
#   person.omg # => true
#
# For more detailed information on other functionalities available, please
# refer to the specific modules included in +ActiveModel::Model+
# (see below).
#
# source://activemodel//lib/active_model/model.rb#42
module ActiveModel::Model
  include ::ActiveModel::Access
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods
  include ::ActiveModel::Validations
  include ::ActiveModel::Conversion
  include ::ActiveModel::API

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Validations::ClassMethods
  mixes_in_class_methods ::ActiveModel::Callbacks
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::ActiveModel::Translation
  mixes_in_class_methods ::ActiveModel::Validations::HelperMethods
  mixes_in_class_methods ::ActiveModel::Conversion::ClassMethods

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
    def _validators; end
    def _validators=(value); end
    def _validators?; end
    def param_delimiter; end
    def param_delimiter=(value); end
    def param_delimiter?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
    def _validators; end
    def _validators?; end
    def param_delimiter=(value); end
  end
end

# source://activemodel//lib/active_model/naming.rb#9
class ActiveModel::Name
  include ::Comparable

  # Returns a new ActiveModel::Name instance. By default, the +namespace+
  # and +name+ option will take the namespace and name of the given class
  # respectively.
  # Use +locale+ argument for singularize and pluralize model name.
  #
  #   module Foo
  #     class Bar
  #     end
  #   end
  #
  #   ActiveModel::Name.new(Foo::Bar).to_s
  #   # => "Foo::Bar"
  #
  # @raise [ArgumentError]
  # @return [Name] a new instance of Name
  #
  # source://activemodel//lib/active_model/naming.rb#166
  def initialize(klass, namespace = T.unsafe(nil), name = T.unsafe(nil), locale = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/naming.rb#151
  def !~(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/naming.rb#151
  def <=>(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/naming.rb#151
  def ==(arg); end

  # source://activemodel//lib/active_model/naming.rb#151
  def ===(arg); end

  # source://activemodel//lib/active_model/naming.rb#151
  def =~(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/naming.rb#151
  def as_json(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute collection.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def cache_key; end

  # Returns the value of attribute collection.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def collection; end

  # Sets the attribute collection
  #
  # @param value the value to set the attribute collection to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def collection=(_arg0); end

  # Returns the value of attribute element.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def element; end

  # Sets the attribute element
  #
  # @param value the value to set the attribute element to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def element=(_arg0); end

  # source://activemodel//lib/active_model/naming.rb#151
  def eql?(*_arg0, **_arg1, &_arg2); end

  # Transform the model name into a more human format, using I18n. By default,
  # it will underscore then humanize the class name.
  #
  #   class BlogPost
  #     extend ActiveModel::Naming
  #   end
  #
  #   BlogPost.model_name.human # => "Blog post"
  #
  # Specify +options+ with additional translating options.
  #
  # source://activemodel//lib/active_model/naming.rb#197
  def human(options = T.unsafe(nil)); end

  # Returns the value of attribute i18n_key.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def i18n_key; end

  # Sets the attribute i18n_key
  #
  # @param value the value to set the attribute i18n_key to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def i18n_key=(_arg0); end

  # source://activemodel//lib/active_model/naming.rb#151
  def match?(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute name.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def name=(_arg0); end

  # Returns the value of attribute param_key.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def param_key; end

  # Sets the attribute param_key
  #
  # @param value the value to set the attribute param_key to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def param_key=(_arg0); end

  # Returns the value of attribute plural.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def plural; end

  # Sets the attribute plural
  #
  # @param value the value to set the attribute plural to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def plural=(_arg0); end

  # Returns the value of attribute route_key.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def route_key; end

  # Sets the attribute route_key
  #
  # @param value the value to set the attribute route_key to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def route_key=(_arg0); end

  # Returns the value of attribute singular.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def singular; end

  # Sets the attribute singular
  #
  # @param value the value to set the attribute singular to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def singular=(_arg0); end

  # Returns the value of attribute singular_route_key.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def singular_route_key; end

  # Sets the attribute singular_route_key
  #
  # @param value the value to set the attribute singular_route_key to.
  #
  # source://activemodel//lib/active_model/naming.rb#12
  def singular_route_key=(_arg0); end

  # source://activemodel//lib/active_model/naming.rb#151
  def to_s(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/naming.rb#151
  def to_str(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/naming.rb#209
  def uncountable?; end

  private

  # source://activemodel//lib/active_model/naming.rb#216
  def _singularize(string); end

  # source://activemodel//lib/active_model/naming.rb#220
  def i18n_keys; end

  # source://activemodel//lib/active_model/naming.rb#228
  def i18n_scope; end
end

# source://activemodel//lib/active_model/naming.rb#214
ActiveModel::Name::MISSING_TRANSLATION = T.let(T.unsafe(nil), Integer)

# = Active \Model \Naming
#
# Creates a +model_name+ method on your object.
#
# To implement, just extend ActiveModel::Naming in your object:
#
#   class BookCover
#     extend ActiveModel::Naming
#   end
#
#   BookCover.model_name.name   # => "BookCover"
#   BookCover.model_name.human  # => "Book cover"
#
#   BookCover.model_name.i18n_key              # => :book_cover
#   BookModule::BookCover.model_name.i18n_key  # => :"book_module/book_cover"
#
# Providing the functionality that ActiveModel::Naming provides in your object
# is required to pass the \Active \Model Lint test. So either extending the
# provided method below, or rolling your own is required.
#
# source://activemodel//lib/active_model/naming.rb#252
module ActiveModel::Naming
  # Returns an ActiveModel::Name object for module. It can be
  # used to retrieve all kinds of naming-related information
  # (See ActiveModel::Name for more information).
  #
  #   class Person
  #     extend ActiveModel::Naming
  #   end
  #
  #   Person.model_name.name     # => "Person"
  #   Person.model_name.class    # => ActiveModel::Name
  #   Person.model_name.singular # => "person"
  #   Person.model_name.plural   # => "people"
  #
  # source://activemodel//lib/active_model/naming.rb#270
  def model_name; end

  private

  # source://activemodel//lib/active_model/naming.rb#352
  def inherited(base); end

  class << self
    # source://activemodel//lib/active_model/naming.rb#253
    def extended(base); end

    # Returns string to use for params names. It differs for
    # namespaced models regarding whether it's inside isolated engine.
    #
    #   # For isolated engine:
    #   ActiveModel::Naming.param_key(Blog::Post) # => "post"
    #
    #   # For shared engine:
    #   ActiveModel::Naming.param_key(Blog::Post) # => "blog_post"
    #
    # source://activemodel//lib/active_model/naming.rb#338
    def param_key(record_or_class); end

    # Returns the plural class name of a record or class.
    #
    #   ActiveModel::Naming.plural(post)             # => "posts"
    #   ActiveModel::Naming.plural(Highrise::Person) # => "highrise_people"
    #
    # source://activemodel//lib/active_model/naming.rb#283
    def plural(record_or_class); end

    # Returns string to use while generating route names. It differs for
    # namespaced models regarding whether it's inside isolated engine.
    #
    #   # For isolated engine:
    #   ActiveModel::Naming.route_key(Blog::Post) # => "posts"
    #
    #   # For shared engine:
    #   ActiveModel::Naming.route_key(Blog::Post) # => "blog_posts"
    #
    # The route key also considers if the noun is uncountable and, in
    # such cases, automatically appends _index.
    #
    # source://activemodel//lib/active_model/naming.rb#326
    def route_key(record_or_class); end

    # Returns the singular class name of a record or class.
    #
    #   ActiveModel::Naming.singular(post)             # => "post"
    #   ActiveModel::Naming.singular(Highrise::Person) # => "highrise_person"
    #
    # source://activemodel//lib/active_model/naming.rb#291
    def singular(record_or_class); end

    # Returns string to use while generating route names. It differs for
    # namespaced models regarding whether it's inside isolated engine.
    #
    #   # For isolated engine:
    #   ActiveModel::Naming.singular_route_key(Blog::Post) # => "post"
    #
    #   # For shared engine:
    #   ActiveModel::Naming.singular_route_key(Blog::Post) # => "blog_post"
    #
    # source://activemodel//lib/active_model/naming.rb#311
    def singular_route_key(record_or_class); end

    # Identifies whether the class name of a record or class is uncountable.
    #
    #   ActiveModel::Naming.uncountable?(Sheep) # => true
    #   ActiveModel::Naming.uncountable?(Post)  # => false
    #
    # @return [Boolean]
    #
    # source://activemodel//lib/active_model/naming.rb#299
    def uncountable?(record_or_class); end

    private

    # source://activemodel//lib/active_model/naming.rb#342
    def model_name_from_record_or_class(record_or_class); end
  end
end

# source://activemodel//lib/active_model/nested_error.rb#7
class ActiveModel::NestedError < ::ActiveModel::Error
  extend ::Forwardable

  # @return [NestedError] a new instance of NestedError
  #
  # source://activemodel//lib/active_model/nested_error.rb#8
  def initialize(base, inner_error, override_options = T.unsafe(nil)); end

  # Returns the value of attribute inner_error.
  #
  # source://activemodel//lib/active_model/nested_error.rb#17
  def inner_error; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def message(*args, **_arg1, &block); end
end

# source://activemodel//lib/active_model/attribute_mutation_tracker.rb#156
class ActiveModel::NullMutationTracker
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#174
  def any_changes?; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#171
  def change_to_attribute(attr_name); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#178
  def changed?(attr_name, **_arg1); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#159
  def changed_attribute_names; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#182
  def changed_in_place?(attr_name); end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#163
  def changed_values; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#167
  def changes; end

  # source://activemodel//lib/active_model/attribute_mutation_tracker.rb#186
  def original_value(attr_name); end

  class << self
    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://activemodel//lib/active_model/railtie.rb#7
class ActiveModel::Railtie < ::Rails::Railtie; end

# = Active \Model \RangeError
#
# Raised when attribute values are out of range.
#
# source://activemodel//lib/active_model/errors.rb#523
class ActiveModel::RangeError < ::RangeError; end

# source://activemodel//lib/active_model/secure_password.rb#4
module ActiveModel::SecurePassword
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActiveModel::SecurePassword::ClassMethods

  class << self
    # source://activemodel//lib/active_model/secure_password.rb#13
    def min_cost; end

    # source://activemodel//lib/active_model/secure_password.rb#13
    def min_cost=(_arg0); end
  end
end

# source://activemodel//lib/active_model/secure_password.rb#17
module ActiveModel::SecurePassword::ClassMethods
  # Adds methods to set and authenticate against a BCrypt password.
  # This mechanism requires you to have a +XXX_digest+ attribute,
  # where +XXX+ is the attribute name of your desired password.
  #
  # The following validations are added automatically:
  # * Password must be present on creation
  # * Password length should be less than or equal to 72 bytes
  # * Confirmation of password (using a +XXX_confirmation+ attribute)
  #
  # If confirmation validation is not needed, simply leave out the
  # value for +XXX_confirmation+ (i.e. don't provide a form field for
  # it). When this attribute has a +nil+ value, the validation will not be
  # triggered.
  #
  # Additionally, a +XXX_challenge+ attribute is created. When set to a
  # value other than +nil+, it will validate against the currently persisted
  # password. This validation relies on dirty tracking, as provided by
  # ActiveModel::Dirty; if dirty tracking methods are not defined, this
  # validation will fail.
  #
  # All of the above validations can be omitted by passing
  # <tt>validations: false</tt> as an argument. This allows complete
  # customizability of validation behavior.
  #
  # To use +has_secure_password+, add bcrypt (~> 3.1.7) to your Gemfile:
  #
  #   gem "bcrypt", "~> 3.1.7"
  #
  # ==== Examples
  #
  # ===== Using Active Record (which automatically includes ActiveModel::SecurePassword)
  #
  #   # Schema: User(name:string, password_digest:string, recovery_password_digest:string)
  #   class User < ActiveRecord::Base
  #     has_secure_password
  #     has_secure_password :recovery_password, validations: false
  #   end
  #
  #   user = User.new(name: "david", password: "", password_confirmation: "nomatch")
  #
  #   user.save                                                      # => false, password required
  #   user.password = "vr00m"
  #   user.save                                                      # => false, confirmation doesn't match
  #   user.password_confirmation = "vr00m"
  #   user.save                                                      # => true
  #
  #   user.authenticate("notright")                                  # => false
  #   user.authenticate("vr00m")                                     # => user
  #   User.find_by(name: "david")&.authenticate("notright")          # => false
  #   User.find_by(name: "david")&.authenticate("vr00m")             # => user
  #
  #   user.recovery_password = "42password"
  #   user.recovery_password_digest                                  # => "$2a$04$iOfhwahFymCs5weB3BNH/uXkTG65HR.qpW.bNhEjFP3ftli3o5DQC"
  #   user.save                                                      # => true
  #
  #   user.authenticate_recovery_password("42password")              # => user
  #
  #   user.update(password: "pwn3d", password_challenge: "")         # => false, challenge doesn't authenticate
  #   user.update(password: "nohack4u", password_challenge: "vr00m") # => true
  #
  #   user.authenticate("vr00m")                                     # => false, old password
  #   user.authenticate("nohack4u")                                  # => user
  #
  # ===== Conditionally requiring a password
  #
  #   class Account
  #     include ActiveModel::SecurePassword
  #
  #     attr_accessor :is_guest, :password_digest
  #
  #     has_secure_password
  #
  #     def errors
  #       super.tap { |errors| errors.delete(:password, :blank) if is_guest }
  #     end
  #   end
  #
  #   account = Account.new
  #   account.valid? # => false, password required
  #
  #   account.is_guest = true
  #   account.valid? # => true
  #
  # source://activemodel//lib/active_model/secure_password.rb#101
  def has_secure_password(attribute = T.unsafe(nil), validations: T.unsafe(nil)); end
end

# source://activemodel//lib/active_model/secure_password.rb#148
class ActiveModel::SecurePassword::InstanceMethodsOnActivation < ::Module
  # @return [InstanceMethodsOnActivation] a new instance of InstanceMethodsOnActivation
  #
  # source://activemodel//lib/active_model/secure_password.rb#149
  def initialize(attribute); end
end

# BCrypt hash function can handle maximum 72 bytes, and if we pass
# password of length more than 72 bytes it ignores extra characters.
# Hence need to put a restriction on password length.
#
# source://activemodel//lib/active_model/secure_password.rb#10
ActiveModel::SecurePassword::MAX_PASSWORD_LENGTH_ALLOWED = T.let(T.unsafe(nil), Integer)

# = Active \Model \Serialization
#
# Provides a basic serialization to a serializable_hash for your objects.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::Serialization
#
#     attr_accessor :name
#
#     def attributes
#       {'name' => nil}
#     end
#   end
#
# Which would provide you with:
#
#   person = Person.new
#   person.serializable_hash   # => {"name"=>nil}
#   person.name = "Bob"
#   person.serializable_hash   # => {"name"=>"Bob"}
#
# An +attributes+ hash must be defined and should contain any attributes you
# need to be serialized. Attributes must be strings, not symbols.
# When called, serializable hash will use instance methods that match the name
# of the attributes hash's keys. In order to override this behavior, take a look
# at the private method +read_attribute_for_serialization+.
#
# ActiveModel::Serializers::JSON module automatically includes
# the +ActiveModel::Serialization+ module, so there is no need to
# explicitly include +ActiveModel::Serialization+.
#
# A minimal implementation including JSON would be:
#
#   class Person
#     include ActiveModel::Serializers::JSON
#
#     attr_accessor :name
#
#     def attributes
#       {'name' => nil}
#     end
#   end
#
# Which would provide you with:
#
#   person = Person.new
#   person.serializable_hash   # => {"name"=>nil}
#   person.as_json             # => {"name"=>nil}
#   person.to_json             # => "{\"name\":null}"
#
#   person.name = "Bob"
#   person.serializable_hash   # => {"name"=>"Bob"}
#   person.as_json             # => {"name"=>"Bob"}
#   person.to_json             # => "{\"name\":\"Bob\"}"
#
# Valid options are <tt>:only</tt>, <tt>:except</tt>, <tt>:methods</tt> and
# <tt>:include</tt>. The following are all valid examples:
#
#   person.serializable_hash(only: 'name')
#   person.serializable_hash(include: :address)
#   person.serializable_hash(include: { address: { only: 'city' }})
#
# source://activemodel//lib/active_model/serialization.rb#69
module ActiveModel::Serialization
  # Hook method defining how an attribute value should be retrieved for
  # serialization. By default this is assumed to be an instance named after
  # the attribute. Override this method in subclasses should you need to
  # retrieve the value for a given attribute differently:
  #
  #   class MyClass
  #     include ActiveModel::Serialization
  #
  #     def initialize(data = {})
  #       @data = data
  #     end
  #
  #     def read_attribute_for_serialization(key)
  #       @data[key]
  #     end
  #   end
  def read_attribute_for_serialization(*_arg0); end

  # Returns a serialized hash of your object.
  #
  #   class Person
  #     include ActiveModel::Serialization
  #
  #     attr_accessor :name, :age
  #
  #     def attributes
  #       {'name' => nil, 'age' => nil}
  #     end
  #
  #     def capitalized_name
  #       name.capitalize
  #     end
  #   end
  #
  #   person = Person.new
  #   person.name = 'bob'
  #   person.age  = 22
  #   person.serializable_hash                # => {"name"=>"bob", "age"=>22}
  #   person.serializable_hash(only: :name)   # => {"name"=>"bob"}
  #   person.serializable_hash(except: :name) # => {"age"=>22}
  #   person.serializable_hash(methods: :capitalized_name)
  #   # => {"name"=>"bob", "age"=>22, "capitalized_name"=>"Bob"}
  #
  # Example with <tt>:include</tt> option
  #
  #   class User
  #     include ActiveModel::Serializers::JSON
  #     attr_accessor :name, :notes # Emulate has_many :notes
  #     def attributes
  #       {'name' => nil}
  #     end
  #   end
  #
  #   class Note
  #     include ActiveModel::Serializers::JSON
  #     attr_accessor :title, :text
  #     def attributes
  #       {'title' => nil, 'text' => nil}
  #     end
  #   end
  #
  #   note = Note.new
  #   note.title = 'Battle of Austerlitz'
  #   note.text = 'Some text here'
  #
  #   user = User.new
  #   user.name = 'Napoleon'
  #   user.notes = [note]
  #
  #   user.serializable_hash
  #   # => {"name" => "Napoleon"}
  #   user.serializable_hash(include: { notes: { only: 'title' }})
  #   # => {"name" => "Napoleon", "notes" => [{"title"=>"Battle of Austerlitz"}]}
  #
  # source://activemodel//lib/active_model/serialization.rb#125
  def serializable_hash(options = T.unsafe(nil)); end

  private

  # source://activemodel//lib/active_model/serialization.rb#152
  def attribute_names_for_serialization; end

  # Add associations specified via the <tt>:include</tt> option.
  #
  # Expects a block that takes as arguments:
  #   +association+ - name of the association
  #   +records+     - the association record(s) to be serialized
  #   +opts+        - options for the association records
  #
  # source://activemodel//lib/active_model/serialization.rb#184
  def serializable_add_includes(options = T.unsafe(nil)); end

  # source://activemodel//lib/active_model/serialization.rb#174
  def serializable_attributes(attribute_names); end
end

# source://activemodel//lib/active_model.rb#68
module ActiveModel::Serializers
  extend ::ActiveSupport::Autoload
end

# = Active \Model \JSON \Serializer
#
# source://activemodel//lib/active_model/serializers/json.rb#8
module ActiveModel::Serializers::JSON
  include ::ActiveModel::Serialization
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Naming

  # Returns a hash representing the model. Some configuration can be
  # passed through +options+.
  #
  # The option <tt>include_root_in_json</tt> controls the top-level behavior
  # of +as_json+. If +true+, +as_json+ will emit a single root node named
  # after the object's type. The default value for <tt>include_root_in_json</tt>
  # option is +false+.
  #
  #   user = User.find(1)
  #   user.as_json
  #   # => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #     "created_at" => "2006-08-01T17:27:133.000Z", "awesome" => true}
  #
  #   ActiveRecord::Base.include_root_in_json = true
  #
  #   user.as_json
  #   # => { "user" => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #                  "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true } }
  #
  # This behavior can also be achieved by setting the <tt>:root</tt> option
  # to +true+ as in:
  #
  #   user = User.find(1)
  #   user.as_json(root: true)
  #   # => { "user" => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #                  "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true } }
  #
  # If you prefer, <tt>:root</tt> may also be set to a custom string key instead as in:
  #
  #   user = User.find(1)
  #   user.as_json(root: "author")
  #   # => { "author" => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #                  "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true } }
  #
  # Without any +options+, the returned Hash will include all the model's
  # attributes.
  #
  #   user = User.find(1)
  #   user.as_json
  #   # => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #      "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true}
  #
  # The <tt>:only</tt> and <tt>:except</tt> options can be used to limit
  # the attributes included, and work similar to the +attributes+ method.
  #
  #   user.as_json(only: [:id, :name])
  #   # => { "id" => 1, "name" => "Konata Izumi" }
  #
  #   user.as_json(except: [:id, :created_at, :age])
  #   # => { "name" => "Konata Izumi", "awesome" => true }
  #
  # To include the result of some method calls on the model use <tt>:methods</tt>:
  #
  #   user.as_json(methods: :permalink)
  #   # => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #      "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true,
  #   #      "permalink" => "1-konata-izumi" }
  #
  # To include associations use <tt>:include</tt>:
  #
  #   user.as_json(include: :posts)
  #   # => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #      "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true,
  #   #      "posts" => [ { "id" => 1, "author_id" => 1, "title" => "Welcome to the weblog" },
  #   #                   { "id" => 2, "author_id" => 1, "title" => "So I was thinking" } ] }
  #
  # Second level and higher order associations work as well:
  #
  #   user.as_json(include: { posts: {
  #                              include: { comments: {
  #                                             only: :body } },
  #                              only: :title } })
  #   # => { "id" => 1, "name" => "Konata Izumi", "age" => 16,
  #   #      "created_at" => "2006-08-01T17:27:13.000Z", "awesome" => true,
  #   #      "posts" => [ { "comments" => [ { "body" => "1st post!" }, { "body" => "Second!" } ],
  #   #                     "title" => "Welcome to the weblog" },
  #   #                   { "comments" => [ { "body" => "Don't think too hard" } ],
  #   #                     "title" => "So I was thinking" } ] }
  #
  # source://activemodel//lib/active_model/serializers/json.rb#96
  def as_json(options = T.unsafe(nil)); end

  # Sets the model +attributes+ from a JSON string. Returns +self+.
  #
  #   class Person
  #     include ActiveModel::Serializers::JSON
  #
  #     attr_accessor :name, :age, :awesome
  #
  #     def attributes=(hash)
  #       hash.each do |key, value|
  #         send("#{key}=", value)
  #       end
  #     end
  #
  #     def attributes
  #       instance_values
  #     end
  #   end
  #
  #   json = { name: 'bob', age: 22, awesome:true }.to_json
  #   person = Person.new
  #   person.from_json(json) # => #<Person:0x007fec5e7a0088 @age=22, @awesome=true, @name="bob">
  #   person.name            # => "bob"
  #   person.age             # => 22
  #   person.awesome         # => true
  #
  # The default value for +include_root+ is +false+. You can change it to
  # +true+ if the given JSON string includes a single root node.
  #
  #   json = { person: { name: 'bob', age: 22, awesome:true } }.to_json
  #   person = Person.new
  #   person.from_json(json, true) # => #<Person:0x007fec5e7a0088 @age=22, @awesome=true, @name="bob">
  #   person.name                  # => "bob"
  #   person.age                   # => 22
  #   person.awesome               # => true
  #
  # source://activemodel//lib/active_model/serializers/json.rb#146
  def from_json(json, include_root = T.unsafe(nil)); end

  module GeneratedClassMethods
    def include_root_in_json; end
    def include_root_in_json=(value); end
    def include_root_in_json?; end
  end

  module GeneratedInstanceMethods
    def include_root_in_json; end
    def include_root_in_json?; end
  end
end

# = Active \Model \StrictValidationFailed
#
# Raised when a validation cannot be corrected by end users and are considered
# exceptional.
#
#   class Person
#     include ActiveModel::Validations
#
#     attr_accessor :name
#
#     validates_presence_of :name, strict: true
#   end
#
#   person = Person.new
#   person.name = nil
#   person.valid?
#   # => ActiveModel::StrictValidationFailed: Name can't be blank
#
# source://activemodel//lib/active_model/errors.rb#517
class ActiveModel::StrictValidationFailed < ::StandardError; end

# = Active \Model \Translation
#
# Provides integration between your object and the \Rails internationalization
# (i18n) framework.
#
# A minimal implementation could be:
#
#   class TranslatedPerson
#     extend ActiveModel::Translation
#   end
#
#   TranslatedPerson.human_attribute_name('my_attribute')
#   # => "My attribute"
#
# This also provides the required class methods for hooking into the
# \Rails internationalization API, including being able to define a
# class-based +i18n_scope+ and +lookup_ancestors+ to find translations in
# parent classes.
#
# source://activemodel//lib/active_model/translation.rb#22
module ActiveModel::Translation
  include ::ActiveModel::Naming

  # Transforms attribute names into a more human format, such as "First name"
  # instead of "first_name".
  #
  #   Person.human_attribute_name("first_name") # => "First name"
  #
  # Specify +options+ with additional translating options.
  #
  # source://activemodel//lib/active_model/translation.rb#46
  def human_attribute_name(attribute, options = T.unsafe(nil)); end

  # Returns the +i18n_scope+ for the class. Override if you want custom lookup.
  #
  # source://activemodel//lib/active_model/translation.rb#26
  def i18n_scope; end

  # When localizing a string, it goes through the lookup returned by this
  # method, which is used in ActiveModel::Name#human,
  # ActiveModel::Errors#full_messages and
  # ActiveModel::Translation#human_attribute_name.
  #
  # source://activemodel//lib/active_model/translation.rb#34
  def lookup_ancestors; end
end

# source://activemodel//lib/active_model/translation.rb#38
ActiveModel::Translation::MISSING_TRANSLATION = T.let(T.unsafe(nil), Integer)

# source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#4
module ActiveModel::Type
  class << self
    # source://activemodel//lib/active_model/type.rb#38
    def default_value; end

    # source://activemodel//lib/active_model/type.rb#34
    def lookup(*_arg0, **_arg1, &_arg2); end

    # Add a new type to the registry, allowing it to be referenced as a
    # symbol by {attribute}[rdoc-ref:Attributes::ClassMethods#attribute].
    #
    # source://activemodel//lib/active_model/type.rb#30
    def register(type_name, klass = T.unsafe(nil), &block); end

    # source://activemodel//lib/active_model/type.rb#26
    def registry; end

    # source://activemodel//lib/active_model/type.rb#26
    def registry=(_arg0); end
  end
end

# = Active Model \BigInteger \Type
#
# Attribute type for integers that can be serialized to an unlimited number
# of bytes. This type is registered under the +:big_integer+ key.
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :id, :big_integer
#   end
#
#   person = Person.new
#   person.id = "18_000_000_000"
#
#   person.id # => 18000000000
#
# All casting and serialization are performed in the same way as the
# standard ActiveModel::Type::Integer type.
#
# source://activemodel//lib/active_model/type/big_integer.rb#25
class ActiveModel::Type::BigInteger < ::ActiveModel::Type::Integer
  # source://activemodel//lib/active_model/type/big_integer.rb#26
  def serialize_cast_value(value); end

  private

  # source://activemodel//lib/active_model/type/big_integer.rb#31
  def max_value; end
end

# = Active Model \Binary \Type
#
# Attribute type for representation of binary data. This type is registered
# under the +:binary+ key.
#
# Non-string values are coerced to strings using their +to_s+ method.
#
# source://activemodel//lib/active_model/type/binary.rb#11
class ActiveModel::Type::Binary < ::ActiveModel::Type::Value
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/binary.rb#16
  def binary?; end

  # source://activemodel//lib/active_model/type/binary.rb#20
  def cast(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/binary.rb#35
  def changed_in_place?(raw_old_value, value); end

  # source://activemodel//lib/active_model/type/binary.rb#30
  def serialize(value); end

  # source://activemodel//lib/active_model/type/binary.rb#12
  def type; end
end

# source://activemodel//lib/active_model/type/binary.rb#40
class ActiveModel::Type::Binary::Data
  # @return [Data] a new instance of Data
  #
  # source://activemodel//lib/active_model/type/binary.rb#41
  def initialize(value); end

  # source://activemodel//lib/active_model/type/binary.rb#56
  def ==(other); end

  # source://activemodel//lib/active_model/type/binary.rb#52
  def hex; end

  # source://activemodel//lib/active_model/type/binary.rb#47
  def to_s; end

  # source://activemodel//lib/active_model/type/binary.rb#47
  def to_str; end
end

# = Active Model \Boolean \Type
#
# A class that behaves like a boolean type, including rules for coercion of
# user input.
#
# - <tt>"false"</tt>, <tt>"f"</tt>, <tt>"0"</tt>, +0+ or any other value in
#   +FALSE_VALUES+ will be coerced to +false+.
# - Empty strings are coerced to +nil+.
# - All other values will be coerced to +true+.
#
# source://activemodel//lib/active_model/type/boolean.rb#14
class ActiveModel::Type::Boolean < ::ActiveModel::Type::Value
  # source://activemodel//lib/active_model/type/boolean.rb#30
  def serialize(value); end

  # source://activemodel//lib/active_model/type/boolean.rb#34
  def serialize_cast_value(value); end

  # source://activemodel//lib/active_model/type/boolean.rb#26
  def type; end

  private

  # source://activemodel//lib/active_model/type/boolean.rb#39
  def cast_value(value); end
end

# source://activemodel//lib/active_model/type/boolean.rb#15
ActiveModel::Type::Boolean::FALSE_VALUES = T.let(T.unsafe(nil), Set)

# = Active Model \Date \Type
#
# Attribute type for date representation. It is registered under the
# +:date+ key.
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :birthday, :date
#   end
#
#   person = Person.new
#   person.birthday = "1989-07-13"
#
#   person.birthday.class # => Date
#   person.birthday.year  # => 1989
#   person.birthday.month # => 7
#   person.birthday.day   # => 13
#
# String values are parsed using the ISO 8601 date format. Any other values
# are cast using their +to_date+ method, if it exists.
#
# source://activemodel//lib/active_model/type/date.rb#26
class ActiveModel::Type::Date < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Timezone
  include ::ActiveModel::Type::Helpers::AcceptsMultiparameterTime::InstanceMethods

  # source://activemodel//lib/active_model/type/date.rb#30
  def type; end

  # source://activemodel//lib/active_model/type/date.rb#34
  def type_cast_for_schema(value); end

  private

  # source://activemodel//lib/active_model/type/date.rb#39
  def cast_value(value); end

  # source://activemodel//lib/active_model/type/date.rb#57
  def fallback_string_to_date(string); end

  # source://activemodel//lib/active_model/type/date.rb#51
  def fast_string_to_date(string); end

  # source://activemodel//lib/active_model/type/date.rb#66
  def new_date(year, mon, mday); end

  # source://activemodel//lib/active_model/type/date.rb#72
  def value_from_multiparameter_assignment(*_arg0); end
end

# source://activemodel//lib/active_model/type/date.rb#50
ActiveModel::Type::Date::ISO_DATE = T.let(T.unsafe(nil), Regexp)

# = Active Model \DateTime \Type
#
# Attribute type to represent dates and times. It is registered under the
# +:datetime+ key.
#
#   class Event
#     include ActiveModel::Attributes
#
#     attribute :start, :datetime
#   end
#
#   event = Event.new
#   event.start = "Wed, 04 Sep 2013 03:00:00 EAT"
#
#   event.start.class # => Time
#   event.start.year  # => 2013
#   event.start.month # => 9
#   event.start.day   # => 4
#   event.start.hour  # => 3
#   event.start.min   # => 0
#   event.start.sec   # => 0
#   event.start.zone  # => "EAT"
#
# String values are parsed using the ISO 8601 datetime format. Partial
# time-only formats are also accepted.
#
#   event.start = "06:07:08+09:00"
#   event.start.utc # => 1999-12-31 21:07:08 UTC
#
# The degree of sub-second precision can be customized when declaring an
# attribute:
#
#   class Event
#     include ActiveModel::Attributes
#
#     attribute :start, :datetime, precision: 4
#   end
#
# source://activemodel//lib/active_model/type/date_time.rb#42
class ActiveModel::Type::DateTime < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Timezone
  include ::ActiveModel::Type::Helpers::AcceptsMultiparameterTime::InstanceMethods
  include ::ActiveModel::Type::Helpers::TimeValue

  # source://activemodel//lib/active_model/type/date_time.rb#49
  def type; end

  private

  # source://activemodel//lib/active_model/type/date_time.rb#54
  def cast_value(value); end

  # source://activemodel//lib/active_model/type/date_time.rb#67
  def fallback_string_to_time(string); end

  # '0.123456' -> 123456
  # '1.123456' -> 123456
  #
  # source://activemodel//lib/active_model/type/date_time.rb#63
  def microseconds(time); end

  # source://activemodel//lib/active_model/type/date_time.rb#79
  def value_from_multiparameter_assignment(values_hash); end
end

# = Active Model \Decimal \Type
#
# Attribute type for decimal, high-precision floating point numeric
# representation. It is registered under the +:decimal+ key.
#
#   class BagOfCoffee
#     include ActiveModel::Attributes
#
#     attribute :weight, :decimal
#   end
#
# Numeric instances are converted to BigDecimal instances. Any other objects
# are cast using their +to_d+ method, except for blank strings, which are
# cast to +nil+. If a +to_d+ method is not defined, the object is converted
# to a string using +to_s+, which is then cast using +to_d+.
#
#   bag = BagOfCoffee.new
#
#   bag.weight = 0.01
#   bag.weight # => 0.1e-1
#
#   bag.weight = "0.01"
#   bag.weight # => 0.1e-1
#
#   bag.weight = ""
#   bag.weight # => nil
#
#   bag.weight = :arbitrary
#   bag.weight # => nil (the result of `.to_s.to_d`)
#
# Decimal precision defaults to 18, and can be customized when declaring an
# attribute:
#
#   class BagOfCoffee
#     include ActiveModel::Attributes
#
#     attribute :weight, :decimal, precision: 24
#   end
#
# source://activemodel//lib/active_model/type/decimal.rb#45
class ActiveModel::Type::Decimal < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Numeric

  # source://activemodel//lib/active_model/type/decimal.rb#49
  def type; end

  # source://activemodel//lib/active_model/type/decimal.rb#53
  def type_cast_for_schema(value); end

  private

  # source://activemodel//lib/active_model/type/decimal.rb#98
  def apply_scale(value); end

  # source://activemodel//lib/active_model/type/decimal.rb#58
  def cast_value(value); end

  # source://activemodel//lib/active_model/type/decimal.rb#82
  def convert_float_to_big_decimal(value); end

  # source://activemodel//lib/active_model/type/decimal.rb#90
  def float_precision; end
end

# source://activemodel//lib/active_model/type/decimal.rb#47
ActiveModel::Type::Decimal::BIGDECIMAL_PRECISION = T.let(T.unsafe(nil), Integer)

# = Active Model \Float \Type
#
# Attribute type for floating point numeric values. It is registered under
# the +:float+ key.
#
#   class BagOfCoffee
#     include ActiveModel::Attributes
#
#     attribute :weight, :float
#   end
#
# Values are cast using their +to_f+ method, except for the following
# strings:
#
# - Blank strings are cast to +nil+.
# - <tt>"Infinity"</tt> is cast to +Float::INFINITY+.
# - <tt>"-Infinity"</tt> is cast to <tt>-Float::INFINITY</tt>.
# - <tt>"NaN"</tt> is cast to +Float::NAN+.
#
#   bag = BagOfCoffee.new
#
#   bag.weight = "0.25"
#   bag.weight # => 0.25
#
#   bag.weight = ""
#   bag.weight # => nil
#
#   bag.weight = "NaN"
#   bag.weight # => Float::NAN
#
# source://activemodel//lib/active_model/type/float.rb#36
class ActiveModel::Type::Float < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Numeric

  # source://activemodel//lib/active_model/type/float.rb#39
  def type; end

  # source://activemodel//lib/active_model/type/float.rb#43
  def type_cast_for_schema(value); end

  private

  # source://activemodel//lib/active_model/type/float.rb#53
  def cast_value(value); end
end

# source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#5
module ActiveModel::Type::Helpers; end

# source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#6
class ActiveModel::Type::Helpers::AcceptsMultiparameterTime < ::Module
  # @return [AcceptsMultiparameterTime] a new instance of AcceptsMultiparameterTime
  #
  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#37
  def initialize(defaults: T.unsafe(nil)); end
end

# source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#7
module ActiveModel::Type::Helpers::AcceptsMultiparameterTime::InstanceMethods
  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#24
  def assert_valid_value(value); end

  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#16
  def cast(value); end

  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#8
  def serialize(value); end

  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#12
  def serialize_cast_value(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/accepts_multiparameter_time.rb#32
  def value_constructed_by_mass_assignment?(value); end
end

# source://activemodel//lib/active_model/type/helpers/mutable.rb#6
module ActiveModel::Type::Helpers::Mutable
  # source://activemodel//lib/active_model/type/helpers/mutable.rb#7
  def cast(value); end

  # +raw_old_value+ will be the `_before_type_cast` version of the
  # value (likely a string). +new_value+ will be the current, type
  # cast value.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/mutable.rb#14
  def changed_in_place?(raw_old_value, new_value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/mutable.rb#18
  def mutable?; end
end

# source://activemodel//lib/active_model/type/helpers/numeric.rb#6
module ActiveModel::Type::Helpers::Numeric
  # source://activemodel//lib/active_model/type/helpers/numeric.rb#15
  def cast(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/numeric.rb#31
  def changed?(old_value, _new_value, new_value_before_type_cast); end

  # source://activemodel//lib/active_model/type/helpers/numeric.rb#7
  def serialize(value); end

  # source://activemodel//lib/active_model/type/helpers/numeric.rb#11
  def serialize_cast_value(value); end

  private

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/numeric.rb#37
  def equal_nan?(old_value, new_value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/numeric.rb#49
  def non_numeric_string?(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/numeric.rb#44
  def number_to_non_number?(old_value, new_value_before_type_cast); end
end

# source://activemodel//lib/active_model/type/helpers/numeric.rb#56
ActiveModel::Type::Helpers::Numeric::NUMERIC_REGEX = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/type/helpers/time_value.rb#9
module ActiveModel::Type::Helpers::TimeValue
  # source://activemodel//lib/active_model/type/helpers/time_value.rb#24
  def apply_seconds_precision(value); end

  # source://activemodel//lib/active_model/type/helpers/time_value.rb#10
  def serialize_cast_value(value); end

  # source://activemodel//lib/active_model/type/helpers/time_value.rb#38
  def type_cast_for_schema(value); end

  # source://activemodel//lib/active_model/type/helpers/time_value.rb#42
  def user_input_in_time_zone(value); end

  private

  # BUG: Wrapping the Time object with Time.at because Time.new with `in:` in Ruby 3.2.0
  # used to return an invalid Time object
  # see: https://bugs.ruby-lang.org/issues/19292
  #
  # source://activemodel//lib/active_model/type/helpers/time_value.rb#89
  def fast_string_to_time(string); end

  # source://activemodel//lib/active_model/type/helpers/time_value.rb#47
  def new_time(year, mon, mday, hour, min, sec, microsec, offset = T.unsafe(nil)); end
end

# source://activemodel//lib/active_model/type/helpers/time_value.rb#64
ActiveModel::Type::Helpers::TimeValue::ISO_DATETIME = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/type/helpers/timezone.rb#8
module ActiveModel::Type::Helpers::Timezone
  # source://activemodel//lib/active_model/type/helpers/timezone.rb#17
  def default_timezone; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/helpers/timezone.rb#9
  def is_utc?; end
end

# = Active Model \ImmutableString \Type
#
# Attribute type to represent immutable strings. It casts incoming values to
# frozen strings.
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :name, :immutable_string
#   end
#
#   person = Person.new
#   person.name = 1
#
#   person.name # => "1"
#   person.name.frozen? # => true
#
# Values are coerced to strings using their +to_s+ method. Boolean values
# are treated differently, however: +true+ will be cast to <tt>"t"</tt> and
# +false+ will be cast to <tt>"f"</tt>. These strings can be customized when
# declaring an attribute:
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :active, :immutable_string, true: "aye", false: "nay"
#   end
#
#   person = Person.new
#   person.active = true
#
#   person.active # => "aye"
#
# source://activemodel//lib/active_model/type/immutable_string.rb#37
class ActiveModel::Type::ImmutableString < ::ActiveModel::Type::Value
  # @return [ImmutableString] a new instance of ImmutableString
  #
  # source://activemodel//lib/active_model/type/immutable_string.rb#38
  def initialize(**args); end

  # source://activemodel//lib/active_model/type/immutable_string.rb#48
  def serialize(value); end

  # source://activemodel//lib/active_model/type/immutable_string.rb#57
  def serialize_cast_value(value); end

  # source://activemodel//lib/active_model/type/immutable_string.rb#44
  def type; end

  private

  # source://activemodel//lib/active_model/type/immutable_string.rb#62
  def cast_value(value); end
end

# = Active Model \Integer \Type
#
# Attribute type for integer representation. This type is registered under
# the +:integer+ key.
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :age, :integer
#   end
#
# Values are cast using their +to_i+ method, except for blank strings, which
# are cast to +nil+. If a +to_i+ method is not defined or raises an error,
# the value will be cast to +nil+.
#
#   person = Person.new
#
#   person.age = "18"
#   person.age # => 18
#
#   person.age = ""
#   person.age # => nil
#
#   person.age = :not_an_integer
#   person.age # => nil (because Symbol does not define #to_i)
#
# Serialization also works under the same principle. Non-numeric strings are
# serialized as +nil+, for example.
#
# Serialization also validates that the integer can be stored using a
# limited number of bytes. If it cannot, an ActiveModel::RangeError will be
# raised. The default limit is 4 bytes, and can be customized when declaring
# an attribute:
#
#   class Person
#     include ActiveModel::Attributes
#
#     attribute :age, :integer, limit: 6
#   end
#
# source://activemodel//lib/active_model/type/integer.rb#44
class ActiveModel::Type::Integer < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Numeric

  # @return [Integer] a new instance of Integer
  #
  # source://activemodel//lib/active_model/type/integer.rb#51
  def initialize(**_arg0); end

  # source://activemodel//lib/active_model/type/integer.rb#60
  def deserialize(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/integer.rb#74
  def serializable?(value); end

  # source://activemodel//lib/active_model/type/integer.rb#65
  def serialize(value); end

  # source://activemodel//lib/active_model/type/integer.rb#70
  def serialize_cast_value(value); end

  # source://activemodel//lib/active_model/type/integer.rb#56
  def type; end

  private

  # source://activemodel//lib/active_model/type/integer.rb#108
  def _limit; end

  # source://activemodel//lib/active_model/type/integer.rb#89
  def cast_value(value); end

  # source://activemodel//lib/active_model/type/integer.rb#93
  def ensure_in_range(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/integer.rb#85
  def in_range?(value); end

  # source://activemodel//lib/active_model/type/integer.rb#100
  def max_value; end

  # source://activemodel//lib/active_model/type/integer.rb#104
  def min_value; end

  # Returns the value of attribute range.
  #
  # source://activemodel//lib/active_model/type/integer.rb#83
  def range; end
end

# Column storage size in bytes.
# 4 bytes means an integer as opposed to smallint etc.
#
# source://activemodel//lib/active_model/type/integer.rb#49
ActiveModel::Type::Integer::DEFAULT_LIMIT = T.let(T.unsafe(nil), Integer)

# source://activemodel//lib/active_model/type/registry.rb#5
class ActiveModel::Type::Registry
  # @return [Registry] a new instance of Registry
  #
  # source://activemodel//lib/active_model/type/registry.rb#6
  def initialize; end

  # source://activemodel//lib/active_model/type/registry.rb#23
  def lookup(symbol, *_arg1, **_arg2, &_arg3); end

  # source://activemodel//lib/active_model/type/registry.rb#15
  def register(type_name, klass = T.unsafe(nil), &block); end

  private

  # source://activemodel//lib/active_model/type/registry.rb#10
  def initialize_copy(other); end

  # Returns the value of attribute registrations.
  #
  # source://activemodel//lib/active_model/type/registry.rb#34
  def registrations; end
end

# source://activemodel//lib/active_model/type/serialize_cast_value.rb#5
module ActiveModel::Type::SerializeCastValue
  extend ::ActiveSupport::Concern
  include ::ActiveModel::Type::SerializeCastValue::DefaultImplementation

  mixes_in_class_methods ::ActiveModel::Type::SerializeCastValue::ClassMethods

  # source://activemodel//lib/active_model/type/serialize_cast_value.rb#41
  def initialize(*_arg0, **_arg1, &_arg2); end

  # source://activemodel//lib/active_model/type/serialize_cast_value.rb#37
  def itself_if_serialize_cast_value_compatible; end

  class << self
    # @private
    #
    # source://activemodel//lib/active_model/type/serialize_cast_value.rb#21
    def included(klass); end

    # source://activemodel//lib/active_model/type/serialize_cast_value.rb#25
    def serialize(type, value); end
  end
end

# source://activemodel//lib/active_model/type/serialize_cast_value.rb#8
module ActiveModel::Type::SerializeCastValue::ClassMethods
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/serialize_cast_value.rb#9
  def serialize_cast_value_compatible?; end
end

# source://activemodel//lib/active_model/type/serialize_cast_value.rb#15
module ActiveModel::Type::SerializeCastValue::DefaultImplementation
  # source://activemodel//lib/active_model/type/serialize_cast_value.rb#16
  def serialize_cast_value(value); end
end

# = Active Model \String \Type
#
# Attribute type for strings. It is registered under the +:string+ key.
#
# This class is a specialization of ActiveModel::Type::ImmutableString. It
# performs coercion in the same way, and can be configured in the same way.
# However, it accounts for mutable strings, so dirty tracking can properly
# check if a string has changed.
#
# source://activemodel//lib/active_model/type/string.rb#15
class ActiveModel::Type::String < ::ActiveModel::Type::ImmutableString
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/string.rb#16
  def changed_in_place?(raw_old_value, new_value); end

  # source://activemodel//lib/active_model/type/string.rb#22
  def to_immutable_string; end

  private

  # source://activemodel//lib/active_model/type/string.rb#33
  def cast_value(value); end
end

# = Active Model \Time \Type
#
# Attribute type for time of day representation. It is registered under the
# +:time+ key.
#
#   class Event
#     include ActiveModel::Attributes
#
#     attribute :start, :time
#   end
#
# String values are parsed using the ISO 8601 datetime format, but are
# normalized to have a date of 2000-01-01 and be in the UTC time zone.
#
#   event = Event.new
#   event.start = "2004-10-25T01:23:45-06:00"
#
#   event.start.class # => Time
#   event.start       # => 2000-01-01 07:23:45 UTC
#
# Partial time-only formats are also accepted.
#
#   event.start = "00:01:02+03:00"
#   event.start # => 1999-12-31 21:01:02 UTC
#
# The degree of sub-second precision can be customized when declaring an
# attribute:
#
#   class Event
#     include ActiveModel::Attributes
#
#     attribute :start, :time, precision: 4
#   end
#
# source://activemodel//lib/active_model/type/time.rb#38
class ActiveModel::Type::Time < ::ActiveModel::Type::Value
  include ::ActiveModel::Type::Helpers::Timezone
  include ::ActiveModel::Type::Helpers::AcceptsMultiparameterTime::InstanceMethods
  include ::ActiveModel::Type::Helpers::TimeValue

  # source://activemodel//lib/active_model/type/time.rb#45
  def type; end

  # source://activemodel//lib/active_model/type/time.rb#49
  def user_input_in_time_zone(value); end

  private

  # source://activemodel//lib/active_model/type/time.rb#69
  def cast_value(value); end
end

# = Active Model \Value \Type
#
# The base class for all attribute types. This class also serves as the
# default type for attributes that do not specify a type.
#
# source://activemodel//lib/active_model/type/value.rb#9
class ActiveModel::Type::Value
  include ::ActiveModel::Type::SerializeCastValue
  include ::ActiveModel::Type::SerializeCastValue::DefaultImplementation
  extend ::ActiveModel::Type::SerializeCastValue::ClassMethods

  # Initializes a type with three basic configuration settings: precision,
  # limit, and scale. The Value base class does not define behavior for
  # these settings. It uses them for equality comparison and hash key
  # generation only.
  #
  # @return [Value] a new instance of Value
  #
  # source://activemodel//lib/active_model/type/value.rb#17
  def initialize(precision: T.unsafe(nil), limit: T.unsafe(nil), scale: T.unsafe(nil)); end

  # source://activemodel//lib/active_model/type/value.rb#121
  def ==(other); end

  # @raise [NoMethodError]
  #
  # source://activemodel//lib/active_model/type/value.rb#144
  def as_json(*_arg0); end

  # source://activemodel//lib/active_model/type/value.rb#133
  def assert_valid_value(_); end

  # These predicates are not documented, as I need to look further into
  # their use, and see if they can be removed entirely.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#77
  def binary?; end

  # Type casts a value from user input (e.g. from a setter). This value may
  # be a string from the form builder, or a ruby object passed to a setter.
  # There is currently no way to differentiate between which source it came
  # from.
  #
  # The return value of this method will be returned from
  # ActiveRecord::AttributeMethods::Read#read_attribute. See also:
  # Value#cast_value.
  #
  # +value+ The raw input, as provided to the attribute setter.
  #
  # source://activemodel//lib/active_model/type/value.rb#57
  def cast(value); end

  # Determines whether a value has changed for dirty checking. +old_value+
  # and +new_value+ will always be type-cast. Types should not need to
  # override this method.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#84
  def changed?(old_value, new_value, _new_value_before_type_cast); end

  # Determines whether the mutable value has been modified since it was
  # read. Returns +false+ by default. If your type returns an object
  # which could be mutated, you should override this method. You will need
  # to either:
  #
  # - pass +new_value+ to Value#serialize and compare it to
  #   +raw_old_value+
  #
  # or
  #
  # - pass +raw_old_value+ to Value#deserialize and compare it to
  #   +new_value+
  #
  # +raw_old_value+ The original value, before being passed to
  # +deserialize+.
  #
  # +new_value+ The current value, after type casting.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#105
  def changed_in_place?(raw_old_value, new_value); end

  # Converts a value from database input to the appropriate ruby type. The
  # return value of this method will be returned from
  # ActiveRecord::AttributeMethods::Read#read_attribute. The default
  # implementation just calls Value#cast.
  #
  # +value+ The raw input, as provided from the database.
  #
  # source://activemodel//lib/active_model/type/value.rb#43
  def deserialize(value); end

  # source://activemodel//lib/active_model/type/value.rb#121
  def eql?(other); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#113
  def force_equality?(_value); end

  # source://activemodel//lib/active_model/type/value.rb#129
  def hash; end

  # Returns the value of attribute limit.
  #
  # source://activemodel//lib/active_model/type/value.rb#11
  def limit; end

  # @yield [value]
  #
  # source://activemodel//lib/active_model/type/value.rb#117
  def map(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#140
  def mutable?; end

  # Returns the value of attribute precision.
  #
  # source://activemodel//lib/active_model/type/value.rb#11
  def precision; end

  # Returns the value of attribute scale.
  #
  # source://activemodel//lib/active_model/type/value.rb#11
  def scale; end

  # Returns true if this type can convert +value+ to a type that is usable
  # by the database.  For example a boolean type can return +true+ if the
  # value parameter is a Ruby boolean, but may return +false+ if the value
  # parameter is some other object.
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#28
  def serializable?(value); end

  # Casts a value from the ruby type to a type that the database knows how
  # to understand. The returned value from this method should be a
  # +String+, +Numeric+, +Date+, +Time+, +Symbol+, +true+, +false+, or
  # +nil+.
  #
  # source://activemodel//lib/active_model/type/value.rb#65
  def serialize(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#136
  def serialized?; end

  # Returns the unique type name as a Symbol. Subclasses should override
  # this method.
  #
  # source://activemodel//lib/active_model/type/value.rb#34
  def type; end

  # Type casts a value for schema dumping. This method is private, as we are
  # hoping to remove it entirely.
  #
  # source://activemodel//lib/active_model/type/value.rb#71
  def type_cast_for_schema(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/type/value.rb#109
  def value_constructed_by_mass_assignment?(_value); end

  private

  # Convenience method for types which do not need separate type casting
  # behavior for user and database inputs. Called by Value#cast for
  # values except +nil+.
  #
  # source://activemodel//lib/active_model/type/value.rb#152
  def cast_value(value); end
end

# = Active \Model \UnknownAttributeError
#
# Raised when unknown attributes are supplied via mass assignment.
#
#   class Person
#     include ActiveModel::AttributeAssignment
#     include ActiveModel::Validations
#   end
#
#   person = Person.new
#   person.assign_attributes(name: 'Gorby')
#   # => ActiveModel::UnknownAttributeError: unknown attribute 'name' for Person.
#
# source://activemodel//lib/active_model/errors.rb#538
class ActiveModel::UnknownAttributeError < ::NoMethodError
  # @return [UnknownAttributeError] a new instance of UnknownAttributeError
  #
  # source://activemodel//lib/active_model/errors.rb#541
  def initialize(record, attribute); end

  # Returns the value of attribute attribute.
  #
  # source://activemodel//lib/active_model/errors.rb#539
  def attribute; end

  # Returns the value of attribute record.
  #
  # source://activemodel//lib/active_model/errors.rb#539
  def record; end
end

# source://activemodel//lib/active_model/gem_version.rb#9
module ActiveModel::VERSION; end

# source://activemodel//lib/active_model/gem_version.rb#10
ActiveModel::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://activemodel//lib/active_model/gem_version.rb#11
ActiveModel::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://activemodel//lib/active_model/gem_version.rb#13
ActiveModel::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://activemodel//lib/active_model/gem_version.rb#15
ActiveModel::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://activemodel//lib/active_model/gem_version.rb#12
ActiveModel::VERSION::TINY = T.let(T.unsafe(nil), Integer)

# = Active \Model \ValidationError
#
# Raised by <tt>validate!</tt> when the model is invalid. Use the
# +model+ method to retrieve the record which did not validate.
#
#   begin
#     complex_operation_that_internally_calls_validate!
#   rescue ActiveModel::ValidationError => invalid
#     puts invalid.model.errors
#   end
#
# source://activemodel//lib/active_model/validations.rb#460
class ActiveModel::ValidationError < ::StandardError
  # @return [ValidationError] a new instance of ValidationError
  #
  # source://activemodel//lib/active_model/validations.rb#463
  def initialize(model); end

  # Returns the value of attribute model.
  #
  # source://activemodel//lib/active_model/validations.rb#461
  def model; end
end

# = Active \Model \Validations
#
# Provides a full validation framework to your objects.
#
# A minimal implementation could be:
#
#   class Person
#     include ActiveModel::Validations
#
#     attr_accessor :first_name, :last_name
#
#     validates_each :first_name, :last_name do |record, attr, value|
#       record.errors.add attr, "starts with z." if value.start_with?("z")
#     end
#   end
#
# Which provides you with the full standard validation stack that you
# know from Active Record:
#
#   person = Person.new
#   person.valid?                   # => true
#   person.invalid?                 # => false
#
#   person.first_name = 'zoolander'
#   person.valid?                   # => false
#   person.invalid?                 # => true
#   person.errors.messages          # => {first_name:["starts with z."]}
#
# Note that +ActiveModel::Validations+ automatically adds an +errors+
# method to your instances initialized with a new ActiveModel::Errors
# object, so there is no need for you to do this manually.
#
# source://activemodel//lib/active_model/validations.rb#37
module ActiveModel::Validations
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks
  include ::ActiveModel::Validations::HelperMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Validations::ClassMethods
  mixes_in_class_methods ::ActiveModel::Callbacks
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::ActiveModel::Translation
  mixes_in_class_methods ::ActiveModel::Validations::HelperMethods

  # Returns the +Errors+ object that holds all information about attribute
  # error messages.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name
  #   end
  #
  #   person = Person.new
  #   person.valid? # => false
  #   person.errors # => #<ActiveModel::Errors:0x007fe603816640 @messages={name:["can't be blank"]}>
  #
  # source://activemodel//lib/active_model/validations.rb#330
  def errors; end

  # Performs the opposite of <tt>valid?</tt>. Returns +true+ if errors were
  # added, +false+ otherwise.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name
  #   end
  #
  #   person = Person.new
  #   person.name = ''
  #   person.invalid? # => true
  #   person.name = 'david'
  #   person.invalid? # => false
  #
  # Context can optionally be supplied to define which callbacks to test
  # against (the context is defined on the validations using <tt>:on</tt>).
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name, on: :new
  #   end
  #
  #   person = Person.new
  #   person.invalid?       # => false
  #   person.invalid?(:new) # => true
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations.rb#402
  def invalid?(context = T.unsafe(nil)); end

  # Hook method defining how an attribute value should be retrieved. By default
  # this is assumed to be an instance named after the attribute. Override this
  # method in subclasses should you need to retrieve the value for a given
  # attribute differently:
  #
  #   class MyClass
  #     include ActiveModel::Validations
  #
  #     def initialize(data = {})
  #       @data = data
  #     end
  #
  #     def read_attribute_for_validation(key)
  #       @data[key]
  #     end
  #   end
  def read_attribute_for_validation(*_arg0); end

  # Runs all the specified validations and returns +true+ if no errors were
  # added otherwise +false+.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name
  #   end
  #
  #   person = Person.new
  #   person.name = ''
  #   person.valid? # => false
  #   person.name = 'david'
  #   person.valid? # => true
  #
  # Context can optionally be supplied to define which callbacks to test
  # against (the context is defined on the validations using <tt>:on</tt>).
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name, on: :new
  #   end
  #
  #   person = Person.new
  #   person.valid?       # => true
  #   person.valid?(:new) # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations.rb#363
  def valid?(context = T.unsafe(nil)); end

  # Runs all the specified validations and returns +true+ if no errors were
  # added otherwise +false+.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name
  #   end
  #
  #   person = Person.new
  #   person.name = ''
  #   person.valid? # => false
  #   person.name = 'david'
  #   person.valid? # => true
  #
  # Context can optionally be supplied to define which callbacks to test
  # against (the context is defined on the validations using <tt>:on</tt>).
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates_presence_of :name, on: :new
  #   end
  #
  #   person = Person.new
  #   person.valid?       # => true
  #   person.valid?(:new) # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations.rb#363
  def validate(context = T.unsafe(nil)); end

  # Runs all the validations within the specified context. Returns +true+ if
  # no errors are found, raises +ValidationError+ otherwise.
  #
  # Validations with no <tt>:on</tt> option will run no matter the context. Validations with
  # some <tt>:on</tt> option will only run in the specified context.
  #
  # source://activemodel//lib/active_model/validations.rb#411
  def validate!(context = T.unsafe(nil)); end

  # Passes the record off to the class or classes specified and allows them
  # to add errors based on more complex conditions.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     validate :instance_validations
  #
  #     def instance_validations
  #       validates_with MyValidator
  #     end
  #   end
  #
  # Please consult the class method documentation for more information on
  # creating your own validator.
  #
  # You may also pass it multiple classes, like so:
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     validate :instance_validations, on: :create
  #
  #     def instance_validations
  #       validates_with MyValidator, MyOtherValidator
  #     end
  #   end
  #
  # Standard configuration options (<tt>:on</tt>, <tt>:if</tt> and
  # <tt>:unless</tt>), which are available on the class version of
  # +validates_with+, should instead be placed on the +validates+ method
  # as these are applied and tested in the callback.
  #
  # If you pass any additional configuration options, they will be passed
  # to the class and available as +options+, please refer to the
  # class version of this method for more information.
  #
  # source://activemodel//lib/active_model/validations/with.rb#144
  def validates_with(*args, &block); end

  private

  # source://activemodel//lib/active_model/validations.rb#434
  def init_internals; end

  # Clean the +Errors+ object if instance is duped.
  #
  # source://activemodel//lib/active_model/validations.rb#312
  def initialize_dup(other); end

  # @raise [ValidationError]
  #
  # source://activemodel//lib/active_model/validations.rb#445
  def raise_validation_error; end

  # source://activemodel//lib/active_model/validations.rb#440
  def run_validations!; end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
    def _validators; end
    def _validators=(value); end
    def _validators?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
    def _validators; end
    def _validators?; end
  end
end

# == \Active \Model Absence Validator
#
# source://activemodel//lib/active_model/validations/absence.rb#6
class ActiveModel::Validations::AbsenceValidator < ::ActiveModel::EachValidator
  # source://activemodel//lib/active_model/validations/absence.rb#7
  def validate_each(record, attr_name, value); end
end

# source://activemodel//lib/active_model/validations/acceptance.rb#5
class ActiveModel::Validations::AcceptanceValidator < ::ActiveModel::EachValidator
  # @return [AcceptanceValidator] a new instance of AcceptanceValidator
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#6
  def initialize(options); end

  # source://activemodel//lib/active_model/validations/acceptance.rb#11
  def validate_each(record, attribute, value); end

  private

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#23
  def acceptable_option?(value); end

  # source://activemodel//lib/active_model/validations/acceptance.rb#18
  def setup!(klass); end
end

# source://activemodel//lib/active_model/validations/acceptance.rb#27
class ActiveModel::Validations::AcceptanceValidator::LazilyDefineAttributes < ::Module
  # @return [LazilyDefineAttributes] a new instance of LazilyDefineAttributes
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#28
  def initialize(attributes); end

  # source://activemodel//lib/active_model/validations/acceptance.rb#73
  def ==(other); end

  # source://activemodel//lib/active_model/validations/acceptance.rb#56
  def define_on(klass); end

  # source://activemodel//lib/active_model/validations/acceptance.rb#32
  def included(klass); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#51
  def matches?(method_name); end

  protected

  # Returns the value of attribute attributes.
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#78
  def attributes; end
end

# = Active \Model \Validation \Callbacks
#
# Provides an interface for any class to have ClassMethods#before_validation and
# ClassMethods#after_validation callbacks.
#
# First, include +ActiveModel::Validations::Callbacks+ from the class you are
# creating:
#
#   class MyModel
#     include ActiveModel::Validations::Callbacks
#
#     before_validation :do_stuff_before_validation
#     after_validation  :do_stuff_after_validation
#   end
#
# Like other <tt>before_*</tt> callbacks if +before_validation+ throws
# +:abort+ then <tt>valid?</tt> will not be called.
#
# source://activemodel//lib/active_model/validations/callbacks.rb#22
module ActiveModel::Validations::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveModel::Validations::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker

  private

  # Override run_validations! to include callbacks.
  #
  # source://activemodel//lib/active_model/validations/callbacks.rb#114
  def run_validations!; end

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://activemodel//lib/active_model/validations/callbacks.rb#32
module ActiveModel::Validations::Callbacks::ClassMethods
  # Defines a callback that will get called right after validation.
  #
  #   class Person
  #     include ActiveModel::Validations
  #     include ActiveModel::Validations::Callbacks
  #
  #     attr_accessor :name, :status
  #
  #     validates_presence_of :name
  #
  #     after_validation :set_status
  #
  #     private
  #       def set_status
  #         self.status = errors.empty?
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = ''
  #   person.valid? # => false
  #   person.status # => false
  #   person.name = 'bob'
  #   person.valid? # => true
  #   person.status # => true
  #
  # source://activemodel//lib/active_model/validations/callbacks.rb#88
  def after_validation(*args, &block); end

  # Defines a callback that will get called right before validation.
  #
  #   class Person
  #     include ActiveModel::Validations
  #     include ActiveModel::Validations::Callbacks
  #
  #     attr_accessor :name
  #
  #     validates_length_of :name, maximum: 6
  #
  #     before_validation :remove_whitespaces
  #
  #     private
  #       def remove_whitespaces
  #         name.strip!
  #       end
  #   end
  #
  #   person = Person.new
  #   person.name = '  bob  '
  #   person.valid? # => true
  #   person.name   # => "bob"
  #
  # source://activemodel//lib/active_model/validations/callbacks.rb#55
  def before_validation(*args, &block); end

  private

  # source://activemodel//lib/active_model/validations/callbacks.rb#99
  def set_options_for_callback(options); end
end

# source://activemodel//lib/active_model/validations.rb#74
module ActiveModel::Validations::ClassMethods
  # Returns +true+ if +attribute+ is an attribute method, +false+ otherwise.
  #
  #  class Person
  #    include ActiveModel::Validations
  #
  #    attr_accessor :name
  #  end
  #
  #  User.attribute_method?(:name) # => true
  #  User.attribute_method?(:age)  # => false
  #
  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations.rb#284
  def attribute_method?(attribute); end

  # Clears all of the validators and validations.
  #
  # Note that this will clear anything that is being used to validate
  # the model for both the +validates_with+ and +validate+ methods.
  # It clears the validators that are created with an invocation of
  # +validates_with+ and the callbacks that are set by an invocation
  # of +validate+.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     validates_with MyValidator
  #     validates_with OtherValidator, on: :create
  #     validates_with StrictValidator, strict: true
  #     validate :cannot_be_robot
  #
  #     def cannot_be_robot
  #       errors.add(:base, 'A person cannot be a robot') if person_is_robot
  #     end
  #   end
  #
  #   Person.validators
  #   # => [
  #   #      #<MyValidator:0x007fbff403e808 @options={}>,
  #   #      #<OtherValidator:0x007fbff403d930 @options={on: :create}>,
  #   #      #<StrictValidator:0x007fbff3204a30 @options={strict:true}>
  #   #    ]
  #
  # If one runs <tt>Person.clear_validators!</tt> and then checks to see what
  # validators this class has, you would obtain:
  #
  #   Person.validators # => []
  #
  # Also, the callback set by <tt>validate :cannot_be_robot</tt> will be erased
  # so that:
  #
  #   Person._validate_callbacks.empty?  # => true
  #
  # source://activemodel//lib/active_model/validations.rb#248
  def clear_validators!; end

  # Copy validators on inheritance.
  #
  # source://activemodel//lib/active_model/validations.rb#289
  def inherited(base); end

  # Adds a validation method or block to the class. This is useful when
  # overriding the +validate+ instance method becomes too unwieldy and
  # you're looking for more descriptive declaration of your validations.
  #
  # This can be done with a symbol pointing to a method:
  #
  #   class Comment
  #     include ActiveModel::Validations
  #
  #     validate :must_be_friends
  #
  #     def must_be_friends
  #       errors.add(:base, 'Must be friends to leave a comment') unless commenter.friend_of?(commentee)
  #     end
  #   end
  #
  # With a block which is passed with the current record to be validated:
  #
  #   class Comment
  #     include ActiveModel::Validations
  #
  #     validate do |comment|
  #       comment.must_be_friends
  #     end
  #
  #     def must_be_friends
  #       errors.add(:base, 'Must be friends to leave a comment') unless commenter.friend_of?(commentee)
  #     end
  #   end
  #
  # Or with a block where +self+ points to the current record to be validated:
  #
  #   class Comment
  #     include ActiveModel::Validations
  #
  #     validate do
  #       errors.add(:base, 'Must be friends to leave a comment') unless commenter.friend_of?(commentee)
  #     end
  #   end
  #
  # Note that the return value of validation methods is not relevant.
  # It's not possible to halt the validate callback chain.
  #
  # Options:
  # * <tt>:on</tt> - Specifies the contexts where this validation is active.
  #   Runs in all validation contexts by default +nil+. You can pass a symbol
  #   or an array of symbols. (e.g. <tt>on: :create</tt> or
  #   <tt>on: :custom_validation_context</tt> or
  #   <tt>on: [:create, :custom_validation_context]</tt>)
  # * <tt>:if</tt> - Specifies a method, proc, or string to call to determine
  #   if the validation should occur (e.g. <tt>if: :allow_validation</tt>,
  #   or <tt>if: Proc.new { |user| user.signup_step > 2 }</tt>). The method,
  #   proc or string should return or evaluate to a +true+ or +false+ value.
  # * <tt>:unless</tt> - Specifies a method, proc, or string to call to
  #   determine if the validation should not occur (e.g. <tt>unless: :skip_validation</tt>,
  #   or <tt>unless: Proc.new { |user| user.signup_step <= 2 }</tt>). The
  #   method, proc, or string should return or evaluate to a +true+ or +false+
  #   value.
  #
  # NOTE: Calling +validate+ multiple times on the same method will overwrite previous definitions.
  #
  # source://activemodel//lib/active_model/validations.rb#171
  def validate(*args, &block); end

  # This method is a shortcut to all default validators and any custom
  # validator classes ending in 'Validator'. Note that \Rails default
  # validators can be overridden inside specific classes by creating
  # custom validator classes in their place such as PresenceValidator.
  #
  # Examples of using the default Rails validators:
  #
  #   validates :username, absence: true
  #   validates :terms, acceptance: true
  #   validates :password, confirmation: true
  #   validates :username, exclusion: { in: %w(admin superuser) }
  #   validates :email, format: { with: /\A([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})\z/i, on: :create }
  #   validates :age, inclusion: { in: 0..9 }
  #   validates :first_name, length: { maximum: 30 }
  #   validates :age, numericality: true
  #   validates :username, presence: true
  #
  # The power of the +validates+ method comes when using custom validators
  # and default validators in one call for a given attribute.
  #
  #   class EmailValidator < ActiveModel::EachValidator
  #     def validate_each(record, attribute, value)
  #       record.errors.add attribute, (options[:message] || "is not an email") unless
  #         /\A([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})\z/i.match?(value)
  #     end
  #   end
  #
  #   class Person
  #     include ActiveModel::Validations
  #     attr_accessor :name, :email
  #
  #     validates :name, presence: true, length: { maximum: 100 }
  #     validates :email, presence: true, email: true
  #   end
  #
  # Validator classes may also exist within the class being validated
  # allowing custom modules of validators to be included as needed.
  #
  #   class Film
  #     include ActiveModel::Validations
  #
  #     class TitleValidator < ActiveModel::EachValidator
  #       def validate_each(record, attribute, value)
  #         record.errors.add attribute, "must start with 'the'" unless /\Athe/i.match?(value)
  #       end
  #     end
  #
  #     validates :name, title: true
  #   end
  #
  # Additionally validator classes may be in another namespace and still
  # used within any class.
  #
  #   validates :name, :'film/title' => true
  #
  # The validators hash can also handle regular expressions, ranges, arrays
  # and strings in shortcut form.
  #
  #   validates :email, format: /@/
  #   validates :role, inclusion: %w(admin contributor)
  #   validates :password, length: 6..20
  #
  # When using shortcut form, ranges and arrays are passed to your
  # validator's initializer as <tt>options[:in]</tt> while other types
  # including regular expressions and strings are passed as <tt>options[:with]</tt>.
  #
  # There is also a list of options that could be used along with validators:
  #
  # * <tt>:on</tt> - Specifies the contexts where this validation is active.
  #   Runs in all validation contexts by default +nil+. You can pass a symbol
  #   or an array of symbols. (e.g. <tt>on: :create</tt> or
  #   <tt>on: :custom_validation_context</tt> or
  #   <tt>on: [:create, :custom_validation_context]</tt>)
  # * <tt>:if</tt> - Specifies a method, proc, or string to call to determine
  #   if the validation should occur (e.g. <tt>if: :allow_validation</tt>,
  #   or <tt>if: Proc.new { |user| user.signup_step > 2 }</tt>). The method,
  #   proc or string should return or evaluate to a +true+ or +false+ value.
  # * <tt>:unless</tt> - Specifies a method, proc, or string to call to determine
  #   if the validation should not occur (e.g. <tt>unless: :skip_validation</tt>,
  #   or <tt>unless: Proc.new { |user| user.signup_step <= 2 }</tt>). The
  #   method, proc, or string should return or evaluate to a +true+ or
  #   +false+ value.
  # * <tt>:allow_nil</tt> - Skip validation if the attribute is +nil+.
  # * <tt>:allow_blank</tt> - Skip validation if the attribute is blank.
  # * <tt>:strict</tt> - If the <tt>:strict</tt> option is set to true
  #   will raise ActiveModel::StrictValidationFailed instead of adding the error.
  #   <tt>:strict</tt> option can also be set to any other exception.
  #
  # Example:
  #
  #   validates :password, presence: true, confirmation: true, if: :password_required?
  #   validates :token, length: { is: 24 }, strict: TokenLengthException
  #
  #
  # Finally, the options +:if+, +:unless+, +:on+, +:allow_blank+, +:allow_nil+, +:strict+
  # and +:message+ can be given to one specific validator, as a hash:
  #
  #   validates :password, presence: { if: :password_required?, message: 'is forgotten.' }, confirmation: true
  #
  # @raise [ArgumentError]
  #
  # source://activemodel//lib/active_model/validations/validates.rb#106
  def validates(*attributes); end

  # This method is used to define validations that cannot be corrected by end
  # users and are considered exceptional. So each validator defined with bang
  # or <tt>:strict</tt> option set to <tt>true</tt> will always raise
  # ActiveModel::StrictValidationFailed instead of adding error
  # when validation fails. See <tt>validates</tt> for more information about
  # the validation itself.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name
  #     validates! :name, presence: true
  #   end
  #
  #   person = Person.new
  #   person.name = ''
  #   person.valid?
  #   # => ActiveModel::StrictValidationFailed: Name can't be blank
  #
  # source://activemodel//lib/active_model/validations/validates.rb#148
  def validates!(*attributes); end

  # Validates each attribute against a block.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :first_name, :last_name
  #
  #     validates_each :first_name, :last_name, allow_blank: true do |record, attr, value|
  #       record.errors.add attr, "starts with z." if value.start_with?("z")
  #     end
  #   end
  #
  # Options:
  # * <tt>:on</tt> - Specifies the contexts where this validation is active.
  #   Runs in all validation contexts by default +nil+. You can pass a symbol
  #   or an array of symbols. (e.g. <tt>on: :create</tt> or
  #   <tt>on: :custom_validation_context</tt> or
  #   <tt>on: [:create, :custom_validation_context]</tt>)
  # * <tt>:allow_nil</tt> - Skip validation if attribute is +nil+.
  # * <tt>:allow_blank</tt> - Skip validation if attribute is blank.
  # * <tt>:if</tt> - Specifies a method, proc, or string to call to determine
  #   if the validation should occur (e.g. <tt>if: :allow_validation</tt>,
  #   or <tt>if: Proc.new { |user| user.signup_step > 2 }</tt>). The method,
  #   proc or string should return or evaluate to a +true+ or +false+ value.
  # * <tt>:unless</tt> - Specifies a method, proc, or string to call to
  #   determine if the validation should not occur (e.g. <tt>unless: :skip_validation</tt>,
  #   or <tt>unless: Proc.new { |user| user.signup_step <= 2 }</tt>). The
  #   method, proc, or string should return or evaluate to a +true+ or +false+
  #   value.
  #
  # source://activemodel//lib/active_model/validations.rb#104
  def validates_each(*attr_names, &block); end

  # Passes the record off to the class or classes specified and allows them
  # to add errors based on more complex conditions.
  #
  #   class Person
  #     include ActiveModel::Validations
  #     validates_with MyValidator
  #   end
  #
  #   class MyValidator < ActiveModel::Validator
  #     def validate(record)
  #       if some_complex_logic
  #         record.errors.add :base, 'This record is invalid'
  #       end
  #     end
  #
  #     private
  #       def some_complex_logic
  #         # ...
  #       end
  #   end
  #
  # You may also pass it multiple classes, like so:
  #
  #   class Person
  #     include ActiveModel::Validations
  #     validates_with MyValidator, MyOtherValidator, on: :create
  #   end
  #
  # There is no default error message for +validates_with+. You must
  # manually add errors to the record's errors collection in the validator
  # class.
  #
  # To implement the validate method, you must have a +record+ parameter
  # defined, which is the record to be validated.
  #
  # Configuration options:
  # * <tt>:on</tt> - Specifies the contexts where this validation is active.
  #   Runs in all validation contexts by default +nil+. You can pass a symbol
  #   or an array of symbols. (e.g. <tt>on: :create</tt> or
  #   <tt>on: :custom_validation_context</tt> or
  #   <tt>on: [:create, :custom_validation_context]</tt>)
  # * <tt>:if</tt> - Specifies a method, proc, or string to call to determine
  #   if the validation should occur (e.g. <tt>if: :allow_validation</tt>,
  #   or <tt>if: Proc.new { |user| user.signup_step > 2 }</tt>).
  #   The method, proc, or string should return or evaluate to a +true+ or
  #   +false+ value.
  # * <tt>:unless</tt> - Specifies a method, proc, or string to call to
  #   determine if the validation should not occur
  #   (e.g. <tt>unless: :skip_validation</tt>, or
  #   <tt>unless: Proc.new { |user| user.signup_step <= 2 }</tt>).
  #   The method, proc, or string should return or evaluate to a +true+ or
  #   +false+ value.
  # * <tt>:strict</tt> - Specifies whether validation should be strict.
  #   See <tt>ActiveModel::Validations#validates!</tt> for more information.
  #
  # If you pass any additional configuration options, they will be passed
  # to the class and available as +options+:
  #
  #   class Person
  #     include ActiveModel::Validations
  #     validates_with MyValidator, my_custom_key: 'my custom value'
  #   end
  #
  #   class MyValidator < ActiveModel::Validator
  #     def validate(record)
  #       options[:my_custom_key] # => "my custom value"
  #     end
  #   end
  #
  # source://activemodel//lib/active_model/validations/with.rb#88
  def validates_with(*args, &block); end

  # List all validators that are being used to validate the model using
  # +validates_with+ method.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     validates_with MyValidator
  #     validates_with OtherValidator, on: :create
  #     validates_with StrictValidator, strict: true
  #   end
  #
  #   Person.validators
  #   # => [
  #   #      #<MyValidator:0x007fbff403e808 @options={}>,
  #   #      #<OtherValidator:0x007fbff403d930 @options={on: :create}>,
  #   #      #<StrictValidator:0x007fbff3204a30 @options={strict:true}>
  #   #    ]
  #
  # source://activemodel//lib/active_model/validations.rb#206
  def validators; end

  # List all validators that are being used to validate a specific attribute.
  #
  #   class Person
  #     include ActiveModel::Validations
  #
  #     attr_accessor :name, :age
  #
  #     validates_presence_of :name
  #     validates_inclusion_of :age, in: 0..99
  #   end
  #
  #   Person.validators_on(:name)
  #   # => [
  #   #       #<ActiveModel::Validations::PresenceValidator:0x007fe604914e60 @attributes=[:name], @options={}>,
  #   #    ]
  #
  # source://activemodel//lib/active_model/validations.rb#268
  def validators_on(*attributes); end

  private

  # source://activemodel//lib/active_model/validations/validates.rb#161
  def _parse_validates_options(options); end

  # When creating custom validators, it might be useful to be able to specify
  # additional default keys. This can be done by overwriting this method.
  #
  # source://activemodel//lib/active_model/validations/validates.rb#157
  def _validates_default_keys; end

  # source://activemodel//lib/active_model/validations.rb#298
  def predicate_for_validation_context(context); end
end

# source://activemodel//lib/active_model/validations.rb#108
ActiveModel::Validations::ClassMethods::VALID_OPTIONS_FOR_VALIDATE = T.let(T.unsafe(nil), Array)

# source://activemodel//lib/active_model/validations/clusivity.rb#8
module ActiveModel::Validations::Clusivity
  include ::ActiveModel::Validations::ResolveValue

  # source://activemodel//lib/active_model/validations/clusivity.rb#14
  def check_validity!; end

  private

  # source://activemodel//lib/active_model/validations/clusivity.rb#31
  def delimiter; end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/clusivity.rb#21
  def include?(record, value); end

  # After Ruby 2.2, <tt>Range#include?</tt> on non-number-or-time-ish ranges checks all
  # possible values in the range for equality, which is slower but more accurate.
  # <tt>Range#cover?</tt> uses the previous logic of comparing a value with the range
  # endpoints, which is fast but is only accurate on Numeric, Time, Date,
  # or DateTime ranges.
  #
  # source://activemodel//lib/active_model/validations/clusivity.rb#40
  def inclusion_method(enumerable); end
end

# source://activemodel//lib/active_model/validations/clusivity.rb#11
ActiveModel::Validations::Clusivity::ERROR_MESSAGE = T.let(T.unsafe(nil), String)

# source://activemodel//lib/active_model/validations/comparability.rb#5
module ActiveModel::Validations::Comparability
  # source://activemodel//lib/active_model/validations/comparability.rb#10
  def error_options(value, option_value); end
end

# source://activemodel//lib/active_model/validations/comparability.rb#6
ActiveModel::Validations::Comparability::COMPARE_CHECKS = T.let(T.unsafe(nil), Hash)

# source://activemodel//lib/active_model/validations/comparison.rb#8
class ActiveModel::Validations::ComparisonValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::Comparability
  include ::ActiveModel::Validations::ResolveValue

  # source://activemodel//lib/active_model/validations/comparison.rb#12
  def check_validity!; end

  # source://activemodel//lib/active_model/validations/comparison.rb#19
  def validate_each(record, attr_name, value); end
end

# source://activemodel//lib/active_model/validations/confirmation.rb#5
class ActiveModel::Validations::ConfirmationValidator < ::ActiveModel::EachValidator
  # @return [ConfirmationValidator] a new instance of ConfirmationValidator
  #
  # source://activemodel//lib/active_model/validations/confirmation.rb#6
  def initialize(options); end

  # source://activemodel//lib/active_model/validations/confirmation.rb#11
  def validate_each(record, attribute, value); end

  private

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/confirmation.rb#31
  def confirmation_value_equal?(record, attribute, value, confirmed); end

  # source://activemodel//lib/active_model/validations/confirmation.rb#21
  def setup!(klass); end
end

# source://activemodel//lib/active_model/validations/exclusion.rb#7
class ActiveModel::Validations::ExclusionValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::ResolveValue
  include ::ActiveModel::Validations::Clusivity

  # source://activemodel//lib/active_model/validations/exclusion.rb#10
  def validate_each(record, attribute, value); end
end

# source://activemodel//lib/active_model/validations/format.rb#7
class ActiveModel::Validations::FormatValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::ResolveValue

  # source://activemodel//lib/active_model/validations/format.rb#20
  def check_validity!; end

  # source://activemodel//lib/active_model/validations/format.rb#10
  def validate_each(record, attribute, value); end

  private

  # source://activemodel//lib/active_model/validations/format.rb#34
  def check_options_validity(name); end

  # source://activemodel//lib/active_model/validations/format.rb#30
  def record_error(record, attribute, name, value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/format.rb#48
  def regexp_using_multiline_anchors?(regexp); end
end

# source://activemodel//lib/active_model/validations/absence.rb#12
module ActiveModel::Validations::HelperMethods
  # Validates that the specified attributes are blank (as defined by
  # Object#present?).
  #
  #   class Person < ActiveRecord::Base
  #     validates_absence_of :first_name
  #   end
  #
  # The first_name attribute must be in the object and it must be blank.
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "must be blank").
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/absence.rb#28
  def validates_absence_of(*attr_names); end

  # Encapsulates the pattern of wanting to validate the acceptance of a
  # terms of service check box (or similar agreement).
  #
  #   class Person < ActiveRecord::Base
  #     validates_acceptance_of :terms_of_service
  #     validates_acceptance_of :eula, message: 'must be abided'
  #   end
  #
  # If the database column does not exist, the +terms_of_service+ attribute
  # is entirely virtual. This check is performed only if +terms_of_service+
  # is not +nil+.
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "must be
  #   accepted").
  # * <tt>:accept</tt> - Specifies a value that is considered accepted.
  #   Also accepts an array of possible values. The default value is
  #   an array ["1", true], which makes it easy to relate to an HTML
  #   checkbox. This should be set to, or include, +true+ if you are validating
  #   a database column, since the attribute is typecast from "1" to +true+
  #   before validation.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/acceptance.rb#108
  def validates_acceptance_of(*attr_names); end

  # Validates the value of a specified attribute fulfills all
  # defined comparisons with another value, proc, or attribute.
  #
  #   class Person < ActiveRecord::Base
  #     validates_comparison_of :value, greater_than: 'the sum of its parts'
  #   end
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "failed comparison").
  # * <tt>:greater_than</tt> - Specifies the value must be greater than the
  #   supplied value. The default error message for this option is _"must be
  #   greater than %{count}"_.
  # * <tt>:greater_than_or_equal_to</tt> - Specifies the value must be
  #   greater than or equal to the supplied value. The default error message
  #   for this option is _"must be greater than or equal to %{count}"_.
  # * <tt>:equal_to</tt> - Specifies the value must be equal to the supplied
  #   value. The default error message for this option is _"must be equal to
  #   %{count}"_.
  # * <tt>:less_than</tt> - Specifies the value must be less than the
  #   supplied value. The default error message for this option is _"must be
  #   less than %{count}"_.
  # * <tt>:less_than_or_equal_to</tt> - Specifies the value must be less
  #   than or equal to the supplied value. The default error message for
  #   this option is _"must be less than or equal to %{count}"_.
  # * <tt>:other_than</tt> - Specifies the value must not be equal to the
  #   supplied value. The default error message for this option is _"must be
  #   other than %{count}"_.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+ .
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # The validator requires at least one of the following checks to be supplied.
  # Each will accept a proc, value, or a symbol which corresponds to a method:
  #
  # * <tt>:greater_than</tt>
  # * <tt>:greater_than_or_equal_to</tt>
  # * <tt>:equal_to</tt>
  # * <tt>:less_than</tt>
  # * <tt>:less_than_or_equal_to</tt>
  # * <tt>:other_than</tt>
  #
  # For example:
  #
  #   class Person < ActiveRecord::Base
  #     validates_comparison_of :birth_date, less_than_or_equal_to: -> { Date.today }
  #     validates_comparison_of :preferred_name, other_than: :given_name, allow_nil: true
  #   end
  #
  # source://activemodel//lib/active_model/validations/comparison.rb#85
  def validates_comparison_of(*attr_names); end

  # Encapsulates the pattern of wanting to validate a password or email
  # address field with a confirmation.
  #
  #   Model:
  #     class Person < ActiveRecord::Base
  #       validates_confirmation_of :user_name, :password
  #       validates_confirmation_of :email_address,
  #                                 message: 'should match confirmation'
  #     end
  #
  #   View:
  #     <%= password_field "person", "password" %>
  #     <%= password_field "person", "password_confirmation" %>
  #
  # The added +password_confirmation+ attribute is virtual; it exists only
  # as an in-memory attribute for validating the password. To achieve this,
  # the validation adds accessors to the model for the confirmation
  # attribute.
  #
  # NOTE: This check is performed only if +password_confirmation+ is not
  # +nil+. To require confirmation, make sure to add a presence check for
  # the confirmation attribute:
  #
  #   validates_presence_of :password_confirmation, if: :password_changed?
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "doesn't match
  #   <tt>%{translated_attribute_name}</tt>").
  # * <tt>:case_sensitive</tt> - Looks for an exact match. Ignored by
  #   non-text columns (+true+ by default).
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/confirmation.rb#75
  def validates_confirmation_of(*attr_names); end

  # Validates that the value of the specified attribute is not in a
  # particular enumerable object.
  #
  #   class Person < ActiveRecord::Base
  #     validates_exclusion_of :username, in: %w( admin superuser ), message: "You don't belong here"
  #     validates_exclusion_of :age, in: 30..60, message: 'This site is only for under 30 and over 60'
  #     validates_exclusion_of :format, in: %w( mov avi ), message: "extension %{value} is not allowed"
  #     validates_exclusion_of :password, in: ->(person) { [person.username, person.first_name] },
  #                            message: 'should not be the same as your username or first name'
  #     validates_exclusion_of :karma, in: :reserved_karmas
  #   end
  #
  # Configuration options:
  # * <tt>:in</tt> - An enumerable object of items that the value shouldn't
  #   be part of. This can be supplied as a proc, lambda, or symbol which returns an
  #   enumerable. If the enumerable is a numerical, time, or datetime range the test
  #   is performed with <tt>Range#cover?</tt>, otherwise with <tt>include?</tt>. When
  #   using a proc or lambda the instance under validation is passed as an argument.
  # * <tt>:within</tt> - A synonym(or alias) for <tt>:in</tt>
  #   <tt>Range#cover?</tt>, otherwise with <tt>include?</tt>.
  # * <tt>:message</tt> - Specifies a custom error message (default is: "is
  #   reserved").
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/exclusion.rb#44
  def validates_exclusion_of(*attr_names); end

  # Validates whether the value of the specified attribute is of the correct
  # form, going by the regular expression provided. You can require that the
  # attribute matches the regular expression:
  #
  #   class Person < ActiveRecord::Base
  #     validates_format_of :email, with: /\A([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})\z/i, on: :create
  #   end
  #
  # Alternatively, you can require that the specified attribute does _not_
  # match the regular expression:
  #
  #   class Person < ActiveRecord::Base
  #     validates_format_of :email, without: /NOSPAM/
  #   end
  #
  # You can also provide a proc or lambda which will determine the regular
  # expression that will be used to validate the attribute.
  #
  #   class Person < ActiveRecord::Base
  #     # Admin can have number as a first letter in their screen name
  #     validates_format_of :screen_name,
  #                         with: ->(person) { person.admin? ? /\A[a-z0-9][a-z0-9_\-]*\z/i : /\A[a-z][a-z0-9_\-]*\z/i }
  #   end
  #
  # Note: use <tt>\A</tt> and <tt>\z</tt> to match the start and end of the
  # string, <tt>^</tt> and <tt>$</tt> match the start/end of a line.
  #
  # Due to frequent misuse of <tt>^</tt> and <tt>$</tt>, you need to pass
  # the <tt>multiline: true</tt> option in case you use any of these two
  # anchors in the provided regular expression. In most cases, you should be
  # using <tt>\A</tt> and <tt>\z</tt>.
  #
  # You must pass either <tt>:with</tt> or <tt>:without</tt> as an option.
  # In addition, both must be a regular expression or a proc or lambda, or
  # else an exception will be raised.
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "is invalid").
  # * <tt>:with</tt> - Regular expression that if the attribute matches will
  #   result in a successful validation. This can be provided as a proc or
  #   lambda returning regular expression which will be called at runtime.
  # * <tt>:without</tt> - Regular expression that if the attribute does not
  #   match will result in a successful validation. This can be provided as
  #   a proc or lambda returning regular expression which will be called at
  #   runtime.
  # * <tt>:multiline</tt> - Set to true if your regular expression contains
  #   anchors that match the beginning or end of lines as opposed to the
  #   beginning or end of the string. These anchors are <tt>^</tt> and <tt>$</tt>.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/format.rb#107
  def validates_format_of(*attr_names); end

  # Validates whether the value of the specified attribute is available in a
  # particular enumerable object.
  #
  #   class Person < ActiveRecord::Base
  #     validates_inclusion_of :role, in: %w( admin contributor )
  #     validates_inclusion_of :age, in: 0..99
  #     validates_inclusion_of :format, in: %w( jpg gif png ), message: "extension %{value} is not included in the list"
  #     validates_inclusion_of :states, in: ->(person) { STATES[person.country] }
  #     validates_inclusion_of :karma, in: :available_karmas
  #   end
  #
  # Configuration options:
  # * <tt>:in</tt> - An enumerable object of available items. This can be
  #   supplied as a proc, lambda, or symbol which returns an enumerable. If the
  #   enumerable is a numerical, time, or datetime range the test is performed
  #   with <tt>Range#cover?</tt>, otherwise with <tt>include?</tt>. When using
  #   a proc or lambda the instance under validation is passed as an argument.
  # * <tt>:within</tt> - A synonym(or alias) for <tt>:in</tt>
  # * <tt>:message</tt> - Specifies a custom error message (default is: "is
  #   not included in the list").
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/inclusion.rb#42
  def validates_inclusion_of(*attr_names); end

  # Validates that the specified attributes match the length restrictions
  # supplied. Only one constraint option can be used at a time apart from
  # +:minimum+ and +:maximum+ that can be combined together:
  #
  #   class Person < ActiveRecord::Base
  #     validates_length_of :first_name, maximum: 30
  #     validates_length_of :last_name, maximum: 30, message: "less than 30 if you don't mind"
  #     validates_length_of :fax, in: 7..32, allow_nil: true
  #     validates_length_of :phone, in: 7..32, allow_blank: true
  #     validates_length_of :user_name, within: 6..20, too_long: 'pick a shorter name', too_short: 'pick a longer name'
  #     validates_length_of :zip_code, minimum: 5, too_short: 'please enter at least 5 characters'
  #     validates_length_of :smurf_leader, is: 4, message: "papa is spelled with 4 characters... don't play me."
  #     validates_length_of :words_in_essay, minimum: 100, too_short: 'Your essay must be at least 100 words.'
  #
  #     private
  #       def words_in_essay
  #         essay.scan(/\w+/)
  #       end
  #   end
  #
  # Constraint options:
  #
  # * <tt>:minimum</tt> - The minimum size of the attribute.
  # * <tt>:maximum</tt> - The maximum size of the attribute. Allows +nil+ by
  #   default if not used with +:minimum+.
  # * <tt>:is</tt> - The exact size of the attribute.
  # * <tt>:within</tt> - A range specifying the minimum and maximum size of
  #   the attribute.
  # * <tt>:in</tt> - A synonym (or alias) for <tt>:within</tt>.
  #
  # Other options:
  #
  # * <tt>:allow_nil</tt> - Attribute may be +nil+; skip validation.
  # * <tt>:allow_blank</tt> - Attribute may be blank; skip validation.
  # * <tt>:too_long</tt> - The error message if the attribute goes over the
  #   maximum (default is: "is too long (maximum is %{count} characters)").
  # * <tt>:too_short</tt> - The error message if the attribute goes under the
  #   minimum (default is: "is too short (minimum is %{count} characters)").
  # * <tt>:wrong_length</tt> - The error message if using the <tt>:is</tt>
  #   method and the attribute is the wrong size (default is: "is the wrong
  #   length (should be %{count} characters)").
  # * <tt>:message</tt> - The error message to use for a <tt>:minimum</tt>,
  #   <tt>:maximum</tt>, or <tt>:is</tt> violation. An alias of the appropriate
  #   <tt>too_long</tt>/<tt>too_short</tt>/<tt>wrong_length</tt> message.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/length.rb#123
  def validates_length_of(*attr_names); end

  # Validates whether the value of the specified attribute is numeric by
  # trying to convert it to a float with +Kernel.Float+ (if
  # <tt>only_integer</tt> is +false+) or applying it to the regular
  # expression <tt>/\A[\+\-]?\d+\z/</tt> (if <tt>only_integer</tt> is set to
  # +true+). Precision of +Kernel.Float+ values are guaranteed up to 15
  # digits.
  #
  #   class Person < ActiveRecord::Base
  #     validates_numericality_of :value, on: :create
  #   end
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "is not a number").
  # * <tt>:only_integer</tt> - Specifies whether the value has to be an
  #   integer (default is +false+).
  # * <tt>:only_numeric</tt> - Specifies whether the value has to be an
  #   instance of Numeric (default is +false+). The default behavior is to
  #   attempt parsing the value if it is a String.
  # * <tt>:allow_nil</tt> - Skip validation if attribute is +nil+ (default is
  #   +false+). Notice that for Integer and Float columns empty strings are
  #   converted to +nil+.
  # * <tt>:greater_than</tt> - Specifies the value must be greater than the
  #   supplied value. The default error message for this option is _"must be
  #   greater than %{count}"_.
  # * <tt>:greater_than_or_equal_to</tt> - Specifies the value must be
  #   greater than or equal the supplied value. The default error message
  #   for this option is _"must be greater than or equal to %{count}"_.
  # * <tt>:equal_to</tt> - Specifies the value must be equal to the supplied
  #   value. The default error message for this option is _"must be equal to
  #   %{count}"_.
  # * <tt>:less_than</tt> - Specifies the value must be less than the
  #   supplied value. The default error message for this option is _"must be
  #   less than %{count}"_.
  # * <tt>:less_than_or_equal_to</tt> - Specifies the value must be less
  #   than or equal the supplied value. The default error message for this
  #   option is _"must be less than or equal to %{count}"_.
  # * <tt>:other_than</tt> - Specifies the value must be other than the
  #   supplied value. The default error message for this option is _"must be
  #   other than %{count}"_.
  # * <tt>:odd</tt> - Specifies the value must be an odd number. The default
  #   error message for this option is _"must be odd"_.
  # * <tt>:even</tt> - Specifies the value must be an even number. The
  #   default error message for this option is _"must be even"_.
  # * <tt>:in</tt> - Check that the value is within a range. The default
  #   error message for this option is _"must be in %{count}"_.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+ .
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # The following checks can also be supplied with a proc or a symbol which
  # corresponds to a method:
  #
  # * <tt>:greater_than</tt>
  # * <tt>:greater_than_or_equal_to</tt>
  # * <tt>:equal_to</tt>
  # * <tt>:less_than</tt>
  # * <tt>:less_than_or_equal_to</tt>
  # * <tt>:only_integer</tt>
  # * <tt>:other_than</tt>
  #
  # For example:
  #
  #   class Person < ActiveRecord::Base
  #     validates_numericality_of :width, less_than: ->(person) { person.height }
  #     validates_numericality_of :width, greater_than: :minimum_weight
  #   end
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#217
  def validates_numericality_of(*attr_names); end

  # Validates that the specified attributes are not blank (as defined by
  # Object#blank?).
  #
  #   class Person < ActiveRecord::Base
  #     validates_presence_of :first_name
  #   end
  #
  # The first_name attribute must be in the object and it cannot be blank.
  #
  # If you want to validate the presence of a boolean field (where the real
  # values are +true+ and +false+), you will want to use
  # <tt>validates_inclusion_of :field_name, in: [true, false]</tt>.
  #
  # This is due to the way Object#blank? handles boolean values:
  # <tt>false.blank? # => true</tt>.
  #
  # Configuration options:
  # * <tt>:message</tt> - A custom error message (default is: "can't be blank").
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, +:allow_nil+, +:allow_blank+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/presence.rb#34
  def validates_presence_of(*attr_names); end

  # Validates that the specified attributes match the length restrictions
  # supplied. Only one constraint option can be used at a time apart from
  # +:minimum+ and +:maximum+ that can be combined together:
  #
  #   class Person < ActiveRecord::Base
  #     validates_length_of :first_name, maximum: 30
  #     validates_length_of :last_name, maximum: 30, message: "less than 30 if you don't mind"
  #     validates_length_of :fax, in: 7..32, allow_nil: true
  #     validates_length_of :phone, in: 7..32, allow_blank: true
  #     validates_length_of :user_name, within: 6..20, too_long: 'pick a shorter name', too_short: 'pick a longer name'
  #     validates_length_of :zip_code, minimum: 5, too_short: 'please enter at least 5 characters'
  #     validates_length_of :smurf_leader, is: 4, message: "papa is spelled with 4 characters... don't play me."
  #     validates_length_of :words_in_essay, minimum: 100, too_short: 'Your essay must be at least 100 words.'
  #
  #     private
  #       def words_in_essay
  #         essay.scan(/\w+/)
  #       end
  #   end
  #
  # Constraint options:
  #
  # * <tt>:minimum</tt> - The minimum size of the attribute.
  # * <tt>:maximum</tt> - The maximum size of the attribute. Allows +nil+ by
  #   default if not used with +:minimum+.
  # * <tt>:is</tt> - The exact size of the attribute.
  # * <tt>:within</tt> - A range specifying the minimum and maximum size of
  #   the attribute.
  # * <tt>:in</tt> - A synonym (or alias) for <tt>:within</tt>.
  #
  # Other options:
  #
  # * <tt>:allow_nil</tt> - Attribute may be +nil+; skip validation.
  # * <tt>:allow_blank</tt> - Attribute may be blank; skip validation.
  # * <tt>:too_long</tt> - The error message if the attribute goes over the
  #   maximum (default is: "is too long (maximum is %{count} characters)").
  # * <tt>:too_short</tt> - The error message if the attribute goes under the
  #   minimum (default is: "is too short (minimum is %{count} characters)").
  # * <tt>:wrong_length</tt> - The error message if using the <tt>:is</tt>
  #   method and the attribute is the wrong size (default is: "is the wrong
  #   length (should be %{count} characters)").
  # * <tt>:message</tt> - The error message to use for a <tt>:minimum</tt>,
  #   <tt>:maximum</tt>, or <tt>:is</tt> violation. An alias of the appropriate
  #   <tt>too_long</tt>/<tt>too_short</tt>/<tt>wrong_length</tt> message.
  #
  # There is also a list of default options supported by every validator:
  # +:if+, +:unless+, +:on+, and +:strict+.
  # See ActiveModel::Validations::ClassMethods#validates for more information.
  #
  # source://activemodel//lib/active_model/validations/length.rb#123
  def validates_size_of(*attr_names); end

  private

  # source://activemodel//lib/active_model/validations/helper_methods.rb#7
  def _merge_attributes(attr_names); end
end

# source://activemodel//lib/active_model/validations/inclusion.rb#7
class ActiveModel::Validations::InclusionValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::ResolveValue
  include ::ActiveModel::Validations::Clusivity

  # source://activemodel//lib/active_model/validations/inclusion.rb#10
  def validate_each(record, attribute, value); end
end

# source://activemodel//lib/active_model/validations/length.rb#7
class ActiveModel::Validations::LengthValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::ResolveValue

  # @return [LengthValidator] a new instance of LengthValidator
  #
  # source://activemodel//lib/active_model/validations/length.rb#15
  def initialize(options); end

  # source://activemodel//lib/active_model/validations/length.rb#29
  def check_validity!; end

  # source://activemodel//lib/active_model/validations/length.rb#47
  def validate_each(record, attribute, value); end

  private

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/length.rb#69
  def skip_nil_check?(key); end
end

# source://activemodel//lib/active_model/validations/length.rb#11
ActiveModel::Validations::LengthValidator::CHECKS = T.let(T.unsafe(nil), Hash)

# source://activemodel//lib/active_model/validations/length.rb#10
ActiveModel::Validations::LengthValidator::MESSAGES = T.let(T.unsafe(nil), Hash)

# source://activemodel//lib/active_model/validations/length.rb#13
ActiveModel::Validations::LengthValidator::RESERVED_OPTIONS = T.let(T.unsafe(nil), Array)

# source://activemodel//lib/active_model/validations/numericality.rb#9
class ActiveModel::Validations::NumericalityValidator < ::ActiveModel::EachValidator
  include ::ActiveModel::Validations::Comparability
  include ::ActiveModel::Validations::ResolveValue

  # source://activemodel//lib/active_model/validations/numericality.rb#22
  def check_validity!; end

  # source://activemodel//lib/active_model/validations/numericality.rb#36
  def validate_each(record, attr_name, value, precision: T.unsafe(nil), scale: T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#118
  def allow_only_integer?(record); end

  # source://activemodel//lib/active_model/validations/numericality.rb#112
  def filtered_options(value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#108
  def is_hexadecimal_literal?(raw_value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#104
  def is_integer?(raw_value); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#94
  def is_number?(raw_value, precision, scale); end

  # source://activemodel//lib/active_model/validations/numericality.rb#68
  def option_as_number(record, option_value, precision, scale); end

  # source://activemodel//lib/active_model/validations/numericality.rb#72
  def parse_as_number(raw_value, precision, scale); end

  # source://activemodel//lib/active_model/validations/numericality.rb#86
  def parse_float(raw_value, precision, scale); end

  # source://activemodel//lib/active_model/validations/numericality.rb#122
  def prepare_value_for_validation(value, record, attr_name); end

  # @return [Boolean]
  #
  # source://activemodel//lib/active_model/validations/numericality.rb#143
  def record_attribute_changed_in_place?(record, attr_name); end

  # source://activemodel//lib/active_model/validations/numericality.rb#90
  def round(raw_value, scale); end
end

# source://activemodel//lib/active_model/validations/numericality.rb#20
ActiveModel::Validations::NumericalityValidator::HEXADECIMAL_REGEX = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/validations/numericality.rb#18
ActiveModel::Validations::NumericalityValidator::INTEGER_REGEX = T.let(T.unsafe(nil), Regexp)

# source://activemodel//lib/active_model/validations/numericality.rb#14
ActiveModel::Validations::NumericalityValidator::NUMBER_CHECKS = T.let(T.unsafe(nil), Hash)

# source://activemodel//lib/active_model/validations/numericality.rb#13
ActiveModel::Validations::NumericalityValidator::RANGE_CHECKS = T.let(T.unsafe(nil), Hash)

# source://activemodel//lib/active_model/validations/numericality.rb#16
ActiveModel::Validations::NumericalityValidator::RESERVED_OPTIONS = T.let(T.unsafe(nil), Array)

# source://activemodel//lib/active_model/validations/presence.rb#5
class ActiveModel::Validations::PresenceValidator < ::ActiveModel::EachValidator
  # source://activemodel//lib/active_model/validations/presence.rb#6
  def validate_each(record, attr_name, value); end
end

# source://activemodel//lib/active_model/validations/resolve_value.rb#5
module ActiveModel::Validations::ResolveValue
  # source://activemodel//lib/active_model/validations/resolve_value.rb#6
  def resolve_value(record, value); end
end

# source://activemodel//lib/active_model/validations/with.rb#7
class ActiveModel::Validations::WithValidator < ::ActiveModel::EachValidator
  # source://activemodel//lib/active_model/validations/with.rb#8
  def validate_each(record, attr, val); end
end

# = Active \Model \Validator
#
# A simple base class that can be used along with
# ActiveModel::Validations::ClassMethods.validates_with
#
#   class Person
#     include ActiveModel::Validations
#     validates_with MyValidator
#   end
#
#   class MyValidator < ActiveModel::Validator
#     def validate(record)
#       if some_complex_logic
#         record.errors.add(:base, "This record is invalid")
#       end
#     end
#
#     private
#       def some_complex_logic
#         # ...
#       end
#   end
#
# Any class that inherits from \ActiveModel::Validator must implement a method
# called +validate+ which accepts a +record+.
#
#   class Person
#     include ActiveModel::Validations
#     validates_with MyValidator
#   end
#
#   class MyValidator < ActiveModel::Validator
#     def validate(record)
#       record # => The person instance being validated
#       options # => Any non-standard options passed to validates_with
#     end
#   end
#
# To cause a validation error, you must add to the +record+'s errors directly
# from within the validators message.
#
#   class MyValidator < ActiveModel::Validator
#     def validate(record)
#       record.errors.add :base, "This is some custom error message"
#       record.errors.add :first_name, "This is some complex validation"
#       # etc...
#     end
#   end
#
# To add behavior to the initialize method, use the following signature:
#
#   class MyValidator < ActiveModel::Validator
#     def initialize(options)
#       super
#       @my_custom_field = options[:field_name] || :first_name
#     end
#   end
#
# Note that the validator is initialized only once for the whole application
# life cycle, and not on each validation run.
#
# The easiest way to add custom validators for validating individual attributes
# is with the convenient ActiveModel::EachValidator class.
#
#   class TitleValidator < ActiveModel::EachValidator
#     def validate_each(record, attribute, value)
#       record.errors.add attribute, 'must be Mr., Mrs., or Dr.' unless %w(Mr. Mrs. Dr.).include?(value)
#     end
#   end
#
# This can now be used in combination with the +validates+ method.
# See ActiveModel::Validations::ClassMethods#validates for more on this.
#
#   class Person
#     include ActiveModel::Validations
#     attr_accessor :title
#
#     validates :title, presence: true, title: true
#   end
#
# It can be useful to access the class that is using that validator when there are prerequisites such
# as an +attr_accessor+ being present. This class is accessible via <tt>options[:class]</tt> in the constructor.
# To set up your validator override the constructor.
#
#   class MyValidator < ActiveModel::Validator
#     def initialize(options={})
#       super
#       options[:class].attr_accessor :custom_attribute
#     end
#   end
#
# source://activemodel//lib/active_model/validator.rb#96
class ActiveModel::Validator
  # Accepts options that will be made available through the +options+ reader.
  #
  # @return [Validator] a new instance of Validator
  #
  # source://activemodel//lib/active_model/validator.rb#108
  def initialize(options = T.unsafe(nil)); end

  # Returns the kind for this validator.
  #
  #   PresenceValidator.new(attributes: [:username]).kind # => :presence
  #   AcceptanceValidator.new(attributes: [:terms]).kind  # => :acceptance
  #
  # source://activemodel//lib/active_model/validator.rb#116
  def kind; end

  # Returns the value of attribute options.
  #
  # source://activemodel//lib/active_model/validator.rb#97
  def options; end

  # Override this method in subclasses with validation logic, adding errors
  # to the records +errors+ array where necessary.
  #
  # @raise [NotImplementedError]
  #
  # source://activemodel//lib/active_model/validator.rb#122
  def validate(record); end

  class << self
    # Returns the kind of the validator.
    #
    #   PresenceValidator.kind   # => :presence
    #   AcceptanceValidator.kind # => :acceptance
    #
    # source://activemodel//lib/active_model/validator.rb#103
    def kind; end
  end
end
