# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `benchmark` gem.
# Please instead update this file by running `bin/tapioca gem benchmark`.


# The Benchmark module provides methods to measure and report the time
# used to execute Ruby code.
#
# * Measure the time to construct the string given by the expression
#   <code>"a"*1_000_000_000</code>:
#
#       require 'benchmark'
#
#       puts Benchmark.measure { "a"*1_000_000_000 }
#
#   On my machine (OSX 10.8.3 on i5 1.7 GHz) this generates:
#
#       0.350000   0.400000   0.750000 (  0.835234)
#
#   This report shows the user CPU time, system CPU time, the sum of
#   the user and system CPU times, and the elapsed real time. The unit
#   of time is seconds.
#
# * Do some experiments sequentially using the #bm method:
#
#       require 'benchmark'
#
#       n = 5000000
#       Benchmark.bm do |x|
#         x.report { for i in 1..n; a = "1"; end }
#         x.report { n.times do   ; a = "1"; end }
#         x.report { 1.upto(n) do ; a = "1"; end }
#       end
#
#   The result:
#
#              user     system      total        real
#          1.010000   0.000000   1.010000 (  1.014479)
#          1.000000   0.000000   1.000000 (  0.998261)
#          0.980000   0.000000   0.980000 (  0.981335)
#
# * Continuing the previous example, put a label in each report:
#
#       require 'benchmark'
#
#       n = 5000000
#       Benchmark.bm(7) do |x|
#         x.report("for:")   { for i in 1..n; a = "1"; end }
#         x.report("times:") { n.times do   ; a = "1"; end }
#         x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
#       end
#
# The result:
#
#                     user     system      total        real
#       for:      1.010000   0.000000   1.010000 (  1.015688)
#       times:    1.000000   0.000000   1.000000 (  1.003611)
#       upto:     1.030000   0.000000   1.030000 (  1.028098)
#
# * The times for some benchmarks depend on the order in which items
#   are run.  These differences are due to the cost of memory
#   allocation and garbage collection. To avoid these discrepancies,
#   the #bmbm method is provided.  For example, to compare ways to
#   sort an array of floats:
#
#       require 'benchmark'
#
#       array = (1..1000000).map { rand }
#
#       Benchmark.bmbm do |x|
#         x.report("sort!") { array.dup.sort! }
#         x.report("sort")  { array.dup.sort  }
#       end
#
#   The result:
#
#        Rehearsal -----------------------------------------
#        sort!   1.490000   0.010000   1.500000 (  1.490520)
#        sort    1.460000   0.000000   1.460000 (  1.463025)
#        -------------------------------- total: 2.960000sec
#
#                    user     system      total        real
#        sort!   1.460000   0.000000   1.460000 (  1.460465)
#        sort    1.450000   0.010000   1.460000 (  1.448327)
#
# * Report statistics of sequential experiments with unique labels,
#   using the #benchmark method:
#
#       require 'benchmark'
#       include Benchmark         # we need the CAPTION and FORMAT constants
#
#       n = 5000000
#       Benchmark.benchmark(CAPTION, 7, FORMAT, ">total:", ">avg:") do |x|
#         tf = x.report("for:")   { for i in 1..n; a = "1"; end }
#         tt = x.report("times:") { n.times do   ; a = "1"; end }
#         tu = x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
#         [tf+tt+tu, (tf+tt+tu)/3]
#       end
#
#   The result:
#
#                     user     system      total        real
#        for:      0.950000   0.000000   0.950000 (  0.952039)
#        times:    0.980000   0.000000   0.980000 (  0.984938)
#        upto:     0.950000   0.000000   0.950000 (  0.946787)
#        >total:   2.880000   0.000000   2.880000 (  2.883764)
#        >avg:     0.960000   0.000000   0.960000 (  0.961255)
#
# source://benchmark//lib/benchmark.rb#122
module Benchmark
  private

  # Invokes the block with a Benchmark::Report object, which
  # may be used to collect and report on the results of individual
  # benchmark tests. Reserves +label_width+ leading spaces for
  # labels on each line. Prints +caption+ at the top of the
  # report, and uses +format+ to format each line.
  # (Note: +caption+ must contain a terminating newline character,
  # see the default Benchmark::Tms::CAPTION for an example.)
  #
  # Returns an array of Benchmark::Tms objects.
  #
  # If the block returns an array of
  # Benchmark::Tms objects, these will be used to format
  # additional lines of output. If +labels+ parameter are
  # given, these are used to label these extra lines.
  #
  # _Note_: Other methods provide a simpler interface to this one, and are
  # suitable for nearly all benchmarking requirements.  See the examples in
  # Benchmark, and the #bm and #bmbm methods.
  #
  # Example:
  #
  #     require 'benchmark'
  #     include Benchmark          # we need the CAPTION and FORMAT constants
  #
  #     n = 5000000
  #     Benchmark.benchmark(CAPTION, 7, FORMAT, ">total:", ">avg:") do |x|
  #       tf = x.report("for:")   { for i in 1..n; a = "1"; end }
  #       tt = x.report("times:") { n.times do   ; a = "1"; end }
  #       tu = x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
  #       [tf+tt+tu, (tf+tt+tu)/3]
  #     end
  #
  # Generates:
  #
  #                     user     system      total        real
  #       for:      0.970000   0.000000   0.970000 (  0.970493)
  #       times:    0.990000   0.000000   0.990000 (  0.989542)
  #       upto:     0.970000   0.000000   0.970000 (  0.972854)
  #       >total:   2.930000   0.000000   2.930000 (  2.932889)
  #       >avg:     0.976667   0.000000   0.976667 (  0.977630)
  #
  # source://benchmark//lib/benchmark.rb#170
  def benchmark(caption = T.unsafe(nil), label_width = T.unsafe(nil), format = T.unsafe(nil), *labels); end

  # A simple interface to the #benchmark method, #bm generates sequential
  # reports with labels. +label_width+ and +labels+ parameters have the same
  # meaning as for #benchmark.
  #
  #     require 'benchmark'
  #
  #     n = 5000000
  #     Benchmark.bm(7) do |x|
  #       x.report("for:")   { for i in 1..n; a = "1"; end }
  #       x.report("times:") { n.times do   ; a = "1"; end }
  #       x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
  #     end
  #
  # Generates:
  #
  #                     user     system      total        real
  #       for:      0.960000   0.000000   0.960000 (  0.957966)
  #       times:    0.960000   0.000000   0.960000 (  0.960423)
  #       upto:     0.950000   0.000000   0.950000 (  0.954864)
  #
  # source://benchmark//lib/benchmark.rb#215
  def bm(label_width = T.unsafe(nil), *labels, &blk); end

  # Sometimes benchmark results are skewed because code executed
  # earlier encounters different garbage collection overheads than
  # that run later. #bmbm attempts to minimize this effect by running
  # the tests twice, the first time as a rehearsal in order to get the
  # runtime environment stable, the second time for
  # real. GC.start is executed before the start of each of
  # the real timings; the cost of this is not included in the
  # timings. In reality, though, there's only so much that #bmbm can
  # do, and the results are not guaranteed to be isolated from garbage
  # collection and other effects.
  #
  # Because #bmbm takes two passes through the tests, it can
  # calculate the required label width.
  #
  #       require 'benchmark'
  #
  #       array = (1..1000000).map { rand }
  #
  #       Benchmark.bmbm do |x|
  #         x.report("sort!") { array.dup.sort! }
  #         x.report("sort")  { array.dup.sort  }
  #       end
  #
  # Generates:
  #
  #        Rehearsal -----------------------------------------
  #        sort!   1.440000   0.010000   1.450000 (  1.446833)
  #        sort    1.440000   0.000000   1.440000 (  1.448257)
  #        -------------------------------- total: 2.890000sec
  #
  #                    user     system      total        real
  #        sort!   1.460000   0.000000   1.460000 (  1.458065)
  #        sort    1.450000   0.000000   1.450000 (  1.455963)
  #
  # #bmbm yields a Benchmark::Job object and returns an array of
  # Benchmark::Tms objects.
  #
  # source://benchmark//lib/benchmark.rb#257
  def bmbm(width = T.unsafe(nil)); end

  # Returns the time used to execute the given block as a
  # Benchmark::Tms object. Takes +label+ option.
  #
  #       require 'benchmark'
  #
  #       n = 1000000
  #
  #       time = Benchmark.measure do
  #         n.times { a = "1" }
  #       end
  #       puts time
  #
  # Generates:
  #
  #        0.220000   0.000000   0.220000 (  0.227313)
  #
  # source://benchmark//lib/benchmark.rb#302
  def measure(label = T.unsafe(nil)); end

  # Returns the elapsed real time used to execute the given block.
  # The unit of time is seconds.
  #
  #       Benchmark.realtime { "a" * 1_000_000_000 }
  #       #=> 0.5098029999935534
  #
  # source://benchmark//lib/benchmark.rb#321
  def realtime; end

  class << self
    # Invokes the block with a Benchmark::Report object, which
    # may be used to collect and report on the results of individual
    # benchmark tests. Reserves +label_width+ leading spaces for
    # labels on each line. Prints +caption+ at the top of the
    # report, and uses +format+ to format each line.
    # (Note: +caption+ must contain a terminating newline character,
    # see the default Benchmark::Tms::CAPTION for an example.)
    #
    # Returns an array of Benchmark::Tms objects.
    #
    # If the block returns an array of
    # Benchmark::Tms objects, these will be used to format
    # additional lines of output. If +labels+ parameter are
    # given, these are used to label these extra lines.
    #
    # _Note_: Other methods provide a simpler interface to this one, and are
    # suitable for nearly all benchmarking requirements.  See the examples in
    # Benchmark, and the #bm and #bmbm methods.
    #
    # Example:
    #
    #     require 'benchmark'
    #     include Benchmark          # we need the CAPTION and FORMAT constants
    #
    #     n = 5000000
    #     Benchmark.benchmark(CAPTION, 7, FORMAT, ">total:", ">avg:") do |x|
    #       tf = x.report("for:")   { for i in 1..n; a = "1"; end }
    #       tt = x.report("times:") { n.times do   ; a = "1"; end }
    #       tu = x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
    #       [tf+tt+tu, (tf+tt+tu)/3]
    #     end
    #
    # Generates:
    #
    #                     user     system      total        real
    #       for:      0.970000   0.000000   0.970000 (  0.970493)
    #       times:    0.990000   0.000000   0.990000 (  0.989542)
    #       upto:     0.970000   0.000000   0.970000 (  0.972854)
    #       >total:   2.930000   0.000000   2.930000 (  2.932889)
    #       >avg:     0.976667   0.000000   0.976667 (  0.977630)
    #
    # source://benchmark//lib/benchmark.rb#170
    def benchmark(caption = T.unsafe(nil), label_width = T.unsafe(nil), format = T.unsafe(nil), *labels); end

    # A simple interface to the #benchmark method, #bm generates sequential
    # reports with labels. +label_width+ and +labels+ parameters have the same
    # meaning as for #benchmark.
    #
    #     require 'benchmark'
    #
    #     n = 5000000
    #     Benchmark.bm(7) do |x|
    #       x.report("for:")   { for i in 1..n; a = "1"; end }
    #       x.report("times:") { n.times do   ; a = "1"; end }
    #       x.report("upto:")  { 1.upto(n) do ; a = "1"; end }
    #     end
    #
    # Generates:
    #
    #                     user     system      total        real
    #       for:      0.960000   0.000000   0.960000 (  0.957966)
    #       times:    0.960000   0.000000   0.960000 (  0.960423)
    #       upto:     0.950000   0.000000   0.950000 (  0.954864)
    #
    # source://benchmark//lib/benchmark.rb#215
    def bm(label_width = T.unsafe(nil), *labels, &blk); end

    # Sometimes benchmark results are skewed because code executed
    # earlier encounters different garbage collection overheads than
    # that run later. #bmbm attempts to minimize this effect by running
    # the tests twice, the first time as a rehearsal in order to get the
    # runtime environment stable, the second time for
    # real. GC.start is executed before the start of each of
    # the real timings; the cost of this is not included in the
    # timings. In reality, though, there's only so much that #bmbm can
    # do, and the results are not guaranteed to be isolated from garbage
    # collection and other effects.
    #
    # Because #bmbm takes two passes through the tests, it can
    # calculate the required label width.
    #
    #       require 'benchmark'
    #
    #       array = (1..1000000).map { rand }
    #
    #       Benchmark.bmbm do |x|
    #         x.report("sort!") { array.dup.sort! }
    #         x.report("sort")  { array.dup.sort  }
    #       end
    #
    # Generates:
    #
    #        Rehearsal -----------------------------------------
    #        sort!   1.440000   0.010000   1.450000 (  1.446833)
    #        sort    1.440000   0.000000   1.440000 (  1.448257)
    #        -------------------------------- total: 2.890000sec
    #
    #                    user     system      total        real
    #        sort!   1.460000   0.000000   1.460000 (  1.458065)
    #        sort    1.450000   0.000000   1.450000 (  1.455963)
    #
    # #bmbm yields a Benchmark::Job object and returns an array of
    # Benchmark::Tms objects.
    #
    # source://benchmark//lib/benchmark.rb#257
    def bmbm(width = T.unsafe(nil)); end

    # Returns the time used to execute the given block as a
    # Benchmark::Tms object. Takes +label+ option.
    #
    #       require 'benchmark'
    #
    #       n = 1000000
    #
    #       time = Benchmark.measure do
    #         n.times { a = "1" }
    #       end
    #       puts time
    #
    # Generates:
    #
    #        0.220000   0.000000   0.220000 (  0.227313)
    #
    # source://benchmark//lib/benchmark.rb#302
    def measure(label = T.unsafe(nil)); end

    # Returns the elapsed real time used to execute the given block.
    # The unit of time is seconds.
    #
    #       Benchmark.realtime { "a" * 1_000_000_000 }
    #       #=> 0.5098029999935534
    #
    # source://benchmark//lib/benchmark.rb#321
    def realtime; end
  end
end

# A Job is a sequence of labelled blocks to be processed by the
# Benchmark.bmbm method.  It is of little direct interest to the user.
#
# source://benchmark//lib/benchmark.rb#333
class Benchmark::Job
  # Returns an initialized Job instance.
  # Usually, one doesn't call this method directly, as new
  # Job objects are created by the #bmbm method.
  # +width+ is a initial value for the label offset used in formatting;
  # the #bmbm method passes its +width+ argument to this constructor.
  #
  # @return [Job] a new instance of Job
  #
  # source://benchmark//lib/benchmark.rb#341
  def initialize(width); end

  # Registers the given label and block pair in the job list.
  #
  # @raise [ArgumentError]
  #
  # source://benchmark//lib/benchmark.rb#349
  def item(label = T.unsafe(nil), &blk); end

  # An array of 2-element arrays, consisting of label and block pairs.
  #
  # source://benchmark//lib/benchmark.rb#361
  def list; end

  # Registers the given label and block pair in the job list.
  #
  # @raise [ArgumentError]
  #
  # source://benchmark//lib/benchmark.rb#349
  def report(label = T.unsafe(nil), &blk); end

  # Length of the widest label in the #list.
  #
  # source://benchmark//lib/benchmark.rb#364
  def width; end
end

# This class is used by the Benchmark.benchmark and Benchmark.bm methods.
# It is of little direct interest to the user.
#
# source://benchmark//lib/benchmark.rb#371
class Benchmark::Report
  # Returns an initialized Report instance.
  # Usually, one doesn't call this method directly, as new
  # Report objects are created by the #benchmark and #bm methods.
  # +width+ and +format+ are the label offset and
  # format string used by Tms#format.
  #
  # @return [Report] a new instance of Report
  #
  # source://benchmark//lib/benchmark.rb#379
  def initialize(width = T.unsafe(nil), format = T.unsafe(nil)); end

  # An array of Benchmark::Tms objects representing each item.
  #
  # source://benchmark//lib/benchmark.rb#398
  def format; end

  # Prints the +label+ and measured time for the block,
  # formatted by +format+. See Tms#format for the
  # formatting rules.
  #
  # source://benchmark//lib/benchmark.rb#388
  def item(label = T.unsafe(nil), *format, &blk); end

  # An array of Benchmark::Tms objects representing each item.
  #
  # source://benchmark//lib/benchmark.rb#398
  def list; end

  # Prints the +label+ and measured time for the block,
  # formatted by +format+. See Tms#format for the
  # formatting rules.
  #
  # source://benchmark//lib/benchmark.rb#388
  def report(label = T.unsafe(nil), *format, &blk); end

  # An array of Benchmark::Tms objects representing each item.
  #
  # source://benchmark//lib/benchmark.rb#398
  def width; end
end

# A data object, representing the times associated with a benchmark
# measurement.
#
# source://benchmark//lib/benchmark.rb#407
class Benchmark::Tms
  # Returns an initialized Tms object which has
  # +utime+ as the user CPU time, +stime+ as the system CPU time,
  # +cutime+ as the children's user CPU time, +cstime+ as the children's
  # system CPU time, +real+ as the elapsed real time and +label+ as the label.
  #
  # @return [Tms] a new instance of Tms
  #
  # source://benchmark//lib/benchmark.rb#442
  def initialize(utime = T.unsafe(nil), stime = T.unsafe(nil), cutime = T.unsafe(nil), cstime = T.unsafe(nil), real = T.unsafe(nil), label = T.unsafe(nil)); end

  # Returns a new Tms object obtained by memberwise multiplication
  # of the individual times for this Tms object by +x+.
  #
  # source://benchmark//lib/benchmark.rb#490
  def *(x); end

  # Returns a new Tms object obtained by memberwise summation
  # of the individual times for this Tms object with those of the +other+
  # Tms object.
  # This method and #/() are useful for taking statistics.
  #
  # source://benchmark//lib/benchmark.rb#477
  def +(other); end

  # Returns a new Tms object obtained by memberwise subtraction
  # of the individual times for the +other+ Tms object from those of this
  # Tms object.
  #
  # source://benchmark//lib/benchmark.rb#484
  def -(other); end

  # Returns a new Tms object obtained by memberwise division
  # of the individual times for this Tms object by +x+.
  # This method and #+() are useful for taking statistics.
  #
  # source://benchmark//lib/benchmark.rb#497
  def /(x); end

  # Returns a new Tms object whose times are the sum of the times for this
  # Tms object, plus the time required to execute the code block (+blk+).
  #
  # source://benchmark//lib/benchmark.rb#451
  def add(&blk); end

  # An in-place version of #add.
  # Changes the times of this Tms object by making it the sum of the times
  # for this Tms object, plus the time required to execute
  # the code block (+blk+).
  #
  # source://benchmark//lib/benchmark.rb#461
  def add!(&blk); end

  # System CPU time of children
  #
  # source://benchmark//lib/benchmark.rb#425
  def cstime; end

  # User CPU time of children
  #
  # source://benchmark//lib/benchmark.rb#422
  def cutime; end

  # Returns the contents of this Tms object as
  # a formatted string, according to a +format+ string
  # like that passed to Kernel.format. In addition, #format
  # accepts the following extensions:
  #
  # <tt>%u</tt>::     Replaced by the user CPU time, as reported by Tms#utime.
  # <tt>%y</tt>::     Replaced by the system CPU time, as reported by #stime (Mnemonic: y of "s*y*stem")
  # <tt>%U</tt>::     Replaced by the children's user CPU time, as reported by Tms#cutime
  # <tt>%Y</tt>::     Replaced by the children's system CPU time, as reported by Tms#cstime
  # <tt>%t</tt>::     Replaced by the total CPU time, as reported by Tms#total
  # <tt>%r</tt>::     Replaced by the elapsed real time, as reported by Tms#real
  # <tt>%n</tt>::     Replaced by the label string, as reported by Tms#label (Mnemonic: n of "*n*ame")
  #
  # If +format+ is not given, FORMAT is used as default value, detailing the
  # user, system and real elapsed time.
  #
  # source://benchmark//lib/benchmark.rb#516
  def format(format = T.unsafe(nil), *args); end

  # Label
  #
  # source://benchmark//lib/benchmark.rb#434
  def label; end

  # Elapsed real time
  #
  # source://benchmark//lib/benchmark.rb#428
  def real; end

  # System CPU time
  #
  # source://benchmark//lib/benchmark.rb#419
  def stime; end

  # Returns a new 6-element array, consisting of the
  # label, user CPU time, system CPU time, children's
  # user CPU time, children's system CPU time and elapsed
  # real time.
  #
  # source://benchmark//lib/benchmark.rb#541
  def to_a; end

  # Returns a hash containing the same data as `to_a`.
  #
  # source://benchmark//lib/benchmark.rb#548
  def to_h; end

  # Same as #format.
  #
  # source://benchmark//lib/benchmark.rb#531
  def to_s; end

  # Total time, that is +utime+ + +stime+ + +cutime+ + +cstime+
  #
  # source://benchmark//lib/benchmark.rb#431
  def total; end

  # User CPU time
  #
  # source://benchmark//lib/benchmark.rb#416
  def utime; end

  protected

  # Returns a new Tms object obtained by memberwise operation +op+
  # of the individual times for this Tms object with those of the other
  # Tms object (+x+).
  #
  # +op+ can be a mathematical operation such as <tt>+</tt>, <tt>-</tt>,
  # <tt>*</tt>, <tt>/</tt>
  #
  # source://benchmark//lib/benchmark.rb#569
  def memberwise(op, x); end
end

# source://benchmark//lib/benchmark.rb#124
Benchmark::VERSION = T.let(T.unsafe(nil), String)
