# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `drb` gem.
# Please instead update this file by running `bin/tapioca gem drb`.


# for ruby-1.8.0
#
# source://drb//lib/drb/eq.rb#2
module DRb
  private

  # Get the configuration of the current server.
  #
  # If there is no current server, this returns the default configuration.
  # See #current_server and DRbServer::make_config.
  #
  # source://drb//lib/drb/drb.rb#1832
  def config; end

  # Get the 'current' server.
  #
  # In the context of execution taking place within the main
  # thread of a dRuby server (typically, as a result of a remote
  # call on the server or one of its objects), the current
  # server is that server.  Otherwise, the current server is
  # the primary server.
  #
  # If the above rule fails to find a server, a DRbServerNotFound
  # error is raised.
  #
  # @raise [DRbServerNotFound]
  #
  # source://drb//lib/drb/drb.rb#1789
  def current_server; end

  # Retrieves the server with the given +uri+.
  #
  # See also regist_server and remove_server.
  #
  # source://drb//lib/drb/drb.rb#1934
  def fetch_server(uri); end

  # Get the front object of the current server.
  #
  # This raises a DRbServerNotFound error if there is no current server.
  # See #current_server.
  #
  # source://drb//lib/drb/drb.rb#1843
  def front; end

  # Is +uri+ the URI for the current local server?
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1822
  def here?(uri); end

  # Set the default ACL to +acl+.
  #
  # See DRb::DRbServer.default_acl.
  #
  # source://drb//lib/drb/drb.rb#1888
  def install_acl(acl); end

  # Set the default id conversion object.
  #
  # This is expected to be an instance such as DRb::DRbIdConv that responds to
  # #to_id and #to_obj that can convert objects to and from DRb references.
  #
  # See DRbServer#default_id_conv.
  #
  # source://drb//lib/drb/drb.rb#1880
  def install_id_conv(idconv); end

  # source://drb//lib/drb/drb.rb#1894
  def mutex; end

  # The primary local dRuby server.
  #
  # This is the server created by the #start_service call.
  #
  # source://drb//lib/drb/drb.rb#1776
  def primary_server; end

  # The primary local dRuby server.
  #
  # This is the server created by the #start_service call.
  #
  # source://drb//lib/drb/drb.rb#1776
  def primary_server=(_arg0); end

  # Registers +server+ with DRb.
  #
  # This is called when a new DRb::DRbServer is created.
  #
  # If there is no primary server then +server+ becomes the primary server.
  #
  # Example:
  #
  #  require 'drb'
  #
  #  s = DRb::DRbServer.new # automatically calls regist_server
  #  DRb.fetch_server s.uri #=> #<DRb::DRbServer:0x...>
  #
  # source://drb//lib/drb/drb.rb#1912
  def regist_server(server); end

  # Removes +server+ from the list of registered servers.
  #
  # source://drb//lib/drb/drb.rb#1921
  def remove_server(server); end

  # Start a dRuby server locally.
  #
  # The new dRuby server will become the primary server, even
  # if another server is currently the primary server.
  #
  # +uri+ is the URI for the server to bind to.  If nil,
  # the server will bind to random port on the default local host
  # name and use the default dRuby protocol.
  #
  # +front+ is the server's front object.  This may be nil.
  #
  # +config+ is the configuration for the new server.  This may
  # be nil.
  #
  # See DRbServer::new.
  #
  # source://drb//lib/drb/drb.rb#1768
  def start_service(uri = T.unsafe(nil), front = T.unsafe(nil), config = T.unsafe(nil)); end

  # Stop the local dRuby server.
  #
  # This operates on the primary server.  If there is no primary
  # server currently running, it is a noop.
  #
  # source://drb//lib/drb/drb.rb#1801
  def stop_service; end

  # Get the thread of the primary server.
  #
  # This returns nil if there is no primary server.  See #primary_server.
  #
  # source://drb//lib/drb/drb.rb#1869
  def thread; end

  # Get a reference id for an object using the current server.
  #
  # This raises a DRbServerNotFound error if there is no current server.
  # See #current_server.
  #
  # source://drb//lib/drb/drb.rb#1860
  def to_id(obj); end

  # Convert a reference into an object using the current server.
  #
  # This raises a DRbServerNotFound error if there is no current server.
  # See #current_server.
  #
  # source://drb//lib/drb/drb.rb#1852
  def to_obj(ref); end

  # Get the URI defining the local dRuby space.
  #
  # This is the URI of the current server.  See #current_server.
  #
  # source://drb//lib/drb/drb.rb#1810
  def uri; end

  class << self
    # Get the configuration of the current server.
    #
    # If there is no current server, this returns the default configuration.
    # See #current_server and DRbServer::make_config.
    #
    # source://drb//lib/drb/drb.rb#1832
    def config; end

    # Get the 'current' server.
    #
    # In the context of execution taking place within the main
    # thread of a dRuby server (typically, as a result of a remote
    # call on the server or one of its objects), the current
    # server is that server.  Otherwise, the current server is
    # the primary server.
    #
    # If the above rule fails to find a server, a DRbServerNotFound
    # error is raised.
    #
    # @raise [DRbServerNotFound]
    #
    # source://drb//lib/drb/drb.rb#1789
    def current_server; end

    # Retrieves the server with the given +uri+.
    #
    # See also regist_server and remove_server.
    #
    # source://drb//lib/drb/drb.rb#1934
    def fetch_server(uri); end

    # Get the front object of the current server.
    #
    # This raises a DRbServerNotFound error if there is no current server.
    # See #current_server.
    #
    # source://drb//lib/drb/drb.rb#1843
    def front; end

    # Is +uri+ the URI for the current local server?
    #
    # @return [Boolean]
    #
    # source://drb//lib/drb/drb.rb#1822
    def here?(uri); end

    # Set the default ACL to +acl+.
    #
    # See DRb::DRbServer.default_acl.
    #
    # source://drb//lib/drb/drb.rb#1888
    def install_acl(acl); end

    # Set the default id conversion object.
    #
    # This is expected to be an instance such as DRb::DRbIdConv that responds to
    # #to_id and #to_obj that can convert objects to and from DRb references.
    #
    # See DRbServer#default_id_conv.
    #
    # source://drb//lib/drb/drb.rb#1880
    def install_id_conv(idconv); end

    # source://drb//lib/drb/drb.rb#1894
    def mutex; end

    # The primary local dRuby server.
    #
    # This is the server created by the #start_service call.
    #
    # source://drb//lib/drb/drb.rb#1776
    def primary_server; end

    # The primary local dRuby server.
    #
    # This is the server created by the #start_service call.
    #
    # source://drb//lib/drb/drb.rb#1776
    def primary_server=(_arg0); end

    # Registers +server+ with DRb.
    #
    # This is called when a new DRb::DRbServer is created.
    #
    # If there is no primary server then +server+ becomes the primary server.
    #
    # Example:
    #
    #  require 'drb'
    #
    #  s = DRb::DRbServer.new # automatically calls regist_server
    #  DRb.fetch_server s.uri #=> #<DRb::DRbServer:0x...>
    #
    # source://drb//lib/drb/drb.rb#1912
    def regist_server(server); end

    # Removes +server+ from the list of registered servers.
    #
    # source://drb//lib/drb/drb.rb#1921
    def remove_server(server); end

    # Start a dRuby server locally.
    #
    # The new dRuby server will become the primary server, even
    # if another server is currently the primary server.
    #
    # +uri+ is the URI for the server to bind to.  If nil,
    # the server will bind to random port on the default local host
    # name and use the default dRuby protocol.
    #
    # +front+ is the server's front object.  This may be nil.
    #
    # +config+ is the configuration for the new server.  This may
    # be nil.
    #
    # See DRbServer::new.
    #
    # source://drb//lib/drb/drb.rb#1768
    def start_service(uri = T.unsafe(nil), front = T.unsafe(nil), config = T.unsafe(nil)); end

    # Stop the local dRuby server.
    #
    # This operates on the primary server.  If there is no primary
    # server currently running, it is a noop.
    #
    # source://drb//lib/drb/drb.rb#1801
    def stop_service; end

    # Get the thread of the primary server.
    #
    # This returns nil if there is no primary server.  See #primary_server.
    #
    # source://drb//lib/drb/drb.rb#1869
    def thread; end

    # Get a reference id for an object using the current server.
    #
    # This raises a DRbServerNotFound error if there is no current server.
    # See #current_server.
    #
    # source://drb//lib/drb/drb.rb#1860
    def to_id(obj); end

    # Convert a reference into an object using the current server.
    #
    # This raises a DRbServerNotFound error if there is no current server.
    # See #current_server.
    #
    # source://drb//lib/drb/drb.rb#1852
    def to_obj(ref); end

    # Get the URI defining the local dRuby space.
    #
    # This is the URI of the current server.  See #current_server.
    #
    # source://drb//lib/drb/drb.rb#1810
    def uri; end
  end
end

# An Array wrapper that can be sent to another server via DRb.
#
# All entries in the array will be dumped or be references that point to
# the local server.
#
# source://drb//lib/drb/drb.rb#518
class DRb::DRbArray
  # Creates a new DRbArray that either dumps or wraps all the items in the
  # Array +ary+ so they can be loaded by a remote DRb server.
  #
  # @return [DRbArray] a new instance of DRbArray
  #
  # source://drb//lib/drb/drb.rb#523
  def initialize(ary); end

  # source://drb//lib/drb/drb.rb#542
  def _dump(lv); end

  class << self
    # source://drb//lib/drb/drb.rb#538
    def _load(s); end
  end
end

# Class handling the connection between a DRbObject and the
# server the real object lives on.
#
# This class maintains a pool of connections, to reduce the
# overhead of starting and closing down connections for each
# method call.
#
# This class is used internally by DRbObject.  The user does
# not normally need to deal with it directly.
#
# source://drb//lib/drb/drb.rb#1256
class DRb::DRbConn
  # @return [DRbConn] a new instance of DRbConn
  #
  # source://drb//lib/drb/drb.rb#1317
  def initialize(remote_uri); end

  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1333
  def alive?; end

  # source://drb//lib/drb/drb.rb#1328
  def close; end

  # source://drb//lib/drb/drb.rb#1323
  def send_message(ref, msg_id, arg, block); end

  # source://drb//lib/drb/drb.rb#1321
  def uri; end

  class << self
    # source://drb//lib/drb/drb.rb#1259
    def make_pool; end

    # source://drb//lib/drb/drb.rb#1297
    def open(remote_uri); end

    # source://drb//lib/drb/drb.rb#1292
    def stop_pool; end
  end
end

# Class responsible for converting between an object and its id.
#
# This, the default implementation, uses an object's local ObjectSpace
# __id__ as its id.  This means that an object's identification over
# drb remains valid only while that object instance remains alive
# within the server runtime.
#
# For alternative mechanisms, see DRb::TimerIdConv in drb/timeridconv.rb
# and DRbNameIdConv in sample/name.rb in the full drb distribution.
#
# source://drb//lib/drb/drb.rb#360
class DRb::DRbIdConv
  # Convert an object into a reference id.
  #
  # This implementation returns the object's __id__ in the local
  # object space.
  #
  # source://drb//lib/drb/drb.rb#374
  def to_id(obj); end

  # Convert an object reference id to an object.
  #
  # This implementation looks up the reference id in the local object
  # space and returns the object it refers to.
  #
  # source://drb//lib/drb/drb.rb#366
  def to_obj(ref); end
end

# Handler for sending and receiving drb messages.
#
# This takes care of the low-level marshalling and unmarshalling
# of drb requests and responses sent over the wire between server
# and client.  This relieves the implementor of a new drb
# protocol layer with having to deal with these details.
#
# The user does not have to directly deal with this object in
# normal use.
#
# source://drb//lib/drb/drb.rb#556
class DRb::DRbMessage
  # @return [DRbMessage] a new instance of DRbMessage
  #
  # source://drb//lib/drb/drb.rb#557
  def initialize(config); end

  # source://drb//lib/drb/drb.rb#562
  def dump(obj, error = T.unsafe(nil)); end

  # @raise [DRbConnError]
  #
  # source://drb//lib/drb/drb.rb#579
  def load(soc); end

  # source://drb//lib/drb/drb.rb#639
  def recv_reply(stream); end

  # @raise [DRbConnError]
  #
  # source://drb//lib/drb/drb.rb#619
  def recv_request(stream); end

  # source://drb//lib/drb/drb.rb#633
  def send_reply(stream, succ, result); end

  # source://drb//lib/drb/drb.rb#605
  def send_request(stream, ref, msg_id, arg, b); end

  private

  # source://drb//lib/drb/drb.rb#646
  def make_proxy(obj, error = T.unsafe(nil)); end
end

# source://drb//lib/drb/eq.rb#3
class DRb::DRbObject
  # Create a new remote object stub.
  #
  # +obj+ is the (local) object we want to create a stub for.  Normally
  # this is +nil+.  +uri+ is the URI of the remote object that this
  # will be a stub for.
  #
  # @return [DRbObject] a new instance of DRbObject
  #
  # source://drb//lib/drb/drb.rb#1089
  def initialize(obj, uri = T.unsafe(nil)); end

  # source://drb//lib/drb/eq.rb#4
  def ==(other); end

  # Get the reference of the object, if local.
  #
  # source://drb//lib/drb/drb.rb#1115
  def __drbref; end

  # Get the URI of the remote object.
  #
  # source://drb//lib/drb/drb.rb#1110
  def __drburi; end

  # Marshall this object.
  #
  # The URI and ref of the object are marshalled.
  #
  # source://drb//lib/drb/drb.rb#1080
  def _dump(lv); end

  # source://drb//lib/drb/eq.rb#4
  def eql?(other); end

  # source://drb//lib/drb/eq.rb#9
  def hash; end

  # source://drb//lib/drb/drb.rb#1135
  def method_missing(msg_id, *a, **_arg2, &b); end

  # source://drb//lib/drb/drb.rb#1187
  def pretty_print(q); end

  # source://drb//lib/drb/drb.rb#1191
  def pretty_print_cycle(q); end

  # Routes respond_to? to the referenced remote object.
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1123
  def respond_to?(msg_id, priv = T.unsafe(nil)); end

  class << self
    # Unmarshall a marshalled DRbObject.
    #
    # If the referenced object is located within the local server, then
    # the object itself is returned.  Otherwise, a new DRbObject is
    # created to act as a stub for the remote referenced object.
    #
    # source://drb//lib/drb/drb.rb#1051
    def _load(s); end

    # Creates a DRb::DRbObject given the reference information to the remote
    # host +uri+ and object +ref+.
    #
    # source://drb//lib/drb/drb.rb#1065
    def new_with(uri, ref); end

    # Create a new DRbObject from a URI alone.
    #
    # source://drb//lib/drb/drb.rb#1073
    def new_with_uri(uri); end

    # Returns a modified backtrace from +result+ with the +uri+ where each call
    # in the backtrace came from.
    #
    # source://drb//lib/drb/drb.rb#1173
    def prepare_backtrace(uri, result); end

    # Given the +uri+ of another host executes the block provided.
    #
    # source://drb//lib/drb/drb.rb#1160
    def with_friend(uri); end
  end
end

# Module managing the underlying network protocol(s) used by drb.
#
# By default, drb uses the DRbTCPSocket protocol.  Other protocols
# can be defined.  A protocol must define the following class methods:
#
#   [open(uri, config)] Open a client connection to the server at +uri+,
#                       using configuration +config+.  Return a protocol
#                       instance for this connection.
#   [open_server(uri, config)] Open a server listening at +uri+,
#                              using configuration +config+.  Return a
#                              protocol instance for this listener.
#   [uri_option(uri, config)] Take a URI, possibly containing an option
#                             component (e.g. a trailing '?param=val'),
#                             and return a [uri, option] tuple.
#
# All of these methods should raise a DRbBadScheme error if the URI
# does not identify the protocol they support (e.g. "druby:" for
# the standard Ruby protocol).  This is how the DRbProtocol module,
# given a URI, determines which protocol implementation serves that
# protocol.
#
# The protocol instance returned by #open_server must have the
# following methods:
#
# [accept] Accept a new connection to the server.  Returns a protocol
#          instance capable of communicating with the client.
# [close] Close the server connection.
# [uri] Get the URI for this server.
#
# The protocol instance returned by #open must have the following methods:
#
# [send_request (ref, msg_id, arg, b)]
#      Send a request to +ref+ with the given message id and arguments.
#      This is most easily implemented by calling DRbMessage.send_request,
#      providing a stream that sits on top of the current protocol.
# [recv_reply]
#      Receive a reply from the server and return it as a [success-boolean,
#      reply-value] pair.  This is most easily implemented by calling
#      DRb.recv_reply, providing a stream that sits on top of the
#      current protocol.
# [alive?]
#      Is this connection still alive?
# [close]
#      Close this connection.
#
# The protocol instance returned by #open_server().accept() must have
# the following methods:
#
# [recv_request]
#     Receive a request from the client and return a [object, message,
#     args, block] tuple.  This is most easily implemented by calling
#     DRbMessage.recv_request, providing a stream that sits on top of
#     the current protocol.
# [send_reply(succ, result)]
#     Send a reply to the client.  This is most easily implemented
#     by calling DRbMessage.send_reply, providing a stream that sits
#     on top of the current protocol.
# [close]
#     Close this connection.
#
# A new protocol is registered with the DRbProtocol module using
# the add_protocol method.
#
# For examples of other protocols, see DRbUNIXSocket in drb/unix.rb,
# and HTTP0 in sample/http0.rb and sample/http0serv.rb in the full
# drb distribution.
#
# source://drb//lib/drb/drb.rb#721
module DRb::DRbProtocol
  private

  # Add a new protocol to the DRbProtocol module.
  #
  # source://drb//lib/drb/drb.rb#724
  def add_protocol(prot); end

  # source://drb//lib/drb/drb.rb#802
  def auto_load(uri); end

  # Open a client connection to +uri+ with the configuration +config+.
  #
  # The DRbProtocol module asks each registered protocol in turn to
  # try to open the URI.  Each protocol signals that it does not handle that
  # URI by raising a DRbBadScheme error.  If no protocol recognises the
  # URI, then a DRbBadURI error is raised.  If a protocol accepts the
  # URI, but an error occurs in opening it, a DRbConnError is raised.
  #
  # @raise [DRbBadURI]
  #
  # source://drb//lib/drb/drb.rb#736
  def open(uri, config, first = T.unsafe(nil)); end

  # Open a server listening for connections at +uri+ with
  # configuration +config+.
  #
  # The DRbProtocol module asks each registered protocol in turn to
  # try to open a server at the URI.  Each protocol signals that it does
  # not handle that URI by raising a DRbBadScheme error.  If no protocol
  # recognises the URI, then a DRbBadURI error is raised.  If a protocol
  # accepts the URI, but an error occurs in opening it, the underlying
  # error is passed on to the caller.
  #
  # @raise [DRbBadURI]
  #
  # source://drb//lib/drb/drb.rb#764
  def open_server(uri, config, first = T.unsafe(nil)); end

  # Parse +uri+ into a [uri, option] pair.
  #
  # The DRbProtocol module asks each registered protocol in turn to
  # try to parse the URI.  Each protocol signals that it does not handle that
  # URI by raising a DRbBadScheme error.  If no protocol recognises the
  # URI, then a DRbBadURI error is raised.
  #
  # @raise [DRbBadURI]
  #
  # source://drb//lib/drb/drb.rb#785
  def uri_option(uri, config, first = T.unsafe(nil)); end

  class << self
    # Add a new protocol to the DRbProtocol module.
    #
    # source://drb//lib/drb/drb.rb#724
    def add_protocol(prot); end

    # source://drb//lib/drb/drb.rb#802
    def auto_load(uri); end

    # Open a client connection to +uri+ with the configuration +config+.
    #
    # The DRbProtocol module asks each registered protocol in turn to
    # try to open the URI.  Each protocol signals that it does not handle that
    # URI by raising a DRbBadScheme error.  If no protocol recognises the
    # URI, then a DRbBadURI error is raised.  If a protocol accepts the
    # URI, but an error occurs in opening it, a DRbConnError is raised.
    #
    # @raise [DRbBadURI]
    #
    # source://drb//lib/drb/drb.rb#736
    def open(uri, config, first = T.unsafe(nil)); end

    # Open a server listening for connections at +uri+ with
    # configuration +config+.
    #
    # The DRbProtocol module asks each registered protocol in turn to
    # try to open a server at the URI.  Each protocol signals that it does
    # not handle that URI by raising a DRbBadScheme error.  If no protocol
    # recognises the URI, then a DRbBadURI error is raised.  If a protocol
    # accepts the URI, but an error occurs in opening it, the underlying
    # error is passed on to the caller.
    #
    # @raise [DRbBadURI]
    #
    # source://drb//lib/drb/drb.rb#764
    def open_server(uri, config, first = T.unsafe(nil)); end

    # Parse +uri+ into a [uri, option] pair.
    #
    # The DRbProtocol module asks each registered protocol in turn to
    # try to parse the URI.  Each protocol signals that it does not handle that
    # URI by raising a DRbBadScheme error.  If no protocol recognises the
    # URI, then a DRbBadURI error is raised.
    #
    # @raise [DRbBadURI]
    #
    # source://drb//lib/drb/drb.rb#785
    def uri_option(uri, config, first = T.unsafe(nil)); end
  end
end

# An exception wrapping an error object
#
# source://drb//lib/drb/drb.rb#431
class DRb::DRbRemoteError < ::DRb::DRbError
  # Creates a new remote error that wraps the Exception +error+
  #
  # @return [DRbRemoteError] a new instance of DRbRemoteError
  #
  # source://drb//lib/drb/drb.rb#434
  def initialize(error); end

  # the class of the error, as a string.
  #
  # source://drb//lib/drb/drb.rb#441
  def reason; end
end

# source://drb//lib/drb/drb.rb#1350
class DRb::DRbServer
  # Create a new DRbServer instance.
  #
  # +uri+ is the URI to bind to.  This is normally of the form
  # 'druby://<hostname>:<port>' where <hostname> is a hostname of
  # the local machine.  If nil, then the system's default hostname
  # will be bound to, on a port selected by the system; these value
  # can be retrieved from the +uri+ attribute.  'druby:' specifies
  # the default dRuby transport protocol: another protocol, such
  # as 'drbunix:', can be specified instead.
  #
  # +front+ is the front object for the server, that is, the object
  # to which remote method calls on the server will be passed.  If
  # nil, then the server will not accept remote method calls.
  #
  # If +config_or_acl+ is a hash, it is the configuration to
  # use for this server.  The following options are recognised:
  #
  # :idconv :: an id-to-object conversion object.  This defaults
  #            to an instance of the class DRb::DRbIdConv.
  # :verbose :: if true, all unsuccessful remote calls on objects
  #             in the server will be logged to $stdout. false
  #             by default.
  # :tcp_acl :: the access control list for this server.  See
  #             the ACL class from the main dRuby distribution.
  # :load_limit :: the maximum message size in bytes accepted by
  #                the server.  Defaults to 25 MB (26214400).
  # :argc_limit :: the maximum number of arguments to a remote
  #                method accepted by the server.  Defaults to
  #                256.
  # The default values of these options can be modified on
  # a class-wide basis by the class methods #default_argc_limit,
  # #default_load_limit, #default_acl, #default_id_conv,
  # and #verbose=
  #
  # If +config_or_acl+ is not a hash, but is not nil, it is
  # assumed to be the access control list for this server.
  # See the :tcp_acl option for more details.
  #
  # If no other server is currently set as the primary server,
  # this will become the primary server.
  #
  # The server will immediately start running in its own thread.
  #
  # @return [DRbServer] a new instance of DRbServer
  #
  # source://drb//lib/drb/drb.rb#1451
  def initialize(uri = T.unsafe(nil), front = T.unsafe(nil), config_or_acl = T.unsafe(nil)); end

  # Is this server alive?
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1506
  def alive?; end

  # Check that a method is callable via dRuby.
  #
  # +obj+ is the object we want to invoke the method on. +msg_id+ is the
  # method name, as a Symbol.
  #
  # If the method is an insecure method (see #insecure_method?) a
  # SecurityError is thrown.  If the method is private or undefined,
  # a NameError is thrown.
  #
  # @raise [ArgumentError]
  #
  # source://drb//lib/drb/drb.rb#1594
  def check_insecure_method(obj, msg_id); end

  # The configuration of this DRbServer
  #
  # source://drb//lib/drb/drb.rb#1493
  def config; end

  # The front object of the DRbServer.
  #
  # This object receives remote method calls made on the server's
  # URI alone, with an object id.
  #
  # source://drb//lib/drb/drb.rb#1490
  def front; end

  # Is +uri+ the URI for this server?
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1511
  def here?(uri); end

  # Stop this server.
  #
  # source://drb//lib/drb/drb.rb#1516
  def stop_service; end

  # The main thread of this DRbServer.
  #
  # This is the thread that listens for and accepts connections
  # from clients, not that handles each client's request-response
  # session.
  #
  # source://drb//lib/drb/drb.rb#1484
  def thread; end

  # Convert a local object to a dRuby reference.
  #
  # source://drb//lib/drb/drb.rb#1533
  def to_id(obj); end

  # Convert a dRuby reference to the local object it refers to.
  #
  # source://drb//lib/drb/drb.rb#1526
  def to_obj(ref); end

  # The URI of this DRbServer.
  #
  # source://drb//lib/drb/drb.rb#1477
  def uri; end

  # Get whether the server is in verbose mode.
  #
  # In verbose mode, failed calls are logged to stdout.
  #
  # source://drb//lib/drb/drb.rb#1503
  def verbose; end

  # Set whether to operate in verbose mode.
  #
  # In verbose mode, failed calls are logged to stdout.
  #
  # source://drb//lib/drb/drb.rb#1498
  def verbose=(v); end

  private

  # Coerce an object to a string, providing our own representation if
  # to_s is not defined for the object.
  #
  # source://drb//lib/drb/drb.rb#1580
  def any_to_s(obj); end

  # source://drb//lib/drb/drb.rb#1696
  def error_print(exception); end

  # Has a method been included in the list of insecure methods?
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1574
  def insecure_method?(msg_id); end

  # The main loop performed by a DRbServer's internal thread.
  #
  # Accepts a connection from a client, and starts up its own
  # thread to handle it.  This thread loops, receiving requests
  # from the client, invoking them on a local object, and
  # returning responses, until the client closes the connection
  # or a local method call fails.
  #
  # source://drb//lib/drb/drb.rb#1714
  def main_loop; end

  # Starts the DRb main loop in a new thread.
  #
  # source://drb//lib/drb/drb.rb#1555
  def run; end

  # source://drb//lib/drb/drb.rb#1540
  def shutdown; end

  class << self
    # Set the default access control list to +acl+.  The default ACL is +nil+.
    #
    # See also DRb::ACL and #new()
    #
    # source://drb//lib/drb/drb.rb#1375
    def default_acl(acl); end

    # Set the default value for the :argc_limit option.
    #
    # See #new().  The initial default value is 256.
    #
    # source://drb//lib/drb/drb.rb#1361
    def default_argc_limit(argc); end

    # Set the default value for the :id_conv option.
    #
    # See #new().  The initial default value is a DRbIdConv instance.
    #
    # source://drb//lib/drb/drb.rb#1382
    def default_id_conv(idconv); end

    # Set the default value for the :load_limit option.
    #
    # See #new().  The initial default value is 25 MB.
    #
    # source://drb//lib/drb/drb.rb#1368
    def default_load_limit(sz); end

    # source://drb//lib/drb/drb.rb#1398
    def make_config(hash = T.unsafe(nil)); end

    # Get the default value of the :verbose option.
    #
    # source://drb//lib/drb/drb.rb#1394
    def verbose; end

    # Set the default value of the :verbose option.
    #
    # See #new().  The initial default value is false.
    #
    # source://drb//lib/drb/drb.rb#1389
    def verbose=(on); end
  end
end

# source://drb//lib/drb/drb.rb#1624
class DRb::DRbServer::InvokeMethod
  include ::DRb::DRbServer::InvokeMethod18Mixin

  # @return [InvokeMethod] a new instance of InvokeMethod
  #
  # source://drb//lib/drb/drb.rb#1625
  def initialize(drb_server, client); end

  # source://drb//lib/drb/drb.rb#1630
  def perform; end

  private

  # source://drb//lib/drb/drb.rb#1667
  def check_insecure_method; end

  # source://drb//lib/drb/drb.rb#1659
  def init_with_client; end

  # source://drb//lib/drb/drb.rb#1676
  def perform_without_block; end

  # source://drb//lib/drb/drb.rb#1671
  def setup_message; end
end

# source://drb//lib/drb/invokemethod.rb#6
module DRb::DRbServer::InvokeMethod18Mixin
  # source://drb//lib/drb/invokemethod.rb#7
  def block_yield(x); end

  # source://drb//lib/drb/invokemethod.rb#14
  def perform_with_block; end
end

# The default drb protocol which communicates over a TCP socket.
#
# The DRb TCP protocol URI looks like:
# <code>druby://<host>:<port>?<option></code>.  The option is optional.
#
# source://drb//lib/drb/drb.rb#815
class DRb::DRbTCPSocket
  # Create a new DRbTCPSocket instance.
  #
  # +uri+ is the URI we are connected to.
  # +soc+ is the tcp socket we are bound to.  +config+ is our
  # configuration.
  #
  # @return [DRbTCPSocket] a new instance of DRbTCPSocket
  #
  # source://drb//lib/drb/drb.rb#903
  def initialize(uri, soc, config = T.unsafe(nil)); end

  # On the server side, for an instance returned by #open_server,
  # accept a client connection and return a new instance to handle
  # the server's side of this client-server session.
  #
  # source://drb//lib/drb/drb.rb#971
  def accept; end

  # Check to see if this connection is alive.
  #
  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1001
  def alive?; end

  # Close the connection.
  #
  # If this is an instance returned by #open_server, then this stops
  # listening for new connections altogether.  If this is an instance
  # returned by #open or by #accept, then it closes this particular
  # client-server session.
  #
  # source://drb//lib/drb/drb.rb#953
  def close; end

  # Get the address of our TCP peer (the other end of the socket
  # we are bound to.
  #
  # source://drb//lib/drb/drb.rb#918
  def peeraddr; end

  # On the client side, receive a reply from the server.
  #
  # source://drb//lib/drb/drb.rb#941
  def recv_reply; end

  # On the server side, receive a request from the client.
  #
  # source://drb//lib/drb/drb.rb#931
  def recv_request; end

  # On the server side, send a reply to the client.
  #
  # source://drb//lib/drb/drb.rb#936
  def send_reply(succ, result); end

  # On the client side, send a request to the server.
  #
  # source://drb//lib/drb/drb.rb#926
  def send_request(ref, msg_id, arg, b); end

  # source://drb//lib/drb/drb.rb#1010
  def set_sockopt(soc); end

  # Graceful shutdown
  #
  # source://drb//lib/drb/drb.rb#996
  def shutdown; end

  # Get the socket.
  #
  # source://drb//lib/drb/drb.rb#923
  def stream; end

  # Get the URI that we are connected to.
  #
  # source://drb//lib/drb/drb.rb#914
  def uri; end

  private

  # source://drb//lib/drb/drb.rb#986
  def accept_or_shutdown; end

  # source://drb//lib/drb/drb.rb#962
  def close_shutdown_pipe; end

  class << self
    # Returns the hostname of this server
    #
    # source://drb//lib/drb/drb.rb#845
    def getservername; end

    # Open a client connection to +uri+ (DRb URI string) using configuration
    # +config+.
    #
    # This can raise DRb::DRbBadScheme or DRb::DRbBadURI if +uri+ is not for a
    # recognized protocol.  See DRb::DRbServer.new for information on built-in
    # URI protocols.
    #
    # source://drb//lib/drb/drb.rb#838
    def open(uri, config); end

    # Open a server listening for connections at +uri+ using
    # configuration +config+.
    #
    # source://drb//lib/drb/drb.rb#876
    def open_server(uri, config); end

    # For the families available for +host+, returns a TCPServer on +port+.
    # If +port+ is 0 the first available port is used.  IPv4 servers are
    # preferred over IPv6 servers.
    #
    # source://drb//lib/drb/drb.rb#861
    def open_server_inaddr_any(host, port); end

    # source://drb//lib/drb/drb.rb#818
    def parse_uri(uri); end

    # Parse +uri+ into a [uri, option] pair.
    #
    # source://drb//lib/drb/drb.rb#893
    def uri_option(uri, config); end
  end
end

# Implements DRb over a UNIX socket
#
# DRb UNIX socket URIs look like <code>drbunix:<path>?<option></code>.  The
# option is optional.
#
# source://drb//lib/drb/unix.rb#15
class DRb::DRbUNIXSocket < ::DRb::DRbTCPSocket
  # @return [DRbUNIXSocket] a new instance of DRbUNIXSocket
  #
  # source://drb//lib/drb/unix.rb#62
  def initialize(uri, soc, config = T.unsafe(nil), server_mode = T.unsafe(nil)); end

  # source://drb//lib/drb/unix.rb#105
  def accept; end

  # source://drb//lib/drb/unix.rb#95
  def close; end

  # source://drb//lib/drb/unix.rb#111
  def set_sockopt(soc); end

  class << self
    # source://drb//lib/drb/unix.rb#28
    def open(uri, config); end

    # source://drb//lib/drb/unix.rb#34
    def open_server(uri, config); end

    # :stopdoc:
    #
    # source://drb//lib/drb/unix.rb#17
    def parse_uri(uri); end

    # source://drb//lib/drb/unix.rb#72
    def temp_server; end

    # source://drb//lib/drb/unix.rb#57
    def uri_option(uri, config); end
  end
end

# import from tempfile.rb
#
# source://drb//lib/drb/unix.rb#70
DRb::DRbUNIXSocket::Max_try = T.let(T.unsafe(nil), Integer)

# source://drb//lib/drb/drb.rb#1021
class DRb::DRbURIOption
  # @return [DRbURIOption] a new instance of DRbURIOption
  #
  # source://drb//lib/drb/drb.rb#1022
  def initialize(option); end

  # source://drb//lib/drb/drb.rb#1028
  def ==(other); end

  # source://drb//lib/drb/drb.rb#1028
  def eql?(other); end

  # source://drb//lib/drb/drb.rb#1033
  def hash; end

  # Returns the value of attribute option.
  #
  # source://drb//lib/drb/drb.rb#1025
  def option; end

  # source://drb//lib/drb/drb.rb#1026
  def to_s; end
end

# Mixin module making an object undumpable or unmarshallable.
#
# If an object which includes this module is returned by method
# called over drb, then the object remains in the server space
# and a reference to the object is returned, rather than the
# object being marshalled and moved into the client space.
#
# source://drb//lib/drb/drb.rb#390
module DRb::DRbUndumped
  # @raise [TypeError]
  #
  # source://drb//lib/drb/drb.rb#391
  def _dump(dummy); end
end

# Class wrapping a marshalled object whose type is unknown locally.
#
# If an object is returned by a method invoked over drb, but the
# class of the object is unknown in the client namespace, or
# the object is a constant unknown in the client namespace, then
# the still-marshalled object is returned wrapped in a DRbUnknown instance.
#
# If this object is passed as an argument to a method invoked over
# drb, then the wrapped object is passed instead.
#
# The class or constant name of the object can be read from the
# +name+ attribute.  The marshalled object is held in the +buf+
# attribute.
#
# source://drb//lib/drb/drb.rb#457
class DRb::DRbUnknown
  # Create a new DRbUnknown object.
  #
  # +buf+ is a string containing a marshalled object that could not
  # be unmarshalled.  +err+ is the error message that was raised
  # when the unmarshalling failed.  It is used to determine the
  # name of the unmarshalled object.
  #
  # @return [DRbUnknown] a new instance of DRbUnknown
  #
  # source://drb//lib/drb/drb.rb#465
  def initialize(err, buf); end

  # source://drb//lib/drb/drb.rb#494
  def _dump(lv); end

  # Buffer contained the marshalled, unknown object.
  #
  # source://drb//lib/drb/drb.rb#484
  def buf; end

  # Create a DRbUnknownError exception containing this object.
  #
  # source://drb//lib/drb/drb.rb#508
  def exception; end

  # The name of the unknown thing.
  #
  # Class name for unknown objects; variable name for unknown
  # constants.
  #
  # source://drb//lib/drb/drb.rb#481
  def name; end

  # Attempt to load the wrapped marshalled object again.
  #
  # If the class of the object is now known locally, the object
  # will be unmarshalled and returned.  Otherwise, a new
  # but identical DRbUnknown object will be returned.
  #
  # source://drb//lib/drb/drb.rb#503
  def reload; end

  class << self
    # source://drb//lib/drb/drb.rb#486
    def _load(s); end
  end
end

# An exception wrapping a DRb::DRbUnknown object
#
# source://drb//lib/drb/drb.rb#410
class DRb::DRbUnknownError < ::DRb::DRbError
  # Create a new DRbUnknownError for the DRb::DRbUnknown object +unknown+
  #
  # @return [DRbUnknownError] a new instance of DRbUnknownError
  #
  # source://drb//lib/drb/drb.rb#413
  def initialize(unknown); end

  # source://drb//lib/drb/drb.rb#425
  def _dump(lv); end

  # Get the wrapped DRb::DRbUnknown object.
  #
  # source://drb//lib/drb/drb.rb#419
  def unknown; end

  class << self
    # source://drb//lib/drb/drb.rb#421
    def _load(s); end
  end
end

# source://drb//lib/drb/drb.rb#1199
class DRb::ThreadObject
  include ::MonitorMixin

  # @return [ThreadObject] a new instance of ThreadObject
  #
  # source://drb//lib/drb/drb.rb#1202
  def initialize(&blk); end

  # source://drb//lib/drb/drb.rb#1237
  def _execute; end

  # @return [Boolean]
  #
  # source://drb//lib/drb/drb.rb#1213
  def alive?; end

  # source://drb//lib/drb/drb.rb#1217
  def kill; end

  # source://drb//lib/drb/drb.rb#1222
  def method_missing(msg, *arg, &blk); end
end

# source://drb//lib/drb/version.rb#2
DRb::VERSION = T.let(T.unsafe(nil), String)

# source://drb//lib/drb/drb.rb#1943
DRbIdConv = DRb::DRbIdConv

# :stopdoc:
#
# source://drb//lib/drb/drb.rb#1941
DRbObject = DRb::DRbObject

# source://drb//lib/drb/drb.rb#1942
DRbUndumped = DRb::DRbUndumped
