# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `mime-types` gem.
# Please instead update this file by running `bin/tapioca gem mime-types`.


# source://mime-types//lib/mime/types.rb#4
module MIME; end

# The definition of one MIME content-type.
#
# == Usage
#  require "mime/types"
#
#  plaintext = MIME::Types["text/plain"] # => [ text/plain ]
#  text = plaintext.first
#  puts text.media_type            # => "text"
#  puts text.sub_type              # => "plain"
#
#  puts text.extensions.join(" ")  # => "txt asc c cc h hh cpp hpp dat hlp"
#  puts text.preferred_extension   # => "txt"
#  puts text.friendly              # => "Text Document"
#  puts text.i18n_key              # => "text.plain"
#
#  puts text.encoding              # => quoted-printable
#  puts text.default_encoding      # => quoted-printable
#  puts text.binary?               # => false
#  puts text.ascii?                # => true
#  puts text.obsolete?             # => false
#  puts text.registered?           # => true
#  puts text.provisional?          # => false
#  puts text.complete?             # => true
#
#  puts text                       # => "text/plain"
#
#  puts text == "text/plain"       # => true
#  puts "text/plain" == text       # => true
#  puts text == "text/x-plain"     # => false
#  puts "text/x-plain" == text     # => false
#
#  puts MIME::Type.simplified("x-appl/x-zip") # => "x-appl/x-zip"
#  puts MIME::Type.i18n_key("x-appl/x-zip") # => "x-appl.x-zip"
#
#  puts text.like?("text/x-plain") # => true
#  puts text.like?(MIME::Type.new("content-type" => "x-text/x-plain")) # => true
#
#  puts text.xrefs.inspect # => { "rfc" => [ "rfc2046", "rfc3676", "rfc5147" ] }
#  puts text.xref_urls # => [ "http://www.iana.org/go/rfc2046",
#                      #      "http://www.iana.org/go/rfc3676",
#                      #      "http://www.iana.org/go/rfc5147" ]
#
#  xtext = MIME::Type.new("x-text/x-plain")
#  puts xtext.media_type # => "text"
#  puts xtext.raw_media_type # => "x-text"
#  puts xtext.sub_type # => "plain"
#  puts xtext.raw_sub_type # => "x-plain"
#  puts xtext.complete? # => false
#
#  puts MIME::Types.any? { |type| type.content_type == "text/plain" } # => true
#  puts MIME::Types.all?(&:registered?) # => false
#
#  # Various string representations of MIME types
#  qcelp = MIME::Types["audio/QCELP"].first # => audio/QCELP
#  puts qcelp.content_type         # => "audio/QCELP"
#  puts qcelp.simplified           # => "audio/qcelp"
#
#  xwingz = MIME::Types["application/x-Wingz"].first # => application/x-Wingz
#  puts xwingz.content_type        # => "application/x-Wingz"
#  puts xwingz.simplified          # => "application/x-wingz"
#
# source://mime-types//lib/mime/type.rb#69
class MIME::Type
  include ::Comparable

  # Builds a MIME::Type object from the +content_type+, a MIME Content Type
  # value (e.g., "text/plain" or "application/x-eruby"). The constructed object
  # is yielded to an optional block for additional configuration, such as
  # associating extensions and encoding information.
  #
  # * When provided a Hash or a MIME::Type, the MIME::Type will be
  #   constructed with #init_with.
  #
  # There are two deprecated initialization forms:
  #
  # * When provided an Array, the MIME::Type will be constructed using
  #   the first element as the content type and the remaining flattened
  #   elements as extensions.
  # * Otherwise, the content_type will be used as a string.
  #
  # Yields the newly constructed +self+ object.
  #
  # @return [Type] a new instance of Type
  # @yield [_self]
  # @yieldparam _self [MIME::Type] the object that the method was called on
  #
  # source://mime-types//lib/mime/type.rb#136
  def initialize(content_type); end

  # Compares the +other+ MIME::Type against the exact content type or the
  # simplified type (the simplified type will be used if comparing against
  # something that can be treated as a String with #to_s). In comparisons, this
  # is done against the lowercase version of the MIME::Type.
  #
  # source://mime-types//lib/mime/type.rb#188
  def <=>(other); end

  # Merge the +extensions+ provided into this MIME::Type. The extensions added
  # will be merged uniquely.
  #
  # source://mime-types//lib/mime/type.rb#336
  def add_extensions(*extensions); end

  # MIME types can be specified to be sent across a network in particular
  # formats. This method returns +false+ when the MIME::Type encoding is
  # set to <tt>base64</tt>.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#492
  def ascii?; end

  # MIME types can be specified to be sent across a network in particular
  # formats. This method returns +true+ when the MIME::Type encoding is set
  # to <tt>base64</tt>.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#485
  def binary?; end

  # Returns +true+ if the MIME::Type specifies an extension list,
  # indicating that it is a complete MIME::Type.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#502
  def complete?; end

  # Returns the whole MIME content-type string.
  #
  # The content type is a presentation value from the MIME type registry and
  # should not be used for comparison. The case of the content type is
  # preserved, and extension markers (<tt>x-</tt>) are kept.
  #
  #   text/plain        => text/plain
  #   x-chemical/x-pdb  => x-chemical/x-pdb
  #   audio/QCELP       => audio/QCELP
  #
  # source://mime-types//lib/mime/type.rb#285
  def content_type; end

  # Returns the default encoding for the MIME::Type based on the media type.
  #
  # source://mime-types//lib/mime/type.rb#391
  def default_encoding; end

  # The documentation for this MIME::Type.
  #
  # source://mime-types//lib/mime/type.rb#415
  def docs; end

  # The documentation for this MIME::Type.
  #
  # source://mime-types//lib/mime/type.rb#415
  def docs=(_arg0); end

  # Populates the +coder+ with attributes about this record for
  # serialization. The structure of +coder+ should match the structure used
  # with #init_with.
  #
  # This method should be considered a private implementation detail.
  #
  # source://mime-types//lib/mime/type.rb#536
  def encode_with(coder); end

  # Returns the value of attribute encoding.
  #
  # source://mime-types//lib/mime/type.rb#377
  def encoding; end

  # source://mime-types//lib/mime/type.rb#380
  def encoding=(enc); end

  # Returns +true+ if the +other+ object is a MIME::Type and the content types
  # match.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#246
  def eql?(other); end

  # The list of extensions which are known to be used for this MIME::Type.
  # Non-array values will be coerced into an array with #to_a. Array values
  # will be flattened, +nil+ values removed, and made unique.
  #
  # :attr_accessor: extensions
  #
  # source://mime-types//lib/mime/type.rb#324
  def extensions; end

  # source://mime-types//lib/mime/type.rb#329
  def extensions=(value); end

  # A friendly short description for this MIME::Type.
  #
  # call-seq:
  #   text_plain.friendly         # => "Text File"
  #   text_plain.friendly("en")   # => "Text File"
  #
  # source://mime-types//lib/mime/type.rb#422
  def friendly(lang = T.unsafe(nil)); end

  # Returns a hash based on the #simplified value.
  #
  # This maintains the invariant that two #eql? instances must have the same
  # #hash (although having the same #hash does *not* imply that the objects are
  # #eql?).
  #
  # To see why, suppose a MIME::Type instance +a+ is compared to another object
  # +b+, and that <code>a.eql?(b)</code> is true. By the definition of #eql?,
  # we know the following:
  #
  # 1. +b+ is a MIME::Type instance itself.
  # 2. <code>a == b</code> is true.
  #
  # Due to the first point, we know that +b+ should respond to the #simplified
  # method. Thus, per the definition of #<=>, we know that +a.simplified+ must
  # be equal to +b.simplified+, as compared by the <=> method corresponding to
  # +a.simplified+.
  #
  # Presumably, if <code>a.simplified <=> b.simplified</code> is +0+, then
  # +a.simplified+ has the same hash as +b.simplified+. So we assume it is
  # suitable for #hash to delegate to #simplified in service of the #eql?
  # invariant.
  #
  # source://mime-types//lib/mime/type.rb#272
  def hash; end

  # A key suitable for use as a lookup key for translations, such as with
  # the I18n library.
  #
  # call-seq:
  #    text_plain.i18n_key # => "text.plain"
  #    3gpp_xml.i18n_key   # => "application.vnd-3gpp-bsf-xml"
  #      # from application/vnd.3gpp.bsf+xml
  #    x_msword.i18n_key   # => "application.word"
  #      # from application/x-msword
  #
  # source://mime-types//lib/mime/type.rb#447
  def i18n_key; end

  # Initialize an empty object from +coder+, which must contain the
  # attributes necessary for initializing an empty object.
  #
  # This method should be considered a private implementation detail.
  #
  # source://mime-types//lib/mime/type.rb#565
  def init_with(coder); end

  # source://mime-types//lib/mime/type.rb#581
  def inspect; end

  # Indicates that a MIME type is like another type. This differs from
  # <tt>==</tt> because <tt>x-</tt> prefixes are removed for this comparison.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#174
  def like?(other); end

  # Returns the media type of the simplified MIME::Type.
  #
  #   text/plain        => text
  #   x-chemical/x-pdb  => x-chemical
  #   audio/QCELP       => audio
  #
  # source://mime-types//lib/mime/type.rb#298
  def media_type; end

  # Returns +true+ if the media type is obsolete.
  #
  # source://mime-types//lib/mime/type.rb#411
  def obsolete; end

  # Returns +true+ if the media type is obsolete.
  #
  # source://mime-types//lib/mime/type.rb#411
  def obsolete=(_arg0); end

  # Returns +true+ if the media type is obsolete.
  #
  # source://mime-types//lib/mime/type.rb#411
  def obsolete?; end

  # source://mime-types//lib/mime/type.rb#350
  def preferred_extension; end

  # source://mime-types//lib/mime/type.rb#355
  def preferred_extension=(value); end

  # Compares the +other+ MIME::Type based on how reliable it is before doing a
  # normal <=> comparison. Used by MIME::Types#[] to sort types. The
  # comparisons involved are:
  #
  # 1. self.simplified <=> other.simplified (ensures that we
  #    do not try to compare different types)
  # 2. IANA-registered definitions < other definitions.
  # 3. Complete definitions < incomplete definitions.
  # 4. Current definitions < obsolete definitions.
  # 5. Obselete with use-instead names < obsolete without.
  # 6. Obsolete use-instead definitions are compared.
  #
  # While this method is public, its use is strongly discouraged by consumers
  # of mime-types. In mime-types 3, this method is likely to see substantial
  # revision and simplification to ensure current registered content types sort
  # before unregistered or obsolete content types.
  #
  # source://mime-types//lib/mime/type.rb#218
  def priority_compare(other); end

  # Indicates whether the MIME type's registration with IANA is provisional.
  #
  # source://mime-types//lib/mime/type.rb#475
  def provisional; end

  # Indicates whether the MIME type's registration with IANA is provisional.
  #
  # source://mime-types//lib/mime/type.rb#475
  def provisional=(_arg0); end

  # Indicates whether the MIME type's registration with IANA is provisional.
  #
  # @return [Boolean]
  #
  # source://mime-types//lib/mime/type.rb#478
  def provisional?; end

  # Returns the media type of the unmodified MIME::Type.
  #
  #   text/plain        => text
  #   x-chemical/x-pdb  => x-chemical
  #   audio/QCELP       => audio
  #
  # source://mime-types//lib/mime/type.rb#304
  def raw_media_type; end

  # Returns the media type of the unmodified MIME::Type.
  #
  #   text/plain        => plain
  #   x-chemical/x-pdb  => x-pdb
  #   audio/QCELP       => qcelp
  #
  # source://mime-types//lib/mime/type.rb#316
  def raw_sub_type; end

  # Indicates whether the MIME type has been registered with IANA.
  #
  # source://mime-types//lib/mime/type.rb#471
  def registered; end

  # Indicates whether the MIME type has been registered with IANA.
  #
  # source://mime-types//lib/mime/type.rb#471
  def registered=(_arg0); end

  # Indicates whether the MIME type has been registered with IANA.
  #
  # source://mime-types//lib/mime/type.rb#471
  def registered?; end

  # Indicateswhether the MIME type is declared as a signature type.
  #
  # source://mime-types//lib/mime/type.rb#497
  def signature; end

  # Indicateswhether the MIME type is declared as a signature type.
  #
  # source://mime-types//lib/mime/type.rb#497
  def signature=(_arg0); end

  # Indicateswhether the MIME type is declared as a signature type.
  #
  # source://mime-types//lib/mime/type.rb#497
  def signature?; end

  # A simplified form of the MIME content-type string, suitable for
  # case-insensitive comparison, with the content_type converted to lowercase.
  #
  #   text/plain        => text/plain
  #   x-chemical/x-pdb  => x-chemical/x-pdb
  #   audio/QCELP       => audio/qcelp
  #
  # source://mime-types//lib/mime/type.rb#292
  def simplified; end

  # Returns the sub-type of the simplified MIME::Type.
  #
  #   text/plain        => plain
  #   x-chemical/x-pdb  => pdb
  #   audio/QCELP       => QCELP
  #
  # source://mime-types//lib/mime/type.rb#310
  def sub_type; end

  # Converts the MIME::Type to a hash. The output of this method can also be
  # used to initialize a MIME::Type.
  #
  # source://mime-types//lib/mime/type.rb#527
  def to_h; end

  # Converts the MIME::Type to a JSON string.
  #
  # source://mime-types//lib/mime/type.rb#520
  def to_json(*args); end

  # Returns the MIME::Type as a string.
  #
  # source://mime-types//lib/mime/type.rb#507
  def to_s; end

  # Returns the MIME::Type as a string for implicit conversions. This allows
  # MIME::Type objects to appear on either side of a comparison.
  #
  #   "text/plain" == MIME::Type.new("content-type" => "text/plain")
  #
  # source://mime-types//lib/mime/type.rb#515
  def to_str; end

  # source://mime-types//lib/mime/type.rb#403
  def use_instead; end

  # Sets the attribute use_instead
  #
  # @param value the value to set the attribute use_instead to.
  #
  # source://mime-types//lib/mime/type.rb#408
  def use_instead=(_arg0); end

  # The decoded cross-reference URL list for this MIME::Type.
  #
  # source://mime-types//lib/mime/type.rb#463
  def xref_urls; end

  # Returns the value of attribute xrefs.
  #
  # source://mime-types//lib/mime/type.rb#455
  def xrefs; end

  # source://mime-types//lib/mime/type.rb#458
  def xrefs=(xrefs); end

  private

  # source://mime-types//lib/mime/type.rb#634
  def content_type=(type_string); end

  # MRI 2.2 and older do not have a method for string interning,
  # so we simply freeze them for keeping a similar interface
  #
  # source://mime-types//lib/mime/type.rb#651
  def intern_string(string); end

  # source://mime-types//lib/mime/type.rb#662
  def xref_map(values, helper); end

  # source://mime-types//lib/mime/type.rb#670
  def xref_url_for_draft(value); end

  # source://mime-types//lib/mime/type.rb#678
  def xref_url_for_person(value); end

  # source://mime-types//lib/mime/type.rb#666
  def xref_url_for_rfc(value); end

  # source://mime-types//lib/mime/type.rb#674
  def xref_url_for_rfc_errata(value); end

  # source://mime-types//lib/mime/type.rb#682
  def xref_url_for_template(value); end

  class << self
    # Converts a provided +content_type+ into a translation key suitable for
    # use with the I18n library.
    #
    # source://mime-types//lib/mime/type.rb#601
    def i18n_key(content_type); end

    # Return a +MatchData+ object of the +content_type+ against pattern of
    # media types.
    #
    # source://mime-types//lib/mime/type.rb#609
    def match(content_type); end

    # MIME media types are case-insensitive, but are typically presented in a
    # case-preserving format in the type registry. This method converts
    # +content_type+ to lowercase.
    #
    # In previous versions of mime-types, this would also remove any extension
    # prefix (<tt>x-</tt>). This is no longer default behaviour, but may be
    # provided by providing a truth value to +remove_x_prefix+.
    #
    # source://mime-types//lib/mime/type.rb#595
    def simplified(content_type, remove_x_prefix: T.unsafe(nil)); end

    private

    # source://mime-types//lib/mime/type.rb#620
    def simplify_matchdata(matchdata, remove_x = T.unsafe(nil), joiner: T.unsafe(nil)); end
  end
end

# source://mime-types//lib/mime/type.rb#114
MIME::Type::ASCII_ENCODINGS = T.let(T.unsafe(nil), Array)

# source://mime-types//lib/mime/type.rb#113
MIME::Type::BINARY_ENCODINGS = T.let(T.unsafe(nil), Array)

# A version of MIME::Type that works hand-in-hand with a MIME::Types::Columnar
# container to load data by columns.
#
# When a field is has not yet been loaded, that data will be loaded for all
# types in the container before forwarding the message to MIME::Type.
#
# More information can be found in MIME::Types::Columnar.
#
# MIME::Type::Columnar is *not* intended to be created except by
# MIME::Types::Columnar containers.
#
# source://mime-types//lib/mime/type/columnar.rb#15
class MIME::Type::Columnar < ::MIME::Type
  # @return [Columnar] a new instance of Columnar
  #
  # source://mime-types//lib/mime/type/columnar.rb#16
  def initialize(container, content_type, extensions); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def docs(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def docs=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#43
  def encode_with(coder); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def encoding(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def encoding=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def friendly(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def obsolete(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def obsolete=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def obsolete?(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def preferred_extension(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def preferred_extension=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def provisional(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def provisional=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def provisional?(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def registered(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def registered=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def registered?(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def signature(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def signature=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def signature?(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def use_instead(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def use_instead=(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def xref_urls(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def xrefs(*args); end

  # source://mime-types//lib/mime/type/columnar.rb#27
  def xrefs=(*args); end
end

# source://mime-types//lib/mime/type.rb#112
MIME::Type::I18N_RE = T.let(T.unsafe(nil), Regexp)

# Reflects a MIME content-type specification that is not correctly
# formatted (it is not +type+/+subtype+).
#
# source://mime-types//lib/mime/type.rb#72
class MIME::Type::InvalidContentType < ::ArgumentError
  # :stopdoc:
  #
  # @return [InvalidContentType] a new instance of InvalidContentType
  #
  # source://mime-types//lib/mime/type.rb#74
  def initialize(type_string); end

  # source://mime-types//lib/mime/type.rb#78
  def to_s; end
end

# Reflects an unsupported MIME encoding.
#
# source://mime-types//lib/mime/type.rb#85
class MIME::Type::InvalidEncoding < ::ArgumentError
  # :stopdoc:
  #
  # @return [InvalidEncoding] a new instance of InvalidEncoding
  #
  # source://mime-types//lib/mime/type.rb#87
  def initialize(encoding); end

  # source://mime-types//lib/mime/type.rb#91
  def to_s; end
end

# source://mime-types//lib/mime/type.rb#111
MIME::Type::MEDIA_TYPE_RE = T.let(T.unsafe(nil), Regexp)

# The released version of the mime-types library.
#
# source://mime-types//lib/mime/type.rb#98
MIME::Type::VERSION = T.let(T.unsafe(nil), String)

# MIME::Types is a registry of MIME types. It is both a class (created with
# MIME::Types.new) and a default registry (loaded automatically or through
# interactions with MIME::Types.[] and MIME::Types.type_for).
#
# == The Default mime-types Registry
#
# The default mime-types registry is loaded automatically when the library
# is required (<tt>require 'mime/types'</tt>), but it may be lazily loaded
# (loaded on first use) with the use of the environment variable
# +RUBY_MIME_TYPES_LAZY_LOAD+ having any value other than +false+. The
# initial startup is about 14× faster (~10 ms vs ~140 ms), but the
# registry will be loaded at some point in the future.
#
# The default mime-types registry can also be loaded from a Marshal cache
# file specific to the version of MIME::Types being loaded. This will be
# handled automatically with the use of a file referred to in the
# environment variable +RUBY_MIME_TYPES_CACHE+. MIME::Types will attempt to
# load the registry from this cache file (MIME::Type::Cache.load); if it
# cannot be loaded (because the file does not exist, there is an error, or
# the data is for a different version of mime-types), the default registry
# will be loaded from the normal JSON version and then the cache file will
# be *written* to the location indicated by +RUBY_MIME_TYPES_CACHE+. Cache
# file loads just over 4½× faster (~30 ms vs ~140 ms).
# loads.
#
# Notes:
# * The loading of the default registry is *not* atomic; when using a
#   multi-threaded environment, it is recommended that lazy loading is not
#   used and mime-types is loaded as early as possible.
# * Cache files should be specified per application in a multiprocess
#   environment and should be initialized during deployment or before
#   forking to minimize the chance that the multiple processes will be
#   trying to write to the same cache file at the same time, or that two
#   applications that are on different versions of mime-types would be
#   thrashing the cache.
# * Unless cache files are preinitialized, the application using the
#   mime-types cache file must have read/write permission to the cache file.
#
# == Usage
#  require 'mime/types'
#
#  plaintext = MIME::Types['text/plain']
#  print plaintext.media_type           # => 'text'
#  print plaintext.sub_type             # => 'plain'
#
#  puts plaintext.extensions.join(" ")  # => 'asc txt c cc h hh cpp'
#
#  puts plaintext.encoding              # => 8bit
#  puts plaintext.binary?               # => false
#  puts plaintext.ascii?                # => true
#  puts plaintext.obsolete?             # => false
#  puts plaintext.registered?           # => true
#  puts plaintext.provisional?          # => false
#  puts plaintext == 'text/plain'       # => true
#  puts MIME::Type.simplified('x-appl/x-zip') # => 'appl/zip'
#
# source://mime-types//lib/mime/types.rb#6
class MIME::Types
  include ::Enumerable
  extend ::Enumerable

  # Creates a new MIME::Types registry.
  #
  # @return [Types] a new instance of Types
  #
  # source://mime-types//lib/mime/types.rb#75
  def initialize; end

  # Returns a list of MIME::Type objects, which may be empty. The optional
  # flag parameters are <tt>:complete</tt> (finds only complete MIME::Type
  # objects) and <tt>:registered</tt> (finds only MIME::Types that are
  # registered). It is possible for multiple matches to be returned for
  # either type (in the example below, 'text/plain' returns two values --
  # one for the general case, and one for VMS systems).
  #
  #   puts "\nMIME::Types['text/plain']"
  #   MIME::Types['text/plain'].each { |t| puts t.to_a.join(", ") }
  #
  #   puts "\nMIME::Types[/^image/, complete: true]"
  #   MIME::Types[/^image/, :complete => true].each do |t|
  #     puts t.to_a.join(", ")
  #   end
  #
  # If multiple type definitions are returned, returns them sorted as
  # follows:
  #   1. Complete definitions sort before incomplete ones;
  #   2. IANA-registered definitions sort before LTSW-recorded
  #      definitions.
  #   3. Current definitions sort before obsolete ones;
  #   4. Obsolete definitions with use-instead clauses sort before those
  #      without;
  #   5. Obsolete definitions use-instead clauses are compared.
  #   6. Sort on name.
  #
  # source://mime-types//lib/mime/types.rb#125
  def [](type_id, complete: T.unsafe(nil), registered: T.unsafe(nil)); end

  # Add one or more MIME::Type objects to the set of known types. If the
  # type is already known, a warning will be displayed.
  #
  # The last parameter may be the value <tt>:silent</tt> or +true+ which
  # will suppress duplicate MIME type warnings.
  #
  # source://mime-types//lib/mime/types.rb#167
  def add(*types); end

  # Add a single MIME::Type object to the set of known types. If the +type+ is
  # already known, a warning will be displayed. The +quiet+ parameter may be a
  # truthy value to suppress that warning.
  #
  # source://mime-types//lib/mime/types.rb#188
  def add_type(type, quiet = T.unsafe(nil)); end

  # Returns the number of known type variants.
  #
  # source://mime-types//lib/mime/types.rb#81
  def count; end

  # Iterates through the type variants.
  #
  # source://mime-types//lib/mime/types.rb#90
  def each; end

  # source://mime-types//lib/mime/types.rb#85
  def inspect; end

  # Return the list of MIME::Types which belongs to the file based on its
  # filename extension. If there is no extension, the filename will be used
  # as the matching criteria on its own.
  #
  # This will always return a merged, flatten, priority sorted, unique array.
  #
  #   puts MIME::Types.type_for('citydesk.xml')
  #     => [application/xml, text/xml]
  #   puts MIME::Types.type_for('citydesk.gif')
  #     => [image/gif]
  #   puts MIME::Types.type_for(%w(citydesk.xml citydesk.gif))
  #     => [application/xml, image/gif, text/xml]
  #
  # source://mime-types//lib/mime/types.rb#153
  def of(filename); end

  # Return the list of MIME::Types which belongs to the file based on its
  # filename extension. If there is no extension, the filename will be used
  # as the matching criteria on its own.
  #
  # This will always return a merged, flatten, priority sorted, unique array.
  #
  #   puts MIME::Types.type_for('citydesk.xml')
  #     => [application/xml, text/xml]
  #   puts MIME::Types.type_for('citydesk.gif')
  #     => [image/gif]
  #   puts MIME::Types.type_for(%w(citydesk.xml citydesk.gif))
  #     => [application/xml, image/gif, text/xml]
  #
  # source://mime-types//lib/mime/types.rb#153
  def type_for(filename); end

  private

  # source://mime-types//lib/mime/types.rb#201
  def add_type_variant!(mime_type); end

  # source://mime-types//lib/mime/types.rb#211
  def index_extensions!(mime_type); end

  # source://mime-types//lib/mime/types.rb#221
  def match(pattern); end

  # source://mime-types//lib/mime/types.rb#215
  def prune_matches(matches, complete, registered); end

  # source://mime-types//lib/mime/types.rb#205
  def reindex_extensions!(mime_type); end

  class << self
    # MIME::Types#[] against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#16
    def [](type_id, complete: T.unsafe(nil), registered: T.unsafe(nil)); end

    # MIME::Types#add against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#41
    def add(*types); end

    # MIME::Types#count against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#21
    def count; end

    # Used to mark a method as deprecated in the mime-types interface.
    #
    # source://mime-types//lib/mime/types/deprecations.rb#7
    def deprecated(options = T.unsafe(nil), &block); end

    # MIME::Types#each against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#26
    def each; end

    # Configure the MIME::Types logger. This defaults to an instance of a
    # logger that passes messages (unformatted) through to Kernel#warn.
    #
    # source://mime-types//lib/mime/types/logger.rb#12
    def logger; end

    # Configure the MIME::Types logger. This defaults to an instance of a
    # logger that passes messages (unformatted) through to Kernel#warn.
    #
    # source://mime-types//lib/mime/types/logger.rb#12
    def logger=(_arg0); end

    # source://mime-types//lib/mime/types/registry.rb#9
    def new(*_arg0); end

    # MIME::Types#type_for against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#35
    def of(filename); end

    # MIME::Types#type_for against the default MIME::Types registry.
    #
    # source://mime-types//lib/mime/types/registry.rb#35
    def type_for(filename); end

    private

    # @return [Boolean]
    #
    # source://mime-types//lib/mime/types/deprecations.rb#50
    def __deprecation_logged?(message, once); end

    # source://mime-types//lib/mime/types/registry.rb#77
    def __instances__; end

    # source://mime-types//lib/mime/types/registry.rb#57
    def __types__; end

    # @return [Boolean]
    #
    # source://mime-types//lib/mime/types/registry.rb#47
    def lazy_load?; end

    # source://mime-types//lib/mime/types/registry.rb#67
    def load_default_mime_types(mode = T.unsafe(nil)); end

    # source://mime-types//lib/mime/types/registry.rb#62
    def load_mode; end

    # source://mime-types//lib/mime/types/registry.rb#81
    def reindex_extensions(type); end
  end
end

# Caching of MIME::Types registries is advisable if you will be loading
# the default registry relatively frequently. With the class methods on
# MIME::Types::Cache, any MIME::Types registry can be marshaled quickly
# and easily.
#
# The cache is invalidated on a per-data-version basis; a cache file for
# version 3.2015.1118 will not be reused with version 3.2015.1201.
#
# source://mime-types//lib/mime/types/cache.rb#3
class MIME::Types::Cache < ::Struct
  def data; end
  def data=(_); end
  def version; end
  def version=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end

    # Attempts to load the cache from the file provided as a parameter or in
    # the environment variable +RUBY_MIME_TYPES_CACHE+. Returns +nil+ if the
    # file does not exist, if the file cannot be loaded, or if the data in
    # the cache version is different than this version.
    #
    # source://mime-types//lib/mime/types/cache.rb#17
    def load(cache_file = T.unsafe(nil)); end

    def members; end
    def new(*_arg0); end

    # Attempts to save the types provided to the cache file provided.
    #
    # If +types+ is not provided or is +nil+, the cache will contain the
    # current MIME::Types default registry.
    #
    # If +cache_file+ is not provided or is +nil+, the cache will be written
    # to the file specified in the environment variable
    # +RUBY_MIME_TYPES_CACHE+. If there is no cache file specified either
    # directly or through the environment, this method will return +nil+
    #
    # source://mime-types//lib/mime/types/cache.rb#46
    def save(types = T.unsafe(nil), cache_file = T.unsafe(nil)); end
  end
end

# MIME::Types::Columnar is used to extend a MIME::Types container to load data
# by columns instead of from JSON or YAML. Column loads of MIME types loaded
# through the columnar store are synchronized with a Mutex.
#
# MIME::Types::Columnar is not intended to be used directly, but will be added
# to an instance of MIME::Types when it is loaded with
# MIME::Types::Loader#load_columnar.
#
# source://mime-types//lib/mime/types/_columnar.rb#12
module MIME::Types::Columnar
  # Load the first column data file (type and extensions).
  #
  # source://mime-types//lib/mime/types/_columnar.rb#22
  def load_base_data(path); end

  private

  # source://mime-types//lib/mime/types/_columnar.rb#122
  def arr(line); end

  # source://mime-types//lib/mime/types/_columnar.rb#110
  def dict(line, array: T.unsafe(nil)); end

  # source://mime-types//lib/mime/types/_columnar.rb#41
  def each_file_line(name, lookup = T.unsafe(nil)); end

  # source://mime-types//lib/mime/types/_columnar.rb#134
  def flag(line); end

  # source://mime-types//lib/mime/types/_columnar.rb#70
  def load_docs; end

  # source://mime-types//lib/mime/types/_columnar.rb#63
  def load_encoding; end

  # source://mime-types//lib/mime/types/_columnar.rb#82
  def load_flags; end

  # source://mime-types//lib/mime/types/_columnar.rb#98
  def load_friendly; end

  # source://mime-types//lib/mime/types/_columnar.rb#76
  def load_preferred_extension; end

  # source://mime-types//lib/mime/types/_columnar.rb#104
  def load_use_instead; end

  # source://mime-types//lib/mime/types/_columnar.rb#92
  def load_xrefs; end

  # source://mime-types//lib/mime/types/_columnar.rb#130
  def opt(line); end

  class << self
    # source://mime-types//lib/mime/types/_columnar.rb#15
    def extended(obj); end
  end
end

# source://mime-types//lib/mime/types/_columnar.rb#13
MIME::Types::Columnar::LOAD_MUTEX = T.let(T.unsafe(nil), Thread::Mutex)

# MIME::Types requires a serializable keyed container that returns an empty Set
# on a key miss. Hash#default_value cannot be used because, while it traverses
# the Marshal format correctly, it will not survive any other serialization
# format (plus, a default of a mutable object resuls in a shared mess).
# Hash#default_proc cannot be used without a wrapper because it prevents
# Marshal serialization (and does not survive the round-trip).
#
# source://mime-types//lib/mime/types/container.rb#12
class MIME::Types::Container
  extend ::Forwardable

  # @return [Container] a new instance of Container
  #
  # source://mime-types//lib/mime/types/container.rb#15
  def initialize(hash = T.unsafe(nil)); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def ==(*args, **_arg1, &block); end

  # source://mime-types//lib/mime/types/container.rb#20
  def [](key); end

  # source://mime-types//lib/mime/types/container.rb#24
  def []=(key, value); end

  # source://mime-types//lib/mime/types/container.rb#61
  def add(key, value); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def count(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def each(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def each_value(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def empty?(*args, **_arg1, &block); end

  # source://mime-types//lib/mime/types/container.rb#73
  def encode_with(coder); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def flat_map(*args, **_arg1, &block); end

  # source://mime-types//lib/mime/types/container.rb#77
  def init_with(coder); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def keys(*args, **_arg1, &block); end

  # source://mime-types//lib/mime/types/container.rb#65
  def marshal_dump; end

  # source://mime-types//lib/mime/types/container.rb#69
  def marshal_load(hash); end

  # source://mime-types//lib/mime/types/container.rb#34
  def merge(other); end

  # source://mime-types//lib/mime/types/container.rb#38
  def merge!(other); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def select(*args, **_arg1, &block); end

  # source://mime-types//lib/mime/types/container.rb#46
  def to_hash; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def values(*args, **_arg1, &block); end

  protected

  # Returns the value of attribute container.
  #
  # source://mime-types//lib/mime/types/container.rb#84
  def container; end

  # Sets the attribute container
  #
  # @param value the value to set the attribute container to.
  #
  # source://mime-types//lib/mime/types/container.rb#84
  def container=(_arg0); end

  # source://mime-types//lib/mime/types/container.rb#86
  def normalize; end
end

# source://mime-types//lib/mime/types/container.rb#94
MIME::Types::Container::EMPTY_SET = T.let(T.unsafe(nil), Set)

# This class is responsible for initializing the MIME::Types registry from
# the data files supplied with the mime-types library.
#
# The Loader will use one of the following paths:
# 1.  The +path+ provided in its constructor argument;
# 2.  The value of ENV["RUBY_MIME_TYPES_DATA"]; or
# 3.  The value of MIME::Types::Data::PATH.
#
# When #load is called, the +path+ will be searched recursively for all YAML
# (.yml or .yaml) files. By convention, there is one file for each media
# type (application.yml, audio.yml, etc.), but this is not required.
#
# source://mime-types//lib/mime/types/loader.rb#22
class MIME::Types::Loader
  # Creates a Loader object that can be used to load MIME::Types registries
  # into memory, using YAML, JSON, or Columnar registry format loaders.
  #
  # @return [Loader] a new instance of Loader
  #
  # source://mime-types//lib/mime/types/loader.rb#31
  def initialize(path = T.unsafe(nil), container = T.unsafe(nil)); end

  # The MIME::Types container instance that will be loaded. If not provided
  # at initialization, a new MIME::Types instance will be constructed.
  #
  # source://mime-types//lib/mime/types/loader.rb#27
  def container; end

  # Loads a MIME::Types registry. Loads from JSON files by default
  # (#load_json).
  #
  # This will load from columnar files (#load_columnar) if <tt>columnar:
  # true</tt> is provided in +options+ and there are columnar files in +path+.
  #
  # source://mime-types//lib/mime/types/loader.rb#82
  def load(options = T.unsafe(nil)); end

  # Loads a MIME::Types registry from columnar files recursively found in
  # +path+.
  #
  # source://mime-types//lib/mime/types/loader.rb#69
  def load_columnar; end

  # Loads a MIME::Types registry from JSON files (<tt>*.json</tt>)
  # recursively found in +path+.
  #
  # It is expected that the JSON objects will be an array of hash objects.
  # The JSON format is the registry format for the MIME types registry
  # shipped with the mime-types library.
  #
  # source://mime-types//lib/mime/types/loader.rb#59
  def load_json; end

  # Loads a MIME::Types registry from YAML files (<tt>*.yml</tt> or
  # <tt>*.yaml</tt>) recursively found in +path+.
  #
  # It is expected that the YAML objects contained within the registry array
  # will be tagged as <tt>!ruby/object:MIME::Type</tt>.
  #
  # Note that the YAML format is about 2½ times *slower* than the JSON format.
  #
  # NOTE: The purpose of this format is purely for maintenance reasons.
  #
  # source://mime-types//lib/mime/types/loader.rb#46
  def load_yaml; end

  # The path that will be read for the MIME::Types files.
  #
  # source://mime-types//lib/mime/types/loader.rb#24
  def path; end

  private

  # source://mime-types//lib/mime/types/loader.rb#156
  def columnar_path; end

  # source://mime-types//lib/mime/types/loader.rb#152
  def json_path; end

  # source://mime-types//lib/mime/types/loader.rb#148
  def yaml_path; end

  class << self
    # Loads the default MIME::Type registry.
    #
    # source://mime-types//lib/mime/types/loader.rb#92
    def load(options = T.unsafe(nil)); end

    # Loads MIME::Types from a single JSON file.
    #
    # It is expected that the JSON objects will be an array of hash objects.
    # The JSON format is the registry format for the MIME types registry
    # shipped with the mime-types library.
    #
    # source://mime-types//lib/mime/types/loader.rb#126
    def load_from_json(filename); end

    # Loads MIME::Types from a single YAML file.
    #
    # It is expected that the YAML objects contained within the registry
    # array will be tagged as <tt>!ruby/object:MIME::Type</tt>.
    #
    # Note that the YAML format is about 2½ times *slower* than the JSON
    # format.
    #
    # NOTE: The purpose of this format is purely for maintenance reasons.
    #
    # source://mime-types//lib/mime/types/loader.rb#105
    def load_from_yaml(filename); end

    private

    # @return [Boolean]
    #
    # source://mime-types//lib/mime/types/loader.rb#137
    def old_yaml?; end

    # source://mime-types//lib/mime/types/loader.rb#133
    def read_file(filename); end
  end
end

# The release version of Ruby MIME::Types
#
# source://mime-types//lib/mime/types.rb#70
MIME::Types::VERSION = T.let(T.unsafe(nil), String)

# source://mime-types//lib/mime/types/logger.rb#15
class MIME::Types::WarnLogger < ::Logger
  # @return [WarnLogger] a new instance of WarnLogger
  #
  # source://mime-types//lib/mime/types/logger.rb#28
  def initialize(_one, _two = T.unsafe(nil), _three = T.unsafe(nil)); end
end

# source://mime-types//lib/mime/types/logger.rb#16
class MIME::Types::WarnLogger::WarnLogDevice < ::Logger::LogDevice
  # @return [WarnLogDevice] a new instance of WarnLogDevice
  #
  # source://mime-types//lib/mime/types/logger.rb#17
  def initialize(*_arg0); end

  # source://mime-types//lib/mime/types/logger.rb#24
  def close; end

  # source://mime-types//lib/mime/types/logger.rb#20
  def write(m); end
end
