# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `mimemagic` gem.
# Please instead update this file by running `bin/tapioca gem mimemagic`.


# Mime type detection
#
# source://mimemagic//lib/mimemagic/tables.rb#7
class MimeMagic
  # Mime type by type string
  #
  # @return [MimeMagic] a new instance of MimeMagic
  #
  # source://mimemagic//lib/mimemagic.rb#15
  def initialize(type); end

  # Allow comparison with string
  #
  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#101
  def ==(other); end

  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#52
  def audio?; end

  # Returns true if type is child of parent type
  #
  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#56
  def child_of?(parent); end

  # Get mime comment
  #
  # source://mimemagic//lib/mimemagic.rb#66
  def comment; end

  # Allow comparison with string
  #
  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#101
  def eql?(other); end

  # Get string list of file extensions
  #
  # source://mimemagic//lib/mimemagic.rb#61
  def extensions; end

  # source://mimemagic//lib/mimemagic.rb#105
  def hash; end

  # Mediatype shortcuts
  #
  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#51
  def image?; end

  # Returns the value of attribute mediatype.
  #
  # source://mimemagic//lib/mimemagic.rb#12
  def mediatype; end

  # Returns the value of attribute subtype.
  #
  # source://mimemagic//lib/mimemagic.rb#12
  def subtype; end

  # Returns true if type is a text format
  #
  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#48
  def text?; end

  # Return type as string
  #
  # source://mimemagic//lib/mimemagic.rb#96
  def to_s; end

  # Returns the value of attribute type.
  #
  # source://mimemagic//lib/mimemagic.rb#12
  def type; end

  # @return [Boolean]
  #
  # source://mimemagic//lib/mimemagic.rb#53
  def video?; end

  class << self
    # Add custom mime type. Arguments:
    # * <i>type</i>: Mime type
    # * <i>options</i>: Options hash
    #
    # Option keys:
    # * <i>:extensions</i>: String list or single string of file extensions
    # * <i>:parents</i>: String list or single string of parent mime types
    # * <i>:magic</i>: Mime magic specification
    # * <i>:comment</i>: Comment string
    #
    # source://mimemagic//lib/mimemagic.rb#29
    def add(type, options); end

    # Lookup all mime types by magic content analysis.
    # This is a slower operation.
    #
    # source://mimemagic//lib/mimemagic.rb#91
    def all_by_magic(io); end

    # Lookup mime type by file extension
    #
    # source://mimemagic//lib/mimemagic.rb#71
    def by_extension(ext); end

    # Lookup mime type by magic content analysis.
    # This is a slow operation.
    #
    # source://mimemagic//lib/mimemagic.rb#84
    def by_magic(io); end

    # Lookup mime type by filename
    #
    # source://mimemagic//lib/mimemagic.rb#78
    def by_path(path); end

    # @return [Boolean]
    #
    # source://mimemagic//lib/mimemagic.rb#111
    def child?(child, parent); end

    # source://mimemagic//lib/mimemagic/tables.rb#18
    def get_matches(parent); end

    # source://mimemagic//lib/mimemagic/tables.rb#67
    def open_mime_database; end

    # source://mimemagic//lib/mimemagic/tables.rb#72
    def parse_database; end

    # Removes a mime type from the dictionary.  You might want to do this if
    # you're seeing impossible conflicts (for instance, application/x-gmc-link).
    # * <i>type</i>: The mime type to remove.  All associated extensions and magic are removed too.
    #
    # source://mimemagic//lib/mimemagic.rb#41
    def remove(type); end

    # source://mimemagic//lib/mimemagic/tables.rb#12
    def str2int(s); end

    private

    # source://mimemagic//lib/mimemagic.rb#115
    def magic_match(io, method); end

    # source://mimemagic//lib/mimemagic.rb#125
    def magic_match_io(io, matches, buffer); end
  end
end

# source://mimemagic//lib/mimemagic/tables.rb#8
MimeMagic::EXTENSIONS = T.let(T.unsafe(nil), Hash)

# source://mimemagic//lib/mimemagic/tables.rb#10
MimeMagic::MAGIC = T.let(T.unsafe(nil), Array)

# source://mimemagic//lib/mimemagic/tables.rb#9
MimeMagic::TYPES = T.let(T.unsafe(nil), Hash)

# MimeMagic version string
#
# @api public
#
# source://mimemagic//lib/mimemagic/version.rb#4
MimeMagic::VERSION = T.let(T.unsafe(nil), String)
