# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `minitest` gem.
# Please instead update this file by running `bin/tapioca gem minitest`.


# Kernel extensions for minitest
#
# source://minitest//lib/minitest/spec.rb#46
module Kernel
  private

  # Describe a series of expectations for a given target +desc+.
  #
  # Defines a test class subclassing from either Minitest::Spec or
  # from the surrounding describe's class. The surrounding class may
  # subclass Minitest::Spec manually in order to easily share code:
  #
  #     class MySpec < Minitest::Spec
  #       # ... shared code ...
  #     end
  #
  #     class TestStuff < MySpec
  #       it "does stuff" do
  #         # shared code available here
  #       end
  #       describe "inner stuff" do
  #         it "still does stuff" do
  #           # ...and here
  #         end
  #       end
  #     end
  #
  # For more information on getting started with writing specs, see:
  #
  # http://www.rubyinside.com/a-minitestspec-tutorial-elegant-spec-style-testing-that-comes-with-ruby-5354.html
  #
  # For some suggestions on how to improve your specs, try:
  #
  # https://betterspecs.org
  #
  # but do note that several items there are debatable or specific to
  # rspec.
  #
  # For more information about expectations, see Minitest::Expectations.
  #
  # source://minitest//lib/minitest/spec.rb#82
  def describe(desc, *additional_desc, &block); end
end

# :include: README.rdoc
#
# source://minitest//lib/minitest/parallel.rb#1
module Minitest
  class << self
    # Internal run method. Responsible for telling all Runnable
    # sub-classes to run.
    #
    # source://minitest//lib/minitest.rb#322
    def __run(reporter, options); end

    # A simple hook allowing you to run a block of code after everything
    # is done running. Eg:
    #
    #   Minitest.after_run { p $debugging_info }
    #
    # source://minitest//lib/minitest.rb#96
    def after_run(&block); end

    # source://minitest//lib/minitest.rb#19
    def allow_fork; end

    # source://minitest//lib/minitest.rb#19
    def allow_fork=(_arg0); end

    # Registers Minitest to run at process exit
    #
    # source://minitest//lib/minitest.rb#69
    def autorun; end

    # source://minitest//lib/minitest.rb#19
    def backtrace_filter; end

    # source://minitest//lib/minitest.rb#19
    def backtrace_filter=(_arg0); end

    # source://minitest//lib/minitest.rb#18
    def cattr_accessor(name); end

    # source://minitest//lib/minitest.rb#1215
    def clock_time; end

    # source://minitest//lib/minitest.rb#302
    def empty_run!(options); end

    # source://minitest//lib/minitest.rb#19
    def extensions; end

    # source://minitest//lib/minitest.rb#19
    def extensions=(_arg0); end

    # source://minitest//lib/minitest.rb#335
    def filter_backtrace(bt); end

    # source://minitest//lib/minitest.rb#19
    def info_signal; end

    # source://minitest//lib/minitest.rb#19
    def info_signal=(_arg0); end

    # source://minitest//lib/minitest.rb#124
    def init_plugins(options); end

    # source://minitest//lib/minitest.rb#108
    def load_plugins; end

    # source://minitest//lib/minitest.rb#19
    def parallel_executor; end

    # source://minitest//lib/minitest.rb#19
    def parallel_executor=(_arg0); end

    # source://minitest//lib/minitest.rb#142
    def process_args(args = T.unsafe(nil)); end

    # Register a plugin to be used. Does NOT require / load it.
    #
    # source://minitest//lib/minitest.rb#103
    def register_plugin(name_or_mod); end

    # source://minitest//lib/minitest.rb#19
    def reporter; end

    # source://minitest//lib/minitest.rb#19
    def reporter=(_arg0); end

    # This is the top-level run method. Everything starts from here. It
    # tells each Runnable sub-class to run, and each of those are
    # responsible for doing whatever they do.
    #
    # The overall structure of a run looks like this:
    #
    #   Minitest.autorun
    #     Minitest.run(args)
    #       Minitest.load_plugins
    #       Minitest.process_args
    #       Minitest.init_plugins
    #       Minitest.__run(reporter, options)
    #         Runnable.runnables.each
    #           runnable_klass.run(reporter, options)
    #             self.runnable_methods.each
    #               self.run_one_method(self, runnable_method, reporter)
    #                 Minitest.run_one_method(klass, runnable_method)
    #                   klass.new(runnable_method).run
    #
    # source://minitest//lib/minitest.rb#268
    def run(args = T.unsafe(nil)); end

    # source://minitest//lib/minitest.rb#1206
    def run_one_method(klass, method_name); end

    # source://minitest//lib/minitest.rb#19
    def seed; end

    # source://minitest//lib/minitest.rb#19
    def seed=(_arg0); end
  end
end

# Defines the API for Reporters. Subclass this and override whatever
# you want. Go nuts.
#
# source://minitest//lib/minitest.rb#686
class Minitest::AbstractReporter
  # @return [AbstractReporter] a new instance of AbstractReporter
  #
  # source://minitest//lib/minitest.rb#688
  def initialize; end

  # Did this run pass?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#723
  def passed?; end

  # About to start running a test. This allows a reporter to show
  # that it is starting or that we are in the middle of a test run.
  #
  # source://minitest//lib/minitest.rb#702
  def prerecord(klass, name); end

  # Output and record the result of the test. Call
  # {result#result_code}[rdoc-ref:Runnable#result_code] to get the
  # result character string. Stores the result of the run if the run
  # did not pass.
  #
  # source://minitest//lib/minitest.rb#711
  def record(result); end

  # Outputs the summary of the run.
  #
  # source://minitest//lib/minitest.rb#717
  def report; end

  # Starts reporting on the run.
  #
  # source://minitest//lib/minitest.rb#695
  def start; end

  # source://minitest//lib/minitest.rb#727
  def synchronize(&block); end
end

# Represents run failures.
#
# source://minitest//lib/minitest.rb#1019
class Minitest::Assertion < ::Exception
  # source://minitest//lib/minitest.rb#1022
  def error; end

  # Where was this run before an assertion was raised?
  #
  # source://minitest//lib/minitest.rb#1029
  def location; end

  # source://minitest//lib/minitest.rb#1037
  def result_code; end

  # source://minitest//lib/minitest.rb#1041
  def result_label; end
end

# source://minitest//lib/minitest.rb#1020
Minitest::Assertion::RE = T.let(T.unsafe(nil), Regexp)

# Minitest Assertions.  All assertion methods accept a +msg+ which is
# printed if the assertion fails.
#
# Protocol: Nearly everything here boils up to +assert+, which
# expects to be able to increment an instance accessor named
# +assertions+. This is not provided by Assertions and must be
# provided by the thing including Assertions. See Minitest::Runnable
# for an example.
#
# source://minitest//lib/minitest/assertions.rb#16
module Minitest::Assertions
  # source://minitest//lib/minitest/assertions.rb#181
  def _synchronize; end

  # source://minitest//lib/minitest/assertions.rb#194
  def _where; end

  # Fails unless +test+ is truthy.
  #
  # source://minitest//lib/minitest/assertions.rb#171
  def assert(test, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is empty.
  #
  # source://minitest//lib/minitest/assertions.rb#188
  def assert_empty(obj, msg = T.unsafe(nil)); end

  # Fails unless <tt>exp == act</tt> printing the difference between
  # the two, if possible.
  #
  # If there is no visible difference but the assertion fails, you
  # should suspect that your #== is buggy, or your inspect output is
  # missing crucial details.  For nicer structural diffing, set
  # Minitest::Test.make_my_diffs_pretty!
  #
  # For floats use assert_in_delta.
  #
  # See also: Minitest::Assertions.diff
  #
  # source://minitest//lib/minitest/assertions.rb#214
  def assert_equal(exp, act, msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails unless +exp+ and +act+ are within +delta+
  # of each other.
  #
  #   assert_in_delta Math::PI, (22.0 / 7.0), 0.01
  #
  # source://minitest//lib/minitest/assertions.rb#235
  def assert_in_delta(exp, act, delta = T.unsafe(nil), msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails unless +exp+ and +act+ have a relative
  # error less than +epsilon+.
  #
  # source://minitest//lib/minitest/assertions.rb#247
  def assert_in_epsilon(exp, act, epsilon = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails unless +collection+ includes +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#254
  def assert_includes(collection, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is an instance of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#265
  def assert_instance_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is a kind of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#276
  def assert_kind_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails unless +matcher+ <tt>=~</tt> +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#287
  def assert_match(matcher, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is nil
  #
  # source://minitest//lib/minitest/assertions.rb#299
  def assert_nil(obj, msg = T.unsafe(nil)); end

  # For testing with binary operators. Eg:
  #
  #   assert_operator 5, :<=, 4
  #
  # source://minitest//lib/minitest/assertions.rb#309
  def assert_operator(o1, op, o2 = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if stdout or stderr do not output the expected results.
  # Pass in nil if you don't care about that streams output. Pass in
  # "" if you require it to be silent. Pass in a regexp if you want
  # to pattern match.
  #
  #   assert_output(/hey/) { method_with_output }
  #
  # NOTE: this uses #capture_io, not #capture_subprocess_io.
  #
  # See also: #assert_silent
  #
  # source://minitest//lib/minitest/assertions.rb#327
  def assert_output(stdout = T.unsafe(nil), stderr = T.unsafe(nil)); end

  # Fails unless +path+ exists.
  #
  # source://minitest//lib/minitest/assertions.rb#351
  def assert_path_exists(path, msg = T.unsafe(nil)); end

  # For testing with pattern matching (only supported with Ruby 3.0 and later)
  #
  #   # pass
  #   assert_pattern { [1,2,3] => [Integer, Integer, Integer] }
  #
  #   # fail "length mismatch (given 3, expected 1)"
  #   assert_pattern { [1,2,3] => [Integer] }
  #
  # The bare <tt>=></tt> pattern will raise a NoMatchingPatternError on failure, which would
  # normally be counted as a test error. This assertion rescues NoMatchingPatternError and
  # generates a test failure. Any other exception will be raised as normal and generate a test
  # error.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest/assertions.rb#370
  def assert_pattern; end

  # For testing with predicates. Eg:
  #
  #   assert_predicate str, :empty?
  #
  # This is really meant for specs and is front-ended by assert_operator:
  #
  #   str.must_be :empty?
  #
  # source://minitest//lib/minitest/assertions.rb#391
  def assert_predicate(o1, op, msg = T.unsafe(nil)); end

  # Fails unless the block raises one of +exp+. Returns the
  # exception matched so you can check the message, attributes, etc.
  #
  # +exp+ takes an optional message on the end to help explain
  # failures and defaults to StandardError if no exception class is
  # passed. Eg:
  #
  #   assert_raises(CustomError) { method_with_custom_error }
  #
  # With custom error message:
  #
  #   assert_raises(CustomError, 'This should have raised CustomError') { method_with_custom_error }
  #
  # Using the returned object:
  #
  #   error = assert_raises(CustomError) do
  #     raise CustomError, 'This is really bad'
  #   end
  #
  #   assert_equal 'This is really bad', error.message
  #
  # source://minitest//lib/minitest/assertions.rb#418
  def assert_raises(*exp); end

  # Fails unless +obj+ responds to +meth+.
  # include_all defaults to false to match Object#respond_to?
  #
  # source://minitest//lib/minitest/assertions.rb#450
  def assert_respond_to(obj, meth, msg = T.unsafe(nil), include_all: T.unsafe(nil)); end

  # Fails unless +exp+ and +act+ are #equal?
  #
  # source://minitest//lib/minitest/assertions.rb#460
  def assert_same(exp, act, msg = T.unsafe(nil)); end

  # +send_ary+ is a receiver, message and arguments.
  #
  # Fails unless the call returns a true value
  #
  # source://minitest//lib/minitest/assertions.rb#473
  def assert_send(send_ary, m = T.unsafe(nil)); end

  # Fails if the block outputs anything to stderr or stdout.
  #
  # See also: #assert_output
  #
  # source://minitest//lib/minitest/assertions.rb#488
  def assert_silent; end

  # Fails unless the block throws +sym+
  #
  # source://minitest//lib/minitest/assertions.rb#497
  def assert_throws(sym, msg = T.unsafe(nil)); end

  # Captures $stdout and $stderr into strings:
  #
  #   out, err = capture_io do
  #     puts "Some info"
  #     warn "You did a bad thing"
  #   end
  #
  #   assert_match %r%info%, out
  #   assert_match %r%bad%, err
  #
  # NOTE: For efficiency, this method uses StringIO and does not
  # capture IO for subprocesses. Use #capture_subprocess_io for
  # that.
  #
  # source://minitest//lib/minitest/assertions.rb#538
  def capture_io; end

  # Captures $stdout and $stderr into strings, using Tempfile to
  # ensure that subprocess IO is captured as well.
  #
  #   out, err = capture_subprocess_io do
  #     system "echo Some info"
  #     system "echo You did a bad thing 1>&2"
  #   end
  #
  #   assert_match %r%info%, out
  #   assert_match %r%bad%, err
  #
  # NOTE: This method is approximately 10x slower than #capture_io so
  # only use it when you need to test the output of a subprocess.
  #
  # source://minitest//lib/minitest/assertions.rb#571
  def capture_subprocess_io; end

  # Returns a diff between +exp+ and +act+. If there is no known
  # diff command or if it doesn't make sense to diff the output
  # (single line, short output), then it simply returns a basic
  # comparison between the two.
  #
  # See +things_to_diff+ for more info.
  #
  # source://minitest//lib/minitest/assertions.rb#57
  def diff(exp, act); end

  # Returns details for exception +e+
  #
  # source://minitest//lib/minitest/assertions.rb#603
  def exception_details(e, msg); end

  # Fails after a given date (in the local time zone). This allows
  # you to put time-bombs in your tests if you need to keep
  # something around until a later date lest you forget about it.
  #
  # source://minitest//lib/minitest/assertions.rb#619
  def fail_after(y, m, d, msg); end

  # Fails with +msg+.
  #
  # source://minitest//lib/minitest/assertions.rb#626
  def flunk(msg = T.unsafe(nil)); end

  # Returns a proc that will output +msg+ along with the default message.
  #
  # source://minitest//lib/minitest/assertions.rb#634
  def message(msg = T.unsafe(nil), ending = T.unsafe(nil), &default); end

  # This returns a human-readable version of +obj+. By default
  # #inspect is called. You can override this to use #pretty_inspect
  # if you want.
  #
  # See Minitest::Test.make_my_diffs_pretty!
  #
  # source://minitest//lib/minitest/assertions.rb#127
  def mu_pp(obj); end

  # This returns a diff-able more human-readable version of +obj+.
  # This differs from the regular mu_pp because it expands escaped
  # newlines and makes hex-values (like object_ids) generic. This
  # uses mu_pp to do the first pass and then cleans it up.
  #
  # source://minitest//lib/minitest/assertions.rb#145
  def mu_pp_for_diff(obj); end

  # used for counting assertions
  #
  # source://minitest//lib/minitest/assertions.rb#645
  def pass(_msg = T.unsafe(nil)); end

  # Fails if +test+ is truthy.
  #
  # source://minitest//lib/minitest/assertions.rb#652
  def refute(test, msg = T.unsafe(nil)); end

  # Fails if +obj+ is empty.
  #
  # source://minitest//lib/minitest/assertions.rb#660
  def refute_empty(obj, msg = T.unsafe(nil)); end

  # Fails if <tt>exp == act</tt>.
  #
  # For floats use refute_in_delta.
  #
  # source://minitest//lib/minitest/assertions.rb#671
  def refute_equal(exp, act, msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails if +exp+ is within +delta+ of +act+.
  #
  #   refute_in_delta Math::PI, (22.0 / 7.0)
  #
  # source://minitest//lib/minitest/assertions.rb#683
  def refute_in_delta(exp, act, delta = T.unsafe(nil), msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails if +exp+ and +act+ have a relative error
  # less than +epsilon+.
  #
  # source://minitest//lib/minitest/assertions.rb#695
  def refute_in_epsilon(a, b, epsilon = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if +collection+ includes +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#702
  def refute_includes(collection, obj, msg = T.unsafe(nil)); end

  # Fails if +obj+ is an instance of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#713
  def refute_instance_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails if +obj+ is a kind of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#723
  def refute_kind_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails if +matcher+ <tt>=~</tt> +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#731
  def refute_match(matcher, obj, msg = T.unsafe(nil)); end

  # Fails if +obj+ is nil.
  #
  # source://minitest//lib/minitest/assertions.rb#741
  def refute_nil(obj, msg = T.unsafe(nil)); end

  # Fails if +o1+ is not +op+ +o2+. Eg:
  #
  #   refute_operator 1, :>, 2 #=> pass
  #   refute_operator 1, :<, 2 #=> fail
  #
  # source://minitest//lib/minitest/assertions.rb#776
  def refute_operator(o1, op, o2 = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if +path+ exists.
  #
  # source://minitest//lib/minitest/assertions.rb#785
  def refute_path_exists(path, msg = T.unsafe(nil)); end

  # For testing with pattern matching (only supported with Ruby 3.0 and later)
  #
  #   # pass
  #   refute_pattern { [1,2,3] => [String] }
  #
  #   # fail "NoMatchingPatternError expected, but nothing was raised."
  #   refute_pattern { [1,2,3] => [Integer, Integer, Integer] }
  #
  # This assertion expects a NoMatchingPatternError exception, and will fail if none is raised. Any
  # other exceptions will be raised as normal and generate a test error.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest/assertions.rb#758
  def refute_pattern; end

  # For testing with predicates.
  #
  #   refute_predicate str, :empty?
  #
  # This is really meant for specs and is front-ended by refute_operator:
  #
  #   str.wont_be :empty?
  #
  # source://minitest//lib/minitest/assertions.rb#799
  def refute_predicate(o1, op, msg = T.unsafe(nil)); end

  # Fails if +obj+ responds to the message +meth+.
  # include_all defaults to false to match Object#respond_to?
  #
  # source://minitest//lib/minitest/assertions.rb#808
  def refute_respond_to(obj, meth, msg = T.unsafe(nil), include_all: T.unsafe(nil)); end

  # Fails if +exp+ is the same (by object identity) as +act+.
  #
  # source://minitest//lib/minitest/assertions.rb#817
  def refute_same(exp, act, msg = T.unsafe(nil)); end

  # Skips the current run. If run in verbose-mode, the skipped run
  # gets listed at the end of the run but doesn't cause a failure
  # exit code.
  #
  # @raise [Minitest::Skip]
  #
  # source://minitest//lib/minitest/assertions.rb#830
  def skip(msg = T.unsafe(nil), _ignored = T.unsafe(nil)); end

  # Skips the current run until a given date (in the local time
  # zone). This allows you to put some fixes on hold until a later
  # date, but still holds you accountable and prevents you from
  # forgetting it.
  #
  # source://minitest//lib/minitest/assertions.rb#842
  def skip_until(y, m, d, msg); end

  # Was this testcase skipped? Meant for #teardown.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest/assertions.rb#851
  def skipped?; end

  # Returns things to diff [expect, butwas], or [nil, nil] if nothing to diff.
  #
  # Criterion:
  #
  # 1. Strings include newlines or escaped newlines, but not both.
  # 2. or:  String lengths are > 30 characters.
  # 3. or:  Strings are equal to each other (but maybe different encodings?).
  # 4. and: we found a diff executable.
  #
  # source://minitest//lib/minitest/assertions.rb#102
  def things_to_diff(exp, act); end

  class << self
    # Returns the diff command to use in #diff. Tries to intelligently
    # figure out what diff to use.
    #
    # source://minitest//lib/minitest/assertions.rb#27
    def diff; end

    # Set the diff command to use in #diff.
    #
    # source://minitest//lib/minitest/assertions.rb#45
    def diff=(o); end
  end
end

# source://minitest//lib/minitest/assertions.rb#199
Minitest::Assertions::E = T.let(T.unsafe(nil), String)

# source://minitest//lib/minitest/assertions.rb#17
Minitest::Assertions::UNDEFINED = T.let(T.unsafe(nil), Object)

# The standard backtrace filter for minitest.
#
# See Minitest.backtrace_filter=.
#
# source://minitest//lib/minitest.rb#1174
class Minitest::BacktraceFilter
  # @return [BacktraceFilter] a new instance of BacktraceFilter
  #
  # source://minitest//lib/minitest.rb#1183
  def initialize(regexp = T.unsafe(nil)); end

  # Filter +bt+ to something useful. Returns the whole thing if
  # $DEBUG (ruby) or $MT_DEBUG (env).
  #
  # source://minitest//lib/minitest.rb#1191
  def filter(bt); end

  # The regular expression to use to filter backtraces. Defaults to +MT_RE+.
  #
  # source://minitest//lib/minitest.rb#1181
  def regexp; end

  # The regular expression to use to filter backtraces. Defaults to +MT_RE+.
  #
  # source://minitest//lib/minitest.rb#1181
  def regexp=(_arg0); end
end

# source://minitest//lib/minitest.rb#1176
Minitest::BacktraceFilter::MT_RE = T.let(T.unsafe(nil), Regexp)

# Dispatch to multiple reporters as one.
#
# source://minitest//lib/minitest.rb#968
class Minitest::CompositeReporter < ::Minitest::AbstractReporter
  # @return [CompositeReporter] a new instance of CompositeReporter
  #
  # source://minitest//lib/minitest.rb#974
  def initialize(*reporters); end

  # Add another reporter to the mix.
  #
  # source://minitest//lib/minitest.rb#986
  def <<(reporter); end

  # source://minitest//lib/minitest.rb#979
  def io; end

  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#990
  def passed?; end

  # source://minitest//lib/minitest.rb#998
  def prerecord(klass, name); end

  # source://minitest//lib/minitest.rb#1005
  def record(result); end

  # source://minitest//lib/minitest.rb#1011
  def report; end

  # The list of reporters to dispatch to.
  #
  # source://minitest//lib/minitest.rb#972
  def reporters; end

  # The list of reporters to dispatch to.
  #
  # source://minitest//lib/minitest.rb#972
  def reporters=(_arg0); end

  # source://minitest//lib/minitest.rb#994
  def start; end
end

# Compresses backtraces.
#
# source://minitest//lib/minitest/compress.rb#5
module Minitest::Compress
  # Takes a backtrace (array of strings) and compresses repeating
  # cycles in it to make it more readable.
  #
  # source://minitest//lib/minitest/compress.rb#11
  def compress(orig); end
end

# source://minitest//lib/minitest/spec.rb#41
class Minitest::Expectation < ::Struct
  def ctx; end
  def ctx=(_); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_close_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_empty(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_instance_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_kind_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_nil(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_same_as(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_silent(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_within_delta(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_be_within_epsilon(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_equal(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_include(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_output(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_pattern_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_raise(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_respond_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def must_throw(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def path_must_exist(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def path_wont_exist(*args, **_arg1); end

  def target; end
  def target=(_); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_close_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_empty(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_instance_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_kind_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_nil(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_same_as(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_within_delta(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_be_within_epsilon(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_equal(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_include(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_pattern_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#25
  def wont_respond_to(*args, **_arg1); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# It's where you hide your "assertions".
#
# Please note, because of the way that expectations are implemented,
# all expectations (eg must_equal) are dependent upon a thread local
# variable +:current_spec+. If your specs rely on mixing threads into
# the specs themselves, you're better off using assertions or the new
# _(value) wrapper. For example:
#
#     it "should still work in threads" do
#       my_threaded_thingy do
#         (1+1).must_equal 2                  # bad
#         assert_equal 2, 1+1                 # good
#         _(1 + 1).must_equal 2               # good
#         value(1 + 1).must_equal 2           # good, also #expect
#         _ { 1 + "1" }.must_raise TypeError  # good
#       end
#     end
#
# source://minitest//lib/minitest/expectations.rb#20
module Minitest::Expectations
  # source://minitest//lib/minitest/spec.rb#15
  def must_be(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_close_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_empty(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_instance_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_kind_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_nil(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_same_as(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_silent(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_within_delta(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_be_within_epsilon(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_equal(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_include(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_output(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_pattern_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_raise(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_respond_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def must_throw(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def path_must_exist(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def path_wont_exist(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_close_to(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_empty(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_instance_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_kind_of(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_nil(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_same_as(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_within_delta(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_be_within_epsilon(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_equal(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_include(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_pattern_match(*args, **_arg1); end

  # source://minitest//lib/minitest/spec.rb#15
  def wont_respond_to(*args, **_arg1); end
end

# Provides a simple set of guards that you can use in your tests
# to skip execution if it is not applicable. These methods are
# mixed into Test as both instance and class methods so you
# can use them inside or outside of the test methods.
#
#   def test_something_for_mri
#     skip "bug 1234"  if jruby?
#     # ...
#   end
#
#   if windows? then
#     # ... lots of test methods ...
#   end
#
# source://minitest//lib/minitest.rb#1118
module Minitest::Guard
  # Is this running on jruby?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1123
  def jruby?(platform = T.unsafe(nil)); end

  # Is this running on maglev?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1130
  def maglev?(platform = T.unsafe(nil)); end

  # Is this running on mri?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1140
  def mri?(platform = T.unsafe(nil)); end

  # Is this running on macOS?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1147
  def osx?(platform = T.unsafe(nil)); end

  # Is this running on rubinius?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1154
  def rubinius?(platform = T.unsafe(nil)); end

  # Is this running on windows?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1164
  def windows?(platform = T.unsafe(nil)); end
end

# source://minitest//lib/minitest/parallel.rb#2
module Minitest::Parallel; end

# The engine used to run multiple tests in parallel.
#
# source://minitest//lib/minitest/parallel.rb#7
class Minitest::Parallel::Executor
  # Create a parallel test executor of with +size+ workers.
  #
  # @return [Executor] a new instance of Executor
  #
  # source://minitest//lib/minitest/parallel.rb#17
  def initialize(size); end

  # Add a job to the queue
  #
  # source://minitest//lib/minitest/parallel.rb#43
  def <<(work); end

  # Shuts down the pool of workers by signalling them to quit and
  # waiting for them all to finish what they're currently working
  # on.
  #
  # source://minitest//lib/minitest/parallel.rb#50
  def shutdown; end

  # The size of the pool of workers.
  #
  # source://minitest//lib/minitest/parallel.rb#12
  def size; end

  # Start the executor
  #
  # source://minitest//lib/minitest/parallel.rb#26
  def start; end
end

# source://minitest//lib/minitest/parallel.rb#56
module Minitest::Parallel::Test
  # source://minitest//lib/minitest/parallel.rb#57
  def _synchronize; end
end

# source://minitest//lib/minitest/parallel.rb#59
module Minitest::Parallel::Test::ClassMethods
  # source://minitest//lib/minitest/parallel.rb#60
  def run_one_method(klass, method_name, reporter); end

  # source://minitest//lib/minitest/parallel.rb#64
  def test_order; end
end

# A very simple reporter that prints the "dots" during the run.
#
# This is added to the top-level CompositeReporter at the start of
# the run. If you want to change the output of minitest via a
# plugin, pull this out of the composite and replace it with your
# own.
#
# source://minitest//lib/minitest.rb#758
class Minitest::ProgressReporter < ::Minitest::Reporter
  # source://minitest//lib/minitest.rb#759
  def prerecord(klass, name); end

  # source://minitest//lib/minitest.rb#766
  def record(result); end
end

# Shared code for anything that can get passed to a Reporter. See
# Minitest::Test & Minitest::Result.
#
# source://minitest//lib/minitest.rb#580
module Minitest::Reportable
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#602
  def class_name; end

  # Did this run error?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#623
  def error?; end

  # The location identifier of this test. Depends on a method
  # existing called class_name.
  #
  # source://minitest//lib/minitest.rb#597
  def location; end

  # Did this run pass?
  #
  # Note: skipped runs are not considered passing, but they don't
  # cause the process to exit non-zero.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#587
  def passed?; end

  # Returns ".", "F", or "E" based on the result of the run.
  #
  # source://minitest//lib/minitest.rb#609
  def result_code; end

  # Was this run skipped?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#616
  def skipped?; end
end

# source://minitest//lib/minitest.rb#591
Minitest::Reportable::BASE_DIR = T.let(T.unsafe(nil), String)

# source://minitest//lib/minitest.rb#734
class Minitest::Reporter < ::Minitest::AbstractReporter
  # @return [Reporter] a new instance of Reporter
  #
  # source://minitest//lib/minitest.rb#743
  def initialize(io = T.unsafe(nil), options = T.unsafe(nil)); end

  # The IO used to report.
  #
  # source://minitest//lib/minitest.rb#736
  def io; end

  # The IO used to report.
  #
  # source://minitest//lib/minitest.rb#736
  def io=(_arg0); end

  # Command-line options for this run.
  #
  # source://minitest//lib/minitest.rb#741
  def options; end

  # Command-line options for this run.
  #
  # source://minitest//lib/minitest.rb#741
  def options=(_arg0); end
end

# This represents a test result in a clean way that can be
# marshalled over a wire. Tests can do anything they want to the
# test instance and can create conditions that cause Marshal.dump to
# blow up. By using Result.from(a_test) you can be reasonably sure
# that the test result can be marshalled.
#
# source://minitest//lib/minitest.rb#635
class Minitest::Result < ::Minitest::Runnable
  include ::Minitest::Reportable

  # source://minitest//lib/minitest.rb#669
  def class_name; end

  # The class name of the test result.
  #
  # source://minitest//lib/minitest.rb#644
  def klass; end

  # The class name of the test result.
  #
  # source://minitest//lib/minitest.rb#644
  def klass=(_arg0); end

  # The location of the test method.
  #
  # source://minitest//lib/minitest.rb#649
  def source_location; end

  # The location of the test method.
  #
  # source://minitest//lib/minitest.rb#649
  def source_location=(_arg0); end

  # source://minitest//lib/minitest.rb#673
  def to_s; end

  class << self
    # Create a new test result from a Runnable instance.
    #
    # source://minitest//lib/minitest.rb#654
    def from(runnable); end
  end
end

# re-open
#
# source://minitest//lib/minitest.rb#348
class Minitest::Runnable
  # @return [Runnable] a new instance of Runnable
  #
  # source://minitest//lib/minitest.rb#511
  def initialize(name); end

  # Number of assertions executed in this run.
  #
  # source://minitest//lib/minitest.rb#352
  def assertions; end

  # Number of assertions executed in this run.
  #
  # source://minitest//lib/minitest.rb#352
  def assertions=(_arg0); end

  # source://minitest//lib/minitest.rb#507
  def failure; end

  # An assertion raised during the run, if any.
  #
  # source://minitest//lib/minitest.rb#357
  def failures; end

  # An assertion raised during the run, if any.
  #
  # source://minitest//lib/minitest.rb#357
  def failures=(_arg0); end

  # source://minitest//lib/minitest.rb#493
  def marshal_dump; end

  # source://minitest//lib/minitest.rb#503
  def marshal_load(ary); end

  # Metadata you attach to the test results that get sent to the reporter.
  #
  # Lazily initializes to a hash, to keep memory down.
  #
  # NOTE: this data *must* be plain (read: marshal-able) data!
  # Hashes! Arrays! Strings!
  #
  # source://minitest//lib/minitest.rb#526
  def metadata; end

  # Sets metadata, mainly used for +Result.from+.
  #
  # source://minitest//lib/minitest.rb#533
  def metadata=(_arg0); end

  # Returns true if metadata exists.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#538
  def metadata?; end

  # Name of the run.
  #
  # source://minitest//lib/minitest.rb#375
  def name; end

  # Set the name of the run.
  #
  # source://minitest//lib/minitest.rb#382
  def name=(o); end

  # Did this run pass?
  #
  # Note: skipped runs are not considered passing, but they don't
  # cause the process to exit non-zero.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#555
  def passed?; end

  # Returns a single character string to print based on the result
  # of the run. One of <tt>"."</tt>, <tt>"F"</tt>,
  # <tt>"E"</tt> or <tt>"S"</tt>.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#564
  def result_code; end

  # Runs a single method. Needs to return self.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#545
  def run; end

  # Was this run skipped? See #passed? for more information.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#571
  def skipped?; end

  # The time it took to run.
  #
  # source://minitest//lib/minitest.rb#362
  def time; end

  # The time it took to run.
  #
  # source://minitest//lib/minitest.rb#362
  def time=(_arg0); end

  # source://minitest//lib/minitest.rb#364
  def time_it; end

  class << self
    # source://minitest//lib/minitest.rb#1225
    def inherited(klass); end

    # Returns all instance methods matching the pattern +re+.
    #
    # source://minitest//lib/minitest.rb#389
    def methods_matching(re); end

    # source://minitest//lib/minitest.rb#463
    def on_signal(name, action); end

    # source://minitest//lib/minitest.rb#393
    def reset; end

    # Responsible for running all runnable methods in a given class,
    # each in its own instance. Each instance is passed to the
    # reporter to record.
    #
    # source://minitest//lib/minitest.rb#404
    def run(reporter, options = T.unsafe(nil)); end

    # Runs a single method and has the reporter record the result.
    # This was considered internal API but is factored out of run so
    # that subclasses can specialize the running of an individual
    # test. See Minitest::ParallelTest::ClassMethods for an example.
    #
    # source://minitest//lib/minitest.rb#444
    def run_one_method(klass, method_name, reporter); end

    # Each subclass of Runnable is responsible for overriding this
    # method to return all runnable methods. See #methods_matching.
    #
    # @raise [NotImplementedError]
    #
    # source://minitest//lib/minitest.rb#480
    def runnable_methods; end

    # Returns all subclasses of Runnable.
    #
    # source://minitest//lib/minitest.rb#487
    def runnables; end

    # Defines the order to run tests (:random by default). Override
    # this or use a convenience method to change it for your tests.
    #
    # source://minitest//lib/minitest.rb#453
    def test_order; end

    # source://minitest//lib/minitest.rb#457
    def with_info_handler(reporter, &block); end
  end
end

# source://minitest//lib/minitest.rb#461
Minitest::Runnable::SIGNALS = T.let(T.unsafe(nil), Hash)

# Assertion raised when skipping a run.
#
# source://minitest//lib/minitest.rb#1049
class Minitest::Skip < ::Minitest::Assertion
  # source://minitest//lib/minitest.rb#1050
  def result_label; end
end

# Minitest::Spec -- The faster, better, less-magical spec framework!
#
# For a list of expectations, see Minitest::Expectations.
#
# source://minitest//lib/minitest/spec.rb#106
class Minitest::Spec < ::Minitest::Test
  include ::Minitest::Spec::DSL::InstanceMethods
  extend ::Minitest::Spec::DSL

  # @return [Spec] a new instance of Spec
  #
  # source://minitest//lib/minitest/spec.rb#112
  def initialize(name); end

  class << self
    # source://minitest//lib/minitest/spec.rb#108
    def current; end
  end
end

# Oh look! A Minitest::Spec::DSL module! Eat your heart out DHH.
#
# source://minitest//lib/minitest/spec.rb#120
module Minitest::Spec::DSL
  # Define an 'after' action. Inherits the way normal methods should.
  #
  # NOTE: +type+ is ignored and is only there to make porting easier.
  #
  # Equivalent to Minitest::Test#teardown.
  #
  # source://minitest//lib/minitest/spec.rb#205
  def after(_type = T.unsafe(nil), &block); end

  # Define a 'before' action. Inherits the way normal methods should.
  #
  # NOTE: +type+ is ignored and is only there to make porting easier.
  #
  # Equivalent to Minitest::Test#setup.
  #
  # source://minitest//lib/minitest/spec.rb#191
  def before(_type = T.unsafe(nil), &block); end

  # source://minitest//lib/minitest/spec.rb#174
  def children; end

  # source://minitest//lib/minitest/spec.rb#270
  def create(name, desc); end

  # source://minitest//lib/minitest/spec.rb#291
  def desc; end

  # source://minitest//lib/minitest/spec.rb#170
  def describe_stack; end

  # Define an expectation with name +desc+. Name gets morphed to a
  # proper test method name. For some freakish reason, people who
  # write specs don't like class inheritance, so this goes way out of
  # its way to make sure that expectations aren't inherited.
  #
  # This is also aliased to #specify and doesn't require a +desc+ arg.
  #
  # Hint: If you _do_ want inheritance, use minitest/test. You can mix
  # and match between assertions and expectations as much as you want.
  #
  # source://minitest//lib/minitest/spec.rb#223
  def it(desc = T.unsafe(nil), &block); end

  # Essentially, define an accessor for +name+ with +block+.
  #
  # Why use let instead of def? I honestly don't know.
  #
  # @raise [ArgumentError]
  #
  # source://minitest//lib/minitest/spec.rb#247
  def let(name, &block); end

  # source://minitest//lib/minitest/spec.rb#283
  def name; end

  # source://minitest//lib/minitest/spec.rb#178
  def nuke_test_methods!; end

  # Register a new type of spec that matches the spec's description.
  # This method can take either a Regexp and a spec class or a spec
  # class and a block that takes the description and returns true if
  # it matches.
  #
  # Eg:
  #
  #     register_spec_type(/Controller$/, Minitest::Spec::Rails)
  #
  # or:
  #
  #     register_spec_type(Minitest::Spec::RailsModel) do |desc|
  #       desc.superclass == ActiveRecord::Base
  #     end
  #
  # source://minitest//lib/minitest/spec.rb#146
  def register_spec_type(*args, &block); end

  # Figure out the spec class to use based on a spec's description. Eg:
  #
  #     spec_type("BlahController") # => Minitest::Spec::Rails
  #
  # source://minitest//lib/minitest/spec.rb#160
  def spec_type(desc, *additional); end

  # Define an expectation with name +desc+. Name gets morphed to a
  # proper test method name. For some freakish reason, people who
  # write specs don't like class inheritance, so this goes way out of
  # its way to make sure that expectations aren't inherited.
  #
  # This is also aliased to #specify and doesn't require a +desc+ arg.
  #
  # Hint: If you _do_ want inheritance, use minitest/test. You can mix
  # and match between assertions and expectations as much as you want.
  #
  # source://minitest//lib/minitest/spec.rb#223
  def specify(desc = T.unsafe(nil), &block); end

  # Another lazy man's accessor generator. Made even more lazy by
  # setting the name for you to +subject+.
  #
  # source://minitest//lib/minitest/spec.rb#266
  def subject(&block); end

  # source://minitest//lib/minitest/spec.rb#287
  def to_s; end

  class << self
    # source://minitest//lib/minitest/spec.rb#335
    def extended(obj); end
  end
end

# Rdoc... why are you so dumb?
#
# source://minitest//lib/minitest/spec.rb#297
module Minitest::Spec::DSL::InstanceMethods
  # Takes a value or a block and returns a value monad that has
  # all of Expectations methods available to it.
  #
  #   _(1 + 1).must_equal 2
  #
  # And for blocks:
  #
  #   _ { 1 + "1" }.must_raise TypeError
  #
  # This method of expectation-based testing is preferable to
  # straight-expectation methods (on Object) because it stores its
  # test context, bypassing our hacky use of thread-local variables.
  #
  # NOTE: At some point, the methods on Object will be deprecated
  # and then removed.
  #
  # It is also aliased to #value and #expect for your aesthetic
  # pleasure:
  #
  #         _(1 + 1).must_equal 2
  #     value(1 + 1).must_equal 2
  #    expect(1 + 1).must_equal 2
  #
  # source://minitest//lib/minitest/spec.rb#322
  def _(value = T.unsafe(nil), &block); end

  # source://minitest//lib/minitest/spec.rb#329
  def before_setup; end

  # Takes a value or a block and returns a value monad that has
  # all of Expectations methods available to it.
  #
  #   _(1 + 1).must_equal 2
  #
  # And for blocks:
  #
  #   _ { 1 + "1" }.must_raise TypeError
  #
  # This method of expectation-based testing is preferable to
  # straight-expectation methods (on Object) because it stores its
  # test context, bypassing our hacky use of thread-local variables.
  #
  # NOTE: At some point, the methods on Object will be deprecated
  # and then removed.
  #
  # It is also aliased to #value and #expect for your aesthetic
  # pleasure:
  #
  #         _(1 + 1).must_equal 2
  #     value(1 + 1).must_equal 2
  #    expect(1 + 1).must_equal 2
  #
  # source://minitest//lib/minitest/spec.rb#322
  def expect(value = T.unsafe(nil), &block); end

  # Takes a value or a block and returns a value monad that has
  # all of Expectations methods available to it.
  #
  #   _(1 + 1).must_equal 2
  #
  # And for blocks:
  #
  #   _ { 1 + "1" }.must_raise TypeError
  #
  # This method of expectation-based testing is preferable to
  # straight-expectation methods (on Object) because it stores its
  # test context, bypassing our hacky use of thread-local variables.
  #
  # NOTE: At some point, the methods on Object will be deprecated
  # and then removed.
  #
  # It is also aliased to #value and #expect for your aesthetic
  # pleasure:
  #
  #         _(1 + 1).must_equal 2
  #     value(1 + 1).must_equal 2
  #    expect(1 + 1).must_equal 2
  #
  # source://minitest//lib/minitest/spec.rb#322
  def value(value = T.unsafe(nil), &block); end
end

# Contains pairs of matchers and Spec classes to be used to
# calculate the superclass of a top-level describe. This allows for
# automatically customizable spec types.
#
# See: register_spec_type and spec_type
#
# source://minitest//lib/minitest/spec.rb#128
Minitest::Spec::DSL::TYPES = T.let(T.unsafe(nil), Array)

# source://minitest//lib/minitest/spec.rb#342
Minitest::Spec::TYPES = T.let(T.unsafe(nil), Array)

# A reporter that gathers statistics about a test run. Does not do
# any IO because meant to be used as a parent class for a reporter
# that does.
#
# If you want to create an entirely different type of output (eg,
# CI, HTML, etc), this is the place to start.
#
# Example:
#
#   class JenkinsCIReporter < StatisticsReporter
#     def report
#       super  # Needed to calculate some statistics
#
#       print "<testsuite "
#       print "tests='#{count}' "
#       print "failures='#{failures}' "
#       # Remaining XML...
#     end
#   end
#
# source://minitest//lib/minitest.rb#794
class Minitest::StatisticsReporter < ::Minitest::Reporter
  # @return [StatisticsReporter] a new instance of StatisticsReporter
  #
  # source://minitest//lib/minitest.rb#843
  def initialize(io = T.unsafe(nil), options = T.unsafe(nil)); end

  # Total number of assertions.
  #
  # source://minitest//lib/minitest.rb#798
  def assertions; end

  # Total number of assertions.
  #
  # source://minitest//lib/minitest.rb#798
  def assertions=(_arg0); end

  # Total number of test cases.
  #
  # source://minitest//lib/minitest.rb#803
  def count; end

  # Total number of test cases.
  #
  # source://minitest//lib/minitest.rb#803
  def count=(_arg0); end

  # Total number of tests that erred.
  #
  # source://minitest//lib/minitest.rb#831
  def errors; end

  # Total number of tests that erred.
  #
  # source://minitest//lib/minitest.rb#831
  def errors=(_arg0); end

  # Total number of tests that failed.
  #
  # source://minitest//lib/minitest.rb#826
  def failures; end

  # Total number of tests that failed.
  #
  # source://minitest//lib/minitest.rb#826
  def failures=(_arg0); end

  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#857
  def passed?; end

  # source://minitest//lib/minitest.rb#865
  def record(result); end

  # Report on the tracked statistics.
  #
  # source://minitest//lib/minitest.rb#875
  def report; end

  # An +Array+ of test cases that failed or were skipped.
  #
  # source://minitest//lib/minitest.rb#808
  def results; end

  # An +Array+ of test cases that failed or were skipped.
  #
  # source://minitest//lib/minitest.rb#808
  def results=(_arg0); end

  # Total number of tests that where skipped.
  #
  # source://minitest//lib/minitest.rb#841
  def skips; end

  # Total number of tests that where skipped.
  #
  # source://minitest//lib/minitest.rb#841
  def skips=(_arg0); end

  # source://minitest//lib/minitest.rb#861
  def start; end

  # Time the test run started. If available, the monotonic clock is
  # used and this is a +Float+, otherwise it's an instance of
  # +Time+.
  #
  # source://minitest//lib/minitest.rb#815
  def start_time; end

  # Time the test run started. If available, the monotonic clock is
  # used and this is a +Float+, otherwise it's an instance of
  # +Time+.
  #
  # source://minitest//lib/minitest.rb#815
  def start_time=(_arg0); end

  # Test run time. If available, the monotonic clock is used and
  # this is a +Float+, otherwise it's an instance of +Time+.
  #
  # source://minitest//lib/minitest.rb#821
  def total_time; end

  # Test run time. If available, the monotonic clock is used and
  # this is a +Float+, otherwise it's an instance of +Time+.
  #
  # source://minitest//lib/minitest.rb#821
  def total_time=(_arg0); end

  # Total number of tests that warned.
  #
  # source://minitest//lib/minitest.rb#836
  def warnings; end

  # Total number of tests that warned.
  #
  # source://minitest//lib/minitest.rb#836
  def warnings=(_arg0); end
end

# A reporter that prints the header, summary, and failure details at
# the end of the run.
#
# This is added to the top-level CompositeReporter at the start of
# the run. If you want to change the output of minitest via a
# plugin, pull this out of the composite and replace it with your
# own.
#
# source://minitest//lib/minitest.rb#896
class Minitest::SummaryReporter < ::Minitest::StatisticsReporter
  # source://minitest//lib/minitest.rb#929
  def aggregated_results(io); end

  # source://minitest//lib/minitest.rb#898
  def old_sync; end

  # source://minitest//lib/minitest.rb#898
  def old_sync=(_arg0); end

  # source://minitest//lib/minitest.rb#912
  def report; end

  # source://minitest//lib/minitest.rb#900
  def start; end

  # source://minitest//lib/minitest.rb#924
  def statistics; end

  # source://minitest//lib/minitest.rb#949
  def summary; end

  # source://minitest//lib/minitest.rb#897
  def sync; end

  # source://minitest//lib/minitest.rb#897
  def sync=(_arg0); end

  # source://minitest//lib/minitest.rb#945
  def to_s; end
end

# Subclass Test to create your own tests. Typically you'll want a
# Test subclass per implementation class.
#
# See Minitest::Assertions
#
# source://minitest//lib/minitest/test.rb#10
class Minitest::Test < ::Minitest::Runnable
  include ::Minitest::Assertions
  include ::Minitest::Reportable
  include ::Minitest::Test::LifecycleHooks
  include ::Minitest::Guard
  extend ::Minitest::Guard

  # LifecycleHooks
  #
  # source://minitest//lib/minitest/test.rb#189
  def capture_exceptions; end

  # source://minitest//lib/minitest/test.rb#15
  def class_name; end

  # source://minitest//lib/minitest/test.rb#206
  def neuter_exception(e); end

  # source://minitest//lib/minitest/test.rb#217
  def new_exception(klass, msg, bt, kill = T.unsafe(nil)); end

  # Runs a single test with setup/teardown hooks.
  #
  # source://minitest//lib/minitest/test.rb#87
  def run; end

  # source://minitest//lib/minitest/test.rb#199
  def sanitize_exception(e); end

  class << self
    # Call this at the top of your tests when you absolutely
    # positively need to have ordered tests. In doing so, you're
    # admitting that you suck and your tests are weak.
    #
    # source://minitest//lib/minitest/test.rb#35
    def i_suck_and_my_tests_are_order_dependent!; end

    # Returns the value of attribute io_lock.
    #
    # source://minitest//lib/minitest/test.rb#26
    def io_lock; end

    # Sets the attribute io_lock
    #
    # @param value the value to set the attribute io_lock to.
    #
    # source://minitest//lib/minitest/test.rb#26
    def io_lock=(_arg0); end

    # Make diffs for this Test use #pretty_inspect so that diff
    # in assert_equal can have more details. NOTE: this is much slower
    # than the regular inspect but much more usable for complex
    # objects.
    #
    # source://minitest//lib/minitest/test.rb#48
    def make_my_diffs_pretty!; end

    # Call this at the top of your tests (inside the +Minitest::Test+
    # subclass or +describe+ block) when you want to run your tests in
    # parallel. In doing so, you're admitting that you rule and your
    # tests are awesome.
    #
    # source://minitest//lib/minitest/test.rb#60
    def parallelize_me!; end

    # Returns all instance methods starting with "test_". Based on
    # #test_order, the methods are either sorted, randomized
    # (default), or run in parallel.
    #
    # source://minitest//lib/minitest/test.rb#70
    def runnable_methods; end
  end
end

# Provides before/after hooks for setup and teardown. These are
# meant for library writers, NOT for regular test authors. See
# #before_setup for an example.
#
# source://minitest//lib/minitest/test.rb#112
module Minitest::Test::LifecycleHooks
  # Runs before every test, after setup. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#162
  def after_setup; end

  # Runs after every test, after teardown. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#186
  def after_teardown; end

  # Runs before every test, before setup. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # As a simplistic example:
  #
  #   module MyMinitestPlugin
  #     def before_setup
  #       super
  #       # ... stuff to do before setup is run
  #     end
  #
  #     def after_setup
  #       # ... stuff to do after setup is run
  #       super
  #     end
  #
  #     def before_teardown
  #       super
  #       # ... stuff to do before teardown is run
  #     end
  #
  #     def after_teardown
  #       # ... stuff to do after teardown is run
  #       super
  #     end
  #   end
  #
  #   class Minitest::Test
  #     include MyMinitestPlugin
  #   end
  #
  # source://minitest//lib/minitest/test.rb#147
  def before_setup; end

  # Runs after every test, before teardown. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#171
  def before_teardown; end

  # Runs before every test. Use this to set up before each test
  # run.
  #
  # source://minitest//lib/minitest/test.rb#153
  def setup; end

  # Runs after every test. Use this to clean up after each test
  # run.
  #
  # source://minitest//lib/minitest/test.rb#177
  def teardown; end
end

# source://minitest//lib/minitest/test.rb#19
Minitest::Test::PASSTHROUGH_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://minitest//lib/minitest/test.rb#21
Minitest::Test::SETUP_METHODS = T.let(T.unsafe(nil), Array)

# source://minitest//lib/minitest/test.rb#23
Minitest::Test::TEARDOWN_METHODS = T.let(T.unsafe(nil), Array)

# Assertion wrapping an unexpected error that was raised during a run.
#
# source://minitest//lib/minitest.rb#1058
class Minitest::UnexpectedError < ::Minitest::Assertion
  include ::Minitest::Compress

  # @return [UnexpectedError] a new instance of UnexpectedError
  #
  # source://minitest//lib/minitest.rb#1064
  def initialize(error); end

  # source://minitest//lib/minitest.rb#1077
  def backtrace; end

  # TODO: figure out how to use `cause` instead
  #
  # source://minitest//lib/minitest.rb#1062
  def error; end

  # TODO: figure out how to use `cause` instead
  #
  # source://minitest//lib/minitest.rb#1062
  def error=(_arg0); end

  # source://minitest//lib/minitest.rb#1083
  def message; end

  # source://minitest//lib/minitest.rb#1089
  def result_label; end
end

# source://minitest//lib/minitest.rb#1081
Minitest::UnexpectedError::BASE_RE = T.let(T.unsafe(nil), Regexp)

# Assertion raised on warning when running in -Werror mode.
#
# source://minitest//lib/minitest.rb#1097
class Minitest::UnexpectedWarning < ::Minitest::Assertion
  # source://minitest//lib/minitest.rb#1098
  def result_label; end
end

# source://minitest//lib/minitest.rb#12
Minitest::VERSION = T.let(T.unsafe(nil), String)

# source://minitest//lib/minitest/spec.rb#3
class Module
  # source://minitest//lib/minitest/spec.rb#4
  def infect_an_assertion(meth, new_name, dont_flip = T.unsafe(nil)); end
end

# source://minitest//lib/minitest/spec.rb#347
class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin
  include ::Minitest::Expectations
end
