# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `money` gem.
# Please instead update this file by running `bin/tapioca gem money`.


# "Money is any object or record that is generally accepted as payment for
# goods and services and repayment of debts in a given socio-economic context
# or country." -Wikipedia
#
# An instance of Money represents an amount of a specific currency.
#
# Money is a value object and should be treated as immutable.
#
# @see http://en.wikipedia.org/wiki/Money
#
# source://money//lib/money/currency/loader.rb#1
class Money
  include ::Comparable
  include ::Money::Arithmetic
  extend ::Money::Constructors

  # Creates a new Money object of value given in the
  # +fractional unit+ of the given +currency+.
  #
  # Alternatively you can use the convenience
  # methods like {Money.ca_dollar} and {Money.us_dollar}.
  #
  # @example
  #   Money.new(100)        #=> #<Money @fractional=100 @currency="USD">
  #   Money.new(100, "USD") #=> #<Money @fractional=100 @currency="USD">
  #   Money.new(100, "EUR") #=> #<Money @fractional=100 @currency="EUR">
  # @option [Money::Bank::*]
  # @param currency [Currency, String, Symbol] The currency format.
  # @param [Money::Bank::*] [Hash] a customizable set of options
  # @param options [Hash] Optional settings for the new Money instance
  # @param obj [Object] Either the fractional value of the money,
  #   a Money object, or a currency. (If passed a currency as the first
  #   argument, a Money will be created in that currency with fractional value
  #   = 0.
  # @raise [ArgumentError]
  # @return [Money]
  #
  # source://money//lib/money/money.rb#341
  def initialize(obj, currency = T.unsafe(nil), options = T.unsafe(nil)); end

  # Splits a given amount in parts without losing pennies. The left-over pennies will be
  # distributed round-robin amongst the parties. This means that parts listed first will likely
  # receive more pennies than ones listed later.
  #
  # Pass [2, 1, 1] as input to give twice as much to part1 as part2 or
  # part3 which results in 50% of the cash to party1, 25% to part2, and 25% to part3. Passing a
  # number instead of an array will split the amount evenly (without losing pennies when rounding).
  #
  # @example
  #   Money.new(5,   "USD").allocate([3, 7]) #=> [Money.new(2), Money.new(3)]
  #   Money.new(100, "USD").allocate([1, 1, 1]) #=> [Money.new(34), Money.new(33), Money.new(33)]
  #   Money.new(100, "USD").allocate(2) #=> [Money.new(50), Money.new(50)]
  #   Money.new(100, "USD").allocate(3) #=> [Money.new(34), Money.new(33), Money.new(33)]
  # @param parts [Array<Numeric>, Numeric] how amount should be distributed to parts
  # @return [Array<Money>]
  #
  # source://money//lib/money/money.rb#595
  def allocate(parts); end

  # Returns the numerical value of the money
  #
  # @example
  #   Money.new(1_00, "USD").amount    # => BigDecimal("1.00")
  # @return [BigDecimal]
  # @see #to_d
  # @see #fractional
  #
  # source://money//lib/money/money.rb#386
  def amount; end

  # Receive a money object with the same amount as the current Money object
  # in Canadian dollar.
  #
  # @example
  #   n = Money.new(100, "USD").as_ca_dollar
  #   n.currency #=> #<Money::Currency id: cad>
  # @return [Money]
  #
  # source://money//lib/money/money.rb#561
  def as_ca_dollar; end

  # Receive a money object with the same amount as the current Money object
  # in euro.
  #
  # @example
  #   n = Money.new(100, "USD").as_euro
  #   n.currency #=> #<Money::Currency id: eur>
  # @return [Money]
  #
  # source://money//lib/money/money.rb#573
  def as_euro; end

  # Receive a money object with the same amount as the current Money object
  # in United States dollar.
  #
  # @example
  #   n = Money.new(100, "CAD").as_us_dollar
  #   n.currency #=> #<Money::Currency id: usd>
  # @return [Money]
  #
  # source://money//lib/money/money.rb#549
  def as_us_dollar; end

  # Returns the value of attribute bank.
  #
  # source://money//lib/money/money.rb#88
  def bank; end

  # Convenience method for fractional part of the amount. Synonym of #fractional
  #
  # @return [Integer] when infinite_precision is false
  # @return [BigDecimal] when infinite_precision is true
  # @see infinite_precision
  #
  # source://money//lib/money/money.rb#33
  def cents; end

  # @return [Currency] The money's currency.
  #
  # source://money//lib/money/money.rb#88
  def currency; end

  # Return string representation of currency object
  #
  # @example
  #   Money.new(100, :USD).currency_as_string #=> "USD"
  # @return [String]
  #
  # source://money//lib/money/money.rb#396
  def currency_as_string; end

  # Set currency object using a string
  #
  # @example
  #   Money.new(100).currency_as_string("CAD") #=> #<Money::Currency id: cad>
  # @param val [String] The currency string.
  # @return [Money::Currency]
  #
  # source://money//lib/money/money.rb#409
  def currency_as_string=(val); end

  # Returns a decimal mark according to the locale
  #
  # @return [String]
  #
  # source://money//lib/money/money.rb#644
  def decimal_mark; end

  # Assuming using a currency using dollars:
  # Returns the value of the money in dollars,
  # instead of in the fractional unit cents.
  #
  # Synonym of #amount
  #
  # @example
  #   Money.new(1_00, "USD").dollars   # => BigDecimal("1.00")
  # @return [BigDecimal]
  # @see #amount
  # @see #to_d
  # @see #cents
  #
  # source://money//lib/money/money.rb#372
  def dollars; end

  # source://money//lib/money/money.rb#649
  def dup_with(options = T.unsafe(nil)); end

  # Receive the amount of this money object in another Currency.
  #
  # @example
  #   Money.new(2000, "USD").exchange_to("EUR")
  #   Money.new(2000, "USD").exchange_to("EUR") {|x| x.round}
  #   Money.new(2000, "USD").exchange_to(Currency.new("EUR"))
  # @param other_currency [Currency, String, Symbol] Currency to exchange to.
  # @return [Money]
  # @yield [n] Optional block to use when rounding after exchanging one currency
  #   for another.
  # @yieldparam n [Float] The resulting float after exchanging one currency for
  #   another.
  # @yieldreturn [Integer]
  #
  # source://money//lib/money/money.rb#532
  def exchange_to(other_currency, &rounding_method); end

  # Creates a formatted price string according to several rules.
  #
  # @param rules [Hash] See {Money::Formatter Money::Formatter} for the list of formatting options
  # @return [String]
  #
  # source://money//lib/money/money.rb#627
  def format(*rules); end

  # The value of the monetary amount represented in the fractional or subunit
  # of the currency.
  #
  # For example, in the US dollar currency the fractional unit is cents, and
  # there are 100 cents in one US dollar. So given the Money representation of
  # one US dollar, the fractional interpretation is 100.
  #
  # Another example is that of the Kuwaiti dinar. In this case the fractional
  # unit is the fils and there 1000 fils to one Kuwaiti dinar. So given the
  # Money representation of one Kuwaiti dinar, the fractional interpretation is
  # 1000.
  #
  # @return [Integer] when infinite_precision is false
  # @return [BigDecimal] when infinite_precision is true
  # @see infinite_precision
  #
  # source://money//lib/money/money.rb#53
  def fractional; end

  # Returns a Integer hash value based on the +fractional+ and +currency+ attributes
  # in order to use functions like & (intersection), group_by, etc.
  #
  # @example
  #   Money.new(100).hash #=> 908351
  # @return [Integer]
  #
  # source://money//lib/money/money.rb#422
  def hash; end

  # Common inspect function
  #
  # @return [String]
  #
  # source://money//lib/money/money.rb#439
  def inspect; end

  # Round the monetary amount to smallest unit of coinage.
  #
  # @example
  #   Money.new(10.1, 'USD').round #=> Money.new(10, 'USD')
  # @note This method is only useful when operating with infinite_precision turned
  #   on. Without infinite_precision values are rounded to the smallest unit of
  #   coinage automatically.
  # @return [Money]
  # @see Money.default_infinite_precision
  #
  # source://money//lib/money/money.rb#616
  def round(rounding_mode = T.unsafe(nil), rounding_precision = T.unsafe(nil)); end

  # Round a given amount of money to the nearest possible amount in cash value. For
  # example, in Swiss franc (CHF), the smallest possible amount of cash value is
  # CHF 0.05. Therefore, this method rounds CHF 0.07 to CHF 0.05, and CHF 0.08 to
  # CHF 0.10.
  #
  # @return [Integer] when infinite_precision is false
  # @return [BigDecimal] when infinite_precision is true
  # @see infinite_precision
  #
  # source://money//lib/money/money.rb#70
  def round_to_nearest_cash_value; end

  # Splits a given amount in parts without losing pennies. The left-over pennies will be
  # distributed round-robin amongst the parties. This means that parts listed first will likely
  # receive more pennies than ones listed later.
  #
  # Pass [2, 1, 1] as input to give twice as much to part1 as part2 or
  # part3 which results in 50% of the cash to party1, 25% to part2, and 25% to part3. Passing a
  # number instead of an array will split the amount evenly (without losing pennies when rounding).
  #
  # @example
  #   Money.new(5,   "USD").allocate([3, 7]) #=> [Money.new(2), Money.new(3)]
  #   Money.new(100, "USD").allocate([1, 1, 1]) #=> [Money.new(34), Money.new(33), Money.new(33)]
  #   Money.new(100, "USD").allocate(2) #=> [Money.new(50), Money.new(50)]
  #   Money.new(100, "USD").allocate(3) #=> [Money.new(34), Money.new(33), Money.new(33)]
  # @param parts [Array<Numeric>, Numeric] how amount should be distributed to parts
  # @return [Array<Money>]
  #
  # source://money//lib/money/money.rb#595
  def split(parts); end

  # Uses +Currency#symbol+. If +nil+ is returned, defaults to "¤".
  #
  # @example
  #   Money.new(100, "USD").symbol #=> "$"
  # @return [String]
  #
  # source://money//lib/money/money.rb#432
  def symbol; end

  # Returns a thousands separator according to the locale
  #
  # @return [String]
  #
  # source://money//lib/money/money.rb#635
  def thousands_separator; end

  # Return the amount of money as a BigDecimal.
  #
  # @example
  #   Money.us_dollar(1_00).to_d #=> BigDecimal("1.00")
  # @return [BigDecimal]
  #
  # source://money//lib/money/money.rb#462
  def to_d; end

  # Return the amount of money as a float. Floating points cannot guarantee
  # precision. Therefore, this function should only be used when you no longer
  # need to represent currency or working with another system that requires
  # floats.
  #
  # @example
  #   Money.us_dollar(100).to_f #=> 1.0
  # @return [Float]
  #
  # source://money//lib/money/money.rb#485
  def to_f; end

  # source://money-rails/1.15.0/lib/money-rails/money.rb#26
  def to_hash; end

  # Return the amount of money as a Integer.
  #
  # @example
  #   Money.us_dollar(1_00).to_i #=> 1
  # @return [Integer]
  #
  # source://money//lib/money/money.rb#472
  def to_i; end

  # Conversion to +self+.
  #
  # @return [self]
  #
  # source://money//lib/money/money.rb#507
  def to_money(given_currency = T.unsafe(nil)); end

  # Returns the amount of money as a string.
  #
  # @example
  #   Money.ca_dollar(100).to_s #=> "1.00"
  # @return [String]
  #
  # source://money//lib/money/money.rb#449
  def to_s; end

  # Returns a new Money instance in a given currency leaving the amount intact
  # and not performing currency conversion.
  #
  # @param new_currency [Currency, String, Symbol] Currency of the new object.
  # @return [self]
  #
  # source://money//lib/money/money.rb#495
  def with_currency(new_currency); end

  private

  # source://money//lib/money/money.rb#659
  def as_d(num); end

  # source://money//lib/money/money.rb#675
  def locale_backend; end

  # source://money//lib/money/money.rb#667
  def return_value(value); end

  class << self
    # Adds a new exchange rate to the default bank and return the rate.
    #
    # @example
    #   Money.add_rate("USD", "CAD", 1.25) #=> 1.25
    # @param from_currency [Currency, String, Symbol] Currency to exchange from.
    # @param to_currency [Currency, String, Symbol] Currency to exchange to.
    # @param rate [Numeric] Rate to exchange with.
    # @return [Numeric]
    #
    # source://money//lib/money/money.rb#282
    def add_rate(from_currency, to_currency, rate); end

    # Used to specify precision for converting Rational to BigDecimal
    #
    # @return [Integer]
    #
    # source://money//lib/money/money.rb#132
    def conversion_precision; end

    # Sets the attribute conversion_precision
    #
    # @param value the value to set the attribute conversion_precision to.
    #
    # source://money//lib/money/money.rb#132
    def conversion_precision=(_arg0); end

    # Used to set a default bank for currency exchange.
    #
    # Each Money object is associated with a bank
    # object, which is responsible for currency exchange. This property
    # allows you to specify the default bank object. The default value for
    # this property is an instance of +Bank::VariableExchange.+ It allows
    # one to specify custom exchange rates.
    #
    # @return [Money::Bank::Base]
    #
    # source://money//lib/money/money.rb#171
    def default_bank; end

    # Used to set a default bank for currency exchange.
    #
    # Each Money object is associated with a bank
    # object, which is responsible for currency exchange. This property
    # allows you to specify the default bank object. The default value for
    # this property is an instance of +Bank::VariableExchange.+ It allows
    # one to specify custom exchange rates.
    #
    # @return [Money::Bank::Base]
    #
    # source://money//lib/money/money.rb#134
    def default_bank=(_arg0); end

    # source://money//lib/money/money.rb#152
    def default_currency; end

    # source://money//lib/money/money.rb#166
    def default_currency=(currency); end

    # Used to define a default hash of rules for every time
    # +Money#format+ is called.  Rules provided on method call will be
    # merged with the default ones.  To overwrite a rule, just provide the
    # intended value while calling +format+.
    #
    # @example
    #   Money.default_formatting_rules = { display_free: true }
    #   Money.new(0, "USD").format                          # => "free"
    #   Money.new(0, "USD").format(display_free: false)  # => "$0.00"
    # @return [Hash]
    # @see Money::Formatter#initialize Money::Formatter for more details
    #
    # source://money-rails/1.15.0/lib/money-rails/money.rb#8
    def default_formatting_rules; end

    # Used to define a default hash of rules for every time
    # +Money#format+ is called.  Rules provided on method call will be
    # merged with the default ones.  To overwrite a rule, just provide the
    # intended value while calling +format+.
    #
    # @example
    #   Money.default_formatting_rules = { display_free: true }
    #   Money.new(0, "USD").format                          # => "free"
    #   Money.new(0, "USD").format(display_free: false)  # => "$0.00"
    # @return [Hash]
    # @see Money::Formatter#initialize Money::Formatter for more details
    #
    # source://money//lib/money/money.rb#132
    def default_formatting_rules=(_arg0); end

    # @return [Boolean] Use this to enable infinite precision cents as the
    #   global default
    #
    # source://money//lib/money/money.rb#132
    def default_infinite_precision; end

    # @return [Boolean] Use this to enable infinite precision cents as the
    #   global default
    #
    # source://money//lib/money/money.rb#132
    def default_infinite_precision=(_arg0); end

    # Sets the default bank to be a SingleCurrency bank that raises on
    # currency exchange. Useful when apps operate in a single currency at a time.
    #
    # source://money//lib/money/money.rb#288
    def disallow_currency_conversion!; end

    # Creates a new Money object of value given in the +unit+ of the given
    # +currency+.
    #
    # @example
    #   Money.from_amount(23.45, "USD") # => #<Money fractional:2345 currency:USD>
    #   Money.from_amount(23.45, "JPY") # => #<Money fractional:23 currency:JPY>
    # @option [Money::Bank::*]
    # @param currency [Currency, String, Symbol] The currency format.
    # @param [Money::Bank::*] [Hash] a customizable set of options
    # @param options [Hash] Optional settings for the new Money instance
    # @param amount [Numeric] The numerical value of the money.
    # @raise [ArgumentError]
    # @return [Money]
    # @see #initialize
    #
    # source://money//lib/money/money.rb#307
    def from_amount(amount, currency = T.unsafe(nil), options = T.unsafe(nil)); end

    def from_cents(*_arg0); end

    # Creates a new Money object of value given in the +unit+ of the given
    # +currency+.
    #
    # @example
    #   Money.from_amount(23.45, "USD") # => #<Money fractional:2345 currency:USD>
    #   Money.from_amount(23.45, "JPY") # => #<Money fractional:23 currency:JPY>
    # @option [Money::Bank::*]
    # @param currency [Currency, String, Symbol] The currency format.
    # @param [Money::Bank::*] [Hash] a customizable set of options
    # @param options [Hash] Optional settings for the new Money instance
    # @param amount [Numeric] The numerical value of the money.
    # @raise [ArgumentError]
    # @return [Money]
    # @see #initialize
    #
    # source://money//lib/money/money.rb#307
    def from_dollars(amount, currency = T.unsafe(nil), options = T.unsafe(nil)); end

    # source://money//lib/money/money.rb#136
    def infinite_precision; end

    # source://money//lib/money/money.rb#141
    def infinite_precision=(value); end

    # @private
    #
    # source://money//lib/money/money.rb#224
    def inherited(base); end

    # Returns the value of attribute locale_backend.
    #
    # source://money//lib/money/money.rb#133
    def locale_backend; end

    # source://money//lib/money/money.rb#179
    def locale_backend=(value); end

    # source://money//lib/money/money.rb#132
    def orig_default_formatting_rules; end

    # Use this to return the rounding mode.
    #
    # @param mode [BigDecimal::ROUND_MODE]
    # @return [BigDecimal::ROUND_MODE] rounding mode
    #
    # source://money//lib/money/money.rb#235
    def rounding_mode(mode = T.unsafe(nil)); end

    # @attr_writer rounding_mode Use this to specify the rounding mode
    #
    # source://money//lib/money/money.rb#184
    def rounding_mode=(new_rounding_mode); end

    # source://money//lib/money/money.rb#199
    def setup_defaults; end

    # Used to disable i18n even if it's used by other components of your app.
    #
    # @return [Boolean]
    #
    # source://money//lib/money/money.rb#133
    def use_i18n; end

    # Used to disable i18n even if it's used by other components of your app.
    #
    # @return [Boolean]
    #
    # source://money//lib/money/money.rb#189
    def use_i18n=(value); end

    # Temporarily changes the rounding mode in a given block.
    #
    # @example
    #   fee = Money.with_rounding_mode(BigDecimal::ROUND_HALF_UP) do
    #   Money.new(1200) * BigDecimal('0.029')
    #   end
    # @param mode [BigDecimal::ROUND_MODE]
    # @return [Object] block results
    # @yield The block within which rounding mode will be changed. Its return
    #   value will also be the return value of the whole method.
    #
    # source://money//lib/money/money.rb#265
    def with_rounding_mode(mode); end
  end
end

# source://money//lib/money/money/allocation.rb#4
class Money::Allocation
  class << self
    # Converts a given number to BigDecimal.
    # This method supports inputs of BigDecimal, Rational, and other numeric types by ensuring they are all returned
    # as BigDecimal instances for consistent handling.
    #
    # @param number [Numeric, BigDecimal, Rational] The number to convert.
    # @return [BigDecimal] The converted number as a BigDecimal.
    #
    # source://money//lib/money/money/allocation.rb#58
    def convert_to_big_decimal(number); end

    # Splits a given amount in parts. The allocation is based on the parts' proportions
    # or evenly if parts are numerically specified.
    #
    # The results should always add up to the original amount.
    #
    # @param amount [Numeric] The total amount to be allocated.
    # @param parts [Numeric, Array<Numeric>] Number of parts to split into or an array (proportions for allocation)
    # @param whole_amounts [Boolean] Specifies whether to allocate whole amounts only. Defaults to true.
    # @raise [ArgumentError] If parts is empty or not provided.
    # @return [Array<Numeric>] An array containing the allocated amounts.
    #
    # source://money//lib/money/money/allocation.rb#16
    def generate(amount, parts, whole_amounts = T.unsafe(nil)); end
  end
end

# source://money//lib/money/money/arithmetic.rb#2
module Money::Arithmetic
  # Synonym for +#modulo+.
  #
  # @param val [Money, Integer] Number take modulo with.
  # @return [Money]
  # @see #modulo
  #
  # source://money//lib/money/money/arithmetic.rb#264
  def %(val); end

  # Multiplies the monetary value with the given number and returns a new
  # +Money+ object with this monetary value and the same currency.
  #
  # Note that you can't multiply a Money object by an other +Money+ object.
  #
  # @example
  #   Money.new(100) * 2 #=> #<Money @fractional=200>
  # @param value [Numeric] Number to multiply by.
  # @raise [TypeError] If +value+ is NOT a number.
  # @return [Money] The resulting money.
  #
  # source://money//lib/money/money/arithmetic.rb#167
  def *(value); end

  # Returns a new Money object containing the sum of the two operands' monetary
  # values. If +other_money+ has a different currency then its monetary value
  # is automatically exchanged to this object's currency using +exchange_to+.
  #
  # Returns a new Money object containing the difference between the two
  # operands' monetary values. If +other_money+ has a different currency then
  # its monetary value is automatically exchanged to this object's currency
  # using +exchange_to+.
  #
  # @example
  #   Money.new(100) + Money.new(100) #=> #<Money @fractional=200>
  # @example
  #   Money.new(100) - Money.new(99) #=> #<Money @fractional=1>
  # @param other [Money] Other +Money+ object to add.
  # @param other [Money] Other +Money+ object to subtract.
  # @return [Money]
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#135
  def +(other); end

  # Returns a new Money object containing the sum of the two operands' monetary
  # values. If +other_money+ has a different currency then its monetary value
  # is automatically exchanged to this object's currency using +exchange_to+.
  #
  # Returns a new Money object containing the difference between the two
  # operands' monetary values. If +other_money+ has a different currency then
  # its monetary value is automatically exchanged to this object's currency
  # using +exchange_to+.
  #
  # @example
  #   Money.new(100) + Money.new(100) #=> #<Money @fractional=200>
  # @example
  #   Money.new(100) - Money.new(99) #=> #<Money @fractional=1>
  # @param other [Money] Other +Money+ object to add.
  # @param other [Money] Other +Money+ object to subtract.
  # @return [Money]
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#135
  def -(other); end

  # Returns a money object with changed polarity.
  #
  # @example
  #   - Money.new(100) #=> #<Money @fractional=-100>
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#18
  def -@; end

  # Divides the monetary value with the given number and returns a new +Money+
  # object with this monetary value and the same currency.
  # Can also divide by another +Money+ object to get a ratio.
  #
  # +Money/Numeric+ returns +Money+. +Money/Money+ returns +Float+.
  #
  # @example
  #   Money.new(100) / 10            #=> #<Money @fractional=10>
  #   Money.new(100) / Money.new(10) #=> 10.0
  # @param value [Money, Numeric] Number to divide by.
  # @return [Money] The resulting money if you divide Money by a number.
  # @return [Float] The resulting number if you divide Money by a Money.
  #
  # source://money//lib/money/money/arithmetic.rb#191
  def /(value); end

  # Compares two Money objects. If money objects have a different currency it
  # will attempt to convert the currency.
  #
  # @param other [Money] Value to compare with.
  # @raise [TypeError] when other object is not Money
  # @return [Integer]
  #
  # source://money//lib/money/money/arithmetic.rb#55
  def <=>(other); end

  # Uses Comparable's implementation but raises ArgumentError if non-zero
  # numeric value is given.
  #
  # source://money//lib/money/money/arithmetic.rb#73
  def ==(other); end

  # Return absolute value of self as a new Money object.
  #
  # @example
  #   Money.new(-100).abs #=> #<Money @fractional=100>
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#294
  def abs; end

  # Used to make Money instance handle the operations when arguments order is reversed
  #
  # @example
  #   2 * Money.new(10) #=> #<Money @fractional=20>
  # @return [Array]
  #
  # source://money//lib/money/money/arithmetic.rb#326
  def coerce(other); end

  # Synonym for +#/+.
  #
  # @param value [Money, Numeric] Number to divide by.
  # @return [Money] The resulting money if you divide Money by a number.
  # @return [Float] The resulting number if you divide Money by a Money.
  # @see #/
  #
  # source://money//lib/money/money/arithmetic.rb#209
  def div(value); end

  # Divide money by money or fixnum and return array containing quotient and
  # modulus.
  #
  # @example
  #   Money.new(100).divmod(9)            #=> [#<Money @fractional=11>, #<Money @fractional=1>]
  #   Money.new(100).divmod(Money.new(9)) #=> [11, #<Money @fractional=1>]
  # @param val [Money, Integer] Number to divmod by.
  # @return [Array<Money,Money>, Array<Integer,Money>]
  #
  # source://money//lib/money/money/arithmetic.rb#223
  def divmod(val); end

  # Checks whether two Money objects have the same currency and the same
  # amount. If Money objects have a different currency it will only be true
  # if the amounts are both zero. Checks against objects that are not Money or
  # a subclass will always return false.
  #
  # @example
  #   Money.new(100).eql?(Money.new(101))                #=> false
  #   Money.new(100).eql?(Money.new(100))                #=> true
  #   Money.new(100, "USD").eql?(Money.new(100, "GBP"))  #=> false
  #   Money.new(0, "USD").eql?(Money.new(0, "EUR"))      #=> true
  #   Money.new(100).eql?("1.00")                        #=> false
  # @param other_money [Money] Value to compare with.
  # @return [Boolean]
  #
  # source://money//lib/money/money/arithmetic.rb#37
  def eql?(other_money); end

  # Equivalent to +self.divmod(val)[1]+
  #
  # @example
  #   Money.new(100).modulo(9)            #=> #<Money @fractional=1>
  #   Money.new(100).modulo(Money.new(9)) #=> #<Money @fractional=1>
  # @param val [Money, Integer] Number take modulo with.
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#253
  def modulo(val); end

  # Test if the amount is negative. Returns +true+ if the money amount is
  # less than 0, +false+ otherwise.
  #
  # @example
  #   Money.new(-1).negative? #=> true
  #   Money.new(0).negative?  #=> false
  #   Money.new(1).negative?  #=> false
  # @return [Boolean]
  #
  # source://money//lib/money/money/arithmetic.rb#102
  def negative?; end

  # Test if the money amount is non-zero. Returns this money object if it is
  # non-zero, or nil otherwise, like +Numeric#nonzero?+.
  #
  # @example
  #   Money.new(100).nonzero? #=> #<Money @fractional=100>
  #   Money.new(0).nonzero?   #=> nil
  # @return [Money, nil]
  #
  # source://money//lib/money/money/arithmetic.rb#317
  def nonzero?; end

  # Test if the amount is positive. Returns +true+ if the money amount is
  # greater than 0, +false+ otherwise.
  #
  # @example
  #   Money.new(1).positive?  #=> true
  #   Money.new(0).positive?  #=> false
  #   Money.new(-1).positive? #=> false
  # @return [Boolean]
  #
  # source://money//lib/money/money/arithmetic.rb#89
  def positive?; end

  # If different signs +self.modulo(val) - val+ otherwise +self.modulo(val)+
  #
  # @example
  #   Money.new(100).remainder(9) #=> #<Money @fractional=1>
  # @param val [Money, Integer] Number to rake remainder with.
  # @return [Money]
  #
  # source://money//lib/money/money/arithmetic.rb#276
  def remainder(val); end

  # Test if the money amount is zero.
  #
  # @example
  #   Money.new(100).zero? #=> false
  #   Money.new(0).zero?   #=> true
  # @return [Boolean]
  #
  # source://money//lib/money/money/arithmetic.rb#305
  def zero?; end

  private

  # source://money//lib/money/money/arithmetic.rb#231
  def divmod_money(val); end

  # source://money//lib/money/money/arithmetic.rb#238
  def divmod_other(val); end
end

# Wrapper for coerced numeric values to distinguish
# when numeric was on the 1st place in operation.
#
# source://money//lib/money/money/arithmetic.rb#5
class Money::Arithmetic::CoercedNumeric < ::Struct
  # Returns the value of attribute value
  #
  # @return [Object] the current value of value
  def value; end

  # Sets the attribute value
  #
  # @param value [Object] the value to set the attribute value to.
  # @return [Object] the newly set value
  def value=(_); end

  # Proxy #zero? method to skip unnecessary typecasts. See #- and #+.
  #
  # @return [Boolean]
  #
  # source://money//lib/money/money/arithmetic.rb#7
  def zero?; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Provides classes that aid in the ability of exchange one currency with
# another.
#
# source://money//lib/money/bank/base.rb#4
module Money::Bank; end

# Money::Bank::Base is the basic interface for creating a money exchange
# object, also called Bank.
#
# A Bank is responsible for storing exchange rates, take a Money object as
# input and returns the corresponding Money object converted into an other
# currency.
#
# This class exists for aiding in the creating of other classes to exchange
# money between different currencies. When creating a subclass you will
# need to implement the following methods to exchange money between
# currencies:
#
# - #exchange_with(Money) #=> Money
#
# See Money::Bank::VariableExchange for a real example.
#
# Also, you can extend +Money::Bank::VariableExchange+ instead of
# +Money::Bank::Base+ if your bank implementation needs to store rates
# internally.
#
# @abstract Subclass and override +#exchange_with+ to implement a custom
#   +Money::Bank+ class. You can also override +#setup+ instead of
#   +#initialize+ to setup initial variables, etc.
#
# source://money//lib/money/bank/base.rb#40
class Money::Bank::Base
  # Initializes a new +Money::Bank::Base+ object. An optional block can be
  # passed to dictate the rounding method that +#exchange_with+ can use.
  #
  # @example
  #   Money::Bank::Base.new #=> #<Money::Bank::Base @rounding_method=nil>
  #   Money::Bank::Base.new {|n|
  #   n.floor
  #   } #=> #<Money::Bank::Base @round_method=#<Proc>>
  # @return [Money::Bank::Base]
  # @yield [n] Optional block to use when rounding after exchanging one
  #   currency for another.
  # @yieldparam n [Float] The resulting float after exchanging one currency
  #   for another.
  # @yieldreturn [Integer]
  #
  # source://money//lib/money/bank/base.rb#70
  def initialize(&block); end

  # Exchanges the given +Money+ object to a new +Money+ object in
  # +to_currency+.
  #
  # @abstract Subclass and override +#exchange_with+ to implement a custom
  #   +Money::Bank+ class.
  # @param from [Money] The +Money+ object to exchange from.
  # @param to_currency [Money::Currency, String, Symbol] The currency
  #   string or object to exchange to.
  # @raise NotImplementedError
  # @return [Money]
  # @yield [n] Optional block to use to round the result after making
  #   the exchange.
  # @yieldparam n [Float] The result after exchanging from one currency to
  #   the other.
  # @yieldreturn [Integer]
  #
  # source://money//lib/money/bank/base.rb#103
  def exchange_with(from, to_currency, &block); end

  # The rounding method to use when exchanging rates.
  #
  # @return [Proc]
  #
  # source://money//lib/money/bank/base.rb#52
  def rounding_method; end

  # Given two currency strings or object, checks whether they're both the
  # same currency. Return +true+ if the currencies are the same, +false+
  # otherwise.
  #
  # @example
  #   same_currency?("usd", "USD")                #=> true
  #   same_currency?("usd", "EUR")                #=> false
  #   same_currency?("usd", Currency.new("USD"))   #=> true
  #   same_currency?("usd", "USD")                #=> true
  # @param currency1 [Money::Currency, String, Symbol] The first currency
  #   to compare.
  # @param currency2 [Money::Currency, String, Symbol] The second currency
  #   to compare.
  # @return [Boolean]
  #
  # source://money//lib/money/bank/base.rb#123
  def same_currency?(currency1, currency2); end

  # Called after initialize. Subclasses can use this method to setup
  # variables, etc that they normally would in +#initialize+.
  #
  # @abstract Subclass and override +#setup+ to implement a custom
  #   +Money::Bank+ class.
  # @return [self]
  #
  # source://money//lib/money/bank/base.rb#82
  def setup; end

  class << self
    # Returns the singleton instance of the Base bank.
    #
    # @return [Money::Bank::Base]
    #
    # source://money//lib/money/bank/base.rb#45
    def instance; end
  end
end

# Raised when trying to exchange currencies
#
# source://money//lib/money/bank/single_currency.rb#6
class Money::Bank::DifferentCurrencyError < ::Money::Bank::Error; end

# The lowest Money::Bank error class.
# All Money::Bank errors should inherit from it.
#
# source://money//lib/money/bank/base.rb#8
class Money::Bank::Error < ::StandardError; end

# Class to ensure client code is operating in a single currency
# by raising if an exchange attempts to happen.
#
# This is useful when an application uses multiple currencies but
# it usually deals with only one currency at a time so any arithmetic
# where exchanges happen are erroneous. Using this as the default bank
# means that that these mistakes don't silently do the wrong thing.
#
# source://money//lib/money/bank/single_currency.rb#15
class Money::Bank::SingleCurrency < ::Money::Bank::Base
  # Raises a DifferentCurrencyError to remove possibility of accidentally
  # exchanging currencies
  #
  # @raise [DifferentCurrencyError]
  #
  # source://money//lib/money/bank/single_currency.rb#19
  def exchange_with(from, to_currency, &block); end
end

# Raised when the bank doesn't know about the conversion rate
# for specified currencies.
#
# source://money//lib/money/bank/base.rb#13
class Money::Bank::UnknownRate < ::Money::Bank::Error; end

# Thrown when an unknown rate format is requested.
#
# source://money//lib/money/bank/variable_exchange.rb#9
class Money::Bank::UnknownRateFormat < ::StandardError; end

# Class for aiding in exchanging money between different currencies. By
# default, the +Money+ class uses an object of this class (accessible
# through +Money#bank+) for performing currency exchanges.
#
# By default, +Money::Bank::VariableExchange+ has no knowledge about
# conversion rates. One must manually specify them with +add_rate+, after
# which one can perform exchanges with +#exchange_with+.
#
# Exchange rates are stored in memory using +Money::RatesStore::Memory+ by default.
# Pass custom rates stores for other types of storage (file, database, etc)
#
# @example
#   bank = Money::Bank::VariableExchange.new
#   bank.add_rate("USD", "CAD", 1.24515)
#   bank.add_rate("CAD", "USD", 0.803115)
#
#   c1 = Money.new(100_00, "USD")
#   c2 = Money.new(100_00, "CAD")
#
#   # Exchange 100 USD to CAD:
#   bank.exchange_with(c1, "CAD") #=> #<Money fractional:12451 currency:CAD>
#
#   # Exchange 100 CAD to USD:
#   bank.exchange_with(c2, "USD") #=> #<Money fractional:8031 currency:USD>
#
#   # With custom exchange rates storage
#   redis_store = MyCustomRedisStore.new(host: 'localhost:6379')
#   bank = Money::Bank::VariableExchange.new(redis_store)
#   # Store rates in redis
#   bank.add_rate 'USD', 'CAD', 0.98
#   # Get rate from redis
#   bank.get_rate 'USD', 'CAD'
#
# source://money//lib/money/bank/variable_exchange.rb#43
class Money::Bank::VariableExchange < ::Money::Bank::Base
  # Initializes a new +Money::Bank::VariableExchange+ object.
  # It defaults to using an in-memory, thread safe store instance for
  # storing exchange rates.
  #
  # @param st [RateStore] An exchange rate store, used to persist exchange rate pairs.
  # @return [VariableExchange] a new instance of VariableExchange
  # @yield [n] Optional block to use when rounding after exchanging one
  #   currency for another. See +Money::bank::base+
  #
  # source://money//lib/money/bank/variable_exchange.rb#59
  def initialize(st = T.unsafe(nil), &block); end

  # Registers a conversion rate and returns it (uses +#set_rate+).
  # Delegates to +Money::RatesStore::Memory+
  #
  # @example
  #   bank = Money::Bank::VariableExchange.new
  #   bank.add_rate("USD", "CAD", 1.24515)
  #   bank.add_rate("CAD", "USD", 0.803115)
  # @param from [Currency, String, Symbol] Currency to exchange from.
  # @param to [Currency, String, Symbol] Currency to exchange to.
  # @param rate [Numeric] Rate to use when exchanging currencies.
  # @return [Numeric]
  #
  # source://money//lib/money/bank/variable_exchange.rb#158
  def add_rate(from, to, rate); end

  # source://money//lib/money/bank/variable_exchange.rb#127
  def calculate_fractional(from, to_currency); end

  # source://money//lib/money/bank/variable_exchange.rb#134
  def exchange(fractional, rate, &block); end

  # Exchanges the given +Money+ object to a new +Money+ object in
  # +to_currency+.
  #
  # @example
  #   bank = Money::Bank::VariableExchange.new
  #   bank.add_rate("USD", "CAD", 1.24515)
  #   bank.add_rate("CAD", "USD", 0.803115)
  #
  #   c1 = Money.new(100_00, "USD")
  #   c2 = Money.new(100_00, "CAD")
  #
  #   # Exchange 100 USD to CAD:
  #   bank.exchange_with(c1, "CAD") #=> #<Money fractional:12451 currency:CAD>
  #
  #   # Exchange 100 CAD to USD:
  #   bank.exchange_with(c2, "USD") #=> #<Money fractional:8031 currency:USD>
  # @param from [Money] The +Money+ object to exchange.
  # @param to_currency [Currency, String, Symbol] The currency to exchange to.
  # @raise +Money::Bank::UnknownRate+ if the conversion rate is unknown.
  # @return [Money]
  # @yield [n] Optional block to use when rounding after exchanging one
  #   currency for another.
  # @yieldparam n [Float] The resulting float after exchanging one currency
  #   for another.
  # @yieldreturn [Integer]
  #
  # source://money//lib/money/bank/variable_exchange.rb#109
  def exchange_with(from, to_currency, &block); end

  # Return the known rates as a string in the format specified. If +file+
  # is given will also write the string out to the file specified.
  # Available formats are +:json+, +:ruby+ and +:yaml+.
  #
  # @example
  #   bank = Money::Bank::VariableExchange.new
  #   bank.set_rate("USD", "CAD", 1.24515)
  #   bank.set_rate("CAD", "USD", 0.803115)
  #
  #   s = bank.export_rates(:json)
  #   s #=> "{\"USD_TO_CAD\":1.24515,\"CAD_TO_USD\":0.803115}"
  # @param format [Symbol] Request format for the resulting string.
  # @param file [String] Optional file location to write the rates to.
  # @param opts [Hash] Options hash to set special parameters. Backwards compatibility only.
  # @raise +Money::Bank::UnknownRateFormat+ if format is unknown.
  # @return [String]
  #
  # source://money//lib/money/bank/variable_exchange.rb#221
  def export_rates(format, file = T.unsafe(nil), opts = T.unsafe(nil)); end

  # Retrieve the rate for the given currencies.
  # data access.
  # Delegates to +Money::RatesStore::Memory+
  #
  # @example
  #   bank = Money::Bank::VariableExchange.new
  #   bank.set_rate("USD", "CAD", 1.24515)
  #   bank.set_rate("CAD", "USD", 0.803115)
  #
  #   bank.get_rate("USD", "CAD") #=> 1.24515
  #   bank.get_rate("CAD", "USD") #=> 0.803115
  # @param from [Currency, String, Symbol] Currency to exchange from.
  # @param to [Currency, String, Symbol] Currency to exchange to.
  # @param opts [Hash] Options hash to set special parameters. Backwards compatibility only.
  # @return [Numeric]
  #
  # source://money//lib/money/bank/variable_exchange.rb#198
  def get_rate(from, to, opts = T.unsafe(nil)); end

  # Loads rates provided in +s+ given the specified format. Available
  # formats are +:json+, +:ruby+ and +:yaml+.
  # Delegates to +Money::RatesStore::Memory+
  #
  # @example
  #   s = "{\"USD_TO_CAD\":1.24515,\"CAD_TO_USD\":0.803115}"
  #   bank = Money::Bank::VariableExchange.new
  #   bank.import_rates(:json, s)
  #
  #   bank.get_rate("USD", "CAD") #=> 1.24515
  #   bank.get_rate("CAD", "USD") #=> 0.803115
  # @param format [Symbol] The format of +s+.
  # @param s [String] The rates string.
  # @param opts [Hash] Options hash to set special parameters. Backwards compatibility only.
  # @raise +Money::Bank::UnknownRateFormat+ if format is unknown.
  # @return [self]
  #
  # source://money//lib/money/bank/variable_exchange.rb#261
  def import_rates(format, s, opts = T.unsafe(nil)); end

  # source://money//lib/money/bank/variable_exchange.rb#68
  def marshal_dump; end

  # source://money//lib/money/bank/variable_exchange.rb#72
  def marshal_load(arr); end

  # Returns the value of attribute mutex.
  #
  # source://money//lib/money/bank/variable_exchange.rb#45
  def mutex; end

  # This should be deprecated.
  #
  # source://money//lib/money/bank/variable_exchange.rb#236
  def rates; end

  # Set the rate for the given currencies.
  # access.
  # Delegates to +Money::RatesStore::Memory+
  #
  # @example
  #   bank = Money::Bank::VariableExchange.new
  #   bank.set_rate("USD", "CAD", 1.24515)
  #   bank.set_rate("CAD", "USD", 0.803115)
  # @param from [Currency, String, Symbol] Currency to exchange from.
  # @param to [Currency, String, Symbol] Currency to exchange to.
  # @param rate [Numeric] Rate to use when exchanging currencies.
  # @param opts [Hash] Options hash to set special parameters. Backwards compatibility only.
  # @return [Numeric]
  #
  # source://money//lib/money/bank/variable_exchange.rb#177
  def set_rate(from, to, rate, opts = T.unsafe(nil)); end

  # source://money//lib/money/bank/variable_exchange.rb#64
  def store; end
end

# source://money//lib/money/bank/variable_exchange.rb#50
Money::Bank::VariableExchange::FORMAT_SERIALIZERS = T.let(T.unsafe(nil), Hash)

# Available formats for importing/exporting rates.
#
# source://money//lib/money/bank/variable_exchange.rb#48
Money::Bank::VariableExchange::RATE_FORMATS = T.let(T.unsafe(nil), Array)

# source://money//lib/money/bank/variable_exchange.rb#49
Money::Bank::VariableExchange::SERIALIZER_SEPARATOR = T.let(T.unsafe(nil), String)

# source://money//lib/money/money/constructors.rb#2
module Money::Constructors
  # Creates a new Money object of the given value, using the Canadian
  # dollar currency.
  #
  # @example
  #   n = Money.ca_dollar(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: cad>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#29
  def ca_dollar(cents); end

  # Creates a new Money object of the given value, using the Canadian
  # dollar currency.
  #
  # @example
  #   n = Money.ca_dollar(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: cad>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#29
  def cad(cents); end

  # Create a new money object with value 0.
  #
  # @example
  #   Money.empty #=> #<Money @fractional=0>
  # @param currency [Currency, String, Symbol] The currency to use.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#12
  def empty(currency = T.unsafe(nil)); end

  # Creates a new Money object of the given value, using the Euro currency.
  #
  # @example
  #   n = Money.euro(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: eur>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#62
  def eur(cents); end

  # Creates a new Money object of the given value, using the Euro currency.
  #
  # @example
  #   n = Money.euro(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: eur>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#62
  def euro(cents); end

  # Creates a new Money object of the given value, in British pounds.
  #
  # @example
  #   n = Money.pound_sterling(100)
  #   n.fractional    #=> 100
  #   n.currency #=> #<Money::Currency id: gbp>
  # @param pence [Integer] The pence value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#78
  def gbp(pence); end

  # Creates a new Money object of the given value, in British pounds.
  #
  # @example
  #   n = Money.pound_sterling(100)
  #   n.fractional    #=> 100
  #   n.currency #=> #<Money::Currency id: gbp>
  # @param pence [Integer] The pence value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#78
  def pound_sterling(pence); end

  # Creates a new Money object of the given value, using the American dollar
  # currency.
  #
  # @example
  #   n = Money.us_dollar(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: usd>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#46
  def us_dollar(cents); end

  # Creates a new Money object of the given value, using the American dollar
  # currency.
  #
  # @example
  #   n = Money.us_dollar(100)
  #   n.cents    #=> 100
  #   n.currency #=> #<Money::Currency id: usd>
  # @param cents [Integer] The cents value.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#46
  def usd(cents); end

  # Create a new money object with value 0.
  #
  # @example
  #   Money.empty #=> #<Money @fractional=0>
  # @param currency [Currency, String, Symbol] The currency to use.
  # @return [Money]
  #
  # source://money//lib/money/money/constructors.rb#12
  def zero(currency = T.unsafe(nil)); end
end

# Represents a specific currency unit.
#
# @see https://en.wikipedia.org/wiki/Currency
# @see http://iso4217.net/
#
# source://money//lib/money/currency/loader.rb#2
class Money::Currency
  include ::Comparable
  extend ::Enumerable
  extend ::Money::Currency::Heuristics

  # Create a new +Currency+ object.
  #
  # @example
  #   Money::Currency.new(:usd) #=> #<Money::Currency id: usd ...>
  # @param id [String, Symbol, #to_s] Used to look into +table+ and retrieve
  #   the applicable attributes.
  # @return [Money::Currency]
  #
  # source://money//lib/money/currency.rb#275
  def initialize(id); end

  # Compares +self+ with +other_currency+ against the value of +priority+
  # attribute.
  #
  # @example
  #   c1 = Money::Currency.new(:usd)
  #   c2 = Money::Currency.new(:jpy)
  #   c1 <=> c2 #=> 1
  #   c2 <=> c1 #=> -1
  #   c1 <=> c1 #=> 0
  # @param other_currency [Money::Currency] The currency to compare to.
  # @return [-1, 0, 1] -1 if less than, 0 is equal to, 1 if greater than
  #
  # source://money//lib/money/currency.rb#293
  def <=>(other_currency); end

  # Compares +self+ with +other_currency+ and returns +true+ if the are the
  # same or if their +id+ attributes match.
  #
  # @example
  #   c1 = Money::Currency.new(:usd)
  #   c2 = Money::Currency.new(:jpy)
  #   c1 == c1 #=> true
  #   c1 == c2 #=> false
  # @param other_currency [Money::Currency] The currency to compare to.
  # @return [Boolean]
  #
  # source://money//lib/money/currency.rb#316
  def ==(other_currency); end

  # Returns currency symbol or iso code for currencies with no symbol.
  #
  # @return [String]
  #
  # source://money//lib/money/currency.rb#400
  def code; end

  # @return [String] The decimal mark, or character used to separate the
  #   whole unit from the subunit.
  #
  # source://money//lib/money/currency.rb#258
  def decimal_mark; end

  # Returns the relation between subunit and unit as a base 10 exponent.
  #
  # Note that MGA and MRU are exceptions and are rounded to 1
  #
  # @return [Integer]
  # @see https://en.wikipedia.org/wiki/ISO_4217#Active_codes
  #
  # source://money//lib/money/currency.rb#425
  def decimal_places; end

  # @return [String] The character used to separate thousands grouping of
  #   the whole unit.
  #
  # source://money//lib/money/currency.rb#258
  def delimiter; end

  # @return [String] Alternative currency used if symbol is ambiguous
  #
  # source://money//lib/money/currency.rb#258
  def disambiguate_symbol; end

  def eql?(_arg0); end

  # Returns the relation between subunit and unit as a base 10 exponent.
  #
  # Note that MGA and MRU are exceptions and are rounded to 1
  #
  # @return [Integer]
  # @see https://en.wikipedia.org/wiki/ISO_4217#Active_codes
  #
  # source://money//lib/money/currency.rb#425
  def exponent; end

  # Returns the value of attribute format.
  #
  # source://money//lib/money/currency.rb#258
  def format; end

  # Returns a Integer hash value based on the +id+ attribute in order to use
  # functions like & (intersection), group_by, etc.
  #
  # @example
  #   Money::Currency.new(:usd).hash #=> 428936
  # @return [Integer]
  #
  # source://money//lib/money/currency.rb#337
  def hash; end

  # @return [String] The html entity for the currency symbol
  #
  # source://money//lib/money/currency.rb#258
  def html_entity; end

  # @return [Symbol] The symbol used to identify the currency, usually THE
  #   lowercase +iso_code+ attribute.
  #
  # source://money//lib/money/currency.rb#258
  def id; end

  # Returns a human readable representation.
  #
  # @example
  #   Money::Currency.new(:usd) #=> #<Currency id: usd ...>
  # @return [String]
  #
  # source://money//lib/money/currency.rb#347
  def inspect; end

  # Returns if a code currency is ISO.
  #
  # @example
  #   Money::Currency.new(:usd).iso?
  # @return [Boolean]
  #
  # source://money//lib/money/currency.rb#415
  def iso?; end

  # @return [String] The international 3-letter code as defined by the ISO
  #   4217 standard.
  #
  # source://money//lib/money/currency.rb#258
  def iso_code; end

  # @return [String] The international 3-numeric code as defined by the ISO
  #   4217 standard.
  #
  # source://money//lib/money/currency.rb#258
  def iso_numeric; end

  # @return [String] The currency name.
  #
  # source://money//lib/money/currency.rb#258
  def name; end

  # @return [Integer] A numerical value you can use to sort/group the
  #   currency list.
  #
  # source://money//lib/money/currency.rb#258
  def priority; end

  # @return [String] The decimal mark, or character used to separate the
  #   whole unit from the subunit.
  #
  # source://money//lib/money/currency.rb#258
  def separator; end

  # @return [Integer] Smallest amount of cash possible (in the subunit of
  #   this currency)
  #
  # source://money//lib/money/currency.rb#258
  def smallest_denomination; end

  # @return [String] The name of the fractional monetary unit.
  #
  # source://money//lib/money/currency.rb#258
  def subunit; end

  # @return [Integer] The proportion between the unit and the subunit
  #
  # source://money//lib/money/currency.rb#258
  def subunit_to_unit; end

  # @return [String] The currency symbol (UTF-8 encoded).
  #
  # source://money//lib/money/currency.rb#258
  def symbol; end

  # @return [Boolean] Should the currency symbol precede the amount, or
  #   should it come after?
  #
  # source://money//lib/money/currency.rb#258
  def symbol_first; end

  # @return [Boolean]
  #
  # source://money//lib/money/currency.rb#404
  def symbol_first?; end

  # @return [String] The character used to separate thousands grouping of
  #   the whole unit.
  #
  # source://money//lib/money/currency.rb#258
  def thousands_separator; end

  # Conversion to +self+.
  #
  # @return [self]
  #
  # source://money//lib/money/currency.rb#393
  def to_currency; end

  # Returns a string representation corresponding to the upcase +id+
  # attribute.
  #
  # --
  # DEV: id.to_s.upcase corresponds to iso_code but don't use ISO_CODE for consistency.
  #
  # @example
  #   Money::Currency.new(:usd).to_s #=> "USD"
  #   Money::Currency.new(:eur).to_s #=> "EUR"
  # @return [String]
  #
  # source://money//lib/money/currency.rb#362
  def to_s; end

  # Returns a string representation corresponding to the upcase +id+
  # attribute. Useful in cases where only implicit conversions are made.
  #
  # @example
  #   Money::Currency.new(:usd).to_str #=> "USD"
  #   Money::Currency.new(:eur).to_str #=> "EUR"
  # @return [String]
  #
  # source://money//lib/money/currency.rb#374
  def to_str; end

  # Returns a symbol representation corresponding to the upcase +id+
  # attribute.
  #
  # @example
  #   Money::Currency.new(:usd).to_sym #=> :USD
  #   Money::Currency.new(:eur).to_sym #=> :EUR
  # @return [Symbol]
  #
  # source://money//lib/money/currency.rb#386
  def to_sym; end

  private

  # source://money//lib/money/currency.rb#320
  def compare_ids(other_currency); end

  # source://money//lib/money/currency.rb#432
  def initialize_data!; end

  class << self
    # source://money//lib/money/currency.rb#46
    def _instances; end

    # List the currencies imported and registered
    #
    # @example
    #   Money::Currency.all()
    #   [#<Currency ..USD>, 'CAD', 'EUR']...
    # @return [Array]
    #
    # source://money//lib/money/currency.rb#133
    def all; end

    # source://money//lib/money/currency.rb#205
    def each; end

    # Lookup a currency with given +id+ an returns a +Currency+ instance on
    # success, +nil+ otherwise.
    #
    # retrieve the applicable attributes.
    #
    # @example
    #   Money::Currency.find(:eur) #=> #<Money::Currency id: eur ...>
    #   Money::Currency.find(:foo) #=> nil
    # @param id [String, Symbol, #to_s] Used to look into +table+ and
    # @return [Money::Currency]
    #
    # source://money//lib/money/currency.rb#61
    def find(id); end

    # Lookup a currency with given +num+ as an ISO 4217 numeric and returns an
    # +Currency+ instance on success, +nil+ otherwise.
    #
    # the right currency id.
    #
    # @example
    #   Money::Currency.find_by_iso_numeric(978) #=> #<Money::Currency id: eur ...>
    #   Money::Currency.find_by_iso_numeric(51) #=> #<Money::Currency id: amd ...>
    #   Money::Currency.find_by_iso_numeric('001') #=> nil
    # @param num [#to_s] used to look into +table+ in +iso_numeric+ and find
    # @return [Money::Currency]
    #
    # source://money//lib/money/currency.rb#80
    def find_by_iso_numeric(num); end

    # Inherit a new currency from existing one
    #
    # @param parent_iso_code [String] the international 3-letter code as defined
    # @param curr [Hash] See {register} method for hash structure
    #
    # source://money//lib/money/currency.rb#181
    def inherit(parent_iso_code, curr); end

    # source://money//lib/money/currency.rb#37
    def new(id); end

    # Register a new currency
    #
    # @option priority
    # @option name
    # @option symbol
    # @option subunit
    # @option subunit_to_unit
    # @option separator
    # @option delimiter
    # @option iso_code
    # @option iso_numeric
    # @param separator [Hash] a customizable set of options
    # @param delimiter [Hash] a customizable set of options
    # @param curr [Hash] information about the currency
    # @param priority [Hash] a customizable set of options
    # @param iso_code [Hash] a customizable set of options
    # @param iso_numeric [Hash] a customizable set of options
    # @param name [Hash] a customizable set of options
    # @param symbol [Hash] a customizable set of options
    # @param subunit [Hash] a customizable set of options
    # @param subunit_to_unit [Hash] a customizable set of options
    #
    # source://money//lib/money/currency.rb#170
    def register(curr); end

    # source://money//lib/money/currency.rb#209
    def reset!; end

    # We need a string-based validator before creating an unbounded number of
    # symbols.
    # http://www.randomhacks.net/articles/2007/01/20/13-ways-of-looking-at-a-ruby-symbol#11
    # https://github.com/RubyMoney/money/issues/132
    #
    # @return [Set]
    #
    # source://money//lib/money/currency.rb#149
    def stringified_keys; end

    # List of known currencies.
    #
    # == monetary unit
    # The standard unit of value of a currency, as the dollar in the United States or the peso in Mexico.
    # https://www.answers.com/topic/monetary-unit
    # == fractional monetary unit, subunit
    # A monetary unit that is valued at a fraction (usually one hundredth) of the basic monetary unit
    # https://www.answers.com/topic/fractional-monetary-unit-subunit
    #
    # See https://en.wikipedia.org/wiki/List_of_circulating_currencies and
    # http://search.cpan.org/~tnguyen/Locale-Currency-Format-1.28/Format.pm
    #
    # source://money//lib/money/currency.rb#123
    def table; end

    # Unregister a currency.
    #
    # @param curr [Object] A Hash with the key `:iso_code`, or the ISO code
    #   as a String or Symbol.
    # @return [Boolean] true if the currency previously existed, false
    #   if it didn't.
    #
    # source://money//lib/money/currency.rb#194
    def unregister(curr); end

    # Wraps the object in a +Currency+ unless it's already a +Currency+
    # object.
    #
    # object.
    #
    # @example
    #   c1 = Money::Currency.new(:usd)
    #   Money::Currency.wrap(nil)   #=> nil
    #   Money::Currency.wrap(c1)    #=> #<Money::Currency id: usd ...>
    #   Money::Currency.wrap("usd") #=> #<Money::Currency id: usd ...>
    # @param object [Object] The object to attempt and wrap as a +Currency+
    # @return [Money::Currency]
    #
    # source://money//lib/money/currency.rb#102
    def wrap(object); end

    private

    # source://money//lib/money/currency.rb#216
    def stringify_keys; end
  end
end

# source://money//lib/money/currency/heuristics.rb#5
module Money::Currency::Heuristics
  # @raise [StandardError]
  #
  # source://money//lib/money/currency/heuristics.rb#6
  def analyze(str); end
end

# source://money//lib/money/currency/loader.rb#3
module Money::Currency::Loader
  class << self
    # Loads and returns the currencies stored in JSON files in the config directory.
    #
    # @return [Hash]
    #
    # source://money//lib/money/currency/loader.rb#10
    def load_currencies; end

    private

    # source://money//lib/money/currency/loader.rb#18
    def parse_currency_file(filename); end
  end
end

# source://money//lib/money/currency/loader.rb#4
Money::Currency::Loader::DATA_PATH = T.let(T.unsafe(nil), String)

# Thrown when a Currency has been registered without all the attributes
# which are required for the current action.
#
# source://money//lib/money/currency.rb#24
class Money::Currency::MissingAttributeError < ::StandardError
  # @return [MissingAttributeError] a new instance of MissingAttributeError
  #
  # source://money//lib/money/currency.rb#25
  def initialize(method, currency, attribute); end
end

# Thrown when an unknown currency is requested.
#
# source://money//lib/money/currency.rb#34
class Money::Currency::UnknownCurrency < ::ArgumentError; end

# source://money//lib/money/money/formatter.rb#5
class Money::Formatter
  # Creates a formatted price string according to several rules.
  #
  # with the symbol (if present) and `%n` will be replaced with the number.
  #
  # Note that the default rules can be defined through {Money.default_formatting_rules} hash.
  #
  # @example
  #   Money.new(10000, "USD").format(format: '%u %n') #=> "$ 100.00"
  #   Money.new(10000, "USD").format(format: '<span>%u%n</span>')  #=> "<span>$100.00</span>"
  # @example
  #   Money.us_dollar(100.1).format #=> "$1.001"
  #   Money.us_dollar(100.1).format(rounded_infinite_precision: true) #=> "$1"
  #   Money.us_dollar(100.9).format(rounded_infinite_precision: true) #=> "$1.01"
  # @example
  #   Money.ca_dollar(100).format(no_cents: true) #=> "$1"
  #   Money.ca_dollar(599).format(no_cents: true) #=> "$5"
  # @example
  #   Money.ca_dollar(10000).format(no_cents_if_whole: true) #=> "$100"
  #   Money.ca_dollar(10034).format(no_cents_if_whole: true) #=> "$100.34"
  # @example
  #   Money.new(100, "USD") #=> "$1.00"
  #   Money.new(100, "GBP") #=> "£1.00"
  #   Money.new(100, "EUR") #=> "€1.00"
  #
  #   # Same thing.
  #   Money.new(100, "USD").format(symbol: true) #=> "$1.00"
  #   Money.new(100, "GBP").format(symbol: true) #=> "£1.00"
  #   Money.new(100, "EUR").format(symbol: true) #=> "€1.00"
  #
  #   # You can specify a false expression or an empty string to disable
  #   # prepending a money symbol.§
  #   Money.new(100, "USD").format(symbol: false) #=> "1.00"
  #   Money.new(100, "GBP").format(symbol: nil)   #=> "1.00"
  #   Money.new(100, "EUR").format(symbol: "")    #=> "1.00"
  #
  #   # If the symbol for the given currency isn't known, then it will default
  #   # to "¤" as symbol.
  #   Money.new(100, "AWG").format(symbol: true) #=> "¤1.00"
  #
  #   # You can specify a string as value to enforce using a particular symbol.
  #   Money.new(100, "AWG").format(symbol: "ƒ") #=> "ƒ1.00"
  #
  #   # You can specify a indian currency format
  #   Money.new(10000000, "INR").format(south_asian_number_formatting: true) #=> "1,00,000.00"
  #   Money.new(10000000).format(south_asian_number_formatting: true) #=> "$1,00,000.00"
  # @example
  #   # Default is to not insert a space.
  #   Money.new(100, "USD").format #=> "$1.00"
  #
  #   # Same thing.
  #   Money.new(100, "USD").format(symbol_before_without_space: true) #=> "$1.00"
  #
  #   # If set to false, will insert a space.
  #   Money.new(100, "USD").format(symbol_before_without_space: false) #=> "$ 1.00"
  # @example
  #   # Default is to insert a space.
  #   Money.new(100, "USD").format(symbol_position: :after) #=> "1.00 $"
  #
  #   # If set to true, will not insert a space.
  #   Money.new(100, "USD").format(symbol_position: :after, symbol_after_without_space: true) #=> "1.00$"
  # @example
  #   # If a string is specified, it's value is used.
  #   Money.new(100, "USD").format(decimal_mark: ",") #=> "$1,00"
  #
  #   # If the decimal_mark for a given currency isn't known, then it will default
  #   # to "." as decimal_mark.
  #   Money.new(100, "FOO").format #=> "$1.00"
  # @example
  #   # If a falsey value is specified, no thousands_separator is used.
  #   Money.new(100000, "USD").format(thousands_separator: false) #=> "1000.00"
  #   Money.new(100000, "USD").format(thousands_separator: nil)   #=> "1000.00"
  #   Money.new(100000, "USD").format(thousands_separator: "")    #=> "1000.00"
  #
  #   # If true is specified, the locale or default thousands_separator is used.
  #   Money.new(100000, "USD").format(thousands_separator: true) #=> "1,000.00"
  #
  #   # If a string is specified, it's value is used.
  #   Money.new(100000, "USD").format(thousands_separator: ".") #=> "$1.000.00"
  #
  #   # If the thousands_separator for a given currency isn't known, then it will
  #   # default to "," as thousands_separator.
  #   Money.new(100000, "FOO").format #=> "$1,000.00"
  # @example
  #   Money.ca_dollar(570).format(html: true, with_currency: true)
  #   #=> "$5.70 <span class=\"currency\">CAD</span>"
  # @example
  #   Money.ca_dollar(570).format(html_wrap: true, with_currency: true)
  #   #=> "<span class=\"money-currency-symbol\">$</span><span class=\"money-whole\">5</span><span class=\"money-decimal-mark\">.</span><span class=\"money-decimal\">70</span> <span class=\"money-currency\">CAD</span>"
  # @example
  #   # You can specify to display the sign before the symbol for negative numbers
  #   Money.new(-100, "GBP").format(sign_before_symbol: true)  #=> "-£1.00"
  #   Money.new(-100, "GBP").format(sign_before_symbol: false) #=> "£-1.00"
  #   Money.new(-100, "GBP").format                               #=> "£-1.00"
  # @example
  #   # You can specify to display the sign with positive numbers
  #   Money.new(100, "GBP").format(sign_positive: true,  sign_before_symbol: true)  #=> "+£1.00"
  #   Money.new(100, "GBP").format(sign_positive: true,  sign_before_symbol: false) #=> "£+1.00"
  #   Money.new(100, "GBP").format(sign_positive: false, sign_before_symbol: true)  #=> "£1.00"
  #   Money.new(100, "GBP").format(sign_positive: false, sign_before_symbol: false) #=> "£1.00"
  #   Money.new(100, "GBP").format                               #=> "£+1.00"
  # @example
  #   Money.us_dollar(0).format(display_free: true)     #=> "free"
  #   Money.us_dollar(0).format(display_free: "gratis") #=> "gratis"
  #   Money.us_dollar(0).format                            #=> "$0.00"
  # @example
  #   Money.new(10000, "USD").format(disambiguate: false)   #=> "$100.00"
  #   Money.new(10000, "CAD").format(disambiguate: false)   #=> "$100.00"
  #   Money.new(10000, "USD").format(disambiguate: true)    #=> "$100.00"
  #   Money.new(10000, "CAD").format(disambiguate: true)    #=> "C$100.00"
  # @example
  #   Money.new(10000, "USD").format(disambiguate: false)
  #   #=> "<span class=\"currency_symbol\">$100.00</span>
  # @example
  #   Money.new(10000, "USD").format(symbol_position: :before) #=> "$100.00"
  #   Money.new(10000, "USD").format(symbol_position: :after)  #=> "100.00 $"
  # @example
  #   # With the following entry in the translation files:
  #   # en:
  #   #   number:
  #   #     currency:
  #   #       symbol:
  #   #         CAD: "CAD$"
  #   Money.new(10000, "CAD").format(translate: true) #=> "CAD$100.00"
  # @example
  #   Money.new(89000, :btc).format(drop_trailing_zeros: true) #=> B⃦0.00089
  #   Money.new(110, :usd).format(drop_trailing_zeros: true)   #=> $1.1
  # @example
  #   Money.new(89000, :btc).format(delimiter_pattern: /(\d)(?=\d)/) #=> B⃦8,9,0.00
  # @example
  #   Money.ca_dollar(100).format #=> "$1.00"
  #   Money.ca_dollar(100).format(with_currency: true) #=> "$1.00 CAD"
  #   Money.us_dollar(85).format(with_currency: true)  #=> "$0.85 USD"
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @option rules
  # @param rules [Hash] The options used to format the string.
  # @return [String]
  # @see Money.default_formatting_rules Money.default_formatting_rules for more information.
  #
  # source://money//lib/money/money/formatter.rb#233
  def initialize(money, *rules); end

  # source://money//lib/money/money/formatter.rb#254
  def decimal_mark; end

  # source://money//lib/money/money/formatter.rb#246
  def delimiter; end

  # source://money//lib/money/money/formatter.rb#254
  def separator; end

  # source://money//lib/money/money/formatter.rb#246
  def thousands_separator; end

  # source://money//lib/money/money/formatter.rb#239
  def to_s; end

  private

  # source://money//lib/money/money/formatter.rb#317
  def append_currency_symbol(formatted_number); end

  # source://money//lib/money/money/formatter.rb#288
  def append_sign(formatted_number); end

  # Returns the value of attribute currency.
  #
  # source://money//lib/money/money/formatter.rb#263
  def currency; end

  # source://money//lib/money/money/formatter.rb#351
  def extract_whole_and_decimal_parts; end

  # source://money//lib/money/money/formatter.rb#364
  def format_decimal_part(value); end

  # source://money//lib/money/money/formatter.rb#265
  def format_number; end

  # source://money//lib/money/money/formatter.rb#344
  def format_whole_part(value); end

  # source://money//lib/money/money/formatter.rb#340
  def free_text; end

  # source://money//lib/money/money/formatter.rb#336
  def html_wrap(string, class_name); end

  # source://money//lib/money/money/formatter.rb#378
  def lookup(key); end

  # source://money//lib/money/money/formatter.rb#384
  def lookup_default(key); end

  # Returns the value of attribute money.
  #
  # source://money//lib/money/money/formatter.rb#263
  def money; end

  # Returns the value of attribute rules.
  #
  # source://money//lib/money/money/formatter.rb#263
  def rules; end

  # @return [Boolean]
  #
  # source://money//lib/money/money/formatter.rb#332
  def show_free_text?; end

  # source://money//lib/money/money/formatter.rb#388
  def symbol_value_from(rules); end
end

# source://money//lib/money/money/formatter.rb#6
Money::Formatter::DEFAULTS = T.let(T.unsafe(nil), Hash)

# source://money//lib/money/money/formatting_rules.rb#4
class Money::FormattingRules
  # @return [FormattingRules] a new instance of FormattingRules
  #
  # source://money//lib/money/money/formatting_rules.rb#5
  def initialize(currency, *raw_rules); end

  # source://money//lib/money/money/formatting_rules.rb#20
  def [](key); end

  # @return [Boolean]
  #
  # source://money//lib/money/money/formatting_rules.rb#24
  def has_key?(key); end

  private

  # Returns the value of attribute currency.
  #
  # source://money//lib/money/money/formatting_rules.rb#30
  def currency; end

  # source://money//lib/money/money/formatting_rules.rb#61
  def default_formatting_rules; end

  # source://money//lib/money/money/formatting_rules.rb#94
  def delimiter_pattern_rule(rules); end

  # source://money//lib/money/money/formatting_rules.rb#82
  def determine_format_from_formatting_rules(rules); end

  # source://money//lib/money/money/formatting_rules.rb#74
  def localize_formatting_rules(rules); end

  # Cleans up formatting rules.
  #
  # @param rules [Hash]
  # @return [Hash]
  #
  # source://money//lib/money/money/formatting_rules.rb#37
  def normalize_formatting_rules(rules); end

  # source://money//lib/money/money/formatting_rules.rb#103
  def symbol_position_from(rules); end

  # source://money//lib/money/money/formatting_rules.rb#65
  def translate_formatting_rules(rules); end

  # source://money//lib/money/money/formatting_rules.rb#117
  def warn_about_deprecated_rules(rules); end
end

# source://money//lib/money/locale_backend/errors.rb#2
module Money::LocaleBackend
  class << self
    # @raise [Unknown]
    #
    # source://money//lib/money/money/locale_backend.rb#16
    def find(name); end
  end
end

# source://money//lib/money/money/locale_backend.rb#10
Money::LocaleBackend::BACKENDS = T.let(T.unsafe(nil), Hash)

# source://money//lib/money/locale_backend/base.rb#5
class Money::LocaleBackend::Base; end

# source://money//lib/money/locale_backend/currency.rb#5
class Money::LocaleBackend::Currency < ::Money::LocaleBackend::Base
  # source://money//lib/money/locale_backend/currency.rb#6
  def lookup(key, currency); end
end

# source://money//lib/money/locale_backend/i18n.rb#5
class Money::LocaleBackend::I18n < ::Money::LocaleBackend::Base
  # @raise [NotSupported]
  # @return [I18n] a new instance of I18n
  #
  # source://money//lib/money/locale_backend/i18n.rb#12
  def initialize; end

  # source://money//lib/money/locale_backend/i18n.rb#16
  def lookup(key, _); end
end

# source://money//lib/money/locale_backend/i18n.rb#6
Money::LocaleBackend::I18n::KEY_MAP = T.let(T.unsafe(nil), Hash)

# source://money//lib/money/locale_backend/legacy.rb#6
class Money::LocaleBackend::Legacy < ::Money::LocaleBackend::Base
  # @raise [NotSupported]
  # @return [Legacy] a new instance of Legacy
  #
  # source://money//lib/money/locale_backend/legacy.rb#7
  def initialize; end

  # source://money//lib/money/locale_backend/legacy.rb#11
  def lookup(key, currency); end

  private

  # source://money//lib/money/locale_backend/legacy.rb#23
  def i18n_backend; end
end

# source://money//lib/money/locale_backend/errors.rb#3
class Money::LocaleBackend::NotSupported < ::StandardError; end

# source://money//lib/money/locale_backend/errors.rb#4
class Money::LocaleBackend::Unknown < ::ArgumentError; end

# source://money//lib/money/rates_store/memory.rb#4
module Money::RatesStore; end

# Class for thread-safe storage of exchange rate pairs.
# Used by instances of +Money::Bank::VariableExchange+.
#
# @example
#   store = Money::RatesStore::Memory.new
#   store.add_rate 'USD', 'CAD', 0.98
#   store.get_rate 'USD', 'CAD' # => 0.98
#   # iterates rates
#   store.each_rate {|iso_from, iso_to, rate| puts "#{from} -> #{to}: #{rate}" }
#
# source://money//lib/money/rates_store/memory.rb#15
class Money::RatesStore::Memory
  # Initializes a new +Money::RatesStore::Memory+ object.
  #
  # @option opts
  # @param opts [Hash] Optional store options.
  # @param rates [Hash] Optional initial exchange rate data.
  # @return [Memory] a new instance of Memory
  #
  # source://money//lib/money/rates_store/memory.rb#23
  def initialize(opts = T.unsafe(nil), rates = T.unsafe(nil)); end

  # Registers a conversion rate and returns it. Uses +Mutex+ to synchronize data access.
  #
  # @example
  #   store = Money::RatesStore::Memory.new
  #   store.add_rate("USD", "CAD", 1.24515)
  #   store.add_rate("CAD", "USD", 0.803115)
  # @param currency_iso_from [String] Currency to exchange from.
  # @param currency_iso_to [String] Currency to exchange to.
  # @param rate [Numeric] Rate to use when exchanging currencies.
  # @return [Numeric]
  #
  # source://money//lib/money/rates_store/memory.rb#41
  def add_rate(currency_iso_from, currency_iso_to, rate); end

  # Iterate over rate tuples (iso_from, iso_to, rate)
  #
  # @example
  #   store.each_rate do |iso_from, iso_to, rate|
  #   puts [iso_from, iso_to, rate].join
  #   end
  # @return [Enumerator]
  # @yieldparam iso_from [String] Currency ISO string.
  # @yieldparam iso_to [String] Currency ISO string.
  # @yieldparam rate [Numeric] Exchange rate.
  #
  # source://money//lib/money/rates_store/memory.rb#91
  def each_rate(&block); end

  # Retrieve the rate for the given currencies. Uses +Mutex+ to synchronize data access.
  # Delegates to +Money::RatesStore::Memory+
  #
  # @example
  #   store = Money::RatesStore::Memory.new
  #   store.add_rate("USD", "CAD", 1.24515)
  #
  #   store.get_rate("USD", "CAD") #=> 1.24515
  # @param currency_iso_from [String] Currency to exchange from.
  # @param currency_iso_to [String] Currency to exchange to.
  # @return [Numeric]
  #
  # source://money//lib/money/rates_store/memory.rb#60
  def get_rate(currency_iso_from, currency_iso_to); end

  # source://money//lib/money/rates_store/memory.rb#66
  def marshal_dump; end

  # Wraps block execution in a thread-safe transaction
  #
  # source://money//lib/money/rates_store/memory.rb#73
  def transaction(&block); end

  private

  # Returns the value of attribute guard.
  #
  # source://money//lib/money/rates_store/memory.rb#104
  def guard; end

  # Returns the value of attribute options.
  #
  # source://money//lib/money/rates_store/memory.rb#104
  def options; end

  # Return the rate hashkey for the given currencies.
  #
  # @example
  #   rate_key_for("USD", "CAD") #=> "USD_TO_CAD"
  # @param currency_iso_from [String] The currency to exchange from.
  # @param currency_iso_to [String] The currency to exchange to.
  # @return [String]
  #
  # source://money//lib/money/rates_store/memory.rb#115
  def rate_key_for(currency_iso_from, currency_iso_to); end

  # Returns the value of attribute rates.
  #
  # source://money//lib/money/rates_store/memory.rb#104
  def rates; end
end

# source://money//lib/money/rates_store/memory.rb#16
Money::RatesStore::Memory::INDEX_KEY_SEPARATOR = T.let(T.unsafe(nil), String)

# Raised when smallest denomination of a currency is not defined
#
# source://money//lib/money/money.rb#25
class Money::UndefinedSmallestDenomination < ::StandardError; end
