# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `paperclip` gem.
# Please instead update this file by running `bin/tapioca gem paperclip`.


# The base module that gets included in ActiveRecord::Base. See the
# documentation for Paperclip::ClassMethods for more useful information.
#
# source://paperclip//lib/paperclip/version.rb#1
module Paperclip
  extend ::Paperclip::Helpers
  extend ::Paperclip::Logger
  extend ::Paperclip::ProcessorHelpers

  class << self
    # source://paperclip//lib/paperclip.rb#109
    def io_adapters; end

    # source://paperclip//lib/paperclip.rb#105
    def io_adapters=(new_registry); end

    # Returns hash with styles missing from recent run of rake paperclip:refresh:missing_styles
    #   {
    #     :User => {:avatar => [:big]},
    #     :Book => {
    #       :cover => [:croppable]},
    #     }
    #   }
    #
    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#59
    def missing_attachments_styles; end

    # Provides configurability to Paperclip. The options available are:
    # * whiny: Will raise an error if Paperclip cannot process thumbnails of
    #   an uploaded image. Defaults to true.
    # * log: Logs progress to the Rails log. Uses ActiveRecord's logger, so honors
    #   log levels, etc. Defaults to true.
    # * command_path: Defines the path at which to find the command line
    #   programs if they are not visible to Rails the system's search path. Defaults to
    #   nil, which uses the first executable found in the user's search path.
    # * use_exif_orientation: Whether to inspect EXIF data to determine an
    #   image's orientation. Defaults to true.
    #
    # source://paperclip//lib/paperclip.rb#91
    def options; end

    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#7
    def registered_attachments_styles_path; end

    # Sets the attribute registered_attachments_styles_path
    #
    # @param value the value to set the attribute registered_attachments_styles_path to.
    #
    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#6
    def registered_attachments_styles_path=(_arg0); end

    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#20
    def save_current_attachments_styles!; end

    private

    # Returns hash with styles for all classes using Paperclip.
    # Unfortunately current version does not work with lambda styles:(
    #   {
    #     :User => {:avatar => [:small, :big]},
    #     :Book => {
    #       :cover => [:thumb, :croppable]},
    #       :sample => [:thumb, :big]},
    #     }
    #   }
    #
    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#35
    def current_attachments_styles; end

    # Get list of styles saved on previous deploy (running rake paperclip:refresh:missing_styles)
    #
    # source://paperclip//lib/paperclip/missing_attachment_styles.rb#13
    def get_registered_attachments_styles; end
  end
end

# source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#4
class Paperclip::AbstractAdapter
  # @return [AbstractAdapter] a new instance of AbstractAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#11
  def initialize(target, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#44
  def assignment?; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def binmode(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def binmode?(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def close(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def close!(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def closed?(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute content_type.
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#7
  def content_type; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def eof?(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#16
  def fingerprint; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#31
  def inspect; end

  # Returns the value of attribute size.
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#7
  def length; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#40
  def nil?; end

  # Returns the value of attribute original_filename.
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#7
  def original_filename; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#35
  def original_filename=(new_filename); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def path(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#27
  def read(length = T.unsafe(nil), buffer = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def readbyte(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def rewind(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute size.
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#7
  def size; end

  # Returns the value of attribute tempfile.
  #
  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#7
  def tempfile; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#8
  def unlink(*_arg0, **_arg1, &_arg2); end

  private

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#54
  def copy_to_tempfile(src); end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#50
  def destination; end

  # source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#59
  def link_or_copy_file(src, dest); end
end

# source://paperclip//lib/paperclip/io_adapters/abstract_adapter.rb#5
Paperclip::AbstractAdapter::OS_RESTRICTED_CHARACTERS = T.let(T.unsafe(nil), Regexp)

# source://paperclip//lib/paperclip/io_adapters/registry.rb#2
class Paperclip::AdapterRegistry
  # @return [AdapterRegistry] a new instance of AdapterRegistry
  #
  # source://paperclip//lib/paperclip/io_adapters/registry.rb#7
  def initialize; end

  # source://paperclip//lib/paperclip/io_adapters/registry.rb#32
  def for(target, options = T.unsafe(nil)); end

  # @raise [NoHandlerError]
  #
  # source://paperclip//lib/paperclip/io_adapters/registry.rb#19
  def handler_for(target); end

  # source://paperclip//lib/paperclip/io_adapters/registry.rb#11
  def register(handler_class, &block); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/registry.rb#26
  def registered?(target); end

  # Returns the value of attribute registered_handlers.
  #
  # source://paperclip//lib/paperclip/io_adapters/registry.rb#5
  def registered_handlers; end

  # source://paperclip//lib/paperclip/io_adapters/registry.rb#15
  def unregister(handler_class); end
end

# source://paperclip//lib/paperclip/io_adapters/registry.rb#3
class Paperclip::AdapterRegistry::NoHandlerError < ::Paperclip::Error; end

# The Attachment class manages the files for a given attachment. It saves
# when the model saves, deletes when the model is destroyed, and processes
# the file upon assignment.
#
# source://paperclip//lib/paperclip/attachment.rb#10
class Paperclip::Attachment
  # Creates an Attachment object. +name+ is the name of the attachment,
  # +instance+ is the model object instance it's attached to, and
  # +options+ is the same as the hash passed to +has_attached_file+.
  #
  # Options include:
  #
  # +url+ - a relative URL of the attachment. This is interpolated using +interpolator+
  # +path+ - where on the filesystem to store the attachment. This is interpolated using +interpolator+
  # +styles+ - a hash of options for processing the attachment. See +has_attached_file+ for the details
  # +only_process+ - style args to be run through the post-processor. This defaults to the empty list (which is
  #                  a special case that indicates all styles should be processed)
  # +default_url+ - a URL for the missing image
  # +default_style+ - the style to use when an argument is not specified e.g. #url, #path
  # +storage+ - the storage mechanism. Defaults to :filesystem
  # +use_timestamp+ - whether to append an anti-caching timestamp to image URLs. Defaults to true
  # +whiny+, +whiny_thumbnails+ - whether to raise when thumbnailing fails
  # +use_default_time_zone+ - related to +use_timestamp+. Defaults to true
  # +hash_digest+ - a string representing a class that will be used to hash URLs for obfuscation
  # +hash_data+ - the relative URL for the hash data. This is interpolated using +interpolator+
  # +hash_secret+ - a secret passed to the +hash_digest+
  # +convert_options+ - flags passed to the +convert+ command for processing
  # +source_file_options+ - flags passed to the +convert+ command that controls how the file is read
  # +processors+ - classes that transform the attachment. Defaults to [:thumbnail]
  # +preserve_files+ - whether to keep files on the filesystem when deleting or clearing the attachment. Defaults to false
  # +filename_cleaner+ - An object that responds to #call(filename) that will strip unacceptable charcters from filename
  # +interpolator+ - the object used to interpolate filenames and URLs. Defaults to Paperclip::Interpolations
  # +url_generator+ - the object used to generate URLs, using the interpolator. Defaults to Paperclip::UrlGenerator
  # +escape_url+ - Perform URI escaping to URLs. Defaults to true
  #
  # @return [Attachment] a new instance of Attachment
  #
  # source://paperclip//lib/paperclip/attachment.rb#72
  def initialize(name, instance, options = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/attachment.rb#191
  def as_json(options = T.unsafe(nil)); end

  # What gets called when you call instance.attachment = File. It clears
  # errors, assigns attributes, and processes the file. It also queues up the
  # previous file for deletion, to be flushed away on #save of its host.  In
  # addition to form uploads, you can also assign another Paperclip
  # attachment:
  #   new_user.avatar = old_user.avatar
  #
  # source://paperclip//lib/paperclip/attachment.rb#99
  def assign(uploaded_file); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#368
  def blank?; end

  # Clears out the attachment. Has the same effect as previously assigning
  # nil to the attachment. Does NOT save. If you wish to clear AND save,
  # use #destroy.
  #
  # source://paperclip//lib/paperclip/attachment.rb#254
  def clear(*styles_to_clear); end

  # Returns the content_type of the file as originally assigned, and lives
  # in the <attachment>_content_type attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#297
  def content_type; end

  # Returns the value of attribute convert_options.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def convert_options; end

  # Returns the creation time of the file as originally assigned, and
  # lives in the <attachment>_created_at attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#303
  def created_at; end

  # source://paperclip//lib/paperclip/attachment.rb#151
  def default_options; end

  # Returns the value of attribute default_style.
  #
  # source://paperclip//lib/paperclip/attachment.rb#195
  def default_style; end

  # Destroys the attachment. Has the same effect as previously assigning
  # nil to the attachment *and saving*. This is permanent. If you wish to
  # wipe out the existing attachment but not save, use #clear.
  #
  # source://paperclip//lib/paperclip/attachment.rb#267
  def destroy; end

  # Returns true if there are changes that need to be saved.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#234
  def dirty?; end

  # Returns an array containing the errors on this attachment.
  #
  # source://paperclip//lib/paperclip/attachment.rb#229
  def errors; end

  # Alias to +url+ that allows using the expiring_url method provided by the cloud
  # storage implementations, but keep using filesystem storage for development and
  # testing.
  #
  # source://paperclip//lib/paperclip/attachment.rb#161
  def expiring_url(time = T.unsafe(nil), style_name = T.unsafe(nil)); end

  # Returns true if a file has been assigned.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#362
  def file?; end

  # Returns the fingerprint of the file, if one's defined. The fingerprint is
  # stored in the <attachment>_fingerprint attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#291
  def fingerprint; end

  # Returns a unique hash suitable for obfuscating the URL of an otherwise
  # publicly viewable attachment.
  #
  # @raise [ArgumentError]
  #
  # source://paperclip//lib/paperclip/attachment.rb#325
  def hash_key(style_name = T.unsafe(nil)); end

  # Returns the value of attribute instance.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def instance; end

  # Reads the attachment-specific attribute on the instance. See instance_write
  # for more details.
  #
  # source://paperclip//lib/paperclip/attachment.rb#390
  def instance_read(attr); end

  # Determines whether the instance responds to this attribute. Used to prevent
  # calculations on fields we won't even store.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#374
  def instance_respond_to?(attr); end

  # Writes the attachment-specific attribute on the instance. For example,
  # instance_write(:file_name, "me.jpg") will write "me.jpg" to the instance's
  # "avatar_file_name" field (assuming the attachment is called avatar).
  #
  # source://paperclip//lib/paperclip/attachment.rb#381
  def instance_write(attr, value); end

  # Returns the value of attribute interpolator.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def interpolator; end

  # Returns the value of attribute name.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def name; end

  # source://paperclip//lib/paperclip/attachment.rb#212
  def only_process; end

  # Returns the value of attribute options.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def options; end

  # Returns the name of the file as originally assigned, and lives in the
  # <attachment>_file_name attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#279
  def original_filename; end

  # Returns the path of the attachment as defined by the :path option. If the
  # file is stored in the filesystem the path refers to the path of the file
  # on disk. If the file is stored in S3, the path is the "key" part of the
  # URL, and the :bucket option refers to the S3 bucket.
  #
  # source://paperclip//lib/paperclip/attachment.rb#169
  def path(style_name = T.unsafe(nil)); end

  # Returns the value of attribute post_processing.
  #
  # source://paperclip//lib/paperclip/attachment.rb#42
  def post_processing; end

  # Sets the attribute post_processing
  #
  # @param value the value to set the attribute post_processing to.
  #
  # source://paperclip//lib/paperclip/attachment.rb#42
  def post_processing=(_arg0); end

  # Returns true if a file has been assigned.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#362
  def present?; end

  # source://paperclip//lib/paperclip/attachment.rb#218
  def processors; end

  # Returns the value of attribute queued_for_write.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def queued_for_write; end

  # This method really shouldn't be called that often. Its expected use is
  # in the paperclip:refresh rake task and that's it. It will regenerate all
  # thumbnails forcefully, by reobtaining the original file and going through
  # the post-process again.
  # NOTE: Calling reprocess WILL NOT delete existing files. This is due to
  # inconsistencies in timing of S3 commands. It's possible that calling
  # #reprocess! will lose data if the files are not kept.
  #
  # source://paperclip//lib/paperclip/attachment.rb#339
  def reprocess!(*style_args); end

  # Saves the file, if there are no errors. If there are, it flushes them to
  # the instance's errors and returns false, cancelling the save.
  #
  # source://paperclip//lib/paperclip/attachment.rb#240
  def save; end

  # Returns the size of the file as originally assigned, and lives in the
  # <attachment>_file_size attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#285
  def size; end

  # Returns the value of attribute source_file_options.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def source_file_options; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#182
  def staged?; end

  # source://paperclip//lib/paperclip/attachment.rb#175
  def staged_path(style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/attachment.rb#199
  def styles; end

  # The time zone to use for timestamp interpolation.  Using the default
  # time zone ensures that results are consistent across all threads.
  #
  # source://paperclip//lib/paperclip/attachment.rb#319
  def time_zone; end

  # Alias to +url+
  #
  # source://paperclip//lib/paperclip/attachment.rb#187
  def to_s(style_name = T.unsafe(nil)); end

  # Returns the last modified time of the file as originally assigned, and
  # lives in the <attachment>_updated_at attribute of the model.
  #
  # source://paperclip//lib/paperclip/attachment.rb#312
  def updated_at; end

  # Returns the uploaded file if present.
  #
  # source://paperclip//lib/paperclip/attachment.rb#273
  def uploaded_file; end

  # Returns the public URL of the attachment with a given style. This does
  # not necessarily need to point to a file that your Web server can access
  # and can instead point to an action in your app, for example for fine grained
  # security; this has a serious performance tradeoff.
  #
  # Options:
  #
  # +timestamp+ - Add a timestamp to the end of the URL. Default: true.
  # +escape+    - Perform URI escaping to the URL. Default: true.
  #
  # Global controls (set on has_attached_file):
  #
  # +interpolator+  - The object that fills in a URL pattern's variables.
  # +default_url+   - The image to show when the attachment has no image.
  # +url+           - The URL for a saved image.
  # +url_generator+ - The object that generates a URL. Default: Paperclip::UrlGenerator.
  #
  # As mentioned just above, the object that generates this URL can be passed
  # in, for finer control. This object must respond to two methods:
  #
  # +#new(Paperclip::Attachment, options_hash)+
  # +#for(style_name, options_hash)+
  #
  # source://paperclip//lib/paperclip/attachment.rb#143
  def url(style_name = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute whiny.
  #
  # source://paperclip//lib/paperclip/attachment.rb#40
  def whiny; end

  private

  # Check if attachment database table has a created_at field
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#623
  def able_to_store_created_at?; end

  # source://paperclip//lib/paperclip/attachment.rb#403
  def active_validator_classes; end

  # called by storage after the writes are flushed and before @queued_for_write is cleared
  #
  # source://paperclip//lib/paperclip/attachment.rb#596
  def after_flush_writes; end

  # source://paperclip//lib/paperclip/attachment.rb#439
  def assign_attributes; end

  # source://paperclip//lib/paperclip/attachment.rb#446
  def assign_file_information; end

  # source://paperclip//lib/paperclip/attachment.rb#452
  def assign_fingerprint; end

  # source://paperclip//lib/paperclip/attachment.rb#458
  def assign_timestamps; end

  # source://paperclip//lib/paperclip/attachment.rb#618
  def cleanup_filename(filename); end

  # source://paperclip//lib/paperclip/attachment.rb#474
  def dirty!; end

  # source://paperclip//lib/paperclip/attachment.rb#417
  def ensure_required_accessors!; end

  # source://paperclip//lib/paperclip/attachment.rb#411
  def ensure_required_validations!; end

  # source://paperclip//lib/paperclip/attachment.rb#494
  def extra_options_for(style); end

  # source://paperclip//lib/paperclip/attachment.rb#498
  def extra_source_file_options_for(style); end

  # You can either specifiy :restricted_characters or you can define your own
  # :filename_cleaner object. This object needs to respond to #call and takes
  # the filename that will be cleaned. It should return the cleaned filename.
  #
  # source://paperclip//lib/paperclip/attachment.rb#614
  def filename_cleaner; end

  # source://paperclip//lib/paperclip/attachment.rb#589
  def flush_errors; end

  # Check if attachment database table has a created_at field which is not yet set
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#628
  def has_enabled_but_unset_created_at?; end

  # source://paperclip//lib/paperclip/attachment.rb#429
  def initialize_storage; end

  # source://paperclip//lib/paperclip/attachment.rb#564
  def interpolate(pattern, style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/attachment.rb#425
  def log(message); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#407
  def missing_required_validator?; end

  # source://paperclip//lib/paperclip/attachment.rb#399
  def path_option; end

  # source://paperclip//lib/paperclip/attachment.rb#511
  def post_process(*style_args); end

  # source://paperclip//lib/paperclip/attachment.rb#466
  def post_process_file; end

  # source://paperclip//lib/paperclip/attachment.rb#530
  def post_process_style(name, style); end

  # source://paperclip//lib/paperclip/attachment.rb#523
  def post_process_styles(*style_args); end

  # source://paperclip//lib/paperclip/attachment.rb#502
  def process_options(options_type, style); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/attachment.rb#560
  def process_style?(style_name, style_args); end

  # source://paperclip//lib/paperclip/attachment.rb#574
  def queue_all_for_delete; end

  # source://paperclip//lib/paperclip/attachment.rb#568
  def queue_some_for_delete(*styles); end

  # source://paperclip//lib/paperclip/attachment.rb#478
  def reset_file_if_original_reprocessed; end

  # source://paperclip//lib/paperclip/attachment.rb#484
  def reset_updater; end

  # source://paperclip//lib/paperclip/attachment.rb#600
  def unlink_files(files); end

  # source://paperclip//lib/paperclip/attachment.rb#490
  def updater; end

  class << self
    # source://paperclip//lib/paperclip/attachment.rb#11
    def default_options; end
  end
end

# source://paperclip//lib/paperclip/io_adapters/attachment_adapter.rb#2
class Paperclip::AttachmentAdapter < ::Paperclip::AbstractAdapter
  # @return [AttachmentAdapter] a new instance of AttachmentAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/attachment_adapter.rb#9
  def initialize(target, options = T.unsafe(nil)); end

  private

  # source://paperclip//lib/paperclip/io_adapters/attachment_adapter.rb#23
  def cache_current_values; end

  # source://paperclip//lib/paperclip/io_adapters/attachment_adapter.rb#30
  def copy_to_tempfile(source); end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/attachment_adapter.rb#3
    def register; end
  end
end

# source://paperclip//lib/paperclip/attachment_registry.rb#4
class Paperclip::AttachmentRegistry
  include ::Singleton
  extend ::Singleton::SingletonClassMethods

  # @return [AttachmentRegistry] a new instance of AttachmentRegistry
  #
  # source://paperclip//lib/paperclip/attachment_registry.rb#27
  def initialize; end

  # source://paperclip//lib/paperclip/attachment_registry.rb#37
  def clear; end

  # source://paperclip//lib/paperclip/attachment_registry.rb#53
  def definitions_for(klass); end

  # source://paperclip//lib/paperclip/attachment_registry.rb#45
  def each_definition; end

  # source://paperclip//lib/paperclip/attachment_registry.rb#41
  def names_for(klass); end

  # source://paperclip//lib/paperclip/attachment_registry.rb#31
  def register(klass, attachment_name, attachment_options); end

  class << self
    # source://paperclip//lib/paperclip/attachment_registry.rb#11
    def clear; end

    # source://paperclip//lib/paperclip/attachment_registry.rb#23
    def definitions_for(klass); end

    # source://paperclip//lib/paperclip/attachment_registry.rb#19
    def each_definition(&block); end

    # source://paperclip//lib/paperclip/attachment_registry.rb#15
    def names_for(klass); end

    # source://paperclip//lib/paperclip/attachment_registry.rb#7
    def register(klass, attachment_name, attachment_options); end

    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://paperclip//lib/paperclip/callbacks.rb#2
module Paperclip::Callbacks
  include ::Paperclip::Callbacks::Running

  mixes_in_class_methods ::Paperclip::Callbacks::Defining

  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/callbacks.rb#3
    def included(base); end
  end
end

# source://paperclip//lib/paperclip/callbacks.rb#8
module Paperclip::Callbacks::Defining
  # source://paperclip//lib/paperclip/callbacks.rb#9
  def define_paperclip_callbacks(*callbacks); end

  private

  # source://paperclip//lib/paperclip/callbacks.rb#25
  def hasta_la_vista_baby; end
end

# source://paperclip//lib/paperclip/callbacks.rb#36
module Paperclip::Callbacks::Running
  # source://paperclip//lib/paperclip/callbacks.rb#37
  def run_paperclip_callbacks(callback, &block); end
end

# source://paperclip//lib/paperclip.rb#113
module Paperclip::ClassMethods
  # +has_attached_file+ gives the class it is called on an attribute that maps to a file. This
  # is typically a file stored somewhere on the filesystem and has been uploaded by a user.
  # The attribute returns a Paperclip::Attachment object which handles the management of
  # that file. The intent is to make the attachment as much like a normal attribute. The
  # thumbnails will be created when the new file is assigned, but they will *not* be saved
  # until +save+ is called on the record. Likewise, if the attribute is set to +nil+ is
  # called on it, the attachment will *not* be deleted until +save+ is called. See the
  # Paperclip::Attachment documentation for more specifics. There are a number of options
  # you can set to change the behavior of a Paperclip attachment:
  # * +url+: The full URL of where the attachment is publicly accessible. This can just
  #   as easily point to a directory served directly through Apache as it can to an action
  #   that can control permissions. You can specify the full domain and path, but usually
  #   just an absolute path is sufficient. The leading slash *must* be included manually for
  #   absolute paths. The default value is
  #   "/system/:class/:attachment/:id_partition/:style/:filename". See
  #   Paperclip::Attachment#interpolate for more information on variable interpolaton.
  #     :url => "/:class/:attachment/:id/:style_:filename"
  #     :url => "http://some.other.host/stuff/:class/:id_:extension"
  #   Note: When using the +s3+ storage option, the +url+ option expects
  #   particular values. See the Paperclip::Storage::S3#url documentation for
  #   specifics.
  # * +default_url+: The URL that will be returned if there is no attachment assigned.
  #   This field is interpolated just as the url is. The default value is
  #   "/:attachment/:style/missing.png"
  #     has_attached_file :avatar, :default_url => "/images/default_:style_avatar.png"
  #     User.new.avatar_url(:small) # => "/images/default_small_avatar.png"
  # * +styles+: A hash of thumbnail styles and their geometries. You can find more about
  #   geometry strings at the ImageMagick website
  #   (http://www.imagemagick.org/script/command-line-options.php#resize). Paperclip
  #   also adds the "#" option (e.g. "50x50#"), which will resize the image to fit maximally
  #   inside the dimensions and then crop the rest off (weighted at the center). The
  #   default value is to generate no thumbnails.
  # * +default_style+: The thumbnail style that will be used by default URLs.
  #   Defaults to +original+.
  #     has_attached_file :avatar, :styles => { :normal => "100x100#" },
  #                       :default_style => :normal
  #     user.avatar.url # => "/avatars/23/normal_me.png"
  # * +keep_old_files+: Keep the existing attachment files (original + resized) from
  #   being automatically deleted when an attachment is cleared or updated. Defaults to +false+.
  # * +preserve_files+: Keep the existing attachment files in all cases, even if the parent
  #   record is destroyed. Defaults to +false+.
  # * +whiny+: Will raise an error if Paperclip cannot post_process an uploaded file due
  #   to a command line error. This will override the global setting for this attachment.
  #   Defaults to true.
  # * +convert_options+: When creating thumbnails, use this free-form options
  #   array to pass in various convert command options.  Typical options are "-strip" to
  #   remove all Exif data from the image (save space for thumbnails and avatars) or
  #   "-depth 8" to specify the bit depth of the resulting conversion.  See ImageMagick
  #   convert documentation for more options: (http://www.imagemagick.org/script/convert.php)
  #   Note that this option takes a hash of options, each of which correspond to the style
  #   of thumbnail being generated. You can also specify :all as a key, which will apply
  #   to all of the thumbnails being generated. If you specify options for the :original,
  #   it would be best if you did not specify destructive options, as the intent of keeping
  #   the original around is to regenerate all the thumbnails when requirements change.
  #     has_attached_file :avatar, :styles => { :large => "300x300", :negative => "100x100" }
  #                                :convert_options => {
  #                                  :all => "-strip",
  #                                  :negative => "-negate"
  #                                }
  #   NOTE: While not deprecated yet, it is not recommended to specify options this way.
  #   It is recommended that :convert_options option be included in the hash passed to each
  #   :styles for compatibility with future versions.
  #   NOTE: Strings supplied to :convert_options are split on space in order to undergo
  #   shell quoting for safety. If your options require a space, please pre-split them
  #   and pass an array to :convert_options instead.
  # * +storage+: Chooses the storage backend where the files will be stored. The current
  #   choices are :filesystem, :fog and :s3. The default is :filesystem. Make sure you read the
  #   documentation for Paperclip::Storage::Filesystem, Paperclip::Storage::Fog and Paperclip::Storage::S3
  #   for backend-specific options.
  #
  # It's also possible for you to dynamically define your interpolation string for :url,
  # :default_url, and :path in your model by passing a method name as a symbol as a argument
  # for your has_attached_file definition:
  #
  #   class Person
  #     has_attached_file :avatar, :default_url => :default_url_by_gender
  #
  #     private
  #
  #     def default_url_by_gender
  #       "/assets/avatars/default_#{gender}.png"
  #     end
  #   end
  #
  # source://paperclip//lib/paperclip.rb#197
  def has_attached_file(name, options = T.unsafe(nil)); end
end

# source://paperclip//lib/paperclip/content_type_detector.rb#2
class Paperclip::ContentTypeDetector
  # @return [ContentTypeDetector] a new instance of ContentTypeDetector
  #
  # source://paperclip//lib/paperclip/content_type_detector.rb#23
  def initialize(filepath); end

  # Returns a String describing the file's content type
  #
  # source://paperclip//lib/paperclip/content_type_detector.rb#28
  def detect; end

  private

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/content_type_detector.rb#42
  def blank_name?; end

  # source://paperclip//lib/paperclip/content_type_detector.rb#52
  def calculated_type_matches; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/content_type_detector.rb#46
  def empty?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/content_type_detector.rb#46
  def empty_file?; end

  # source://paperclip//lib/paperclip/content_type_detector.rb#58
  def possible_types; end

  # source://paperclip//lib/paperclip/content_type_detector.rb#75
  def type_from_file_command; end

  # source://paperclip//lib/paperclip/content_type_detector.rb#62
  def type_from_file_contents; end

  # source://paperclip//lib/paperclip/content_type_detector.rb#69
  def type_from_mime_magic; end
end

# The content-type detection strategy is as follows:
#
# 1. Blank/Empty files: If there's no filepath or the file is empty,
#    provide a sensible default (application/octet-stream or inode/x-empty)
#
# 2. Calculated match: Return the first result that is found by both the
#    `file` command and MIME::Types.
#
# 3. Standard types: Return the first standard (without an x- prefix) entry
#    in MIME::Types
#
# 4. Experimental types: If there were no standard types in MIME::Types
#    list, try to return the first experimental one
#
# 5. Raw `file` command: Just use the output of the `file` command raw, or
#    a sensible default. This is cached from Step 2.
#
# source://paperclip//lib/paperclip/content_type_detector.rb#20
Paperclip::ContentTypeDetector::EMPTY_TYPE = T.let(T.unsafe(nil), String)

# source://paperclip//lib/paperclip/content_type_detector.rb#21
Paperclip::ContentTypeDetector::SENSIBLE_DEFAULT = T.let(T.unsafe(nil), String)

# source://paperclip//lib/paperclip/io_adapters/data_uri_adapter.rb#2
class Paperclip::DataUriAdapter < ::Paperclip::StringioAdapter
  # @return [DataUriAdapter] a new instance of DataUriAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/data_uri_adapter.rb#11
  def initialize(target_uri, options = T.unsafe(nil)); end

  private

  # source://paperclip//lib/paperclip/io_adapters/data_uri_adapter.rb#17
  def extract_target(uri); end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/data_uri_adapter.rb#3
    def register; end
  end
end

# source://paperclip//lib/paperclip/io_adapters/data_uri_adapter.rb#9
Paperclip::DataUriAdapter::REGEXP = T.let(T.unsafe(nil), Regexp)

# source://paperclip//lib/paperclip/io_adapters/empty_string_adapter.rb#2
class Paperclip::EmptyStringAdapter < ::Paperclip::AbstractAdapter
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/empty_string_adapter.rb#13
  def assignment?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/empty_string_adapter.rb#9
  def nil?; end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/empty_string_adapter.rb#3
    def register; end
  end
end

# A base error class for Paperclip. Most of the error that will be thrown
# from Paperclip will inherits from this class.
#
# source://paperclip//lib/paperclip/errors.rb#4
class Paperclip::Error < ::StandardError; end

# source://paperclip//lib/paperclip/errors.rb#7
module Paperclip::Errors; end

# Will be thrown when a command or executable is not found.
#
# source://paperclip//lib/paperclip/errors.rb#13
class Paperclip::Errors::CommandNotFoundError < ::Paperclip::Error; end

# Will be thrown if the interpolation is creating an infinite loop. If you
# are creating an interpolator which might cause an infinite loop, you
# should be throwing this error upon the infinite loop as well.
#
# source://paperclip//lib/paperclip/errors.rb#31
class Paperclip::Errors::InfiniteInterpolationError < ::Paperclip::Error; end

# Attachments require a content_type or file_name validator,
# or to have explicitly opted out of them.
#
# source://paperclip//lib/paperclip/errors.rb#18
class Paperclip::Errors::MissingRequiredValidatorError < ::Paperclip::Error; end

# Will be thrown when ImageMagic cannot determine the uploaded file's
# metadata, usually this would mean the file is not an image. If you are
# consistently receiving this error on PDFs make sure that you have
# installed Ghostscript.
#
# source://paperclip//lib/paperclip/errors.rb#25
class Paperclip::Errors::NotIdentifiedByImageMagickError < ::Paperclip::Error; end

# Will be thrown when a storage method is not found.
#
# source://paperclip//lib/paperclip/errors.rb#9
class Paperclip::Errors::StorageMethodNotFound < ::Paperclip::Error; end

# source://paperclip//lib/paperclip/io_adapters/file_adapter.rb#2
class Paperclip::FileAdapter < ::Paperclip::AbstractAdapter
  # @return [FileAdapter] a new instance of FileAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/file_adapter.rb#9
  def initialize(target, options = T.unsafe(nil)); end

  private

  # source://paperclip//lib/paperclip/io_adapters/file_adapter.rb#16
  def cache_current_values; end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/file_adapter.rb#3
    def register; end
  end
end

# source://paperclip//lib/paperclip/file_command_content_type_detector.rb#2
class Paperclip::FileCommandContentTypeDetector
  # @return [FileCommandContentTypeDetector] a new instance of FileCommandContentTypeDetector
  #
  # source://paperclip//lib/paperclip/file_command_content_type_detector.rb#5
  def initialize(filename); end

  # source://paperclip//lib/paperclip/file_command_content_type_detector.rb#9
  def detect; end

  private

  # source://paperclip//lib/paperclip/file_command_content_type_detector.rb#15
  def type_from_file_command; end
end

# source://paperclip//lib/paperclip/file_command_content_type_detector.rb#3
Paperclip::FileCommandContentTypeDetector::SENSIBLE_DEFAULT = T.let(T.unsafe(nil), String)

# source://paperclip//lib/paperclip/filename_cleaner.rb#2
class Paperclip::FilenameCleaner
  # @return [FilenameCleaner] a new instance of FilenameCleaner
  #
  # source://paperclip//lib/paperclip/filename_cleaner.rb#3
  def initialize(invalid_character_regex); end

  # source://paperclip//lib/paperclip/filename_cleaner.rb#7
  def call(filename); end
end

# Defines the geometry of an image.
#
# source://paperclip//lib/paperclip/geometry.rb#4
class Paperclip::Geometry
  # Gives a Geometry representing the given height and width
  #
  # @return [Geometry] a new instance of Geometry
  #
  # source://paperclip//lib/paperclip/geometry.rb#10
  def initialize(width = T.unsafe(nil), height = T.unsafe(nil), modifier = T.unsafe(nil)); end

  # The aspect ratio of the dimensions.
  #
  # source://paperclip//lib/paperclip/geometry.rb#60
  def aspect; end

  # Swaps the height and width if necessary
  #
  # source://paperclip//lib/paperclip/geometry.rb#37
  def auto_orient; end

  # Returns the value of attribute height.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def height; end

  # Sets the attribute height
  #
  # @param value the value to set the attribute height to.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def height=(_arg0); end

  # True if the dimensions represent a horizontal rectangle
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/geometry.rb#50
  def horizontal?; end

  # Same as to_s
  #
  # source://paperclip//lib/paperclip/geometry.rb#84
  def inspect; end

  # Returns the larger of the two dimensions
  #
  # source://paperclip//lib/paperclip/geometry.rb#65
  def larger; end

  # Returns the value of attribute modifier.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def modifier; end

  # Sets the attribute modifier
  #
  # @param value the value to set the attribute modifier to.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def modifier=(_arg0); end

  # resize to a new geometry
  #
  # @example
  #   Paperclip::Geometry.new(150, 150).resize_to('50x50!')
  #   #=> Paperclip::Geometry(50, 50)
  # @param geometry [String] the Paperclip geometry definition to resize to
  #
  # source://paperclip//lib/paperclip/geometry.rb#112
  def resize_to(geometry); end

  # Returns the smaller of the two dimensions
  #
  # source://paperclip//lib/paperclip/geometry.rb#70
  def smaller; end

  # True if the dimensions represent a square
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/geometry.rb#45
  def square?; end

  # Returns the width and height in a format suitable to be passed to Geometry.parse
  #
  # source://paperclip//lib/paperclip/geometry.rb#75
  def to_s; end

  # Returns the scaling and cropping geometries (in string-based ImageMagick format)
  # neccessary to transform this Geometry into the Geometry given. If crop is true,
  # then it is assumed the destination Geometry will be the exact final resolution.
  # In this case, the source Geometry is scaled so that an image containing the
  # destination Geometry would be completely filled by the source image, and any
  # overhanging image would be cropped. Useful for square thumbnail images. The cropping
  # is weighted at the center of the Geometry.
  #
  # source://paperclip//lib/paperclip/geometry.rb#95
  def transformation_to(dst, crop = T.unsafe(nil)); end

  # True if the dimensions represent a vertical rectangle
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/geometry.rb#55
  def vertical?; end

  # Returns the value of attribute width.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def width; end

  # Sets the attribute width
  #
  # @param value the value to set the attribute width to.
  #
  # source://paperclip//lib/paperclip/geometry.rb#5
  def width=(_arg0); end

  private

  # source://paperclip//lib/paperclip/geometry.rb#144
  def cropping(dst, ratio, scale); end

  # scale to the requested geometry and preserve the aspect ratio
  #
  # source://paperclip//lib/paperclip/geometry.rb#153
  def scale_to(new_geometry); end

  # source://paperclip//lib/paperclip/geometry.rb#136
  def scaling(dst, ratio); end

  class << self
    # Extracts the Geometry from a file (or path to a file)
    #
    # source://paperclip//lib/paperclip/geometry.rb#25
    def from_file(file); end

    # Extracts the Geometry from a "WxH,O" string
    # Where W is the width, H is the height,
    # and O is the EXIF orientation
    #
    # source://paperclip//lib/paperclip/geometry.rb#32
    def parse(string); end
  end
end

# source://paperclip//lib/paperclip/geometry.rb#7
Paperclip::Geometry::EXIF_ROTATED_ORIENTATION_VALUES = T.let(T.unsafe(nil), Array)

# source://paperclip//lib/paperclip/geometry_detector_factory.rb#2
class Paperclip::GeometryDetector
  # @return [GeometryDetector] a new instance of GeometryDetector
  #
  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#3
  def initialize(file); end

  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#8
  def make; end

  private

  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#15
  def geometry_string; end

  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#34
  def path; end

  # @raise [Errors::CommandNotFoundError]
  #
  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#44
  def raise_because_imagemagick_missing; end

  # source://paperclip//lib/paperclip/geometry_detector_factory.rb#38
  def raise_if_blank_file; end
end

# source://paperclip//lib/paperclip/geometry_parser_factory.rb#2
class Paperclip::GeometryParser
  # @return [GeometryParser] a new instance of GeometryParser
  #
  # source://paperclip//lib/paperclip/geometry_parser_factory.rb#4
  def initialize(string); end

  # source://paperclip//lib/paperclip/geometry_parser_factory.rb#8
  def make; end

  private

  # source://paperclip//lib/paperclip/geometry_parser_factory.rb#21
  def match; end
end

# source://paperclip//lib/paperclip/geometry_parser_factory.rb#3
Paperclip::GeometryParser::FORMAT = T.let(T.unsafe(nil), Regexp)

# source://paperclip//lib/paperclip/glue.rb#6
module Paperclip::Glue
  include ::Paperclip::Callbacks::Running
  include ::Paperclip::Callbacks
  include ::Paperclip::Validators::HelperMethods
  include ::Paperclip::Validators
  include ::Paperclip::Schema

  mixes_in_class_methods ::Paperclip::ClassMethods
  mixes_in_class_methods ::Paperclip::Callbacks::Defining
  mixes_in_class_methods ::Paperclip::Validators::ClassMethods
  mixes_in_class_methods ::Paperclip::Validators::HelperMethods

  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/glue.rb#7
    def included(base); end
  end
end

# source://paperclip//lib/paperclip/has_attached_file.rb#2
class Paperclip::HasAttachedFile
  # @return [HasAttachedFile] a new instance of HasAttachedFile
  #
  # source://paperclip//lib/paperclip/has_attached_file.rb#7
  def initialize(klass, name, options); end

  # source://paperclip//lib/paperclip/has_attached_file.rb#13
  def define; end

  private

  # source://paperclip//lib/paperclip/has_attached_file.rb#90
  def add_active_record_callbacks; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#103
  def add_paperclip_callbacks; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#81
  def add_required_validations; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#59
  def define_class_getter; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#26
  def define_flush_errors; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#33
  def define_getters; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#38
  def define_instance_getter; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#70
  def define_query; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#63
  def define_setter; end

  # source://paperclip//lib/paperclip/has_attached_file.rb#77
  def register_new_attachment; end

  class << self
    # source://paperclip//lib/paperclip/has_attached_file.rb#3
    def define_on(klass, name, options); end
  end
end

# source://paperclip//lib/paperclip/has_attached_file.rb#109
module Paperclip::HasAttachedFile::ClassMethods
  # source://paperclip//lib/paperclip/has_attached_file.rb#110
  def attachment_definitions; end
end

# source://paperclip//lib/paperclip/helpers.rb#2
module Paperclip::Helpers
  # source://paperclip//lib/paperclip/helpers.rb#46
  def class_for(class_name); end

  # @yield [_self]
  # @yieldparam _self [Paperclip::Helpers] the object that the method was called on
  #
  # source://paperclip//lib/paperclip/helpers.rb#3
  def configure; end

  # Find all instances of the given Active Record model +klass+ with attachment +name+.
  # This method is used by the refresh rake tasks.
  #
  # source://paperclip//lib/paperclip/helpers.rb#40
  def each_instance_with_attachment(klass, name); end

  # source://paperclip//lib/paperclip/helpers.rb#7
  def interpolates(key, &block); end

  # source://paperclip//lib/paperclip/helpers.rb#56
  def reset_duplicate_clash_check!; end

  # The run method takes the name of a binary to run, the arguments
  # to that binary, the values to interpolate and some local options.
  #
  #  :cmd -> The name of a binary to run.
  #
  #  :arguments -> The command line arguments to that binary.
  #
  #  :interpolation_values -> Values to be interpolated into the arguments.
  #
  #  :local_options -> The options to be used by Cocain::CommandLine.
  #                    These could be: runner
  #                                    logger
  #                                    swallow_stderr
  #                                    expected_outcodes
  #                                    environment
  #                                    runner_options
  #
  # source://paperclip//lib/paperclip/helpers.rb#28
  def run(cmd, arguments = T.unsafe(nil), interpolation_values = T.unsafe(nil), local_options = T.unsafe(nil)); end
end

# source://paperclip//lib/paperclip/io_adapters/http_url_proxy_adapter.rb#2
class Paperclip::HttpUrlProxyAdapter < ::Paperclip::UriAdapter
  # @return [HttpUrlProxyAdapter] a new instance of HttpUrlProxyAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/http_url_proxy_adapter.rb#11
  def initialize(target, options = T.unsafe(nil)); end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/http_url_proxy_adapter.rb#3
    def register; end
  end
end

# source://paperclip//lib/paperclip/io_adapters/http_url_proxy_adapter.rb#9
Paperclip::HttpUrlProxyAdapter::REGEXP = T.let(T.unsafe(nil), Regexp)

# source://paperclip//lib/paperclip/io_adapters/identity_adapter.rb#2
class Paperclip::IdentityAdapter < ::Paperclip::AbstractAdapter
  # @return [IdentityAdapter] a new instance of IdentityAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/identity_adapter.rb#9
  def initialize; end

  # source://paperclip//lib/paperclip/io_adapters/identity_adapter.rb#12
  def new(target, _); end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/identity_adapter.rb#3
    def register; end
  end
end

# This module contains all the methods that are available for interpolation
# in paths and urls. To add your own (or override an existing one), you
# can either open this module and define it, or call the
# Paperclip.interpolates method.
#
# source://paperclip//lib/paperclip/interpolations/plural_cache.rb#2
module Paperclip::Interpolations
  extend ::Paperclip::Interpolations

  # Returns the pluralized form of the attachment name. e.g.
  # "avatars" for an attachment of :avatar
  #
  # source://paperclip//lib/paperclip/interpolations.rb#193
  def attachment(attachment, style_name); end

  # Returns the basename of the file. e.g. "file" for "file.jpg"
  #
  # source://paperclip//lib/paperclip/interpolations.rb#98
  def basename(attachment, style_name); end

  # Returns the underscored, pluralized version of the class name.
  # e.g. "users" for the User class.
  # NOTE: The arguments need to be optional, because some tools fetch
  # all class names. Calling #class will return the expected class.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#92
  def class(attachment = T.unsafe(nil), style_name = T.unsafe(nil)); end

  # Returns an extension based on the content type. e.g. "jpeg" for
  # "image/jpeg". If the style has a specified format, it will override the
  # content-type detection.
  #
  # Each mime type generally has multiple extensions associated with it, so
  # if the extension from the original filename is one of these extensions,
  # that extension is used, otherwise, the first in the list is used.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#125
  def content_type_extension(attachment, style_name); end

  # Returns the dot+extension of the file. e.g. ".jpg" for "file.jpg"
  # If the style has a format defined, it will return the format instead
  # of the actual extension. If the extension is empty, no dot is added.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#113
  def dotextension(attachment, style_name); end

  # Returns the extension of the file. e.g. "jpg" for "file.jpg"
  # If the style has a format defined, it will return the format instead
  # of the actual extension.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#105
  def extension(attachment, style_name); end

  # Returns the filename, the same way as ":basename.:extension" would.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#50
  def filename(attachment, style_name); end

  # Returns the fingerprint of the instance.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#160
  def fingerprint(attachment, style_name); end

  # Returns a the attachment hash.  See Paperclip::Attachment#hash_key for
  # more details.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#166
  def hash(attachment = T.unsafe(nil), style_name = T.unsafe(nil)); end

  # Returns the id of the instance.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#150
  def id(attachment, style_name); end

  # Returns the id of the instance in a split path form. e.g. returns
  # 000/001/234 for an id of 1234.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#176
  def id_partition(attachment, style_name); end

  # Returns the #to_param of the instance.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#155
  def param(attachment, style_name); end

  # Returns the Rails.env constant.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#84
  def rails_env(attachment, style_name); end

  # Returns the Rails.root constant.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#79
  def rails_root(attachment, style_name); end

  # Returns the style, or the default style if nil is supplied.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#198
  def style(attachment, style_name); end

  # Returns the timestamp as defined by the <attachment>_updated_at field
  # in the server default time zone unless :use_global_time_zone is set
  # to false.  Note that a Rails.config.time_zone change will still
  # invalidate any path or URL that uses :timestamp.  For a
  # time_zone-agnostic timestamp, use #updated_at.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#68
  def timestamp(attachment, style_name); end

  # Returns an integer timestamp that is time zone-neutral, so that paths
  # remain valid even if a server's time zone changes.
  #
  # source://paperclip//lib/paperclip/interpolations.rb#74
  def updated_at(attachment, style_name); end

  # @raise [Errors::InfiniteInterpolationError]
  #
  # source://paperclip//lib/paperclip/interpolations.rb#58
  def url(attachment, style_name); end

  class << self
    # Hash access of interpolations. Included only for compatibility,
    # and is not intended for normal use.
    #
    # source://paperclip//lib/paperclip/interpolations.rb#19
    def [](name); end

    # Hash assignment of interpolations. Included only for compatibility,
    # and is not intended for normal use.
    #
    # source://paperclip//lib/paperclip/interpolations.rb#12
    def []=(name, block); end

    # Returns a sorted list of all interpolations.
    #
    # source://paperclip//lib/paperclip/interpolations.rb#24
    def all; end

    # Perform the actual interpolation. Takes the pattern to interpolate
    # and the arguments to pass, which are the attachment and style name.
    # You can pass a method name on your record as a symbol, which should turn
    # an interpolation pattern for Paperclip to use.
    #
    # source://paperclip//lib/paperclip/interpolations.rb#32
    def interpolate(pattern, *args); end

    # source://paperclip//lib/paperclip/interpolations.rb#41
    def interpolators_cache; end

    # source://paperclip//lib/paperclip/interpolations.rb#45
    def plural_cache; end
  end
end

# source://paperclip//lib/paperclip/interpolations.rb#8
Paperclip::Interpolations::ID_PARTITION_LIMIT = T.let(T.unsafe(nil), Integer)

# source://paperclip//lib/paperclip/interpolations/plural_cache.rb#3
class Paperclip::Interpolations::PluralCache
  # @return [PluralCache] a new instance of PluralCache
  #
  # source://paperclip//lib/paperclip/interpolations/plural_cache.rb#4
  def initialize; end

  # source://paperclip//lib/paperclip/interpolations/plural_cache.rb#9
  def pluralize_symbol(symbol); end

  # source://paperclip//lib/paperclip/interpolations/plural_cache.rb#13
  def underscore_and_pluralize_class(klass); end
end

# Returns the interpolated URL. Will raise an error if the url itself
# contains ":url" to prevent infinite recursion. This interpolation
# is used in the default :path to ease default specifications.
#
# source://paperclip//lib/paperclip/interpolations.rb#57
Paperclip::Interpolations::RIGHT_HERE = T.let(T.unsafe(nil), String)

# source://paperclip//lib/paperclip/logger.rb#2
module Paperclip::Logger
  # Log a paperclip-specific line. This will log to STDOUT
  # by default. Set Paperclip.options[:log] to false to turn off.
  #
  # source://paperclip//lib/paperclip/logger.rb#5
  def log(message); end

  # source://paperclip//lib/paperclip/logger.rb#9
  def logger; end

  # source://paperclip//lib/paperclip/logger.rb#13
  def logger=(logger); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/logger.rb#17
  def logging?; end
end

# source://paperclip//lib/paperclip/media_type_spoof_detector.rb#2
class Paperclip::MediaTypeSpoofDetector
  # @return [MediaTypeSpoofDetector] a new instance of MediaTypeSpoofDetector
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#7
  def initialize(file, name, content_type); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#13
  def spoofed?; end

  private

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#68
  def calculated_content_type; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#72
  def calculated_media_type; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#42
  def calculated_type_mismatch?; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#60
  def content_types_from_name; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#36
  def extension_type_mismatch?; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#89
  def filename_extension; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#28
  def has_extension?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#24
  def has_name?; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#85
  def mapped_content_type; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#47
  def mapping_override_mismatch?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#32
  def media_type_mismatch?; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#64
  def media_types_from_name; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#52
  def supplied_content_type; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#56
  def supplied_media_type; end

  # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#76
  def type_from_file_command; end

  class << self
    # source://paperclip//lib/paperclip/media_type_spoof_detector.rb#3
    def using(file, name, content_type); end
  end
end

# source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#2
class Paperclip::NilAdapter < ::Paperclip::AbstractAdapter
  # @return [NilAdapter] a new instance of NilAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#9
  def initialize(_target, _options = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#15
  def content_type; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#31
  def eof?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#23
  def nil?; end

  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#11
  def original_filename; end

  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#27
  def read(*_args); end

  # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#19
  def size; end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/nil_adapter.rb#3
    def register; end
  end
end

# Paperclip processors allow you to modify attached files when they are
# attached in any way you are able. Paperclip itself uses command-line
# programs for its included Thumbnail processor, but custom processors
# are not required to follow suit.
#
# Processors are required to be defined inside the Paperclip module and
# are also required to be a subclass of Paperclip::Processor. There is
# only one method you *must* implement to properly be a subclass:
# #make, but #initialize may also be of use. #initialize accepts 3
# arguments: the file that will be operated on (which is an instance of
# File), a hash of options that were defined in has_attached_file's
# style hash, and the Paperclip::Attachment itself. These are set as
# instance variables that can be used within `#make`.
#
# #make must return an instance of File (Tempfile is acceptable) which
# contains the results of the processing.
#
# See Paperclip.run for more information about using command-line
# utilities from within Processors.
#
# source://paperclip//lib/paperclip/processor.rb#21
class Paperclip::Processor
  # @return [Processor] a new instance of Processor
  #
  # source://paperclip//lib/paperclip/processor.rb#24
  def initialize(file, options = T.unsafe(nil), attachment = T.unsafe(nil)); end

  # Returns the value of attribute attachment.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def attachment; end

  # Sets the attribute attachment
  #
  # @param value the value to set the attribute attachment to.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def attachment=(_arg0); end

  # The convert method runs the convert binary with the provided arguments.
  # See Paperclip.run for the available options.
  #
  # source://paperclip//lib/paperclip/processor.rb#39
  def convert(arguments = T.unsafe(nil), local_options = T.unsafe(nil)); end

  # Returns the value of attribute file.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def file; end

  # Sets the attribute file
  #
  # @param value the value to set the attribute file to.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def file=(_arg0); end

  # The identify method runs the identify binary with the provided arguments.
  # See Paperclip.run for the available options.
  #
  # source://paperclip//lib/paperclip/processor.rb#49
  def identify(arguments = T.unsafe(nil), local_options = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/processor.rb#30
  def make; end

  # Returns the value of attribute options.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://paperclip//lib/paperclip/processor.rb#22
  def options=(_arg0); end

  class << self
    # source://paperclip//lib/paperclip/processor.rb#33
    def make(file, options = T.unsafe(nil), attachment = T.unsafe(nil)); end
  end
end

# source://paperclip//lib/paperclip/processor_helpers.rb#2
module Paperclip::ProcessorHelpers
  # source://paperclip//lib/paperclip/processor_helpers.rb#33
  def clear_processors!; end

  # source://paperclip//lib/paperclip/processor_helpers.rb#17
  def load_processor(name); end

  # source://paperclip//lib/paperclip/processor_helpers.rb#5
  def processor(name); end

  # You can add your own processor via the Paperclip configuration. Normally
  # Paperclip will load all processors from the
  # Rails.root/lib/paperclip_processors directory, but here you can add any
  # existing class using this mechanism.
  #
  #   Paperclip.configure do |c|
  #     c.register_processor :watermarker, WatermarkingProcessor.new
  #   end
  #
  # source://paperclip//lib/paperclip/processor_helpers.rb#45
  def register_processor(name, processor); end
end

# source://paperclip//lib/paperclip/processor_helpers.rb#3
class Paperclip::ProcessorHelpers::NoSuchProcessor < ::StandardError; end

# source://paperclip//lib/paperclip/validators.rb#20
Paperclip::REQUIRED_VALIDATORS = T.let(T.unsafe(nil), Array)

# source://paperclip//lib/paperclip/rails_environment.rb#2
class Paperclip::RailsEnvironment
  # source://paperclip//lib/paperclip/rails_environment.rb#7
  def get; end

  private

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/rails_environment.rb#21
  def rails_environment_exists?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/rails_environment.rb#17
  def rails_exists?; end

  class << self
    # source://paperclip//lib/paperclip/rails_environment.rb#3
    def get; end
  end
end

# Provides helper methods that can be used in migrations.
#
# source://paperclip//lib/paperclip/schema.rb#5
module Paperclip::Schema
  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/schema.rb#11
    def included(base); end
  end
end

# source://paperclip//lib/paperclip/schema.rb#6
Paperclip::Schema::COLUMNS = T.let(T.unsafe(nil), Hash)

# source://paperclip//lib/paperclip/schema.rb#65
module Paperclip::Schema::CommandRecorder
  # source://paperclip//lib/paperclip/schema.rb#66
  def add_attachment(*args); end

  private

  # source://paperclip//lib/paperclip/schema.rb#72
  def invert_add_attachment(args); end
end

# source://paperclip//lib/paperclip/schema.rb#18
module Paperclip::Schema::Statements
  # @raise [ArgumentError]
  #
  # source://paperclip//lib/paperclip/schema.rb#19
  def add_attachment(table_name, *attachment_names); end

  # source://paperclip//lib/paperclip/schema.rb#42
  def drop_attached_file(*args); end

  # @raise [ArgumentError]
  #
  # source://paperclip//lib/paperclip/schema.rb#32
  def remove_attachment(table_name, *attachment_names); end
end

# source://paperclip//lib/paperclip/schema.rb#48
module Paperclip::Schema::TableDefinition
  # source://paperclip//lib/paperclip/schema.rb#49
  def attachment(*attachment_names); end

  # source://paperclip//lib/paperclip/schema.rb#59
  def has_attached_file(*attachment_names); end
end

# source://paperclip//lib/paperclip/storage/filesystem.rb#2
module Paperclip::Storage; end

# The default place to store attachments is in the filesystem. Files on the local
# filesystem can be very easily served by Apache without requiring a hit to your app.
# They also can be processed more easily after they've been saved, as they're just
# normal files. There are two Filesystem-specific options for has_attached_file:
# * +path+: The location of the repository of attachments on disk. This can (and, in
#   almost all cases, should) be coordinated with the value of the +url+ option to
#   allow files to be saved into a place where Apache can serve them without
#   hitting your app. Defaults to
#   ":rails_root/public/:attachment/:id/:style/:basename.:extension"
#   By default this places the files in the app's public directory which can be served
#   directly. If you are using capistrano for deployment, a good idea would be to
#   make a symlink to the capistrano-created system directory from inside your app's
#   public directory.
#   See Paperclip::Attachment#interpolate for more information on variable interpolaton.
#     :path => "/var/app/attachments/:class/:id/:style/:basename.:extension"
# * +override_file_permissions+: This allows you to override the file permissions for files
#   saved by paperclip. If you set this to an explicit octal value (0755, 0644, etc) then
#   that value will be used to set the permissions for an uploaded file. The default is 0666.
#   If you set :override_file_permissions to false, the chmod will be skipped. This allows
#   you to use paperclip on filesystems that don't understand unix file permissions, and has the
#   added benefit of using the storage directories default umask on those that do.
#
# source://paperclip//lib/paperclip/storage/filesystem.rb#24
module Paperclip::Storage::Filesystem
  # source://paperclip//lib/paperclip/storage/filesystem.rb#84
  def copy_to_local_file(style, local_dest_path); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/filesystem.rb#28
  def exists?(style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/filesystem.rb#60
  def flush_deletes; end

  # source://paperclip//lib/paperclip/storage/filesystem.rb#36
  def flush_writes; end

  private

  # source://paperclip//lib/paperclip/storage/filesystem.rb#90
  def move_file(src, dest); end

  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/storage/filesystem.rb#25
    def extended(base); end
  end
end

# fog is a modern and versatile cloud computing library for Ruby.
# Among others, it supports Amazon S3 to store your files. In
# contrast to the outdated AWS-S3 gem it is actively maintained and
# supports multiple locations.
# Amazon's S3 file hosting service is a scalable, easy place to
# store files for distribution. You can find out more about it at
# http://aws.amazon.com/s3 There are a few fog-specific options for
# has_attached_file, which will be explained using S3 as an example:
# * +fog_credentials+: Takes a Hash with your credentials. For S3,
#   you can use the following format:
#     aws_access_key_id: '<your aws_access_key_id>'
#     aws_secret_access_key: '<your aws_secret_access_key>'
#     provider: 'AWS'
#     region: 'eu-west-1'
#     scheme: 'https'
# * +fog_directory+: This is the name of the S3 bucket that will
#   store your files.  Remember that the bucket must be unique across
#   all of Amazon S3. If the bucket does not exist, Paperclip will
#   attempt to create it.
# * +fog_file+: This can be hash or lambda returning hash. The
#   value is used as base properties for new uploaded file.
# * +path+: This is the key under the bucket in which the file will
#   be stored. The URL will be constructed from the bucket and the
#   path. This is what you will want to interpolate. Keys should be
#   unique, like filenames, and despite the fact that S3 (strictly
#   speaking) does not support directories, you can still use a / to
#   separate parts of your file name.
# * +fog_public+: (optional, defaults to true) Should the uploaded
#   files be public or not? (true/false)
# * +fog_host+: (optional) The fully-qualified domain name (FQDN)
#   that is the alias to the S3 domain of your bucket, e.g.
#   'http://images.example.com'. This can also be used in
#   conjunction with Cloudfront (http://aws.amazon.com/cloudfront)
# * +fog_options+: (optional) A hash of options that are passed
#   to fog when the file is created. For example, you could set
#   the multipart-chunk size to 100MB with a hash:
#     { :multipart_chunk_size => 104857600 }
#
# source://paperclip//lib/paperclip/storage/fog.rb#41
module Paperclip::Storage::Fog
  # source://paperclip//lib/paperclip/storage/fog.rb#173
  def copy_to_local_file(style, local_dest_path); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/fog.rb#63
  def exists?(style = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/fog.rb#152
  def expiring_url(time = T.unsafe(nil), style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/fog.rb#132
  def flush_deletes; end

  # source://paperclip//lib/paperclip/storage/fog.rb#103
  def flush_writes; end

  # source://paperclip//lib/paperclip/storage/fog.rb#71
  def fog_credentials; end

  # source://paperclip//lib/paperclip/storage/fog.rb#75
  def fog_file; end

  # source://paperclip//lib/paperclip/storage/fog.rb#88
  def fog_public(style = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/fog.rb#168
  def parse_credentials(creds); end

  # source://paperclip//lib/paperclip/storage/fog.rb#140
  def public_url(style = T.unsafe(nil)); end

  private

  # source://paperclip//lib/paperclip/storage/fog.rb#227
  def connection; end

  # source://paperclip//lib/paperclip/storage/fog.rb#187
  def convert_time(time); end

  # source://paperclip//lib/paperclip/storage/fog.rb#231
  def directory; end

  # source://paperclip//lib/paperclip/storage/fog.rb#235
  def directory_name; end

  # source://paperclip//lib/paperclip/storage/fog.rb#194
  def dynamic_fog_host_for_style(style); end

  # source://paperclip//lib/paperclip/storage/fog.rb#210
  def find_credentials(creds); end

  # source://paperclip//lib/paperclip/storage/fog.rb#202
  def host_name_for_directory; end

  # source://paperclip//lib/paperclip/storage/fog.rb#243
  def scheme; end

  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/storage/fog.rb#42
    def extended(base); end
  end
end

# source://paperclip//lib/paperclip/storage/fog.rb#61
Paperclip::Storage::Fog::AWS_BUCKET_SUBDOMAIN_RESTRICTON_REGEX = T.let(T.unsafe(nil), Regexp)

# Amazon's S3 file hosting service is a scalable, easy place to store files for
# distribution. You can find out more about it at http://aws.amazon.com/s3
#
# To use Paperclip with S3, include the +aws-sdk-s3+ gem in your Gemfile:
#   gem 'aws-sdk-s3'
# There are a few S3-specific options for has_attached_file:
# * +s3_credentials+: Takes a path, a File, a Hash or a Proc. The path (or File) must point
#   to a YAML file containing the +access_key_id+ and +secret_access_key+ that Amazon
#   gives you. You can 'environment-space' this just like you do to your
#   database.yml file, so different environments can use different accounts:
#     development:
#       access_key_id: 123...
#       secret_access_key: 123...
#     test:
#       access_key_id: abc...
#       secret_access_key: abc...
#     production:
#       access_key_id: 456...
#       secret_access_key: 456...
#   This is not required, however, and the file may simply look like this:
#     access_key_id: 456...
#     secret_access_key: 456...
#   In which case, those access keys will be used in all environments. You can also
#   put your bucket name in this file, instead of adding it to the code directly.
#   This is useful when you want the same account but a different bucket for
#   development versus production.
#   When using a Proc it provides a single parameter which is the attachment itself. A
#   method #instance is available on the attachment which will take you back to your
#   code. eg.
#     class User
#       has_attached_file :download,
#                         :storage => :s3,
#                         :s3_credentials => Proc.new{|a| a.instance.s3_credentials }
#
#       def s3_credentials
#         {:bucket => "xxx", :access_key_id => "xxx", :secret_access_key => "xxx"}
#       end
#     end
# * +s3_permissions+: This is a String that should be one of the "canned" access
#   policies that S3 provides (more information can be found here:
#   http://docs.aws.amazon.com/AmazonS3/latest/dev/ACLOverview.html)
#   The default for Paperclip is public-read.
#
#   You can set permission on a per style bases by doing the following:
#     :s3_permissions => {
#       :original => "private"
#     }
#   Or globally:
#     :s3_permissions => "private"
#
# * +s3_protocol+: The protocol for the URLs generated to your S3 assets.
#   Can be either 'http', 'https', or an empty string to generate
#   protocol-relative URLs. Defaults to empty string.
# * +s3_headers+: A hash of headers or a Proc. You may specify a hash such as
#   {'Expires' => 1.year.from_now.httpdate}. If you use a Proc, headers are determined at
#   runtime. Paperclip will call that Proc with attachment as the only argument.
#   Can be defined both globally and within a style-specific hash.
# * +bucket+: This is the name of the S3 bucket that will store your files. Remember
#   that the bucket must be unique across all of Amazon S3. If the bucket does not exist
#   Paperclip will attempt to create it. The bucket name will not be interpolated.
#   You can define the bucket as a Proc if you want to determine its name at runtime.
#   Paperclip will call that Proc with attachment as the only argument.
# * +s3_host_alias+: The fully-qualified domain name (FQDN) that is the alias to the
#   S3 domain of your bucket. Used with the :s3_alias_url url interpolation. See the
#   link in the +url+ entry for more information about S3 domains and buckets.
# * +s3_prefixes_in_alias+: The number of prefixes that is prepended by
#   s3_host_alias. This will remove the prefixes from the path in
#   :s3_alias_url url interpolation
# * +url+: There are four options for the S3 url. You can choose to have the bucket's name
#   placed domain-style (bucket.s3.amazonaws.com) or path-style (s3.amazonaws.com/bucket).
#   You can also specify a CNAME (which requires the CNAME to be specified as
#   :s3_alias_url. You can read more about CNAMEs and S3 at
#   http://docs.amazonwebservices.com/AmazonS3/latest/index.html?VirtualHosting.html
#   Normally, this won't matter in the slightest and you can leave the default (which is
#   path-style, or :s3_path_url). But in some cases paths don't work and you need to use
#   the domain-style (:s3_domain_url). Anything else here will be treated like path-style.
#
#   Notes:
#   * The value of this option is a string, not a symbol.
#     <b>right:</b> <tt>":s3_domain_url"</tt>
#     <b>wrong:</b> <tt>:s3_domain_url</tt>
#   * If you use a CNAME for use with CloudFront, you can NOT specify https as your
#     :s3_protocol;
#     This is *not supported* by S3/CloudFront. Finally, when using the host
#     alias, the :bucket parameter is ignored, as the hostname is used as the bucket name
#     by S3. The fourth option for the S3 url is :asset_host, which uses Rails' built-in
#     asset_host settings.
#   * To get the full url from a paperclip'd object, use the
#     image_path helper; this is what image_tag uses to generate the url for an img tag.
# * +path+: This is the key under the bucket in which the file will be stored. The
#   URL will be constructed from the bucket and the path. This is what you will want
#   to interpolate. Keys should be unique, like filenames, and despite the fact that
#   S3 (strictly speaking) does not support directories, you can still use a / to
#   separate parts of your file name.
# * +s3_host_name+: If you are using your bucket in Tokyo region
#   etc, write host_name (e.g., 's3-ap-northeast-1.amazonaws.com').
# * +s3_region+: For aws-sdk-s3, s3_region is required.
# * +s3_metadata+: These key/value pairs will be stored with the
#   object.  This option works by prefixing each key with
#   "x-amz-meta-" before sending it as a header on the object
#   upload request. Can be defined both globally and within a style-specific hash.
# * +s3_storage_class+: If this option is set to
#   <tt>:REDUCED_REDUNDANCY</tt>, the object will be stored using Reduced
#   Redundancy Storage. RRS enables customers to reduce their
#   costs by storing non-critical, reproducible data at lower
#   levels of redundancy than Amazon S3's standard storage.
# * +use_accelerate_endpoint+: Use accelerate endpoint
#   http://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html
#
#   You can set storage class on a per style bases by doing the following:
#     :s3_storage_class => {
#       :thumb => :REDUCED_REDUNDANCY
#     }
#
#   Or globally:
#     :s3_storage_class => :REDUCED_REDUNDANCY
#
#   Other storage classes, such as <tt>:STANDARD_IA</tt>, are also available—see the
#   documentation for the <tt>aws-sdk-s3</tt> gem for the full list.
#
# source://paperclip//lib/paperclip/storage/s3.rb#123
module Paperclip::Storage::S3
  # source://paperclip//lib/paperclip/storage/s3.rb#227
  def bucket_name; end

  # source://paperclip//lib/paperclip/storage/s3.rb#413
  def copy_to_local_file(style, local_dest_path); end

  # source://paperclip//lib/paperclip/storage/s3.rb#347
  def create_bucket; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/s3.rb#316
  def exists?(style = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#181
  def expiring_url(time = T.unsafe(nil), style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#401
  def flush_deletes; end

  # source://paperclip//lib/paperclip/storage/s3.rb#351
  def flush_writes; end

  # source://paperclip//lib/paperclip/storage/s3.rb#284
  def http_proxy_host; end

  # source://paperclip//lib/paperclip/storage/s3.rb#296
  def http_proxy_password; end

  # source://paperclip//lib/paperclip/storage/s3.rb#288
  def http_proxy_port; end

  # source://paperclip//lib/paperclip/storage/s3.rb#292
  def http_proxy_user; end

  # source://paperclip//lib/paperclip/storage/s3.rb#259
  def obtain_s3_instance_for(options); end

  # source://paperclip//lib/paperclip/storage/s3.rb#310
  def parse_credentials(creds); end

  # source://paperclip//lib/paperclip/storage/s3.rb#264
  def s3_bucket; end

  # source://paperclip//lib/paperclip/storage/s3.rb#193
  def s3_credentials; end

  # source://paperclip//lib/paperclip/storage/s3.rb#211
  def s3_host_alias; end

  # source://paperclip//lib/paperclip/storage/s3.rb#197
  def s3_host_name; end

  # source://paperclip//lib/paperclip/storage/s3.rb#233
  def s3_interface; end

  # source://paperclip//lib/paperclip/storage/s3.rb#272
  def s3_object(style_name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#326
  def s3_permissions(style = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#217
  def s3_prefixes_in_alias; end

  # source://paperclip//lib/paperclip/storage/s3.rb#336
  def s3_protocol(style = T.unsafe(nil), with_colon = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#204
  def s3_region; end

  # source://paperclip//lib/paperclip/storage/s3.rb#332
  def s3_storage_class(style = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/storage/s3.rb#221
  def s3_url_options; end

  # source://paperclip//lib/paperclip/storage/s3.rb#300
  def set_permissions(permissions); end

  # source://paperclip//lib/paperclip/storage/s3.rb#305
  def set_storage_class(storage_class); end

  # source://paperclip//lib/paperclip/storage/s3.rb#268
  def style_name_as_path(style_name); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/s3.rb#276
  def use_accelerate_endpoint?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/s3.rb#280
  def using_http_proxy?; end

  private

  # source://paperclip//lib/paperclip/storage/s3.rb#427
  def find_credentials(creds); end

  # source://paperclip//lib/paperclip/storage/s3.rb#446
  def merge_s3_headers(http_headers, s3_headers, s3_metadata); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/storage/s3.rb#442
  def use_secure_protocol?(style_name); end

  class << self
    # @private
    #
    # source://paperclip//lib/paperclip/storage/s3.rb#124
    def extended(base); end
  end
end

# source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#2
class Paperclip::StringioAdapter < ::Paperclip::AbstractAdapter
  # @return [StringioAdapter] a new instance of StringioAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#9
  def initialize(target, options = T.unsafe(nil)); end

  # Sets the attribute content_type
  #
  # @param value the value to set the attribute content_type to.
  #
  # source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#14
  def content_type=(_arg0); end

  private

  # source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#18
  def cache_current_values; end

  # source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#26
  def copy_to_tempfile(source); end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/stringio_adapter.rb#3
    def register; end
  end
end

# The Style class holds the definition of a thumbnail style,  applying
# whatever processing is required to normalize the definition and delaying
# the evaluation of block parameters until useful context is available.
#
# source://paperclip//lib/paperclip/style.rb#6
class Paperclip::Style
  # Creates a Style object. +name+ is the name of the attachment,
  # +definition+ is the style definition from has_attached_file, which
  # can be string, array or hash
  #
  # @return [Style] a new instance of Style
  #
  # source://paperclip//lib/paperclip/style.rb#13
  def initialize(name, definition, attachment); end

  # Supports getting and setting style properties with hash notation to ensure backwards-compatibility
  # eg. @attachment.styles[:large][:geometry]@ will still work
  #
  # source://paperclip//lib/paperclip/style.rb#85
  def [](key); end

  # source://paperclip//lib/paperclip/style.rb#93
  def []=(key, value); end

  # Returns the value of attribute attachment.
  #
  # source://paperclip//lib/paperclip/style.rb#8
  def attachment; end

  # source://paperclip//lib/paperclip/style.rb#53
  def convert_options; end

  # defaults to default format (nil by default)
  #
  # source://paperclip//lib/paperclip/style.rb#102
  def default_format; end

  # Returns the value of attribute format.
  #
  # source://paperclip//lib/paperclip/style.rb#8
  def format; end

  # returns the geometry string for this style
  # if a proc has been supplied, we call it here
  #
  # source://paperclip//lib/paperclip/style.rb#65
  def geometry; end

  # Returns the value of attribute name.
  #
  # source://paperclip//lib/paperclip/style.rb#8
  def name; end

  # Supplies the hash of options that processors expect to receive as their second argument
  # Arguments other than the standard geometry, format etc are just passed through from
  # initialization and any procs are called here, just before post-processing.
  #
  # source://paperclip//lib/paperclip/style.rb#72
  def processor_options; end

  # retrieves from the attachment the processors defined in the has_attached_file call
  # (which method (in the attachment) will call any supplied procs)
  # There is an important change of interface here: a style rule can set its own processors
  # by default we behave as before, though.
  # if a proc has been supplied, we call it here
  #
  # source://paperclip//lib/paperclip/style.rb#39
  def processors; end

  # source://paperclip//lib/paperclip/style.rb#58
  def source_file_options; end

  # retrieves from the attachment the whiny setting
  #
  # source://paperclip//lib/paperclip/style.rb#44
  def whiny; end

  # returns true if we're inclined to grumble
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/style.rb#49
  def whiny?; end
end

# Overriding some implementation of Tempfile
#
# source://paperclip//lib/paperclip/tempfile.rb#3
class Paperclip::Tempfile < ::Tempfile
  # Due to how ImageMagick handles its image format conversion and how
  # Tempfile handles its naming scheme, it is necessary to override how
  # Tempfile makes # its names so as to allow for file extensions. Idea
  # taken from the comments on this blog post:
  # http://marsorange.com/archives/of-mogrify-ruby-tempfile-dynamic-class-definitions
  #
  # This is Ruby 1.9.3's implementation.
  #
  # source://paperclip//lib/paperclip/tempfile.rb#11
  def make_tmpname(prefix_suffix, n); end
end

# source://paperclip//lib/paperclip/tempfile.rb#30
module Paperclip::TempfileEncoding
  # This overrides Tempfile#binmode to make sure that the extenal encoding
  # for binary mode is ASCII-8BIT. This behavior is what's in CRuby, but not
  # in JRuby
  #
  # source://paperclip//lib/paperclip/tempfile.rb#34
  def binmode; end
end

# source://paperclip//lib/paperclip/tempfile_factory.rb#2
class Paperclip::TempfileFactory
  # source://paperclip//lib/paperclip/tempfile_factory.rb#15
  def basename; end

  # source://paperclip//lib/paperclip/tempfile_factory.rb#11
  def extension; end

  # source://paperclip//lib/paperclip/tempfile_factory.rb#4
  def generate(name = T.unsafe(nil)); end

  # source://paperclip//lib/paperclip/tempfile_factory.rb#19
  def random_name; end
end

# Handles thumbnailing images that are uploaded.
#
# source://paperclip//lib/paperclip/thumbnail.rb#3
class Paperclip::Thumbnail < ::Paperclip::Processor
  # Creates a Thumbnail object set to work on the +file+ given. It
  # will attempt to transform the image into one defined by +target_geometry+
  # which is a "WxH"-style string. +format+ will be inferred from the +file+
  # unless specified. Thumbnail creation will raise no errors unless
  # +whiny+ is true (which it is, by default. If +convert_options+ is
  # set, the options will be appended to the convert command upon image conversion
  #
  # Options include:
  #
  #   +geometry+ - the desired width and height of the thumbnail (required)
  #   +file_geometry_parser+ - an object with a method named +from_file+ that takes an image file and produces its geometry and a +transformation_to+. Defaults to Paperclip::Geometry
  #   +string_geometry_parser+ - an object with a method named +parse+ that takes a string and produces an object with +width+, +height+, and +to_s+ accessors. Defaults to Paperclip::Geometry
  #   +source_file_options+ - flags passed to the +convert+ command that influence how the source file is read
  #   +convert_options+ - flags passed to the +convert+ command that influence how the image is processed
  #   +whiny+ - whether to raise an error when processing fails. Defaults to true
  #   +format+ - the desired filename extension
  #   +animated+ - whether to merge all the layers in the image. Defaults to true
  #   +frame_index+ - the frame index of the source file to render as the thumbnail
  #
  # @return [Thumbnail] a new instance of Thumbnail
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#30
  def initialize(file, options = T.unsafe(nil), attachment = T.unsafe(nil)); end

  # Returns the value of attribute animated.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def animated; end

  # Sets the attribute animated
  #
  # @param value the value to set the attribute animated to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def animated=(_arg0); end

  # Returns the value of attribute auto_orient.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def auto_orient; end

  # Sets the attribute auto_orient
  #
  # @param value the value to set the attribute auto_orient to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def auto_orient=(_arg0); end

  # Returns the value of attribute convert_options.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def convert_options; end

  # Sets the attribute convert_options
  #
  # @param value the value to set the attribute convert_options to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def convert_options=(_arg0); end

  # Returns true if the image is meant to make use of additional convert options.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#60
  def convert_options?; end

  # Returns true if the +target_geometry+ is meant to crop.
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#55
  def crop?; end

  # Returns the value of attribute current_geometry.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def current_geometry; end

  # Sets the attribute current_geometry
  #
  # @param value the value to set the attribute current_geometry to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def current_geometry=(_arg0); end

  # Returns the value of attribute format.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def format; end

  # Sets the attribute format
  #
  # @param value the value to set the attribute format to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def format=(_arg0); end

  # Returns the value of attribute frame_index.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def frame_index; end

  # Sets the attribute frame_index
  #
  # @param value the value to set the attribute frame_index to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def frame_index=(_arg0); end

  # Performs the conversion of the +file+ into a thumbnail. Returns the Tempfile
  # that contains the new image.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#66
  def make; end

  # Returns the value of attribute source_file_options.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def source_file_options; end

  # Sets the attribute source_file_options
  #
  # @param value the value to set the attribute source_file_options to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def source_file_options=(_arg0); end

  # Returns the value of attribute target_geometry.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def target_geometry; end

  # Sets the attribute target_geometry
  #
  # @param value the value to set the attribute target_geometry to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def target_geometry=(_arg0); end

  # Returns the command ImageMagick's +convert+ needs to transform the image
  # into the thumbnail.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#101
  def transformation_command; end

  # Returns the value of attribute whiny.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def whiny; end

  # Sets the attribute whiny
  #
  # @param value the value to set the attribute whiny to.
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#5
  def whiny=(_arg0); end

  protected

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#118
  def animated?; end

  # Return true if ImageMagick's +identify+ returns an animated format
  #
  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#123
  def identified_as_animated?; end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/thumbnail.rb#114
  def multi_frame_format?; end
end

# List of formats that we need to preserve animation
#
# source://paperclip//lib/paperclip/thumbnail.rb#9
Paperclip::Thumbnail::ANIMATED_FORMATS = T.let(T.unsafe(nil), Array)

# source://paperclip//lib/paperclip/thumbnail.rb#10
Paperclip::Thumbnail::MULTI_FRAME_FORMATS = T.let(T.unsafe(nil), Array)

# source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#2
class Paperclip::UploadedFileAdapter < ::Paperclip::AbstractAdapter
  # @return [UploadedFileAdapter] a new instance of UploadedFileAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#9
  def initialize(target, options = T.unsafe(nil)); end

  private

  # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#26
  def cache_current_values; end

  # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#32
  def content_type_detector; end

  # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#36
  def determine_content_type; end

  class << self
    # Returns the value of attribute content_type_detector.
    #
    # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#21
    def content_type_detector; end

    # Sets the attribute content_type_detector
    #
    # @param value the value to set the attribute content_type_detector to.
    #
    # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#21
    def content_type_detector=(_arg0); end

    # source://paperclip//lib/paperclip/io_adapters/uploaded_file_adapter.rb#3
    def register; end
  end
end

# source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#4
class Paperclip::UriAdapter < ::Paperclip::AbstractAdapter
  # @return [UriAdapter] a new instance of UriAdapter
  #
  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#13
  def initialize(target, options = T.unsafe(nil)); end

  # Sets the attribute content_type
  #
  # @param value the value to set the attribute content_type to.
  #
  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#5
  def content_type=(_arg0); end

  private

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#22
  def cache_current_values; end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#30
  def content_type_from_content; end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#59
  def copy_to_tempfile(src); end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#49
  def default_filename; end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#53
  def download_content; end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#34
  def filename_from_content_disposition; end

  # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#45
  def filename_from_path; end

  class << self
    # source://paperclip//lib/paperclip/io_adapters/uri_adapter.rb#7
    def register; end
  end
end

# source://paperclip//lib/paperclip/url_generator.rb#5
class Paperclip::UrlGenerator
  # @return [UrlGenerator] a new instance of UrlGenerator
  #
  # source://paperclip//lib/paperclip/url_generator.rb#6
  def initialize(attachment); end

  # source://paperclip//lib/paperclip/url_generator.rb#22
  def attachment_options(*_arg0, **_arg1, &_arg2); end

  # source://paperclip//lib/paperclip/url_generator.rb#10
  def for(style_name, options); end

  private

  # Returns the value of attribute attachment.
  #
  # source://paperclip//lib/paperclip/url_generator.rb#21
  def attachment; end

  # This method is all over the place.
  #
  # source://paperclip//lib/paperclip/url_generator.rb#25
  def default_url; end

  # source://paperclip//lib/paperclip/url_generator.rb#72
  def escape_regex; end

  # source://paperclip//lib/paperclip/url_generator.rb#64
  def escape_url(url); end

  # source://paperclip//lib/paperclip/url_generator.rb#56
  def escape_url_as_needed(url, options); end

  # source://paperclip//lib/paperclip/url_generator.rb#35
  def most_appropriate_url; end

  # source://paperclip//lib/paperclip/url_generator.rb#43
  def timestamp_as_needed(url, options); end

  # @return [Boolean]
  #
  # source://paperclip//lib/paperclip/url_generator.rb#52
  def timestamp_possible?; end
end

# source://paperclip//lib/paperclip/version.rb#3
Paperclip::VERSION = T.let(T.unsafe(nil), String)

# source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#2
module Paperclip::Validators
  extend ::ActiveSupport::Concern
  include ::Paperclip::Validators::HelperMethods

  mixes_in_class_methods ::Paperclip::Validators::ClassMethods
  mixes_in_class_methods ::Paperclip::Validators::HelperMethods
end

# source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#3
class Paperclip::Validators::AttachmentContentTypeValidator < ::ActiveModel::EachValidator
  # @return [AttachmentContentTypeValidator] a new instance of AttachmentContentTypeValidator
  #
  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#4
  def initialize(options); end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#46
  def allowed_types; end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#54
  def check_validity!; end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#50
  def forbidden_types; end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#42
  def mark_invalid(record, attribute, types); end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#36
  def validate_blacklist(record, attribute, value); end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#13
  def validate_each(record, attribute, value); end

  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#30
  def validate_whitelist(record, attribute, value); end

  class << self
    # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#9
    def helper_method_name; end
  end
end

# source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#3
class Paperclip::Validators::AttachmentFileNameValidator < ::ActiveModel::EachValidator
  # @return [AttachmentFileNameValidator] a new instance of AttachmentFileNameValidator
  #
  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#4
  def initialize(options); end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#46
  def allowed; end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#54
  def check_validity!; end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#50
  def forbidden; end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#42
  def mark_invalid(record, attribute, patterns); end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#36
  def validate_blacklist(record, attribute, value); end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#13
  def validate_each(record, attribute, value); end

  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#30
  def validate_whitelist(record, attribute, value); end

  class << self
    # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#9
    def helper_method_name; end
  end
end

# source://paperclip//lib/paperclip/validators/attachment_file_type_ignorance_validator.rb#5
class Paperclip::Validators::AttachmentFileTypeIgnoranceValidator < ::ActiveModel::EachValidator
  # source://paperclip//lib/paperclip/validators/attachment_file_type_ignorance_validator.rb#6
  def validate_each(record, attribute, value); end

  class << self
    # source://paperclip//lib/paperclip/validators/attachment_file_type_ignorance_validator.rb#11
    def helper_method_name; end
  end
end

# source://paperclip//lib/paperclip/validators/attachment_presence_validator.rb#5
class Paperclip::Validators::AttachmentPresenceValidator < ::ActiveModel::EachValidator
  # source://paperclip//lib/paperclip/validators/attachment_presence_validator.rb#6
  def validate_each(record, attribute, value); end

  class << self
    # source://paperclip//lib/paperclip/validators/attachment_presence_validator.rb#12
    def helper_method_name; end
  end
end

# source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#5
class Paperclip::Validators::AttachmentSizeValidator < ::ActiveModel::Validations::NumericalityValidator
  # @return [AttachmentSizeValidator] a new instance of AttachmentSizeValidator
  #
  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#8
  def initialize(options); end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#41
  def check_validity!; end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#17
  def validate_each(record, attr_name, value); end

  private

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#61
  def extract_option_value(option, option_value); end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#49
  def extract_options(options); end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#73
  def human_size(size); end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#84
  def max_value_in_human_size(record); end

  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#77
  def min_value_in_human_size(record); end

  class << self
    # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#13
    def helper_method_name; end
  end
end

# source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#6
Paperclip::Validators::AttachmentSizeValidator::AVAILABLE_CHECKS = T.let(T.unsafe(nil), Array)

# source://paperclip//lib/paperclip/validators.rb#22
module Paperclip::Validators::ClassMethods
  # source://paperclip//lib/paperclip/validators.rb#64
  def create_validating_before_filter(attribute, validator_class, options); end

  # source://paperclip//lib/paperclip/validators.rb#55
  def validate_before_processing(validator_class, options); end

  # This method is a shortcut to validator classes that is in
  # "Attachment...Validator" format. It is almost the same thing as the
  # +validates+ method that shipped with Rails, but this is customized to
  # be using with attachment validators. This is helpful when you're using
  # multiple attachment validators on a single attachment.
  #
  # Example of using the validator:
  #
  #   validates_attachment :avatar, :presence => true,
  #      :content_type => { :content_type => "image/jpg" },
  #      :size => { :in => 0..10.kilobytes }
  #
  # source://paperclip//lib/paperclip/validators.rb#35
  def validates_attachment(*attributes); end
end

# source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#61
module Paperclip::Validators::HelperMethods
  # Places ActiveModel validations on the presence of a file.
  # Options:
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run if this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  #
  # source://paperclip//lib/paperclip/validators/attachment_file_type_ignorance_validator.rb#22
  def do_not_validate_attachment_file_type(*attr_names); end

  # Places ActiveModel validations on the content type of the file
  # assigned. The possible options are:
  # * +content_type+: Allowed content types.  Can be a single content type
  #   or an array.  Each type can be a String or a Regexp. It should be
  #   noted that Internet Explorer uploads files with content_types that you
  #   may not expect. For example, JPEG images are given image/pjpeg and
  #   PNGs are image/x-png, so keep that in mind when determining how you
  #   match.  Allows all by default.
  # * +not+: Forbidden content types.
  # * +message+: The message to display when the uploaded file has an invalid
  #   content type.
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run is this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  # NOTE: If you do not specify an [attachment]_content_type field on your
  # model, content_type validation will work _ONLY upon assignment_ and
  # re-validation after the instance has been reloaded will always succeed.
  # You'll still need to have a virtual attribute (created by +attr_accessor+)
  # name +[attachment]_content_type+ to be able to use this validator.
  #
  # source://paperclip//lib/paperclip/validators/attachment_content_type_validator.rb#81
  def validates_attachment_content_type(*attr_names); end

  # Places ActiveModel validations on the name of the file
  # assigned. The possible options are:
  # * +matches+: Allowed filename patterns as Regexps. Can be a single one
  #   or an array.
  # * +not+: Forbidden file name patterns, specified the same was as +matches+.
  # * +message+: The message to display when the uploaded file has an invalid
  #   name.
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run is this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  #
  # source://paperclip//lib/paperclip/validators/attachment_file_name_validator.rb#72
  def validates_attachment_file_name(*attr_names); end

  # Places ActiveModel validations on the presence of a file.
  # Options:
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run if this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  #
  # source://paperclip//lib/paperclip/validators/attachment_presence_validator.rb#23
  def validates_attachment_presence(*attr_names); end

  # Places ActiveModel validations on the size of the file assigned. The
  # possible options are:
  # * +in+: a Range of bytes (i.e. +1..1.megabyte+),
  # * +less_than+: equivalent to :in => 0..options[:less_than]
  # * +greater_than+: equivalent to :in => options[:greater_than]..Infinity
  # * +message+: error message to display, use :min and :max as replacements
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run if this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  #
  # source://paperclip//lib/paperclip/validators/attachment_size_validator.rb#102
  def validates_attachment_size(*attr_names); end

  # Places ActiveModel validations on the presence of a file.
  # Options:
  # * +if+: A lambda or name of an instance method. Validation will only
  #   be run if this lambda or method returns true.
  # * +unless+: Same as +if+ but validates if lambda or method returns false.
  #
  # source://paperclip//lib/paperclip/validators/media_type_spoof_detection_validator.rb#24
  def validates_media_type_spoof_detection(*attr_names); end
end

# source://paperclip//lib/paperclip/validators/media_type_spoof_detection_validator.rb#5
class Paperclip::Validators::MediaTypeSpoofDetectionValidator < ::ActiveModel::EachValidator
  # source://paperclip//lib/paperclip/validators/media_type_spoof_detection_validator.rb#6
  def validate_each(record, attribute, value); end
end
