# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rack` gem.
# Please instead update this file by running `bin/tapioca gem rack`.


# The Rack main module, serving as a namespace for all core Rack
# modules and classes.
#
# All modules meant for use in your application are <tt>autoload</tt>ed here,
# so it should be enough just to <tt>require 'rack'</tt> in your code.
#
# source://rack//lib/rack/version.rb#14
module Rack
  class << self
    # Return the Rack release as a dotted string.
    #
    # source://rack//lib/rack/version.rb#18
    def release; end
  end
end

# source://rack//lib/rack.rb#60
module Rack::Auth; end

# Rack::Auth::AbstractHandler implements common authentication functionality.
#
# +realm+ should be set for all handlers.
#
# source://rack//lib/rack/auth/abstract/handler.rb#11
class Rack::Auth::AbstractHandler
  # @return [AbstractHandler] a new instance of AbstractHandler
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#15
  def initialize(app, realm = T.unsafe(nil), &authenticator); end

  # Returns the value of attribute realm.
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#13
  def realm; end

  # Sets the attribute realm
  #
  # @param value the value to set the attribute realm to.
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#13
  def realm=(_arg0); end

  private

  # source://rack//lib/rack/auth/abstract/handler.rb#31
  def bad_request; end

  # source://rack//lib/rack/auth/abstract/handler.rb#22
  def unauthorized(www_authenticate = T.unsafe(nil)); end
end

# source://rack//lib/rack/auth/abstract/request.rb#7
class Rack::Auth::AbstractRequest
  # @return [AbstractRequest] a new instance of AbstractRequest
  #
  # source://rack//lib/rack/auth/abstract/request.rb#9
  def initialize(env); end

  # source://rack//lib/rack/auth/abstract/request.rb#33
  def params; end

  # source://rack//lib/rack/auth/abstract/request.rb#25
  def parts; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/abstract/request.rb#17
  def provided?; end

  # source://rack//lib/rack/auth/abstract/request.rb#13
  def request; end

  # source://rack//lib/rack/auth/abstract/request.rb#29
  def scheme; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/abstract/request.rb#21
  def valid?; end

  private

  # source://rack//lib/rack/auth/abstract/request.rb#42
  def authorization_key; end
end

# source://rack//lib/rack/auth/abstract/request.rb#40
Rack::Auth::AbstractRequest::AUTHORIZATION_KEYS = T.let(T.unsafe(nil), Array)

# Rack::Auth::Basic implements HTTP Basic Authentication, as per RFC 2617.
#
# Initialize with the Rack application that you want protecting,
# and a block that checks if a username and password pair are valid.
#
# source://rack//lib/rack/auth/basic.rb#13
class Rack::Auth::Basic < ::Rack::Auth::AbstractHandler
  # source://rack//lib/rack/auth/basic.rb#15
  def call(env); end

  private

  # source://rack//lib/rack/auth/basic.rb#34
  def challenge; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/basic.rb#38
  def valid?(auth); end
end

# source://rack//lib/rack/auth/basic.rb#42
class Rack::Auth::Basic::Request < ::Rack::Auth::AbstractRequest
  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/basic.rb#43
  def basic?; end

  # source://rack//lib/rack/auth/basic.rb#47
  def credentials; end

  # source://rack//lib/rack/auth/basic.rb#51
  def username; end
end

# source://rack//lib/rack/builder.rb#6
Rack::BUILDER_TOPLEVEL_BINDING = T.let(T.unsafe(nil), Proc)

# Represents a 400 Bad Request error when input data fails to meet the
# requirements.
#
# source://rack//lib/rack/bad_request.rb#6
module Rack::BadRequest; end

# Proxy for response bodies allowing calling a block when
# the response body is closed (after the response has been fully
# sent to the client).
#
# source://rack//lib/rack/body_proxy.rb#7
class Rack::BodyProxy
  # Set the response body to wrap, and the block to call when the
  # response has been fully sent.
  #
  # @return [BodyProxy] a new instance of BodyProxy
  #
  # source://rack//lib/rack/body_proxy.rb#10
  def initialize(body, &block); end

  # If not already closed, close the wrapped body and
  # then call the block the proxy was initialized with.
  #
  # source://rack//lib/rack/body_proxy.rb#28
  def close; end

  # Whether the proxy is closed.  The proxy starts as not closed,
  # and becomes closed on the first call to close.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/body_proxy.rb#40
  def closed?; end

  # Delegate missing methods to the wrapped body.
  #
  # source://rack//lib/rack/body_proxy.rb#45
  def method_missing(method_name, *args, **_arg2, &block); end

  private

  # Return whether the wrapped body responds to the method.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/body_proxy.rb#17
  def respond_to_missing?(method_name, include_all = T.unsafe(nil)); end
end

# Rack::Builder provides a domain-specific language (DSL) to construct Rack
# applications. It is primarily used to parse +config.ru+ files which
# instantiate several middleware and a final application which are hosted
# by a Rack-compatible web server.
#
# Example:
#
#   app = Rack::Builder.new do
#     use Rack::CommonLogger
#     map "/ok" do
#       run lambda { |env| [200, {'content-type' => 'text/plain'}, ['OK']] }
#     end
#   end
#
#   run app
#
# Or
#
#   app = Rack::Builder.app do
#     use Rack::CommonLogger
#     run lambda { |env| [200, {'content-type' => 'text/plain'}, ['OK']] }
#   end
#
#   run app
#
# +use+ adds middleware to the stack, +run+ dispatches to an application.
# You can use +map+ to construct a Rack::URLMap in a convenient way.
#
# source://rack//lib/rack/builder.rb#36
class Rack::Builder
  # Initialize a new Rack::Builder instance.  +default_app+ specifies the
  # default application if +run+ is not called later.  If a block
  # is given, it is evaluated in the context of the instance.
  #
  # @return [Builder] a new instance of Builder
  #
  # source://rack//lib/rack/builder.rb#116
  def initialize(default_app = T.unsafe(nil), **options, &block); end

  # Call the Rack application generated by this builder instance. Note that
  # this rebuilds the Rack application and runs the warmup code (if any)
  # every time it is called, so it should not be used if performance is important.
  #
  # source://rack//lib/rack/builder.rb#276
  def call(env); end

  # Freeze the app (set using run) and all middleware instances when building the application
  # in to_app.
  #
  # source://rack//lib/rack/builder.rb#259
  def freeze_app; end

  # Creates a route within the application.  Routes under the mapped path will be sent to
  # the Rack application specified by run inside the block.  Other requests will be sent to the
  # default application specified by run outside the block.
  #
  #   class App
  #     def call(env)
  #       [200, {'content-type' => 'text/plain'}, ["Hello World"]]
  #     end
  #   end
  #
  #   class Heartbeat
  #     def call(env)
  #       [200, { "content-type" => "text/plain" }, ["OK"]]
  #     end
  #   end
  #
  #   app = Rack::Builder.app do
  #     map '/heartbeat' do
  #       run Heartbeat.new
  #     end
  #     run App.new
  #   end
  #
  #   run app
  #
  # The +use+ method can also be used inside the block to specify middleware to run under a specific path:
  #
  #   app = Rack::Builder.app do
  #     map '/heartbeat' do
  #       use Middleware
  #       run Heartbeat.new
  #     end
  #     run App.new
  #   end
  #
  # This example includes a piece of middleware which will run before +/heartbeat+ requests hit +Heartbeat+.
  #
  # Note that providing a +path+ of +/+ will ignore any default application given in a +run+ statement
  # outside the block.
  #
  # source://rack//lib/rack/builder.rb#252
  def map(path, &block); end

  # Any options provided to the Rack::Builder instance at initialization.
  # These options can be server-specific. Some general options are:
  #
  # * +:isolation+: One of +process+, +thread+ or +fiber+. The execution
  #   isolation model to use.
  #
  # source://rack//lib/rack/builder.rb#132
  def options; end

  # Takes a block or argument that is an object that responds to #call and
  # returns a Rack response.
  #
  # You can use a block:
  #
  #   run do |env|
  #     [200, { "content-type" => "text/plain" }, ["Hello World!"]]
  #   end
  #
  # You can also provide a lambda:
  #
  #   run lambda { |env| [200, { "content-type" => "text/plain" }, ["OK"]] }
  #
  # You can also provide a class instance:
  #
  #   class Heartbeat
  #     def call(env)
  #      [200, { "content-type" => "text/plain" }, ["OK"]]
  #     end
  #   end
  #
  #   run Heartbeat.new
  #
  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/builder.rb#193
  def run(app = T.unsafe(nil), &block); end

  # Return the Rack application generated by this instance.
  #
  # source://rack//lib/rack/builder.rb#264
  def to_app; end

  # Specifies middleware to use in a stack.
  #
  #   class Middleware
  #     def initialize(app)
  #       @app = app
  #     end
  #
  #     def call(env)
  #       env["rack.some_header"] = "setting an example"
  #       @app.call(env)
  #     end
  #   end
  #
  #   use Middleware
  #   run lambda { |env| [200, { "content-type" => "text/plain" }, ["OK"]] }
  #
  # All requests through to this application will first be processed by the middleware class.
  # The +call+ method in this example sets an additional environment key which then can be
  # referenced in the application if required.
  #
  # source://rack//lib/rack/builder.rb#159
  def use(middleware, *args, **_arg2, &block); end

  # Takes a lambda or block that is used to warm-up the application. This block is called
  # before the Rack application is returned by to_app.
  #
  #   warmup do |app|
  #     client = Rack::MockRequest.new(app)
  #     client.get('/')
  #   end
  #
  #   use SomeMiddleware
  #   run MyApp
  #
  # source://rack//lib/rack/builder.rb#209
  def warmup(prc = T.unsafe(nil), &block); end

  private

  # Generate a URLMap instance by generating new Rack applications for each
  # map block in this instance.
  #
  # source://rack//lib/rack/builder.rb#284
  def generate_map(default_app, mapping); end

  class << self
    # Create a new Rack::Builder instance and return the Rack application
    # generated from it.
    #
    # source://rack//lib/rack/builder.rb#136
    def app(default_app = T.unsafe(nil), &block); end

    # Load the given file as a rackup file, treating the
    # contents as if specified inside a Rack::Builder block.
    #
    # Ignores content in the file after +__END__+, so that
    # use of +__END__+ will not result in a syntax error.
    #
    # Example config.ru file:
    #
    #   $ cat config.ru
    #
    #   use Rack::ContentLength
    #   require './app.rb'
    #   run App
    #
    # source://rack//lib/rack/builder.rb#87
    def load_file(path, **options); end

    # Evaluate the given +builder_script+ string in the context of
    # a Rack::Builder block, returning a Rack application.
    #
    # source://rack//lib/rack/builder.rb#102
    def new_from_string(builder_script, path = T.unsafe(nil), **options); end

    # Parse the given config file to get a Rack application.
    #
    # If the config file ends in +.ru+, it is treated as a
    # rackup file and the contents will be treated as if
    # specified inside a Rack::Builder block.
    #
    # If the config file does not end in +.ru+, it is
    # required and Rack will use the basename of the file
    # to guess which constant will be the Rack application to run.
    #
    # Examples:
    #
    #   Rack::Builder.parse_file('config.ru')
    #   # Rack application built using Rack::Builder.new
    #
    #   Rack::Builder.parse_file('app.rb')
    #   # requires app.rb, which can be anywhere in Ruby's
    #   # load path. After requiring, assumes App constant
    #   # is a Rack application
    #
    #   Rack::Builder.parse_file('./my_app.rb')
    #   # requires ./my_app.rb, which should be in the
    #   # process's current directory.  After requiring,
    #   # assumes MyApp constant is a Rack application
    #
    # source://rack//lib/rack/builder.rb#65
    def parse_file(path, **options); end
  end
end

# https://stackoverflow.com/questions/2223882/whats-the-difference-between-utf-8-and-utf-8-without-bom
#
# source://rack//lib/rack/builder.rb#39
Rack::Builder::UTF_8_BOM = T.let(T.unsafe(nil), String)

# Response Header Keys
#
# source://rack//lib/rack/constants.rb#19
Rack::CACHE_CONTROL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#35
Rack::CONNECT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#20
Rack::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#21
Rack::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# Rack::Cascade tries a request on several apps, and returns the
# first response that is not 404 or 405 (or in a list of configured
# status codes).  If all applications tried return one of the configured
# status codes, return the last response.
#
# source://rack//lib/rack/cascade.rb#11
class Rack::Cascade
  # Set the apps to send requests to, and what statuses result in
  # cascading.  Arguments:
  #
  # apps: An enumerable of rack applications.
  # cascade_for: The statuses to use cascading for.  If a response is received
  #              from an app, the next app is tried.
  #
  # @return [Cascade] a new instance of Cascade
  #
  # source://rack//lib/rack/cascade.rb#21
  def initialize(apps, cascade_for = T.unsafe(nil)); end

  # Append an app to the list of apps to cascade.  This app will
  # be tried last.
  #
  # source://rack//lib/rack/cascade.rb#56
  def <<(app); end

  # Append an app to the list of apps to cascade.  This app will
  # be tried last.
  #
  # source://rack//lib/rack/cascade.rb#56
  def add(app); end

  # An array of applications to try in order.
  #
  # source://rack//lib/rack/cascade.rb#13
  def apps; end

  # Call each app in order.  If the responses uses a status that requires
  # cascading, try the next app.  If all responses require cascading,
  # return the response from the last app.
  #
  # source://rack//lib/rack/cascade.rb#32
  def call(env); end

  # Whether the given app is one of the apps to cascade to.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/cascade.rb#61
  def include?(app); end
end

# Rack::CommonLogger forwards every request to the given +app+, and
# logs a line in the
# {Apache common log format}[http://httpd.apache.org/docs/1.3/logs.html#common]
# to the configured logger.
#
# source://rack//lib/rack/common_logger.rb#13
class Rack::CommonLogger
  # +logger+ can be any object that supports the +write+ or +<<+ methods,
  # which includes the standard library Logger.  These methods are called
  # with a single string argument, the log message.
  # If +logger+ is nil, CommonLogger will fall back <tt>env['rack.errors']</tt>.
  #
  # @return [CommonLogger] a new instance of CommonLogger
  #
  # source://rack//lib/rack/common_logger.rb#29
  def initialize(app, logger = T.unsafe(nil)); end

  # Log all requests in common_log format after a response has been
  # returned.  Note that if the app raises an exception, the request
  # will not be logged, so if exception handling middleware are used,
  # they should be loaded after this middleware.  Additionally, because
  # the logging happens after the request body has been fully sent, any
  # exceptions raised during the sending of the response body will
  # cause the request not to be logged.
  #
  # source://rack//lib/rack/common_logger.rb#41
  def call(env); end

  private

  # Attempt to determine the content length for the response to
  # include it in the logged data.
  #
  # source://rack//lib/rack/common_logger.rb#83
  def extract_content_length(headers); end

  # Log the request to the configured logger.
  #
  # source://rack//lib/rack/common_logger.rb#52
  def log(env, status, response_headers, began_at); end
end

# Common Log Format: http://httpd.apache.org/docs/1.3/logs.html#common
#
#   lilith.local - - [07/Aug/2006 23:58:02 -0400] "GET / HTTP/1.1" 500 -
#
#   %{%s - %s [%s] "%s %s%s %s" %d %s\n} %
#
# The actual format is slightly different than the above due to the
# separation of SCRIPT_NAME and PATH_INFO, and because the elapsed
# time in seconds is included at the end.
#
# source://rack//lib/rack/common_logger.rb#23
Rack::CommonLogger::FORMAT = T.let(T.unsafe(nil), String)

# Middleware that enables conditional GET using if-none-match and
# if-modified-since. The application should set either or both of the
# last-modified or etag response headers according to RFC 2616. When
# either of the conditions is met, the response body is set to be zero
# length and the response status is set to 304 Not Modified.
#
# Applications that defer response body generation until the body's each
# message is received will avoid response body generation completely when
# a conditional GET matches.
#
# Adapted from Michael Klishin's Merb implementation:
# https://github.com/wycats/merb/blob/master/merb-core/lib/merb-core/rack/middleware/conditional_get.rb
#
# source://rack//lib/rack/conditional_get.rb#21
class Rack::ConditionalGet
  # @return [ConditionalGet] a new instance of ConditionalGet
  #
  # source://rack//lib/rack/conditional_get.rb#22
  def initialize(app); end

  # Return empty 304 response if the response has not been
  # modified since the last request.
  #
  # source://rack//lib/rack/conditional_get.rb#28
  def call(env); end

  private

  # Whether the etag response header matches the if-none-match request header.
  # If so, the request has not been modified.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#62
  def etag_matches?(none_match, headers); end

  # Return whether the response has not been modified since the
  # last request.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#51
  def fresh?(env, headers); end

  # Whether the last-modified response header matches the if-modified-since
  # request header.  If so, the request has not been modified.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#68
  def modified_since?(modified_since, headers); end

  # Return a Time object for the given string (which should be in RFC2822
  # format), or nil if the string cannot be parsed.
  #
  # source://rack//lib/rack/conditional_get.rb#75
  def to_rfc2822(since); end
end

# Rack::Config modifies the environment using the block given during
# initialization.
#
# Example:
#     use Rack::Config do |env|
#       env['my-key'] = 'some-value'
#     end
#
# source://rack//lib/rack/config.rb#11
class Rack::Config
  # @return [Config] a new instance of Config
  #
  # source://rack//lib/rack/config.rb#12
  def initialize(app, &block); end

  # source://rack//lib/rack/config.rb#17
  def call(env); end
end

# Sets the content-length header on responses that do not specify
# a content-length or transfer-encoding header.  Note that this
# does not fix responses that have an invalid content-length
# header specified.
#
# source://rack//lib/rack/content_length.rb#12
class Rack::ContentLength
  include ::Rack::Utils

  # @return [ContentLength] a new instance of ContentLength
  #
  # source://rack//lib/rack/content_length.rb#15
  def initialize(app); end

  # source://rack//lib/rack/content_length.rb#19
  def call(env); end
end

# Sets the content-type header on responses which don't have one.
#
# Builder Usage:
#   use Rack::ContentType, "text/plain"
#
# When no content type argument is provided, "text/html" is the
# default.
#
# source://rack//lib/rack/content_type.rb#15
class Rack::ContentType
  include ::Rack::Utils

  # @return [ContentType] a new instance of ContentType
  #
  # source://rack//lib/rack/content_type.rb#18
  def initialize(app, content_type = T.unsafe(nil)); end

  # source://rack//lib/rack/content_type.rb#23
  def call(env); end
end

# source://rack//lib/rack/constants.rb#32
Rack::DELETE = T.let(T.unsafe(nil), String)

# This middleware enables content encoding of http responses,
# usually for purposes of compression.
#
# Currently supported encodings:
#
# * gzip
# * identity (no transformation)
#
# This middleware automatically detects when encoding is supported
# and allowed. For example no encoding is made when a cache
# directive of 'no-transform' is present, when the response status
# code is one that doesn't allow an entity body, or when the body
# is empty.
#
# Note that despite the name, Deflater does not support the +deflate+
# encoding.
#
# source://rack//lib/rack/deflater.rb#28
class Rack::Deflater
  # Creates Rack::Deflater middleware. Options:
  #
  # :if :: a lambda enabling / disabling deflation based on returned boolean value
  #        (e.g <tt>use Rack::Deflater, :if => lambda { |*, body| sum=0; body.each { |i| sum += i.length }; sum > 512 }</tt>).
  #        However, be aware that calling `body.each` inside the block will break cases where `body.each` is not idempotent,
  #        such as when it is an +IO+ instance.
  # :include :: a list of content types that should be compressed. By default, all content types are compressed.
  # :sync :: determines if the stream is going to be flushed after every chunk.  Flushing after every chunk reduces
  #          latency for time-sensitive streaming applications, but hurts compression and throughput.
  #          Defaults to +true+.
  #
  # @return [Deflater] a new instance of Deflater
  #
  # source://rack//lib/rack/deflater.rb#39
  def initialize(app, options = T.unsafe(nil)); end

  # source://rack//lib/rack/deflater.rb#46
  def call(env); end

  private

  # Whether the body should be compressed.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/deflater.rb#136
  def should_deflate?(env, status, headers, body); end
end

# Body class used for gzip encoded responses.
#
# source://rack//lib/rack/deflater.rb#83
class Rack::Deflater::GzipStream
  # Initialize the gzip stream.  Arguments:
  # body :: Response body to compress with gzip
  # mtime :: The modification time of the body, used to set the
  #          modification time in the gzip header.
  # sync :: Whether to flush each gzip chunk as soon as it is ready.
  #
  # @return [GzipStream] a new instance of GzipStream
  #
  # source://rack//lib/rack/deflater.rb#92
  def initialize(body, mtime, sync); end

  # Close the original body if possible.
  #
  # source://rack//lib/rack/deflater.rb#128
  def close; end

  # Yield gzip compressed strings to the given block.
  #
  # source://rack//lib/rack/deflater.rb#99
  def each(&block); end

  # Call the block passed to #each with the gzipped data.
  #
  # source://rack//lib/rack/deflater.rb#123
  def write(data); end
end

# source://rack//lib/rack/deflater.rb#85
Rack::Deflater::GzipStream::BUFFER_LENGTH = T.let(T.unsafe(nil), Integer)

# Rack::Directory serves entries below the +root+ given, according to the
# path info of the Rack request. If a directory is found, the file's contents
# will be presented in an html based index. If a file is found, the env will
# be passed to the specified +app+.
#
# If +app+ is not specified, a Rack::Files of the same +root+ will be used.
#
# source://rack//lib/rack/directory.rb#19
class Rack::Directory
  # Set the root directory and application for serving files.
  #
  # @return [Directory] a new instance of Directory
  #
  # source://rack//lib/rack/directory.rb#83
  def initialize(root, app = T.unsafe(nil)); end

  # source://rack//lib/rack/directory.rb#89
  def call(env); end

  # Rack response to use for requests with invalid paths, or nil if path is valid.
  #
  # source://rack//lib/rack/directory.rb#109
  def check_bad_request(path_info); end

  # Rack response to use for requests with paths outside the root, or nil if path is inside the root.
  #
  # source://rack//lib/rack/directory.rb#119
  def check_forbidden(path_info); end

  # Rack response to use for unreadable and non-file, non-directory entries.
  #
  # source://rack//lib/rack/directory.rb#181
  def entity_not_found(path_info); end

  # Provide human readable file sizes
  #
  # source://rack//lib/rack/directory.rb#197
  def filesize_format(int); end

  # Internals of request handling.  Similar to call but does
  # not remove body for HEAD requests.
  #
  # source://rack//lib/rack/directory.rb#96
  def get(env); end

  # Rack response to use for directories under the root.
  #
  # source://rack//lib/rack/directory.rb#130
  def list_directory(path_info, path, script_name); end

  # Rack response to use for files and directories under the root.
  # Unreadable and non-file, non-directory entries will get a 404 response.
  #
  # source://rack//lib/rack/directory.rb#171
  def list_path(env, path, path_info, script_name); end

  # The root of the directory hierarchy.  Only requests for files and
  # directories inside of the root directory are supported.
  #
  # source://rack//lib/rack/directory.rb#80
  def root; end

  # File::Stat for the given path, but return nil for missing/bad entries.
  #
  # source://rack//lib/rack/directory.rb#163
  def stat(path); end
end

# source://rack//lib/rack/directory.rb#20
Rack::Directory::DIR_FILE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/directory.rb#43
Rack::Directory::DIR_PAGE_FOOTER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/directory.rb#21
Rack::Directory::DIR_PAGE_HEADER = T.let(T.unsafe(nil), String)

# Body class for directory entries, showing an index page with links
# to each file.
#
# source://rack//lib/rack/directory.rb#51
class Rack::Directory::DirectoryBody < ::Struct
  # Yield strings for each part of the directory entry
  #
  # @yield [DIR_PAGE_HEADER % [ show_path, show_path ]]
  #
  # source://rack//lib/rack/directory.rb#53
  def each; end

  private

  # Escape each element in the array of html strings.
  #
  # source://rack//lib/rack/directory.rb#73
  def DIR_FILE_escape(htmls); end
end

# Stolen from Ramaze
#
# source://rack//lib/rack/directory.rb#189
Rack::Directory::FILESIZE_FORMAT = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/constants.rb#22
Rack::ETAG = T.let(T.unsafe(nil), String)

# Automatically sets the etag header on all String bodies.
#
# The etag header is skipped if etag or last-modified headers are sent or if
# a sendfile body (body.responds_to :to_path) is given (since such cases
# should be handled by apache/nginx).
#
# On initialization, you can pass two parameters: a cache-control directive
# used when etag is absent and a directive when it is present. The first
# defaults to nil, while the second defaults to "max-age=0, private, must-revalidate"
#
# source://rack//lib/rack/etag.rb#18
class Rack::ETag
  # @return [ETag] a new instance of ETag
  #
  # source://rack//lib/rack/etag.rb#22
  def initialize(app, no_cache_control = T.unsafe(nil), cache_control = T.unsafe(nil)); end

  # source://rack//lib/rack/etag.rb#28
  def call(env); end

  private

  # source://rack//lib/rack/etag.rb#58
  def digest_body(body); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/etag.rb#50
  def etag_status?(status); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/etag.rb#54
  def skip_caching?(headers); end
end

# source://rack//lib/rack/etag.rb#20
Rack::ETag::DEFAULT_CACHE_CONTROL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/etag.rb#19
Rack::ETag::ETAG_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#23
Rack::EXPIRES = T.let(T.unsafe(nil), String)

# This middleware provides hooks to certain places in the request /
# response lifecycle.  This is so that middleware that don't need to filter
# the response data can safely leave it alone and not have to send messages
# down the traditional "rack stack".
#
# The events are:
#
# * on_start(request, response)
#
#   This event is sent at the start of the request, before the next
#   middleware in the chain is called.  This method is called with a request
#   object, and a response object.  Right now, the response object is always
#   nil, but in the future it may actually be a real response object.
#
# * on_commit(request, response)
#
#   The response has been committed.  The application has returned, but the
#   response has not been sent to the webserver yet.  This method is always
#   called with a request object and the response object.  The response
#   object is constructed from the rack triple that the application returned.
#   Changes may still be made to the response object at this point.
#
# * on_send(request, response)
#
#   The webserver has started iterating over the response body and presumably
#   has started sending data over the wire. This method is always called with
#   a request object and the response object.  The response object is
#   constructed from the rack triple that the application returned.  Changes
#   SHOULD NOT be made to the response object as the webserver has already
#   started sending data.  Any mutations will likely result in an exception.
#
# * on_finish(request, response)
#
#   The webserver has closed the response, and all data has been written to
#   the response socket.  The request and response object should both be
#   read-only at this point.  The body MAY NOT be available on the response
#   object as it may have been flushed to the socket.
#
# * on_error(request, response, error)
#
#   An exception has occurred in the application or an `on_commit` event.
#   This method will get the request, the response (if available) and the
#   exception that was raised.
#
# ## Order
#
# `on_start` is called on the handlers in the order that they were passed to
# the constructor.  `on_commit`, on_send`, `on_finish`, and `on_error` are
# called in the reverse order.  `on_finish` handlers are called inside an
# `ensure` block, so they are guaranteed to be called even if something
# raises an exception.  If something raises an exception in a `on_finish`
# method, then nothing is guaranteed.
#
# source://rack//lib/rack/events.rb#61
class Rack::Events
  # @return [Events] a new instance of Events
  #
  # source://rack//lib/rack/events.rb#106
  def initialize(app, handlers); end

  # source://rack//lib/rack/events.rb#111
  def call(env); end

  private

  # source://rack//lib/rack/events.rb#149
  def make_request(env); end

  # source://rack//lib/rack/events.rb#153
  def make_response(status, headers, body); end

  # source://rack//lib/rack/events.rb#137
  def on_commit(request, response); end

  # source://rack//lib/rack/events.rb#133
  def on_error(request, response, e); end

  # source://rack//lib/rack/events.rb#145
  def on_finish(request, response); end

  # source://rack//lib/rack/events.rb#141
  def on_start(request, response); end
end

# source://rack//lib/rack/events.rb#62
module Rack::Events::Abstract
  # source://rack//lib/rack/events.rb#66
  def on_commit(req, res); end

  # source://rack//lib/rack/events.rb#75
  def on_error(req, res, e); end

  # source://rack//lib/rack/events.rb#72
  def on_finish(req, res); end

  # source://rack//lib/rack/events.rb#69
  def on_send(req, res); end

  # source://rack//lib/rack/events.rb#63
  def on_start(req, res); end
end

# source://rack//lib/rack/events.rb#95
class Rack::Events::BufferedResponse < ::Rack::Response::Raw
  # @return [BufferedResponse] a new instance of BufferedResponse
  #
  # source://rack//lib/rack/events.rb#98
  def initialize(status, headers, body); end

  # Returns the value of attribute body.
  #
  # source://rack//lib/rack/events.rb#96
  def body; end

  # source://rack//lib/rack/events.rb#103
  def to_a; end
end

# source://rack//lib/rack/events.rb#79
class Rack::Events::EventedBodyProxy < ::Rack::BodyProxy
  # @return [EventedBodyProxy] a new instance of EventedBodyProxy
  #
  # source://rack//lib/rack/events.rb#82
  def initialize(body, request, response, handlers, &block); end

  # source://rack//lib/rack/events.rb#89
  def each; end

  # Returns the value of attribute request.
  #
  # source://rack//lib/rack/events.rb#80
  def request; end

  # Returns the value of attribute response.
  #
  # source://rack//lib/rack/events.rb#80
  def response; end
end

# Rack::Files serves files below the +root+ directory given, according to the
# path info of the Rack request.
# e.g. when Rack::Files.new("/etc") is used, you can access 'passwd' file
# as http://localhost:9292/passwd
#
# Handlers can detect if bodies are a Rack::Files, and use mechanisms
# like sendfile on the +path+.
#
# source://rack//lib/rack/files.rb#20
class Rack::Files
  # @return [Files] a new instance of Files
  #
  # source://rack//lib/rack/files.rb#27
  def initialize(root, headers = T.unsafe(nil), default_mime = T.unsafe(nil)); end

  # source://rack//lib/rack/files.rb#34
  def call(env); end

  # source://rack//lib/rack/files.rb#39
  def get(env); end

  # Returns the value of attribute root.
  #
  # source://rack//lib/rack/files.rb#25
  def root; end

  # source://rack//lib/rack/files.rb#68
  def serving(request, path); end

  private

  # source://rack//lib/rack/files.rb#190
  def fail(status, body, headers = T.unsafe(nil)); end

  # source://rack//lib/rack/files.rb#209
  def filesize(path); end

  # The MIME type for the contents of the file located at @path
  #
  # source://rack//lib/rack/files.rb#205
  def mime_type(path, default_mime); end
end

# source://rack//lib/rack/files.rb#21
Rack::Files::ALLOWED_VERBS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/files.rb#22
Rack::Files::ALLOW_HEADER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/files.rb#121
class Rack::Files::BaseIterator
  # @return [BaseIterator] a new instance of BaseIterator
  #
  # source://rack//lib/rack/files.rb#124
  def initialize(path, ranges, options); end

  # source://rack//lib/rack/files.rb#144
  def bytesize; end

  # source://rack//lib/rack/files.rb#153
  def close; end

  # source://rack//lib/rack/files.rb#130
  def each; end

  # Returns the value of attribute options.
  #
  # source://rack//lib/rack/files.rb#122
  def options; end

  # Returns the value of attribute path.
  #
  # source://rack//lib/rack/files.rb#122
  def path; end

  # Returns the value of attribute ranges.
  #
  # source://rack//lib/rack/files.rb#122
  def ranges; end

  private

  # source://rack//lib/rack/files.rb#171
  def each_range_part(file, range); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/files.rb#157
  def multipart?; end

  # source://rack//lib/rack/files.rb#161
  def multipart_heading(range); end
end

# source://rack//lib/rack/files.rb#184
class Rack::Files::Iterator < ::Rack::Files::BaseIterator
  # source://rack//lib/rack/files.rb#122
  def to_path; end
end

# source://rack//lib/rack/files.rb#23
Rack::Files::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)

# Rack::ForwardRequest gets caught by Rack::Recursive and redirects
# the current request to the app at +url+.
#
#   raise ForwardRequest.new("/not-found")
#
# source://rack//lib/rack/recursive.rb#14
class Rack::ForwardRequest < ::Exception
  # @return [ForwardRequest] a new instance of ForwardRequest
  #
  # source://rack//lib/rack/recursive.rb#17
  def initialize(url, env = T.unsafe(nil)); end

  # Returns the value of attribute env.
  #
  # source://rack//lib/rack/recursive.rb#15
  def env; end

  # Returns the value of attribute url.
  #
  # source://rack//lib/rack/recursive.rb#15
  def url; end
end

# HTTP method verbs
#
# source://rack//lib/rack/constants.rb#28
Rack::GET = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#33
Rack::HEAD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#7
Rack::HTTPS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#16
Rack::HTTP_COOKIE = T.let(T.unsafe(nil), String)

# Request env keys
#
# source://rack//lib/rack/constants.rb#5
Rack::HTTP_HOST = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#6
Rack::HTTP_PORT = T.let(T.unsafe(nil), String)

# Rack::Head returns an empty body for all HEAD requests. It leaves
# all other requests unchanged.
#
# source://rack//lib/rack/head.rb#9
class Rack::Head
  # @return [Head] a new instance of Head
  #
  # source://rack//lib/rack/head.rb#10
  def initialize(app); end

  # source://rack//lib/rack/head.rb#14
  def call(env); end
end

# Rack::Headers is a Hash subclass that downcases all keys.  It's designed
# to be used by rack applications that don't implement the Rack 3 SPEC
# (by using non-lowercase response header keys), automatically handling
# the downcasing of keys.
#
# source://rack//lib/rack/headers.rb#8
class Rack::Headers < ::Hash
  # source://rack//lib/rack/headers.rb#110
  def [](key); end

  # source://rack//lib/rack/headers.rb#114
  def []=(key, value); end

  # source://rack//lib/rack/headers.rb#119
  def assoc(key); end

  # @raise [TypeError]
  #
  # source://rack//lib/rack/headers.rb#123
  def compare_by_identity; end

  # source://rack//lib/rack/headers.rb#127
  def delete(key); end

  # source://rack//lib/rack/headers.rb#131
  def dig(key, *a); end

  # :nocov:
  #
  # source://rack//lib/rack/headers.rb#227
  def except(*a); end

  # source://rack//lib/rack/headers.rb#135
  def fetch(key, *default, &block); end

  # source://rack//lib/rack/headers.rb#140
  def fetch_values(*a); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/headers.rb#144
  def has_key?(key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/headers.rb#144
  def include?(key); end

  # source://rack//lib/rack/headers.rb#151
  def invert; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/headers.rb#144
  def key?(key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/headers.rb#144
  def member?(key); end

  # source://rack//lib/rack/headers.rb#157
  def merge(hash, &block); end

  # source://rack//lib/rack/headers.rb#186
  def merge!(hash, &block); end

  # source://rack//lib/rack/headers.rb#161
  def reject(&block); end

  # source://rack//lib/rack/headers.rb#167
  def replace(hash); end

  # source://rack//lib/rack/headers.rb#172
  def select(&block); end

  # :nocov:
  #
  # source://rack//lib/rack/headers.rb#205
  def slice(*a); end

  # source://rack//lib/rack/headers.rb#114
  def store(key, value); end

  # source://rack//lib/rack/headers.rb#178
  def to_proc; end

  # source://rack//lib/rack/headers.rb#211
  def transform_keys(&block); end

  # source://rack//lib/rack/headers.rb#215
  def transform_keys!; end

  # source://rack//lib/rack/headers.rb#182
  def transform_values(&block); end

  # source://rack//lib/rack/headers.rb#186
  def update(hash, &block); end

  # source://rack//lib/rack/headers.rb#198
  def values_at(*keys); end

  private

  # source://rack//lib/rack/headers.rb#234
  def downcase_key(key); end

  class << self
    # source://rack//lib/rack/headers.rb#91
    def [](*items); end
  end
end

# source://rack//lib/rack/headers.rb#9
Rack::Headers::KNOWN_HEADERS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/constants.rb#36
Rack::LINK = T.let(T.unsafe(nil), String)

# Rack::Lint validates your application and the requests and
# responses according to the Rack spec.
#
# source://rack//lib/rack/lint.rb#13
class Rack::Lint
  # @return [Lint] a new instance of Lint
  #
  # source://rack//lib/rack/lint.rb#19
  def initialize(app); end

  # AUTHORS: n.b. The trailing whitespace between paragraphs is important and
  # should not be removed. The whitespace creates paragraphs in the RDoc
  # output.
  #
  # This specification aims to formalize the Rack protocol. You
  # can (and should) use Rack::Lint to enforce it.
  #
  # When you develop middleware, be sure to add a Lint before and
  # after to catch all mistakes.
  #
  # = Rack applications
  #
  # A Rack application is a Ruby object (not a class) that
  # responds to +call+.
  #
  # source://rack//lib/rack/lint.rb#40
  def call(env = T.unsafe(nil)); end
end

# :stopdoc:
#
# source://rack//lib/rack/lint.rb#25
class Rack::Lint::LintError < ::RuntimeError; end

# source://rack//lib/rack/lint.rb#15
Rack::Lint::REQUEST_PATH_ABSOLUTE_FORM = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/lint.rb#17
Rack::Lint::REQUEST_PATH_ASTERISK_FORM = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/lint.rb#16
Rack::Lint::REQUEST_PATH_AUTHORITY_FORM = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/lint.rb#14
Rack::Lint::REQUEST_PATH_ORIGIN_FORM = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/lint.rb#44
class Rack::Lint::Wrapper
  # @return [Wrapper] a new instance of Wrapper
  #
  # source://rack//lib/rack/lint.rb#45
  def initialize(app, env); end

  # ==== Streaming Body
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#939
  def call(stream); end

  # ==== The +content-length+ Header
  #
  # source://rack//lib/rack/lint.rb#757
  def check_content_length_header(status, headers); end

  # ==== The +content-type+ Header
  #
  # source://rack//lib/rack/lint.rb#741
  def check_content_type_header(status, headers); end

  # === Early Hints
  #
  # The application or any middleware may call the <tt>rack.early_hints</tt>
  # with an object which would be valid as the headers of a Rack response.
  #
  # source://rack//lib/rack/lint.rb#657
  def check_early_hints(env); end

  # == The Environment
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#101
  def check_environment(env); end

  # === The Error Stream
  #
  # source://rack//lib/rack/lint.rb#531
  def check_error_stream(error); end

  # source://rack//lib/rack/lint.rb#731
  def check_header_value(key, value); end

  # === The Headers
  #
  # source://rack//lib/rack/lint.rb#691
  def check_headers(headers); end

  # === Hijacking
  #
  # The hijacking interfaces provides a means for an application to take
  # control of the HTTP connection. There are two distinct hijack
  # interfaces: full hijacking where the application takes over the raw
  # connection, and partial hijacking where the application takes over
  # just the response body stream. In both cases, the application is
  # responsible for closing the hijacked stream.
  #
  # Full hijacking only works with HTTP/1. Partial hijacking is functionally
  # equivalent to streaming bodies, and is still optionally supported for
  # backwards compatibility with older Rack versions.
  #
  # ==== Full Hijack
  #
  # Full hijack is used to completely take over an HTTP/1 connection. It
  # occurs before any headers are written and causes the request to
  # ignores any response generated by the application.
  #
  # It is intended to be used when applications need access to raw HTTP/1
  # connection.
  #
  # source://rack//lib/rack/lint.rb#591
  def check_hijack(env); end

  # ==== Partial Hijack
  #
  # Partial hijack is used for bi-directional streaming of the request and
  # response body. It occurs after the status and headers are written by
  # the server and causes the server to ignore the Body of the response.
  #
  # It is intended to be used when applications need bi-directional
  # streaming.
  #
  # source://rack//lib/rack/lint.rb#619
  def check_hijack_response(headers, env); end

  # === The Input Stream
  #
  # The input stream is an IO-like object which contains the raw HTTP
  # POST data.
  #
  # source://rack//lib/rack/lint.rb#427
  def check_input_stream(input); end

  # ==== The +rack.protocol+ Header
  #
  # source://rack//lib/rack/lint.rb#785
  def check_rack_protocol_header(status, headers); end

  # == The Response
  #
  # === The Status
  #
  # source://rack//lib/rack/lint.rb#680
  def check_status(status); end

  # Setting this value informs the server that it should perform a
  # connection upgrade. In HTTP/1, this is done using the +upgrade+
  # header. In HTTP/2, this is done by accepting the request.
  #
  # === The Body
  #
  # The Body is typically an +Array+ of +String+ instances, an enumerable
  # that yields +String+ instances, a +Proc+ instance, or a File-like
  # object.
  #
  # The Body must respond to +each+ or +call+. It may optionally respond
  # to +to_path+ or +to_ary+. A Body that responds to +each+ is considered
  # to be an Enumerable Body. A Body that responds to +call+ is considered
  # to be a Streaming Body.
  #
  # A Body that responds to both +each+ and +call+ must be treated as an
  # Enumerable Body, not a Streaming Body. If it responds to +each+, you
  # must call +each+ and not +call+. If the Body doesn't respond to
  # +each+, then you can assume it responds to +call+.
  #
  # The Body must either be consumed or returned. The Body is consumed by
  # optionally calling either +each+ or +call+.
  # Then, if the Body responds to +close+, it must be called to release
  # any resources associated with the generation of the body.
  # In other words, +close+ must always be called at least once; typically
  # after the web server has sent the response to the client, but also in
  # cases where the Rack application makes internal/virtual requests and
  # discards the response.
  #
  # source://rack//lib/rack/lint.rb#831
  def close; end

  # ==== Enumerable Body
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#865
  def each; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/lint.rb#910
  def respond_to?(name, *_arg1); end

  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#60
  def response; end

  # If the Body responds to +to_ary+, it must return an +Array+ whose
  # contents are identical to that produced by calling +each+.
  # Middleware may call +to_ary+ directly on the Body and return a new
  # Body in its place. In other words, middleware can only process the
  # Body directly if it responds to +to_ary+. If the Body responds to both
  # +to_ary+ and +close+, its implementation of +to_ary+ must call
  # +close+.
  #
  # source://rack//lib/rack/lint.rb#926
  def to_ary; end

  # source://rack//lib/rack/lint.rb#906
  def to_path; end

  # source://rack//lib/rack/lint.rb#770
  def verify_content_length(size); end

  # source://rack//lib/rack/lint.rb#847
  def verify_to_path; end
end

# source://rack//lib/rack/lint.rb#904
Rack::Lint::Wrapper::BODY_METHODS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/lint.rb#540
class Rack::Lint::Wrapper::ErrorWrapper
  # @return [ErrorWrapper] a new instance of ErrorWrapper
  #
  # source://rack//lib/rack/lint.rb#541
  def initialize(error); end

  # * +close+ must never be called on the error stream.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#563
  def close(*args); end

  # * +flush+ must be called without arguments and must be called
  #   in order to make the error appear for sure.
  #
  # source://rack//lib/rack/lint.rb#558
  def flush; end

  # * +puts+ must be called with a single argument that responds to +to_s+.
  #
  # source://rack//lib/rack/lint.rb#546
  def puts(str); end

  # * +write+ must be called with a single argument that is a String.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#551
  def write(str); end
end

# source://rack//lib/rack/lint.rb#445
class Rack::Lint::Wrapper::InputWrapper
  # @return [InputWrapper] a new instance of InputWrapper
  #
  # source://rack//lib/rack/lint.rb#446
  def initialize(input); end

  # * +close+ can be called on the input stream to indicate that
  #   any remaining input is not needed.
  #
  # source://rack//lib/rack/lint.rb#523
  def close(*args); end

  # * +each+ must be called without arguments and only yield Strings.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#511
  def each(*args); end

  # * +gets+ must be called without arguments and return a string,
  #   or +nil+ on EOF.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#452
  def gets(*args); end

  # * +read+ behaves like <tt>IO#read</tt>.
  #   Its signature is <tt>read([length, [buffer]])</tt>.
  #
  #   If given, +length+ must be a non-negative Integer (>= 0) or +nil+,
  #   and +buffer+ must be a String and may not be nil.
  #
  #   If +length+ is given and not nil, then this method reads at most
  #   +length+ bytes from the input stream.
  #
  #   If +length+ is not given or nil, then this method reads
  #   all data until EOF.
  #
  #   When EOF is reached, this method returns nil if +length+ is given
  #   and not nil, or "" if +length+ is not given or is nil.
  #
  #   If +buffer+ is given, then the read data will be placed
  #   into +buffer+ instead of a newly created String object.
  #
  # source://rack//lib/rack/lint.rb#478
  def read(*args); end
end

# source://rack//lib/rack/lint.rb#959
class Rack::Lint::Wrapper::StreamWrapper
  extend ::Forwardable

  # @return [StreamWrapper] a new instance of StreamWrapper
  #
  # source://rack//lib/rack/lint.rb#974
  def initialize(stream); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def <<(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close_read(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close_write(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def closed?(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def flush(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def read(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def write(*args, **_arg1, &block); end
end

# The semantics of these IO methods must be a best effort match to
# those of a normal Ruby IO or Socket object, using standard arguments
# and raising standard exceptions. Servers are encouraged to simply
# pass on real IO objects, although it is recognized that this approach
# is not directly compatible with HTTP/2.
#
# source://rack//lib/rack/lint.rb#967
Rack::Lint::Wrapper::StreamWrapper::REQUIRED_METHODS = T.let(T.unsafe(nil), Array)

# Rack::Lock locks every request inside a mutex, so that every request
# will effectively be executed synchronously.
#
# source://rack//lib/rack/lock.rb#8
class Rack::Lock
  # @return [Lock] a new instance of Lock
  #
  # source://rack//lib/rack/lock.rb#9
  def initialize(app, mutex = T.unsafe(nil)); end

  # source://rack//lib/rack/lock.rb#13
  def call(env); end

  private

  # source://rack//lib/rack/lock.rb#25
  def unlock; end
end

# Sets up rack.logger to write to rack.errors stream
#
# source://rack//lib/rack/logger.rb#10
class Rack::Logger
  # @return [Logger] a new instance of Logger
  #
  # source://rack//lib/rack/logger.rb#11
  def initialize(app, level = T.unsafe(nil)); end

  # source://rack//lib/rack/logger.rb#15
  def call(env); end
end

# Rack::MediaType parse media type and parameters out of content_type string
#
# source://rack//lib/rack/media_type.rb#6
class Rack::MediaType
  class << self
    # The media type parameters provided in CONTENT_TYPE as a Hash, or
    # an empty Hash if no CONTENT_TYPE or media-type parameters were
    # provided.  e.g., when the CONTENT_TYPE is "text/plain;charset=utf-8",
    # this method responds with the following Hash:
    #   { 'charset' => 'utf-8' }
    #
    # source://rack//lib/rack/media_type.rb#30
    def params(content_type); end

    # The media type (type/subtype) portion of the CONTENT_TYPE header
    # without any media type parameters. e.g., when CONTENT_TYPE is
    # "text/plain;charset=utf-8", the media-type is "text/plain".
    #
    # For more information on the use of media types in HTTP, see:
    # http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7
    #
    # source://rack//lib/rack/media_type.rb#16
    def type(content_type); end

    private

    # source://rack//lib/rack/media_type.rb#43
    def strip_doublequotes(str); end
  end
end

# source://rack//lib/rack/media_type.rb#7
Rack::MediaType::SPLIT_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/method_override.rb#8
class Rack::MethodOverride
  # @return [MethodOverride] a new instance of MethodOverride
  #
  # source://rack//lib/rack/method_override.rb#15
  def initialize(app); end

  # source://rack//lib/rack/method_override.rb#19
  def call(env); end

  # source://rack//lib/rack/method_override.rb#31
  def method_override(env); end

  private

  # source://rack//lib/rack/method_override.rb#44
  def allowed_methods; end

  # source://rack//lib/rack/method_override.rb#48
  def method_override_param(req); end
end

# source://rack//lib/rack/method_override.rb#13
Rack::MethodOverride::ALLOWED_METHODS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/method_override.rb#9
Rack::MethodOverride::HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/method_override.rb#12
Rack::MethodOverride::HTTP_METHOD_OVERRIDE_HEADER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/method_override.rb#11
Rack::MethodOverride::METHOD_OVERRIDE_PARAM_KEY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/mime.rb#4
module Rack::Mime
  private

  # Returns true if the given value is a mime match for the given mime match
  # specification, false otherwise.
  #
  #    Rack::Mime.match?('text/html', 'text/*') => true
  #    Rack::Mime.match?('text/plain', '*') => true
  #    Rack::Mime.match?('text/html', 'application/json') => false
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/mime.rb#30
  def match?(value, matcher); end

  # Returns String with mime type if found, otherwise use +fallback+.
  # +ext+ should be filename extension in the '.ext' format that
  #       File.extname(file) returns.
  # +fallback+ may be any object
  #
  # Also see the documentation for MIME_TYPES
  #
  # Usage:
  #     Rack::Mime.mime_type('.foo')
  #
  # This is a shortcut for:
  #     Rack::Mime::MIME_TYPES.fetch('.foo', 'application/octet-stream')
  #
  # source://rack//lib/rack/mime.rb#18
  def mime_type(ext, fallback = T.unsafe(nil)); end

  class << self
    # Returns true if the given value is a mime match for the given mime match
    # specification, false otherwise.
    #
    #    Rack::Mime.match?('text/html', 'text/*') => true
    #    Rack::Mime.match?('text/plain', '*') => true
    #    Rack::Mime.match?('text/html', 'application/json') => false
    #
    # @return [Boolean]
    #
    # source://rack//lib/rack/mime.rb#30
    def match?(value, matcher); end

    # Returns String with mime type if found, otherwise use +fallback+.
    # +ext+ should be filename extension in the '.ext' format that
    #       File.extname(file) returns.
    # +fallback+ may be any object
    #
    # Also see the documentation for MIME_TYPES
    #
    # Usage:
    #     Rack::Mime.mime_type('.foo')
    #
    # This is a shortcut for:
    #     Rack::Mime::MIME_TYPES.fetch('.foo', 'application/octet-stream')
    #
    # source://rack//lib/rack/mime.rb#18
    def mime_type(ext, fallback = T.unsafe(nil)); end
  end
end

# List of most common mime-types, selected various sources
# according to their usefulness in a webserving scope for Ruby
# users.
#
# To amend this list with your local mime.types list you can use:
#
#     require 'webrick/httputils'
#     list = WEBrick::HTTPUtils.load_mime_types('/etc/mime.types')
#     Rack::Mime::MIME_TYPES.merge!(list)
#
# N.B. On Ubuntu the mime.types file does not include the leading period, so
# users may need to modify the data before merging into the hash.
#
# source://rack//lib/rack/mime.rb#51
Rack::Mime::MIME_TYPES = T.let(T.unsafe(nil), Hash)

# Rack::MockRequest helps testing your Rack application without
# actually using HTTP.
#
# After performing a request on a URL with get/post/put/patch/delete, it
# returns a MockResponse with useful helper methods for effective
# testing.
#
# You can pass a hash with additional configuration to the
# get/post/put/patch/delete.
# <tt>:input</tt>:: A String or IO-like to be used as rack.input.
# <tt>:fatal</tt>:: Raise a FatalWarning if the app writes to rack.errors.
# <tt>:lint</tt>:: If true, wrap the application in a Rack::Lint.
#
# source://rack//lib/rack/mock_request.rb#23
class Rack::MockRequest
  # @return [MockRequest] a new instance of MockRequest
  #
  # source://rack//lib/rack/mock_request.rb#44
  def initialize(app); end

  # Make a DELETE request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#57
  def delete(uri, opts = T.unsafe(nil)); end

  # Make a GET request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#49
  def get(uri, opts = T.unsafe(nil)); end

  # Make a HEAD request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#59
  def head(uri, opts = T.unsafe(nil)); end

  # Make an OPTIONS request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#61
  def options(uri, opts = T.unsafe(nil)); end

  # Make a PATCH request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#55
  def patch(uri, opts = T.unsafe(nil)); end

  # Make a POST request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#51
  def post(uri, opts = T.unsafe(nil)); end

  # Make a PUT request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock_request.rb#53
  def put(uri, opts = T.unsafe(nil)); end

  # Make a request using the given request method for the given
  # uri to the rack application and return a MockResponse.
  # Options given are passed to MockRequest.env_for.
  #
  # source://rack//lib/rack/mock_request.rb#66
  def request(method = T.unsafe(nil), uri = T.unsafe(nil), opts = T.unsafe(nil)); end

  class << self
    # Return the Rack environment used for a request to +uri+.
    # All options that are strings are added to the returned environment.
    # Options:
    # :fatal :: Whether to raise an exception if request outputs to rack.errors
    # :input :: The rack.input to set
    # :http_version :: The SERVER_PROTOCOL to set
    # :method :: The HTTP request method to use
    # :params :: The params to use
    # :script_name :: The SCRIPT_NAME to set
    #
    # source://rack//lib/rack/mock_request.rb#98
    def env_for(uri = T.unsafe(nil), opts = T.unsafe(nil)); end

    # For historical reasons, we're pinning to RFC 2396.
    # URI::Parser = URI::RFC2396_Parser
    #
    # source://rack//lib/rack/mock_request.rb#84
    def parse_uri_rfc2396(uri); end
  end
end

# source://rack//lib/rack/mock_request.rb#27
class Rack::MockRequest::FatalWarner
  # source://rack//lib/rack/mock_request.rb#36
  def flush; end

  # @raise [FatalWarning]
  #
  # source://rack//lib/rack/mock_request.rb#28
  def puts(warning); end

  # source://rack//lib/rack/mock_request.rb#39
  def string; end

  # @raise [FatalWarning]
  #
  # source://rack//lib/rack/mock_request.rb#32
  def write(warning); end
end

# source://rack//lib/rack/mock_request.rb#24
class Rack::MockRequest::FatalWarning < ::RuntimeError; end

# Rack::MockResponse provides useful helpers for testing your apps.
# Usually, you don't create the MockResponse on your own, but use
# MockRequest.
#
# source://rack//lib/rack/mock_response.rb#13
class Rack::MockResponse < ::Rack::Response
  # @return [MockResponse] a new instance of MockResponse
  #
  # source://rack//lib/rack/mock_response.rb#24
  def initialize(status, headers, body, errors = T.unsafe(nil)); end

  # source://rack//lib/rack/mock_response.rb#39
  def =~(other); end

  # source://rack//lib/rack/mock_response.rb#47
  def body; end

  # source://rack//lib/rack/mock_response.rb#73
  def cookie(name); end

  # Headers
  #
  # source://rack//lib/rack/mock_response.rb#19
  def cookies; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/mock_response.rb#69
  def empty?; end

  # Errors
  #
  # source://rack//lib/rack/mock_response.rb#22
  def errors; end

  # Errors
  #
  # source://rack//lib/rack/mock_response.rb#22
  def errors=(_arg0); end

  # source://rack//lib/rack/mock_response.rb#43
  def match(other); end

  # Headers
  #
  # source://rack//lib/rack/mock_response.rb#19
  def original_headers; end

  private

  # source://rack//lib/rack/mock_response.rb#100
  def identify_cookie_attributes(cookie_filling); end

  # source://rack//lib/rack/mock_response.rb#79
  def parse_cookies_from_header; end

  class << self
    def [](*_arg0); end
  end
end

# A multipart form data parser, adapted from IOWA.
#
# Usually, Rack::Request#POST takes care of calling this.
#
# source://rack//lib/rack/multipart/parser.rb#9
module Rack::Multipart
  class << self
    # source://rack//lib/rack/multipart.rb#72
    def build_multipart(params, first = T.unsafe(nil)); end

    # source://rack//lib/rack/multipart.rb#68
    def extract_multipart(request, params = T.unsafe(nil)); end

    # source://rack//lib/rack/multipart.rb#48
    def parse_multipart(env, params = T.unsafe(nil)); end
  end
end

# Base class for multipart exceptions that do not subclass from
# other exception classes for backwards compatibility.
#
# source://rack//lib/rack/multipart/parser.rb#26
class Rack::Multipart::BoundaryTooLongError < ::StandardError
  include ::Rack::BadRequest
end

# source://rack//lib/rack/multipart/parser.rb#33
Rack::Multipart::EOL = T.let(T.unsafe(nil), String)

# Use specific error class when parsing multipart request
# that ends early.
#
# source://rack//lib/rack/multipart/parser.rb#20
class Rack::Multipart::EmptyContentError < ::EOFError
  include ::Rack::BadRequest
end

# Prefer to use the BoundaryTooLongError class or Rack::BadRequest.
#
# source://rack//lib/rack/multipart/parser.rb#31
Rack::Multipart::Error = Rack::Multipart::BoundaryTooLongError

# source://rack//lib/rack/multipart/generator.rb#7
class Rack::Multipart::Generator
  # @return [Generator] a new instance of Generator
  #
  # source://rack//lib/rack/multipart/generator.rb#8
  def initialize(params, first = T.unsafe(nil)); end

  # source://rack//lib/rack/multipart/generator.rb#16
  def dump; end

  private

  # source://rack//lib/rack/multipart/generator.rb#89
  def content_for_other(file, name); end

  # source://rack//lib/rack/multipart/generator.rb#77
  def content_for_tempfile(io, file, name); end

  # source://rack//lib/rack/multipart/generator.rb#52
  def flattened_params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/generator.rb#37
  def multipart?; end
end

# source://rack//lib/rack/multipart/parser.rb#34
Rack::Multipart::MULTIPART = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#16
Rack::Multipart::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart/parser.rb#36
Rack::Multipart::MULTIPART_CONTENT_DISPOSITION = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/parser.rb#37
Rack::Multipart::MULTIPART_CONTENT_ID = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/parser.rb#35
Rack::Multipart::MULTIPART_CONTENT_TYPE = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#18
class Rack::Multipart::MissingInputError < ::StandardError
  include ::Rack::BadRequest
end

# source://rack//lib/rack/multipart/parser.rb#10
class Rack::Multipart::MultipartPartLimitError < ::Errno::EMFILE
  include ::Rack::BadRequest
end

# source://rack//lib/rack/multipart/parser.rb#14
class Rack::Multipart::MultipartTotalPartLimitError < ::StandardError
  include ::Rack::BadRequest
end

# Accumulator for multipart form data, conforming to the QueryParser API.
# In future, the Parser could return the pair list directly, but that would
# change its API.
#
# source://rack//lib/rack/multipart.rb#25
class Rack::Multipart::ParamList
  # @return [ParamList] a new instance of ParamList
  #
  # source://rack//lib/rack/multipart.rb#34
  def initialize; end

  # source://rack//lib/rack/multipart.rb#38
  def <<(pair); end

  # source://rack//lib/rack/multipart.rb#42
  def to_params_hash; end

  class << self
    # source://rack//lib/rack/multipart.rb#26
    def make_params; end

    # source://rack//lib/rack/multipart.rb#30
    def normalize_params(params, key, value); end
  end
end

# source://rack//lib/rack/multipart/parser.rb#39
class Rack::Multipart::Parser
  # @return [Parser] a new instance of Parser
  #
  # source://rack//lib/rack/multipart/parser.rb#200
  def initialize(boundary, tempfile, bufsize, query_parser); end

  # source://rack//lib/rack/multipart/parser.rb#217
  def parse(io); end

  # source://rack//lib/rack/multipart/parser.rb#240
  def result; end

  # Returns the value of attribute state.
  #
  # source://rack//lib/rack/multipart/parser.rb#198
  def state; end

  private

  # Scan until the we find the start or end of the boundary.
  # If we find it, return the appropriate symbol for the start or
  # end of the boundary.  If we don't find the start or end of the
  # boundary, clear the buffer and return nil.
  #
  # source://rack//lib/rack/multipart/parser.rb#434
  def consume_boundary; end

  # From WEBrick::HTTPUtils
  #
  # source://rack//lib/rack/multipart/parser.rb#252
  def dequote(str); end

  # Return the related Encoding object. However, because
  # enc is submitted by the user, it may be invalid, so
  # use a binary encoding in that case.
  #
  # source://rack//lib/rack/multipart/parser.rb#489
  def find_encoding(enc); end

  # source://rack//lib/rack/multipart/parser.rb#294
  def handle_consume_token; end

  # source://rack//lib/rack/multipart/parser.rb#495
  def handle_empty_content!(content); end

  # This handles the initial parser state.  We read until we find the starting
  # boundary, then we can transition to the next state. If we find the ending
  # boundary, this is an invalid multipart upload, but keep scanning for opening
  # boundary in that case. If no boundary found, we need to keep reading data
  # and retry. It's highly unlikely the initial read will not consume the
  # boundary.  The client would have to deliberately craft a response
  # with the opening boundary beyond the buffer size for that to happen.
  #
  # source://rack//lib/rack/multipart/parser.rb#271
  def handle_fast_forward; end

  # source://rack//lib/rack/multipart/parser.rb#411
  def handle_mime_body; end

  # source://rack//lib/rack/multipart/parser.rb#306
  def handle_mime_head; end

  # source://rack//lib/rack/multipart/parser.rb#443
  def normalize_filename(filename); end

  # source://rack//lib/rack/multipart/parser.rb#258
  def read_data(io, outbuf); end

  # source://rack//lib/rack/multipart/parser.rb#456
  def tag_multipart_encoding(filename, content_type, name, body); end

  class << self
    # source://rack//lib/rack/multipart/parser.rb#87
    def parse(io, content_length, content_type, tmpfile, bufsize, qp); end

    # source://rack//lib/rack/multipart/parser.rb#80
    def parse_boundary(content_type); end
  end
end

# source://rack//lib/rack/multipart/parser.rb#40
Rack::Multipart::Parser::BUFSIZE = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/multipart/parser.rb#48
class Rack::Multipart::Parser::BoundedIO
  # @return [BoundedIO] a new instance of BoundedIO
  #
  # source://rack//lib/rack/multipart/parser.rb#49
  def initialize(io, content_length); end

  # source://rack//lib/rack/multipart/parser.rb#55
  def read(size, outbuf = T.unsafe(nil)); end
end

# source://rack//lib/rack/multipart/parser.rb#453
Rack::Multipart::Parser::CHARSET = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart/parser.rb#305
Rack::Multipart::Parser::CONTENT_DISPOSITION_MAX_BYTES = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/multipart/parser.rb#304
Rack::Multipart::Parser::CONTENT_DISPOSITION_MAX_PARAMS = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/multipart/parser.rb#107
class Rack::Multipart::Parser::Collector
  include ::Enumerable

  # @return [Collector] a new instance of Collector
  #
  # source://rack//lib/rack/multipart/parser.rb#143
  def initialize(tempfile); end

  # source://rack//lib/rack/multipart/parser.rb#149
  def each; end

  # source://rack//lib/rack/multipart/parser.rb#169
  def on_mime_body(mime_index, content); end

  # source://rack//lib/rack/multipart/parser.rb#173
  def on_mime_finish(mime_index); end

  # source://rack//lib/rack/multipart/parser.rb#153
  def on_mime_head(mime_index, head, filename, content_type, name); end

  private

  # source://rack//lib/rack/multipart/parser.rb#178
  def check_part_limits; end
end

# source://rack//lib/rack/multipart/parser.rb#131
class Rack::Multipart::Parser::Collector::BufferPart < ::Rack::Multipart::Parser::Collector::MimePart
  # source://rack//lib/rack/multipart/parser.rb#133
  def close; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/parser.rb#132
  def file?; end
end

# source://rack//lib/rack/multipart/parser.rb#108
class Rack::Multipart::Parser::Collector::MimePart < ::Struct
  # @yield [data]
  #
  # source://rack//lib/rack/multipart/parser.rb#109
  def get_data; end
end

# source://rack//lib/rack/multipart/parser.rb#136
class Rack::Multipart::Parser::Collector::TempfilePart < ::Rack::Multipart::Parser::Collector::MimePart
  # source://rack//lib/rack/multipart/parser.rb#138
  def close; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/parser.rb#137
  def file?; end
end

# source://rack//lib/rack/multipart/parser.rb#78
Rack::Multipart::Parser::EMPTY = T.let(T.unsafe(nil), Rack::Multipart::Parser::MultipartInfo)

# source://rack//lib/rack/multipart/parser.rb#77
class Rack::Multipart::Parser::MultipartInfo < ::Struct
  # Returns the value of attribute params
  #
  # @return [Object] the current value of params
  def params; end

  # Sets the attribute params
  #
  # @param value [Object] the value to set the attribute params to.
  # @return [Object] the newly set value
  def params=(_); end

  # Returns the value of attribute tmp_files
  #
  # @return [Object] the current value of tmp_files
  def tmp_files; end

  # Sets the attribute tmp_files
  #
  # @param value [Object] the value to set the attribute tmp_files to.
  # @return [Object] the newly set value
  def tmp_files=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rack//lib/rack/multipart/parser.rb#42
Rack::Multipart::Parser::TEMPFILE_FACTORY = T.let(T.unsafe(nil), Proc)

# source://rack//lib/rack/multipart/parser.rb#41
Rack::Multipart::Parser::TEXT_PLAIN = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart/uploaded_file.rb#8
class Rack::Multipart::UploadedFile
  # @return [UploadedFile] a new instance of UploadedFile
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#16
  def initialize(filepath = T.unsafe(nil), ct = T.unsafe(nil), bin = T.unsafe(nil), path: T.unsafe(nil), content_type: T.unsafe(nil), binary: T.unsafe(nil), filename: T.unsafe(nil), io: T.unsafe(nil)); end

  # The content type of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#14
  def content_type; end

  # The content type of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#14
  def content_type=(_arg0); end

  # source://rack//lib/rack/multipart/uploaded_file.rb#31
  def local_path; end

  # source://rack//lib/rack/multipart/uploaded_file.rb#40
  def method_missing(method_name, *args, &block); end

  # The filename, *not* including the path, of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#11
  def original_filename; end

  # source://rack//lib/rack/multipart/uploaded_file.rb#31
  def path; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#36
  def respond_to?(*args); end
end

# source://rack//lib/rack/null_logger.rb#6
class Rack::NullLogger
  # @return [NullLogger] a new instance of NullLogger
  #
  # source://rack//lib/rack/null_logger.rb#7
  def initialize(app); end

  # source://rack//lib/rack/null_logger.rb#45
  def <<(msg); end

  # source://rack//lib/rack/null_logger.rb#43
  def add(severity, message = T.unsafe(nil), progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#11
  def call(env); end

  # source://rack//lib/rack/null_logger.rb#42
  def close; end

  # source://rack//lib/rack/null_logger.rb#34
  def datetime_format; end

  # source://rack//lib/rack/null_logger.rb#39
  def datetime_format=(datetime_format); end

  # source://rack//lib/rack/null_logger.rb#17
  def debug(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#27
  def debug!; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#23
  def debug?; end

  # source://rack//lib/rack/null_logger.rb#19
  def error(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#28
  def error!; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#25
  def error?; end

  # source://rack//lib/rack/null_logger.rb#20
  def fatal(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#29
  def fatal!; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#26
  def fatal?; end

  # source://rack//lib/rack/null_logger.rb#35
  def formatter; end

  # source://rack//lib/rack/null_logger.rb#40
  def formatter=(formatter); end

  # source://rack//lib/rack/null_logger.rb#16
  def info(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#30
  def info!; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#22
  def info?; end

  # source://rack//lib/rack/null_logger.rb#32
  def level; end

  # source://rack//lib/rack/null_logger.rb#37
  def level=(level); end

  # source://rack//lib/rack/null_logger.rb#44
  def log(severity, message = T.unsafe(nil), progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#33
  def progname; end

  # source://rack//lib/rack/null_logger.rb#38
  def progname=(progname); end

  # source://rack//lib/rack/null_logger.rb#46
  def reopen(logdev = T.unsafe(nil)); end

  # source://rack//lib/rack/null_logger.rb#36
  def sev_threshold; end

  # source://rack//lib/rack/null_logger.rb#41
  def sev_threshold=(sev_threshold); end

  # source://rack//lib/rack/null_logger.rb#21
  def unknown(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#18
  def warn(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#31
  def warn!; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#24
  def warn?; end
end

# source://rack//lib/rack/constants.rb#34
Rack::OPTIONS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#31
Rack::PATCH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#8
Rack::PATH_INFO = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#29
Rack::POST = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#30
Rack::PUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#12
Rack::QUERY_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/query_parser.rb#7
class Rack::QueryParser
  # @return [QueryParser] a new instance of QueryParser
  #
  # source://rack//lib/rack/query_parser.rb#36
  def initialize(params_class, param_depth_limit); end

  # source://rack//lib/rack/query_parser.rb#166
  def make_params; end

  # source://rack//lib/rack/query_parser.rb#170
  def new_depth_limit(param_depth_limit); end

  # normalize_params recursively expands parameters into structural types. If
  # the structural types represented by two different parameter names are in
  # conflict, a ParameterTypeError is raised.  The depth argument is deprecated
  # and should no longer be used, it is kept for backwards compatibility with
  # earlier versions of rack.
  #
  # source://rack//lib/rack/query_parser.rb#94
  def normalize_params(params, name, v, _depth = T.unsafe(nil)); end

  # Returns the value of attribute param_depth_limit.
  #
  # source://rack//lib/rack/query_parser.rb#34
  def param_depth_limit; end

  # parse_nested_query expands a query string into structural types. Supported
  # types are Arrays, Hashes and basic value types. It is possible to supply
  # query strings with parameters of conflicting types, in this case a
  # ParameterTypeError is raised. Users are encouraged to return a 400 in this
  # case.
  #
  # source://rack//lib/rack/query_parser.rb#73
  def parse_nested_query(qs, separator = T.unsafe(nil)); end

  # Stolen from Mongrel, with some small modifications:
  # Parses a query string by breaking it up at the '&'.  You can also use this
  # to parse cookies by changing the characters used in the second parameter
  # (which defaults to '&').
  #
  # source://rack//lib/rack/query_parser.rb#45
  def parse_query(qs, separator = T.unsafe(nil), &unescaper); end

  private

  # @raise [ParamsTooDeepError]
  #
  # source://rack//lib/rack/query_parser.rb#98
  def _normalize_params(params, name, v, depth); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/query_parser.rb#180
  def params_hash_has_key?(hash, key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/query_parser.rb#176
  def params_hash_type?(obj); end

  # source://rack//lib/rack/query_parser.rb#192
  def unescape(string, encoding = T.unsafe(nil)); end

  class << self
    # source://rack//lib/rack/query_parser.rb#30
    def make_default(param_depth_limit); end
  end
end

# source://rack//lib/rack/query_parser.rb#9
Rack::QueryParser::COMMON_SEP = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/query_parser.rb#8
Rack::QueryParser::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# InvalidParameterError is the error that is raised when incoming structural
# parameters (parsed by parse_nested_query) contain invalid format or byte
# sequence.
#
# source://rack//lib/rack/query_parser.rb#20
class Rack::QueryParser::InvalidParameterError < ::ArgumentError
  include ::Rack::BadRequest
end

# ParameterTypeError is the error that is raised when incoming structural
# parameters (parsed by parse_nested_query) contain conflicting types.
#
# source://rack//lib/rack/query_parser.rb#13
class Rack::QueryParser::ParameterTypeError < ::TypeError
  include ::Rack::BadRequest
end

# source://rack//lib/rack/query_parser.rb#196
class Rack::QueryParser::Params < ::Hash
  def to_params_hash; end
end

# ParamsTooDeepError is the error that is raised when params are recursively
# nested over the specified limit.
#
# source://rack//lib/rack/query_parser.rb#26
class Rack::QueryParser::ParamsTooDeepError < ::RangeError
  include ::Rack::BadRequest
end

# source://rack//lib/rack/constants.rb#43
Rack::RACK_EARLY_HINTS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#44
Rack::RACK_ERRORS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#51
Rack::RACK_HIJACK = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#46
Rack::RACK_INPUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#52
Rack::RACK_IS_HIJACK = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#45
Rack::RACK_LOGGER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#66
Rack::RACK_METHODOVERRIDE_ORIGINAL_METHOD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#54
Rack::RACK_MULTIPART_BUFFER_SIZE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#55
Rack::RACK_MULTIPART_TEMPFILE_FACTORY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#53
Rack::RACK_RECURSIVE_INCLUDE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#62
Rack::RACK_REQUEST_COOKIE_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#63
Rack::RACK_REQUEST_COOKIE_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#61
Rack::RACK_REQUEST_FORM_ERROR = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#58
Rack::RACK_REQUEST_FORM_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#57
Rack::RACK_REQUEST_FORM_INPUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#59
Rack::RACK_REQUEST_FORM_PAIRS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#60
Rack::RACK_REQUEST_FORM_VARS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#64
Rack::RACK_REQUEST_QUERY_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#65
Rack::RACK_REQUEST_QUERY_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#56
Rack::RACK_RESPONSE_FINISHED = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#47
Rack::RACK_SESSION = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#48
Rack::RACK_SESSION_OPTIONS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#49
Rack::RACK_SHOWSTATUS_DETAIL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#42
Rack::RACK_TEMPFILES = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#50
Rack::RACK_URL_SCHEME = T.let(T.unsafe(nil), String)

# Rack environment variables
#
# source://rack//lib/rack/constants.rb#41
Rack::RACK_VERSION = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/version.rb#15
Rack::RELEASE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#9
Rack::REQUEST_METHOD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#10
Rack::REQUEST_PATH = T.let(T.unsafe(nil), String)

# Rack::Recursive allows applications called down the chain to
# include data from other applications (by using
# <tt>rack['rack.recursive.include'][...]</tt> or raise a
# ForwardRequest to redirect internally.
#
# source://rack//lib/rack/recursive.rb#36
class Rack::Recursive
  # @return [Recursive] a new instance of Recursive
  #
  # source://rack//lib/rack/recursive.rb#37
  def initialize(app); end

  # source://rack//lib/rack/recursive.rb#45
  def _call(env); end

  # source://rack//lib/rack/recursive.rb#41
  def call(env); end

  # source://rack//lib/rack/recursive.rb#52
  def include(env, path); end
end

# High performant source reloader
#
# This class acts as Rack middleware.
#
# What makes it especially suited for use in a production environment is that
# any file will only be checked once and there will only be made one system
# call stat(2).
#
# Please note that this will not reload files in the background, it does so
# only when actively called.
#
# It is performing a check/reload cycle at the start of every request, but
# also respects a cool down time, during which nothing will be done.
#
# source://rack//lib/rack/reloader.rb#24
class Rack::Reloader
  # @return [Reloader] a new instance of Reloader
  #
  # source://rack//lib/rack/reloader.rb#25
  def initialize(app, cooldown = T.unsafe(nil), backend = T.unsafe(nil)); end

  # source://rack//lib/rack/reloader.rb#36
  def call(env); end

  # source://rack//lib/rack/reloader.rb#50
  def reload!(stderr = T.unsafe(nil)); end

  # A safe Kernel::load, issuing the hooks depending on the results
  #
  # source://rack//lib/rack/reloader.rb#58
  def safe_load(file, mtime, stderr = T.unsafe(nil)); end
end

# source://rack//lib/rack/reloader.rb#68
module Rack::Reloader::Stat
  # Takes a relative or absolute +file+ name, a couple possible +paths+ that
  # the +file+ might reside in. Returns the full path and File::Stat for the
  # path.
  #
  # source://rack//lib/rack/reloader.rb#88
  def figure_path(file, paths); end

  # source://rack//lib/rack/reloader.rb#69
  def rotation; end

  # source://rack//lib/rack/reloader.rb#103
  def safe_stat(file); end
end

# Rack::Request provides a convenient interface to a Rack
# environment.  It is stateless, the environment +env+ passed to the
# constructor will be directly modified.
#
#   req = Rack::Request.new(env)
#   req.post?
#   req.params["data"]
#
# source://rack//lib/rack/request.rb#16
class Rack::Request
  include ::Rack::Request::Env
  include ::Rack::Request::Helpers

  # @return [Request] a new instance of Request
  #
  # source://rack//lib/rack/request.rb#62
  def initialize(env); end

  # source://rack//lib/rack/request.rb#76
  def delete_param(k); end

  # source://rack//lib/rack/request.rb#67
  def params; end

  # source://rack//lib/rack/request.rb#67
  def query; end

  # source://rack//lib/rack/request.rb#71
  def update_param(k, v); end

  # source://yard/0.9.37/lib/yard/server/rack_adapter.rb#94
  def version_supplied; end

  # source://yard/0.9.37/lib/yard/server/rack_adapter.rb#94
  def version_supplied=(_arg0); end

  # source://yard/0.9.37/lib/yard/server/rack_adapter.rb#96
  def xhr?; end

  class << self
    # The priority when checking forwarded headers. The default
    # is <tt>[:forwarded, :x_forwarded]</tt>, which means, check the
    # +Forwarded+ header first, followed by the appropriate
    # <tt>X-Forwarded-*</tt> header.  You can revert the priority by
    # reversing the priority, or remove checking of either
    # or both headers by removing elements from the array.
    #
    # This should be set as appropriate in your environment
    # based on what reverse proxies are in use.  If you are not
    # using reverse proxies, you should probably use an empty
    # array.
    #
    # source://rack//lib/rack/request.rb#31
    def forwarded_priority; end

    # The priority when checking forwarded headers. The default
    # is <tt>[:forwarded, :x_forwarded]</tt>, which means, check the
    # +Forwarded+ header first, followed by the appropriate
    # <tt>X-Forwarded-*</tt> header.  You can revert the priority by
    # reversing the priority, or remove checking of either
    # or both headers by removing elements from the array.
    #
    # This should be set as appropriate in your environment
    # based on what reverse proxies are in use.  If you are not
    # using reverse proxies, you should probably use an empty
    # array.
    #
    # source://rack//lib/rack/request.rb#31
    def forwarded_priority=(_arg0); end

    # Returns the value of attribute ip_filter.
    #
    # source://rack//lib/rack/request.rb#18
    def ip_filter; end

    # Sets the attribute ip_filter
    #
    # @param value the value to set the attribute ip_filter to.
    #
    # source://rack//lib/rack/request.rb#18
    def ip_filter=(_arg0); end

    # The priority when checking either the <tt>X-Forwarded-Proto</tt>
    # or <tt>X-Forwarded-Scheme</tt> header for the forwarded protocol.
    # The default is <tt>[:proto, :scheme]</tt>, to try the
    # <tt>X-Forwarded-Proto</tt> header before the
    # <tt>X-Forwarded-Scheme</tt> header.  Rack 2 had behavior
    # similar to <tt>[:scheme, :proto]</tt>.  You can remove either or
    # both of the entries in array to ignore that respective header.
    #
    # source://rack//lib/rack/request.rb#40
    def x_forwarded_proto_priority; end

    # The priority when checking either the <tt>X-Forwarded-Proto</tt>
    # or <tt>X-Forwarded-Scheme</tt> header for the forwarded protocol.
    # The default is <tt>[:proto, :scheme]</tt>, to try the
    # <tt>X-Forwarded-Proto</tt> header before the
    # <tt>X-Forwarded-Scheme</tt> header.  Rack 2 had behavior
    # similar to <tt>[:scheme, :proto]</tt>.  You can remove either or
    # both of the entries in array to ignore that respective header.
    #
    # source://rack//lib/rack/request.rb#40
    def x_forwarded_proto_priority=(_arg0); end
  end
end

# source://rack//lib/rack/request.rb#60
Rack::Request::ALLOWED_SCHEMES = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/request.rb#82
module Rack::Request::Env
  # source://rack//lib/rack/request.rb#86
  def initialize(env); end

  # Add a header that may have multiple values.
  #
  # Example:
  #   request.add_header 'Accept', 'image/png'
  #   request.add_header 'Accept', '*/*'
  #
  #   assert_equal 'image/png,*/*', request.get_header('Accept')
  #
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2
  #
  # source://rack//lib/rack/request.rb#129
  def add_header(key, v); end

  # Delete a request specific value for `name`.
  #
  # source://rack//lib/rack/request.rb#140
  def delete_header(name); end

  # Loops through each key / value pair in the request specific data.
  #
  # source://rack//lib/rack/request.rb#111
  def each_header(&block); end

  # The environment of the request.
  #
  # source://rack//lib/rack/request.rb#84
  def env; end

  # If a block is given, it yields to the block if the value hasn't been set
  # on the request.
  #
  # source://rack//lib/rack/request.rb#106
  def fetch_header(name, &block); end

  # Get a request specific value for `name`.
  #
  # source://rack//lib/rack/request.rb#100
  def get_header(name); end

  # Predicate method to test to see if `name` has been set as request
  # specific data
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#95
  def has_header?(name); end

  # Set a request specific value for `name` to `v`
  #
  # source://rack//lib/rack/request.rb#116
  def set_header(name, v); end

  private

  # source://rack//lib/rack/request.rb#144
  def initialize_copy(other); end
end

# source://rack//lib/rack/request.rb#149
module Rack::Request::Helpers
  # Returns the data received in the query string.
  #
  # source://rack//lib/rack/request.rb#484
  def GET; end

  # Returns the data received in the request body.
  #
  # This method support both application/x-www-form-urlencoded and
  # multipart/form-data.
  #
  # source://rack//lib/rack/request.rb#503
  def POST; end

  # source://rack//lib/rack/request.rb#607
  def accept_encoding; end

  # source://rack//lib/rack/request.rb#611
  def accept_language; end

  # The authority of the incoming request as defined by RFC3976.
  # https://tools.ietf.org/html/rfc3986#section-3.2
  #
  # In HTTP/1, this is the `host` header.
  # In HTTP/2, this is the `:authority` pseudo-header.
  #
  # source://rack//lib/rack/request.rb#266
  def authority; end

  # source://rack//lib/rack/request.rb#590
  def base_url; end

  # source://rack//lib/rack/request.rb#190
  def body; end

  # The character set of the request body if a "charset" media type
  # parameter was given, or nil if no "charset" was specified. Note
  # that, per RFC2616, text/* media types that specify no explicit
  # charset are to be considered ISO-8859-1.
  #
  # source://rack//lib/rack/request.rb#458
  def content_charset; end

  # source://rack//lib/rack/request.rb#199
  def content_length; end

  # source://rack//lib/rack/request.rb#308
  def content_type; end

  # source://rack//lib/rack/request.rb#293
  def cookies; end

  # Checks the HTTP request method (or verb) to see if it was of type DELETE
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#220
  def delete?; end

  # Destructively delete a parameter, whether it's in GET or POST. Returns the value of the deleted parameter.
  #
  # If the parameter is in both GET and POST, the POST value takes precedence since that's how #params works.
  #
  # <tt>env['rack.input']</tt> is not touched.
  #
  # source://rack//lib/rack/request.rb#585
  def delete_param(k); end

  # Determine whether the request body contains form-data by checking
  # the request content-type for one of the media-types:
  # "application/x-www-form-urlencoded" or "multipart/form-data". The
  # list of form-data media types can be modified through the
  # +FORM_DATA_MEDIA_TYPES+ array.
  #
  # A request body is also assumed to contain form-data when no
  # content-type header is provided and the request_method is POST.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#470
  def form_data?; end

  # source://rack//lib/rack/request.rb#393
  def forwarded_authority; end

  # source://rack//lib/rack/request.rb#353
  def forwarded_for; end

  # source://rack//lib/rack/request.rb#374
  def forwarded_port; end

  # source://rack//lib/rack/request.rb#603
  def fullpath; end

  # Checks the HTTP request method (or verb) to see if it was of type GET
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#223
  def get?; end

  # Checks the HTTP request method (or verb) to see if it was of type HEAD
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#226
  def head?; end

  # Returns a formatted host, suitable for being used in a URI.
  #
  # source://rack//lib/rack/request.rb#333
  def host; end

  # The `HTTP_HOST` header.
  #
  # source://rack//lib/rack/request.rb#318
  def host_authority; end

  # source://rack//lib/rack/request.rb#322
  def host_with_port(authority = T.unsafe(nil)); end

  # Returns an address suitable for being to resolve to an address.
  # In the case of a domain name or IPv4 address, the result is the same
  # as +host+. In the case of IPv6 or future address formats, the square
  # brackets are removed.
  #
  # source://rack//lib/rack/request.rb#341
  def hostname; end

  # source://rack//lib/rack/request.rb#414
  def ip; end

  # Checks the HTTP request method (or verb) to see if it was of type LINK
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#232
  def link?; end

  # source://rack//lib/rack/request.rb#200
  def logger; end

  # The media type (type/subtype) portion of the CONTENT_TYPE header
  # without any media type parameters. e.g., when CONTENT_TYPE is
  # "text/plain;charset=utf-8", the media-type is "text/plain".
  #
  # For more information on the use of media types in HTTP, see:
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7
  #
  # source://rack//lib/rack/request.rb#441
  def media_type; end

  # The media type parameters provided in CONTENT_TYPE as a Hash, or
  # an empty Hash if no CONTENT_TYPE or media-type parameters were
  # provided.  e.g., when the CONTENT_TYPE is "text/plain;charset=utf-8",
  # this method responds with the following Hash:
  #   { 'charset' => 'utf-8' }
  #
  # source://rack//lib/rack/request.rb#450
  def media_type_params; end

  # Checks the HTTP request method (or verb) to see if it was of type OPTIONS
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#229
  def options?; end

  # The union of GET and POST data.
  #
  # Note that modifications will not be persisted in the env. Use update_param or delete_param if you want to destructively modify params.
  #
  # source://rack//lib/rack/request.rb#556
  def params; end

  # Determine whether the request body contains data by checking
  # the request media_type against registered parse-data media-types
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#479
  def parseable_data?; end

  # Checks the HTTP request method (or verb) to see if it was of type PATCH
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#235
  def patch?; end

  # source://rack//lib/rack/request.rb#599
  def path; end

  # source://rack//lib/rack/request.rb#194
  def path_info; end

  # source://rack//lib/rack/request.rb#195
  def path_info=(s); end

  # source://rack//lib/rack/request.rb#345
  def port; end

  # Checks the HTTP request method (or verb) to see if it was of type POST
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#238
  def post?; end

  # Checks the HTTP request method (or verb) to see if it was of type PUT
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#241
  def put?; end

  # source://rack//lib/rack/request.rb#198
  def query_string; end

  # the referer of the client
  #
  # source://rack//lib/rack/request.rb#204
  def referer; end

  # the referer of the client
  #
  # source://rack//lib/rack/request.rb#204
  def referrer; end

  # source://rack//lib/rack/request.rb#197
  def request_method; end

  # source://rack//lib/rack/request.rb#249
  def scheme; end

  # source://rack//lib/rack/request.rb#191
  def script_name; end

  # source://rack//lib/rack/request.rb#192
  def script_name=(s); end

  # The authority as defined by the `SERVER_NAME` and `SERVER_PORT`
  # variables.
  #
  # source://rack//lib/rack/request.rb#272
  def server_authority; end

  # source://rack//lib/rack/request.rb#285
  def server_name; end

  # source://rack//lib/rack/request.rb#289
  def server_port; end

  # source://rack//lib/rack/request.rb#207
  def session; end

  # source://rack//lib/rack/request.rb#213
  def session_options; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#410
  def ssl?; end

  # Checks the HTTP request method (or verb) to see if it was of type TRACE
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#244
  def trace?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#615
  def trusted_proxy?(ip); end

  # Checks the HTTP request method (or verb) to see if it was of type UNLINK
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#247
  def unlink?; end

  # Destructively update a parameter, whether it's in GET and/or POST. Returns nil.
  #
  # The parameter is updated wherever it was previous defined, so GET, POST, or both. If it wasn't previously defined, it's inserted into GET.
  #
  # <tt>env['rack.input']</tt> is not touched.
  #
  # source://rack//lib/rack/request.rb#565
  def update_param(k, v); end

  # Tries to return a remake of the original request URL as a string.
  #
  # source://rack//lib/rack/request.rb#595
  def url; end

  # source://rack//lib/rack/request.rb#201
  def user_agent; end

  # like Hash#values_at
  #
  # source://rack//lib/rack/request.rb#620
  def values_at(*keys); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#313
  def xhr?; end

  private

  # source://rack//lib/rack/request.rb#776
  def allowed_scheme(header); end

  # source://rack//lib/rack/request.rb#628
  def default_session; end

  # source://rack//lib/rack/request.rb#684
  def expand_param_pairs(pairs, query_parser = T.unsafe(nil)); end

  # source://rack//lib/rack/request.rb#780
  def forwarded_priority; end

  # source://rack//lib/rack/request.rb#752
  def forwarded_scheme; end

  # Get an array of values set in the RFC 7239 `Forwarded` request header.
  #
  # source://rack//lib/rack/request.rb#668
  def get_http_forwarded(token); end

  # source://rack//lib/rack/request.rb#644
  def parse_http_accept_header(header); end

  # source://rack//lib/rack/request.rb#680
  def parse_multipart; end

  # source://rack//lib/rack/request.rb#676
  def parse_query(qs, d = T.unsafe(nil)); end

  # source://rack//lib/rack/request.rb#672
  def query_parser; end

  # source://rack//lib/rack/request.rb#743
  def reject_trusted_ip_addresses(ip_addresses); end

  # source://rack//lib/rack/request.rb#737
  def split_authority(authority); end

  # source://rack//lib/rack/request.rb#694
  def split_header(value); end

  # Assist with compatibility when processing `X-Forwarded-For`.
  #
  # source://rack//lib/rack/request.rb#631
  def wrap_ipv6(host); end

  # source://rack//lib/rack/request.rb#784
  def x_forwarded_proto_priority; end
end

# source://rack//lib/rack/request.rb#722
Rack::Request::Helpers::AUTHORITY = T.let(T.unsafe(nil), Regexp)

# Default ports depending on scheme. Used to decide whether or not
# to include the port in a generated URI.
#
# source://rack//lib/rack/request.rb#168
Rack::Request::Helpers::DEFAULT_PORTS = T.let(T.unsafe(nil), Hash)

# The set of form-data media-types. Requests that do not indicate
# one of the media types present in this list will not be eligible
# for form-data / param parsing.
#
# source://rack//lib/rack/request.rb#153
Rack::Request::Helpers::FORM_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/request.rb#747
Rack::Request::Helpers::FORWARDED_SCHEME_HEADERS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/request.rb#176
Rack::Request::Helpers::HTTP_FORWARDED = T.let(T.unsafe(nil), String)

# The address of the client which connected to the proxy.
#
# source://rack//lib/rack/request.rb#171
Rack::Request::Helpers::HTTP_X_FORWARDED_FOR = T.let(T.unsafe(nil), String)

# The contents of the host/:authority header sent to the proxy.
#
# source://rack//lib/rack/request.rb#174
Rack::Request::Helpers::HTTP_X_FORWARDED_HOST = T.let(T.unsafe(nil), String)

# The port used to connect to the proxy.
#
# source://rack//lib/rack/request.rb#185
Rack::Request::Helpers::HTTP_X_FORWARDED_PORT = T.let(T.unsafe(nil), String)

# The protocol used to connect to the proxy.
#
# source://rack//lib/rack/request.rb#182
Rack::Request::Helpers::HTTP_X_FORWARDED_PROTO = T.let(T.unsafe(nil), String)

# The value of the scheme sent to the proxy.
#
# source://rack//lib/rack/request.rb#179
Rack::Request::Helpers::HTTP_X_FORWARDED_SCHEME = T.let(T.unsafe(nil), String)

# Another way for specifying https scheme was used.
#
# source://rack//lib/rack/request.rb#188
Rack::Request::Helpers::HTTP_X_FORWARDED_SSL = T.let(T.unsafe(nil), String)

# The set of media-types. Requests that do not indicate
# one of the media types present in this list will not be eligible
# for param parsing like soap attachments or generic multiparts
#
# source://rack//lib/rack/request.rb#161
Rack::Request::Helpers::PARSEABLE_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)

# Rack::Response provides a convenient interface to create a Rack
# response.
#
# It allows setting of headers and cookies, and provides useful
# defaults (an OK response with empty headers and body).
#
# You can use Response#write to iteratively generate your response,
# but note that this is buffered by Rack::Response until you call
# +finish+.  +finish+ however can take a block inside which calls to
# +write+ are synchronous with the Rack response.
#
# Your application's +call+ should end returning Response#finish.
#
# source://rack//lib/rack/response.rb#23
class Rack::Response
  include ::Rack::Response::Helpers

  # Initialize the response object with the specified +body+, +status+
  # and +headers+.
  #
  # If the +body+ is +nil+, construct an empty response object with internal
  # buffering.
  #
  # If the +body+ responds to +to_str+, assume it's a string-like object and
  # construct a buffered response object containing using that string as the
  # initial contents of the buffer.
  #
  # Otherwise it is expected +body+ conforms to the normal requirements of a
  # Rack response body, typically implementing one of +each+ (enumerable
  # body) or +call+ (streaming body).
  #
  # The +status+ defaults to +200+ which is the "OK" HTTP status code. You
  # can provide any other valid status code.
  #
  # The +headers+ must be a +Hash+ of key-value header pairs which conform to
  # the Rack specification for response headers. The key must be a +String+
  # instance and the value can be either a +String+ or +Array+ instance.
  #
  # @return [Response] a new instance of Response
  # @yield [_self]
  # @yieldparam _self [Rack::Response] the object that the method was called on
  #
  # source://rack//lib/rack/response.rb#54
  def initialize(body = T.unsafe(nil), status = T.unsafe(nil), headers = T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#164
  def [](key); end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#168
  def []=(key, value); end

  # Returns the value of attribute body.
  #
  # source://rack//lib/rack/response.rb#31
  def body; end

  # Sets the attribute body
  #
  # @param value the value to set the attribute body to.
  #
  # source://rack//lib/rack/response.rb#31
  def body=(_arg0); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#95
  def chunked?; end

  # source://rack//lib/rack/response.rb#152
  def close; end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#172
  def delete_header(key); end

  # source://rack//lib/rack/response.rb#130
  def each(&callback); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#156
  def empty?; end

  # Generate a response array consistent with the requirements of the SPEC.
  # which is suitable to be returned from the middleware `#call(env)` method.
  #
  # @return [Array] a 3-tuple suitable of `[status, headers, body]`
  #
  # source://rack//lib/rack/response.rb#107
  def finish(&block); end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#164
  def get_header(key); end

  # @raise [ArgumentError]
  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#160
  def has_header?(key); end

  # Returns the value of attribute headers.
  #
  # source://rack//lib/rack/response.rb#32
  def headers; end

  # Returns the value of attribute length.
  #
  # source://rack//lib/rack/response.rb#31
  def length; end

  # Sets the attribute length
  #
  # @param value the value to set the attribute length to.
  #
  # source://rack//lib/rack/response.rb#31
  def length=(_arg0); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#99
  def no_entity_body?; end

  # source://rack//lib/rack/response.rb#90
  def redirect(target, status = T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#168
  def set_header(key, value); end

  # Returns the value of attribute status.
  #
  # source://rack//lib/rack/response.rb#31
  def status; end

  # Sets the attribute status
  #
  # @param value the value to set the attribute status to.
  #
  # source://rack//lib/rack/response.rb#31
  def status=(_arg0); end

  # Generate a response array consistent with the requirements of the SPEC.
  # which is suitable to be returned from the middleware `#call(env)` method.
  # For *response
  #
  # @return [Array] a 3-tuple suitable of `[status, headers, body]`
  #
  # source://rack//lib/rack/response.rb#107
  def to_a(&block); end

  # Append a chunk to the response body.
  #
  # Converts the response into a buffered response if it wasn't already.
  #
  # NOTE: Do not mix #write and direct #body access!
  #
  # source://rack//lib/rack/response.rb#146
  def write(chunk); end

  class << self
    # source://rack//lib/rack/response.rb#24
    def [](status, headers, body); end
  end
end

# source://rack//lib/rack/response.rb#28
Rack::Response::CHUNKED = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/response.rb#180
module Rack::Response::Helpers
  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#191
  def accepted?; end

  # Add a header that may have multiple values.
  #
  # Example:
  #   response.add_header 'vary', 'accept-encoding'
  #   response.add_header 'vary', 'cookie'
  #
  #   assert_equal 'accept-encoding,cookie', response.get_header('vary')
  #
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2
  #
  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/response.rb#219
  def add_header(key, value); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#194
  def bad_request?; end

  # Specify that the content should be cached.
  #
  # @option directive
  # @param duration [Integer] The number of seconds until the cache expires.
  # @param directive [Hash] a customizable set of options
  #
  # source://rack//lib/rack/response.rb#307
  def cache!(duration = T.unsafe(nil), directive: T.unsafe(nil)); end

  # source://rack//lib/rack/response.rb#290
  def cache_control; end

  # source://rack//lib/rack/response.rb#294
  def cache_control=(value); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#186
  def client_error?; end

  # source://rack//lib/rack/response.rb#257
  def content_length; end

  # Get the content type of the response.
  #
  # source://rack//lib/rack/response.rb#240
  def content_type; end

  # Set the content type of the response.
  #
  # source://rack//lib/rack/response.rb#245
  def content_type=(content_type); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#190
  def created?; end

  # source://rack//lib/rack/response.rb#274
  def delete_cookie(key, value = T.unsafe(nil)); end

  # Specifies that the content shouldn't be cached. Overrides `cache!` if already called.
  #
  # source://rack//lib/rack/response.rb#299
  def do_not_cache!; end

  # source://rack//lib/rack/response.rb#314
  def etag; end

  # source://rack//lib/rack/response.rb#318
  def etag=(value); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#196
  def forbidden?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#206
  def include?(header); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#183
  def informational?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#181
  def invalid?; end

  # source://rack//lib/rack/response.rb#262
  def location; end

  # source://rack//lib/rack/response.rb#266
  def location=(location); end

  # source://rack//lib/rack/response.rb#249
  def media_type; end

  # source://rack//lib/rack/response.rb#253
  def media_type_params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#198
  def method_not_allowed?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#193
  def moved_permanently?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#192
  def no_content?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#199
  def not_acceptable?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#197
  def not_found?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#189
  def ok?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#201
  def precondition_failed?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#204
  def redirect?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#185
  def redirection?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#200
  def request_timeout?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#187
  def server_error?; end

  # source://rack//lib/rack/response.rb#270
  def set_cookie(key, value); end

  # source://rack//lib/rack/response.rb#282
  def set_cookie_header; end

  # source://rack//lib/rack/response.rb#286
  def set_cookie_header=(value); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#184
  def successful?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#195
  def unauthorized?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#202
  def unprocessable?; end

  protected

  # source://rack//lib/rack/response.rb#359
  def append(chunk); end

  # Convert the body of this response into an internally buffered Array if possible.
  #
  # `@buffered` is a ternary value which indicates whether the body is buffered. It can be:
  # * `nil` - The body has not been buffered yet.
  # * `true` - The body is buffered as an Array instance.
  # * `false` - The body is not buffered and cannot be buffered.
  #
  # @return [Boolean] whether the body is buffered as an Array instance.
  #
  # source://rack//lib/rack/response.rb#332
  def buffered_body!; end
end

# source://rack//lib/rack/response.rb#375
class Rack::Response::Raw
  include ::Rack::Response::Helpers

  # @return [Raw] a new instance of Raw
  #
  # source://rack//lib/rack/response.rb#381
  def initialize(status, headers); end

  # source://rack//lib/rack/response.rb#398
  def delete_header(key); end

  # source://rack//lib/rack/response.rb#390
  def get_header(key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#386
  def has_header?(key); end

  # Returns the value of attribute headers.
  #
  # source://rack//lib/rack/response.rb#378
  def headers; end

  # source://rack//lib/rack/response.rb#394
  def set_header(key, value); end

  # Returns the value of attribute status.
  #
  # source://rack//lib/rack/response.rb#379
  def status; end

  # Sets the attribute status
  #
  # @param value the value to set the attribute status to.
  #
  # source://rack//lib/rack/response.rb#379
  def status=(_arg0); end
end

# source://rack//lib/rack/response.rb#29
Rack::Response::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

# Class which can make any IO object rewindable, including non-rewindable ones. It does
# this by buffering the data into a tempfile, which is rewindable.
#
# Don't forget to call #close when you're done. This frees up temporary resources that
# RewindableInput uses, though it does *not* close the original IO object.
#
# source://rack//lib/rack/rewindable_input.rb#14
class Rack::RewindableInput
  # @return [RewindableInput] a new instance of RewindableInput
  #
  # source://rack//lib/rack/rewindable_input.rb#29
  def initialize(io); end

  # Closes this RewindableInput object without closing the originally
  # wrapped IO object. Cleans up any temporary resources that this RewindableInput
  # has created.
  #
  # This method may be called multiple times. It does nothing on subsequent calls.
  #
  # source://rack//lib/rack/rewindable_input.rb#65
  def close; end

  # source://rack//lib/rack/rewindable_input.rb#45
  def each(&block); end

  # source://rack//lib/rack/rewindable_input.rb#35
  def gets; end

  # source://rack//lib/rack/rewindable_input.rb#40
  def read(*args); end

  # source://rack//lib/rack/rewindable_input.rb#50
  def rewind; end

  # source://rack//lib/rack/rewindable_input.rb#55
  def size; end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/rewindable_input.rb#109
  def filesystem_has_posix_semantics?; end

  # source://rack//lib/rack/rewindable_input.rb#78
  def make_rewindable; end
end

# Makes rack.input rewindable, for compatibility with applications and middleware
# designed for earlier versions of Rack (where rack.input was required to be
# rewindable).
#
# source://rack//lib/rack/rewindable_input.rb#18
class Rack::RewindableInput::Middleware
  # @return [Middleware] a new instance of Middleware
  #
  # source://rack//lib/rack/rewindable_input.rb#19
  def initialize(app); end

  # source://rack//lib/rack/rewindable_input.rb#23
  def call(env); end
end

# Sets an "x-runtime" response header, indicating the response
# time of the request, in seconds
#
# You can put it right before the application to see the processing
# time, or before all the other middlewares to include time for them,
# too.
#
# source://rack//lib/rack/runtime.rb#12
class Rack::Runtime
  # @return [Runtime] a new instance of Runtime
  #
  # source://rack//lib/rack/runtime.rb#16
  def initialize(app, name = T.unsafe(nil)); end

  # source://rack//lib/rack/runtime.rb#22
  def call(env); end
end

# source://rack//lib/rack/runtime.rb#13
Rack::Runtime::FORMAT_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/runtime.rb#14
Rack::Runtime::HEADER_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#11
Rack::SCRIPT_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#14
Rack::SERVER_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#15
Rack::SERVER_PORT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#13
Rack::SERVER_PROTOCOL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#24
Rack::SET_COOKIE = T.let(T.unsafe(nil), String)

# = Sendfile
#
# The Sendfile middleware intercepts responses whose body is being
# served from a file and replaces it with a server specific x-sendfile
# header. The web server is then responsible for writing the file contents
# to the client. This can dramatically reduce the amount of work required
# by the Ruby backend and takes advantage of the web server's optimized file
# delivery code.
#
# In order to take advantage of this middleware, the response body must
# respond to +to_path+ and the request must include an x-sendfile-type
# header. Rack::Files and other components implement +to_path+ so there's
# rarely anything you need to do in your application. The x-sendfile-type
# header is typically set in your web servers configuration. The following
# sections attempt to document
#
# === Nginx
#
# Nginx supports the x-accel-redirect header. This is similar to x-sendfile
# but requires parts of the filesystem to be mapped into a private URL
# hierarchy.
#
# The following example shows the Nginx configuration required to create
# a private "/files/" area, enable x-accel-redirect, and pass the special
# x-sendfile-type and x-accel-mapping headers to the backend:
#
#   location ~ /files/(.*) {
#     internal;
#     alias /var/www/$1;
#   }
#
#   location / {
#     proxy_redirect     off;
#
#     proxy_set_header   Host                $host;
#     proxy_set_header   X-Real-IP           $remote_addr;
#     proxy_set_header   X-Forwarded-For     $proxy_add_x_forwarded_for;
#
#     proxy_set_header   x-sendfile-type     x-accel-redirect;
#     proxy_set_header   x-accel-mapping     /var/www/=/files/;
#
#     proxy_pass         http://127.0.0.1:8080/;
#   }
#
# Note that the x-sendfile-type header must be set exactly as shown above.
# The x-accel-mapping header should specify the location on the file system,
# followed by an equals sign (=), followed name of the private URL pattern
# that it maps to. The middleware performs a simple substitution on the
# resulting path.
#
# See Also: https://www.nginx.com/resources/wiki/start/topics/examples/xsendfile
#
# === lighttpd
#
# Lighttpd has supported some variation of the x-sendfile header for some
# time, although only recent version support x-sendfile in a reverse proxy
# configuration.
#
#   $HTTP["host"] == "example.com" {
#      proxy-core.protocol = "http"
#      proxy-core.balancer = "round-robin"
#      proxy-core.backends = (
#        "127.0.0.1:8000",
#        "127.0.0.1:8001",
#        ...
#      )
#
#      proxy-core.allow-x-sendfile = "enable"
#      proxy-core.rewrite-request = (
#        "x-sendfile-type" => (".*" => "x-sendfile")
#      )
#    }
#
# See Also: http://redmine.lighttpd.net/wiki/lighttpd/Docs:ModProxyCore
#
# === Apache
#
# x-sendfile is supported under Apache 2.x using a separate module:
#
# https://tn123.org/mod_xsendfile/
#
# Once the module is compiled and installed, you can enable it using
# XSendFile config directive:
#
#   RequestHeader Set x-sendfile-type x-sendfile
#   ProxyPassReverse / http://localhost:8001/
#   XSendFile on
#
# === Mapping parameter
#
# The third parameter allows for an overriding extension of the
# x-accel-mapping header. Mappings should be provided in tuples of internal to
# external. The internal values may contain regular expression syntax, they
# will be matched with case indifference.
#
# source://rack//lib/rack/sendfile.rb#104
class Rack::Sendfile
  # @return [Sendfile] a new instance of Sendfile
  #
  # source://rack//lib/rack/sendfile.rb#105
  def initialize(app, variation = T.unsafe(nil), mappings = T.unsafe(nil)); end

  # source://rack//lib/rack/sendfile.rb#113
  def call(env); end

  private

  # source://rack//lib/rack/sendfile.rb#154
  def map_accel_path(env, path); end

  # source://rack//lib/rack/sendfile.rb#148
  def variation(env); end
end

# Rack::ShowExceptions catches all exceptions raised from the app it
# wraps.  It shows a useful backtrace with the sourcefile and
# clickable context, the whole Rack environment and the request
# data.
#
# Be careful when you use this on public-facing sites as it could
# reveal information helpful to attackers.
#
# source://rack//lib/rack/show_exceptions.rb#18
class Rack::ShowExceptions
  # @return [ShowExceptions] a new instance of ShowExceptions
  #
  # source://rack//lib/rack/show_exceptions.rb#26
  def initialize(app); end

  # source://rack//lib/rack/show_exceptions.rb#30
  def call(env); end

  # source://rack//lib/rack/show_exceptions.rb#65
  def dump_exception(exception); end

  # source://rack//lib/rack/show_exceptions.rb#116
  def h(obj); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/show_exceptions.rb#56
  def prefers_plaintext?(env); end

  # source://rack//lib/rack/show_exceptions.rb#76
  def pretty(env, exception); end

  # source://rack//lib/rack/show_exceptions.rb#112
  def template; end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/show_exceptions.rb#60
  def accepts_html?(env); end
end

# source://rack//lib/rack/show_exceptions.rb#19
Rack::ShowExceptions::CONTEXT = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/show_exceptions.rb#21
class Rack::ShowExceptions::Frame < ::Struct
  # Returns the value of attribute context_line
  #
  # @return [Object] the current value of context_line
  def context_line; end

  # Sets the attribute context_line
  #
  # @param value [Object] the value to set the attribute context_line to.
  # @return [Object] the newly set value
  def context_line=(_); end

  # Returns the value of attribute filename
  #
  # @return [Object] the current value of filename
  def filename; end

  # Sets the attribute filename
  #
  # @param value [Object] the value to set the attribute filename to.
  # @return [Object] the newly set value
  def filename=(_); end

  # Returns the value of attribute function
  #
  # @return [Object] the current value of function
  def function; end

  # Sets the attribute function
  #
  # @param value [Object] the value to set the attribute function to.
  # @return [Object] the newly set value
  def function=(_); end

  # Returns the value of attribute lineno
  #
  # @return [Object] the current value of lineno
  def lineno; end

  # Sets the attribute lineno
  #
  # @param value [Object] the value to set the attribute lineno to.
  # @return [Object] the newly set value
  def lineno=(_); end

  # Returns the value of attribute post_context
  #
  # @return [Object] the current value of post_context
  def post_context; end

  # Sets the attribute post_context
  #
  # @param value [Object] the value to set the attribute post_context to.
  # @return [Object] the newly set value
  def post_context=(_); end

  # Returns the value of attribute post_context_lineno
  #
  # @return [Object] the current value of post_context_lineno
  def post_context_lineno; end

  # Sets the attribute post_context_lineno
  #
  # @param value [Object] the value to set the attribute post_context_lineno to.
  # @return [Object] the newly set value
  def post_context_lineno=(_); end

  # Returns the value of attribute pre_context
  #
  # @return [Object] the current value of pre_context
  def pre_context; end

  # Sets the attribute pre_context
  #
  # @param value [Object] the value to set the attribute pre_context to.
  # @return [Object] the newly set value
  def pre_context=(_); end

  # Returns the value of attribute pre_context_lineno
  #
  # @return [Object] the current value of pre_context_lineno
  def pre_context_lineno; end

  # Sets the attribute pre_context_lineno
  #
  # @param value [Object] the value to set the attribute pre_context_lineno to.
  # @return [Object] the newly set value
  def pre_context_lineno=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rack//lib/rack/show_exceptions.rb#131
Rack::ShowExceptions::TEMPLATE = T.let(T.unsafe(nil), ERB)

# Rack::ShowStatus catches all empty responses and replaces them
# with a site explaining the error.
#
# Additional details can be put into <tt>rack.showstatus.detail</tt>
# and will be shown as HTML.  If such details exist, the error page
# is always rendered, even if the reply was not empty.
#
# source://rack//lib/rack/show_status.rb#18
class Rack::ShowStatus
  # @return [ShowStatus] a new instance of ShowStatus
  #
  # source://rack//lib/rack/show_status.rb#19
  def initialize(app); end

  # source://rack//lib/rack/show_status.rb#24
  def call(env); end

  # source://rack//lib/rack/show_status.rb#54
  def h(obj); end
end

# source://rack//lib/rack/show_status.rb#69
Rack::ShowStatus::TEMPLATE = T.let(T.unsafe(nil), String)

# The Rack::Static middleware intercepts requests for static files
# (javascript files, images, stylesheets, etc) based on the url prefixes or
# route mappings passed in the options, and serves them using a Rack::Files
# object. This allows a Rack stack to serve both static and dynamic content.
#
# Examples:
#
# Serve all requests beginning with /media from the "media" folder located
# in the current directory (ie media/*):
#
#     use Rack::Static, :urls => ["/media"]
#
# Same as previous, but instead of returning 404 for missing files under
# /media, call the next middleware:
#
#     use Rack::Static, :urls => ["/media"], :cascade => true
#
# Serve all requests beginning with /css or /images from the folder "public"
# in the current directory (ie public/css/* and public/images/*):
#
#     use Rack::Static, :urls => ["/css", "/images"], :root => "public"
#
# Serve all requests to / with "index.html" from the folder "public" in the
# current directory (ie public/index.html):
#
#     use Rack::Static, :urls => {"/" => 'index.html'}, :root => 'public'
#
# Serve all requests normally from the folder "public" in the current
# directory but uses index.html as default route for "/"
#
#     use Rack::Static, :urls => [""], :root => 'public', :index =>
#     'index.html'
#
# Set custom HTTP Headers for based on rules:
#
#     use Rack::Static, :root => 'public',
#         :header_rules => [
#           [rule, {header_field => content, header_field => content}],
#           [rule, {header_field => content}]
#         ]
#
#  Rules for selecting files:
#
#  1) All files
#     Provide the :all symbol
#     :all => Matches every file
#
#  2) Folders
#     Provide the folder path as a string
#     '/folder' or '/folder/subfolder' => Matches files in a certain folder
#
#  3) File Extensions
#     Provide the file extensions as an array
#     ['css', 'js'] or %w(css js) => Matches files ending in .css or .js
#
#  4) Regular Expressions / Regexp
#     Provide a regular expression
#     %r{\.(?:css|js)\z} => Matches files ending in .css or .js
#     /\.(?:eot|ttf|otf|woff2|woff|svg)\z/ => Matches files ending in
#       the most common web font formats (.eot, .ttf, .otf, .woff2, .woff, .svg)
#       Note: This Regexp is available as a shortcut, using the :fonts rule
#
#  5) Font Shortcut
#     Provide the :fonts symbol
#     :fonts => Uses the Regexp rule stated right above to match all common web font endings
#
#  Rule Ordering:
#    Rules are applied in the order that they are provided.
#    List rather general rules above special ones.
#
#  Complete example use case including HTTP header rules:
#
#     use Rack::Static, :root => 'public',
#         :header_rules => [
#           # Cache all static files in public caches (e.g. Rack::Cache)
#           #  as well as in the browser
#           [:all, {'cache-control' => 'public, max-age=31536000'}],
#
#           # Provide web fonts with cross-origin access-control-headers
#           #  Firefox requires this when serving assets using a Content Delivery Network
#           [:fonts, {'access-control-allow-origin' => '*'}]
#         ]
#
# source://rack//lib/rack/static.rb#92
class Rack::Static
  # @return [Static] a new instance of Static
  #
  # source://rack//lib/rack/static.rb#93
  def initialize(app, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/static.rb#109
  def add_index_root?(path); end

  # Convert HTTP header rules to HTTP headers
  #
  # source://rack//lib/rack/static.rb#166
  def applicable_rules(path); end

  # source://rack//lib/rack/static.rb#125
  def call(env); end

  # source://rack//lib/rack/static.rb#121
  def can_serve(path); end

  # source://rack//lib/rack/static.rb#113
  def overwrite_file_path(path); end

  # source://rack//lib/rack/static.rb#117
  def route_file(path); end
end

# source://rack//lib/rack/constants.rb#38
Rack::TRACE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/constants.rb#25
Rack::TRANSFER_ENCODING = T.let(T.unsafe(nil), String)

# Middleware tracks and cleans Tempfiles created throughout a request (i.e. Rack::Multipart)
# Ideas/strategy based on posts by Eric Wong and Charles Oliver Nutter
# https://groups.google.com/forum/#!searchin/rack-devel/temp/rack-devel/brK8eh-MByw/sw61oJJCGRMJ
#
# source://rack//lib/rack/tempfile_reaper.rb#11
class Rack::TempfileReaper
  # @return [TempfileReaper] a new instance of TempfileReaper
  #
  # source://rack//lib/rack/tempfile_reaper.rb#12
  def initialize(app); end

  # source://rack//lib/rack/tempfile_reaper.rb#16
  def call(env); end
end

# source://rack//lib/rack/constants.rb#37
Rack::UNLINK = T.let(T.unsafe(nil), String)

# Rack::URLMap takes a hash mapping urls or paths to apps, and
# dispatches accordingly.  Support for HTTP/1.1 host names exists if
# the URLs start with <tt>http://</tt> or <tt>https://</tt>.
#
# URLMap modifies the SCRIPT_NAME and PATH_INFO such that the part
# relevant for dispatch is in the SCRIPT_NAME, and the rest in the
# PATH_INFO.  This should be taken care of when you need to
# reconstruct the URL in order to create links.
#
# URLMap dispatches in such a way that the longest paths are tried
# first, since they are most specific.
#
# source://rack//lib/rack/urlmap.rb#20
class Rack::URLMap
  # @return [URLMap] a new instance of URLMap
  #
  # source://rack//lib/rack/urlmap.rb#21
  def initialize(map = T.unsafe(nil)); end

  # source://rack//lib/rack/urlmap.rb#48
  def call(env); end

  # source://rack//lib/rack/urlmap.rb#25
  def remap(map); end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/urlmap.rb#87
  def casecmp?(v1, v2); end
end

# Rack::Utils contains a grab-bag of useful methods for writing web
# applications adopted from all kinds of Ruby libraries.
#
# source://rack//lib/rack/utils.rb#20
module Rack::Utils
  private

  # Return best accept value to use, based on the algorithm
  # in RFC 2616 Section 14.  If there are multiple best
  # matches (same specificity and quality), the value returned
  # is arbitrary.
  #
  # source://rack//lib/rack/utils.rb#166
  def best_q_match(q_value_header, available_mimes); end

  # source://rack//lib/rack/utils.rb#119
  def build_nested_query(value, prefix = T.unsafe(nil)); end

  # source://rack//lib/rack/utils.rb#109
  def build_query(params); end

  # Parses the "Range:" header, if present, into an array of Range objects.
  # Returns nil if the header is missing or syntactically invalid.
  # Returns an empty array if none of the ranges are satisfiable.
  #
  # source://rack//lib/rack/utils.rb#408
  def byte_ranges(env, size); end

  # source://rack//lib/rack/utils.rb#608
  def clean_path_info(path_info); end

  # :nocov:
  #
  # source://rack//lib/rack/utils.rb#90
  def clock_time; end

  # source://rack//lib/rack/utils.rb#366
  def delete_cookie_header!(headers, key, value = T.unsafe(nil)); end

  # :call-seq:
  #   delete_set_cookie_header(key, value = {}) -> encoded string
  #
  # Generate an encoded string based on the given +key+ and +value+ using
  # set_cookie_header for the purpose of causing the specified cookie to be
  # deleted. The +value+ may be an instance of +Hash+ and can include
  # attributes as outlined by set_cookie_header. The encoded cookie will have
  # a +max_age+ of 0 seconds, an +expires+ date in the past and an empty
  # +value+. When used with the +set-cookie+ header, it will cause the client
  # to *remove* any matching cookie.
  #
  #   delete_set_cookie_header("myname")
  #   # => "myname=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"
  #
  # source://rack//lib/rack/utils.rb#362
  def delete_set_cookie_header(key, value = T.unsafe(nil)); end

  # :call-seq:
  #   delete_set_cookie_header!(header, key, value = {}) -> header value
  #
  # Set an expired cookie in the specified headers with the given cookie
  # +key+ and +value+ using delete_set_cookie_header. This causes
  # the client to immediately delete the specified cookie.
  #
  #   delete_set_cookie_header!(nil, "mycookie")
  #   # => "mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"
  #
  # If the header is non-nil, it will be modified in place.
  #
  #   header = []
  #   delete_set_cookie_header!(header, "mycookie")
  #   # => ["mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"]
  #   header
  #   # => ["mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"]
  #
  # source://rack//lib/rack/utils.rb#390
  def delete_set_cookie_header!(header, key, value = T.unsafe(nil)); end

  # URI escapes. (CGI style space to +)
  #
  # source://rack//lib/rack/utils.rb#39
  def escape(s); end

  # source://rack//lib/rack/utils.rb#261
  def escape_cookie_key(key); end

  # Escape ampersands, brackets and quotes to their HTML/XML entities.
  def escape_html(_arg0); end

  # Like URI escaping, but with %20 instead of +. Strictly speaking this is
  # true URI escaping.
  #
  # source://rack//lib/rack/utils.rb#45
  def escape_path(s); end

  # source://rack//lib/rack/utils.rb#148
  def forwarded_values(forwarded_header); end

  # source://rack//lib/rack/utils.rb#412
  def get_byte_ranges(http_range, size); end

  # :call-seq:
  #   parse_cookies(env) -> hash
  #
  # Parse cookies from the provided request environment using
  # parse_cookies_header. Returns a map of cookie +key+ to cookie +value+.
  #
  #   parse_cookies({'HTTP_COOKIE' => 'myname=myvalue'})
  #   # => {'myname' => 'myvalue'}
  #
  # source://rack//lib/rack/utils.rb#252
  def parse_cookies(env); end

  # :call-seq:
  #   parse_cookies_header(value) -> hash
  #
  # Parse cookies from the provided header +value+ according to RFC6265. The
  # syntax for cookie headers only supports semicolons. Returns a map of
  # cookie +key+ to cookie +value+.
  #
  #   parse_cookies_header('myname=myvalue; max-age=0')
  #   # => {"myname"=>"myvalue", "max-age"=>"0"}
  #
  # source://rack//lib/rack/utils.rb#233
  def parse_cookies_header(value); end

  # source://rack//lib/rack/utils.rb#105
  def parse_nested_query(qs, d = T.unsafe(nil)); end

  # source://rack//lib/rack/utils.rb#101
  def parse_query(qs, d = T.unsafe(nil), &unescaper); end

  # source://rack//lib/rack/utils.rb#137
  def q_values(q_value_header); end

  # source://rack//lib/rack/utils.rb#401
  def rfc2822(time); end

  # :nocov:
  #
  # source://rack//lib/rack/utils.rb#454
  def secure_compare(a, b); end

  # source://rack//lib/rack/utils.rb#191
  def select_best_encoding(available_encodings, accept_encoding); end

  # :call-seq:
  #   set_cookie_header(key, value) -> encoded string
  #
  # Generate an encoded string using the provided +key+ and +value+ suitable
  # for the +set-cookie+ header according to RFC6265. The +value+ may be an
  # instance of either +String+ or +Hash+.
  #
  # If the cookie +value+ is an instance of +Hash+, it considers the following
  # cookie attribute keys: +domain+, +max_age+, +expires+ (must be instance
  # of +Time+), +secure+, +http_only+, +same_site+ and +value+. For more
  # details about the interpretation of these fields, consult
  # [RFC6265 Section 5.2](https://datatracker.ietf.org/doc/html/rfc6265#section-5.2).
  #
  # An extra cookie attribute +escape_key+ can be provided to control whether
  # or not the cookie key is URL encoded. If explicitly set to +false+, the
  # cookie key name will not be url encoded (escaped). The default is +true+.
  #
  #   set_cookie_header("myname", "myvalue")
  #   # => "myname=myvalue"
  #
  #   set_cookie_header("myname", {value: "myvalue", max_age: 10})
  #   # => "myname=myvalue; max-age=10"
  #
  # source://rack//lib/rack/utils.rb#293
  def set_cookie_header(key, value); end

  # :call-seq:
  #   set_cookie_header!(headers, key, value) -> header value
  #
  # Append a cookie in the specified headers with the given cookie +key+ and
  # +value+ using set_cookie_header.
  #
  # If the headers already contains a +set-cookie+ key, it will be converted
  # to an +Array+ if not already, and appended to.
  #
  # source://rack//lib/rack/utils.rb#336
  def set_cookie_header!(headers, key, value); end

  # source://rack//lib/rack/utils.rb#588
  def status_code(status); end

  # Unescapes a URI escaped string with +encoding+. +encoding+ will be the
  # target encoding of the string returned, and it defaults to UTF-8
  #
  # source://rack//lib/rack/utils.rb#57
  def unescape(s, encoding = T.unsafe(nil)); end

  # Unescapes the **path** component of a URI.  See Rack::Utils.unescape for
  # unescaping query parameters or form components.
  #
  # source://rack//lib/rack/utils.rb#51
  def unescape_path(s); end

  # source://rack//lib/rack/utils.rb#625
  def valid_path?(path); end

  class << self
    # Return best accept value to use, based on the algorithm
    # in RFC 2616 Section 14.  If there are multiple best
    # matches (same specificity and quality), the value returned
    # is arbitrary.
    #
    # source://rack//lib/rack/utils.rb#166
    def best_q_match(q_value_header, available_mimes); end

    # source://rack//lib/rack/utils.rb#119
    def build_nested_query(value, prefix = T.unsafe(nil)); end

    # source://rack//lib/rack/utils.rb#109
    def build_query(params); end

    # Parses the "Range:" header, if present, into an array of Range objects.
    # Returns nil if the header is missing or syntactically invalid.
    # Returns an empty array if none of the ranges are satisfiable.
    #
    # source://rack//lib/rack/utils.rb#408
    def byte_ranges(env, size); end

    # source://rack//lib/rack/utils.rb#608
    def clean_path_info(path_info); end

    # source://rack//lib/rack/utils.rb#90
    def clock_time; end

    # Returns the value of attribute default_query_parser.
    #
    # source://rack//lib/rack/utils.rb#29
    def default_query_parser; end

    # Sets the attribute default_query_parser
    #
    # @param value the value to set the attribute default_query_parser to.
    #
    # source://rack//lib/rack/utils.rb#29
    def default_query_parser=(_arg0); end

    # source://rack//lib/rack/utils.rb#366
    def delete_cookie_header!(headers, key, value = T.unsafe(nil)); end

    # :call-seq:
    #   delete_set_cookie_header(key, value = {}) -> encoded string
    #
    # Generate an encoded string based on the given +key+ and +value+ using
    # set_cookie_header for the purpose of causing the specified cookie to be
    # deleted. The +value+ may be an instance of +Hash+ and can include
    # attributes as outlined by set_cookie_header. The encoded cookie will have
    # a +max_age+ of 0 seconds, an +expires+ date in the past and an empty
    # +value+. When used with the +set-cookie+ header, it will cause the client
    # to *remove* any matching cookie.
    #
    #   delete_set_cookie_header("myname")
    #   # => "myname=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"
    #
    # source://rack//lib/rack/utils.rb#362
    def delete_set_cookie_header(key, value = T.unsafe(nil)); end

    # :call-seq:
    #   delete_set_cookie_header!(header, key, value = {}) -> header value
    #
    # Set an expired cookie in the specified headers with the given cookie
    # +key+ and +value+ using delete_set_cookie_header. This causes
    # the client to immediately delete the specified cookie.
    #
    #   delete_set_cookie_header!(nil, "mycookie")
    #   # => "mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"
    #
    # If the header is non-nil, it will be modified in place.
    #
    #   header = []
    #   delete_set_cookie_header!(header, "mycookie")
    #   # => ["mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"]
    #   header
    #   # => ["mycookie=; max-age=0; expires=Thu, 01 Jan 1970 00:00:00 GMT"]
    #
    # source://rack//lib/rack/utils.rb#390
    def delete_set_cookie_header!(header, key, value = T.unsafe(nil)); end

    # URI escapes. (CGI style space to +)
    #
    # source://rack//lib/rack/utils.rb#39
    def escape(s); end

    # source://rack//lib/rack/utils.rb#261
    def escape_cookie_key(key); end

    def escape_html(_arg0); end

    # Like URI escaping, but with %20 instead of +. Strictly speaking this is
    # true URI escaping.
    #
    # source://rack//lib/rack/utils.rb#45
    def escape_path(s); end

    # source://rack//lib/rack/utils.rb#148
    def forwarded_values(forwarded_header); end

    # source://rack//lib/rack/utils.rb#412
    def get_byte_ranges(http_range, size); end

    # Returns the value of attribute multipart_file_limit.
    #
    # source://rack//lib/rack/utils.rb#64
    def multipart_file_limit; end

    # Sets the attribute multipart_file_limit
    #
    # @param value the value to set the attribute multipart_file_limit to.
    #
    # source://rack//lib/rack/utils.rb#64
    def multipart_file_limit=(_arg0); end

    # Returns the value of attribute multipart_file_limit.
    # multipart_part_limit is the original name of multipart_file_limit, but
    # the limit only counts parts with filenames.
    #
    # source://rack//lib/rack/utils.rb#64
    def multipart_part_limit; end

    # Sets the attribute multipart_file_limit
    #
    # @param value the value to set the attribute multipart_file_limit to.
    #
    # source://rack//lib/rack/utils.rb#64
    def multipart_part_limit=(_arg0); end

    # Returns the value of attribute multipart_total_part_limit.
    #
    # source://rack//lib/rack/utils.rb#62
    def multipart_total_part_limit; end

    # Sets the attribute multipart_total_part_limit
    #
    # @param value the value to set the attribute multipart_total_part_limit to.
    #
    # source://rack//lib/rack/utils.rb#62
    def multipart_total_part_limit=(_arg0); end

    # source://rack//lib/rack/utils.rb#81
    def param_depth_limit; end

    # source://rack//lib/rack/utils.rb#85
    def param_depth_limit=(v); end

    # :call-seq:
    #   parse_cookies(env) -> hash
    #
    # Parse cookies from the provided request environment using
    # parse_cookies_header. Returns a map of cookie +key+ to cookie +value+.
    #
    #   parse_cookies({'HTTP_COOKIE' => 'myname=myvalue'})
    #   # => {'myname' => 'myvalue'}
    #
    # source://rack//lib/rack/utils.rb#252
    def parse_cookies(env); end

    # :call-seq:
    #   parse_cookies_header(value) -> hash
    #
    # Parse cookies from the provided header +value+ according to RFC6265. The
    # syntax for cookie headers only supports semicolons. Returns a map of
    # cookie +key+ to cookie +value+.
    #
    #   parse_cookies_header('myname=myvalue; max-age=0')
    #   # => {"myname"=>"myvalue", "max-age"=>"0"}
    #
    # source://rack//lib/rack/utils.rb#233
    def parse_cookies_header(value); end

    # source://rack//lib/rack/utils.rb#105
    def parse_nested_query(qs, d = T.unsafe(nil)); end

    # source://rack//lib/rack/utils.rb#101
    def parse_query(qs, d = T.unsafe(nil), &unescaper); end

    # source://rack//lib/rack/utils.rb#137
    def q_values(q_value_header); end

    # source://rack//lib/rack/utils.rb#401
    def rfc2822(time); end

    # source://rack//lib/rack/utils.rb#454
    def secure_compare(a, b); end

    # source://rack//lib/rack/utils.rb#191
    def select_best_encoding(available_encodings, accept_encoding); end

    # :call-seq:
    #   set_cookie_header(key, value) -> encoded string
    #
    # Generate an encoded string using the provided +key+ and +value+ suitable
    # for the +set-cookie+ header according to RFC6265. The +value+ may be an
    # instance of either +String+ or +Hash+.
    #
    # If the cookie +value+ is an instance of +Hash+, it considers the following
    # cookie attribute keys: +domain+, +max_age+, +expires+ (must be instance
    # of +Time+), +secure+, +http_only+, +same_site+ and +value+. For more
    # details about the interpretation of these fields, consult
    # [RFC6265 Section 5.2](https://datatracker.ietf.org/doc/html/rfc6265#section-5.2).
    #
    # An extra cookie attribute +escape_key+ can be provided to control whether
    # or not the cookie key is URL encoded. If explicitly set to +false+, the
    # cookie key name will not be url encoded (escaped). The default is +true+.
    #
    #   set_cookie_header("myname", "myvalue")
    #   # => "myname=myvalue"
    #
    #   set_cookie_header("myname", {value: "myvalue", max_age: 10})
    #   # => "myname=myvalue; max-age=10"
    #
    # source://rack//lib/rack/utils.rb#293
    def set_cookie_header(key, value); end

    # :call-seq:
    #   set_cookie_header!(headers, key, value) -> header value
    #
    # Append a cookie in the specified headers with the given cookie +key+ and
    # +value+ using set_cookie_header.
    #
    # If the headers already contains a +set-cookie+ key, it will be converted
    # to an +Array+ if not already, and appended to.
    #
    # source://rack//lib/rack/utils.rb#336
    def set_cookie_header!(headers, key, value); end

    # source://rack//lib/rack/utils.rb#588
    def status_code(status); end

    # Unescapes a URI escaped string with +encoding+. +encoding+ will be the
    # target encoding of the string returned, and it defaults to UTF-8
    #
    # source://rack//lib/rack/utils.rb#57
    def unescape(s, encoding = T.unsafe(nil)); end

    # Unescapes the **path** component of a URI.  See Rack::Utils.unescape for
    # unescaping query parameters or form components.
    #
    # source://rack//lib/rack/utils.rb#51
    def unescape_path(s); end

    # @return [Boolean]
    #
    # source://rack//lib/rack/utils.rb#625
    def valid_path?(path); end
  end
end

# source://rack//lib/rack/utils.rb#25
Rack::Utils::COMMON_SEP = T.let(T.unsafe(nil), Hash)

# Context allows the use of a compatible middleware at different points
# in a request handling stack. A compatible middleware must define
# #context which should take the arguments env and app. The first of which
# would be the request environment. The second of which would be the rack
# application that the request would be forwarded to.
#
# source://rack//lib/rack/utils.rb#477
class Rack::Utils::Context
  # @return [Context] a new instance of Context
  #
  # source://rack//lib/rack/utils.rb#480
  def initialize(app_f, app_r); end

  # Returns the value of attribute app.
  #
  # source://rack//lib/rack/utils.rb#478
  def app; end

  # source://rack//lib/rack/utils.rb#485
  def call(env); end

  # source://rack//lib/rack/utils.rb#493
  def context(env, app = T.unsafe(nil)); end

  # Returns the value of attribute for.
  #
  # source://rack//lib/rack/utils.rb#478
  def for; end

  # source://rack//lib/rack/utils.rb#489
  def recontext(app); end
end

# source://rack//lib/rack/utils.rb#24
Rack::Utils::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# Every standard HTTP code mapped to the appropriate message.
# Generated with:
#   curl -s https://www.iana.org/assignments/http-status-codes/http-status-codes-1.csv \
#     | ruby -rcsv -e "puts CSV.parse(STDIN, headers: true) \
#     .reject {|v| v['Description'] == 'Unassigned' or v['Description'].include? '(' } \
#     .map {|v| %Q/#{v['Value']} => '#{v['Description']}'/ }.join(','+?\n)"
#
# source://rack//lib/rack/utils.rb#504
Rack::Utils::HTTP_STATUS_CODES = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#22
Rack::Utils::InvalidParameterError = Rack::QueryParser::InvalidParameterError

# source://rack//lib/rack/utils.rb#26
Rack::Utils::KeySpaceConstrainedParams = Rack::QueryParser::Params

# source://rack//lib/rack/utils.rb#623
Rack::Utils::NULL_BYTE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/utils.rb#574
Rack::Utils::OBSOLETE_SYMBOLS_TO_STATUS_CODES = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#582
Rack::Utils::OBSOLETE_SYMBOL_MAPPINGS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#606
Rack::Utils::PATH_SEPS = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/utils.rb#21
Rack::Utils::ParameterTypeError = Rack::QueryParser::ParameterTypeError

# source://rack//lib/rack/utils.rb#23
Rack::Utils::ParamsTooDeepError = Rack::QueryParser::ParamsTooDeepError

# Responses with HTTP status codes that should not have an entity body
#
# source://rack//lib/rack/utils.rb#568
Rack::Utils::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#570
Rack::Utils::SYMBOL_TO_STATUS_CODE = T.let(T.unsafe(nil), Hash)

# A valid cookie key according to RFC2616.
# A <cookie-name> can be any US-ASCII characters, except control characters, spaces, or tabs. It also must not contain a separator character like the following: ( ) < > @ , ; : \ " / [ ] ? = { }.
#
# source://rack//lib/rack/utils.rb#258
Rack::Utils::VALID_COOKIE_KEY = T.let(T.unsafe(nil), Regexp)
