# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `railties` gem.
# Please instead update this file by running `bin/tapioca gem railties`.


# :include: ../README.rdoc
#
# source://railties//lib/rails/gem_version.rb#3
module Rails
  extend ::ActiveSupport::Autoload
  extend ::ActiveSupport::Benchmarkable

  class << self
    # Returns the value of attribute app_class.
    #
    # source://railties//lib/rails.rb#44
    def app_class; end

    # Sets the attribute app_class
    #
    # @param value the value to set the attribute app_class to.
    #
    # source://railties//lib/rails.rb#44
    def app_class=(_arg0); end

    # source://railties//lib/rails.rb#45
    def application; end

    # Sets the attribute application
    #
    # @param value the value to set the attribute application to.
    #
    # source://railties//lib/rails.rb#43
    def application=(_arg0); end

    # source://railties//lib/rails.rb#126
    def autoloaders; end

    # source://railties//lib/rails.rb#56
    def backtrace_cleaner; end

    # Returns the value of attribute cache.
    #
    # source://railties//lib/rails.rb#44
    def cache; end

    # Sets the attribute cache
    #
    # @param value the value to set the attribute cache to.
    #
    # source://railties//lib/rails.rb#44
    def cache=(_arg0); end

    # The Configuration instance used to configure the \Rails environment
    #
    # source://railties//lib/rails.rb#52
    def configuration; end

    # source://railties//lib/rails/deprecator.rb#4
    def deprecator; end

    # Returns the current \Rails environment.
    #
    #   Rails.env # => "development"
    #   Rails.env.development? # => true
    #   Rails.env.production? # => false
    #   Rails.env.local? # => true              true for "development" and "test", false for anything else
    #
    # source://railties//lib/rails.rb#75
    def env; end

    # Sets the \Rails environment.
    #
    #   Rails.env = "staging" # => "staging"
    #
    # source://railties//lib/rails.rb#82
    def env=(environment); end

    # Returns the ActiveSupport::ErrorReporter of the current \Rails project,
    # otherwise it returns +nil+ if there is no project.
    #
    #   Rails.error.handle(IOError) do
    #     # ...
    #   end
    #   Rails.error.report(error)
    #
    # source://railties//lib/rails.rb#93
    def error; end

    # Returns the currently loaded version of \Rails as a +Gem::Version+.
    #
    # source://railties//lib/rails/gem_version.rb#5
    def gem_version; end

    # Returns all \Rails groups for loading based on:
    #
    # * The \Rails environment;
    # * The environment variable RAILS_GROUPS;
    # * The optional envs given as argument and the hash with group dependencies;
    #
    #  Rails.groups assets: [:development, :test]
    #  # => [:default, "development", :assets] for Rails.env == "development"
    #  # => [:default, "production"]           for Rails.env == "production"
    #
    # source://railties//lib/rails.rb#106
    def groups(*groups); end

    # source://railties//lib/rails.rb#49
    def initialize!(*_arg0, **_arg1, &_arg2); end

    # source://railties//lib/rails.rb#49
    def initialized?(*_arg0, **_arg1, &_arg2); end

    # Returns the value of attribute logger.
    #
    # source://railties//lib/rails.rb#44
    def logger; end

    # Sets the attribute logger
    #
    # @param value the value to set the attribute logger to.
    #
    # source://railties//lib/rails.rb#44
    def logger=(_arg0); end

    # Returns a Pathname object of the public folder of the current
    # \Rails project, otherwise it returns +nil+ if there is no project:
    #
    #   Rails.public_path
    #     # => #<Pathname:/Users/someuser/some/path/project/public>
    #
    # source://railties//lib/rails.rb#122
    def public_path; end

    # Returns a Pathname object of the current \Rails project,
    # otherwise it returns +nil+ if there is no project:
    #
    #   Rails.root
    #     # => #<Pathname:/Users/someuser/some/path/project>
    #
    # source://railties//lib/rails.rb#65
    def root; end

    # Returns the currently loaded version of \Rails as a string.
    #
    # source://railties//lib/rails/version.rb#7
    def version; end
  end
end

# An Engine with the responsibility of coordinating the whole boot process.
#
# == Initialization
#
# Rails::Application is responsible for executing all railties and engines
# initializers. It also executes some bootstrap initializers (check
# Rails::Application::Bootstrap) and finishing initializers, after all the others
# are executed (check Rails::Application::Finisher).
#
# == \Configuration
#
# Besides providing the same configuration as Rails::Engine and Rails::Railtie,
# the application object has several specific configurations, for example
# +enable_reloading+, +consider_all_requests_local+, +filter_parameters+,
# +logger+, and so forth.
#
# Check Rails::Application::Configuration to see them all.
#
# == Routes
#
# The application object is also responsible for holding the routes and reloading routes
# whenever the files change in development.
#
# == Middlewares
#
# The Application is also responsible for building the middleware stack.
#
# == Booting process
#
# The application is also responsible for setting up and executing the booting
# process. From the moment you require <tt>config/application.rb</tt> in your app,
# the booting process goes like this:
#
# 1.  <tt>require "config/boot.rb"</tt> to set up load paths.
# 2.  +require+ railties and engines.
# 3.  Define +Rails.application+ as <tt>class MyApp::Application < Rails::Application</tt>.
# 4.  Run +config.before_configuration+ callbacks.
# 5.  Load <tt>config/environments/ENV.rb</tt>.
# 6.  Run +config.before_initialize+ callbacks.
# 7.  Run <tt>Railtie#initializer</tt> defined by railties, engines, and application.
#     One by one, each engine sets up its load paths and routes, and runs its <tt>config/initializers/*</tt> files.
# 8.  Custom <tt>Railtie#initializers</tt> added by railties, engines, and applications are executed.
# 9.  Build the middleware stack and run +to_prepare+ callbacks.
# 10. Run +config.before_eager_load+ and +eager_load!+ if +eager_load+ is +true+.
# 11. Run +config.after_initialize+ callbacks.
#
# source://railties//lib/rails/application.rb#61
class Rails::Application < ::Rails::Engine
  # @return [Application] a new instance of Application
  #
  # source://railties//lib/rails/application.rb#108
  def initialize(initial_variable_values = T.unsafe(nil), &block); end

  # Returns the value of attribute assets.
  #
  # source://railties//lib/rails/application.rb#99
  def assets; end

  # Sets the attribute assets
  #
  # @param value the value to set the attribute assets to.
  #
  # source://railties//lib/rails/application.rb#99
  def assets=(_arg0); end

  # Returns the value of attribute autoloaders.
  #
  # source://railties//lib/rails/application.rb#101
  def autoloaders; end

  # source://railties//lib/rails/engine.rb#516
  def build_middleware_stack; end

  # source://railties//lib/rails/application.rb#446
  def config; end

  # Sets the attribute config
  #
  # @param value the value to set the attribute config to.
  #
  # source://railties//lib/rails/application.rb#450
  def config=(_arg0); end

  # Convenience for loading config/foo.yml for the current \Rails env.
  # Example:
  #
  #     # config/exception_notification.yml:
  #     production:
  #       url: http://127.0.0.1:8080
  #       namespace: my_app_production
  #
  #     development:
  #       url: http://localhost:3001
  #       namespace: my_app_development
  #
  # <code></code>
  #
  #     # config/environments/production.rb
  #     Rails.application.configure do
  #       config.middleware.use ExceptionNotifier, config_for(:exception_notification)
  #     end
  #
  # You can also store configurations in a shared section which will be merged
  # with the environment configuration
  #
  #     # config/example.yml
  #     shared:
  #       foo:
  #         bar:
  #           baz: 1
  #
  #     development:
  #       foo:
  #         bar:
  #           qux: 2
  #
  # <code></code>
  #
  #     # development environment
  #     Rails.application.config_for(:example)[:foo][:bar]
  #     # => { baz: 1, qux: 2 }
  #
  # source://railties//lib/rails/application.rb#283
  def config_for(name, env: T.unsafe(nil)); end

  # Sends any console called in the instance of a new application up
  # to the +console+ method defined in Rails::Railtie.
  #
  # source://railties//lib/rails/application.rb#366
  def console(&blk); end

  # Returns an ActiveSupport::EncryptedConfiguration instance for the
  # credentials file specified by +config.credentials.content_path+.
  #
  # By default, +config.credentials.content_path+ will point to either
  # <tt>config/credentials/#{environment}.yml.enc</tt> for the current
  # environment (for example, +config/credentials/production.yml.enc+ for the
  # +production+ environment), or +config/credentials.yml.enc+ if that file
  # does not exist.
  #
  # The encryption key is taken from either <tt>ENV["RAILS_MASTER_KEY"]</tt>,
  # or from the file specified by +config.credentials.key_path+. By default,
  # +config.credentials.key_path+ will point to either
  # <tt>config/credentials/#{environment}.key</tt> for the current
  # environment, or +config/master.key+ if that file does not exist.
  #
  # source://railties//lib/rails/application.rb#487
  def credentials; end

  # Sets the attribute credentials
  #
  # @param value the value to set the attribute credentials to.
  #
  # source://railties//lib/rails/application.rb#451
  def credentials=(_arg0); end

  # source://railties//lib/rails/application.rb#103
  def default_url_options(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/application.rb#103
  def default_url_options=(arg); end

  # A managed collection of deprecators (ActiveSupport::Deprecation::Deprecators).
  # The collection's configuration methods affect all deprecators in the
  # collection. Additionally, the collection's +silence+ method silences all
  # deprecators in the collection for the duration of a given block.
  #
  # source://railties//lib/rails/application.rb#239
  def deprecators; end

  # Eager loads the application code.
  #
  # source://railties//lib/rails/application.rb#545
  def eager_load!; end

  # Returns an ActiveSupport::EncryptedConfiguration instance for an encrypted
  # file. By default, the encryption key is taken from either
  # <tt>ENV["RAILS_MASTER_KEY"]</tt>, or from the +config/master.key+ file.
  #
  #   my_config = Rails.application.encrypted("config/my_config.enc")
  #
  #   my_config.read
  #   # => "foo:\n  bar: 123\n"
  #
  #   my_config.foo.bar
  #   # => 123
  #
  # Encrypted files can be edited with the <tt>bin/rails encrypted:edit</tt>
  # command. (See the output of <tt>bin/rails encrypted:edit --help</tt> for
  # more information.)
  #
  # source://railties//lib/rails/application.rb#506
  def encrypted(path, key_path: T.unsafe(nil), env_key: T.unsafe(nil)); end

  # Stores some of the \Rails initial environment parameters which
  # will be used by middlewares and engines to configure themselves.
  #
  # source://railties//lib/rails/application.rb#312
  def env_config; end

  # Returns the value of attribute executor.
  #
  # source://railties//lib/rails/application.rb#101
  def executor; end

  # Sends any generators called in the instance of a new application up
  # to the +generators+ method defined in Rails::Railtie.
  #
  # source://railties//lib/rails/application.rb#372
  def generators(&blk); end

  # source://railties//lib/rails/application.rb#519
  def helpers_paths; end

  # Initialize the application passing the given group. By default, the
  # group is :default
  #
  # source://railties//lib/rails/application.rb#433
  def initialize!(group = T.unsafe(nil)); end

  # Returns true if the application is initialized.
  #
  # @return [Boolean]
  #
  # source://railties//lib/rails/application.rb#133
  def initialized?; end

  # Sends the initializers to the +initializer+ method defined in the
  # Rails::Initializable module. Each Rails::Application class has its own
  # set of initializers, as defined by the Initializable module.
  #
  # source://railties//lib/rails/application.rb#354
  def initializer(name, opts = T.unsafe(nil), &block); end

  # source://railties//lib/rails/application.rb#440
  def initializers; end

  # Sends the +isolate_namespace+ method up to the class method.
  #
  # source://railties//lib/rails/application.rb#383
  def isolate_namespace(mod); end

  # Returns a key generator (ActiveSupport::CachingKeyGenerator) for a
  # specified +secret_key_base+. The return value is memoized, so additional
  # calls with the same +secret_key_base+ will return the same key generator
  # instance.
  #
  # source://railties//lib/rails/application.rb#167
  def key_generator(secret_key_base = T.unsafe(nil)); end

  # source://railties//lib/rails/application.rb#539
  def load_generators(app = T.unsafe(nil)); end

  # Returns a message verifier object.
  #
  # This verifier can be used to generate and verify signed messages in the application.
  #
  # It is recommended not to use the same verifier for different things, so you can get different
  # verifiers passing the +verifier_name+ argument.
  #
  # For instance, +ActiveStorage::Blob.signed_id_verifier+ is implemented using this feature, which assures that
  # the IDs strings haven't been tampered with and are safe to use in a finder.
  #
  # See the ActiveSupport::MessageVerifier documentation for more information.
  #
  # ==== Parameters
  #
  # * +verifier_name+ - the name of the message verifier.
  #
  # ==== Examples
  #
  #     message = Rails.application.message_verifier('my_purpose').generate('data to sign against tampering')
  #     Rails.application.message_verifier('my_purpose').verify(message)
  #     # => 'data to sign against tampering'
  #
  # source://railties//lib/rails/application.rb#231
  def message_verifier(verifier_name); end

  # Returns a message verifier factory (ActiveSupport::MessageVerifiers). This
  # factory can be used as a central point to configure and create message
  # verifiers (ActiveSupport::MessageVerifier) for your application.
  #
  # By default, message verifiers created by this factory will generate
  # messages using the default ActiveSupport::MessageVerifier options. You can
  # override these options with a combination of
  # ActiveSupport::MessageVerifiers#clear_rotations and
  # ActiveSupport::MessageVerifiers#rotate. However, this must be done prior
  # to building any message verifier instances. For example, in a
  # +before_initialize+ block:
  #
  #   # Use `url_safe: true` when generating messages
  #   config.before_initialize do |app|
  #     app.message_verifiers.clear_rotations
  #     app.message_verifiers.rotate(url_safe: true)
  #   end
  #
  # Message verifiers created by this factory will always use a secret derived
  # from #secret_key_base when generating messages. +clear_rotations+ will not
  # affect this behavior. However, older +secret_key_base+ values can be
  # rotated for verifying messages:
  #
  #   # Fall back to old `secret_key_base` when verifying messages
  #   config.before_initialize do |app|
  #     app.message_verifiers.rotate(secret_key_base: "old secret_key_base")
  #   end
  #
  # source://railties//lib/rails/application.rb#203
  def message_verifiers; end

  # Return an array of railties respecting the order they're loaded
  # and the order specified by the +railties_order+ config.
  #
  # While running initializers we need engines in reverse order here when
  # copying migrations from railties ; we need them in the order given by
  # +railties_order+.
  #
  # source://railties//lib/rails/application.rb#535
  def migration_railties; end

  # Returns the dasherized application name.
  #
  #   MyApp::Application.new.name => "my-app"
  #
  # source://railties//lib/rails/application.rb#140
  def name; end

  # If you try to define a set of Rake tasks on the instance, these will get
  # passed up to the Rake tasks defined on the application's class.
  #
  # source://railties//lib/rails/application.rb#347
  def rake_tasks(&block); end

  # Reload application routes regardless if they changed or not.
  #
  # source://railties//lib/rails/application.rb#159
  def reload_routes!; end

  # Returns the value of attribute reloader.
  #
  # source://railties//lib/rails/application.rb#101
  def reloader; end

  # Returns the value of attribute reloaders.
  #
  # source://railties//lib/rails/application.rb#101
  def reloaders; end

  # source://railties//lib/rails/application.rb#409
  def require_environment!; end

  # source://railties//lib/rails/application.rb#414
  def routes_reloader; end

  # source://railties//lib/rails/application.rb#144
  def run_load_hooks!; end

  # Sends any runner called in the instance of a new application up
  # to the +runner+ method defined in Rails::Railtie.
  #
  # source://railties//lib/rails/application.rb#360
  def runner(&blk); end

  # Returns the value of attribute sandbox.
  #
  # source://railties//lib/rails/application.rb#99
  def sandbox; end

  # Sets the attribute sandbox
  #
  # @param value the value to set the attribute sandbox to.
  #
  # source://railties//lib/rails/application.rb#99
  def sandbox=(_arg0); end

  # Returns the value of attribute sandbox.
  #
  # source://railties//lib/rails/application.rb#99
  def sandbox?; end

  # The secret_key_base is used as the input secret to the application's key generator, which in turn
  # is used to create all ActiveSupport::MessageVerifier and ActiveSupport::MessageEncryptor instances,
  # including the ones that sign and encrypt cookies.
  #
  # In development and test, this is randomly generated and stored in a
  # temporary file in <tt>tmp/local_secret.txt</tt>.
  #
  # You can also set <tt>ENV["SECRET_KEY_BASE_DUMMY"]</tt> to trigger the use of a randomly generated
  # secret_key_base that's stored in a temporary file. This is useful when precompiling assets for
  # production as part of a build step that otherwise does not need access to the production secrets.
  #
  # Dockerfile example: <tt>RUN SECRET_KEY_BASE_DUMMY=1 bundle exec rails assets:precompile</tt>.
  #
  # In all other environments, we look for it first in <tt>ENV["SECRET_KEY_BASE"]</tt>,
  # then +credentials.secret_key_base+. For most applications, the correct place to store it is in the
  # encrypted credentials file.
  #
  # source://railties//lib/rails/application.rb#469
  def secret_key_base; end

  # Sends any server called in the instance of a new application up
  # to the +server+ method defined in Rails::Railtie.
  #
  # source://railties//lib/rails/application.rb#378
  def server(&blk); end

  # source://railties//lib/rails/application.rb#515
  def to_app; end

  # Returns an array of file paths appended with a hash of
  # directories-extensions suitable for ActiveSupport::FileUpdateChecker
  # API.
  #
  # source://railties//lib/rails/application.rb#421
  def watchable_args; end

  protected

  # source://railties//lib/rails/application.rb#618
  def default_middleware_stack; end

  # source://railties//lib/rails/application.rb#623
  def ensure_generator_templates_added; end

  # Returns the ordered railties for this application considering railties_order.
  #
  # source://railties//lib/rails/application.rb#584
  def ordered_railties; end

  # source://railties//lib/rails/application.rb#606
  def railties_initializers(current); end

  # source://railties//lib/rails/application.rb#573
  def run_console_blocks(app); end

  # source://railties//lib/rails/application.rb#563
  def run_generators_blocks(app); end

  # source://railties//lib/rails/application.rb#568
  def run_runner_blocks(app); end

  # source://railties//lib/rails/application.rb#578
  def run_server_blocks(app); end

  # source://railties//lib/rails/application.rb#552
  def run_tasks_blocks(app); end

  private

  # source://railties//lib/rails/application.rb#636
  def build_middleware; end

  # source://railties//lib/rails/application.rb#629
  def build_request(env); end

  # source://railties//lib/rails/application.rb#640
  def coerce_same_site_protection(protection); end

  # source://railties//lib/rails/application.rb#644
  def filter_parameters; end

  class << self
    # This method is called just after an application inherits from Rails::Application,
    # allowing the developer to load classes in lib and use them during application
    # configuration.
    #
    #   class MyApplication < Rails::Application
    #     require "my_backend" # in lib/my_backend
    #     config.i18n.backend = MyBackend
    #   end
    #
    # Notice this method takes into consideration the default root path. So if you
    # are changing config.root inside your application definition or having a custom
    # Rails application, you will need to add lib to $LOAD_PATH on your own in case
    # you need to load files in lib/ during the application configuration as well.
    #
    # source://railties//lib/rails/application.rb#402
    def add_lib_to_load_path!(root); end

    # source://railties//lib/rails/application.rb#83
    def create(initial_variable_values = T.unsafe(nil), &block); end

    # source://railties//lib/rails/application.rb#87
    def find_root(from); end

    # @private
    #
    # source://railties//lib/rails/application.rb#70
    def inherited(base); end

    # source://railties//lib/rails/application.rb#79
    def instance; end

    def new(*_arg0); end
  end
end

# source://railties//lib/rails/application/bootstrap.rb#11
module Rails::Application::Bootstrap
  include ::Rails::Initializable
  extend ::Rails::Initializable::ClassMethods
end

# source://railties//lib/rails/application/configuration.rb#13
class Rails::Application::Configuration < ::Rails::Engine::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://railties//lib/rails/application/configuration.rb#30
  def initialize(*_arg0); end

  # Returns the value of attribute add_autoload_paths_to_load_path.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def add_autoload_paths_to_load_path; end

  # Sets the attribute add_autoload_paths_to_load_path
  #
  # @param value the value to set the attribute add_autoload_paths_to_load_path to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def add_autoload_paths_to_load_path=(_arg0); end

  # Returns the value of attribute allow_concurrency.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def allow_concurrency; end

  # Sets the attribute allow_concurrency
  #
  # @param value the value to set the attribute allow_concurrency to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def allow_concurrency=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#558
  def annotations; end

  # Returns the value of attribute api_only.
  #
  # source://railties//lib/rails/application/configuration.rb#28
  def api_only; end

  # source://railties//lib/rails/application/configuration.rb#373
  def api_only=(value); end

  # Returns the value of attribute asset_host.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def asset_host; end

  # Sets the attribute asset_host
  #
  # @param value the value to set the attribute asset_host to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def asset_host=(_arg0); end

  # Returns the value of attribute assume_ssl.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def assume_ssl; end

  # Sets the attribute assume_ssl
  #
  # @param value the value to set the attribute assume_ssl to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def assume_ssl=(_arg0); end

  # Returns the value of attribute autoflush_log.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def autoflush_log; end

  # Sets the attribute autoflush_log
  #
  # @param value the value to set the attribute autoflush_log to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def autoflush_log=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#468
  def autoload_lib(ignore:); end

  # source://railties//lib/rails/application/configuration.rb#480
  def autoload_lib_once(ignore:); end

  # Returns the value of attribute beginning_of_week.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def beginning_of_week; end

  # Sets the attribute beginning_of_week
  #
  # @param value the value to set the attribute beginning_of_week to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def beginning_of_week=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#385
  def broadcast_log_level; end

  # Returns the value of attribute cache_classes.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def cache_classes; end

  # Sets the attribute cache_classes
  #
  # @param value the value to set the attribute cache_classes to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def cache_classes=(_arg0); end

  # Returns the value of attribute cache_store.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def cache_store; end

  # Sets the attribute cache_store
  #
  # @param value the value to set the attribute cache_store to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def cache_store=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#492
  def colorize_logging; end

  # source://railties//lib/rails/application/configuration.rb#496
  def colorize_logging=(val); end

  # Returns the value of attribute consider_all_requests_local.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def consider_all_requests_local; end

  # Sets the attribute consider_all_requests_local
  #
  # @param value the value to set the attribute consider_all_requests_local to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def consider_all_requests_local=(_arg0); end

  # Returns the value of attribute console.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def console; end

  # Sets the attribute console
  #
  # @param value the value to set the attribute console to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def console=(_arg0); end

  # Configures the ActionDispatch::ContentSecurityPolicy.
  #
  # source://railties//lib/rails/application/configuration.rb#563
  def content_security_policy(&block); end

  # Returns the value of attribute content_security_policy_nonce_directives.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_nonce_directives; end

  # Sets the attribute content_security_policy_nonce_directives
  #
  # @param value the value to set the attribute content_security_policy_nonce_directives to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_nonce_directives=(_arg0); end

  # Returns the value of attribute content_security_policy_nonce_generator.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_nonce_generator; end

  # Sets the attribute content_security_policy_nonce_generator
  #
  # @param value the value to set the attribute content_security_policy_nonce_generator to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_nonce_generator=(_arg0); end

  # Returns the value of attribute content_security_policy_report_only.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_report_only; end

  # Sets the attribute content_security_policy_report_only
  #
  # @param value the value to set the attribute content_security_policy_report_only to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def content_security_policy_report_only=(_arg0); end

  # Returns the value of attribute credentials.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def credentials; end

  # Sets the attribute credentials
  #
  # @param value the value to set the attribute credentials to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def credentials=(_arg0); end

  # Loads and returns the entire raw configuration of database from
  # values stored in <tt>config/database.yml</tt>.
  #
  # source://railties//lib/rails/application/configuration.rb#431
  def database_configuration; end

  # source://railties//lib/rails/application/configuration.rb#387
  def debug_exception_response_format; end

  # Sets the attribute debug_exception_response_format
  #
  # @param value the value to set the attribute debug_exception_response_format to.
  #
  # source://railties//lib/rails/application/configuration.rb#391
  def debug_exception_response_format=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#580
  def default_log_file; end

  # Returns the value of attribute disable_sandbox.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def disable_sandbox; end

  # Sets the attribute disable_sandbox
  #
  # @param value the value to set the attribute disable_sandbox to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def disable_sandbox=(_arg0); end

  # Returns the value of attribute dom_testing_default_html_version.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def dom_testing_default_html_version; end

  # Sets the attribute dom_testing_default_html_version
  #
  # @param value the value to set the attribute dom_testing_default_html_version to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def dom_testing_default_html_version=(_arg0); end

  # Returns the value of attribute eager_load.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def eager_load; end

  # Sets the attribute eager_load
  #
  # @param value the value to set the attribute eager_load to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def eager_load=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#349
  def enable_reloading; end

  # source://railties//lib/rails/application/configuration.rb#353
  def enable_reloading=(value); end

  # Returns the value of attribute encoding.
  #
  # source://railties//lib/rails/application/configuration.rb#28
  def encoding; end

  # source://railties//lib/rails/application/configuration.rb#365
  def encoding=(value); end

  # Returns the value of attribute exceptions_app.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def exceptions_app; end

  # Sets the attribute exceptions_app
  #
  # @param value the value to set the attribute exceptions_app to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def exceptions_app=(_arg0); end

  # Returns the value of attribute file_watcher.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def file_watcher; end

  # Sets the attribute file_watcher
  #
  # @param value the value to set the attribute file_watcher to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def file_watcher=(_arg0); end

  # Returns the value of attribute filter_parameters.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def filter_parameters; end

  # Sets the attribute filter_parameters
  #
  # @param value the value to set the attribute filter_parameters to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def filter_parameters=(_arg0); end

  # Returns the value of attribute filter_redirect.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def filter_redirect; end

  # Sets the attribute filter_redirect
  #
  # @param value the value to set the attribute filter_redirect to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def filter_redirect=(_arg0); end

  # Returns the value of attribute force_ssl.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def force_ssl; end

  # Sets the attribute force_ssl
  #
  # @param value the value to set the attribute force_ssl to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def force_ssl=(_arg0); end

  # Returns the value of attribute helpers_paths.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def helpers_paths; end

  # Sets the attribute helpers_paths
  #
  # @param value the value to set the attribute helpers_paths to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def helpers_paths=(_arg0); end

  # Returns the value of attribute host_authorization.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def host_authorization; end

  # Sets the attribute host_authorization
  #
  # @param value the value to set the attribute host_authorization to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def host_authorization=(_arg0); end

  # Returns the value of attribute hosts.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def hosts; end

  # Sets the attribute hosts
  #
  # @param value the value to set the attribute hosts to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def hosts=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#592
  def inspect; end

  # Load the <tt>config/database.yml</tt> to create the Rake tasks for
  # multiple databases without loading the environment and filling in the
  # environment specific configuration values.
  #
  # Do not use this method, use #database_configuration instead.
  #
  # source://railties//lib/rails/application/configuration.rb#413
  def load_database_yaml; end

  # Loads default configuration values for a target version. This includes
  # defaults for versions prior to the target version. See the
  # {configuration guide}[https://guides.rubyonrails.org/configuring.html#versioned-default-values]
  # for the default values associated with a particular version.
  #
  # source://railties//lib/rails/application/configuration.rb#91
  def load_defaults(target_version); end

  # Returns the value of attribute loaded_config_version.
  #
  # source://railties//lib/rails/application/configuration.rb#28
  def loaded_config_version; end

  # Returns the value of attribute log_file_size.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_file_size; end

  # Sets the attribute log_file_size
  #
  # @param value the value to set the attribute log_file_size to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_file_size=(_arg0); end

  # Returns the value of attribute log_formatter.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_formatter; end

  # Sets the attribute log_formatter
  #
  # @param value the value to set the attribute log_formatter to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_formatter=(_arg0); end

  # Returns the value of attribute log_level.
  #
  # source://railties//lib/rails/application/configuration.rb#28
  def log_level; end

  # source://railties//lib/rails/application/configuration.rb#380
  def log_level=(level); end

  # Returns the value of attribute log_tags.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_tags; end

  # Sets the attribute log_tags
  #
  # @param value the value to set the attribute log_tags to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def log_tags=(_arg0); end

  # Returns the value of attribute logger.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def logger=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#393
  def paths; end

  # Configures the ActionDispatch::PermissionsPolicy.
  #
  # source://railties//lib/rails/application/configuration.rb#572
  def permissions_policy(&block); end

  # Returns the value of attribute precompile_filter_parameters.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def precompile_filter_parameters; end

  # Sets the attribute precompile_filter_parameters
  #
  # @param value the value to set the attribute precompile_filter_parameters to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def precompile_filter_parameters=(_arg0); end

  # Returns the value of attribute public_file_server.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def public_file_server; end

  # Sets the attribute public_file_server
  #
  # @param value the value to set the attribute public_file_server to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def public_file_server=(_arg0); end

  # Returns the value of attribute railties_order.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def railties_order; end

  # Sets the attribute railties_order
  #
  # @param value the value to set the attribute railties_order to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def railties_order=(_arg0); end

  # Returns the value of attribute rake_eager_load.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def rake_eager_load; end

  # Sets the attribute rake_eager_load
  #
  # @param value the value to set the attribute rake_eager_load to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def rake_eager_load=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#357
  def read_encrypted_secrets; end

  # source://railties//lib/rails/application/configuration.rb#361
  def read_encrypted_secrets=(value); end

  # Returns the value of attribute relative_url_root.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def relative_url_root; end

  # Sets the attribute relative_url_root
  #
  # @param value the value to set the attribute relative_url_root to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def relative_url_root=(_arg0); end

  # Returns the value of attribute reload_classes_only_on_change.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def reload_classes_only_on_change; end

  # Sets the attribute reload_classes_only_on_change
  #
  # @param value the value to set the attribute reload_classes_only_on_change to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def reload_classes_only_on_change=(_arg0); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/application/configuration.rb#345
  def reloading_enabled?; end

  # Returns the value of attribute require_master_key.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def require_master_key; end

  # Sets the attribute require_master_key
  #
  # @param value the value to set the attribute require_master_key to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def require_master_key=(_arg0); end

  # Returns the value of attribute sandbox_by_default.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def sandbox_by_default; end

  # Sets the attribute sandbox_by_default
  #
  # @param value the value to set the attribute sandbox_by_default to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def sandbox_by_default=(_arg0); end

  # source://railties//lib/rails/application/configuration.rb#501
  def secret_key_base; end

  # source://railties//lib/rails/application/configuration.rb#511
  def secret_key_base=(new_secret_key_base); end

  # Returns the value of attribute server_timing.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def server_timing; end

  # Sets the attribute server_timing
  #
  # @param value the value to set the attribute server_timing to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def server_timing=(_arg0); end

  # Returns the value of attribute session_options.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def session_options; end

  # Sets the attribute session_options
  #
  # @param value the value to set the attribute session_options to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def session_options=(_arg0); end

  # Specifies what class to use to store the session. Possible values
  # are +:cache_store+, +:cookie_store+, +:mem_cache_store+, a custom
  # store, or +:disabled+. +:disabled+ tells \Rails not to deal with
  # sessions.
  #
  # Additional options will be set as +session_options+:
  #
  #   config.session_store :cookie_store, key: "_your_app_session"
  #   config.session_options # => {key: "_your_app_session"}
  #
  # If a custom store is specified as a symbol, it will be resolved to
  # the +ActionDispatch::Session+ namespace:
  #
  #   # use ActionDispatch::Session::MyCustomStore as the session store
  #   config.session_store :my_custom_store
  #
  # source://railties//lib/rails/application/configuration.rb#538
  def session_store(new_session_store = T.unsafe(nil), **options); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/application/configuration.rb#554
  def session_store?; end

  # Returns the value of attribute ssl_options.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def ssl_options; end

  # Sets the attribute ssl_options
  #
  # @param value the value to set the attribute ssl_options to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def ssl_options=(_arg0); end

  # Returns the value of attribute time_zone.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def time_zone; end

  # Sets the attribute time_zone
  #
  # @param value the value to set the attribute time_zone to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def time_zone=(_arg0); end

  # Returns the value of attribute x.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def x; end

  # Sets the attribute x
  #
  # @param value the value to set the attribute x to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def x=(_arg0); end

  # Returns the value of attribute yjit.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def yjit; end

  # Sets the attribute yjit
  #
  # @param value the value to set the attribute yjit to.
  #
  # source://railties//lib/rails/application/configuration.rb#14
  def yjit=(_arg0); end

  private

  # source://railties//lib/rails/application/configuration.rb#619
  def credentials_defaults; end

  # source://railties//lib/rails/application/configuration.rb#629
  def generate_local_secret; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/application/configuration.rb#641
  def generate_local_secret?; end
end

# source://railties//lib/rails/application/configuration.rb#596
class Rails::Application::Configuration::Custom
  # @return [Custom] a new instance of Custom
  #
  # source://railties//lib/rails/application/configuration.rb#597
  def initialize; end

  # source://railties//lib/rails/application/configuration.rb#601
  def method_missing(method, *args); end

  private

  # @return [Boolean]
  #
  # source://railties//lib/rails/application/configuration.rb#613
  def respond_to_missing?(symbol, _); end
end

# source://railties//lib/rails/application/default_middleware_stack.rb#5
class Rails::Application::DefaultMiddlewareStack
  # @return [DefaultMiddlewareStack] a new instance of DefaultMiddlewareStack
  #
  # source://railties//lib/rails/application/default_middleware_stack.rb#8
  def initialize(app, config, paths); end

  # Returns the value of attribute app.
  #
  # source://railties//lib/rails/application/default_middleware_stack.rb#6
  def app; end

  # source://railties//lib/rails/application/default_middleware_stack.rb#14
  def build_stack; end

  # Returns the value of attribute config.
  #
  # source://railties//lib/rails/application/default_middleware_stack.rb#6
  def config; end

  # Returns the value of attribute paths.
  #
  # source://railties//lib/rails/application/default_middleware_stack.rb#6
  def paths; end

  private

  # source://railties//lib/rails/application/default_middleware_stack.rb#109
  def load_rack_cache; end

  # source://railties//lib/rails/application/default_middleware_stack.rb#131
  def show_exceptions_app; end
end

# source://railties//lib/rails/application/finisher.rb#11
module Rails::Application::Finisher
  include ::Rails::Initializable
  extend ::Rails::Initializable::ClassMethods
end

# source://railties//lib/rails/application/finisher.rb#111
module Rails::Application::Finisher::InterlockHook
  class << self
    # source://railties//lib/rails/application/finisher.rb#116
    def complete(_state); end

    # source://railties//lib/rails/application/finisher.rb#112
    def run; end
  end
end

# source://railties//lib/rails/application/finisher.rb#97
class Rails::Application::Finisher::MonitorHook
  # @return [MonitorHook] a new instance of MonitorHook
  #
  # source://railties//lib/rails/application/finisher.rb#98
  def initialize(monitor = T.unsafe(nil)); end

  # source://railties//lib/rails/application/finisher.rb#106
  def complete(_state); end

  # source://railties//lib/rails/application/finisher.rb#102
  def run; end
end

# source://railties//lib/rails/application.rb#105
Rails::Application::INITIAL_VARIABLES = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/application/routes_reloader.rb#7
class Rails::Application::RoutesReloader
  include ::ActiveSupport::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker

  # @return [RoutesReloader] a new instance of RoutesReloader
  #
  # source://railties//lib/rails/application/routes_reloader.rb#15
  def initialize; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # Returns the value of attribute eager_load.
  #
  # source://railties//lib/rails/application/routes_reloader.rb#11
  def eager_load; end

  # Sets the attribute eager_load
  #
  # @param value the value to set the attribute eager_load to.
  #
  # source://railties//lib/rails/application/routes_reloader.rb#11
  def eager_load=(_arg0); end

  # source://railties//lib/rails/application/routes_reloader.rb#13
  def execute(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/application/routes_reloader.rb#13
  def execute_if_updated(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute external_routes.
  #
  # source://railties//lib/rails/application/routes_reloader.rb#10
  def external_routes; end

  # Returns the value of attribute paths.
  #
  # source://railties//lib/rails/application/routes_reloader.rb#10
  def paths; end

  # source://railties//lib/rails/application/routes_reloader.rb#22
  def reload!; end

  # Returns the value of attribute route_sets.
  #
  # source://railties//lib/rails/application/routes_reloader.rb#10
  def route_sets; end

  # source://railties//lib/rails/application/routes_reloader.rb#12
  def run_after_load_paths=(_arg0); end

  # source://railties//lib/rails/application/routes_reloader.rb#13
  def updated?(*_arg0, **_arg1, &_arg2); end

  private

  # source://railties//lib/rails/application/routes_reloader.rb#42
  def clear!; end

  # source://railties//lib/rails/application/routes_reloader.rb#58
  def finalize!; end

  # source://railties//lib/rails/application/routes_reloader.rb#49
  def load_paths; end

  # source://railties//lib/rails/application/routes_reloader.rb#62
  def revert; end

  # source://railties//lib/rails/application/routes_reloader.rb#54
  def run_after_load_paths; end

  # source://railties//lib/rails/application/routes_reloader.rb#32
  def updater; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end
  end
end

# source://railties//lib/rails/application_controller.rb#3
class Rails::ApplicationController < ::ActionController::Base
  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://railties//lib/rails/application_controller.rb#25
  def disable_content_security_policy_nonce!; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/application_controller.rb#21
  def local_request?; end

  # source://railties//lib/rails/application_controller.rb#15
  def require_local!; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions; end

    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end
  end
end

# source://railties//lib/rails/autoloaders.rb#4
class Rails::Autoloaders
  include ::Enumerable

  # @return [Autoloaders] a new instance of Autoloaders
  #
  # source://railties//lib/rails/autoloaders.rb#11
  def initialize; end

  # @yield [main]
  #
  # source://railties//lib/rails/autoloaders.rb#31
  def each; end

  # source://railties//lib/rails/autoloaders.rb#40
  def log!; end

  # source://railties//lib/rails/autoloaders.rb#36
  def logger=(logger); end

  # Returns the value of attribute main.
  #
  # source://railties//lib/rails/autoloaders.rb#9
  def main; end

  # Returns the value of attribute once.
  #
  # source://railties//lib/rails/autoloaders.rb#9
  def once; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/autoloaders.rb#44
  def zeitwerk_enabled?; end
end

# source://railties//lib/rails/autoloaders/inflector.rb#7
module Rails::Autoloaders::Inflector
  class << self
    # source://railties//lib/rails/autoloaders/inflector.rb#12
    def camelize(basename, _abspath); end

    # source://railties//lib/rails/autoloaders/inflector.rb#16
    def inflect(overrides); end
  end
end

# source://railties//lib/rails/backtrace_cleaner.rb#7
class Rails::BacktraceCleaner < ::ActiveSupport::BacktraceCleaner
  # @return [BacktraceCleaner] a new instance of BacktraceCleaner
  #
  # source://railties//lib/rails/backtrace_cleaner.rb#11
  def initialize; end

  # source://railties//lib/rails/backtrace_cleaner.rb#29
  def clean(backtrace, kind = T.unsafe(nil)); end

  # source://railties//lib/rails/backtrace_cleaner.rb#36
  def clean_frame(frame, kind = T.unsafe(nil)); end

  # source://railties//lib/rails/backtrace_cleaner.rb#29
  def filter(backtrace, kind = T.unsafe(nil)); end
end

# source://railties//lib/rails/backtrace_cleaner.rb#8
Rails::BacktraceCleaner::APP_DIRS_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://railties//lib/rails/backtrace_cleaner.rb#9
Rails::BacktraceCleaner::RENDER_TEMPLATE_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://railties//lib/rails/command.rb#11
module Rails::Command
  include ::Rails::Command::Behavior
  extend ::ActiveSupport::Autoload
  extend ::Rails::Command::Behavior::ClassMethods

  class << self
    # source://railties//lib/rails/command.rb#116
    def application_root; end

    # source://railties//lib/rails/command.rb#57
    def environment; end

    # Rails finds namespaces similar to Thor, it only adds one rule:
    #
    # Command names must end with "_command.rb". This is required because Rails
    # looks in load paths and loads the command just before it's going to be used.
    #
    #   find_by_namespace :webrat, :integration
    #
    # Will search for the following commands:
    #
    #   "webrat", "webrat:integration", "rails:webrat", "rails:webrat:integration"
    #
    # source://railties//lib/rails/command.rb#96
    def find_by_namespace(namespace, command_name = T.unsafe(nil)); end

    # source://railties//lib/rails/command.rb#53
    def hidden_commands; end

    # Receives a namespace, arguments, and the behavior to invoke the command.
    #
    # source://railties//lib/rails/command.rb#62
    def invoke(full_namespace, args = T.unsafe(nil), **config); end

    # source://railties//lib/rails/command.rb#120
    def printing_commands; end

    # Returns the root of the \Rails engine or app running the command.
    #
    # source://railties//lib/rails/command.rb#108
    def root; end

    private

    # source://railties//lib/rails/command.rb#159
    def command_type; end

    # source://railties//lib/rails/command.rb#167
    def file_lookup_paths; end

    # source://railties//lib/rails/command.rb#154
    def invoke_rake(task, args, config); end

    # source://railties//lib/rails/command.rb#163
    def lookup_paths; end

    # @return [Boolean]
    #
    # source://railties//lib/rails/command.rb#127
    def rails_new_with_no_path?(args); end

    # source://railties//lib/rails/command.rb#131
    def split_namespace(namespace); end

    # source://railties//lib/rails/command.rb#146
    def with_argv(argv); end
  end
end

# source://railties//lib/rails/command/actions.rb#5
module Rails::Command::Actions
  # source://railties//lib/rails/command/actions.rb#18
  def boot_application!; end

  # source://railties//lib/rails/command/actions.rb#23
  def load_environment_config!; end

  # source://railties//lib/rails/command/actions.rb#46
  def load_generators; end

  # source://railties//lib/rails/command/actions.rb#42
  def load_tasks; end

  # source://railties//lib/rails/command/actions.rb#13
  def require_application!; end

  # Change to the application's path if there is no <tt>config.ru</tt> file in current directory.
  # This allows us to run <tt>rails server</tt> from other directories, but still get
  # the main <tt>config.ru</tt> and properly set the <tt>tmp</tt> directory.
  #
  # source://railties//lib/rails/command/actions.rb#9
  def set_application_directory!; end
end

# source://railties//lib/rails/command/base.rb#14
class Rails::Command::Base < ::Thor
  include ::Rails::Command::Actions

  # source://thor/1.3.2/lib/thor/base.rb#155
  def current_subcommand; end

  # source://railties//lib/rails/command/base.rb#172
  def executable(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/command/base.rb#175
  def invoke_command(command, *_arg1); end

  class << self
    # source://railties//lib/rails/command/base.rb#86
    def banner(command = T.unsafe(nil), *_arg1); end

    # Sets the base_name taking into account the current class namespace.
    #
    #   Rails::Command::TestCommand.base_name # => 'rails'
    #
    # source://railties//lib/rails/command/base.rb#106
    def base_name; end

    # source://railties//lib/rails/command/base.rb#20
    def bin; end

    # source://railties//lib/rails/command/base.rb#20
    def bin=(value); end

    # source://railties//lib/rails/command/base.rb#20
    def bin?; end

    # source://railties//lib/rails/command/base.rb#122
    def class_usage; end

    # Return command name without namespaces.
    #
    #   Rails::Command::TestCommand.command_name # => 'test'
    #
    # source://railties//lib/rails/command/base.rb#115
    def command_name; end

    # Default file root to place extra files a command might need, placed
    # one folder above the command file.
    #
    # For a Rails::Command::TestCommand placed in <tt>rails/command/test_command.rb</tt>
    # would return <tt>rails/test</tt>.
    #
    # source://railties//lib/rails/command/base.rb#139
    def default_command_root; end

    # Tries to get the description from a USAGE file one folder above the command
    # root.
    #
    # source://railties//lib/rails/command/base.rb#34
    def desc(usage = T.unsafe(nil), description = T.unsafe(nil), options = T.unsafe(nil)); end

    # Returns true when the app is a \Rails engine.
    #
    # @return [Boolean]
    #
    # source://railties//lib/rails/command/base.rb#28
    def engine?; end

    # source://railties//lib/rails/command/base.rb#82
    def executable(command_name = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/command/base.rb#23
    def exit_on_failure?; end

    # Override Thor's class-level help to also show the USAGE.
    #
    # source://railties//lib/rails/command/base.rb#98
    def help(shell, *_arg1); end

    # Convenience method to hide this command from the available ones when
    # running rails command.
    #
    # source://railties//lib/rails/command/base.rb#55
    def hide_command!; end

    # source://railties//lib/rails/command/base.rb#59
    def inherited(base); end

    # Convenience method to get the namespace from the class name. It's the
    # same as Thor default except that the Command at the end of the class
    # is removed.
    #
    # source://railties//lib/rails/command/base.rb#45
    def namespace(name = T.unsafe(nil)); end

    # source://railties//lib/rails/command/base.rb#67
    def perform(command, args, config); end

    # source://railties//lib/rails/command/base.rb#76
    def printing_commands; end

    # Path to lookup a USAGE description in a file.
    #
    # source://railties//lib/rails/command/base.rb#129
    def usage_path; end

    private

    # Allow the command method to be called perform.
    #
    # source://railties//lib/rails/command/base.rb#146
    def create_command(meth); end

    # source://railties//lib/rails/command/base.rb#159
    def namespaced_name(name); end

    # source://railties//lib/rails/command/base.rb#164
    def resolve_path(path); end
  end
end

# source://railties//lib/rails/command/base.rb#15
class Rails::Command::Base::Error < ::Thor::Error; end

# source://railties//lib/rails/command/behavior.rb#7
module Rails::Command::Behavior
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::Rails::Command::Behavior::ClassMethods
end

# source://railties//lib/rails/command/behavior.rb#0
module Rails::Command::Behavior::ClassMethods
  # source://railties//lib/rails/command/behavior.rb#12
  def no_color!; end

  # source://railties//lib/rails/command/behavior.rb#17
  def subclasses; end

  private

  # source://railties//lib/rails/command/behavior.rb#36
  def lookup(namespaces); end

  # source://railties//lib/rails/command/behavior.rb#56
  def lookup!; end

  # source://railties//lib/rails/command/behavior.rb#70
  def namespaces_to_paths(namespaces); end

  # source://railties//lib/rails/command/behavior.rb#23
  def print_list(base, namespaces); end
end

# source://railties//lib/rails/command.rb#17
class Rails::Command::CorrectableNameError < ::StandardError
  include ::DidYouMean::Correctable

  # @return [CorrectableNameError] a new instance of CorrectableNameError
  #
  # source://railties//lib/rails/command.rb#20
  def initialize(message, name, alternatives); end

  # source://railties//lib/rails/command.rb#35
  def corrections; end

  # Returns the value of attribute name.
  #
  # source://railties//lib/rails/command.rb#18
  def name; end
end

# source://railties//lib/rails/command.rb#49
Rails::Command::HELP_MAPPINGS = T.let(T.unsafe(nil), Set)

# source://railties//lib/rails/command.rb#41
class Rails::Command::UnrecognizedCommandError < ::Rails::Command::CorrectableNameError
  # @return [UnrecognizedCommandError] a new instance of UnrecognizedCommandError
  #
  # source://railties//lib/rails/command.rb#42
  def initialize(name); end
end

# source://railties//lib/rails/command.rb#50
Rails::Command::VERSION_MAPPINGS = T.let(T.unsafe(nil), Set)

# source://railties//lib/rails/configuration.rb#9
module Rails::Configuration; end

# source://railties//lib/rails/configuration.rb#104
class Rails::Configuration::Generators
  # @return [Generators] a new instance of Generators
  #
  # source://railties//lib/rails/configuration.rb#108
  def initialize; end

  # source://railties//lib/rails/configuration.rb#130
  def after_generate(&block); end

  # Returns the value of attribute after_generate_callbacks.
  #
  # source://railties//lib/rails/configuration.rb#106
  def after_generate_callbacks; end

  # Returns the value of attribute aliases.
  #
  # source://railties//lib/rails/configuration.rb#105
  def aliases; end

  # Sets the attribute aliases
  #
  # @param value the value to set the attribute aliases to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def aliases=(_arg0); end

  # Returns the value of attribute api_only.
  #
  # source://railties//lib/rails/configuration.rb#105
  def api_only; end

  # Sets the attribute api_only
  #
  # @param value the value to set the attribute api_only to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def api_only=(_arg0); end

  # source://railties//lib/rails/configuration.rb#134
  def apply_rubocop_autocorrect_after_generate!; end

  # Returns the value of attribute colorize_logging.
  #
  # source://railties//lib/rails/configuration.rb#105
  def colorize_logging; end

  # Sets the attribute colorize_logging
  #
  # @param value the value to set the attribute colorize_logging to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def colorize_logging=(_arg0); end

  # Returns the value of attribute fallbacks.
  #
  # source://railties//lib/rails/configuration.rb#105
  def fallbacks; end

  # Sets the attribute fallbacks
  #
  # @param value the value to set the attribute fallbacks to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def fallbacks=(_arg0); end

  # Returns the value of attribute hidden_namespaces.
  #
  # source://railties//lib/rails/configuration.rb#106
  def hidden_namespaces; end

  # source://railties//lib/rails/configuration.rb#126
  def hide_namespace(namespace); end

  # source://railties//lib/rails/configuration.rb#143
  def method_missing(method, *args); end

  # Returns the value of attribute options.
  #
  # source://railties//lib/rails/configuration.rb#105
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def options=(_arg0); end

  # Returns the value of attribute templates.
  #
  # source://railties//lib/rails/configuration.rb#105
  def templates; end

  # Sets the attribute templates
  #
  # @param value the value to set the attribute templates to.
  #
  # source://railties//lib/rails/configuration.rb#105
  def templates=(_arg0); end

  private

  # source://railties//lib/rails/configuration.rb#119
  def initialize_copy(source); end
end

# MiddlewareStackProxy is a proxy for the \Rails middleware stack that allows
# you to configure middlewares in your application. It works basically as a
# command recorder, saving each command to be applied after initialization
# over the default middleware stack, so you can add, swap, or remove any
# middleware in \Rails.
#
# You can add your own middlewares by using the +config.middleware.use+ method:
#
#     config.middleware.use Magical::Unicorns
#
# This will put the +Magical::Unicorns+ middleware on the end of the stack.
# You can use +insert_before+ if you wish to add a middleware before another:
#
#     config.middleware.insert_before Rack::Head, Magical::Unicorns
#
# There's also +insert_after+ which will insert a middleware after another:
#
#     config.middleware.insert_after Rack::Head, Magical::Unicorns
#
# Middlewares can also be completely swapped out and replaced with others:
#
#     config.middleware.swap ActionDispatch::Flash, Magical::Unicorns
#
# Middlewares can be moved from one place to another:
#
#     config.middleware.move_before ActionDispatch::Flash, Magical::Unicorns
#
# This will move the +Magical::Unicorns+ middleware before the
# +ActionDispatch::Flash+. You can also move it after:
#
#     config.middleware.move_after ActionDispatch::Flash, Magical::Unicorns
#
# And finally they can also be removed from the stack completely:
#
#     config.middleware.delete ActionDispatch::Flash
#
# source://railties//lib/rails/configuration.rb#46
class Rails::Configuration::MiddlewareStackProxy
  # @return [MiddlewareStackProxy] a new instance of MiddlewareStackProxy
  #
  # source://railties//lib/rails/configuration.rb#47
  def initialize(operations = T.unsafe(nil), delete_operations = T.unsafe(nil)); end

  # source://railties//lib/rails/configuration.rb#96
  def +(other); end

  # source://railties//lib/rails/configuration.rb#70
  def delete(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#52
  def insert(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#58
  def insert_after(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#52
  def insert_before(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#88
  def merge_into(other); end

  # source://railties//lib/rails/configuration.rb#74
  def move(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#80
  def move_after(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#74
  def move_before(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#62
  def swap(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#84
  def unshift(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/configuration.rb#66
  def use(*_arg0, **_arg1, &_arg2); end

  protected

  # Returns the value of attribute delete_operations.
  #
  # source://railties//lib/rails/configuration.rb#101
  def delete_operations; end

  # Returns the value of attribute operations.
  #
  # source://railties//lib/rails/configuration.rb#101
  def operations; end
end

# +Rails::Engine+ allows you to wrap a specific \Rails application or subset of
# functionality and share it with other applications or within a larger packaged application.
# Every Rails::Application is just an engine, which allows for simple
# feature and application sharing.
#
# Any +Rails::Engine+ is also a Rails::Railtie, so the same
# methods (like {rake_tasks}[rdoc-ref:Rails::Railtie::rake_tasks] and
# {generators}[rdoc-ref:Rails::Railtie::generators]) and configuration
# options that are available in railties can also be used in engines.
#
# == Creating an Engine
#
# If you want a gem to behave as an engine, you have to specify an +Engine+
# for it somewhere inside your plugin's +lib+ folder (similar to how we
# specify a +Railtie+):
#
#   # lib/my_engine.rb
#   module MyEngine
#     class Engine < Rails::Engine
#     end
#   end
#
# Then ensure that this file is loaded at the top of your <tt>config/application.rb</tt>
# (or in your +Gemfile+), and it will automatically load models, controllers, and helpers
# inside +app+, load routes at <tt>config/routes.rb</tt>, load locales at
# <tt>config/locales/**/*</tt>, and load tasks at <tt>lib/tasks/**/*</tt>.
#
# == Configuration
#
# Like railties, engines can access a config object which contains configuration shared by
# all railties and the application.
# Additionally, each engine can access <tt>autoload_paths</tt>, <tt>eager_load_paths</tt> and
# <tt>autoload_once_paths</tt> settings which are scoped to that engine.
#
#   class MyEngine < Rails::Engine
#     # Add a load path for this specific Engine
#     config.autoload_paths << File.expand_path("lib/some/path", __dir__)
#
#     initializer "my_engine.add_middleware" do |app|
#       app.middleware.use MyEngine::Middleware
#     end
#   end
#
# == Generators
#
# You can set up generators for engines with <tt>config.generators</tt> method:
#
#   class MyEngine < Rails::Engine
#     config.generators do |g|
#       g.orm             :active_record
#       g.template_engine :erb
#       g.test_framework  :test_unit
#     end
#   end
#
# You can also set generators for an application by using <tt>config.app_generators</tt>:
#
#   class MyEngine < Rails::Engine
#     # note that you can also pass block to app_generators in the same way you
#     # can pass it to generators method
#     config.app_generators.orm :datamapper
#   end
#
# == Paths
#
# Applications and engines have flexible path configuration, meaning that you
# are not required to place your controllers at <tt>app/controllers</tt>, but
# in any place which you find convenient.
#
# For example, let's suppose you want to place your controllers in <tt>lib/controllers</tt>.
# You can set that as an option:
#
#   class MyEngine < Rails::Engine
#     paths["app/controllers"] = "lib/controllers"
#   end
#
# You can also have your controllers loaded from both <tt>app/controllers</tt> and
# <tt>lib/controllers</tt>:
#
#   class MyEngine < Rails::Engine
#     paths["app/controllers"] << "lib/controllers"
#   end
#
# The available paths in an engine are:
#
#   class MyEngine < Rails::Engine
#     paths["app"]                 # => ["app"]
#     paths["app/controllers"]     # => ["app/controllers"]
#     paths["app/helpers"]         # => ["app/helpers"]
#     paths["app/models"]          # => ["app/models"]
#     paths["app/views"]           # => ["app/views"]
#     paths["lib"]                 # => ["lib"]
#     paths["lib/tasks"]           # => ["lib/tasks"]
#     paths["config"]              # => ["config"]
#     paths["config/initializers"] # => ["config/initializers"]
#     paths["config/locales"]      # => ["config/locales"]
#     paths["config/routes.rb"]    # => ["config/routes.rb"]
#   end
#
# The <tt>Application</tt> class adds a couple more paths to this set. And as in your
# <tt>Application</tt>, all folders under +app+ are automatically added to the load path.
# If you have an <tt>app/services</tt> folder for example, it will be added by default.
#
# == Endpoint
#
# An engine can also be a Rack application. It can be useful if you have a Rack application that
# you would like to provide with some of the +Engine+'s features.
#
# To do that, use the ::endpoint method:
#
#   module MyEngine
#     class Engine < Rails::Engine
#       endpoint MyRackApplication
#     end
#   end
#
# Now you can mount your engine in application's routes:
#
#   Rails.application.routes.draw do
#     mount MyEngine::Engine => "/engine"
#   end
#
# == Middleware stack
#
# As an engine can now be a Rack endpoint, it can also have a middleware
# stack. The usage is exactly the same as in <tt>Application</tt>:
#
#   module MyEngine
#     class Engine < Rails::Engine
#       middleware.use SomeMiddleware
#     end
#   end
#
# == Routes
#
# If you don't specify an endpoint, routes will be used as the default
# endpoint. You can use them just like you use an application's routes:
#
#   # ENGINE/config/routes.rb
#   MyEngine::Engine.routes.draw do
#     get "/" => "posts#index"
#   end
#
# == Mount priority
#
# Note that now there can be more than one router in your application, and it's better to avoid
# passing requests through many routers. Consider this situation:
#
#   Rails.application.routes.draw do
#     mount MyEngine::Engine => "/blog"
#     get "/blog/omg" => "main#omg"
#   end
#
# +MyEngine+ is mounted at <tt>/blog</tt>, and <tt>/blog/omg</tt> points to application's
# controller. In such a situation, requests to <tt>/blog/omg</tt> will go through +MyEngine+,
# and if there is no such route in +Engine+'s routes, it will be dispatched to <tt>main#omg</tt>.
# It's much better to swap that:
#
#   Rails.application.routes.draw do
#     get "/blog/omg" => "main#omg"
#     mount MyEngine::Engine => "/blog"
#   end
#
# Now, +Engine+ will get only requests that were not handled by +Application+.
#
# == Engine name
#
# There are some places where an Engine's name is used:
#
# * routes: when you mount an Engine with <tt>mount(MyEngine::Engine => '/my_engine')</tt>,
#   it's used as default <tt>:as</tt> option
# * rake task for installing migrations <tt>my_engine:install:migrations</tt>
#
# Engine name is set by default based on class name. For +MyEngine::Engine+ it will be
# <tt>my_engine_engine</tt>. You can change it manually using the <tt>engine_name</tt> method:
#
#   module MyEngine
#     class Engine < Rails::Engine
#       engine_name "my_engine"
#     end
#   end
#
# == Isolated Engine
#
# Normally when you create controllers, helpers, and models inside an engine, they are treated
# as if they were created inside the application itself. This means that all helpers and
# named routes from the application will be available to your engine's controllers as well.
#
# However, sometimes you want to isolate your engine from the application, especially if your engine
# has its own router. To do that, you simply need to call ::isolate_namespace. This method requires
# you to pass a module where all your controllers, helpers, and models should be nested to:
#
#   module MyEngine
#     class Engine < Rails::Engine
#       isolate_namespace MyEngine
#     end
#   end
#
# With such an engine, everything that is inside the +MyEngine+ module will be isolated from
# the application.
#
# Consider this controller:
#
#   module MyEngine
#     class FooController < ActionController::Base
#     end
#   end
#
# If the +MyEngine+ engine is marked as isolated, +FooController+ only has
# access to helpers from +MyEngine+, and <tt>url_helpers</tt> from
# <tt>MyEngine::Engine.routes</tt>.
#
# The next thing that changes in isolated engines is the behavior of routes.
# Normally, when you namespace your controllers, you also need to namespace
# the related routes. With an isolated engine, the engine's namespace is
# automatically applied, so you don't need to specify it explicitly in your
# routes:
#
#   MyEngine::Engine.routes.draw do
#     resources :articles
#   end
#
# If +MyEngine+ is isolated, the routes above will point to
# +MyEngine::ArticlesController+. You also don't need to use longer
# URL helpers like +my_engine_articles_path+. Instead, you should simply use
# +articles_path+, like you would do with your main application.
#
# To make this behavior consistent with other parts of the framework,
# isolated engines also have an effect on ActiveModel::Naming. In a
# normal \Rails app, when you use a namespaced model such as
# +Namespace::Article+, ActiveModel::Naming will generate
# names with the prefix "namespace". In an isolated engine, the prefix will
# be omitted in URL helpers and form fields, for convenience.
#
#   polymorphic_url(MyEngine::Article.new)
#   # => "articles_path" # not "my_engine_articles_path"
#
#   form_for(MyEngine::Article.new) do
#     text_field :title # => <input type="text" name="article[title]" id="article_title" />
#   end
#
# Additionally, an isolated engine will set its own name according to its
# namespace, so <tt>MyEngine::Engine.engine_name</tt> will return
# "my_engine". It will also set +MyEngine.table_name_prefix+ to "my_engine_",
# meaning for example that +MyEngine::Article+ will use the
# +my_engine_articles+ database table by default.
#
# == Using Engine's routes outside Engine
#
# Since you can now mount an engine inside application's routes, you do not have direct access to +Engine+'s
# <tt>url_helpers</tt> inside +Application+. When you mount an engine in an application's routes, a special helper is
# created to allow you to do that. Consider such a scenario:
#
#   # config/routes.rb
#   Rails.application.routes.draw do
#     mount MyEngine::Engine => "/my_engine", as: "my_engine"
#     get "/foo" => "foo#index"
#   end
#
# Now, you can use the <tt>my_engine</tt> helper inside your application:
#
#   class FooController < ApplicationController
#     def index
#       my_engine.root_url # => /my_engine/
#     end
#   end
#
# There is also a <tt>main_app</tt> helper that gives you access to application's routes inside Engine:
#
#   module MyEngine
#     class BarController
#       def index
#         main_app.foo_path # => /foo
#       end
#     end
#   end
#
# Note that the <tt>:as</tt> option given to mount takes the <tt>engine_name</tt> as default, so most of the time
# you can simply omit it.
#
# Finally, if you want to generate a URL to an engine's route using
# <tt>polymorphic_url</tt>, you also need to pass the engine helper. Let's
# say that you want to create a form pointing to one of the engine's routes.
# All you need to do is pass the helper as the first element in array with
# attributes for URL:
#
#   form_for([my_engine, @user])
#
# This code will use <tt>my_engine.user_path(@user)</tt> to generate the proper route.
#
# == Isolated engine's helpers
#
# Sometimes you may want to isolate an engine, but use helpers that are defined for it.
# If you want to share just a few specific helpers you can add them to application's
# helpers in ApplicationController:
#
#   class ApplicationController < ActionController::Base
#     helper MyEngine::SharedEngineHelper
#   end
#
# If you want to include all of the engine's helpers, you can use the #helper method on an engine's
# instance:
#
#   class ApplicationController < ActionController::Base
#     helper MyEngine::Engine.helpers
#   end
#
# It will include all of the helpers from engine's directory. Take into account this does
# not include helpers defined in controllers with helper_method or other similar solutions,
# only helpers defined in the helpers directory will be included.
#
# == Migrations & seed data
#
# Engines can have their own migrations. The default path for migrations is exactly the same
# as in application: <tt>db/migrate</tt>
#
# To use engine's migrations in application you can use the rake task below, which copies them to
# application's dir:
#
#   $ rake ENGINE_NAME:install:migrations
#
# Note that some of the migrations may be skipped if a migration with the same name already exists
# in application. In such a situation you must decide whether to leave that migration or rename the
# migration in the application and rerun copying migrations.
#
# If your engine has migrations, you may also want to prepare data for the database in
# the <tt>db/seeds.rb</tt> file. You can load that data using the <tt>load_seed</tt> method, e.g.
#
#   MyEngine::Engine.load_seed
#
# == Loading priority
#
# In order to change engine's priority you can use +config.railties_order+ in the main application.
# It will affect the priority of loading views, helpers, assets, and all the other files
# related to engine or application.
#
#   # load Blog::Engine with highest priority, followed by application and other railties
#   config.railties_order = [Blog::Engine, :main_app, :all]
#
# source://railties//lib/rails/engine/railties.rb#4
class Rails::Engine < ::Rails::Railtie
  include ::ActiveSupport::Callbacks
  extend ::ActiveSupport::Callbacks::ClassMethods

  # @return [Engine] a new instance of Engine
  #
  # source://railties//lib/rails/engine.rb#439
  def initialize; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _load_seed_callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_load_seed_callbacks(&block); end

  # Returns the underlying Rack application for this engine.
  #
  # source://railties//lib/rails/engine.rb#516
  def app; end

  # Define the Rack API for this engine.
  #
  # source://railties//lib/rails/engine.rb#533
  def call(env); end

  # Define the configuration object for the engine.
  #
  # source://railties//lib/rails/engine.rb#552
  def config; end

  # source://railties//lib/rails/engine.rb#490
  def eager_load!; end

  # Returns the endpoint for this engine. If none is registered,
  # defaults to an ActionDispatch::Routing::RouteSet.
  #
  # source://railties//lib/rails/engine.rb#528
  def endpoint; end

  # source://railties//lib/rails/engine.rb#437
  def engine_name(*_arg0, **_arg1, &_arg2); end

  # Defines additional Rack env configuration that is added on each call.
  #
  # source://railties//lib/rails/engine.rb#539
  def env_config; end

  # Returns a module with all the helpers defined for the engine.
  #
  # source://railties//lib/rails/engine.rb#500
  def helpers; end

  # Returns all registered helpers paths.
  #
  # source://railties//lib/rails/engine.rb#511
  def helpers_paths; end

  # source://railties//lib/rails/engine.rb#437
  def isolated?(&_arg0); end

  # Load console and invoke the registered hooks.
  # Check Rails::Railtie.console for more info.
  #
  # source://railties//lib/rails/engine.rb#453
  def load_console(app = T.unsafe(nil)); end

  # Load \Rails generators and invoke the registered hooks.
  # Check Rails::Railtie.generators for more info.
  #
  # source://railties//lib/rails/engine.rb#476
  def load_generators(app = T.unsafe(nil)); end

  # Load \Rails runner and invoke the registered hooks.
  # Check Rails::Railtie.runner for more info.
  #
  # source://railties//lib/rails/engine.rb#461
  def load_runner(app = T.unsafe(nil)); end

  # Load data from db/seeds.rb file. It can be used in to load engines'
  # seeds, e.g.:
  #
  # Blog::Engine.load_seed
  #
  # source://railties//lib/rails/engine.rb#560
  def load_seed; end

  # Invoke the server registered hooks.
  # Check Rails::Railtie.server for more info.
  #
  # source://railties//lib/rails/engine.rb#485
  def load_server(app = T.unsafe(nil)); end

  # Load Rake and railties tasks, and invoke the registered hooks.
  # Check Rails::Railtie.rake_tasks for more info.
  #
  # source://railties//lib/rails/engine.rb#468
  def load_tasks(app = T.unsafe(nil)); end

  # source://railties//lib/rails/engine.rb#436
  def middleware(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/engine.rb#436
  def paths(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/engine.rb#495
  def railties; end

  # source://railties//lib/rails/engine.rb#436
  def root(*_arg0, **_arg1, &_arg2); end

  # Defines the routes for this engine. If a block is given to
  # routes, it is appended to the engine.
  #
  # source://railties//lib/rails/engine.rb#545
  def routes(&block); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/engine.rb#676
  def routes?; end

  protected

  # source://railties//lib/rails/engine.rb#681
  def run_tasks_blocks(*_arg0); end

  private

  # source://railties//lib/rails/engine.rb#713
  def _all_autoload_once_paths; end

  # source://railties//lib/rails/engine.rb#717
  def _all_autoload_paths; end

  # source://railties//lib/rails/engine.rb#726
  def _all_load_paths(add_autoload_paths_to_load_path); end

  # source://railties//lib/rails/engine.rb#751
  def build_middleware; end

  # source://railties//lib/rails/engine.rb#743
  def build_request(env); end

  # source://railties//lib/rails/engine.rb#709
  def default_middleware_stack; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/engine.rb#737
  def fixtures_in_root_and_not_in_vendor_or_dot_dir?(fixtures); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/engine.rb#693
  def has_migrations?; end

  # source://railties//lib/rails/engine.rb#687
  def load_config_initializer(initializer); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _load_seed_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _load_seed_callbacks=(value); end

    # Returns the value of attribute called_from.
    #
    # source://railties//lib/rails/engine.rb#354
    def called_from; end

    # Sets the attribute called_from
    #
    # @param value the value to set the attribute called_from to.
    #
    # source://railties//lib/rails/engine.rb#354
    def called_from=(_arg0); end

    # source://railties//lib/rails/engine.rb#359
    def eager_load!(*_arg0, **_arg1, &_arg2); end

    # source://railties//lib/rails/engine.rb#379
    def endpoint(endpoint = T.unsafe(nil)); end

    # source://railties//lib/rails/railtie.rb#176
    def engine_name(name = T.unsafe(nil)); end

    # Finds engine with given path.
    #
    # source://railties//lib/rails/engine.rb#423
    def find(path); end

    # source://railties//lib/rails/engine.rb#375
    def find_root(from); end

    # source://railties//lib/rails/engine.rb#697
    def find_root_with_flag(flag, root_path, default = T.unsafe(nil)); end

    # @private
    #
    # source://railties//lib/rails/engine.rb#361
    def inherited(base); end

    # source://railties//lib/rails/engine.rb#385
    def isolate_namespace(mod); end

    # Returns the value of attribute isolated.
    #
    # source://railties//lib/rails/engine.rb#354
    def isolated; end

    # Sets the attribute isolated
    #
    # @param value the value to set the attribute isolated to.
    #
    # source://railties//lib/rails/engine.rb#354
    def isolated=(_arg0); end

    # Returns the value of attribute isolated.
    #
    # source://railties//lib/rails/engine.rb#354
    def isolated?; end
  end
end

# source://railties//lib/rails/engine/configuration.rb#7
class Rails::Engine::Configuration < ::Rails::Railtie::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://railties//lib/rails/engine/configuration.rb#41
  def initialize(root = T.unsafe(nil)); end

  # Private method that adds custom autoload once paths to the ones defined
  # by +paths+.
  #
  # source://railties//lib/rails/engine/configuration.rb#125
  def all_autoload_once_paths; end

  # Private method that adds custom autoload paths to the ones defined by
  # +paths+.
  #
  # source://railties//lib/rails/engine/configuration.rb#119
  def all_autoload_paths; end

  # Private method that adds custom eager load paths to the ones defined by
  # +paths+.
  #
  # source://railties//lib/rails/engine/configuration.rb#131
  def all_eager_load_paths; end

  # An array of custom autoload once paths. These won't be eager loaded
  # unless you push them to +eager_load_paths+ too, which is recommended.
  #
  # This collection is empty by default, it accepts strings and +Pathname+
  # objects.
  #
  # If you'd like to add +lib+ to it, please see +autoload_lib_once+.
  #
  # source://railties//lib/rails/engine/configuration.rb#29
  def autoload_once_paths; end

  # Sets the attribute autoload_once_paths
  #
  # @param value the value to set the attribute autoload_once_paths to.
  #
  # source://railties//lib/rails/engine/configuration.rb#10
  def autoload_once_paths=(_arg0); end

  # An array of custom autoload paths to be added to the ones defined
  # automatically by Rails. These won't be eager loaded, unless you push
  # them to +eager_load_paths+ too, which is recommended.
  #
  # This collection is empty by default, it accepts strings and +Pathname+
  # objects.
  #
  # If you'd like to add +lib+ to it, please see +autoload_lib+.
  #
  # source://railties//lib/rails/engine/configuration.rb#20
  def autoload_paths; end

  # Sets the attribute autoload_paths
  #
  # @param value the value to set the attribute autoload_paths to.
  #
  # source://railties//lib/rails/engine/configuration.rb#10
  def autoload_paths=(_arg0); end

  # An array of custom eager load paths to be added to the ones defined
  # automatically by Rails. Anything in this collection is considered to be
  # an autoload path regardless of whether it was added to +autoload_paths+.
  #
  # This collection is empty by default, it accepts strings and +Pathname+
  # objects.
  #
  # If you'd like to add +lib+ to it, please see +autoload_lib+.
  #
  # source://railties//lib/rails/engine/configuration.rb#39
  def eager_load_paths; end

  # Sets the attribute eager_load_paths
  #
  # @param value the value to set the attribute eager_load_paths to.
  #
  # source://railties//lib/rails/engine/configuration.rb#10
  def eager_load_paths=(_arg0); end

  # Holds generators configuration:
  #
  #   config.generators do |g|
  #     g.orm             :data_mapper, migration: true
  #     g.template_engine :haml
  #     g.test_framework  :rspec
  #   end
  #
  # If you want to disable color in console, do:
  #
  #   config.generators.colorize_logging = false
  #
  # @yield [@generators]
  #
  # source://railties//lib/rails/engine/configuration.rb#65
  def generators; end

  # Returns the value of attribute javascript_path.
  #
  # source://railties//lib/rails/engine/configuration.rb#9
  def javascript_path; end

  # Sets the attribute javascript_path
  #
  # @param value the value to set the attribute javascript_path to.
  #
  # source://railties//lib/rails/engine/configuration.rb#9
  def javascript_path=(_arg0); end

  # Returns the value of attribute middleware.
  #
  # source://railties//lib/rails/engine/configuration.rb#9
  def middleware; end

  # Sets the attribute middleware
  #
  # @param value the value to set the attribute middleware to.
  #
  # source://railties//lib/rails/engine/configuration.rb#9
  def middleware=(_arg0); end

  # source://railties//lib/rails/engine/configuration.rb#71
  def paths; end

  # Returns the value of attribute root.
  #
  # source://railties//lib/rails/engine/configuration.rb#8
  def root; end

  # source://railties//lib/rails/engine/configuration.rb#113
  def root=(value); end
end

# source://railties//lib/rails/engine/railties.rb#5
class Rails::Engine::Railties
  include ::Enumerable

  # @return [Railties] a new instance of Railties
  #
  # source://railties//lib/rails/engine/railties.rb#9
  def initialize; end

  # source://railties//lib/rails/engine/railties.rb#18
  def -(others); end

  # Returns the value of attribute _all.
  #
  # source://railties//lib/rails/engine/railties.rb#7
  def _all; end

  # source://railties//lib/rails/engine/railties.rb#14
  def each(*args, &block); end
end

# source://railties//lib/rails/generators.rb#14
module Rails::Generators
  include ::Rails::Command::Behavior
  extend ::Rails::Command::Behavior::ClassMethods

  # source://railties//lib/rails/generators.rb#28
  def namespace; end

  # source://railties//lib/rails/generators.rb#28
  def namespace=(val); end

  class << self
    # source://railties//lib/rails/generators.rb#274
    def add_generated_file(file); end

    # source://railties//lib/rails/generators.rb#89
    def after_generate_callbacks; end

    # source://railties//lib/rails/generators.rb#81
    def aliases; end

    # Configure generators for API only applications. It basically hides
    # everything that is usually browser related, such as assets and session
    # migration generators, and completely disable helpers and assets
    # so generators such as scaffold won't create them.
    #
    # source://railties//lib/rails/generators.rb#113
    def api_only!; end

    # source://railties//lib/rails/generators.rb#65
    def configure!(config); end

    # Hold configured generators fallbacks. If a plugin developer wants a
    # generator group to fall back to another group in case of missing generators,
    # they can add a fallback.
    #
    # For example, shoulda is considered a test_framework and is an extension
    # of test_unit. However, most part of shoulda generators are similar to
    # test_unit ones.
    #
    # Shoulda then can tell generators to search for test_unit generators when
    # some of them are not available by adding a fallback:
    #
    #   Rails::Generators.fallbacks[:shoulda] = :test_unit
    #
    # source://railties//lib/rails/generators.rb#105
    def fallbacks; end

    # Rails finds namespaces similar to Thor, it only adds one rule:
    #
    # Generators names must end with "_generator.rb". This is required because Rails
    # looks in load paths and loads the generator just before it's going to be used.
    #
    #   find_by_namespace :webrat, :rails, :integration
    #
    # Will search for the following generators:
    #
    #   "rails:webrat", "webrat:integration", "webrat"
    #
    # Notice that "rails:generators:webrat" could be loaded as well, what
    # Rails looks for is the first and last parts of the namespace.
    #
    # source://railties//lib/rails/generators.rb#230
    def find_by_namespace(name, base = T.unsafe(nil), context = T.unsafe(nil)); end

    # Show help message with available generators.
    #
    # source://railties//lib/rails/generators.rb#166
    def help(command = T.unsafe(nil)); end

    # Returns an array of generator namespaces that are hidden.
    # Generator namespaces may be hidden for a variety of reasons.
    # Some are aliased such as "rails:migration" and can be
    # invoked with the shorter "migration".
    #
    # source://railties//lib/rails/generators.rb#131
    def hidden_namespaces; end

    # source://railties//lib/rails/generators.rb#160
    def hide_namespace(*namespaces); end

    # source://railties//lib/rails/generators.rb#160
    def hide_namespaces(*namespaces); end

    # Receives a namespace, arguments, and the behavior to invoke the generator.
    # It's used as the default entry point for generate, destroy, and update
    # commands.
    #
    # source://railties//lib/rails/generators.rb#257
    def invoke(namespace, args = T.unsafe(nil), config = T.unsafe(nil)); end

    # source://railties//lib/rails/generators.rb#28
    def namespace; end

    # source://railties//lib/rails/generators.rb#28
    def namespace=(val); end

    # source://railties//lib/rails/generators.rb#85
    def options; end

    # source://railties//lib/rails/generators.rb#188
    def print_generators; end

    # source://railties//lib/rails/generators.rb#183
    def public_namespaces; end

    # source://railties//lib/rails/generators.rb#192
    def sorted_groups; end

    # source://railties//lib/rails/generators.rb#77
    def templates_path; end

    private

    # source://railties//lib/rails/generators.rb#301
    def command_type; end

    # source://railties//lib/rails/generators.rb#309
    def file_lookup_paths; end

    # Try fallbacks for the given base.
    #
    # source://railties//lib/rails/generators.rb#286
    def invoke_fallbacks_for(name, base); end

    # source://railties//lib/rails/generators.rb#305
    def lookup_paths; end

    # source://railties//lib/rails/generators.rb#280
    def print_list(base, namespaces); end

    # source://railties//lib/rails/generators.rb#313
    def run_after_generate_callback; end
  end
end

# source://railties//lib/rails/generators/actions.rb#9
module Rails::Generators::Actions
  # source://railties//lib/rails/generators/actions.rb#10
  def initialize(*_arg0); end

  # Add the given source to +Gemfile+
  #
  # If block is given, gem entries in block are wrapped into the source group.
  #
  #   add_source "http://gems.github.com/"
  #
  #   add_source "http://gems.github.com/" do
  #     gem "rspec-rails"
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#151
  def add_source(source, options = T.unsafe(nil), &block); end

  # Adds configuration code to a \Rails runtime environment.
  #
  # By default, adds code inside the +Application+ class in
  # +config/application.rb+ so that it applies to all environments.
  #
  #   environment %(config.asset_host = "cdn.provider.com")
  #
  # Results in:
  #
  #   # config/application.rb
  #   class Application < Rails::Application
  #     config.asset_host = "cdn.provider.com"
  #     # ...
  #   end
  #
  # If the +:env+ option is specified, the code will be added to the
  # corresponding file in +config/environments+ instead.
  #
  #   environment %(config.asset_host = "localhost:3000"), env: "development"
  #
  # Results in:
  #
  #   # config/environments/development.rb
  #   Rails.application.configure do
  #     config.asset_host = "localhost:3000"
  #     # ...
  #   end
  #
  # +:env+ can also be an array. In which case, the code is added to each
  # corresponding file in +config/environments+.
  #
  # The code can also be specified as the return value of the block:
  #
  #   environment do
  #     %(config.asset_host = "cdn.provider.com")
  #   end
  #
  #   environment(nil, env: "development") do
  #     %(config.asset_host = "localhost:3000")
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#206
  def application(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds configuration code to a \Rails runtime environment.
  #
  # By default, adds code inside the +Application+ class in
  # +config/application.rb+ so that it applies to all environments.
  #
  #   environment %(config.asset_host = "cdn.provider.com")
  #
  # Results in:
  #
  #   # config/application.rb
  #   class Application < Rails::Application
  #     config.asset_host = "cdn.provider.com"
  #     # ...
  #   end
  #
  # If the +:env+ option is specified, the code will be added to the
  # corresponding file in +config/environments+ instead.
  #
  #   environment %(config.asset_host = "localhost:3000"), env: "development"
  #
  # Results in:
  #
  #   # config/environments/development.rb
  #   Rails.application.configure do
  #     config.asset_host = "localhost:3000"
  #     # ...
  #   end
  #
  # +:env+ can also be an array. In which case, the code is added to each
  # corresponding file in +config/environments+.
  #
  # The code can also be specified as the return value of the block:
  #
  #   environment do
  #     %(config.asset_host = "cdn.provider.com")
  #   end
  #
  #   environment(nil, env: "development") do
  #     %(config.asset_host = "localhost:3000")
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#206
  def environment(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Adds a +gem+ declaration to the +Gemfile+ for the specified gem.
  #
  #   gem "rspec", group: :test
  #   gem "technoweenie-restful-authentication", lib: "restful-authentication", source: "http://gems.github.com/"
  #   gem "rails", "3.0", git: "https://github.com/rails/rails"
  #   gem "RedCloth", ">= 4.1.0", "< 4.2.0"
  #   gem "rspec", comment: "Put this comment above the gem declaration"
  #
  # Note that this method only adds the gem to the +Gemfile+; it does not
  # install the gem.
  #
  # ==== Options
  #
  # [+:version+]
  #   The version constraints for the gem, specified as a string or an
  #   array of strings:
  #
  #     gem "my_gem", version: "~> 1.1"
  #     gem "my_gem", version: [">= 1.1", "< 2.0"]
  #
  #   Alternatively, can be specified as one or more arguments following the
  #   gem name:
  #
  #     gem "my_gem", ">= 1.1", "< 2.0"
  #
  # [+:comment+]
  #   Outputs a comment above the +gem+ declaration in the +Gemfile+.
  #
  #     gem "my_gem", comment: "First line.\nSecond line."
  #
  #   Outputs:
  #
  #     # First line.
  #     # Second line.
  #     gem "my_gem"
  #
  # [+:group+]
  #   The gem group in the +Gemfile+ that the gem belongs to.
  #
  # [+:git+]
  #   The URL of the git repository for the gem.
  #
  # Any additional options passed to this method will be appended to the
  # +gem+ declaration in the +Gemfile+. For example:
  #
  #   gem "my_gem", comment: "Edge my_gem", git: "https://example.com/my_gem.git", branch: "master"
  #
  # Outputs:
  #
  #   # Edge my_gem
  #   gem "my_gem", git: "https://example.com/my_gem.git", branch: "master"
  #
  # source://railties//lib/rails/generators/actions.rb#67
  def gem(*args); end

  # Wraps gem entries inside a group.
  #
  #   gem_group :development, :test do
  #     gem "rspec-rails"
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#111
  def gem_group(*names, &block); end

  # Runs another generator.
  #
  #   generate "scaffold", "Post title:string body:text"
  #   generate "scaffold", "Post", "title:string", "body:text"
  #
  # The first argument is the generator name, and the remaining arguments
  # are joined together and passed to the generator.
  #
  # source://railties//lib/rails/generators/actions.rb#332
  def generate(what, *args); end

  # Runs one or more git commands.
  #
  #   git :init
  #   # => runs `git init`
  #
  #   git add: "this.file that.rb"
  #   # => runs `git add this.file that.rb`
  #
  #   git commit: "-m 'First commit'"
  #   # => runs `git commit -m 'First commit'`
  #
  #   git add: "good.rb", rm: "bad.cxx"
  #   # => runs `git add good.rb; git rm bad.cxx`
  #
  # source://railties//lib/rails/generators/actions.rb#237
  def git(commands = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/actions.rb#125
  def github(repo, options = T.unsafe(nil), &block); end

  # Creates an initializer file in +config/initializers/+. The code can be
  # specified as an argument or as the return value of the block.
  #
  #   initializer "api.rb", <<~RUBY
  #     API_KEY = "123456"
  #   RUBY
  #
  #   initializer "api.rb" do
  #     %(API_KEY = "123456")
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#319
  def initializer(filename, data = T.unsafe(nil)); end

  # Creates a file in +lib/+. The contents can be specified as an argument
  # or as the return value of the block.
  #
  #   lib "foreign.rb", <<~RUBY
  #     # Foreign code is fun
  #   RUBY
  #
  #   lib "foreign.rb" do
  #     "# Foreign code is fun"
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#275
  def lib(filename, data = T.unsafe(nil)); end

  # Runs the specified \Rails command.
  #
  #   rails_command "db:migrate"
  #   rails_command "db:migrate", env: "production"
  #   rails_command "db:migrate", abort_on_failure: true
  #   rails_command "stats", capture: true
  #   rails_command "gems:install", sudo: true
  #
  # ==== Options
  #
  # [+:env+]
  #   The \Rails environment in which to run the command. Defaults to
  #   <tt>ENV["RAILS_ENV"] || "development"</tt>.
  #
  # [+:abort_on_failure+]
  #   Whether to halt the generator if the command exits with a non-success
  #   exit status.
  #
  # [+:capture+]
  #   Whether to capture and return the output of the command.
  #
  # [+:sudo+]
  #   Whether to run the command using +sudo+.
  #
  # source://railties//lib/rails/generators/actions.rb#391
  def rails_command(command, options = T.unsafe(nil)); end

  # Runs the specified Rake task.
  #
  #   rake "db:migrate"
  #   rake "db:migrate", env: "production"
  #   rake "db:migrate", abort_on_failure: true
  #   rake "stats", capture: true
  #   rake "gems:install", sudo: true
  #
  # ==== Options
  #
  # [+:env+]
  #   The \Rails environment in which to run the task. Defaults to
  #   <tt>ENV["RAILS_ENV"] || "development"</tt>.
  #
  # [+:abort_on_failure+]
  #   Whether to halt the generator if the task exits with a non-success
  #   exit status.
  #
  # [+:capture+]
  #   Whether to capture and return the output of the task.
  #
  # [+:sudo+]
  #   Whether to run the task using +sudo+.
  #
  # source://railties//lib/rails/generators/actions.rb#364
  def rake(command, options = T.unsafe(nil)); end

  # Creates a Rake tasks file in +lib/tasks/+. The code can be specified as
  # an argument or as the return value of the block.
  #
  #   rakefile "bootstrap.rake", <<~RUBY
  #     task :bootstrap do
  #       puts "Boots! Boots! Boots!"
  #     end
  #   RUBY
  #
  #   rakefile "bootstrap.rake" do
  #     project = ask("What is the UNIX name of your project?")
  #
  #     <<~RUBY
  #       namespace :#{project} do
  #         task :bootstrap do
  #           puts "Boots! Boots! Boots!"
  #         end
  #       end
  #     RUBY
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#302
  def rakefile(filename, data = T.unsafe(nil)); end

  # Reads the given file at the source root and prints it in the console.
  #
  #   readme "README"
  #
  # source://railties//lib/rails/generators/actions.rb#442
  def readme(path); end

  # Make an entry in \Rails routing file <tt>config/routes.rb</tt>
  #
  #   route "root 'welcome#index'"
  #   route "root 'admin#index'", namespace: :admin
  #
  # source://railties//lib/rails/generators/actions.rb#409
  def route(routing_code, namespace: T.unsafe(nil)); end

  # Creates a file in +vendor/+. The contents can be specified as an
  # argument or as the return value of the block.
  #
  #   vendor "foreign.rb", <<~RUBY
  #     # Foreign code is fun
  #   RUBY
  #
  #   vendor "foreign.rb" do
  #     "# Foreign code is fun"
  #   end
  #
  # source://railties//lib/rails/generators/actions.rb#258
  def vendor(filename, data = T.unsafe(nil)); end

  private

  # Append string to a file with a newline if necessary
  #
  # source://railties//lib/rails/generators/actions.rb#507
  def append_file_with_newline(path, str, options = T.unsafe(nil)); end

  # Runs the supplied command using either "rake ..." or "rails ..."
  # based on the executor parameter provided.
  #
  # source://railties//lib/rails/generators/actions.rb#461
  def execute_command(executor, command, options = T.unsafe(nil)); end

  # Indent the +Gemfile+ to the depth of @indentation
  #
  # source://railties//lib/rails/generators/actions.rb#494
  def indentation; end

  # Define log for backwards compatibility. If just one argument is sent,
  # invoke say, otherwise invoke say_status. Differently from say and
  # similarly to say_status, this method respects the quiet? option given.
  #
  # source://railties//lib/rails/generators/actions.rb#450
  def log(*args); end

  # source://railties//lib/rails/generators/actions.rb#513
  def match_file(path, pattern); end

  # Returns optimized string with indentation
  #
  # source://railties//lib/rails/generators/actions.rb#487
  def optimize_indentation(value, amount = T.unsafe(nil)); end

  # Always returns value in double quotes.
  #
  # source://railties//lib/rails/generators/actions.rb#475
  def quote(value); end

  # Returns optimized string with indentation
  #
  # source://railties//lib/rails/generators/actions.rb#487
  def rebase_indentation(value, amount = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/actions.rb#517
  def route_namespace_pattern(namespace); end

  # Manage +Gemfile+ indentation for a DSL action block
  #
  # source://railties//lib/rails/generators/actions.rb#499
  def with_indentation(&block); end
end

# source://railties//lib/rails/generators/actions/create_migration.rb#9
class Rails::Generators::Actions::CreateMigration < ::Thor::Actions::CreateFile
  # source://railties//lib/rails/generators/actions/create_migration.rb#41
  def existing_migration; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#41
  def exists?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/actions/create_migration.rb#18
  def identical?; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#22
  def invoke!; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#10
  def migration_dir; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#14
  def migration_file_name; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#37
  def relative_existing_migration; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#29
  def revoke!; end

  private

  # source://railties//lib/rails/generators/actions/create_migration.rb#48
  def on_conflict_behavior; end

  # source://railties//lib/rails/generators/actions/create_migration.rb#69
  def say_status(status, color, message = T.unsafe(nil)); end
end

# ActiveModel is a class to be implemented by each ORM to allow \Rails to
# generate customized controller code.
#
# The API has the same methods as ActiveRecord, but each method returns a
# string that matches the ORM API.
#
# For example:
#
#   ActiveRecord::Generators::ActiveModel.find(Foo, "params[:id]")
#   # => "Foo.find(params[:id])"
#
#   DataMapper::Generators::ActiveModel.find(Foo, "params[:id]")
#   # => "Foo.get(params[:id])"
#
# On initialization, the ActiveModel accepts the instance name that will
# receive the calls:
#
#   builder = ActiveRecord::Generators::ActiveModel.new "@foo"
#   builder.save # => "@foo.save"
#
# The only exception in ActiveModel for ActiveRecord is the use of self.build
# instead of self.new.
#
# source://railties//lib/rails/generators/active_model.rb#28
class Rails::Generators::ActiveModel
  # @return [ActiveModel] a new instance of ActiveModel
  #
  # source://railties//lib/rails/generators/active_model.rb#31
  def initialize(name); end

  # Used for:
  #
  # * DELETE +destroy+
  #
  # source://railties//lib/rails/generators/active_model.rb#89
  def destroy; end

  # Used for:
  #
  # * POST +create+
  # * PATCH / PUT +update+
  #
  # source://railties//lib/rails/generators/active_model.rb#82
  def errors; end

  # Returns the value of attribute name.
  #
  # source://railties//lib/rails/generators/active_model.rb#29
  def name; end

  # Used for:
  #
  # * POST +create+
  #
  # source://railties//lib/rails/generators/active_model.rb#67
  def save; end

  # Used for:
  #
  # * PATCH / PUT +update+
  #
  # source://railties//lib/rails/generators/active_model.rb#74
  def update(params = T.unsafe(nil)); end

  class << self
    # Used for:
    #
    # * GET +index+
    #
    # source://railties//lib/rails/generators/active_model.rb#38
    def all(klass); end

    # Used for:
    #
    # * GET +new+
    # * POST +create+
    #
    # source://railties//lib/rails/generators/active_model.rb#56
    def build(klass, params = T.unsafe(nil)); end

    # Used for:
    #
    # * GET +show+
    # * GET +edit+
    # * PATCH / PUT +update+
    # * DELETE +destroy+
    #
    # source://railties//lib/rails/generators/active_model.rb#48
    def find(klass, params = T.unsafe(nil)); end
  end
end

# source://railties//lib/rails/generators/app_base.rb#14
class Rails::Generators::AppBase < ::Rails::Generators::Base
  include ::Rails::Generators::AppName

  # @return [AppBase] a new instance of AppBase
  #
  # source://railties//lib/rails/generators/app_base.rb#137
  def initialize(positional_argv, option_argv, *_arg2); end

  # source://thor/1.3.2/lib/thor/base.rb#163
  def app_path; end

  # source://thor/1.3.2/lib/thor/base.rb#163
  def app_path=(_arg0); end

  # Returns the value of attribute rails_template.
  #
  # source://thor/1.3.2/lib/thor/base.rb#163
  def rails_template; end

  # Sets the attribute rails_template
  #
  # @param value the value to set the attribute rails_template to.
  #
  # source://thor/1.3.2/lib/thor/base.rb#163
  def rails_template=(_arg0); end

  # source://railties//lib/rails/generators/base.rb#401
  def shebang; end

  private

  # source://railties//lib/rails/generators/app_base.rb#724
  def add_bundler_platforms; end

  # source://railties//lib/rails/generators/app_base.rb#260
  def apply_rails_template; end

  # source://railties//lib/rails/generators/app_base.rb#289
  def asset_pipeline_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#166
  def build(meth, *args); end

  # source://railties//lib/rails/generators/app_base.rb#158
  def builder; end

  # source://railties//lib/rails/generators/app_base.rb#629
  def bundle_command(command, env = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#655
  def bundle_install?; end

  # source://railties//lib/rails/generators/app_base.rb#659
  def bundler_windows_platforms; end

  # source://railties//lib/rails/generators/app_base.rb#622
  def cable_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#336
  def comment_if(value); end

  # source://railties//lib/rails/generators/app_base.rb#253
  def create_root; end

  # source://railties//lib/rails/generators/app_base.rb#609
  def css_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#778
  def database; end

  # source://railties//lib/rails/generators/app_base.rb#277
  def database_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#170
  def deduce_implied_options(options, option_reasons, meta_options); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#667
  def depend_on_bootsnap?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#663
  def depends_on_system_test?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#413
  def devcontainer?; end

  # source://railties//lib/rails/generators/app_base.rb#574
  def dockerfile_base_packages; end

  # source://railties//lib/rails/generators/app_base.rb#545
  def dockerfile_binfile_fixups; end

  # source://railties//lib/rails/generators/app_base.rb#590
  def dockerfile_build_packages; end

  # source://railties//lib/rails/generators/app_base.rb#539
  def dockerfile_bun_version; end

  # source://railties//lib/rails/generators/app_base.rb#769
  def dockerfile_chown_directories; end

  # source://railties//lib/rails/generators/app_base.rb#533
  def dockerfile_yarn_version; end

  # source://railties//lib/rails/generators/app_base.rb#765
  def edge_branch; end

  # source://railties//lib/rails/generators/app_base.rb#740
  def empty_directory_with_keep_file(destination, config = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/app_base.rb#646
  def exec_bundle_command(bundle_command, command, env); end

  # source://railties//lib/rails/generators/app_base.rb#144
  def gemfile_entries; end

  # source://railties//lib/rails/generators/app_base.rb#734
  def generate_bundler_binstub; end

  # source://railties//lib/rails/generators/app_base.rb#753
  def git_init_command; end

  # source://railties//lib/rails/generators/app_base.rb#498
  def hotwire_gemfile_entry; end

  # ==== Options
  #
  # [+:meta_options+]
  #   A list of generator options which only serve to trigger other options.
  #   These options should have no other effects, and will be treated
  #   transparently when revoking other options.
  #
  #   For example: --minimal implies both --skip-active-job and
  #   --skip-active-storage. Also, --skip-active-job by itself implies
  #   --skip-active-storage. If --skip-active-job is explicitly
  #   specified, --no-skip-active-storage should raise an error. But, if
  #   only --minimal is specified, --no-skip-active-storage should "undo"
  #   the implied --skip-active-job. This can be accomplished by passing
  #   <tt>meta_options: [:minimal]</tt>.
  #
  #   In contrast, --api is not a meta option because it does other things
  #   besides implying options such as --skip-asset-pipeline. (And so --api
  #   with --no-skip-asset-pipeline should raise an error.)
  #
  # source://railties//lib/rails/generators/app_base.rb#223
  def imply_options(option_implications = T.unsafe(nil), meta_options: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#316
  def include_all_railties?; end

  # source://railties//lib/rails/generators/app_base.rb#488
  def javascript_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#483
  def jbuilder_gemfile_entry; end

  # source://railties//lib/rails/generators/app_base.rb#745
  def keep_file(destination); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#349
  def keeps?; end

  # source://railties//lib/rails/generators/app_base.rb#523
  def node_version; end

  # source://railties//lib/rails/generators/app_base.rb#457
  def rails_gemfile_entry; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#453
  def rails_prerelease?; end

  # source://railties//lib/rails/generators/app_base.rb#320
  def rails_require_statement; end

  # source://railties//lib/rails/generators/app_base.rb#470
  def rails_version_specifier(gem_version = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/app_base.rb#236
  def report_implied_options; end

  # source://railties//lib/rails/generators/app_base.rb#300
  def required_railties; end

  # source://railties//lib/rails/generators/app_base.rb#693
  def run_bundle; end

  # source://railties//lib/rails/generators/app_base.rb#712
  def run_css; end

  # source://railties//lib/rails/generators/app_base.rb#706
  def run_hotwire; end

  # source://railties//lib/rails/generators/app_base.rb#697
  def run_javascript; end

  # source://railties//lib/rails/generators/app_base.rb#266
  def set_default_accessors!; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#369
  def skip_action_cable?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#377
  def skip_action_mailbox?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#373
  def skip_action_mailer?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#381
  def skip_action_text?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#357
  def skip_active_record?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#361
  def skip_active_storage?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#385
  def skip_asset_pipeline?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#401
  def skip_brakeman?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#405
  def skip_ci?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#409
  def skip_devcontainer?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#393
  def skip_propshaft?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#397
  def skip_rubocop?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#389
  def skip_sprockets?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#365
  def skip_storage?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#353
  def sqlite3?; end

  # source://railties//lib/rails/generators/app_base.rb#671
  def target_rails_prerelease(self_command = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/app_base.rb#749
  def user_default_branch; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#519
  def using_bun?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#510
  def using_js_runtime?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_base.rb#515
  def using_node?; end

  # source://railties//lib/rails/generators/app_base.rb#285
  def web_server_gemfile_entry; end

  class << self
    # source://railties//lib/rails/generators/app_base.rb#33
    def add_shared_options_for(name); end

    # source://railties//lib/rails/generators/app_base.rb#133
    def edge_branch; end

    # source://railties//lib/rails/generators/app_base.rb#29
    def strict_args_position; end
  end
end

# source://railties//lib/rails/generators/app_base.rb#22
Rails::Generators::AppBase::ASSET_PIPELINE_OPTIONS = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/app_base.rb#18
Rails::Generators::AppBase::BUN_VERSION = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/generators/app_base.rb#21
Rails::Generators::AppBase::CSS_OPTIONS = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/app_base.rb#417
class Rails::Generators::AppBase::GemfileEntry < ::Struct
  # @return [GemfileEntry] a new instance of GemfileEntry
  #
  # source://railties//lib/rails/generators/app_base.rb#418
  def initialize(name, version, comment, options = T.unsafe(nil), commented_out = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/app_base.rb#442
  def to_s; end

  class << self
    # source://railties//lib/rails/generators/app_base.rb#434
    def floats(name, comment = T.unsafe(nil)); end

    # source://railties//lib/rails/generators/app_base.rb#422
    def github(name, github, branch = T.unsafe(nil), comment = T.unsafe(nil)); end

    # source://railties//lib/rails/generators/app_base.rb#438
    def path(name, path, comment = T.unsafe(nil)); end

    # source://railties//lib/rails/generators/app_base.rb#430
    def version(name, version, comment = T.unsafe(nil)); end
  end
end

# source://railties//lib/rails/generators/app_base.rb#20
Rails::Generators::AppBase::JAVASCRIPT_OPTIONS = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/app_base.rb#17
Rails::Generators::AppBase::NODE_LTS_VERSION = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/generators/app_base.rb#198
Rails::Generators::AppBase::OPTION_IMPLICATIONS = T.let(T.unsafe(nil), Hash)

# source://railties//lib/rails/generators/app_name.rb#5
module Rails::Generators::AppName
  private

  # source://railties//lib/rails/generators/app_name.rb#22
  def app_const; end

  # source://railties//lib/rails/generators/app_name.rb#17
  def app_const_base; end

  # source://railties//lib/rails/generators/app_name.rb#9
  def app_name; end

  # source://railties//lib/rails/generators/app_name.rb#17
  def camelized; end

  # source://railties//lib/rails/generators/app_name.rb#13
  def original_app_name; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/app_name.rb#26
  def valid_const?; end
end

# source://railties//lib/rails/generators/app_name.rb#6
Rails::Generators::AppName::RESERVED_NAMES = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/base.rb#17
class Rails::Generators::Base < ::Thor::Group
  include ::Thor::Actions
  include ::Rails::Generators::Actions
  extend ::Thor::Actions::ClassMethods

  private

  # Check whether the given class names are already taken by user
  # application or Ruby on Rails.
  #
  # source://railties//lib/rails/generators/base.rb#264
  def class_collisions(*class_names); end

  # Takes in an array of nested modules and extracts the last module
  #
  # source://railties//lib/rails/generators/base.rb#287
  def extract_last_module(nesting); end

  # source://railties//lib/rails/generators/base.rb#427
  def gem_ruby_version; end

  # source://railties//lib/rails/generators/base.rb#302
  def indent(content, multiplier = T.unsafe(nil)); end

  # Wrap block with namespace of current application
  # if namespace exists and is not skipped
  #
  # source://railties//lib/rails/generators/base.rb#296
  def module_namespacing(&block); end

  # source://railties//lib/rails/generators/base.rb#312
  def namespace; end

  # source://railties//lib/rails/generators/base.rb#320
  def namespace_dirs; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/base.rb#316
  def namespaced?; end

  # source://railties//lib/rails/generators/base.rb#324
  def namespaced_path; end

  # source://railties//lib/rails/generators/base.rb#307
  def wrap_with_namespace(content); end

  class << self
    # Small macro to add ruby as an option to the generator with proper
    # default value plus an instance helper method called shebang.
    #
    # source://railties//lib/rails/generators/base.rb#396
    def add_shebang_option!; end

    # Use \Rails default banner.
    #
    # source://railties//lib/rails/generators/base.rb#329
    def banner; end

    # Sets the base_name taking into account the current class namespace.
    #
    # source://railties//lib/rails/generators/base.rb#334
    def base_name; end

    # Returns the base root for a common set of generators. This is used to dynamically
    # guess the default source root.
    #
    # source://railties//lib/rails/generators/base.rb#236
    def base_root; end

    # Make class option aware of Rails::Generators.options and Rails::Generators.aliases.
    #
    # source://railties//lib/rails/generators/base.rb#217
    def class_option(name, options = T.unsafe(nil)); end

    # Returns default aliases for the option name given doing a lookup in
    # Rails::Generators.aliases.
    #
    # source://railties//lib/rails/generators/base.rb#357
    def default_aliases_for_option(name, options); end

    # Returns default for the option name given doing a lookup in config.
    #
    # source://railties//lib/rails/generators/base.rb#362
    def default_for_option(config, name, options, default); end

    # source://railties//lib/rails/generators/base.rb#422
    def default_generator_root; end

    # Returns the default source root for a given generator. This is used internally
    # by Rails to set its generators source root. If you want to customize your source
    # root, you should use source_root.
    #
    # source://railties//lib/rails/generators/base.rb#227
    def default_source_root; end

    # Returns the default value for the option name given doing a lookup in
    # Rails::Generators.options.
    #
    # source://railties//lib/rails/generators/base.rb#351
    def default_value_for_option(name, options); end

    # Tries to get the description from a USAGE file one folder above the source
    # root otherwise uses a default description.
    #
    # source://railties//lib/rails/generators/base.rb#41
    def desc(description = T.unsafe(nil)); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/generators/base.rb#29
    def exit_on_failure?; end

    # Removes the namespaces and get the generator name. For example,
    # Rails::Generators::ModelGenerator will return "model" as generator name.
    #
    # source://railties//lib/rails/generators/base.rb#342
    def generator_name; end

    # Convenience method to hide this generator from the available ones when
    # running rails generator command.
    #
    # source://railties//lib/rails/generators/base.rb#61
    def hide!; end

    # Invoke a generator based on the value supplied by the user to the
    # given option named "name". A class option is created when this method
    # is invoked and you can set a hash to customize it.
    #
    # ==== Examples
    #
    #   module Rails::Generators
    #     class ControllerGenerator < Base
    #       hook_for :test_framework, aliases: "-t"
    #     end
    #   end
    #
    # The example above will create a test framework option and will invoke
    # a generator based on the user supplied value.
    #
    # For example, if the user invoke the controller generator as:
    #
    #   $ bin/rails generate controller Account --test-framework=test_unit
    #
    # The controller generator will then try to invoke the following generators:
    #
    #   "rails:test_unit", "test_unit:controller", "test_unit"
    #
    # Notice that "rails:generators:test_unit" could be loaded as well, what
    # \Rails looks for is the first and last parts of the namespace. This is what
    # allows any test framework to hook into \Rails as long as it provides any
    # of the hooks above.
    #
    # ==== Options
    #
    # The first and last part used to find the generator to be invoked are
    # guessed based on class invokes hook_for, as noticed in the example above.
    # This can be customized with two options: +:in+ and +:as+.
    #
    # Let's suppose you are creating a generator that needs to invoke the
    # controller generator from test unit. Your first attempt is:
    #
    #   class AwesomeGenerator < Rails::Generators::Base
    #     hook_for :test_framework
    #   end
    #
    # The lookup in this case for test_unit as input is:
    #
    #   "test_unit:awesome", "test_unit"
    #
    # Which is not the desired lookup. You can change it by providing the
    # +:as+ option:
    #
    #   class AwesomeGenerator < Rails::Generators::Base
    #     hook_for :test_framework, as: :controller
    #   end
    #
    # And now it will look up at:
    #
    #   "test_unit:controller", "test_unit"
    #
    # Similarly, if you want it to also look up in the rails namespace, you
    # just need to provide the +:in+ value:
    #
    #   class AwesomeGenerator < Rails::Generators::Base
    #     hook_for :test_framework, in: :rails, as: :controller
    #   end
    #
    # And the lookup is exactly the same as previously:
    #
    #   "rails:test_unit", "test_unit:controller", "test_unit"
    #
    # ==== Switches
    #
    # All hooks come with switches for user interface. If you do not want
    # to use any test framework, you can do:
    #
    #   $ bin/rails generate controller Account --skip-test-framework
    #
    # Or similarly:
    #
    #   $ bin/rails generate controller Account --no-test-framework
    #
    # ==== Boolean hooks
    #
    # In some cases, you may want to provide a boolean hook. For example, webrat
    # developers might want to have webrat available on controller generator.
    # This can be achieved as:
    #
    #   Rails::Generators::ControllerGenerator.hook_for :webrat, type: :boolean
    #
    # Then, if you want webrat to be invoked, just supply:
    #
    #   $ bin/rails generate controller Account --webrat
    #
    # The hooks lookup is similar as above:
    #
    #   "rails:generators:webrat", "webrat:generators:controller", "webrat"
    #
    # ==== Custom invocations
    #
    # You can also supply a block to hook_for to customize how the hook is
    # going to be invoked. The block receives two arguments, an instance
    # of the current class and the class to be invoked.
    #
    # For example, in the resource generator, the controller should be invoked
    # with a pluralized class name. But by default it is invoked with the same
    # name as the resource generator, which is singular. To change this, we
    # can give a block to customize how the controller can be invoked.
    #
    #   hook_for :resource_controller do |instance, controller|
    #     instance.invoke controller, [ instance.name.pluralize ]
    #   end
    #
    # source://railties//lib/rails/generators/base.rb#174
    def hook_for(*names, &block); end

    # Keep hooks configuration that are used on prepare_for_invocation.
    #
    # source://railties//lib/rails/generators/base.rb#375
    def hooks; end

    # Cache source root and add lib/generators/base/generator/templates to
    # source paths.
    #
    # source://railties//lib/rails/generators/base.rb#242
    def inherited(base); end

    # Convenience method to get the namespace from the class name. It's the
    # same as Thor default except that the Generator at the end of the class
    # is removed.
    #
    # source://railties//lib/rails/generators/base.rb#54
    def namespace(name = T.unsafe(nil)); end

    # Prepare class invocation to search on Rails namespace if a previous
    # added hook is being used.
    #
    # source://railties//lib/rails/generators/base.rb#381
    def prepare_for_invocation(name, value); end

    # Remove a previously added hook.
    #
    #   remove_hook_for :orm
    #
    # source://railties//lib/rails/generators/base.rb#207
    def remove_hook_for(*names); end

    # Returns the source root for this generator using default_source_root as default.
    #
    # source://railties//lib/rails/generators/base.rb#34
    def source_root(path = T.unsafe(nil)); end

    # source://railties//lib/rails/generators/base.rb#414
    def usage_path; end
  end
end

# source://railties//lib/rails/generators.rb#30
Rails::Generators::DEFAULT_ALIASES = T.let(T.unsafe(nil), Hash)

# source://railties//lib/rails/generators.rb#47
Rails::Generators::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://railties//lib/rails/generators/database.rb#5
class Rails::Generators::Database
  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#49
  def base_package; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#53
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#60
  def feature; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#41
  def feature_name; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#45
  def gem; end

  # source://railties//lib/rails/generators/database.rb#58
  def host; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#29
  def name; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#37
  def port; end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/database.rb#33
  def service; end

  # source://railties//lib/rails/generators/database.rb#57
  def socket; end

  # source://railties//lib/rails/generators/database.rb#66
  def volume; end

  class << self
    # source://railties//lib/rails/generators/database.rb#19
    def all; end

    # source://railties//lib/rails/generators/database.rb#9
    def build(database_name); end
  end
end

# source://railties//lib/rails/generators/database.rb#6
Rails::Generators::Database::DATABASES = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/database.rb#172
class Rails::Generators::Database::MariaDB < ::Rails::Generators::Database
  include ::Rails::Generators::Database::MySqlSocket

  # source://railties//lib/rails/generators/database.rb#199
  def base_package; end

  # source://railties//lib/rails/generators/database.rb#203
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#207
  def feature_name; end

  # source://railties//lib/rails/generators/database.rb#195
  def gem; end

  # source://railties//lib/rails/generators/database.rb#175
  def name; end

  # source://railties//lib/rails/generators/database.rb#191
  def port; end

  # source://railties//lib/rails/generators/database.rb#179
  def service; end
end

# source://railties//lib/rails/generators/database.rb#92
class Rails::Generators::Database::MySQL < ::Rails::Generators::Database
  include ::Rails::Generators::Database::MySqlSocket

  # source://railties//lib/rails/generators/database.rb#120
  def base_package; end

  # source://railties//lib/rails/generators/database.rb#124
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#128
  def feature_name; end

  # source://railties//lib/rails/generators/database.rb#116
  def gem; end

  # source://railties//lib/rails/generators/database.rb#95
  def name; end

  # source://railties//lib/rails/generators/database.rb#112
  def port; end

  # source://railties//lib/rails/generators/database.rb#99
  def service; end
end

# source://railties//lib/rails/generators/database.rb#72
module Rails::Generators::Database::MySqlSocket
  # source://railties//lib/rails/generators/database.rb#87
  def host; end

  # source://railties//lib/rails/generators/database.rb#73
  def socket; end
end

# source://railties//lib/rails/generators/database.rb#242
class Rails::Generators::Database::Null < ::Rails::Generators::Database
  # source://railties//lib/rails/generators/database.rb#247
  def base_package; end

  # source://railties//lib/rails/generators/database.rb#248
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#249
  def feature_name; end

  # source://railties//lib/rails/generators/database.rb#243
  def name; end

  # source://railties//lib/rails/generators/database.rb#245
  def port; end

  # source://railties//lib/rails/generators/database.rb#244
  def service; end

  # source://railties//lib/rails/generators/database.rb#246
  def volume; end
end

# source://railties//lib/rails/generators/database.rb#133
class Rails::Generators::Database::PostgreSQL < ::Rails::Generators::Database
  # source://railties//lib/rails/generators/database.rb#159
  def base_package; end

  # source://railties//lib/rails/generators/database.rb#163
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#167
  def feature_name; end

  # source://railties//lib/rails/generators/database.rb#155
  def gem; end

  # source://railties//lib/rails/generators/database.rb#134
  def name; end

  # source://railties//lib/rails/generators/database.rb#151
  def port; end

  # source://railties//lib/rails/generators/database.rb#138
  def service; end
end

# source://railties//lib/rails/generators/database.rb#212
class Rails::Generators::Database::SQLite3 < ::Rails::Generators::Database
  # source://railties//lib/rails/generators/database.rb#229
  def base_package; end

  # source://railties//lib/rails/generators/database.rb#233
  def build_package; end

  # source://railties//lib/rails/generators/database.rb#237
  def feature_name; end

  # source://railties//lib/rails/generators/database.rb#225
  def gem; end

  # source://railties//lib/rails/generators/database.rb#213
  def name; end

  # source://railties//lib/rails/generators/database.rb#221
  def port; end

  # source://railties//lib/rails/generators/database.rb#217
  def service; end
end

# source://railties//lib/rails/generators/base.rb#14
class Rails::Generators::Error < ::Thor::Error; end

# source://railties//lib/rails/generators/generated_attribute.rb#7
class Rails::Generators::GeneratedAttribute
  # @return [GeneratedAttribute] a new instance of GeneratedAttribute
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#109
  def initialize(name, type = T.unsafe(nil), index_type = T.unsafe(nil), attr_options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#211
  def attachment?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#215
  def attachments?; end

  # Returns the value of attribute attr_options.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#31
  def attr_options; end

  # source://railties//lib/rails/generators/generated_attribute.rb#171
  def column_name; end

  # source://railties//lib/rails/generators/generated_attribute.rb#133
  def default; end

  # source://railties//lib/rails/generators/generated_attribute.rb#117
  def field_type; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#175
  def foreign_key?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#191
  def has_index?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#195
  def has_uniq_index?; end

  # source://railties//lib/rails/generators/generated_attribute.rb#159
  def human_name; end

  # source://railties//lib/rails/generators/generated_attribute.rb#163
  def index_name; end

  # Sets the attribute index_name
  #
  # @param value the value to set the attribute index_name to.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#32
  def index_name=(_arg0); end

  # source://railties//lib/rails/generators/generated_attribute.rb#227
  def inject_index_options; end

  # source://railties//lib/rails/generators/generated_attribute.rb#223
  def inject_options; end

  # Returns the value of attribute name.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#30
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#30
  def name=(_arg0); end

  # source://railties//lib/rails/generators/generated_attribute.rb#231
  def options_for_migration; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#199
  def password_digest?; end

  # source://railties//lib/rails/generators/generated_attribute.rb#151
  def plural_name; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#183
  def polymorphic?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#179
  def reference?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#187
  def required?; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#207
  def rich_text?; end

  # source://railties//lib/rails/generators/generated_attribute.rb#155
  def singular_name; end

  # source://railties//lib/rails/generators/generated_attribute.rb#243
  def to_s; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#203
  def token?; end

  # Returns the value of attribute type.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#30
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#30
  def type=(_arg0); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/generated_attribute.rb#219
  def virtual?; end

  private

  # source://railties//lib/rails/generators/generated_attribute.rb#254
  def print_attribute_options; end

  class << self
    # @return [Boolean]
    #
    # source://railties//lib/rails/generators/generated_attribute.rb#67
    def dangerous_name?(name); end

    # source://railties//lib/rails/generators/generated_attribute.rb#35
    def parse(column_definition); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/generators/generated_attribute.rb#82
    def reference?(type); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/generators/generated_attribute.rb#78
    def valid_index_type?(index_type); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/generators/generated_attribute.rb#72
    def valid_type?(type); end

    private

    # parse possible attribute options like :limit for string/text/binary/integer, :precision/:scale for decimals or :polymorphic for references/belongs_to
    # when declaring options curly brackets should be used
    #
    # source://railties//lib/rails/generators/generated_attribute.rb#89
    def parse_type_and_options(type); end
  end
end

# source://railties//lib/rails/generators/generated_attribute.rb#10
Rails::Generators::GeneratedAttribute::DEFAULT_TYPES = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/generated_attribute.rb#8
Rails::Generators::GeneratedAttribute::INDEX_OPTIONS = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/generators/generated_attribute.rb#9
Rails::Generators::GeneratedAttribute::UNIQ_INDEX_OPTIONS = T.let(T.unsafe(nil), Array)

# Holds common methods for migrations. It assumes that migrations have the
# [0-9]*_name format and can be used by other frameworks (like Sequel)
# just by implementing the +next_migration_number+ method.
#
# source://railties//lib/rails/generators/migration.rb#11
module Rails::Generators::Migration
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::Rails::Generators::Migration::ClassMethods

  # source://railties//lib/rails/generators/migration.rb#35
  def create_migration(destination, data, config = T.unsafe(nil), &block); end

  # Returns the value of attribute migration_class_name.
  #
  # source://railties//lib/rails/generators/migration.rb#13
  def migration_class_name; end

  # Returns the value of attribute migration_file_name.
  #
  # source://railties//lib/rails/generators/migration.rb#13
  def migration_file_name; end

  # Returns the value of attribute migration_number.
  #
  # source://railties//lib/rails/generators/migration.rb#13
  def migration_number; end

  # Creates a migration template at the given destination. The difference
  # to the default template method is that the migration number is prepended
  # to the destination file name.
  #
  # The migration number, migration file name, migration class name are
  # available as instance variables in the template to be rendered.
  #
  #   migration_template "migration.rb", "db/migrate/add_foo_to_bar.rb"
  #
  # source://railties//lib/rails/generators/migration.rb#56
  def migration_template(source, destination, config = T.unsafe(nil)); end

  # source://railties//lib/rails/generators/migration.rb#39
  def set_migration_assigns!(destination); end
end

# source://railties//lib/rails/generators/migration.rb#15
module Rails::Generators::Migration::ClassMethods
  # source://railties//lib/rails/generators/migration.rb#24
  def current_migration_number(dirname); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/migration.rb#20
  def migration_exists?(dirname, file_name); end

  # source://railties//lib/rails/generators/migration.rb#16
  def migration_lookup_at(dirname); end

  # @raise [NotImplementedError]
  #
  # source://railties//lib/rails/generators/migration.rb#30
  def next_migration_number(dirname); end
end

# source://railties//lib/rails/generators/model_helpers.rb#7
module Rails::Generators::ModelHelpers
  # source://railties//lib/rails/generators/model_helpers.rb#26
  def initialize(args, *_options); end

  # source://railties//lib/rails/generators/model_helpers.rb#19
  def skip_warn; end

  # source://railties//lib/rails/generators/model_helpers.rb#19
  def skip_warn=(val); end

  private

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/model_helpers.rb#56
  def inflection_impossible?(name); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/model_helpers.rb#52
  def irregular_model_name?(name); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/model_helpers.rb#48
  def plural_model_name?(name); end

  class << self
    # source://railties//lib/rails/generators/model_helpers.rb#21
    def included(base); end

    # source://railties//lib/rails/generators/model_helpers.rb#19
    def skip_warn; end

    # source://railties//lib/rails/generators/model_helpers.rb#19
    def skip_warn=(val); end
  end
end

# source://railties//lib/rails/generators/model_helpers.rb#14
Rails::Generators::ModelHelpers::INFLECTION_IMPOSSIBLE_ERROR_MESSAGE = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/generators/model_helpers.rb#10
Rails::Generators::ModelHelpers::IRREGULAR_MODEL_NAME_WARN_MESSAGE = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/generators/model_helpers.rb#8
Rails::Generators::ModelHelpers::PLURAL_MODEL_NAME_WARN_MESSAGE = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/generators/named_base.rb#8
class Rails::Generators::NamedBase < ::Rails::Generators::Base
  # @return [NamedBase] a new instance of NamedBase
  #
  # source://railties//lib/rails/generators/named_base.rb#11
  def initialize(args, *options); end

  # Returns the value of attribute file_name.
  #
  # source://thor/1.3.2/lib/thor/base.rb#155
  def file_name; end

  # source://railties//lib/rails/generators/named_base.rb#29
  def js_template(source, destination); end

  # source://thor/1.3.2/lib/thor/base.rb#163
  def name; end

  # source://thor/1.3.2/lib/thor/base.rb#163
  def name=(_arg0); end

  # source://railties//lib/rails/generators/named_base.rb#23
  def template(source, *args, &block); end

  private

  # Tries to retrieve the application name or simply return application.
  #
  # source://railties//lib/rails/generators/named_base.rb#138
  def application_name; end

  # source://railties//lib/rails/generators/named_base.rb#175
  def assign_names!(name); end

  # source://railties//lib/rails/generators/named_base.rb#188
  def attributes_names; end

  # source://railties//lib/rails/generators/named_base.rb#70
  def class_name; end

  # source://railties//lib/rails/generators/named_base.rb#58
  def class_path; end

  # source://railties//lib/rails/generators/named_base.rb#105
  def edit_helper(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/generators/named_base.rb#54
  def file_path; end

  # source://railties//lib/rails/generators/named_base.rb#125
  def fixture_file_name; end

  # source://railties//lib/rails/generators/named_base.rb#74
  def human_name; end

  # source://railties//lib/rails/generators/named_base.rb#82
  def i18n_scope; end

  # source://railties//lib/rails/generators/named_base.rb#97
  def index_helper(type: T.unsafe(nil)); end

  # source://railties//lib/rails/generators/named_base.rb#43
  def inside_template; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/named_base.rb#50
  def inside_template?; end

  # source://railties//lib/rails/generators/named_base.rb#150
  def model_resource_name(base_name = T.unsafe(nil), prefix: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/named_base.rb#200
  def mountable_engine?; end

  # source://railties//lib/rails/generators/named_base.rb#66
  def namespaced_class_path; end

  # source://railties//lib/rails/generators/named_base.rb#109
  def new_helper(type: T.unsafe(nil)); end

  # Convert attributes array into GeneratedAttribute objects.
  #
  # source://railties//lib/rails/generators/named_base.rb#182
  def parse_attributes!; end

  # source://railties//lib/rails/generators/named_base.rb#121
  def plural_file_name; end

  # source://railties//lib/rails/generators/named_base.rb#78
  def plural_name; end

  # source://railties//lib/rails/generators/named_base.rb#167
  def plural_route_name; end

  # source://railties//lib/rails/generators/named_base.rb#117
  def plural_table_name; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/named_base.rb#196
  def pluralize_table_names?; end

  # source://railties//lib/rails/generators/named_base.rb#146
  def redirect_resource_name; end

  # source://railties//lib/rails/generators/named_base.rb#62
  def regular_class_path; end

  # source://railties//lib/rails/generators/named_base.rb#129
  def route_url; end

  # source://railties//lib/rails/generators/named_base.rb#101
  def show_helper(arg = T.unsafe(nil), type: T.unsafe(nil)); end

  # FIXME: We are avoiding to use alias because a bug on thor that make
  # this method public and add it to the task list.
  #
  # source://railties//lib/rails/generators/named_base.rb#39
  def singular_name; end

  # source://railties//lib/rails/generators/named_base.rb#159
  def singular_route_name; end

  # source://railties//lib/rails/generators/named_base.rb#113
  def singular_table_name; end

  # source://railties//lib/rails/generators/named_base.rb#86
  def table_name; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/named_base.rb#93
  def uncountable?; end

  # source://railties//lib/rails/generators/named_base.rb#133
  def url_helper_prefix; end

  class << self
    # Add a class collisions name to be checked on class initialization. You
    # can supply a hash with a +:prefix+ or +:suffix+ to be tested.
    #
    # ==== Examples
    #
    #   check_class_collision suffix: "Decorator"
    #
    # If the generator is invoked with class name Admin, it will check for
    # the presence of "AdminDecorator".
    #
    # source://railties//lib/rails/generators/named_base.rb#214
    def check_class_collision(options = T.unsafe(nil)); end
  end
end

# Deal with controller names on scaffold and add some helpers to deal with
# ActiveModel.
#
# source://railties//lib/rails/generators/resource_helpers.rb#10
module Rails::Generators::ResourceHelpers
  include ::Rails::Generators::ModelHelpers

  # Set controller variables on initialization.
  #
  # source://railties//lib/rails/generators/resource_helpers.rb#17
  def initialize(*args); end

  private

  # source://railties//lib/rails/generators/resource_helpers.rb#39
  def assign_controller_names!(name); end

  # source://railties//lib/rails/generators/resource_helpers.rb#50
  def controller_class_name; end

  # source://railties//lib/rails/generators/resource_helpers.rb#31
  def controller_class_path; end

  # Returns the value of attribute controller_file_name.
  #
  # source://railties//lib/rails/generators/resource_helpers.rb#29
  def controller_file_name; end

  # source://railties//lib/rails/generators/resource_helpers.rb#46
  def controller_file_path; end

  # source://railties//lib/rails/generators/resource_helpers.rb#54
  def controller_i18n_scope; end

  # Returns the value of attribute controller_name.
  #
  # source://railties//lib/rails/generators/resource_helpers.rb#29
  def controller_name; end

  # Loads the ORM::Generators::ActiveModel class. This class is responsible
  # to tell scaffold entities how to generate a specific method for the
  # ORM. Check Rails::Generators::ActiveModel for more information.
  #
  # source://railties//lib/rails/generators/resource_helpers.rb#61
  def orm_class; end

  # Initialize ORM::Generators::ActiveModel to access instance methods.
  #
  # source://railties//lib/rails/generators/resource_helpers.rb#77
  def orm_instance(name = T.unsafe(nil)); end

  class << self
    # source://railties//lib/rails/generators/resource_helpers.rb#11
    def included(base); end
  end
end

# This class provides a TestCase for testing generators. To set up, you need
# just to configure the destination and set which generator is being tested:
#
#   class AppGeneratorTest < Rails::Generators::TestCase
#     tests AppGenerator
#     destination File.expand_path("../tmp", __dir__)
#   end
#
# If you want to ensure your destination root is clean before running each test,
# you can set a setup callback:
#
#   class AppGeneratorTest < Rails::Generators::TestCase
#     tests AppGenerator
#     destination File.expand_path("../tmp", __dir__)
#     setup :prepare_destination
#   end
#
# source://railties//lib/rails/generators/test_case.rb#30
class Rails::Generators::TestCase < ::ActiveSupport::TestCase
  include ::ActiveSupport::Testing::Stream
  include ::Rails::Generators::Testing::Behavior
  include ::Rails::Generators::Testing::SetupAndTeardown
  include ::Rails::Generators::Testing::Assertions
  include ::FileUtils::StreamUtils_
  include ::FileUtils
  extend ::Rails::Generators::Testing::Behavior::ClassMethods

  # source://railties//lib/rails/generators/testing/behavior.rb#21
  def current_path; end

  # source://railties//lib/rails/generators/testing/behavior.rb#21
  def current_path=(_arg0); end

  # source://railties//lib/rails/generators/testing/behavior.rb#21
  def current_path?; end

  # source://railties//lib/rails/generators/testing/behavior.rb#22
  def default_arguments; end

  # source://railties//lib/rails/generators/testing/behavior.rb#22
  def default_arguments=(_arg0); end

  # source://railties//lib/rails/generators/testing/behavior.rb#22
  def default_arguments?; end

  # source://railties//lib/rails/generators/testing/behavior.rb#23
  def destination_root; end

  # source://railties//lib/rails/generators/testing/behavior.rb#23
  def destination_root=(_arg0); end

  # source://railties//lib/rails/generators/testing/behavior.rb#23
  def destination_root?; end

  # source://railties//lib/rails/generators/testing/behavior.rb#24
  def generator_class; end

  # source://railties//lib/rails/generators/testing/behavior.rb#24
  def generator_class=(_arg0); end

  # source://railties//lib/rails/generators/testing/behavior.rb#24
  def generator_class?; end

  class << self
    # source://railties//lib/rails/generators/testing/behavior.rb#21
    def current_path; end

    # source://railties//lib/rails/generators/testing/behavior.rb#21
    def current_path=(value); end

    # source://railties//lib/rails/generators/testing/behavior.rb#21
    def current_path?; end

    # source://railties//lib/rails/generators/testing/behavior.rb#22
    def default_arguments; end

    # source://railties//lib/rails/generators/testing/behavior.rb#22
    def default_arguments=(value); end

    # source://railties//lib/rails/generators/testing/behavior.rb#22
    def default_arguments?; end

    # source://railties//lib/rails/generators/testing/behavior.rb#23
    def destination_root; end

    # source://railties//lib/rails/generators/testing/behavior.rb#23
    def destination_root=(value); end

    # source://railties//lib/rails/generators/testing/behavior.rb#23
    def destination_root?; end

    # source://railties//lib/rails/generators/testing/behavior.rb#24
    def generator_class; end

    # source://railties//lib/rails/generators/testing/behavior.rb#24
    def generator_class=(value); end

    # source://railties//lib/rails/generators/testing/behavior.rb#24
    def generator_class?; end
  end
end

# source://railties//lib/rails/generators/testing/behavior.rb#13
module Rails::Generators::Testing; end

# source://railties//lib/rails/generators/testing/assertions.rb#6
module Rails::Generators::Testing::Assertions
  # Asserts the given class method exists in the given content. This method does not detect
  # class methods inside (class << self), only class methods which starts with "self.".
  # When a block is given, it yields the content of the method.
  #
  #   assert_migration "db/migrate/create_products.rb" do |migration|
  #     assert_class_method :up, migration do |up|
  #       assert_match(/create_table/, up)
  #     end
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#88
  def assert_class_method(method, content, &block); end

  # Asserts a given file exists. You need to supply an absolute path or a path relative
  # to the configured destination:
  #
  #   assert_file "config/environment.rb"
  #
  # You can also give extra arguments. If the argument is a regexp, it will check if the
  # regular expression matches the given file content. If it's a string, it compares the
  # file with the given string:
  #
  #   assert_file "config/environment.rb", /initialize/
  #
  # Finally, when a block is given, it yields the file content:
  #
  #   assert_file "app/controllers/products_controller.rb" do |controller|
  #     assert_instance_method :index, controller do |index|
  #       assert_match(/Product\.all/, index)
  #     end
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#25
  def assert_directory(relative, *contents); end

  # Asserts the given attribute type gets a proper default value:
  #
  #   assert_field_default_value :string, "MyString"
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#117
  def assert_field_default_value(attribute_type, value); end

  # Asserts the given attribute type gets translated to a field type
  # properly:
  #
  #   assert_field_type :date, :date_select
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#110
  def assert_field_type(attribute_type, field_type); end

  # Asserts a given file exists. You need to supply an absolute path or a path relative
  # to the configured destination:
  #
  #   assert_file "config/environment.rb"
  #
  # You can also give extra arguments. If the argument is a regexp, it will check if the
  # regular expression matches the given file content. If it's a string, it compares the
  # file with the given string:
  #
  #   assert_file "config/environment.rb", /initialize/
  #
  # Finally, when a block is given, it yields the file content:
  #
  #   assert_file "app/controllers/products_controller.rb" do |controller|
  #     assert_instance_method :index, controller do |index|
  #       assert_match(/Product\.all/, index)
  #     end
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#25
  def assert_file(relative, *contents); end

  # Asserts a given initializer exists. You need to supply a path relative
  # to the `config/initializers/` directory.
  #
  #   assert_initializer "mail_interceptors.rb"
  #
  # You can also give extra arguments. If the argument is a regexp, it will check if the
  # regular expression matches the given file content. If it's a string, it compares the
  # file with the given string:
  #
  #   assert_initializer "mail_interceptors.rb", /SandboxEmailInterceptor/
  #
  # Finally, when a block is given, it yields the file content:
  #
  #   assert_initializer "mail_interceptors.rb" do |initializer|
  #     assert_match(/SandboxEmailInterceptor/, initializer)
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#141
  def assert_initializer(name, *contents, &block); end

  # Asserts the given method exists in the given content. When a block is given,
  # it yields the content of the method.
  #
  #   assert_file "app/controllers/products_controller.rb" do |controller|
  #     assert_instance_method :index, controller do |index|
  #       assert_match(/Product\.all/, index)
  #     end
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#100
  def assert_instance_method(method, content); end

  # Asserts the given method exists in the given content. When a block is given,
  # it yields the content of the method.
  #
  #   assert_file "app/controllers/products_controller.rb" do |controller|
  #     assert_instance_method :index, controller do |index|
  #       assert_match(/Product\.all/, index)
  #     end
  #   end
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#100
  def assert_method(method, content); end

  # Asserts a given migration exists. You need to supply an absolute path or a
  # path relative to the configured destination:
  #
  #   assert_migration "db/migrate/create_products.rb"
  #
  # This method manipulates the given path and tries to find any migration which
  # matches the migration name. For example, the call above is converted to:
  #
  #   assert_file "db/migrate/003_create_products.rb"
  #
  # Consequently, assert_migration accepts the same arguments has assert_file.
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#64
  def assert_migration(relative, *contents, &block); end

  # Asserts a given file does not exist. You need to supply an absolute path or a
  # path relative to the configured destination:
  #
  #   assert_no_file "config/random.rb"
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#47
  def assert_no_directory(relative); end

  # Asserts a given file does not exist. You need to supply an absolute path or a
  # path relative to the configured destination:
  #
  #   assert_no_file "config/random.rb"
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#47
  def assert_no_file(relative); end

  # Asserts a given migration does not exist. You need to supply an absolute path or a
  # path relative to the configured destination:
  #
  #   assert_no_migration "db/migrate/create_products.rb"
  #
  # source://railties//lib/rails/generators/testing/assertions.rb#74
  def assert_no_migration(relative); end
end

# source://railties//lib/rails/generators/testing/behavior.rb#14
module Rails::Generators::Testing::Behavior
  include ::ActiveSupport::Testing::Stream
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::Rails::Generators::Testing::Behavior::ClassMethods

  # Create a Rails::Generators::GeneratedAttribute by supplying the
  # attribute type and, optionally, the attribute name:
  #
  #   create_generated_attribute(:string, "name")
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#89
  def create_generated_attribute(attribute_type, name = T.unsafe(nil), index = T.unsafe(nil)); end

  # Instantiate the generator.
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#81
  def generator(args = T.unsafe(nil), options = T.unsafe(nil), config = T.unsafe(nil)); end

  # Runs the generator configured for this class. The first argument is an array like
  # command line arguments:
  #
  #   class AppGeneratorTest < Rails::Generators::TestCase
  #     tests AppGenerator
  #     destination File.expand_path("../tmp", __dir__)
  #     setup :prepare_destination
  #
  #     test "database.yml is not created when skipping Active Record" do
  #       run_generator %w(myapp --skip-active-record)
  #       assert_no_file "config/database.yml"
  #     end
  #   end
  #
  # You can provide a configuration hash as second argument. This method returns the output
  # printed by the generator.
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#67
  def run_generator(args = T.unsafe(nil), config = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#94
  def destination_root_is_set?; end

  # source://railties//lib/rails/generators/testing/behavior.rb#98
  def ensure_current_path; end

  # source://railties//lib/rails/generators/testing/behavior.rb#108
  def migration_file_name(relative); end

  # Clears all files and directories in destination.
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#103
  def prepare_destination; end

  module GeneratedClassMethods
    def current_path; end
    def current_path=(value); end
    def current_path?; end
    def default_arguments; end
    def default_arguments=(value); end
    def default_arguments?; end
    def destination_root; end
    def destination_root=(value); end
    def destination_root?; end
    def generator_class; end
    def generator_class=(value); end
    def generator_class?; end
  end

  module GeneratedInstanceMethods
    def current_path; end
    def current_path=(value); end
    def current_path?; end
    def default_arguments; end
    def default_arguments=(value); end
    def default_arguments?; end
    def destination_root; end
    def destination_root=(value); end
    def destination_root?; end
    def generator_class; end
    def generator_class=(value); end
    def generator_class?; end
  end
end

# source://railties//lib/rails/generators/testing/behavior.rb#27
module Rails::Generators::Testing::Behavior::ClassMethods
  # Sets default arguments on generator invocation. This can be overwritten when
  # invoking it.
  #
  #   arguments %w(app_name --skip-active-record)
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#39
  def arguments(array); end

  # Sets the destination of generator files:
  #
  #   destination File.expand_path("../tmp", __dir__)
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#46
  def destination(path); end

  # Sets which generator should be tested:
  #
  #   tests AppGenerator
  #
  # source://railties//lib/rails/generators/testing/behavior.rb#31
  def tests(klass); end
end

# source://railties//lib/rails/generators/testing/setup_and_teardown.rb#6
module Rails::Generators::Testing::SetupAndTeardown
  # source://railties//lib/rails/generators/testing/setup_and_teardown.rb#7
  def setup; end

  # source://railties//lib/rails/generators/testing/setup_and_teardown.rb#13
  def teardown; end
end

# Built-in Health Check Endpoint
#
# \Rails also comes with a built-in health check endpoint that is reachable at
# the +/up+ path. This endpoint will return a 200 status code if the app has
# booted with no exceptions, and a 500 status code otherwise.
#
# In production, many applications are required to report their status upstream,
# whether it's to an uptime monitor that will page an engineer when things go
# wrong, or a load balancer or Kubernetes controller used to determine a pod's
# health. This health check is designed to be a one-size fits all that will work
# in many situations.
#
# While any newly generated \Rails applications will have the health check at
# +/up+, you can configure the path to be anything you'd like in your
# <tt>"config/routes.rb"</tt>:
#
#   Rails.application.routes.draw do
#     get "healthz" => "rails/health#show", as: :rails_health_check
#   end
#
# The health check will now be accessible via the +/healthz+ path.
#
# NOTE: This endpoint does not reflect the status of all of your application's
# dependencies, such as the database or Redis cluster. Replace
# <tt>"rails/health#show"</tt> with your own controller action if you have
# application specific needs.
#
# Think carefully about what you want to check as it can lead to situations
# where your application is being restarted due to a third-party service going
# bad. Ideally, you should design your application to handle those outages
# gracefully.
#
# source://railties//lib/rails/health_controller.rb#35
class Rails::HealthController < ::ActionController::Base
  # source://railties//lib/rails/health_controller.rb#38
  def show; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://railties//lib/rails/health_controller.rb#51
  def html_status(color:); end

  # source://railties//lib/rails/health_controller.rb#47
  def render_down; end

  # source://railties//lib/rails/health_controller.rb#43
  def render_up; end

  class << self
    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end
  end
end

# This module helps build the runtime properties that are displayed in
# Rails::InfoController responses. These include the active \Rails version,
# Ruby version, Rack version, and so on.
#
# source://railties//lib/rails/info.rb#9
module Rails::Info
  # source://railties//lib/rails/info.rb#10
  def properties; end

  # source://railties//lib/rails/info.rb#10
  def properties=(val); end

  class << self
    # source://railties//lib/rails/info.rb#31
    def inspect; end

    # source://railties//lib/rails/info.rb#10
    def properties; end

    # source://railties//lib/rails/info.rb#10
    def properties=(val); end

    # source://railties//lib/rails/info.rb#25
    def property(name, value = T.unsafe(nil)); end

    # source://railties//lib/rails/info.rb#43
    def to_html; end

    # source://railties//lib/rails/info.rb#31
    def to_s; end
  end
end

# source://railties//lib/rails/info_controller.rb#6
class Rails::InfoController < ::Rails::ApplicationController
  # source://railties//lib/rails/info_controller.rb#12
  def index; end

  # source://railties//lib/rails/info_controller.rb#16
  def properties; end

  # source://railties//lib/rails/info_controller.rb#21
  def routes; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://railties//lib/rails/info_controller.rb#8
  def _layout_from_proc; end

  # source://railties//lib/rails/info_controller.rb#36
  def matching_routes(query:, exact_match:); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions; end

    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end
  end
end

# source://railties//lib/rails/initializable.rb#6
module Rails::Initializable
  mixes_in_class_methods ::Rails::Initializable::ClassMethods

  # source://railties//lib/rails/initializable.rb#66
  def initializers; end

  # source://railties//lib/rails/initializable.rb#58
  def run_initializers(group = T.unsafe(nil), *args); end

  class << self
    # source://railties//lib/rails/initializable.rb#7
    def included(base); end
  end
end

# source://railties//lib/rails/initializable.rb#70
module Rails::Initializable::ClassMethods
  # @raise [ArgumentError]
  #
  # source://railties//lib/rails/initializable.rb#88
  def initializer(name, opts = T.unsafe(nil), &blk); end

  # source://railties//lib/rails/initializable.rb#71
  def initializers; end

  # source://railties//lib/rails/initializable.rb#75
  def initializers_chain; end

  # source://railties//lib/rails/initializable.rb#84
  def initializers_for(binding); end
end

# source://railties//lib/rails/initializable.rb#45
class Rails::Initializable::Collection < ::Array
  include ::TSort

  # source://railties//lib/rails/initializable.rb#53
  def +(other); end

  # source://railties//lib/rails/initializable.rb#49
  def tsort_each_child(initializer, &block); end

  def tsort_each_node; end
end

# source://railties//lib/rails/initializable.rb#11
class Rails::Initializable::Initializer
  # @return [Initializer] a new instance of Initializer
  #
  # source://railties//lib/rails/initializable.rb#14
  def initialize(name, context, options, &block); end

  # source://railties//lib/rails/initializable.rb#23
  def after; end

  # source://railties//lib/rails/initializable.rb#19
  def before; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/initializable.rb#27
  def belongs_to?(group); end

  # source://railties//lib/rails/initializable.rb#35
  def bind(context); end

  # Returns the value of attribute block.
  #
  # source://railties//lib/rails/initializable.rb#12
  def block; end

  # source://railties//lib/rails/initializable.rb#40
  def context_class; end

  # Returns the value of attribute name.
  #
  # source://railties//lib/rails/initializable.rb#12
  def name; end

  # source://railties//lib/rails/initializable.rb#31
  def run(*args); end
end

# source://railties//lib/rails/test_unit/line_filtering.rb#6
module Rails::LineFiltering
  # source://railties//lib/rails/test_unit/line_filtering.rb#7
  def run(reporter, options = T.unsafe(nil)); end
end

# source://railties//lib/rails/mailers_controller.rb#6
class Rails::MailersController < ::Rails::ApplicationController
  # source://railties//lib/rails/mailers_controller.rb#22
  def download; end

  # source://railties//lib/rails/mailers_controller.rb#17
  def index; end

  # source://railties//lib/rails/mailers_controller.rb#32
  def preview; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  # source://railties//lib/rails/mailers_controller.rb#107
  def attachment_url(attachment); end

  # source://railties//lib/rails/mailers_controller.rb#101
  def attachments_for(email); end

  # source://railties//lib/rails/mailers_controller.rb#93
  def find_part(format); end

  # source://railties//lib/rails/mailers_controller.rb#81
  def find_preferred_part(*formats); end

  # source://railties//lib/rails/mailers_controller.rb#69
  def find_preview; end

  # source://railties//lib/rails/mailers_controller.rb#115
  def locale_query(locale); end

  # source://railties//lib/rails/mailers_controller.rb#111
  def part_query(mime_type); end

  # source://railties//lib/rails/mailers_controller.rb#119
  def set_locale(&block); end

  # @return [Boolean]
  #
  # source://railties//lib/rails/mailers_controller.rb#65
  def show_previews?; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionpack/7.2.1/lib/abstract_controller/helpers.rb#13
    def _helper_methods; end

    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end
  end
end

# source://railties//lib/rails/mailers_controller.rb#0
module Rails::MailersController::HelperMethods
  include ::ActionText::ContentHelper
  include ::ActionText::TagHelper
  include ::ActionController::Base::HelperMethods

  # source://railties//lib/rails/mailers_controller.rb#13
  def attachment_url(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/mailers_controller.rb#13
  def locale_query(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/mailers_controller.rb#13
  def part_query(*_arg0, **_arg1, &_arg2); end
end

# source://railties//lib/rails/paths.rb#6
module Rails::Paths; end

# source://railties//lib/rails/paths.rb#114
class Rails::Paths::Path
  include ::Enumerable

  # @return [Path] a new instance of Path
  #
  # source://railties//lib/rails/paths.rb#119
  def initialize(root, current, paths, options = T.unsafe(nil)); end

  # source://railties//lib/rails/paths.rb#171
  def <<(path); end

  # source://railties//lib/rails/paths.rb#132
  def absolute_current; end

  # source://railties//lib/rails/paths.rb#153
  def autoload!; end

  # source://railties//lib/rails/paths.rb#161
  def autoload?; end

  # source://railties//lib/rails/paths.rb#153
  def autoload_once!; end

  # source://railties//lib/rails/paths.rb#161
  def autoload_once?; end

  # source://railties//lib/rails/paths.rb#136
  def children; end

  # source://railties//lib/rails/paths.rb#176
  def concat(paths); end

  # source://railties//lib/rails/paths.rb#167
  def each(&block); end

  # source://railties//lib/rails/paths.rb#153
  def eager_load!; end

  # source://railties//lib/rails/paths.rb#161
  def eager_load?; end

  # Returns all expanded paths but only if they exist in the filesystem.
  #
  # source://railties//lib/rails/paths.rb#220
  def existent; end

  # source://railties//lib/rails/paths.rb#231
  def existent_directories; end

  # Expands all paths against the root and return all unique values.
  #
  # source://railties//lib/rails/paths.rb#201
  def expanded; end

  # source://railties//lib/rails/paths.rb#196
  def extensions; end

  # source://railties//lib/rails/paths.rb#143
  def first; end

  # Returns the value of attribute glob.
  #
  # source://railties//lib/rails/paths.rb#117
  def glob; end

  # Sets the attribute glob
  #
  # @param value the value to set the attribute glob to.
  #
  # source://railties//lib/rails/paths.rb#117
  def glob=(_arg0); end

  # source://railties//lib/rails/paths.rb#147
  def last; end

  # source://railties//lib/rails/paths.rb#153
  def load_path!; end

  # source://railties//lib/rails/paths.rb#161
  def load_path?; end

  # source://railties//lib/rails/paths.rb#188
  def paths; end

  # source://railties//lib/rails/paths.rb#171
  def push(path); end

  # source://railties//lib/rails/paths.rb#157
  def skip_autoload!; end

  # source://railties//lib/rails/paths.rb#157
  def skip_autoload_once!; end

  # source://railties//lib/rails/paths.rb#157
  def skip_eager_load!; end

  # source://railties//lib/rails/paths.rb#157
  def skip_load_path!; end

  # Expands all paths against the root and return all unique values.
  #
  # source://railties//lib/rails/paths.rb#201
  def to_a; end

  # source://railties//lib/rails/paths.rb#184
  def to_ary; end

  # source://railties//lib/rails/paths.rb#180
  def unshift(*paths); end

  private

  # source://railties//lib/rails/paths.rb#238
  def files_in(path); end
end

# This object is an extended hash that behaves as root of the Rails::Paths system.
# It allows you to collect information about how you want to structure your application
# paths through a Hash-like \API. It requires you to give a physical path on initialization.
#
#   root = Root.new "/rails"
#   root.add "app/controllers", eager_load: true
#
# The above command creates a new root object and adds "app/controllers" as a path.
# This means we can get a Rails::Paths::Path object back like below:
#
#   path = root["app/controllers"]
#   path.eager_load?               # => true
#   path.is_a?(Rails::Paths::Path) # => true
#
# The Path[rdoc-ref:Rails::Paths::Path] object is simply an enumerable and
# allows you to easily add extra paths:
#
#   path.is_a?(Enumerable) # => true
#   path.to_ary.inspect    # => ["app/controllers"]
#
#   path << "lib/controllers"
#   path.to_ary.inspect    # => ["app/controllers", "lib/controllers"]
#
# Notice that when you add a path using #add, the
# Path[rdoc-ref:Rails::Paths::Path] object created already contains the path
# with the same path value given to #add. In some situations, you may not
# want this behavior, so you can give <tt>:with</tt> as option.
#
#   root.add "config/routes", with: "config/routes.rb"
#   root["config/routes"].inspect # => ["config/routes.rb"]
#
# The #add method accepts the following options as arguments:
# +eager_load+, +autoload+, +autoload_once+, and +glob+.
#
# Finally, the Path[rdoc-ref:Rails::Paths::Path] object also provides a few
# helpers:
#
#   root = Root.new "/rails"
#   root.add "app/controllers"
#
#   root["app/controllers"].expanded # => ["/rails/app/controllers"]
#   root["app/controllers"].existent # => ["/rails/app/controllers"]
#
# Check the Rails::Paths::Path documentation for more information.
#
# source://railties//lib/rails/paths.rb#51
class Rails::Paths::Root
  # @return [Root] a new instance of Root
  #
  # source://railties//lib/rails/paths.rb#54
  def initialize(path); end

  # source://railties//lib/rails/paths.rb#69
  def [](path); end

  # source://railties//lib/rails/paths.rb#59
  def []=(path, value); end

  # source://railties//lib/rails/paths.rb#64
  def add(path, options = T.unsafe(nil)); end

  # source://railties//lib/rails/paths.rb#85
  def all_paths; end

  # source://railties//lib/rails/paths.rb#89
  def autoload_once; end

  # source://railties//lib/rails/paths.rb#97
  def autoload_paths; end

  # source://railties//lib/rails/paths.rb#93
  def eager_load; end

  # source://railties//lib/rails/paths.rb#77
  def keys; end

  # source://railties//lib/rails/paths.rb#101
  def load_paths; end

  # Returns the value of attribute path.
  #
  # source://railties//lib/rails/paths.rb#52
  def path; end

  # Sets the attribute path
  #
  # @param value the value to set the attribute path to.
  #
  # source://railties//lib/rails/paths.rb#52
  def path=(_arg0); end

  # source://railties//lib/rails/paths.rb#73
  def values; end

  # source://railties//lib/rails/paths.rb#81
  def values_at(*list); end

  private

  # source://railties//lib/rails/paths.rb#106
  def filter_by(&block); end
end

# source://railties//lib/rails/pwa_controller.rb#5
class Rails::PwaController < ::Rails::ApplicationController
  # source://railties//lib/rails/pwa_controller.rb#12
  def manifest; end

  # source://railties//lib/rails/pwa_controller.rb#8
  def service_worker; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end
  end
end

# source://railties//lib/rails/rack.rb#4
module Rails::Rack; end

# Sets log tags, logs the request, calls the app, and flushes the logs.
#
# Log tags (+taggers+) can be an Array containing: methods that the +request+
# object responds to, objects that respond to +to_s+ or Proc objects that accept
# an instance of the +request+ object.
#
# source://railties//lib/rails/rack/logger.rb#14
class Rails::Rack::Logger < ::ActiveSupport::LogSubscriber
  # @return [Logger] a new instance of Logger
  #
  # source://railties//lib/rails/rack/logger.rb#15
  def initialize(app, taggers = T.unsafe(nil)); end

  # source://railties//lib/rails/rack/logger.rb#20
  def call(env); end

  private

  # source://railties//lib/rails/rack/logger.rb#33
  def call_app(request, env); end

  # source://railties//lib/rails/rack/logger.rb#64
  def compute_tags(request); end

  # source://railties//lib/rails/rack/logger.rb#81
  def finish_request_instrumentation(handle, logger_tag_pop_count); end

  # source://railties//lib/rails/rack/logger.rb#77
  def logger; end

  # Started GET "/session/new" for 127.0.0.1 at 2012-09-26 14:51:42 -0700
  #
  # source://railties//lib/rails/rack/logger.rb#56
  def started_request_message(request); end
end

# +Rails::Railtie+ is the core of the \Rails framework and provides
# several hooks to extend \Rails and/or modify the initialization process.
#
# Every major component of \Rails (Action Mailer, Action Controller, Active
# Record, etc.) implements a railtie. Each of them is responsible for their
# own initialization. This makes \Rails itself absent of any component hooks,
# allowing other components to be used in place of any of the \Rails defaults.
#
# Developing a \Rails extension does _not_ require implementing a railtie, but
# if you need to interact with the \Rails framework during or after boot, then
# a railtie is needed.
#
# For example, an extension doing any of the following would need a railtie:
#
# * creating initializers
# * configuring a \Rails framework for the application, like setting a generator
# * adding <tt>config.*</tt> keys to the environment
# * setting up a subscriber with ActiveSupport::Notifications
# * adding Rake tasks
#
# == Creating a Railtie
#
# To extend \Rails using a railtie, create a subclass of +Rails::Railtie+.
# This class must be loaded during the \Rails boot process, and is conventionally
# called +MyNamespace::Railtie+.
#
# The following example demonstrates an extension which can be used with or
# without \Rails.
#
#   # lib/my_gem/railtie.rb
#   module MyGem
#     class Railtie < Rails::Railtie
#     end
#   end
#
#   # lib/my_gem.rb
#   require "my_gem/railtie" if defined?(Rails::Railtie)
#
# == Initializers
#
# To add an initialization step to the \Rails boot process from your railtie, just
# define the initialization code with the +initializer+ macro:
#
#   class MyRailtie < Rails::Railtie
#     initializer "my_railtie.configure_rails_initialization" do
#       # some initialization behavior
#     end
#   end
#
# If specified, the block can also receive the application object, in case you
# need to access some application-specific configuration, like middleware:
#
#   class MyRailtie < Rails::Railtie
#     initializer "my_railtie.configure_rails_initialization" do |app|
#       app.middleware.use MyRailtie::Middleware
#     end
#   end
#
# Finally, you can also pass <tt>:before</tt> and <tt>:after</tt> as options to
# +initializer+, in case you want to couple it with a specific step in the
# initialization process.
#
# == Configuration
#
# Railties can access a config object which contains configuration shared by all
# railties and the application:
#
#   class MyRailtie < Rails::Railtie
#     # Customize the ORM
#     config.app_generators.orm :my_railtie_orm
#
#     # Add a to_prepare block which is executed once in production
#     # and before each request in development.
#     config.to_prepare do
#       MyRailtie.setup!
#     end
#   end
#
# == Loading Rake Tasks and Generators
#
# If your railtie has Rake tasks, you can tell \Rails to load them through the method
# +rake_tasks+:
#
#   class MyRailtie < Rails::Railtie
#     rake_tasks do
#       load "path/to/my_railtie.tasks"
#     end
#   end
#
# By default, \Rails loads generators from your load path. However, if you want to place
# your generators at a different location, you can specify in your railtie a block which
# will load them during normal generators lookup:
#
#   class MyRailtie < Rails::Railtie
#     generators do
#       require "path/to/my_railtie_generator"
#     end
#   end
#
# Since filenames on the load path are shared across gems, be sure that files you load
# through a railtie have unique names.
#
# == Run another program when the \Rails server starts
#
# In development, it's very usual to have to run another process next to the \Rails Server. In example
# you might want to start the Webpack or React server. Or maybe you need to run your job scheduler process
# like Sidekiq. This is usually done by opening a new shell and running the program from here.
#
# \Rails allow you to specify a +server+ block which will get called when a \Rails server starts.
# This way, your users don't need to remember to have to open a new shell and run another program, making
# this less confusing for everyone.
# It can be used like this:
#
#   class MyRailtie < Rails::Railtie
#     server do
#       WebpackServer.start
#     end
#   end
#
# == Application and Engine
#
# An engine is nothing more than a railtie with some initializers already set. And since
# Rails::Application is an engine, the same configuration described here can be
# used in both.
#
# Be sure to look at the documentation of those specific classes for more information.
#
# source://railties//lib/rails/railtie.rb#136
class Rails::Railtie
  include ::Rails::Initializable
  extend ::ActiveSupport::DescendantsTracker
  extend ::Rails::Initializable::ClassMethods

  # @return [Railtie] a new instance of Railtie
  #
  # source://railties//lib/rails/railtie.rb#245
  def initialize; end

  # This is used to create the <tt>config</tt> object on Railties, an instance of
  # Railtie::Configuration, that is used by Railties and Application to store
  # related configuration.
  #
  # source://railties//lib/rails/railtie.rb#262
  def config; end

  # source://railties//lib/rails/railtie.rb#255
  def configure(&block); end

  # source://railties//lib/rails/railtie.rb#251
  def inspect; end

  # source://railties//lib/rails/railtie.rb#243
  def railtie_name(*_arg0, **_arg1, &_arg2); end

  # source://railties//lib/rails/railtie.rb#266
  def railtie_namespace; end

  protected

  # source://railties//lib/rails/railtie.rb#271
  def run_console_blocks(app); end

  # source://railties//lib/rails/railtie.rb#275
  def run_generators_blocks(app); end

  # source://railties//lib/rails/railtie.rb#279
  def run_runner_blocks(app); end

  # source://railties//lib/rails/railtie.rb#288
  def run_server_blocks(app); end

  # source://railties//lib/rails/railtie.rb#283
  def run_tasks_blocks(app); end

  private

  # run `&block` in every registered block in `#register_block_for`
  #
  # source://railties//lib/rails/railtie.rb#294
  def each_registered_block(type, &block); end

  class << self
    # source://railties//lib/rails/railtie.rb#194
    def <=>(other); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/railtie.rb#172
    def abstract_railtie?; end

    # source://railties//lib/rails/railtie.rb#146
    def config(*_arg0, **_arg1, &_arg2); end

    # Allows you to configure the railtie. This is the same method seen in
    # Railtie::Configurable, but this module is no longer required for all
    # subclasses of Railtie so we provide the class method here.
    #
    # source://railties//lib/rails/railtie.rb#190
    def configure(&block); end

    # source://railties//lib/rails/railtie.rb#156
    def console(&blk); end

    # source://railties//lib/rails/railtie.rb#164
    def generators(&blk); end

    # @private
    #
    # source://railties//lib/rails/railtie.rb#198
    def inherited(subclass); end

    # Since Rails::Railtie cannot be instantiated, any methods that call
    # +instance+ are intended to be called only on subclasses of a Railtie.
    #
    # source://railties//lib/rails/railtie.rb#183
    def instance; end

    # source://railties//lib/rails/railtie.rb#176
    def railtie_name(name = T.unsafe(nil)); end

    # source://railties//lib/rails/railtie.rb#152
    def rake_tasks(&blk); end

    # source://railties//lib/rails/railtie.rb#160
    def runner(&blk); end

    # source://railties//lib/rails/railtie.rb#168
    def server(&blk); end

    # source://railties//lib/rails/railtie.rb#148
    def subclasses; end

    protected

    # source://railties//lib/rails/railtie.rb#206
    def increment_load_index; end

    # Returns the value of attribute load_index.
    #
    # source://railties//lib/rails/railtie.rb#204
    def load_index; end

    private

    # source://railties//lib/rails/railtie.rb#212
    def generate_railtie_name(string); end

    # If the class method does not have a method, then send the method call
    # to the Railtie instance.
    #
    # source://railties//lib/rails/railtie.rb#224
    def method_missing(name, *_arg1, **_arg2, &_arg3); end

    def new(*_arg0); end

    # receives an instance variable identifier, set the variable value if is
    # blank and append given block to value, which will be used later in
    # `#each_registered_block(type, &block)`
    #
    # source://railties//lib/rails/railtie.rb#235
    def register_block_for(type, &blk); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/railtie.rb#216
    def respond_to_missing?(name, _); end
  end
end

# source://railties//lib/rails/railtie.rb#142
Rails::Railtie::ABSTRACT_RAILTIES = T.let(T.unsafe(nil), Array)

# source://railties//lib/rails/railtie/configuration.rb#7
class Rails::Railtie::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://railties//lib/rails/railtie/configuration.rb#8
  def initialize; end

  # Last configurable block to run. Called after frameworks initialize.
  #
  # source://railties//lib/rails/railtie/configuration.rb#70
  def after_initialize(&block); end

  # Called after application routes have been loaded.
  #
  # source://railties//lib/rails/railtie/configuration.rb#75
  def after_routes_loaded(&block); end

  # This allows you to modify application's generators from Railties.
  #
  # Values set on app_generators will become defaults for application, unless
  # application overwrites them.
  #
  # @yield [@@app_generators]
  #
  # source://railties//lib/rails/railtie/configuration.rb#47
  def app_generators; end

  # This allows you to modify the application's middlewares from Engines.
  #
  # All operations you run on the app_middleware will be replayed on the
  # application once it is defined and the default_middlewares are
  # created
  #
  # source://railties//lib/rails/railtie/configuration.rb#39
  def app_middleware; end

  # First configurable block to run. Called before any initializers are run.
  #
  # source://railties//lib/rails/railtie/configuration.rb#54
  def before_configuration(&block); end

  # Third configurable block to run. Does not run if +config.eager_load+
  # set to false.
  #
  # source://railties//lib/rails/railtie/configuration.rb#60
  def before_eager_load(&block); end

  # Second configurable block to run. Called before frameworks initialize.
  #
  # source://railties//lib/rails/railtie/configuration.rb#65
  def before_initialize(&block); end

  # All namespaces that are eager loaded
  #
  # source://railties//lib/rails/railtie/configuration.rb#18
  def eager_load_namespaces; end

  # @return [Boolean]
  #
  # source://railties//lib/rails/railtie/configuration.rb#90
  def respond_to?(name, include_private = T.unsafe(nil)); end

  # Defines generic callbacks to run before #after_initialize. Useful for
  # Rails::Railtie subclasses.
  #
  # source://railties//lib/rails/railtie/configuration.rb#86
  def to_prepare(&blk); end

  # Array of callbacks defined by #to_prepare.
  #
  # source://railties//lib/rails/railtie/configuration.rb#80
  def to_prepare_blocks; end

  # Add directories that should be watched for change.
  # The key of the hashes should be directories and the values should
  # be an array of extensions to match in each directory.
  #
  # source://railties//lib/rails/railtie/configuration.rb#30
  def watchable_dirs; end

  # Add files that should be watched for change.
  #
  # source://railties//lib/rails/railtie/configuration.rb#23
  def watchable_files; end

  private

  # @return [Boolean]
  #
  # source://railties//lib/rails/railtie/configuration.rb#95
  def actual_method?(key); end

  # source://railties//lib/rails/railtie/configuration.rb#99
  def method_missing(name, *args, &blk); end

  class << self
    # Expose the eager_load_namespaces at "module" level for convenience.
    #
    # source://railties//lib/rails/railtie/configuration.rb#13
    def eager_load_namespaces; end
  end
end

# Implements the logic behind +Rails::Command::NotesCommand+. See <tt>rails notes --help</tt> for usage information.
#
# Annotation objects are triplets <tt>:line</tt>, <tt>:tag</tt>, <tt>:text</tt> that
# represent the line where the annotation lives, its tag, and its text. Note
# the filename is not stored.
#
# Annotations are looked for in comments and modulus whitespace they have to
# start with the tag optionally followed by a colon. Everything up to the end
# of the line (or closing ERB comment tag) is considered to be their text.
#
# source://railties//lib/rails/source_annotation_extractor.rb#15
class Rails::SourceAnnotationExtractor
  # @return [SourceAnnotationExtractor] a new instance of SourceAnnotationExtractor
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#137
  def initialize(tag); end

  # Prints the mapping from filenames to annotations in +results+ ordered by filename.
  # The +options+ hash is passed to each annotation's +to_s+.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#186
  def display(results, options = T.unsafe(nil)); end

  # Returns a hash that maps filenames under +dirs+ (recursively) to arrays
  # with their annotations.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#143
  def find(dirs); end

  # Returns a hash that maps filenames under +dir+ (recursively) to arrays
  # with their annotations. Files with extensions registered in
  # <tt>Rails::SourceAnnotationExtractor::Annotation.extensions</tt> are
  # taken into account. Only files with annotations are included.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#151
  def find_in(dir); end

  # Returns the value of attribute tag.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#135
  def tag; end

  class << self
    # Prints all annotations with tag +tag+ under the root directories +app+,
    # +config+, +db+, +lib+, and +test+ (recursively).
    #
    # If +tag+ is <tt>nil</tt>, annotations with either default or registered tags are printed.
    #
    # Specific directories can be explicitly set using the <tt>:dirs</tt> key in +options+.
    #
    #   Rails::SourceAnnotationExtractor.enumerate 'TODO|FIXME', dirs: %w(app lib), tag: true
    #
    # If +options+ has a <tt>:tag</tt> flag, it will be passed to each annotation's +to_s+.
    #
    # See SourceAnnotationExtractor#find_in for a list of file extensions that will be taken into account.
    #
    # This class method is the single entry point for the <tt>rails notes</tt> command.
    #
    # source://railties//lib/rails/source_annotation_extractor.rb#128
    def enumerate(tag = T.unsafe(nil), options = T.unsafe(nil)); end
  end
end

# source://railties//lib/rails/source_annotation_extractor.rb#54
class Rails::SourceAnnotationExtractor::Annotation < ::Struct
  # Returns a representation of the annotation that looks like this:
  #
  #   [126] [TODO] This algorithm is simple and clearly correct, make it faster.
  #
  # If +options+ has a flag <tt>:tag</tt> the tag is shown as in the example above.
  # Otherwise the string contains just line and text.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#107
  def to_s(options = T.unsafe(nil)); end

  class << self
    # source://railties//lib/rails/source_annotation_extractor.rb#55
    def directories; end

    # source://railties//lib/rails/source_annotation_extractor.rb#75
    def extensions; end

    # Registers additional directories to be included
    #   Rails::SourceAnnotationExtractor::Annotation.register_directories("spec", "another")
    #
    # source://railties//lib/rails/source_annotation_extractor.rb#61
    def register_directories(*dirs); end

    # Registers new Annotations File Extensions
    #   Rails::SourceAnnotationExtractor::Annotation.register_extensions("css", "scss", "sass", "less", "js") { |tag| /\/\/\s*(#{tag}):?\s*(.*)$/ }
    #
    # source://railties//lib/rails/source_annotation_extractor.rb#81
    def register_extensions(*exts, &block); end

    # Registers additional tags
    #   Rails::SourceAnnotationExtractor::Annotation.register_tags("TESTME", "DEPRECATEME")
    #
    # source://railties//lib/rails/source_annotation_extractor.rb#71
    def register_tags(*additional_tags); end

    # source://railties//lib/rails/source_annotation_extractor.rb#65
    def tags; end
  end
end

# Wraps a regular expression that will be tested against each of the source
# file's comments.
#
# source://railties//lib/rails/source_annotation_extractor.rb#18
class Rails::SourceAnnotationExtractor::ParserExtractor < ::Struct
  # source://railties//lib/rails/source_annotation_extractor.rb#33
  def annotations(file); end
end

# source://railties//lib/rails/source_annotation_extractor.rb#19
class Rails::SourceAnnotationExtractor::ParserExtractor::Parser < ::Ripper
  # @return [Parser] a new instance of Parser
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#22
  def initialize(source, pattern:); end

  # Returns the value of attribute comments.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#20
  def comments; end

  # source://railties//lib/rails/source_annotation_extractor.rb#28
  def on_comment(value); end

  # Returns the value of attribute pattern.
  #
  # source://railties//lib/rails/source_annotation_extractor.rb#20
  def pattern; end
end

# Wraps a regular expression that will iterate through a file's lines and
# test each one for the given pattern.
#
# source://railties//lib/rails/source_annotation_extractor.rb#42
class Rails::SourceAnnotationExtractor::PatternExtractor < ::Struct
  # source://railties//lib/rails/source_annotation_extractor.rb#43
  def annotations(file); end
end

# source://railties//lib/rails/test_unit/test_parser.rb#12
module Rails::TestUnit; end

# source://railties//lib/rails/test_unit/runner.rb#146
class Rails::TestUnit::CompositeFilter
  # @return [CompositeFilter] a new instance of CompositeFilter
  #
  # source://railties//lib/rails/test_unit/runner.rb#149
  def initialize(runnable, filter, patterns); end

  # minitest uses === to find matching filters.
  #
  # source://railties//lib/rails/test_unit/runner.rb#156
  def ===(method); end

  # Returns the value of attribute named_filter.
  #
  # source://railties//lib/rails/test_unit/runner.rb#147
  def named_filter; end

  private

  # source://railties//lib/rails/test_unit/runner.rb#171
  def derive_line_filters(patterns); end

  # source://railties//lib/rails/test_unit/runner.rb#161
  def derive_named_filter(filter); end
end

# source://railties//lib/rails/test_unit/runner.rb#182
class Rails::TestUnit::Filter
  # @return [Filter] a new instance of Filter
  #
  # source://railties//lib/rails/test_unit/runner.rb#183
  def initialize(runnable, file, line_or_range); end

  # source://railties//lib/rails/test_unit/runner.rb#192
  def ===(method); end

  private

  # source://railties//lib/rails/test_unit/runner.rb#204
  def definition_for(method); end
end

# source://railties//lib/rails/test_unit/runner.rb#12
class Rails::TestUnit::InvalidTestError < ::StandardError
  # @return [InvalidTestError] a new instance of InvalidTestError
  #
  # source://railties//lib/rails/test_unit/runner.rb#13
  def initialize(path, suggestion); end
end

# source://railties//lib/rails/test_unit/runner.rb#21
class Rails::TestUnit::Runner
  # source://railties//lib/rails/test_unit/runner.rb#24
  def filters; end

  class << self
    # source://railties//lib/rails/test_unit/runner.rb#27
    def attach_before_load_options(opts); end

    # source://railties//lib/rails/test_unit/runner.rb#78
    def compose_filter(runnable, filter); end

    # source://railties//lib/rails/test_unit/runner.rb#24
    def filters; end

    # source://railties//lib/rails/test_unit/runner.rb#57
    def load_tests(argv); end

    # source://railties//lib/rails/test_unit/runner.rb#32
    def parse_options(argv); end

    # source://railties//lib/rails/test_unit/runner.rb#51
    def run(argv = T.unsafe(nil)); end

    # source://railties//lib/rails/test_unit/runner.rb#45
    def run_from_rake(test_command, argv = T.unsafe(nil)); end

    private

    # source://railties//lib/rails/test_unit/runner.rb#113
    def default_test_exclude_glob; end

    # source://railties//lib/rails/test_unit/runner.rb#109
    def default_test_glob; end

    # source://railties//lib/rails/test_unit/runner.rb#89
    def extract_filters(argv); end

    # source://railties//lib/rails/test_unit/runner.rb#125
    def list_tests(patterns); end

    # source://railties//lib/rails/test_unit/runner.rb#131
    def normalize_declarative_test_filter(filter); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/test_unit/runner.rb#121
    def path_argument?(arg); end

    # @return [Boolean]
    #
    # source://railties//lib/rails/test_unit/runner.rb#117
    def regexp_filter?(arg); end
  end
end

# source://railties//lib/rails/test_unit/runner.rb#23
Rails::TestUnit::Runner::PATH_ARGUMENT_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://railties//lib/rails/test_unit/runner.rb#22
Rails::TestUnit::Runner::TEST_FOLDERS = T.let(T.unsafe(nil), Array)

# Parse a test file to extract the line ranges of all tests in both
# method-style (def test_foo) and declarative-style (test "foo" do)
#
# source://railties//lib/rails/test_unit/test_parser.rb#15
module Rails::TestUnit::TestParser
  class << self
    # Helper to translate a method object into the path and line range where
    # the method was defined.
    #
    # source://railties//lib/rails/test_unit/test_parser.rb#18
    def definition_for(method); end
  end
end

# source://railties//lib/rails/test_unit/railtie.rb#6
class Rails::TestUnitRailtie < ::Rails::Railtie; end

# source://railties//lib/rails/gem_version.rb#9
module Rails::VERSION; end

# source://railties//lib/rails/gem_version.rb#10
Rails::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://railties//lib/rails/gem_version.rb#11
Rails::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://railties//lib/rails/gem_version.rb#13
Rails::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://railties//lib/rails/gem_version.rb#15
Rails::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://railties//lib/rails/gem_version.rb#12
Rails::VERSION::TINY = T.let(T.unsafe(nil), Integer)

# source://railties//lib/rails/welcome_controller.rb#5
class Rails::WelcomeController < ::Rails::ApplicationController
  # source://railties//lib/rails/welcome_controller.rb#9
  def index; end

  private

  # source://actionview/7.2.1/lib/action_view/layouts.rb#328
  def _layout(lookup_context, formats); end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#211
    def _layout; end

    # source://actionview/7.2.1/lib/action_view/layouts.rb#212
    def _layout_conditions; end

    # source://actionpack/7.2.1/lib/action_controller/metal.rb#288
    def middleware_stack; end
  end
end
