# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rdoc` gem.
# Please instead update this file by running `bin/tapioca gem rdoc`.


module ERB::Escape
  private

  def html_escape(_arg0); end

  class << self
    def html_escape(_arg0); end
  end
end

# RDoc produces documentation for Ruby source files by parsing the source and
# extracting the definition for classes, modules, methods, includes and
# requires.  It associates these with optional documentation contained in an
# immediately preceding comment block then renders the result using an output
# formatter.
#
# For a simple introduction to writing or generating documentation using RDoc
# see the README.
#
# == Roadmap
#
# If you think you found a bug in RDoc see CONTRIBUTING@Bugs
#
# If you want to use RDoc to create documentation for your Ruby source files,
# see RDoc::Markup and refer to <tt>rdoc --help</tt> for command line usage.
#
# If you want to set the default markup format see
# RDoc::Markup@Supported+Formats
#
# If you want to store rdoc configuration in your gem (such as the default
# markup format) see RDoc::Options@Saved+Options
#
# If you want to write documentation for Ruby files see RDoc::Parser::Ruby
#
# If you want to write documentation for extensions written in C see
# RDoc::Parser::C
#
# If you want to generate documentation using <tt>rake</tt> see RDoc::Task.
#
# If you want to drive RDoc programmatically, see RDoc::RDoc.
#
# If you want to use the library to format text blocks into HTML or other
# formats, look at RDoc::Markup.
#
# If you want to make an RDoc plugin such as a generator or directive handler
# see RDoc::RDoc.
#
# If you want to write your own output generator see RDoc::Generator.
#
# If you want an overview of how RDoc works see CONTRIBUTING
#
# == Credits
#
# RDoc is currently being maintained by Eric Hodel <drbrain@segment7.net>.
#
# Dave Thomas <dave@pragmaticprogrammer.com> is the original author of RDoc.
#
# * The Ruby parser in rdoc/parse.rb is based heavily on the outstanding
#   work of Keiju ISHITSUKA of Nippon Rational Inc, who produced the Ruby
#   parser for irb and the rtags package.
#
# source://rdoc//lib/rdoc.rb#58
module RDoc
  class << self
    # Searches and returns the directory for settings.
    #
    # 1. <tt>$HOME/.rdoc</tt> directory, if it exists.
    # 2. The +rdoc+ directory under the path specified by the
    #    +XDG_DATA_HOME+ environment variable, if it is set.
    # 3. <tt>$HOME/.local/share/rdoc</tt> directory.
    #
    # Other than the home directory, the containing directory will be
    # created automatically.
    #
    # source://rdoc//lib/rdoc.rb#134
    def home; end

    # Loads the best available YAML library.
    #
    # source://rdoc//lib/rdoc.rb#107
    def load_yaml; end
  end
end

# Represent an alias, which is an old_name/new_name pair associated with a
# particular context
# --
# TODO implement Alias as a proxy to a method/attribute, inheriting from
#      MethodAttr
#
# source://rdoc//lib/rdoc/alias.rb#9
class RDoc::Alias < ::RDoc::CodeObject
  # Creates a new Alias with a token stream of +text+ that aliases +old_name+
  # to +new_name+, has +comment+ and is a +singleton+ context.
  #
  # @return [Alias] a new instance of Alias
  #
  # source://rdoc//lib/rdoc/alias.rb#37
  def initialize(text, old_name, new_name, comment, singleton = T.unsafe(nil)); end

  # Order by #singleton then #new_name
  #
  # source://rdoc//lib/rdoc/alias.rb#50
  def <=>(other); end

  # HTML fragment reference for this alias
  #
  # source://rdoc//lib/rdoc/alias.rb#57
  def aref; end

  # Full old name including namespace
  #
  # source://rdoc//lib/rdoc/alias.rb#65
  def full_old_name; end

  # HTML id-friendly version of +#new_name+.
  #
  # source://rdoc//lib/rdoc/alias.rb#72
  def html_name; end

  # source://rdoc//lib/rdoc/alias.rb#76
  def inspect; end

  # Aliased method's name
  #
  # source://rdoc//lib/rdoc/alias.rb#14
  def name; end

  # '::' for the alias of a singleton method/attribute, '#' for instance-level.
  #
  # source://rdoc//lib/rdoc/alias.rb#87
  def name_prefix; end

  # Aliased method's name
  #
  # source://rdoc//lib/rdoc/alias.rb#14
  def new_name; end

  # Aliasee method's name
  #
  # source://rdoc//lib/rdoc/alias.rb#21
  def old_name; end

  # New name with prefix '::' or '#'.
  #
  # source://rdoc//lib/rdoc/alias.rb#101
  def pretty_name; end

  # New name with prefix '::' or '#'.
  #
  # source://rdoc//lib/rdoc/alias.rb#101
  def pretty_new_name; end

  # Old name with prefix '::' or '#'.
  #
  # source://rdoc//lib/rdoc/alias.rb#94
  def pretty_old_name; end

  # Is this an alias declared in a singleton context?
  #
  # source://rdoc//lib/rdoc/alias.rb#26
  def singleton; end

  # Is this an alias declared in a singleton context?
  #
  # source://rdoc//lib/rdoc/alias.rb#26
  def singleton=(_arg0); end

  # Source file token stream
  #
  # source://rdoc//lib/rdoc/alias.rb#31
  def text; end

  # source://rdoc//lib/rdoc/alias.rb#107
  def to_s; end
end

# AnyMethod is the base class for objects representing methods
#
# source://rdoc//lib/rdoc/any_method.rb#5
class RDoc::AnyMethod < ::RDoc::MethodAttr
  include ::RDoc::TokenStream

  # Creates a new AnyMethod with a token stream +text+ and +name+
  #
  # @return [AnyMethod] a new instance of AnyMethod
  #
  # source://rdoc//lib/rdoc/any_method.rb#46
  def initialize(text, name); end

  # Adds +an_alias+ as an alias for this method in +context+.
  #
  # source://rdoc//lib/rdoc/any_method.rb#59
  def add_alias(an_alias, context = T.unsafe(nil)); end

  # Prefix for +aref+ is 'method'.
  #
  # source://rdoc//lib/rdoc/any_method.rb#76
  def aref_prefix; end

  # The call_seq or the param_seq with method name, if there is no call_seq.
  #
  # Use this for displaying a method's argument lists.
  #
  # source://rdoc//lib/rdoc/any_method.rb#85
  def arglists; end

  # The C function that implements this method (if it was defined in a C file)
  #
  # source://rdoc//lib/rdoc/any_method.rb#27
  def c_function; end

  # The C function that implements this method (if it was defined in a C file)
  #
  # source://rdoc//lib/rdoc/any_method.rb#27
  def c_function=(_arg0); end

  # Different ways to call this method
  #
  # source://rdoc//lib/rdoc/any_method.rb#96
  def call_seq; end

  # Sets the different ways you can call this method.  If an empty +call_seq+
  # is given nil is assumed.
  #
  # See also #param_seq
  #
  # source://rdoc//lib/rdoc/any_method.rb#112
  def call_seq=(call_seq); end

  # If true this method uses +super+ to call a superclass version
  #
  # source://rdoc//lib/rdoc/any_method.rb#39
  def calls_super; end

  # If true this method uses +super+ to call a superclass version
  #
  # source://rdoc//lib/rdoc/any_method.rb#39
  def calls_super=(_arg0); end

  # Don't rename \#initialize to \::new
  #
  # source://rdoc//lib/rdoc/any_method.rb#22
  def dont_rename_initialize; end

  # Don't rename \#initialize to \::new
  #
  # source://rdoc//lib/rdoc/any_method.rb#22
  def dont_rename_initialize=(_arg0); end

  # Whether the method has a call-seq.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/any_method.rb#121
  def has_call_seq?; end

  # Loads is_alias_for from the internal name.  Returns nil if the alias
  # cannot be found.
  #
  # source://rdoc//lib/rdoc/any_method.rb#129
  def is_alias_for; end

  # Dumps this AnyMethod for use by ri.  See also #marshal_load
  #
  # source://rdoc//lib/rdoc/any_method.rb#147
  def marshal_dump; end

  # Loads this AnyMethod from +array+.  For a loaded AnyMethod the following
  # methods will return cached values:
  #
  # * #full_name
  # * #parent_name
  #
  # source://rdoc//lib/rdoc/any_method.rb#184
  def marshal_load(array); end

  # Method name
  #
  # If the method has no assigned name, it extracts it from #call_seq.
  #
  # source://rdoc//lib/rdoc/any_method.rb#233
  def name; end

  # A list of this method's method and yield parameters.  +call-seq+ params
  # are preferred over parsed method and block params.
  #
  # source://rdoc//lib/rdoc/any_method.rb#246
  def param_list; end

  # Pretty parameter list for this method.  If the method's parameters were
  # given by +call-seq+ it is preferred over the parsed values.
  #
  # source://rdoc//lib/rdoc/any_method.rb#278
  def param_seq; end

  # Parameters for this method
  #
  # source://rdoc//lib/rdoc/any_method.rb#34
  def params; end

  # Parameters for this method
  #
  # source://rdoc//lib/rdoc/any_method.rb#34
  def params=(_arg0); end

  # The section title of the method (if defined in a C file via +:category:+)
  #
  # source://rdoc//lib/rdoc/any_method.rb#30
  def section_title; end

  # The section title of the method (if defined in a C file via +:category:+)
  #
  # source://rdoc//lib/rdoc/any_method.rb#30
  def section_title=(_arg0); end

  # Whether to skip the method description, true for methods that have
  # aliases with a call-seq that doesn't include the method name.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/any_method.rb#310
  def skip_description?; end

  # Sets the store for this method and its referenced code objects.
  #
  # source://rdoc//lib/rdoc/any_method.rb#317
  def store=(store); end

  # For methods that +super+, find the superclass method that would be called.
  #
  # source://rdoc//lib/rdoc/any_method.rb#326
  def superclass_method; end

  protected

  # call_seq without deduplication and alias lookup.
  #
  # source://rdoc//lib/rdoc/any_method.rb#345
  def _call_seq; end

  private

  # call_seq with alias examples information removed, if this
  # method is an alias method.
  #
  # source://rdoc//lib/rdoc/any_method.rb#355
  def deduplicate_call_seq(call_seq); end
end

# An attribute created by \#attr, \#attr_reader, \#attr_writer or
# \#attr_accessor
#
# source://rdoc//lib/rdoc/attr.rb#6
class RDoc::Attr < ::RDoc::MethodAttr
  # Creates a new Attr with body +text+, +name+, read/write status +rw+ and
  # +comment+.  +singleton+ marks this as a class attribute.
  #
  # @return [Attr] a new instance of Attr
  #
  # source://rdoc//lib/rdoc/attr.rb#25
  def initialize(text, name, rw, comment, singleton = T.unsafe(nil)); end

  # Attributes are equal when their names, singleton and rw are identical
  #
  # source://rdoc//lib/rdoc/attr.rb#36
  def ==(other); end

  # Add +an_alias+ as an attribute in +context+.
  #
  # source://rdoc//lib/rdoc/attr.rb#46
  def add_alias(an_alias, context); end

  # The #aref prefix for attributes
  #
  # source://rdoc//lib/rdoc/attr.rb#61
  def aref_prefix; end

  # Attributes never call super.  See RDoc::AnyMethod#calls_super
  #
  # An RDoc::Attr can show up in the method list in some situations (see
  # Gem::ConfigFile)
  #
  # source://rdoc//lib/rdoc/attr.rb#71
  def calls_super; end

  # Returns attr_reader, attr_writer or attr_accessor as appropriate.
  #
  # source://rdoc//lib/rdoc/attr.rb#78
  def definition; end

  # source://rdoc//lib/rdoc/attr.rb#86
  def inspect; end

  # Dumps this Attr for use by ri.  See also #marshal_load
  #
  # source://rdoc//lib/rdoc/attr.rb#102
  def marshal_dump; end

  # Loads this Attr from +array+.  For a loaded Attr the following
  # methods will return cached values:
  #
  # * #full_name
  # * #parent_name
  #
  # source://rdoc//lib/rdoc/attr.rb#124
  def marshal_load(array); end

  # source://rdoc//lib/rdoc/attr.rb#151
  def pretty_print(q); end

  # Is the attribute readable ('R'), writable ('W') or both ('RW')?
  #
  # source://rdoc//lib/rdoc/attr.rb#19
  def rw; end

  # Is the attribute readable ('R'), writable ('W') or both ('RW')?
  #
  # source://rdoc//lib/rdoc/attr.rb#19
  def rw=(_arg0); end

  # source://rdoc//lib/rdoc/attr.rb#162
  def to_s; end

  # Attributes do not have token streams.
  #
  # An RDoc::Attr can show up in the method list in some situations (see
  # Gem::ConfigFile)
  #
  # source://rdoc//lib/rdoc/attr.rb#172
  def token_stream; end
end

# ClassModule is the base class for objects representing either a class or a
# module.
#
# source://rdoc//lib/rdoc/class_module.rb#6
class RDoc::ClassModule < ::RDoc::Context
  # Creates a new ClassModule with +name+ with optional +superclass+
  #
  # This is a constructor for subclasses, and must never be called directly.
  #
  # @return [ClassModule] a new instance of ClassModule
  #
  # source://rdoc//lib/rdoc/class_module.rb#111
  def initialize(name, superclass = T.unsafe(nil)); end

  # Adds +comment+ to this ClassModule's list of comments at +location+.  This
  # method is preferred over #comment= since it allows ri data to be updated
  # across multiple runs.
  #
  # source://rdoc//lib/rdoc/class_module.rb#127
  def add_comment(comment, location); end

  # source://rdoc//lib/rdoc/class_module.rb#148
  def add_things(my_things, other_things); end

  # Ancestors list for this ClassModule: the list of included modules
  # (classes will add their superclass if any).
  #
  # Returns the included classes or modules, not the includes
  # themselves. The returned values are either String or
  # RDoc::NormalModule instances (see RDoc::Include#module).
  #
  # The values are returned in reverse order of their inclusion,
  # which is the order suitable for searching methods/attributes
  # in the ancestors. The superclass, if any, comes last.
  #
  # source://rdoc//lib/rdoc/class_module.rb#171
  def ancestors; end

  # HTML fragment reference for this module or class.  See
  # RDoc::NormalClass#aref and RDoc::NormalModule#aref
  #
  # source://rdoc//lib/rdoc/class_module.rb#183
  def aref; end

  # @raise [NotImplementedError]
  #
  # source://rdoc//lib/rdoc/class_module.rb#175
  def aref_prefix; end

  # Clears the comment. Used by the Ruby parser.
  #
  # source://rdoc//lib/rdoc/class_module.rb#195
  def clear_comment; end

  # This method is deprecated, use #add_comment instead.
  #
  # Appends +comment+ to the current comment, but separated by a rule.  Works
  # more like <tt>+=</tt>.
  #
  # source://rdoc//lib/rdoc/class_module.rb#205
  def comment=(comment); end

  # Comment and the location it came from.  Use #add_comment to add comments
  #
  # source://rdoc//lib/rdoc/class_module.rb#35
  def comment_location; end

  # Comment and the location it came from.  Use #add_comment to add comments
  #
  # source://rdoc//lib/rdoc/class_module.rb#35
  def comment_location=(_arg0); end

  # Prepares this ClassModule for use by a generator.
  #
  # See RDoc::Store#complete
  #
  # source://rdoc//lib/rdoc/class_module.rb#223
  def complete(min_visibility); end

  # Constants that are aliases for this class or module
  #
  # source://rdoc//lib/rdoc/class_module.rb#30
  def constant_aliases; end

  # Constants that are aliases for this class or module
  #
  # source://rdoc//lib/rdoc/class_module.rb#30
  def constant_aliases=(_arg0); end

  # Handy wrapper for marking up this class or module's comment
  #
  # source://rdoc//lib/rdoc/generator/markup.rb#131
  def description; end

  # source://rdoc//lib/rdoc/class_module.rb#37
  def diagram; end

  # source://rdoc//lib/rdoc/class_module.rb#37
  def diagram=(_arg0); end

  # Ancestors list for this ClassModule: the list of included modules
  # (classes will add their superclass if any).
  #
  # Returns the included classes or modules, not the includes
  # themselves. The returned values are either String or
  # RDoc::NormalModule instances (see RDoc::Include#module).
  #
  # The values are returned in reverse order of their inclusion,
  # which is the order suitable for searching methods/attributes
  # in the ancestors. The superclass, if any, comes last.
  #
  # Ancestors of this class or module only
  #
  # source://rdoc//lib/rdoc/class_module.rb#171
  def direct_ancestors; end

  # Does this ClassModule or any of its methods have document_self set?
  #
  # source://rdoc//lib/rdoc/class_module.rb#233
  def document_self_or_methods; end

  # Does this class or module have a comment with content or is
  # #received_nodoc true?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/class_module.rb#241
  def documented?; end

  # Iterates the ancestors of this class or module for which an
  # RDoc::ClassModule exists.
  #
  # source://rdoc//lib/rdoc/class_module.rb#251
  def each_ancestor; end

  # Looks for a symbol in the #ancestors. See Context#find_local_symbol.
  #
  # source://rdoc//lib/rdoc/class_module.rb#264
  def find_ancestor_local_symbol(symbol); end

  # Finds a class or module with +name+ in this namespace or its descendants
  #
  # source://rdoc//lib/rdoc/class_module.rb#276
  def find_class_named(name); end

  # Return the fully qualified name of this class or module
  #
  # source://rdoc//lib/rdoc/class_module.rb#289
  def full_name; end

  # Class or module this constant is an alias for
  #
  # source://rdoc//lib/rdoc/class_module.rb#42
  def is_alias_for; end

  # Class or module this constant is an alias for
  #
  # source://rdoc//lib/rdoc/class_module.rb#42
  def is_alias_for=(_arg0); end

  # TODO: filter included items by #display?
  #
  # source://rdoc//lib/rdoc/class_module.rb#300
  def marshal_dump; end

  # source://rdoc//lib/rdoc/class_module.rb#346
  def marshal_load(array); end

  # Merges +class_module+ into this ClassModule.
  #
  # The data in +class_module+ is preferred over the receiver.
  #
  # source://rdoc//lib/rdoc/class_module.rb#435
  def merge(class_module); end

  # Merges collection +mine+ with +other+ preferring other.  +other_files+ is
  # used to help determine which items should be deleted.
  #
  # Yields whether the item should be added or removed (true or false) and the
  # item to be added or removed.
  #
  #   merge_collections things, other.things, other.in_files do |add, thing|
  #     if add then
  #       # add the thing
  #     else
  #       # remove the thing
  #     end
  #   end
  #
  # source://rdoc//lib/rdoc/class_module.rb#519
  def merge_collections(mine, other, other_files, &block); end

  # Merges the comments in this ClassModule with the comments in the other
  # ClassModule +cm+.
  #
  # source://rdoc//lib/rdoc/class_module.rb#531
  def merge_sections(cm); end

  # Does this object represent a module?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/class_module.rb#570
  def module?; end

  # Allows overriding the initial name.
  #
  # Used for modules and classes that are constant aliases.
  #
  # source://rdoc//lib/rdoc/class_module.rb#579
  def name=(new_name); end

  # Name to use to generate the url:
  # modules and classes that are aliases for another
  # module or class return the name of the latter.
  #
  # source://rdoc//lib/rdoc/class_module.rb#622
  def name_for_path; end

  # Returns the classes and modules that are not constants
  # aliasing another class or module. For use by formatters
  # only (caches its result).
  #
  # source://rdoc//lib/rdoc/class_module.rb#631
  def non_aliases; end

  # Parses +comment_location+ into an RDoc::Markup::Document composed of
  # multiple RDoc::Markup::Documents with their file set.
  #
  # source://rdoc//lib/rdoc/class_module.rb#587
  def parse(comment_location); end

  # Path to this class or module for use with HTML generator output.
  #
  # source://rdoc//lib/rdoc/class_module.rb#613
  def path; end

  # Updates the child modules or classes of class/module +parent+ by
  # deleting the ones that have been removed from the documentation.
  #
  # +parent_hash+ is either <tt>parent.modules_hash</tt> or
  # <tt>parent.classes_hash</tt> and +all_hash+ is ::all_modules_hash or
  # ::all_classes_hash.
  #
  # source://rdoc//lib/rdoc/class_module.rb#643
  def remove_nodoc_children; end

  # source://rdoc//lib/rdoc/class_module.rb#657
  def remove_things(my_things, other_files); end

  # Search record used by RDoc::Generator::JsonIndex
  #
  # source://rdoc//lib/rdoc/class_module.rb#672
  def search_record; end

  # Sets the store for this class or module and its contained code objects.
  #
  # source://rdoc//lib/rdoc/class_module.rb#687
  def store=(store); end

  # Get the superclass of this class.  Attempts to retrieve the superclass
  # object, returns the name if it is not known.
  #
  # source://rdoc//lib/rdoc/class_module.rb#701
  def superclass; end

  # Set the superclass of this class to +superclass+
  #
  # @raise [NoMethodError]
  #
  # source://rdoc//lib/rdoc/class_module.rb#708
  def superclass=(superclass); end

  # source://rdoc//lib/rdoc/class_module.rb#713
  def to_s; end

  # 'module' or 'class'
  #
  # source://rdoc//lib/rdoc/class_module.rb#724
  def type; end

  # Updates the child modules & classes by replacing the ones that are
  # aliases through a constant.
  #
  # The aliased module/class is replaced in the children and in
  # RDoc::Store#modules_hash or RDoc::Store#classes_hash
  # by a copy that has <tt>RDoc::ClassModule#is_alias_for</tt> set to
  # the aliased module/class, and this copy is added to <tt>#aliases</tt>
  # of the aliased module/class.
  #
  # Formatters can use the #non_aliases method to retrieve children that
  # are not aliases, for instance to list the namespace content, since
  # the aliased modules are included in the constants of the class/module,
  # that are listed separately.
  #
  # source://rdoc//lib/rdoc/class_module.rb#743
  def update_aliases; end

  # Deletes from #extends those whose module has been removed from the
  # documentation.
  # --
  # FIXME: like update_includes, extends are not reliably removed
  #
  # source://rdoc//lib/rdoc/class_module.rb#791
  def update_extends; end

  # Deletes from #includes those whose module has been removed from the
  # documentation.
  # --
  # FIXME: includes are not reliably removed, see _possible_bug test case
  #
  # source://rdoc//lib/rdoc/class_module.rb#776
  def update_includes; end

  class << self
    # Return a RDoc::ClassModule of class +class_type+ that is a copy
    # of module +module+. Used to promote modules to classes.
    # --
    # TODO move to RDoc::NormalClass (I think)
    #
    # source://rdoc//lib/rdoc/class_module.rb#50
    def from_module(class_type, mod); end
  end
end

# Base class for the RDoc code tree.
#
# We contain the common stuff for contexts (which are containers) and other
# elements (methods, attributes and so on)
#
# Here's the tree of the CodeObject subclasses:
#
# * RDoc::Context
#   * RDoc::TopLevel
#   * RDoc::ClassModule
#     * RDoc::AnonClass (never used so far)
#     * RDoc::NormalClass
#     * RDoc::NormalModule
#     * RDoc::SingleClass
# * RDoc::MethodAttr
#   * RDoc::Attr
#   * RDoc::AnyMethod
#     * RDoc::GhostMethod
#     * RDoc::MetaMethod
# * RDoc::Alias
# * RDoc::Constant
# * RDoc::Mixin
#   * RDoc::Require
#   * RDoc::Include
#
# source://rdoc//lib/rdoc/code_object.rb#28
class RDoc::CodeObject
  include ::RDoc::Text
  include ::RDoc::Generator::Markup

  # Creates a new CodeObject that will document itself and its children
  #
  # @return [CodeObject] a new instance of CodeObject
  #
  # source://rdoc//lib/rdoc/code_object.rb#102
  def initialize; end

  # Our comment
  #
  # source://rdoc//lib/rdoc/code_object.rb#35
  def comment; end

  # Replaces our comment with +comment+, unless it is empty.
  #
  # source://rdoc//lib/rdoc/code_object.rb#135
  def comment=(comment); end

  # Should this CodeObject be displayed in output?
  #
  # A code object should be displayed if:
  #
  # * The item didn't have a nodoc or wasn't in a container that had nodoc
  # * The item wasn't ignored
  # * The item has documentation and was not suppressed
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/code_object.rb#163
  def display?; end

  # Do we document our children?
  #
  # source://rdoc//lib/rdoc/code_object.rb#40
  def document_children; end

  # Enables or disables documentation of this CodeObject's children unless it
  # has been turned off by :enddoc:
  #
  # source://rdoc//lib/rdoc/code_object.rb#172
  def document_children=(document_children); end

  # Do we document ourselves?
  #
  # source://rdoc//lib/rdoc/code_object.rb#45
  def document_self; end

  # Enables or disables documentation of this CodeObject unless it has been
  # turned off by :enddoc:.  If the argument is +nil+ it means the
  #
  # source://rdoc//lib/rdoc/code_object.rb#183
  def document_self=(document_self); end

  # Does this object have a comment with content or is #received_nodoc true?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/code_object.rb#194
  def documented?; end

  # Are we done documenting (ie, did we come across a :enddoc:)?
  #
  # source://rdoc//lib/rdoc/code_object.rb#50
  def done_documenting; end

  # Turns documentation on/off, and turns on/off #document_self
  # and #document_children.
  #
  # Once documentation has been turned off (by +:enddoc:+),
  # the object will refuse to turn #document_self or
  # will have no effect in the current file.
  #
  # source://rdoc//lib/rdoc/code_object.rb#207
  def done_documenting=(value); end

  # Yields each parent of this CodeObject.  See also
  # RDoc::ClassModule#each_ancestor
  #
  # source://rdoc//lib/rdoc/code_object.rb#218
  def each_parent; end

  # Which file this code object was defined in
  #
  # source://rdoc//lib/rdoc/code_object.rb#55
  def file; end

  # File name where this CodeObject was found.
  #
  # See also RDoc::Context#in_files
  #
  # source://rdoc//lib/rdoc/code_object.rb#233
  def file_name; end

  # Force documentation of this CodeObject
  #
  # source://rdoc//lib/rdoc/code_object.rb#60
  def force_documentation; end

  # Force the documentation of this object unless documentation
  # has been turned off by :enddoc:
  # --
  # HACK untested, was assigning to an ivar
  #
  # source://rdoc//lib/rdoc/code_object.rb#245
  def force_documentation=(value); end

  # Sets the full_name overriding any computed full name.
  #
  # Set to +nil+ to clear RDoc's cached value
  #
  # source://rdoc//lib/rdoc/code_object.rb#254
  def full_name=(full_name); end

  # Use this to ignore a CodeObject and all its children until found again
  # (#record_location is called).  An ignored item will not be displayed in
  # documentation.
  #
  # See github issue #55
  #
  # The ignored status is temporary in order to allow implementation details
  # to be hidden.  At the end of processing a file RDoc allows all classes
  # and modules to add new documentation to previously created classes.
  #
  # If a class was ignored (via stopdoc) then reopened later with additional
  # documentation it should be displayed.  If a class was ignored and never
  # reopened it should not be displayed.  The ignore flag allows this to
  # occur.
  #
  # source://rdoc//lib/rdoc/code_object.rb#274
  def ignore; end

  # Has this class been ignored?
  #
  # See also #ignore
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/code_object.rb#287
  def ignored?; end

  # Initializes state for visibility of this CodeObject and its children.
  #
  # source://rdoc//lib/rdoc/code_object.rb#121
  def initialize_visibility; end

  # Line in #file where this CodeObject was defined
  #
  # source://rdoc//lib/rdoc/code_object.rb#65
  def line; end

  # Line in #file where this CodeObject was defined
  #
  # source://rdoc//lib/rdoc/code_object.rb#65
  def line=(_arg0); end

  # Hash of arbitrary metadata for this CodeObject
  #
  # source://rdoc//lib/rdoc/code_object.rb#70
  def metadata; end

  # The options instance from the store this CodeObject is attached to, or a
  # default options instance if the CodeObject is not attached.
  #
  # This is used by Text#snippet
  #
  # source://rdoc//lib/rdoc/code_object.rb#297
  def options; end

  # Our parent CodeObject.  The parent may be missing for classes loaded from
  # legacy RI data stores.
  #
  # source://rdoc//lib/rdoc/code_object.rb#309
  def parent; end

  # Sets the parent CodeObject
  #
  # source://rdoc//lib/rdoc/code_object.rb#75
  def parent=(_arg0); end

  # File name of our parent
  #
  # source://rdoc//lib/rdoc/code_object.rb#331
  def parent_file_name; end

  # Name of our parent
  #
  # source://rdoc//lib/rdoc/code_object.rb#338
  def parent_name; end

  # source://rdoc//lib/rdoc/code_object.rb#80
  def received_nodoc; end

  # Records the RDoc::TopLevel (file) where this code object was defined
  #
  # source://rdoc//lib/rdoc/code_object.rb#345
  def record_location(top_level); end

  # The section this CodeObject is in.  Sections allow grouping of constants,
  # attributes and methods inside a class or module.
  #
  # source://rdoc//lib/rdoc/code_object.rb#355
  def section; end

  # Set the section this CodeObject is in
  #
  # source://rdoc//lib/rdoc/code_object.rb#85
  def section=(_arg0); end

  # Enable capture of documentation unless documentation has been
  # turned off by :enddoc:
  #
  # source://rdoc//lib/rdoc/code_object.rb#365
  def start_doc; end

  # Disable capture of documentation
  #
  # source://rdoc//lib/rdoc/code_object.rb#377
  def stop_doc; end

  # The RDoc::Store for this object.
  #
  # source://rdoc//lib/rdoc/code_object.rb#90
  def store; end

  # Sets the +store+ that contains this CodeObject
  #
  # source://rdoc//lib/rdoc/code_object.rb#387
  def store=(store); end

  # Use this to suppress a CodeObject and all its children until the next file
  # it is seen in or documentation is discovered.  A suppressed item with
  # documentation will be displayed while an ignored item with documentation
  # may not be displayed.
  #
  # source://rdoc//lib/rdoc/code_object.rb#404
  def suppress; end

  # Has this class been suppressed?
  #
  # See also #suppress
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/code_object.rb#417
  def suppressed?; end

  # We are the model of the code, but we know that at some point we will be
  # worked on by viewers. By implementing the Viewable protocol, viewers can
  # associated themselves with these objects.
  #
  # source://rdoc//lib/rdoc/code_object.rb#97
  def viewer; end

  # We are the model of the code, but we know that at some point we will be
  # worked on by viewers. By implementing the Viewable protocol, viewers can
  # associated themselves with these objects.
  #
  # source://rdoc//lib/rdoc/code_object.rb#97
  def viewer=(_arg0); end
end

# source://rdoc//lib/rdoc/comment.rb#12
class RDoc::Comment
  include ::RDoc::Text

  # Creates a new comment with +text+ that is found in the RDoc::TopLevel
  # +location+.
  #
  # @return [Comment] a new instance of Comment
  #
  # source://rdoc//lib/rdoc/comment.rb#56
  def initialize(text = T.unsafe(nil), location = T.unsafe(nil), language = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/comment.rb#74
  def ==(other); end

  # Overrides the content returned by #parse.  Use when there is no #text
  # source for this comment
  #
  # source://rdoc//lib/rdoc/comment.rb#50
  def document=(_arg0); end

  # A comment is empty if its text String is empty.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/comment.rb#128
  def empty?; end

  # HACK dubious
  #
  # source://rdoc//lib/rdoc/comment.rb#135
  def encode!(encoding); end

  # Look for a 'call-seq' in the comment to override the normal parameter
  # handling.  The :call-seq: is indented from the baseline.  All lines of the
  # same indentation level and prefix are consumed.
  #
  # For example, all of the following will be used as the :call-seq:
  #
  #   # :call-seq:
  #   #   ARGF.readlines(sep=$/)     -> array
  #   #   ARGF.readlines(limit)      -> array
  #   #   ARGF.readlines(sep, limit) -> array
  #   #
  #   #   ARGF.to_a(sep=$/)     -> array
  #   #   ARGF.to_a(limit)      -> array
  #   #   ARGF.to_a(sep, limit) -> array
  #
  # source://rdoc//lib/rdoc/comment.rb#95
  def extract_call_seq(method); end

  # The RDoc::TopLevel this comment was found in
  #
  # For duck-typing when merging classes at load time
  #
  # source://rdoc//lib/rdoc/comment.rb#24
  def file; end

  # The format of this comment.  Defaults to RDoc::Markup
  #
  # source://rdoc//lib/rdoc/comment.rb#19
  def format; end

  # Sets the format of this comment and resets any parsed document
  #
  # source://rdoc//lib/rdoc/comment.rb#143
  def format=(format); end

  # source://rdoc//lib/rdoc/comment.rb#148
  def inspect; end

  # Line where this Comment was written
  #
  # source://rdoc//lib/rdoc/comment.rb#29
  def line; end

  # Line where this Comment was written
  #
  # source://rdoc//lib/rdoc/comment.rb#29
  def line=(_arg0); end

  # The RDoc::TopLevel this comment was found in
  #
  # source://rdoc//lib/rdoc/comment.rb#24
  def location; end

  # The RDoc::TopLevel this comment was found in
  #
  # source://rdoc//lib/rdoc/comment.rb#24
  def location=(_arg0); end

  # Normalizes the text.  See RDoc::Text#normalize_comment for details
  #
  # source://rdoc//lib/rdoc/comment.rb#157
  def normalize; end

  # Was this text normalized?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/comment.rb#171
  def normalized?; end

  # Parses the comment into an RDoc::Markup::Document.  The parsed document is
  # cached until the text is changed.
  #
  # source://rdoc//lib/rdoc/comment.rb#179
  def parse; end

  # Removes private sections from this comment.  Private sections are flush to
  # the comment marker and start with <tt>--</tt> and end with <tt>++</tt>.
  # For C-style comments, a private marker may not start at the opening of the
  # comment.
  #
  #   /*
  #    *--
  #    * private
  #    *++
  #    * public
  #    */
  #
  # source://rdoc//lib/rdoc/comment.rb#200
  def remove_private; end

  # The text for this comment
  #
  # source://rdoc//lib/rdoc/comment.rb#39
  def text; end

  # Replaces this comment's text with +text+ and resets the parsed document.
  #
  # An error is raised if the comment contains a document but no text.
  #
  # @raise [RDoc::Error]
  #
  # source://rdoc//lib/rdoc/comment.rb#214
  def text=(text); end

  # The text for this comment
  #
  # Alias for text
  #
  # source://rdoc//lib/rdoc/comment.rb#39
  def to_s; end

  # Returns true if this comment is in TomDoc format.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/comment.rb#225
  def tomdoc?; end

  private

  # --
  # TODO deep copy @document
  #
  # source://rdoc//lib/rdoc/comment.rb#70
  def initialize_copy(copy); end
end

# A constant
#
# source://rdoc//lib/rdoc/constant.rb#5
class RDoc::Constant < ::RDoc::CodeObject
  # Creates a new constant with +name+, +value+ and +comment+
  #
  # @return [Constant] a new instance of Constant
  #
  # source://rdoc//lib/rdoc/constant.rb#32
  def initialize(name, value, comment); end

  # Constants are ordered by name
  #
  # source://rdoc//lib/rdoc/constant.rb#47
  def <=>(other); end

  # Constants are equal when their #parent and #name is the same
  #
  # source://rdoc//lib/rdoc/constant.rb#56
  def ==(other); end

  # A constant is documented if it has a comment, or is an alias
  # for a documented class or module.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/constant.rb#66
  def documented?; end

  # Full constant name including namespace
  #
  # source://rdoc//lib/rdoc/constant.rb#81
  def full_name; end

  # source://rdoc//lib/rdoc/constant.rb#99
  def inspect; end

  # The module or class this constant is an alias for
  #
  # source://rdoc//lib/rdoc/constant.rb#88
  def is_alias_for; end

  # Sets the module or class this is constant is an alias for.
  #
  # source://rdoc//lib/rdoc/constant.rb#12
  def is_alias_for=(_arg0); end

  # Dumps this Constant for use by ri.  See also #marshal_load
  #
  # source://rdoc//lib/rdoc/constant.rb#109
  def marshal_dump; end

  # Loads this Constant from +array+.  For a loaded Constant the following
  # methods will return cached values:
  #
  # * #full_name
  # * #parent_name
  #
  # source://rdoc//lib/rdoc/constant.rb#135
  def marshal_load(array); end

  # The constant's name
  #
  # source://rdoc//lib/rdoc/constant.rb#17
  def name; end

  # The constant's name
  #
  # source://rdoc//lib/rdoc/constant.rb#17
  def name=(_arg0); end

  # Path to this constant for use with HTML generator output.
  #
  # source://rdoc//lib/rdoc/constant.rb#153
  def path; end

  # source://rdoc//lib/rdoc/constant.rb#157
  def pretty_print(q); end

  # Sets the store for this class or module and its contained code objects.
  #
  # source://rdoc//lib/rdoc/constant.rb#171
  def store=(store); end

  # source://rdoc//lib/rdoc/constant.rb#177
  def to_s; end

  # The constant's value
  #
  # source://rdoc//lib/rdoc/constant.rb#22
  def value; end

  # The constant's value
  #
  # source://rdoc//lib/rdoc/constant.rb#22
  def value=(_arg0); end

  # The constant's visibility
  #
  # source://rdoc//lib/rdoc/constant.rb#27
  def visibility; end

  # The constant's visibility
  #
  # source://rdoc//lib/rdoc/constant.rb#27
  def visibility=(_arg0); end
end

# A Context is something that can hold modules, classes, methods, attributes,
# aliases, requires, and includes. Classes, modules, and files are all
# Contexts.
#
# source://rdoc//lib/rdoc/context.rb#7
class RDoc::Context < ::RDoc::CodeObject
  include ::Comparable

  # Creates an unnamed empty context with public current visibility
  #
  # @return [Context] a new instance of Context
  #
  # source://rdoc//lib/rdoc/context.rb#123
  def initialize; end

  # Contexts are sorted by full_name
  #
  # source://rdoc//lib/rdoc/context.rb#171
  def <=>(other); end

  # Adds an item of type +klass+ with the given +name+ and +comment+ to the
  # context.
  #
  # Currently only RDoc::Extend and RDoc::Include are supported.
  #
  # source://rdoc//lib/rdoc/context.rb#183
  def add(klass, name, comment); end

  # Adds +an_alias+ that is automatically resolved
  #
  # source://rdoc//lib/rdoc/context.rb#198
  def add_alias(an_alias); end

  # Adds +attribute+ if not already there. If it is (as method(s) or attribute),
  # updates the comment if it was empty.
  #
  # The attribute is registered only if it defines a new method.
  # For instance, <tt>attr_reader :foo</tt> will not be registered
  # if method +foo+ exists, but <tt>attr_accessor :foo</tt> will be registered
  # if method +foo+ exists, but <tt>foo=</tt> does not.
  #
  # source://rdoc//lib/rdoc/context.rb#225
  def add_attribute(attribute); end

  # Adds a class named +given_name+ with +superclass+.
  #
  # Both +given_name+ and +superclass+ may contain '::', and are
  # interpreted relative to the +self+ context. This allows handling correctly
  # examples like these:
  #   class RDoc::Gauntlet < Gauntlet
  #   module Mod
  #     class Object   # implies < ::Object
  #     class SubObject < Object  # this is _not_ ::Object
  #
  # Given <tt>class Container::Item</tt> RDoc assumes +Container+ is a module
  # unless it later sees <tt>class Container</tt>.  +add_class+ automatically
  # upgrades +given_name+ to a class in this case.
  #
  # source://rdoc//lib/rdoc/context.rb#288
  def add_class(class_type, given_name, superclass = T.unsafe(nil)); end

  # Adds the class or module +mod+ to the modules or
  # classes Hash +self_hash+, and to +all_hash+ (either
  # <tt>TopLevel::modules_hash</tt> or <tt>TopLevel::classes_hash</tt>),
  # unless #done_documenting is +true+. Sets the #parent of +mod+
  # to +self+, and its #section to #current_section. Returns +mod+.
  #
  # source://rdoc//lib/rdoc/context.rb#404
  def add_class_or_module(mod, self_hash, all_hash); end

  # Adds +constant+ if not already there. If it is, updates the comment,
  # value and/or is_alias_for of the known constant if they were empty/nil.
  #
  # source://rdoc//lib/rdoc/context.rb#429
  def add_constant(constant); end

  # Adds extension module +ext+ which should be an RDoc::Extend
  #
  # source://rdoc//lib/rdoc/context.rb#463
  def add_extend(ext); end

  # Adds included module +include+ which should be an RDoc::Include
  #
  # source://rdoc//lib/rdoc/context.rb#454
  def add_include(include); end

  # Adds +method+ if not already there. If it is (as method or attribute),
  # updates the comment if it was empty.
  #
  # source://rdoc//lib/rdoc/context.rb#473
  def add_method(method); end

  # Adds a module named +name+.  If RDoc already knows +name+ is a class then
  # that class is returned instead.  See also #add_class.
  #
  # source://rdoc//lib/rdoc/context.rb#506
  def add_module(class_type, name); end

  # Adds an alias from +from+ (a class or module) to +name+ which was defined
  # in +file+.
  #
  # source://rdoc//lib/rdoc/context.rb#527
  def add_module_alias(from, from_name, to, file); end

  # Adds a module by +RDoc::NormalModule+ instance. See also #add_module.
  #
  # source://rdoc//lib/rdoc/context.rb#519
  def add_module_by_normal_module(mod); end

  # Adds +require+ to this context's top level
  #
  # source://rdoc//lib/rdoc/context.rb#568
  def add_require(require); end

  # Returns a section with +title+, creating it if it doesn't already exist.
  # +comment+ will be appended to the section's comment.
  #
  # A section with a +title+ of +nil+ will return the default section.
  #
  # See also RDoc::Context::Section
  #
  # source://rdoc//lib/rdoc/context.rb#586
  def add_section(title, comment = T.unsafe(nil)); end

  # Adds +thing+ to the collection +array+
  #
  # source://rdoc//lib/rdoc/context.rb#600
  def add_to(array, thing); end

  # Class/module aliases
  #
  # source://rdoc//lib/rdoc/context.rb#25
  def aliases; end

  # Is there any content?
  #
  # This means any of: comment, aliases, methods, attributes, external
  # aliases, require, constant.
  #
  # Includes and extends are also checked unless <tt>includes == false</tt>.
  #
  # source://rdoc//lib/rdoc/context.rb#616
  def any_content(includes = T.unsafe(nil)); end

  # All attr* methods
  #
  # source://rdoc//lib/rdoc/context.rb#30
  def attributes; end

  # Block params to be used in the next MethodAttr parsed under this context
  #
  # source://rdoc//lib/rdoc/context.rb#35
  def block_params; end

  # Block params to be used in the next MethodAttr parsed under this context
  #
  # source://rdoc//lib/rdoc/context.rb#35
  def block_params=(_arg0); end

  # Creates the full name for a child with +name+
  #
  # source://rdoc//lib/rdoc/context.rb#632
  def child_name(name); end

  # Class attributes
  #
  # source://rdoc//lib/rdoc/context.rb#645
  def class_attributes; end

  # Class methods
  #
  # source://rdoc//lib/rdoc/context.rb#652
  def class_method_list; end

  # Array of classes in this context
  #
  # source://rdoc//lib/rdoc/context.rb#659
  def classes; end

  # All classes and modules in this namespace
  #
  # source://rdoc//lib/rdoc/context.rb#666
  def classes_and_modules; end

  # Hash of classes keyed by class name
  #
  # source://rdoc//lib/rdoc/context.rb#673
  def classes_hash; end

  # Constants defined
  #
  # source://rdoc//lib/rdoc/context.rb#40
  def constants; end

  # Hash of registered constants.
  #
  # source://rdoc//lib/rdoc/context.rb#118
  def constants_hash; end

  # Current visibility of this line
  #
  # source://rdoc//lib/rdoc/context.rb#102
  def current_line_visibility=(_arg0); end

  # The current documentation section that new items will be added to.  If
  # temporary_section is available it will be used.
  #
  # source://rdoc//lib/rdoc/context.rb#681
  def current_section; end

  # Sets the current documentation section of documentation
  #
  # source://rdoc//lib/rdoc/context.rb#45
  def current_section=(_arg0); end

  # Is part of this thing was defined in +file+?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/context.rb#694
  def defined_in?(file); end

  # source://rdoc//lib/rdoc/context.rb#698
  def display(method_attr); end

  # Iterator for ancestors for duck-typing.  Does nothing.  See
  # RDoc::ClassModule#each_ancestor.
  #
  # This method exists to make it easy to work with Context subclasses that
  # aren't part of RDoc.
  #
  # source://rdoc//lib/rdoc/context.rb#713
  def each_ancestor(&_); end

  # Iterator for attributes
  #
  # source://rdoc//lib/rdoc/context.rb#719
  def each_attribute; end

  # Iterator for classes and modules
  #
  # source://rdoc//lib/rdoc/context.rb#726
  def each_classmodule(&block); end

  # Iterator for constants
  #
  # source://rdoc//lib/rdoc/context.rb#733
  def each_constant; end

  # Iterator for extension modules
  #
  # source://rdoc//lib/rdoc/context.rb#747
  def each_extend; end

  # Iterator for included modules
  #
  # source://rdoc//lib/rdoc/context.rb#740
  def each_include; end

  # Iterator for methods
  #
  # source://rdoc//lib/rdoc/context.rb#754
  def each_method; end

  # Iterator for each section's contents sorted by title.  The +section+, the
  # section's +constants+ and the sections +attributes+ are yielded.  The
  # +constants+ and +attributes+ collections are sorted.
  #
  # To retrieve methods in a section use #methods_by_type with the optional
  # +section+ parameter.
  #
  # NOTE: Do not edit collections yielded by this method
  #
  # source://rdoc//lib/rdoc/context.rb#770
  def each_section; end

  # Modules this context is extended with
  #
  # source://rdoc//lib/rdoc/context.rb#60
  def extends; end

  # Aliases that could not be resolved.
  #
  # source://rdoc//lib/rdoc/context.rb#92
  def external_aliases; end

  # Finds an attribute +name+ with singleton value +singleton+.
  #
  # source://rdoc//lib/rdoc/context.rb#787
  def find_attribute(name, singleton); end

  # Finds an attribute with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#795
  def find_attribute_named(name); end

  # Finds a class method with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#809
  def find_class_method_named(name); end

  # Finds a constant with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#816
  def find_constant_named(name); end

  # Find a module at a higher scope
  #
  # source://rdoc//lib/rdoc/context.rb#825
  def find_enclosing_module_named(name); end

  # Finds an external alias +name+ with singleton value +singleton+.
  #
  # source://rdoc//lib/rdoc/context.rb#832
  def find_external_alias(name, singleton); end

  # Finds an external alias with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#839
  def find_external_alias_named(name); end

  # Finds a file with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#853
  def find_file_named(name); end

  # Finds an instance method with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#860
  def find_instance_method_named(name); end

  # Finds a method, constant, attribute, external alias, module or file
  # named +symbol+ in this context.
  #
  # source://rdoc//lib/rdoc/context.rb#868
  def find_local_symbol(symbol); end

  # Finds a method named +name+ with singleton value +singleton+.
  #
  # source://rdoc//lib/rdoc/context.rb#880
  def find_method(name, singleton); end

  # Finds a instance or module method with +name+ in this context
  #
  # source://rdoc//lib/rdoc/context.rb#893
  def find_method_named(name); end

  # Find a module with +name+ using ruby's scoping rules
  #
  # source://rdoc//lib/rdoc/context.rb#907
  def find_module_named(name); end

  # Look up +symbol+, first as a module, then as a local symbol.
  #
  # source://rdoc//lib/rdoc/context.rb#917
  def find_symbol(symbol); end

  # Look up a module named +symbol+.
  #
  # source://rdoc//lib/rdoc/context.rb#924
  def find_symbol_module(symbol); end

  # The full name for this context.  This method is overridden by subclasses.
  #
  # source://rdoc//lib/rdoc/context.rb#957
  def full_name; end

  # Does this context and its methods and constants all have documentation?
  #
  # (Yes, fully documented doesn't mean everything.)
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/context.rb#966
  def fully_documented?; end

  # URL for this with a +prefix+
  #
  # source://rdoc//lib/rdoc/context.rb#976
  def http_url(prefix); end

  # Files this context is found in
  #
  # source://rdoc//lib/rdoc/context.rb#50
  def in_files; end

  # Modules this context includes
  #
  # source://rdoc//lib/rdoc/context.rb#55
  def includes; end

  # Sets the defaults for methods and so-forth
  #
  # source://rdoc//lib/rdoc/context.rb#145
  def initialize_methods_etc; end

  # Instance attributes
  #
  # source://rdoc//lib/rdoc/context.rb#987
  def instance_attributes; end

  # Instance methods
  # --
  # TODO remove this later
  #
  # source://rdoc//lib/rdoc/context.rb#1003
  def instance_method_list; end

  # Instance methods
  #
  # source://rdoc//lib/rdoc/context.rb#994
  def instance_methods; end

  # Methods defined in this context
  #
  # source://rdoc//lib/rdoc/context.rb#65
  def method_list; end

  # Breaks method_list into a nested hash by type (<tt>'class'</tt> or
  # <tt>'instance'</tt>) and visibility (+:public+, +:protected+, +:private+).
  #
  # If +section+ is provided only methods in that RDoc::Context::Section will
  # be returned.
  #
  # source://rdoc//lib/rdoc/context.rb#1015
  def methods_by_type(section = T.unsafe(nil)); end

  # Hash of registered methods. Attributes are also registered here,
  # twice if they are RW.
  #
  # source://rdoc//lib/rdoc/context.rb#108
  def methods_hash; end

  # Yields AnyMethod and Attr entries matching the list of names in +methods+.
  #
  # source://rdoc//lib/rdoc/context.rb#1038
  def methods_matching(methods, singleton = T.unsafe(nil), &block); end

  # Array of modules in this context
  #
  # source://rdoc//lib/rdoc/context.rb#1051
  def modules; end

  # Hash of modules keyed by module name
  #
  # source://rdoc//lib/rdoc/context.rb#1058
  def modules_hash; end

  # Name of this class excluding namespace.  See also full_name
  #
  # source://rdoc//lib/rdoc/context.rb#70
  def name; end

  # Name to use to generate the url.
  # <tt>#full_name</tt> by default.
  #
  # source://rdoc//lib/rdoc/context.rb#1066
  def name_for_path; end

  # Changes the visibility for new methods to +visibility+
  #
  # source://rdoc//lib/rdoc/context.rb#1073
  def ongoing_visibility=(visibility); end

  # Params to be used in the next MethodAttr parsed under this context
  #
  # source://rdoc//lib/rdoc/context.rb#113
  def params; end

  # Params to be used in the next MethodAttr parsed under this context
  #
  # source://rdoc//lib/rdoc/context.rb#113
  def params=(_arg0); end

  # Record +top_level+ as a file +self+ is in.
  #
  # source://rdoc//lib/rdoc/context.rb#1080
  def record_location(top_level); end

  # Should we remove this context from the documentation?
  #
  # The answer is yes if:
  # * #received_nodoc is +true+
  # * #any_content is +false+ (not counting includes)
  # * All #includes are modules (not a string), and their module has
  #   <tt>#remove_from_documentation? == true</tt>
  # * All classes and modules have <tt>#remove_from_documentation? == true</tt>
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/context.rb#1094
  def remove_from_documentation?; end

  # Removes methods and attributes with a visibility less than +min_visibility+.
  # --
  # TODO mark the visibility of attributes in the template (if not public?)
  #
  # source://rdoc//lib/rdoc/context.rb#1107
  def remove_invisible(min_visibility); end

  # Only called when min_visibility == :public or :private
  #
  # source://rdoc//lib/rdoc/context.rb#1117
  def remove_invisible_in(array, min_visibility); end

  # Files this context requires
  #
  # source://rdoc//lib/rdoc/context.rb#75
  def requires; end

  # Tries to resolve unmatched aliases when a method or attribute has just
  # been added.
  #
  # source://rdoc//lib/rdoc/context.rb#1133
  def resolve_aliases(added); end

  # Returns RDoc::Context::Section objects referenced in this context for use
  # in a table of contents.
  #
  # source://rdoc//lib/rdoc/context.rb#1149
  def section_contents; end

  # Sections in this context
  #
  # source://rdoc//lib/rdoc/context.rb#1173
  def sections; end

  # source://rdoc//lib/rdoc/context.rb#1177
  def sections_hash; end

  # Given an array +names+ of constants, set the visibility of each constant to
  # +visibility+
  #
  # source://rdoc//lib/rdoc/context.rb#1202
  def set_constant_visibility_for(names, visibility); end

  # Sets the current section to a section with +title+.  See also #add_section
  #
  # source://rdoc//lib/rdoc/context.rb#1184
  def set_current_section(title, comment); end

  # Given an array +methods+ of method names, set the visibility of each to
  # +visibility+
  #
  # source://rdoc//lib/rdoc/context.rb#1192
  def set_visibility_for(methods, visibility, singleton = T.unsafe(nil)); end

  # Sorts sections alphabetically (default) or in TomDoc fashion (none,
  # Public, Internal, Deprecated)
  #
  # source://rdoc//lib/rdoc/context.rb#1213
  def sort_sections; end

  # Use this section for the next method, attribute or constant added.
  #
  # source://rdoc//lib/rdoc/context.rb#80
  def temporary_section; end

  # Use this section for the next method, attribute or constant added.
  #
  # source://rdoc//lib/rdoc/context.rb#80
  def temporary_section=(_arg0); end

  # source://rdoc//lib/rdoc/context.rb#1229
  def to_s; end

  # Return the TopLevel that owns us
  # --
  # FIXME we can be 'owned' by several TopLevel (see #record_location &
  # #in_files)
  #
  # source://rdoc//lib/rdoc/context.rb#1239
  def top_level; end

  # Hash <tt>old_name => [aliases]</tt>, for aliases
  # that haven't (yet) been resolved to a method/attribute.
  # (Not to be confused with the aliases of the context.)
  #
  # source://rdoc//lib/rdoc/context.rb#87
  def unmatched_alias_lists; end

  # Hash <tt>old_name => [aliases]</tt>, for aliases
  # that haven't (yet) been resolved to a method/attribute.
  # (Not to be confused with the aliases of the context.)
  #
  # source://rdoc//lib/rdoc/context.rb#87
  def unmatched_alias_lists=(_arg0); end

  # Upgrades NormalModule +mod+ in +enclosing+ to a +class_type+
  #
  # source://rdoc//lib/rdoc/context.rb#1249
  def upgrade_to_class(mod, class_type, enclosing); end

  # Current visibility of this context
  #
  # source://rdoc//lib/rdoc/context.rb#97
  def visibility; end

  # Current visibility of this context
  #
  # source://rdoc//lib/rdoc/context.rb#97
  def visibility=(_arg0); end
end

# A section of documentation like:
#
#   # :section: The title
#   # The body
#
# Sections can be referenced multiple times and will be collapsed into a
# single section.
#
# source://rdoc//lib/rdoc/context/section.rb#13
class RDoc::Context::Section
  include ::RDoc::Text
  include ::RDoc::Generator::Markup

  # Creates a new section with +title+ and +comment+
  #
  # @return [Section] a new instance of Section
  #
  # source://rdoc//lib/rdoc/context/section.rb#42
  def initialize(parent, title, comment); end

  # Sections are equal when they have the same #title
  #
  # source://rdoc//lib/rdoc/context/section.rb#54
  def ==(other); end

  # Adds +comment+ to this section
  #
  # source://rdoc//lib/rdoc/context/section.rb#63
  def add_comment(comment); end

  # Anchor reference for linking to this section
  #
  # source://rdoc//lib/rdoc/context/section.rb#83
  def aref; end

  # Section comment
  #
  # source://rdoc//lib/rdoc/context/section.rb#22
  def comment; end

  # Section comments
  #
  # source://rdoc//lib/rdoc/context/section.rb#27
  def comments; end

  # Sections are equal when they have the same #title
  #
  # source://rdoc//lib/rdoc/context/section.rb#54
  def eql?(other); end

  # Extracts the comment for this section from the original comment block.
  # If the first line contains :section:, strip it and use the rest.
  # Otherwise remove lines up to the line containing :section:, and look
  # for those lines again at the end and remove them. This lets us write
  #
  #   # :section: The title
  #   # The body
  #
  # source://rdoc//lib/rdoc/context/section.rb#98
  def extract_comment(comment); end

  # source://rdoc//lib/rdoc/context/section.rb#130
  def hash; end

  # The files comments in this section come from
  #
  # source://rdoc//lib/rdoc/context/section.rb#137
  def in_files; end

  # source://rdoc//lib/rdoc/context/section.rb#126
  def inspect; end

  # Serializes this Section.  The title and parsed comment are saved, but not
  # the section parent which must be restored manually.
  #
  # source://rdoc//lib/rdoc/context/section.rb#158
  def marshal_dump; end

  # De-serializes this Section.  The section parent must be restored manually.
  #
  # source://rdoc//lib/rdoc/context/section.rb#169
  def marshal_load(array); end

  # Context this Section lives in
  #
  # source://rdoc//lib/rdoc/context/section.rb#32
  def parent; end

  # Parses +comment_location+ into an RDoc::Markup::Document composed of
  # multiple RDoc::Markup::Documents with their file set.
  #
  # source://rdoc//lib/rdoc/context/section.rb#180
  def parse; end

  # The section's title, or 'Top Section' if the title is nil.
  #
  # This is used by the table of contents template so the name is silly.
  #
  # source://rdoc//lib/rdoc/context/section.rb#208
  def plain_html; end

  # Removes a comment from this section if it is from the same file as
  # +comment+
  #
  # source://rdoc//lib/rdoc/context/section.rb#216
  def remove_comment(comment); end

  # Section title
  #
  # source://rdoc//lib/rdoc/context/section.rb#37
  def title; end
end

# RDoc::CrossReference is a reusable way to create cross references for names.
#
# source://rdoc//lib/rdoc/cross_reference.rb#8
class RDoc::CrossReference
  # Allows cross-references to be created based on the given +context+
  # (RDoc::Context).
  #
  # @return [CrossReference] a new instance of CrossReference
  #
  # source://rdoc//lib/rdoc/cross_reference.rb#127
  def initialize(context); end

  # Returns a reference to +name+.
  #
  # If the reference is found and +name+ is not documented +text+ will be
  # returned.  If +name+ is escaped +name+ is returned.  If +name+ is not
  # found +text+ is returned.
  #
  # source://rdoc//lib/rdoc/cross_reference.rb#190
  def resolve(name, text); end

  # Returns a method reference to +name+.
  #
  # source://rdoc//lib/rdoc/cross_reference.rb#137
  def resolve_method(name); end

  # Hash of references that have been looked-up to their replacements
  #
  # source://rdoc//lib/rdoc/cross_reference.rb#121
  def seen; end

  # Hash of references that have been looked-up to their replacements
  #
  # source://rdoc//lib/rdoc/cross_reference.rb#121
  def seen=(_arg0); end
end

# Regular expression to match method arguments.
#
# source://rdoc//lib/rdoc/cross_reference.rb#28
RDoc::CrossReference::METHOD_ARGS_REGEXP_STR = T.let(T.unsafe(nil), String)

# Regular expression to match a single method argument.
#
# source://rdoc//lib/rdoc/cross_reference.rb#23
RDoc::CrossReference::METHOD_ARG_REGEXP_STR = T.let(T.unsafe(nil), String)

# A subclass of ERB that writes directly to an IO.  Credit to Aaron Patterson
# and Masatoshi SEKI.
#
# To use:
#
#   erbio = RDoc::ERBIO.new '<%= "hello world" %>', nil, nil
#
#   File.open 'hello.txt', 'w' do |io|
#     erbio.result binding
#   end
#
# Note that binding must enclose the io you wish to output on.
#
# source://rdoc//lib/rdoc/erbio.rb#18
class RDoc::ERBIO < ::ERB
  # Defaults +eoutvar+ to 'io', otherwise is identical to ERB's initialize
  #
  # @return [ERBIO] a new instance of ERBIO
  #
  # source://rdoc//lib/rdoc/erbio.rb#23
  def initialize(str, trim_mode: T.unsafe(nil), eoutvar: T.unsafe(nil)); end

  # Instructs +compiler+ how to write to +io_variable+
  #
  # source://rdoc//lib/rdoc/erbio.rb#30
  def set_eoutvar(compiler, io_variable); end
end

# Allows an ERB template to be rendered in the context (binding) of an
# existing ERB template evaluation.
#
# source://rdoc//lib/rdoc/erb_partial.rb#6
class RDoc::ERBPartial < ::ERB
  # Overrides +compiler+ startup to set the +eoutvar+ to an empty string only
  # if it isn't already set.
  #
  # source://rdoc//lib/rdoc/erb_partial.rb#12
  def set_eoutvar(compiler, eoutvar = T.unsafe(nil)); end
end

# This class is a wrapper around File IO and Encoding that helps RDoc load
# files and convert them to the correct encoding.
#
# source://rdoc//lib/rdoc/encoding.rb#8
module RDoc::Encoding
  class << self
    # Changes encoding based on +encoding+ without converting and returns new
    # string
    #
    # source://rdoc//lib/rdoc/encoding.rb#112
    def change_encoding(text, encoding); end

    # Detects the encoding of +string+ based on the magic comment
    #
    # source://rdoc//lib/rdoc/encoding.rb#92
    def detect_encoding(string); end

    # Reads the contents of +filename+ and handles any encoding directives in
    # the file.
    #
    # The content will be converted to the +encoding+.  If the file cannot be
    # converted a warning will be printed and nil will be returned.
    #
    # If +force_transcode+ is true the document will be transcoded and any
    # unknown character in the target encoding will be replaced with '?'
    #
    # source://rdoc//lib/rdoc/encoding.rb#32
    def read_file(filename, encoding, force_transcode = T.unsafe(nil)); end

    # Removes magic comments and shebang
    #
    # source://rdoc//lib/rdoc/encoding.rb#102
    def remove_magic_comment(string); end
  end
end

# source://rdoc//lib/rdoc/encoding.rb#10
RDoc::Encoding::HEADER_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://rdoc//lib/rdoc/generator/darkfish.rb#55
class RDoc::Generator::Darkfish
  include ::ERB::Escape
  include ::ERB::Util
  include ::ActiveSupport::CoreExt::ERBUtil
  include ::ActiveSupport::CoreExt::ERBUtilPrivate

  # Initialize a few instance variables before we start
  #
  # @return [Darkfish] a new instance of Darkfish
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#159
  def initialize(store, options); end

  # Creates a template from its components and the +body_file+.
  #
  # For backwards compatibility, if +body_file+ contains "<html" the body is
  # used directly.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#675
  def assemble_template(body_file); end

  # The relative path to style sheets and javascript.  By default this is set
  # the same as the rel_prefix.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#96
  def asset_rel_path; end

  # The relative path to style sheets and javascript.  By default this is set
  # the same as the rel_prefix.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#96
  def asset_rel_path=(_arg0); end

  # The path to generate files into, combined with <tt>--op</tt> from the
  # options for a full path.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#102
  def base_dir; end

  # Directory where generated class HTML files live relative to the output
  # dir.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#191
  def class_dir; end

  # Classes and modules to be used by this generator, not necessarily
  # displayed.  See also #modsort
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#108
  def classes; end

  # Copies static files from the static_path into the output directory
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#265
  def copy_static; end

  # Output progress information if debugging is enabled
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#182
  def debug_msg(*msg); end

  # No files will be written when dry_run is true.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#113
  def dry_run; end

  # No files will be written when dry_run is true.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#113
  def dry_run=(_arg0); end

  # Directory where generated class HTML files live relative to the output
  # dir.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#199
  def file_dir; end

  # When false the generate methods return a String instead of writing to a
  # file.  The default is true.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#119
  def file_output; end

  # When false the generate methods return a String instead of writing to a
  # file.  The default is true.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#119
  def file_output=(_arg0); end

  # Files to be displayed by this generator
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#124
  def files; end

  # Create the directories the generated docs will live in if they don't
  # already exist.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#207
  def gen_sub_directories; end

  # Build the initial indices and output objects based on an array of TopLevel
  # objects containing the extracted information.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#241
  def generate; end

  # Generates a class file for +klass+
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#337
  def generate_class(klass, template_file = T.unsafe(nil)); end

  # Generate a documentation file for each class and module
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#368
  def generate_class_files; end

  # Generate a documentation file for each file
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#395
  def generate_file_files; end

  # Generate an index page which lists all the classes which are documented.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#303
  def generate_index; end

  # Generate a page file for +file+
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#464
  def generate_page(file); end

  # Generates the 404 page for the RDoc servlet
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#493
  def generate_servlet_not_found(message); end

  # Generates the servlet root page for the RDoc servlet
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#526
  def generate_servlet_root(installed); end

  # Generate an index page which lists all the classes which are documented.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#553
  def generate_table_of_contents; end

  # Return a list of the documented modules sorted by salience first, then
  # by name.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#294
  def get_sorted_module_list(classes); end

  # Try to extract Subversion information out of the first constant whose
  # value looks like a subversion Id tag. If no matching constant is found,
  # and empty hash is returned.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#652
  def get_svninfo(klass); end

  # source://rdoc//lib/rdoc/generator/darkfish.rb#584
  def install_rdoc_static_file(source, destination, options); end

  # The JSON index generator for this Darkfish generator
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#129
  def json_index; end

  # Methods to be displayed by this generator
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#134
  def methods; end

  # Sorted list of classes and modules to be displayed by this generator
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#139
  def modsort; end

  # The output directory
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#154
  def outputdir; end

  # Renders the ERb contained in +file_name+ relative to the template
  # directory and returns the result based on the current context.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#699
  def render(file_name); end

  # Load and render the erb template in the given +template_file+ and write
  # it out to +out_file+.
  #
  # Both +template_file+ and +out_file+ should be Pathname-like objects.
  #
  # An io will be yielded which must be captured by binding in the caller.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#717
  def render_template(template_file, out_file = T.unsafe(nil)); end

  # Prepares for generation of output from the current directory
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#604
  def setup; end

  # The RDoc::Store that is the source of the generated content
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#144
  def store; end

  # The directory where the template files live
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#149
  def template_dir; end

  # Retrieves a cache template for +file+, if present, or fills the cache.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#764
  def template_for(file, page = T.unsafe(nil), klass = T.unsafe(nil)); end

  # Creates the result for +template+ with +context+.  If an error is raised a
  # Pathname +template_file+ will indicate the file where the error occurred.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#751
  def template_result(template, context, template_file); end

  # Return a string describing the amount of time in the given number of
  # seconds in terms a human can understand easily.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#621
  def time_delta_string(seconds); end

  # Copy over the stylesheet into the appropriate place in the output
  # directory.
  #
  # source://rdoc//lib/rdoc/generator/darkfish.rb#215
  def write_style_sheet; end
end

# source://rdoc//lib/rdoc/generator/json_index.rb#77
class RDoc::Generator::JsonIndex
  include ::RDoc::Text

  # Creates a new generator.  +parent_generator+ is used to determine the
  # class_dir and file_dir of links in the output index.
  #
  # +options+ are the same options passed to the parent generator.
  #
  # @return [JsonIndex] a new instance of JsonIndex
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#94
  def initialize(parent_generator, options); end

  # Builds the JSON index as a Hash.
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#110
  def build_index; end

  # The directory classes are written to
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#271
  def class_dir; end

  # Output progress information if debugging is enabled
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#123
  def debug_msg(*msg); end

  # The directory files are written to
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#278
  def file_dir; end

  # Writes the JSON index to disk
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#131
  def generate; end

  # Compress the search_index.js file using gzip
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#166
  def generate_gzipped; end

  # source://rdoc//lib/rdoc/generator/json_index.rb#86
  def index; end

  # Adds classes and modules to the index
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#211
  def index_classes; end

  # Adds methods to the index
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#230
  def index_methods; end

  # Adds pages to the index
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#251
  def index_pages; end

  # source://rdoc//lib/rdoc/generator/json_index.rb#282
  def reset(files, classes); end

  # Removes whitespace and downcases +string+
  #
  # source://rdoc//lib/rdoc/generator/json_index.rb#296
  def search_string(string); end
end

# Generates a POT file.
#
# Here is a translator work flow with the generator.
#
# == Create .pot
#
# You create .pot file by pot formatter:
#
#   % rdoc --format pot
#
# It generates doc/rdoc.pot.
#
# == Create .po
#
# You create .po file from doc/rdoc.pot. This operation is needed only
# the first time. This work flow assumes that you are a translator
# for Japanese.
#
# You create locale/ja/rdoc.po from doc/rdoc.pot. You can use msginit
# provided by GNU gettext or rmsginit provided by gettext gem. This
# work flow uses gettext gem because it is more portable than GNU
# gettext for Rubyists. Gettext gem is implemented by pure Ruby.
#
#   % gem install gettext
#   % mkdir -p locale/ja
#   % rmsginit --input doc/rdoc.pot --output locale/ja/rdoc.po --locale ja
#
# Translate messages in .po
#
# You translate messages in .po by a PO file editor. po-mode.el exists
# for Emacs users. There are some GUI tools such as GTranslator.
# There are some Web services such as POEditor and Tansifex. You can
# edit by your favorite text editor because .po is a text file.
# Generate localized documentation
#
# You can generate localized documentation with locale/ja/rdoc.po:
#
#   % rdoc --locale ja
#
# You can find documentation in Japanese in doc/. Yay!
#
# == Update translation
#
# You need to update translation when your application is added or
# modified messages.
#
# You can update .po by the following command lines:
#
#   % rdoc --format pot
#   % rmsgmerge --update locale/ja/rdoc.po doc/rdoc.pot
#
# You edit locale/ja/rdoc.po to translate new messages.
#
# source://rdoc//lib/rdoc/generator/pot.rb#56
class RDoc::Generator::POT
  # Set up a new .pot generator
  #
  # @return [POT] a new instance of POT
  #
  # source://rdoc//lib/rdoc/generator/pot.rb#68
  def initialize(store, options); end

  # source://rdoc//lib/rdoc/generator/pot.rb#85
  def class_dir; end

  # Writes .pot to disk.
  #
  # source://rdoc//lib/rdoc/generator/pot.rb#76
  def generate; end

  private

  # source://rdoc//lib/rdoc/generator/pot.rb#90
  def extract_messages; end
end

# Extracts message from RDoc::Store
#
# source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#5
class RDoc::Generator::POT::MessageExtractor
  # Creates a message extractor for +store+.
  #
  # @return [MessageExtractor] a new instance of MessageExtractor
  #
  # source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#10
  def initialize(store); end

  # Extracts messages from +store+, stores them into
  # RDoc::Generator::POT::PO and returns it.
  #
  # source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#19
  def extract; end

  private

  # source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#64
  def entry(msgid, options); end

  # source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#28
  def extract_from_klass(klass); end

  # source://rdoc//lib/rdoc/generator/pot/message_extractor.rb#51
  def extract_text(text, comment, location = T.unsafe(nil)); end
end

# Generates a PO format text
#
# source://rdoc//lib/rdoc/generator/pot/po.rb#5
class RDoc::Generator::POT::PO
  # Creates an object that represents PO format.
  #
  # @return [PO] a new instance of PO
  #
  # source://rdoc//lib/rdoc/generator/pot/po.rb#10
  def initialize; end

  # Adds a PO entry to the PO.
  #
  # source://rdoc//lib/rdoc/generator/pot/po.rb#18
  def add(entry); end

  # Returns PO format text for the PO.
  #
  # source://rdoc//lib/rdoc/generator/pot/po.rb#29
  def to_s; end

  private

  # source://rdoc//lib/rdoc/generator/pot/po.rb#40
  def add_header; end

  # source://rdoc//lib/rdoc/generator/pot/po.rb#44
  def header_entry; end

  # source://rdoc//lib/rdoc/generator/pot/po.rb#73
  def sort_entries; end
end

# A PO entry in PO
#
# source://rdoc//lib/rdoc/generator/pot/po_entry.rb#5
class RDoc::Generator::POT::POEntry
  # Creates a PO entry for +msgid+. Other valus can be specified by
  # +options+.
  #
  # @return [POEntry] a new instance of POEntry
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#29
  def initialize(msgid, options = T.unsafe(nil)); end

  # The comment content extracted from source file
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#17
  def extracted_comment; end

  # The flags of the PO entry
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#23
  def flags; end

  # Merges the PO entry with +other_entry+.
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#56
  def merge(other_entry); end

  # The msgid content
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#8
  def msgid; end

  # The msgstr content
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#11
  def msgstr; end

  # The locations where the PO entry is extracted
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#20
  def references; end

  # Returns the PO entry in PO format.
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#41
  def to_s; end

  # The comment content created by translator (PO editor)
  #
  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#14
  def translator_comment; end

  private

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#120
  def escape(string); end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#72
  def format_comment(mark, comment); end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#88
  def format_extracted_comment; end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#102
  def format_flags; end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#109
  def format_message(message); end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#92
  def format_references; end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#84
  def format_translator_comment; end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#137
  def merge_array(array1, array2); end

  # source://rdoc//lib/rdoc/generator/pot/po_entry.rb#133
  def merge_string(string1, string2); end
end

# Generates ri data files
#
# source://rdoc//lib/rdoc/generator/ri.rb#5
class RDoc::Generator::RI
  # Set up a new ri generator
  #
  # @return [RI] a new instance of RI
  #
  # source://rdoc//lib/rdoc/generator/ri.rb#17
  def initialize(store, options); end

  # Writes the parsed data store to disk for use by ri.
  #
  # source://rdoc//lib/rdoc/generator/ri.rb#26
  def generate; end
end

# A message container for a locale.
#
# This object provides the following two features:
#
#   * Loads translated messages from .po file.
#   * Translates a message into the locale.
#
# source://rdoc//lib/rdoc/i18n/locale.rb#10
class RDoc::I18n::Locale
  # Creates a new locale object for +name+ locale. +name+ must
  # follow IETF language tag format.
  #
  # @return [Locale] a new instance of Locale
  #
  # source://rdoc//lib/rdoc/i18n/locale.rb#48
  def initialize(name); end

  # Loads translation messages from +locale_directory+/+@name+/rdoc.po
  # or +locale_directory+/+@name+.po. The former has high priority.
  #
  # This method requires gettext gem for parsing .po file. If you
  # don't have gettext gem, this method doesn't load .po file. This
  # method warns and returns +false+.
  #
  # Returns +true+ if succeeded, +false+ otherwise.
  #
  # source://rdoc//lib/rdoc/i18n/locale.rb#63
  def load(locale_directory); end

  # The name of the locale. It uses IETF language tag format
  # +[language[_territory][.codeset][@modifier]]+.
  #
  # See also {BCP 47 - Tags for Identifying
  # Languages}[http://tools.ietf.org/rfc/bcp/bcp47.txt].
  #
  # source://rdoc//lib/rdoc/i18n/locale.rb#42
  def name; end

  # Translates the +message+ into locale. If there is no translation
  # messages for +message+ in locale, +message+ itself is returned.
  #
  # source://rdoc//lib/rdoc/i18n/locale.rb#98
  def translate(message); end

  class << self
    # Returns the locale object for +locale_name+.
    #
    # source://rdoc//lib/rdoc/i18n/locale.rb#19
    def [](locale_name); end

    # Sets the locale object for +locale_name+.
    #
    # Normally, this method is not used. This method is useful for
    # testing.
    #
    # source://rdoc//lib/rdoc/i18n/locale.rb#29
    def []=(locale_name, locale); end
  end
end

# An i18n supported text.
#
# This object provides the following two features:
#
#   * Extracts translation messages from wrapped raw text.
#   * Translates wrapped raw text in specified locale.
#
# Wrapped raw text is one of String, RDoc::Comment or Array of them.
#
# source://rdoc//lib/rdoc/i18n/text.rb#12
class RDoc::I18n::Text
  # Creates a new i18n supported text for +raw+ text.
  #
  # @return [Text] a new instance of Text
  #
  # source://rdoc//lib/rdoc/i18n/text.rb#17
  def initialize(raw); end

  # Extracts translation target messages and yields each message.
  #
  # Each yielded message is a Hash. It consists of the followings:
  #
  # :type      :: :paragraph
  # :paragraph :: String (The translation target message itself.)
  # :line_no   :: Integer (The line number of the :paragraph is started.)
  #
  # The above content may be added in the future.
  #
  # source://rdoc//lib/rdoc/i18n/text.rb#32
  def extract_messages; end

  # Translates raw text into +locale+.
  #
  # source://rdoc//lib/rdoc/i18n/text.rb#44
  def translate(locale); end

  private

  # source://rdoc//lib/rdoc/i18n/text.rb#88
  def each_line(raw, &block); end

  # @yield [part]
  #
  # source://rdoc//lib/rdoc/i18n/text.rb#101
  def emit_empty_line_event(line, line_no); end

  # source://rdoc//lib/rdoc/i18n/text.rb#110
  def emit_paragraph_event(paragraph, paragraph_start_line, line_no, &block); end

  # source://rdoc//lib/rdoc/i18n/text.rb#60
  def parse(&block); end
end

# source://rdoc//lib/rdoc/markdown.rb#182
class RDoc::Markdown
  # Creates a new markdown parser that enables the given +extensions+.
  #
  # @return [Markdown] a new instance of Markdown
  #
  # source://rdoc//lib/rdoc/markdown.rb#668
  def initialize(extensions = T.unsafe(nil), debug = T.unsafe(nil)); end

  # Alphanumeric = %literals.Alphanumeric
  #
  # source://rdoc//lib/rdoc/markdown.rb#14705
  def _Alphanumeric; end

  # AlphanumericAscii = %literals.AlphanumericAscii
  #
  # source://rdoc//lib/rdoc/markdown.rb#14712
  def _AlphanumericAscii; end

  # AtxHeading = AtxStart:s @Sp AtxInline+:a (@Sp /#*/ @Sp)? @Newline { RDoc::Markup::Heading.new(s, a.join) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1162
  def _AtxHeading; end

  # AtxInline = !@Newline !(@Sp /#*/ @Sp @Newline) Inline
  #
  # source://rdoc//lib/rdoc/markdown.rb#1080
  def _AtxInline; end

  # AtxStart = < /\#{1,6}/ > { text.length }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1136
  def _AtxStart; end

  # AutoLink = (AutoLinkUrl | AutoLinkEmail)
  #
  # source://rdoc//lib/rdoc/markdown.rb#11574
  def _AutoLink; end

  # AutoLinkEmail = "<" "mailto:"? < /[\w+.\/!%~$-]+/i "@" (!@Newline !">" .)+ > ">" { "mailto:#{text}" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11707
  def _AutoLinkEmail; end

  # AutoLinkUrl = "<" < /[A-Za-z]+/ "://" (!@Newline !">" .)+ > ">" { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11592
  def _AutoLinkUrl; end

  # BOM = %literals.BOM
  #
  # source://rdoc//lib/rdoc/markdown.rb#14719
  def _BOM; end

  # BlankLine = @Sp @Newline { "\n" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14148
  def _BlankLine; end

  # Block = @BlankLine* (BlockQuote | Verbatim | CodeFence | Table | Note | Reference | HorizontalRule | Heading | OrderedList | BulletList | DefinitionList | HtmlBlock | StyleBlock | Para | Plain)
  #
  # source://rdoc//lib/rdoc/markdown.rb#939
  def _Block; end

  # BlockQuote = BlockQuoteRaw:a { RDoc::Markup::BlockQuote.new(*a) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1566
  def _BlockQuote; end

  # BlockQuoteRaw = @StartList:a (">" " "? Line:l { a << l } (!">" !@BlankLine Line:c { a << c })* (@BlankLine:n { a << n })*)+ { inner_parse a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1589
  def _BlockQuoteRaw; end

  # Bullet = !HorizontalRule @NonindentSpace /[+*-]/ @Spacechar+
  #
  # source://rdoc//lib/rdoc/markdown.rb#2154
  def _Bullet; end

  # BulletList = &Bullet (ListTight | ListLoose):a { RDoc::Markup::List.new(:BULLET, *a) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2198
  def _BulletList; end

  # CharEntity = "&" < /[A-Za-z0-9]+/ > ";" { if entity = HTML_ENTITIES[text] then                  entity.pack 'U*'                else                  "&#{text};"                end              }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14812
  def _CharEntity; end

  # Code = (Ticks1 @Sp < ((!"`" Nonspacechar)+ | !Ticks1 /`+/ | !(@Sp Ticks1) (@Spacechar | @Newline !@BlankLine))+ > @Sp Ticks1 | Ticks2 @Sp < ((!"`" Nonspacechar)+ | !Ticks2 /`+/ | !(@Sp Ticks2) (@Spacechar | @Newline !@BlankLine))+ > @Sp Ticks2 | Ticks3 @Sp < ((!"`" Nonspacechar)+ | !Ticks3 /`+/ | !(@Sp Ticks3) (@Spacechar | @Newline !@BlankLine))+ > @Sp Ticks3 | Ticks4 @Sp < ((!"`" Nonspacechar)+ | !Ticks4 /`+/ | !(@Sp Ticks4) (@Spacechar | @Newline !@BlankLine))+ > @Sp Ticks4 | Ticks5 @Sp < ((!"`" Nonspacechar)+ | !Ticks5 /`+/ | !(@Sp Ticks5) (@Spacechar | @Newline !@BlankLine))+ > @Sp Ticks5) { "<code>#{text}</code>" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#12511
  def _Code; end

  # CodeFence = &{ github? } Ticks3 (@Sp StrChunk:format)? Spnl < ((!"`" Nonspacechar)+ | !Ticks3 /`+/ | Spacechar | @Newline)+ > Ticks3 @Sp @Newline* { verbatim = RDoc::Markup::Verbatim.new text               verbatim.format = format.intern if format.instance_of?(String)               verbatim             }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15681
  def _CodeFence; end

  # DecEntity = "&#" < /[0-9]+/ > ";" { [text.to_i].pack 'U' }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14776
  def _DecEntity; end

  # DefinitionList = &{ definition_lists? } DefinitionListItem+:list { RDoc::Markup::List.new :NOTE, *list.flatten }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16339
  def _DefinitionList; end

  # DefinitionListDefinition = @NonindentSpace ":" @Space Inlines:a @BlankLine+ { paragraph a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16482
  def _DefinitionListDefinition; end

  # DefinitionListItem = DefinitionListLabel+:label DefinitionListDefinition+:defns { list_items = []                        list_items <<                          RDoc::Markup::ListItem.new(label, defns.shift)                         list_items.concat defns.map { |defn|                          RDoc::Markup::ListItem.new nil, defn                        } unless list_items.empty?                         list_items                      }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16383
  def _DefinitionListItem; end

  # DefinitionListLabel = Inline:label @Sp @Newline { label }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16449
  def _DefinitionListLabel; end

  # Digit = [0-9]
  #
  # source://rdoc//lib/rdoc/markdown.rb#14691
  def _Digit; end

  # Doc = BOM? Block*:a { RDoc::Markup::Document.new(*a.compact) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#899
  def _Doc; end

  # Emph = (EmphStar | EmphUl)
  #
  # source://rdoc//lib/rdoc/markdown.rb#10283
  def _Emph; end

  # EmphStar = "*" !@Whitespace @StartList:a (!"*" Inline:b { a << b } | StrongStar:b { a << b })+ "*" { emphasis a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10319
  def _EmphStar; end

  # EmphUl = "_" !@Whitespace @StartList:a (!"_" Inline:b { a << b } | StrongUl:b { a << b })+ "_" { emphasis a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10477
  def _EmphUl; end

  # EmptyTitle = ""
  #
  # source://rdoc//lib/rdoc/markdown.rb#12086
  def _EmptyTitle; end

  # Endline = (@LineBreak | @TerminalEndline | @NormalEndline)
  #
  # source://rdoc//lib/rdoc/markdown.rb#9917
  def _Endline; end

  # Entity = (HexEntity | DecEntity | CharEntity):a { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9880
  def _Entity; end

  # Enumerator = @NonindentSpace [0-9]+ "." @Spacechar+
  #
  # source://rdoc//lib/rdoc/markdown.rb#2687
  def _Enumerator; end

  # Eof = !.
  #
  # source://rdoc//lib/rdoc/markdown.rb#14542
  def _Eof; end

  # EscapedChar = "\\" !@Newline < /[:\\`|*_{}\[\]()#+.!><-]/ > { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9841
  def _EscapedChar; end

  # ExplicitLink = Label:l "(" @Sp Source:s Spnl Title @Sp ")" { "{#{l}}[#{s}]" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11147
  def _ExplicitLink; end

  # ExtendedSpecialChar = &{ notes? } "^"
  #
  # source://rdoc//lib/rdoc/markdown.rb#15184
  def _ExtendedSpecialChar; end

  # Heading = (SetextHeading | AtxHeading)
  #
  # source://rdoc//lib/rdoc/markdown.rb#1548
  def _Heading; end

  # HexEntity = /&#x/i < /[0-9a-fA-F]+/ > ";" { [text.to_i(16)].pack 'U' }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14740
  def _HexEntity; end

  # HorizontalRule = @NonindentSpace ("*" @Sp "*" @Sp "*" (@Sp "*")* | "-" @Sp "-" @Sp "-" (@Sp "-")* | "_" @Sp "_" @Sp "_" (@Sp "_")*) @Sp @Newline @BlankLine+ { RDoc::Markup::Rule.new 1 }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1932
  def _HorizontalRule; end

  # HtmlAnchor = HtmlOpenAnchor (HtmlAnchor | !HtmlCloseAnchor .)* HtmlCloseAnchor
  #
  # source://rdoc//lib/rdoc/markdown.rb#2971
  def _HtmlAnchor; end

  # HtmlAttribute = (AlphanumericAscii | "-")+ Spnl ("=" Spnl (Quoted | (!">" Nonspacechar)+))? Spnl
  #
  # source://rdoc//lib/rdoc/markdown.rb#14273
  def _HtmlAttribute; end

  # HtmlBlock = < (HtmlBlockInTags | HtmlComment | HtmlBlockSelfClosing | HtmlUnclosed) > @BlankLine+ { if html? then                 RDoc::Markup::Raw.new text               end }
  #
  # source://rdoc//lib/rdoc/markdown.rb#8768
  def _HtmlBlock; end

  # HtmlBlockAddress = HtmlBlockOpenAddress (HtmlBlockAddress | !HtmlBlockCloseAddress .)* HtmlBlockCloseAddress
  #
  # source://rdoc//lib/rdoc/markdown.rb#3137
  def _HtmlBlockAddress; end

  # HtmlBlockBlockquote = HtmlBlockOpenBlockquote (HtmlBlockBlockquote | !HtmlBlockCloseBlockquote .)* HtmlBlockCloseBlockquote
  #
  # source://rdoc//lib/rdoc/markdown.rb#3303
  def _HtmlBlockBlockquote; end

  # HtmlBlockCenter = HtmlBlockOpenCenter (HtmlBlockCenter | !HtmlBlockCloseCenter .)* HtmlBlockCloseCenter
  #
  # source://rdoc//lib/rdoc/markdown.rb#3469
  def _HtmlBlockCenter; end

  # HtmlBlockCloseAddress = "<" Spnl "/" ("address" | "ADDRESS") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3085
  def _HtmlBlockCloseAddress; end

  # HtmlBlockCloseBlockquote = "<" Spnl "/" ("blockquote" | "BLOCKQUOTE") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3251
  def _HtmlBlockCloseBlockquote; end

  # HtmlBlockCloseCenter = "<" Spnl "/" ("center" | "CENTER") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3417
  def _HtmlBlockCloseCenter; end

  # HtmlBlockCloseDd = "<" Spnl "/" ("dd" | "DD") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6737
  def _HtmlBlockCloseDd; end

  # HtmlBlockCloseDir = "<" Spnl "/" ("dir" | "DIR") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3583
  def _HtmlBlockCloseDir; end

  # HtmlBlockCloseDiv = "<" Spnl "/" ("div" | "DIV") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3749
  def _HtmlBlockCloseDiv; end

  # HtmlBlockCloseDl = "<" Spnl "/" ("dl" | "DL") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3915
  def _HtmlBlockCloseDl; end

  # HtmlBlockCloseDt = "<" Spnl "/" ("dt" | "DT") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6903
  def _HtmlBlockCloseDt; end

  # HtmlBlockCloseFieldset = "<" Spnl "/" ("fieldset" | "FIELDSET") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4081
  def _HtmlBlockCloseFieldset; end

  # HtmlBlockCloseForm = "<" Spnl "/" ("form" | "FORM") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4247
  def _HtmlBlockCloseForm; end

  # HtmlBlockCloseFrameset = "<" Spnl "/" ("frameset" | "FRAMESET") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7069
  def _HtmlBlockCloseFrameset; end

  # HtmlBlockCloseH1 = "<" Spnl "/" ("h1" | "H1") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4413
  def _HtmlBlockCloseH1; end

  # HtmlBlockCloseH2 = "<" Spnl "/" ("h2" | "H2") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4579
  def _HtmlBlockCloseH2; end

  # HtmlBlockCloseH3 = "<" Spnl "/" ("h3" | "H3") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4745
  def _HtmlBlockCloseH3; end

  # HtmlBlockCloseH4 = "<" Spnl "/" ("h4" | "H4") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4911
  def _HtmlBlockCloseH4; end

  # HtmlBlockCloseH5 = "<" Spnl "/" ("h5" | "H5") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5077
  def _HtmlBlockCloseH5; end

  # HtmlBlockCloseH6 = "<" Spnl "/" ("h6" | "H6") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5243
  def _HtmlBlockCloseH6; end

  # HtmlBlockCloseHead = "<" Spnl "/" ("head" | "HEAD") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8552
  def _HtmlBlockCloseHead; end

  # HtmlBlockCloseLi = "<" Spnl "/" ("li" | "LI") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7235
  def _HtmlBlockCloseLi; end

  # HtmlBlockCloseMenu = "<" Spnl "/" ("menu" | "MENU") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5409
  def _HtmlBlockCloseMenu; end

  # HtmlBlockCloseNoframes = "<" Spnl "/" ("noframes" | "NOFRAMES") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5575
  def _HtmlBlockCloseNoframes; end

  # HtmlBlockCloseNoscript = "<" Spnl "/" ("noscript" | "NOSCRIPT") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5741
  def _HtmlBlockCloseNoscript; end

  # HtmlBlockCloseOl = "<" Spnl "/" ("ol" | "OL") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5907
  def _HtmlBlockCloseOl; end

  # HtmlBlockCloseP = "<" Spnl "/" ("p" | "P") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6073
  def _HtmlBlockCloseP; end

  # HtmlBlockClosePre = "<" Spnl "/" ("pre" | "PRE") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6239
  def _HtmlBlockClosePre; end

  # HtmlBlockCloseScript = "<" Spnl "/" ("script" | "SCRIPT") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8397
  def _HtmlBlockCloseScript; end

  # HtmlBlockCloseTable = "<" Spnl "/" ("table" | "TABLE") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6405
  def _HtmlBlockCloseTable; end

  # HtmlBlockCloseTbody = "<" Spnl "/" ("tbody" | "TBODY") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7401
  def _HtmlBlockCloseTbody; end

  # HtmlBlockCloseTd = "<" Spnl "/" ("td" | "TD") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7567
  def _HtmlBlockCloseTd; end

  # HtmlBlockCloseTfoot = "<" Spnl "/" ("tfoot" | "TFOOT") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7733
  def _HtmlBlockCloseTfoot; end

  # HtmlBlockCloseTh = "<" Spnl "/" ("th" | "TH") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7899
  def _HtmlBlockCloseTh; end

  # HtmlBlockCloseThead = "<" Spnl "/" ("thead" | "THEAD") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8065
  def _HtmlBlockCloseThead; end

  # HtmlBlockCloseTr = "<" Spnl "/" ("tr" | "TR") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8231
  def _HtmlBlockCloseTr; end

  # HtmlBlockCloseUl = "<" Spnl "/" ("ul" | "UL") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6571
  def _HtmlBlockCloseUl; end

  # HtmlBlockDd = HtmlBlockOpenDd (HtmlBlockDd | !HtmlBlockCloseDd .)* HtmlBlockCloseDd
  #
  # source://rdoc//lib/rdoc/markdown.rb#6789
  def _HtmlBlockDd; end

  # HtmlBlockDir = HtmlBlockOpenDir (HtmlBlockDir | !HtmlBlockCloseDir .)* HtmlBlockCloseDir
  #
  # source://rdoc//lib/rdoc/markdown.rb#3635
  def _HtmlBlockDir; end

  # HtmlBlockDiv = HtmlBlockOpenDiv (HtmlBlockDiv | !HtmlBlockCloseDiv .)* HtmlBlockCloseDiv
  #
  # source://rdoc//lib/rdoc/markdown.rb#3801
  def _HtmlBlockDiv; end

  # HtmlBlockDl = HtmlBlockOpenDl (HtmlBlockDl | !HtmlBlockCloseDl .)* HtmlBlockCloseDl
  #
  # source://rdoc//lib/rdoc/markdown.rb#3967
  def _HtmlBlockDl; end

  # HtmlBlockDt = HtmlBlockOpenDt (HtmlBlockDt | !HtmlBlockCloseDt .)* HtmlBlockCloseDt
  #
  # source://rdoc//lib/rdoc/markdown.rb#6955
  def _HtmlBlockDt; end

  # HtmlBlockFieldset = HtmlBlockOpenFieldset (HtmlBlockFieldset | !HtmlBlockCloseFieldset .)* HtmlBlockCloseFieldset
  #
  # source://rdoc//lib/rdoc/markdown.rb#4133
  def _HtmlBlockFieldset; end

  # HtmlBlockForm = HtmlBlockOpenForm (HtmlBlockForm | !HtmlBlockCloseForm .)* HtmlBlockCloseForm
  #
  # source://rdoc//lib/rdoc/markdown.rb#4299
  def _HtmlBlockForm; end

  # HtmlBlockFrameset = HtmlBlockOpenFrameset (HtmlBlockFrameset | !HtmlBlockCloseFrameset .)* HtmlBlockCloseFrameset
  #
  # source://rdoc//lib/rdoc/markdown.rb#7121
  def _HtmlBlockFrameset; end

  # HtmlBlockH1 = HtmlBlockOpenH1 (HtmlBlockH1 | !HtmlBlockCloseH1 .)* HtmlBlockCloseH1
  #
  # source://rdoc//lib/rdoc/markdown.rb#4465
  def _HtmlBlockH1; end

  # HtmlBlockH2 = HtmlBlockOpenH2 (HtmlBlockH2 | !HtmlBlockCloseH2 .)* HtmlBlockCloseH2
  #
  # source://rdoc//lib/rdoc/markdown.rb#4631
  def _HtmlBlockH2; end

  # HtmlBlockH3 = HtmlBlockOpenH3 (HtmlBlockH3 | !HtmlBlockCloseH3 .)* HtmlBlockCloseH3
  #
  # source://rdoc//lib/rdoc/markdown.rb#4797
  def _HtmlBlockH3; end

  # HtmlBlockH4 = HtmlBlockOpenH4 (HtmlBlockH4 | !HtmlBlockCloseH4 .)* HtmlBlockCloseH4
  #
  # source://rdoc//lib/rdoc/markdown.rb#4963
  def _HtmlBlockH4; end

  # HtmlBlockH5 = HtmlBlockOpenH5 (HtmlBlockH5 | !HtmlBlockCloseH5 .)* HtmlBlockCloseH5
  #
  # source://rdoc//lib/rdoc/markdown.rb#5129
  def _HtmlBlockH5; end

  # HtmlBlockH6 = HtmlBlockOpenH6 (HtmlBlockH6 | !HtmlBlockCloseH6 .)* HtmlBlockCloseH6
  #
  # source://rdoc//lib/rdoc/markdown.rb#5295
  def _HtmlBlockH6; end

  # HtmlBlockHead = HtmlBlockOpenHead (!HtmlBlockCloseHead .)* HtmlBlockCloseHead
  #
  # source://rdoc//lib/rdoc/markdown.rb#8604
  def _HtmlBlockHead; end

  # HtmlBlockInTags = (HtmlAnchor | HtmlBlockAddress | HtmlBlockBlockquote | HtmlBlockCenter | HtmlBlockDir | HtmlBlockDiv | HtmlBlockDl | HtmlBlockFieldset | HtmlBlockForm | HtmlBlockH1 | HtmlBlockH2 | HtmlBlockH3 | HtmlBlockH4 | HtmlBlockH5 | HtmlBlockH6 | HtmlBlockMenu | HtmlBlockNoframes | HtmlBlockNoscript | HtmlBlockOl | HtmlBlockP | HtmlBlockPre | HtmlBlockTable | HtmlBlockUl | HtmlBlockDd | HtmlBlockDt | HtmlBlockFrameset | HtmlBlockLi | HtmlBlockTbody | HtmlBlockTd | HtmlBlockTfoot | HtmlBlockTh | HtmlBlockThead | HtmlBlockTr | HtmlBlockScript | HtmlBlockHead)
  #
  # source://rdoc//lib/rdoc/markdown.rb#8651
  def _HtmlBlockInTags; end

  # HtmlBlockLi = HtmlBlockOpenLi (HtmlBlockLi | !HtmlBlockCloseLi .)* HtmlBlockCloseLi
  #
  # source://rdoc//lib/rdoc/markdown.rb#7287
  def _HtmlBlockLi; end

  # HtmlBlockMenu = HtmlBlockOpenMenu (HtmlBlockMenu | !HtmlBlockCloseMenu .)* HtmlBlockCloseMenu
  #
  # source://rdoc//lib/rdoc/markdown.rb#5461
  def _HtmlBlockMenu; end

  # HtmlBlockNoframes = HtmlBlockOpenNoframes (HtmlBlockNoframes | !HtmlBlockCloseNoframes .)* HtmlBlockCloseNoframes
  #
  # source://rdoc//lib/rdoc/markdown.rb#5627
  def _HtmlBlockNoframes; end

  # HtmlBlockNoscript = HtmlBlockOpenNoscript (HtmlBlockNoscript | !HtmlBlockCloseNoscript .)* HtmlBlockCloseNoscript
  #
  # source://rdoc//lib/rdoc/markdown.rb#5793
  def _HtmlBlockNoscript; end

  # HtmlBlockOl = HtmlBlockOpenOl (HtmlBlockOl | !HtmlBlockCloseOl .)* HtmlBlockCloseOl
  #
  # source://rdoc//lib/rdoc/markdown.rb#5959
  def _HtmlBlockOl; end

  # HtmlBlockOpenAddress = "<" Spnl ("address" | "ADDRESS") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3029
  def _HtmlBlockOpenAddress; end

  # HtmlBlockOpenBlockquote = "<" Spnl ("blockquote" | "BLOCKQUOTE") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3195
  def _HtmlBlockOpenBlockquote; end

  # HtmlBlockOpenCenter = "<" Spnl ("center" | "CENTER") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3361
  def _HtmlBlockOpenCenter; end

  # HtmlBlockOpenDd = "<" Spnl ("dd" | "DD") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6681
  def _HtmlBlockOpenDd; end

  # HtmlBlockOpenDir = "<" Spnl ("dir" | "DIR") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3527
  def _HtmlBlockOpenDir; end

  # HtmlBlockOpenDiv = "<" Spnl ("div" | "DIV") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3693
  def _HtmlBlockOpenDiv; end

  # HtmlBlockOpenDl = "<" Spnl ("dl" | "DL") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#3859
  def _HtmlBlockOpenDl; end

  # HtmlBlockOpenDt = "<" Spnl ("dt" | "DT") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6847
  def _HtmlBlockOpenDt; end

  # HtmlBlockOpenFieldset = "<" Spnl ("fieldset" | "FIELDSET") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4025
  def _HtmlBlockOpenFieldset; end

  # HtmlBlockOpenForm = "<" Spnl ("form" | "FORM") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4191
  def _HtmlBlockOpenForm; end

  # HtmlBlockOpenFrameset = "<" Spnl ("frameset" | "FRAMESET") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7013
  def _HtmlBlockOpenFrameset; end

  # HtmlBlockOpenH1 = "<" Spnl ("h1" | "H1") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4357
  def _HtmlBlockOpenH1; end

  # HtmlBlockOpenH2 = "<" Spnl ("h2" | "H2") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4523
  def _HtmlBlockOpenH2; end

  # HtmlBlockOpenH3 = "<" Spnl ("h3" | "H3") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4689
  def _HtmlBlockOpenH3; end

  # HtmlBlockOpenH4 = "<" Spnl ("h4" | "H4") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#4855
  def _HtmlBlockOpenH4; end

  # HtmlBlockOpenH5 = "<" Spnl ("h5" | "H5") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5021
  def _HtmlBlockOpenH5; end

  # HtmlBlockOpenH6 = "<" Spnl ("h6" | "H6") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5187
  def _HtmlBlockOpenH6; end

  # HtmlBlockOpenHead = "<" Spnl ("head" | "HEAD") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8496
  def _HtmlBlockOpenHead; end

  # HtmlBlockOpenLi = "<" Spnl ("li" | "LI") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7179
  def _HtmlBlockOpenLi; end

  # HtmlBlockOpenMenu = "<" Spnl ("menu" | "MENU") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5353
  def _HtmlBlockOpenMenu; end

  # HtmlBlockOpenNoframes = "<" Spnl ("noframes" | "NOFRAMES") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5519
  def _HtmlBlockOpenNoframes; end

  # HtmlBlockOpenNoscript = "<" Spnl ("noscript" | "NOSCRIPT") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5685
  def _HtmlBlockOpenNoscript; end

  # HtmlBlockOpenOl = "<" Spnl ("ol" | "OL") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#5851
  def _HtmlBlockOpenOl; end

  # HtmlBlockOpenP = "<" Spnl ("p" | "P") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6017
  def _HtmlBlockOpenP; end

  # HtmlBlockOpenPre = "<" Spnl ("pre" | "PRE") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6183
  def _HtmlBlockOpenPre; end

  # HtmlBlockOpenScript = "<" Spnl ("script" | "SCRIPT") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8341
  def _HtmlBlockOpenScript; end

  # HtmlBlockOpenTable = "<" Spnl ("table" | "TABLE") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6349
  def _HtmlBlockOpenTable; end

  # HtmlBlockOpenTbody = "<" Spnl ("tbody" | "TBODY") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7345
  def _HtmlBlockOpenTbody; end

  # HtmlBlockOpenTd = "<" Spnl ("td" | "TD") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7511
  def _HtmlBlockOpenTd; end

  # HtmlBlockOpenTfoot = "<" Spnl ("tfoot" | "TFOOT") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7677
  def _HtmlBlockOpenTfoot; end

  # HtmlBlockOpenTh = "<" Spnl ("th" | "TH") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#7843
  def _HtmlBlockOpenTh; end

  # HtmlBlockOpenThead = "<" Spnl ("thead" | "THEAD") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8009
  def _HtmlBlockOpenThead; end

  # HtmlBlockOpenTr = "<" Spnl ("tr" | "TR") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8175
  def _HtmlBlockOpenTr; end

  # HtmlBlockOpenUl = "<" Spnl ("ul" | "UL") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#6515
  def _HtmlBlockOpenUl; end

  # HtmlBlockP = HtmlBlockOpenP (HtmlBlockP | !HtmlBlockCloseP .)* HtmlBlockCloseP
  #
  # source://rdoc//lib/rdoc/markdown.rb#6125
  def _HtmlBlockP; end

  # HtmlBlockPre = HtmlBlockOpenPre (HtmlBlockPre | !HtmlBlockClosePre .)* HtmlBlockClosePre
  #
  # source://rdoc//lib/rdoc/markdown.rb#6291
  def _HtmlBlockPre; end

  # HtmlBlockScript = HtmlBlockOpenScript (!HtmlBlockCloseScript .)* HtmlBlockCloseScript
  #
  # source://rdoc//lib/rdoc/markdown.rb#8449
  def _HtmlBlockScript; end

  # HtmlBlockSelfClosing = "<" Spnl HtmlBlockType Spnl HtmlAttribute* "/" Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8896
  def _HtmlBlockSelfClosing; end

  # HtmlBlockTable = HtmlBlockOpenTable (HtmlBlockTable | !HtmlBlockCloseTable .)* HtmlBlockCloseTable
  #
  # source://rdoc//lib/rdoc/markdown.rb#6457
  def _HtmlBlockTable; end

  # HtmlBlockTbody = HtmlBlockOpenTbody (HtmlBlockTbody | !HtmlBlockCloseTbody .)* HtmlBlockCloseTbody
  #
  # source://rdoc//lib/rdoc/markdown.rb#7453
  def _HtmlBlockTbody; end

  # HtmlBlockTd = HtmlBlockOpenTd (HtmlBlockTd | !HtmlBlockCloseTd .)* HtmlBlockCloseTd
  #
  # source://rdoc//lib/rdoc/markdown.rb#7619
  def _HtmlBlockTd; end

  # HtmlBlockTfoot = HtmlBlockOpenTfoot (HtmlBlockTfoot | !HtmlBlockCloseTfoot .)* HtmlBlockCloseTfoot
  #
  # source://rdoc//lib/rdoc/markdown.rb#7785
  def _HtmlBlockTfoot; end

  # HtmlBlockTh = HtmlBlockOpenTh (HtmlBlockTh | !HtmlBlockCloseTh .)* HtmlBlockCloseTh
  #
  # source://rdoc//lib/rdoc/markdown.rb#7951
  def _HtmlBlockTh; end

  # HtmlBlockThead = HtmlBlockOpenThead (HtmlBlockThead | !HtmlBlockCloseThead .)* HtmlBlockCloseThead
  #
  # source://rdoc//lib/rdoc/markdown.rb#8117
  def _HtmlBlockThead; end

  # HtmlBlockTr = HtmlBlockOpenTr (HtmlBlockTr | !HtmlBlockCloseTr .)* HtmlBlockCloseTr
  #
  # source://rdoc//lib/rdoc/markdown.rb#8283
  def _HtmlBlockTr; end

  # HtmlBlockType = ("ADDRESS" | "BLOCKQUOTE" | "CENTER" | "DD" | "DIR" | "DIV" | "DL" | "DT" | "FIELDSET" | "FORM" | "FRAMESET" | "H1" | "H2" | "H3" | "H4" | "H5" | "H6" | "HR" | "ISINDEX" | "LI" | "MENU" | "NOFRAMES" | "NOSCRIPT" | "OL" | "P" | "PRE" | "SCRIPT" | "TABLE" | "TBODY" | "TD" | "TFOOT" | "TH" | "THEAD" | "TR" | "UL" | "address" | "blockquote" | "center" | "dd" | "dir" | "div" | "dl" | "dt" | "fieldset" | "form" | "frameset" | "h1" | "h2" | "h3" | "h4" | "h5" | "h6" | "hr" | "isindex" | "li" | "menu" | "noframes" | "noscript" | "ol" | "p" | "pre" | "script" | "table" | "tbody" | "td" | "tfoot" | "th" | "thead" | "tr" | "ul")
  #
  # source://rdoc//lib/rdoc/markdown.rb#8951
  def _HtmlBlockType; end

  # HtmlBlockUl = HtmlBlockOpenUl (HtmlBlockUl | !HtmlBlockCloseUl .)* HtmlBlockCloseUl
  #
  # source://rdoc//lib/rdoc/markdown.rb#6623
  def _HtmlBlockUl; end

  # HtmlCloseAnchor = "<" Spnl "/" ("a" | "A") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#2919
  def _HtmlCloseAnchor; end

  # HtmlComment = "<!--" (!"-->" .)* "-->"
  #
  # source://rdoc//lib/rdoc/markdown.rb#14415
  def _HtmlComment; end

  # HtmlOpenAnchor = "<" Spnl ("a" | "A") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#2863
  def _HtmlOpenAnchor; end

  # HtmlTag = "<" Spnl "/"? AlphanumericAscii+ Spnl HtmlAttribute* "/"? Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#14462
  def _HtmlTag; end

  # HtmlUnclosed = "<" Spnl HtmlUnclosedType Spnl HtmlAttribute* Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#8828
  def _HtmlUnclosed; end

  # HtmlUnclosedType = ("HR" | "hr")
  #
  # source://rdoc//lib/rdoc/markdown.rb#8878
  def _HtmlUnclosedType; end

  # Image = "!" (ExplicitLink | ReferenceLink):a { "rdoc-image:#{a[/\[(.*)\]/, 1]}" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10972
  def _Image; end

  # InStyleTags = StyleOpen (!StyleClose .)* StyleClose
  #
  # source://rdoc//lib/rdoc/markdown.rb#9281
  def _InStyleTags; end

  # Indent = /\t|    /
  #
  # source://rdoc//lib/rdoc/markdown.rb#14860
  def _Indent; end

  # IndentedLine = Indent Line
  #
  # source://rdoc//lib/rdoc/markdown.rb#14867
  def _IndentedLine; end

  # Inline = (Str | @Endline | UlOrStarLine | @Space | Strong | Emph | Strike | Image | Link | NoteReference | InlineNote | Code | RawHtml | Entity | EscapedChar | Symbol)
  #
  # source://rdoc//lib/rdoc/markdown.rb#9586
  def _Inline; end

  # InlineNote = &{ notes? } "^[" @StartList:a (!"]" Inline:l { a << l })+ "]" { ref = [:inline, @note_order.length]                @footnotes[ref] = paragraph a                 note_for ref              }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15431
  def _InlineNote; end

  # Inlines = (!@Endline Inline:i { i } | @Endline:c !(&{ github? } Ticks3 /[^`\n]*$/) &Inline { c })+:chunks @Endline? { chunks }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9365
  def _Inlines; end

  # Label = "[" (!"^" &{ notes? } | &. &{ !notes? }) @StartList:a (!"]" Inline:l { a << l })* "]" { a.join.gsub(/\s+/, ' ') }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11907
  def _Label; end

  # Line = @RawLine:a { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14938
  def _Line; end

  # LineBreak = "  " @NormalEndline { RDoc::Markup::HardBreak.new }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10042
  def _LineBreak; end

  # Link = (ExplicitLink | ReferenceLink | AutoLink)
  #
  # source://rdoc//lib/rdoc/markdown.rb#11011
  def _Link; end

  # ListBlock = !@BlankLine Line:a ListBlockLine*:c { [a, *c] }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2548
  def _ListBlock; end

  # ListBlockLine = !@BlankLine !(Indent? (Bullet | Enumerator)) !HorizontalRule OptionallyIndentedLine
  #
  # source://rdoc//lib/rdoc/markdown.rb#2793
  def _ListBlockLine; end

  # ListContinuationBlock = @StartList:a @BlankLine* { a << "\n" } (Indent ListBlock:b { a.concat b })+ { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2592
  def _ListContinuationBlock; end

  # ListItem = (Bullet | Enumerator) @StartList:a ListBlock:b { a << b } (ListContinuationBlock:c { a.push(*c) })* { list_item_from a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2392
  def _ListItem; end

  # ListItemTight = (Bullet | Enumerator) ListBlock:a (!@BlankLine ListContinuationBlock:b { a.push(*b) })* !ListContinuationBlock { list_item_from a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2468
  def _ListItemTight; end

  # ListLoose = @StartList:a (ListItem:b @BlankLine* { a << b })+ { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2304
  def _ListLoose; end

  # ListTight = ListItemTight+:a @BlankLine* !(Bullet | Enumerator) { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2239
  def _ListTight; end

  # Newline = %literals.Newline
  #
  # source://rdoc//lib/rdoc/markdown.rb#14726
  def _Newline; end

  # NonblankIndentedLine = !@BlankLine IndentedLine
  #
  # source://rdoc//lib/rdoc/markdown.rb#1821
  def _NonblankIndentedLine; end

  # NonindentSpace = / {0,3}/
  #
  # source://rdoc//lib/rdoc/markdown.rb#14853
  def _NonindentSpace; end

  # Nonspacechar = !@Spacechar !@Newline .
  #
  # source://rdoc//lib/rdoc/markdown.rb#14552
  def _Nonspacechar; end

  # NormalChar = !(@SpecialChar | @Spacechar | @Newline) .
  #
  # source://rdoc//lib/rdoc/markdown.rb#14653
  def _NormalChar; end

  # NormalEndline = @Sp @Newline !@BlankLine !">" !AtxStart !(Line /={1,}|-{1,}/ @Newline) { "\n" }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9938
  def _NormalEndline; end

  # Note = &{ notes? } @NonindentSpace RawNoteReference:ref ":" @Sp @StartList:a RawNoteBlock:i { a.concat i } (&Indent RawNoteBlock:i { a.concat i })* { @footnotes[ref] = paragraph a                    nil                 }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15333
  def _Note; end

  # NoteReference = &{ notes? } RawNoteReference:ref { note_for ref }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15207
  def _NoteReference; end

  # Notes = (Note | SkipBlock)*
  #
  # source://rdoc//lib/rdoc/markdown.rb#15538
  def _Notes; end

  # OptionallyIndentedLine = Indent? Line
  #
  # source://rdoc//lib/rdoc/markdown.rb#14888
  def _OptionallyIndentedLine; end

  # OrderedList = &Enumerator (ListTight | ListLoose):a { RDoc::Markup::List.new(:NUMBER, *a) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#2752
  def _OrderedList; end

  # Para = @NonindentSpace Inlines:a @BlankLine+ { paragraph a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1014
  def _Para; end

  # Plain = Inlines:a { paragraph a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1057
  def _Plain; end

  # Quoted = ("\"" (!"\"" .)* "\"" | "'" (!"'" .)* "'")
  #
  # source://rdoc//lib/rdoc/markdown.rb#14175
  def _Quoted; end

  # RawHtml = < (HtmlComment | HtmlBlockScript | HtmlTag) > { if html? then text else '' end }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14108
  def _RawHtml; end

  # RawLine = (< /[^\r\n]*/ @Newline > | < .+ > @Eof) { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14961
  def _RawLine; end

  # RawNoteBlock = @StartList:a (!@BlankLine !RawNoteReference OptionallyIndentedLine:l { a << l })+ < @BlankLine* > { a << text } { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15560
  def _RawNoteBlock; end

  # RawNoteReference = "[^" < (!@Newline !"]" .)+ > "]" { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15237
  def _RawNoteReference; end

  # RefSrc = < Nonspacechar+ > { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#12026
  def _RefSrc; end

  # RefTitle = (RefTitleSingle | RefTitleDouble | RefTitleParens | EmptyTitle)
  #
  # source://rdoc//lib/rdoc/markdown.rb#12062
  def _RefTitle; end

  # RefTitleDouble = Spnl "\"" < (!("\"" @Sp @Newline | @Newline) .)* > "\"" { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#12185
  def _RefTitleDouble; end

  # RefTitleParens = Spnl "(" < (!(")" @Sp @Newline | @Newline) .)* > ")" { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#12277
  def _RefTitleParens; end

  # RefTitleSingle = Spnl "'" < (!("'" @Sp @Newline | @Newline) .)* > "'" { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#12093
  def _RefTitleSingle; end

  # Reference = @NonindentSpace !"[]" Label:label ":" Spnl RefSrc:link RefTitle @BlankLine+ { # TODO use title               reference label, link               nil             }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11832
  def _Reference; end

  # ReferenceLink = (ReferenceLinkDouble | ReferenceLinkSingle)
  #
  # source://rdoc//lib/rdoc/markdown.rb#11032
  def _ReferenceLink; end

  # ReferenceLinkDouble = Label:content < Spnl > !"[]" Label:label { link_to content, label, text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11050
  def _ReferenceLinkDouble; end

  # ReferenceLinkSingle = Label:content < (Spnl "[]")? > { link_to content, content, text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11096
  def _ReferenceLinkSingle; end

  # References = (Reference | SkipBlock)*
  #
  # source://rdoc//lib/rdoc/markdown.rb#12369
  def _References; end

  # SetextBottom1 = /={1,}/ @Newline
  #
  # source://rdoc//lib/rdoc/markdown.rb#1262
  def _SetextBottom1; end

  # SetextBottom2 = /-{1,}/ @Newline
  #
  # source://rdoc//lib/rdoc/markdown.rb#1283
  def _SetextBottom2; end

  # SetextHeading = (SetextHeading1 | SetextHeading2)
  #
  # source://rdoc//lib/rdoc/markdown.rb#1244
  def _SetextHeading; end

  # SetextHeading1 = &(@RawLine SetextBottom1) @StartList:a (!@Endline Inline:b { a << b })+ @Sp @Newline SetextBottom1 { RDoc::Markup::Heading.new(1, a.join) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1304
  def _SetextHeading1; end

  # SetextHeading2 = &(@RawLine SetextBottom2) @StartList:a (!@Endline Inline:b { a << b })+ @Sp @Newline SetextBottom2 { RDoc::Markup::Heading.new(2, a.join) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1426
  def _SetextHeading2; end

  # SkipBlock = (HtmlBlock | (!"#" !SetextBottom1 !SetextBottom2 !@BlankLine @RawLine)+ @BlankLine* | @BlankLine+ | @RawLine)
  #
  # source://rdoc//lib/rdoc/markdown.rb#15040
  def _SkipBlock; end

  # Source = ("<" < SourceContents > ">" | < SourceContents >) { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11206
  def _Source; end

  # SourceContents = ((!"(" !")" !">" Nonspacechar)+ | "(" SourceContents ")")*
  #
  # source://rdoc//lib/rdoc/markdown.rb#11266
  def _SourceContents; end

  # Sp = @Spacechar*
  #
  # source://rdoc//lib/rdoc/markdown.rb#14584
  def _Sp; end

  # Space = @Spacechar+ { " " }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9646
  def _Space; end

  # Spacechar = %literals.Spacechar
  #
  # source://rdoc//lib/rdoc/markdown.rb#14733
  def _Spacechar; end

  # SpecialChar = (/[~*_`&\[\]()<!#\\'"]/ | @ExtendedSpecialChar)
  #
  # source://rdoc//lib/rdoc/markdown.rb#14635
  def _SpecialChar; end

  # Spnl = @Sp (@Newline @Sp)?
  #
  # source://rdoc//lib/rdoc/markdown.rb#14595
  def _Spnl; end

  # StarLine = (< /\*{4,}/ > { text } | < @Spacechar /\*+/ &@Spacechar > { text })
  #
  # source://rdoc//lib/rdoc/markdown.rb#10129
  def _StarLine; end

  # StartList = &. { [] }
  #
  # source://rdoc//lib/rdoc/markdown.rb#14914
  def _StartList; end

  # Str = @StartList:a < @NormalChar+ > { a = text } (StrChunk:c { a << c })* { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9678
  def _Str; end

  # StrChunk = < (@NormalChar | /_+/ &Alphanumeric)+ > { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9751
  def _StrChunk; end

  # Strike = &{ strike? } "~~" !@Whitespace @StartList:a (!"~~" Inline:b { a << b })+ "~~" { strike a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10861
  def _Strike; end

  # Strong = (StrongStar | StrongUl)
  #
  # source://rdoc//lib/rdoc/markdown.rb#10635
  def _Strong; end

  # StrongStar = "**" !@Whitespace @StartList:a (!"**" Inline:b { a << b })+ "**" { strong a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10653
  def _StrongStar; end

  # StrongUl = "__" !@Whitespace @StartList:a (!"__" Inline:b { a << b })+ "__" { strong a.join }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10757
  def _StrongUl; end

  # StyleBlock = < InStyleTags > @BlankLine* { if css? then                     RDoc::Markup::Raw.new text                   end }
  #
  # source://rdoc//lib/rdoc/markdown.rb#9328
  def _StyleBlock; end

  # StyleClose = "<" Spnl "/" ("style" | "STYLE") Spnl ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#9229
  def _StyleClose; end

  # StyleOpen = "<" Spnl ("style" | "STYLE") Spnl HtmlAttribute* ">"
  #
  # source://rdoc//lib/rdoc/markdown.rb#9173
  def _StyleOpen; end

  # Symbol = < @SpecialChar > { text }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10069
  def _Symbol; end

  # Table = &{ github? } TableHead:header TableLine:line TableRow+:body { table = RDoc::Markup::Table.new(header, line, body) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15937
  def _Table; end

  # TableAlign = < /:?-+:?/ > @Sp {                 text.start_with?(":") ?                 (text.end_with?(":") ? :center : :left) :                 (text.end_with?(":") ? :right : nil)               }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16304
  def _TableAlign; end

  # TableAlign2 = "|" @Sp TableAlign
  #
  # source://rdoc//lib/rdoc/markdown.rb#16278
  def _TableAlign2; end

  # TableHead = TableItem2+:items "|"? @Newline { items }
  #
  # source://rdoc//lib/rdoc/markdown.rb#15993
  def _TableHead; end

  # TableItem = < /(?:\\.|[^|\n])+/ > { text.strip.gsub(/\\(.)/, '\1')  }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16159
  def _TableItem; end

  # TableItem2 = "|" TableItem
  #
  # source://rdoc//lib/rdoc/markdown.rb#16138
  def _TableItem2; end

  # TableLine = ((TableAlign:align1 TableAlign2*:aligns {[align1, *aligns] }):line | TableAlign2+:line) "|"? @Newline { line }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16185
  def _TableLine; end

  # TableRow = ((TableItem:item1 TableItem2*:items { [item1, *items] }):row | TableItem2+:row) "|"? @Newline { row }
  #
  # source://rdoc//lib/rdoc/markdown.rb#16045
  def _TableRow; end

  # TerminalEndline = @Sp @Newline @Eof
  #
  # source://rdoc//lib/rdoc/markdown.rb#10016
  def _TerminalEndline; end

  # Ticks1 = "`" !"`"
  #
  # source://rdoc//lib/rdoc/markdown.rb#12391
  def _Ticks1; end

  # Ticks2 = "``" !"`"
  #
  # source://rdoc//lib/rdoc/markdown.rb#12415
  def _Ticks2; end

  # Ticks3 = "```" !"`"
  #
  # source://rdoc//lib/rdoc/markdown.rb#12439
  def _Ticks3; end

  # Ticks4 = "````" !"`"
  #
  # source://rdoc//lib/rdoc/markdown.rb#12463
  def _Ticks4; end

  # Ticks5 = "`````" !"`"
  #
  # source://rdoc//lib/rdoc/markdown.rb#12487
  def _Ticks5; end

  # Title = (TitleSingle | TitleDouble | ""):a { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#11383
  def _Title; end

  # TitleDouble = "\"" (!("\"" @Sp (")" | @Newline)) .)* "\""
  #
  # source://rdoc//lib/rdoc/markdown.rb#11497
  def _TitleDouble; end

  # TitleSingle = "'" (!("'" @Sp (")" | @Newline)) .)* "'"
  #
  # source://rdoc//lib/rdoc/markdown.rb#11420
  def _TitleSingle; end

  # UlLine = (< /_{4,}/ > { text } | < @Spacechar /_+/ &@Spacechar > { text })
  #
  # source://rdoc//lib/rdoc/markdown.rb#10206
  def _UlLine; end

  # UlOrStarLine = (UlLine | StarLine):a { a }
  #
  # source://rdoc//lib/rdoc/markdown.rb#10095
  def _UlOrStarLine; end

  # Verbatim = VerbatimChunk+:a { RDoc::Markup::Verbatim.new(*a.flatten) }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1895
  def _Verbatim; end

  # VerbatimChunk = @BlankLine*:a NonblankIndentedLine+:b { a.concat b }
  #
  # source://rdoc//lib/rdoc/markdown.rb#1845
  def _VerbatimChunk; end

  # Whitespace = (@Spacechar | @Newline)
  #
  # source://rdoc//lib/rdoc/markdown.rb#10301
  def _Whitespace; end

  # root = Doc
  #
  # source://rdoc//lib/rdoc/markdown.rb#892
  def _root; end

  # source://rdoc//lib/rdoc/markdown.rb#502
  def apply(rule); end

  # source://rdoc//lib/rdoc/markdown.rb#468
  def apply_with_args(rule, *args); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def break_on_newline=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def break_on_newline?; end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def css=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def css?; end

  # source://rdoc//lib/rdoc/markdown.rb#250
  def current_character(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#211
  def current_column(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#234
  def current_line(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#259
  def current_pos_info(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def definition_lists=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def definition_lists?; end

  # Wraps `text` in emphasis for rdoc inline formatting
  #
  # source://rdoc//lib/rdoc/markdown.rb#683
  def emphasis(text); end

  # :category: Extensions
  #
  # Enables or disables the extension with `name`
  #
  # source://rdoc//lib/rdoc/markdown.rb#705
  def extension(name, enable); end

  # :category: Extensions
  #
  # Is the extension `name` enabled?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markdown.rb#696
  def extension?(name); end

  # source://rdoc//lib/rdoc/markdown.rb#449
  def external_invoke(other, rule, *args); end

  # Returns the value of attribute failed_rule.
  #
  # source://rdoc//lib/rdoc/markdown.rb#371
  def failed_rule; end

  # Returns the value of attribute failing_rule_offset.
  #
  # source://rdoc//lib/rdoc/markdown.rb#208
  def failing_rule_offset; end

  # source://rdoc//lib/rdoc/markdown.rb#318
  def failure_caret; end

  # source://rdoc//lib/rdoc/markdown.rb#323
  def failure_character; end

  # source://rdoc//lib/rdoc/markdown.rb#306
  def failure_info; end

  # source://rdoc//lib/rdoc/markdown.rb#327
  def failure_oneline; end

  # source://rdoc//lib/rdoc/markdown.rb#393
  def get_byte; end

  # source://rdoc//lib/rdoc/markdown.rb#271
  def get_line(no); end

  # source://rdoc//lib/rdoc/markdown.rb#285
  def get_text(start); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def github=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def github?; end

  # source://rdoc//lib/rdoc/markdown.rb#535
  def grow_lr(rule, args, start_pos, m); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def html=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def html?; end

  # Parses `text` in a clone of this parser.  This is used for handling nested
  # lists the same way as markdown_parser.
  #
  # source://rdoc//lib/rdoc/markdown.rb#717
  def inner_parse(text); end

  # source://rdoc//lib/rdoc/markdown.rb#267
  def lines; end

  # Finds a link reference for `label` and creates a new link to it with
  # `content` as the link text.  If `label` was not encountered in the
  # reference-gathering parser pass the label and content are reconstructed
  # with the linking `text` (usually whitespace).
  #
  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/markdown.rb#737
  def link_to(content, label = T.unsafe(nil), text = T.unsafe(nil)); end

  # Creates an RDoc::Markup::ListItem by parsing the `unparsed` content from
  # the first parsing pass.
  #
  # source://rdoc//lib/rdoc/markdown.rb#754
  def list_item_from(unparsed); end

  # source://rdoc//lib/rdoc/markdown.rb#373
  def match_string(str); end

  # Stores `label` as a note and fills in previously unknown note references.
  #
  # source://rdoc//lib/rdoc/markdown.rb#762
  def note(label); end

  # Creates a new link for the footnote `reference` and adds the reference to
  # the note order list for proper display at the end of the document.
  #
  # source://rdoc//lib/rdoc/markdown.rb#776
  def note_for(ref); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def notes=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def notes?; end

  # Creates an RDoc::Markup::Paragraph from `parts` and including
  # extension-specific behavior
  #
  # source://rdoc//lib/rdoc/markdown.rb#793
  def paragraph(parts); end

  # Parses `markdown` into an RDoc::Document
  #
  # source://rdoc//lib/rdoc/markdown.rb#808
  def parse(markdown); end

  # The internal kpeg parse method
  #
  # source://rdoc//lib/rdoc/markdown.rb#414
  def peg_parse(rule = T.unsafe(nil)); end

  # Returns the value of attribute pos.
  #
  # source://rdoc//lib/rdoc/markdown.rb#209
  def pos; end

  # Sets the attribute pos
  #
  # @param value the value to set the attribute pos to.
  #
  # source://rdoc//lib/rdoc/markdown.rb#209
  def pos=(_arg0); end

  # source://rdoc//lib/rdoc/markdown.rb#221
  def position_line_offsets; end

  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/markdown.rb#341
  def raise_error; end

  # Stores `label` as a reference to `link` and fills in previously unknown
  # link references.
  #
  # source://rdoc//lib/rdoc/markdown.rb#855
  def reference(label, link); end

  # Returns the value of attribute result.
  #
  # source://rdoc//lib/rdoc/markdown.rb#209
  def result; end

  # Sets the attribute result
  #
  # @param value the value to set the attribute result to.
  #
  # source://rdoc//lib/rdoc/markdown.rb#209
  def result=(_arg0); end

  # source://rdoc//lib/rdoc/markdown.rb#383
  def scan(reg); end

  # source://rdoc//lib/rdoc/markdown.rb#364
  def set_failed_rule(name); end

  # Sets the string and current parsing position for the parser.
  #
  # source://rdoc//lib/rdoc/markdown.rb#290
  def set_string(string, pos); end

  # :stopdoc:
  #
  # source://rdoc//lib/rdoc/markdown.rb#887
  def setup_foreign_grammar; end

  # Prepares for parsing +str+.  If you define a custom initialize you must
  # call this method before #parse
  #
  # source://rdoc//lib/rdoc/markdown.rb#196
  def setup_parser(str, debug = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#345
  def show_error(io = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown.rb#297
  def show_pos; end

  # Wraps `text` in strike markup for rdoc inline formatting
  #
  # source://rdoc//lib/rdoc/markdown.rb#877
  def strike(text); end

  # source://rdoc//lib/rdoc/markdown.rb#610
  def strike=(enable); end

  # source://rdoc//lib/rdoc/markdown.rb#606
  def strike?; end

  # Returns the value of attribute string.
  #
  # source://rdoc//lib/rdoc/markdown.rb#207
  def string; end

  # Wraps `text` in strong markup for rdoc inline formatting
  #
  # source://rdoc//lib/rdoc/markdown.rb#866
  def strong(text); end

  private

  # This is distinct from setup_parser so that a standalone parser
  # can redefine #initialize and still have access to the proper
  # parser setup code.
  # TODO remove when kpeg 0.10 is released
  #
  # @return [Markdown] a new instance of Markdown
  #
  # source://rdoc//lib/rdoc/markdown.rb#188
  def orig_initialize(str, debug = T.unsafe(nil)); end

  class << self
    # Creates extension methods for the `name` extension to enable and disable
    # the extension and to query if they are active.
    #
    # source://rdoc//lib/rdoc/markdown.rb#603
    def extension(name); end

    # Parses the `markdown` document into an RDoc::Document using the default
    # extensions.
    #
    # source://rdoc//lib/rdoc/markdown.rb#656
    def parse(markdown); end

    # source://rdoc//lib/rdoc/markdown.rb#566
    def rule_info(name, rendered); end
  end
end

# source://rdoc//lib/rdoc/markdown.rb#257
class RDoc::Markdown::KpegPosInfo < ::Struct
  # Returns the value of attribute char
  #
  # @return [Object] the current value of char
  def char; end

  # Sets the attribute char
  #
  # @param value [Object] the value to set the attribute char to.
  # @return [Object] the newly set value
  def char=(_); end

  # Returns the value of attribute col
  #
  # @return [Object] the current value of col
  def col; end

  # Sets the attribute col
  #
  # @param value [Object] the value to set the attribute col to.
  # @return [Object] the newly set value
  def col=(_); end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def line; end

  # Sets the attribute line
  #
  # @param value [Object] the value to set the attribute line to.
  # @return [Object] the newly set value
  def line=(_); end

  # Returns the value of attribute lno
  #
  # @return [Object] the current value of lno
  def lno; end

  # Sets the attribute lno
  #
  # @param value [Object] the value to set the attribute lno to.
  # @return [Object] the newly set value
  def lno=(_); end

  # Returns the value of attribute pos
  #
  # @return [Object] the current value of pos
  def pos; end

  # Sets the attribute pos
  #
  # @param value [Object] the value to set the attribute pos to.
  # @return [Object] the newly set value
  def pos=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This set of literals is for Ruby 1.9 regular expressions and gives full
# unicode support.
#
# Unlike peg-markdown, this set of literals recognizes Unicode alphanumeric
# characters, newlines and spaces.
#
# source://rdoc//lib/rdoc/markdown/literals.rb#11
class RDoc::Markdown::Literals
  # This is distinct from setup_parser so that a standalone parser
  # can redefine #initialize and still have access to the proper
  # parser setup code.
  #
  # @return [Literals] a new instance of Literals
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#17
  def initialize(str, debug = T.unsafe(nil)); end

  # Alphanumeric = /\p{Word}/
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#405
  def _Alphanumeric; end

  # AlphanumericAscii = /[A-Za-z0-9]/
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#412
  def _AlphanumericAscii; end

  # BOM = "uFEFF"
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#419
  def _BOM; end

  # Newline = /\n|\r\n?|\p{Zl}|\p{Zp}/
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#426
  def _Newline; end

  # NonAlphanumeric = /\p{^Word}/
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#433
  def _NonAlphanumeric; end

  # Spacechar = /\t|\p{Zs}/
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#440
  def _Spacechar; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#331
  def apply(rule); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#297
  def apply_with_args(rule, *args); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#79
  def current_character(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#40
  def current_column(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#63
  def current_line(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#88
  def current_pos_info(target = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#278
  def external_invoke(other, rule, *args); end

  # Returns the value of attribute failed_rule.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#200
  def failed_rule; end

  # Returns the value of attribute failing_rule_offset.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#37
  def failing_rule_offset; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#147
  def failure_caret; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#152
  def failure_character; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#135
  def failure_info; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#156
  def failure_oneline; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#222
  def get_byte; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#100
  def get_line(no); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#114
  def get_text(start); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#364
  def grow_lr(rule, args, start_pos, m); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#96
  def lines; end

  # source://rdoc//lib/rdoc/markdown/literals.rb#202
  def match_string(str); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#243
  def parse(rule = T.unsafe(nil)); end

  # Returns the value of attribute pos.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#38
  def pos; end

  # Sets the attribute pos
  #
  # @param value the value to set the attribute pos to.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#38
  def pos=(_arg0); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#50
  def position_line_offsets; end

  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#170
  def raise_error; end

  # Returns the value of attribute result.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#38
  def result; end

  # Sets the attribute result
  #
  # @param value the value to set the attribute result to.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#38
  def result=(_arg0); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#212
  def scan(reg); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#193
  def set_failed_rule(name); end

  # Sets the string and current parsing position for the parser.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#119
  def set_string(string, pos); end

  # :startdoc:
  # :stopdoc:
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#402
  def setup_foreign_grammar; end

  # Prepares for parsing +str+.  If you define a custom initialize you must
  # call this method before #parse
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#25
  def setup_parser(str, debug = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#174
  def show_error(io = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#126
  def show_pos; end

  # Returns the value of attribute string.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#36
  def string; end

  class << self
    # source://rdoc//lib/rdoc/markdown/literals.rb#395
    def rule_info(name, rendered); end
  end
end

# source://rdoc//lib/rdoc/markdown/literals.rb#86
class RDoc::Markdown::Literals::KpegPosInfo < ::Struct
  # Returns the value of attribute char
  #
  # @return [Object] the current value of char
  def char; end

  # Sets the attribute char
  #
  # @param value [Object] the value to set the attribute char to.
  # @return [Object] the newly set value
  def char=(_); end

  # Returns the value of attribute col
  #
  # @return [Object] the current value of col
  def col; end

  # Sets the attribute col
  #
  # @param value [Object] the value to set the attribute col to.
  # @return [Object] the newly set value
  def col=(_); end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def line; end

  # Sets the attribute line
  #
  # @param value [Object] the value to set the attribute line to.
  # @return [Object] the newly set value
  def line=(_); end

  # Returns the value of attribute lno
  #
  # @return [Object] the current value of lno
  def lno; end

  # Sets the attribute lno
  #
  # @param value [Object] the value to set the attribute lno to.
  # @return [Object] the newly set value
  def lno=(_); end

  # Returns the value of attribute pos
  #
  # @return [Object] the current value of pos
  def pos; end

  # Sets the attribute pos
  #
  # @param value [Object] the value to set the attribute pos to.
  # @return [Object] the newly set value
  def pos=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rdoc//lib/rdoc/markdown/literals.rb#257
class RDoc::Markdown::Literals::MemoEntry
  # @return [MemoEntry] a new instance of MemoEntry
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#258
  def initialize(ans, pos); end

  # Returns the value of attribute ans.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#266
  def ans; end

  # Returns the value of attribute left_rec.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#267
  def left_rec; end

  # Sets the attribute left_rec
  #
  # @param value the value to set the attribute left_rec to.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#267
  def left_rec=(_arg0); end

  # source://rdoc//lib/rdoc/markdown/literals.rb#269
  def move!(ans, pos, result); end

  # Returns the value of attribute pos.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#266
  def pos; end

  # Returns the value of attribute result.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#266
  def result; end

  # Returns the value of attribute set.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#266
  def set; end
end

# source://rdoc//lib/rdoc/markdown/literals.rb#386
class RDoc::Markdown::Literals::RuleInfo
  # @return [RuleInfo] a new instance of RuleInfo
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#387
  def initialize(name, rendered); end

  # Returns the value of attribute name.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#392
  def name; end

  # Returns the value of attribute rendered.
  #
  # source://rdoc//lib/rdoc/markdown/literals.rb#392
  def rendered; end
end

# source://rdoc//lib/rdoc/markdown.rb#428
class RDoc::Markdown::MemoEntry
  # @return [MemoEntry] a new instance of MemoEntry
  #
  # source://rdoc//lib/rdoc/markdown.rb#429
  def initialize(ans, pos); end

  # Returns the value of attribute ans.
  #
  # source://rdoc//lib/rdoc/markdown.rb#437
  def ans; end

  # Returns the value of attribute left_rec.
  #
  # source://rdoc//lib/rdoc/markdown.rb#438
  def left_rec; end

  # Sets the attribute left_rec
  #
  # @param value the value to set the attribute left_rec to.
  #
  # source://rdoc//lib/rdoc/markdown.rb#438
  def left_rec=(_arg0); end

  # source://rdoc//lib/rdoc/markdown.rb#440
  def move!(ans, pos, result); end

  # Returns the value of attribute pos.
  #
  # source://rdoc//lib/rdoc/markdown.rb#437
  def pos; end

  # Returns the value of attribute result.
  #
  # source://rdoc//lib/rdoc/markdown.rb#437
  def result; end

  # Returns the value of attribute set.
  #
  # source://rdoc//lib/rdoc/markdown.rb#437
  def set; end
end

# source://rdoc//lib/rdoc/markdown.rb#557
class RDoc::Markdown::RuleInfo
  # @return [RuleInfo] a new instance of RuleInfo
  #
  # source://rdoc//lib/rdoc/markdown.rb#558
  def initialize(name, rendered); end

  # Returns the value of attribute name.
  #
  # source://rdoc//lib/rdoc/markdown.rb#563
  def name; end

  # Returns the value of attribute rendered.
  #
  # source://rdoc//lib/rdoc/markdown.rb#563
  def rendered; end
end

# source://rdoc//lib/rdoc/markup.rb#106
class RDoc::Markup
  # Take a block of text and use various heuristics to determine its
  # structure (paragraphs, lists, and so on).  Invoke an event handler as we
  # identify significant chunks.
  #
  # @return [Markup] a new instance of Markup
  #
  # source://rdoc//lib/rdoc/markup.rb#146
  def initialize(attribute_manager = T.unsafe(nil)); end

  # Add to the sequences recognized as general markup.
  #
  # source://rdoc//lib/rdoc/markup.rb#163
  def add_html(tag, name); end

  # Add to other inline sequences.  For example, we could add WikiWords using
  # something like:
  #
  #    parser.add_regexp_handling(/\b([A-Z][a-z]+[A-Z]\w+)/, :WIKIWORD)
  #
  # Each wiki word will be presented to the output formatter.
  #
  # source://rdoc//lib/rdoc/markup.rb#175
  def add_regexp_handling(pattern, name); end

  # Add to the sequences used to add formatting to an individual word (such
  # as *bold*).  Matching entries will generate attributes that the output
  # formatters can recognize by their +name+.
  #
  # source://rdoc//lib/rdoc/markup.rb#156
  def add_word_pair(start, stop, name); end

  # An AttributeManager which handles inline markup.
  #
  # source://rdoc//lib/rdoc/markup.rb#111
  def attribute_manager; end

  # We take +input+, parse it if necessary, then invoke the output +formatter+
  # using a Visitor to render the result.
  #
  # source://rdoc//lib/rdoc/markup.rb#183
  def convert(input, formatter); end

  class << self
    # Parses +str+ into an RDoc::Markup::Document.
    #
    # source://rdoc//lib/rdoc/markup.rb#116
    def parse(str); end
  end
end

# An AttrChanger records a change in attributes. It contains a bitmap of the
# attributes to turn on, and a bitmap of those to turn off.
#
# source://rdoc//lib/rdoc/markup/attr_changer.rb#4
class RDoc::Markup::AttrChanger < ::Struct
  # source://rdoc//lib/rdoc/markup/attr_changer.rb#18
  def inspect; end

  # source://rdoc//lib/rdoc/markup/attr_changer.rb#14
  def to_s; end
end

# An array of attributes which parallels the characters in a string.
#
# source://rdoc//lib/rdoc/markup/attr_span.rb#5
class RDoc::Markup::AttrSpan
  # Creates a new AttrSpan for +length+ characters
  #
  # @return [AttrSpan] a new instance of AttrSpan
  #
  # source://rdoc//lib/rdoc/markup/attr_span.rb#10
  def initialize(length, exclusive); end

  # Accesses flags for character +n+
  #
  # source://rdoc//lib/rdoc/markup/attr_span.rb#31
  def [](n); end

  # Toggles +bits+ from +start+ to +length+
  #
  # source://rdoc//lib/rdoc/markup/attr_span.rb#17
  def set_attrs(start, length, bits); end
end

# Manages changes of attributes in a block of text
#
# source://rdoc//lib/rdoc/markup/attribute_manager.rb#6
class RDoc::Markup::AttributeManager
  # Creates a new attribute manager that understands bold, emphasized and
  # teletype text.
  #
  # @return [AttributeManager] a new instance of AttributeManager
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#80
  def initialize; end

  # Adds a markup class with +name+ for words surrounded by HTML tag +tag+.
  # To process emphasis tags:
  #
  #   am.add_html 'em', :EM
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#286
  def add_html(tag, name, exclusive = T.unsafe(nil)); end

  # Adds a regexp handling for +pattern+ with +name+.  A simple URL handler
  # would be:
  #
  #   @am.add_regexp_handling(/((https?:)\S+\w)/, :HYPERLINK)
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#298
  def add_regexp_handling(pattern, name, exclusive = T.unsafe(nil)); end

  # Adds a markup class with +name+ for words wrapped in the +start+ and
  # +stop+ character.  To make words wrapped with "*" bold:
  #
  #   am.add_word_pair '*', '*', :BOLD
  #
  # @raise [ArgumentError]
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#261
  def add_word_pair(start, stop, name, exclusive = T.unsafe(nil)); end

  # Return an attribute object with the given turn_on and turn_off bits set
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#103
  def attribute(turn_on, turn_off); end

  # The attributes enabled for this markup object.
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#40
  def attributes; end

  # Changes the current attribute from +current+ to +new+
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#110
  def change_attribute(current, new); end

  # Used by the tests to change attributes by name from +current_set+ to
  # +new_set+
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#119
  def changed_attribute_by_name(current_set, new_set); end

  # Map attributes like <b>text</b>to the sequence
  # \001\002<char>\001\003<char>, where <char> is a per-attribute specific
  # character
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#154
  def convert_attrs(str, attrs, exclusive = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#160
  def convert_attrs_matching_word_pairs(str, attrs, exclusive); end

  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#185
  def convert_attrs_word_pair_map(str, attrs, exclusive); end

  # Converts HTML tags to RDoc attributes
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#206
  def convert_html(str, attrs, exclusive = T.unsafe(nil)); end

  # Converts regexp handling sequences to RDoc attributes
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#223
  def convert_regexp_handlings(str, attrs, exclusive = T.unsafe(nil)); end

  # Copies +start_pos+ to +end_pos+ from the current string
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#135
  def copy_string(start_pos, end_pos); end

  # Debug method that prints a string along with its attributes
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#329
  def display_attributes; end

  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#142
  def exclusive?(attr); end

  # A bits of exclusive maps
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#74
  def exclusive_bitmap; end

  # Processes +str+ converting attributes, HTML and regexp handlings
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#307
  def flow(str); end

  # This maps HTML tags to the corresponding attribute char
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#58
  def html_tags; end

  # Escapes regexp handling sequences of text to prevent conversion to RDoc
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#239
  def mask_protected_sequences; end

  # This maps delimiters that occur around words (such as *bold* or +tt+)
  # where the start and end delimiters and the same. This lets us optimize
  # the regexp
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#47
  def matching_word_pairs; end

  # A \ in front of a character that would normally be processed turns off
  # processing. We do this by turning \< into <#{PROTECT}
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#64
  def protectable; end

  # And this maps _regexp handling_ sequences to a name. A regexp handling
  # sequence is something like a WikiWord
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#70
  def regexp_handlings; end

  # Splits the string into chunks by attribute change
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#354
  def split_into_flow; end

  # Unescapes regexp handling sequences of text
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#251
  def unmask_protected_sequences; end

  # And this is used when the delimiters aren't the same. In this case the
  # hash maps a pattern to the attribute character
  #
  # source://rdoc//lib/rdoc/markup/attribute_manager.rb#53
  def word_pair_map; end
end

# source://rdoc//lib/rdoc/markup/attribute_manager.rb#147
RDoc::Markup::AttributeManager::NON_PRINTING_END = T.let(T.unsafe(nil), String)

# source://rdoc//lib/rdoc/markup/attribute_manager.rb#146
RDoc::Markup::AttributeManager::NON_PRINTING_START = T.let(T.unsafe(nil), String)

# We manage a set of attributes.  Each attribute has a symbol name and a bit
# value.
#
# source://rdoc//lib/rdoc/markup/attributes.rb#6
class RDoc::Markup::Attributes
  # Creates a new attributes set.
  #
  # @return [Attributes] a new instance of Attributes
  #
  # source://rdoc//lib/rdoc/markup/attributes.rb#16
  def initialize; end

  # Returns a string representation of +bitmap+
  #
  # source://rdoc//lib/rdoc/markup/attributes.rb#46
  def as_string(bitmap); end

  # Returns a unique bit for +name+
  #
  # source://rdoc//lib/rdoc/markup/attributes.rb#29
  def bitmap_for(name); end

  # yields each attribute name in +bitmap+
  #
  # source://rdoc//lib/rdoc/markup/attributes.rb#60
  def each_name_of(bitmap); end

  # The regexp handling attribute type. See RDoc::Markup#add_regexp_handling
  #
  # source://rdoc//lib/rdoc/markup/attributes.rb#11
  def regexp_handling; end
end

# An empty line.  This class is a singleton.
#
# source://rdoc//lib/rdoc/markup/blank_line.rb#5
class RDoc::Markup::BlankLine
  # Calls #accept_blank_line on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/blank_line.rb#19
  def accept(visitor); end

  # source://rdoc//lib/rdoc/markup/blank_line.rb#23
  def pretty_print(q); end

  class << self
    # RDoc::Markup::BlankLine is a singleton
    #
    # source://rdoc//lib/rdoc/markup/blank_line.rb#12
    def new; end
  end
end

# A quoted section which contains markup items.
#
# source://rdoc//lib/rdoc/markup/block_quote.rb#5
class RDoc::Markup::BlockQuote < ::RDoc::Markup::Raw
  # Calls #accept_block_quote on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/block_quote.rb#10
  def accept(visitor); end
end

# A Document containing lists, headings, paragraphs, etc.
#
# source://rdoc//lib/rdoc/markup/document.rb#5
class RDoc::Markup::Document
  include ::Enumerable

  # Creates a new Document with +parts+
  #
  # @return [Document] a new instance of Document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#29
  def initialize(*parts); end

  # Appends +part+ to the document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#40
  def <<(part); end

  # source://rdoc//lib/rdoc/markup/document.rb#56
  def ==(other); end

  # Runs this document and all its #items through +visitor+
  #
  # source://rdoc//lib/rdoc/markup/document.rb#65
  def accept(visitor); end

  # Concatenates the given +parts+ onto the document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#76
  def concat(parts); end

  # Enumerator for the parts of this document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#83
  def each(&block); end

  # Does this document have no parts?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/document.rb#90
  def empty?; end

  # The file this document was created from.  See also
  # RDoc::ClassModule#add_comment
  #
  # source://rdoc//lib/rdoc/markup/document.rb#13
  def file; end

  # The file this Document was created from.
  #
  # source://rdoc//lib/rdoc/markup/document.rb#97
  def file=(location); end

  # When this is a collection of documents (#file is not set and this document
  # contains only other documents as its direct children) #merge replaces
  # documents in this class with documents from +other+ when the file matches
  # and adds documents from +other+ when the files do not.
  #
  # The information in +other+ is preferred over the receiver
  #
  # source://rdoc//lib/rdoc/markup/document.rb#114
  def merge(other); end

  # Does this Document contain other Documents?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/document.rb#134
  def merged?; end

  # If a heading is below the given level it will be omitted from the
  # table_of_contents
  #
  # source://rdoc//lib/rdoc/markup/document.rb#19
  def omit_headings_below; end

  # If a heading is below the given level it will be omitted from the
  # table_of_contents
  #
  # source://rdoc//lib/rdoc/markup/document.rb#19
  def omit_headings_below=(_arg0); end

  # The parts of the Document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#24
  def parts; end

  # source://rdoc//lib/rdoc/markup/document.rb#138
  def pretty_print(q); end

  # Appends +parts+ to the document
  #
  # source://rdoc//lib/rdoc/markup/document.rb#151
  def push(*parts); end

  # Returns an Array of headings in the document.
  #
  # Require 'rdoc/markup/formatter' before calling this method.
  #
  # source://rdoc//lib/rdoc/markup/document.rb#160
  def table_of_contents; end
end

# Base class for RDoc markup formatters
#
# Formatters are a visitor that converts an RDoc::Markup tree (from a comment)
# into some kind of output.  RDoc ships with formatters for converting back to
# rdoc, ANSI text, HTML, a Table of Contents and other formats.
#
# If you'd like to write your own Formatter use
# RDoc::Markup::FormatterTestCase.  If you're writing a text-output formatter
# use RDoc::Markup::TextFormatterTestCase which provides extra test cases.
#
# source://rdoc//lib/rdoc/markup/formatter.rb#13
class RDoc::Markup::Formatter
  # Creates a new Formatter
  #
  # @return [Formatter] a new instance of Formatter
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#48
  def initialize(options, markup = T.unsafe(nil)); end

  # Adds +document+ to the output
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#69
  def accept_document(document); end

  # Adds a regexp handling for links of the form rdoc-...:
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#83
  def add_regexp_handling_RDOCLINK; end

  # Adds a regexp handling for links of the form {<text>}[<url>] and
  # <word>[<url>]
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#91
  def add_regexp_handling_TIDYLINK; end

  # Add a new set of tags for an attribute. We allow separate start and end
  # tags for flexibility
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#105
  def add_tag(name, start, stop); end

  # Allows +tag+ to be decorated with additional information.
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#113
  def annotate(tag); end

  # Marks up +content+
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#120
  def convert(content); end

  # Converts flow items +flow+
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#127
  def convert_flow(flow); end

  # Converts added regexp handlings. See RDoc::Markup#add_regexp_handling
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#150
  def convert_regexp_handling(target); end

  # Converts a string to be fancier if desired
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#176
  def convert_string(string); end

  # Use ignore in your subclass to ignore the content of a node.
  #
  #   ##
  #   # We don't support raw nodes in ToNoRaw
  #
  #   alias accept_raw ignore
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def ignore(*node); end

  # Are we currently inside tt tags?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#194
  def in_tt?; end

  # Turns off tags for +item+ on +res+
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#216
  def off_tags(res, item); end

  # Turns on tags for +item+ on +res+
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#201
  def on_tags(res, item); end

  # Extracts and a scheme, url and an anchor id from +url+ and returns them.
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#231
  def parse_url(url); end

  # Is +tag+ a tt tag?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#261
  def tt?(tag); end

  class << self
    # Converts a target url to one that is relative to a given path
    #
    # source://rdoc//lib/rdoc/markup/formatter.rb#24
    def gen_relative_url(path, target); end
  end
end

# A hard-break in the middle of a paragraph.
#
# source://rdoc//lib/rdoc/markup/hard_break.rb#5
class RDoc::Markup::HardBreak
  # source://rdoc//lib/rdoc/markup/hard_break.rb#23
  def ==(other); end

  # Calls #accept_hard_break on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/hard_break.rb#19
  def accept(visitor); end

  # source://rdoc//lib/rdoc/markup/hard_break.rb#27
  def pretty_print(q); end

  class << self
    # RDoc::Markup::HardBreak is a singleton
    #
    # source://rdoc//lib/rdoc/markup/hard_break.rb#12
    def new; end
  end
end

# source://rdoc//lib/rdoc/markup/heading.rb#6
class RDoc::Markup::Heading < ::Struct
  # source://rdoc//lib/rdoc/markup/heading.rb#40
  def accept(visitor); end

  # source://rdoc//lib/rdoc/markup/heading.rb#47
  def aref; end

  # source://rdoc//lib/rdoc/markup/heading.rb#55
  def label(context = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markup/heading.rb#68
  def plain_html; end

  # source://rdoc//lib/rdoc/markup/heading.rb#72
  def pretty_print(q); end

  class << self
    # source://rdoc//lib/rdoc/markup/heading.rb#22
    def to_html; end

    # source://rdoc//lib/rdoc/markup/heading.rb#14
    def to_label; end
  end
end

# A file included at generation time.  Objects of this class are created by
# RDoc::RD for an extension-less include.
#
# This implementation in incomplete.
#
# source://rdoc//lib/rdoc/markup/include.rb#8
class RDoc::Markup::Include
  # Creates a new include that will import +file+ from +include_path+
  #
  # @return [Include] a new instance of Include
  #
  # source://rdoc//lib/rdoc/markup/include.rb#23
  def initialize(file, include_path); end

  # source://rdoc//lib/rdoc/markup/include.rb#28
  def ==(other); end

  # The filename to be included, without extension
  #
  # source://rdoc//lib/rdoc/markup/include.rb#13
  def file; end

  # Directories to search for #file
  #
  # source://rdoc//lib/rdoc/markup/include.rb#18
  def include_path; end

  # source://rdoc//lib/rdoc/markup/include.rb#33
  def pretty_print(q); end
end

# An Indented Paragraph of text
#
# source://rdoc//lib/rdoc/markup/indented_paragraph.rb#5
class RDoc::Markup::IndentedParagraph < ::RDoc::Markup::Raw
  # Creates a new IndentedParagraph containing +parts+ indented with +indent+
  # spaces
  #
  # @return [IndentedParagraph] a new instance of IndentedParagraph
  #
  # source://rdoc//lib/rdoc/markup/indented_paragraph.rb#16
  def initialize(indent, *parts); end

  # source://rdoc//lib/rdoc/markup/indented_paragraph.rb#22
  def ==(other); end

  # Calls #accept_indented_paragraph on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/indented_paragraph.rb#29
  def accept(visitor); end

  # The indent in number of spaces
  #
  # source://rdoc//lib/rdoc/markup/indented_paragraph.rb#10
  def indent; end

  # Joins the raw paragraph text and converts inline HardBreaks to the
  # +hard_break+ text followed by the indent.
  #
  # source://rdoc//lib/rdoc/markup/indented_paragraph.rb#37
  def text(hard_break = T.unsafe(nil)); end
end

# A List is a homogeneous set of ListItems.
#
# The supported list types include:
#
# :BULLET::
#   An unordered list
# :LABEL::
#   An unordered definition list, but using an alternate RDoc::Markup syntax
# :LALPHA::
#   An ordered list using increasing lowercase English letters
# :NOTE::
#   An unordered definition list
# :NUMBER::
#   An ordered list using increasing Arabic numerals
# :UALPHA::
#   An ordered list using increasing uppercase English letters
#
# Definition lists behave like HTML definition lists.  Each list item can
# describe multiple terms.  See RDoc::Markup::ListItem for how labels and
# definition are stored as list items.
#
# source://rdoc//lib/rdoc/markup/list.rb#24
class RDoc::Markup::List
  # Creates a new list of +type+ with +items+.  Valid list types are:
  # +:BULLET+, +:LABEL+, +:LALPHA+, +:NOTE+, +:NUMBER+, +:UALPHA+
  #
  # @return [List] a new instance of List
  #
  # source://rdoc//lib/rdoc/markup/list.rb#40
  def initialize(type = T.unsafe(nil), *items); end

  # Appends +item+ to the list
  #
  # source://rdoc//lib/rdoc/markup/list.rb#49
  def <<(item); end

  # source://rdoc//lib/rdoc/markup/list.rb#53
  def ==(other); end

  # Runs this list and all its #items through +visitor+
  #
  # source://rdoc//lib/rdoc/markup/list.rb#62
  def accept(visitor); end

  # Is the list empty?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/list.rb#75
  def empty?; end

  # Items in the list
  #
  # source://rdoc//lib/rdoc/markup/list.rb#34
  def items; end

  # Returns the last item in the list
  #
  # source://rdoc//lib/rdoc/markup/list.rb#82
  def last; end

  # source://rdoc//lib/rdoc/markup/list.rb#86
  def pretty_print(q); end

  # Appends +items+ to the list
  #
  # source://rdoc//lib/rdoc/markup/list.rb#97
  def push(*items); end

  # The list's type
  #
  # source://rdoc//lib/rdoc/markup/list.rb#29
  def type; end

  # The list's type
  #
  # source://rdoc//lib/rdoc/markup/list.rb#29
  def type=(_arg0); end
end

# An item within a List that contains paragraphs, headings, etc.
#
# For BULLET, NUMBER, LALPHA and UALPHA lists, the label will always be nil.
# For NOTE and LABEL lists, the list label may contain:
#
# * a single String for a single label
# * an Array of Strings for a list item with multiple terms
# * nil for an extra description attached to a previously labeled list item
#
# source://rdoc//lib/rdoc/markup/list_item.rb#12
class RDoc::Markup::ListItem
  # Creates a new ListItem with an optional +label+ containing +parts+
  #
  # @return [ListItem] a new instance of ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#27
  def initialize(label = T.unsafe(nil), *parts); end

  # Appends +part+ to the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#36
  def <<(part); end

  # source://rdoc//lib/rdoc/markup/list_item.rb#40
  def ==(other); end

  # Runs this list item and all its #parts through +visitor+
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#49
  def accept(visitor); end

  # Is the ListItem empty?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#62
  def empty?; end

  # The label for the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#17
  def label; end

  # The label for the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#17
  def label=(_arg0); end

  # Length of parts in the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#69
  def length; end

  # Parts of the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#22
  def parts; end

  # source://rdoc//lib/rdoc/markup/list_item.rb#73
  def pretty_print(q); end

  # Adds +parts+ to the ListItem
  #
  # source://rdoc//lib/rdoc/markup/list_item.rb#95
  def push(*parts); end
end

# A Paragraph of text
#
# source://rdoc//lib/rdoc/markup/paragraph.rb#5
class RDoc::Markup::Paragraph < ::RDoc::Markup::Raw
  # Calls #accept_paragraph on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/paragraph.rb#10
  def accept(visitor); end

  # Joins the raw paragraph text and converts inline HardBreaks to the
  # +hard_break+ text.
  #
  # source://rdoc//lib/rdoc/markup/paragraph.rb#18
  def text(hard_break = T.unsafe(nil)); end
end

# A recursive-descent parser for RDoc markup.
#
# The parser tokenizes an input string then parses the tokens into a Document.
# Documents can be converted into output formats by writing a visitor like
# RDoc::Markup::ToHTML.
#
# The parser only handles the block-level constructs Paragraph, List,
# ListItem, Heading, Verbatim, BlankLine, Rule and BlockQuote.
# Inline markup such as <tt>\+blah\+</tt> is handled separately by
# RDoc::Markup::AttributeManager.
#
# To see what markup the Parser implements read RDoc.  To see how to use
# RDoc markup to format text in your program read RDoc::Markup.
#
# source://rdoc//lib/rdoc/markup/parser.rb#19
class RDoc::Markup::Parser
  include ::RDoc::Text

  # Creates a new Parser.  See also ::parse
  #
  # @return [Parser] a new instance of Parser
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#79
  def initialize; end

  # Builds a Heading of +level+
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#90
  def build_heading(level); end

  # Builds a List flush to +margin+
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#108
  def build_list(margin); end

  # Builds a Paragraph that is flush to +margin+
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#208
  def build_paragraph(margin); end

  # Builds a Verbatim that is indented from +margin+.
  #
  # The verbatim block is shifted left (the least indented lines start in
  # column 0).  Each part of the verbatim is one line of text, always
  # terminated by a newline.  Blank lines always consist of a single newline
  # character, and there is never a single newline at the end of the verbatim.
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#243
  def build_verbatim(margin); end

  # Enables display of debugging information
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#48
  def debug; end

  # Enables display of debugging information
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#48
  def debug=(_arg0); end

  # Pulls the next token from the stream.
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#327
  def get; end

  # Parses the tokens into an array of RDoc::Markup::XXX objects,
  # and appends them to the passed +parent+ RDoc::Markup::YYY object.
  #
  # Exits at the end of the token stream, or when it encounters a token
  # in a column less than +indent+ (unless it is a NEWLINE).
  #
  # Returns +parent+.
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#342
  def parse(parent, indent = T.unsafe(nil)); end

  # Small hook that is overridden by RDoc::TomDoc
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#406
  def parse_text(parent, indent); end

  # Returns the next token on the stream without modifying the stream
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#413
  def peek_token; end

  # Creates the StringScanner
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#468
  def setup_scanner(input); end

  # Skips the next token if its type is +token_type+.
  #
  # Optionally raises an error if the next token is not of the expected type.
  #
  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#477
  def skip(token_type, error = T.unsafe(nil)); end

  # Turns text +input+ into a stream of tokens
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#488
  def tokenize(input); end

  # Token accessor
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#53
  def tokens; end

  # Returns the current token to the token stream
  #
  # @raise [Error]
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#578
  def unget; end

  class << self
    # Parses +str+ into a Document.
    #
    # Use RDoc::Markup#parse instead of this method.
    #
    # source://rdoc//lib/rdoc/markup/parser.rb#60
    def parse(str); end

    # Returns a token stream for +str+, for testing
    #
    # source://rdoc//lib/rdoc/markup/parser.rb#70
    def tokenize(str); end
  end
end

# A simple wrapper of StringScanner that is aware of the current column and lineno
#
# source://rdoc//lib/rdoc/markup/parser.rb#422
class RDoc::Markup::Parser::MyStringScanner
  # :stopdoc:
  #
  # @return [MyStringScanner] a new instance of MyStringScanner
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#425
  def initialize(input); end

  # source://rdoc//lib/rdoc/markup/parser.rb#458
  def [](i); end

  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/parser.rb#450
  def eos?; end

  # source://rdoc//lib/rdoc/markup/parser.rb#454
  def matched; end

  # source://rdoc//lib/rdoc/markup/parser.rb#445
  def newline!; end

  # source://rdoc//lib/rdoc/markup/parser.rb#441
  def pos; end

  # source://rdoc//lib/rdoc/markup/parser.rb#430
  def scan(re); end

  # source://rdoc//lib/rdoc/markup/parser.rb#436
  def unscan(s); end
end

# Handle common directives that can occur in a block of text:
#
#   \:include: filename
#
# Directives can be escaped by preceding them with a backslash.
#
# RDoc plugin authors can register additional directives to be handled by
# using RDoc::Markup::PreProcess::register.
#
# Any directive that is not built-in to RDoc (including those registered via
# plugins) will be stored in the metadata hash on the CodeObject the comment
# is attached to.  See RDoc::Markup@Directives for the list of built-in
# directives.
#
# source://rdoc//lib/rdoc/markup/pre_process.rb#17
class RDoc::Markup::PreProcess
  # Creates a new pre-processor for +input_file_name+ that will look for
  # included files in +include_path+
  #
  # @return [PreProcess] a new instance of PreProcess
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#78
  def initialize(input_file_name, include_path); end

  # Look for the given file in the directory containing the current file,
  # and then in each of the directories specified in the RDOC_INCLUDE path
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#288
  def find_include_file(name); end

  # Look for directives in the given +text+.
  #
  # Options that we don't handle are yielded.  If the block returns false the
  # directive is restored to the text.  If the block returns nil or no block
  # was given the directive is handled according to the registered directives.
  # If a String was returned the directive is replaced with the string.
  #
  # If no matching directive was registered the directive is restored to the
  # text.
  #
  # If +code_object+ is given and the directive is unknown then the
  # directive's parameter is set as metadata on the +code_object+.  See
  # RDoc::CodeObject#metadata for details.
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#99
  def handle(text, code_object = T.unsafe(nil), &block); end

  # Performs the actions described by +directive+ and its parameter +param+.
  #
  # +code_object+ is used for directives that operate on a class or module.
  # +prefix+ is used to ensure the replacement for handled directives is
  # correct.  +encoding+ is used for the <tt>include</tt> directive.
  #
  # For a list of directives in RDoc see RDoc::Markup.
  # --
  # When 1.8.7 support is ditched prefix can be defaulted to ''
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#150
  def handle_directive(prefix, directive, param, code_object = T.unsafe(nil), encoding = T.unsafe(nil)); end

  # Handles the <tt>:include: _filename_</tt> directive.
  #
  # If the first line of the included file starts with '#', and contains
  # an encoding information in the form 'coding:' or 'coding=', it is
  # removed.
  #
  # If all lines in the included file start with a '#', this leading '#'
  # is removed before inclusion. The included content is indented like
  # the <tt>:include:</tt> directive.
  # --
  # so all content will be verbatim because of the likely space after '#'?
  # TODO shift left the whole file content in that case
  # TODO comment stop/start #-- and #++ in included file must be processed here
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#262
  def include_file(name, indent, encoding); end

  # An RDoc::Options instance that will be filled in with overrides from
  # directives
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#23
  def options; end

  # An RDoc::Options instance that will be filled in with overrides from
  # directives
  #
  # source://rdoc//lib/rdoc/markup/pre_process.rb#23
  def options=(_arg0); end

  class << self
    # Adds a post-process handler for directives.  The handler will be called
    # with the result RDoc::Comment (or text String) and the code object for the
    # comment (if any).
    #
    # source://rdoc//lib/rdoc/markup/pre_process.rb#30
    def post_process(&block); end

    # Registered post-processors
    #
    # source://rdoc//lib/rdoc/markup/pre_process.rb#37
    def post_processors; end

    # Registers +directive+ as one handled by RDoc.  If a block is given the
    # directive will be replaced by the result of the block, otherwise the
    # directive will be removed from the processed text.
    #
    # The block will be called with the directive name and the directive
    # parameter:
    #
    #   RDoc::Markup::PreProcess.register 'my-directive' do |directive, param|
    #     # replace text, etc.
    #   end
    #
    # source://rdoc//lib/rdoc/markup/pre_process.rb#53
    def register(directive, &block); end

    # Registered directives
    #
    # source://rdoc//lib/rdoc/markup/pre_process.rb#60
    def registered; end

    # Clears all registered directives and post-processors
    #
    # source://rdoc//lib/rdoc/markup/pre_process.rb#67
    def reset; end
  end
end

# A section of text that is added to the output document as-is
#
# source://rdoc//lib/rdoc/markup/raw.rb#5
class RDoc::Markup::Raw
  # Creates a new Raw containing +parts+
  #
  # @return [Raw] a new instance of Raw
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#15
  def initialize(*parts); end

  # Appends +text+
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#23
  def <<(text); end

  # source://rdoc//lib/rdoc/markup/raw.rb#27
  def ==(other); end

  # Calls #accept_raw+ on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#34
  def accept(visitor); end

  # Appends +other+'s parts
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#41
  def merge(other); end

  # The component parts of the list
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#10
  def parts; end

  # source://rdoc//lib/rdoc/markup/raw.rb#45
  def pretty_print(q); end

  # Appends +texts+ onto this Paragraph
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#58
  def push(*texts); end

  # The raw text
  #
  # source://rdoc//lib/rdoc/markup/raw.rb#65
  def text; end
end

# Hold details of a regexp handling sequence
#
# source://rdoc//lib/rdoc/markup/regexp_handling.rb#5
class RDoc::Markup::RegexpHandling
  # Creates a new regexp handling sequence of +type+ with +text+
  #
  # @return [RegexpHandling] a new instance of RegexpHandling
  #
  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#20
  def initialize(type, text); end

  # Regexp handlings are equal when the have the same text and type
  #
  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#27
  def ==(o); end

  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#31
  def inspect; end

  # Regexp handling text
  #
  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#15
  def text; end

  # Regexp handling text
  #
  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#15
  def text=(_arg0); end

  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#36
  def to_s; end

  # Regexp handling type
  #
  # source://rdoc//lib/rdoc/markup/regexp_handling.rb#10
  def type; end
end

# A horizontal rule with a weight
#
# source://rdoc//lib/rdoc/markup/rule.rb#5
class RDoc::Markup::Rule < ::Struct
  # Calls #accept_rule on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/rule.rb#10
  def accept(visitor); end

  # source://rdoc//lib/rdoc/markup/rule.rb#14
  def pretty_print(q); end
end

# A section of table
#
# source://rdoc//lib/rdoc/markup/table.rb#5
class RDoc::Markup::Table
  # Creates new instance
  #
  # @return [Table] a new instance of Table
  #
  # source://rdoc//lib/rdoc/markup/table.rb#16
  def initialize(header, align, body); end

  # :stopdoc:
  #
  # source://rdoc//lib/rdoc/markup/table.rb#21
  def ==(other); end

  # source://rdoc//lib/rdoc/markup/table.rb#28
  def accept(visitor); end

  # alignments of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#10
  def align; end

  # alignments of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#10
  def align=(_arg0); end

  # body texts of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#13
  def body; end

  # body texts of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#13
  def body=(_arg0); end

  # headers of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#7
  def header; end

  # headers of each column
  #
  # source://rdoc//lib/rdoc/markup/table.rb#7
  def header=(_arg0); end

  # source://rdoc//lib/rdoc/markup/table.rb#32
  def pretty_print(q); end
end

# Outputs RDoc markup with vibrant ANSI color!
#
# source://rdoc//lib/rdoc/markup/to_ansi.rb#5
class RDoc::Markup::ToAnsi < ::RDoc::Markup::ToRdoc
  # Creates a new ToAnsi visitor that is ready to output vibrant ANSI color!
  #
  # @return [ToAnsi] a new instance of ToAnsi
  #
  # source://rdoc//lib/rdoc/markup/to_ansi.rb#10
  def initialize(markup = T.unsafe(nil)); end

  # Overrides indent width to ensure output lines up correctly.
  #
  # source://rdoc//lib/rdoc/markup/to_ansi.rb#31
  def accept_list_item_end(list_item); end

  # Adds coloring to note and label list items
  #
  # source://rdoc//lib/rdoc/markup/to_ansi.rb#55
  def accept_list_item_start(list_item); end

  # Maps attributes to ANSI sequences
  #
  # source://rdoc//lib/rdoc/markup/to_ansi.rb#22
  def init_tags; end

  # Starts accepting with a reset screen
  #
  # source://rdoc//lib/rdoc/markup/to_ansi.rb#87
  def start_accepting; end
end

# Outputs RDoc markup with hot backspace action!  You will probably need a
# pager to use this output format.
#
# This formatter won't work on 1.8.6 because it lacks String#chars.
#
# source://rdoc//lib/rdoc/markup/to_bs.rb#8
class RDoc::Markup::ToBs < ::RDoc::Markup::ToRdoc
  # Returns a new ToBs that is ready for hot backspace action!
  #
  # @return [ToBs] a new instance of ToBs
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#13
  def initialize(markup = T.unsafe(nil)); end

  # Makes heading text bold.
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#33
  def accept_heading(heading); end

  # Prepares the visitor for consuming +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#46
  def accept_list_item_start(list_item); end

  # Turns on or off regexp handling for +convert_string+
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#71
  def annotate(tag); end

  # Calls convert_string on the result of convert_regexp_handling
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#84
  def convert_regexp_handling(target); end

  # Adds bold or underline mixed with backspaces
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#91
  def convert_string(string); end

  # Sets a flag that is picked up by #annotate to do the right thing in
  # #convert_string
  #
  # source://rdoc//lib/rdoc/markup/to_bs.rb#24
  def init_tags; end
end

# Outputs RDoc markup as HTML.
#
# source://rdoc//lib/rdoc/markup/to_html.rb#7
class RDoc::Markup::ToHtml < ::RDoc::Markup::Formatter
  include ::RDoc::Text

  # Creates a new formatter that will output HTML
  #
  # @return [ToHtml] a new instance of ToHtml
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#45
  def initialize(options, markup = T.unsafe(nil)); end

  # Adds +blank_line+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#291
  def accept_blank_line(blank_line); end

  # Adds +block_quote+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#190
  def accept_block_quote(block_quote); end

  # Adds +heading+ to the output.  The headings greater than 6 are trimmed to
  # level 6.
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#299
  def accept_heading(heading); end

  # Finishes consumption of +list+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#262
  def accept_list_end(list); end

  # Finishes consumption of +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#284
  def accept_list_item_end(list_item); end

  # Prepares the visitor for consuming +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#273
  def accept_list_item_start(list_item); end

  # Prepares the visitor for consuming +list+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#253
  def accept_list_start(list); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#203
  def accept_paragraph(paragraph); end

  # Adds +raw+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#320
  def accept_raw(raw); end

  # Adds +rule+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#246
  def accept_rule(rule); end

  # Adds +table+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#327
  def accept_table(header, body, aligns); end

  # Adds +verbatim+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#216
  def accept_verbatim(verbatim); end

  # The RDoc::CodeObject HTML is being generated for.  This is used to
  # generate namespaced URI fragments
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#33
  def code_object; end

  # The RDoc::CodeObject HTML is being generated for.  This is used to
  # generate namespaced URI fragments
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#33
  def code_object=(_arg0); end

  # CGI-escapes +text+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#352
  def convert_string(text); end

  # Returns the generated output
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#183
  def end_accepting; end

  # Path to this document for relative links
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#38
  def from_path; end

  # Path to this document for relative links
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#38
  def from_path=(_arg0); end

  # Generate a link to +url+ with content +text+.  Handles the special cases
  # for img: and link: described under handle_regexp_HYPERLINK
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#360
  def gen_url(url, text); end

  # source://rdoc//lib/rdoc/markup/to_html.rb#85
  def handle_RDOCLINK(url); end

  # +target+ is a <code><br></code>
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#110
  def handle_regexp_HARD_BREAK(target); end

  # +target+ is a potential link.  The following schemes are handled:
  #
  # <tt>mailto:</tt>::
  #   Inserted as-is.
  # <tt>http:</tt>::
  #   Links are checked to see if they reference an image. If so, that image
  #   gets inserted using an <tt><img></tt> tag. Otherwise a conventional
  #   <tt><a href></tt> is used.
  # <tt>link:</tt>::
  #   Reference to a local file relative to the output directory.
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#126
  def handle_regexp_HYPERLINK(target); end

  # +target+ is an rdoc-schemed link that will be converted into a hyperlink.
  #
  # For the +rdoc-ref+ scheme the named reference will be returned without
  # creating a link.
  #
  # For the +rdoc-label+ scheme the footnote and label prefixes are stripped
  # when creating a link.  All other contents will be linked verbatim.
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#141
  def handle_regexp_RDOCLINK(target); end

  # This +target+ is a link where the label is different from the URL
  # <tt>label[url]</tt> or <tt>{long label}[url]</tt>
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#149
  def handle_regexp_TIDYLINK(target); end

  # Determines the HTML list element for +list_type+ and +open_tag+
  #
  # @raise [RDoc::Error]
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#385
  def html_list_name(list_type, open_tag); end

  # source://rdoc//lib/rdoc/markup/to_html.rb#26
  def in_list_entry; end

  # Adds regexp handlings about link notations.
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#80
  def init_link_notation_regexp_handlings; end

  # Adds regexp handlings.
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#70
  def init_regexp_handlings; end

  # Maps attributes to HTML tags
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#394
  def init_tags; end

  # source://rdoc//lib/rdoc/markup/to_html.rb#27
  def list; end

  # Returns the HTML end-tag for +list_type+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#420
  def list_end_for(list_type); end

  # Returns the HTML tag for +list_type+, possible using a label from
  # +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#404
  def list_item_start(list_item, list_type); end

  # Returns true if text is valid ruby syntax
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#434
  def parseable?(text); end

  # source://rdoc//lib/rdoc/markup/to_html.rb#25
  def res; end

  # Prepares the visitor for HTML generation
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#174
  def start_accepting; end

  # Converts +item+ to HTML using RDoc::Text#to_html
  #
  # source://rdoc//lib/rdoc/markup/to_html.rb#448
  def to_html(item); end
end

# source://rdoc//lib/rdoc/markup/to_html.rb#65
RDoc::Markup::ToHtml::URL_CHARACTERS_REGEXP_STR = T.let(T.unsafe(nil), String)

# Subclass of the RDoc::Markup::ToHtml class that supports looking up method
# names, classes, etc to create links.  RDoc::CrossReference is used to
# generate those links based on the current context.
#
# source://rdoc//lib/rdoc/markup/to_html_crossref.rb#7
class RDoc::Markup::ToHtmlCrossref < ::RDoc::Markup::ToHtml
  # Creates a new crossref resolver that generates links relative to +context+
  # which lives at +from_path+ in the generated files.  '#' characters on
  # references are removed unless +show_hash+ is true.  Only method names
  # preceded by '#' or '::' are linked, unless +hyperlink_all+ is true.
  #
  # @raise [ArgumentError]
  # @return [ToHtmlCrossref] a new instance of ToHtmlCrossref
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#32
  def initialize(options, from_path, context, markup = T.unsafe(nil)); end

  # RDoc::CodeObject for generating references
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#19
  def context; end

  # RDoc::CodeObject for generating references
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#19
  def context=(_arg0); end

  # Creates a link to the reference +name+ if the name exists.  If +text+ is
  # given it is used as the link text, otherwise +name+ is used.
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#61
  def cross_reference(name, text = T.unsafe(nil), code = T.unsafe(nil)); end

  # Generates links for <tt>rdoc-ref:</tt> scheme URLs and allows
  # RDoc::Markup::ToHtml to handle other schemes.
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#131
  def gen_url(url, text); end

  # We're invoked when any text matches the CROSSREF pattern.  If we find the
  # corresponding reference, generate a link.  If the name we're looking for
  # contains no punctuation, we look for it up the module/class chain.  For
  # example, ToHtml is found, even without the <tt>RDoc::Markup::</tt> prefix,
  # because we look for it in module Markup first.
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#83
  def handle_regexp_CROSSREF(target); end

  # Handles <tt>rdoc-ref:</tt> scheme links and allows RDoc::Markup::ToHtml to
  # handle other schemes.
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#102
  def handle_regexp_HYPERLINK(target); end

  # +target+ is an rdoc-schemed link that will be converted into a hyperlink.
  # For the rdoc-ref scheme the cross-reference will be looked up and the
  # given name will be used.
  #
  # All other contents are handled by
  # {the superclass}[rdoc-ref:RDoc::Markup::ToHtml#handle_regexp_RDOCLINK]
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#116
  def handle_regexp_RDOCLINK(target); end

  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#46
  def init_link_notation_regexp_handlings; end

  # Creates an HTML link to +name+ with the given +text+.
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#141
  def link(name, text, code = T.unsafe(nil)); end

  # Should we show '#' characters on method references?
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#24
  def show_hash; end

  # Should we show '#' characters on method references?
  #
  # source://rdoc//lib/rdoc/markup/to_html_crossref.rb#24
  def show_hash=(_arg0); end
end

# Outputs RDoc markup as paragraphs with inline markup only.
#
# source://rdoc//lib/rdoc/markup/to_html_snippet.rb#5
class RDoc::Markup::ToHtmlSnippet < ::RDoc::Markup::ToHtml
  # Creates a new ToHtmlSnippet formatter that will cut off the input on the
  # next word boundary after the given number of +characters+ or +paragraphs+
  # of text have been encountered.
  #
  # @return [ToHtmlSnippet] a new instance of ToHtmlSnippet
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#37
  def initialize(options, characters = T.unsafe(nil), paragraphs = T.unsafe(nil), markup = T.unsafe(nil)); end

  # Adds +heading+ to the output as a paragraph
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#53
  def accept_heading(heading); end

  # Finishes consumption of +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#85
  def accept_list_item_end(list_item); end

  # Prepares the visitor for consuming +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#91
  def accept_list_item_start(list_item); end

  # Prepares the visitor for consuming +list+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#98
  def accept_list_start(list); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#72
  def accept_paragraph(paragraph); end

  # Raw sections are untrusted and ignored
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_raw(*node); end

  # Rules are ignored
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_rule(*node); end

  # Adds +verbatim+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#107
  def accept_verbatim(verbatim); end

  # Throws +:done+ when paragraph_limit paragraphs have been encountered
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#198
  def add_paragraph; end

  # After this many characters the input will be cut off.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#10
  def character_limit; end

  # The number of characters seen so far.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#15
  def characters; end

  # Marks up +content+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#207
  def convert(content); end

  # Converts flow items +flow+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#218
  def convert_flow(flow); end

  # Returns just the text of +link+, +url+ is only used to determine the link
  # type.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#171
  def gen_url(url, text); end

  # Removes escaping from the cross-references in +target+
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#131
  def handle_regexp_CROSSREF(target); end

  # +target+ is a <code><br></code>
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#138
  def handle_regexp_HARD_BREAK(target); end

  # In snippets, there are no lists
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#191
  def html_list_name(list_type, open_tag); end

  # Lists are paragraphs, but notes and labels have a separator
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#146
  def list_item_start(list_item, list_type); end

  # The attribute bitmask
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#20
  def mask; end

  # Maintains a bitmask to allow HTML elements to be closed properly.  See
  # RDoc::Markup::Formatter.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#264
  def off_tags(res, item); end

  # Maintains a bitmask to allow HTML elements to be closed properly.  See
  # RDoc::Markup::Formatter.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#254
  def on_tags(res, item); end

  # After this many paragraphs the input will be cut off.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#25
  def paragraph_limit; end

  # Count of paragraphs found
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#30
  def paragraphs; end

  # Prepares the visitor for HTML snippet generation
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#122
  def start_accepting; end

  # Truncates +text+ at the end of the first word after the character_limit.
  #
  # source://rdoc//lib/rdoc/markup/to_html_snippet.rb#273
  def truncate(text); end
end

# Joins the parts of an RDoc::Markup::Paragraph into a single String.
#
# This allows for easier maintenance and testing of Markdown support.
#
# This formatter only works on Paragraph instances.  Attempting to process
# other markup syntax items will not work.
#
# source://rdoc//lib/rdoc/markup/to_joined_paragraph.rb#10
class RDoc::Markup::ToJoinedParagraph < ::RDoc::Markup::Formatter
  # @return [ToJoinedParagraph] a new instance of ToJoinedParagraph
  #
  # source://rdoc//lib/rdoc/markup/to_joined_paragraph.rb#12
  def initialize; end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_block_quote(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_heading(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_start(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_start(*node); end

  # Converts the parts of +paragraph+ to a single entry.
  #
  # source://rdoc//lib/rdoc/markup/to_joined_paragraph.rb#25
  def accept_paragraph(paragraph); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_raw(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_rule(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_table(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_verbatim(*node); end

  # source://rdoc//lib/rdoc/markup/to_joined_paragraph.rb#19
  def end_accepting; end

  # source://rdoc//lib/rdoc/markup/to_joined_paragraph.rb#16
  def start_accepting; end
end

# Creates HTML-safe labels suitable for use in id attributes.  Tidylinks are
# converted to their link part and cross-reference links have the suppression
# marks removed (\\SomeClass is converted to SomeClass).
#
# source://rdoc//lib/rdoc/markup/to_label.rb#9
class RDoc::Markup::ToLabel < ::RDoc::Markup::Formatter
  # Creates a new formatter that will output HTML-safe labels
  #
  # @return [ToLabel] a new instance of ToLabel
  #
  # source://rdoc//lib/rdoc/markup/to_label.rb#16
  def initialize(markup = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_blank_line(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_block_quote(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_heading(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_start(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_start(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_paragraph(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_raw(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_rule(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_verbatim(*node); end

  # Converts +text+ to an HTML-safe label
  #
  # source://rdoc//lib/rdoc/markup/to_label.rb#32
  def convert(text); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def end_accepting(*node); end

  # Converts the CROSSREF +target+ to plain text, removing the suppression
  # marker, if any
  #
  # source://rdoc//lib/rdoc/markup/to_label.rb#42
  def handle_regexp_CROSSREF(target); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def handle_regexp_HARD_BREAK(*node); end

  # Converts the TIDYLINK +target+ to just the text part
  #
  # source://rdoc//lib/rdoc/markup/to_label.rb#51
  def handle_regexp_TIDYLINK(target); end

  # source://rdoc//lib/rdoc/markup/to_label.rb#11
  def res; end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def start_accepting(*node); end
end

# Outputs parsed markup as Markdown
#
# source://rdoc//lib/rdoc/markup/to_markdown.rb#7
class RDoc::Markup::ToMarkdown < ::RDoc::Markup::ToRdoc
  # Creates a new formatter that will output Markdown format text
  #
  # @return [ToMarkdown] a new instance of ToMarkdown
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#12
  def initialize(markup = T.unsafe(nil)); end

  # Finishes consumption of `list`
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#47
  def accept_list_end(list); end

  # Finishes consumption of `list_item`
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#54
  def accept_list_item_end(list_item); end

  # Prepares the visitor for consuming `list_item`
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#75
  def accept_list_item_start(list_item); end

  # Prepares the visitor for consuming `list`
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#100
  def accept_list_start(list); end

  # Adds `rule` to the output
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#117
  def accept_rule(rule); end

  # Outputs `verbatim` indented 4 columns
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#126
  def accept_verbatim(verbatim); end

  # Creates a Markdown-style URL from +url+ with +text+.
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#140
  def gen_url(url, text); end

  # Handles <tt>rdoc-</tt> type links for footnotes.
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#149
  def handle_rdoc_link(url); end

  # Adds a newline to the output
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#40
  def handle_regexp_HARD_BREAK(target); end

  # Converts the rdoc-...: links into a Markdown.style links.
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#187
  def handle_regexp_RDOCLINK(target); end

  # Converts the RDoc markup tidylink into a Markdown.style link.
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#169
  def handle_regexp_TIDYLINK(target); end

  # Maps attributes to HTML sequences
  #
  # source://rdoc//lib/rdoc/markup/to_markdown.rb#31
  def init_tags; end
end

# Outputs RDoc markup as RDoc markup! (mostly)
#
# source://rdoc//lib/rdoc/markup/to_rdoc.rb#5
class RDoc::Markup::ToRdoc < ::RDoc::Markup::Formatter
  # Creates a new formatter that will output (mostly) \RDoc markup
  #
  # @return [ToRdoc] a new instance of ToRdoc
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#45
  def initialize(markup = T.unsafe(nil)); end

  # Adds +blank_line+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#77
  def accept_blank_line(blank_line); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#84
  def accept_block_quote(block_quote); end

  # Adds +heading+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#99
  def accept_heading(heading); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#211
  def accept_indented_paragraph(paragraph); end

  # Finishes consumption of +list+
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#110
  def accept_list_end(list); end

  # Finishes consumption of +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#119
  def accept_list_item_end(list_item); end

  # Prepares the visitor for consuming +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#143
  def accept_list_item_start(list_item); end

  # Prepares the visitor for consuming +list+
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#176
  def accept_list_start(list); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#203
  def accept_paragraph(paragraph); end

  # Adds +raw+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#221
  def accept_raw(raw); end

  # Adds +rule+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#228
  def accept_rule(rule); end

  # Adds +table+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#251
  def accept_table(header, body, aligns); end

  # Outputs +verbatim+ indented 2 columns
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#237
  def accept_verbatim(verbatim); end

  # Applies attribute-specific markup to +text+ using RDoc::AttributeManager
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#279
  def attributes(text); end

  # Returns the generated output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#287
  def end_accepting; end

  # Adds a newline to the output
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#303
  def handle_regexp_HARD_BREAK(target); end

  # Removes preceding \\ from the suppressed crossref +target+
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#294
  def handle_regexp_SUPPRESSED_CROSSREF(target); end

  # Current indent amount for output in characters
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#10
  def indent; end

  # Current indent amount for output in characters
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#10
  def indent=(_arg0); end

  # Maps attributes to HTML sequences
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#68
  def init_tags; end

  # Stack of current list indexes for alphabetic and numeric lists
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#20
  def list_index; end

  # Stack of list types
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#25
  def list_type; end

  # Stack of list widths for indentation
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#30
  def list_width; end

  # Prefix for the next list item.  See #use_prefix
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#35
  def prefix; end

  # Output accumulator
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#40
  def res; end

  # Prepares the visitor for text generation
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#310
  def start_accepting; end

  # Adds the stored #prefix to the output and clears it.  Lists generate a
  # prefix for later consumption.
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#324
  def use_prefix; end

  # Output width in characters
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#15
  def width; end

  # Output width in characters
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#15
  def width=(_arg0); end

  # Wraps +text+ to #width
  #
  # source://rdoc//lib/rdoc/markup/to_rdoc.rb#334
  def wrap(text); end
end

# Extracts just the RDoc::Markup::Heading elements from a
# RDoc::Markup::Document to help build a table of contents
#
# source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#6
class RDoc::Markup::ToTableOfContents < ::RDoc::Markup::Formatter
  # @return [ToTableOfContents] a new instance of ToTableOfContents
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#27
  def initialize; end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_blank_line(*node); end

  # :stopdoc:
  #
  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_block_quote(*node); end

  # Adds +document+ to the output, using its heading cutoff if present
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#36
  def accept_document(document); end

  # Adds +heading+ to the table of contents
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#45
  def accept_heading(heading); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_end_bullet(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_end(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_item_start(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_list_start(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_paragraph(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_raw(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_rule(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_table(*node); end

  # source://rdoc//lib/rdoc/markup/formatter.rb#188
  def accept_verbatim(*node); end

  # Returns the table of contents
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#52
  def end_accepting; end

  # Omits headings with a level less than the given level.
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#25
  def omit_headings_below; end

  # Omits headings with a level less than the given level.
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#25
  def omit_headings_below=(_arg0); end

  # Output accumulator
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#20
  def res; end

  # Prepares the visitor for text generation
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#59
  def start_accepting; end

  # Returns true if +heading+ is below the display threshold
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#67
  def suppressed?(heading); end

  class << self
    # Singleton for table-of-contents generation
    #
    # source://rdoc//lib/rdoc/markup/to_table_of_contents.rb#13
    def to_toc; end
  end
end

# This Markup outputter is used for testing purposes.
#
# source://rdoc//lib/rdoc/markup/to_test.rb#5
class RDoc::Markup::ToTest < ::RDoc::Markup::Formatter
  # source://rdoc//lib/rdoc/markup/to_test.rb#55
  def accept_blank_line(blank_line); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#59
  def accept_heading(heading); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#44
  def accept_list_end(list); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#52
  def accept_list_item_end(list_item); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#48
  def accept_list_item_start(list_item); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#33
  def accept_list_start(list); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#21
  def accept_paragraph(paragraph); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#25
  def accept_raw(raw); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#63
  def accept_rule(rule); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#29
  def accept_verbatim(verbatim); end

  # source://rdoc//lib/rdoc/markup/to_test.rb#17
  def end_accepting; end

  # :section: Visitor
  #
  # source://rdoc//lib/rdoc/markup/to_test.rb#12
  def start_accepting; end
end

# Extracts sections of text enclosed in plus, tt or code.  Used to discover
# undocumented parameters.
#
# source://rdoc//lib/rdoc/markup/to_tt_only.rb#6
class RDoc::Markup::ToTtOnly < ::RDoc::Markup::Formatter
  # Creates a new tt-only formatter.
  #
  # @return [ToTtOnly] a new instance of ToTtOnly
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#21
  def initialize(markup = T.unsafe(nil)); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_blank_line(markup_item); end

  # Adds tts from +block_quote+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#30
  def accept_block_quote(block_quote); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_heading(markup_item); end

  # Pops the list type for +list+ from #list_type
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#37
  def accept_list_end(list); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_list_item_end(markup_item); end

  # Prepares the visitor for consuming +list_item+
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#51
  def accept_list_item_start(list_item); end

  # Pushes the list type for +list+ onto #list_type
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#44
  def accept_list_start(list); end

  # Adds +paragraph+ to the output
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#63
  def accept_paragraph(paragraph); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_raw(markup_item); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_rule(markup_item); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def accept_verbatim(markup_item); end

  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#71
  def do_nothing(markup_item); end

  # Returns an Array of items that were wrapped in plus, tt or code.
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#107
  def end_accepting; end

  # Stack of list types
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#11
  def list_type; end

  # Output accumulator
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#16
  def res; end

  # Prepares the visitor for gathering tt sections
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#114
  def start_accepting; end

  # Extracts tt sections from +text+
  #
  # source://rdoc//lib/rdoc/markup/to_tt_only.rb#84
  def tt_sections(text); end
end

# A section of verbatim text
#
# source://rdoc//lib/rdoc/markup/verbatim.rb#5
class RDoc::Markup::Verbatim < ::RDoc::Markup::Raw
  # @return [Verbatim] a new instance of Verbatim
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#12
  def initialize(*parts); end

  # source://rdoc//lib/rdoc/markup/verbatim.rb#18
  def ==(other); end

  # Calls #accept_verbatim on +visitor+
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#25
  def accept(visitor); end

  # Format of this verbatim section
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#10
  def format; end

  # Format of this verbatim section
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#10
  def format=(_arg0); end

  # Collapses 3+ newlines into two newlines
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#32
  def normalize; end

  # source://rdoc//lib/rdoc/markup/verbatim.rb#53
  def pretty_print(q); end

  # Is this verbatim section Ruby code?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#71
  def ruby?; end

  # The text of the section
  #
  # source://rdoc//lib/rdoc/markup/verbatim.rb#79
  def text; end
end

# Abstract class representing either a method or an attribute.
#
# source://rdoc//lib/rdoc/method_attr.rb#5
class RDoc::MethodAttr < ::RDoc::CodeObject
  include ::Comparable

  # Creates a new MethodAttr from token stream +text+ and method or attribute
  # name +name+.
  #
  # Usually this is called by super from a subclass.
  #
  # @return [MethodAttr] a new instance of MethodAttr
  #
  # source://rdoc//lib/rdoc/method_attr.rb#78
  def initialize(text, name); end

  # Order by #singleton then #name
  #
  # source://rdoc//lib/rdoc/method_attr.rb#113
  def <=>(other); end

  # source://rdoc//lib/rdoc/method_attr.rb#121
  def ==(other); end

  # Abstract method. Contexts in their building phase call this
  # to register a new alias for this known method/attribute.
  #
  # - creates a new AnyMethod/Attribute named <tt>an_alias.new_name</tt>;
  # - adds +self+ as an alias for the new method or attribute
  # - adds the method or attribute to #aliases
  # - adds the method or attribute to +context+.
  #
  # @raise [NotImplementedError]
  #
  # source://rdoc//lib/rdoc/method_attr.rb#209
  def add_alias(an_alias, context); end

  # Prepend +src+ with line numbers.  Relies on the first line of a source
  # code listing having:
  #
  #   # File xxxxx, line dddd
  #
  # If it has this comment then line numbers are added to +src+ and the <tt>,
  # line dddd</tt> portion of the comment is removed.
  #
  # source://rdoc//lib/rdoc/generator/markup.rb#77
  def add_line_numbers(src); end

  # Array of other names for this method/attribute
  #
  # source://rdoc//lib/rdoc/method_attr.rb#32
  def aliases; end

  # HTML fragment reference for this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#216
  def aref; end

  # Prefix for +aref+, defined by subclasses.
  #
  # @raise [NotImplementedError]
  #
  # source://rdoc//lib/rdoc/method_attr.rb#225
  def aref_prefix; end

  # The call_seq or the param_seq with method name, if there is no call_seq.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#64
  def arglists; end

  # Parameters yielded by the called block
  #
  # source://rdoc//lib/rdoc/method_attr.rb#49
  def block_params; end

  # Attempts to sanitize the content passed by the Ruby parser:
  # remove outer parentheses, etc.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#233
  def block_params=(value); end

  # Different ways to call this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#59
  def call_seq; end

  # Different ways to call this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#59
  def call_seq=(_arg0); end

  # A method/attribute is documented if any of the following is true:
  # - it has a comment;
  # - it is an alias for a documented method;
  # - it has a +#see+ method that is documented.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/method_attr.rb#132
  def documented?; end

  # source://rdoc//lib/rdoc/method_attr.rb#178
  def find_method_or_attribute(name); end

  # source://rdoc//lib/rdoc/method_attr.rb#166
  def find_see; end

  # Full method/attribute name including namespace
  #
  # source://rdoc//lib/rdoc/method_attr.rb#300
  def full_name; end

  # HTML id-friendly method/attribute name
  #
  # source://rdoc//lib/rdoc/method_attr.rb#291
  def html_name; end

  # source://rdoc//lib/rdoc/method_attr.rb#105
  def initialize_visibility; end

  # source://rdoc//lib/rdoc/method_attr.rb#304
  def inspect; end

  # The method/attribute we're aliasing
  #
  # source://rdoc//lib/rdoc/method_attr.rb#37
  def is_alias_for; end

  # The method/attribute we're aliasing
  #
  # source://rdoc//lib/rdoc/method_attr.rb#37
  def is_alias_for=(_arg0); end

  # Turns the method's token stream into HTML.
  #
  # Prepends line numbers if +options.line_numbers+ is true.
  #
  # source://rdoc//lib/rdoc/generator/markup.rb#101
  def markup_code; end

  # Name of this method/attribute.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#12
  def name; end

  # Name of this method/attribute.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#12
  def name=(_arg0); end

  # '::' for a class method/attribute, '#' for an instance method.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#319
  def name_prefix; end

  # Name for output to HTML.  For class methods the full name with a "." is
  # used like +SomeClass.method_name+.  For instance methods the class name is
  # used if +context+ does not match the parent.
  #
  # This is to help prevent people from using :: to call class methods.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#330
  def output_name(context); end

  # Pretty parameter list for this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#69
  def param_seq; end

  # Parameters for this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#54
  def params; end

  # Parameters for this method
  #
  # source://rdoc//lib/rdoc/method_attr.rb#54
  def params=(_arg0); end

  # Name of our parent with special handling for un-marshaled methods
  #
  # source://rdoc//lib/rdoc/method_attr.rb#360
  def parent_name; end

  # Path to this method for use with HTML generator output.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#353
  def path; end

  # Method/attribute name with class/instance indicator
  #
  # source://rdoc//lib/rdoc/method_attr.rb#339
  def pretty_name; end

  # source://rdoc//lib/rdoc/method_attr.rb#364
  def pretty_print(q); end

  # Used by RDoc::Generator::JsonIndex to create a record for the search
  # engine.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#398
  def search_record; end

  # A method/attribute to look at,
  # in particular if this method/attribute has no documentation.
  #
  # It can be a method/attribute of the superclass or of an included module,
  # including the Kernel module, which is always appended to the included
  # modules.
  #
  # Returns +nil+ if there is no such method/attribute.
  # The +#is_alias_for+ method/attribute, if any, is not included.
  #
  # Templates may generate a "see also ..." if this method/attribute
  # has documentation, and "see ..." if it does not.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#152
  def see; end

  # Is this a singleton method/attribute?
  #
  # source://rdoc//lib/rdoc/method_attr.rb#22
  def singleton; end

  # Is this a singleton method/attribute?
  #
  # source://rdoc//lib/rdoc/method_attr.rb#22
  def singleton=(_arg0); end

  # Sets the store for this class or module and its contained code objects.
  #
  # source://rdoc//lib/rdoc/method_attr.rb#160
  def store=(store); end

  # Source file token stream
  #
  # source://rdoc//lib/rdoc/method_attr.rb#27
  def text; end

  # source://rdoc//lib/rdoc/method_attr.rb#410
  def to_s; end

  # Type of method/attribute (class or instance)
  #
  # source://rdoc//lib/rdoc/method_attr.rb#346
  def type; end

  # public, protected, private
  #
  # source://rdoc//lib/rdoc/method_attr.rb#17
  def visibility; end

  # public, protected, private
  #
  # source://rdoc//lib/rdoc/method_attr.rb#17
  def visibility=(_arg0); end

  private

  # Resets cached data for the object so it can be rebuilt by accessor methods
  #
  # source://rdoc//lib/rdoc/method_attr.rb#101
  def initialize_copy(other); end
end

# A Mixin adds features from a module into another context.  RDoc::Include and
# RDoc::Extend are both mixins.
#
# source://rdoc//lib/rdoc/mixin.rb#6
class RDoc::Mixin < ::RDoc::CodeObject
  # Creates a new Mixin for +name+ with +comment+
  #
  # @return [Mixin] a new instance of Mixin
  #
  # source://rdoc//lib/rdoc/mixin.rb#16
  def initialize(name, comment); end

  # Mixins are sorted by name
  #
  # source://rdoc//lib/rdoc/mixin.rb#26
  def <=>(other); end

  # source://rdoc//lib/rdoc/mixin.rb#32
  def ==(other); end

  # source://rdoc//lib/rdoc/mixin.rb#32
  def eql?(other); end

  # Full name based on #module
  #
  # source://rdoc//lib/rdoc/mixin.rb#41
  def full_name; end

  # source://rdoc//lib/rdoc/mixin.rb#46
  def hash; end

  # source://rdoc//lib/rdoc/mixin.rb#50
  def inspect; end

  # Attempts to locate the included module object.  Returns the name if not
  # known.
  #
  # The scoping rules of Ruby to resolve the name of an included module are:
  # - first look into the children of the current context;
  # - if not found, look into the children of included modules,
  #   in reverse inclusion order;
  # - if still not found, go up the hierarchy of names.
  #
  # This method has <code>O(n!)</code> behavior when the module calling
  # include is referencing nonexistent modules.  Avoid calling #module until
  # after all the files are parsed.  This behavior is due to ruby's constant
  # lookup behavior.
  #
  # As of the beginning of October, 2011, no gem includes nonexistent modules.
  #
  # source://rdoc//lib/rdoc/mixin.rb#75
  def module; end

  # Name of included module
  #
  # source://rdoc//lib/rdoc/mixin.rb#11
  def name; end

  # Name of included module
  #
  # source://rdoc//lib/rdoc/mixin.rb#11
  def name=(_arg0); end

  # Sets the store for this class or module and its contained code objects.
  #
  # source://rdoc//lib/rdoc/mixin.rb#110
  def store=(store); end

  # source://rdoc//lib/rdoc/mixin.rb#116
  def to_s; end
end

# A normal class, neither singleton nor anonymous
#
# source://rdoc//lib/rdoc/normal_class.rb#5
class RDoc::NormalClass < ::RDoc::ClassModule
  # The ancestors of this class including modules.  Unlike Module#ancestors,
  # this class is not included in the result.  The result will contain both
  # RDoc::ClassModules and Strings.
  #
  # source://rdoc//lib/rdoc/normal_class.rb#12
  def ancestors; end

  # source://rdoc//lib/rdoc/normal_class.rb#24
  def aref_prefix; end

  # The definition of this class, <tt>class MyClassName</tt>
  #
  # source://rdoc//lib/rdoc/normal_class.rb#31
  def definition; end

  # source://rdoc//lib/rdoc/normal_class.rb#35
  def direct_ancestors; end

  # source://rdoc//lib/rdoc/normal_class.rb#39
  def inspect; end

  # source://rdoc//lib/rdoc/normal_class.rb#56
  def pretty_print(q); end

  # source://rdoc//lib/rdoc/normal_class.rb#47
  def to_s; end
end

# A normal module, like NormalClass
#
# source://rdoc//lib/rdoc/normal_module.rb#5
class RDoc::NormalModule < ::RDoc::ClassModule
  # source://rdoc//lib/rdoc/normal_module.rb#7
  def aref_prefix; end

  # The definition of this module, <tt>module MyModuleName</tt>
  #
  # source://rdoc//lib/rdoc/normal_module.rb#21
  def definition; end

  # source://rdoc//lib/rdoc/normal_module.rb#11
  def inspect; end

  # This is a module, returns true
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/normal_module.rb#28
  def module?; end

  # source://rdoc//lib/rdoc/normal_module.rb#32
  def pretty_print(q); end

  # Modules don't have one, raises NoMethodError
  #
  # @raise [NoMethodError]
  #
  # source://rdoc//lib/rdoc/normal_module.rb#69
  def superclass; end
end

# RDoc::Options handles the parsing and storage of options
#
# == Saved Options
#
# You can save some options like the markup format in the
# <tt>.rdoc_options</tt> file in your gem.  The easiest way to do this is:
#
#   rdoc --markup tomdoc --write-options
#
# Which will automatically create the file and fill it with the options you
# specified.
#
# The following options will not be saved since they interfere with the user's
# preferences or with the normal operation of RDoc:
#
# * +--coverage-report+
# * +--dry-run+
# * +--encoding+
# * +--force-update+
# * +--format+
# * +--pipe+
# * +--quiet+
# * +--template+
# * +--verbose+
#
# == Custom Options
#
# Generators can hook into RDoc::Options to add generator-specific command
# line options.
#
# When <tt>--format</tt> is encountered in ARGV, RDoc calls ::setup_options on
# the generator class to add extra options to the option parser.  Options for
# custom generators must occur after <tt>--format</tt>.  <tt>rdoc --help</tt>
# will list options for all installed generators.
#
# Example:
#
#   class RDoc::Generator::Spellcheck
#     RDoc::RDoc.add_generator self
#
#     def self.setup_options rdoc_options
#       op = rdoc_options.option_parser
#
#       op.on('--spell-dictionary DICTIONARY',
#             RDoc::Options::Path) do |dictionary|
#         rdoc_options.spell_dictionary = dictionary
#       end
#     end
#   end
#
# Of course, RDoc::Options does not respond to +spell_dictionary+ by default
# so you will need to add it:
#
#   class RDoc::Options
#
#     ##
#     # The spell dictionary used by the spell-checking plugin.
#
#     attr_accessor :spell_dictionary
#
#   end
#
# == Option Validators
#
# OptionParser validators will validate and cast user input values.  In
# addition to the validators that ship with OptionParser (String, Integer,
# Float, TrueClass, FalseClass, Array, Regexp, Date, Time, URI, etc.),
# RDoc::Options adds Path, PathArray and Template.
#
# source://rdoc//lib/rdoc/options.rb#75
class RDoc::Options
  # @return [Options] a new instance of Options
  #
  # source://rdoc//lib/rdoc/options.rb#347
  def initialize(loaded_options = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/options.rb#460
  def ==(other); end

  # Character-set for HTML output.  #encoding is preferred over #charset
  #
  # source://rdoc//lib/rdoc/options.rb#152
  def charset; end

  # Character-set for HTML output.  #encoding is preferred over #charset
  #
  # source://rdoc//lib/rdoc/options.rb#152
  def charset=(_arg0); end

  # Check that the files on the command line exist
  #
  # source://rdoc//lib/rdoc/options.rb#484
  def check_files; end

  # Ensure only one generator is loaded
  #
  # source://rdoc//lib/rdoc/options.rb#505
  def check_generator; end

  # If true, only report on undocumented files
  #
  # source://rdoc//lib/rdoc/options.rb#244
  def coverage_report; end

  # If true, only report on undocumented files
  #
  # source://rdoc//lib/rdoc/options.rb#244
  def coverage_report=(_arg0); end

  # Set the title, but only if not already set. Used to set the title
  # from a source file, so that a title set from the command line
  # will have the priority.
  #
  # source://rdoc//lib/rdoc/options.rb#517
  def default_title=(string); end

  # If true, RDoc will not write any files.
  #
  # source://rdoc//lib/rdoc/options.rb#157
  def dry_run; end

  # If true, RDoc will not write any files.
  #
  # source://rdoc//lib/rdoc/options.rb#157
  def dry_run=(_arg0); end

  # The output encoding.  All input files will be transcoded to this encoding.
  #
  # The default encoding is UTF-8.  This is set via --encoding.
  #
  # source://rdoc//lib/rdoc/options.rb#164
  def encoding; end

  # The output encoding.  All input files will be transcoded to this encoding.
  #
  # The default encoding is UTF-8.  This is set via --encoding.
  #
  # source://rdoc//lib/rdoc/options.rb#164
  def encoding=(_arg0); end

  # Create a regexp for #exclude
  #
  # source://rdoc//lib/rdoc/options.rb#545
  def exclude; end

  # Files matching this pattern will be excluded
  #
  # source://rdoc//lib/rdoc/options.rb#169
  def exclude=(_arg0); end

  # The list of files to be processed
  #
  # source://rdoc//lib/rdoc/options.rb#174
  def files; end

  # The list of files to be processed
  #
  # source://rdoc//lib/rdoc/options.rb#174
  def files=(_arg0); end

  # Completes any unfinished option setup business such as filtering for
  # existent files, creating a regexp for #exclude and setting a default
  # #template.
  #
  # source://rdoc//lib/rdoc/options.rb#561
  def finish; end

  # Fixes the page_dir to be relative to the root_dir and adds the page_dir to
  # the files list.
  #
  # source://rdoc//lib/rdoc/options.rb#602
  def finish_page_dir; end

  # Create the output even if the output directory does not look
  # like an rdoc output directory
  #
  # source://rdoc//lib/rdoc/options.rb#180
  def force_output; end

  # Create the output even if the output directory does not look
  # like an rdoc output directory
  #
  # source://rdoc//lib/rdoc/options.rb#180
  def force_output=(_arg0); end

  # Scan newer sources than the flag file if true.
  #
  # source://rdoc//lib/rdoc/options.rb#185
  def force_update; end

  # Scan newer sources than the flag file if true.
  #
  # source://rdoc//lib/rdoc/options.rb#185
  def force_update=(_arg0); end

  # Formatter to mark up text with
  #
  # source://rdoc//lib/rdoc/options.rb#190
  def formatter; end

  # Formatter to mark up text with
  #
  # source://rdoc//lib/rdoc/options.rb#190
  def formatter=(_arg0); end

  # Description of the output generator (set with the <tt>--format</tt> option)
  #
  # source://rdoc//lib/rdoc/options.rb#195
  def generator; end

  # Description of the output generator (set with the <tt>--format</tt> option)
  #
  # source://rdoc//lib/rdoc/options.rb#195
  def generator=(_arg0); end

  # Returns a properly-space list of generators and their descriptions.
  #
  # source://rdoc//lib/rdoc/options.rb#621
  def generator_descriptions; end

  # For #==
  #
  # source://rdoc//lib/rdoc/options.rb#200
  def generator_name; end

  # Loaded generator options.  Used to prevent --help from loading the same
  # options multiple times.
  #
  # source://rdoc//lib/rdoc/options.rb#206
  def generator_options; end

  # Loaded generator options.  Used to prevent --help from loading the same
  # options multiple times.
  #
  # source://rdoc//lib/rdoc/options.rb#206
  def generator_options=(_arg0); end

  # Old rdoc behavior: hyperlink all words that match a method name,
  # even if not preceded by '#' or '::'
  #
  # source://rdoc//lib/rdoc/options.rb#212
  def hyperlink_all; end

  # Old rdoc behavior: hyperlink all words that match a method name,
  # even if not preceded by '#' or '::'
  #
  # source://rdoc//lib/rdoc/options.rb#212
  def hyperlink_all=(_arg0); end

  # source://rdoc//lib/rdoc/options.rb#352
  def init_ivars; end

  # source://rdoc//lib/rdoc/options.rb#397
  def init_with(map); end

  # Include line numbers in the source code
  #
  # source://rdoc//lib/rdoc/options.rb#217
  def line_numbers; end

  # Include line numbers in the source code
  #
  # source://rdoc//lib/rdoc/options.rb#217
  def line_numbers=(_arg0); end

  # The output locale.
  #
  # source://rdoc//lib/rdoc/options.rb#222
  def locale; end

  # The output locale.
  #
  # source://rdoc//lib/rdoc/options.rb#222
  def locale=(_arg0); end

  # The directory where locale data live.
  #
  # source://rdoc//lib/rdoc/options.rb#227
  def locale_dir; end

  # The directory where locale data live.
  #
  # source://rdoc//lib/rdoc/options.rb#227
  def locale_dir=(_arg0); end

  # Name of the file, class or module to display in the initial index page (if
  # not specified the first file we encounter is used)
  #
  # source://rdoc//lib/rdoc/options.rb#233
  def main_page; end

  # Name of the file, class or module to display in the initial index page (if
  # not specified the first file we encounter is used)
  #
  # source://rdoc//lib/rdoc/options.rb#233
  def main_page=(_arg0); end

  # The default markup format.  The default is 'rdoc'.  'markdown', 'tomdoc'
  # and 'rd' are also built-in.
  #
  # source://rdoc//lib/rdoc/options.rb#239
  def markup; end

  # The default markup format.  The default is 'rdoc'.  'markdown', 'tomdoc'
  # and 'rd' are also built-in.
  #
  # source://rdoc//lib/rdoc/options.rb#239
  def markup=(_arg0); end

  # The name of the output directory
  #
  # source://rdoc//lib/rdoc/options.rb#249
  def op_dir; end

  # The name of the output directory
  #
  # source://rdoc//lib/rdoc/options.rb#249
  def op_dir=(_arg0); end

  # The OptionParser for this instance
  #
  # source://rdoc//lib/rdoc/options.rb#254
  def option_parser; end

  # The OptionParser for this instance
  #
  # source://rdoc//lib/rdoc/options.rb#254
  def option_parser=(_arg0); end

  # Output heading decorations?
  #
  # source://rdoc//lib/rdoc/options.rb#258
  def output_decoration; end

  # Output heading decorations?
  #
  # source://rdoc//lib/rdoc/options.rb#258
  def output_decoration=(_arg0); end

  # source://rdoc//lib/rdoc/options.rb#428
  def override(map); end

  # Directory where guides, FAQ, and other pages not associated with a class
  # live.  You may leave this unset if these are at the root of your project.
  #
  # source://rdoc//lib/rdoc/options.rb#264
  def page_dir; end

  # Directory where guides, FAQ, and other pages not associated with a class
  # live.  You may leave this unset if these are at the root of your project.
  #
  # source://rdoc//lib/rdoc/options.rb#264
  def page_dir=(_arg0); end

  # Parses command line options.
  #
  # source://rdoc//lib/rdoc/options.rb#647
  def parse(argv); end

  # Is RDoc in pipe mode?
  #
  # source://rdoc//lib/rdoc/options.rb#269
  def pipe; end

  # Is RDoc in pipe mode?
  #
  # source://rdoc//lib/rdoc/options.rb#269
  def pipe=(_arg0); end

  # Don't display progress as we process the files
  #
  # source://rdoc//lib/rdoc/options.rb#1192
  def quiet; end

  # Set quietness to +bool+
  #
  # source://rdoc//lib/rdoc/options.rb#1199
  def quiet=(bool); end

  # Array of directories to search for files to satisfy an :include:
  #
  # source://rdoc//lib/rdoc/options.rb#274
  def rdoc_include; end

  # Array of directories to search for files to satisfy an :include:
  #
  # source://rdoc//lib/rdoc/options.rb#274
  def rdoc_include=(_arg0); end

  # Root of the source documentation will be generated for.  Set this when
  # building documentation outside the source directory.  Defaults to the
  # current directory.
  #
  # source://rdoc//lib/rdoc/options.rb#281
  def root; end

  # Root of the source documentation will be generated for.  Set this when
  # building documentation outside the source directory.  Defaults to the
  # current directory.
  #
  # source://rdoc//lib/rdoc/options.rb#281
  def root=(_arg0); end

  # Removes directories from +path+ that are outside the current directory
  #
  # source://rdoc//lib/rdoc/options.rb#1206
  def sanitize_path(path); end

  # Set up an output generator for the named +generator_name+.
  #
  # If the found generator responds to :setup_options it will be called with
  # the options instance.  This allows generators to add custom options or set
  # default options.
  #
  # source://rdoc//lib/rdoc/options.rb#1233
  def setup_generator(generator_name = T.unsafe(nil)); end

  # Include the '#' at the front of hyperlinked instance method names
  #
  # source://rdoc//lib/rdoc/options.rb#286
  def show_hash; end

  # Include the '#' at the front of hyperlinked instance method names
  #
  # source://rdoc//lib/rdoc/options.rb#286
  def show_hash=(_arg0); end

  # Indicates if files of test suites should be skipped
  #
  # source://rdoc//lib/rdoc/options.rb#345
  def skip_tests; end

  # Indicates if files of test suites should be skipped
  #
  # source://rdoc//lib/rdoc/options.rb#345
  def skip_tests=(_arg0); end

  # Directory to copy static files from
  #
  # source://rdoc//lib/rdoc/options.rb#291
  def static_path; end

  # Directory to copy static files from
  #
  # source://rdoc//lib/rdoc/options.rb#291
  def static_path=(_arg0); end

  # The number of columns in a tab
  #
  # source://rdoc//lib/rdoc/options.rb#296
  def tab_width; end

  # The number of columns in a tab
  #
  # source://rdoc//lib/rdoc/options.rb#296
  def tab_width=(_arg0); end

  # Template to be used when generating output
  #
  # source://rdoc//lib/rdoc/options.rb#301
  def template; end

  # Template to be used when generating output
  #
  # source://rdoc//lib/rdoc/options.rb#301
  def template=(_arg0); end

  # Directory the template lives in
  #
  # source://rdoc//lib/rdoc/options.rb#306
  def template_dir; end

  # Directory the template lives in
  #
  # source://rdoc//lib/rdoc/options.rb#306
  def template_dir=(_arg0); end

  # Finds the template dir for +template+
  #
  # source://rdoc//lib/rdoc/options.rb#1255
  def template_dir_for(template); end

  # Additional template stylesheets
  #
  # source://rdoc//lib/rdoc/options.rb#311
  def template_stylesheets; end

  # Additional template stylesheets
  #
  # source://rdoc//lib/rdoc/options.rb#311
  def template_stylesheets=(_arg0); end

  # Documentation title
  #
  # source://rdoc//lib/rdoc/options.rb#316
  def title; end

  # Documentation title
  #
  # source://rdoc//lib/rdoc/options.rb#316
  def title=(_arg0); end

  # For dumping YAML
  #
  # source://rdoc//lib/rdoc/options.rb#524
  def to_yaml(*options); end

  # Should RDoc update the timestamps in the output dir?
  #
  # source://rdoc//lib/rdoc/options.rb#321
  def update_output_dir; end

  # Should RDoc update the timestamps in the output dir?
  #
  # source://rdoc//lib/rdoc/options.rb#321
  def update_output_dir=(_arg0); end

  # Verbosity, zero means quiet
  #
  # source://rdoc//lib/rdoc/options.rb#326
  def verbosity; end

  # Verbosity, zero means quiet
  #
  # source://rdoc//lib/rdoc/options.rb#326
  def verbosity=(_arg0); end

  # Minimum visibility of a documented method. One of +:public+, +:protected+,
  # +:private+ or +:nodoc+.
  #
  # The +:nodoc+ visibility ignores all directives related to visibility.  The
  # directive.
  #
  # source://rdoc//lib/rdoc/options.rb#341
  def visibility; end

  # Sets the minimum visibility of a documented method.
  #
  # Accepts +:public+, +:protected+, +:private+, +:nodoc+, or +:all+.
  #
  # When +:all+ is passed, visibility is set to +:private+, similarly to
  # RDOCOPT="--all", see #visibility for more information.
  #
  # source://rdoc//lib/rdoc/options.rb#1272
  def visibility=(visibility); end

  # Displays a warning using Kernel#warn if we're being verbose
  #
  # source://rdoc//lib/rdoc/options.rb#1284
  def warn(message); end

  # URL of web cvs frontend
  #
  # source://rdoc//lib/rdoc/options.rb#331
  def webcvs; end

  # URL of web cvs frontend
  #
  # source://rdoc//lib/rdoc/options.rb#331
  def webcvs=(_arg0); end

  # Writes the YAML file .rdoc_options to the current directory containing the
  # parsed options.
  #
  # source://rdoc//lib/rdoc/options.rb#1292
  def write_options; end

  # source://rdoc//lib/rdoc/options.rb#424
  def yaml_initialize(tag, map); end

  class << self
    # Loads options from .rdoc_options if the file exists, otherwise creates a
    # new RDoc::Options instance.
    #
    # @raise [RDoc::Error]
    #
    # source://rdoc//lib/rdoc/options.rb#1306
    def load_options; end
  end
end

# A parser is simple a class that subclasses RDoc::Parser and implements #scan
# to fill in an RDoc::TopLevel with parsed data.
#
# The initialize method takes an RDoc::TopLevel to fill with parsed content,
# the name of the file to be parsed, the content of the file, an RDoc::Options
# object and an RDoc::Stats object to inform the user of parsed items.  The
# scan method is then called to parse the file and must return the
# RDoc::TopLevel object.  By calling super these items will be set for you.
#
# In order to be used by RDoc the parser needs to register the file extensions
# it can parse.  Use ::parse_files_matching to register extensions.
#
#   require 'rdoc'
#
#   class RDoc::Parser::Xyz < RDoc::Parser
#     parse_files_matching /\.xyz$/
#
#     def initialize top_level, file_name, content, options, stats
#       super
#
#       # extra initialization if needed
#     end
#
#     def scan
#       # parse file and fill in @top_level
#     end
#   end
#
# source://rdoc//lib/rdoc/parser.rb#33
class RDoc::Parser
  # Creates a new Parser storing +top_level+, +file_name+, +content+,
  # +options+ and +stats+ in instance variables.  In +@preprocess+ an
  # RDoc::Markup::PreProcess object is created which allows processing of
  # directives.
  #
  # @return [Parser] a new instance of Parser
  #
  # source://rdoc//lib/rdoc/parser.rb#254
  def initialize(top_level, file_name, content, options, stats); end

  # The name of the file being parsed
  #
  # source://rdoc//lib/rdoc/parser.rb#52
  def file_name; end

  # Normalizes tabs in +body+
  #
  # source://rdoc//lib/rdoc/parser.rb#274
  def handle_tab_width(body); end

  class << self
    # Alias an extension to another extension. After this call, files ending
    # "new_ext" will be parsed using the same parser as "old_ext"
    #
    # source://rdoc//lib/rdoc/parser.rb#58
    def alias_extension(old_ext, new_ext); end

    # Determines if the file is a "binary" file which basically means it has
    # content that an RDoc parser shouldn't try to consume.
    #
    # @return [Boolean]
    #
    # source://rdoc//lib/rdoc/parser.rb#74
    def binary?(file); end

    # Return a parser that can handle a particular extension
    #
    # source://rdoc//lib/rdoc/parser.rb#107
    def can_parse(file_name); end

    # Returns a parser that can handle the extension for +file_name+.  This does
    # not depend upon the file being readable.
    #
    # source://rdoc//lib/rdoc/parser.rb#120
    def can_parse_by_name(file_name); end

    # Returns the file type from the modeline in +file_name+
    #
    # source://rdoc//lib/rdoc/parser.rb#143
    def check_modeline(file_name); end

    # Finds and instantiates the correct parser for the given +file_name+ and
    # +content+.
    #
    # source://rdoc//lib/rdoc/parser.rb#169
    def for(top_level, file_name, content, options, stats); end

    # Record which file types this parser can understand.
    #
    # It is ok to call this multiple times.
    #
    # source://rdoc//lib/rdoc/parser.rb#203
    def parse_files_matching(regexp); end

    # An Array of arrays that maps file extension (or name) regular
    # expressions to parser classes that will parse matching filenames.
    #
    # Use parse_files_matching to register a parser's file extensions.
    #
    # source://rdoc//lib/rdoc/parser.rb#45
    def parsers; end

    # Removes an emacs-style modeline from the first line of the document
    #
    # source://rdoc//lib/rdoc/parser.rb#210
    def remove_modeline(content); end

    # If there is a <tt>markup: parser_name</tt> comment at the front of the
    # file, use it to determine the parser.  For example:
    #
    #   # markup: rdoc
    #   # Class comment can go here
    #
    #   class C
    #   end
    #
    # The comment should appear as the first line of the +content+.
    #
    # If the content contains a shebang or editor modeline the comment may
    # appear on the second or third line.
    #
    # Any comment style may be used to hide the markup comment.
    #
    # source://rdoc//lib/rdoc/parser.rb#231
    def use_markup(content); end

    # Checks if +file+ is a zip file in disguise.  Signatures from
    # http://www.garykessler.net/library/file_sigs.html
    #
    # @return [Boolean]
    #
    # source://rdoc//lib/rdoc/parser.rb#94
    def zip?(file); end
  end
end

# RDoc::Parser::C attempts to parse C extension files.  It looks for
# the standard patterns that you find in extensions: +rb_define_class+,
# +rb_define_method+ and so on.  It tries to find the corresponding
# C source for the methods and extract comments, but if we fail
# we don't worry too much.
#
# The comments associated with a Ruby method are extracted from the C
# comment block associated with the routine that _implements_ that
# method, that is to say the method whose name is given in the
# +rb_define_method+ call. For example, you might write:
#
#   /*
#    * Returns a new array that is a one-dimensional flattening of this
#    * array (recursively). That is, for every element that is an array,
#    * extract its elements into the new array.
#    *
#    *    s = [ 1, 2, 3 ]           #=> [1, 2, 3]
#    *    t = [ 4, 5, 6, [7, 8] ]   #=> [4, 5, 6, [7, 8]]
#    *    a = [ s, t, 9, 10 ]       #=> [[1, 2, 3], [4, 5, 6, [7, 8]], 9, 10]
#    *    a.flatten                 #=> [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
#    */
#    static VALUE
#    rb_ary_flatten(VALUE ary)
#    {
#        ary = rb_obj_dup(ary);
#        rb_ary_flatten_bang(ary);
#        return ary;
#    }
#
#    ...
#
#    void
#    Init_Array(void)
#    {
#      ...
#      rb_define_method(rb_cArray, "flatten", rb_ary_flatten, 0);
#
# Here RDoc will determine from the +rb_define_method+ line that there's a
# method called "flatten" in class Array, and will look for the implementation
# in the method +rb_ary_flatten+. It will then use the comment from that
# method in the HTML output. This method must be in the same source file
# as the +rb_define_method+.
#
# The comment blocks may include special directives:
#
# [Document-class: +name+]
#   Documentation for the named class.
#
# [Document-module: +name+]
#   Documentation for the named module.
#
# [Document-const: +name+]
#   Documentation for the named +rb_define_const+.
#
#   Constant values can be supplied on the first line of the comment like so:
#
#     /* 300: The highest possible score in bowling */
#     rb_define_const(cFoo, "PERFECT", INT2FIX(300));
#
#   The value can contain internal colons so long as they are escaped with a \
#
# [Document-global: +name+]
#   Documentation for the named +rb_define_global_const+
#
# [Document-variable: +name+]
#   Documentation for the named +rb_define_variable+
#
# [Document-method\: +method_name+]
#   Documentation for the named method.  Use this when the method name is
#   unambiguous.
#
# [Document-method\: <tt>ClassName::method_name</tt>]
#   Documentation for a singleton method in the given class.  Use this when
#   the method name alone is ambiguous.
#
# [Document-method\: <tt>ClassName#method_name</tt>]
#   Documentation for a instance method in the given class.  Use this when the
#   method name alone is ambiguous.
#
# [Document-attr: +name+]
#   Documentation for the named attribute.
#
# [call-seq:  <i>text up to an empty line</i>]
#   Because C source doesn't give descriptive names to Ruby-level parameters,
#   you need to document the calling sequence explicitly
#
# In addition, RDoc assumes by default that the C method implementing a
# Ruby function is in the same source file as the rb_define_method call.
# If this isn't the case, add the comment:
#
#   rb_define_method(....);  // in filename
#
# As an example, we might have an extension that defines multiple classes
# in its Init_xxx method. We could document them using
#
#   /*
#    * Document-class:  MyClass
#    *
#    * Encapsulate the writing and reading of the configuration
#    * file. ...
#    */
#
#   /*
#    * Document-method: read_value
#    *
#    * call-seq:
#    *   cfg.read_value(key)            -> value
#    *   cfg.read_value(key} { |key| }  -> value
#    *
#    * Return the value corresponding to +key+ from the configuration.
#    * In the second form, if the key isn't found, invoke the
#    * block and return its value.
#    */
#
# source://rdoc//lib/rdoc/parser/c.rb#119
class RDoc::Parser::C < ::RDoc::Parser
  include ::RDoc::Text

  # Prepares for parsing a C file.  See RDoc::Parser#initialize for details on
  # the arguments.
  #
  # @return [C] a new instance of C
  #
  # source://rdoc//lib/rdoc/parser/c.rb#171
  def initialize(top_level, file_name, content, options, stats); end

  # Add alias, either from a direct alias definition, or from two
  # method that reference the same function.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#250
  def add_alias(var_name, class_obj, old_name, new_name, comment); end

  # Maps C variable names to names of Ruby classes or modules
  #
  # source://rdoc//lib/rdoc/parser/c.rb#133
  def classes; end

  # C file the parser is parsing
  #
  # source://rdoc//lib/rdoc/parser/c.rb#138
  def content; end

  # C file the parser is parsing
  #
  # source://rdoc//lib/rdoc/parser/c.rb#138
  def content=(_arg0); end

  # Scans #content for rb_define_alias
  #
  # source://rdoc//lib/rdoc/parser/c.rb#222
  def do_aliases; end

  # Scans #content for rb_attr and rb_define_attr
  #
  # source://rdoc//lib/rdoc/parser/c.rb#263
  def do_attrs; end

  # Scans #content for boot_defclass
  #
  # source://rdoc//lib/rdoc/parser/c.rb#286
  def do_boot_defclass; end

  # Scans #content for rb_define_class, boot_defclass, rb_define_class_under
  # and rb_singleton_class
  #
  # source://rdoc//lib/rdoc/parser/c.rb#298
  def do_classes_and_modules; end

  # Scans #content for rb_define_variable, rb_define_readonly_variable,
  # rb_define_const and rb_define_global_const
  #
  # source://rdoc//lib/rdoc/parser/c.rb#396
  def do_constants; end

  # Scans #content for rb_include_module
  #
  # source://rdoc//lib/rdoc/parser/c.rb#442
  def do_includes; end

  # Scans #content for rb_define_method, rb_define_singleton_method,
  # rb_define_module_function, rb_define_private_method,
  # rb_define_global_function and define_filetest_function
  #
  # source://rdoc//lib/rdoc/parser/c.rb#458
  def do_methods; end

  # Creates classes and module that were missing were defined due to the file
  # order being different than the declaration order.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#507
  def do_missing; end

  # Dependencies from a missing enclosing class to the classes in
  # missing_dependencies that depend upon it.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#144
  def enclosure_dependencies; end

  # Finds the comment for an alias on +class_name+ from +new_name+ to
  # +old_name+
  #
  # source://rdoc//lib/rdoc/parser/c.rb#523
  def find_alias_comment(class_name, new_name, old_name); end

  # Finds a comment for rb_define_attr, rb_attr or Document-attr.
  #
  # +var_name+ is the C class variable the attribute is defined on.
  # +attr_name+ is the attribute's name.
  #
  # +read+ and +write+ are the read/write flags ('1' or '0').  Either both or
  # neither must be provided.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#541
  def find_attr_comment(var_name, attr_name, read = T.unsafe(nil), write = T.unsafe(nil)); end

  # Find the C code corresponding to a Ruby method
  #
  # source://rdoc//lib/rdoc/parser/c.rb#598
  def find_body(class_name, meth_name, meth_obj, file_content, quiet = T.unsafe(nil)); end

  # Finds a RDoc::NormalClass or RDoc::NormalModule for +raw_name+
  #
  # source://rdoc//lib/rdoc/parser/c.rb#682
  def find_class(raw_name, name, base_name = T.unsafe(nil)); end

  # Look for class or module documentation above Init_+class_name+(void),
  # in a Document-class +class_name+ (or module) comment or above an
  # rb_define_class (or module).  If a comment is supplied above a matching
  # Init_ and a rb_define_class the Init_ comment is used.
  #
  #   /*
  #    * This is a comment for Foo
  #    */
  #   Init_Foo(void) {
  #       VALUE cFoo = rb_define_class("Foo", rb_cObject);
  #   }
  #
  #   /*
  #    * Document-class: Foo
  #    * This is a comment for Foo
  #    */
  #   Init_foo(void) {
  #       VALUE cFoo = rb_define_class("Foo", rb_cObject);
  #   }
  #
  #   /*
  #    * This is a comment for Foo
  #    */
  #   VALUE cFoo = rb_define_class("Foo", rb_cObject);
  #
  # source://rdoc//lib/rdoc/parser/c.rb#723
  def find_class_comment(class_name, class_mod); end

  # Finds a comment matching +type+ and +const_name+ either above the
  # comment or in the matching Document- section.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#789
  def find_const_comment(type, const_name, class_name = T.unsafe(nil)); end

  # Handles modifiers in +comment+ and updates +meth_obj+ as appropriate.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#806
  def find_modifiers(comment, meth_obj); end

  # Finds a <tt>Document-method</tt> override for +meth_obj+ on +class_name+
  #
  # source://rdoc//lib/rdoc/parser/c.rb#816
  def find_override_comment(class_name, meth_obj); end

  # Generate a Ruby-method table
  #
  # source://rdoc//lib/rdoc/parser/c.rb#574
  def gen_body_table(file_content); end

  # Generate a const table
  #
  # source://rdoc//lib/rdoc/parser/c.rb#756
  def gen_const_table(file_content); end

  # Creates a new RDoc::Attr +attr_name+ on class +var_name+ that is either
  # +read+, +write+ or both
  #
  # source://rdoc//lib/rdoc/parser/c.rb#838
  def handle_attr(var_name, attr_name, read, write); end

  # Creates a new RDoc::NormalClass or RDoc::NormalModule based on +type+
  # named +class_name+ in +parent+ which was assigned to the C +var_name+.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#867
  def handle_class_module(var_name, type, class_name, parent, in_module); end

  # Adds constants.  By providing some_value: at the start of the comment you
  # can override the C value of the comment to give a friendly definition.
  #
  #   /* 300: The perfect score in bowling */
  #   rb_define_const(cFoo, "PERFECT", INT2FIX(300));
  #
  # Will override <tt>INT2FIX(300)</tt> with the value +300+ in the output
  # RDoc.  Values may include quotes and escaped colons (\:).
  #
  # source://rdoc//lib/rdoc/parser/c.rb#932
  def handle_constants(type, var_name, const_name, definition); end

  # Removes #ifdefs that would otherwise confuse us
  #
  # source://rdoc//lib/rdoc/parser/c.rb#982
  def handle_ifdefs_in(body); end

  # Adds an RDoc::AnyMethod +meth_name+ defined on a class or module assigned
  # to +var_name+.  +type+ is the type of method definition function used.
  # +singleton_method+ and +module_function+ create a singleton method.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#991
  def handle_method(type, var_name, meth_name, function, param_count, source_file = T.unsafe(nil)); end

  # Registers a singleton class +sclass_var+ as a singleton of +class_var+
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1061
  def handle_singleton(sclass_var, class_var); end

  # Maps C variable names to names of Ruby classes (and singleton classes)
  #
  # source://rdoc//lib/rdoc/parser/c.rb#149
  def known_classes; end

  # Loads the variable map with the given +name+ from the RDoc::Store, if
  # present.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1072
  def load_variable_map(map_name); end

  # Look for directives in a normal comment block:
  #
  #   /*
  #    * :title: My Awesome Project
  #    */
  #
  # This method modifies the +comment+
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1101
  def look_for_directives_in(context, comment); end

  # Classes found while parsing the C file that were not yet registered due to
  # a missing enclosing class.  These are processed by do_missing
  #
  # source://rdoc//lib/rdoc/parser/c.rb#155
  def missing_dependencies; end

  # Creates a RDoc::Comment instance.
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1231
  def new_comment(text = T.unsafe(nil), location = T.unsafe(nil), language = T.unsafe(nil)); end

  # Extracts parameters from the +method_body+ and returns a method
  # parameter string.  Follows 1.9.3dev's scan-arg-spec, see README.EXT
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1120
  def rb_scan_args(method_body); end

  # Removes lines that are commented out that might otherwise get picked up
  # when scanning for classes and methods
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1203
  def remove_commented_out_lines; end

  # Extracts the classes, modules, methods, attributes, constants and aliases
  # from a C file and returns an RDoc::TopLevel for this file
  #
  # source://rdoc//lib/rdoc/parser/c.rb#1211
  def scan; end

  # Maps C variable names to names of Ruby singleton classes
  #
  # source://rdoc//lib/rdoc/parser/c.rb#160
  def singleton_classes; end

  # The TopLevel items in the parsed file belong to
  #
  # source://rdoc//lib/rdoc/parser/c.rb#165
  def top_level; end
end

# :stopdoc:
#
# source://rdoc//lib/rdoc/parser/c.rb#126
RDoc::Parser::C::BOOL_ARG_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rdoc//lib/rdoc/parser/c.rb#127
RDoc::Parser::C::TRUE_VALUES = T.let(T.unsafe(nil), Array)

# A ChangeLog file parser.
#
# This parser converts a ChangeLog into an RDoc::Markup::Document.  When
# viewed as HTML a ChangeLog page will have an entry for each day's entries in
# the sidebar table of contents.
#
# This parser is meant to parse the MRI ChangeLog, but can be used to parse any
# {GNU style Change
# Log}[http://www.gnu.org/prep/standards/html_node/Style-of-Change-Logs.html].
#
# source://rdoc//lib/rdoc/parser/changelog.rb#14
class RDoc::Parser::ChangeLog < ::RDoc::Parser
  include ::RDoc::Parser::Text

  # Attaches the +continuation+ of the previous line to the +entry_body+.
  #
  # Continued function listings are joined together as a single entry.
  # Continued descriptions are joined to make a single paragraph.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#26
  def continue_entry_body(entry_body, continuation); end

  # Creates an RDoc::Markup::Document given the +groups+ of ChangeLog entries.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#44
  def create_document(groups); end

  # Returns a list of ChangeLog entries an RDoc::Markup nodes for the given
  # +entries+.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#66
  def create_entries(entries); end

  # Returns an RDoc::Markup::List containing the given +items+ in the
  # ChangeLog
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#83
  def create_items(items); end

  # Groups +entries+ by date.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#103
  def group_entries(entries); end

  # Parse date in ISO-8601, RFC-2822, or default of Git
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#119
  def parse_date(date); end

  # Parses the entries in the ChangeLog.
  #
  # Returns an Array of each ChangeLog entry in order of parsing.
  #
  # A ChangeLog entry is an Array containing the ChangeLog title (date and
  # committer) and an Array of ChangeLog items (file and function changed with
  # description).
  #
  # An example result would be:
  #
  #    [ 'Tue Dec  4 08:33:46 2012  Eric Hodel  <drbrain@segment7.net>',
  #      [ 'README.EXT:  Converted to RDoc format',
  #        'README.EXT.ja:  ditto']]
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#149
  def parse_entries; end

  # Converts the ChangeLog into an RDoc::Markup::Document
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#206
  def scan; end
end

# The extension for Git commit log
#
# source://rdoc//lib/rdoc/parser/changelog.rb#222
module RDoc::Parser::ChangeLog::Git
  # Returns a list of ChangeLog entries as
  # RDoc::Parser::ChangeLog::Git::LogEntry list for the given
  # +entries+.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#262
  def create_entries(entries); end

  # Parses the entries in the Git commit logs
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#235
  def parse_entries; end

  # Parses auxiliary info.  Currentry `base-url` to expand
  # references is effective.
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#227
  def parse_info(info); end
end

# source://rdoc//lib/rdoc/parser/changelog.rb#271
RDoc::Parser::ChangeLog::Git::HEADING_LEVEL = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/changelog.rb#270
class RDoc::Parser::ChangeLog::Git::LogEntry < ::Struct
  # @return [LogEntry] a new instance of LogEntry
  #
  # source://rdoc//lib/rdoc/parser/changelog.rb#273
  def initialize(base, commit, author, email, date, contents); end

  # source://rdoc//lib/rdoc/parser/changelog.rb#313
  def accept(visitor); end

  # source://rdoc//lib/rdoc/parser/changelog.rb#294
  def aref; end

  # Returns the value of attribute author
  #
  # @return [Object] the current value of author
  def author; end

  # Sets the attribute author
  #
  # @param value [Object] the value to set the attribute author to.
  # @return [Object] the newly set value
  def author=(_); end

  # Returns the value of attribute base
  #
  # @return [Object] the current value of base
  def base; end

  # Sets the attribute base
  #
  # @param value [Object] the value to set the attribute base to.
  # @return [Object] the newly set value
  def base=(_); end

  # Returns the value of attribute commit
  #
  # @return [Object] the current value of commit
  def commit; end

  # Sets the attribute commit
  #
  # @param value [Object] the value to set the attribute commit to.
  # @return [Object] the newly set value
  def commit=(_); end

  # Returns the value of attribute contents
  #
  # @return [Object] the current value of contents
  def contents; end

  # Sets the attribute contents
  #
  # @param value [Object] the value to set the attribute contents to.
  # @return [Object] the newly set value
  def contents=(_); end

  # Returns the value of attribute date
  #
  # @return [Object] the current value of date
  def date; end

  # Sets the attribute date
  #
  # @param value [Object] the value to set the attribute date to.
  # @return [Object] the newly set value
  def date=(_); end

  # Returns the value of attribute email
  #
  # @return [Object] the current value of email
  def email; end

  # Sets the attribute email
  #
  # @param value [Object] the value to set the attribute email to.
  # @return [Object] the newly set value
  def email=(_); end

  # source://rdoc//lib/rdoc/parser/changelog.rb#298
  def label(context = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/parser/changelog.rb#290
  def level; end

  # source://rdoc//lib/rdoc/parser/changelog.rb#330
  def pretty_print(q); end

  # source://rdoc//lib/rdoc/parser/changelog.rb#302
  def text; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Parse a Markdown format file.  The parsed RDoc::Markup::Document is attached
# as a file comment.
#
# source://rdoc//lib/rdoc/parser/markdown.rb#6
class RDoc::Parser::Markdown < ::RDoc::Parser
  include ::RDoc::Parser::Text

  # Creates an Markdown-format TopLevel for the given file.
  #
  # source://rdoc//lib/rdoc/parser/markdown.rb#15
  def scan; end
end

# Parse a RD format file.  The parsed RDoc::Markup::Document is attached as a
# file comment.
#
# source://rdoc//lib/rdoc/parser/rd.rb#6
class RDoc::Parser::RD < ::RDoc::Parser
  include ::RDoc::Parser::Text

  # Creates an rd-format TopLevel for the given file.
  #
  # source://rdoc//lib/rdoc/parser/rd.rb#15
  def scan; end
end

# Wrapper for Ripper lex states
#
# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#7
class RDoc::Parser::RipperStateLex
  # New lexer for +code+.
  #
  # @return [RipperStateLex] a new instance of RipperStateLex
  #
  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#576
  def initialize(code); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#322
  def get_squashed_tk; end

  private

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#465
  def get_embdoc_tk(tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#474
  def get_heredoc_tk(heredoc_name, indent); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#549
  def get_op_tk(tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#447
  def get_regexp_tk(tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#420
  def get_string_tk(tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#373
  def get_symbol_tk(tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#511
  def get_words_tk(tk); end

  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#499
  def heredoc_end?(name, indent, tk); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#493
  def retrieve_heredoc_info(tk); end

  class << self
    # Returns +true+ if lex state will be +END+ after +token+.
    #
    # @return [Boolean]
    #
    # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#597
    def end?(token); end

    # Returns tokens parsed from +code+.
    #
    # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#584
    def parse(code); end
  end
end

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#20
RDoc::Parser::RipperStateLex::EXPR_ARG = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#31
RDoc::Parser::RipperStateLex::EXPR_ARG_ANY = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#16
RDoc::Parser::RipperStateLex::EXPR_BEG = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#30
RDoc::Parser::RipperStateLex::EXPR_BEG_ANY = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#25
RDoc::Parser::RipperStateLex::EXPR_CLASS = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#21
RDoc::Parser::RipperStateLex::EXPR_CMDARG = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#24
RDoc::Parser::RipperStateLex::EXPR_DOT = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#17
RDoc::Parser::RipperStateLex::EXPR_END = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#18
RDoc::Parser::RipperStateLex::EXPR_ENDARG = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#19
RDoc::Parser::RipperStateLex::EXPR_ENDFN = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#32
RDoc::Parser::RipperStateLex::EXPR_END_ANY = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#28
RDoc::Parser::RipperStateLex::EXPR_FITEM = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#23
RDoc::Parser::RipperStateLex::EXPR_FNAME = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#26
RDoc::Parser::RipperStateLex::EXPR_LABEL = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#27
RDoc::Parser::RipperStateLex::EXPR_LABELED = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#22
RDoc::Parser::RipperStateLex::EXPR_MID = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#15
RDoc::Parser::RipperStateLex::EXPR_NONE = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#29
RDoc::Parser::RipperStateLex::EXPR_VALUE = T.let(T.unsafe(nil), Integer)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#312
class RDoc::Parser::RipperStateLex::InnerStateLex < ::Ripper::Filter
  # @return [InnerStateLex] a new instance of InnerStateLex
  #
  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#313
  def initialize(code); end

  # source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#317
  def on_default(event, tok, data); end
end

# TODO: Remove this constants after Ruby 2.4 EOL
#
# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#11
RDoc::Parser::RipperStateLex::RIPPER_HAS_LEX_STATE = T.let(T.unsafe(nil), TrueClass)

# source://rdoc//lib/rdoc/parser/ripper_state_lex.rb#13
class RDoc::Parser::RipperStateLex::Token < ::Struct
  # Returns the value of attribute char_no
  #
  # @return [Object] the current value of char_no
  def char_no; end

  # Sets the attribute char_no
  #
  # @param value [Object] the value to set the attribute char_no to.
  # @return [Object] the newly set value
  def char_no=(_); end

  # Returns the value of attribute kind
  #
  # @return [Object] the current value of kind
  def kind; end

  # Sets the attribute kind
  #
  # @param value [Object] the value to set the attribute kind to.
  # @return [Object] the newly set value
  def kind=(_); end

  # Returns the value of attribute line_no
  #
  # @return [Object] the current value of line_no
  def line_no; end

  # Sets the attribute line_no
  #
  # @param value [Object] the value to set the attribute line_no to.
  # @return [Object] the newly set value
  def line_no=(_); end

  # Returns the value of attribute state
  #
  # @return [Object] the current value of state
  def state; end

  # Sets the attribute state
  #
  # @param value [Object] the value to set the attribute state to.
  # @return [Object] the newly set value
  def state=(_); end

  # Returns the value of attribute text
  #
  # @return [Object] the current value of text
  def text; end

  # Sets the attribute text
  #
  # @param value [Object] the value to set the attribute text to.
  # @return [Object] the newly set value
  def text=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Extracts code elements from a source file returning a TopLevel object
# containing the constituent file elements.
#
# This file is based on rtags
#
# RubyParser understands how to document:
# * classes
# * modules
# * methods
# * constants
# * aliases
# * private, public, protected
# * private_class_function, public_class_function
# * private_constant, public_constant
# * module_function
# * attr, attr_reader, attr_writer, attr_accessor
# * extra accessors given on the command line
# * metaprogrammed methods
# * require
# * include
#
# == Method Arguments
#
# --
# NOTE: I don't think this works, needs tests, remove the paragraph following
# this block when known to work
#
# The parser extracts the arguments from the method definition.  You can
# override this with a custom argument definition using the :args: directive:
#
#   ##
#   # This method tries over and over until it is tired
#
#   def go_go_go(thing_to_try, tries = 10) # :args: thing_to_try
#     puts thing_to_try
#     go_go_go thing_to_try, tries - 1
#   end
#
# If you have a more-complex set of overrides you can use the :call-seq:
# directive:
# ++
#
# The parser extracts the arguments from the method definition.  You can
# override this with a custom argument definition using the :call-seq:
# directive:
#
#   ##
#   # This method can be called with a range or an offset and length
#   #
#   # :call-seq:
#   #   my_method(Range)
#   #   my_method(offset, length)
#
#   def my_method(*args)
#   end
#
# The parser extracts +yield+ expressions from method bodies to gather the
# yielded argument names.  If your method manually calls a block instead of
# yielding or you want to override the discovered argument names use
# the :yields: directive:
#
#   ##
#   # My method is awesome
#
#   def my_method(&block) # :yields: happy, times
#     block.call 1, 2
#   end
#
# == Metaprogrammed Methods
#
# To pick up a metaprogrammed method, the parser looks for a comment starting
# with '##' before an identifier:
#
#   ##
#   # This is a meta-programmed method!
#
#   add_my_method :meta_method, :arg1, :arg2
#
# The parser looks at the token after the identifier to determine the name, in
# this example, :meta_method.  If a name cannot be found, a warning is printed
# and 'unknown is used.
#
# You can force the name of a method using the :method: directive:
#
#   ##
#   # :method: some_method!
#
# By default, meta-methods are instance methods.  To indicate that a method is
# a singleton method instead use the :singleton-method: directive:
#
#   ##
#   # :singleton-method:
#
# You can also use the :singleton-method: directive with a name:
#
#   ##
#   # :singleton-method: some_method!
#
# You can define arguments for metaprogrammed methods via either the
# :call-seq:, :arg: or :args: directives.
#
# Additionally you can mark a method as an attribute by
# using :attr:, :attr_reader:, :attr_writer: or :attr_accessor:.  Just like
# for :method:, the name is optional.
#
#   ##
#   # :attr_reader: my_attr_name
#
# == Hidden methods and attributes
#
# You can provide documentation for methods that don't appear using
# the :method:, :singleton-method: and :attr: directives:
#
#   ##
#   # :attr_writer: ghost_writer
#   # There is an attribute here, but you can't see it!
#
#   ##
#   # :method: ghost_method
#   # There is a method here, but you can't see it!
#
#   ##
#   # this is a comment for a regular method
#
#   def regular_method() end
#
# Note that by default, the :method: directive will be ignored if there is a
# standard rdocable item following it.
#
# source://rdoc//lib/rdoc/parser/ruby.rb#144
class RDoc::Parser::Ruby < ::RDoc::Parser
  include ::RDoc::TokenStream
  include ::RDoc::Parser::RubyTools

  # Creates a new Ruby parser.
  #
  # @return [Ruby] a new instance of Ruby
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#164
  def initialize(top_level, file_name, content, options, stats); end

  # Look for the first comment in a file that isn't a shebang line.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#236
  def collect_first_comment; end

  # Consumes trailing whitespace from the token stream
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#279
  def consume_trailing_spaces; end

  # Creates a new attribute in +container+ with +name+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#286
  def create_attr(container, single, name, rw, comment); end

  # Creates a module alias in +container+ at +rhs_name+ (or at the top-level
  # for "::") with the name from +constant+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#300
  def create_module_alias(container, constant, rhs_name); end

  # Aborts with +msg+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#313
  def error(msg); end

  # Looks for a true or false token.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#322
  def get_bool; end

  # Look for the name of a class of module (optionally with a leading :: or
  # with :: separated named) and return the ultimate name, the associated
  # container, and the given name (with the ::).
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#340
  def get_class_or_module(container, ignore_constants = T.unsafe(nil)); end

  # Return a superclass, which can be either a constant of an expression
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#423
  def get_class_specification; end

  # Parse a constant, which might be qualified by one or more class or module
  # names
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#456
  def get_constant; end

  # Little hack going on here. In the statement:
  #
  #   f = 2*(1+yield)
  #
  # We see the RPAREN as the next token, so we need to exit early.  This still
  # won't catch all cases (such as "a = yield + 1"
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#558
  def get_end_token(tk); end

  # Get an included module that may be surrounded by parens
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#473
  def get_included_module_with_optional_parens; end

  # Retrieves the method container for a singleton method.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#578
  def get_method_container(container, name_t); end

  # Extracts a name or symbol from the token stream.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#621
  def get_symbol_or_name; end

  # Retrieves the read token stream and replaces +pattern+ with +replacement+
  # using gsub.  If the result is only a ";" returns an empty string.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#194
  def get_tkread_clean(pattern, replacement); end

  # Extracts the visibility information for the visibility token +tk+
  # and +single+ class type identifier.
  #
  # Returns the visibility type (a string), the visibility (a symbol) and
  # +singleton+ if the methods following should be converted to singleton
  # methods.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#208
  def get_visibility_information(tk, single); end

  # Look for directives in a normal comment block:
  #
  #   # :stopdoc:
  #   # Don't display comment from this point forward
  #
  # This routine modifies its +comment+ parameter.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#661
  def look_for_directives_in(container, comment); end

  # Adds useful info about the parser to +message+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#681
  def make_message(message); end

  # Creates a comment with the correct format
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#693
  def new_comment(comment, line_no = T.unsafe(nil)); end

  # Parses an +alias+ in +context+ with +comment+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#762
  def parse_alias(context, single, tk, comment); end

  # Creates an RDoc::Attr for the name following +tk+, setting the comment to
  # +comment+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#704
  def parse_attr(context, single, tk, comment); end

  # Creates an RDoc::Attr for each attribute listed after +tk+, setting the
  # comment for each to +comment+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#733
  def parse_attr_accessor(context, single, tk, comment); end

  # Extracts call parameters from the token stream.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#803
  def parse_call_parameters(tk); end

  # Parses a class in +context+ with +comment+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#846
  def parse_class(container, single, tk, comment); end

  # Parses and creates a regular class
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#880
  def parse_class_regular(container, declaration_context, single, name_t, given_name, comment); end

  # Parses a singleton class in +container+ with the given +name+ and
  # +comment+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#920
  def parse_class_singleton(container, name, comment); end

  # Generates an RDoc::Method or RDoc::Attr from +comment+ by looking for
  # :method: or :attr: directives in +comment+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1085
  def parse_comment(container, tk, comment); end

  # Parse a comment that is describing an attribute in +container+ with the
  # given +name+ and +comment+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1113
  def parse_comment_attr(container, type, name, comment); end

  # source://rdoc//lib/rdoc/parser/ruby.rb#1125
  def parse_comment_ghost(container, text, name, column, line_no, comment); end

  # Creates an RDoc::Method on +container+ from +comment+ if there is a
  # Signature section in the comment
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1164
  def parse_comment_tomdoc(container, tk, comment); end

  # Parses a constant in +context+ with +comment+.  If +ignore_constants+ is
  # true, no found constants will be added to RDoc.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#959
  def parse_constant(container, tk, comment, ignore_constants = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/parser/ruby.rb#1026
  def parse_constant_body(container, constant, is_array_or_hash); end

  # Parses a Module#private_constant or Module#public_constant call from +tk+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2103
  def parse_constant_visibility(container, single, tk); end

  # Parses an +include+ or +extend+, indicated by the +klass+ and adds it to
  # +container+ # with +comment+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1199
  def parse_extend_or_include(klass, container, comment); end

  # Parses identifiers that can create new methods or change visibility.
  #
  # Returns true if the comment was not consumed.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1237
  def parse_identifier(container, single, tk, comment); end

  # Parses an +included+ with a block feature of ActiveSupport::Concern.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1219
  def parse_included_with_activesupport_concern(container, comment); end

  # Parses a meta-programmed attribute and creates an RDoc::Attr.
  #
  # To create foo and bar attributes on class C with comment "My attributes":
  #
  #   class C
  #
  #     ##
  #     # :attr:
  #     #
  #     # My attributes
  #
  #     my_attr :foo, :bar
  #
  #   end
  #
  # To create a foo attribute on class C with comment "My attribute":
  #
  #   class C
  #
  #     ##
  #     # :attr: foo
  #     #
  #     # My attribute
  #
  #     my_attr :foo, :bar
  #
  #   end
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1301
  def parse_meta_attr(context, single, tk, comment); end

  # Parses a meta-programmed method
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1335
  def parse_meta_method(container, single, tk, comment); end

  # Parses the name of a metaprogrammed method.  +comment+ is used to
  # determine the name while +tk+ is used in an error message if the name
  # cannot be determined.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1381
  def parse_meta_method_name(comment, tk); end

  # Parses the parameters and block for a meta-programmed method.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1405
  def parse_meta_method_params(container, single, meth, tk, comment); end

  # Parses a normal method defined by +def+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1437
  def parse_method(container, single, tk, comment); end

  # Parses a method that needs to be ignored.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1522
  def parse_method_dummy(container); end

  # Parses the name of a method in +container+.
  #
  # Returns the method name, the container it is in (for def Foo.name) and if
  # it is a singleton or regular method.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1535
  def parse_method_name(container); end

  # For the given +container+ and initial name token +name_t+ the method name
  # is parsed from the token stream for a regular method.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1562
  def parse_method_name_regular(container, name_t); end

  # For the given +container+ and initial name token +name_t+ the method name
  # and the new +container+ (if necessary) are parsed from the token stream
  # for a singleton method.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1580
  def parse_method_name_singleton(container, name_t); end

  # Extracts +yield+ parameters from +method+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1624
  def parse_method_or_yield_parameters(method = T.unsafe(nil), modifiers = T.unsafe(nil)); end

  # Capture the method's parameters. Along the way, look for a comment
  # containing:
  #
  #    # yields: ....
  #
  # and add this as the block_params for the method
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1691
  def parse_method_parameters(method); end

  # Parses the parameters and body of +meth+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1492
  def parse_method_params_and_body(container, single, meth, added_container); end

  # Parses an RDoc::NormalModule in +container+ with +comment+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1706
  def parse_module(container, single, tk, comment); end

  # Parses an RDoc::Require in +context+ containing +comment+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1728
  def parse_require(context, comment); end

  # Parses a rescue
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1749
  def parse_rescue; end

  # The core of the Ruby parser.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1780
  def parse_statements(container, single = T.unsafe(nil), current_method = T.unsafe(nil), comment = T.unsafe(nil)); end

  # Parse up to +no+ symbol arguments
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1971
  def parse_symbol_arg(no = T.unsafe(nil)); end

  # Parses up to +no+ symbol arguments surrounded by () and places them in
  # +args+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1986
  def parse_symbol_arg_paren(no); end

  # Parses up to +no+ symbol arguments separated by spaces and places them in
  # +args+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2014
  def parse_symbol_arg_space(no, tk); end

  # Returns symbol text from the next token
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2045
  def parse_symbol_in_arg; end

  # Parses statements in the top-level +container+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2062
  def parse_top_level_statements(container); end

  # Determines the visibility in +container+ from +tk+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2080
  def parse_visibility(container, single, tk); end

  # Determines the block parameter for +context+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2119
  def parse_yield(context, single, tk, method); end

  # Directives are modifier comments that can appear after class, module, or
  # method names. For example:
  #
  #   def fred # :yields: a, b
  #
  # or:
  #
  #
  # We return the directive name and any parameters as a two element array if
  # the name is in +allowed+.  A directive can be found anywhere up to the end
  # of the current line.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2140
  def read_directive(allowed); end

  # Handles directives following the definition for +context+ (any
  # RDoc::CodeObject) if the directives are +allowed+ at this point.
  #
  # See also RDoc::Markup::PreProcess#handle_directive
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2172
  def read_documentation_modifiers(context, allowed); end

  # Records the location of this +container+ in the file for this parser and
  # adds it to the list of classes and modules in the file.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2191
  def record_location(container); end

  # Retrieve comment body without =begin/=end
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#1769
  def retrieve_comment_body(tk); end

  # Scans this Ruby file for Ruby constructs
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2203
  def scan; end

  # skip the var [in] part of a 'for' statement
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2291
  def skip_for_variable; end

  # Skips the next method in +container+
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2302
  def skip_method(container); end

  # while, until, and for have an optional do
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2250
  def skip_optional_do_after_expression; end

  # Skip opening parentheses and yield the block.
  # Skip closing parentheses too when exists.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#401
  def skip_parentheses(&block); end

  # Skip spaces until a comment is found
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2311
  def skip_tkspace_comment(skip_nl = T.unsafe(nil)); end

  # Marks containers between +container+ and +ancestor+ as ignored
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#646
  def suppress_parents(container, ancestor); end

  # Return +true+ if +tk+ is a newline.
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#186
  def tk_nl?(tk); end

  # Updates visibility in +container+ from +vis_type+ and +vis+.
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2323
  def update_visibility(container, vis_type, vis, singleton); end

  # Prints +message+ to +$stderr+ unless we're being quiet
  #
  # source://rdoc//lib/rdoc/parser/ruby.rb#2368
  def warn(message); end
end

# Collection of methods for writing parsers
#
# source://rdoc//lib/rdoc/parser/ruby_tools.rb#5
module RDoc::Parser::RubyTools
  # Adds a token listener +obj+, but you should probably use token_listener
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#10
  def add_token_listener(obj); end

  # Fetches the next token from the scanner
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#18
  def get_tk; end

  # Reads and returns all tokens up to one of +tokens+.  Leaves the matched
  # token in the token list.
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#52
  def get_tk_until(*tokens); end

  # Retrieves a String representation of the read tokens
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#73
  def get_tkread; end

  # Peek equivalent for get_tkread
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#82
  def peek_read; end

  # Peek at the next token, but don't remove it from the stream
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#89
  def peek_tk; end

  # Removes the token listener +obj+
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#97
  def remove_token_listener(obj); end

  # Resets the tools
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#104
  def reset; end

  # Skips whitespace tokens including newlines
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#115
  def skip_tkspace; end

  # Skips whitespace tokens excluding newlines
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#129
  def skip_tkspace_without_nl; end

  # Has +obj+ listen to tokens
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#143
  def token_listener(obj); end

  # Returns +tk+ to the scanner
  #
  # source://rdoc//lib/rdoc/parser/ruby_tools.rb#153
  def unget_tk(tk); end
end

# Parse a non-source file. We basically take the whole thing as one big
# comment.
#
# source://rdoc//lib/rdoc/parser/simple.rb#6
class RDoc::Parser::Simple < ::RDoc::Parser
  include ::RDoc::Parser::Text

  # Prepare to parse a plain file
  #
  # @return [Simple] a new instance of Simple
  #
  # source://rdoc//lib/rdoc/parser/simple.rb#17
  def initialize(top_level, file_name, content, options, stats); end

  # source://rdoc//lib/rdoc/parser/simple.rb#12
  def content; end

  # Removes the encoding magic comment from +text+
  #
  # source://rdoc//lib/rdoc/parser/simple.rb#41
  def remove_coding_comment(text); end

  # Removes private comments.
  #
  # Unlike RDoc::Comment#remove_private this implementation only looks for two
  # dashes at the beginning of the line.  Three or more dashes are considered
  # to be a rule and ignored.
  #
  # source://rdoc//lib/rdoc/parser/simple.rb#52
  def remove_private_comment(comment); end

  # Extract the file contents and attach them to the TopLevel as a comment
  #
  # source://rdoc//lib/rdoc/parser/simple.rb#28
  def scan; end
end

# source://rdoc//lib/rdoc/rd.rb#72
class RDoc::RD
  class << self
    # Parses +rd+ source and returns an RDoc::Markup::Document.  If the
    # <tt>=begin</tt> or <tt>=end</tt> lines are missing they will be added.
    #
    # source://rdoc//lib/rdoc/rd.rb#78
    def parse(rd); end
  end
end

# RD format parser for headings, paragraphs, lists, verbatim sections that
# exist as blocks.
#
# source://rdoc//lib/rdoc/rd/block_parser.rb#660
class RDoc::RD::BlockParser < ::Racc::Parser
  # Creates a new RDoc::RD::BlockParser.  Use #parse to parse an rd-format
  # document.
  #
  # @return [BlockParser] a new instance of BlockParser
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#695
  def initialize; end

  # reduce 0 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1330
  def _reduce_1(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1372
  def _reduce_10(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1377
  def _reduce_11(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1382
  def _reduce_12(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1390
  def _reduce_13(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1396
  def _reduce_14(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1403
  def _reduce_15(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1408
  def _reduce_16(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1413
  def _reduce_17(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1424
  def _reduce_18(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1435
  def _reduce_19(val, _values, result); end

  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1335
  def _reduce_2(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1441
  def _reduce_20(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1447
  def _reduce_21(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1453
  def _reduce_22(val, _values, result); end

  # reduce 26 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1469
  def _reduce_27(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1475
  def _reduce_28(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1481
  def _reduce_29(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1340
  def _reduce_3(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1487
  def _reduce_30(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1492
  def _reduce_31(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1497
  def _reduce_32(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1503
  def _reduce_33(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1508
  def _reduce_34(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1513
  def _reduce_35(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1519
  def _reduce_36(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1525
  def _reduce_37(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1530
  def _reduce_38(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1535
  def _reduce_39(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1345
  def _reduce_4(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1541
  def _reduce_40(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1547
  def _reduce_41(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1552
  def _reduce_42(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1557
  def _reduce_43(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1565
  def _reduce_44(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1571
  def _reduce_45(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1576
  def _reduce_46(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1581
  def _reduce_47(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1587
  def _reduce_48(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1593
  def _reduce_49(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1350
  def _reduce_5(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1599
  def _reduce_50(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1605
  def _reduce_51(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1611
  def _reduce_52(val, _values, result); end

  # reduce 53 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1618
  def _reduce_54(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1623
  def _reduce_55(val, _values, result); end

  # reduce 56 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1630
  def _reduce_57(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1355
  def _reduce_6(val, _values, result); end

  # reduce 61 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1643
  def _reduce_62(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1649
  def _reduce_63(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1655
  def _reduce_64(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1661
  def _reduce_65(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1667
  def _reduce_66(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1673
  def _reduce_67(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1678
  def _reduce_68(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1683
  def _reduce_69(val, _values, result); end

  # reduce 70 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1690
  def _reduce_71(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1695
  def _reduce_72(val, _values, result); end

  # reduce 7 omitted
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1362
  def _reduce_8(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1367
  def _reduce_9(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#1700
  def _reduce_none(val, _values, result); end

  # Adds footnote +content+ to the document
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1045
  def add_footnote(content); end

  # Adds label +label+ to the document
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1059
  def add_label(label); end

  # Retrieves the content of +values+ as a single String
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1028
  def content(values); end

  # Footnotes for this document
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#679
  def footnotes; end

  # Path to find included files in
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#689
  def include_path; end

  # Path to find included files in
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#689
  def include_path=(_arg0); end

  # Labels for items in this document
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#684
  def labels; end

  # Current line number
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#983
  def line_index; end

  # Returns the next token from the document
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#751
  def next_token; end

  # Raises a ParseError when invalid formatting is found
  #
  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#967
  def on_error(et, ev, _values); end

  # Creates a paragraph for +value+
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1035
  def paragraph(value); end

  # Parses +src+ and returns an RDoc::Markup::Document.
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#707
  def parse(src); end

  private

  # Cuts off excess whitespace in +src+
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#931
  def cut_off(src); end

  # Formats line numbers +line_numbers+ prettily
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1019
  def format_line_num(*line_numbers); end

  # Retrieves the content for +file+ from the include_path
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#1000
  def get_included(file); end

  # Yields to the given block if +indent+ matches the current indent, otherwise
  # an indentation token is processed.
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#913
  def if_current_indent_equal(indent); end

  # Parses subtree +src+
  #
  # source://rdoc//lib/rdoc/rd/block_parser.rb#990
  def parse_subtree(src); end

  # source://rdoc//lib/rdoc/rd/block_parser.rb#958
  def set_term_to_element(parent, term); end
end

# source://rdoc//lib/rdoc/rd/block_parser.rb#1324
RDoc::RD::BlockParser::Racc_debug_parser = T.let(T.unsafe(nil), FalseClass)

# Inline keeps track of markup and labels to create proper links.
#
# source://rdoc//lib/rdoc/rd/inline.rb#5
class RDoc::RD::Inline
  # Initializes the Inline with +rdoc+ and +inline+
  #
  # @return [Inline] a new instance of Inline
  #
  # source://rdoc//lib/rdoc/rd/inline.rb#34
  def initialize(rdoc, reference); end

  # source://rdoc//lib/rdoc/rd/inline.rb#42
  def ==(other); end

  # Appends +more+ to this inline.  +more+ may be a String or another Inline.
  #
  # source://rdoc//lib/rdoc/rd/inline.rb#50
  def append(more); end

  # source://rdoc//lib/rdoc/rd/inline.rb#65
  def inspect; end

  # The markup of this reference in RDoc format
  #
  # source://rdoc//lib/rdoc/rd/inline.rb#15
  def rdoc; end

  # The text of the reference
  #
  # source://rdoc//lib/rdoc/rd/inline.rb#10
  def reference; end

  # The markup of this reference in RDoc format
  #
  # source://rdoc//lib/rdoc/rd/inline.rb#15
  def to_s; end

  class << self
    # Creates a new Inline for +rdoc+ and +reference+.
    #
    # +rdoc+ may be another Inline or a String.  If +reference+ is not given it
    # will use the text from +rdoc+.
    #
    # source://rdoc//lib/rdoc/rd/inline.rb#23
    def new(rdoc, reference = T.unsafe(nil)); end
  end
end

# RD format parser for inline markup such as emphasis, links, footnotes, etc.
#
# source://rdoc//lib/rdoc/rd/inline_parser.rb#661
class RDoc::RD::InlineParser < ::Racc::Parser
  # Creates a new parser for inline markup in the rd format.  The +block_parser+
  # is used to for footnotes and labels in the inline text.
  #
  # @return [InlineParser] a new instance of InlineParser
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#734
  def initialize(block_parser); end

  # reduce 100 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1746
  def _reduce_101(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1753
  def _reduce_102(val, _values, result); end

  # reduce 108 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1771
  def _reduce_109(val, _values, result); end

  # reduce 110 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1778
  def _reduce_111(val, _values, result); end

  # reduce 112 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1786
  def _reduce_113(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1791
  def _reduce_114(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1796
  def _reduce_115(val, _values, result); end

  # reduce 12 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1409
  def _reduce_13(val, _values, result); end

  # reduce 135 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1841
  def _reduce_136(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1416
  def _reduce_14(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1423
  def _reduce_15(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1430
  def _reduce_16(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1437
  def _reduce_17(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1445
  def _reduce_18(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1451
  def _reduce_19(val, _values, result); end

  # reduce 1 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1381
  def _reduce_2(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1459
  def _reduce_20(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1465
  def _reduce_21(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1474
  def _reduce_22(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1480
  def _reduce_23(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1486
  def _reduce_24(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1492
  def _reduce_25(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1501
  def _reduce_26(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1507
  def _reduce_27(val, _values, result); end

  # reduce 28 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1516
  def _reduce_29(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1386
  def _reduce_3(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1521
  def _reduce_30(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1526
  def _reduce_31(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1532
  def _reduce_32(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1538
  def _reduce_33(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1544
  def _reduce_34(val, _values, result); end

  # reduce 35 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1552
  def _reduce_36(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1557
  def _reduce_37(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1562
  def _reduce_38(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1568
  def _reduce_39(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1574
  def _reduce_40(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1580
  def _reduce_41(val, _values, result); end

  # reduce 42 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1588
  def _reduce_43(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1594
  def _reduce_44(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1600
  def _reduce_45(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1606
  def _reduce_46(val, _values, result); end

  # reduce 56 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1632
  def _reduce_57(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1638
  def _reduce_58(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1644
  def _reduce_59(val, _values, result); end

  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1650
  def _reduce_60(val, _values, result); end

  # reduce 61 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1657
  def _reduce_62(val, _values, result); end

  # reduce 63 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1665
  def _reduce_64(val, _values, result); end

  # reduce 77 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1697
  def _reduce_78(val, _values, result); end

  # reduce 137 omitted
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#1848
  def _reduce_none(val, _values, result); end

  # Creates a new RDoc::RD::Inline for the +rdoc+ markup and the raw +reference+
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#883
  def inline(rdoc, reference = T.unsafe(nil)); end

  # Returns the next token from the inline text
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#752
  def next_token; end

  # Returns words following an error
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#872
  def next_words_on_error; end

  # Raises a ParseError when invalid formatting is found
  #
  # @raise [ParseError]
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#832
  def on_error(et, ev, values); end

  # Parses the +inline+ text from RD format into RDoc format.
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#741
  def parse(inline); end

  # Returns words before the error
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#849
  def prev_words_on_error(ev); end

  private

  # Returns the last line of +src+
  #
  # source://rdoc//lib/rdoc/rd/inline_parser.rb#860
  def last_line(src); end
end

# source://rdoc//lib/rdoc/rd/inline_parser.rb#1373
RDoc::RD::InlineParser::Racc_debug_parser = T.let(T.unsafe(nil), FalseClass)

# This is the driver for generating RDoc output.  It handles file parsing and
# generation of output.
#
# To use this class to generate RDoc output via the API, the recommended way
# is:
#
#   rdoc = RDoc::RDoc.new
#   options = RDoc::Options.load_options # returns an RDoc::Options instance
#   # set extra options
#   rdoc.document options
#
# You can also generate output like the +rdoc+ executable:
#
#   rdoc = RDoc::RDoc.new
#   rdoc.document argv
#
# Where +argv+ is an array of strings, each corresponding to an argument you'd
# give rdoc on the command line.  See <tt>rdoc --help</tt> for details.
#
# source://rdoc//lib/rdoc/rdoc.rb#29
class RDoc::RDoc
  # Creates a new RDoc::RDoc instance.  Call #document to parse files and
  # generate documentation.
  #
  # @return [RDoc] a new instance of RDoc
  #
  # source://rdoc//lib/rdoc/rdoc.rb#100
  def initialize; end

  # Generates documentation or a coverage report depending upon the settings
  # in +options+.
  #
  # +options+ can be either an RDoc::Options instance or an array of strings
  # equivalent to the strings that would be passed on the command line like
  # <tt>%w[-q -o doc -t My\ Doc\ Title]</tt>.  #document will automatically
  # call RDoc::Options#finish if an options instance was given.
  #
  # For a list of options, see either RDoc::Options or <tt>rdoc --help</tt>.
  #
  # By default, output will be stored in a directory called "doc" below the
  # current directory, so make sure you're somewhere writable before invoking.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#450
  def document(options); end

  # Report an error message and exit
  #
  # @raise [RDoc::Error]
  #
  # source://rdoc//lib/rdoc/rdoc.rb#113
  def error(msg); end

  # Gathers a set of parseable files from the files and directories listed in
  # +files+.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#121
  def gather_files(files); end

  # Generates documentation for +file_info+ (from #parse_files) into the
  # output dir using the generator selected
  # by the RDoc options
  #
  # source://rdoc//lib/rdoc/rdoc.rb#515
  def generate; end

  # Generator instance used for creating output
  #
  # source://rdoc//lib/rdoc/rdoc.rb#52
  def generator; end

  # Generator instance used for creating output
  #
  # source://rdoc//lib/rdoc/rdoc.rb#52
  def generator=(_arg0); end

  # Turns RDoc from stdin into HTML
  #
  # source://rdoc//lib/rdoc/rdoc.rb#142
  def handle_pipe; end

  # Installs a siginfo handler that prints the current filename.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#157
  def install_siginfo_handler; end

  # Hash of files and their last modified times.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#57
  def last_modified; end

  # Return a list of the files to be processed in a directory. We know that
  # this directory doesn't have a .document file, so we're looking for real
  # files. However we may well contain subdirectories which must be tested
  # for .document files.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#323
  def list_files_in_directory(dir); end

  # Given a list of files and directories, create a list of all the Ruby
  # files they contain.
  #
  # If +force_doc+ is true we always add the given files, if false, only
  # add files that we guarantee we can parse.  It is true when looking at
  # files given on the command line, false when recursing through
  # subdirectories.
  #
  # The effect of this is that if you want a file with a non-standard
  # extension parsed, you must name it explicitly.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#275
  def normalized_file_list(relative_files, force_doc = T.unsafe(nil), exclude_pattern = T.unsafe(nil)); end

  # RDoc options
  #
  # source://rdoc//lib/rdoc/rdoc.rb#62
  def options; end

  # RDoc options
  #
  # source://rdoc//lib/rdoc/rdoc.rb#62
  def options=(_arg0); end

  # Return the path name of the flag file in an output directory.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#240
  def output_flag_file(op_dir); end

  # The .document file contains a list of file and directory name patterns,
  # representing candidates for documentation. It may also contain comments
  # (starting with '#')
  #
  # source://rdoc//lib/rdoc/rdoc.rb#249
  def parse_dot_doc_file(in_dir, filename); end

  # Parses +filename+ and returns an RDoc::TopLevel
  #
  # source://rdoc//lib/rdoc/rdoc.rb#332
  def parse_file(filename); end

  # Parse each file on the command line, recursively entering directories.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#404
  def parse_files(files); end

  # Removes a siginfo handler and replaces the previous
  #
  # source://rdoc//lib/rdoc/rdoc.rb#534
  def remove_siginfo_handler; end

  # Removes file extensions known to be unparseable from +files+ and TAGS
  # files for emacs and vim.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#428
  def remove_unparseable(files); end

  # Create an output dir if it doesn't exist. If it does exist, but doesn't
  # contain the flag file <tt>created.rid</tt> then we refuse to use it, as
  # we may clobber some manually generated documentation
  #
  # source://rdoc//lib/rdoc/rdoc.rb#170
  def setup_output_dir(dir, force); end

  # Accessor for statistics.  Available after each call to parse_files
  #
  # source://rdoc//lib/rdoc/rdoc.rb#67
  def stats; end

  # The current documentation store
  #
  # source://rdoc//lib/rdoc/rdoc.rb#72
  def store; end

  # Sets the current documentation tree to +store+ and sets the store's rdoc
  # driver to this instance.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#215
  def store=(store); end

  # Update the flag file in an output directory.
  #
  # source://rdoc//lib/rdoc/rdoc.rb#223
  def update_output_dir(op_dir, time, last = T.unsafe(nil)); end

  class << self
    # Add +klass+ that can generate output after parsing
    #
    # source://rdoc//lib/rdoc/rdoc.rb#77
    def add_generator(klass); end

    # Active RDoc::RDoc instance
    #
    # source://rdoc//lib/rdoc/rdoc.rb#85
    def current; end

    # Sets the active RDoc::RDoc instance
    #
    # source://rdoc//lib/rdoc/rdoc.rb#92
    def current=(rdoc); end
  end
end

# List of directory names skipped if test suites should be skipped
#
# source://rdoc//lib/rdoc/rdoc.rb#46
RDoc::RDoc::TEST_SUITE_DIRECTORY_NAMES = T.let(T.unsafe(nil), Array)

# List of directory names always skipped
#
# source://rdoc//lib/rdoc/rdoc.rb#41
RDoc::RDoc::UNCONDITIONALLY_SKIPPED_DIRECTORIES = T.let(T.unsafe(nil), Array)

# The RI driver implements the command-line ri tool.
#
# The driver supports:
# * loading RI data from:
#   * Ruby's standard library
#   * RubyGems
#   * ~/.rdoc
#   * A user-supplied directory
# * Paging output (uses RI_PAGER environment variable, PAGER environment
#   variable or the less, more and pager programs)
# * Interactive mode with tab-completion
# * Abbreviated names (ri Zl shows Zlib documentation)
# * Colorized output
# * Merging output from multiple RI data sources
#
# source://rdoc//lib/rdoc/ri/driver.rb#25
class RDoc::RI::Driver
  # Creates a new driver using +initial_options+ from ::process_args
  #
  # @return [Driver] a new instance of Driver
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#391
  def initialize(initial_options = T.unsafe(nil)); end

  # Adds paths for undocumented classes +also_in+ to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#429
  def add_also_in(out, also_in); end

  # Adds a class header to +out+ for class +name+ which is described in
  # +classes+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#446
  def add_class(out, name, classes); end

  # Adds +extends+ to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#473
  def add_extends(out, extends); end

  # Adds a list of +extensions+ to this module of the given +type+ to +out+.
  # add_includes and add_extends call this, so you should use those directly.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#481
  def add_extension_modules(out, type, extensions); end

  # Renders multiple included +modules+ from +store+ to +out+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#499
  def add_extension_modules_multiple(out, store, modules); end

  # Adds a single extension module +include+ from +store+ to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#526
  def add_extension_modules_single(out, store, include); end

  # Adds "(from ...)" to +out+ for +store+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#466
  def add_from(out, store); end

  # Adds +includes+ to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#540
  def add_includes(out, includes); end

  # Looks up the method +name+ and adds it to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#547
  def add_method(out, name); end

  # Adds documentation for all methods in +klass+ to +out+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#558
  def add_method_documentation(out, klass); end

  # Adds a list of +methods+ to +out+ with a heading of +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#571
  def add_method_list(out, methods, name); end

  # Returns ancestor classes of +klass+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#591
  def ancestors_of(klass); end

  # source://rdoc//lib/rdoc/ri/driver.rb#926
  def check_did_you_mean; end

  # For RubyGems backwards compatibility
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#622
  def class_cache; end

  # Builds a RDoc::Markup::Document from +found+, +klasess+ and +includes+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#628
  def class_document(name, found, klasses, includes, extends); end

  # Adds the class +comment+ to +out+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#650
  def class_document_comment(out, comment); end

  # Adds the constants from +klass+ to the Document +out+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#670
  def class_document_constants(out, klass); end

  # Hash mapping a known class or module to the stores it can be loaded from
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#694
  def classes; end

  # Returns the stores wherein +name+ is found along with the classes,
  # extends and includes that match it
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#714
  def classes_and_includes_and_extends_for(name); end

  # Completes +name+ based on the caches.  For Readline
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#739
  def complete(name); end

  # source://rdoc//lib/rdoc/ri/driver.rb#750
  def complete_klass(name, klass, selector, method, completions); end

  # source://rdoc//lib/rdoc/ri/driver.rb#769
  def complete_method(name, klass, selector, completions); end

  # Converts +document+ to text and writes it to the pager
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#789
  def display(document); end

  # Outputs formatted RI data for class +name+.  Groups undocumented classes
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#802
  def display_class(name); end

  # Outputs formatted RI data for method +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#818
  def display_method(name); end

  # Outputs formatted RI data for the class or method +name+.
  #
  # Returns true if +name+ was found, false if it was not an alternative could
  # be guessed, raises an error if +name+ couldn't be guessed.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#832
  def display_name(name); end

  # Displays each name in +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#861
  def display_names(names); end

  # Outputs formatted RI data for page +name+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#872
  def display_page(name); end

  # Outputs a formatted RI page list for the pages in +store+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#903
  def display_page_list(store, pages = T.unsafe(nil), search = T.unsafe(nil)); end

  # Expands abbreviated klass +klass+ into a fully-qualified class.  "Zl::Da"
  # will be expanded to Zlib::DataError.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#947
  def expand_class(klass); end

  # Expands the class portion of +name+ into a fully-qualified class.  See
  # #expand_class.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#965
  def expand_name(name); end

  # Filters the methods in +found+ trying to find a match for +name+.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#981
  def filter_methods(found, name); end

  # Yields items matching +name+ including the store they were found in, the
  # class being searched for, the class they were found in (an ancestor) the
  # types of methods to look up (from #method_type), and the method name being
  # searched for
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#999
  def find_methods(name); end

  # Finds a store that matches +name+ which can be the name of a gem, "ruby",
  # "home" or "site".
  #
  # See also RDoc::Store#source
  #
  # @raise [RDoc::RI::Driver::NotFoundError]
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1045
  def find_store(name); end

  # Creates a new RDoc::Markup::Formatter.  If a formatter is given with -f,
  # use it.  If we're outputting to a pager, use bs, otherwise ansi.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1062
  def formatter(io); end

  # Runs ri interactively using Readline if it is available.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1075
  def interactive; end

  # Lists classes known to ri starting with +names+.  If +names+ is empty all
  # known classes are shown.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1114
  def list_known_classes(names = T.unsafe(nil)); end

  # Returns an Array of methods matching +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1146
  def list_methods_matching(name); end

  # Loads RI data for method +name+ on +klass+ from +store+.  +type+ and
  # +cache+ indicate if it is a class or instance method.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1185
  def load_method(store, cache, klass, type, name); end

  # Returns an Array of RI data for methods matching +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1208
  def load_methods_matching(name); end

  # Returns a filtered list of methods matching +name+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1229
  def lookup_method(name); end

  # Builds a RDoc::Markup::Document from +found+, +klasses+ and +includes+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1254
  def method_document(name, filtered); end

  # Returns the type of method (:both, :instance, :class) for +selector+
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1272
  def method_type(selector); end

  # Returns a regular expression for +name+ that will match an
  # RDoc::AnyMethod's name.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1284
  def name_regexp(name); end

  # Paginates output through a pager program.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1298
  def page; end

  # Are we using a pager?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1316
  def paging?; end

  # Extracts the class, selector and method name parts from +name+ like
  # Foo::Bar#baz.
  #
  # NOTE: Given Foo::Bar, Bar is considered a class even though it may be a
  # method
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1327
  def parse_name(name); end

  # Renders the +klass+ from +store+ to +out+.  If the klass has no
  # documentable items the class is added to +also_in+ instead.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1359
  def render_class(out, store, klass, also_in); end

  # source://rdoc//lib/rdoc/ri/driver.rb#1389
  def render_method(out, store, method, name); end

  # source://rdoc//lib/rdoc/ri/driver.rb#1409
  def render_method_arguments(out, arglists); end

  # source://rdoc//lib/rdoc/ri/driver.rb#1418
  def render_method_comment(out, method, alias_for = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/ri/driver.rb#1436
  def render_method_superclass(out, method); end

  # Looks up and displays ri data according to the options given.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1448
  def run; end

  # Sets up a pager program to pass output through.  Tries the RI_PAGER and
  # PAGER environment variables followed by pager, less then more.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1468
  def setup_pager; end

  # Show all method documentation following a class or module
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#62
  def show_all; end

  # Show all method documentation following a class or module
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#62
  def show_all=(_arg0); end

  # Starts a WEBrick server for ri.
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#1494
  def start_server; end

  # An RDoc::RI::Store for each entry in the RI path
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#67
  def stores; end

  # An RDoc::RI::Store for each entry in the RI path
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#67
  def stores=(_arg0); end

  # Controls the user of the pager vs $stdout
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#72
  def use_stdout; end

  # Controls the user of the pager vs $stdout
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#72
  def use_stdout=(_arg0); end

  class << self
    # Default options for ri
    #
    # source://rdoc//lib/rdoc/ri/driver.rb#77
    def default_options; end

    # Dump +data_path+ using pp
    #
    # source://rdoc//lib/rdoc/ri/driver.rb#98
    def dump(data_path); end

    # Parses +argv+ and returns a Hash of options
    #
    # source://rdoc//lib/rdoc/ri/driver.rb#109
    def process_args(argv); end

    # Runs the ri command line executable using +argv+
    #
    # source://rdoc//lib/rdoc/ri/driver.rb#376
    def run(argv = T.unsafe(nil)); end
  end
end

# Raised when a name isn't found in the ri data stores
#
# source://rdoc//lib/rdoc/ri/driver.rb#35
class RDoc::RI::Driver::NotFoundError < ::RDoc::RI::Driver::Error
  # @return [NotFoundError] a new instance of NotFoundError
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#37
  def initialize(klass, suggestion_proc = T.unsafe(nil)); end

  # source://rdoc//lib/rdoc/ri/driver.rb#49
  def message; end

  # Name that wasn't found
  #
  # source://rdoc//lib/rdoc/ri/driver.rb#45
  def name; end
end

# For RubyGems backwards compatibility
#
# source://rdoc//lib/rdoc/ri/formatter.rb#5
module RDoc::RI::Formatter; end

# source://rdoc//lib/rdoc/ri/store.rb#4
RDoc::RI::Store = RDoc::Store

# A file loaded by \#require
#
# source://rdoc//lib/rdoc/require.rb#5
class RDoc::Require < ::RDoc::CodeObject
  # Creates a new Require that loads +name+ with +comment+
  #
  # @return [Require] a new instance of Require
  #
  # source://rdoc//lib/rdoc/require.rb#15
  def initialize(name, comment); end

  # source://rdoc//lib/rdoc/require.rb#22
  def inspect; end

  # Name of the required file
  #
  # source://rdoc//lib/rdoc/require.rb#10
  def name; end

  # Name of the required file
  #
  # source://rdoc//lib/rdoc/require.rb#10
  def name=(_arg0); end

  # source://rdoc//lib/rdoc/require.rb#31
  def to_s; end

  # The RDoc::TopLevel corresponding to this require, or +nil+ if not found.
  #
  # source://rdoc//lib/rdoc/require.rb#38
  def top_level; end
end

# This is a WEBrick servlet that allows you to browse ri documentation.
#
# You can show documentation through either `ri --server` or, with RubyGems
# 2.0 or newer, `gem server`.  For ri, the server runs on port 8214 by
# default.  For RubyGems the server runs on port 8808 by default.
#
# You can use this servlet in your own project by mounting it on a WEBrick
# server:
#
#   require 'webrick'
#
#   server = WEBrick::HTTPServer.new Port: 8000
#
#   server.mount '/', RDoc::Servlet
#
# If you want to mount the servlet some other place than the root, provide the
# base path when mounting:
#
#   server.mount '/rdoc', RDoc::Servlet, '/rdoc'
#
# source://rdoc//lib/rdoc/servlet.rb#34
class RDoc::Servlet < ::WEBrick::HTTPServlet::AbstractServlet
  # Creates a new WEBrick servlet.
  #
  # Use +mount_path+ when mounting the servlet somewhere other than /.
  #
  # Use +extra_doc_dirs+ for additional documentation directories.
  #
  # +server+ is provided automatically by WEBrick when mounting.  +stores+ and
  # +cache+ are provided automatically by the servlet.
  #
  # @return [Servlet] a new instance of Servlet
  #
  # source://rdoc//lib/rdoc/servlet.rb#69
  def initialize(server, stores, cache, mount_path = T.unsafe(nil), extra_doc_dirs = T.unsafe(nil)); end

  # Serves the asset at the path in +req+ for +generator_name+ via +res+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#100
  def asset(generator_name, req, res); end

  # Maps an asset type to its path on the filesystem
  #
  # source://rdoc//lib/rdoc/servlet.rb#42
  def asset_dirs; end

  # GET request entry point.  Fills in +res+ for the path, etc. in +req+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#119
  def do_GET(req, res); end

  # Fills in +res+ with the class, module or page for +req+ from +store+.
  #
  # +path+ is relative to the mount_path and is used to determine the class,
  # module or page name (/RDoc/Servlet.html becomes RDoc::Servlet).
  # +generator+ is used to create the page.
  #
  # source://rdoc//lib/rdoc/servlet.rb#152
  def documentation_page(store, generator, path, req, res); end

  # Creates the JSON search index on +res+ for the given +store+.  +generator+
  # must respond to \#json_index to build.  +req+ is ignored.
  #
  # source://rdoc//lib/rdoc/servlet.rb#171
  def documentation_search(store, generator, req, res); end

  # Returns the RDoc::Store and path relative to +mount_path+ for
  # documentation at +path+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#185
  def documentation_source(path); end

  # Generates an error page for the +exception+ while handling +req+ on +res+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#203
  def error(exception, req, res); end

  # Instantiates a Darkfish generator for +store+
  #
  # source://rdoc//lib/rdoc/servlet.rb#246
  def generator_for(store); end

  # Handles the If-Modified-Since HTTP header on +req+ for +path+.  If the
  # file has not been modified a Not Modified response is returned.  If the
  # file has been modified a Last-Modified header is added to +res+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#267
  def if_modified_since(req, res, path = T.unsafe(nil)); end

  # Returns an Array of installed documentation.
  #
  # Each entry contains the documentation name (gem name, 'Ruby
  # Documentation', etc.), the path relative to the mount point, whether the
  # documentation exists, the type of documentation (See RDoc::RI::Paths#each)
  # and the filesystem to the RDoc::Store for the documentation.
  #
  # source://rdoc//lib/rdoc/servlet.rb#290
  def installed_docs; end

  # Returns a 404 page built by +generator+ for +req+ on +res+.
  #
  # source://rdoc//lib/rdoc/servlet.rb#318
  def not_found(generator, req, res, message = T.unsafe(nil)); end

  # An RDoc::Options instance used for rendering options
  #
  # source://rdoc//lib/rdoc/servlet.rb#47
  def options; end

  # Enumerates the ri paths.  See RDoc::RI::Paths#each
  #
  # source://rdoc//lib/rdoc/servlet.rb#327
  def ri_paths(&block); end

  # Generates the root page on +res+.  +req+ is ignored.
  #
  # source://rdoc//lib/rdoc/servlet.rb#334
  def root(req, res); end

  # Generates a search index for the root page on +res+.  +req+ is ignored.
  #
  # source://rdoc//lib/rdoc/servlet.rb#345
  def root_search(req, res); end

  # Displays documentation for +req+ on +res+, whether that be HTML or some
  # asset.
  #
  # source://rdoc//lib/rdoc/servlet.rb#395
  def show_documentation(req, res); end

  # Returns an RDoc::Store for the given +source_name+ ('ruby' or a gem name).
  #
  # source://rdoc//lib/rdoc/servlet.rb#419
  def store_for(source_name); end

  class << self
    # Creates an instance of this servlet that shares cached data between
    # requests.
    #
    # source://rdoc//lib/rdoc/servlet.rb#53
    def get_instance(server, *options); end
  end
end

# A singleton class
#
# source://rdoc//lib/rdoc/single_class.rb#5
class RDoc::SingleClass < ::RDoc::ClassModule
  # Adds the superclass to the included modules.
  #
  # source://rdoc//lib/rdoc/single_class.rb#10
  def ancestors; end

  # source://rdoc//lib/rdoc/single_class.rb#14
  def aref_prefix; end

  # The definition of this singleton class, <tt>class << MyClassName</tt>
  #
  # source://rdoc//lib/rdoc/single_class.rb#21
  def definition; end

  # source://rdoc//lib/rdoc/single_class.rb#25
  def pretty_print(q); end
end

# RDoc statistics collector which prints a summary and report of a project's
# documentation totals.
#
# source://rdoc//lib/rdoc/stats.rb#6
class RDoc::Stats
  include ::RDoc::Text

  # Creates a new Stats that will have +num_files+.  +verbosity+ defaults to 1
  # which will create an RDoc::Stats::Normal outputter.
  #
  # @return [Stats] a new instance of Stats
  #
  # source://rdoc//lib/rdoc/stats.rb#29
  def initialize(store, num_files, verbosity = T.unsafe(nil)); end

  # Records the parsing of an alias +as+.
  #
  # source://rdoc//lib/rdoc/stats.rb#52
  def add_alias(as); end

  # Records the parsing of an attribute +attribute+
  #
  # source://rdoc//lib/rdoc/stats.rb#59
  def add_attribute(attribute); end

  # Records the parsing of a class +klass+
  #
  # source://rdoc//lib/rdoc/stats.rb#66
  def add_class(klass); end

  # Records the parsing of +constant+
  #
  # source://rdoc//lib/rdoc/stats.rb#73
  def add_constant(constant); end

  # Records the parsing of +file+
  #
  # source://rdoc//lib/rdoc/stats.rb#80
  def add_file(file); end

  # Records the parsing of +method+
  #
  # source://rdoc//lib/rdoc/stats.rb#88
  def add_method(method); end

  # Records the parsing of a module +mod+
  #
  # source://rdoc//lib/rdoc/stats.rb#95
  def add_module(mod); end

  # Call this to mark the beginning of parsing for display purposes
  #
  # source://rdoc//lib/rdoc/stats.rb#102
  def begin_adding; end

  # Calculates documentation totals and percentages for classes, modules,
  # constants, attributes and methods.
  #
  # source://rdoc//lib/rdoc/stats.rb#110
  def calculate; end

  # Output level for the coverage report
  #
  # source://rdoc//lib/rdoc/stats.rb#13
  def coverage_level; end

  # Sets coverage report level.  Accepted values are:
  #
  # false or nil:: No report
  # 0:: Classes, modules, constants, attributes, methods
  # 1:: Level 0 + method parameters
  #
  # source://rdoc//lib/rdoc/stats.rb#158
  def coverage_level=(level); end

  # Returns the length and number of undocumented items in +collection+.
  #
  # source://rdoc//lib/rdoc/stats.rb#167
  def doc_stats(collection); end

  # Call this to mark the end of parsing for display purposes
  #
  # source://rdoc//lib/rdoc/stats.rb#175
  def done_adding; end

  # Count of files parsed during parsing
  #
  # source://rdoc//lib/rdoc/stats.rb#18
  def files_so_far; end

  # The documentation status of this project.  +true+ when 100%, +false+ when
  # less than 100% and +nil+ when unknown.
  #
  # Set by calling #calculate
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/stats.rb#185
  def fully_documented?; end

  # A report that says you did a great job!
  #
  # source://rdoc//lib/rdoc/stats.rb#192
  def great_job; end

  # Total number of files found
  #
  # source://rdoc//lib/rdoc/stats.rb#23
  def num_files; end

  # Calculates the percentage of items documented.
  #
  # source://rdoc//lib/rdoc/stats.rb#204
  def percent_doc; end

  # Returns a report on which items are not documented
  #
  # source://rdoc//lib/rdoc/stats.rb#218
  def report; end

  # Returns a report on undocumented attributes in ClassModule +cm+
  #
  # source://rdoc//lib/rdoc/stats.rb#259
  def report_attributes(cm); end

  # Returns a report on undocumented items in ClassModule +cm+
  #
  # source://rdoc//lib/rdoc/stats.rb#277
  def report_class_module(cm); end

  # Returns a report on undocumented constants in ClassModule +cm+
  #
  # source://rdoc//lib/rdoc/stats.rb#329
  def report_constants(cm); end

  # Returns a report on undocumented methods in ClassModule +cm+
  #
  # source://rdoc//lib/rdoc/stats.rb#351
  def report_methods(cm); end

  # Returns a summary of the collected statistics.
  #
  # source://rdoc//lib/rdoc/stats.rb#389
  def summary; end

  # Determines which parameters in +method+ were not documented.  Returns a
  # total parameter count and an Array of undocumented methods.
  #
  # source://rdoc//lib/rdoc/stats.rb#439
  def undoc_params(method); end
end

# Stats printer that prints just the files being documented with a progress
# bar
#
# source://rdoc//lib/rdoc/stats/normal.rb#13
class RDoc::Stats::Normal < ::RDoc::Stats::Quiet
  # source://rdoc//lib/rdoc/stats/normal.rb#15
  def begin_adding; end

  # source://rdoc//lib/rdoc/stats/normal.rb#54
  def done_adding; end

  # Prints a file with a progress bar
  #
  # source://rdoc//lib/rdoc/stats/normal.rb#23
  def print_file(files_so_far, filename); end
end

# Stats printer that prints nothing
#
# source://rdoc//lib/rdoc/stats/quiet.rb#5
class RDoc::Stats::Quiet
  # Creates a new Quiet that will print nothing
  #
  # @return [Quiet] a new instance of Quiet
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#10
  def initialize(num_files); end

  # Prints a message at the beginning of parsing
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#17
  def begin_adding(*_arg0); end

  # Prints when RDoc is done
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#57
  def done_adding(*_arg0); end

  # Prints when an alias is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#22
  def print_alias(*_arg0); end

  # Prints when an attribute is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#27
  def print_attribute(*_arg0); end

  # Prints when a class is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#32
  def print_class(*_arg0); end

  # Prints when a constant is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#37
  def print_constant(*_arg0); end

  # Prints when a file is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#42
  def print_file(*_arg0); end

  # Prints when a method is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#47
  def print_method(*_arg0); end

  # Prints when a module is added
  #
  # source://rdoc//lib/rdoc/stats/quiet.rb#52
  def print_module(*_arg0); end
end

# Stats printer that prints everything documented, including the documented
# status
#
# source://rdoc//lib/rdoc/stats/verbose.rb#6
class RDoc::Stats::Verbose < ::RDoc::Stats::Normal
  # Returns a marker for RDoc::CodeObject +co+ being undocumented
  #
  # source://rdoc//lib/rdoc/stats/verbose.rb#11
  def nodoc(co); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#15
  def print_alias(as); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#19
  def print_attribute(attribute); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#23
  def print_class(klass); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#27
  def print_constant(constant); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#31
  def print_file(files_so_far, file); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#36
  def print_method(method); end

  # source://rdoc//lib/rdoc/stats/verbose.rb#40
  def print_module(mod); end
end

# A set of rdoc data for a single project (gem, path, etc.).
#
# The store manages reading and writing ri data for a project and maintains a
# cache of methods, classes and ancestors in the store.
#
# The store maintains a #cache of its contents for faster lookup.  After
# adding items to the store it must be flushed using #save_cache.  The cache
# contains the following structures:
#
#    @cache = {
#      :ancestors        => {}, # class name => ancestor names
#      :attributes       => {}, # class name => attributes
#      :class_methods    => {}, # class name => class methods
#      :instance_methods => {}, # class name => instance methods
#      :modules          => [], # classes and modules in this store
#      :pages            => [], # page names
#    }
# --
# TODO need to prune classes
#
# source://rdoc//lib/rdoc/store.rb#25
class RDoc::Store
  # Creates a new Store of +type+ that will load or save to +path+
  #
  # @return [Store] a new instance of Store
  #
  # source://rdoc//lib/rdoc/store.rb#127
  def initialize(path = T.unsafe(nil), type = T.unsafe(nil)); end

  # Adds +module+ as an enclosure (namespace) for the given +variable+ for C
  # files.
  #
  # source://rdoc//lib/rdoc/store.rb#169
  def add_c_enclosure(variable, namespace); end

  # Adds C variables from an RDoc::Parser::C
  #
  # source://rdoc//lib/rdoc/store.rb#176
  def add_c_variables(c_parser); end

  # Adds the file with +name+ as an RDoc::TopLevel to the store.  Returns the
  # created RDoc::TopLevel.
  #
  # source://rdoc//lib/rdoc/store.rb#188
  def add_file(absolute_name, relative_name: T.unsafe(nil), parser: T.unsafe(nil)); end

  # Returns all classes discovered by RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#212
  def all_classes; end

  # Returns all classes and modules discovered by RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#219
  def all_classes_and_modules; end

  # All TopLevels known to RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#226
  def all_files; end

  # Returns all modules discovered by RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#233
  def all_modules; end

  # Ancestors cache accessor.  Maps a klass name to an Array of its ancestors
  # in this store.  If Foo in this store inherits from Object, Kernel won't be
  # listed (it will be included from ruby's ri store).
  #
  # source://rdoc//lib/rdoc/store.rb#242
  def ancestors; end

  # Attributes cache accessor.  Maps a class to an Array of its attributes.
  #
  # source://rdoc//lib/rdoc/store.rb#249
  def attributes; end

  # Maps C variables to class or module names for each parsed C file.
  #
  # source://rdoc//lib/rdoc/store.rb#80
  def c_class_variables; end

  # Stores the name of the C variable a class belongs to.  This helps wire up
  # classes defined from C across files.
  #
  # source://rdoc//lib/rdoc/store.rb#73
  def c_enclosure_classes; end

  # source://rdoc//lib/rdoc/store.rb#75
  def c_enclosure_names; end

  # Maps C variables to singleton class names for each parsed C file.
  #
  # source://rdoc//lib/rdoc/store.rb#85
  def c_singleton_class_variables; end

  # The contents of the Store
  #
  # source://rdoc//lib/rdoc/store.rb#112
  def cache; end

  # Path to the cache file
  #
  # source://rdoc//lib/rdoc/store.rb#256
  def cache_path; end

  # Path to the ri data for +klass_name+
  #
  # source://rdoc//lib/rdoc/store.rb#263
  def class_file(klass_name); end

  # Class methods cache accessor.  Maps a class to an Array of its class
  # methods (not full name).
  #
  # source://rdoc//lib/rdoc/store.rb#272
  def class_methods; end

  # Path where data for +klass_name+ will be stored (methods or class data)
  #
  # source://rdoc//lib/rdoc/store.rb#279
  def class_path(klass_name); end

  # Hash of all classes known to RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#286
  def classes_hash; end

  # Removes empty items and ensures item in each collection are unique and
  # sorted
  #
  # source://rdoc//lib/rdoc/store.rb#294
  def clean_cache_collection(collection); end

  # Prepares the RDoc code object tree for use by a generator.
  #
  # It finds unique classes/modules defined, and replaces classes/modules that
  # are aliases for another one by a copy with RDoc::ClassModule#is_alias_for
  # set.
  #
  # It updates the RDoc::ClassModule#constant_aliases attribute of "real"
  # classes or modules.
  #
  # It also completely removes the classes and modules that should be removed
  # from the documentation and the methods that have a visibility below
  # +min_visibility+, which is the <tt>--visibility</tt> option.
  #
  # See also RDoc::Context#remove_from_documentation?
  #
  # source://rdoc//lib/rdoc/store.rb#322
  def complete(min_visibility); end

  # If true this Store will not write any files
  #
  # source://rdoc//lib/rdoc/store.rb#90
  def dry_run; end

  # If true this Store will not write any files
  #
  # source://rdoc//lib/rdoc/store.rb#90
  def dry_run=(_arg0); end

  # The encoding of the contents in the Store
  #
  # source://rdoc//lib/rdoc/store.rb#117
  def encoding; end

  # The encoding of the contents in the Store
  #
  # source://rdoc//lib/rdoc/store.rb#117
  def encoding=(_arg0); end

  # Hash of all files known to RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#362
  def files_hash; end

  # Finds the enclosure (namespace) for the given C +variable+.
  #
  # source://rdoc//lib/rdoc/store.rb#369
  def find_c_enclosure(variable); end

  # Finds the class with +name+ in all discovered classes
  #
  # source://rdoc//lib/rdoc/store.rb#394
  def find_class_named(name); end

  # Finds the class with +name+ starting in namespace +from+
  #
  # source://rdoc//lib/rdoc/store.rb#401
  def find_class_named_from(name, from); end

  # Finds the class or module with +name+
  #
  # source://rdoc//lib/rdoc/store.rb#419
  def find_class_or_module(name); end

  # Finds the file with +name+ in all discovered files
  #
  # source://rdoc//lib/rdoc/store.rb#427
  def find_file_named(name); end

  # Finds the module with +name+ in all discovered modules
  #
  # source://rdoc//lib/rdoc/store.rb#434
  def find_module_named(name); end

  # Returns the RDoc::TopLevel that is a text file and has the given
  # +file_name+
  #
  # source://rdoc//lib/rdoc/store.rb#442
  def find_text_page(file_name); end

  # Finds unique classes/modules defined in +all_hash+,
  # and returns them as an array. Performs the alias
  # updates in +all_hash+: see ::complete.
  # --
  # TODO  aliases should be registered by Context#add_module_alias
  #
  # source://rdoc//lib/rdoc/store.rb#455
  def find_unique(all_hash); end

  # Fixes the erroneous <tt>BasicObject < Object</tt> in 1.9.
  #
  # Because we assumed all classes without a stated superclass
  # inherit from Object, we have the above wrong inheritance.
  #
  # We fix BasicObject right away if we are running in a Ruby
  # version >= 1.9.
  #
  # source://rdoc//lib/rdoc/store.rb#474
  def fix_basic_object_inheritance; end

  # Friendly rendition of #path
  #
  # source://rdoc//lib/rdoc/store.rb#483
  def friendly_path; end

  # source://rdoc//lib/rdoc/store.rb#495
  def inspect; end

  # Instance methods cache accessor.  Maps a class to an Array of its
  # instance methods (not full name).
  #
  # source://rdoc//lib/rdoc/store.rb#503
  def instance_methods; end

  # Loads all items from this store into memory.  This recreates a
  # documentation tree for use by a generator
  #
  # source://rdoc//lib/rdoc/store.rb#511
  def load_all; end

  # Loads cache file for this store
  #
  # source://rdoc//lib/rdoc/store.rb#559
  def load_cache; end

  # Loads ri data for +klass_name+ and hooks it up to this store.
  #
  # source://rdoc//lib/rdoc/store.rb#598
  def load_class(klass_name); end

  # Loads ri data for +klass_name+
  #
  # source://rdoc//lib/rdoc/store.rb#616
  def load_class_data(klass_name); end

  # Loads ri data for +method_name+ in +klass_name+
  #
  # source://rdoc//lib/rdoc/store.rb#629
  def load_method(klass_name, method_name); end

  # Loads ri data for +page_name+
  #
  # source://rdoc//lib/rdoc/store.rb#645
  def load_page(page_name); end

  # Gets the main page for this RDoc store.  This page is used as the root of
  # the RDoc server.
  #
  # source://rdoc//lib/rdoc/store.rb#661
  def main; end

  # Sets the main page for this RDoc store.
  #
  # source://rdoc//lib/rdoc/store.rb#668
  def main=(page); end

  # Converts the variable => ClassModule map +variables+ from a C parser into
  # a variable => class name map.
  #
  # source://rdoc//lib/rdoc/store.rb#676
  def make_variable_map(variables); end

  # Path to the ri data for +method_name+ in +klass_name+
  #
  # source://rdoc//lib/rdoc/store.rb#689
  def method_file(klass_name, method_name); end

  # Modules cache accessor.  An Array of all the module (and class) names in
  # the store.
  #
  # source://rdoc//lib/rdoc/store.rb#703
  def module_names; end

  # Hash of all modules known to RDoc
  #
  # source://rdoc//lib/rdoc/store.rb#710
  def modules_hash; end

  # Returns the RDoc::TopLevel that is a text file and has the given +name+
  #
  # source://rdoc//lib/rdoc/store.rb#717
  def page(name); end

  # Path to the ri data for +page_name+
  #
  # source://rdoc//lib/rdoc/store.rb#726
  def page_file(page_name); end

  # Path this store reads or writes
  #
  # source://rdoc//lib/rdoc/store.rb#95
  def path; end

  # Path this store reads or writes
  #
  # source://rdoc//lib/rdoc/store.rb#95
  def path=(_arg0); end

  # The RDoc::RDoc driver for this parse tree.  This allows classes consulting
  # the documentation tree to access user-set options, for example.
  #
  # source://rdoc//lib/rdoc/store.rb#101
  def rdoc; end

  # The RDoc::RDoc driver for this parse tree.  This allows classes consulting
  # the documentation tree to access user-set options, for example.
  #
  # source://rdoc//lib/rdoc/store.rb#101
  def rdoc=(_arg0); end

  # Removes from +all_hash+ the contexts that are nodoc or have no content.
  #
  # See RDoc::Context#remove_from_documentation?
  #
  # source://rdoc//lib/rdoc/store.rb#737
  def remove_nodoc(all_hash); end

  # Saves all entries in the store
  #
  # source://rdoc//lib/rdoc/store.rb#747
  def save; end

  # Writes the cache file for this store
  #
  # source://rdoc//lib/rdoc/store.rb#772
  def save_cache; end

  # Writes the ri data for +klass+ (or module)
  #
  # source://rdoc//lib/rdoc/store.rb#799
  def save_class(klass); end

  # Writes the ri data for +method+ on +klass+
  #
  # source://rdoc//lib/rdoc/store.rb#873
  def save_method(klass, method); end

  # Writes the ri data for +page+
  #
  # source://rdoc//lib/rdoc/store.rb#896
  def save_page(page); end

  # Source of the contents of this store.
  #
  # For a store from a gem the source is the gem name.  For a store from the
  # home directory the source is "home".  For system ri store (the standard
  # library documentation) the source is"ruby".  For a store from the site
  # ri directory the store is "site".  For other stores the source is the
  # #path.
  #
  # source://rdoc//lib/rdoc/store.rb#922
  def source; end

  # Gets the title for this RDoc store.  This is used as the title in each
  # page on the RDoc server
  #
  # source://rdoc//lib/rdoc/store.rb#936
  def title; end

  # Sets the title page for this RDoc store.
  #
  # source://rdoc//lib/rdoc/store.rb#943
  def title=(title); end

  # Type of ri datastore this was loaded from.  See RDoc::RI::Driver,
  # RDoc::RI::Paths.
  #
  # source://rdoc//lib/rdoc/store.rb#107
  def type; end

  # Type of ri datastore this was loaded from.  See RDoc::RI::Driver,
  # RDoc::RI::Paths.
  #
  # source://rdoc//lib/rdoc/store.rb#107
  def type=(_arg0); end

  # Returns the unique classes discovered by RDoc.
  #
  # ::complete must have been called prior to using this method.
  #
  # source://rdoc//lib/rdoc/store.rb#952
  def unique_classes; end

  # Returns the unique classes and modules discovered by RDoc.
  # ::complete must have been called prior to using this method.
  #
  # source://rdoc//lib/rdoc/store.rb#960
  def unique_classes_and_modules; end

  # Returns the unique modules discovered by RDoc.
  # ::complete must have been called prior to using this method.
  #
  # source://rdoc//lib/rdoc/store.rb#968
  def unique_modules; end

  # The lazy constants alias will be discovered in passing
  #
  # source://rdoc//lib/rdoc/store.rb#122
  def unmatched_constant_alias; end

  # Sets the parser of +absolute_name+, unless it from a source code file.
  #
  # source://rdoc//lib/rdoc/store.rb#203
  def update_parser_of_file(absolute_name, parser); end

  private

  # source://rdoc//lib/rdoc/store.rb#973
  def marshal_load(file); end
end

# source://rdoc//lib/rdoc/store.rb#977
RDoc::Store::MarshalFilter = T.let(T.unsafe(nil), Proc)

# Raised when a stored file for a class, module, page or method is missing.
#
# source://rdoc//lib/rdoc/store.rb#36
class RDoc::Store::MissingFileError < ::RDoc::Store::Error
  # Creates a new MissingFileError for the missing +file+ for the given
  # +name+ that should have been in the +store+.
  #
  # @return [MissingFileError] a new instance of MissingFileError
  #
  # source://rdoc//lib/rdoc/store.rb#57
  def initialize(store, file, name); end

  # The file the #name should be saved as
  #
  # source://rdoc//lib/rdoc/store.rb#46
  def file; end

  # source://rdoc//lib/rdoc/store.rb#63
  def message; end

  # The name of the object the #file would be loaded from
  #
  # source://rdoc//lib/rdoc/store.rb#51
  def name; end

  # The store the file should exist in
  #
  # source://rdoc//lib/rdoc/store.rb#41
  def store; end
end

# RDoc::Task creates the following rake tasks to generate and clean up RDoc
# output:
#
# [rdoc]
#   Main task for this RDoc task.
#
# [clobber_rdoc]
#   Delete all the rdoc files.  This target is automatically added to the main
#   clobber target.
#
# [rerdoc]
#   Rebuild the rdoc files from scratch, even if they are not out of date.
#
# [rdoc:coverage]
#   Print RDoc coverage report for all rdoc files.
#
# Simple Example:
#
#   require 'rdoc/task'
#
#   RDoc::Task.new do |rdoc|
#     rdoc.main = "README.rdoc"
#     rdoc.rdoc_files.include("README.rdoc", "lib/**/*.rb")
#   end
#
# The +rdoc+ object passed to the block is an RDoc::Task object. See the
# attributes list for the RDoc::Task class for available customization options.
#
# == Specifying different task names
#
# You may wish to give the task a different name, such as if you are
# generating two sets of documentation.  For instance, if you want to have a
# development set of documentation including private methods:
#
#   require 'rdoc/task'
#
#   RDoc::Task.new :rdoc_dev do |rdoc|
#     rdoc.main = "README.rdoc"
#     rdoc.rdoc_files.include("README.rdoc", "lib/**/*.rb")
#     rdoc.options << "--all"
#   end
#
# The tasks would then be named :<em>rdoc_dev</em>,
# :clobber_<em>rdoc_dev</em>, and :re<em>rdoc_dev</em>.
#
# If you wish to have completely different task names, then pass a Hash as
# first argument. With the <tt>:rdoc</tt>, <tt>:clobber_rdoc</tt> and
# <tt>:rerdoc</tt> options, you can customize the task names to your liking.
#
# For example:
#
#   require 'rdoc/task'
#
#   RDoc::Task.new(:rdoc => "rdoc", :clobber_rdoc => "rdoc:clean",
#                  :rerdoc => "rdoc:force")
#
# This will create the tasks <tt>:rdoc</tt>, <tt>:rdoc:clean</tt>,
# <tt>:rdoc:force</tt>, and <tt>:rdoc:coverage</tt>.
#
# source://rdoc//lib/rdoc/task.rb#99
class RDoc::Task < ::Rake::TaskLib
  # Create an RDoc task with the given name. See the RDoc::Task class overview
  # for documentation.
  #
  # @return [Task] a new instance of Task
  # @yield [_self]
  # @yieldparam _self [RDoc::Task] the object that the method was called on
  #
  # source://rdoc//lib/rdoc/task.rb#158
  def initialize(name = T.unsafe(nil)); end

  # The block passed to this method will be called just before running the
  # RDoc generator. It is allowed to modify RDoc::Task attributes inside the
  # block.
  #
  # source://rdoc//lib/rdoc/task.rb#288
  def before_running_rdoc(&block); end

  # Ensures that +names+ only includes names for the :rdoc, :clobber_rdoc and
  # :rerdoc.  If other names are given an ArgumentError is raised.
  #
  # source://rdoc//lib/rdoc/task.rb#174
  def check_names(names); end

  # Task description for the clobber rdoc task or its renamed equivalent
  #
  # source://rdoc//lib/rdoc/task.rb#188
  def clobber_task_description; end

  # Task description for the coverage task or its renamed description
  #
  # source://rdoc//lib/rdoc/task.rb#309
  def coverage_task_description; end

  # Sets default task values
  #
  # source://rdoc//lib/rdoc/task.rb#195
  def defaults; end

  # Create the tasks defined by this task lib.
  #
  # source://rdoc//lib/rdoc/task.rb#224
  def define; end

  # Whether to run the rdoc process as an external shell (default is false)
  #
  # source://rdoc//lib/rdoc/task.rb#152
  def external; end

  # Whether to run the rdoc process as an external shell (default is false)
  #
  # source://rdoc//lib/rdoc/task.rb#152
  def external=(_arg0); end

  # Name of format generator (<tt>--format</tt>) used by rdoc. (defaults to
  # rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#137
  def generator; end

  # Name of format generator (<tt>--format</tt>) used by rdoc. (defaults to
  # rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#137
  def generator=(_arg0); end

  # All source is inline now.  This method is deprecated
  #
  # source://rdoc//lib/rdoc/task.rb#209
  def inline_source; end

  # All source is inline now.  This method is deprecated
  #
  # source://rdoc//lib/rdoc/task.rb#217
  def inline_source=(value); end

  # Name of file to be used as the main, top level file of the RDoc. (default
  # is none)
  #
  # source://rdoc//lib/rdoc/task.rb#126
  def main; end

  # Name of file to be used as the main, top level file of the RDoc. (default
  # is none)
  #
  # source://rdoc//lib/rdoc/task.rb#126
  def main=(_arg0); end

  # Comment markup format.  rdoc, rd and tomdoc are supported.  (default is
  # 'rdoc')
  #
  # source://rdoc//lib/rdoc/task.rb#110
  def markup; end

  # Comment markup format.  rdoc, rd and tomdoc are supported.  (default is
  # 'rdoc')
  #
  # source://rdoc//lib/rdoc/task.rb#110
  def markup=(_arg0); end

  # Name of the main, top level task.  (default is :rdoc)
  #
  # source://rdoc//lib/rdoc/task.rb#104
  def name; end

  # Name of the main, top level task.  (default is :rdoc)
  #
  # source://rdoc//lib/rdoc/task.rb#104
  def name=(_arg0); end

  # List of options that will be supplied to RDoc
  #
  # source://rdoc//lib/rdoc/task.rb#272
  def option_list; end

  # Additional list of options to be passed rdoc.  (default is [])
  #
  # source://rdoc//lib/rdoc/task.rb#147
  def options; end

  # Additional list of options to be passed rdoc.  (default is [])
  #
  # source://rdoc//lib/rdoc/task.rb#147
  def options=(_arg0); end

  # Name of directory to receive the html output files. (default is "html")
  #
  # source://rdoc//lib/rdoc/task.rb#115
  def rdoc_dir; end

  # Name of directory to receive the html output files. (default is "html")
  #
  # source://rdoc//lib/rdoc/task.rb#115
  def rdoc_dir=(_arg0); end

  # List of files to be included in the rdoc generation. (default is [])
  #
  # source://rdoc//lib/rdoc/task.rb#142
  def rdoc_files; end

  # List of files to be included in the rdoc generation. (default is [])
  #
  # source://rdoc//lib/rdoc/task.rb#142
  def rdoc_files=(_arg0); end

  # Task description for the rdoc task or its renamed equivalent
  #
  # source://rdoc//lib/rdoc/task.rb#295
  def rdoc_task_description; end

  # Task description for the rerdoc task or its renamed description
  #
  # source://rdoc//lib/rdoc/task.rb#302
  def rerdoc_task_description; end

  # Name of template to be used by rdoc. (defaults to rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#131
  def template; end

  # Name of template to be used by rdoc. (defaults to rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#131
  def template=(_arg0); end

  # Title of RDoc documentation. (defaults to rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#120
  def title; end

  # Title of RDoc documentation. (defaults to rdoc's default)
  #
  # source://rdoc//lib/rdoc/task.rb#120
  def title=(_arg0); end

  private

  # source://rdoc//lib/rdoc/task.rb#326
  def clobber_task_name; end

  # source://rdoc//lib/rdoc/task.rb#340
  def coverage_task_name; end

  # source://rdoc//lib/rdoc/task.rb#315
  def rdoc_target; end

  # source://rdoc//lib/rdoc/task.rb#319
  def rdoc_task_name; end

  # source://rdoc//lib/rdoc/task.rb#333
  def rerdoc_task_name; end
end

# Methods for manipulating comment text
#
# source://rdoc//lib/rdoc/text.rb#11
module RDoc::Text
  # Expands tab characters in +text+ to eight spaces
  #
  # source://rdoc//lib/rdoc/text.rb#63
  def expand_tabs(text); end

  # Flush +text+ left based on the shortest line
  #
  # source://rdoc//lib/rdoc/text.rb#82
  def flush_left(text); end

  # The language for this text.  This affects stripping comments
  # markers.
  #
  # source://rdoc//lib/rdoc/text.rb#17
  def language; end

  # The language for this text.  This affects stripping comments
  # markers.
  #
  # source://rdoc//lib/rdoc/text.rb#17
  def language=(_arg0); end

  # Convert a string in markup format into HTML.
  #
  # Requires the including class to implement #formatter
  #
  # source://rdoc//lib/rdoc/text.rb#101
  def markup(text); end

  # Strips hashes, expands tabs then flushes +text+ to the left
  #
  # source://rdoc//lib/rdoc/text.rb#117
  def normalize_comment(text); end

  # Normalizes +text+ then builds a RDoc::Markup::Document from it
  #
  # source://rdoc//lib/rdoc/text.rb#135
  def parse(text, format = T.unsafe(nil)); end

  # The first +limit+ characters of +text+ as HTML
  #
  # source://rdoc//lib/rdoc/text.rb#149
  def snippet(text, limit = T.unsafe(nil)); end

  # Strips leading # characters from +text+
  #
  # source://rdoc//lib/rdoc/text.rb#158
  def strip_hashes(text); end

  # Strips leading and trailing \n characters from +text+
  #
  # source://rdoc//lib/rdoc/text.rb#170
  def strip_newlines(text); end

  # Strips /* */ style comments
  #
  # source://rdoc//lib/rdoc/text.rb#177
  def strip_stars(text); end

  # source://rdoc//lib/rdoc/text.rb#200
  def to_html(text); end

  # Wraps +txt+ to +line_len+
  #
  # source://rdoc//lib/rdoc/text.rb#287
  def wrap(txt, line_len = T.unsafe(nil)); end

  class << self
    # Transcodes +character+ to +encoding+ with a +fallback+ character.
    #
    # source://rdoc//lib/rdoc/text.rb#55
    def encode_fallback(character, encoding, fallback); end
  end
end

# Character class to be separated by a space when concatenating
# lines.
#
# source://rdoc//lib/rdoc/text.rb#320
RDoc::Text::SPACE_SEPARATED_LETTER_CLASS = T.let(T.unsafe(nil), Regexp)

# A TokenStream is a list of tokens, gathered during the parse of some entity
# (say a method). Entities populate these streams by being registered with the
# lexer. Any class can collect tokens by including TokenStream. From the
# outside, you use such an object by calling the start_collecting_tokens
# method, followed by calls to add_token and pop_token.
#
# source://rdoc//lib/rdoc/token_stream.rb#9
module RDoc::TokenStream
  # Adds one +token+ to the collected tokens
  #
  # source://rdoc//lib/rdoc/token_stream.rb#84
  def add_token(token); end

  # Adds +tokens+ to the collected tokens
  #
  # source://rdoc//lib/rdoc/token_stream.rb#77
  def add_tokens(tokens); end

  # Starts collecting tokens
  #
  # source://rdoc//lib/rdoc/token_stream.rb#91
  def collect_tokens; end

  # Remove the last token from the collected tokens
  #
  # source://rdoc//lib/rdoc/token_stream.rb#100
  def pop_token; end

  # Starts collecting tokens
  #
  # source://rdoc//lib/rdoc/token_stream.rb#91
  def start_collecting_tokens; end

  # Current token stream
  #
  # source://rdoc//lib/rdoc/token_stream.rb#107
  def token_stream; end

  # Returns a string representation of the token stream
  #
  # source://rdoc//lib/rdoc/token_stream.rb#114
  def tokens_to_s; end

  class << self
    # Converts +token_stream+ to HTML wrapping various tokens with
    # <tt><span></tt> elements. Some tokens types are wrapped in spans
    # with the given class names. Other token types are not wrapped in spans.
    #
    # source://rdoc//lib/rdoc/token_stream.rb#16
    def to_html(token_stream); end
  end
end

# A parser for TomDoc based on TomDoc 1.0.0-rc1 (02adef9b5a)
#
# The TomDoc specification can be found at:
#
# http://tomdoc.org
#
# The latest version of the TomDoc specification can be found at:
#
# https://github.com/mojombo/tomdoc/blob/master/tomdoc.md
#
# To choose TomDoc as your only default format see RDoc::Options@Saved+Options
# for instructions on setting up a <code>.rdoc_options</code> file to store
# your project default.
#
# There are a few differences between this parser and the specification.  A
# best-effort was made to follow the specification as closely as possible but
# some choices to deviate were made.
#
# A future version of RDoc will warn when a MUST or MUST NOT is violated and
# may warn when a SHOULD or SHOULD NOT is violated.  RDoc will always try
# to emit documentation even if given invalid TomDoc.
#
# Here are some implementation choices this parser currently makes:
#
# This parser allows rdoc-style inline markup but you should not depended on
# it.
#
# This parser allows a space between the comment and the method body.
#
# This parser does not require the default value to be described for an
# optional argument.
#
# This parser does not examine the order of sections.  An Examples section may
# precede the Arguments section.
#
# This class is documented in TomDoc format.  Since this is a subclass of the
# RDoc markup parser there isn't much to see here, unfortunately.
#
# source://rdoc//lib/rdoc/tom_doc.rb#42
class RDoc::TomDoc < ::RDoc::Markup::Parser
  # Public: Creates a new TomDoc parser.  See also RDoc::Markup::parse
  #
  # @return [TomDoc] a new instance of TomDoc
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#130
  def initialize; end

  # Internal: Builds a heading from the token stream
  #
  # level - The level of heading to create
  #
  # Returns an RDoc::Markup::Heading
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#143
  def build_heading(level); end

  # Internal: Builds a paragraph from the token stream
  #
  # margin - Unused
  #
  # Returns an RDoc::Markup::Paragraph.
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#173
  def build_paragraph(margin); end

  # Internal: Builds a verbatim from the token stream.  A verbatim in the
  # Examples section will be marked as in Ruby format.
  #
  # margin - The indentation from the margin for lines that belong to this
  #          verbatim section.
  #
  # Returns an RDoc::Markup::Verbatim
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#159
  def build_verbatim(margin); end

  # Detects a section change to "Returns" and adds a heading
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#213
  def parse_text(parent, indent); end

  # Internal: Turns text into an Array of tokens
  #
  # text - A String containing TomDoc-format text.
  #
  # Returns self.
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#231
  def tokenize(text); end

  # Internal: Token accessor
  #
  # source://rdoc//lib/rdoc/tom_doc.rb#46
  def tokens; end

  class << self
    # Internal: Adds a post-processor which sets the RDoc section based on the
    # comment's status.
    #
    # Returns nothing.
    #
    # source://rdoc//lib/rdoc/tom_doc.rb#53
    def add_post_processor; end

    # Public: Parses TomDoc from text
    #
    # text - A String containing TomDoc-format text.
    #
    # Examples
    #
    #   RDoc::TomDoc.parse <<-TOMDOC
    #   This method does some things
    #
    #   Returns nothing.
    #   TOMDOC
    #   # => #<RDoc::Markup::Document:0xXXX @parts=[...], @file=nil>
    #
    # Returns an RDoc::Markup::Document representing the TomDoc format.
    #
    # source://rdoc//lib/rdoc/tom_doc.rb#84
    def parse(text); end

    # Internal: Extracts the Signature section's method signature
    #
    # comment - An RDoc::Comment that will be parsed and have the signature
    #           extracted
    #
    # Returns a String containing the signature and nil if not
    #
    # source://rdoc//lib/rdoc/tom_doc.rb#100
    def signature(comment); end
  end
end

# A TopLevel context is a representation of the contents of a single file
#
# source://rdoc//lib/rdoc/top_level.rb#5
class RDoc::TopLevel < ::RDoc::Context
  # Creates a new TopLevel for the file at +absolute_name+.  If documentation
  # is being generated outside the source dir +relative_name+ is relative to
  # the source directory.
  #
  # @return [TopLevel] a new instance of TopLevel
  #
  # source://rdoc//lib/rdoc/top_level.rb#43
  def initialize(absolute_name, relative_name = T.unsafe(nil)); end

  # An RDoc::TopLevel is equal to another with the same relative_name
  #
  # source://rdoc//lib/rdoc/top_level.rb#67
  def ==(other); end

  # Absolute name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#22
  def absolute_name; end

  # Absolute name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#22
  def absolute_name=(_arg0); end

  # Adds +an_alias+ to +Object+ instead of +self+.
  #
  # source://rdoc//lib/rdoc/top_level.rb#76
  def add_alias(an_alias); end

  # Adds +constant+ to +Object+ instead of +self+.
  #
  # source://rdoc//lib/rdoc/top_level.rb#85
  def add_constant(constant); end

  # Adds +include+ to +Object+ instead of +self+.
  #
  # source://rdoc//lib/rdoc/top_level.rb#94
  def add_include(include); end

  # Adds +method+ to +Object+ instead of +self+.
  #
  # source://rdoc//lib/rdoc/top_level.rb#103
  def add_method(method); end

  # Adds class or module +mod+. Used in the building phase
  # by the Ruby parser.
  #
  # source://rdoc//lib/rdoc/top_level.rb#113
  def add_to_classes_or_modules(mod); end

  # Base name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#120
  def base_name; end

  # All the classes or modules that were declared in
  # this file. These are assigned to either +#classes_hash+
  # or +#modules_hash+ once we know what they really are.
  #
  # source://rdoc//lib/rdoc/top_level.rb#29
  def classes_or_modules; end

  # Returns a URL for this source file on some web repository.  Use the -W
  # command line option to set.
  #
  # source://rdoc//lib/rdoc/generator/markup.rb#149
  def cvs_url; end

  # source://rdoc//lib/rdoc/top_level.rb#31
  def diagram; end

  # source://rdoc//lib/rdoc/top_level.rb#31
  def diagram=(_arg0); end

  # Only a TopLevel that contains text file) will be displayed.  See also
  # RDoc::CodeObject#display?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/top_level.rb#130
  def display?; end

  # An RDoc::TopLevel is equal to another with the same relative_name
  #
  # source://rdoc//lib/rdoc/top_level.rb#67
  def eql?(other); end

  # This TopLevel's File::Stat struct
  #
  # source://rdoc//lib/rdoc/top_level.rb#12
  def file_stat; end

  # This TopLevel's File::Stat struct
  #
  # source://rdoc//lib/rdoc/top_level.rb#12
  def file_stat=(_arg0); end

  # See RDoc::TopLevel::find_class_or_module
  # --
  # TODO Why do we search through all classes/modules found, not just the
  #       ones of this instance?
  #
  # source://rdoc//lib/rdoc/top_level.rb#140
  def find_class_or_module(name); end

  # Finds a class or module named +symbol+
  #
  # source://rdoc//lib/rdoc/top_level.rb#147
  def find_local_symbol(symbol); end

  # Finds a module or class with +name+
  #
  # source://rdoc//lib/rdoc/top_level.rb#154
  def find_module_named(name); end

  # Returns the relative name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#161
  def full_name; end

  # An RDoc::TopLevel has the same hash as another with the same
  # relative_name
  #
  # source://rdoc//lib/rdoc/top_level.rb#169
  def hash; end

  # URL for this with a +prefix+
  #
  # source://rdoc//lib/rdoc/top_level.rb#176
  def http_url(prefix); end

  # source://rdoc//lib/rdoc/top_level.rb#182
  def inspect; end

  # Time this file was last modified, if known
  #
  # source://rdoc//lib/rdoc/top_level.rb#194
  def last_modified; end

  # Dumps this TopLevel for use by ri.  See also #marshal_load
  #
  # source://rdoc//lib/rdoc/top_level.rb#201
  def marshal_dump; end

  # Loads this TopLevel from +array+.
  #
  # source://rdoc//lib/rdoc/top_level.rb#213
  def marshal_load(array); end

  # Base name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#120
  def name; end

  # Returns the NormalClass "Object", creating it if not found.
  #
  # Records +self+ as a location in "Object".
  #
  # source://rdoc//lib/rdoc/top_level.rb#227
  def object_class; end

  # Base name of this file without the extension
  #
  # source://rdoc//lib/rdoc/top_level.rb#238
  def page_name; end

  # The parser class that processed this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#36
  def parser; end

  # Sets the parser for this toplevel context, also the store.
  #
  # source://rdoc//lib/rdoc/top_level.rb#58
  def parser=(val); end

  # Path to this file for use with HTML generator output.
  #
  # source://rdoc//lib/rdoc/top_level.rb#248
  def path; end

  # source://rdoc//lib/rdoc/top_level.rb#252
  def pretty_print(q); end

  # Relative name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#17
  def relative_name; end

  # Relative name of this file
  #
  # source://rdoc//lib/rdoc/top_level.rb#17
  def relative_name=(_arg0); end

  # Search record used by RDoc::Generator::JsonIndex
  #
  # source://rdoc//lib/rdoc/top_level.rb#266
  def search_record; end

  # Is this TopLevel from a text file instead of a source code file?
  #
  # @return [Boolean]
  #
  # source://rdoc//lib/rdoc/top_level.rb#283
  def text?; end

  # source://rdoc//lib/rdoc/top_level.rb#287
  def to_s; end
end

# :stopdoc:
#
# source://rdoc//lib/rdoc/task.rb#347
module Rake
  extend ::FileUtils::StreamUtils_
  extend ::FileUtils
end

# For backwards compatibility
#
# source://rdoc//lib/rdoc/task.rb#352
Rake::RDocTask = RDoc::Task
