# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rexml` gem.
# Please instead update this file by running `bin/tapioca gem rexml`.


# This class needs:
# * Documentation
# * Work!  Not all types of attlists are intelligently parsed, so we just
# spew back out what we get in.  This works, but it would be better if
# we formatted the output ourselves.
#
# AttlistDecls provide *just* enough support to allow namespace
# declarations.  If you need some sort of generalized support, or have an
# interesting idea about how to map the hideous, terrible design of DTD
# AttlistDecls onto an intuitive Ruby interface, let me know.  I'm desperate
# for anything to make DTDs more palateable.
#
# source://rexml//lib/rexml/attlistdecl.rb#18
class REXML::AttlistDecl < ::REXML::Child
  include ::Enumerable

  # Create an AttlistDecl, pulling the information from a Source.  Notice
  # that this isn't very convenient; to create an AttlistDecl, you basically
  # have to format it yourself, and then have the initializer parse it.
  # Sorry, but for the foreseeable future, DTD support in REXML is pretty
  # weak on convenience.  Have I mentioned how much I hate DTDs?
  #
  # @return [AttlistDecl] a new instance of AttlistDecl
  #
  # source://rexml//lib/rexml/attlistdecl.rb#29
  def initialize(source); end

  # Access the attlist attribute/value pairs.
  #  value = attlist_decl[ attribute_name ]
  #
  # source://rexml//lib/rexml/attlistdecl.rb#38
  def [](key); end

  # Iterate over the key/value pairs:
  #  attlist_decl.each { |attribute_name, attribute_value| ... }
  #
  # source://rexml//lib/rexml/attlistdecl.rb#50
  def each(&block); end

  # What is this?  Got me.
  #
  # source://rexml//lib/rexml/attlistdecl.rb#22
  def element_name; end

  # Whether an attlist declaration includes the given attribute definition
  #  if attlist_decl.include? "xmlns:foobar"
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/attlistdecl.rb#44
  def include?(key); end

  # source://rexml//lib/rexml/attlistdecl.rb#59
  def node_type; end

  # Write out exactly what we got in.
  #
  # source://rexml//lib/rexml/attlistdecl.rb#55
  def write(out, indent = T.unsafe(nil)); end
end

# Defines an Element Attribute; IE, a attribute=value pair, as in:
# <element attribute="value"/>.  Attributes can be in their own
# namespaces.  General users of REXML will not interact with the
# Attribute class much.
#
# source://rexml//lib/rexml/attribute.rb#10
class REXML::Attribute
  include ::REXML::Node
  include ::REXML::XMLTokens
  include ::REXML::Namespace

  # Constructor.
  # FIXME: The parser doesn't catch illegal characters in attributes
  #
  # first::
  #   Either: an Attribute, which this new attribute will become a
  #   clone of; or a String, which is the name of this attribute
  # second::
  #   If +first+ is an Attribute, then this may be an Element, or nil.
  #   If nil, then the Element parent of this attribute is the parent
  #   of the +first+ Attribute.  If the first argument is a String,
  #   then this must also be a String, and is the content of the attribute.
  #   If this is the content, it must be fully normalized (contain no
  #   illegal characters).
  # parent::
  #   Ignored unless +first+ is a String; otherwise, may be the Element
  #   parent of this attribute, or nil.
  #
  #
  #  Attribute.new( attribute_to_clone )
  #  Attribute.new( attribute_to_clone, parent_element )
  #  Attribute.new( "attr", "attr_value" )
  #  Attribute.new( "attr", "attr_value", parent_element )
  #
  # @return [Attribute] a new instance of Attribute
  #
  # source://rexml//lib/rexml/attribute.rb#42
  def initialize(first, second = T.unsafe(nil), parent = T.unsafe(nil)); end

  # Returns true if other is an Attribute and has the same name and value,
  # false otherwise.
  #
  # source://rexml//lib/rexml/attribute.rb#106
  def ==(other); end

  # Returns a copy of this attribute
  #
  # source://rexml//lib/rexml/attribute.rb#164
  def clone; end

  # source://rexml//lib/rexml/attribute.rb#132
  def doctype; end

  # The element to which this attribute belongs
  #
  # source://rexml//lib/rexml/attribute.rb#15
  def element; end

  # Sets the element of which this object is an attribute.  Normally, this
  # is not directly called.
  #
  # Returns this attribute
  #
  # source://rexml//lib/rexml/attribute.rb#172
  def element=(element); end

  # Creates (and returns) a hash from both the name and value
  #
  # source://rexml//lib/rexml/attribute.rb#111
  def hash; end

  # source://rexml//lib/rexml/attribute.rb#198
  def inspect; end

  # Returns the namespace URL, if defined, or nil otherwise
  #
  #  e = Element.new("el")
  #  e.add_namespace("ns", "http://url")
  #  e.add_attribute("ns:a", "b")
  #  e.add_attribute("nsx:a", "c")
  #  e.attribute("ns:a").namespace # => "http://url"
  #  e.attribute("nsx:a").namespace # => nil
  #
  # This method always returns "" for no namespace attribute. Because
  # the default namespace doesn't apply to attribute names.
  #
  # From https://www.w3.org/TR/xml-names/#uniqAttrs
  #
  # > the default namespace does not apply to attribute names
  #
  #  e = REXML::Element.new("el")
  #  e.add_namespace("", "http://example.com/")
  #  e.namespace # => "http://example.com/"
  #  e.add_attribute("a", "b")
  #  e.attribute("a").namespace # => ""
  #
  # source://rexml//lib/rexml/attribute.rb#95
  def namespace(arg = T.unsafe(nil)); end

  # source://rexml//lib/rexml/attribute.rb#194
  def node_type; end

  # The normalized value of this attribute.  That is, the attribute with
  # entities intact.
  #
  # source://rexml//lib/rexml/attribute.rb#158
  def normalized=(new_normalized); end

  # Returns the namespace of the attribute.
  #
  #  e = Element.new( "elns:myelement" )
  #  e.add_attribute( "nsa:a", "aval" )
  #  e.add_attribute( "b", "bval" )
  #  e.attributes.get_attribute( "a" ).prefix   # -> "nsa"
  #  e.attributes.get_attribute( "b" ).prefix   # -> ""
  #  a = Attribute.new( "x", "y" )
  #  a.prefix                                   # -> ""
  #
  # source://rexml//lib/rexml/attribute.rb#70
  def prefix; end

  # Removes this Attribute from the tree, and returns true if successful
  #
  # This method is usually not called directly.
  #
  # source://rexml//lib/rexml/attribute.rb#185
  def remove; end

  # Returns the attribute value, with entities replaced
  #
  # source://rexml//lib/rexml/attribute.rb#140
  def to_s; end

  # Returns this attribute out as XML source, expanding the name
  #
  #  a = Attribute.new( "x", "y" )
  #  a.to_string     # -> "x='y'"
  #  b = Attribute.new( "ns:x", "y" )
  #  b.to_string     # -> "ns:x='y'"
  #
  # source://rexml//lib/rexml/attribute.rb#121
  def to_string; end

  # Returns the UNNORMALIZED value of this attribute.  That is, entities
  # have been expanded to their values
  #
  # source://rexml//lib/rexml/attribute.rb#149
  def value; end

  # Writes this attribute (EG, puts 'key="value"' to the output)
  #
  # source://rexml//lib/rexml/attribute.rb#190
  def write(output, indent = T.unsafe(nil)); end

  # source://rexml//lib/rexml/attribute.rb#204
  def xpath; end
end

# A class that defines the set of Attributes of an Element and provides
# operations for accessing elements in that set.
#
# source://rexml//lib/rexml/element.rb#2137
class REXML::Attributes < ::Hash
  # :call-seq:
  #   new(element)
  #
  # Creates and returns a new \REXML::Attributes object.
  # The element given by argument +element+ is stored,
  # but its own attributes are not modified:
  #
  #   ele = REXML::Element.new('foo')
  #   attrs = REXML::Attributes.new(ele)
  #   attrs.object_id == ele.attributes.object_id # => false
  #
  # Other instance methods in class \REXML::Attributes may refer to:
  #
  # - +element.document+.
  # - +element.prefix+.
  # - +element.expanded_name+.
  #
  # @return [Attributes] a new instance of Attributes
  #
  # source://rexml//lib/rexml/element.rb#2156
  def initialize(element); end

  # :call-seq:
  #   add(attribute) -> attribute
  #
  # Adds attribute +attribute+, replacing the previous
  # attribute of the same name if it exists;
  # returns +attribute+:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs # => {"att"=>{"foo"=>foo:att='1', "bar"=>bar:att='2', ""=>att='&lt;'}}
  #   attrs.add(REXML::Attribute.new('foo:att', '2')) # => foo:att='2'
  #   attrs.add(REXML::Attribute.new('baz', '3')) # => baz='3'
  #   attrs.include?('baz') # => true
  #
  # source://rexml//lib/rexml/element.rb#2522
  def <<(attribute); end

  # :call-seq:
  #   [name] -> attribute_value or nil
  #
  # Returns the value for the attribute given by +name+,
  # if it exists; otherwise +nil+.
  # The value returned is the unnormalized attribute value,
  # with entities expanded:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   ele.attributes['att']     # => "<"
  #   ele.attributes['bar:att'] # => "2"
  #   ele.attributes['nosuch']  # => nil
  #
  # Related: get_attribute (returns an \Attribute object).
  #
  # source://rexml//lib/rexml/element.rb#2181
  def [](name); end

  # :call-seq:
  #   [name] = value -> value
  #
  # When +value+ is non-+nil+,
  # assigns that to the attribute for the given +name+,
  # overwriting the previous value if it exists:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs['foo:att'] = '2' # => "2"
  #   attrs['baz:att'] = '3' # => "3"
  #
  # When +value+ is +nil+, deletes the attribute if it exists:
  #
  #   attrs['baz:att'] = nil
  #   attrs.include?('baz:att') # => false
  #
  # source://rexml//lib/rexml/element.rb#2365
  def []=(name, value); end

  # :call-seq:
  #   add(attribute) -> attribute
  #
  # Adds attribute +attribute+, replacing the previous
  # attribute of the same name if it exists;
  # returns +attribute+:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs # => {"att"=>{"foo"=>foo:att='1', "bar"=>bar:att='2', ""=>att='&lt;'}}
  #   attrs.add(REXML::Attribute.new('foo:att', '2')) # => foo:att='2'
  #   attrs.add(REXML::Attribute.new('baz', '3')) # => baz='3'
  #   attrs.include?('baz') # => true
  #
  # source://rexml//lib/rexml/element.rb#2522
  def add(attribute); end

  # :call-seq:
  #    delete(name) -> element
  #    delete(attribute) -> element
  #
  # Removes a specified attribute if it exists;
  # returns the attributes' element.
  #
  # When string argument +name+ is given,
  # removes the attribute of that name if it exists:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs.delete('foo:att') # => <ele bar:att='2' att='&lt;'/>
  #   attrs.delete('foo:att') # => <ele bar:att='2' att='&lt;'/>
  #
  # When attribute argument +attribute+ is given,
  # removes that attribute if it exists:
  #
  #   attr = REXML::Attribute.new('bar:att', '2')
  #   attrs.delete(attr) # => <ele att='&lt;'/> # => <ele att='&lt;'/>
  #   attrs.delete(attr) # => <ele att='&lt;'/> # => <ele/>
  #
  # source://rexml//lib/rexml/element.rb#2475
  def delete(attribute); end

  # :call-seq:
  #   delete_all(name) -> array_of_removed_attributes
  #
  # Removes all attributes matching the given +name+;
  # returns an array of the removed attributes:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs.delete_all('att') # => [att='&lt;']
  #
  # source://rexml//lib/rexml/element.rb#2544
  def delete_all(name); end

  # :call-seq:
  #   each {|expanded_name, value| ... }
  #
  # Calls the given block with each expanded-name/value pair:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele']   # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   ele.attributes.each do |expanded_name, value|
  #     p [expanded_name, value]
  #   end
  #
  # Output:
  #
  #   ["foo:att", "1"]
  #   ["bar:att", "2"]
  #   ["att", "<"]
  #
  # source://rexml//lib/rexml/element.rb#2283
  def each; end

  # :call-seq:
  #   each_attribute {|attr| ... }
  #
  # Calls the given block with each \REXML::Attribute object:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele']   # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   ele.attributes.each_attribute do |attr|
  #     p [attr.class, attr]
  #   end
  #
  # Output:
  #
  #   [REXML::Attribute, foo:att='1']
  #   [REXML::Attribute, bar:att='2']
  #   [REXML::Attribute, att='&lt;']
  #
  # source://rexml//lib/rexml/element.rb#2250
  def each_attribute; end

  # :call-seq:
  #   get_attribute(name) -> attribute_object or nil
  #
  # Returns the \REXML::Attribute object for the given +name+:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs.get_attribute('foo:att')       # => foo:att='1'
  #   attrs.get_attribute('foo:att').class # => REXML::Attribute
  #   attrs.get_attribute('bar:att')       # => bar:att='2'
  #   attrs.get_attribute('att')           # => att='&lt;'
  #   attrs.get_attribute('nosuch')        # => nil
  #
  # source://rexml//lib/rexml/element.rb#2309
  def get_attribute(name); end

  # :call-seq:
  #   get_attribute_ns(namespace, name)
  #
  # Returns the \REXML::Attribute object among the attributes
  # that matches the given +namespace+ and +name+:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele'] # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes
  #   attrs.get_attribute_ns('http://foo', 'att')    # => foo:att='1'
  #   attrs.get_attribute_ns('http://foo', 'nosuch') # => nil
  #
  # source://rexml//lib/rexml/element.rb#2570
  def get_attribute_ns(namespace, name); end

  # :call-seq:
  #   length
  #
  # Returns the count of attributes:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele']   # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   ele.attributes.length # => 3
  #
  # source://rexml//lib/rexml/element.rb#2221
  def length; end

  # :call-seq:
  #   namespaces
  #
  # Returns a hash of name/value pairs for the namespaces:
  #
  #   xml_string = '<a xmlns="foo" xmlns:x="bar" xmlns:y="twee" z="glorp"/>'
  #   d = REXML::Document.new(xml_string)
  #   d.root.attributes.namespaces # => {"xmlns"=>"foo", "x"=>"bar", "y"=>"twee"}
  #
  # source://rexml//lib/rexml/element.rb#2431
  def namespaces; end

  # :call-seq:
  #   prefixes -> array_of_prefix_strings
  #
  # Returns an array of prefix strings in the attributes.
  # The array does not include the default
  # namespace declaration, if one exists.
  #
  #   xml_string = '<a xmlns="foo" xmlns:x="bar" xmlns:y="twee" z="glorp"/>'
  #   d = REXML::Document.new(xml_string)
  #   d.root.attributes.prefixes # => ["x", "y"]
  #
  # source://rexml//lib/rexml/element.rb#2406
  def prefixes; end

  # :call-seq:
  #   length
  #
  # Returns the count of attributes:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele']   # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   ele.attributes.length # => 3
  #
  # source://rexml//lib/rexml/element.rb#2221
  def size; end

  # :call-seq:
  #   to_a -> array_of_attribute_objects
  #
  # Returns an array of \REXML::Attribute objects representing
  # the attributes:
  #
  #   xml_string = <<-EOT
  #     <root xmlns:foo="http://foo" xmlns:bar="http://bar">
  #        <ele foo:att='1' bar:att='2' att='&lt;'/>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   ele = d.root.elements['//ele']   # => <a foo:att='1' bar:att='2' att='&lt;'/>
  #   attrs = ele.attributes.to_a      # => [foo:att='1', bar:att='2', att='&lt;']
  #   attrs.first.class                # => REXML::Attribute
  #
  # source://rexml//lib/rexml/element.rb#2203
  def to_a; end
end

# source://rexml//lib/rexml/cdata.rb#5
class REXML::CData < ::REXML::Text
  # Constructor.  CData is data between <![CDATA[ ... ]]>
  #
  # _Examples_
  #  CData.new( source )
  #  CData.new( "Here is some CDATA" )
  #  CData.new( "Some unprocessed data", respect_whitespace_TF, parent_element )
  #
  # @return [CData] a new instance of CData
  #
  # source://rexml//lib/rexml/cdata.rb#16
  def initialize(first, whitespace = T.unsafe(nil), parent = T.unsafe(nil)); end

  # Make a copy of this object
  #
  # _Examples_
  #  c = CData.new( "Some text" )
  #  d = c.clone
  #  d.to_s        # -> "Some text"
  #
  # source://rexml//lib/rexml/cdata.rb#26
  def clone; end

  # Returns the content of this CData object
  #
  # _Examples_
  #  c = CData.new( "Some text" )
  #  c.to_s        # -> "Some text"
  #
  # source://rexml//lib/rexml/cdata.rb#35
  def to_s; end

  # source://rexml//lib/rexml/cdata.rb#39
  def value; end

  # == DEPRECATED
  # See the rexml/formatters package
  #
  # Generates XML output of this object
  #
  # output::
  #   Where to write the string.  Defaults to $stdout
  # indent::
  #   The amount to indent this node by
  # transitive::
  #   Ignored
  # ie_hack::
  #   Ignored
  #
  # _Examples_
  #  c = CData.new( " Some text " )
  #  c.write( $stdout )     #->  <![CDATA[ Some text ]]>
  #
  # source://rexml//lib/rexml/cdata.rb#60
  def write(output = T.unsafe(nil), indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end
end

# A Child object is something contained by a parent, and this class
# contains methods to support that.  Most user code will not use this
# class directly.
#
# source://rexml//lib/rexml/child.rb#9
class REXML::Child
  include ::REXML::Node

  # Constructor.  Any inheritors of this class should call super to make
  # sure this method is called.
  # parent::
  #   if supplied, the parent of this child will be set to the
  #   supplied value, and self will be added to the parent
  #
  # @return [Child] a new instance of Child
  #
  # source://rexml//lib/rexml/child.rb#18
  def initialize(parent = T.unsafe(nil)); end

  # This doesn't yet handle encodings
  #
  # source://rexml//lib/rexml/child.rb#91
  def bytes; end

  # Returns:: the document this child belongs to, or nil if this child
  # belongs to no document
  #
  # source://rexml//lib/rexml/child.rb#85
  def document; end

  # source://rexml//lib/rexml/node.rb#11
  def next_sibling; end

  # Sets the next sibling of this child.  This can be used to insert a child
  # after some other child.
  #  a = Element.new("a")
  #  b = a.add_element("b")
  #  c = Element.new("c")
  #  b.next_sibling = c
  #  # => <a><b/><c/></a>
  #
  # source://rexml//lib/rexml/child.rb#68
  def next_sibling=(other); end

  # The Parent of this object
  #
  # source://rexml//lib/rexml/child.rb#11
  def parent; end

  # Sets the parent of this child to the supplied argument.
  #
  # other::
  #   Must be a Parent object.  If this object is the same object as the
  #   existing parent of this child, no action is taken. Otherwise, this
  #   child is removed from the current parent (if one exists), and is added
  #   to the new parent.
  # Returns:: The parent added
  #
  # source://rexml//lib/rexml/child.rb#52
  def parent=(other); end

  # source://rexml//lib/rexml/node.rb#17
  def previous_sibling; end

  # Sets the previous sibling of this child.  This can be used to insert a
  # child before some other child.
  #  a = Element.new("a")
  #  b = a.add_element("b")
  #  c = Element.new("c")
  #  b.previous_sibling = c
  #  # => <a><b/><c/></a>
  #
  # source://rexml//lib/rexml/child.rb#79
  def previous_sibling=(other); end

  # Removes this child from the parent.
  #
  # Returns:: self
  #
  # source://rexml//lib/rexml/child.rb#37
  def remove; end

  # Replaces this object with another object.  Basically, calls
  # Parent.replace_child
  #
  # Returns:: self
  #
  # source://rexml//lib/rexml/child.rb#29
  def replace_with(child); end
end

# Represents an XML comment; that is, text between \<!-- ... -->
#
# source://rexml//lib/rexml/comment.rb#7
class REXML::Comment < ::REXML::Child
  include ::Comparable

  # Constructor.  The first argument can be one of three types:
  # argument.  If Comment, the argument is duplicated.  If
  # Source, the argument is scanned for a comment.
  # should be nil, not supplied, or a Parent to be set as the parent
  # of this object
  #
  # @param first If String, the contents of this comment are set to the
  # @param second If the first argument is a Source, this argument
  # @return [Comment] a new instance of Comment
  #
  # source://rexml//lib/rexml/comment.rb#24
  def initialize(first, second = T.unsafe(nil)); end

  # Compares this Comment to another; the contents of the comment are used
  # in the comparison.
  #
  # source://rexml//lib/rexml/comment.rb#63
  def <=>(other); end

  # Compares this Comment to another; the contents of the comment are used
  # in the comparison.
  #
  # source://rexml//lib/rexml/comment.rb#70
  def ==(other); end

  # source://rexml//lib/rexml/comment.rb#33
  def clone; end

  # source://rexml//lib/rexml/comment.rb#75
  def node_type; end

  # The content text
  #
  # source://rexml//lib/rexml/comment.rb#14
  def string; end

  # The content text
  #
  # source://rexml//lib/rexml/comment.rb#14
  def string=(_arg0); end

  # The content text
  #
  # source://rexml//lib/rexml/comment.rb#14
  def to_s; end

  # == DEPRECATED
  # See REXML::Formatters
  #
  # output::
  #    Where to write the string
  # indent::
  #    An integer.    If -1, no indenting will be used; otherwise, the
  #    indentation will be this number of spaces, and children will be
  #    indented an additional amount.
  # transitive::
  #    Ignored by this class. The contents of comments are never modified.
  # ie_hack::
  #    Needed for conformity to the child API, but not used by this class.
  #
  # source://rexml//lib/rexml/comment.rb#50
  def write(output, indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end
end

# source://rexml//lib/rexml/xpath_parser.rb#11
module REXML::DClonable; end

# This is an abstract class.  You never use this directly; it serves as a
# parent class for the specific declarations.
#
# source://rexml//lib/rexml/doctype.rb#242
class REXML::Declaration < ::REXML::Child
  # @return [Declaration] a new instance of Declaration
  #
  # source://rexml//lib/rexml/doctype.rb#243
  def initialize(src); end

  # source://rexml//lib/rexml/doctype.rb#248
  def to_s; end

  # == DEPRECATED
  # See REXML::Formatters
  #
  # source://rexml//lib/rexml/doctype.rb#255
  def write(output, indent); end
end

# Represents an XML DOCTYPE declaration; that is, the contents of <!DOCTYPE
# ... >.  DOCTYPES can be used to declare the DTD of a document, as well as
# being used to declare entities used in the document.
#
# source://rexml//lib/rexml/doctype.rb#51
class REXML::DocType < ::REXML::Parent
  include ::REXML::XMLTokens

  # Constructor
  #
  #   dt = DocType.new( 'foo', '-//I/Hate/External/IDs' )
  #   # <!DOCTYPE foo '-//I/Hate/External/IDs'>
  #   dt = DocType.new( doctype_to_clone )
  #   # Incomplete.  Shallow clone of doctype
  #
  # +Note+ that the constructor:
  #
  #  Doctype.new( Source.new( "<!DOCTYPE foo 'bar'>" ) )
  #
  # is _deprecated_.  Do not use it.  It will probably disappear.
  #
  # @return [DocType] a new instance of DocType
  #
  # source://rexml//lib/rexml/doctype.rb#80
  def initialize(first, parent = T.unsafe(nil)); end

  # source://rexml//lib/rexml/doctype.rb#185
  def add(child); end

  # source://rexml//lib/rexml/doctype.rb#125
  def attribute_of(element, attribute); end

  # source://rexml//lib/rexml/doctype.rb#115
  def attributes_of(element); end

  # source://rexml//lib/rexml/doctype.rb#135
  def clone; end

  # source://rexml//lib/rexml/doctype.rb#173
  def context; end

  # name is the name of the doctype
  # external_id is the referenced DTD, if given
  #
  # source://rexml//lib/rexml/doctype.rb#66
  def entities; end

  # source://rexml//lib/rexml/doctype.rb#181
  def entity(name); end

  # name is the name of the doctype
  # external_id is the referenced DTD, if given
  #
  # source://rexml//lib/rexml/doctype.rb#66
  def external_id; end

  # name is the name of the doctype
  # external_id is the referenced DTD, if given
  #
  # source://rexml//lib/rexml/doctype.rb#66
  def name; end

  # name is the name of the doctype
  # external_id is the referenced DTD, if given
  #
  # source://rexml//lib/rexml/doctype.rb#66
  def namespaces; end

  # source://rexml//lib/rexml/doctype.rb#111
  def node_type; end

  # Retrieves a named notation. Only notations declared in the internal
  # DTD subset can be retrieved.
  #
  # Method contributed by Henrik Martensson
  #
  # source://rexml//lib/rexml/doctype.rb#229
  def notation(name); end

  # This method returns a list of notations that have been declared in the
  # _internal_ DTD subset. Notations in the external DTD subset are not
  # listed.
  #
  # Method contributed by Henrik Martensson
  #
  # source://rexml//lib/rexml/doctype.rb#221
  def notations; end

  # This method retrieves the public identifier identifying the document's
  # DTD.
  #
  # Method contributed by Henrik Martensson
  #
  # source://rexml//lib/rexml/doctype.rb#195
  def public; end

  # This method retrieves the system identifier identifying the document's DTD
  #
  # Method contributed by Henrik Martensson
  #
  # source://rexml//lib/rexml/doctype.rb#207
  def system; end

  # output::
  #   Where to write the string
  # indent::
  #   An integer.  If -1, no indentation will be used; otherwise, the
  #   indentation will be this number of spaces, and children will be
  #   indented an additional amount.
  # transitive::
  #   Ignored
  # ie_hack::
  #   Ignored
  #
  # source://rexml//lib/rexml/doctype.rb#149
  def write(output, indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end
end

# Represents an XML document.
#
# A document may have:
#
# - A single child that may be accessed via method #root.
# - An XML declaration.
# - A document type.
# - Processing instructions.
#
# == In a Hurry?
#
# If you're somewhat familiar with XML
# and have a particular task in mind,
# you may want to see the
# {tasks pages}[../doc/rexml/tasks/tocs/master_toc_rdoc.html],
# and in particular, the
# {tasks page for documents}[../doc/rexml/tasks/tocs/document_toc_rdoc.html].
#
# source://rexml//lib/rexml/document.rb#35
class REXML::Document < ::REXML::Element
  # :call-seq:
  #   new(string = nil, context = {}) -> new_document
  #   new(io_stream = nil, context = {}) -> new_document
  #   new(document = nil, context = {}) -> new_document
  #
  # Returns a new \REXML::Document object.
  #
  # When no arguments are given,
  # returns an empty document:
  #
  #   d = REXML::Document.new
  #   d.to_s # => ""
  #
  # When argument +string+ is given, it must be a string
  # containing a valid XML document:
  #
  #   xml_string = '<root><foo>Foo</foo><bar>Bar</bar></root>'
  #   d = REXML::Document.new(xml_string)
  #   d.to_s # => "<root><foo>Foo</foo><bar>Bar</bar></root>"
  #
  # When argument +io_stream+ is given, it must be an \IO object
  # that is opened for reading, and when read must return a valid XML document:
  #
  #   File.write('t.xml', xml_string)
  #   d = File.open('t.xml', 'r') do |io|
  #     REXML::Document.new(io)
  #   end
  #   d.to_s # => "<root><foo>Foo</foo><bar>Bar</bar></root>"
  #
  # When argument +document+ is given, it must be an existing
  # document object, whose context and attributes (but not children)
  # are cloned into the new document:
  #
  #   d = REXML::Document.new(xml_string)
  #   d.children    # => [<root> ... </>]
  #   d.context = {raw: :all, compress_whitespace: :all}
  #   d.add_attributes({'bar' => 0, 'baz' => 1})
  #   d1 = REXML::Document.new(d)
  #   d1.children   # => []
  #   d1.context    # => {:raw=>:all, :compress_whitespace=>:all}
  #   d1.attributes # => {"bar"=>bar='0', "baz"=>baz='1'}
  #
  # When argument +context+ is given, it must be a hash
  # containing context entries for the document;
  # see {Element Context}[../doc/rexml/context_rdoc.html]:
  #
  #   context = {raw: :all, compress_whitespace: :all}
  #   d = REXML::Document.new(xml_string, context)
  #   d.context # => {:raw=>:all, :compress_whitespace=>:all}
  #
  # @return [Document] a new instance of Document
  #
  # source://rexml//lib/rexml/document.rb#92
  def initialize(source = T.unsafe(nil), context = T.unsafe(nil)); end

  # :call-seq:
  #   add(xml_decl) -> self
  #   add(doc_type) -> self
  #   add(object) -> self
  #
  # Adds an object to the document; returns +self+.
  #
  # When argument +xml_decl+ is given,
  # it must be an REXML::XMLDecl object,
  # which becomes the XML declaration for the document,
  # replacing the previous XML declaration if any:
  #
  #   d = REXML::Document.new
  #   d.xml_decl.to_s # => ""
  #   d.add(REXML::XMLDecl.new('2.0'))
  #   d.xml_decl.to_s # => "<?xml version='2.0'?>"
  #
  # When argument +doc_type+ is given,
  # it must be an REXML::DocType object,
  # which becomes the document type for the document,
  # replacing the previous document type, if any:
  #
  #   d = REXML::Document.new
  #   d.doctype.to_s # => ""
  #   d.add(REXML::DocType.new('foo'))
  #   d.doctype.to_s # => "<!DOCTYPE foo>"
  #
  # When argument +object+ (not an REXML::XMLDecl or REXML::DocType object)
  # is given it is added as the last child:
  #
  #   d = REXML::Document.new
  #   d.add(REXML::Element.new('foo'))
  #   d.to_s # => "<foo/>"
  #
  # source://rexml//lib/rexml/document.rb#172
  def <<(child); end

  # :call-seq:
  #   add(xml_decl) -> self
  #   add(doc_type) -> self
  #   add(object) -> self
  #
  # Adds an object to the document; returns +self+.
  #
  # When argument +xml_decl+ is given,
  # it must be an REXML::XMLDecl object,
  # which becomes the XML declaration for the document,
  # replacing the previous XML declaration if any:
  #
  #   d = REXML::Document.new
  #   d.xml_decl.to_s # => ""
  #   d.add(REXML::XMLDecl.new('2.0'))
  #   d.xml_decl.to_s # => "<?xml version='2.0'?>"
  #
  # When argument +doc_type+ is given,
  # it must be an REXML::DocType object,
  # which becomes the document type for the document,
  # replacing the previous document type, if any:
  #
  #   d = REXML::Document.new
  #   d.doctype.to_s # => ""
  #   d.add(REXML::DocType.new('foo'))
  #   d.doctype.to_s # => "<!DOCTYPE foo>"
  #
  # When argument +object+ (not an REXML::XMLDecl or REXML::DocType object)
  # is given it is added as the last child:
  #
  #   d = REXML::Document.new
  #   d.add(REXML::Element.new('foo'))
  #   d.to_s # => "<foo/>"
  #
  # source://rexml//lib/rexml/document.rb#172
  def add(child); end

  # :call-seq:
  #   add_element(name_or_element = nil, attributes = nil) -> new_element
  #
  # Adds an element to the document by calling REXML::Element.add_element:
  #
  #   REXML::Element.add_element(name_or_element, attributes)
  #
  # source://rexml//lib/rexml/document.rb#211
  def add_element(arg = T.unsafe(nil), arg2 = T.unsafe(nil)); end

  # :call-seq:
  #   clone -> new_document
  #
  # Returns the new document resulting from executing
  # <tt>Document.new(self)</tt>.  See Document.new.
  #
  # source://rexml//lib/rexml/document.rb#122
  def clone; end

  # :call-seq:
  #   doctype -> doc_type or nil
  #
  # Returns the DocType object for the document, if it exists, otherwise +nil+:
  #
  #   d = REXML::Document.new('<!DOCTYPE document SYSTEM "subjects.dtd">')
  #   d.doctype.class # => REXML::DocType
  #   d = REXML::Document.new('')
  #   d.doctype.class # => nil
  #
  # source://rexml//lib/rexml/document.rb#243
  def doctype; end

  # source://rexml//lib/rexml/document.rb#446
  def document; end

  # :call-seq:
  #   encoding -> encoding_string
  #
  # Returns the XMLDecl encoding of the document,
  #
  #   d = REXML::Document.new('<?xml version="1.0" encoding="UTF-16"?>')
  #   d.encoding # => "UTF-16"
  #   d = REXML::Document.new('')
  #   d.encoding # => "UTF-8"
  #
  # source://rexml//lib/rexml/document.rb#292
  def encoding; end

  # Returns the value of attribute entity_expansion_count.
  #
  # source://rexml//lib/rexml/document.rb#435
  def entity_expansion_count; end

  # Sets the attribute entity_expansion_limit
  #
  # @param value the value to set the attribute entity_expansion_limit to.
  #
  # source://rexml//lib/rexml/document.rb#436
  def entity_expansion_limit=(_arg0); end

  # Returns the value of attribute entity_expansion_text_limit.
  #
  # source://rexml//lib/rexml/document.rb#437
  def entity_expansion_text_limit; end

  # Sets the attribute entity_expansion_text_limit
  #
  # @param value the value to set the attribute entity_expansion_text_limit to.
  #
  # source://rexml//lib/rexml/document.rb#437
  def entity_expansion_text_limit=(_arg0); end

  # :call-seq:
  #   expanded_name -> empty_string
  #
  # Returns an empty string.
  #
  # source://rexml//lib/rexml/document.rb#131
  def expanded_name; end

  # :call-seq:
  #   expanded_name -> empty_string
  #
  # Returns an empty string.
  # d = doc_type
  # d ? d.name : "UNDEFINED"
  #
  # source://rexml//lib/rexml/document.rb#131
  def name; end

  # :call-seq:
  #   node_type -> :document
  #
  # Returns the symbol +:document+.
  #
  # source://rexml//lib/rexml/document.rb#112
  def node_type; end

  # source://rexml//lib/rexml/document.rb#439
  def record_entity_expansion; end

  # :call-seq:
  #   root -> root_element or nil
  #
  # Returns the root element of the document, if it exists, otherwise +nil+:
  #
  #   d = REXML::Document.new('<root></root>')
  #   d.root # => <root/>
  #   d = REXML::Document.new('')
  #   d.root # => nil
  #
  # source://rexml//lib/rexml/document.rb#227
  def root; end

  # :call-seq:
  #   stand_alone?
  #
  # Returns the XMLDecl standalone value of the document as a string,
  # if it has been set, otherwise the default standalone value:
  #
  #   d = REXML::Document.new('<?xml standalone="yes"?>')
  #   d.stand_alone? # => "yes"
  #   d = REXML::Document.new('')
  #   d.stand_alone? # => nil
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/document.rb#307
  def stand_alone?; end

  # :call-seq:
  #   version -> version_string
  #
  # Returns the XMLDecl version of this document as a string,
  # if it has been set, otherwise the default version:
  #
  #   d = REXML::Document.new('<?xml version="2.0" encoding="UTF-8"?>')
  #   d.version # => "2.0"
  #   d = REXML::Document.new('')
  #   d.version # => "1.0"
  #
  # source://rexml//lib/rexml/document.rb#277
  def version; end

  # :call-seq:
  #    doc.write(output=$stdout, indent=-1, transtive=false, ie_hack=false, encoding=nil)
  #    doc.write(options={:output => $stdout, :indent => -1, :transtive => false, :ie_hack => false, :encoding => nil})
  #
  # Write the XML tree out, optionally with indent.  This writes out the
  # entire XML document, including XML declarations, doctype declarations,
  # and processing instructions (if any are given).
  #
  # A controversial point is whether Document should always write the XML
  # declaration (<?xml version='1.0'?>) whether or not one is given by the
  # user (or source document).  REXML does not write one if one was not
  # specified, because it adds unnecessary bandwidth to applications such
  # as XML-RPC.
  #
  # Accept Nth argument style and options Hash style as argument.
  # The recommended style is options Hash style for one or more
  # arguments case.
  #
  # _Examples_
  #   Document.new("<a><b/></a>").write
  #
  #   output = ""
  #   Document.new("<a><b/></a>").write(output)
  #
  #   output = ""
  #   Document.new("<a><b/></a>").write(:output => output, :indent => 2)
  #
  # See also the classes in the rexml/formatters package for the proper way
  # to change the default formatting of XML output.
  #
  # _Examples_
  #
  #   output = ""
  #   tr = Transitive.new
  #   tr.write(Document.new("<a><b/></a>"), output)
  #
  # output::
  #   output an object which supports '<< string'; this is where the
  #   document will be written.
  # indent::
  #   An integer.  If -1, no indenting will be used; otherwise, the
  #   indentation will be twice this number of spaces, and children will be
  #   indented an additional amount.  For a value of 3, every item will be
  #   indented 3 more levels, or 6 more spaces (2 * 3). Defaults to -1
  # transitive::
  #   If transitive is true and indent is >= 0, then the output will be
  #   pretty-printed in such a way that the added whitespace does not affect
  #   the absolute *value* of the document -- that is, it leaves the value
  #   and number of Text nodes in the document unchanged.
  # ie_hack::
  #   This hack inserts a space before the /> on empty tags to address
  #   a limitation of Internet Explorer.  Defaults to false
  #   Encoding name as String. Change output encoding to specified encoding
  #   instead of encoding in XML declaration.
  #   Defaults to nil. It means encoding in XML declaration is used.
  #
  # source://rexml//lib/rexml/document.rb#367
  def write(*arguments); end

  # :call-seq:
  #   xml_decl -> xml_decl
  #
  # Returns the XMLDecl object for the document, if it exists,
  # otherwise the default XMLDecl object:
  #
  #   d = REXML::Document.new('<?xml version="1.0" encoding="UTF-8"?>')
  #   d.xml_decl.class # => REXML::XMLDecl
  #   d.xml_decl.to_s  # => "<?xml version='1.0' encoding='UTF-8'?>"
  #   d = REXML::Document.new('')
  #   d.xml_decl.class # => REXML::XMLDecl
  #   d.xml_decl.to_s  # => ""
  #
  # source://rexml//lib/rexml/document.rb#260
  def xml_decl; end

  private

  # source://rexml//lib/rexml/document.rb#451
  def build(source); end

  class << self
    # Get the entity expansion limit. By default the limit is set to 10000.
    #
    # Deprecated. Use REXML::Security.entity_expansion_limit= instead.
    #
    # source://rexml//lib/rexml/document.rb#417
    def entity_expansion_limit; end

    # Set the entity expansion limit. By default the limit is set to 10000.
    #
    # Deprecated. Use REXML::Security.entity_expansion_limit= instead.
    #
    # source://rexml//lib/rexml/document.rb#410
    def entity_expansion_limit=(val); end

    # Get the entity expansion limit. By default the limit is set to 10240.
    #
    # Deprecated. Use REXML::Security.entity_expansion_text_limit instead.
    #
    # source://rexml//lib/rexml/document.rb#431
    def entity_expansion_text_limit; end

    # Set the entity expansion limit. By default the limit is set to 10240.
    #
    # Deprecated. Use REXML::Security.entity_expansion_text_limit= instead.
    #
    # source://rexml//lib/rexml/document.rb#424
    def entity_expansion_text_limit=(val); end

    # source://rexml//lib/rexml/document.rb#403
    def parse_stream(source, listener); end
  end
end

# An \REXML::Element object represents an XML element.
#
# An element:
#
# - Has a name (string).
# - May have a parent (another element).
# - Has zero or more children
#   (other elements, text, CDATA, processing instructions, and comments).
# - Has zero or more siblings
#   (other elements, text, CDATA, processing instructions, and comments).
# - Has zero or more named attributes.
#
# == In a Hurry?
#
# If you're somewhat familiar with XML
# and have a particular task in mind,
# you may want to see the
# {tasks pages}[../doc/rexml/tasks/tocs/master_toc_rdoc.html],
# and in particular, the
# {tasks page for elements}[../doc/rexml/tasks/tocs/element_toc_rdoc.html].
#
# === Name
#
# An element has a name, which is initially set when the element is created:
#
#   e = REXML::Element.new('foo')
#   e.name # => "foo"
#
# The name may be changed:
#
#   e.name = 'bar'
#   e.name # => "bar"
#
#
# === \Parent
#
# An element may have a parent.
#
# Its parent may be assigned explicitly when the element is created:
#
#   e0 = REXML::Element.new('foo')
#   e1 = REXML::Element.new('bar', e0)
#   e1.parent # => <foo> ... </>
#
# Note: the representation of an element always shows the element's name.
# If the element has children, the representation indicates that
# by including an ellipsis (<tt>...</tt>).
#
# The parent may be assigned explicitly at any time:
#
#   e2 = REXML::Element.new('baz')
#   e1.parent = e2
#   e1.parent # => <baz/>
#
# When an element is added as a child, its parent is set automatically:
#
#   e1.add_element(e0)
#   e0.parent # => <bar> ... </>
#
# For an element that has no parent, method +parent+ returns +nil+.
#
# === Children
#
# An element has zero or more children.
# The children are an ordered collection
# of all objects whose parent is the element itself.
#
# The children may include any combination of elements, text, comments,
# processing instructions, and CDATA.
# (This example keeps things clean by controlling whitespace
# via a +context+ setting.)
#
#    xml_string = <<-EOT
#    <root>
#      <ele_0/>
#      text 0
#      <!--comment 0-->
#      <?target_0 pi_0?>
#      <![CDATA[cdata 0]]>
#      <ele_1/>
#      text 1
#      <!--comment 1-->
#      <?target_0 pi_1?>
#      <![CDATA[cdata 1]]>
#    </root>
#    EOT
#    context = {ignore_whitespace_nodes: :all, compress_whitespace: :all}
#    d = REXML::Document.new(xml_string, context)
#    root = d.root
#    root.children.size # => 10
#    root.each {|child| p "#{child.class}: #{child}" }
#
# Output:
#
#   "REXML::Element: <ele_0/>"
#   "REXML::Text: \n text 0\n "
#   "REXML::Comment: comment 0"
#   "REXML::Instruction: <?target_0 pi_0?>"
#   "REXML::CData: cdata 0"
#   "REXML::Element: <ele_1/>"
#   "REXML::Text: \n text 1\n "
#   "REXML::Comment: comment 1"
#   "REXML::Instruction: <?target_0 pi_1?>"
#   "REXML::CData: cdata 1"
#
# A child may be added using inherited methods
# Parent#insert_before or Parent#insert_after:
#
#   xml_string = '<root><a/><c/><d/></root>'
#   d = REXML::Document.new(xml_string)
#   root = d.root
#   c = d.root[1] # => <c/>
#   root.insert_before(c, REXML::Element.new('b'))
#   root.to_a # => [<a/>, <b/>, <c/>, <d/>]
#
# A child may be replaced using Parent#replace_child:
#
#   root.replace_child(c, REXML::Element.new('x'))
#   root.to_a # => [<a/>, <b/>, <x/>, <d/>]
#
# A child may be removed using Parent#delete:
#
#   x = root[2] # => <x/>
#   root.delete(x)
#   root.to_a # => [<a/>, <b/>, <d/>]
#
# === Siblings
#
# An element has zero or more siblings,
# which are the other children of the element's parent.
#
# In the example above, element +ele_1+ is between a CDATA sibling
# and a text sibling:
#
#   ele_1 = root[5]        # => <ele_1/>
#   ele_1.previous_sibling # => "cdata 0"
#   ele_1.next_sibling     # => "\n text 1\n "
#
# === \Attributes
#
# An element has zero or more named attributes.
#
# A new element has no attributes:
#
#   e = REXML::Element.new('foo')
#   e.attributes      # => {}
#
# Attributes may be added:
#
#   e.add_attribute('bar', 'baz')
#   e.add_attribute('bat', 'bam')
#   e.attributes.size # => 2
#   e['bar']          # => "baz"
#   e['bat']          # => "bam"
#
# An existing attribute may be modified:
#
#   e.add_attribute('bar', 'bad')
#   e.attributes.size # => 2
#   e['bar']          # => "bad"
#
# An existing attribute may be deleted:
#
#   e.delete_attribute('bar')
#   e.attributes.size # => 1
#   e['bar']          # => nil
#
# == What's Here
#
# To begin with, what's elsewhere?
#
# \Class \REXML::Element inherits from its ancestor classes:
#
# - REXML::Child
# - REXML::Parent
#
# \REXML::Element itself and its ancestors also include modules:
#
# - {Enumerable}[https://docs.ruby-lang.org/en/master/Enumerable.html]
# - REXML::Namespace
# - REXML::Node
# - REXML::XMLTokens
#
# === Methods for Creating an \Element
#
# ::new:: Returns a new empty element.
# #clone:: Returns a clone of another element.
#
# === Methods for Attributes
#
# {[attribute_name]}[#method-i-5B-5D]:: Returns an attribute value.
# #add_attribute:: Adds a new attribute.
# #add_attributes:: Adds multiple new attributes.
# #attribute:: Returns the attribute value for a given name and optional namespace.
# #delete_attribute:: Removes an attribute.
#
# === Methods for Children
#
# {[index]}[#method-i-5B-5D]:: Returns the child at the given offset.
# #add_element:: Adds an element as the last child.
# #delete_element:: Deletes a child element.
# #each_element:: Calls the given block with each child element.
# #each_element_with_attribute:: Calls the given block with each child element
#                                that meets given criteria,
#                                which can include the attribute name.
# #each_element_with_text:: Calls the given block with each child element
#                           that meets given criteria,
#                           which can include text.
# #get_elements:: Returns an array of element children that match a given xpath.
#
# === Methods for \Text Children
#
# #add_text:: Adds a text node to the element.
# #get_text:: Returns a text node that meets specified criteria.
# #text:: Returns the text string from the first node that meets specified criteria.
# #texts:: Returns an array of the text children of the element.
# #text=:: Adds, removes, or replaces the first text child of the element
#
# === Methods for Other Children
#
# #cdatas:: Returns an array of the cdata children of the element.
# #comments:: Returns an array of the comment children of the element.
# #instructions:: Returns an array of the instruction children of the element.
#
# === Methods for Namespaces
#
# #add_namespace:: Adds a namespace to the element.
# #delete_namespace:: Removes a namespace from the element.
# #namespace:: Returns the string namespace URI for the element.
# #namespaces:: Returns a hash of all defined namespaces in the element.
# #prefixes:: Returns an array of the string prefixes (names)
#             of all defined namespaces in the element
#
# === Methods for Querying
#
# #document:: Returns the document, if any, that the element belongs to.
# #root:: Returns the most distant element (not document) ancestor of the element.
# #root_node:: Returns the most distant ancestor of the element.
# #xpath:: Returns the string xpath to the element
#          relative to the most distant parent
# #has_attributes?:: Returns whether the element has attributes.
# #has_elements?:: Returns whether the element has elements.
# #has_text?:: Returns whether the element has text.
# #next_element:: Returns the next sibling that is an element.
# #previous_element:: Returns the previous sibling that is an element.
# #raw:: Returns whether raw mode is set for the element.
# #whitespace:: Returns whether whitespace is respected for the element.
# #ignore_whitespace_nodes:: Returns whether whitespace nodes
#                            are to be ignored for the element.
# #node_type:: Returns symbol <tt>:element</tt>.
#
# === One More Method
#
# #inspect:: Returns a string representation of the element.
#
# === Accessors
#
# #elements:: Returns the REXML::Elements object for the element.
# #attributes:: Returns the REXML::Attributes object for the element.
# #context:: Returns or sets the context hash for the element.
#
# source://rexml//lib/rexml/element.rb#271
class REXML::Element < ::REXML::Parent
  include ::REXML::XMLTokens
  include ::REXML::Namespace

  # :call-seq:
  #   Element.new(name = 'UNDEFINED', parent = nil, context = nil) -> new_element
  #   Element.new(element, parent = nil, context = nil) -> new_element
  #
  # Returns a new \REXML::Element object.
  #
  # When no arguments are given,
  # returns an element with name <tt>'UNDEFINED'</tt>:
  #
  #   e = REXML::Element.new # => <UNDEFINED/>
  #   e.class                # => REXML::Element
  #   e.name                 # => "UNDEFINED"
  #
  # When only argument +name+ is given,
  # returns an element of the given name:
  #
  #   REXML::Element.new('foo') # => <foo/>
  #
  # When only argument +element+ is given, it must be an \REXML::Element object;
  # returns a shallow copy of the given element:
  #
  #   e0 = REXML::Element.new('foo')
  #   e1 = REXML::Element.new(e0) # => <foo/>
  #
  # When argument +parent+ is also given, it must be an REXML::Parent object:
  #
  #   e = REXML::Element.new('foo', REXML::Parent.new)
  #   e.parent # => #<REXML::Parent @parent=nil, @children=[<foo/>]>
  #
  # When argument +context+ is also given, it must be a hash
  # representing the context for the element;
  # see {Element Context}[../doc/rexml/context_rdoc.html]:
  #
  #   e = REXML::Element.new('foo', nil, {raw: :all})
  #   e.context # => {:raw=>:all}
  #
  # @return [Element] a new instance of Element
  #
  # source://rexml//lib/rexml/element.rb#319
  def initialize(arg = T.unsafe(nil), parent = T.unsafe(nil), context = T.unsafe(nil)); end

  # :call-seq:
  #   [index] -> object
  #   [attr_name] -> attr_value
  #   [attr_sym] -> attr_value
  #
  # With integer argument +index+ given,
  # returns the child at offset +index+, or +nil+ if none:
  #
  #   d = REXML::Document.new '><root><a/>text<b/>more<c/></root>'
  #   root = d.root
  #   (0..root.size).each do |index|
  #     node = root[index]
  #     p "#{index}: #{node} (#{node.class})"
  #   end
  #
  # Output:
  #
  #   "0: <a/> (REXML::Element)"
  #   "1: text (REXML::Text)"
  #   "2: <b/> (REXML::Element)"
  #   "3: more (REXML::Text)"
  #   "4: <c/> (REXML::Element)"
  #   "5:  (NilClass)"
  #
  # With string argument +attr_name+ given,
  # returns the string value for the given attribute name if it exists,
  # otherwise +nil+:
  #
  #   d = REXML::Document.new('<root attr="value"></root>')
  #   root = d.root
  #   root['attr']   # => "value"
  #   root['nosuch'] # => nil
  #
  # With symbol argument +attr_sym+ given,
  # returns <tt>[attr_sym.to_s]</tt>:
  #
  #   root[:attr]   # => "value"
  #   root[:nosuch] # => nil
  #
  # source://rexml//lib/rexml/element.rb#1246
  def [](name_or_index); end

  # :call-seq:
  #   add_attribute(name, value) -> value
  #   add_attribute(attribute) -> attribute
  #
  # Adds an attribute to this element, overwriting any existing attribute
  # by the same name.
  #
  # With string argument +name+ and object +value+ are given,
  # adds the attribute created with that name and value:
  #
  #   e = REXML::Element.new
  #   e.add_attribute('attr', 'value') # => "value"
  #   e['attr'] # => "value"
  #   e.add_attribute('attr', 'VALUE') # => "VALUE"
  #   e['attr'] # => "VALUE"
  #
  # With only attribute object +attribute+ given,
  # adds the given attribute:
  #
  #   a = REXML::Attribute.new('attr', 'value')
  #   e.add_attribute(a) # => attr='value'
  #   e['attr'] # => "value"
  #   a = REXML::Attribute.new('attr', 'VALUE')
  #   e.add_attribute(a) # => attr='VALUE'
  #   e['attr'] # => "VALUE"
  #
  # source://rexml//lib/rexml/element.rb#1345
  def add_attribute(key, value = T.unsafe(nil)); end

  # :call-seq:
  #   add_attributes(hash) -> hash
  #   add_attributes(array)
  #
  # Adds zero or more attributes to the element;
  # returns the argument.
  #
  # If hash argument +hash+ is given,
  # each key must be a string;
  # adds each attribute created with the key/value pair:
  #
  #   e = REXML::Element.new
  #   h = {'foo' => 'bar', 'baz' => 'bat'}
  #   e.add_attributes(h)
  #
  # If argument +array+ is given,
  # each array member must be a 2-element array <tt>[name, value];
  # each name must be a string:
  #
  #   e = REXML::Element.new
  #   a = [['foo' => 'bar'], ['baz' => 'bat']]
  #   e.add_attributes(a)
  #
  # source://rexml//lib/rexml/element.rb#1376
  def add_attributes(hash); end

  # :call-seq:
  #   add_element(name, attributes = nil) -> new_element
  #   add_element(element, attributes = nil) -> element
  #
  # Adds a child element, optionally setting attributes
  # on the added element; returns the added element.
  #
  # With string argument +name+, creates a new element with that name
  # and adds the new element as a child:
  #
  #   e0 = REXML::Element.new('foo')
  #   e0.add_element('bar')
  #   e0[0] # => <bar/>
  #
  #
  # With argument +name+ and hash argument +attributes+,
  # sets attributes on the new element:
  #
  #   e0.add_element('baz', {'bat' => '0', 'bam' => '1'})
  #   e0[1] # => <baz bat='0' bam='1'/>
  #
  # With element argument +element+, adds that element as a child:
  #
  #   e0 = REXML::Element.new('foo')
  #   e1 = REXML::Element.new('bar')
  #   e0.add_element(e1)
  #   e0[0] # => <bar/>
  #
  # With argument +element+ and hash argument +attributes+,
  # sets attributes on the added element:
  #
  #   e0.add_element(e1, {'bat' => '0', 'bam' => '1'})
  #   e0[1] # => <bar bat='0' bam='1'/>
  #
  # source://rexml//lib/rexml/element.rb#732
  def add_element(element, attrs = T.unsafe(nil)); end

  # :call-seq:
  #   add_namespace(prefix, uri = nil) -> self
  #
  # Adds a namespace to the element; returns +self+.
  #
  # With the single argument +prefix+,
  # adds a namespace using the given +prefix+ and the namespace URI:
  #
  #   e = REXML::Element.new('foo')
  #   e.add_namespace('bar')
  #   e.namespaces # => {"xmlns"=>"bar"}
  #
  # With both arguments +prefix+ and +uri+ given,
  # adds a namespace using both arguments:
  #
  #   e.add_namespace('baz', 'bat')
  #   e.namespaces # => {"xmlns"=>"bar", "baz"=>"bat"}
  #
  # source://rexml//lib/rexml/element.rb#655
  def add_namespace(prefix, uri = T.unsafe(nil)); end

  # :call-seq:
  #   add_text(string) -> nil
  #   add_text(text_node) -> self
  #
  # Adds text to the element.
  #
  # When string argument +string+ is given, returns +nil+.
  #
  # If the element has no child text node,
  # creates a \REXML::Text object using the string,
  # honoring the current settings for whitespace and raw,
  # then adds that node to the element:
  #
  #   d = REXML::Document.new('<a><b/></a>')
  #   a = d.root
  #   a.add_text('foo')
  #   a.to_a # => [<b/>, "foo"]
  #
  # If the element has child text nodes,
  # appends the string to the _last_ text node:
  #
  #   d = REXML::Document.new('<a>foo<b/>bar</a>')
  #   a = d.root
  #   a.add_text('baz')
  #   a.to_a # => ["foo", <b/>, "barbaz"]
  #   a.add_text('baz')
  #   a.to_a # => ["foo", <b/>, "barbazbaz"]
  #
  # When text node argument +text_node+ is given,
  # appends the node as the last text node in the element;
  # returns +self+:
  #
  #   d = REXML::Document.new('<a>foo<b/>bar</a>')
  #   a = d.root
  #   a.add_text(REXML::Text.new('baz'))
  #   a.to_a # => ["foo", <b/>, "bar", "baz"]
  #   a.add_text(REXML::Text.new('baz'))
  #   a.to_a # => ["foo", <b/>, "bar", "baz", "baz"]
  #
  # source://rexml//lib/rexml/element.rb#1147
  def add_text(text); end

  # :call-seq:
  #   attribute(name, namespace = nil)
  #
  # Returns the string value for the given attribute name.
  #
  # With only argument +name+ given,
  # returns the value of the named attribute if it exists, otherwise +nil+:
  #
  #   xml_string = <<-EOT
  #     <root xmlns="ns0">
  #       <a xmlns="ns1" attr="value"></a>
  #       <b xmlns="ns2" attr="value"></b>
  #       <c attr="value"/>
  #    </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   root = d.root
  #   a = root[1] # => <a xmlns='ns1' attr='value'/>
  #   a.attribute('attr') # => attr='value'
  #   a.attribute('nope') # => nil
  #
  # With arguments +name+ and +namespace+ given,
  # returns the value of the named attribute if it exists, otherwise +nil+:
  #
  #   xml_string = "<root xmlns:a='a' a:x='a:x' x='x'/>"
  #   document = REXML::Document.new(xml_string)
  #   document.root.attribute("x")      # => x='x'
  #   document.root.attribute("x", "a") # => a:x='a:x'
  #
  # source://rexml//lib/rexml/element.rb#1287
  def attribute(name, namespace = T.unsafe(nil)); end

  # Mechanisms for accessing attributes and child elements of this
  # element.
  #
  # source://rexml//lib/rexml/element.rb#278
  def attributes; end

  # :call-seq:
  #   cdatas -> array_of_cdata_children
  #
  # Returns a frozen array of the REXML::CData children of the element:
  #
  #   xml_string = <<-EOT
  #     <root>
  #       <![CDATA[foo]]>
  #       <![CDATA[bar]]>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   cds = d.root.cdatas      # => ["foo", "bar"]
  #   cds.frozen?              # => true
  #   cds.map {|cd| cd.class } # => [REXML::CData, REXML::CData]
  #
  # source://rexml//lib/rexml/element.rb#1420
  def cdatas; end

  # :call-seq:
  #   clone -> new_element
  #
  # Returns a shallow copy of the element, containing the name and attributes,
  # but not the parent or children:
  #
  #   e = REXML::Element.new('foo')
  #   e.add_attributes({'bar' => 0, 'baz' => 1})
  #   e.clone # => <foo bar='0' baz='1'/>
  #
  # source://rexml//lib/rexml/element.rb#383
  def clone; end

  # :call-seq:
  #   comments -> array_of_comment_children
  #
  # Returns a frozen array of the REXML::Comment children of the element:
  #
  #   xml_string = <<-EOT
  #     <root>
  #       <!--foo-->
  #       <!--bar-->
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   cs = d.root.comments
  #   cs.frozen?            # => true
  #   cs.map {|c| c.class } # => [REXML::Comment, REXML::Comment]
  #   cs.map {|c| c.to_s }  # => ["foo", "bar"]
  #
  # source://rexml//lib/rexml/element.rb#1441
  def comments; end

  # The context holds information about the processing environment, such as
  # whitespace handling.
  #
  # source://rexml//lib/rexml/element.rb#281
  def context; end

  # The context holds information about the processing environment, such as
  # whitespace handling.
  #
  # source://rexml//lib/rexml/element.rb#281
  def context=(_arg0); end

  # :call-seq:
  #   delete_attribute(name) -> removed_attribute or nil
  #
  # Removes a named attribute if it exists;
  # returns the removed attribute if found, otherwise +nil+:
  #
  #   e = REXML::Element.new('foo')
  #   e.add_attribute('bar', 'baz')
  #   e.delete_attribute('bar') # => <bar/>
  #   e.delete_attribute('bar') # => nil
  #
  # source://rexml//lib/rexml/element.rb#1395
  def delete_attribute(key); end

  # :call-seq:
  #   delete_element(index) -> removed_element or nil
  #   delete_element(element) -> removed_element or nil
  #   delete_element(xpath) -> removed_element or nil
  #
  # Deletes a child element.
  #
  # When 1-based integer argument +index+ is given,
  # removes and returns the child element at that offset if it exists;
  # indexing does not include text nodes;
  # returns +nil+ if the element does not exist:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   a = d.root          # => <a> ... </>
  #   a.delete_element(1) # => <b/>
  #   a.delete_element(1) # => <c/>
  #   a.delete_element(1) # => nil
  #
  # When element argument +element+ is given,
  # removes and returns that child element if it exists,
  # otherwise returns +nil+:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   a = d.root          # => <a> ... </>
  #   c = a[2]            # => <c/>
  #   a.delete_element(c) # => <c/>
  #   a.delete_element(c) # => nil
  #
  # When xpath argument +xpath+ is given,
  # removes and returns the element at xpath if it exists,
  # otherwise returns +nil+:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   a = d.root              # => <a> ... </>
  #   a.delete_element('//c') # => <c/>
  #   a.delete_element('//c') # => nil
  #
  # source://rexml//lib/rexml/element.rb#778
  def delete_element(element); end

  # :call-seq:
  #   delete_namespace(namespace = 'xmlns') -> self
  #
  # Removes a namespace from the element.
  #
  # With no argument, removes the default namespace:
  #
  #   d = REXML::Document.new "<a xmlns:foo='bar' xmlns='twiddle'/>"
  #   d.to_s # => "<a xmlns:foo='bar' xmlns='twiddle'/>"
  #   d.root.delete_namespace # => <a xmlns:foo='bar'/>
  #   d.to_s # => "<a xmlns:foo='bar'/>"
  #
  # With argument +namespace+, removes the specified namespace:
  #
  #   d.root.delete_namespace('foo')
  #   d.to_s # => "<a/>"
  #
  # Does nothing if no such namespace is found:
  #
  #   d.root.delete_namespace('nosuch')
  #   d.to_s # => "<a/>"
  #
  # source://rexml//lib/rexml/element.rb#687
  def delete_namespace(namespace = T.unsafe(nil)); end

  # :call-seq:
  #   document -> document or nil
  #
  # If the element is part of a document, returns that document:
  #
  #   d = REXML::Document.new('<a><b><c/></b></a>')
  #   top_element = d.first
  #   child = top_element.first
  #   top_element.document == d # => true
  #   child.document == d       # => true
  #
  # If the element is not part of a document, returns +nil+:
  #
  #   REXML::Element.new.document # => nil
  #
  # For a document, returns +self+:
  #
  #   d.document == d           # => true
  #
  # Related: #root, #root_node.
  #
  # source://rexml//lib/rexml/element.rb#475
  def document; end

  # :call-seq:
  #   each_element {|e| ... }
  #
  # Calls the given block with each child element:
  #
  #   d = REXML::Document.new '<a><b>b</b><c>b</c><d>d</d><e/></a>'
  #   a = d.root
  #   a.each_element {|e| p e }
  #
  # Output:
  #
  #   <b> ... </>
  #   <c> ... </>
  #   <d> ... </>
  #   <e/>
  #
  # source://rexml//lib/rexml/element.rb#930
  def each_element(xpath = T.unsafe(nil), &block); end

  # :call-seq:
  #   each_element_with_attribute(attr_name, value = nil, max = 0, xpath = nil) {|e| ... }
  #
  # Calls the given block with each child element that meets given criteria.
  #
  # When only string argument +attr_name+ is given,
  # calls the block with each child element that has that attribute:
  #
  #   d = REXML::Document.new '<a><b id="1"/><c id="2"/><d id="1"/><e/></a>'
  #   a = d.root
  #   a.each_element_with_attribute('id') {|e| p e }
  #
  # Output:
  #
  #   <b id='1'/>
  #   <c id='2'/>
  #   <d id='1'/>
  #
  # With argument +attr_name+ and string argument +value+ given,
  # calls the block with each child element that has that attribute
  # with that value:
  #
  #   a.each_element_with_attribute('id', '1') {|e| p e }
  #
  # Output:
  #
  #   <b id='1'/>
  #   <d id='1'/>
  #
  # With arguments +attr_name+, +value+, and integer argument +max+ given,
  # calls the block with at most +max+ child elements:
  #
  #   a.each_element_with_attribute('id', '1', 1) {|e| p e }
  #
  # Output:
  #
  #   <b id='1'/>
  #
  # With all arguments given, including +xpath+,
  # calls the block with only those child elements
  # that meet the first three criteria,
  # and also match the given +xpath+:
  #
  #   a.each_element_with_attribute('id', '1', 2, '//d') {|e| p e }
  #
  # Output:
  #
  #   <d id='1'/>
  #
  # source://rexml//lib/rexml/element.rb#847
  def each_element_with_attribute(key, value = T.unsafe(nil), max = T.unsafe(nil), name = T.unsafe(nil), &block); end

  # :call-seq:
  #   each_element_with_text(text = nil, max = 0, xpath = nil) {|e| ... }
  #
  # Calls the given block with each child element that meets given criteria.
  #
  # With no arguments, calls the block with each child element that has text:
  #
  #   d = REXML::Document.new '<a><b>b</b><c>b</c><d>d</d><e/></a>'
  #   a = d.root
  #   a.each_element_with_text {|e| p e }
  #
  # Output:
  #
  #   <b> ... </>
  #   <c> ... </>
  #   <d> ... </>
  #
  # With the single string argument +text+,
  # calls the block with each element that has exactly that text:
  #
  #   a.each_element_with_text('b') {|e| p e }
  #
  # Output:
  #
  #   <b> ... </>
  #   <c> ... </>
  #
  # With argument +text+ and integer argument +max+,
  # calls the block with at most +max+ elements:
  #
  #   a.each_element_with_text('b', 1) {|e| p e }
  #
  # Output:
  #
  #   <b> ... </>
  #
  # With all arguments given, including +xpath+,
  # calls the block with only those child elements
  # that meet the first two criteria,
  # and also match the given +xpath+:
  #
  #   a.each_element_with_text('b', 2, '//c') {|e| p e }
  #
  # Output:
  #
  #   <c> ... </>
  #
  # source://rexml//lib/rexml/element.rb#904
  def each_element_with_text(text = T.unsafe(nil), max = T.unsafe(nil), name = T.unsafe(nil), &block); end

  # Mechanisms for accessing attributes and child elements of this
  # element.
  #
  # source://rexml//lib/rexml/element.rb#278
  def elements; end

  # :call-seq:
  #   get_elements(xpath)
  #
  # Returns an array of the elements that match the given +xpath+:
  #
  #   xml_string = <<-EOT
  #   <root>
  #     <a level='1'>
  #       <a level='2'/>
  #     </a>
  #   </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   d.root.get_elements('//a') # => [<a level='1'> ... </>, <a level='2'/>]
  #
  # source://rexml//lib/rexml/element.rb#949
  def get_elements(xpath); end

  # :call-seq:
  #   get_text(xpath = nil) -> text_node or nil
  #
  # Returns the first text node child in a specified element, if it exists,
  # +nil+ otherwise.
  #
  # With no argument, returns the first text node from +self+:
  #
  #   d = REXML::Document.new "<p>some text <b>this is bold!</b> more text</p>"
  #   d.root.get_text.class # => REXML::Text
  #   d.root.get_text       # => "some text "
  #
  # With argument +xpath+, returns the first text node from the element
  # that matches +xpath+:
  #
  #   d.root.get_text(1) # => "this is bold!"
  #
  # source://rexml//lib/rexml/element.rb#1053
  def get_text(path = T.unsafe(nil)); end

  # :call-seq:
  #   has_attributes? -> true or false
  #
  # Returns +true+ if the element has attributes, +false+ otherwise:
  #
  #   d = REXML::Document.new('<root><a attr="val"/><b/></root>')
  #   a, b = *d.root
  #   a.has_attributes? # => true
  #   b.has_attributes? # => false
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/element.rb#1315
  def has_attributes?; end

  # :call-seq:
  #   has_elements?
  #
  # Returns +true+ if the element has one or more element children,
  # +false+ otherwise:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   a = d.root              # => <a> ... </>
  #   a.has_elements? # => true
  #   b = a[0]        # => <b/>
  #   b.has_elements? # => false
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/element.rb#794
  def has_elements?; end

  # :call-seq:
  #   has_text? -> true or false
  #
  # Returns +true+ if the element has one or more text noded,
  # +false+ otherwise:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   a = d.root
  #   a.has_text? # => true
  #   b = a[0]
  #   b.has_text? # => false
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/element.rb#1002
  def has_text?; end

  # :call-seq:
  #   ignore_whitespace_nodes
  #
  # Returns +true+ if whitespace nodes are ignored for the element.
  #
  # See {Element Context}[../doc/rexml/context_rdoc.html].
  #
  # source://rexml//lib/rexml/element.rb#513
  def ignore_whitespace_nodes; end

  # :call-seq:
  #   inspect -> string
  #
  # Returns a string representation of the element.
  #
  # For an element with no attributes and no children, shows the element name:
  #
  #   REXML::Element.new.inspect # => "<UNDEFINED/>"
  #
  # Shows attributes, if any:
  #
  #   e = REXML::Element.new('foo')
  #   e.add_attributes({'bar' => 0, 'baz' => 1})
  #   e.inspect # => "<foo bar='0' baz='1'/>"
  #
  # Shows an ellipsis (<tt>...</tt>), if there are child elements:
  #
  #   e.add_element(REXML::Element.new('bar'))
  #   e.add_element(REXML::Element.new('baz'))
  #   e.inspect # => "<foo bar='0' baz='1'> ... </>"
  #
  # source://rexml//lib/rexml/element.rb#358
  def inspect; end

  # :call-seq:
  #   instructions -> array_of_instruction_children
  #
  # Returns a frozen array of the REXML::Instruction children of the element:
  #
  #   xml_string = <<-EOT
  #     <root>
  #       <?target0 foo?>
  #       <?target1 bar?>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   is = d.root.instructions
  #   is.frozen?             # => true
  #   is.map {|i| i.class } # => [REXML::Instruction, REXML::Instruction]
  #   is.map {|i| i.to_s }  # => ["<?target0 foo?>", "<?target1 bar?>"]
  #
  # source://rexml//lib/rexml/element.rb#1462
  def instructions; end

  # :call-seq:
  #   namespace(prefix = nil) -> string_uri or nil
  #
  # Returns the string namespace URI for the element,
  # possibly deriving from one of its ancestors.
  #
  #   xml_string = <<-EOT
  #     <root>
  #        <a xmlns='1' xmlns:y='2'>
  #          <b/>
  #          <c xmlns:z='3'/>
  #        </a>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   b = d.elements['//b']
  #   b.namespace      # => "1"
  #   b.namespace('y') # => "2"
  #   b.namespace('nosuch') # => nil
  #
  # source://rexml//lib/rexml/element.rb#618
  def namespace(prefix = T.unsafe(nil)); end

  # :call-seq:
  #    namespaces -> array_of_namespace_names
  #
  # Returns a hash of all defined namespaces
  # in the element and its ancestors:
  #
  #   xml_string = <<-EOT
  #     <root>
  #        <a xmlns:x='1' xmlns:y='2'>
  #          <b/>
  #          <c xmlns:z='3'/>
  #        </a>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string)
  #   d.elements['//a'].namespaces # => {"x"=>"1", "y"=>"2"}
  #   d.elements['//b'].namespaces # => {"x"=>"1", "y"=>"2"}
  #   d.elements['//c'].namespaces # => {"x"=>"1", "y"=>"2", "z"=>"3"}
  #
  # source://rexml//lib/rexml/element.rb#591
  def namespaces; end

  # :call-seq:
  #   next_element
  #
  # Returns the next sibling that is an element if it exists,
  # +niL+ otherwise:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   d.root.elements['b'].next_element #-> <c/>
  #   d.root.elements['c'].next_element #-> nil
  #
  # source://rexml//lib/rexml/element.rb#963
  def next_element; end

  # :call-seq:
  #   node_type -> :element
  #
  # Returns symbol <tt>:element</tt>:
  #
  #   d = REXML::Document.new('<a/>')
  #   a = d.root  # => <a/>
  #   a.node_type # => :element
  #
  # source://rexml//lib/rexml/element.rb#1168
  def node_type; end

  # :call-seq:
  #   prefixes -> array_of_namespace_prefixes
  #
  # Returns an array of the string prefixes (names) of all defined namespaces
  # in the element and its ancestors:
  #
  #   xml_string = <<-EOT
  #     <root>
  #        <a xmlns:x='1' xmlns:y='2'>
  #          <b/>
  #          <c xmlns:z='3'/>
  #        </a>
  #     </root>
  #   EOT
  #   d = REXML::Document.new(xml_string, {compress_whitespace: :all})
  #   d.elements['//a'].prefixes # => ["x", "y"]
  #   d.elements['//b'].prefixes # => ["x", "y"]
  #   d.elements['//c'].prefixes # => ["x", "y", "z"]
  #
  # source://rexml//lib/rexml/element.rb#565
  def prefixes; end

  # :call-seq:
  #   previous_element
  #
  # Returns the previous sibling that is an element if it exists,
  # +niL+ otherwise:
  #
  #   d = REXML::Document.new '<a><b/>text<c/></a>'
  #   d.root.elements['c'].previous_element #-> <b/>
  #   d.root.elements['b'].previous_element #-> nil
  #
  # source://rexml//lib/rexml/element.rb#979
  def previous_element; end

  # :call-seq:
  #   raw
  #
  # Returns +true+ if raw mode is set for the element.
  #
  # See {Element Context}[../doc/rexml/context_rdoc.html].
  #
  # The evaluation is tested against +expanded_name+, and so is namespace
  # sensitive.
  #
  # source://rexml//lib/rexml/element.rb#533
  def raw; end

  # :call-seq:
  #   root -> element
  #
  # Returns the most distant _element_ (not document) ancestor of the element:
  #
  #   d = REXML::Document.new('<a><b><c/></b></a>')
  #   top_element = d.first
  #   child = top_element.first
  #   top_element.root == top_element # => true
  #   child.root == top_element       # => true
  #
  # For a document, returns the topmost element:
  #
  #   d.root == top_element # => true
  #
  # Related: #root_node, #document.
  #
  # source://rexml//lib/rexml/element.rb#443
  def root; end

  # :call-seq:
  #   root_node -> document or element
  #
  # Returns the most distant ancestor of +self+.
  #
  # When the element is part of a document,
  # returns the root node of the document.
  # Note that the root node is different from the document element;
  # in this example +a+ is document element and the root node is its parent:
  #
  #   d = REXML::Document.new('<a><b><c/></b></a>')
  #   top_element = d.first      # => <a> ... </>
  #   child = top_element.first  # => <b> ... </>
  #   d.root_node == d           # => true
  #   top_element.root_node == d # => true
  #   child.root_node == d       # => true
  #
  # When the element is not part of a document, but does have ancestor elements,
  # returns the most distant ancestor element:
  #
  #   e0 = REXML::Element.new('foo')
  #   e1 = REXML::Element.new('bar')
  #   e1.parent = e0
  #   e2 = REXML::Element.new('baz')
  #   e2.parent = e1
  #   e2.root_node == e0 # => true
  #
  # When the element has no ancestor elements,
  # returns +self+:
  #
  #   e = REXML::Element.new('foo')
  #   e.root_node == e # => true
  #
  # Related: #root, #document.
  #
  # source://rexml//lib/rexml/element.rb#422
  def root_node; end

  # :call-seq:
  #   text(xpath = nil) -> text_string or nil
  #
  # Returns the text string from the first text node child
  # in a specified element, if it exists, +nil+ otherwise.
  #
  # With no argument, returns the text from the first text node in +self+:
  #
  #   d = REXML::Document.new "<p>some text <b>this is bold!</b> more text</p>"
  #   d.root.text.class # => String
  #   d.root.text       # => "some text "
  #
  # With argument +xpath+, returns text from the first text node
  # in the element that matches +xpath+:
  #
  #   d.root.text(1) # => "this is bold!"
  #
  # Note that an element may have multiple text nodes,
  # possibly separated by other non-text children, as above.
  # Even so, the returned value is the string text from the first such node.
  #
  # Note also that the text note is retrieved by method get_text,
  # and so is always normalized text.
  #
  # source://rexml//lib/rexml/element.rb#1030
  def text(path = T.unsafe(nil)); end

  # :call-seq:
  #   text = string -> string
  #   text = nil -> nil
  #
  # Adds, replaces, or removes the first text node child in the element.
  #
  # With string argument +string+,
  # creates a new \REXML::Text node containing that string,
  # honoring the current settings for whitespace and row,
  # then places the node as the first text child in the element;
  # returns +string+.
  #
  # If the element has no text child, the text node is added:
  #
  #   d = REXML::Document.new '<a><b/></a>'
  #   d.root.text = 'foo' #-> '<a><b/>foo</a>'
  #
  # If the element has a text child, it is replaced:
  #
  #   d.root.text = 'bar' #-> '<a><b/>bar</a>'
  #
  # With argument +nil+, removes the first text child:
  #
  #   d.root.text = nil   #-> '<a><b/><c/></a>'
  #
  # source://rexml//lib/rexml/element.rb#1089
  def text=(text); end

  # :call-seq:
  #   texts -> array_of_text_children
  #
  # Returns a frozen array of the REXML::Text children of the element:
  #
  #   xml_string = '<root><a/>text<b/>more<c/></root>'
  #   d = REXML::Document.new(xml_string)
  #   ts = d.root.texts
  #   ts.frozen?            # => true
  #   ts.map {|t| t.class } # => [REXML::Text, REXML::Text]
  #   ts.map {|t| t.to_s }  # => ["text", "more"]
  #
  # source://rexml//lib/rexml/element.rb#1478
  def texts; end

  # :call-seq:
  #   whitespace
  #
  # Returns +true+ if whitespace is respected for this element,
  # +false+ otherwise.
  #
  # See {Element Context}[../doc/rexml/context_rdoc.html].
  #
  # The evaluation is tested against the element's +expanded_name+,
  # and so is namespace-sensitive.
  #
  # source://rexml//lib/rexml/element.rb#490
  def whitespace; end

  # == DEPRECATED
  # See REXML::Formatters
  #
  # Writes out this element, and recursively, all children.
  # output::
  #     output an object which supports '<< string'; this is where the
  #   document will be written.
  # indent::
  #   An integer.  If -1, no indenting will be used; otherwise, the
  #   indentation will be this number of spaces, and children will be
  #   indented an additional amount.  Defaults to -1
  # transitive::
  #   If transitive is true and indent is >= 0, then the output will be
  #   pretty-printed in such a way that the added whitespace does not affect
  #   the parse tree of the document
  # ie_hack::
  #   This hack inserts a space before the /> on empty tags to address
  #   a limitation of Internet Explorer.  Defaults to false
  #
  #  out = ''
  #  doc.write( out )     #-> doc is written to the string 'out'
  #  doc.write( $stdout ) #-> doc written to the console
  #
  # source://rexml//lib/rexml/element.rb#1504
  def write(output = T.unsafe(nil), indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end

  # :call-seq:
  #   xpath -> string_xpath
  #
  # Returns the string xpath to the element
  # relative to the most distant parent:
  #
  #   d = REXML::Document.new('<a><b><c/></b></a>')
  #   a = d.root # => <a> ... </>
  #   b = a[0]   # => <b> ... </>
  #   c = b[0]   # => <c/>
  #   d.xpath    # => ""
  #   a.xpath    # => "/a"
  #   b.xpath    # => "/a/b"
  #   c.xpath    # => "/a/b/c"
  #
  # If there is no parent, returns the expanded name of the element:
  #
  #   e = REXML::Element.new('foo')
  #   e.xpath    # => "foo"
  #
  # source://rexml//lib/rexml/element.rb#1192
  def xpath; end

  private

  # source://rexml//lib/rexml/element.rb#1521
  def __to_xpath_helper(node); end

  # A private helper method
  #
  # source://rexml//lib/rexml/element.rb#1536
  def each_with_something(test, max = T.unsafe(nil), name = T.unsafe(nil)); end
end

# source://rexml//lib/rexml/doctype.rb#261
class REXML::ElementDecl < ::REXML::Declaration
  # @return [ElementDecl] a new instance of ElementDecl
  #
  # source://rexml//lib/rexml/doctype.rb#262
  def initialize(src); end
end

# A class which provides filtering of children for Elements, and
# XPath search support.  You are expected to only encounter this class as
# the <tt>element.elements</tt> object.  Therefore, you are
# _not_ expected to instantiate this yourself.
#
#   xml_string = <<-EOT
#   <?xml version="1.0" encoding="UTF-8"?>
#   <bookstore>
#     <book category="cooking">
#       <title lang="en">Everyday Italian</title>
#       <author>Giada De Laurentiis</author>
#       <year>2005</year>
#       <price>30.00</price>
#     </book>
#     <book category="children">
#       <title lang="en">Harry Potter</title>
#       <author>J K. Rowling</author>
#       <year>2005</year>
#       <price>29.99</price>
#     </book>
#     <book category="web">
#       <title lang="en">XQuery Kick Start</title>
#       <author>James McGovern</author>
#       <author>Per Bothner</author>
#       <author>Kurt Cagle</author>
#       <author>James Linn</author>
#       <author>Vaidyanathan Nagarajan</author>
#       <year>2003</year>
#       <price>49.99</price>
#     </book>
#     <book category="web" cover="paperback">
#       <title lang="en">Learning XML</title>
#       <author>Erik T. Ray</author>
#       <year>2003</year>
#       <price>39.95</price>
#     </book>
#   </bookstore>
#   EOT
#   d = REXML::Document.new(xml_string)
#   elements = d.root.elements
#   elements # => #<REXML::Elements @element=<bookstore> ... </>>
#
# source://rexml//lib/rexml/element.rb#1591
class REXML::Elements
  include ::Enumerable

  # :call-seq:
  #   new(parent) -> new_elements_object
  #
  # Returns a new \Elements object with the given +parent+.
  # Does _not_ assign <tt>parent.elements = self</tt>:
  #
  #   d = REXML::Document.new(xml_string)
  #   eles = REXML::Elements.new(d.root)
  #   eles # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles == d.root.elements # => false
  #
  # @return [Elements] a new instance of Elements
  #
  # source://rexml//lib/rexml/element.rb#1604
  def initialize(parent); end

  # :call-seq:
  #   add -> new_element
  #   add(name) -> new_element
  #   add(element) -> element
  #
  # Adds an element; returns the element added.
  #
  # With no argument, creates and adds a new element.
  # The new element has:
  #
  # - No name.
  # - \Parent from the \Elements object.
  # - Context from the that parent.
  #
  # Example:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   parent = elements.parent     # => <bookstore> ... </>
  #   parent.context = {raw: :all}
  #   elements.size                # => 4
  #   new_element = elements.add   # => </>
  #   elements.size                # => 5
  #   new_element.name             # => nil
  #   new_element.parent           # => <bookstore> ... </>
  #   new_element.context          # => {:raw=>:all}
  #
  # With string argument +name+, creates and adds a new element.
  # The new element has:
  #
  # - Name +name+.
  # - \Parent from the \Elements object.
  # - Context from the that parent.
  #
  # Example:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   parent = elements.parent          # => <bookstore> ... </>
  #   parent.context = {raw: :all}
  #   elements.size                     # => 4
  #   new_element = elements.add('foo') # => <foo/>
  #   elements.size                     # => 5
  #   new_element.name                  # => "foo"
  #   new_element.parent                # => <bookstore> ... </>
  #   new_element.context               # => {:raw=>:all}
  #
  # With argument +element+,
  # creates and adds a clone of the given +element+.
  # The new element has name, parent, and context from the given +element+.
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.size                 # => 4
  #   e0 = REXML::Element.new('foo')
  #   e1 = REXML::Element.new('bar', e0, {raw: :all})
  #   element = elements.add(e1) # => <bar/>
  #   elements.size                 # => 5
  #   element.name                  # => "bar"
  #   element.parent                # => <bookstore> ... </>
  #   element.context               # => {:raw=>:all}
  #
  # source://rexml//lib/rexml/element.rb#1921
  def <<(element = T.unsafe(nil)); end

  # :call-seq:
  #   elements[index] -> element or nil
  #   elements[xpath] -> element or nil
  #   elements[n, name] -> element or nil
  #
  # Returns the first \Element object selected by the arguments,
  # if any found, or +nil+ if none found.
  #
  # Notes:
  # - The +index+ is 1-based, not 0-based, so that:
  #   - The first element has index <tt>1</tt>
  #   - The _nth_ element has index +n+.
  # - The selection ignores non-\Element nodes.
  #
  # When the single argument +index+ is given,
  # returns the element given by the index, if any; otherwise, +nil+:
  #
  #   d = REXML::Document.new(xml_string)
  #   eles = d.root.elements
  #   eles # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles[1] # => <book category='cooking'> ... </>
  #   eles.size # => 4
  #   eles[4] # => <book category='web' cover='paperback'> ... </>
  #   eles[5] # => nil
  #
  # The node at this index is not an \Element, and so is not returned:
  #
  #   eles = d.root.first.first # => <title lang='en'> ... </>
  #   eles.to_a # => ["Everyday Italian"]
  #   eles[1] # => nil
  #
  # When the single argument +xpath+ is given,
  # returns the first element found via that +xpath+, if any; otherwise, +nil+:
  #
  #   eles = d.root.elements # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles['/bookstore']                    # => <bookstore> ... </>
  #   eles['//book']                        # => <book category='cooking'> ... </>
  #   eles['//book [@category="children"]'] # => <book category='children'> ... </>
  #   eles['/nosuch']                       # => nil
  #   eles['//nosuch']                      # => nil
  #   eles['//book [@category="nosuch"]']   # => nil
  #   eles['.']                             # => <bookstore> ... </>
  #   eles['..'].class                      # => REXML::Document
  #
  # With arguments +n+ and +name+ given,
  # returns the _nth_ found element that has the given +name+,
  # or +nil+ if there is no such _nth_ element:
  #
  #   eles = d.root.elements # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles[1, 'book'] # => <book category='cooking'> ... </>
  #   eles[4, 'book'] # => <book category='web' cover='paperback'> ... </>
  #   eles[5, 'book'] # => nil
  #
  # source://rexml//lib/rexml/element.rb#1676
  def [](index, name = T.unsafe(nil)); end

  # :call-seq:
  #  elements[] = index, replacement_element -> replacement_element or nil
  #
  # Replaces or adds an element.
  #
  # When <tt>eles[index]</tt> exists, replaces it with +replacement_element+
  # and returns +replacement_element+:
  #
  #   d = REXML::Document.new(xml_string)
  #   eles = d.root.elements # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles[1] # => <book category='cooking'> ... </>
  #   eles[1] = REXML::Element.new('foo')
  #   eles[1] # => <foo/>
  #
  # Does nothing (or raises an exception)
  # if +replacement_element+ is not an \Element:
  #   eles[2] # => <book category='web' cover='paperback'> ... </>
  #   eles[2] = REXML::Text.new('bar')
  #   eles[2] # => <book category='web' cover='paperback'> ... </>
  #
  # When <tt>eles[index]</tt> does not exist,
  # adds +replacement_element+ to the element and returns
  #
  #   d = REXML::Document.new(xml_string)
  #   eles = d.root.elements # => #<REXML::Elements @element=<bookstore> ... </>>
  #   eles.size # => 4
  #   eles[50] = REXML::Element.new('foo') # => <foo/>
  #   eles.size # => 5
  #   eles[5] # => <foo/>
  #
  # Does nothing (or raises an exception)
  # if +replacement_element+ is not an \Element:
  #
  #   eles[50] = REXML::Text.new('bar') # => "bar"
  #   eles.size # => 5
  #
  # source://rexml//lib/rexml/element.rb#1731
  def []=(index, element); end

  # :call-seq:
  #   add -> new_element
  #   add(name) -> new_element
  #   add(element) -> element
  #
  # Adds an element; returns the element added.
  #
  # With no argument, creates and adds a new element.
  # The new element has:
  #
  # - No name.
  # - \Parent from the \Elements object.
  # - Context from the that parent.
  #
  # Example:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   parent = elements.parent     # => <bookstore> ... </>
  #   parent.context = {raw: :all}
  #   elements.size                # => 4
  #   new_element = elements.add   # => </>
  #   elements.size                # => 5
  #   new_element.name             # => nil
  #   new_element.parent           # => <bookstore> ... </>
  #   new_element.context          # => {:raw=>:all}
  #
  # With string argument +name+, creates and adds a new element.
  # The new element has:
  #
  # - Name +name+.
  # - \Parent from the \Elements object.
  # - Context from the that parent.
  #
  # Example:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   parent = elements.parent          # => <bookstore> ... </>
  #   parent.context = {raw: :all}
  #   elements.size                     # => 4
  #   new_element = elements.add('foo') # => <foo/>
  #   elements.size                     # => 5
  #   new_element.name                  # => "foo"
  #   new_element.parent                # => <bookstore> ... </>
  #   new_element.context               # => {:raw=>:all}
  #
  # With argument +element+,
  # creates and adds a clone of the given +element+.
  # The new element has name, parent, and context from the given +element+.
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.size                 # => 4
  #   e0 = REXML::Element.new('foo')
  #   e1 = REXML::Element.new('bar', e0, {raw: :all})
  #   element = elements.add(e1) # => <bar/>
  #   elements.size                 # => 5
  #   element.name                  # => "bar"
  #   element.parent                # => <bookstore> ... </>
  #   element.context               # => {:raw=>:all}
  #
  # source://rexml//lib/rexml/element.rb#1921
  def add(element = T.unsafe(nil)); end

  # :call-seq:
  #   collect(xpath = nil) {|element| ... } -> array
  #
  # Iterates over the elements; returns the array of block return values.
  #
  # With no argument, iterates over all elements:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.collect {|element| element.size } # => [9, 9, 17, 9]
  #
  # With argument +xpath+, iterates over elements that match
  # the given +xpath+:
  #
  #   xpath = '//book [@category="web"]'
  #   elements.collect(xpath) {|element| element.size } # => [17, 9]
  #
  # source://rexml//lib/rexml/element.rb#1984
  def collect(xpath = T.unsafe(nil)); end

  # :call-seq:
  #   delete(index) -> removed_element or nil
  #   delete(element) -> removed_element or nil
  #   delete(xpath) -> removed_element or nil
  #
  # Removes an element; returns the removed element, or +nil+ if none removed.
  #
  # With integer argument +index+ given,
  # removes the child element at that offset:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.size # => 4
  #   elements[2] # => <book category='children'> ... </>
  #   elements.delete(2) # => <book category='children'> ... </>
  #   elements.size # => 3
  #   elements[2] # => <book category='web'> ... </>
  #   elements.delete(50) # => nil
  #
  # With element argument +element+ given,
  # removes that child element:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   ele_1, ele_2, ele_3, ele_4 = *elements
  #   elements.size # => 4
  #   elements[2] # => <book category='children'> ... </>
  #   elements.delete(ele_2) # => <book category='children'> ... </>
  #   elements.size # => 3
  #   elements[2] # => <book category='web'> ... </>
  #   elements.delete(ele_2) # => nil
  #
  # With string argument +xpath+ given,
  # removes the first element found via that xpath:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.delete('//book') # => <book category='cooking'> ... </>
  #   elements.delete('//book [@category="children"]') # => <book category='children'> ... </>
  #   elements.delete('//nosuch') # => nil
  #
  # source://rexml//lib/rexml/element.rb#1821
  def delete(element); end

  # :call-seq:
  #   delete_all(xpath)
  #
  # Removes all elements found via the given +xpath+;
  # returns the array of removed elements, if any, else +nil+.
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.size # => 4
  #   deleted_elements = elements.delete_all('//book [@category="web"]')
  #   deleted_elements.size # => 2
  #   elements.size # => 2
  #   deleted_elements = elements.delete_all('//book')
  #   deleted_elements.size # => 2
  #   elements.size # => 0
  #   elements.delete_all('//book') # => []
  #
  # source://rexml//lib/rexml/element.rb#1847
  def delete_all(xpath); end

  # :call-seq:
  #    each(xpath = nil) {|element| ... } -> self
  #
  # Iterates over the elements.
  #
  # With no argument, calls the block with each element:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.each {|element| p element }
  #
  # Output:
  #
  #   <book category='cooking'> ... </>
  #   <book category='children'> ... </>
  #   <book category='web'> ... </>
  #   <book category='web' cover='paperback'> ... </>
  #
  # With argument +xpath+, calls the block with each element
  # that matches the given +xpath+:
  #
  #   elements.each('//book [@category="web"]') {|element| p element }
  #
  # Output:
  #
  #   <book category='web'> ... </>
  #   <book category='web' cover='paperback'> ... </>
  #
  # source://rexml//lib/rexml/element.rb#1963
  def each(xpath = T.unsafe(nil)); end

  # :call-seq:
  #   empty? -> true or false
  #
  # Returns +true+ if there are no children, +false+ otherwise.
  #
  #   d = REXML::Document.new('')
  #   d.elements.empty? # => true
  #   d = REXML::Document.new(xml_string)
  #   d.elements.empty? # => false
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/element.rb#1751
  def empty?; end

  # :call-seq:
  #   index(element)
  #
  # Returns the 1-based index of the given +element+, if found;
  # otherwise, returns -1:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   ele_1, ele_2, ele_3, ele_4 = *elements
  #   elements.index(ele_4) # => 4
  #   elements.delete(ele_3)
  #   elements.index(ele_4) # => 3
  #   elements.index(ele_3) # => -1
  #
  # source://rexml//lib/rexml/element.rb#1769
  def index(element); end

  # :call-seq:
  #   inject(xpath = nil, initial = nil) -> object
  #
  # Calls the block with elements; returns the last block return value.
  #
  # With no argument, iterates over the elements, calling the block
  # <tt>elements.size - 1</tt> times.
  #
  # - The first call passes the first and second elements.
  # - The second call passes the first block return value and the third element.
  # - The third call passes the second block return value and the fourth element.
  # - And so on.
  #
  # In this example, the block returns the passed element,
  # which is then the object argument to the next call:
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = d.root.elements
  #   elements.inject do |object, element|
  #     p [elements.index(object), elements.index(element)]
  #     element
  #   end
  #
  # Output:
  #
  #   [1, 2]
  #   [2, 3]
  #   [3, 4]
  #
  # With the single argument +xpath+, calls the block only with
  # elements matching that xpath:
  #
  #   elements.inject('//book [@category="web"]') do |object, element|
  #     p [elements.index(object), elements.index(element)]
  #     element
  #   end
  #
  # Output:
  #
  #  [3, 4]
  #
  # With argument +xpath+ given as +nil+
  # and argument +initial+ also given,
  # calls the block once for each element.
  #
  # - The first call passes the +initial+ and the first element.
  # - The second call passes the first block return value and the second element.
  # - The third call passes the second block return value and the third element.
  # - And so on.
  #
  # In this example, the first object index is <tt>-1</tt>
  #
  #   elements.inject(nil, 'Initial') do |object, element|
  #     p [elements.index(object), elements.index(element)]
  #     element
  #   end
  #
  # Output:
  #
  #   [-1, 1]
  #   [1, 2]
  #   [2, 3]
  #   [3, 4]
  #
  # In this form the passed object can be used as an accumulator:
  #
  #   elements.inject(nil, 0) do |total, element|
  #     total += element.size
  #   end # => 44
  #
  # With both arguments +xpath+ and +initial+ are given,
  # calls the block only with elements matching that xpath:
  #
  #   elements.inject('//book [@category="web"]', 0) do |total, element|
  #     total += element.size
  #   end # => 26
  #
  # source://rexml//lib/rexml/element.rb#2069
  def inject(xpath = T.unsafe(nil), initial = T.unsafe(nil)); end

  # :call-seq:
  #   parent
  #
  # Returns the parent element cited in creating the \Elements object.
  # This element is also the default starting point for searching
  # in the \Elements object.
  #
  #   d = REXML::Document.new(xml_string)
  #   elements = REXML::Elements.new(d.root)
  #   elements.parent == d.root # => true
  #
  # source://rexml//lib/rexml/element.rb#1619
  def parent; end

  # :call-seq:
  #   size -> integer
  #
  # Returns the count of \Element children:
  #
  #   d = REXML::Document.new '<a>sean<b/>elliott<b/>russell<b/></a>'
  #   d.root.elements.size # => 3 # Three elements.
  #   d.root.size          # => 6 # Three elements plus three text nodes..
  #
  # source://rexml//lib/rexml/element.rb#2093
  def size; end

  # :call-seq:
  #   to_a(xpath = nil) -> array_of_elements
  #
  # Returns an array of element children (not including non-element children).
  #
  # With no argument, returns an array of all element children:
  #
  #   d = REXML::Document.new '<a>sean<b/>elliott<c/></a>'
  #   elements = d.root.elements
  #   elements.to_a # => [<b/>, <c/>]               # Omits non-element children.
  #   children = d.root.children
  #   children # => ["sean", <b/>, "elliott", <c/>] # Includes non-element children.
  #
  # With argument +xpath+, returns an array of element children
  # that match the xpath:
  #
  #   elements.to_a('//c') # => [<c/>]
  #
  # source://rexml//lib/rexml/element.rb#2117
  def to_a(xpath = T.unsafe(nil)); end

  private

  # Private helper class.  Removes quotes from quoted strings
  #
  # source://rexml//lib/rexml/element.rb#2125
  def literalize(name); end
end

# source://rexml//lib/rexml/encoding.rb#4
module REXML::Encoding
  # source://rexml//lib/rexml/encoding.rb#29
  def decode(string); end

  # source://rexml//lib/rexml/encoding.rb#25
  def encode(string); end

  # ID ---> Encoding name
  #
  # source://rexml//lib/rexml/encoding.rb#6
  def encoding; end

  # source://rexml//lib/rexml/encoding.rb#7
  def encoding=(encoding); end

  private

  # source://rexml//lib/rexml/encoding.rb#34
  def find_encoding(name); end
end

# source://rexml//lib/rexml/entity.rb#7
class REXML::Entity < ::REXML::Child
  include ::REXML::XMLTokens

  # Create a new entity.  Simple entities can be constructed by passing a
  # name, value to the constructor; this creates a generic, plain entity
  # reference. For anything more complicated, you have to pass a Source to
  # the constructor with the entity definition, or use the accessor methods.
  # +WARNING+: There is no validation of entity state except when the entity
  # is read from a stream.  If you start poking around with the accessors,
  # you can easily create a non-conformant Entity.
  #
  #  e = Entity.new( 'amp', '&' )
  #
  # @return [Entity] a new instance of Entity
  #
  # source://rexml//lib/rexml/entity.rb#34
  def initialize(stream, value = T.unsafe(nil), parent = T.unsafe(nil), reference = T.unsafe(nil)); end

  # Returns the value of attribute external.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def external; end

  # Returns the value of attribute name.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def name; end

  # Returns the value of attribute ndata.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def ndata; end

  # Returns the value of this entity unprocessed -- raw.  This is the
  # normalized value; that is, with all %ent; and &ent; entities intact
  #
  # source://rexml//lib/rexml/entity.rb#86
  def normalized; end

  # Returns the value of attribute pubid.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def pubid; end

  # Returns the value of attribute ref.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def ref; end

  # Returns this entity as a string.  See write().
  #
  # source://rexml//lib/rexml/entity.rb#120
  def to_s; end

  # Evaluates to the unnormalized value of this entity; that is, replacing
  # &ent; entities.
  #
  # source://rexml//lib/rexml/entity.rb#73
  def unnormalized; end

  # Returns the value of attribute value.
  #
  # source://rexml//lib/rexml/entity.rb#23
  def value; end

  # Write out a fully formed, correct entity definition (assuming the Entity
  # object itself is valid.)
  #
  # out::
  #   An object implementing <TT>&lt;&lt;</TT> to which the entity will be
  #   output
  # indent::
  #   *DEPRECATED* and ignored
  #
  # source://rexml//lib/rexml/entity.rb#98
  def write(out, indent = T.unsafe(nil)); end

  class << self
    # Evaluates whether the given string matches an entity definition,
    # returning true if so, and false otherwise.
    #
    # @return [Boolean]
    #
    # source://rexml//lib/rexml/entity.rb#67
    def matches?(string); end
  end
end

# source://rexml//lib/rexml/doctype.rb#267
class REXML::ExternalEntity < ::REXML::Child
  # @return [ExternalEntity] a new instance of ExternalEntity
  #
  # source://rexml//lib/rexml/doctype.rb#268
  def initialize(src); end

  # source://rexml//lib/rexml/doctype.rb#272
  def to_s; end

  # source://rexml//lib/rexml/doctype.rb#275
  def write(output, indent); end
end

# source://rexml//lib/rexml/formatters/default.rb#5
class REXML::Formatters::Default
  # Prints out the XML document with no formatting -- except if ie_hack is
  # set.
  #
  # ie_hack::
  #   If set to true, then inserts whitespace before the close of an empty
  #   tag, so that IE's bad XML parser doesn't choke.
  #
  # @return [Default] a new instance of Default
  #
  # source://rexml//lib/rexml/formatters/default.rb#12
  def initialize(ie_hack = T.unsafe(nil)); end

  # Writes the node to some output.
  #
  # node::
  #   The node to write
  # output::
  #   A class implementing <TT>&lt;&lt;</TT>.  Pass in an Output object to
  #   change the output encoding.
  #
  # source://rexml//lib/rexml/formatters/default.rb#23
  def write(node, output); end

  protected

  # source://rexml//lib/rexml/formatters/default.rb#98
  def write_cdata(node, output); end

  # source://rexml//lib/rexml/formatters/default.rb#92
  def write_comment(node, output); end

  # source://rexml//lib/rexml/formatters/default.rb#61
  def write_document(node, output); end

  # source://rexml//lib/rexml/formatters/default.rb#65
  def write_element(node, output); end

  # source://rexml//lib/rexml/formatters/default.rb#104
  def write_instruction(node, output); end

  # source://rexml//lib/rexml/formatters/default.rb#88
  def write_text(node, output); end
end

# Pretty-prints an XML document.  This destroys whitespace in text nodes
# and will insert carriage returns and indentations.
#
# TODO: Add an option to print attributes on new lines
#
# source://rexml//lib/rexml/formatters/pretty.rb#10
class REXML::Formatters::Pretty < ::REXML::Formatters::Default
  # Create a new pretty printer.
  #
  # output::
  #   An object implementing '<<(String)', to which the output will be written.
  # indentation::
  #   An integer greater than 0.  The indentation of each level will be
  #   this number of spaces.  If this is < 1, the behavior of this object
  #   is undefined.  Defaults to 2.
  # ie_hack::
  #   If true, the printer will insert whitespace before closing empty
  #   tags, thereby allowing Internet Explorer's XML parser to
  #   function. Defaults to false.
  #
  # @return [Pretty] a new instance of Pretty
  #
  # source://rexml//lib/rexml/formatters/pretty.rb#30
  def initialize(indentation = T.unsafe(nil), ie_hack = T.unsafe(nil)); end

  # If compact is set to true, then the formatter will attempt to use as
  # little space as possible
  #
  # source://rexml//lib/rexml/formatters/pretty.rb#14
  def compact; end

  # If compact is set to true, then the formatter will attempt to use as
  # little space as possible
  #
  # source://rexml//lib/rexml/formatters/pretty.rb#14
  def compact=(_arg0); end

  # The width of a page.  Used for formatting text
  #
  # source://rexml//lib/rexml/formatters/pretty.rb#16
  def width; end

  # The width of a page.  Used for formatting text
  #
  # source://rexml//lib/rexml/formatters/pretty.rb#16
  def width=(_arg0); end

  protected

  # source://rexml//lib/rexml/formatters/pretty.rb#102
  def write_cdata(node, output); end

  # source://rexml//lib/rexml/formatters/pretty.rb#97
  def write_comment(node, output); end

  # source://rexml//lib/rexml/formatters/pretty.rb#107
  def write_document(node, output); end

  # source://rexml//lib/rexml/formatters/pretty.rb#39
  def write_element(node, output); end

  # source://rexml//lib/rexml/formatters/pretty.rb#88
  def write_text(node, output); end

  private

  # source://rexml//lib/rexml/formatters/pretty.rb#124
  def indent_text(string, level = T.unsafe(nil), style = T.unsafe(nil), indentfirstline = T.unsafe(nil)); end

  # source://rexml//lib/rexml/formatters/pretty.rb#129
  def wrap(string, width); end
end

# A Source that wraps an IO.  See the Source class for method
# documentation
#
# source://rexml//lib/rexml/source.rb#183
class REXML::IOSource < ::REXML::Source
  # block_size has been deprecated
  #
  # @return [IOSource] a new instance of IOSource
  #
  # source://rexml//lib/rexml/source.rb#187
  def initialize(arg, block_size = T.unsafe(nil), encoding = T.unsafe(nil)); end

  # @return the current line in the source
  #
  # source://rexml//lib/rexml/source.rb#275
  def current_line; end

  # @return [Boolean]
  #
  # source://rexml//lib/rexml/source.rb#270
  def empty?; end

  # source://rexml//lib/rexml/source.rb#247
  def ensure_buffer; end

  # source://rexml//lib/rexml/source.rb#251
  def match(pattern, cons = T.unsafe(nil)); end

  # source://rexml//lib/rexml/source.rb#208
  def read(term = T.unsafe(nil), min_bytes = T.unsafe(nil)); end

  # source://rexml//lib/rexml/source.rb#229
  def read_until(term); end

  private

  # source://rexml//lib/rexml/source.rb#322
  def encoding_updated; end

  # source://rexml//lib/rexml/source.rb#297
  def readline(term = T.unsafe(nil)); end
end

# Represents an XML Instruction; IE, <? ... ?>
# TODO: Add parent arg (3rd arg) to constructor
#
# source://rexml//lib/rexml/instruction.rb#9
class REXML::Instruction < ::REXML::Child
  # Constructs a new Instruction
  # the target of this instruction is set to this.  If an Instruction,
  # then the Instruction is shallowly cloned (target and content are
  # copied).
  # be a Parent if the target argument is a Source.  Otherwise, this
  # String is set as the content of this instruction.
  #
  # @param target can be one of a number of things.  If String, then
  # @param content Must be either a String, or a Parent.  Can only
  # @return [Instruction] a new instance of Instruction
  #
  # source://rexml//lib/rexml/instruction.rb#25
  def initialize(target, content = T.unsafe(nil)); end

  # of the other matches the target and content of this object.
  #
  # @return true if other is an Instruction, and the content and target
  #
  # source://rexml//lib/rexml/instruction.rb#65
  def ==(other); end

  # source://rexml//lib/rexml/instruction.rb#44
  def clone; end

  # target is the "name" of the Instruction; IE, the "tag" in <?tag ...?>
  # content is everything else.
  #
  # source://rexml//lib/rexml/instruction.rb#15
  def content; end

  # target is the "name" of the Instruction; IE, the "tag" in <?tag ...?>
  # content is everything else.
  #
  # source://rexml//lib/rexml/instruction.rb#15
  def content=(_arg0); end

  # source://rexml//lib/rexml/instruction.rb#75
  def inspect; end

  # source://rexml//lib/rexml/instruction.rb#71
  def node_type; end

  # target is the "name" of the Instruction; IE, the "tag" in <?tag ...?>
  # content is everything else.
  #
  # source://rexml//lib/rexml/instruction.rb#15
  def target; end

  # target is the "name" of the Instruction; IE, the "tag" in <?tag ...?>
  # content is everything else.
  #
  # source://rexml//lib/rexml/instruction.rb#15
  def target=(_arg0); end

  # == DEPRECATED
  # See the rexml/formatters package
  #
  # source://rexml//lib/rexml/instruction.rb#51
  def write(writer, indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end
end

# Adds named attributes to an object.
#
# source://rexml//lib/rexml/namespace.rb#7
module REXML::Namespace
  include ::REXML::XMLTokens

  # The name of the object, valid if set
  #
  # source://rexml//lib/rexml/namespace.rb#9
  def expanded_name; end

  # Fully expand the name, even if the prefix wasn't specified in the
  # source file.
  #
  # source://rexml//lib/rexml/namespace.rb#57
  def fully_expanded_name; end

  # Compares names optionally WITH namespaces
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/namespace.rb#43
  def has_name?(other, ns = T.unsafe(nil)); end

  # The name of the object, valid if set
  #
  # source://rexml//lib/rexml/namespace.rb#9
  def name; end

  # Sets the name and the expanded name
  #
  # source://rexml//lib/rexml/namespace.rb#17
  def name=(name); end

  # The expanded name of the object, valid if name is set
  #
  # source://rexml//lib/rexml/namespace.rb#11
  def prefix; end

  # The expanded name of the object, valid if name is set
  #
  # source://rexml//lib/rexml/namespace.rb#11
  def prefix=(_arg0); end
end

# source://rexml//lib/rexml/namespace.rb#13
REXML::Namespace::NAME_WITHOUT_NAMESPACE = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/doctype.rb#280
class REXML::NotationDecl < ::REXML::Child
  # @return [NotationDecl] a new instance of NotationDecl
  #
  # source://rexml//lib/rexml/doctype.rb#282
  def initialize(name, middle, pub, sys); end

  # This method retrieves the name of the notation.
  #
  # Method contributed by Henrik Martensson
  #
  # source://rexml//lib/rexml/doctype.rb#307
  def name; end

  # Returns the value of attribute public.
  #
  # source://rexml//lib/rexml/doctype.rb#281
  def public; end

  # Sets the attribute public
  #
  # @param value the value to set the attribute public to.
  #
  # source://rexml//lib/rexml/doctype.rb#281
  def public=(_arg0); end

  # Returns the value of attribute system.
  #
  # source://rexml//lib/rexml/doctype.rb#281
  def system; end

  # Sets the attribute system
  #
  # @param value the value to set the attribute system to.
  #
  # source://rexml//lib/rexml/doctype.rb#281
  def system=(_arg0); end

  # source://rexml//lib/rexml/doctype.rb#290
  def to_s; end

  # source://rexml//lib/rexml/doctype.rb#300
  def write(output, indent = T.unsafe(nil)); end
end

# source://rexml//lib/rexml/output.rb#5
class REXML::Output
  include ::REXML::Encoding

  # @return [Output] a new instance of Output
  #
  # source://rexml//lib/rexml/output.rb#10
  def initialize(real_IO, encd = T.unsafe(nil)); end

  # source://rexml//lib/rexml/output.rb#22
  def <<(content); end

  # Returns the value of attribute encoding.
  #
  # source://rexml//lib/rexml/output.rb#8
  def encoding; end

  # source://rexml//lib/rexml/output.rb#26
  def to_s; end
end

# A parent has children, and has methods for accessing them.  The Parent
# class is never encountered except as the superclass for some other
# object.
#
# source://rexml//lib/rexml/parent.rb#8
class REXML::Parent < ::REXML::Child
  include ::Enumerable

  # Constructor
  #
  # @param parent if supplied, will be set as the parent of this object
  # @return [Parent] a new instance of Parent
  #
  # source://rexml//lib/rexml/parent.rb#13
  def initialize(parent = T.unsafe(nil)); end

  # source://rexml//lib/rexml/parent.rb#18
  def <<(object); end

  # Fetches a child at a given index
  #
  # @param index the Integer index of the child to fetch
  #
  # source://rexml//lib/rexml/parent.rb#57
  def [](index); end

  # Set an index entry.  See Array.[]=
  #
  # @param index the index of the element to set
  # @param opt either the object to set, or an Integer length
  # @param child if opt is an Integer, this is the child to set
  # @return the parent (self)
  #
  # source://rexml//lib/rexml/parent.rb#70
  def []=(*args); end

  # source://rexml//lib/rexml/parent.rb#18
  def add(object); end

  # source://rexml//lib/rexml/parent.rb#115
  def children; end

  # Deeply clones this object.  This creates a complete duplicate of this
  # Parent, including all descendants.
  #
  # source://rexml//lib/rexml/parent.rb#148
  def deep_clone; end

  # source://rexml//lib/rexml/parent.rb#32
  def delete(object); end

  # source://rexml//lib/rexml/parent.rb#47
  def delete_at(index); end

  # source://rexml//lib/rexml/parent.rb#43
  def delete_if(&block); end

  # source://rexml//lib/rexml/parent.rb#39
  def each(&block); end

  # source://rexml//lib/rexml/parent.rb#39
  def each_child(&block); end

  # source://rexml//lib/rexml/parent.rb#51
  def each_index(&block); end

  # Fetches the index of a given child
  # of this parent.
  #
  # @param child the child to get the index of
  # @return the index of the child, or nil if the object is not a child
  #
  # source://rexml//lib/rexml/parent.rb#123
  def index(child); end

  # Inserts an child after another child
  # child2 will be inserted after child1 in the child list of the parent.
  # If an xpath, child2 will be inserted after the first child to match
  # the xpath.
  #
  # @param child1 this is either an xpath or an Element.  If an Element,
  # @param child2 the child to insert
  # @return the parent (self)
  #
  # source://rexml//lib/rexml/parent.rb#102
  def insert_after(child1, child2); end

  # Inserts an child before another child
  # child2 will be inserted before child1 in the child list of the parent.
  # If an xpath, child2 will be inserted before the first child to match
  # the xpath.
  #
  # @param child1 this is either an xpath or an Element.  If an Element,
  # @param child2 the child to insert
  # @return the parent (self)
  #
  # source://rexml//lib/rexml/parent.rb#82
  def insert_before(child1, child2); end

  # @return the number of children of this parent
  #
  # source://rexml//lib/rexml/parent.rb#130
  def length; end

  # @return [Boolean]
  #
  # source://rexml//lib/rexml/parent.rb#162
  def parent?; end

  # source://rexml//lib/rexml/parent.rb#18
  def push(object); end

  # Replaces one child with another, making sure the nodelist is correct
  # Child)
  #
  # @param to_replace the child to replace (must be a Child)
  # @param replacement the child to insert into the nodelist (must be a
  #
  # source://rexml//lib/rexml/parent.rb#140
  def replace_child(to_replace, replacement); end

  # @return the number of children of this parent
  #
  # source://rexml//lib/rexml/parent.rb#130
  def size; end

  # source://rexml//lib/rexml/parent.rb#115
  def to_a; end

  # source://rexml//lib/rexml/parent.rb#27
  def unshift(object); end
end

# source://rexml//lib/rexml/parseexception.rb#3
class REXML::ParseException < ::RuntimeError
  # @return [ParseException] a new instance of ParseException
  #
  # source://rexml//lib/rexml/parseexception.rb#6
  def initialize(message, source = T.unsafe(nil), parser = T.unsafe(nil), exception = T.unsafe(nil)); end

  # source://rexml//lib/rexml/parseexception.rb#49
  def context; end

  # Returns the value of attribute continued_exception.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def continued_exception; end

  # Sets the attribute continued_exception
  #
  # @param value the value to set the attribute continued_exception to.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def continued_exception=(_arg0); end

  # source://rexml//lib/rexml/parseexception.rb#44
  def line; end

  # Returns the value of attribute parser.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def parser; end

  # Sets the attribute parser
  #
  # @param value the value to set the attribute parser to.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def parser=(_arg0); end

  # source://rexml//lib/rexml/parseexception.rb#39
  def position; end

  # Returns the value of attribute source.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def source; end

  # Sets the attribute source
  #
  # @param value the value to set the attribute source to.
  #
  # source://rexml//lib/rexml/parseexception.rb#4
  def source=(_arg0); end

  # source://rexml//lib/rexml/parseexception.rb#13
  def to_s; end
end

# = Using the Pull Parser
# <em>This API is experimental, and subject to change.</em>
#  parser = PullParser.new( "<a>text<b att='val'/>txet</a>" )
#  while parser.has_next?
#    res = parser.next
#    puts res[1]['att'] if res.start_tag? and res[0] == 'b'
#  end
# See the PullEvent class for information on the content of the results.
# The data is identical to the arguments passed for the various events to
# the StreamListener API.
#
# Notice that:
#  parser = PullParser.new( "<a>BAD DOCUMENT" )
#  while parser.has_next?
#    res = parser.next
#    raise res[1] if res.error?
#  end
#
# Nat Price gave me some good ideas for the API.
#
# source://rexml//lib/rexml/parsers/baseparser.rb#57
class REXML::Parsers::BaseParser
  # @return [BaseParser] a new instance of BaseParser
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#163
  def initialize(source); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#173
  def add_listener(listener); end

  # Returns true if there are no more events
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#204
  def empty?; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#536
  def entity(reference, entities); end

  # Returns the value of attribute entity_expansion_count.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#178
  def entity_expansion_count; end

  # Sets the attribute entity_expansion_limit
  #
  # @param value the value to set the attribute entity_expansion_limit to.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#179
  def entity_expansion_limit=(_arg0); end

  # Sets the attribute entity_expansion_text_limit
  #
  # @param value the value to set the attribute entity_expansion_text_limit to.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#180
  def entity_expansion_text_limit=(_arg0); end

  # Returns true if there are more events.  Synonymous with !empty?
  #
  # @return [Boolean]
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#209
  def has_next?; end

  # Escapes all possible entities
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#547
  def normalize(input, entities = T.unsafe(nil), entity_filter = T.unsafe(nil)); end

  # Peek at the +depth+ event in the stack.  The first element on the stack
  # is at depth 0.  If +depth+ is -1, will parse to the end of the input
  # stream and return the last event, which is always :end_document.
  # Be aware that this causes the stream to be parsed up to the +depth+
  # event, so you can effectively pre-parse the entire document (pull the
  # entire thing into memory) using this method.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#225
  def peek(depth = T.unsafe(nil)); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#194
  def position; end

  # Returns the next event.  This is a +PullEvent+ object.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#240
  def pull; end

  # Returns the value of attribute source.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#177
  def source; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#182
  def stream=(source); end

  # Unescapes all possible entities
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#563
  def unnormalize(string, entities = T.unsafe(nil), filter = T.unsafe(nil)); end

  # Push an event back on the head of the stream.  This method
  # has (theoretically) infinite depth.
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#215
  def unshift(token); end

  private

  # source://rexml//lib/rexml/parsers/baseparser.rb#612
  def add_namespace(prefix, uri); end

  # @return [Boolean]
  #
  # source://rexml//lib/rexml/parsers/baseparser.rb#645
  def need_source_encoding_update?(xml_declaration_encoding); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#765
  def parse_attributes(prefixes); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#664
  def parse_id(base_error_message, accept_external_id:, accept_public_id:); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#692
  def parse_id_invalid_details(accept_external_id:, accept_public_id:); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#651
  def parse_name(base_error_message); end

  # source://rexml//lib/rexml/parsers/baseparser.rb#627
  def pop_namespaces_restore; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#730
  def process_instruction; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#250
  def pull_event; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#621
  def push_namespaces_restore; end

  # source://rexml//lib/rexml/parsers/baseparser.rb#638
  def record_entity_expansion(delta = T.unsafe(nil)); end
end

# source://rexml//lib/rexml/parsers/baseparser.rb#130
REXML::Parsers::BaseParser::EXTERNAL_ID_PUBLIC = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#131
REXML::Parsers::BaseParser::EXTERNAL_ID_SYSTEM = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#132
REXML::Parsers::BaseParser::PUBLIC_ID = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#143
module REXML::Parsers::BaseParser::Private; end

# source://rexml//lib/rexml/parsers/baseparser.rb#147
REXML::Parsers::BaseParser::Private::ATTLISTDECL_END = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#152
REXML::Parsers::BaseParser::Private::CARRIAGE_RETURN_NEWLINE_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#153
REXML::Parsers::BaseParser::Private::CHARACTER_REFERENCES = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#146
REXML::Parsers::BaseParser::Private::CLOSE_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#154
REXML::Parsers::BaseParser::Private::DEFAULT_ENTITIES_PATTERNS = T.let(T.unsafe(nil), Hash)

# source://rexml//lib/rexml/parsers/baseparser.rb#151
REXML::Parsers::BaseParser::Private::ENTITYDECL_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#149
REXML::Parsers::BaseParser::Private::GEDECL_PATTERN = T.let(T.unsafe(nil), String)

# source://rexml//lib/rexml/parsers/baseparser.rb#148
REXML::Parsers::BaseParser::Private::NAME_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#150
REXML::Parsers::BaseParser::Private::PEDECL_PATTERN = T.let(T.unsafe(nil), String)

# source://rexml//lib/rexml/parsers/baseparser.rb#144
REXML::Parsers::BaseParser::Private::PEREFERENCE_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#145
REXML::Parsers::BaseParser::Private::TAG_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#159
REXML::Parsers::BaseParser::Private::XML_PREFIXED_NAMESPACE = T.let(T.unsafe(nil), String)

# source://rexml//lib/rexml/parsers/baseparser.rb#66
REXML::Parsers::BaseParser::QNAME = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/parsers/baseparser.rb#65
REXML::Parsers::BaseParser::QNAME_STR = T.let(T.unsafe(nil), String)

# source://rexml//lib/rexml/parsers/streamparser.rb#6
class REXML::Parsers::StreamParser
  # @return [StreamParser] a new instance of StreamParser
  #
  # source://rexml//lib/rexml/parsers/streamparser.rb#7
  def initialize(source, listener); end

  # source://rexml//lib/rexml/parsers/streamparser.rb#13
  def add_listener(listener); end

  # source://rexml//lib/rexml/parsers/streamparser.rb#17
  def entity_expansion_count; end

  # source://rexml//lib/rexml/parsers/streamparser.rb#21
  def entity_expansion_limit=(limit); end

  # source://rexml//lib/rexml/parsers/streamparser.rb#25
  def entity_expansion_text_limit=(limit); end

  # source://rexml//lib/rexml/parsers/streamparser.rb#29
  def parse; end
end

# source://rexml//lib/rexml/parsers/treeparser.rb#7
class REXML::Parsers::TreeParser
  # @return [TreeParser] a new instance of TreeParser
  #
  # source://rexml//lib/rexml/parsers/treeparser.rb#8
  def initialize(source, build_context = T.unsafe(nil)); end

  # source://rexml//lib/rexml/parsers/treeparser.rb#13
  def add_listener(listener); end

  # source://rexml//lib/rexml/parsers/treeparser.rb#17
  def parse; end
end

# You don't want to use this class.  Really.  Use XPath, which is a wrapper
# for this class.  Believe me.  You don't want to poke around in here.
# There is strange, dark magic at work in this code.  Beware.  Go back!  Go
# back while you still can!
#
# source://rexml//lib/rexml/parsers/xpathparser.rb#12
class REXML::Parsers::XPathParser
  include ::REXML::XMLTokens

  # source://rexml//lib/rexml/parsers/xpathparser.rb#42
  def abbreviate(path_or_parsed); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#132
  def expand(path_or_parsed); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#16
  def namespaces=(namespaces); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#21
  def parse(path); end

  # For backward compatibility
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#174
  def preciate_to_string(parsed, &block); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#36
  def predicate(path); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#174
  def predicate_to_path(parsed, &block); end

  private

  # | AdditiveExpr ('+' | '-') MultiplicativeExpr
  # | MultiplicativeExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#505
  def AdditiveExpr(path, parsed); end

  # | AndExpr S 'and' S EqualityExpr
  # | EqualityExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#438
  def AndExpr(path, parsed); end

  # | EqualityExpr ('=' | '!=')  RelationalExpr
  # | RelationalExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#457
  def EqualityExpr(path, parsed); end

  # | FilterExpr Predicate
  # | PrimaryExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#608
  def FilterExpr(path, parsed); end

  # | FUNCTION_NAME '(' ( expr ( ',' expr )* )? ')'
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#663
  def FunctionCall(rest, parsed); end

  # LocationPath
  #  | RelativeLocationPath
  #  | '/' RelativeLocationPath?
  #  | '//' RelativeLocationPath
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#243
  def LocationPath(path, parsed); end

  # | MultiplicativeExpr ('*' | S ('div' | 'mod') S) UnaryExpr
  # | UnaryExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#528
  def MultiplicativeExpr(path, parsed); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#343
  def NodeTest(path, parsed); end

  # | OrExpr S 'or' S AndExpr
  # | AndExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#419
  def OrExpr(path, parsed); end

  # | LocationPath
  # | FilterExpr ('/' | '//') RelativeLocationPath
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#590
  def PathExpr(path, parsed); end

  # Filters the supplied nodeset on the predicate(s)
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#395
  def Predicate(path, parsed); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#626
  def PrimaryExpr(path, parsed); end

  # | RelationalExpr ('<' | '>' | '<=' | '>=') AdditiveExpr
  # | AdditiveExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#480
  def RelationalExpr(path, parsed); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#267
  def RelativeLocationPath(path, parsed); end

  # | '-' UnaryExpr
  # | UnionExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#553
  def UnaryExpr(path, parsed); end

  # | UnionExpr '|' PathExpr
  # | PathExpr
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#571
  def UnionExpr(path, parsed); end

  # get_group( '[foo]bar' ) -> ['bar', '[foo]']
  #
  # source://rexml//lib/rexml/parsers/xpathparser.rb#676
  def get_group(string); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#694
  def parse_args(string); end

  # source://rexml//lib/rexml/parsers/xpathparser.rb#224
  def quote_literal(literal); end
end

# source://rexml//lib/rexml/parsers/xpathparser.rb#339
REXML::Parsers::XPathParser::LOCAL_NAME_WILDCARD = T.let(T.unsafe(nil), Regexp)

# Returns a 1-1 map of the nodeset
# The contents of the resulting array are either:
#   true/false, if a positive match
#   String, if a name match
# NodeTest
#  | ('*' | NCNAME ':' '*' | QNAME)                NameTest
#  | '*' ':' NCNAME                                NameTest since XPath 2.0
#  | NODE_TYPE '(' ')'                             NodeType
#  | PI '(' LITERAL ')'                            PI
#    | '[' expr ']'                                Predicate
#
# source://rexml//lib/rexml/parsers/xpathparser.rb#338
REXML::Parsers::XPathParser::PREFIX_WILDCARD = T.let(T.unsafe(nil), Regexp)

# source://rexml//lib/rexml/doctype.rb#10
class REXML::ReferenceWriter
  # @return [ReferenceWriter] a new instance of ReferenceWriter
  #
  # source://rexml//lib/rexml/doctype.rb#11
  def initialize(id_type, public_id_literal, system_literal, context = T.unsafe(nil)); end

  # source://rexml//lib/rexml/doctype.rb#25
  def write(output); end
end

# A Source can be searched for patterns, and wraps buffers and other
# objects and provides consumption of text
#
# source://rexml//lib/rexml/source.rb#51
class REXML::Source
  include ::REXML::Encoding

  # Constructor
  # value, overriding all encoding detection
  #
  # @param arg must be a String, and should be a valid XML document
  # @param encoding if non-null, sets the encoding of the source to this
  # @return [Source] a new instance of Source
  #
  # source://rexml//lib/rexml/source.rb#71
  def initialize(arg, encoding = T.unsafe(nil)); end

  # The current buffer (what we're going to read next)
  #
  # source://rexml//lib/rexml/source.rb#84
  def buffer; end

  # source://rexml//lib/rexml/source.rb#94
  def buffer_encoding=(encoding); end

  # @return the current line in the source
  #
  # source://rexml//lib/rexml/source.rb#143
  def current_line; end

  # source://rexml//lib/rexml/source.rb#88
  def drop_parsed_content; end

  # @return [Boolean] true if the Source is exhausted
  #
  # source://rexml//lib/rexml/source.rb#138
  def empty?; end

  # Returns the value of attribute encoding.
  #
  # source://rexml//lib/rexml/source.rb#55
  def encoding; end

  # Inherited from Encoding
  # Overridden to support optimized en/decoding
  #
  # source://rexml//lib/rexml/source.rb#100
  def encoding=(enc); end

  # source://rexml//lib/rexml/source.rb#118
  def ensure_buffer; end

  # The line number of the last consumed text
  #
  # source://rexml//lib/rexml/source.rb#54
  def line; end

  # source://rexml//lib/rexml/source.rb#121
  def match(pattern, cons = T.unsafe(nil)); end

  # source://rexml//lib/rexml/source.rb#129
  def position; end

  # source://rexml//lib/rexml/source.rb#133
  def position=(pos); end

  # source://rexml//lib/rexml/source.rb#105
  def read(term = T.unsafe(nil)); end

  # source://rexml//lib/rexml/source.rb#108
  def read_until(term); end

  private

  # source://rexml//lib/rexml/source.rb#152
  def detect_encoding; end

  # source://rexml//lib/rexml/source.rb#170
  def encoding_updated; end
end

# source://rexml//lib/rexml/source.rb#57
module REXML::Source::Private; end

# source://rexml//lib/rexml/source.rb#59
REXML::Source::Private::PRE_DEFINED_TERM_PATTERNS = T.let(T.unsafe(nil), Hash)

# source://rexml//lib/rexml/source.rb#58
REXML::Source::Private::SCANNER_RESET_SIZE = T.let(T.unsafe(nil), Integer)

# Represents text nodes in an XML document
#
# source://rexml//lib/rexml/text.rb#11
class REXML::Text < ::REXML::Child
  include ::Comparable

  # Constructor
  # +arg+ if a String, the content is set to the String.  If a Text,
  # the object is shallowly cloned.
  #
  # +respect_whitespace+ (boolean, false) if true, whitespace is
  # respected
  #
  # +parent+ (nil) if this is a Parent object, the parent
  # will be set to this.
  #
  # +raw+ (nil) This argument can be given three values.
  # If true, then the value of used to construct this object is expected to
  # contain no unescaped XML markup, and REXML will not change the text. If
  # this value is false, the string may contain any characters, and REXML will
  # escape any and all defined entities whose values are contained in the
  # text.  If this value is nil (the default), then the raw value of the
  # parent will be used as the raw value for this node.  If there is no raw
  # value for the parent, and no value is supplied, the default is false.
  # Use this field if you have entities defined for some text, and you don't
  # want REXML to escape that text in output.
  #   Text.new( "<&", false, nil, false ) #-> "&lt;&amp;"
  #   Text.new( "&lt;&amp;", false, nil, false ) #-> "&amp;lt;&amp;amp;"
  #   Text.new( "<&", false, nil, true )  #-> Parse exception
  #   Text.new( "&lt;&amp;", false, nil, true )  #-> "&lt;&amp;"
  #   # Assume that the entity "s" is defined to be "sean"
  #   # and that the entity    "r" is defined to be "russell"
  #   Text.new( "sean russell" )          #-> "&s; &r;"
  #   Text.new( "sean russell", false, nil, true ) #-> "sean russell"
  #
  # +entity_filter+ (nil) This can be an array of entities to match in the
  # supplied text.  This argument is only useful if +raw+ is set to false.
  #   Text.new( "sean russell", false, nil, false, ["s"] ) #-> "&s; russell"
  #   Text.new( "sean russell", false, nil, true, ["s"] ) #-> "sean russell"
  # In the last example, the +entity_filter+ argument is ignored.
  #
  # +illegal+ INTERNAL USE ONLY
  #
  # @return [Text] a new instance of Text
  #
  # source://rexml//lib/rexml/text.rb#94
  def initialize(arg, respect_whitespace = T.unsafe(nil), parent = T.unsafe(nil), raw = T.unsafe(nil), entity_filter = T.unsafe(nil), illegal = T.unsafe(nil)); end

  # Appends text to this text node.  The text is appended in the +raw+ mode
  # of this text node.
  #
  # +returns+ the text itself to enable method chain like
  # 'text << "XXX" << "YYY"'.
  #
  # source://rexml//lib/rexml/text.rb#214
  def <<(to_append); end

  # +other+ a String or a Text
  # +returns+ the result of (to_s <=> arg.to_s)
  #
  # source://rexml//lib/rexml/text.rb#223
  def <=>(other); end

  # source://rexml//lib/rexml/text.rb#204
  def clone; end

  # source://rexml//lib/rexml/text.rb#227
  def doctype; end

  # @return [Boolean]
  #
  # source://rexml//lib/rexml/text.rb#199
  def empty?; end

  # source://rexml//lib/rexml/text.rb#299
  def indent_text(string, level = T.unsafe(nil), style = T.unsafe(nil), indentfirstline = T.unsafe(nil)); end

  # source://rexml//lib/rexml/text.rb#253
  def inspect; end

  # source://rexml//lib/rexml/text.rb#195
  def node_type; end

  # source://rexml//lib/rexml/text.rb#125
  def parent=(parent); end

  # If +raw+ is true, then REXML leaves the value alone
  #
  # source://rexml//lib/rexml/text.rb#21
  def raw; end

  # If +raw+ is true, then REXML leaves the value alone
  #
  # source://rexml//lib/rexml/text.rb#21
  def raw=(_arg0); end

  # Returns the string value of this text node.  This string is always
  # escaped, meaning that it is a valid XML text node string, and all
  # entities that can be escaped, have been inserted.  This method respects
  # the entity filter set in the constructor.
  #
  #   # Assume that the entity "s" is defined to be "sean", and that the
  #   # entity "r" is defined to be "russell"
  #   t = Text.new( "< & sean russell", false, nil, false, ['s'] )
  #   t.to_s   #-> "&lt; &amp; &s; russell"
  #   t = Text.new( "< & &s; russell", false, nil, false )
  #   t.to_s   #-> "&lt; &amp; &s; russell"
  #   u = Text.new( "sean russell", false, nil, true )
  #   u.to_s   #-> "sean russell"
  #
  # source://rexml//lib/rexml/text.rb#248
  def to_s; end

  # Returns the string value of this text.  This is the text without
  # entities, as it might be used programmatically, or printed to the
  # console.  This ignores the 'raw' attribute setting, and any
  # entity_filter.
  #
  #   # Assume that the entity "s" is defined to be "sean", and that the
  #   # entity "r" is defined to be "russell"
  #   t = Text.new( "< & sean russell", false, nil, false, ['s'] )
  #   t.value   #-> "< & sean russell"
  #   t = Text.new( "< & &s; russell", false, nil, false )
  #   t.value   #-> "< & sean russell"
  #   u = Text.new( "sean russell", false, nil, true )
  #   u.value   #-> "sean russell"
  #
  # source://rexml//lib/rexml/text.rb#270
  def value; end

  # Sets the contents of this text node.  This expects the text to be
  # unnormalized.  It returns self.
  #
  #   e = Element.new( "a" )
  #   e.add_text( "foo" )   # <a>foo</a>
  #   e[0].value = "bar"    # <a>bar</a>
  #   e[0].value = "<a>"    # <a>&lt;a&gt;</a>
  #
  # source://rexml//lib/rexml/text.rb#282
  def value=(val); end

  # source://rexml//lib/rexml/text.rb#288
  def wrap(string, width, addnewline = T.unsafe(nil)); end

  # == DEPRECATED
  # See REXML::Formatters
  #
  # source://rexml//lib/rexml/text.rb#314
  def write(writer, indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end

  # Writes out text, substituting special characters beforehand.
  # +out+ A String, IO, or any other object supporting <<( String )
  # +input+ the text to substitute and the write out
  #
  #   z=utf8.unpack("U*")
  #   ascOut=""
  #   z.each{|r|
  #     if r <  0x100
  #       ascOut.concat(r.chr)
  #     else
  #       ascOut.concat(sprintf("&#x%x;", r))
  #     end
  #   }
  #   puts ascOut
  #
  # source://rexml//lib/rexml/text.rb#346
  def write_with_substitution(out, input); end

  # FIXME
  # This probably won't work properly
  #
  # source://rexml//lib/rexml/text.rb#326
  def xpath; end

  private

  # source://rexml//lib/rexml/text.rb#359
  def clear_cache; end

  class << self
    # check for illegal characters
    #
    # source://rexml//lib/rexml/text.rb#131
    def check(string, pattern, doctype); end

    # source://rexml//lib/rexml/text.rb#429
    def expand(ref, doctype, filter); end

    # Escapes all possible entities
    #
    # source://rexml//lib/rexml/text.rb#391
    def normalize(input, doctype = T.unsafe(nil), entity_filter = T.unsafe(nil)); end

    # Reads text, substituting entities
    #
    # source://rexml//lib/rexml/text.rb#365
    def read_with_substitution(input, illegal = T.unsafe(nil)); end

    # Unescapes all possible entities
    #
    # source://rexml//lib/rexml/text.rb#415
    def unnormalize(string, doctype = T.unsafe(nil), filter = T.unsafe(nil), illegal = T.unsafe(nil), entity_expansion_text_limit: T.unsafe(nil)); end
  end
end

# source://rexml//lib/rexml/undefinednamespaceexception.rb#4
class REXML::UndefinedNamespaceException < ::REXML::ParseException
  # @return [UndefinedNamespaceException] a new instance of UndefinedNamespaceException
  #
  # source://rexml//lib/rexml/undefinednamespaceexception.rb#5
  def initialize(prefix, source, parser); end
end

# source://rexml//lib/rexml/validation/validationexception.rb#4
class REXML::Validation::ValidationException < ::RuntimeError
  # @return [ValidationException] a new instance of ValidationException
  #
  # source://rexml//lib/rexml/validation/validationexception.rb#5
  def initialize(msg); end
end

# NEEDS DOCUMENTATION
#
# source://rexml//lib/rexml/xmldecl.rb#8
class REXML::XMLDecl < ::REXML::Child
  include ::REXML::Encoding

  # @return [XMLDecl] a new instance of XMLDecl
  #
  # source://rexml//lib/rexml/xmldecl.rb#20
  def initialize(version = T.unsafe(nil), encoding = T.unsafe(nil), standalone = T.unsafe(nil)); end

  # source://rexml//lib/rexml/xmldecl.rb#56
  def ==(other); end

  # source://rexml//lib/rexml/xmldecl.rb#39
  def clone; end

  # source://rexml//lib/rexml/xmldecl.rb#102
  def dowrite; end

  # source://rexml//lib/rexml/xmldecl.rb#76
  def encoding=(enc); end

  # source://rexml//lib/rexml/xmldecl.rb#106
  def inspect; end

  # source://rexml//lib/rexml/xmldecl.rb#69
  def node_type; end

  # source://rexml//lib/rexml/xmldecl.rb#98
  def nowrite; end

  # source://rexml//lib/rexml/encoding.rb#7
  def old_enc=(encoding); end

  # Returns the value of attribute standalone.
  #
  # source://rexml//lib/rexml/xmldecl.rb#17
  def stand_alone?; end

  # Returns the value of attribute standalone.
  #
  # source://rexml//lib/rexml/xmldecl.rb#17
  def standalone; end

  # Sets the attribute standalone
  #
  # @param value the value to set the attribute standalone to.
  #
  # source://rexml//lib/rexml/xmldecl.rb#17
  def standalone=(_arg0); end

  # Returns the value of attribute version.
  #
  # source://rexml//lib/rexml/xmldecl.rb#17
  def version; end

  # Sets the attribute version
  #
  # @param value the value to set the attribute version to.
  #
  # source://rexml//lib/rexml/xmldecl.rb#17
  def version=(_arg0); end

  # indent::
  #   Ignored.  There must be no whitespace before an XML declaration
  # transitive::
  #   Ignored
  # ie_hack::
  #   Ignored
  #
  # source://rexml//lib/rexml/xmldecl.rb#49
  def write(writer, indent = T.unsafe(nil), transitive = T.unsafe(nil), ie_hack = T.unsafe(nil)); end

  # Returns the value of attribute writeencoding.
  #
  # source://rexml//lib/rexml/xmldecl.rb#18
  def writeencoding; end

  # Returns the value of attribute writethis.
  #
  # source://rexml//lib/rexml/xmldecl.rb#18
  def writethis; end

  # source://rexml//lib/rexml/xmldecl.rb#63
  def xmldecl(version, encoding, standalone); end

  private

  # source://rexml//lib/rexml/xmldecl.rb#111
  def content(enc); end

  class << self
    # Only use this if you do not want the XML declaration to be written;
    # this object is ignored by the XML writer.  Otherwise, instantiate your
    # own XMLDecl and add it to the document.
    #
    # Note that XML 1.1 documents *must* include an XML declaration
    #
    # source://rexml//lib/rexml/xmldecl.rb#92
    def default; end
  end
end

# @private
#
# source://rexml//lib/rexml/xpath_parser.rb#963
class REXML::XPathNode
  # @return [XPathNode] a new instance of XPathNode
  #
  # source://rexml//lib/rexml/xpath_parser.rb#965
  def initialize(node, context = T.unsafe(nil)); end

  # Returns the value of attribute context.
  #
  # source://rexml//lib/rexml/xpath_parser.rb#964
  def context; end

  # source://rexml//lib/rexml/xpath_parser.rb#974
  def position; end

  # Returns the value of attribute raw_node.
  #
  # source://rexml//lib/rexml/xpath_parser.rb#964
  def raw_node; end
end

# You don't want to use this class.  Really.  Use XPath, which is a wrapper
# for this class.  Believe me.  You don't want to poke around in here.
# There is strange, dark magic at work in this code.  Beware.  Go back!  Go
# back while you still can!
#
# source://rexml//lib/rexml/xpath_parser.rb#54
class REXML::XPathParser
  include ::REXML::XMLTokens

  # @return [XPathParser] a new instance of XPathParser
  #
  # source://rexml//lib/rexml/xpath_parser.rb#60
  def initialize(strict: T.unsafe(nil)); end

  # source://rexml//lib/rexml/xpath_parser.rb#94
  def []=(variable_name, value); end

  # Performs a depth-first (document order) XPath search, and returns the
  # first match.  This is the fastest, lightest way to return a single result.
  #
  # FIXME: This method is incomplete!
  #
  # source://rexml//lib/rexml/xpath_parser.rb#103
  def first(path_stack, node); end

  # source://rexml//lib/rexml/xpath_parser.rb#84
  def get_first(path, nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#139
  def match(path_stack, nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#69
  def namespaces=(namespaces = T.unsafe(nil)); end

  # source://rexml//lib/rexml/xpath_parser.rb#79
  def parse(path, nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#89
  def predicate(path, nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#74
  def variables=(vars = T.unsafe(nil)); end

  private

  # source://rexml//lib/rexml/xpath_parser.rb#779
  def child(nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#920
  def compare(a, operator, b); end

  # source://rexml//lib/rexml/xpath_parser.rb#682
  def descendant(nodeset, include_self); end

  # source://rexml//lib/rexml/xpath_parser.rb#693
  def descendant_recursive(raw_node, new_nodeset, new_nodes, include_self); end

  # source://rexml//lib/rexml/xpath_parser.rb#942
  def each_unnode(nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#641
  def enter(tag, *args); end

  # source://rexml//lib/rexml/xpath_parser.rb#819
  def equality_relational_compare(set1, op, set2); end

  # source://rexml//lib/rexml/xpath_parser.rb#591
  def evaluate_predicate(expression, nodesets); end

  # Expr takes a stack of path elements and a set of nodes (either a Parent
  # or an Array and returns an Array of matching nodes
  #
  # source://rexml//lib/rexml/xpath_parser.rb#175
  def expr(path_stack, nodeset, context = T.unsafe(nil)); end

  # source://rexml//lib/rexml/xpath_parser.rb#582
  def filter_nodeset(nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#749
  def following(node); end

  # source://rexml//lib/rexml/xpath_parser.rb#760
  def following_node_of(node); end

  # Returns a String namespace for a node, given a prefix
  # The rules are:
  #
  #  1. Use the supplied namespace mapping first.
  #  2. If no mapping was supplied, use the context node to look up the namespace
  #
  # source://rexml//lib/rexml/xpath_parser.rb#163
  def get_namespace(node, prefix); end

  # source://rexml//lib/rexml/xpath_parser.rb#646
  def leave(tag, *args); end

  # source://rexml//lib/rexml/xpath_parser.rb#767
  def next_sibling_node(node); end

  # source://rexml//lib/rexml/xpath_parser.rb#477
  def node_test(path_stack, nodesets, any_type: T.unsafe(nil)); end

  # source://rexml//lib/rexml/xpath_parser.rb#806
  def norm(b); end

  # source://rexml//lib/rexml/xpath_parser.rb#894
  def normalize_compare_values(a, operator, b); end

  # Builds a nodeset of all of the preceding nodes of the supplied node,
  # in reverse document order
  # preceding:: includes every element in the document that precedes this node,
  # except for ancestors
  #
  # source://rexml//lib/rexml/xpath_parser.rb#712
  def preceding(node); end

  # source://rexml//lib/rexml/xpath_parser.rb#734
  def preceding_node_of(node); end

  # Reorders an array of nodes so that they are in document order
  # It tries to do this efficiently.
  #
  # FIXME: I need to get rid of this, but the issue is that most of the XPath
  # interpreter functions as a filter, which means that we lose context going
  # in and out of function calls.  If I knew what the index of the nodes was,
  # I wouldn't have to do this.  Maybe add a document IDX for each node?
  # Problems with mutable documents.  Or, rewrite everything.
  #
  # source://rexml//lib/rexml/xpath_parser.rb#659
  def sort(array_of_nodes, order); end

  # source://rexml//lib/rexml/xpath_parser.rb#441
  def step(path_stack, any_type: T.unsafe(nil), order: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rexml//lib/rexml/xpath_parser.rb#154
  def strict?; end

  # source://rexml//lib/rexml/xpath_parser.rb#634
  def trace(*args); end

  # source://rexml//lib/rexml/xpath_parser.rb#954
  def unnode(nodeset); end

  # source://rexml//lib/rexml/xpath_parser.rb#881
  def value_type(value); end
end

# source://rexml//lib/rexml/xpath_parser.rb#58
REXML::XPathParser::DEBUG = T.let(T.unsafe(nil), FalseClass)
