# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop` gem.
# Please instead update this file by running `bin/tapioca gem rubocop`.


class Parser::Source::Comment
  include ::RuboCop::Ext::Comment
end

class Parser::Source::Range
  include ::RuboCop::Ext::Range
end

class Regexp::Expression::Base
  include ::RuboCop::Ext::RegexpParser::Expression::Base
end

class Regexp::Expression::CharacterSet < ::Regexp::Expression::Subexpression
  include ::RuboCop::Ext::RegexpParser::Expression::CharacterSet
end

class Regexp::Expression::Quantifier
  include ::RuboCop::Ext::RegexpParser::Expression::Base
end

# source://rubocop//lib/rubocop/version.rb#3
module RuboCop; end

class RuboCop::AST::ProcessedSource
  include ::RuboCop::Ext::ProcessedSource
end

class RuboCop::AST::RegexpNode < ::RuboCop::AST::Node
  include ::RuboCop::Ext::RegexpNode
end

# This is a class that reads optional command line arguments to rubocop from environment variable.
#
# @api private
#
# source://rubocop//lib/rubocop/arguments_env.rb#6
class RuboCop::ArgumentsEnv
  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/arguments_env.rb#7
    def read_as_arguments; end
  end
end

# This is a class that reads optional command line arguments to rubocop from .rubocop file.
#
# @api private
#
# source://rubocop//lib/rubocop/arguments_file.rb#6
class RuboCop::ArgumentsFile
  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/arguments_file.rb#7
    def read_as_arguments; end
  end
end

# The CLI is a class responsible of handling all the command line interface
# logic.
#
# source://rubocop//lib/rubocop/cli.rb#8
class RuboCop::CLI
  # @return [CLI] a new instance of CLI
  #
  # source://rubocop//lib/rubocop/cli.rb#24
  def initialize; end

  # Returns the value of attribute config_store.
  #
  # source://rubocop//lib/rubocop/cli.rb#22
  def config_store; end

  # Returns the value of attribute options.
  #
  # source://rubocop//lib/rubocop/cli.rb#22
  def options; end

  # Entry point for the application logic. Here we
  # do the command line arguments processing and inspect
  # the target files.
  #
  #
  # @api public
  # @param args [Array<String>] command line arguments
  # @return [Integer] UNIX exit code
  #
  # source://rubocop//lib/rubocop/cli.rb#39
  def run(args = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cli.rb#156
  def act_on_options; end

  # source://rubocop//lib/rubocop/cli.rb#198
  def apply_default_formatter; end

  # source://rubocop//lib/rubocop/cli.rb#125
  def execute_runners; end

  # source://rubocop//lib/rubocop/cli.rb#182
  def handle_editor_mode; end

  # @raise [Finished]
  #
  # source://rubocop//lib/rubocop/cli.rb#187
  def handle_exiting_options; end

  # source://rubocop//lib/rubocop/cli.rb#144
  def parallel_by_default!; end

  # source://rubocop//lib/rubocop/cli.rb#80
  def profile_if_needed; end

  # source://rubocop//lib/rubocop/cli.rb#113
  def require_gem(name); end

  # source://rubocop//lib/rubocop/cli.rb#121
  def run_command(name); end

  # source://rubocop//lib/rubocop/cli.rb#174
  def set_options_to_config_loader; end

  # source://rubocop//lib/rubocop/cli.rb#133
  def suggest_extensions; end

  # @raise [OptionArgumentError]
  #
  # source://rubocop//lib/rubocop/cli.rb#137
  def validate_options_vs_config; end
end

# Home of subcommands in the CLI.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command.rb#7
module RuboCop::CLI::Command
  class << self
    # Find the command with a given name and run it in an environment.
    #
    # @api private
    #
    # source://rubocop//lib/rubocop/cli/command.rb#10
    def run(env, name); end

    private

    # @api private
    #
    # source://rubocop//lib/rubocop/cli/command.rb#16
    def class_for(name); end
  end
end

# Generate a configuration file acting as a TODO list.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#8
class RuboCop::CLI::Command::AutoGenerateConfig < ::RuboCop::CLI::Command::Base
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#25
  def run; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#107
  def add_formatter; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#115
  def add_inheritance_from_auto_generated_file(config_file); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#111
  def execute_runner; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#136
  def existing_configuration(config_file); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#65
  def line_length_cop(config); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#53
  def line_length_enabled?(config); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#61
  def max_line_length(config); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#34
  def maybe_run_line_length_cop; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#73
  def only_exclude?; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#162
  def options_config_in_root?; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#69
  def options_has_only_flag?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#153
  def relative_path_to_todo_from_options_config; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#100
  def reset_config_and_auto_gen_file; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#91
  def run_all_cops(line_length_contents); end

  # Do an initial run with only Layout/LineLength so that cops that
  # depend on Layout/LineLength:Max get the correct value for that
  # parameter.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#80
  def run_line_length_cop; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#57
  def same_max_line_length?(config1, config2); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#48
  def skip_line_length_cop(reason); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#142
  def write_config_file(file_name, file_string, rubocop_yml_contents); end
end

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#11
RuboCop::CLI::Command::AutoGenerateConfig::AUTO_GENERATED_FILE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#15
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1 = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#19
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_DISABLED = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#18
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_OVERRIDDEN = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#20
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_SKIPPED_ONLY_COPS = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#22
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_SKIPPED_ONLY_EXCLUDE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#16
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_2 = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#13
RuboCop::CLI::Command::AutoGenerateConfig::PLACEHOLDER = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cli/command/auto_generate_config.rb#12
RuboCop::CLI::Command::AutoGenerateConfig::YAML_OPTIONAL_DOC_START = T.let(T.unsafe(nil), Regexp)

# A subcommand in the CLI.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/base.rb#8
class RuboCop::CLI::Command::Base
  # @api private
  # @return [Base] a new instance of Base
  #
  # source://rubocop//lib/rubocop/cli/command/base.rb#26
  def initialize(env); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/base.rb#9
  def env; end

  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/cli/command/base.rb#21
    def by_command_name(name); end

    # @api private
    #
    # source://rubocop//lib/rubocop/cli/command/base.rb#14
    def command_name; end

    # @api private
    #
    # source://rubocop//lib/rubocop/cli/command/base.rb#14
    def command_name=(_arg0); end

    # @api private
    # @private
    #
    # source://rubocop//lib/rubocop/cli/command/base.rb#16
    def inherited(subclass); end
  end
end

# Run all the selected cops and report the result.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/execute_runner.rb#8
class RuboCop::CLI::Command::ExecuteRunner < ::RuboCop::CLI::Command::Base
  include ::RuboCop::Formatter::TextUtil

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#16
  def run; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#85
  def bug_tracker_uri; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#69
  def display_error_summary(errors); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#56
  def display_summary(runner); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#61
  def display_warning_summary(warnings); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#22
  def execute_runner(paths); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#91
  def maybe_print_corrected_source; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/execute_runner.rb#42
  def with_redirect; end
end

# Combination of short and long formatter names.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/execute_runner.rb#12
RuboCop::CLI::Command::ExecuteRunner::INTEGRATION_FORMATTERS = T.let(T.unsafe(nil), Array)

# Generate a .rubocop.yml file in the current directory.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/init_dotfile.rb#8
class RuboCop::CLI::Command::InitDotfile < ::RuboCop::CLI::Command::Base
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/init_dotfile.rb#13
  def run; end
end

# @api private
#
# source://rubocop//lib/rubocop/cli/command/init_dotfile.rb#9
RuboCop::CLI::Command::InitDotfile::DOTFILE = T.let(T.unsafe(nil), String)

# Start Language Server Protocol of RuboCop.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/lsp.rb#10
class RuboCop::CLI::Command::LSP < ::RuboCop::CLI::Command::Base
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/lsp.rb#13
  def run; end
end

# Shows the given cops, or all cops by default, and their configurations
# for the current directory.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/show_cops.rb#9
class RuboCop::CLI::Command::ShowCops < ::RuboCop::CLI::Command::Base
  # @api private
  # @return [ShowCops] a new instance of ShowCops
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#12
  def initialize(env); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#19
  def run; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#67
  def config_lines(cop); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#63
  def cops_of_department(cops, department); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#25
  def print_available_cops; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#48
  def print_cop_details(cops); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#36
  def print_cops_of_department(registry, department, show_all); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_cops.rb#57
  def selected_cops_of_department(cops, department); end
end

# Prints out url to documentation of provided cops
# or documentation base url by default.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#9
class RuboCop::CLI::Command::ShowDocsUrl < ::RuboCop::CLI::Command::Base
  # @api private
  # @return [ShowDocsUrl] a new instance of ShowDocsUrl
  #
  # source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#12
  def initialize(env); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#18
  def run; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#38
  def cops_array; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#24
  def print_documentation_url; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/show_docs_url.rb#42
  def registry_hash; end
end

# Suggest RuboCop extensions to install based on Gemfile dependencies.
# Only primary dependencies are evaluated, so if a dependency depends on a
# gem with an extension, it is not suggested. However, if an extension is
# a transitive dependency, it will not be suggested.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#11
class RuboCop::CLI::Command::SuggestExtensions < ::RuboCop::CLI::Command::Base
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#17
  def run; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#73
  def all_extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#69
  def current_formatter; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#111
  def dependent_gems; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#87
  def extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#103
  def installed_and_not_loaded_extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#91
  def installed_extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#115
  def installed_gems; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#99
  def loaded_extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#107
  def lockfile; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#95
  def not_installed_extensions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#41
  def print_install_suggestions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#51
  def print_load_suggestions; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#60
  def print_opt_out_instruction; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#119
  def puts(*args); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#30
  def skip?; end
end

# Combination of short and long formatter names.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/suggest_extensions.rb#13
RuboCop::CLI::Command::SuggestExtensions::INCLUDED_FORMATTERS = T.let(T.unsafe(nil), Array)

# Display version.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/command/version.rb#8
class RuboCop::CLI::Command::Version < ::RuboCop::CLI::Command::Base
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/command/version.rb#11
  def run; end
end

# source://rubocop//lib/rubocop/cli.rb#13
RuboCop::CLI::DEFAULT_PARALLEL_OPTIONS = T.let(T.unsafe(nil), Array)

# Execution environment for a CLI command.
#
# @api private
#
# source://rubocop//lib/rubocop/cli/environment.rb#7
class RuboCop::CLI::Environment
  # @api private
  # @return [Environment] a new instance of Environment
  #
  # source://rubocop//lib/rubocop/cli/environment.rb#10
  def initialize(options, config_store, paths); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/environment.rb#8
  def config_store; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/environment.rb#8
  def options; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cli/environment.rb#8
  def paths; end

  # Run a command in this environment.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cli/environment.rb#17
  def run(name); end
end

# source://rubocop//lib/rubocop/cli.rb#20
class RuboCop::CLI::Finished < ::StandardError; end

# source://rubocop//lib/rubocop/cli.rb#11
RuboCop::CLI::STATUS_ERROR = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cli.rb#12
RuboCop::CLI::STATUS_INTERRUPTED = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cli.rb#10
RuboCop::CLI::STATUS_OFFENSES = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cli.rb#9
RuboCop::CLI::STATUS_SUCCESS = T.let(T.unsafe(nil), Integer)

# This class represents the cache config of the caching RuboCop runs.
#
# @api private
#
# source://rubocop//lib/rubocop/cache_config.rb#6
class RuboCop::CacheConfig
  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/cache_config.rb#7
    def root_dir; end
  end
end

# Converts RuboCop objects to and from the serialization format JSON.
#
# @api private
#
# source://rubocop//lib/rubocop/cached_data.rb#8
class RuboCop::CachedData
  # @api private
  # @return [CachedData] a new instance of CachedData
  #
  # source://rubocop//lib/rubocop/cached_data.rb#9
  def initialize(filename); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#13
  def from_json(text); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#17
  def to_json(offenses); end

  private

  # Restore an offense object loaded from a JSON file.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#47
  def deserialize_offenses(offenses); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#56
  def location_from_source_buffer(offense, source_buffer); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#40
  def message(offense); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cached_data.rb#23
  def serialize_offense(offense); end
end

# and provides a way to check if each cop is enabled at arbitrary line.
#
# source://rubocop//lib/rubocop/comment_config.rb#6
class RuboCop::CommentConfig
  extend ::Forwardable

  # @return [CommentConfig] a new instance of CommentConfig
  #
  # source://rubocop//lib/rubocop/comment_config.rb#34
  def initialize(processed_source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/comment_config.rb#63
  def comment_only_line?(line_number); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def config(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/comment_config.rb#51
  def cop_disabled_line_ranges; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/comment_config.rb#39
  def cop_enabled_at_line?(cop, line_number); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/comment_config.rb#47
  def cop_opted_in?(cop); end

  # source://rubocop//lib/rubocop/comment_config.rb#55
  def extra_enabled_comments; end

  # Returns the value of attribute processed_source.
  #
  # source://rubocop//lib/rubocop/comment_config.rb#30
  def processed_source; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def registry(*args, **_arg1, &block); end

  private

  # source://rubocop//lib/rubocop/comment_config.rb#96
  def analyze; end

  # source://rubocop//lib/rubocop/comment_config.rb#124
  def analyze_cop(analysis, directive); end

  # source://rubocop//lib/rubocop/comment_config.rb#144
  def analyze_disabled(analysis, directive); end

  # source://rubocop//lib/rubocop/comment_config.rb#155
  def analyze_rest(analysis, directive); end

  # source://rubocop//lib/rubocop/comment_config.rb#135
  def analyze_single_line(analysis, directive); end

  # source://rubocop//lib/rubocop/comment_config.rb#164
  def cop_line_ranges(analysis); end

  # source://rubocop//lib/rubocop/comment_config.rb#170
  def each_directive; end

  # source://rubocop//lib/rubocop/comment_config.rb#69
  def extra_enabled_comments_with_names(extras:, names:); end

  # source://rubocop//lib/rubocop/comment_config.rb#190
  def handle_enable_all(directive, names, extras); end

  # Collect cops that have been disabled or enabled by name in a directive comment
  # so that `Lint/RedundantCopEnableDirective` can register offenses correctly.
  #
  # source://rubocop//lib/rubocop/comment_config.rb#204
  def handle_switch(directive, names, extras); end

  # source://rubocop//lib/rubocop/comment_config.rb#115
  def inject_disabled_cops_directives(analyses); end

  # source://rubocop//lib/rubocop/comment_config.rb#183
  def non_comment_token_line_numbers; end

  # source://rubocop//lib/rubocop/comment_config.rb#83
  def opt_in_cops; end

  # source://rubocop//lib/rubocop/comment_config.rb#179
  def qualified_cop_name(cop_name); end
end

# source://rubocop//lib/rubocop/comment_config.rb#9
RuboCop::CommentConfig::CONFIG_DISABLED_LINE_RANGE_MIN = T.let(T.unsafe(nil), Float)

# This class provides an API compatible with RuboCop::DirectiveComment
# to be used for cops that are disabled in the config file
#
# source://rubocop//lib/rubocop/comment_config.rb#13
class RuboCop::CommentConfig::ConfigDisabledCopDirectiveComment
  include ::RuboCop::Ext::Comment

  # @return [ConfigDisabledCopDirectiveComment] a new instance of ConfigDisabledCopDirectiveComment
  #
  # source://rubocop//lib/rubocop/comment_config.rb#21
  def initialize(cop_name); end

  # Returns the value of attribute line_number.
  #
  # source://rubocop//lib/rubocop/comment_config.rb#16
  def line_number; end

  # Returns the value of attribute loc.
  #
  # source://rubocop//lib/rubocop/comment_config.rb#16
  def loc; end

  # Returns the value of attribute text.
  #
  # source://rubocop//lib/rubocop/comment_config.rb#16
  def text; end
end

# source://rubocop//lib/rubocop/comment_config.rb#19
class RuboCop::CommentConfig::ConfigDisabledCopDirectiveComment::Expression < ::Struct
  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def line; end

  # Sets the attribute line
  #
  # @param value [Object] the value to set the attribute line to.
  # @return [Object] the newly set value
  def line=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/comment_config.rb#18
class RuboCop::CommentConfig::ConfigDisabledCopDirectiveComment::Loc < ::Struct
  # Returns the value of attribute expression
  #
  # @return [Object] the current value of expression
  def expression; end

  # Sets the attribute expression
  #
  # @param value [Object] the value to set the attribute expression to.
  # @return [Object] the newly set value
  def expression=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/comment_config.rb#28
class RuboCop::CommentConfig::CopAnalysis < ::Struct
  # Returns the value of attribute line_ranges
  #
  # @return [Object] the current value of line_ranges
  def line_ranges; end

  # Sets the attribute line_ranges
  #
  # @param value [Object] the value to set the attribute line_ranges to.
  # @return [Object] the newly set value
  def line_ranges=(_); end

  # Returns the value of attribute start_line_number
  #
  # @return [Object] the current value of start_line_number
  def start_line_number; end

  # Sets the attribute start_line_number
  #
  # @param value [Object] the value to set the attribute start_line_number to.
  # @return [Object] the newly set value
  def start_line_number=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This class represents the configuration of the RuboCop application
# and all its cops. A Config is associated with a YAML configuration
# file from which it was read. Several different Configs can be used
# during a run of the rubocop program, if files in several
# directories are inspected.
#
# source://rubocop//lib/rubocop/config.rb#12
class RuboCop::Config
  include ::RuboCop::PathUtil
  include ::RuboCop::FileFinder
  extend ::Forwardable

  # @return [Config] a new instance of Config
  #
  # source://rubocop//lib/rubocop/config.rb#30
  def initialize(hash = T.unsafe(nil), loaded_path = T.unsafe(nil)); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def [](*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def []=(*args, **_arg1, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#170
  def active_support_extensions_enabled?; end

  # source://rubocop//lib/rubocop/config.rb#96
  def add_excludes_from_higher_level(highest_config); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#193
  def allowed_camel_case_file?(file); end

  # Paths specified in configuration files starting with .rubocop are
  # relative to the directory where that file is. Paths in other config files
  # are relative to the current directory. This is so that paths in
  # config/default.yml, for example, are not relative to RuboCop's config
  # directory since that wouldn't work.
  #
  # source://rubocop//lib/rubocop/config.rb#237
  def base_dir_for_path_parameters; end

  # @return [String, nil]
  #
  # source://rubocop//lib/rubocop/config.rb#267
  def bundler_lock_file_path; end

  # source://rubocop//lib/rubocop/config.rb#51
  def check; end

  # @api private
  # @return [Boolean] whether config for this badge has 'Include' or 'Exclude' keys
  #
  # source://rubocop//lib/rubocop/config.rb#142
  def clusivity_config_for_badge?(badge); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def delete(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#108
  def deprecation_check; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def dig(*args, **_arg1, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#162
  def disabled_new_cops?; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def each(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def each_key(*args, **_arg1, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#166
  def enabled_new_cops?; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def fetch(*args, **_arg1, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#215
  def file_to_exclude?(file); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#174
  def file_to_include?(file); end

  # source://rubocop//lib/rubocop/config.rb#158
  def for_all_cops; end

  # Note: the 'Enabled' attribute is same as that returned by `for_cop`
  #
  # @return [Config] for the given cop merged with that of its department (if any)
  #
  # source://rubocop//lib/rubocop/config.rb#128
  def for_badge(badge); end

  # Note: the 'Enabled' attribute is calculated according to the department's
  # and 'AllCops' configuration; other attributes are not inherited.
  #
  # @return [Config] for the given cop / cop name.
  #
  # source://rubocop//lib/rubocop/config.rb#122
  def for_cop(cop); end

  # Note: the 'Enabled' attribute will be present only if specified
  # at the department's level
  #
  # @return [Config] for the given department name.
  #
  # source://rubocop//lib/rubocop/config.rb#153
  def for_department(department_name); end

  # Returns target's locked gem versions (i.e. from Gemfile.lock or gems.locked)
  #
  # source://rubocop//lib/rubocop/config.rb#292
  def gem_versions_in_target; end

  # source://rubocop//lib/rubocop/config.rb#296
  def inspect; end

  # True if this is a config file that is shipped with RuboCop
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#76
  def internal?; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def key?(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def keys(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#47
  def loaded_features; end

  # Returns the value of attribute loaded_path.
  #
  # source://rubocop//lib/rubocop/config.rb#20
  def loaded_path; end

  # source://rubocop//lib/rubocop/config.rb#81
  def make_excludes_absolute; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def map(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def merge(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#247
  def parser_engine; end

  # source://rubocop//lib/rubocop/config.rb#228
  def path_relative_to_config(path); end

  # source://rubocop//lib/rubocop/config.rb#224
  def patterns_to_exclude; end

  # source://rubocop//lib/rubocop/config.rb#220
  def patterns_to_include; end

  # source://rubocop//lib/rubocop/config.rb#278
  def pending_cops; end

  # Returns true if there's a chance that an Include pattern matches hidden
  # files, false if that's definitely not possible.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#207
  def possibly_include_hidden?; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def replace(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#71
  def signature; end

  # source://rubocop//lib/rubocop/config.rb#262
  def smart_loaded_path; end

  # source://rubocop//lib/rubocop/config.rb#251
  def target_rails_version; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def target_ruby_version(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def to_h(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def to_hash(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#67
  def to_s; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def transform_values(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def validate(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config.rb#58
  def validate_after_resolution; end

  private

  # source://rubocop//lib/rubocop/config.rb#346
  def department_of(qualified_cop_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config.rb#334
  def enable_cop?(qualified_cop_name, cop_options); end

  # @param gem_version [Gem::Version] an object like `Gem::Version.new("7.1.2.3")`
  # @return [Float] The major and minor version, like `7.1`
  #
  # source://rubocop//lib/rubocop/config.rb#321
  def gem_version_to_major_minor_float(gem_version); end

  # source://rubocop//lib/rubocop/config.rb#327
  def read_gem_versions_from_target_lockfile; end

  # @return [Float, nil] The Rails version as a `major.minor` Float.
  #
  # source://rubocop//lib/rubocop/config.rb#308
  def read_rails_version_from_bundler_lock_file; end

  # @return [Float, nil] The Rails version as a `major.minor` Float.
  #
  # source://rubocop//lib/rubocop/config.rb#303
  def target_rails_version_from_bundler_lock_file; end

  class << self
    # source://rubocop//lib/rubocop/config.rb#22
    def create(hash, path, check: T.unsafe(nil)); end
  end
end

# source://rubocop//lib/rubocop/config.rb#17
class RuboCop::Config::CopConfig < ::Struct
  # Returns the value of attribute metadata
  #
  # @return [Object] the current value of metadata
  def metadata; end

  # Sets the attribute metadata
  #
  # @param value [Object] the value to set the attribute metadata to.
  # @return [Object] the newly set value
  def metadata=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/config.rb#19
RuboCop::Config::DEFAULT_RAILS_VERSION = T.let(T.unsafe(nil), Float)

# This class has methods related to finding configuration path.
#
# @api private
#
# source://rubocop//lib/rubocop/config_finder.rb#8
class RuboCop::ConfigFinder
  extend ::RuboCop::FileFinder

  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#19
    def find_config_path(target_dir); end

    # Returns the path RuboCop inferred as the root of the project. No file
    # searches will go past this directory.
    #
    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#26
    def project_root; end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#17
    def project_root=(_arg0); end

    private

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#69
    def expand_path(path); end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#40
    def find_project_dotfile(target_dir); end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#32
    def find_project_root; end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#44
    def find_project_root_dot_config; end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#54
    def find_user_dotfile; end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_finder.rb#62
    def find_user_xdg_config; end
  end
end

# @api private
#
# source://rubocop//lib/rubocop/config_finder.rb#12
RuboCop::ConfigFinder::DEFAULT_FILE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/config_finder.rb#9
RuboCop::ConfigFinder::DOTFILE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/config_finder.rb#11
RuboCop::ConfigFinder::RUBOCOP_HOME = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/config_finder.rb#10
RuboCop::ConfigFinder::XDG_CONFIG = T.let(T.unsafe(nil), String)

# This class represents the configuration of the RuboCop application
# and all its cops. A Config is associated with a YAML configuration
# file from which it was read. Several different Configs can be used
# during a run of the rubocop program, if files in several
# directories are inspected.
#
# source://rubocop//lib/rubocop/config_loader.rb#17
class RuboCop::ConfigLoader
  extend ::RuboCop::FileFinder

  class << self
    # source://rubocop//lib/rubocop/config_loader.rb#137
    def add_excludes_from_files(config, config_file); end

    # Used to add features that were required inside a config or from
    # the CLI using `--require`.
    #
    # @api private
    #
    # source://rubocop//lib/rubocop/config_loader.rb#198
    def add_loaded_features(loaded_features); end

    # source://rubocop//lib/rubocop/config_loader.rb#80
    def add_missing_namespaces(path, hash); end

    # source://rubocop//lib/rubocop/config_loader.rb#41
    def clear_options; end

    # Returns the path of .rubocop.yml searching upwards in the
    # directory structure starting at the given directory where the
    # inspected file is. If no .rubocop.yml is found there, the
    # user's home directory is checked. If there's no .rubocop.yml
    # there either, the path to the default file is returned.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#104
    def configuration_file_for(target_dir); end

    # source://rubocop//lib/rubocop/config_loader.rb#108
    def configuration_from_file(config_file, check: T.unsafe(nil)); end

    # Returns the value of attribute debug.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def debug; end

    # Sets the attribute debug
    #
    # @param value the value to set the attribute debug to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def debug=(_arg0); end

    # Returns the value of attribute debug.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def debug?; end

    # source://rubocop//lib/rubocop/config_loader.rb#147
    def default_configuration; end

    # Sets the attribute default_configuration
    #
    # @param value the value to set the attribute default_configuration to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#35
    def default_configuration=(_arg0); end

    # Returns the value of attribute disable_pending_cops.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def disable_pending_cops; end

    # Sets the attribute disable_pending_cops
    #
    # @param value the value to set the attribute disable_pending_cops to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def disable_pending_cops=(_arg0); end

    # Returns the value of attribute enable_pending_cops.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def enable_pending_cops; end

    # Sets the attribute enable_pending_cops
    #
    # @param value the value to set the attribute enable_pending_cops to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def enable_pending_cops=(_arg0); end

    # Returns the value of attribute ignore_parent_exclusion.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def ignore_parent_exclusion; end

    # Sets the attribute ignore_parent_exclusion
    #
    # @param value the value to set the attribute ignore_parent_exclusion to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def ignore_parent_exclusion=(_arg0); end

    # Returns the value of attribute ignore_parent_exclusion.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def ignore_parent_exclusion?; end

    # Returns the value of attribute ignore_unrecognized_cops.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def ignore_unrecognized_cops; end

    # Sets the attribute ignore_unrecognized_cops
    #
    # @param value the value to set the attribute ignore_unrecognized_cops to.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#33
    def ignore_unrecognized_cops=(_arg0); end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_loader.rb#155
    def inject_defaults!(project_root); end

    # source://rubocop//lib/rubocop/config_loader.rb#47
    def load_file(file, check: T.unsafe(nil)); end

    # @raise [TypeError]
    #
    # source://rubocop//lib/rubocop/config_loader.rb#67
    def load_yaml_configuration(absolute_path); end

    # Returns the value of attribute loaded_features.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#36
    def loaded_features; end

    # Return a recursive merge of two hashes. That is, a normal hash merge,
    # with the addition that any value that is a hash, and occurs in both
    # arguments, will also be merged. And so on.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#95
    def merge(base_hash, derived_hash); end

    # Merges the given configuration with the default one.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#191
    def merge_with_default(config, config_file, unset_nil: T.unsafe(nil)); end

    # source://rubocop//lib/rubocop/config_loader.rb#128
    def pending_cops_only_qualified(pending_cops); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/config_loader.rb#132
    def possible_new_cops?(config); end

    # Returns the path RuboCop inferred as the root of the project. No file
    # searches will go past this directory.
    #
    # @deprecated Use `RuboCop::ConfigFinder.project_root` instead.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#166
    def project_root; end

    # source://rubocop//lib/rubocop/config_loader.rb#175
    def warn_on_pending_cops(pending_cops); end

    # source://rubocop//lib/rubocop/config_loader.rb#183
    def warn_pending_cop(cop); end

    private

    # source://rubocop//lib/rubocop/config_loader.rb#212
    def check_duplication(yaml_code, absolute_path); end

    # source://rubocop//lib/rubocop/config_loader.rb#204
    def file_path(file); end

    # Read the specified file, or exit with a friendly, concise message on
    # stderr. Care is taken to use the standard OS exit code for a "file not
    # found" error.
    #
    # source://rubocop//lib/rubocop/config_loader.rb#232
    def read_file(absolute_path); end

    # source://rubocop//lib/rubocop/config_loader.rb#208
    def resolver; end

    # source://rubocop//lib/rubocop/config_loader.rb#238
    def yaml_safe_load(yaml_code, filename); end

    # source://rubocop//lib/rubocop/config_loader.rb#248
    def yaml_safe_load!(yaml_code, filename); end
  end
end

# source://rubocop//lib/rubocop/config_loader.rb#20
RuboCop::ConfigLoader::DEFAULT_FILE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/config_loader.rb#18
RuboCop::ConfigLoader::DOTFILE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/config_loader.rb#19
RuboCop::ConfigLoader::RUBOCOP_HOME = T.let(T.unsafe(nil), String)

# A help class for ConfigLoader that handles configuration resolution.
#
# @api private
#
# source://rubocop//lib/rubocop/config_loader_resolver.rb#9
class RuboCop::ConfigLoaderResolver
  # When one .rubocop.yml file inherits from another .rubocop.yml file, the Include paths in the
  # base configuration are relative to the directory where the base configuration file is. For the
  # derived configuration, we need to make those paths relative to where the derived configuration
  # file is.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#45
  def fix_include_paths(base_config_path, hash, path, key, value); end

  # Return a recursive merge of two hashes. That is, a normal hash merge,
  # with the addition that any value that is a hash, and occurs in both
  # arguments, will also be merged. And so on.
  #
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#99
  def merge(base_hash, derived_hash, **opts); end

  # Merges the given configuration with the default one. If
  # AllCops:DisabledByDefault is true, it changes the Enabled params so that
  # only cops from user configuration are enabled. If
  # AllCops:EnabledByDefault is true, it changes the Enabled params so that
  # only cops explicitly disabled in user configuration are disabled.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#75
  def merge_with_default(config, config_file, unset_nil:); end

  # An `Enabled: true` setting in user configuration for a cop overrides an
  # `Enabled: false` setting for its department.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#119
  def override_department_setting_for_cops(base_hash, derived_hash); end

  # If a cop was previously explicitly enabled, but then superseded by the
  # department being disabled, disable it.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#136
  def override_enabled_for_disabled_departments(base_hash, derived_hash); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#19
  def resolve_inheritance(path, hash, file, debug); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#55
  def resolve_inheritance_from_gems(hash); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#10
  def resolve_requires(path, hash); end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#208
  def base_configs(path, inherit_from, file); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#176
  def determine_inherit_mode(hash, key); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#152
  def disabled?(hash, department); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#156
  def duplicate_setting?(base_hash, derived_hash, key, inherited_file); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#268
  def gem_config_path(gem_name, relative_config_path); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#246
  def handle_disabled_by_default(config, new_default_configuration); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#220
  def inherited_file(path, inherit_from, file); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#204
  def merge_hashes?(base_hash, derived_hash, key); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#241
  def remote_file?(uri); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#196
  def should_merge?(mode, key); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#200
  def should_override?(mode, key); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#182
  def should_union?(derived_hash, base_hash, root_mode, key); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#264
  def transform(config, &block); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_loader_resolver.rb#165
  def warn_on_duplicate_setting(base_hash, derived_hash, key, **opts); end
end

# Raised when a RuboCop configuration file is not found.
#
# source://rubocop//lib/rubocop/config_loader.rb#9
class RuboCop::ConfigNotFoundError < ::RuboCop::Error; end

# This class handles obsolete configuration.
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/rule.rb#4
class RuboCop::ConfigObsoletion
  # @api private
  # @return [ConfigObsoletion] a new instance of ConfigObsoletion
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#35
  def initialize(config); end

  # @api private
  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#41
  def reject_obsolete!; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#21
  def rules; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#21
  def warnings; end

  private

  # Cop rules are keyed by the name of the original cop
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#72
  def load_cop_rules(rules); end

  # Parameter rules may apply to multiple cops and multiple parameters
  # and are given as an array. Each combination is turned into a separate
  # rule object.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#85
  def load_parameter_rules(rules); end

  # Default rules for obsoletions are in config/obsoletion.yml
  # Additional rules files can be added with `RuboCop::ConfigObsoletion.files << filename`
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#52
  def load_rules; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion.rb#98
  def obsoletions; end

  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/config_obsoletion.rb#24
    def files; end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_obsoletion.rb#24
    def files=(_arg0); end

    # @api private
    #
    # source://rubocop//lib/rubocop/config_obsoletion.rb#26
    def legacy_cop_names; end
  end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion.rb#8
RuboCop::ConfigObsoletion::COP_RULE_CLASSES = T.let(T.unsafe(nil), Hash)

# Encapsulation of a ConfigObsoletion rule for changing a parameter
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/changed_enforced_styles.rb#7
class RuboCop::ConfigObsoletion::ChangedEnforcedStyles < ::RuboCop::ConfigObsoletion::ParameterRule
  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/changed_enforced_styles.rb#14
  def message; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/changed_enforced_styles.rb#10
  def violated?; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/changed_enforced_styles.rb#28
  def value; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/changed_enforced_styles.rb#8
RuboCop::ConfigObsoletion::ChangedEnforcedStyles::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for changing a parameter
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/changed_parameter.rb#7
class RuboCop::ConfigObsoletion::ChangedParameter < ::RuboCop::ConfigObsoletion::ParameterRule
  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/changed_parameter.rb#10
  def message; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/changed_parameter.rb#8
RuboCop::ConfigObsoletion::ChangedParameter::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Base class for ConfigObsoletion rules relating to cops
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#7
class RuboCop::ConfigObsoletion::CopRule < ::RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [CopRule] a new instance of CopRule
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#10
  def initialize(config, old_name); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#15
  def cop_rule?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#19
  def message; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#8
  def old_name; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#28
  def violated?; end

  # Cop rules currently can only be failures, not warnings
  #
  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/cop_rule.rb#24
  def warning?; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion.rb#7
RuboCop::ConfigObsoletion::DEFAULT_RULES_FILE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for splitting a cop's
# functionality into multiple new cops.
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#8
class RuboCop::ConfigObsoletion::ExtractedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [ExtractedCop] a new instance of ExtractedCop
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#11
  def initialize(config, old_name, gem); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#9
  def department; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#9
  def gem; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#23
  def rule_message; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#17
  def violated?; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#32
  def affected_cops; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/extracted_cop.rb#41
  def feature_loaded?; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion.rb#18
RuboCop::ConfigObsoletion::LOAD_RULES_CACHE = T.let(T.unsafe(nil), Hash)

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion.rb#14
RuboCop::ConfigObsoletion::PARAMETER_RULE_CLASSES = T.let(T.unsafe(nil), Hash)

# Base class for ConfigObsoletion rules relating to parameters
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#7
class RuboCop::ConfigObsoletion::ParameterRule < ::RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [ParameterRule] a new instance of ParameterRule
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#10
  def initialize(config, cop, parameter, metadata); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#8
  def cop; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#8
  def metadata; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#8
  def parameter; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#17
  def parameter_rule?; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#21
  def violated?; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#25
  def warning?; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#39
  def alternative; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#43
  def alternatives; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#31
  def applies_to_current_ruby_version?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#47
  def reason; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/parameter_rule.rb#51
  def severity; end
end

# Encapsulation of a ConfigObsoletion rule for removing
# a previously defined cop.
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#8
class RuboCop::ConfigObsoletion::RemovedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [RemovedCop] a new instance of RemovedCop
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#13
  def initialize(config, old_name, metadata); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#9
  def metadata; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#9
  def old_name; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#18
  def rule_message; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#36
  def alternatives; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#32
  def reason; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/removed_cop.rb#11
RuboCop::ConfigObsoletion::RemovedCop::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for renaming
# a cop or moving it to a new department.
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#8
class RuboCop::ConfigObsoletion::RenamedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [RenamedCop] a new instance of RenamedCop
  #
  # source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#11
  def initialize(config, old_name, new_name); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#9
  def new_name; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#16
  def rule_message; end

  private

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#22
  def moved?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/renamed_cop.rb#29
  def verb; end
end

# Abstract base class for ConfigObsoletion rules
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/rule.rb#7
class RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [Rule] a new instance of Rule
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#8
  def initialize(config); end

  # Does this rule relate to cops?
  #
  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#13
  def cop_rule?; end

  # Does this rule relate to parameters?
  #
  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#18
  def parameter_rule?; end

  # @api private
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#22
  def violated?; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#28
  def config; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#36
  def smart_loaded_path; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/rule.rb#30
  def to_sentence(collection, connector: T.unsafe(nil)); end
end

# Encapsulation of a ConfigObsoletion rule for splitting a cop's
# functionality into multiple new cops.
#
# @api private
#
# source://rubocop//lib/rubocop/config_obsoletion/split_cop.rb#8
class RuboCop::ConfigObsoletion::SplitCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [SplitCop] a new instance of SplitCop
  #
  # source://rubocop//lib/rubocop/config_obsoletion/split_cop.rb#11
  def initialize(config, old_name, metadata); end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/split_cop.rb#9
  def metadata; end

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/split_cop.rb#16
  def rule_message; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_obsoletion/split_cop.rb#22
  def alternatives; end
end

# This class handles collecting the options for regenerating a TODO file.
#
# @api private
#
# source://rubocop//lib/rubocop/config_regeneration.rb#6
class RuboCop::ConfigRegeneration
  # Get options from the comment in the TODO file, and parse them as options
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/config_regeneration.rb#12
  def options; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/config_regeneration.rb#29
  def generation_command; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/config_regeneration.rb#25
  def todo_exists?; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_regeneration.rb#7
RuboCop::ConfigRegeneration::AUTO_GENERATED_FILE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/config_regeneration.rb#8
RuboCop::ConfigRegeneration::COMMAND_REGEX = T.let(T.unsafe(nil), Regexp)

# @api private
#
# source://rubocop//lib/rubocop/config_regeneration.rb#9
RuboCop::ConfigRegeneration::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# Handles caching of configurations and association of inspected
# ruby files to configurations.
#
# source://rubocop//lib/rubocop/config_store.rb#6
class RuboCop::ConfigStore
  # @return [ConfigStore] a new instance of ConfigStore
  #
  # source://rubocop//lib/rubocop/config_store.rb#10
  def initialize; end

  # If type (file/dir) is known beforehand,
  # prefer using #for_file or #for_dir for improved performance
  #
  # source://rubocop//lib/rubocop/config_store.rb#52
  def for(file_or_dir); end

  # source://rubocop//lib/rubocop/config_store.rb#61
  def for_dir(dir); end

  # source://rubocop//lib/rubocop/config_store.rb#42
  def for_file(file); end

  # source://rubocop//lib/rubocop/config_store.rb#46
  def for_pwd; end

  # source://rubocop//lib/rubocop/config_store.rb#33
  def force_default_config!; end

  # source://rubocop//lib/rubocop/config_store.rb#28
  def options_config=(options_config); end

  # source://rubocop//lib/rubocop/config_store.rb#37
  def unvalidated; end

  # Returns the value of attribute validated.
  #
  # source://rubocop//lib/rubocop/config_store.rb#7
  def validated; end

  # Returns the value of attribute validated.
  #
  # source://rubocop//lib/rubocop/config_store.rb#7
  def validated?; end
end

# Handles validation of configuration, for example cop names, parameter
# names, and Ruby versions.
#
# source://rubocop//lib/rubocop/config_validator.rb#6
class RuboCop::ConfigValidator
  extend ::Forwardable

  # @return [ConfigValidator] a new instance of ConfigValidator
  #
  # source://rubocop//lib/rubocop/config_validator.rb#26
  def initialize(config); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def for_all_cops(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def smart_loaded_path(*args, **_arg1, &block); end

  # source://rubocop//lib/rubocop/config_validator.rb#62
  def target_ruby_version; end

  # source://rubocop//lib/rubocop/config_validator.rb#32
  def validate; end

  # Validations that should only be run after all config resolving has
  # taken place:
  # * The target ruby version is only checked once the entire inheritance
  # chain has been loaded so that only the final value is validated, and
  # any obsolete but overridden values are ignored.
  #
  # source://rubocop//lib/rubocop/config_validator.rb#58
  def validate_after_resolution; end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#66
  def validate_section_presence(name); end

  private

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#103
  def alert_about_unrecognized_cops(invalid_cop_names); end

  # source://rubocop//lib/rubocop/config_validator.rb#253
  def check_cop_config_value(hash, parent = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/config_validator.rb#76
  def check_obsoletions; end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#83
  def check_target_ruby; end

  # source://rubocop//lib/rubocop/config_validator.rb#194
  def each_invalid_parameter(cop_name); end

  # source://rubocop//lib/rubocop/config_validator.rb#119
  def list_unknown_cops(invalid_cop_names); end

  # FIXME: Handling colors in exception messages like this is ugly.
  #
  # source://rubocop//lib/rubocop/config_validator.rb#273
  def param_error_message(parent, key, value, supposed_values); end

  # source://rubocop//lib/rubocop/config_validator.rb#241
  def reject_conflicting_safe_settings; end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#232
  def reject_mutually_exclusive_defaults; end

  # source://rubocop//lib/rubocop/config_validator.rb#141
  def suggestion(name); end

  # Returns the value of attribute target_ruby.
  #
  # source://rubocop//lib/rubocop/config_validator.rb#74
  def target_ruby; end

  # source://rubocop//lib/rubocop/config_validator.rb#206
  def validate_enforced_styles(valid_cop_names); end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#168
  def validate_new_cops_parameter; end

  # source://rubocop//lib/rubocop/config_validator.rb#179
  def validate_parameter_names(valid_cop_names); end

  # source://rubocop//lib/rubocop/config_validator.rb#226
  def validate_support_and_has_list(name, formats, valid); end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/config_validator.rb#157
  def validate_syntax_cop; end
end

# @api private
#
# source://rubocop//lib/rubocop/config_validator.rb#10
RuboCop::ConfigValidator::COMMON_PARAMS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/config_validator.rb#21
RuboCop::ConfigValidator::CONFIG_CHECK_AUTOCORRECTS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/config_validator.rb#20
RuboCop::ConfigValidator::CONFIG_CHECK_DEPARTMENTS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop//lib/rubocop/config_validator.rb#19
RuboCop::ConfigValidator::CONFIG_CHECK_KEYS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop//lib/rubocop/config_validator.rb#12
RuboCop::ConfigValidator::INTERNAL_PARAMS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop//lib/rubocop/config_validator.rb#16
RuboCop::ConfigValidator::NEW_COPS_VALUES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/util.rb#4
module RuboCop::Cop; end

# This module checks for nodes that should be aligned to the left or right.
# This amount is determined by the instance variable @column_delta.
#
# source://rubocop//lib/rubocop/cop/mixin/alignment.rb#7
module RuboCop::Cop::Alignment
  private

  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#26
  def check_alignment(items, base_column = T.unsafe(nil)); end

  # Returns the value of attribute column_delta.
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#12
  def column_delta; end

  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#14
  def configured_indentation_width; end

  # @api public
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#58
  def display_column(range); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#45
  def each_bad_alignment(items, base_column); end

  # @deprecated Use processed_source.line_with_comment?(line)
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#69
  def end_of_line_comment(line); end

  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#18
  def indentation(node); end

  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#22
  def offset(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#78
  def register_offense(offense_node, message_node); end

  # @api public
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/alignment.rb#64
  def within?(inner, outer); end
end

# source://rubocop//lib/rubocop/cop/mixin/alignment.rb#10
RuboCop::Cop::Alignment::SPACE = T.let(T.unsafe(nil), String)

# This class does autocorrection of nodes that should just be moved to
# the left or to the right, amount being determined by the instance
# variable column_delta.
#
# source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#8
class RuboCop::Cop::AlignmentCorrector
  extend ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::Alignment

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#29
    def align_end(corrector, processed_source, node, align_to); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#15
    def correct(corrector, processed_source, node, column_delta); end

    # Returns the value of attribute processed_source.
    #
    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#13
    def processed_source; end

    private

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#124
    def alignment_column(align_to); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#40
    def autocorrect_line(corrector, line_begin_pos, expr, column_delta, taboo_ranges); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#81
    def block_comment_within?(expr); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#87
    def calculate_range(expr, line_begin_pos, column_delta); end

    # Some special kinds of string literals are not composed of literal
    # characters between two delimiters:
    # - The source map of `?a` responds to :begin and :end but its end is
    #   nil.
    # - The source map of `__FILE__` responds to neither :begin nor :end.
    #
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#75
    def delimited_string_literal?(node); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#110
    def each_line(expr); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#60
    def inside_string_range(node); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#54
    def inside_string_ranges(node); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#99
    def remove(range, corrector); end

    # source://rubocop//lib/rubocop/cop/correctors/alignment_corrector.rb#118
    def whitespace_range(node); end
  end
end

# This module encapsulates the ability to allow certain identifiers in a cop.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_identifiers.rb#6
module RuboCop::Cop::AllowedIdentifiers
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_identifiers.rb#9
  def allowed_identifier?(name); end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_identifiers.rb#13
  def allowed_identifiers; end
end

# if a variable starts with a sigil it will be removed
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_identifiers.rb#7
RuboCop::Cop::AllowedIdentifiers::SIGILS = T.let(T.unsafe(nil), String)

# This module encapsulates the ability to allow certain methods when
# parsing. Even if the code is in offense, if it contains methods
# that are allowed. This module is equivalent to the IgnoredMethods module,
# which will be deprecated in RuboCop 2.0.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#9
module RuboCop::Cop::AllowedMethods
  private

  # @api public
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#13
  def allowed_method?(name); end

  # @api public
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#27
  def allowed_methods; end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#35
  def cop_config_allowed_methods; end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#39
  def cop_config_deprecated_values; end

  # @deprecated Use allowed_method? instead
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#18
  def ignored_method?; end
end

# This module encapsulates the ability to ignore certain lines when
# parsing.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#7
module RuboCop::Cop::AllowedPattern
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#10
  def allowed_line?(line); end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#42
  def allowed_patterns; end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#58
  def cop_config_deprecated_methods_values; end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#52
  def cop_config_patterns_values; end

  # @deprecated Use allowed_line? instead
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#21
  def ignored_line?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#29
  def matches_allowed_pattern?(line); end

  # @deprecated Use matches_allowed_pattern? instead
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#34
  def matches_ignored_pattern?; end
end

# This module encapsulates the ability to allow certain receivers in a cop.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_receivers.rb#6
module RuboCop::Cop::AllowedReceivers
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/allowed_receivers.rb#7
  def allowed_receiver?(receiver); end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_receivers.rb#29
  def allowed_receivers; end

  # source://rubocop//lib/rubocop/cop/mixin/allowed_receivers.rb#13
  def receiver_name(receiver); end
end

# Error raised when an unqualified cop name is used that could
# refer to two or more cops under different departments
#
# source://rubocop//lib/rubocop/cop/registry.rb#7
class RuboCop::Cop::AmbiguousCopName < ::RuboCop::Error
  # @return [AmbiguousCopName] a new instance of AmbiguousCopName
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#11
  def initialize(name, origin, badges); end
end

# source://rubocop//lib/rubocop/cop/registry.rb#8
RuboCop::Cop::AmbiguousCopName::MSG = T.let(T.unsafe(nil), String)

# Representation of an annotation comment in source code (eg. `# TODO: blah blah blah`).
#
# source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#6
class RuboCop::Cop::AnnotationComment
  extend ::Forwardable

  # @param comment [Parser::Source::Comment]
  # @param keywords [Array<String>]
  # @return [AnnotationComment] a new instance of AnnotationComment
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#13
  def initialize(comment, keywords); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#19
  def annotation?; end

  # Returns the range bounds for just the annotation
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#31
  def bounds; end

  # Returns the value of attribute colon.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def colon; end

  # Returns the value of attribute comment.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def comment; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#23
  def correct?(colon:); end

  # Returns the value of attribute keyword.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def keyword; end

  # Returns the value of attribute margin.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def margin; end

  # Returns the value of attribute note.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def note; end

  # Returns the value of attribute space.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#9
  def space; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#67
  def just_keyword_of_sentence?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#63
  def keyword_appearance?; end

  # Returns the value of attribute keywords.
  #
  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#39
  def keywords; end

  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#53
  def regex; end

  # source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#41
  def split_comment(comment); end
end

# source://rubocop//lib/rubocop/cop/mixin/annotation_comment.rb#50
RuboCop::Cop::AnnotationComment::KEYWORDS_REGEX_CACHE = T.let(T.unsafe(nil), Hash)

# Handles the `MinSize` configuration option for array-based cops
# `Style/SymbolArray` and `Style/WordArray`, which check for use of the
# relevant percent literal syntax such as `%i[...]` and `%w[...]`
#
# source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#8
module RuboCop::Cop::ArrayMinSize
  private

  # source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#19
  def array_style_detected(style, ary_size); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#11
  def below_array_length?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#38
  def largest_brackets_size(style, ary_size); end

  # source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#15
  def min_size_config; end

  # source://rubocop//lib/rubocop/cop/mixin/array_min_size.rb#48
  def smallest_percent_size(style, ary_size); end
end

# Common code for ordinary arrays with [] that can be written with %
# syntax.
#
# source://rubocop//lib/rubocop/cop/mixin/array_syntax.rb#7
module RuboCop::Cop::ArraySyntax
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/array_syntax.rb#10
  def bracketed_array_of?(element_type, node); end
end

# extend this module to signal autocorrection support
#
# source://rubocop//lib/rubocop/cop/mixin/auto_corrector.rb#6
module RuboCop::Cop::AutoCorrector
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/auto_corrector.rb#7
  def support_autocorrect?; end
end

# This module encapsulates the logic for autocorrect behavior for a cop.
#
# source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#6
module RuboCop::Cop::AutocorrectLogic
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#7
  def autocorrect?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#31
  def autocorrect_enabled?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#15
  def autocorrect_requested?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#11
  def autocorrect_with_disable_uncorrectable?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#19
  def correctable?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#23
  def disable_uncorrectable?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#27
  def safe_autocorrect?; end

  private

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#51
  def disable_offense(offense_range); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#118
  def disable_offense_at_end_of_line(range, eol_comment); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#122
  def disable_offense_before_and_after(range_by_lines); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#61
  def disable_offense_with_eol_or_surround_comment(range); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#114
  def max_line_length; end

  # Expand the given range to include all of any lines it covers. Does not
  # include newline at end of the last line.
  #
  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#104
  def range_by_lines(range); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#95
  def range_of_first_line(range); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#72
  def surrounding_heredoc(offense_range); end

  # source://rubocop//lib/rubocop/cop/autocorrect_logic.rb#83
  def surrounding_percent_array(offense_range); end
end

# Identifier of all cops containing a department and cop name.
#
# All cops are identified by their badge. For example, the badge for
# `RuboCop::Cop::Layout::IndentationStyle` is `Layout/IndentationStyle`.
# Badges can be parsed as either `Department/CopName` or just `CopName` to
# allow for badge references in source files that omit the department for
# RuboCop to infer.
#
# source://rubocop//lib/rubocop/cop/badge.rb#12
class RuboCop::Cop::Badge
  # @return [Badge] a new instance of Badge
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#34
  def initialize(class_name_parts); end

  # source://rubocop//lib/rubocop/cop/badge.rb#41
  def ==(other); end

  # Returns the value of attribute cop_name.
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#13
  def cop_name; end

  # Returns the value of attribute department.
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#13
  def department; end

  # Returns the value of attribute department_name.
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#13
  def department_name; end

  # source://rubocop//lib/rubocop/cop/badge.rb#41
  def eql?(other); end

  # source://rubocop//lib/rubocop/cop/badge.rb#46
  def hash; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#51
  def match?(other); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/badge.rb#59
  def qualified?; end

  # source://rubocop//lib/rubocop/cop/badge.rb#55
  def to_s; end

  # source://rubocop//lib/rubocop/cop/badge.rb#63
  def with_department(department); end

  class << self
    # source://rubocop//lib/rubocop/cop/badge.rb#27
    def camel_case(name_part); end

    # source://rubocop//lib/rubocop/cop/badge.rb#15
    def for(class_name); end

    # source://rubocop//lib/rubocop/cop/badge.rb#23
    def parse(identifier); end
  end
end

# A scaffold for concrete cops.
#
# The Cop::Base class is meant to be extended.
#
# Cops track offenses and can autocorrect them on the fly.
#
# A commissioner object is responsible for traversing the AST and invoking
# the specific callbacks on each cop.
#
# First the callback `on_new_investigation` is called;
# if a cop needs to do its own processing of the AST or depends on
# something else.
#
# Then callbacks like `on_def`, `on_send` (see AST::Traversal) are called
# with their respective nodes.
#
# Finally the callback `on_investigation_end` is called.
#
# Within these callbacks, cops are meant to call `add_offense` or
# `add_global_offense`. Use the `processed_source` method to
# get the currently processed source being investigated.
#
# In case of invalid syntax / unparsable content,
# the callback `on_other_file` is called instead of all the other
# `on_...` callbacks.
#
# Private methods are not meant for custom cops consumption,
# nor are any instance variables.
#
# source://rubocop//lib/rubocop/cop/base.rb#34
class RuboCop::Cop::Base
  include ::RuboCop::AST::Sexp
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util
  include ::RuboCop::Cop::IgnoredNode
  include ::RuboCop::Cop::AutocorrectLogic
  extend ::RuboCop::AST::Sexp
  extend ::RuboCop::AST::NodePattern::Macros
  extend ::RuboCop::ExcludeLimit

  # @return [Base] a new instance of Base
  #
  # source://rubocop//lib/rubocop/cop/base.rb#156
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#272
  def active_support_extensions_enabled?; end

  # Adds an offense that has no particular location.
  # No correction can be applied to global offenses
  #
  # source://rubocop//lib/rubocop/cop/base.rb#189
  def add_global_offense(message = T.unsafe(nil), severity: T.unsafe(nil)); end

  # Adds an offense on the specified range (or node with an expression)
  # Unless that offense is disabled for this range, a corrector will be yielded
  # to provide the cop the opportunity to autocorrect the offense.
  # If message is not specified, the method `message` will be called.
  #
  # source://rubocop//lib/rubocop/cop/base.rb#201
  def add_offense(node_or_range, message: T.unsafe(nil), severity: T.unsafe(nil), &block); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#343
  def always_autocorrect?; end

  # Called before any investigation
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/base.rb#329
  def begin_investigation(processed_source, offset: T.unsafe(nil), original: T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/base.rb#314
  def callbacks_needed; end

  # Returns the value of attribute config.
  #
  # source://rubocop//lib/rubocop/cop/base.rb#43
  def config; end

  # source://rubocop//lib/rubocop/cop/base.rb#252
  def config_to_allow_offenses; end

  # source://rubocop//lib/rubocop/cop/base.rb#256
  def config_to_allow_offenses=(hash); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#349
  def contextual_autocorrect?; end

  # Configuration Helpers
  #
  # source://rubocop//lib/rubocop/cop/base.rb#246
  def cop_config; end

  # source://rubocop//lib/rubocop/cop/base.rb#238
  def cop_name; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#285
  def excluded_file?(file); end

  # This method should be overridden when a cop's behavior depends
  # on state that lives outside of these locations:
  #
  #   (1) the file under inspection
  #   (2) the cop's source code
  #   (3) the config (eg a .rubocop.yml file)
  #
  # For example, some cops may want to look at other parts of
  # the codebase being inspected to find violations. A cop may
  # use the presence or absence of file `foo.rb` to determine
  # whether a certain violation exists in `bar.rb`.
  #
  # Overriding this method allows the cop to indicate to RuboCop's
  # ResultCache system when those external dependencies change,
  # ie when the ResultCache should be invalidated.
  #
  # source://rubocop//lib/rubocop/cop/base.rb#234
  def external_dependency_checksum; end

  # source://rubocop//lib/rubocop/cop/base.rb#353
  def inspect; end

  # Gets called if no message is specified when calling `add_offense` or
  # `add_global_offense`
  # Cops are discouraged to override this; instead pass your message directly
  #
  # source://rubocop//lib/rubocop/cop/base.rb#183
  def message(_range = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/base.rb#238
  def name; end

  # @deprecated Make potential errors with previous API more obvious
  #
  # source://rubocop//lib/rubocop/cop/base.rb#305
  def offenses; end

  # Called after all on_... have been called
  # When refining this method, always call `super`
  #
  # source://rubocop//lib/rubocop/cop/base.rb#170
  def on_investigation_end; end

  # Called before all on_... have been called
  # When refining this method, always call `super`
  #
  # source://rubocop//lib/rubocop/cop/base.rb#164
  def on_new_investigation; end

  # Called instead of all on_... callbacks for unrecognized files / syntax errors
  # When refining this method, always call `super`
  #
  # source://rubocop//lib/rubocop/cop/base.rb#176
  def on_other_file; end

  # There should be very limited reasons for a Cop to do it's own parsing
  #
  # source://rubocop//lib/rubocop/cop/base.rb#290
  def parse(source, path = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/base.rb#264
  def parser_engine; end

  # Returns the value of attribute processed_source.
  #
  # source://rubocop//lib/rubocop/cop/base.rb#43
  def processed_source; end

  # Called between investigations
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/base.rb#296
  def ready; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#276
  def relevant_file?(file); end

  # source://rubocop//lib/rubocop/cop/base.rb#268
  def target_rails_version; end

  # source://rubocop//lib/rubocop/cop/base.rb#260
  def target_ruby_version; end

  private

  # source://rubocop//lib/rubocop/cop/base.rb#471
  def annotate(message); end

  # source://rubocop//lib/rubocop/cop/base.rb#365
  def apply_correction(corrector); end

  # @return [Symbol] offense status
  #
  # source://rubocop//lib/rubocop/cop/base.rb#435
  def attempt_correction(range, corrector); end

  # Reserved for Cop::Cop
  #
  # source://rubocop//lib/rubocop/cop/base.rb#361
  def callback_argument(range); end

  # Called to complete an investigation
  #
  # source://rubocop//lib/rubocop/cop/base.rb#394
  def complete_investigation; end

  # @return [Symbol, Corrector] offense status
  #
  # source://rubocop//lib/rubocop/cop/base.rb#409
  def correct(range); end

  # source://rubocop//lib/rubocop/cop/base.rb#379
  def current_corrector; end

  # Reserved for Commissioner:
  #
  # source://rubocop//lib/rubocop/cop/base.rb#371
  def current_offense_locations; end

  # source://rubocop//lib/rubocop/cop/base.rb#383
  def current_offenses; end

  # source://rubocop//lib/rubocop/cop/base.rb#375
  def currently_disabled_lines; end

  # source://rubocop//lib/rubocop/cop/base.rb#499
  def custom_severity; end

  # source://rubocop//lib/rubocop/cop/base.rb#495
  def default_severity; end

  # source://rubocop//lib/rubocop/cop/base.rb#449
  def disable_uncorrectable(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#485
  def enabled_line?(line_number); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#477
  def file_name_matches_any?(file, parameter, default_result); end

  # source://rubocop//lib/rubocop/cop/base.rb#467
  def find_message(range, message); end

  # source://rubocop//lib/rubocop/cop/base.rb#491
  def find_severity(_range, severity); end

  # source://rubocop//lib/rubocop/cop/base.rb#512
  def range_for_original(range); end

  # source://rubocop//lib/rubocop/cop/base.rb#456
  def range_from_node_or_range(node_or_range); end

  # Actually private methods
  #
  # source://rubocop//lib/rubocop/cop/base.rb#404
  def reset_investigation; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/base.rb#520
  def target_satisfies_all_gem_version_requirements?; end

  # @return [Symbol] offense status
  #
  # source://rubocop//lib/rubocop/cop/base.rb#424
  def use_corrector(range, corrector); end

  class << self
    # List of cops that should not try to autocorrect at the same
    # time as this cop
    #
    # @api public
    # @return [Array<RuboCop::Cop::Base>]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#59
    def autocorrect_incompatible_with; end

    # Naming
    #
    # source://rubocop//lib/rubocop/cop/base.rb#93
    def badge; end

    # @api private
    #
    # source://rubocop//lib/rubocop/cop/base.rb#319
    def callbacks_needed; end

    # source://rubocop//lib/rubocop/cop/base.rb#97
    def cop_name; end

    # source://rubocop//lib/rubocop/cop/base.rb#101
    def department; end

    # Returns an url to view this cops documentation online.
    # Requires 'DocumentationBaseURL' to be set for your department.
    # Will follow the convention of RuboCops own documentation structure,
    # overwrite this method to accommodate your custom layout.
    #
    # @api public
    # @return [String, nil]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#70
    def documentation_url(config = T.unsafe(nil)); end

    # Call for abstract Cop classes
    #
    # source://rubocop//lib/rubocop/cop/base.rb#81
    def exclude_from_registry; end

    # Returns the value of attribute gem_requirements.
    #
    # source://rubocop//lib/rubocop/cop/base.rb#138
    def gem_requirements; end

    # @private
    #
    # source://rubocop//lib/rubocop/cop/base.rb#74
    def inherited(subclass); end

    # Override and return the Force class(es) you need to join
    #
    # source://rubocop//lib/rubocop/cop/base.rb#118
    def joining_forces; end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#105
    def lint?; end

    # Returns true if the cop name or the cop namespace matches any of the
    # given names.
    #
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#111
    def match?(given_names); end

    # Register a version requirement for the given gem name.
    # This cop will be skipped unless the target satisfies *all* requirements.
    #
    # @api public
    # @param gem_name [String]
    # @param version_requirements [Array<String>] The version requirements,
    #   using the same syntax as a Gemfile, e.g. ">= 1.2.3"
    #
    #   If omitted, any version of the gem will be accepted.
    #
    #   https://guides.rubygems.org/patterns/#declaring-dependencies
    #
    # source://rubocop//lib/rubocop/cop/base.rb#151
    def requires_gem(gem_name, *version_requirements); end

    # Returns if class supports autocorrect.
    # It is recommended to extend AutoCorrector instead of overriding
    #
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#87
    def support_autocorrect?; end

    # Override if your cop should be called repeatedly for multiple investigations
    # Between calls to `on_new_investigation` and `on_investigation_end`,
    # the result of `processed_source` will remain constant.
    # You should invalidate any caches that depend on the current `processed_source`
    # in the `on_new_investigation` callback.
    # If your cop does autocorrections, be aware that your instance may be called
    # multiple times with the same `processed_source.path` but different content.
    #
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/base.rb#129
    def support_multiple_source?; end

    private

    # source://rubocop//lib/rubocop/cop/base.rb#387
    def restrict_on_send; end
  end
end

# source://rubocop//lib/rubocop/cop/base.rb#391
RuboCop::Cop::Base::EMPTY_OFFENSES = T.let(T.unsafe(nil), Array)

# Reports of an investigation.
# Immutable
# Consider creation API private
#
# source://rubocop//lib/rubocop/cop/base.rb#48
class RuboCop::Cop::Base::InvestigationReport < ::Struct
  # Returns the value of attribute cop
  #
  # @return [Object] the current value of cop
  def cop; end

  # Sets the attribute cop
  #
  # @param value [Object] the value to set the attribute cop to.
  # @return [Object] the newly set value
  def cop=(_); end

  # Returns the value of attribute corrector
  #
  # @return [Object] the current value of corrector
  def corrector; end

  # Sets the attribute corrector
  #
  # @param value [Object] the value to set the attribute corrector to.
  # @return [Object] the newly set value
  def corrector=(_); end

  # Returns the value of attribute offenses
  #
  # @return [Object] the current value of offenses
  def offenses; end

  # Sets the attribute offenses
  #
  # @param value [Object] the value to set the attribute offenses to.
  # @return [Object] the newly set value
  def offenses=(_); end

  # Returns the value of attribute processed_source
  #
  # @return [Object] the current value of processed_source
  def processed_source; end

  # Sets the attribute processed_source
  #
  # @param value [Object] the value to set the attribute processed_source to.
  # @return [Object] the newly set value
  def processed_source=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# List of methods names to restrict calls for `on_send` / `on_csend`
#
# source://rubocop//lib/rubocop/cop/base.rb#51
RuboCop::Cop::Base::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#5
module RuboCop::Cop::Bundler; end

# A Gem's requirements should be listed only once in a Gemfile.
#
# @example
#   # bad
#   gem 'rubocop'
#   gem 'rubocop'
#
#   # bad
#   group :development do
#   gem 'rubocop'
#   end
#
#   group :test do
#   gem 'rubocop'
#   end
#
#   # good
#   group :development, :test do
#   gem 'rubocop'
#   end
#
#   # good
#   gem 'rubocop', groups: [:development, :test]
#
#   # good - conditional declaration
#   if Dir.exist?(local)
#   gem 'rubocop', path: local
#   elsif ENV['RUBOCOP_VERSION'] == 'master'
#   gem 'rubocop', git: 'https://github.com/rubocop/rubocop.git'
#   else
#   gem 'rubocop', '~> 0.90.0'
#   end
#
# source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#39
class RuboCop::Cop::Bundler::DuplicatedGem < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#58
  def gem_declarations(param0); end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#45
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#67
  def conditional_declaration?(nodes); end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#60
  def duplicated_gem_nodes; end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#81
  def register_offense(node, gem_name, line_of_first_occurrence); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#75
  def within_conditional?(node, conditional_node); end
end

# source://rubocop//lib/rubocop/cop/bundler/duplicated_gem.rb#42
RuboCop::Cop::Bundler::DuplicatedGem::MSG = T.let(T.unsafe(nil), String)

# A Gem group, or a set of groups, should be listed only once in a Gemfile.
#
# For example, if the values of `source`, `git`, `platforms`, or `path`
# surrounding `group` are different, no offense will be registered:
#
# [source,ruby]
# -----
# platforms :ruby do
#   group :default do
#     gem 'openssl'
#   end
# end
#
# platforms :jruby do
#   group :default do
#     gem 'jruby-openssl'
#   end
# end
# -----
#
# @example
#   # bad
#   group :development do
#   gem 'rubocop'
#   end
#
#   group :development do
#   gem 'rubocop-rails'
#   end
#
#   # bad (same set of groups declared twice)
#   group :development, :test do
#   gem 'rubocop'
#   end
#
#   group :test, :development do
#   gem 'rspec'
#   end
#
#   # good
#   group :development do
#   gem 'rubocop'
#   end
#
#   group :development, :test do
#   gem 'rspec'
#   end
#
#   # good
#   gem 'rubocop', groups: [:development, :test]
#   gem 'rspec', groups: [:development, :test]
#
# source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#58
class RuboCop::Cop::Bundler::DuplicatedGroup < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#66
  def group_declarations(param0); end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#68
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#82
  def duplicated_group_nodes; end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#105
  def find_source_key(node); end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#115
  def group_attributes(node); end

  # source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#94
  def register_offense(node, group_name, line_of_first_occurrence); end
end

# source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#61
RuboCop::Cop::Bundler::DuplicatedGroup::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/duplicated_group.rb#63
RuboCop::Cop::Bundler::DuplicatedGroup::SOURCE_BLOCK_NAMES = T.let(T.unsafe(nil), Array)

# Each gem in the Gemfile should have a comment explaining
# its purpose in the project, or the reason for its version
# or source.
#
# The optional "OnlyFor" configuration array
# can be used to only register offenses when the gems
# use certain options or have version specifiers.
#
# When "version_specifiers" is included, a comment
# will be enforced if the gem has any version specifier.
#
# When "restrictive_version_specifiers" is included, a comment
# will be enforced if the gem has a version specifier that
# holds back the version of the gem.
#
# For any other value in the array, a comment will be enforced for
# a gem if an option by the same name is present.
# A useful use case is to enforce a comment when using
# options that change the source of a gem:
#
# - `bitbucket`
# - `gist`
# - `git`
# - `github`
# - `source`
#
# For a full list of options supported by bundler,
# see https://bundler.io/man/gemfile.5.html
# .
#
# @example OnlyFor: [] (default)
#   # bad
#
#   gem 'foo'
#
#   # good
#
#   # Helpers for the foo things.
#   gem 'foo'
# @example OnlyFor: ['version_specifiers']
#   # bad
#
#   gem 'foo', '< 2.1'
#
#   # good
#
#   # Version 2.1 introduces breaking change baz
#   gem 'foo', '< 2.1'
# @example OnlyFor: ['restrictive_version_specifiers']
#   # bad
#
#   gem 'foo', '< 2.1'
#
#   # good
#
#   gem 'foo', '>= 1.0'
#
#   # Version 2.1 introduces breaking change baz
#   gem 'foo', '< 2.1'
# @example OnlyFor: ['version_specifiers', 'github']
#   # bad
#
#   gem 'foo', github: 'some_account/some_fork_of_foo'
#
#   gem 'bar', '< 2.1'
#
#   # good
#
#   # Using this fork because baz
#   gem 'foo', github: 'some_account/some_fork_of_foo'
#
#   # Version 2.1 introduces breaking change baz
#   gem 'bar', '< 2.1'
#
# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#83
class RuboCop::Cop::Bundler::GemComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::GemDeclaration

  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#94
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#135
  def checked_options_present?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#109
  def commented?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#105
  def commented_any_descendant?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#159
  def contains_checked_options?(node); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#163
  def gem_options(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#130
  def ignored_gem?(node); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#116
  def precede?(node1, node2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#126
  def preceding_comment?(node1, node2); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#120
  def preceding_lines(node); end

  # Version specifications that restrict all updates going forward. This excludes versions
  # like ">= 1.0" or "!= 2.0.3".
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#152
  def restrictive_version_specified_gem?(node); end

  # Besides the gem name, all other *positional* arguments to `gem` are version specifiers,
  # as long as it has one we know there's at least one version specifier.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#145
  def version_specified_gem?(node); end
end

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#88
RuboCop::Cop::Bundler::GemComment::CHECKED_OPTIONS_CONFIG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#87
RuboCop::Cop::Bundler::GemComment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#91
RuboCop::Cop::Bundler::GemComment::RESTRICTIVE_VERSION_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#90
RuboCop::Cop::Bundler::GemComment::RESTRICTIVE_VERSION_SPECIFIERS_OPTION = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#92
RuboCop::Cop::Bundler::GemComment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/bundler/gem_comment.rb#89
RuboCop::Cop::Bundler::GemComment::VERSION_SPECIFIERS_OPTION = T.let(T.unsafe(nil), String)

# Verifies that a project contains Gemfile or gems.rb file and correct
# associated lock file based on the configuration.
#
# @example EnforcedStyle: Gemfile (default)
#   # bad
#   Project contains gems.rb and gems.locked files
#
#   # bad
#   Project contains Gemfile and gems.locked file
#
#   # good
#   Project contains Gemfile and Gemfile.lock
# @example EnforcedStyle: gems.rb
#   # bad
#   Project contains Gemfile and Gemfile.lock files
#
#   # bad
#   Project contains gems.rb and Gemfile.lock file
#
#   # good
#   Project contains gems.rb and gems.locked files
#
# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#28
class RuboCop::Cop::Bundler::GemFilename < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#43
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#88
  def expected_gemfile?(basename); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#80
  def gemfile_offense?(basename); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#93
  def gemfile_required?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#84
  def gems_rb_offense?(basename); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#97
  def gems_rb_required?; end

  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#58
  def register_gemfile_offense(file_path, basename); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#69
  def register_gems_rb_offense(file_path, basename); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#53
  def register_offense(file_path, basename); end
end

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#40
RuboCop::Cop::Bundler::GemFilename::GEMFILE_FILES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#41
RuboCop::Cop::Bundler::GemFilename::GEMS_RB_FILES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#36
RuboCop::Cop::Bundler::GemFilename::MSG_GEMFILE_MISMATCHED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#32
RuboCop::Cop::Bundler::GemFilename::MSG_GEMFILE_REQUIRED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#38
RuboCop::Cop::Bundler::GemFilename::MSG_GEMS_RB_MISMATCHED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_filename.rb#34
RuboCop::Cop::Bundler::GemFilename::MSG_GEMS_RB_REQUIRED = T.let(T.unsafe(nil), String)

# Enforce that Gem version specifications or a commit reference (branch,
# ref, or tag) are either required or forbidden.
#
# @example EnforcedStyle: required (default)
#   # bad
#   gem 'rubocop'
#
#   # good
#   gem 'rubocop', '~> 1.12'
#
#   # good
#   gem 'rubocop', '>= 1.10.0'
#
#   # good
#   gem 'rubocop', '>= 1.5.0', '< 1.10.0'
#
#   # good
#   gem 'rubocop', branch: 'feature-branch'
#
#   # good
#   gem 'rubocop', ref: '74b5bfbb2c4b6fd6cdbbc7254bd7084b36e0c85b'
#
#   # good
#   gem 'rubocop', tag: 'v1.17.0'
# @example EnforcedStyle: forbidden
#   # good
#   gem 'rubocop'
#
#   # bad
#   gem 'rubocop', '~> 1.12'
#
#   # bad
#   gem 'rubocop', '>= 1.10.0'
#
#   # bad
#   gem 'rubocop', '>= 1.5.0', '< 1.10.0'
#
#   # bad
#   gem 'rubocop', branch: 'feature-branch'
#
#   # bad
#   gem 'rubocop', ref: '74b5bfbb2c4b6fd6cdbbc7254bd7084b36e0c85b'
#
#   # bad
#   gem 'rubocop', tag: 'v1.17.0'
#
# source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#53
class RuboCop::Cop::Bundler::GemVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::GemDeclaration

  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#67
  def includes_commit_reference?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#62
  def includes_version_specification?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#71
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#85
  def allowed_gem?(node); end

  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#89
  def allowed_gems; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#111
  def forbidden_offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#117
  def forbidden_style?; end

  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#93
  def message(_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#101
  def offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#105
  def required_offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#121
  def required_style?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#125
  def version_specification?(expression); end
end

# source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#58
RuboCop::Cop::Bundler::GemVersion::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#57
RuboCop::Cop::Bundler::GemVersion::REQUIRED_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/gem_version.rb#59
RuboCop::Cop::Bundler::GemVersion::VERSION_SPECIFICATION_REGEX = T.let(T.unsafe(nil), Regexp)

# Passing symbol arguments to `source` (e.g. `source :rubygems`) is
# deprecated because they default to using HTTP requests. Instead, specify
# `'https://rubygems.org'` if possible, or `'http://rubygems.org'` if not.
#
# When autocorrecting, this cop will replace symbol arguments with
# `'https://rubygems.org'`.
#
# This cop will not replace existing sources that use `http://`. This may
# be necessary where HTTPS is not available. For example, where using an
# internal gem server via an intranet, or where HTTPS is prohibited.
# However, you should strongly prefer `https://` where possible, as it is
# more secure.
#
# If you don't allow `http://`, please set `false` to `AllowHttpProtocol`.
# This option is `true` by default for safe autocorrection.
#
# @example
#   # bad
#   source :gemcutter
#   source :rubygems
#   source :rubyforge
#
#   # good
#   source 'https://rubygems.org' # strongly recommended
# @example AllowHttpProtocol: true (default)
#
#   # good
#   source 'http://rubygems.org' # use only if HTTPS is unavailable
# @example AllowHttpProtocol: false
#
#   # bad
#   source 'http://rubygems.org'
#
# source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#41
class RuboCop::Cop::Bundler::InsecureProtocolSource < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#54
  def insecure_protocol_source?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#59
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#80
  def allow_http_protocol?; end
end

# source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#45
RuboCop::Cop::Bundler::InsecureProtocolSource::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#49
RuboCop::Cop::Bundler::InsecureProtocolSource::MSG_HTTP_PROTOCOL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/bundler/insecure_protocol_source.rb#51
RuboCop::Cop::Bundler::InsecureProtocolSource::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Gems should be alphabetically sorted within groups.
#
# @example
#   # bad
#   gem 'rubocop'
#   gem 'rspec'
#
#   # good
#   gem 'rspec'
#   gem 'rubocop'
#
#   # good
#   gem 'rubocop'
#
#   gem 'rspec'
# @example TreatCommentsAsGroupSeparators: true (default)
#   # good
#   # For code quality
#   gem 'rubocop'
#   # For tests
#   gem 'rspec'
# @example TreatCommentsAsGroupSeparators: false
#   # bad
#   # For code quality
#   gem 'rubocop'
#   # For tests
#   gem 'rspec'
#
# source://rubocop//lib/rubocop/cop/bundler/ordered_gems.rb#35
class RuboCop::Cop::Bundler::OrderedGems < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/bundler/ordered_gems.rb#64
  def gem_declarations(param0); end

  # source://rubocop//lib/rubocop/cop/bundler/ordered_gems.rb#43
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/bundler/ordered_gems.rb#57
  def previous_declaration(node); end
end

# source://rubocop//lib/rubocop/cop/bundler/ordered_gems.rb#39
RuboCop::Cop::Bundler::OrderedGems::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking assignment nodes.
#
# source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#6
module RuboCop::Cop::CheckAssignment
  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_and_asgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_masgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#7
  def on_or_asgn(node); end

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#19
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#29
  def extract_rhs(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/mixin/check_assignment.rb#29
    def extract_rhs(node); end
  end
end

# This mixin detects collections that are safe to "break"
# by inserting new lines. This is useful for breaking
# up long lines.
#
# Let's look at hashes as an example:
#
# We know hash keys are safe to break across lines. We can add
# linebreaks into hashes on lines longer than the specified maximum.
# Then in further passes cops can clean up the multi-line hash.
# For example, say the maximum line length is as indicated below:
#
#                                         |
#                                         v
# {foo: "0000000000", bar: "0000000000", baz: "0000000000"}
#
# In a LineLength autocorrection pass, a line is added before
# the first key that exceeds the column limit:
#
# {foo: "0000000000", bar: "0000000000",
# baz: "0000000000"}
#
# In a MultilineHashKeyLineBreaks pass, lines are inserted
# before all keys:
#
# {foo: "0000000000",
# bar: "0000000000",
# baz: "0000000000"}
#
# Then in future passes FirstHashElementLineBreak,
# MultilineHashBraceLayout, and TrailingCommaInHashLiteral will
# manipulate as well until we get:
#
# {
#   foo: "0000000000",
#   bar: "0000000000",
#   baz: "0000000000",
# }
#
# (Note: Passes may not happen exactly in this sequence.)
#
# source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#44
module RuboCop::Cop::CheckLineBreakable
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#45
  def extract_breakable_node(node, max); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#200
  def all_on_same_line?(nodes); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#220
  def already_on_multiple_lines?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#133
  def breakable_collection?(node, elements); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#187
  def children_could_be_broken_up?(children); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#150
  def contained_by_breakable_collection_on_same_line?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#170
  def contained_by_multiline_collection_that_could_be_broken_up?(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#60
  def extract_breakable_node_from_elements(node, elements, max); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#72
  def extract_first_element_over_column_limit(node, elements, max); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#92
  def first_argument_is_heredoc?(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#207
  def process_args(args); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#117
  def safe_to_ignore?(node); end

  # If a send node contains a heredoc argument, splitting cannot happen
  # after the heredoc or else it will cause a syntax error.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#101
  def shift_elements_for_heredoc_arg(node, elements, index); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/check_line_breakable.rb#112
  def within_column_limit?(element, max, line); end
end

# Common functionality for checking length of code segments.
#
# source://rubocop//lib/rubocop/cop/mixin/code_length.rb#6
module RuboCop::Cop::CodeLength
  extend ::RuboCop::ExcludeLimit

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#49
  def build_code_length_calculator(node); end

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#31
  def check_code_length(node); end

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#27
  def count_as_one; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#23
  def count_comments?; end

  # Returns true for lines that shall not be included in the count.
  #
  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#45
  def irrelevant_line(source_line); end

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#58
  def location(node); end

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#19
  def max_length; end

  # source://rubocop//lib/rubocop/cop/mixin/code_length.rb#15
  def message(length, max_length); end
end

# source://rubocop//lib/rubocop/cop/mixin/code_length.rb#9
RuboCop::Cop::CodeLength::MSG = T.let(T.unsafe(nil), String)

# Help methods for working with nodes containing comments.
#
# source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#6
module RuboCop::Cop::CommentsHelp
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#25
  def comments_contain_disables?(node, cop_name); end

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#18
  def comments_in_range(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#14
  def contains_comments?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#7
  def source_range_with_comment(node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#44
  def begin_pos_with_comment(node); end

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#58
  def buffer; end

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#39
  def end_position_for(node); end

  # Returns the end line of a node, which might be a comment and not part of the AST
  # End line is considered either the line at which another node starts, or
  # the line at which the parent node ends.
  #
  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#66
  def find_end_line(node); end

  # source://rubocop//lib/rubocop/cop/mixin/comments_help.rb#54
  def start_line_position(node); end
end

# Commissioner class is responsible for processing the AST and delegating
# work to the specified cops.
#
# source://rubocop//lib/rubocop/cop/commissioner.rb#7
class RuboCop::Cop::Commissioner
  include ::RuboCop::AST::Traversal

  # @return [Commissioner] a new instance of Commissioner
  #
  # source://rubocop//lib/rubocop/cop/commissioner.rb#44
  def initialize(cops, forces = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute errors.
  #
  # source://rubocop//lib/rubocop/cop/commissioner.rb#42
  def errors; end

  # @return [InvestigationReport]
  #
  # source://rubocop//lib/rubocop/cop/commissioner.rb#79
  def investigate(processed_source, offset: T.unsafe(nil), original: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on___ENCODING__(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on___FILE__(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on___LINE__(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_alias(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_and_asgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_arg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_arg_expr(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_args(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_array_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_array_pattern_with_tail(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_back_ref(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_begin(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_block_pass(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_blockarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_break(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_case_match(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_cbase(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_complex(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_const(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_const_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_cvar(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_defined?(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_dstr(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_dsym(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_eflipflop(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_empty_else(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_ensure(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_erange(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_false(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_find_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_float(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_for(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_forward_arg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_forward_args(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_forwarded_args(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_forwarded_kwrestarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_forwarded_restarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_gvar(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_hash_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_if_guard(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_iflipflop(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_in_match(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_in_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_index(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_indexasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_int(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_irange(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_ivar(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwargs(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwbegin(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwnilarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwoptarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwrestarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_kwsplat(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_lambda(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_lvar(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_masgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_alt(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_as(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_current_line(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_nil_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_pattern(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_pattern_p(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_rest(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_var(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_with_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_match_with_trailing_comma(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_mlhs(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_next(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_nil(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_not(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_nth_ref(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_optarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_or_asgn(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_pair(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_pin(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_postexe(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_preexe(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_procarg0(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_rational(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_redo(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_regexp(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_regopt(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_resbody(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_rescue(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_restarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_retry(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_return(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_self(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_shadowarg(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_splat(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_str(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_super(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_sym(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_true(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_undef(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_unless_guard(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_when(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_while_post(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_xstr(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_yield(node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#68
  def on_zsuper(node); end

  private

  # source://rubocop//lib/rubocop/cop/commissioner.rb#98
  def begin_investigation(processed_source, offset:, original:); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#121
  def build_callbacks(cops); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#116
  def initialize_callbacks; end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#159
  def invoke(callback, cops); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#163
  def invoke_with_argument(callback, cops, arg); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#112
  def reset; end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#131
  def restrict_callbacks(callbacks); end

  # NOTE: mutates `callbacks` in place
  #
  # source://rubocop//lib/rubocop/cop/commissioner.rb#149
  def restricted_map(callbacks); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#104
  def trigger_responding_cops(callback, node); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#139
  def trigger_restricted_cops(event, node); end

  # Allow blind rescues here, since we're absorbing and packaging or
  # re-raising exceptions that can be raised from within the individual
  # cops' `#investigate` methods.
  #
  # source://rubocop//lib/rubocop/cop/commissioner.rb#170
  def with_cop_error_handling(cop, node = T.unsafe(nil)); end
end

# How a Commissioner returns the results of the investigation
# as a list of Cop::InvestigationReport and any errors caught
# during the investigation.
# Immutable
# Consider creation API private
#
# source://rubocop//lib/rubocop/cop/commissioner.rb#18
class RuboCop::Cop::Commissioner::InvestigationReport < ::Struct
  # Returns the value of attribute cop_reports
  #
  # @return [Object] the current value of cop_reports
  def cop_reports; end

  # Sets the attribute cop_reports
  #
  # @param value [Object] the value to set the attribute cop_reports to.
  # @return [Object] the newly set value
  def cop_reports=(_); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#19
  def cops; end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#27
  def correctors; end

  # Returns the value of attribute errors
  #
  # @return [Object] the current value of errors
  def errors; end

  # Sets the attribute errors
  #
  # @param value [Object] the value to set the attribute errors to.
  # @return [Object] the newly set value
  def errors=(_); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#35
  def merge(investigation); end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#31
  def offenses; end

  # source://rubocop//lib/rubocop/cop/commissioner.rb#23
  def offenses_per_cop; end

  # Returns the value of attribute processed_source
  #
  # @return [Object] the current value of processed_source
  def processed_source; end

  # Sets the attribute processed_source
  #
  # @param value [Object] the value to set the attribute processed_source to.
  # @return [Object] the newly set value
  def processed_source=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/cop/commissioner.rb#10
RuboCop::Cop::Commissioner::RESTRICTED_CALLBACKS = T.let(T.unsafe(nil), Array)

# This class does condition autocorrection
#
# source://rubocop//lib/rubocop/cop/correctors/condition_corrector.rb#6
class RuboCop::Cop::ConditionCorrector
  class << self
    # source://rubocop//lib/rubocop/cop/correctors/condition_corrector.rb#8
    def correct_negative_condition(corrector, node); end

    private

    # source://rubocop//lib/rubocop/cop/correctors/condition_corrector.rb#17
    def negated_condition(node); end
  end
end

# Handles `EnforcedStyle` configuration parameters.
#
# source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#6
module RuboCop::Cop::ConfigurableEnforcedStyle
  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#88
  def alternative_style; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#96
  def alternative_styles; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#19
  def ambiguous_style_detected(*possibilities); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#60
  def conflicting_styles_detected; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#11
  def correct_style_detected; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#64
  def detected_style; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#68
  def detected_style=(style); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#60
  def no_acceptable_style!; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#56
  def no_acceptable_style?; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#7
  def opposite_style_detected; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#79
  def style; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#75
  def style_configured?; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#29
  def style_detected(detected); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#107
  def style_parameter_name; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#100
  def supported_styles; end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#15
  def unexpected_style_detected(unexpected); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#60
  def unrecognized_style_detected; end
end

# source://rubocop//lib/rubocop/cop/mixin/configurable_enforced_style.rb#23
RuboCop::Cop::ConfigurableEnforcedStyle::SYMBOL_TO_STRING_CACHE = T.let(T.unsafe(nil), Hash)

# Shared functionality between mixins that enforce naming conventions
#
# source://rubocop//lib/rubocop/cop/mixin/configurable_formatting.rb#6
module RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  # source://rubocop//lib/rubocop/cop/mixin/configurable_formatting.rb#9
  def check_name(node, name, name_range); end

  # A class emitter method is a singleton method in a class/module, where
  # the method has the same name as a class defined in the class/module.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/configurable_formatting.rb#30
  def class_emitter_method?(node, name); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_formatting.rb#17
  def report_opposing_styles(node, name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/configurable_formatting.rb#24
  def valid_name?(node, name, given_style = T.unsafe(nil)); end
end

# Handles `Max` configuration parameters, especially setting them to an
# appropriate value with --auto-gen-config.
#
# @deprecated Use `exclude_limit <ParameterName>` instead.
#
# source://rubocop//lib/rubocop/cop/mixin/configurable_max.rb#8
module RuboCop::Cop::ConfigurableMax
  private

  # source://rubocop//lib/rubocop/cop/mixin/configurable_max.rb#11
  def max=(value); end

  # source://rubocop//lib/rubocop/cop/mixin/configurable_max.rb#23
  def max_parameter_name; end
end

# This module provides functionality for checking if names match the
# configured EnforcedStyle.
#
# source://rubocop//lib/rubocop/cop/mixin/configurable_naming.rb#7
module RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

# source://rubocop//lib/rubocop/cop/mixin/configurable_naming.rb#10
RuboCop::Cop::ConfigurableNaming::FORMATS = T.let(T.unsafe(nil), Hash)

# This module provides functionality for checking if numbering match the
# configured EnforcedStyle.
#
# source://rubocop//lib/rubocop/cop/mixin/configurable_numbering.rb#7
module RuboCop::Cop::ConfigurableNumbering
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

# source://rubocop//lib/rubocop/cop/mixin/configurable_numbering.rb#11
RuboCop::Cop::ConfigurableNumbering::FORMATS = T.let(T.unsafe(nil), Hash)

# Monkey-patch Cop for tests to provide easy access to messages and
# highlights.
#
# source://rubocop//lib/rubocop/cop/cop.rb#11
class RuboCop::Cop::Cop < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/cop.rb#65
  def add_offense(node_or_range, location: T.unsafe(nil), message: T.unsafe(nil), severity: T.unsafe(nil), &block); end

  # Called before any investigation
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#121
  def begin_investigation(processed_source, offset: T.unsafe(nil), original: T.unsafe(nil)); end

  # @deprecated
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#97
  def corrections; end

  # source://rubocop//lib/rubocop/cop/cop.rb#82
  def find_location(node, loc); end

  # Returns the value of attribute offenses.
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#12
  def offenses; end

  # Called after all on_... have been called
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#114
  def on_investigation_end; end

  # Called before all on_... have been called
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#108
  def on_new_investigation; end

  # @deprecated Use class method
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#88
  def support_autocorrect?; end

  private

  # source://rubocop//lib/rubocop/cop/cop.rb#139
  def apply_correction(corrector); end

  # Override Base
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#135
  def callback_argument(_range); end

  # source://rubocop//lib/rubocop/cop/cop.rb#156
  def correction_lambda; end

  # source://rubocop//lib/rubocop/cop/cop.rb#162
  def dedupe_on_node(node); end

  # Just for legacy
  #
  # @yield [corrector]
  #
  # source://rubocop//lib/rubocop/cop/cop.rb#144
  def emulate_v0_callsequence(corrector); end

  # source://rubocop//lib/rubocop/cop/cop.rb#175
  def range_for_original(range); end

  # source://rubocop//lib/rubocop/cop/cop.rb#169
  def suppress_clobbering; end

  class << self
    # @deprecated Use Registry.all
    #
    # source://rubocop//lib/rubocop/cop/cop.rb#48
    def all; end

    # source://rubocop//lib/rubocop/cop/cop.rb#29
    def joining_forces; end

    # @deprecated Use Registry.qualified_cop_name
    #
    # source://rubocop//lib/rubocop/cop/cop.rb#57
    def qualified_cop_name(name, origin); end

    # @deprecated Use Registry.global
    #
    # source://rubocop//lib/rubocop/cop/cop.rb#39
    def registry; end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/cop.rb#25
    def support_autocorrect?; end
  end
end

# @deprecated
#
# source://rubocop//lib/rubocop/cop/cop.rb#17
class RuboCop::Cop::Cop::Correction < ::Struct
  # source://rubocop//lib/rubocop/cop/cop.rb#18
  def call(corrector); end

  # Returns the value of attribute cop
  #
  # @return [Object] the current value of cop
  def cop; end

  # Sets the attribute cop
  #
  # @param value [Object] the value to set the attribute cop to.
  # @return [Object] the newly set value
  def cop=(_); end

  # Returns the value of attribute lambda
  #
  # @return [Object] the current value of lambda
  def lambda; end

  # Sets the attribute lambda
  #
  # @param value [Object] the value to set the attribute lambda to.
  # @return [Object] the newly set value
  def lambda=(_); end

  # Returns the value of attribute node
  #
  # @return [Object] the current value of node
  def node; end

  # Sets the attribute node
  #
  # @param value [Object] the value to set the attribute node to.
  # @return [Object] the newly set value
  def node=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This class takes a source buffer and rewrite its source
# based on the different correction rules supplied.
#
# Important!
# The nodes modified by the corrections should be part of the
# AST of the source_buffer.
#
# source://rubocop//lib/rubocop/cop/corrector.rb#11
class RuboCop::Cop::Corrector < ::Parser::Source::TreeRewriter
  # corrector = Corrector.new(cop)
  #
  # @param source [Parser::Source::Buffer, or anything
  # leading to one via `(processed_source.)buffer`]
  # @return [Corrector] a new instance of Corrector
  #
  # source://rubocop//lib/rubocop/cop/corrector.rb#32
  def initialize(source); end

  # Removes `size` characters from the beginning of the given range.
  # If `size` is greater than the size of `range`, the removed region can
  # overrun the end of `range`.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  #
  # source://rubocop//lib/rubocop/cop/corrector.rb#63
  def remove_leading(node_or_range, size); end

  # Removes `size` characters prior to the source range.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  #
  # source://rubocop//lib/rubocop/cop/corrector.rb#51
  def remove_preceding(node_or_range, size); end

  # Removes `size` characters from the end of the given range.
  # If `size` is greater than the size of `range`, the removed region can
  # overrun the beginning of `range`.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  #
  # source://rubocop//lib/rubocop/cop/corrector.rb#75
  def remove_trailing(node_or_range, size); end

  # Legacy
  #
  # source://parser/3.3.4.2/lib/parser/source/tree_rewriter.rb#252
  def rewrite; end

  # Swaps sources at the given ranges.
  #
  # @param node_or_range1 [Parser::Source::Range, RuboCop::AST::Node]
  # @param node_or_range2 [Parser::Source::Range, RuboCop::AST::Node]
  #
  # source://rubocop//lib/rubocop/cop/corrector.rb#85
  def swap(node_or_range1, node_or_range2); end

  private

  # source://rubocop//lib/rubocop/cop/corrector.rb#119
  def check_range_validity(node_or_range); end

  # source://rubocop//lib/rubocop/cop/corrector.rb#104
  def to_range(node_or_range); end

  # source://rubocop//lib/rubocop/cop/corrector.rb#123
  def validate_buffer(buffer); end

  class << self
    # Duck typing for get to a ::Parser::Source::Buffer
    #
    # source://rubocop//lib/rubocop/cop/corrector.rb#15
    def source_buffer(source); end
  end
end

# noop
#
# source://rubocop//lib/rubocop/cop/corrector.rb#12
RuboCop::Cop::Corrector::NOOP_CONSUMER = T.let(T.unsafe(nil), Proc)

# Common functionality for checking def nodes.
#
# source://rubocop//lib/rubocop/cop/mixin/def_node.rb#6
module RuboCop::Cop::DefNode
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/def_node.rb#21
  def non_public_modifier?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/def_node.rb#12
  def non_public?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/def_node.rb#16
  def preceding_non_public_modifier?(node); end
end

# Helpers for builtin documentation
#
# source://rubocop//lib/rubocop/cop/documentation.rb#6
module RuboCop::Cop::Documentation
  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/documentation.rb#24
  def base_url_for(cop_class, config); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/documentation.rb#40
  def builtin?(cop_class); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/documentation.rb#35
  def default_base_url; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/documentation.rb#10
  def department_to_basename(department); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/documentation.rb#15
  def url_for(cop_class, config = T.unsafe(nil)); end

  class << self
    # @api private
    #
    # source://rubocop//lib/rubocop/cop/documentation.rb#24
    def base_url_for(cop_class, config); end

    # @api private
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/documentation.rb#40
    def builtin?(cop_class); end

    # @api private
    #
    # source://rubocop//lib/rubocop/cop/documentation.rb#35
    def default_base_url; end

    # @api private
    #
    # source://rubocop//lib/rubocop/cop/documentation.rb#10
    def department_to_basename(department); end

    # @api private
    #
    # source://rubocop//lib/rubocop/cop/documentation.rb#15
    def url_for(cop_class, config = T.unsafe(nil)); end
  end
end

# Common functionality for checking documentation.
#
# source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#6
module RuboCop::Cop::DocumentationComment
  extend ::RuboCop::AST::NodePattern::Macros

  private

  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#47
  def annotation_keywords; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#11
  def documentation_comment?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#39
  def interpreter_directive_comment?(comment); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#31
  def precede?(node1, node2); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#25
  def preceding_comment?(node1, node2); end

  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#35
  def preceding_lines(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/documentation_comment.rb#43
  def rubocop_directive_comment?(comment); end
end

# Common functionality for dealing with duplication.
#
# source://rubocop//lib/rubocop/cop/mixin/duplication.rb#6
module RuboCop::Cop::Duplication
  private

  # Returns the consecutive duplicates, leaving out the first instance of
  # the duplicated elements.
  #
  # @param collection [Array] an array to return consecutive duplicates for
  # @return [Array] the consecutive duplicates
  #
  # source://rubocop//lib/rubocop/cop/mixin/duplication.rb#31
  def consecutive_duplicates(collection); end

  # Returns all duplicates, including the first instance of the duplicated
  # elements.
  #
  # @param collection [Array] an array to return duplicates for
  # @return [Array] all the duplicates
  #
  # source://rubocop//lib/rubocop/cop/mixin/duplication.rb#22
  def duplicates(collection); end

  # Whether the `collection` contains any duplicates.
  #
  # @param collection [Array] an array to check for duplicates
  # @return [Boolean] whether the array contains any duplicates
  #
  # source://rubocop//lib/rubocop/cop/mixin/duplication.rb#13
  def duplicates?(collection); end

  # Returns a hash of grouped duplicates. The key will be the first
  # instance of the element, and  the value an `array` of the initial
  # element and all duplicate instances.
  #
  # @param collection [Array] an array to group duplicates for
  # @return [Array] the grouped duplicates
  #
  # source://rubocop//lib/rubocop/cop/mixin/duplication.rb#41
  def grouped_duplicates(collection); end
end

# This class autocorrects `#each` enumeration to `for` iteration.
#
# source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#6
class RuboCop::Cop::EachToForCorrector
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [EachToForCorrector] a new instance of EachToForCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#12
  def initialize(block_node); end

  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#18
  def call(corrector); end

  private

  # Returns the value of attribute argument_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#24
  def argument_node; end

  # Returns the value of attribute block_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#24
  def block_node; end

  # Returns the value of attribute collection_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#24
  def collection_node; end

  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#26
  def correction; end

  # source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#36
  def offending_range; end
end

# source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#10
RuboCop::Cop::EachToForCorrector::CORRECTION_WITHOUT_ARGUMENTS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/correctors/each_to_for_corrector.rb#9
RuboCop::Cop::EachToForCorrector::CORRECTION_WITH_ARGUMENTS = T.let(T.unsafe(nil), String)

# This class does empty line autocorrection
#
# source://rubocop//lib/rubocop/cop/correctors/empty_line_corrector.rb#6
class RuboCop::Cop::EmptyLineCorrector
  class << self
    # source://rubocop//lib/rubocop/cop/correctors/empty_line_corrector.rb#8
    def correct(corrector, node); end

    # source://rubocop//lib/rubocop/cop/correctors/empty_line_corrector.rb#19
    def insert_before(corrector, node); end
  end
end

# Common code for empty parameter cops.
#
# source://rubocop//lib/rubocop/cop/mixin/empty_parameter.rb#6
module RuboCop::Cop::EmptyParameter
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/empty_parameter.rb#12
  def empty_arguments?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/empty_parameter.rb#16
  def check(node); end
end

# Functions for checking the alignment of the `end` keyword.
#
# source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#6
module RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#60
  def accept_end_kw_alignment?(end_loc); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#50
  def add_offense_for_misalignment(node, align_with); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#19
  def check_end_kw_alignment(node, align_ranges); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#15
  def check_end_kw_in_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#75
  def line_break_before_keyword?(whole_expression, rhs); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#35
  def matching_ranges(end_loc, align_ranges); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#41
  def start_line_range(node); end

  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#65
  def style_parameter_name; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#69
  def variable_alignment?(whole_expression, rhs, end_alignment_style); end
end

# source://rubocop//lib/rubocop/cop/mixin/end_keyword_alignment.rb#10
RuboCop::Cop::EndKeywordAlignment::MSG = T.let(T.unsafe(nil), String)

# Common functionality for enforcing a specific superclass.
#
# IMPORTANT: RuboCop core depended on this module when it supported Rails department.
# Rails department has been extracted to RuboCop Rails gem.
#
# It will not be updated to `RuboCop::Cop::Base` v1 API to maintain compatibility
# with existing RuboCop Rails 2.8 or lower.
#
# @api private
# @deprecated This module is deprecated and will be removed by RuboCop 2.0.
#
# source://rubocop//lib/rubocop/cop/mixin/enforce_superclass.rb#15
module RuboCop::Cop::EnforceSuperclass
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/enforce_superclass.rb#35
  def on_class(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/enforce_superclass.rb#39
  def on_send(node); end

  class << self
    # @api private
    # @private
    #
    # source://rubocop//lib/rubocop/cop/mixin/enforce_superclass.rb#16
    def included(base); end
  end
end

# Common functionality for checking for a line break before the first
# element in a multi-line collection.
#
# source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#7
module RuboCop::Cop::FirstElementLineBreak
  private

  # source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#23
  def check_children_line_break(node, children, start = T.unsafe(nil), ignore_last: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#10
  def check_method_line_break(node, children, ignore_last: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#37
  def first_by_line(nodes); end

  # source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#41
  def last_line(nodes, ignore_last:); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/first_element_line_break.rb#18
  def method_uses_parens?(node, limit); end
end

# This class autocorrects `for` iteration to `#each` enumeration.
#
# source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#6
class RuboCop::Cop::ForToEachCorrector
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [ForToEachCorrector] a new instance of ForToEachCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#11
  def initialize(for_node); end

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#17
  def call(corrector); end

  private

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#57
  def collection_end; end

  # Returns the value of attribute collection_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#25
  def collection_node; end

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#31
  def collection_source; end

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#27
  def correction; end

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#45
  def end_range; end

  # Returns the value of attribute for_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#25
  def for_node; end

  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#53
  def keyword_begin; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#39
  def requires_parentheses?; end

  # Returns the value of attribute variable_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#25
  def variable_node; end
end

# source://rubocop//lib/rubocop/cop/correctors/for_to_each_corrector.rb#9
RuboCop::Cop::ForToEachCorrector::CORRECTION = T.let(T.unsafe(nil), String)

# A scaffold for concrete forces.
#
# source://rubocop//lib/rubocop/cop/force.rb#6
class RuboCop::Cop::Force
  # @return [Force] a new instance of Force
  #
  # source://rubocop//lib/rubocop/cop/force.rb#32
  def initialize(cops); end

  # Returns the value of attribute cops.
  #
  # source://rubocop//lib/rubocop/cop/force.rb#17
  def cops; end

  # source://rubocop//lib/rubocop/cop/force.rb#50
  def investigate(_processed_source); end

  # source://rubocop//lib/rubocop/cop/force.rb#36
  def name; end

  # source://rubocop//lib/rubocop/cop/force.rb#40
  def run_hook(method_name, *args); end

  class << self
    # source://rubocop//lib/rubocop/cop/force.rb#19
    def all; end

    # source://rubocop//lib/rubocop/cop/force.rb#28
    def force_name; end

    # @private
    #
    # source://rubocop//lib/rubocop/cop/force.rb#23
    def inherited(subclass); end
  end
end

# @api private
#
# source://rubocop//lib/rubocop/cop/force.rb#8
class RuboCop::Cop::Force::HookError < ::StandardError
  # @api private
  # @return [HookError] a new instance of HookError
  #
  # source://rubocop//lib/rubocop/cop/force.rb#11
  def initialize(joining_cop); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/force.rb#9
  def joining_cop; end
end

# Common functionality for dealing with frozen string literals.
#
# source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#6
module RuboCop::Cop::FrozenStringLiteral
  private

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#35
  def frozen_heredoc?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#21
  def frozen_string_literal?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#15
  def frozen_string_literal_comment_exists?; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#66
  def frozen_string_literal_specified?; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#60
  def frozen_string_literals_disabled?; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#41
  def frozen_string_literals_enabled?; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#76
  def leading_comment_lines; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#72
  def leading_magic_comments; end

  # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#31
  def uninterpolated_string?(node); end

  class << self
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#15
    def frozen_string_literal_comment_exists?; end
  end
end

# source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#9
RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#10
RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL_ENABLED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/frozen_string_literal.rb#11
RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL_TYPES_RUBY27 = T.let(T.unsafe(nil), Array)

# Common functionality for checking gem declarations.
#
# source://rubocop//lib/rubocop/cop/mixin/gem_declaration.rb#6
module RuboCop::Cop::GemDeclaration
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/gem_declaration.rb#10
  def gem_declaration?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/gemspec/add_runtime_dependency.rb#5
module RuboCop::Cop::Gemspec; end

# Prefer `add_dependency` over `add_runtime_dependency` as the latter is
# considered soft-deprecated.
#
# @example
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_runtime_dependency('rubocop')
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency('rubocop')
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/add_runtime_dependency.rb#21
class RuboCop::Cop::Gemspec::AddRuntimeDependency < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/gemspec/add_runtime_dependency.rb#28
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/gemspec/add_runtime_dependency.rb#24
RuboCop::Cop::Gemspec::AddRuntimeDependency::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/add_runtime_dependency.rb#26
RuboCop::Cop::Gemspec::AddRuntimeDependency::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforce that gem dependency version specifications or a commit reference (branch,
# ref, or tag) are either required or forbidden.
#
# @example EnforcedStyle: required (default)
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
# @example EnforcedStyle: forbidden
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser'
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#53
class RuboCop::Cop::Gemspec::DependencyVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::GemspecHelp

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#67
  def add_dependency_method_declaration?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#78
  def includes_commit_reference?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#73
  def includes_version_specification?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#82
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#118
  def add_dependency_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#96
  def allowed_gem?(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#100
  def allowed_gems; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#132
  def forbidden_offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#138
  def forbidden_style?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#112
  def match_block_variable_name?(receiver_name); end

  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#104
  def message(_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#122
  def offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#126
  def required_offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#142
  def required_style?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#146
  def version_specification?(expression); end
end

# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#61
RuboCop::Cop::Gemspec::DependencyVersion::ADD_DEPENDENCY_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#58
RuboCop::Cop::Gemspec::DependencyVersion::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#57
RuboCop::Cop::Gemspec::DependencyVersion::REQUIRED_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#64
RuboCop::Cop::Gemspec::DependencyVersion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/gemspec/dependency_version.rb#59
RuboCop::Cop::Gemspec::DependencyVersion::VERSION_SPECIFICATION_REGEX = T.let(T.unsafe(nil), Regexp)

# Checks that deprecated attributes are not set in a gemspec file.
# Removing deprecated attributes allows the user to receive smaller packed gems.
#
# @example
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   spec.test_files = Dir.glob('test/**/*')
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   spec.test_files += Dir.glob('test/**/*')
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#28
class RuboCop::Cop::Gemspec::DeprecatedAttributeAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#35
  def gem_specification(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#43
  def on_block(block_node); end

  private

  # source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#86
  def format_message_from; end

  # source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#63
  def node_and_method_name(node, attribute); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#72
  def use_deprecated_attributes?(node, block_parameter); end
end

# source://rubocop//lib/rubocop/cop/gemspec/deprecated_attribute_assignment.rb#32
RuboCop::Cop::Gemspec::DeprecatedAttributeAssignment::MSG = T.let(T.unsafe(nil), String)

# Enforce that development dependencies for a gem are specified in
# `Gemfile`, rather than in the `gemspec` using
# `add_development_dependency`. Alternatively, using `EnforcedStyle:
# gemspec`, enforce that all dependencies are specified in `gemspec`,
# rather than in `Gemfile`.
#
# @example EnforcedStyle: Gemfile (default)
#   # Specify runtime dependencies in your gemspec,
#   # but all other dependencies in your Gemfile.
#
#   # bad
#   # example.gemspec
#   s.add_development_dependency "foo"
#
#   # good
#   # Gemfile
#   gem "foo"
#
#   # good
#   # gems.rb
#   gem "foo"
#
#   # good (with AllowedGems: ["bar"])
#   # example.gemspec
#   s.add_development_dependency "bar"
# @example EnforcedStyle: gems.rb
#   # Specify runtime dependencies in your gemspec,
#   # but all other dependencies in your Gemfile.
#   #
#   # Identical to `EnforcedStyle: Gemfile`, but with a different error message.
#   # Rely on Bundler/GemFilename to enforce the use of `Gemfile` vs `gems.rb`.
#
#   # bad
#   # example.gemspec
#   s.add_development_dependency "foo"
#
#   # good
#   # Gemfile
#   gem "foo"
#
#   # good
#   # gems.rb
#   gem "foo"
#
#   # good (with AllowedGems: ["bar"])
#   # example.gemspec
#   s.add_development_dependency "bar"
# @example EnforcedStyle: gemspec
#   # Specify all dependencies in your gemspec.
#
#   # bad
#   # Gemfile
#   gem "foo"
#
#   # good
#   # example.gemspec
#   s.add_development_dependency "foo"
#
#   # good (with AllowedGems: ["bar"])
#   # Gemfile
#   gem "bar"
#
# source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#70
class RuboCop::Cop::Gemspec::DevelopmentDependencies < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  # source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#77
  def add_development_dependency?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#82
  def gem?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#86
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#97
  def forbidden_gem?(gem_name); end

  # source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#101
  def message(_range); end
end

# source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#73
RuboCop::Cop::Gemspec::DevelopmentDependencies::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/development_dependencies.rb#74
RuboCop::Cop::Gemspec::DevelopmentDependencies::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# An attribute assignment method calls should be listed only once
# in a gemspec.
#
# Assigning to an attribute with the same name using `spec.foo =` will be
# an unintended usage. On the other hand, duplication of methods such
# as `spec.requirements`, `spec.add_runtime_dependency`, and others are
# permitted because it is the intended use of appending values.
#
# @example
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'rubocop'
#   spec.name = 'rubocop2'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.name = 'rubocop'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.requirements << 'libmagick, v6.0'
#   spec.requirements << 'A good graphics card'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency('parallel', '~> 1.10')
#   spec.add_dependency('parser', '>= 2.3.3.1', '< 3.0')
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#37
class RuboCop::Cop::Gemspec::DuplicatedAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::GemspecHelp

  # source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#45
  def assignment_method_declarations(param0); end

  # source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#50
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#68
  def duplicated_assignment_method_nodes; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#62
  def match_block_variable_name?(receiver_name); end

  # source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#76
  def register_offense(node, assignment, line_of_first_occurrence); end
end

# source://rubocop//lib/rubocop/cop/gemspec/duplicated_assignment.rb#41
RuboCop::Cop::Gemspec::DuplicatedAssignment::MSG = T.let(T.unsafe(nil), String)

# Dependencies in the gemspec should be alphabetically sorted.
#
# @example
#   # bad
#   spec.add_dependency 'rubocop'
#   spec.add_dependency 'rspec'
#
#   # good
#   spec.add_dependency 'rspec'
#   spec.add_dependency 'rubocop'
#
#   # good
#   spec.add_dependency 'rubocop'
#
#   spec.add_dependency 'rspec'
#
#   # bad
#   spec.add_development_dependency 'rubocop'
#   spec.add_development_dependency 'rspec'
#
#   # good
#   spec.add_development_dependency 'rspec'
#   spec.add_development_dependency 'rubocop'
#
#   # good
#   spec.add_development_dependency 'rubocop'
#
#   spec.add_development_dependency 'rspec'
#
#   # bad
#   spec.add_runtime_dependency 'rubocop'
#   spec.add_runtime_dependency 'rspec'
#
#   # good
#   spec.add_runtime_dependency 'rspec'
#   spec.add_runtime_dependency 'rubocop'
#
#   # good
#   spec.add_runtime_dependency 'rubocop'
#
#   spec.add_runtime_dependency 'rspec'
# @example TreatCommentsAsGroupSeparators: true (default)
#   # good
#   # For code quality
#   spec.add_dependency 'rubocop'
#   # For tests
#   spec.add_dependency 'rspec'
# @example TreatCommentsAsGroupSeparators: false
#   # bad
#   # For code quality
#   spec.add_dependency 'rubocop'
#   # For tests
#   spec.add_dependency 'rspec'
#
# source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#61
class RuboCop::Cop::Gemspec::OrderedDependencies < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#95
  def dependency_declarations(param0); end

  # source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#69
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#90
  def get_dependency_name(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#84
  def previous_declaration(node); end
end

# source://rubocop//lib/rubocop/cop/gemspec/ordered_dependencies.rb#65
RuboCop::Cop::Gemspec::OrderedDependencies::MSG = T.let(T.unsafe(nil), String)

# Requires a gemspec to have `rubygems_mfa_required` metadata set.
#
# This setting tells RubyGems that MFA (Multi-Factor Authentication) is
# required for accounts to be able perform privileged operations, such as
# (see RubyGems' documentation for the full list of privileged
# operations):
#
# * `gem push`
# * `gem yank`
# * `gem owner --add/remove`
# * adding or removing owners using gem ownership page
#
# This helps make your gem more secure, as users can be more
# confident that gem updates were pushed by maintainers.
#
# @example
#   # bad
#   Gem::Specification.new do |spec|
#   # no `rubygems_mfa_required` metadata specified
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'true'
#   }
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'true'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'false'
#   }
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'true'
#   }
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'false'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'true'
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#63
class RuboCop::Cop::Gemspec::RequireMFA < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::GemspecHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#70
  def metadata(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#87
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#78
  def rubygems_mfa_required(param0); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#83
  def true_string?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#115
  def autocorrect(corrector, node, block_var, metadata); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#139
  def change_value(corrector, value); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#125
  def correct_metadata(corrector, metadata); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#133
  def insert_mfa_required(corrector, node, block_var); end

  # source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#108
  def mfa_value(metadata_value); end
end

# source://rubocop//lib/rubocop/cop/gemspec/require_mfa.rb#67
RuboCop::Cop::Gemspec::RequireMFA::MSG = T.let(T.unsafe(nil), String)

# Checks that `required_ruby_version` in a gemspec file is set to a valid
# value (non-blank) and matches `TargetRubyVersion` as set in RuboCop's
# configuration for the gem.
#
# This ensures that RuboCop is using the same Ruby version as the gem.
#
# @example
#   # When `TargetRubyVersion` of .rubocop.yml is `2.5`.
#
#   # bad
#   Gem::Specification.new do |spec|
#   # no `required_ruby_version` specified
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.4.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.6.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = ''
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.5.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.5'
#   end
#
#   # accepted but not recommended
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = ['>= 2.5.0', '< 2.7.0']
#   end
#
#   # accepted but not recommended, since
#   # Ruby does not really follow semantic versioning
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '~> 2.5'
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#55
class RuboCop::Cop::Gemspec::RequiredRubyVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#70
  def defined_ruby_version(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#78
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#84
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#65
  def required_ruby_version?(param0); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#96
  def dynamic_version?(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#102
  def extract_ruby_version(required_ruby_version); end

  # source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#120
  def not_equal_message(required_ruby_version, target_ruby_version); end
end

# source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#62
RuboCop::Cop::Gemspec::RequiredRubyVersion::MISSING_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#59
RuboCop::Cop::Gemspec::RequiredRubyVersion::NOT_EQUAL_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/gemspec/required_ruby_version.rb#58
RuboCop::Cop::Gemspec::RequiredRubyVersion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that `RUBY_VERSION` constant is not used in gemspec.
# Using `RUBY_VERSION` is dangerous because value of the
# constant is determined by `rake release`.
# It's possible to have dependency based on ruby version used
# to execute `rake release` and not user's ruby version.
#
# @example
#
#   # bad
#   Gem::Specification.new do |spec|
#   if RUBY_VERSION >= '3.0'
#   spec.add_dependency 'gem_a'
#   else
#   spec.add_dependency 'gem_b'
#   end
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'gem_a'
#   end
#
# source://rubocop//lib/rubocop/cop/gemspec/ruby_version_globals_usage.rb#28
class RuboCop::Cop::Gemspec::RubyVersionGlobalsUsage < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::GemspecHelp

  # source://rubocop//lib/rubocop/cop/gemspec/ruby_version_globals_usage.rb#36
  def on_const(node); end

  # source://rubocop//lib/rubocop/cop/gemspec/ruby_version_globals_usage.rb#34
  def ruby_version?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/gemspec/ruby_version_globals_usage.rb#44
  def gem_spec_with_ruby_version?(node); end
end

# source://rubocop//lib/rubocop/cop/gemspec/ruby_version_globals_usage.rb#31
RuboCop::Cop::Gemspec::RubyVersionGlobalsUsage::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking gem declarations.
#
# source://rubocop//lib/rubocop/cop/mixin/gemspec_help.rb#6
module RuboCop::Cop::GemspecHelp
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/gemspec_help.rb#20
  def gem_specification(param0); end

  # source://rubocop//lib/rubocop/cop/mixin/gemspec_help.rb#10
  def gem_specification?(param0 = T.unsafe(nil)); end
end

# Source and spec generator for new cops
#
# This generator will take a cop name and generate a source file
# and spec file when given a valid qualified cop name.
#
# @api private
#
# source://rubocop//lib/rubocop/cop/generator.rb#10
class RuboCop::Cop::Generator
  # @api private
  # @raise [ArgumentError]
  # @return [Generator] a new instance of Generator
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#113
  def initialize(name, output: T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#133
  def inject_config(config_file_path: T.unsafe(nil), version_added: T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#129
  def inject_require(root_file_path: T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#146
  def todo; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#121
  def write_source; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#125
  def write_spec; end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#160
  def badge; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#183
  def generate(template); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#175
  def generated_source; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#179
  def generated_spec; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#160
  def output; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#208
  def snake_case(camel_case_string); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#198
  def source_path; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#188
  def spec_path; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/generator.rb#162
  def write_unless_file_exists(path, contents); end
end

# @api private
#
# source://rubocop//lib/rubocop/cop/generator.rb#109
RuboCop::Cop::Generator::CONFIGURATION_ADDED_MESSAGE = T.let(T.unsafe(nil), String)

# A class that injects a require directive into the root RuboCop file.
# It looks for other directives that require files in the same (cop)
# namespace and injects the provided one in alpha
#
# source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#9
class RuboCop::Cop::Generator::ConfigurationInjector
  # @return [ConfigurationInjector] a new instance of ConfigurationInjector
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#17
  def initialize(configuration_file_path:, badge:, version_added: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#24
  def inject; end

  private

  # Returns the value of attribute badge.
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#39
  def badge; end

  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#41
  def configuration_entries; end

  # Returns the value of attribute configuration_file_path.
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#39
  def configuration_file_path; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#59
  def cop_name_line?(yaml); end

  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#49
  def find_target_line; end

  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#45
  def new_configuration_entry; end

  # Returns the value of attribute output.
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#39
  def output; end

  # Returns the value of attribute version_added.
  #
  # source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#39
  def version_added; end
end

# source://rubocop//lib/rubocop/cop/generator/configuration_injector.rb#10
RuboCop::Cop::Generator::ConfigurationInjector::TEMPLATE = T.let(T.unsafe(nil), String)

# A class that injects a require directive into the root RuboCop file.
# It looks for other directives that require files in the same (cop)
# namespace and injects the provided one in alpha
#
# source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#9
class RuboCop::Cop::Generator::RequireFileInjector
  # @return [RequireFileInjector] a new instance of RequireFileInjector
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#12
  def initialize(source_path:, root_file_path:, output: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#19
  def inject; end

  private

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#64
  def injectable_require_directive; end

  # Returns the value of attribute output.
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#29
  def output; end

  # Returns the value of attribute require_entries.
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#29
  def require_entries; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#31
  def require_exists?; end

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#68
  def require_path; end

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#58
  def require_path_fragments(require_directive); end

  # Returns the value of attribute root_file_path.
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#29
  def root_file_path; end

  # Returns the value of attribute source_path.
  #
  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#29
  def source_path; end

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#39
  def target_line; end

  # source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#35
  def updated_directives; end
end

# source://rubocop//lib/rubocop/cop/generator/require_file_injector.rb#10
RuboCop::Cop::Generator::RequireFileInjector::REQUIRE_PATH = T.let(T.unsafe(nil), Regexp)

# @api private
#
# source://rubocop//lib/rubocop/cop/generator.rb#11
RuboCop::Cop::Generator::SOURCE_TEMPLATE = T.let(T.unsafe(nil), String)

# @api private
#
# source://rubocop//lib/rubocop/cop/generator.rb#85
RuboCop::Cop::Generator::SPEC_TEMPLATE = T.let(T.unsafe(nil), String)

# Common functionality for checking hash alignment.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#6
module RuboCop::Cop::HashAlignmentStyles; end

# Handles calculation of deltas when the enforced style is 'key'.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#8
class RuboCop::Cop::HashAlignmentStyles::KeyAlignment
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#9
  def checkable_layout?(_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#20
  def deltas(first_pair, current_pair); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#13
  def deltas_for_first_pair(first_pair, _node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#34
  def separator_delta(pair); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#45
  def value_delta(pair); end
end

# Handles calculation of deltas for `kwsplat` nodes.
# This is a special case that just ensures the kwsplat is aligned with the rest of the hash
# since a `kwsplat` does not have a key, separator or value.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#145
class RuboCop::Cop::HashAlignmentStyles::KeywordSplatAlignment
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#146
  def deltas(first_pair, current_pair); end
end

# Handles calculation of deltas when the enforced style is 'separator'.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#120
class RuboCop::Cop::HashAlignmentStyles::SeparatorAlignment
  include ::RuboCop::Cop::HashAlignmentStyles::ValueAlignment

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#123
  def deltas_for_first_pair(*_nodes); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#133
  def hash_rocket_delta(first_pair, current_pair); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#129
  def key_delta(first_pair, current_pair); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#137
  def value_delta(first_pair, current_pair); end
end

# Handles calculation of deltas when the enforced style is 'table'.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#81
class RuboCop::Cop::HashAlignmentStyles::TableAlignment
  include ::RuboCop::Cop::HashAlignmentStyles::ValueAlignment

  # @return [TableAlignment] a new instance of TableAlignment
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#84
  def initialize; end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#88
  def deltas_for_first_pair(first_pair, node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#106
  def hash_rocket_delta(first_pair, current_pair); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#102
  def key_delta(first_pair, current_pair); end

  # Returns the value of attribute max_key_width.
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#100
  def max_key_width; end

  # Sets the attribute max_key_width
  #
  # @param value the value to set the attribute max_key_width to.
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#100
  def max_key_width=(_arg0); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#110
  def value_delta(first_pair, current_pair); end
end

# Common functionality for checking alignment of hash values.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#56
module RuboCop::Cop::HashAlignmentStyles::ValueAlignment
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#57
  def checkable_layout?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#61
  def deltas(first_pair, current_pair); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/hash_alignment_styles.rb#71
  def separator_delta(first_pair, current_pair, key_delta); end
end

# This module checks for Ruby 3.1's hash value omission syntax.
#
# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#7
module RuboCop::Cop::HashShorthandSyntax
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#14
  def on_hash_for_mixed_shorthand(hash_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#26
  def on_pair(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#126
  def brackets?(method_dispatch_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#156
  def breakdown_value_types_of_hash(hash_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#103
  def def_node_that_require_parentheses(node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#185
  def each_omittable_value_pair(hash_value_type_breakdown, &block); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#181
  def each_omitted_value_pair(hash_value_type_breakdown, &block); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#81
  def enforced_shorthand_syntax; end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#118
  def find_ancestor_method_dispatch_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#168
  def hash_with_mixed_shorthand_syntax?(hash_value_type_breakdown); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#172
  def hash_with_values_that_cant_be_omitted?(hash_value_type_breakdown); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#176
  def ignore_explicit_omissible_hash_shorthand_syntax?(hash_value_type_breakdown); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#75
  def ignore_hash_shorthand_syntax?(pair_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#69
  def ignore_mixed_hash_shorthand_syntax?(hash_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#141
  def last_expression?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#149
  def method_dispatch_as_argument?(method_dispatch_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#189
  def mixed_shorthand_syntax_check(hash_value_type_breakdown); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#205
  def no_mixed_shorthand_syntax_check(hash_value_type_breakdown); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#49
  def register_offense(node, message, replacement); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#85
  def require_hash_value?(hash_key_source, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#94
  def require_hash_value_for_around_hash_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#130
  def use_element_of_hash_literal_as_receiver?(ancestor, parent); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#135
  def use_modifier_form_without_parenthesized_method_call?(ancestor); end
end

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#12
RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_EXPLICIT_VALUE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#10
RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_MSG_PREFIX = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#11
RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_OMIT_VALUE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#216
class RuboCop::Cop::HashShorthandSyntax::DefNode < ::Struct
  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#225
  def first_argument; end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#229
  def last_argument; end

  # Returns the value of attribute node
  #
  # @return [Object] the current value of node
  def node; end

  # Sets the attribute node
  #
  # @param value [Object] the value to set the attribute node to.
  # @return [Object] the newly set value
  def node=(_); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#217
  def selector; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#9
RuboCop::Cop::HashShorthandSyntax::EXPLICIT_HASH_VALUE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/hash_shorthand_syntax.rb#8
RuboCop::Cop::HashShorthandSyntax::OMIT_HASH_VALUE_MSG = T.let(T.unsafe(nil), String)

# Common functionality for Style/HashTransformKeys and
# Style/HashTransformValues
#
# source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#7
module RuboCop::Cop::HashTransformMethod
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#13
  def array_receiver?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#17
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#34
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#27
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#108
  def execute_correction(corrector, node, correction); end

  # @abstract
  # @raise [NotImplementedError]
  # @return [Captures]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#83
  def extract_captures(_match); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#60
  def handle_possible_offense(node, match, match_desc); end

  # @abstract
  # @raise [NotImplementedError]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#90
  def new_method_name; end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#41
  def on_bad_each_with_object(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#46
  def on_bad_hash_brackets_map(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#51
  def on_bad_map_to_h(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#56
  def on_bad_to_h(_node); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#94
  def prepare_correction(node); end
end

# Internal helper class to hold autocorrect data
#
# source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#136
class RuboCop::Cop::HashTransformMethod::Autocorrection < ::Struct
  # Returns the value of attribute block_node
  #
  # @return [Object] the current value of block_node
  def block_node; end

  # Sets the attribute block_node
  #
  # @param value [Object] the value to set the attribute block_node to.
  # @return [Object] the newly set value
  def block_node=(_); end

  # Returns the value of attribute leading
  #
  # @return [Object] the current value of leading
  def leading; end

  # Sets the attribute leading
  #
  # @param value [Object] the value to set the attribute leading to.
  # @return [Object] the newly set value
  def leading=(_); end

  # Returns the value of attribute match
  #
  # @return [Object] the current value of match
  def match; end

  # Sets the attribute match
  #
  # @param value [Object] the value to set the attribute match to.
  # @return [Object] the newly set value
  def match=(_); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#177
  def set_new_arg_name(transformed_argname, corrector); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#181
  def set_new_body_expression(transforming_body_expr, corrector); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#167
  def set_new_method_name(new_method_name, corrector); end

  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#161
  def strip_prefix_and_suffix(node, corrector); end

  # Returns the value of attribute trailing
  #
  # @return [Object] the current value of trailing
  def trailing; end

  # Sets the attribute trailing
  #
  # @param value [Object] the value to set the attribute trailing to.
  # @return [Object] the newly set value
  def trailing=(_); end

  class << self
    def [](*_arg0); end

    # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#137
    def from_each_with_object(node, match); end

    # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#141
    def from_hash_brackets_map(node, match); end

    # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#145
    def from_map_to_h(node, match); end

    # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#157
    def from_to_h(node, match); end

    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Internal helper class to hold match data
#
# source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#118
class RuboCop::Cop::HashTransformMethod::Captures < ::Struct
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#119
  def noop_transformation?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#124
  def transformation_uses_both_args?; end

  # Returns the value of attribute transformed_argname
  #
  # @return [Object] the current value of transformed_argname
  def transformed_argname; end

  # Sets the attribute transformed_argname
  #
  # @param value [Object] the value to set the attribute transformed_argname to.
  # @return [Object] the newly set value
  def transformed_argname=(_); end

  # Returns the value of attribute transforming_body_expr
  #
  # @return [Object] the current value of transforming_body_expr
  def transforming_body_expr; end

  # Sets the attribute transforming_body_expr
  #
  # @param value [Object] the value to set the attribute transforming_body_expr to.
  # @return [Object] the newly set value
  def transforming_body_expr=(_); end

  # Returns the value of attribute unchanged_body_expr
  #
  # @return [Object] the current value of unchanged_body_expr
  def unchanged_body_expr; end

  # Sets the attribute unchanged_body_expr
  #
  # @param value [Object] the value to set the attribute unchanged_body_expr to.
  # @return [Object] the newly set value
  def unchanged_body_expr=(_); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#128
  def use_transformed_argname?; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rubocop//lib/rubocop/cop/mixin/hash_transform_method.rb#10
RuboCop::Cop::HashTransformMethod::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Common functionality for working with heredoc strings.
#
# source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#6
module RuboCop::Cop::Heredoc
  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#9
  def on_dstr(node); end

  # @raise [NotImplementedError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#17
  def on_heredoc(_node); end

  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#9
  def on_str(node); end

  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#9
  def on_xstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#28
  def delimiter_string(node); end

  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#34
  def heredoc_type(node); end

  # source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#23
  def indent_level(str); end
end

# source://rubocop//lib/rubocop/cop/mixin/heredoc.rb#7
RuboCop::Cop::Heredoc::OPENING_DELIMITER = T.let(T.unsafe(nil), Regexp)

# This class autocorrects `if...then` structures to a multiline `if` statement
#
# source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#6
class RuboCop::Cop::IfThenCorrector
  # @return [IfThenCorrector] a new instance of IfThenCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#9
  def initialize(if_node, indentation: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#14
  def call(corrector); end

  private

  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#50
  def branch_body_indentation; end

  # Returns the value of attribute if_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#20
  def if_node; end

  # Returns the value of attribute indentation.
  #
  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#20
  def indentation; end

  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#22
  def replacement(node = T.unsafe(nil), indentation = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#36
  def rewrite_else_branch(else_branch, indentation); end
end

# source://rubocop//lib/rubocop/cop/correctors/if_then_corrector.rb#7
RuboCop::Cop::IfThenCorrector::DEFAULT_INDENTATION_WIDTH = T.let(T.unsafe(nil), Integer)

# @deprecated IgnoredMethods class has been replaced with AllowedMethods.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_methods.rb#46
RuboCop::Cop::IgnoredMethods = RuboCop::Cop::AllowedMethods

# Handles adding and checking ignored nodes.
#
# source://rubocop//lib/rubocop/cop/ignored_node.rb#6
module RuboCop::Cop::IgnoredNode
  # source://rubocop//lib/rubocop/cop/ignored_node.rb#7
  def ignore_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/ignored_node.rb#24
  def ignored_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/ignored_node.rb#11
  def part_of_ignored_node?(node); end

  private

  # source://rubocop//lib/rubocop/cop/ignored_node.rb#31
  def ignored_nodes; end
end

# @deprecated IgnoredPattern class has been replaced with AllowedPattern.
#
# source://rubocop//lib/rubocop/cop/mixin/allowed_pattern.rb#66
RuboCop::Cop::IgnoredPattern = RuboCop::Cop::AllowedPattern

# Common functionality for checking integer nodes.
#
# source://rubocop//lib/rubocop/cop/mixin/integer_node.rb#6
module RuboCop::Cop::IntegerNode
  private

  # source://rubocop//lib/rubocop/cop/mixin/integer_node.rb#9
  def integer_part(node); end
end

# Common functionality for working with string interpolations.
#
# @abstract Subclasses are expected to implement {#on_interpolation}.
#
# source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#8
module RuboCop::Cop::Interpolation
  # source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#9
  def on_dstr(node); end

  # source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#9
  def on_dsym(node); end

  # source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#17
  def on_node_with_interpolations(node); end

  # source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#9
  def on_regexp(node); end

  # source://rubocop//lib/rubocop/cop/mixin/interpolation.rb#9
  def on_xstr(node); end
end

# This class autocorrects lambda literal to method notation.
#
# source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#6
class RuboCop::Cop::LambdaLiteralToMethodCorrector
  # @return [LambdaLiteralToMethodCorrector] a new instance of LambdaLiteralToMethodCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#7
  def initialize(block_node); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#13
  def call(corrector); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#118
  def arg_to_unparenthesized_call?; end

  # Returns the value of attribute arguments.
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#34
  def arguments; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#102
  def arguments_begin_pos; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#98
  def arguments_end_pos; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#110
  def block_begin; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#106
  def block_end; end

  # Returns the value of attribute block_node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#34
  def block_node; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#59
  def insert_arguments(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#43
  def insert_separating_space(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#88
  def lambda_arg_string; end

  # Returns the value of attribute method.
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#34
  def method; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#92
  def needs_separating_space?; end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#53
  def remove_arguments(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#66
  def remove_leading_whitespace(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#74
  def remove_trailing_whitespace(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#36
  def remove_unparenthesized_whitespace(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#79
  def replace_delimiters(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#49
  def replace_selector(corrector); end

  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#114
  def selector_end; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/lambda_literal_to_method_corrector.rb#134
  def separating_space?; end
end

# source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#5
module RuboCop::Cop::Layout; end

# Bare access modifiers (those not applying to specific methods) should be
# indented as deep as method definitions, or as deep as the class/module
# keyword, depending on configuration.
#
# @example EnforcedStyle: indent (default)
#   # bad
#   class Plumbus
#   private
#   def smooth; end
#   end
#
#   # good
#   class Plumbus
#   private
#   def smooth; end
#   end
# @example EnforcedStyle: outdent
#   # bad
#   class Plumbus
#   private
#   def smooth; end
#   end
#
#   # good
#   class Plumbus
#   private
#   def smooth; end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#35
class RuboCop::Cop::Layout::AccessModifierIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#43
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#43
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#43
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#43
  def on_sclass(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#54
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#58
  def check_body(body, node); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#65
  def check_modifier(send_node, end_range); end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#88
  def expected_indent_offset; end

  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#84
  def message(range); end

  # An offset that is not expected, but correct if the configuration is
  # changed.
  #
  # source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#94
  def unexpected_indent_offset; end
end

# source://rubocop//lib/rubocop/cop/layout/access_modifier_indentation.rb#41
RuboCop::Cop::Layout::AccessModifierIndentation::MSG = T.let(T.unsafe(nil), String)

# Here we check if the arguments on a multi-line method
# definition are aligned.
#
# @example EnforcedStyle: with_first_argument (default)
#   # good
#
#   foo :bar,
#   :baz,
#   key: value
#
#   foo(
#   :bar,
#   :baz,
#   key: value
#   )
#
#   # bad
#
#   foo :bar,
#   :baz,
#   key: value
#
#   foo(
#   :bar,
#   :baz,
#   key: value
#   )
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   foo :bar,
#   :baz,
#   key: value
#
#   # bad
#
#   foo :bar,
#   :baz,
#   key: value
#
# source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#46
class RuboCop::Cop::Layout::ArgumentAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#55
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#55
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#92
  def arguments_or_first_arg_pairs(node); end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#80
  def arguments_with_last_arg_pairs(node); end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#108
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#68
  def autocorrect_incompatible_with_other_cops?; end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#124
  def base_column(node, first_argument); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#144
  def enforce_hash_argument_with_separator?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#116
  def fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#72
  def flattened_arguments(node); end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#152
  def hash_argument_config; end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#112
  def message(_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#101
  def multiple_arguments?(node); end

  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#135
  def target_method_lineno(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#120
  def with_first_argument_style?; end
end

# source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#50
RuboCop::Cop::Layout::ArgumentAlignment::ALIGN_PARAMS_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/argument_alignment.rb#52
RuboCop::Cop::Layout::ArgumentAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Here we check if the elements of a multi-line array literal are
# aligned.
#
# @example EnforcedStyle: with_first_element (default)
#   # good
#
#   array = [1, 2, 3,
#   4, 5, 6]
#   array = ['run',
#   'forrest',
#   'run']
#
#   # bad
#
#   array = [1, 2, 3,
#   4, 5, 6]
#   array = ['run',
#   'forrest',
#   'run']
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   array = [1, 2, 3,
#   4, 5, 6]
#
#   # bad
#
#   array = [1, 2, 3,
#   4, 5, 6]
#
# source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#36
class RuboCop::Cop::Layout::ArrayAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#46
  def on_array(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#55
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#67
  def base_column(node, args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#63
  def fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#59
  def message(_range); end

  # source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#78
  def target_method_lineno(node); end
end

# source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#40
RuboCop::Cop::Layout::ArrayAlignment::ALIGN_ELEMENTS_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/array_alignment.rb#43
RuboCop::Cop::Layout::ArrayAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first line of the
# right-hand-side of a multi-line assignment.
#
# The indentation of the remaining lines can be corrected with
# other cops such as `Layout/IndentationConsistency` and `Layout/EndAlignment`.
#
# @example
#   # bad
#   value =
#   if foo
#   'bar'
#   end
#
#   # good
#   value =
#   if foo
#   'bar'
#   end
#
# source://rubocop//lib/rubocop/cop/layout/assignment_indentation.rb#25
class RuboCop::Cop::Layout::AssignmentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  private

  # source://rubocop//lib/rubocop/cop/layout/assignment_indentation.rb#43
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/assignment_indentation.rb#34
  def check_assignment(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/assignment_indentation.rb#47
  def leftmost_multiple_assignment(node); end
end

# source://rubocop//lib/rubocop/cop/layout/assignment_indentation.rb#30
RuboCop::Cop::Layout::AssignmentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keyword of `begin` is aligned properly.
#
# Two modes are supported through the `EnforcedStyleAlignWith` configuration
# parameter. If it's set to `start_of_line` (which is the default), the
# `end` shall be aligned with the start of the line where the `begin`
# keyword is. If it's set to `begin`, the `end` shall be aligned with the
# `begin` keyword.
#
# `Layout/EndAlignment` cop aligns with keywords (e.g. `if`, `while`, `case`)
# by default. On the other hand, `||= begin` that this cop targets tends to
# align with the start of the line, it defaults to `EnforcedStyleAlignWith: start_of_line`.
# These style can be configured by each cop.
#
# @example EnforcedStyleAlignWith: start_of_line (default)
#   # bad
#   foo ||= begin
#   do_something
#   end
#
#   # good
#   foo ||= begin
#   do_something
#   end
# @example EnforcedStyleAlignWith: begin
#   # bad
#   foo ||= begin
#   do_something
#   end
#
#   # good
#   foo ||= begin
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#41
class RuboCop::Cop::Layout::BeginEndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#48
  def on_kwbegin(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#63
  def alignment_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#59
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#54
  def check_begin_alignment(node); end
end

# source://rubocop//lib/rubocop/cop/layout/begin_end_alignment.rb#46
RuboCop::Cop::Layout::BeginEndAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keywords are aligned properly for do
# end blocks.
#
# Three modes are supported through the `EnforcedStyleAlignWith`
# configuration parameter:
#
# `start_of_block` : the `end` shall be aligned with the
# start of the line where the `do` appeared.
#
# `start_of_line` : the `end` shall be aligned with the
# start of the line where the expression started.
#
# `either` (which is the default) : the `end` is allowed to be in either
# location. The autofixer will default to `start_of_line`.
#
# @example EnforcedStyleAlignWith: either (default)
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   foo.bar
#   .each do
#   baz
#   end
# @example EnforcedStyleAlignWith: start_of_block
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   foo.bar
#   .each do
#   baz
#   end
# @example EnforcedStyleAlignWith: start_of_line
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   foo.bar
#   .each do
#   baz
#   end
#
# source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#66
class RuboCop::Cop::Layout::BlockAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#74
  def block_end_align_target?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#83
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#83
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#89
  def style_parameter_name; end

  private

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#228
  def add_space_before(corrector, loc, delta); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#205
  def alt_start_msg(start_loc, source_line_column); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#155
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#105
  def block_end_align_target(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#123
  def check_block_alignment(start_node, block_node); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#178
  def compute_do_source_line_column(node, end_loc); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#220
  def compute_start_col(ancestor_node, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#119
  def disqualified_parent?(parent, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#115
  def end_align_target?(node, parent); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#168
  def format_message(start_loc, end_loc, do_source_line_column, error_source_line_column); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#215
  def format_source_line_column(source_line_column); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#197
  def loc_to_source_line_column(loc); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#136
  def register_offense(block_node, start_loc, end_loc, do_source_line_column); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#232
  def remove_space_before(corrector, end_pos, delta); end

  # source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#95
  def start_for_block_node(block_node); end
end

# source://rubocop//lib/rubocop/cop/layout/block_alignment.rb#71
RuboCop::Cop::Layout::BlockAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end statement of a do..end block
# is on its own line.
#
# @example
#   # bad
#   blah do |i|
#   foo(i) end
#
#   # good
#   blah do |i|
#   foo(i)
#   end
#
#   # bad
#   blah { |i|
#   foo(i) }
#
#   # good
#   blah { |i|
#   foo(i)
#   }
#
# source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#27
class RuboCop::Cop::Layout::BlockEndNewline < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#33
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#33
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#66
  def last_heredoc_argument(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#62
  def message(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#76
  def offense_range(node); end

  # source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#49
  def register_offense(node, offense_range); end
end

# source://rubocop//lib/rubocop/cop/layout/block_end_newline.rb#31
RuboCop::Cop::Layout::BlockEndNewline::MSG = T.let(T.unsafe(nil), String)

# Checks how the `when` and ``in``s of a `case` expression
# are indented in relation to its `case` or `end` keyword.
#
# It will register a separate offense for each misaligned `when` and `in`.
#
# @example
#   # If Layout/EndAlignment is set to keyword style (default)
#   # *case* and *end* should always be aligned to same depth,
#   # and therefore *when* should always be aligned to both -
#   # regardless of configuration.
#
#   # bad for all styles
#   case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good for all styles
#   case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
# @example EnforcedStyle: case (default)
#   # if EndAlignment is set to other style such as
#   # start_of_line (as shown below), then *when* alignment
#   # configuration does have an effect.
#
#   # bad
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
# @example EnforcedStyle: end
#   # bad
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
# source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#112
class RuboCop::Cop::Layout::CaseIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#120
  def on_case(case_node); end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#127
  def on_case_match(case_match_node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#193
  def base_column(case_node, base); end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#150
  def check_when(when_node, branch_type); end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#182
  def detect_incorrect_style(when_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#136
  def end_and_last_conditional_same_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#146
  def enforced_style_end?; end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#169
  def incorrect_style(when_node, branch_type); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#161
  def indent_one_step?; end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#165
  def indentation_width; end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#207
  def replacement(node); end

  # source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#200
  def whitespace_range(node); end
end

# source://rubocop//lib/rubocop/cop/layout/case_indentation.rb#118
RuboCop::Cop::Layout::CaseIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks if the code style follows the ExpectedOrder configuration:
#
# `Categories` allows us to map macro names into a category.
#
# Consider an example of code style that covers the following order:
#
# * Module inclusion (include, prepend, extend)
# * Constants
# * Associations (has_one, has_many)
# * Public attribute macros (attr_accessor, attr_writer, attr_reader)
# * Other macros (validates, validate)
# * Public class methods
# * Initializer
# * Public instance methods
# * Protected attribute macros (attr_accessor, attr_writer, attr_reader)
# * Protected instance methods
# * Private attribute macros (attr_accessor, attr_writer, attr_reader)
# * Private instance methods
#
# You can configure the following order:
#
# [source,yaml]
# ----
#  Layout/ClassStructure:
#    ExpectedOrder:
#      - module_inclusion
#      - constants
#      - association
#      - public_attribute_macros
#      - public_delegate
#      - macros
#      - public_class_methods
#      - initializer
#      - public_methods
#      - protected_attribute_macros
#      - protected_methods
#      - private_attribute_macros
#      - private_delegate
#      - private_methods
# ----
#
# Instead of putting all literals in the expected order, is also
# possible to group categories of macros. Visibility levels are handled
# automatically.
#
# [source,yaml]
# ----
#  Layout/ClassStructure:
#    Categories:
#      association:
#        - has_many
#        - has_one
#      attribute_macros:
#        - attr_accessor
#        - attr_reader
#        - attr_writer
#      macros:
#        - validates
#        - validate
#      module_inclusion:
#        - include
#        - prepend
#        - extend
# ----
#
# @example
#   # bad
#   # Expect extend be before constant
#   class Person < ApplicationRecord
#   has_many :orders
#   ANSWER = 42
#
#   extend SomeModule
#   include AnotherModule
#   end
#
#   # good
#   class Person
#   # extend and include go first
#   extend SomeModule
#   include AnotherModule
#
#   # inner classes
#   CustomError = Class.new(StandardError)
#
#   # constants are next
#   SOME_CONSTANT = 20
#
#   # afterwards we have public attribute macros
#   attr_reader :name
#
#   # followed by other macros (if any)
#   validates :name
#
#   # then we have public delegate macros
#   delegate :to_s, to: :name
#
#   # public class methods are next in line
#   def self.some_method
#   end
#
#   # initialization goes between class methods and instance methods
#   def initialize
#   end
#
#   # followed by other public instance methods
#   def some_method
#   end
#
#   # protected attribute macros and methods go next
#   protected
#
#   attr_reader :protected_name
#
#   def some_protected_method
#   end
#
#   # private attribute macros, delegate macros and methods
#   # are grouped near the end
#   private
#
#   attr_reader :private_name
#
#   delegate :some_private_delegate, to: :name
#
#   def some_private_method
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/class_structure.rb#142
class RuboCop::Cop::Layout::ClassStructure < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::CommentsHelp
  extend ::RuboCop::Cop::AutoCorrector

  # Validates code style on class declaration.
  # Add offense when find a node out of expected order.
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#158
  def on_class(class_node); end

  # Validates code style on class declaration.
  # Add offense when find a node out of expected order.
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#158
  def on_sclass(class_node); end

  private

  # Autocorrect by swapping between two nodes autocorrecting them
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#174
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#305
  def begin_pos_with_comment(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#328
  def buffer; end

  # Setting categories hash allow you to group methods in group to match
  # in the {expected_order}.
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#340
  def categories; end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#234
  def class_elements(class_node); end

  # Classifies a node to match with something in the {expected_order}
  #
  # @param node to be analysed
  # @return String when the node type is a `:block` then
  #   {classify} recursively with the first children
  # @return String when the node type is a `:send` then {find_category}
  #   by method name
  # @return String otherwise trying to {humanize_node} of the current node
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#194
  def classify(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#271
  def dynamic_constant?(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#295
  def end_position_for(node); end

  # Load expected order from `ExpectedOrder` config.
  # Define new terms in the expected order by adding new {categories}.
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#334
  def expected_order; end

  # Categorize a node according to the {expected_order}
  # Try to match {categories} values against the node's method_name given
  # also its visibility.
  #
  # @param node to be analysed.
  # @return [String] with the key category or the `method_name` as string
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#212
  def find_category(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#324
  def find_heredoc(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#262
  def humanize_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#246
  def ignore?(node, classification); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#253
  def ignore_for_autocorrect?(node, sibling); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#289
  def marked_as_private_constant?(node, name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#279
  def private_constant?(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#320
  def start_line_position(node); end

  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#225
  def walk_over_nested_class_definition(class_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/class_structure.rb#316
  def whole_line_comment_at_line?(line); end
end

# source://rubocop//lib/rubocop/cop/layout/class_structure.rb#147
RuboCop::Cop::Layout::ClassStructure::HUMANIZED_NODE_TYPE = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/layout/class_structure.rb#154
RuboCop::Cop::Layout::ClassStructure::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of here document closings.
#
# @example
#
#   # bad
#   class Foo
#   def bar
#   <<~SQL
#   'Hi'
#   SQL
#   end
#   end
#
#   # good
#   class Foo
#   def bar
#   <<~SQL
#   'Hi'
#   SQL
#   end
#   end
#
#   # bad
#
#   # heredoc contents is before closing heredoc.
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
#
#   # good
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
#
#   # good
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
#
# source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#48
class RuboCop::Cop::Layout::ClosingHeredocIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#57
  def on_heredoc(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#74
  def argument_indentation_correct?(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#82
  def closing_indentation(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#101
  def find_node_used_heredoc_argument(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#90
  def heredoc_closing(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#86
  def heredoc_opening(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#117
  def indent_level(source_line); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#94
  def indented_end(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#109
  def message(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#70
  def opening_indentation(node); end
end

# source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#53
RuboCop::Cop::Layout::ClosingHeredocIndentation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#54
RuboCop::Cop::Layout::ClosingHeredocIndentation::MSG_ARG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/closing_heredoc_indentation.rb#52
RuboCop::Cop::Layout::ClosingHeredocIndentation::SIMPLE_HEREDOC = T.let(T.unsafe(nil), String)

# Checks the indentation of hanging closing parentheses in
# method calls, method definitions, and grouped expressions. A hanging
# closing parenthesis means `)` preceded by a line break.
#
# @example
#
#   # bad
#   some_method(
#   a,
#   b
#   )
#
#   some_method(
#   a, b
#   )
#
#   some_method(a, b, c
#   )
#
#   some_method(a,
#   b,
#   c
#   )
#
#   some_method(a,
#   x: 1,
#   y: 2
#   )
#
#   # Scenario 1: When First Parameter Is On Its Own Line
#
#   # good: when first param is on a new line, right paren is *always*
#   #       outdented by IndentationWidth
#   some_method(
#   a,
#   b
#   )
#
#   # good
#   some_method(
#   a, b
#   )
#
#   # Scenario 2: When First Parameter Is On The Same Line
#
#   # good: when all other params are also on the same line, outdent
#   #       right paren by IndentationWidth
#   some_method(a, b, c
#   )
#
#   # good: when all other params are on multiple lines, but are lined
#   #       up, align right paren with left paren
#   some_method(a,
#   b,
#   c
#   )
#
#   # good: when other params are not lined up on multiple lines, outdent
#   #       right paren by IndentationWidth
#   some_method(a,
#   x: 1,
#   y: 2
#   )
#
# source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#71
class RuboCop::Cop::Layout::ClosingParenthesisIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#84
  def on_begin(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#79
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#88
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#88
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#79
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#157
  def all_elements_aligned?(elements); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#95
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#99
  def check(node, elements); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#107
  def check_for_elements(node, elements); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#125
  def check_for_no_elements(node); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#171
  def correct_column_candidates(node, left_paren); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#144
  def expected_column(left_paren, elements); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#167
  def first_argument_line(elements); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#187
  def line_break_after_left_paren?(left_paren, elements); end

  # source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#179
  def message(correct_column, left_paren, right_paren); end
end

# source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#77
RuboCop::Cop::Layout::ClosingParenthesisIndentation::MSG_ALIGN = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/closing_parenthesis_indentation.rb#75
RuboCop::Cop::Layout::ClosingParenthesisIndentation::MSG_INDENT = T.let(T.unsafe(nil), String)

# Checks the indentation of comments.
#
# @example
#   # bad
#   # comment here
#   def method_name
#   end
#
#   # comment here
#   a = 'hello'
#
#   # yet another comment
#   if true
#   true
#   end
#
#   # good
#   # comment here
#   def method_name
#   end
#
#   # comment here
#   a = 'hello'
#
#   # yet another comment
#   if true
#   true
#   end
# @example AllowForAlignment: false (default)
#   # bad
#   a = 1 # A really long comment
#   # spanning two lines.
#
#   # good
#   # A really long comment spanning one line.
#   a = 1
# @example AllowForAlignment: true
#   # good
#   a = 1 # A really long comment
#   # spanning two lines.
#
# source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#48
class RuboCop::Cop::Layout::CommentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#55
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#61
  def autocorrect(corrector, comment); end

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#88
  def autocorrect_one(corrector, comment); end

  # Corrects all comment lines that occur immediately before the given
  # comment and have the same indentation. This is to avoid a long chain
  # of correcting, saving the file, parsing and inspecting again, and
  # then correcting one more line, and so on.
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#71
  def autocorrect_preceding_comments(corrector, comment); end

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#92
  def check(comment, comment_index); end

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#145
  def correct_indentation(next_line); end

  # Returns true if:
  # a) the cop is configured to allow extra indentation for alignment, and
  # b) the currently inspected comment is aligned with the nearest preceding end-of-line
  #    comment.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#121
  def correctly_aligned_with_preceding_comment?(comment_index, column); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#156
  def less_indented?(line); end

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#140
  def line_after_comment(comment); end

  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#131
  def message(column, correct_comment_indentation); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#135
  def own_line_comment?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#82
  def should_correct?(preceding_comment, reference_comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#162
  def two_alternatives?(line); end
end

# source://rubocop//lib/rubocop/cop/layout/comment_indentation.rb#52
RuboCop::Cop::Layout::CommentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for conditions that are not on the same line as
# if/while/until.
#
# @example
#
#   # bad
#   if
#   some_condition
#   do_something
#   end
#
#   # good
#   if some_condition
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/layout/condition_position.rb#21
class RuboCop::Cop::Layout::ConditionPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/condition_position.rb#27
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/layout/condition_position.rb#33
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/layout/condition_position.rb#33
  def on_while(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/condition_position.rb#40
  def check(node); end

  # source://rubocop//lib/rubocop/cop/layout/condition_position.rb#54
  def message(condition); end
end

# source://rubocop//lib/rubocop/cop/layout/condition_position.rb#25
RuboCop::Cop::Layout::ConditionPosition::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keywords of method definitions are
# aligned properly.
#
# Two modes are supported through the EnforcedStyleAlignWith configuration
# parameter. If it's set to `start_of_line` (which is the default), the
# `end` shall be aligned with the start of the line where the `def`
# keyword is. If it's set to `def`, the `end` shall be aligned with the
# `def` keyword.
#
# @example EnforcedStyleAlignWith: start_of_line (default)
#   # bad
#
#   private def foo
#   end
#
#   # good
#
#   private def foo
#   end
# @example EnforcedStyleAlignWith: def
#   # bad
#
#   private def foo
#   end
#
#   # good
#
#   private def foo
#   end
#
# source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#36
class RuboCop::Cop::Layout::DefEndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#43
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#43
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#48
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#63
  def autocorrect(corrector, node); end
end

# source://rubocop//lib/rubocop/cop/layout/def_end_alignment.rb#41
RuboCop::Cop::Layout::DefEndAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks the . position in multi-line method calls.
#
# @example EnforcedStyle: leading (default)
#   # bad
#   something.
#   method
#
#   # good
#   something
#   .method
# @example EnforcedStyle: trailing
#   # bad
#   something
#   .method
#
#   # good
#   something.
#   method
#
# source://rubocop//lib/rubocop/cop/layout/dot_position.rb#25
class RuboCop::Cop::Layout::DotPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#34
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#34
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#49
  def autocorrect(corrector, dot, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#99
  def correct_dot_position_style?(dot_line, selector_line); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#126
  def end_range(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#122
  def heredoc?(node); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#114
  def last_heredoc_line(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#95
  def line_between?(first_line, second_line); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#64
  def message(dot); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#74
  def proper_dot_position?(node); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#106
  def receiver_end_line(node); end

  # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#130
  def selector_range(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/dot_position.rb#30
    def autocorrect_incompatible_with; end
  end
end

# Checks the alignment of else keywords. Normally they should
# be aligned with an if/unless/while/until/begin/def/rescue keyword, but there
# are special cases when they should follow the same rules as the
# alignment of end.
#
# @example
#   # bad
#   if something
#   code
#   else
#   code
#   end
#
#   # bad
#   if something
#   code
#   elsif something
#   code
#   end
#
#   # good
#   if something
#   code
#   else
#   code
#   end
#
# source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#32
class RuboCop::Cop::Layout::ElseAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::CheckAssignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#57
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#63
  def on_case_match(node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#40
  def on_if(node, base = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#51
  def on_rescue(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#147
  def assignment_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#71
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#106
  def base_for_method_definition(node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#80
  def base_range_of_if(node, base); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#89
  def base_range_of_rescue(node); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#131
  def check_alignment(base_range, else_range); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#115
  def check_assignment(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#75
  def check_nested(node, base); end
end

# source://rubocop//lib/rubocop/cop/layout/else_alignment.rb#38
RuboCop::Cop::Layout::ElseAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks empty comment.
#
# @example
#   # bad
#
#   #
#   class Foo
#   end
#
#   # good
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
# @example AllowBorderComment: true (default)
#   # good
#
#   def foo
#   end
#
#   #################
#
#   def bar
#   end
# @example AllowBorderComment: false
#   # bad
#
#   def foo
#   end
#
#   #################
#
#   def bar
#   end
# @example AllowMarginComment: true (default)
#   # good
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
# @example AllowMarginComment: false
#   # bad
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#63
class RuboCop::Cop::Layout::EmptyComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#69
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#133
  def allow_border_comment?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#137
  def allow_margin_comment?; end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#97
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#129
  def comment_text(comment); end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#108
  def concat_consecutive_comments(comments); end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#141
  def current_token(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#119
  def empty_comment_only?(comment_text); end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#85
  def investigate(comments); end

  # source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#145
  def previous_token(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_comment.rb#67
RuboCop::Cop::Layout::EmptyComment::MSG = T.let(T.unsafe(nil), String)

# Enforces empty line after guard clause.
#
# This cop allows `# :nocov:` directive after guard clause because
# SimpleCov excludes code from the coverage report by wrapping it in `# :nocov:`:
#
# [source,ruby]
# ----
# def foo
#   # :nocov:
#   return if condition
#   # :nocov:
#   bar
# end
# ----
#
# Refer to SimpleCov's documentation for more details:
# https://github.com/simplecov-ruby/simplecov#ignoringskipping-code
#
# @example
#
#   # bad
#   def foo
#   return if need_return?
#   bar
#   end
#
#   # good
#   def foo
#   return if need_return?
#
#   bar
#   end
#
#   # good
#   def foo
#   return if something?
#   return if something_different?
#
#   bar
#   end
#
#   # also good
#   def foo
#   if something?
#   do_something
#   return if need_return?
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#54
class RuboCop::Cop::Layout::EmptyLineAfterGuardClause < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#63
  def on_if(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#84
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#106
  def contains_guard_clause?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#99
  def correct_style?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#181
  def heredoc?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#174
  def heredoc_line(node, heredoc_node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#148
  def last_heredoc_argument(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#162
  def last_heredoc_argument_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#199
  def multiple_statements_on_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#121
  def next_line_allowed_directive_comment?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#117
  def next_line_empty?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#110
  def next_line_empty_or_allowed_directive_comment?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#127
  def next_line_rescue_or_ensure?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#141
  def next_sibling_empty_or_guard_clause?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#132
  def next_sibling_parent_empty_or_else?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#191
  def offense_location(node); end

  # SimpleCov excludes code from the coverage report by wrapping it in `# :nocov:`:
  # https://github.com/simplecov-ruby/simplecov#ignoringskipping-code
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#208
  def simplecov_directive_comment?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#185
  def use_heredoc_in_condition?(condition); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#60
RuboCop::Cop::Layout::EmptyLineAfterGuardClause::END_OF_HEREDOC_LINE = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#59
RuboCop::Cop::Layout::EmptyLineAfterGuardClause::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/empty_line_after_guard_clause.rb#61
RuboCop::Cop::Layout::EmptyLineAfterGuardClause::SIMPLE_DIRECTIVE_COMMENT_PATTERN = T.let(T.unsafe(nil), Regexp)

# Checks for a newline after the final magic comment.
#
# @example
#   # good
#   # frozen_string_literal: true
#
#   # Some documentation for Person
#   class Person
#   # Some code
#   end
#
#   # bad
#   # frozen_string_literal: true
#   # Some documentation for Person
#   class Person
#   # Some code
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#23
class RuboCop::Cop::Layout::EmptyLineAfterMagicComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#29
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#61
  def comments_before_code(source); end

  # Find the last magic comment in the source file.
  #
  # Take all comments that precede the first line of code (or just take
  # them all in the case when there is no code), select the
  # magic comments, and return the last magic comment in the file.
  #
  # @return [Parser::Source::Comment] if magic comments exist before code
  # @return [nil] otherwise
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#55
  def last_magic_comment(source); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#43
  def offending_range(last_magic_comment); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_line_after_magic_comment.rb#27
RuboCop::Cop::Layout::EmptyLineAfterMagicComment::MSG = T.let(T.unsafe(nil), String)

# Enforces empty line after multiline condition.
#
# @example
#   # bad
#   if multiline &&
#   condition
#   do_something
#   end
#
#   # good
#   if multiline &&
#   condition
#
#   do_something
#   end
#
#   # bad
#   case x
#   when foo,
#   bar
#   do_something
#   end
#
#   # good
#   case x
#   when foo,
#   bar
#
#   do_something
#   end
#
#   # bad
#   begin
#   do_something
#   rescue FooError,
#   BarError
#   handle_error
#   end
#
#   # good
#   begin
#   do_something
#   rescue FooError,
#   BarError
#
#   handle_error
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#54
class RuboCop::Cop::Layout::EmptyLineAfterMultilineCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#82
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#60
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#93
  def on_rescue(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#70
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#75
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#70
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#75
  def on_while_post(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#127
  def autocorrect(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#105
  def check_condition(condition); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#120
  def multiline_rescue_exceptions?(exception_nodes); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#116
  def multiline_when_condition?(when_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#112
  def next_line_empty?(line); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_line_after_multiline_condition.rb#58
RuboCop::Cop::Layout::EmptyLineAfterMultilineCondition::MSG = T.let(T.unsafe(nil), String)

# Checks whether class/module/method definitions are
# separated by one or more empty lines.
#
# `NumberOfEmptyLines` can be an integer (default is 1) or
# an array (e.g. [1, 2]) to specify a minimum and maximum
# number of empty lines permitted.
#
# `AllowAdjacentOneLineDefs` configures whether adjacent
# one-line definitions are considered an offense.
#
# @example AllowAdjacentOneLineDefs: false
#
#   # bad
#   class ErrorA < BaseError; end
#   class ErrorB < BaseError; end
#   class ErrorC < BaseError; end
#
#   # good
#   class ErrorA < BaseError; end
#
#   class ErrorB < BaseError; end
#
#   class ErrorC < BaseError; end
# @example
#
#   # good
#   def a
#   end
#
#   def b
#   end
# @example EmptyLineBetweenClassDefs: true (default)
#   # checks for empty lines between class definitions.
#
#   # bad
#   class A
#   end
#   class B
#   end
#   def b
#   end
# @example
#
#   # good
#   class A
#   end
#
#   class B
#   end
#
#   def b
#   end
# @example EmptyLineBetweenModuleDefs: true (default)
#   # checks for empty lines between module definitions.
#
#   # bad
#   module A
#   end
#   module B
#   end
#   def b
#   end
# @example
#
#   # good
#   module A
#   end
#
#   module B
#   end
#
#   def b
#   end
# @example AllowAdjacentOneLineDefs: true (default)
#
#   # good
#   class ErrorA < BaseError; end
#   class ErrorB < BaseError; end
#   class ErrorC < BaseError; end
#
#   # good
#   class ErrorA < BaseError; end
#
#   class ErrorB < BaseError; end
#
#   class ErrorC < BaseError; end
# @example EmptyLineBetweenMethodDefs: true (default)
#   # checks for empty lines between method definitions.
#
#   # bad
#   def a
#   end
#   def b
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#108
class RuboCop::Cop::Layout::EmptyLineBetweenDefs < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#145
  def autocorrect(corrector, prev_def, node, count); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#130
  def check_defs(nodes); end

  # We operate on `begin` nodes, instead of using `OnMethodDef`,
  # so that we can walk over pairs of consecutive nodes and
  # efficiently access a node's predecessor; #prev_node ends up
  # doing a linear scan over siblings, so we don't want to call
  # it on each def.
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#123
  def on_begin(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#290
  def allowance_range?; end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#274
  def autocorrect_insert_lines(corrector, newline_pos, count); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#267
  def autocorrect_remove_lines(corrector, newline_pos, count); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#227
  def blank_lines_count_between(first_def_node, second_def_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#171
  def candidate?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#191
  def class_candidate?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#255
  def def_end(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#163
  def def_location(correction_node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#247
  def def_start(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#178
  def empty_line_between_macros; end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#259
  def end_loc(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#205
  def expected_lines; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#223
  def line_count_allowed?(count); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#239
  def lines_between_defs(first_def_node, second_def_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#182
  def macro_candidate?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#235
  def maximum_empty_lines; end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#199
  def message(node, count: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#187
  def method_candidate?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#231
  def minimum_empty_lines; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#195
  def module_candidate?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#214
  def multiple_blank_lines_groups?(first_def_node, second_def_node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#281
  def node_type(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#114
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/empty_line_between_defs.rb#112
RuboCop::Cop::Layout::EmptyLineBetweenDefs::MSG = T.let(T.unsafe(nil), String)

# Checks for two or more consecutive blank lines.
#
# @example
#
#   # bad - It has two empty lines.
#   some_method
#   # one empty line
#   # two empty lines
#   some_method
#
#   # good
#   some_method
#   # one empty line
#   some_method
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#21
class RuboCop::Cop::Layout::EmptyLines < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#28
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#45
  def each_extra_empty_line(lines); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#63
  def exceeds_line_offset?(line_diff); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#67
  def previous_and_current_lines_empty?(line); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#26
RuboCop::Cop::Layout::EmptyLines::LINE_OFFSET = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cop/layout/empty_lines.rb#25
RuboCop::Cop::Layout::EmptyLines::MSG = T.let(T.unsafe(nil), String)

# Access modifiers should be surrounded by blank lines.
#
# @example EnforcedStyle: around (default)
#
#   # bad
#   class Foo
#   def bar; end
#   private
#   def baz; end
#   end
#
#   # good
#   class Foo
#   def bar; end
#
#   private
#
#   def baz; end
#   end
# @example EnforcedStyle: only_before
#
#   # bad
#   class Foo
#   def bar; end
#   private
#   def baz; end
#   end
#
#   # good
#   class Foo
#   def bar; end
#
#   private
#   def baz; end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#43
class RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [EmptyLinesAroundAccessModifier] a new instance of EmptyLinesAroundAccessModifier
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#56
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#81
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#62
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#71
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#81
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#76
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#87
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#115
  def allowed_only_before_style?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#164
  def block_start?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#170
  def body_end?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#158
  def class_def?(line); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#124
  def correct_next_line_if_denied_style(corrector, node, line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#154
  def empty_lines_around?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#104
  def expected_empty_lines?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#180
  def message(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#189
  def message_for_around_style(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#199
  def message_for_only_before_style(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#176
  def next_empty_line_range(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#148
  def next_line_empty?(last_send_line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#141
  def previous_line_empty?(send_line); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#137
  def previous_line_ignoring_comments(processed_source, send_line); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#48
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_AFTER = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#52
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_AFTER_FOR_ONLY_BEFORE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#49
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_BEFORE_AND_AFTER = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#51
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_BEFORE_FOR_ONLY_BEFORE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_access_modifier.rb#54
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks if empty lines exist around the arguments
# of a method invocation.
#
# @example
#   # bad
#   do_something(
#   foo
#
#   )
#
#   process(bar,
#
#   baz: qux,
#   thud: fred)
#
#   some_method(
#
#   [1,2,3],
#   x: y
#   )
#
#   # good
#   do_something(
#   foo
#   )
#
#   process(bar,
#   baz: qux,
#   thud: fred)
#
#   some_method(
#   [1,2,3],
#   x: y
#   )
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#41
class RuboCop::Cop::Layout::EmptyLinesAroundArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#47
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#47
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#65
  def empty_lines(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#71
  def extra_lines(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#93
  def inner_lines(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#84
  def line_numbers(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#97
  def outer_lines(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#78
  def processed_lines(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#61
  def receiver_and_method_call_on_different_lines?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_arguments.rb#45
RuboCop::Cop::Layout::EmptyLinesAroundArguments::MSG = T.let(T.unsafe(nil), String)

# Checks for a newline after an attribute accessor or a group of them.
# `alias` syntax and `alias_method`, `public`, `protected`, and `private` methods are allowed
# by default. These are customizable with `AllowAliasSyntax` and `AllowedMethods` options.
#
# @example
#   # bad
#   attr_accessor :foo
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#   attr_reader :bar
#   attr_writer :baz
#   attr :qux
#
#   def do_something
#   end
# @example AllowAliasSyntax: true (default)
#   # good
#   attr_accessor :foo
#   alias :foo? :foo
#
#   def do_something
#   end
# @example AllowAliasSyntax: false
#   # bad
#   attr_accessor :foo
#   alias :foo? :foo
#
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#
#   alias :foo? :foo
#
#   def do_something
#   end
# @example AllowedMethods: ['private']
#   # good
#   attr_accessor :foo
#   private :foo
#
#   def do_something
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#63
class RuboCop::Cop::Layout::EmptyLinesAroundAttributeAccessor < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#70
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#123
  def allow_alias?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#133
  def allow_alias_syntax?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#127
  def attribute_or_allowed_method?(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#83
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#107
  def next_line_empty?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#94
  def next_line_empty_or_enable_directive_comment?(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#101
  def next_line_enable_directive_comment?(line); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#117
  def next_line_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#111
  def require_empty_line?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_attribute_accessor.rb#68
RuboCop::Cop::Layout::EmptyLinesAroundAttributeAccessor::MSG = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of begin-end
# blocks.
#
# @example
#
#   # good
#
#   begin
#   # ...
#   end
#
#   # bad
#
#   begin
#
#   # ...
#
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_begin_body.rb#24
class RuboCop::Cop::Layout::EmptyLinesAroundBeginBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_begin_body.rb#30
  def on_kwbegin(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_begin_body.rb#36
  def style; end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_begin_body.rb#28
RuboCop::Cop::Layout::EmptyLinesAroundBeginBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of blocks match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   foo do |bar|
#   # ...
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   foo do |bar|
#
#   # ...
#
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_block_body.rb#24
class RuboCop::Cop::Layout::EmptyLinesAroundBlockBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_block_body.rb#30
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_block_body.rb#30
  def on_numblock(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_block_body.rb#28
RuboCop::Cop::Layout::EmptyLinesAroundBlockBody::KIND = T.let(T.unsafe(nil), String)

# Common functionality for checking if presence/absence of empty lines
# around some kind of body matches the configuration.
#
# source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#8
module RuboCop::Cop::Layout::EmptyLinesAroundBody
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#20
  def constant_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#23
  def empty_line_required?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#26
  def check(node, body, adjusted_first_line: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#81
  def check_beginning(style, first_line); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#67
  def check_both(style, first_line, last_line); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#108
  def check_deferred_empty_line(body); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#43
  def check_empty_lines_except_namespace(body, first_line, last_line); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#51
  def check_empty_lines_special(body, first_line, last_line); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#85
  def check_ending(style, last_line); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#98
  def check_line(style, line, msg); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#89
  def check_source(style, line_no, desc); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#159
  def deferred_message(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#132
  def first_child_requires_empty_line?(body); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#140
  def first_empty_line_required_child(body); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#155
  def message(type, desc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#122
  def namespace?(body, with_one_child: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#148
  def previous_line_ignoring_comments(send_line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#163
  def valid_body_style?(body); end
end

# source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#15
RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_DEFERRED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#13
RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_EXTRA = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/empty_lines_around_body.rb#14
RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_MISSING = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of classes match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   class Foo
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   class Foo
#
#   def bar
#   # ...
#   end
#
#   end
# @example EnforcedStyle: empty_lines_except_namespace
#   # good
#
#   class Foo
#   class Bar
#
#   # ...
#
#   end
#   end
# @example EnforcedStyle: empty_lines_special
#   # good
#   class Foo
#
#   def bar; end
#
#   end
# @example EnforcedStyle: beginning_only
#   # good
#
#   class Foo
#
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: ending_only
#   # good
#
#   class Foo
#   def bar
#   # ...
#   end
#
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_class_body.rb#67
class RuboCop::Cop::Layout::EmptyLinesAroundClassBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_class_body.rb#73
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_class_body.rb#79
  def on_sclass(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_class_body.rb#71
RuboCop::Cop::Layout::EmptyLinesAroundClassBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of `begin`
# sections. This cop doesn't check empty lines at `begin` body
# beginning/end and around method definition body.
# `Style/EmptyLinesAroundBeginBody` or `Style/EmptyLinesAroundMethodBody`
# can be used for this purpose.
#
# @example
#
#   # good
#
#   begin
#   do_something
#   rescue
#   do_something2
#   else
#   do_something3
#   ensure
#   do_something4
#   end
#
#   # good
#
#   def foo
#   do_something
#   rescue
#   do_something2
#   end
#
#   # bad
#
#   begin
#   do_something
#
#   rescue
#
#   do_something2
#
#   else
#
#   do_something3
#
#   ensure
#
#   do_something4
#   end
#
#   # bad
#
#   def foo
#   do_something
#
#   rescue
#
#   do_something2
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#61
class RuboCop::Cop::Layout::EmptyLinesAroundExceptionHandlingKeywords < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#67
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#67
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#67
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#74
  def on_kwbegin(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#67
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#81
  def check_body(body, line_of_def_or_kwbegin); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#108
  def keyword_locations(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#125
  def keyword_locations_in_ensure(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#121
  def keyword_locations_in_rescue(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#96
  def last_rescue_and_end_on_same_line(body); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#100
  def message(location, keyword); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#104
  def style; end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_exception_handling_keywords.rb#65
RuboCop::Cop::Layout::EmptyLinesAroundExceptionHandlingKeywords::MSG = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of methods.
#
# @example
#
#   # good
#
#   def foo
#   # ...
#   end
#
#   # bad
#
#   def bar
#
#   # ...
#
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_method_body.rb#23
class RuboCop::Cop::Layout::EmptyLinesAroundMethodBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_method_body.rb#29
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_method_body.rb#29
  def on_defs(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_method_body.rb#36
  def style; end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_method_body.rb#27
RuboCop::Cop::Layout::EmptyLinesAroundMethodBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of modules match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   module Foo
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   module Foo
#
#   def bar
#   # ...
#   end
#
#   end
# @example EnforcedStyle: empty_lines_except_namespace
#   # good
#
#   module Foo
#   module Bar
#
#   # ...
#
#   end
#   end
# @example EnforcedStyle: empty_lines_special
#   # good
#   module Foo
#
#   def bar; end
#
#   end
#
# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_module_body.rb#47
class RuboCop::Cop::Layout::EmptyLinesAroundModuleBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/empty_lines_around_module_body.rb#53
  def on_module(node); end
end

# source://rubocop//lib/rubocop/cop/layout/empty_lines_around_module_body.rb#51
RuboCop::Cop::Layout::EmptyLinesAroundModuleBody::KIND = T.let(T.unsafe(nil), String)

# Checks whether the end keywords are aligned properly.
#
# Three modes are supported through the `EnforcedStyleAlignWith`
# configuration parameter:
#
# If it's set to `keyword` (which is the default), the `end`
# shall be aligned with the start of the keyword (if, class, etc.).
#
# If it's set to `variable` the `end` shall be aligned with the
# left-hand-side of the variable assignment, if there is one.
#
# If it's set to `start_of_line`, the `end` shall be aligned with the
# start of the line where the matching keyword appears.
#
# This `Layout/EndAlignment` cop aligns with keywords (e.g. `if`, `while`, `case`)
# by default. On the other hand, `Layout/BeginEndAlignment` cop aligns with
# `EnforcedStyleAlignWith: start_of_line` by default due to `||= begin` tends
# to align with the start of the line. `Layout/DefEndAlignment` cop also aligns with
# `EnforcedStyleAlignWith: start_of_line` by default.
# These style can be configured by each cop.
#
# @example EnforcedStyleAlignWith: keyword (default)
#   # bad
#
#   variable = if true
#   end
#
#   # good
#
#   variable = if true
#   end
#
#   variable =
#   if true
#   end
# @example EnforcedStyleAlignWith: variable
#   # bad
#
#   variable = if true
#   end
#
#   # good
#
#   variable = if true
#   end
#
#   variable =
#   if true
#   end
# @example EnforcedStyleAlignWith: start_of_line
#   # bad
#
#   variable = if true
#   end
#
#   puts(if true
#   end)
#
#   # good
#
#   variable = if true
#   end
#
#   puts(if true
#   end)
#
#   variable =
#   if true
#   end
#
# source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#77
class RuboCop::Cop::Layout::EndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#111
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#111
  def on_case_match(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#83
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#99
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#95
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#87
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#107
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#103
  def on_while(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#167
  def alignment_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#184
  def alignment_node_for_variable_style(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#148
  def asgn_variable_align_with(outer_node, inner_node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#202
  def assignment_or_operator_method(node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#122
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#137
  def check_asgn_alignment(outer_node, inner_node); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#126
  def check_assignment(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/end_alignment.rb#158
  def check_other_alignment(node); end
end

# Checks for Windows-style line endings in the source code.
#
# @example EnforcedStyle: native (default)
#   # The `native` style means that CR+LF (Carriage Return + Line Feed) is
#   # enforced on Windows, and LF is enforced on other platforms.
#
#   # bad
#   puts 'Hello' # Return character is LF on Windows.
#   puts 'Hello' # Return character is CR+LF on other than Windows.
#
#   # good
#   puts 'Hello' # Return character is CR+LF on Windows.
#   puts 'Hello' # Return character is LF on other than Windows.
# @example EnforcedStyle: lf
#   # The `lf` style means that LF (Line Feed) is enforced on
#   # all platforms.
#
#   # bad
#   puts 'Hello' # Return character is CR+LF on all platforms.
#
#   # good
#   puts 'Hello' # Return character is LF on all platforms.
# @example EnforcedStyle: crlf
#   # The `crlf` style means that CR+LF (Carriage Return + Line Feed) is
#   # enforced on all platforms.
#
#   # bad
#   puts 'Hello' # Return character is LF on all platforms.
#
#   # good
#   puts 'Hello' # Return character is CR+LF on all platforms.
#
# source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#40
class RuboCop::Cop::Layout::EndOfLine < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#71
  def offense_message(line); end

  # source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#47
  def on_new_investigation; end

  # If there is no LF on the last line, we don't care if there's no CR.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#67
  def unimportant_missing_cr?(index, last_line, line); end

  private

  # source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#85
  def last_line(processed_source); end
end

# source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#44
RuboCop::Cop::Layout::EndOfLine::MSG_DETECTED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/end_of_line.rb#45
RuboCop::Cop::Layout::EndOfLine::MSG_MISSING = T.let(T.unsafe(nil), String)

# Checks for extra/unnecessary whitespace.
#
# @example
#
#   # good if AllowForAlignment is true
#   name      = "RuboCop"
#   # Some comment and an empty line
#
#   website  += "/rubocop/rubocop" unless cond
#   puts        "rubocop"          if     debug
#
#   # bad for any configuration
#   set_app("RuboCop")
#   website  = "https://github.com/rubocop/rubocop"
#
#   # good only if AllowBeforeTrailingComments is true
#   object.method(arg)  # this is a comment
#
#   # good even if AllowBeforeTrailingComments is false or not set
#   object.method(arg) # this is a comment
#
#   # good with either AllowBeforeTrailingComments or AllowForAlignment
#   object.method(arg)         # this is a comment
#   another_object.method(arg) # this is another comment
#   some_object.method(arg)    # this is some comment
#
# source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#31
class RuboCop::Cop::Layout::ExtraSpacing < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#39
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#170
  def align_column(asgn_token); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#147
  def align_equal_sign(corrector, token, align_to); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#137
  def align_equal_signs(range, corrector); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#52
  def aligned_locations(locs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#103
  def aligned_tok?(token); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#159
  def all_relevant_assignment_lines(line_number); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#179
  def allow_for_trailing_comments?; end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#72
  def check_assignment(token); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#81
  def check_other(token1, token2, ast); end

  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#62
  def check_tokens(ast, token1, token2); end

  # @yield [range_between(start_pos, end_pos)]
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#91
  def extra_space_range(token1, token2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#133
  def force_equal_sign_alignment?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#111
  def ignored_range?(ast, start_pos); end

  # Returns an array of ranges that should not be reported. It's the
  # extra spaces between the keys and values in a multiline hash,
  # since those are handled by the Layout/HashAlignment cop.
  #
  # source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#118
  def ignored_ranges(ast); end
end

# source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#37
RuboCop::Cop::Layout::ExtraSpacing::MSG_UNALIGNED_ASGN = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/extra_spacing.rb#36
RuboCop::Cop::Layout::ExtraSpacing::MSG_UNNECESSARY = T.let(T.unsafe(nil), String)

# Checks the indentation of the first argument in a method call.
# Arguments after the first one are checked by `Layout/ArgumentAlignment`,
# not by this cop.
#
# For indenting the first parameter of method _definitions_, check out
# `Layout/FirstParameterIndentation`.
#
# This cop will respect `Layout/ArgumentAlignment` and will not work when
# `EnforcedStyle: with_fixed_indentation` is specified for `Layout/ArgumentAlignment`.
#
# @example
#
#   # bad
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: special_for_inner_method_call_in_parentheses (default)
#   # Same as `special_for_inner_method_call` except that the special rule
#   # only applies if the outer method call encloses its arguments in
#   # parentheses.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: consistent
#   # The first argument should always be indented one step more than the
#   # preceding line.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: consistent_relative_to_receiver
#   # The first argument should always be indented one level relative to
#   # the parent that is receiving the argument
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_params
# @example EnforcedStyle: special_for_inner_method_call
#   # The first argument should normally be indented one step more than
#   # the preceding line, but if it's an argument for a method call that
#   # is itself an argument in a method call, then the inner argument
#   # should be indented relative to the inner method.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
#
# source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#147
class RuboCop::Cop::Layout::FirstArgumentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#222
  def eligible_method_call?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#155
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#155
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#155
  def on_super(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#281
  def argument_alignment_config; end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#174
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#178
  def bare_operator?(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#198
  def base_indentation(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#226
  def base_range(send_node, arg_node); end

  # Returns the column of the given range. For single line ranges, this
  # is simple. For ranges with line breaks, we look a the last code line.
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#238
  def column_of(range); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#259
  def comment_lines; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#277
  def enable_layout_first_method_argument_line_break?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#271
  def enforce_first_argument_with_fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#182
  def message(arg_node); end

  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#267
  def on_new_investigation; end

  # Takes the line number of a given code line and returns a string
  # containing the previous line that's not a comment line or a blank
  # line.
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#250
  def previous_code_line(line_number); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#170
  def should_check?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#206
  def special_inner_call_indentation?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/first_argument_indentation.rb#153
RuboCop::Cop::Layout::FirstArgumentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first element in an array literal
# where the opening bracket and the first element are on separate lines.
# The other elements' indentations are handled by `Layout/ArrayAlignment` cop.
#
# This cop will respect `Layout/ArrayAlignment` and will not work when
# `EnforcedStyle: with_fixed_indentation` is specified for `Layout/ArrayAlignment`.
#
# By default, array literals that are arguments in a method call with
# parentheses, and where the opening square bracket of the array is on the
# same line as the opening parenthesis of the method call, shall have
# their first element indented one step (two spaces) more than the
# position inside the opening parenthesis.
#
# Other array literals shall have their first element indented one step
# more than the start of the line where the opening square bracket is.
#
# This default style is called 'special_inside_parentheses'. Alternative
# styles are 'consistent' and 'align_brackets'. Here are examples:
#
# @example EnforcedStyle: special_inside_parentheses (default)
#   # The `special_inside_parentheses` style enforces that the first
#   # element in an array literal where the opening bracket and first
#   # element are on separate lines is indented one step (two spaces) more
#   # than the position inside the opening parenthesis.
#
#   # bad
#   array = [
#   :value
#   ]
#   and_in_a_method_call([
#   :no_difference
#   ])
#
#   # good
#   array = [
#   :value
#   ]
#   but_in_a_method_call([
#   :its_like_this
#   ])
# @example EnforcedStyle: consistent
#   # The `consistent` style enforces that the first element in an array
#   # literal where the opening bracket and the first element are on
#   # separate lines is indented the same as an array literal which is not
#   # defined inside a method call.
#
#   # bad
#   # consistent
#   array = [
#   :value
#   ]
#   but_in_a_method_call([
#   :its_like_this
#   ])
#
#   # good
#   array = [
#   :value
#   ]
#   and_in_a_method_call([
#   :no_difference
#   ])
# @example EnforcedStyle: align_brackets
#   # The `align_brackets` style enforces that the opening and closing
#   # brackets are indented to the same position.
#
#   # bad
#   # align_brackets
#   and_now_for_something = [
#   :completely_different
#   ]
#
#   # good
#   # align_brackets
#   and_now_for_something = [
#   :completely_different
#   ]
#
# source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#85
class RuboCop::Cop::Layout::FirstArrayElementIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#94
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#100
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#100
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#191
  def array_alignment_config; end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#111
  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  #
  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#149
  def base_description(indent_base_type); end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#115
  def brace_alignment_style; end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#119
  def check(array_node, left_parenthesis); end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#133
  def check_right_bracket(right_bracket, first_elem, left_bracket, left_parenthesis); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#185
  def enforce_first_argument_with_fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#162
  def message(base_description); end

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#170
  def message_for_right_bracket(indent_base_type); end
end

# source://rubocop//lib/rubocop/cop/layout/first_array_element_indentation.rb#91
RuboCop::Cop::Layout::FirstArrayElementIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first element in a
# multi-line array.
#
# @example
#
#   # bad
#   [ :a,
#   :b]
#
#   # good
#   [
#   :a,
#   :b]
#
#   # good
#   [:a, :b]
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   [ :a, {
#   :b => :c
#   }]
#
#   # good
#   [
#   :a, {
#   :b => :c
#   }]
# @example AllowMultilineFinalElement: true
#
#   # good
#   [:a, {
#   :b => :c
#   }]
#
# source://rubocop//lib/rubocop/cop/layout/first_array_element_line_break.rb#43
class RuboCop::Cop::Layout::FirstArrayElementLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_array_element_line_break.rb#49
  def on_array(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_array_element_line_break.rb#57
  def assignment_on_same_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_array_element_line_break.rb#62
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/first_array_element_line_break.rb#47
RuboCop::Cop::Layout::FirstArrayElementLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first key in a hash literal
# where the opening brace and the first key are on separate lines. The
# other keys' indentations are handled by the HashAlignment cop.
#
# By default, Hash literals that are arguments in a method call with
# parentheses, and where the opening curly brace of the hash is on the
# same line as the opening parenthesis of the method call, shall have
# their first key indented one step (two spaces) more than the position
# inside the opening parenthesis.
#
# Other hash literals shall have their first key indented one step more
# than the start of the line where the opening curly brace is.
#
# This default style is called 'special_inside_parentheses'. Alternative
# styles are 'consistent' and 'align_braces'. Here are examples:
#
# @example EnforcedStyle: special_inside_parentheses (default)
#   # The `special_inside_parentheses` style enforces that the first key
#   # in a hash literal where the opening brace and the first key are on
#   # separate lines is indented one step (two spaces) more than the
#   # position inside the opening parentheses.
#
#   # bad
#   hash = {
#   key: :value
#   }
#   and_in_a_method_call({
#   no: :difference
#   })
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
#
#   # good
#   special_inside_parentheses
#   hash = {
#   key: :value
#   }
#   but_in_a_method_call({
#   its_like: :this
#   })
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
# @example EnforcedStyle: consistent
#   # The `consistent` style enforces that the first key in a hash
#   # literal where the opening brace and the first key are on
#   # separate lines is indented the same as a hash literal which is not
#   # defined inside a method call.
#
#   # bad
#   hash = {
#   key: :value
#   }
#   but_in_a_method_call({
#   its_like: :this
#   })
#
#   # good
#   hash = {
#   key: :value
#   }
#   and_in_a_method_call({
#   no: :difference
#   })
# @example EnforcedStyle: align_braces
#   # The `align_brackets` style enforces that the opening and closing
#   # braces are indented to the same position.
#
#   # bad
#   and_now_for_something = {
#   completely: :different
#   }
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
#
#   # good
#   and_now_for_something = {
#   completely: :different
#   }
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
#
# source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#113
class RuboCop::Cop::Layout::FirstHashElementIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#126
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#122
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#126
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#233
  def argument_alignment_config; end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#137
  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  #
  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#191
  def base_description(indent_base_type); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#141
  def brace_alignment_style; end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#145
  def check(hash_node, left_parenthesis); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#184
  def check_based_on_longest_key(hash_node, left_brace, left_parenthesis); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#164
  def check_right_brace(right_brace, first_pair, left_brace, left_parenthesis); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#227
  def enforce_first_argument_with_fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#204
  def message(base_description); end

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#212
  def message_for_right_brace(indent_base_type); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#178
  def separator_style?(first_pair); end
end

# source://rubocop//lib/rubocop/cop/layout/first_hash_element_indentation.rb#119
RuboCop::Cop::Layout::FirstHashElementIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first element in a
# multi-line hash.
#
# @example
#
#   # bad
#   { a: 1,
#   b: 2}
#
#   # good
#   {
#   a: 1,
#   b: 2 }
#
#   # good
#   {
#   a: 1, b: {
#   c: 3
#   }}
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   { a: 1, b: {
#   c: 3
#   }}
# @example AllowMultilineFinalElement: true
#
#   # bad
#   { a: 1,
#   b: {
#   c: 3
#   }}
#
#   # good
#   { a: 1, b: {
#   c: 3
#   }}
#
# source://rubocop//lib/rubocop/cop/layout/first_hash_element_line_break.rb#46
class RuboCop::Cop::Layout::FirstHashElementLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_line_break.rb#52
  def on_hash(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_hash_element_line_break.rb#62
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/first_hash_element_line_break.rb#50
RuboCop::Cop::Layout::FirstHashElementLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first argument in a
# multi-line method call.
#
# @example
#
#   # bad
#   method(foo, bar,
#   baz)
#
#   # good
#   method(
#   foo, bar,
#   baz)
#
#   # ignored
#   method foo, bar,
#   baz
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   method(foo, bar, {
#   baz: "a",
#   qux: "b",
#   })
#
#   # good
#   method(
#   foo, bar, {
#   baz: "a",
#   qux: "b",
#   })
# @example AllowMultilineFinalElement: true
#
#   # bad
#   method(foo,
#   bar,
#   {
#   baz: "a",
#   qux: "b",
#   }
#   )
#
#   # good
#   method(foo, bar, {
#   baz: "a",
#   qux: "b",
#   })
#
#   # good
#   method(
#   foo,
#   bar,
#   {
#   baz: "a",
#   qux: "b",
#   }
#   )
#
# source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#66
class RuboCop::Cop::Layout::FirstMethodArgumentLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#72
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#72
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#72
  def on_super(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#91
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/first_method_argument_line_break.rb#70
RuboCop::Cop::Layout::FirstMethodArgumentLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first parameter in a
# multi-line method parameter definition.
#
# @example
#
#   # bad
#   def method(foo, bar,
#   baz)
#   do_something
#   end
#
#   # good
#   def method(
#   foo, bar,
#   baz)
#   do_something
#   end
#
#   # ignored
#   def method foo,
#   bar
#   do_something
#   end
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   def method(foo, bar, baz = {
#   :a => "b",
#   })
#   do_something
#   end
#
#   # good
#   def method(
#   foo, bar, baz = {
#   :a => "b",
#   })
#   do_something
#   end
# @example AllowMultilineFinalElement: true
#
#   # good
#   def method(foo, bar, baz = {
#   :a => "b",
#   })
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/layout/first_method_parameter_line_break.rb#56
class RuboCop::Cop::Layout::FirstMethodParameterLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_method_parameter_line_break.rb#62
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_method_parameter_line_break.rb#62
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/first_method_parameter_line_break.rb#69
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/first_method_parameter_line_break.rb#60
RuboCop::Cop::Layout::FirstMethodParameterLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first parameter in a method
# definition. Parameters after the first one are checked by
# Layout/ParameterAlignment, not by this cop.
#
# For indenting the first argument of method _calls_, check out
# Layout/FirstArgumentIndentation, which supports options related to
# nesting that are irrelevant for method _definitions_.
#
# @example
#
#   # bad
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
# @example EnforcedStyle: consistent (default)
#   # The first parameter should always be indented one step more than the
#   # preceding line.
#
#   # good
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
# @example EnforcedStyle: align_parentheses
#   # The first parameter should always be indented one step more than the
#   # opening parenthesis.
#
#   # good
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
#
# source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#44
class RuboCop::Cop::Layout::FirstParameterIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#53
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#53
  def on_defs(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#63
  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  #
  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#83
  def base_description(_); end

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#67
  def brace_alignment_style; end

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#71
  def check(def_node); end

  # source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#91
  def message(base_description); end
end

# source://rubocop//lib/rubocop/cop/layout/first_parameter_indentation.rb#50
RuboCop::Cop::Layout::FirstParameterIndentation::MSG = T.let(T.unsafe(nil), String)

# Check that the keys, separators, and values of a multi-line hash
# literal are aligned according to configuration. The configuration
# options are:
#
# * key (left align keys, one space before hash rockets and values)
# * separator (align hash rockets and colons, right align keys)
# * table (left align keys, hash rockets, and values)
#
# The treatment of hashes passed as the last argument to a method call
# can also be configured. The options are:
#
# * always_inspect
# * always_ignore
# * ignore_implicit (without curly braces)
#
# Alternatively you can specify multiple allowed styles. That's done by
# passing a list of styles to EnforcedStyles.
#
# @example EnforcedLastArgumentHashStyle: ignore_explicit
#   # Ignore only explicit hashes.
#
#   # bad
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
# @example EnforcedHashRocketStyle: separator
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#   {
#   :foo => bar,
#   :ba  => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba => baz
#   }
# @example EnforcedHashRocketStyle: table
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba  => baz
#   }
# @example EnforcedColonStyle: key (default)
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#   {
#   foo: bar,
#   ba:  baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba: baz
#   }
# @example EnforcedColonStyle: separator
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba: baz
#   }
# @example EnforcedColonStyle: table
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba:  baz
#   }
# @example EnforcedLastArgumentHashStyle: always_inspect (default)
#   # Inspect both implicit and explicit hashes.
#
#   # bad
#   do_something(foo: 1,
#   bar: 2)
#
#   # bad
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something(
#   foo: 1,
#   bar: 2
#   )
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something({
#   foo: 1,
#   bar: 2
#   })
# @example EnforcedLastArgumentHashStyle: always_ignore
#   # Ignore both implicit and explicit hashes.
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
# @example EnforcedLastArgumentHashStyle: ignore_implicit
#   # Ignore only implicit hashes.
#
#   # bad
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
# @example EnforcedHashRocketStyle: key (default)
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#   {
#   :foo => bar,
#   :ba  => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba => baz
#   }
#
# source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#178
class RuboCop::Cop::Layout::HashAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::HashAlignmentStyles
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # Returns the value of attribute column_deltas.
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#218
  def column_deltas; end

  # Sets the attribute column_deltas
  #
  # @param value the value to set the attribute column_deltas to.
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#218
  def column_deltas=(_arg0); end

  # Returns the value of attribute offenses_by.
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#218
  def offenses_by; end

  # Sets the attribute offenses_by
  #
  # @param value the value to set the attribute offenses_by to.
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#218
  def offenses_by=(_arg0); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#208
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#195
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#195
  def on_super(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#195
  def on_yield(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#265
  def add_offenses; end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#371
  def adjust(corrector, delta, range); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#300
  def alignment_for(pair); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#314
  def alignment_for_colons; end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#310
  def alignment_for_hash_rockets; end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#390
  def argument_alignment_config; end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#233
  def argument_before_hash(hash_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#222
  def autocorrect_incompatible_with_other_cops?(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#283
  def check_delta(delta, node:, alignment:); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#246
  def check_pairs(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#337
  def correct_key_value(corrector, delta, key, value, separator); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#333
  def correct_no_value(corrector, key_delta, key); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#318
  def correct_node(corrector, node, delta); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#242
  def double_splat?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#384
  def enforce_first_argument_with_fixed_indentation?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#380
  def good_alignment?(column_deltas); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#291
  def ignore_hash_argument?(node); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#353
  def new_alignment(key); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#273
  def register_offenses_with_format(offenses, format); end

  # source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#237
  def reset!; end
end

# source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#183
RuboCop::Cop::Layout::HashAlignment::MESSAGES = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/layout/hash_alignment.rb#193
RuboCop::Cop::Layout::HashAlignment::SEPARATOR_ALIGNMENT_STYLES = T.let(T.unsafe(nil), Array)

# Checks for the placement of the closing parenthesis
# in a method call that passes a HEREDOC string as an argument.
# It should be placed at the end of the line containing the
# opening HEREDOC tag.
#
# @example
#   # bad
#
#   foo(<<-SQL
#   bar
#   SQL
#   )
#
#   foo(<<-SQL, 123, <<-NOSQL,
#   bar
#   SQL
#   baz
#   NOSQL
#   )
#
#   foo(
#   bar(<<-SQL
#   baz
#   SQL
#   ),
#   123,
#   )
#
#   # good
#
#   foo(<<-SQL)
#   bar
#   SQL
#
#   foo(<<-SQL, 123, <<-NOSQL)
#   bar
#   SQL
#   baz
#   NOSQL
#
#   foo(
#   bar(<<-SQL),
#   baz
#   SQL
#   123,
#   )
#
# source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#53
class RuboCop::Cop::Layout::HeredocArgumentClosingParenthesis < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#64
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#184
  def add_correct_closing_paren(node, corrector); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#271
  def add_correct_external_trailing_comma(node, corrector); end

  # Autocorrection note:
  #
  # Commas are a bit tricky to handle when the method call is
  # embedded in another expression. Here's an example:
  #
  # [
  #   first_array_value,
  #   foo(<<-SQL, 123, 456,
  #     SELECT * FROM db
  #   SQL
  #   ),
  #   third_array_value,
  # ]
  #
  # The "internal" trailing comma is after `456`.
  # The "external" trailing comma is after `)`.
  #
  # To autocorrect, we remove the latter, and move the former up:
  #
  # [
  #   first_array_value,
  #   foo(<<-SQL, 123, 456),
  #     SELECT * FROM db
  #   SQL
  #   third_array_value,
  # ]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#107
  def autocorrect(corrector, node); end

  # Closing parenthesis helpers.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#162
  def end_keyword_before_closing_parenthesis?(parenthesized_send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#222
  def exist_argument_between_heredoc_end_and_closing_parentheses?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#289
  def external_trailing_comma?(node); end

  # Returns nil if no trailing external comma.
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#294
  def external_trailing_comma_offset_from_loc_end(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#137
  def extract_heredoc(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#133
  def extract_heredoc_argument(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#230
  def find_most_bottom_of_heredoc_end(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#179
  def fix_closing_parenthesis(node, corrector); end

  # External trailing comma helpers.
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#266
  def fix_external_trailing_comma(node, corrector); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#149
  def heredoc_node?(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#197
  def incorrect_parenthesis_removal_begin(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#213
  def incorrect_parenthesis_removal_end(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#244
  def internal_trailing_comma?(node); end

  # Returns nil if no trailing internal comma.
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#249
  def internal_trailing_comma_offset_from_last_arg(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#115
  def outermost_send_on_same_line(heredoc); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#188
  def remove_incorrect_closing_paren(node, corrector); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#277
  def remove_incorrect_external_trailing_comma(node, corrector); end

  # Internal trailing comma helpers.
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#238
  def remove_internal_trailing_comma(node, corrector); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#207
  def safe_to_remove_line_containing_closing_paren?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#126
  def send_missing_closing_parens?(parent, child, heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#153
  def single_line_send_with_heredoc_receiver?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#305
  def space?(pos); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#168
  def subsequent_closing_parentheses_in_same_line?(outermost_send); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#60
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/heredoc_argument_closing_parenthesis.rb#57
RuboCop::Cop::Layout::HeredocArgumentClosingParenthesis::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the here document bodies. The bodies
# are indented one step.
#
# NOTE: When ``Layout/LineLength``'s `AllowHeredoc` is false (not default),
#       this cop does not add any offenses for long here documents to
#       avoid ``Layout/LineLength``'s offenses.
#
# @example
#   # bad
#   <<-RUBY
#   something
#   RUBY
#
#   # good
#   <<~RUBY
#   something
#   RUBY
#
# source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#24
class RuboCop::Cop::Layout::HeredocIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#36
  def on_heredoc(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#120
  def adjust_minus(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#115
  def adjust_squiggly(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#144
  def base_indent_level(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#155
  def heredoc_body(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#159
  def heredoc_end(node); end

  # Returns '~', '-' or nil
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#151
  def heredoc_indent_type(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#126
  def indented_body(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#133
  def indented_end(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#91
  def line_too_long?(node); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#103
  def longest_line(lines); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#111
  def max_line_length; end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#69
  def message(heredoc_indent_type); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#57
  def register_offense(node, heredoc_indent_type); end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#79
  def type_message(indentation_width, current_indent_type); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#107
  def unlimited_heredoc_length?; end

  # source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#87
  def width_message(indentation_width); end
end

# source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#32
RuboCop::Cop::Layout::HeredocIndentation::TYPE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/heredoc_indentation.rb#34
RuboCop::Cop::Layout::HeredocIndentation::WIDTH_MSG = T.let(T.unsafe(nil), String)

# Checks for inconsistent indentation.
#
# The difference between `indented_internal_methods` and `normal` is
# that the `indented_internal_methods` style prescribes that in
# classes and modules the `protected` and `private` modifier keywords
# shall be indented the same as public methods and that protected and
# private members shall be indented one step more than the modifiers.
# Other than that, both styles mean that entities on the same logical
# depth shall have the same indentation.
#
# @example EnforcedStyle: normal (default)
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
# @example EnforcedStyle: indented_internal_methods
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#121
class RuboCop::Cop::Layout::IndentationConsistency < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#128
  def on_begin(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#132
  def on_kwbegin(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#138
  def autocorrect(corrector, node); end

  # Not all nodes define `bare_access_modifier?` (for example,
  # `RuboCop::AST::DefNode` does not), so we must check `send_type?` first
  # to avoid a NoMethodError.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#145
  def bare_access_modifier?(node); end

  # Returns an integer representing the correct indentation, or nil to
  # indicate that the correct indentation is that of the first child that
  # is not an access modifier.
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#152
  def base_column_for_normal_style(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#172
  def check(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#187
  def check_indented_internal_methods_style(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#180
  def check_normal_style(node); end
end

# source://rubocop//lib/rubocop/cop/layout/indentation_consistency.rb#126
RuboCop::Cop::Layout::IndentationConsistency::MSG = T.let(T.unsafe(nil), String)

# Checks that the indentation method is consistent.
# Either tabs only or spaces only are used for indentation.
#
# @example EnforcedStyle: spaces (default)
#   # bad
#   # This example uses a tab to indent bar.
#   def foo
#   bar
#   end
#
#   # good
#   # This example uses spaces to indent bar.
#   def foo
#   bar
#   end
# @example EnforcedStyle: tabs
#   # bad
#   # This example uses spaces to indent bar.
#   def foo
#   bar
#   end
#
#   # good
#   # This example uses a tab to indent bar.
#   def foo
#   bar
#   end
#
# source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#34
class RuboCop::Cop::Layout::IndentationStyle < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#42
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#58
  def autocorrect(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#82
  def autocorrect_lambda_for_spaces(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#77
  def autocorrect_lambda_for_tabs(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#66
  def find_offense(line, lineno); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#88
  def in_string_literal?(ranges, tabs_range); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#109
  def message(_node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#92
  def string_literal_ranges(ast); end
end

# source://rubocop//lib/rubocop/cop/layout/indentation_style.rb#40
RuboCop::Cop::Layout::IndentationStyle::MSG = T.let(T.unsafe(nil), String)

# Checks for indentation that doesn't use the specified number
# of spaces.
#
# See also the IndentationConsistency cop which is the companion to this
# one.
#
# @example
#   # bad
#   class A
#   def test
#   puts 'hello'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   end
#   end
# @example AllowedPatterns: ['^\s*module']
#   # bad
#   module A
#   class B
#   def test
#   puts 'hello'
#   end
#   end
#   end
#
#   # good
#   module A
#   class B
#   def test
#   puts 'hello'
#   end
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#45
class RuboCop::Cop::Layout::IndentationWidth < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#57
  def access_modifier?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#81
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#138
  def on_case(case_node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#146
  def on_case_match(case_match); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#95
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#104
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#121
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#121
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#66
  def on_ensure(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#66
  def on_for(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#156
  def on_if(node, base = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#73
  def on_kwbegin(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#95
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#81
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#66
  def on_resbody(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#61
  def on_rescue(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#95
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#104
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#128
  def on_until(node, base = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#128
  def on_while(node, base = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#227
  def access_modifier_indentation_style; end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#165
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#235
  def check_assignment(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#255
  def check_if(node, body, else_clause, base_loc); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#268
  def check_indentation(base_loc, body_node, style = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#169
  def check_members(base, members); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#193
  def check_members_for_indented_internal_methods_style(members); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#199
  def check_members_for_normal_style(base, members); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#341
  def check_rescue?(rescue_node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#377
  def configured_indentation_width; end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#207
  def each_member(members); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#231
  def indentation_consistency_style; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#323
  def indentation_to_check?(base_loc, body_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#219
  def indented_internal_methods_style?; end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#381
  def leftmost_modifier_of(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#302
  def message(configured_indentation_width, indentation, name); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#360
  def offending_range(body_node, indentation); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#278
  def offense(body_node, indentation, style); end

  # Returns true if the given node is within another node that has
  # already been marked for autocorrection by this cop.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#313
  def other_offense_in_same_range?(node); end

  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#181
  def select_check_member(member); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#345
  def skip_check?(base_loc, body_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#223
  def special_modifier?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#368
  def starts_with_access_modifier?(body_node); end
end

# source://rubocop//lib/rubocop/cop/layout/indentation_width.rb#53
RuboCop::Cop::Layout::IndentationWidth::MSG = T.let(T.unsafe(nil), String)

# Checks for indentation of the first non-blank non-comment
# line in a file.
#
# @example
#   # bad
#   class A
#   def foo; end
#   end
#
#   # good
#   class A
#   def foo; end
#   end
#
# source://rubocop//lib/rubocop/cop/layout/initial_indentation.rb#20
class RuboCop::Cop::Layout::InitialIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/initial_indentation.rb#26
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/initial_indentation.rb#36
  def first_token; end

  # @yield [range_between(space_range.begin_pos, token.begin_pos)]
  #
  # source://rubocop//lib/rubocop/cop/layout/initial_indentation.rb#40
  def space_before(token); end
end

# source://rubocop//lib/rubocop/cop/layout/initial_indentation.rb#24
RuboCop::Cop::Layout::InitialIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks whether comments have a leading space after the
# `#` denoting the start of the comment. The leading space is not
# required for some RDoc special syntax, like `#++`, `#--`,
# `#:nodoc`, `=begin`- and `=end` comments, "shebang" directives,
# or rackup options.
#
# @example
#
#   # bad
#   #Some comment
#
#   # good
#   # Some comment
# @example AllowDoxygenCommentStyle: false (default)
#
#   # bad
#
#   #**
#   # Some comment
#   # Another line of comment
#   #*
# @example AllowDoxygenCommentStyle: true
#
#   # good
#
#   #**
#   # Some comment
#   # Another line of comment
#   #*
# @example AllowGemfileRubyComment: false (default)
#
#   # bad
#
#   #ruby=2.7.0
#   #ruby-gemset=myproject
# @example AllowGemfileRubyComment: true
#
#   # good
#
#   #ruby=2.7.0
#   #ruby-gemset=myproject
#
# source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#52
class RuboCop::Cop::Layout::LeadingCommentSpace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#58
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#95
  def allow_doxygen_comment?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#103
  def allow_gemfile_ruby_comment?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#79
  def allowed_on_first_line?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#99
  def doxygen_comment_style?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#107
  def gemfile?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#115
  def gemfile_ruby_comment?(comment); end

  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#75
  def hash_mark(expr); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#91
  def rackup_config_file?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#87
  def rackup_options?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#111
  def ruby_comment_in_gemfile?(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#83
  def shebang?(comment); end
end

# source://rubocop//lib/rubocop/cop/layout/leading_comment_space.rb#56
RuboCop::Cop::Layout::LeadingCommentSpace::MSG = T.let(T.unsafe(nil), String)

# Checks for unnecessary leading blank lines at the beginning
# of a file.
#
# @example
#
#   # bad
#   # (start of file)
#
#   class Foo
#   end
#
#   # bad
#   # (start of file)
#
#   # a comment
#
#   # good
#   # (start of file)
#   class Foo
#   end
#
#   # good
#   # (start of file)
#   # a comment
#
# source://rubocop//lib/rubocop/cop/layout/leading_empty_lines.rb#30
class RuboCop::Cop::Layout::LeadingEmptyLines < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/leading_empty_lines.rb#35
  def on_new_investigation; end
end

# source://rubocop//lib/rubocop/cop/layout/leading_empty_lines.rb#33
RuboCop::Cop::Layout::LeadingEmptyLines::MSG = T.let(T.unsafe(nil), String)

# Checks that strings broken over multiple lines (by a backslash) contain
# trailing spaces instead of leading spaces (default) or leading spaces
# instead of trailing spaces.
#
# @example EnforcedStyle: trailing (default)
#   # bad
#   'this text contains a lot of' \
#   '               spaces'
#
#   # good
#   'this text contains a lot of               ' \
#   'spaces'
#
#   # bad
#   'this text is too' \
#   ' long'
#
#   # good
#   'this text is too ' \
#   'long'
# @example EnforcedStyle: leading
#   # bad
#   'this text contains a lot of               ' \
#   'spaces'
#
#   # good
#   'this text contains a lot of' \
#   '               spaces'
#
#   # bad
#   'this text is too ' \
#   'long'
#
#   # good
#   'this text is too' \
#   ' long'
#
# source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#43
class RuboCop::Cop::Layout::LineContinuationLeadingSpace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#54
  def on_dstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#113
  def autocorrect(corrector, offense_range, insert_pos, spaces); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#106
  def continuation?(line, line_num, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#138
  def enforced_style_leading?; end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#76
  def investigate(first_line, second_line, end_of_first_line); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#84
  def investigate_leading_style(first_line, second_line, end_of_first_line); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#95
  def investigate_trailing_style(first_line, second_line, end_of_first_line); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#118
  def leading_offense_range(end_of_first_line, matches); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#130
  def message(_range); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#72
  def raw_lines(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#124
  def trailing_offense_range(end_of_first_line, matches); end
end

# source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#49
RuboCop::Cop::Layout::LineContinuationLeadingSpace::LEADING_STYLE_OFFENSE = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#47
RuboCop::Cop::Layout::LineContinuationLeadingSpace::LINE_1_ENDING = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#48
RuboCop::Cop::Layout::LineContinuationLeadingSpace::LINE_2_BEGINNING = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/layout/line_continuation_leading_space.rb#50
RuboCop::Cop::Layout::LineContinuationLeadingSpace::TRAILING_STYLE_OFFENSE = T.let(T.unsafe(nil), Regexp)

# Checks that the backslash of a line continuation is separated from
# preceding text by exactly one space (default) or zero spaces.
#
# @example EnforcedStyle: space (default)
#   # bad
#   'a'\
#   'b'  \
#   'c'
#
#   # good
#   'a' \
#   'b' \
#   'c'
# @example EnforcedStyle: no_space
#   # bad
#   'a' \
#   'b'  \
#   'c'
#
#   # good
#   'a'\
#   'b'\
#   'c'
#
# source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#30
class RuboCop::Cop::Layout::LineContinuationSpacing < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#34
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#81
  def autocorrect(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#111
  def comment_ranges(comments); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#65
  def find_offensive_spacing(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#121
  def ignore_range?(backtick_range); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#91
  def ignored_literal_ranges(ast); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#125
  def ignored_ranges; end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#49
  def investigate(line, line_number); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#115
  def last_line(processed_source); end

  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#73
  def message(_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#130
  def no_space_style?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_continuation_spacing.rb#134
  def space_style?; end
end

# Checks the indentation of the next line after a line that ends with a string
# literal and a backslash.
#
# If `EnforcedStyle: aligned` is set, the concatenated string parts shall be aligned with the
# first part. There are some exceptions, such as implicit return values, where the
# concatenated string parts shall be indented regardless of `EnforcedStyle` configuration.
#
# If `EnforcedStyle: indented` is set, it's the second line that shall be indented one step
# more than the first line. Lines 3 and forward shall be aligned with line 2.
#
# @example
#   # bad
#   def some_method
#   'x' \
#   'y' \
#   'z'
#   end
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   def some_method
#   'x' \
#   'y' \
#   'z'
#   end
# @example EnforcedStyle: aligned (default)
#   # bad
#   puts 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   puts 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
# @example EnforcedStyle: indented
#   # bad
#   result = 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   result = 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
# source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#74
class RuboCop::Cop::Layout::LineEndStringConcatenationIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#97
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#83
  def on_dstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#137
  def add_offense_and_correction(node, message); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#109
  def always_indented?(dstr_node); end

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#128
  def base_column(child); end

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#113
  def check_aligned(children, start_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#122
  def check_indented(children); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#103
  def strings_concatenated_with_backslash?(dstr_node); end
end

# source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#79
RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::MSG_ALIGN = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#80
RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::MSG_INDENT = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/line_end_string_concatenation_indentation.rb#81
RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::PARENT_TYPES_FOR_INDENTED = T.let(T.unsafe(nil), Array)

# Checks the length of lines in the source code.
# The maximum length is configurable.
# The tab size is configured in the `IndentationWidth`
# of the `Layout/IndentationStyle` cop.
# It also ignores a shebang line by default.
#
# This cop has some autocorrection capabilities.
# It can programmatically shorten certain long lines by
# inserting line breaks into expressions that can be safely
# split across lines. These include arrays, hashes, and
# method calls with argument lists.
#
# If autocorrection is enabled, the following cops
# are recommended to further format the broken lines.
# (Many of these are enabled by default.)
#
# * `Layout/ArgumentAlignment`
# * `Layout/ArrayAlignment`
# * `Layout/BlockAlignment`
# * `Layout/BlockEndNewline`
# * `LayoutClosingParenthesisIndentation`
# * `LayoutFirstArgumentIndentation`
# * `LayoutFirstArrayElementIndentation`
# * `LayoutFirstHashElementIndentation`
# * `LayoutFirstParameterIndentation`
# * `LayoutHashAlignment`
# * `LayoutIndentationWidth`
# * `LayoutMultilineArrayLineBreaks`
# * `LayoutMultilineBlockLayout`
# * `LayoutMultilineHashBraceLayout`
# * `LayoutMultilineHashKeyLineBreaks`
# * `LayoutMultilineMethodArgumentLineBreaks`
# * `LayoutMultilineMethodParameterLineBreaks`
# * `Layout/ParameterAlignment`
# * `Style/BlockDelimiters`
#
# Together, these cops will pretty print hashes, arrays,
# method calls, etc. For example, let's say the max columns
# is 25:
#
# @example
#
#   # bad
#   {foo: "0000000000", bar: "0000000000", baz: "0000000000"}
#
#   # good
#   {foo: "0000000000",
#   bar: "0000000000", baz: "0000000000"}
#
#   # good (with recommended cops enabled)
#   {
#   foo: "0000000000",
#   bar: "0000000000",
#   baz: "0000000000",
#   }
#
# source://rubocop//lib/rubocop/cop/layout/line_length.rb#63
class RuboCop::Cop::Layout::LineLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckLineBreakable
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::LineLengthHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#80
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#74
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#80
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#80
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#94
  def on_investigation_end; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#88
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#74
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#80
  def on_potential_breakable_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#80
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#219
  def allow_heredoc?; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#223
  def allowed_heredoc; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#183
  def allowed_line?(line, line_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#135
  def breakable_block_range(block_node); end

  # Returns the value of attribute breakable_range.
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#102
  def breakable_range; end

  # Sets the attribute breakable_range
  #
  # @param value the value to set the attribute breakable_range to.
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#102
  def breakable_range=(_arg0); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#143
  def breakable_range_after_semicolon(semicolon_token); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#156
  def breakable_range_by_line_index; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#250
  def check_directive_line(line, line_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#125
  def check_for_breakable_block(block_node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#104
  def check_for_breakable_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#117
  def check_for_breakable_semicolons(processed_source); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#171
  def check_line(line, line_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#267
  def check_uri_line(line, line_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#204
  def excess_range(uri_range, line, line_index); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#227
  def extract_heredocs(ast); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#160
  def heredocs; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#164
  def highlight_start(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#246
  def line_in_heredoc?(line_number); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#237
  def line_in_permitted_heredoc?(line_number); end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#215
  def max; end

  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#193
  def register_offense(loc, line, line_index, length: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/line_length.rb#189
  def shebang?(line, line_index); end
end

# source://rubocop//lib/rubocop/cop/layout/line_length.rb#72
RuboCop::Cop::Layout::LineLength::MSG = T.let(T.unsafe(nil), String)

# Checks that the closing brace in an array literal is either
# on the same line as the last array element or on a new line.
#
# When using the `symmetrical` (default) style:
#
# If an array's opening brace is on the same line as the first element
# of the array, then the closing brace should be on the same line as
# the last element of the array.
#
# If an array's opening brace is on the line above the first element
# of the array, then the closing brace should be on the line below
# the last element of the array.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line array literal must be on the line
# after the last element of the array.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line array literal must be on the same
# line as the last element of the array.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   [ :a,
#   :b
#   ]
#
#   # bad
#   [
#   :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b ]
#
#   # good
#   [
#   :a,
#   :b
#   ]
# @example EnforcedStyle: new_line
#   # bad
#   [
#   :a,
#   :b ]
#
#   # bad
#   [ :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b
#   ]
#
#   # good
#   [
#   :a,
#   :b
#   ]
# @example EnforcedStyle: same_line
#   # bad
#   [ :a,
#   :b
#   ]
#
#   # bad
#   [
#   :a,
#   :b
#   ]
#
#   # good
#   [
#   :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b ]
#
# source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#91
class RuboCop::Cop::Layout::MultilineArrayBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#109
  def on_array(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#103
RuboCop::Cop::Layout::MultilineArrayBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#106
RuboCop::Cop::Layout::MultilineArrayBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#99
RuboCop::Cop::Layout::MultilineArrayBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_array_brace_layout.rb#95
RuboCop::Cop::Layout::MultilineArrayBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each item in a multi-line array
# starts on a separate line.
#
# @example
#
#   # bad
#   [
#   a, b,
#   c
#   ]
#
#   # good
#   [
#   a,
#   b,
#   c
#   ]
#
#   # good
#   [
#   a,
#   b,
#   foo(
#   bar
#   )
#   ]
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   [a, b, foo(
#   bar
#   )]
# @example AllowMultilineFinalElement: true
#
#   # good
#   [a, b, foo(
#   bar
#   )]
#
# source://rubocop//lib/rubocop/cop/layout/multiline_array_line_breaks.rb#47
class RuboCop::Cop::Layout::MultilineArrayLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_array_line_breaks.rb#53
  def on_array(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_array_line_breaks.rb#59
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_array_line_breaks.rb#51
RuboCop::Cop::Layout::MultilineArrayLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks whether the multiline assignments have a newline
# after the assignment operator.
#
# @example EnforcedStyle: new_line (default)
#   # bad
#   foo = if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   begin
#   compute
#   rescue => e
#   nil
#   end
# @example EnforcedStyle: same_line
#   # good
#   foo = if expression
#   'bar'
#   end
# @example SupportedTypes: ['block', 'case', 'class', 'if', 'kwbegin', 'module'] (default)
#   # good
#   foo =
#   if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   [1].map do |i|
#   i + 1
#   end
# @example SupportedTypes: ['block']
#   # good
#   foo = if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   [1].map do |i|
#   'bar' * i
#   end
#
# source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#60
class RuboCop::Cop::Layout::MultilineAssignmentLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#72
  def check_assignment(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#81
  def check_by_enforced_style(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#90
  def check_new_line_offense(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#98
  def check_same_line_offense(node, rhs); end

  private

  # source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#111
  def supported_types; end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#66
RuboCop::Cop::Layout::MultilineAssignmentLayout::NEW_LINE_OFFENSE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_assignment_layout.rb#69
RuboCop::Cop::Layout::MultilineAssignmentLayout::SAME_LINE_OFFENSE = T.let(T.unsafe(nil), String)

# Checks whether the multiline do end blocks have a newline
# after the start of the block. Additionally, it checks whether the block
# arguments, if any, are on the same line as the start of the
# block. Putting block arguments on separate lines, because the whole
# line would otherwise be too long, is accepted.
#
# @example
#   # bad
#   blah do |i| foo(i)
#   bar(i)
#   end
#
#   # bad
#   blah do
#   |i| foo(i)
#   bar(i)
#   end
#
#   # good
#   blah do |i|
#   foo(i)
#   bar(i)
#   end
#
#   # bad
#   blah { |i| foo(i)
#   bar(i)
#   }
#
#   # good
#   blah { |i|
#   foo(i)
#   bar(i)
#   }
#
#   # good
#   blah { |
#   long_list,
#   of_parameters,
#   that_would_not,
#   fit_on_one_line
#   |
#   foo(i)
#   bar(i)
#   }
#
# source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#51
class RuboCop::Cop::Layout::MultilineBlockLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#59
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#59
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#98
  def add_offense_for_expression(node, expr, msg); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#75
  def args_on_beginning_line?(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#105
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#120
  def autocorrect_arguments(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#130
  def autocorrect_body(corrector, node, block_body); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#142
  def block_arg_string(node, args); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#90
  def characters_needed_for_space_and_pipes(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#154
  def include_trailing_comma?(args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#79
  def line_break_necessary_in_args?(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#83
  def needed_length_for_args(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#56
RuboCop::Cop::Layout::MultilineBlockLayout::ARG_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#55
RuboCop::Cop::Layout::MultilineBlockLayout::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_block_layout.rb#57
RuboCop::Cop::Layout::MultilineBlockLayout::PIPE_SIZE = T.let(T.unsafe(nil), Integer)

# Checks that the closing brace in a hash literal is either
# on the same line as the last hash element, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a hash's opening brace is on the same line as the first element
# of the hash, then the closing brace should be on the same line as
# the last element of the hash.
#
# If a hash's opening brace is on the line above the first element
# of the hash, then the closing brace should be on the line below
# the last element of the hash.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line hash literal must be on the line
# after the last element of the hash.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line hash literal must be on the same
# line as the last element of the hash.
#
# @example EnforcedStyle: symmetrical (default)
#
#   # bad
#   { a: 1,
#   b: 2
#   }
#   # bad
#   {
#   a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2 }
#
#   # good
#   {
#   a: 1,
#   b: 2
#   }
# @example EnforcedStyle: new_line
#   # bad
#   {
#   a: 1,
#   b: 2 }
#
#   # bad
#   { a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2
#   }
# @example EnforcedStyle: same_line
#   # bad
#   { a: 1,
#   b: 2
#   }
#
#   # bad
#   {
#   a: 1,
#   b: 2
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2 }
#
# source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#91
class RuboCop::Cop::Layout::MultilineHashBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#109
  def on_hash(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#103
RuboCop::Cop::Layout::MultilineHashBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#106
RuboCop::Cop::Layout::MultilineHashBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#99
RuboCop::Cop::Layout::MultilineHashBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_hash_brace_layout.rb#95
RuboCop::Cop::Layout::MultilineHashBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each key in a multi-line hash
# starts on a separate line.
#
# @example
#
#   # bad
#   {
#   a: 1, b: 2,
#   c: 3
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2,
#   c: 3
#   }
#
#   # good
#   {
#   a: 1,
#   b: {
#   c: 3,
#   }
#   }
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   { a: 1, b: {
#   c: 3,
#   }}
# @example AllowMultilineFinalElement: true
#
#   # good
#   { a: 1, b: {
#   c: 3,
#   }}
#
# source://rubocop//lib/rubocop/cop/layout/multiline_hash_key_line_breaks.rb#46
class RuboCop::Cop::Layout::MultilineHashKeyLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_hash_key_line_breaks.rb#52
  def on_hash(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_hash_key_line_breaks.rb#68
  def ignore_last_element?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_hash_key_line_breaks.rb#64
  def starts_with_curly_brace?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_hash_key_line_breaks.rb#50
RuboCop::Cop::Layout::MultilineHashKeyLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Ensures that each argument in a multi-line method call
# starts on a separate line.
#
# NOTE: This cop does not move the first argument, if you want that to
# be on a separate line, see `Layout/FirstMethodArgumentLineBreak`.
#
# @example
#
#   # bad
#   foo(a, b,
#   c
#   )
#
#   # bad
#   foo(a, b, {
#   foo: "bar",
#   })
#
#   # good
#   foo(
#   a,
#   b,
#   c
#   )
#
#   # good
#   foo(a, b, c)
# @example AllowMultilineFinalElement: false (default)
#
#   # good
#   foo(
#   a,
#   b,
#   {
#   foo: "bar",
#   }
#   )
# @example AllowMultilineFinalElement: true
#
#   # good
#   foo(
#   a,
#   b,
#   {
#   foo: "bar",
#   }
#   )
#
# source://rubocop//lib/rubocop/cop/layout/multiline_method_argument_line_breaks.rb#56
class RuboCop::Cop::Layout::MultilineMethodArgumentLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_argument_line_breaks.rb#62
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_argument_line_breaks.rb#81
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_method_argument_line_breaks.rb#60
RuboCop::Cop::Layout::MultilineMethodArgumentLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks that the closing brace in a method call is either
# on the same line as the last method argument, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a method call's opening brace is on the same line as the first
# argument of the call, then the closing brace should be on the same
# line as the last argument of the call.
#
# If an method call's opening brace is on the line above the first
# argument of the call, then the closing brace should be on the line
# below the last argument of the call.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line method call must be on the line
# after the last argument of the call.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line method call must be on the same
# line as the last argument of the call.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   foo(a,
#   b
#   )
#
#   # bad
#   foo(
#   a,
#   b)
#
#   # good
#   foo(a,
#   b)
#
#   # good
#   foo(
#   a,
#   b
#   )
# @example EnforcedStyle: new_line
#   # bad
#   foo(
#   a,
#   b)
#
#   # bad
#   foo(a,
#   b)
#
#   # good
#   foo(a,
#   b
#   )
#
#   # good
#   foo(
#   a,
#   b
#   )
# @example EnforcedStyle: same_line
#   # bad
#   foo(a,
#   b
#   )
#
#   # bad
#   foo(
#   a,
#   b
#   )
#
#   # good
#   foo(
#   a,
#   b)
#
#   # good
#   foo(a,
#   b)
#
# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#91
class RuboCop::Cop::Layout::MultilineMethodCallBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#109
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#115
  def children(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#119
  def ignored_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#123
  def single_line_ignoring_receiver?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#103
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#106
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#99
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_brace_layout.rb#95
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Checks the indentation of the method name part in method calls
# that span more than one line.
#
# @example EnforcedStyle: aligned (default)
#   # bad
#   while myvariable
#   .b
#   # do something
#   end
#
#   # good
#   while myvariable
#   .b
#   # do something
#   end
#
#   # good
#   Thing.a
#   .b
#   .c
# @example EnforcedStyle: indented
#   # good
#   while myvariable
#   .b
#
#   # do something
#   end
# @example EnforcedStyle: indented_relative_to_receiver
#   # good
#   while myvariable
#   .a
#   .b
#
#   # do something
#   end
#
#   # good
#   myvariable = Thing
#   .a
#   .b
#   .c
#
# source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#49
class RuboCop::Cop::Layout::MultilineMethodCallIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::MultilineExpressionIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#55
  def validate_config; end

  private

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#136
  def align_with_base_message(rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#152
  def alignment_base(node, rhs, given_style); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#67
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#140
  def base_source; end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#101
  def extra_indentation(given_style, parent); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#226
  def find_multiline_block_chain_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#237
  def first_call_has_a_dot(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#217
  def get_dot_right_above(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#113
  def message(node, lhs, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#144
  def no_base_message(lhs, rhs, node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#87
  def offending_range(node, lhs, rhs, given_style); end

  # @yield [operation_rhs.first_argument]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#247
  def operation_rhs(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#257
  def operator_rhs?(node, receiver); end

  # a
  #   .b
  #   .c
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#193
  def receiver_alignment_base(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#131
  def relative_to_receiver_message(rhs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#71
  def relevant_node?(send_node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#75
  def right_hand_side(send_node); end

  # a.b
  #  .c
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#181
  def semantic_alignment_base(node, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#201
  def semantic_alignment_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#127
  def should_align_with_base?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#123
  def should_indent_relative_to_receiver?; end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_call_indentation.rb#163
  def syntactic_alignment_base(lhs, rhs); end
end

# Checks that the closing brace in a method definition is either
# on the same line as the last method parameter, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a method definition's opening brace is on the same line as the
# first parameter of the definition, then the closing brace should be
# on the same line as the last parameter of the definition.
#
# If an method definition's opening brace is on the line above the first
# parameter of the definition, then the closing brace should be on the
# line below the last parameter of the definition.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line method definition must be on the line
# after the last parameter of the definition.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line method definition must be on the same
# line as the last parameter of the definition.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   def foo(a,
#   b
#   )
#   end
#
#   # bad
#   def foo(
#   a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b)
#   end
#
#   # good
#   def foo(
#   a,
#   b
#   )
#   end
# @example EnforcedStyle: new_line
#   # bad
#   def foo(
#   a,
#   b)
#   end
#
#   # bad
#   def foo(a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b
#   )
#   end
# @example EnforcedStyle: same_line
#   # bad
#   def foo(a,
#   b
#   )
#   end
#
#   # bad
#   def foo(
#   a,
#   b
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b)
#   end
#
# source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#103
class RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#121
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#121
  def on_defs(node); end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#115
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#118
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#111
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/multiline_method_definition_brace_layout.rb#107
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each parameter in a multi-line method definition
# starts on a separate line.
#
# NOTE: This cop does not move the first argument, if you want that to
# be on a separate line, see `Layout/FirstMethodParameterLineBreak`.
#
# @example
#
#   # bad
#   def foo(a, b,
#   c
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b,
#   c
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b = {
#   foo: "bar",
#   }
#   )
#   end
#
#   # good
#   def foo(a, b, c)
#   end
# @example AllowMultilineFinalElement: false (default)
#
#   # bad
#   def foo(a, b = {
#   foo: "bar",
#   })
#   end
# @example AllowMultilineFinalElement: true
#
#   # good
#   def foo(a, b = {
#   foo: "bar",
#   })
#   end
#
# source://rubocop//lib/rubocop/cop/layout/multiline_method_parameter_line_breaks.rb#57
class RuboCop::Cop::Layout::MultilineMethodParameterLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_method_parameter_line_breaks.rb#63
  def on_def(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_method_parameter_line_breaks.rb#71
  def ignore_last_element?; end
end

# source://rubocop//lib/rubocop/cop/layout/multiline_method_parameter_line_breaks.rb#61
RuboCop::Cop::Layout::MultilineMethodParameterLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the right hand side operand in binary operations that
# span more than one line.
#
# The `aligned` style checks that operators are aligned if they are part of an `if` or `while`
# condition, an explicit `return` statement, etc. In other contexts, the second operand should
# be indented regardless of enforced style.
#
# @example EnforcedStyle: aligned (default)
#   # bad
#   if a +
#   b
#   something &&
#   something_else
#   end
#
#   # good
#   if a +
#   b
#   something &&
#   something_else
#   end
# @example EnforcedStyle: indented
#   # bad
#   if a +
#   b
#   something &&
#   something_else
#   end
#
#   # good
#   if a +
#   b
#   something &&
#   something_else
#   end
#
# source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#43
class RuboCop::Cop::Layout::MultilineOperationIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::MultilineExpressionIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#49
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#53
  def on_or(node); end

  # @raise [ValidationError]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#57
  def validate_config; end

  private

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#68
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#78
  def check_and_or(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#110
  def message(node, lhs, rhs); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#84
  def offending_range(node, lhs, rhs, given_style); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#72
  def relevant_node?(node); end

  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#121
  def right_hand_side(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/multiline_operation_indentation.rb#97
  def should_align?(node, rhs, given_style); end
end

# Here we check if the parameters on a multi-line method call or
# definition are aligned.
#
# To set the alignment of the first argument, use the cop
# FirstParameterIndentation.
#
# @example EnforcedStyle: with_first_parameter (default)
#   # good
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   def foo(
#   bar,
#   baz
#   )
#   123
#   end
#
#   # bad
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   # bad
#
#   def foo(
#   bar,
#   baz)
#   123
#   end
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   def foo(
#   bar,
#   baz
#   )
#   123
#   end
#
#   # bad
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   # bad
#
#   def foo(
#   bar,
#   baz)
#   123
#   end
#
# source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#71
class RuboCop::Cop::Layout::ParameterAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#81
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#81
  def on_defs(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#90
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#102
  def base_column(node, args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#98
  def fixed_indentation?; end

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#94
  def message(_node); end

  # source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#113
  def target_method_lineno(node); end
end

# source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#75
RuboCop::Cop::Layout::ParameterAlignment::ALIGN_PARAMS_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/parameter_alignment.rb#78
RuboCop::Cop::Layout::ParameterAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Checks whether certain expressions, e.g. method calls, that could fit
# completely on a single line, are broken up into multiple lines unnecessarily.
#
# @example any configuration
#   # bad
#   foo(
#   a,
#   b
#   )
#
#   puts 'string that fits on ' \
#   'a single line'
#
#   things
#   .select { |thing| thing.cond? }
#   .join('-')
#
#   # good
#   foo(a, b)
#
#   puts 'string that fits on a single line'
#
#   things.select { |thing| thing.cond? }.join('-')
# @example InspectBlocks: false (default)
#   # good
#   foo(a) do |x|
#   puts x
#   end
# @example InspectBlocks: true
#   # bad
#   foo(a) do |x|
#   puts x
#   end
#
#   # good
#   foo(a) { |x| puts x }
#
# source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#45
class RuboCop::Cop::Layout::RedundantLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#55
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#51
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#55
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#73
  def check_assignment(node, _rhs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#133
  def comment_within?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#103
  def configured_to_not_be_inspected?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#127
  def convertible_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#69
  def end_with_percent_blank_string?(processed_source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#97
  def index_access_call_chained?(node); end

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#155
  def max_line_length; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#86
  def offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#110
  def other_cop_takes_precedence?(node); end

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#79
  def register_offense(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#93
  def require_backslash?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#116
  def single_line_block_chain_enabled?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#120
  def suitable_as_single_line?(node); end

  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#146
  def to_single_line(source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#141
  def too_long?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/redundant_line_break.rb#49
RuboCop::Cop::Layout::RedundantLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks whether the rescue and ensure keywords are aligned
# properly.
#
# @example
#
#   # bad
#   begin
#   something
#   rescue
#   puts 'error'
#   end
#
#   # good
#   begin
#   something
#   rescue
#   puts 'error'
#   end
#
# source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#24
class RuboCop::Cop::Layout::RescueEnsureAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#40
  def on_ensure(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#44
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#36
  def on_resbody(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#186
  def access_modifier?(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#163
  def access_modifier_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#149
  def aligned_with_leading_dot?(do_keyword_line, send_node_loc, rescue_keyword_column); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#136
  def aligned_with_line_break_method?(ancestor_node, node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#195
  def alignment_location(alignment_node); end

  # We will use ancestor or wrapper with access modifier.
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#116
  def alignment_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#95
  def alignment_source(node, starting_loc); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#132
  def ancestor_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#155
  def assignment_node(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#73
  def autocorrect(corrector, node, alignment_location); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#203
  def begin_end_alignment_style; end

  # Check alignment of node with rescue or ensure modifiers.
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#57
  def check(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#83
  def format_message(alignment_node, alignment_loc, kw_loc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#173
  def modifier?(node); end

  # source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#179
  def whitespace_range(node); end
end

# source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#34
RuboCop::Cop::Layout::RescueEnsureAlignment::ALTERNATIVE_ACCESS_MODIFIERS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#32
RuboCop::Cop::Layout::RescueEnsureAlignment::ANCESTOR_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#33
RuboCop::Cop::Layout::RescueEnsureAlignment::ANCESTOR_TYPES_WITH_ACCESS_MODIFIERS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/layout/rescue_ensure_alignment.rb#29
RuboCop::Cop::Layout::RescueEnsureAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks if method calls are chained onto single line blocks. It considers that a
# line break before the dot improves the readability of the code.
#
# @example
#   # bad
#   example.select { |item| item.cond? }.join('-')
#
#   # good
#   example.select { |item| item.cond? }
#   .join('-')
#
#   # good (not a concern for this cop)
#   example.select do |item|
#   item.cond?
#   end.join('-')
#
# source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#22
class RuboCop::Cop::Layout::SingleLineBlockChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#32
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#32
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#56
  def call_method_after_block?(node, dot_range, closing_block_delimiter_line_num); end

  # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#40
  def offending_range(node); end

  # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#62
  def selector_range(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#28
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/single_line_block_chain.rb#26
RuboCop::Cop::Layout::SingleLineBlockChain::MSG = T.let(T.unsafe(nil), String)

# Checks for colon (:) not followed by some kind of space.
# N.B. this cop does not handle spaces after a ternary operator, which are
# instead handled by Layout/SpaceAroundOperators.
#
# @example
#   # bad
#   def f(a:, b:2); {a:3}; end
#
#   # good
#   def f(a:, b: 2); {a: 3}; end
#
# source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#16
class RuboCop::Cop::Layout::SpaceAfterColon < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#29
  def on_kwoptarg(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#21
  def on_pair(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#43
  def followed_by_space?(colon); end

  # source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#39
  def register_offense(colon); end
end

# source://rubocop//lib/rubocop/cop/layout/space_after_colon.rb#19
RuboCop::Cop::Layout::SpaceAfterColon::MSG = T.let(T.unsafe(nil), String)

# Checks for comma (,) not followed by some kind of space.
#
# @example
#
#   # bad
#   [1,2]
#   { foo:bar,}
#
#   # good
#   [1, 2]
#   { foo:bar, }
#
# source://rubocop//lib/rubocop/cop/layout/space_after_comma.rb#17
class RuboCop::Cop::Layout::SpaceAfterComma < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SpaceAfterPunctuation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_after_comma.rb#26
  def kind(token); end

  # source://rubocop//lib/rubocop/cop/layout/space_after_comma.rb#21
  def space_style_before_rcurly; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_after_comma.rb#32
  def before_semicolon?(token); end
end

# Checks for space between a method name and a left parenthesis in defs.
#
# @example
#
#   # bad
#   def func (x) end
#   def method= (y) end
#
#   # good
#   def func(x) end
#   def method=(y) end
#
# source://rubocop//lib/rubocop/cop/layout/space_after_method_name.rb#17
class RuboCop::Cop::Layout::SpaceAfterMethodName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_after_method_name.rb#23
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_after_method_name.rb#23
  def on_defs(node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_after_method_name.rb#21
RuboCop::Cop::Layout::SpaceAfterMethodName::MSG = T.let(T.unsafe(nil), String)

# Checks for space after `!`.
#
# @example
#   # bad
#   ! something
#
#   # good
#   !something
#
# source://rubocop//lib/rubocop/cop/layout/space_after_not.rb#14
class RuboCop::Cop::Layout::SpaceAfterNot < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_after_not.rb#21
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_after_not.rb#33
  def whitespace_after_operator?(node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_after_not.rb#18
RuboCop::Cop::Layout::SpaceAfterNot::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_after_not.rb#19
RuboCop::Cop::Layout::SpaceAfterNot::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for semicolon (;) not followed by some kind of space.
#
# @example
#   # bad
#   x = 1;y = 2
#
#   # good
#   x = 1; y = 2
#
# source://rubocop//lib/rubocop/cop/layout/space_after_semicolon.rb#14
class RuboCop::Cop::Layout::SpaceAfterSemicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SpaceAfterPunctuation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_after_semicolon.rb#23
  def kind(token); end

  # source://rubocop//lib/rubocop/cop/layout/space_after_semicolon.rb#18
  def space_style_before_rcurly; end
end

# Checks the spacing inside and after block parameters pipes. Line breaks
# inside parameter pipes are checked by `Layout/MultilineBlockLayout` and
# not by this cop.
#
# @example EnforcedStyleInsidePipes: no_space (default)
#   # bad
#   {}.each { | x,  y |puts x }
#   ->( x,  y ) { puts x }
#
#   # good
#   {}.each { |x, y| puts x }
#   ->(x, y) { puts x }
# @example EnforcedStyleInsidePipes: space
#   # bad
#   {}.each { |x,  y| puts x }
#   ->(x,  y) { puts x }
#
#   # good
#   {}.each { | x, y | puts x }
#   ->( x, y ) { puts x }
#
# source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#27
class RuboCop::Cop::Layout::SpaceAroundBlockParameters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#32
  def on_block(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#65
  def check_after_closing_pipe(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#125
  def check_arg(arg); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#103
  def check_closing_pipe_space(arguments, closing_pipe); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#121
  def check_each_arg(args); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#56
  def check_inside_pipes(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#150
  def check_no_space(space_begin_pos, space_end_pos, msg); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#73
  def check_no_space_style_inside_pipes(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#92
  def check_opening_pipe_space(arguments, opening_pipe); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#136
  def check_space(space_begin_pos, space_end_pos, range, msg, node = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#85
  def check_space_style_inside_pipes(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#113
  def last_end_pos_inside_pipes(arguments, range); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#44
  def pipes(arguments); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#48
  def pipes?(arguments); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_block_parameters.rb#52
  def style_parameter_name; end
end

# Checks that the equals signs in parameter default assignments
# have or don't have surrounding space depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # bad
#   def some_method(arg1=:default, arg2=nil, arg3=[])
#   # do something...
#   end
#
#   # good
#   def some_method(arg1 = :default, arg2 = nil, arg3 = [])
#   # do something...
#   end
# @example EnforcedStyle: no_space
#   # bad
#   def some_method(arg1 = :default, arg2 = nil, arg3 = [])
#   # do something...
#   end
#
#   # good
#   def some_method(arg1=:default, arg2=nil, arg3=[])
#   # do something...
#   end
#
# source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#30
class RuboCop::Cop::Layout::SpaceAroundEqualsInParameterDefault < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#38
  def on_optarg(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#67
  def autocorrect(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#46
  def check_optarg(arg, equals, value); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#58
  def incorrect_style_detected(arg, value); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#83
  def message(_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#79
  def no_surrounding_space?(arg, equals); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#75
  def space_on_both_sides?(arg, equals); end
end

# source://rubocop//lib/rubocop/cop/layout/space_around_equals_in_parameter_default.rb#36
RuboCop::Cop::Layout::SpaceAroundEqualsInParameterDefault::MSG = T.let(T.unsafe(nil), String)

# Checks the spacing around the keywords.
#
# @example
#
#   # bad
#   something 'test'do|x|
#   end
#
#   while(something)
#   end
#
#   something = 123if test
#
#   # good
#   something 'test' do |x|
#   end
#
#   while (something)
#   end
#
#   something = 123 if test
#
# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#27
class RuboCop::Cop::Layout::SpaceAroundKeyword < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#40
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#44
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#48
  def on_break(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#52
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#56
  def on_case_match(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#156
  def on_defined?(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#60
  def on_ensure(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#64
  def on_for(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#68
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#72
  def on_if_guard(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#76
  def on_in_pattern(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#80
  def on_kwbegin(node); end

  # Handle one-line pattern matching syntax (`in`) with `Parser::Ruby27`.
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#85
  def on_match_pattern(node); end

  # Handle one-line pattern matching syntax (`in`) with `Parser::Ruby30`.
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#92
  def on_match_pattern_p(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#96
  def on_next(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#100
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#104
  def on_postexe(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#108
  def on_preexe(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#112
  def on_resbody(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#116
  def on_rescue(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#120
  def on_return(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#124
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#128
  def on_super(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#136
  def on_unless_guard(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#140
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#144
  def on_when(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#148
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#152
  def on_yield(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#132
  def on_zsuper(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#235
  def accept_left_parenthesis?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#239
  def accept_left_square_bracket?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#243
  def accept_namespace_operator?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#228
  def accepted_opening_delimiter?(range, char); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#162
  def check(node, locations, begin_keyword = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#177
  def check_begin(node, range, begin_keyword); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#183
  def check_end(node, range, begin_keyword); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#196
  def check_keyword(node, range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#192
  def do?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#251
  def namespace_operator?(range, pos); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#255
  def preceded_by_operator?(node, _range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#247
  def safe_navigation_call?(range, pos); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#217
  def space_after_missing?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#210
  def space_before_missing?(range); end
end

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#36
RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_LEFT_PAREN = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#37
RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_LEFT_SQUARE_BRACKET = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#38
RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_NAMESPACE_OPERATOR = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#33
RuboCop::Cop::Layout::SpaceAroundKeyword::DO = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#31
RuboCop::Cop::Layout::SpaceAroundKeyword::MSG_AFTER = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#30
RuboCop::Cop::Layout::SpaceAroundKeyword::MSG_BEFORE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#35
RuboCop::Cop::Layout::SpaceAroundKeyword::NAMESPACE_OPERATOR = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_keyword.rb#34
RuboCop::Cop::Layout::SpaceAroundKeyword::SAFE_NAVIGATION = T.let(T.unsafe(nil), String)

# Checks method call operators to not have spaces around them.
#
# @example
#   # bad
#   foo. bar
#   foo .bar
#   foo . bar
#   foo. bar .buzz
#   foo
#   . bar
#   . buzz
#   foo&. bar
#   foo &.bar
#   foo &. bar
#   foo &. bar&. buzz
#   RuboCop:: Cop
#   RuboCop:: Cop:: Base
#   :: RuboCop::Cop
#
#   # good
#   foo.bar
#   foo.bar.buzz
#   foo
#   .bar
#   .buzz
#   foo&.bar
#   foo&.bar&.buzz
#   RuboCop::Cop
#   RuboCop::Cop::Base
#   ::RuboCop::Cop
#
# source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#37
class RuboCop::Cop::Layout::SpaceAroundMethodCallOperator < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#53
  def on_const(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#45
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#45
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#87
  def check_space(begin_pos, end_pos); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#67
  def check_space_after_dot(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#81
  def check_space_after_double_colon(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#61
  def check_space_before_dot(node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#43
RuboCop::Cop::Layout::SpaceAroundMethodCallOperator::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_method_call_operator.rb#41
RuboCop::Cop::Layout::SpaceAroundMethodCallOperator::SPACES_REGEXP = T.let(T.unsafe(nil), Regexp)

# Checks that operators have space around them, except for ** which
# should or shouldn't have surrounding space depending on configuration.
# It allows vertical alignment consisting of one or more whitespace
# around operators.
#
# This cop has `AllowForAlignment` option. When `true`, allows most
# uses of extra spacing if the intent is to align with an operator on
# the previous or next line, not counting empty lines or comment lines.
#
# @example
#   # bad
#   total = 3*4
#   "apple"+"juice"
#   my_number = 38/4
#
#   # good
#   total = 3 * 4
#   "apple" + "juice"
#   my_number = 38 / 4
# @example AllowForAlignment: true (default)
#   # good
#   {
#   1 =>  2,
#   11 => 3
#   }
# @example AllowForAlignment: false
#   # bad
#   {
#   1 =>  2,
#   11 => 3
#   }
# @example EnforcedStyleForExponentOperator: no_space (default)
#   # bad
#   a ** b
#
#   # good
#   a**b
# @example EnforcedStyleForExponentOperator: space
#   # bad
#   a**b
#
#   # good
#   a ** b
# @example EnforcedStyleForRationalLiterals: no_space (default)
#   # bad
#   1 / 48r
#
#   # good
#   1/48r
# @example EnforcedStyleForRationalLiterals: space
#   # bad
#   1/48r
#
#   # good
#   1 / 48r
#
# source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#67
class RuboCop::Cop::Layout::SpaceAroundOperators < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::RationalLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#133
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_and_asgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_assignment(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#133
  def on_binary(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#125
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#133
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#92
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_masgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#149
  def on_match_pattern(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#141
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#133
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#117
  def on_or_asgn(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#84
  def on_pair(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#99
  def on_resbody(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#80
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#107
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#141
  def on_special_asgn(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#259
  def align_hash_cop_config; end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#198
  def autocorrect(corrector, range, right_operand); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#179
  def check_operator(type, operator, right_operand); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#212
  def enclose_operator_with_space(corrector, range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#239
  def excess_leading_space?(type, operator, with_space); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#254
  def excess_trailing_space?(right_operand, with_space); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#277
  def force_equal_sign_alignment?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#263
  def hash_table_style?; end

  # @yield [msg]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#193
  def offense(type, operator, with_space, right_operand); end

  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#225
  def offense_message(type, operator, with_space, right_operand); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#175
  def operator_with_regular_syntax?(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#169
  def regular_operator?(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#281
  def should_not_have_surrounding_space?(operator, right_operand); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#267
  def space_around_exponent_operator?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#271
  def space_around_slash_operator?(right_operand); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#76
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#74
RuboCop::Cop::Layout::SpaceAroundOperators::EXCESSIVE_SPACE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_around_operators.rb#73
RuboCop::Cop::Layout::SpaceAroundOperators::IRREGULAR_METHODS = T.let(T.unsafe(nil), Array)

# Checks that block braces have or don't have a space before the opening
# brace depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # bad
#   foo.map{ |a|
#   a.bar.to_s
#   }
#
#   # good
#   foo.map { |a|
#   a.bar.to_s
#   }
# @example EnforcedStyle: no_space
#   # bad
#   foo.map { |a|
#   a.bar.to_s
#   }
#
#   # good
#   foo.map{ |a|
#   a.bar.to_s
#   }
# @example EnforcedStyleForEmptyBraces: space (default)
#   # bad
#   7.times{}
#
#   # good
#   7.times {}
# @example EnforcedStyleForEmptyBraces: no_space
#   # bad
#   7.times {}
#
#   # good
#   7.times{}
#
# source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#44
class RuboCop::Cop::Layout::SpaceBeforeBlockBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#56
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#56
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#133
  def autocorrect(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#153
  def block_delimiters_style; end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#83
  def check_empty(left_brace, space_plus_brace, used_style); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#109
  def check_non_empty(left_brace, space_plus_brace, used_style); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#149
  def conflict_with_block_delimiters?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#157
  def empty_braces?(loc); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#101
  def handle_different_styles_for_empty_braces(used_style); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#124
  def space_detected(left_brace, space_plus_brace); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#117
  def space_missing(left_brace); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#140
  def style_for_empty_braces; end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#52
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#50
RuboCop::Cop::Layout::SpaceBeforeBlockBraces::DETECTED_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_before_block_braces.rb#49
RuboCop::Cop::Layout::SpaceBeforeBlockBraces::MISSING_MSG = T.let(T.unsafe(nil), String)

# Checks for space between the name of a receiver and a left
# brackets.
#
# @example
#
#   # bad
#   collection [index_or_key]
#
#   # good
#   collection[index_or_key]
#
# source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#17
class RuboCop::Cop::Layout::SpaceBeforeBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#24
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#48
  def dot_before_brackets?(node, receiver_end_pos, selector_begin_pos); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#35
  def offense_range(node, begin_pos); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#54
  def offense_range_for_assignment(node, begin_pos); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#67
  def reference_variable_with_brackets?(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#63
  def register_offense(range); end
end

# source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#21
RuboCop::Cop::Layout::SpaceBeforeBrackets::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_before_brackets.rb#22
RuboCop::Cop::Layout::SpaceBeforeBrackets::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for comma (,) preceded by space.
#
# @example
#   # bad
#   [1 , 2 , 3]
#   a(1 , 2)
#   each { |a , b| }
#
#   # good
#   [1, 2, 3]
#   a(1, 2)
#   each { |a, b| }
#
# source://rubocop//lib/rubocop/cop/layout/space_before_comma.rb#19
class RuboCop::Cop::Layout::SpaceBeforeComma < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SpaceBeforePunctuation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_comma.rb#23
  def kind(token); end
end

# Checks for missing space between a token and a comment on the
# same line.
#
# @example
#   # bad
#   1 + 1# this operation does ...
#
#   # good
#   1 + 1 # this operation does ...
#
# source://rubocop//lib/rubocop/cop/layout/space_before_comment.rb#15
class RuboCop::Cop::Layout::SpaceBeforeComment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_comment.rb#20
  def on_new_investigation; end
end

# source://rubocop//lib/rubocop/cop/layout/space_before_comment.rb#18
RuboCop::Cop::Layout::SpaceBeforeComment::MSG = T.let(T.unsafe(nil), String)

# Checks that exactly one space is used between a method name and the
# first argument for method calls without parentheses.
#
# Alternatively, extra spaces can be added to align the argument with
# something on a preceding or following line, if the AllowForAlignment
# config parameter is true.
#
# @example
#   # bad
#   something  x
#   something   y, z
#   something'hello'
#
#   # good
#   something x
#   something y, z
#   something 'hello'
#
# source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#24
class RuboCop::Cop::Layout::SpaceBeforeFirstArg < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#35
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#35
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#55
  def expect_params_after_method_name?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#64
  def no_space_between_method_name_and_first_argument?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#51
  def regular_method_call_with_arguments?(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#31
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/layout/space_before_first_arg.rb#29
RuboCop::Cop::Layout::SpaceBeforeFirstArg::MSG = T.let(T.unsafe(nil), String)

# Checks for semicolon (;) preceded by space.
#
# @example
#   # bad
#   x = 1 ; y = 2
#
#   # good
#   x = 1; y = 2
#
# source://rubocop//lib/rubocop/cop/layout/space_before_semicolon.rb#14
class RuboCop::Cop::Layout::SpaceBeforeSemicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SpaceBeforePunctuation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_before_semicolon.rb#18
  def kind(token); end
end

# Checks for spaces between `->` and opening parameter
# parenthesis (`(`) in lambda literals.
#
# @example EnforcedStyle: require_no_space (default)
#   # bad
#   a = -> (x, y) { x + y }
#
#   # good
#   a = ->(x, y) { x + y }
# @example EnforcedStyle: require_space
#   # bad
#   a = ->(x, y) { x + y }
#
#   # good
#   a = -> (x, y) { x + y }
#
# source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#22
class RuboCop::Cop::Layout::SpaceInLambdaLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#30
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#50
  def arrow_lambda_with_args?(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#72
  def lambda_arguments(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#65
  def range_of_offense(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#58
  def space_after_arrow(lambda_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#54
  def space_after_arrow?(lambda_node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#28
RuboCop::Cop::Layout::SpaceInLambdaLiteral::MSG_REQUIRE_NO_SPACE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_in_lambda_literal.rb#27
RuboCop::Cop::Layout::SpaceInLambdaLiteral::MSG_REQUIRE_SPACE = T.let(T.unsafe(nil), String)

# Checks that brackets used for array literals have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that array literals have
#   # no surrounding space.
#
#   # bad
#   array = [ a, b, c, d ]
#
#   # good
#   array = [a, b, c, d]
# @example EnforcedStyle: space
#   # The `space` style enforces that array literals have
#   # surrounding space.
#
#   # bad
#   array = [a, b, c, d]
#
#   # good
#   array = [ a, b, c, d ]
# @example EnforcedStyle: compact
#   # The `compact` style normally requires a space inside
#   # array brackets, with the exception that successive left
#   # or right brackets are collapsed together in nested arrays.
#
#   # bad
#   array = [ a, [ b, c ] ]
#   array = [
#   [ a ],
#   [ b, c ]
#   ]
#
#   # good
#   array = [ a, [ b, c ]]
#   array = [[ a ],
#   [ b, c ]]
# @example EnforcedStyleForEmptyBrackets: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty array brackets do not contain spaces.
#
#   # bad
#   foo = [ ]
#   bar = [     ]
#
#   # good
#   foo = []
#   bar = []
# @example EnforcedStyleForEmptyBrackets: space
#   # The `space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty array brackets contain exactly one space.
#
#   # bad
#   foo = []
#   bar = [    ]
#
#   # good
#   foo = [ ]
#   bar = [ ]
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#70
class RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#78
  def on_array(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#109
  def array_brackets(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#95
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#217
  def compact(corrector, bracket, side); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#203
  def compact_corrections(corrector, node, left, right); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#195
  def compact_offense(node, token, side: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#157
  def compact_offenses(node, left, right, start_ok, end_ok); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#118
  def empty_config; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#126
  def end_has_own_line?(token); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#133
  def index_for(node, token); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#141
  def issue_offenses(node, left, right, start_ok, end_ok); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#137
  def line_and_column_for(token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#178
  def multi_dimensional_array?(node, token, side: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#189
  def next_to_bracket?(token, side: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#153
  def next_to_comment?(node, token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#122
  def next_to_newline?(node, token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#170
  def qualifies_for_compact?(node, token, side: T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#76
RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets::EMPTY_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_inside_array_literal_brackets.rb#75
RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets::MSG = T.let(T.unsafe(nil), String)

# Checks for unnecessary additional spaces inside array percent literals
# (i.e. %i/%w).
#
# Note that blank percent literals (e.g. `%i( )`) are checked by
# `Layout/SpaceInsidePercentLiteralDelimiters`.
#
# @example
#
#   # bad
#   %w(foo  bar  baz)
#   # good
#   %i(foo bar baz)
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#18
class RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#26
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#30
  def on_percent_literal(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#40
  def each_unnecessary_space_match(node, &blk); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#23
RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_inside_array_percent_literal.rb#24
RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral::MULTIPLE_SPACES_BETWEEN_ITEMS_REGEX = T.let(T.unsafe(nil), Regexp)

# Checks that block braces have or don't have surrounding space inside
# them on configuration. For blocks taking parameters, it checks that the
# left brace has or doesn't have trailing space depending on
# configuration.
#
# @example EnforcedStyle: space (default)
#   # The `space` style enforces that block braces have
#   # surrounding space.
#
#   # bad
#   some_array.each {puts e}
#
#   # good
#   some_array.each { puts e }
# @example EnforcedStyle: no_space
#   # The `no_space` style enforces that block braces don't
#   # have surrounding space.
#
#   # bad
#   some_array.each { puts e }
#
#   # good
#   some_array.each {puts e}
# @example EnforcedStyleForEmptyBraces: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBraces style enforces that
#   # block braces don't have a space in between when empty.
#
#   # bad
#   some_array.each {   }
#   some_array.each {  }
#   some_array.each { }
#
#   # good
#   some_array.each {}
# @example EnforcedStyleForEmptyBraces: space
#   # The `space` EnforcedStyleForEmptyBraces style enforces that
#   # block braces have at least a space in between when empty.
#
#   # bad
#   some_array.each {}
#
#   # good
#   some_array.each { }
#   some_array.each {  }
#   some_array.each {   }
# @example SpaceBeforeBlockParameters: true (default)
#   # The SpaceBeforeBlockParameters style set to `true` enforces that
#   # there is a space between `{` and `|`. Overrides `EnforcedStyle`
#   # if there is a conflict.
#
#   # bad
#   [1, 2, 3].each {|n| n * 2 }
#
#   # good
#   [1, 2, 3].each { |n| n * 2 }
# @example SpaceBeforeBlockParameters: false
#   # The SpaceBeforeBlockParameters style set to `false` enforces that
#   # there is no space between `{` and `|`. Overrides `EnforcedStyle`
#   # if there is a conflict.
#
#   # bad
#   [1, 2, 3].each { |n| n * 2 }
#
#   # good
#   [1, 2, 3].each {|n| n * 2 }
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#79
class RuboCop::Cop::Layout::SpaceInsideBlockBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#85
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#85
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#122
  def adjacent_braces(left_brace, right_brace); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#161
  def aligned_braces?(inner, right_brace, column); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#130
  def braces_with_contents_inside(node, inner); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#105
  def check_inside(node, left_brace, right_brace); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#137
  def check_left_brace(inner, left_brace, args_delimiter); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#145
  def check_right_brace(node, inner, left_brace, right_brace, single_line); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#165
  def inner_last_space_count(inner); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#157
  def multiline_block?(left_brace, right_brace); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#222
  def no_space(begin_pos, end_pos, msg); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#169
  def no_space_inside_left_brace(left_brace, args_delimiter); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#238
  def offense(begin_pos, end_pos, msg, style_param = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#201
  def pipe?(args_delimiter); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#230
  def space(begin_pos, end_pos, msg); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#186
  def space_inside_left_brace(left_brace, args_delimiter); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#205
  def space_inside_right_brace(inner, right_brace, column); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_block_braces.rb#253
  def style_for_empty_braces; end
end

# Checks that braces used for hash literals have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # The `space` style enforces that hash literals have
#   # surrounding space.
#
#   # bad
#   h = {a: 1, b: 2}
#
#   # good
#   h = { a: 1, b: 2 }
# @example EnforcedStyle: no_space
#   # The `no_space` style enforces that hash literals have
#   # no surrounding space.
#
#   # bad
#   h = { a: 1, b: 2 }
#
#   # good
#   h = {a: 1, b: 2}
# @example EnforcedStyle: compact
#   # The `compact` style normally requires a space inside
#   # hash braces, with the exception that successive left
#   # braces or right braces are collapsed together in nested hashes.
#
#   # bad
#   h = { a: { b: 2 } }
#   foo = { { a: 1 } => { b: { c: 2 } } }
#
#   # good
#   h = { a: { b: 2 }}
#   foo = {{ a: 1 } => { b: { c: 2 }}}
# @example EnforcedStyleForEmptyBraces: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBraces style enforces that
#   # empty hash braces do not contain spaces.
#
#   # bad
#   foo = { }
#   bar = {    }
#   baz = {
#   }
#
#   # good
#   foo = {}
#   bar = {}
#   baz = {}
# @example EnforcedStyleForEmptyBraces: space
#   # The `space` EnforcedStyleForEmptyBraces style enforces that
#   # empty hash braces contain space.
#
#   # bad
#   foo = {}
#
#   # good
#   foo = { }
#   foo = {    }
#   foo = {
#   }
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#70
class RuboCop::Cop::Layout::SpaceInsideHashLiteralBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#78
  def on_hash(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#137
  def ambiguous_or_unexpected_style_detected(style, is_match); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#129
  def autocorrect(corrector, range); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#89
  def check(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#184
  def check_whitespace_only_hash(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#202
  def enforce_no_space_style_for_empty_braces?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#104
  def expect_space?(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#117
  def incorrect_style_detected(token1, token2, expect_space, is_empty_braces); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#150
  def message(brace, is_empty_braces, expect_space); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#145
  def offense?(token1, expect_space); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#196
  def range_inside_hash(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#176
  def range_of_space_to_the_left(range); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#168
  def range_of_space_to_the_right(range); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#160
  def space_range(token_range); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_hash_literal_braces.rb#76
RuboCop::Cop::Layout::SpaceInsideHashLiteralBraces::MSG = T.let(T.unsafe(nil), String)

# Checks for spaces inside ordinary round parentheses.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that parentheses do not have spaces.
#
#   # bad
#   f( 3)
#   g = (a + 3 )
#   f( )
#
#   # good
#   f(3)
#   g = (a + 3)
#   f()
# @example EnforcedStyle: space
#   # The `space` style enforces that parentheses have a space at the
#   # beginning and end.
#   # Note: Empty parentheses should not have spaces.
#
#   # bad
#   f(3)
#   g = (a + 3)
#   y( )
#
#   # good
#   f( 3 )
#   g = ( a + 3 )
#   y()
# @example EnforcedStyle: compact
#   # The `compact` style enforces that parentheses have a space at the
#   # beginning with the exception that successive parentheses are allowed.
#   # Note: Empty parentheses should not have spaces.
#
#   # bad
#   f(3)
#   g = (a + 3)
#   y( )
#   g( f( x ) )
#   g( f( x( 3 ) ), 5 )
#   g( ( ( 3 + 5 ) * f) ** x, 5 )
#
#   # good
#   f( 3 )
#   g = ( a + 3 )
#   y()
#   g( f( x ))
#   g( f( x( 3 )), 5 )
#   g((( 3 + 5 ) * f ) ** x, 5 )
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#57
class RuboCop::Cop::Layout::SpaceInsideParens < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#66
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#161
  def can_be_ignored?(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#99
  def correct_extraneous_space(tokens); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#115
  def correct_extraneous_space_between_consecutive_parens(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#124
  def correct_extraneous_space_in_empty_parens(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#135
  def correct_missing_space(token1, token2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#153
  def left_parens?(token1, token2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#149
  def parens?(token1, token2); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#88
  def process_with_compact_style(tokens); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#81
  def process_with_space_style(tokens); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#157
  def right_parens?(token1, token2); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#63
RuboCop::Cop::Layout::SpaceInsideParens::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_inside_parens.rb#64
RuboCop::Cop::Layout::SpaceInsideParens::MSG_SPACE = T.let(T.unsafe(nil), String)

# Checks for unnecessary additional spaces inside the delimiters of
# %i/%w/%x literals.
#
# @example
#
#   # bad
#   %i( foo bar baz )
#
#   # good
#   %i(foo bar baz)
#
#   # bad
#   %w( foo bar baz )
#
#   # good
#   %w(foo bar baz)
#
#   # bad
#   %x(  ls -l )
#
#   # good
#   %x(ls -l)
#
#   # bad
#   %w( )
#   %w(
#   )
#
#   # good
#   %w()
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#36
class RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#45
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#53
  def on_percent_literal(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#49
  def on_xstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#60
  def add_offenses_for_blank_spaces(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#69
  def add_offenses_for_unnecessary_spaces(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#85
  def body_range(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#79
  def regex_matches(node, &blk); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#42
RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::BEGIN_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#43
RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::END_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/layout/space_inside_percent_literal_delimiters.rb#41
RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::MSG = T.let(T.unsafe(nil), String)

# Checks for spaces inside range literals.
#
# @example
#   # bad
#   1 .. 3
#
#   # good
#   1..3
#
#   # bad
#   'a' .. 'z'
#
#   # good
#   'a'..'z'
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_range_literal.rb#20
class RuboCop::Cop::Layout::SpaceInsideRangeLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_range_literal.rb#29
  def on_erange(node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_range_literal.rb#25
  def on_irange(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_range_literal.rb#35
  def check(node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_range_literal.rb#23
RuboCop::Cop::Layout::SpaceInsideRangeLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks that reference brackets have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that reference brackets have
#   # no surrounding space.
#
#   # bad
#   hash[ :key ]
#   array[ index ]
#
#   # good
#   hash[:key]
#   array[index]
# @example EnforcedStyle: space
#   # The `space` style enforces that reference brackets have
#   # surrounding space.
#
#   # bad
#   hash[:key]
#   array[index]
#
#   # good
#   hash[ :key ]
#   array[ index ]
# @example EnforcedStyleForEmptyBrackets: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty reference brackets do not contain spaces.
#
#   # bad
#   foo[ ]
#   foo[     ]
#   foo[
#   ]
#
#   # good
#   foo[]
# @example EnforcedStyleForEmptyBrackets: space
#   # The `space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty reference brackets contain exactly one space.
#
#   # bad
#   foo[]
#   foo[    ]
#   foo[
#   ]
#
#   # good
#   foo[ ]
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#60
class RuboCop::Cop::Layout::SpaceInsideReferenceBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#70
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#92
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#121
  def closing_bracket(tokens, opening_bracket); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#137
  def empty_config; end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#110
  def left_ref_bracket(node, tokens); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#132
  def previous_token(current_token); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#104
  def reference_brackets(node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#66
RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::EMPTY_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#65
RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/layout/space_inside_reference_brackets.rb#68
RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for whitespace within string interpolations.
#
# @example EnforcedStyle: no_space (default)
#   # bad
#   var = "This is the #{ space } example"
#
#   # good
#   var = "This is the #{no_space} example"
# @example EnforcedStyle: space
#   # bad
#   var = "This is the #{no_space} example"
#
#   # good
#   var = "This is the #{ space } example"
#
# source://rubocop//lib/rubocop/cop/layout/space_inside_string_interpolation.rb#21
class RuboCop::Cop::Layout::SpaceInsideStringInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/space_inside_string_interpolation.rb#30
  def on_interpolation(begin_node); end

  private

  # source://rubocop//lib/rubocop/cop/layout/space_inside_string_interpolation.rb#46
  def autocorrect(corrector, begin_node); end

  # source://rubocop//lib/rubocop/cop/layout/space_inside_string_interpolation.rb#56
  def delimiters(begin_node); end
end

# source://rubocop//lib/rubocop/cop/layout/space_inside_string_interpolation.rb#28
RuboCop::Cop::Layout::SpaceInsideStringInterpolation::MSG = T.let(T.unsafe(nil), String)

# Looks for trailing blank lines and a final newline in the
# source code.
#
# @example EnforcedStyle: final_newline (default)
#   # `final_newline` looks for one newline at the end of files.
#
#   # bad
#   class Foo; end
#
#   # EOF
#
#   # bad
#   class Foo; end # EOF
#
#   # good
#   class Foo; end
#   # EOF
# @example EnforcedStyle: final_blank_line
#   # `final_blank_line` looks for one blank line followed by a new line
#   # at the end of files.
#
#   # bad
#   class Foo; end
#   # EOF
#
#   # bad
#   class Foo; end # EOF
#
#   # good
#   class Foo; end
#
#   # EOF
#
# source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#40
class RuboCop::Cop::Layout::TrailingEmptyLines < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#45
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#90
  def end_with_percent_blank_string?(processed_source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#80
  def ends_in_end?(processed_source); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#94
  def message(wanted_blank_lines, blank_lines); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_empty_lines.rb#67
  def offense_detected(buffer, wanted_blank_lines, blank_lines, whitespace_at_end); end
end

# Looks for trailing whitespace in the source code.
#
# @example
#   # The line in this example contains spaces after the 0.
#   # bad
#   x = 0
#
#   # The line in this example ends directly after the 0.
#   # good
#   x = 0
# @example AllowInHeredoc: false (default)
#   # The line in this example contains spaces after the 0.
#   # bad
#   code = <<~RUBY
#   x = 0
#   RUBY
#
#   # ok
#   code = <<~RUBY
#   x = 0 #{}
#   RUBY
#
#   # good
#   trailing_whitespace = ' '
#   code = <<~RUBY
#   x = 0#{trailing_whitespace}
#   RUBY
# @example AllowInHeredoc: true
#   # The line in this example contains spaces after the 0.
#   # good
#   code = <<~RUBY
#   x = 0
#   RUBY
#
# source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#42
class RuboCop::Cop::Layout::TrailingWhitespace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#57
  def on_heredoc(_node); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#49
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#112
  def extract_heredocs(ast); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#103
  def find_heredoc(line_number); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#108
  def heredocs; end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#125
  def offense_range(lineno, line); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#61
  def process_line(line, lineno); end

  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#75
  def process_line_in_heredoc(corrector, range, heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#99
  def skip_heredoc?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#95
  def static?(heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#86
  def whitespace_is_indentation?(range, level); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#90
  def whitespace_only?(range); end
end

# source://rubocop//lib/rubocop/cop/layout/trailing_whitespace.rb#47
RuboCop::Cop::Layout::TrailingWhitespace::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#5
module RuboCop::Cop::Legacy; end

# Legacy support for Corrector#corrections
# See https://docs.rubocop.org/rubocop/v1_upgrade_notes.html
#
# source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#8
class RuboCop::Cop::Legacy::CorrectionsProxy
  # @return [CorrectionsProxy] a new instance of CorrectionsProxy
  #
  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#9
  def initialize(corrector); end

  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#13
  def <<(callable); end

  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#21
  def concat(corrections); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#17
  def empty?; end

  protected

  # Returns the value of attribute corrector.
  #
  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#31
  def corrector; end

  private

  # source://rubocop//lib/rubocop/cop/legacy/corrections_proxy.rb#35
  def suppress_clobbering; end
end

# This class handles autocorrection for code that needs to be moved
# to new lines.
#
# source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#7
class RuboCop::Cop::LineBreakCorrector
  extend ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::TrailingBody
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#27
    def break_line_before(range:, node:, corrector:, configured_width:, indent_steps: T.unsafe(nil)); end

    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#15
    def correct_trailing_body(configured_width:, corrector:, node:, processed_source:); end

    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#35
    def move_comment(eol_comment:, node:, corrector:); end

    # Returns the value of attribute processed_source.
    #
    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#13
    def processed_source; end

    private

    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#45
    def remove_semicolon(node, corrector); end

    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#51
    def semicolon(node); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/line_break_corrector.rb#58
    def trailing_class_definition?(token, body); end
  end
end

# Help methods for determining if a line is too long.
#
# source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#6
module RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::Alignment

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#24
  def allow_uri?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#28
  def allowed_uri_position?(line, uri_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#15
  def directive_on_source_line?(line_index); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#72
  def extend_uri_end_position(line, end_position); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#36
  def find_excessive_uri_range(line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#11
  def ignore_cop_directives?; end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#59
  def indentation_difference(line); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#32
  def line_length(line); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#105
  def line_length_without_directive(line); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#51
  def match_uris(string); end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#88
  def tab_indentation_width; end

  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#93
  def uri_regexp; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/line_length_help.rb#98
  def valid_uri?(uri_ish_string); end
end

# source://rubocop//lib/rubocop/cop/mixin/unused_argument.rb#5
module RuboCop::Cop::Lint; end

# Checks for mistyped shorthand assignments.
#
# @example
#   # bad
#   x =- y
#   x =+ y
#   x =* y
#   x =! y
#
#   # good
#   x -= y # or x = -y
#   x += y # or x = +y
#   x *= y # or x = *y
#   x != y # or x = !y
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#21
class RuboCop::Cop::Lint::AmbiguousAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_asgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#30
  def on_lvasgn(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#44
  def rhs(node); end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#28
RuboCop::Cop::Lint::AmbiguousAssignment::MISTAKES = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#24
RuboCop::Cop::Lint::AmbiguousAssignment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/ambiguous_assignment.rb#26
RuboCop::Cop::Lint::AmbiguousAssignment::SIMPLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# Checks for ambiguous block association with method
# when param passed without parentheses.
#
# This cop can customize allowed methods with `AllowedMethods`.
# By default, there are no methods to allowed.
#
# @example
#
#   # bad
#   some_method a { |val| puts val }
#
#   # good
#   # With parentheses, there's no ambiguity.
#   some_method(a { |val| puts val })
#   # or (different meaning)
#   some_method(a) { |val| puts val }
#
#   # good
#   # Operator methods require no disambiguation
#   foo == bar { |b| b.baz }
#
#   # good
#   # Lambda arguments require no disambiguation
#   foo = ->(bar) { bar.baz }
# @example AllowedMethods: [] (default)
#
#   # bad
#   expect { do_something }.to change { object.attribute }
# @example AllowedMethods: [change]
#
#   # good
#   expect { do_something }.to change { object.attribute }
# @example AllowedPatterns: [] (default)
#
#   # bad
#   expect { do_something }.to change { object.attribute }
# @example AllowedPatterns: ['change']
#
#   # good
#   expect { do_something }.to change { object.attribute }
#   expect { do_something }.to not_change { object.attribute }
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#52
class RuboCop::Cop::Lint::AmbiguousBlockAssociation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#62
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#62
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#83
  def allowed_method_pattern?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#79
  def ambiguous_block_association?(send_node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#89
  def message(send_node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#95
  def wrap_in_parentheses(corrector, node); end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_block_association.rb#58
RuboCop::Cop::Lint::AmbiguousBlockAssociation::MSG = T.let(T.unsafe(nil), String)

# Checks for ambiguous operators in the first argument of a
# method invocation without parentheses.
#
# @example
#
#   # bad
#
#   # The `*` is interpreted as a splat operator but it could possibly be
#   # a `*` method invocation (i.e. `do_something.*(some_array)`).
#   do_something *some_array
#
#   # good
#
#   # With parentheses, there's no ambiguity.
#   do_something(*some_array)
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#21
class RuboCop::Cop::Lint::AmbiguousOperator < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#43
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#62
  def find_offense_node_by(diagnostic); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#80
  def message(diagnostic); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#90
  def offense_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#86
  def offense_position?(node, diagnostic); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#99
  def unary_operator?(node, diagnostic); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#39
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#24
RuboCop::Cop::Lint::AmbiguousOperator::AMBIGUITIES = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator.rb#34
RuboCop::Cop::Lint::AmbiguousOperator::MSG_FORMAT = T.let(T.unsafe(nil), String)

# Looks for expressions containing multiple binary operators
# where precedence is ambiguous due to lack of parentheses. For example,
# in `1 + 2 * 3`, the multiplication will happen before the addition, but
# lexically it appears that the addition will happen first.
#
# The cop does not consider unary operators (ie. `!a` or `-b`) or comparison
# operators (ie. `a =~ b`) because those are not ambiguous.
#
# NOTE: Ranges are handled by `Lint/AmbiguousRange`.
#
# @example
#   # bad
#   a + b * c
#   a || b && c
#   a ** b + c
#
#   # good (different precedence)
#   a + (b * c)
#   a || (b && c)
#   (a ** b) + c
#
#   # good (same precedence)
#   a + b + c
#   a * b / c % d
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#30
class RuboCop::Cop::Lint::AmbiguousOperatorPrecedence < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#54
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#47
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#65
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#105
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#89
  def greater_precedence?(node1, node2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#85
  def operator?(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#97
  def operator_name(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#79
  def precedence(node); end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#45
RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::MSG = T.let(T.unsafe(nil), String)

# See https://ruby-doc.org/core-3.0.2/doc/syntax/precedence_rdoc.html
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#34
RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::PRECEDENCE = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/ambiguous_operator_precedence.rb#44
RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for ambiguous ranges.
#
# Ranges have quite low precedence, which leads to unexpected behavior when
# using a range with other operators. This cop avoids that by making ranges
# explicit by requiring parenthesis around complex range boundaries (anything
# that is not a literal: numerics, strings, symbols, etc.).
#
# This cop can be configured with `RequireParenthesesForMethodChains` in order to
# specify whether method chains (including `self.foo`) should be wrapped in parens
# by this cop.
#
# NOTE: Regardless of this configuration, if a method receiver is a basic literal
# value, it will be wrapped in order to prevent the ambiguity of `1..2.to_a`.
#
# @example
#   # bad
#   x || 1..2
#   (x || 1..2)
#   1..2.to_a
#
#   # good, unambiguous
#   1..2
#   'a'..'z'
#   :bar..:baz
#   MyClass::MIN..MyClass::MAX
#   @min..@max
#   a..b
#   -a..b
#
#   # good, ambiguity removed
#   x || (1..2)
#   (x || 1)..2
#   (x || 1)..(y || 2)
#   (1..2).to_a
# @example RequireParenthesesForMethodChains: false (default)
#   # good
#   a.foo..b.bar
#   (a.foo)..(b.bar)
# @example RequireParenthesesForMethodChains: true
#   # bad
#   a.foo..b.bar
#
#   # good
#   (a.foo)..(b.bar)
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#59
class RuboCop::Cop::Lint::AmbiguousRange < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#64
  def on_erange(node); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#64
  def on_irange(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#82
  def acceptable?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#89
  def acceptable_call?(node); end

  # @yield [range.begin]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#77
  def each_boundary(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#99
  def require_parentheses_for_method_chain?; end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_range.rb#62
RuboCop::Cop::Lint::AmbiguousRange::MSG = T.let(T.unsafe(nil), String)

# Checks for ambiguous regexp literals in the first argument of
# a method invocation without parentheses.
#
# @example
#
#   # bad
#
#   # This is interpreted as a method invocation with a regexp literal,
#   # but it could possibly be `/` method invocations.
#   # (i.e. `do_something./(pattern)./(i)`)
#   do_something /pattern/i
#
#   # good
#
#   # With parentheses, there's no ambiguity.
#   do_something(/pattern/i)
#
# source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#22
class RuboCop::Cop::Lint::AmbiguousRegexpLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#29
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#54
  def find_offense_node(node, regexp_receiver); end

  # source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#47
  def find_offense_node_by(diagnostic); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#65
  def first_argument_is_regexp?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#69
  def method_chain_to_regexp_receiver?(node, regexp_receiver); end
end

# source://rubocop//lib/rubocop/cop/lint/ambiguous_regexp_literal.rb#25
RuboCop::Cop::Lint::AmbiguousRegexpLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks for assignments in the conditions of
# if/while/until.
#
# `AllowSafeAssignment` option for safe assignment.
# By safe assignment we mean putting parentheses around
# an assignment to indicate "I know I'm using an assignment
# as a condition. It's not a mistake."
#
# @example
#   # bad
#   if some_var = value
#   do_something
#   end
#
#   # good
#   if some_var == value
#   do_something
#   end
# @example AllowSafeAssignment: true (default)
#   # good
#   if (some_var = value)
#   do_something
#   end
# @example AllowSafeAssignment: false
#   # bad
#   if (some_var = value)
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#41
class RuboCop::Cop::Lint::AssignmentInCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SafeAssignment
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#55
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#55
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#55
  def on_while(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#82
  def allowed_construct?(asgn_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#86
  def conditional_assignment?(asgn_node); end

  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#74
  def message(_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#90
  def skip_children?(asgn_node); end

  # source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#96
  def traverse_node(node, &block); end
end

# source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#53
RuboCop::Cop::Lint::AssignmentInCondition::ASGN_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#50
RuboCop::Cop::Lint::AssignmentInCondition::MSG_WITHOUT_SAFE_ASSIGNMENT_ALLOWED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/assignment_in_condition.rb#46
RuboCop::Cop::Lint::AssignmentInCondition::MSG_WITH_SAFE_ASSIGNMENT_ALLOWED = T.let(T.unsafe(nil), String)

# `BigDecimal.new()` is deprecated since BigDecimal 1.3.3.
# This cop identifies places where `BigDecimal.new()`
# can be replaced by `BigDecimal()`.
#
# @example
#   # bad
#   BigDecimal.new(123.456, 3)
#
#   # good
#   BigDecimal(123.456, 3)
#
# source://rubocop//lib/rubocop/cop/lint/big_decimal_new.rb#17
class RuboCop::Cop::Lint::BigDecimalNew < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/big_decimal_new.rb#25
  def big_decimal_new(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/big_decimal_new.rb#30
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/big_decimal_new.rb#20
RuboCop::Cop::Lint::BigDecimalNew::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/big_decimal_new.rb#22
RuboCop::Cop::Lint::BigDecimalNew::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where binary operator has identical operands.
#
# It covers arithmetic operators: `-`, `/`, `%`;
# comparison operators: `==`, `===`, `=~`, `>`, `>=`, `<`, ``<=``;
# bitwise operators: `|`, `^`, `&`;
# boolean operators: `&&`, `||`
# and "spaceship" operator - ``<=>``.
#
# Simple arithmetic operations are allowed by this cop: `+`, `*`, `**`, `<<` and `>>`.
# Although these can be rewritten in a different way, it should not be necessary to
# do so. This does not include operations such as `-` or `/` where the result will
# always be the same (`x - x` will always be 0; `x / x` will always be 1), and
# thus are legitimate offenses.
#
# @example
#   # bad
#   x / x
#   x.top >= x.top
#
#   if a.x != 0 && a.x != 0
#   do_something
#   end
#
#   def child?
#   left_child || left_child
#   end
#
#   # good
#   x + x
#   1 << 1
#
# source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#48
class RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#61
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#61
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#52
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#50
RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands::ALLOWED_MATH_OPERATORS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/binary_operator_with_identical_operands.rb#49
RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands::MSG = T.let(T.unsafe(nil), String)

# Checks for `:true` and `:false` symbols.
# In most cases it would be a typo.
#
# @example
#
#   # bad
#   :true
#
#   # good
#   true
#
#   # bad
#   :false
#
#   # good
#   false
#
# source://rubocop//lib/rubocop/cop/lint/boolean_symbol.rb#27
class RuboCop::Cop::Lint::BooleanSymbol < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/boolean_symbol.rb#33
  def boolean_symbol?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/boolean_symbol.rb#35
  def on_sym(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/boolean_symbol.rb#48
  def autocorrect(corrector, node); end
end

# source://rubocop//lib/rubocop/cop/lint/boolean_symbol.rb#30
RuboCop::Cop::Lint::BooleanSymbol::MSG = T.let(T.unsafe(nil), String)

# Checks for circular argument references in optional keyword
# arguments and optional ordinal arguments.
#
# This cop mirrors a warning produced by MRI since 2.2.
#
# @example
#
#   # bad
#   def bake(pie: pie)
#   pie.heat_up
#   end
#
#   # good
#   def bake(pie:)
#   pie.refrigerate
#   end
#
#   # good
#   def bake(pie: self.pie)
#   pie.feed_to(user)
#   end
#
#   # bad
#   def cook(dry_ingredients = dry_ingredients)
#   dry_ingredients.reduce(&:+)
#   end
#
#   # good
#   def cook(dry_ingredients = self.dry_ingredients)
#   dry_ingredients.combine
#   end
#
# source://rubocop//lib/rubocop/cop/lint/circular_argument_reference.rb#37
class RuboCop::Cop::Lint::CircularArgumentReference < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/circular_argument_reference.rb#40
  def on_kwoptarg(node); end

  # source://rubocop//lib/rubocop/cop/lint/circular_argument_reference.rb#44
  def on_optarg(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/circular_argument_reference.rb#50
  def check_for_circular_argument_references(arg_name, arg_value); end
end

# source://rubocop//lib/rubocop/cop/lint/circular_argument_reference.rb#38
RuboCop::Cop::Lint::CircularArgumentReference::MSG = T.let(T.unsafe(nil), String)

# Do not define constants within a block, since the block's scope does not
# isolate or namespace the constant in any way.
#
# If you are trying to define that constant once, define it outside of
# the block instead, or use a variable or method if defining the constant
# in the outer scope would be problematic.
#
# For meta-programming, use `const_set`.
#
# @example
#   # bad
#   task :lint do
#   FILES_TO_LINT = Dir['lib/*.rb']
#   end
#
#   # bad
#   describe 'making a request' do
#   class TestRequest; end
#   end
#
#   # bad
#   module M
#   extend ActiveSupport::Concern
#   included do
#   LIST = []
#   end
#   end
#
#   # good
#   task :lint do
#   files_to_lint = Dir['lib/*.rb']
#   end
#
#   # good
#   describe 'making a request' do
#   let(:test_request) { Class.new }
#   # see also `stub_const` for RSpec
#   end
#
#   # good
#   module M
#   extend ActiveSupport::Concern
#   included do
#   const_set(:LIST, [])
#   end
#   end
# @example AllowedMethods: ['enums'] (default)
#   # good
#
#   # `enums` for Typed Enums via `T::Enum` in Sorbet.
#   # https://sorbet.org/docs/tenum
#   class TestEnum < T::Enum
#   enums do
#   Foo = new("foo")
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#64
class RuboCop::Cop::Lint::ConstantDefinitionInBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#70
  def constant_assigned_in_block?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#75
  def module_defined_in_block?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#79
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#85
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#85
  def on_module(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#94
  def method_name(node); end
end

# source://rubocop//lib/rubocop/cop/lint/constant_definition_in_block.rb#67
RuboCop::Cop::Lint::ConstantDefinitionInBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for overwriting an exception with an exception result by use ``rescue =>``.
#
# You intended to write as `rescue StandardError`.
# However, you have written `rescue => StandardError`.
# In that case, the result of `rescue` will overwrite `StandardError`.
#
# @example
#
#   # bad
#   begin
#   something
#   rescue => StandardError
#   end
#
#   # good
#   begin
#   something
#   rescue StandardError
#   end
#
# source://rubocop//lib/rubocop/cop/lint/constant_overwritten_in_rescue.rb#26
class RuboCop::Cop::Lint::ConstantOverwrittenInRescue < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/constant_overwritten_in_rescue.rb#41
  def on_resbody(node); end

  # source://rubocop//lib/rubocop/cop/lint/constant_overwritten_in_rescue.rb#33
  def overwritten_constant(param0 = T.unsafe(nil)); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/constant_overwritten_in_rescue.rb#37
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/constant_overwritten_in_rescue.rb#30
RuboCop::Cop::Lint::ConstantOverwrittenInRescue::MSG = T.let(T.unsafe(nil), String)

# Check that certain constants are fully qualified.
#
# This is not enabled by default because it would mark a lot of offenses
# unnecessarily.
#
# Generally, gems should fully qualify all constants to avoid conflicts with
# the code that uses the gem. Enable this cop without using `Only`/`Ignore`
#
# Large projects will over time end up with one or two constant names that
# are problematic because of a conflict with a library or just internally
# using the same name a namespace and a class. To avoid too many unnecessary
# offenses, Enable this cop with `Only: [The, Constant, Names, Causing, Issues]`
#
# NOTE: `Style/RedundantConstantBase` cop is disabled if this cop is enabled to prevent
# conflicting rules. Because it respects user configurations that want to enable
# this cop which is disabled by default.
#
# @example
#   # By default checks every constant
#
#   # bad
#   User
#
#   # bad
#   User::Login
#
#   # good
#   ::User
#
#   # good
#   ::User::Login
# @example Only: ['Login']
#   # Restrict this cop to only being concerned about certain constants
#
#   # bad
#   Login
#
#   # good
#   ::Login
#
#   # good
#   User::Login
# @example Ignore: ['Login']
#   # Restrict this cop not being concerned about certain constants
#
#   # bad
#   User
#
#   # good
#   ::User::Login
#
#   # good
#   Login
#
# source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#62
class RuboCop::Cop::Lint::ConstantResolution < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#70
  def on_const(node); end

  # source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#66
  def unqualified_const?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#83
  def allowed_names; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#78
  def const_name?(name); end

  # source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#87
  def ignored_names; end
end

# source://rubocop//lib/rubocop/cop/lint/constant_resolution.rb#63
RuboCop::Cop::Lint::ConstantResolution::MSG = T.let(T.unsafe(nil), String)

# Checks for debug calls (such as `debugger` or `binding.pry`) that should
# not be kept for production code.
#
# The cop can be configured using `DebuggerMethods`. By default, a number of gems
# debug entrypoints are configured (`Kernel`, `Byebug`, `Capybara`, `debug.rb`,
# `Pry`, `Rails`, `RubyJard`, and `WebConsole`). Additional methods can be added.
#
# Specific default groups can be disabled if necessary:
#
# [source,yaml]
# ----
# Lint/Debugger:
#   DebuggerMethods:
#     WebConsole: ~
# ----
#
# You can also add your own methods by adding a new category:
#
# [source,yaml]
# ----
# Lint/Debugger:
#   DebuggerMethods:
#     MyDebugger:
#       MyDebugger.debug_this
# ----
#
# Some gems also ship files that will start a debugging session when required,
# for example `require 'debug/start'` from `ruby/debug`. These requires can
# be configured through `DebuggerRequires`. It has the same structure as
# `DebuggerMethods`, which you can read about above.
#
# @example
#
#   # bad (ok during development)
#
#   # using pry
#   def some_method
#   binding.pry
#   do_something
#   end
#
#   # bad (ok during development)
#
#   # using byebug
#   def some_method
#   byebug
#   do_something
#   end
#
#   # good
#
#   def some_method
#   do_something
#   end
# @example DebuggerMethods: [my_debugger]
#
#   # bad (ok during development)
#
#   def some_method
#   my_debugger
#   end
# @example DebuggerRequires: [my_debugger/start]
#
#   # bad (ok during development)
#
#   require 'my_debugger/start'
#
# source://rubocop//lib/rubocop/cop/lint/debugger.rb#74
class RuboCop::Cop::Lint::Debugger < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#78
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#138
  def assumed_argument?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#117
  def assumed_usage_context?(node); end

  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#127
  def chained_method_name(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#104
  def debugger_method?(send_node); end

  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#90
  def debugger_methods; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#110
  def debugger_require?(send_node); end

  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#97
  def debugger_requires; end

  # source://rubocop//lib/rubocop/cop/lint/debugger.rb#86
  def message(node); end
end

# source://rubocop//lib/rubocop/cop/lint/debugger.rb#76
RuboCop::Cop::Lint::Debugger::BLOCK_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/debugger.rb#75
RuboCop::Cop::Lint::Debugger::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of the deprecated class method usages.
#
# @example
#
#   # bad
#   File.exists?(some_path)
#   Dir.exists?(some_path)
#   iterator?
#   attr :name, true
#   attr :name, false
#   ENV.freeze # Calling `Env.freeze` raises `TypeError` since Ruby 2.7.
#   ENV.clone
#   ENV.dup # Calling `Env.dup` raises `TypeError` since Ruby 3.1.
#   Socket.gethostbyname(host)
#   Socket.gethostbyaddr(host)
#
#   # good
#   File.exist?(some_path)
#   Dir.exist?(some_path)
#   block_given?
#   attr_accessor :name
#   attr_reader :name
#   ENV # `ENV.freeze` cannot prohibit changes to environment variables.
#   ENV.to_h
#   ENV.to_h # `ENV.dup` cannot dup `ENV`, use `ENV.to_h` to get a copy of `ENV` as a hash.
#   Addrinfo.getaddrinfo(nodename, service)
#   Addrinfo.tcp(host, port).getnameinfo
#
# source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#33
class RuboCop::Cop::Lint::DeprecatedClassMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#53
  def deprecated_class_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#63
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#112
  def dir_env_file_const?(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#83
  def offense_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#93
  def preferred_method(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#108
  def socket_const?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#50
RuboCop::Cop::Lint::DeprecatedClassMethods::DIR_ENV_FILE_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#36
RuboCop::Cop::Lint::DeprecatedClassMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#41
RuboCop::Cop::Lint::DeprecatedClassMethods::PREFERRED_METHODS = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/deprecated_class_methods.rb#37
RuboCop::Cop::Lint::DeprecatedClassMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for deprecated constants.
#
# It has `DeprecatedConstants` config. If there is an alternative method, you can set
# alternative value as `Alternative`. And you can set the deprecated version as
# `DeprecatedVersion`. These options can be omitted if they are not needed.
#
#   DeprecatedConstants:
#     'DEPRECATED_CONSTANT':
#       Alternative: 'alternative_value'
#       DeprecatedVersion: 'deprecated_version'
#
# By default, `NIL`, `TRUE`, `FALSE`, `Net::HTTPServerException, `Random::DEFAULT`,
# `Struct::Group`, and `Struct::Passwd` are configured.
#
# @example
#
#   # bad
#   NIL
#   TRUE
#   FALSE
#   Net::HTTPServerException
#   Random::DEFAULT # Return value of Ruby 2 is `Random` instance, Ruby 3.0 is `Random` class.
#   Struct::Group
#   Struct::Passwd
#
#   # good
#   nil
#   true
#   false
#   Net::HTTPClientException
#   Random.new # `::DEFAULT` has been deprecated in Ruby 3, `.new` is compatible with Ruby 2.
#   Etc::Group
#   Etc::Passwd
#
# source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#40
class RuboCop::Cop::Lint::DeprecatedConstants < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#46
  def on_const(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#66
  def constant_name(node, nested_constant_name); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#82
  def deprecated_constants; end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#72
  def message(good, bad, deprecated_version); end
end

# source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#44
RuboCop::Cop::Lint::DeprecatedConstants::DO_NOT_USE_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/deprecated_constants.rb#43
RuboCop::Cop::Lint::DeprecatedConstants::SUGGEST_GOOD_MSG = T.let(T.unsafe(nil), String)

# Algorithmic constants for `OpenSSL::Cipher` and `OpenSSL::Digest`
# deprecated since OpenSSL version 2.2.0. Prefer passing a string
# instead.
#
# @example
#
#   # bad
#   OpenSSL::Cipher::AES.new(128, :GCM)
#
#   # good
#   OpenSSL::Cipher.new('aes-128-gcm')
#
#   # bad
#   OpenSSL::Digest::SHA256.new
#
#   # good
#   OpenSSL::Digest.new('SHA256')
#
#   # bad
#   OpenSSL::Digest::SHA256.digest('foo')
#
#   # good
#   OpenSSL::Digest.digest('SHA256', 'foo')
#
# source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#30
class RuboCop::Cop::Lint::DeprecatedOpenSSLConstant < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#39
  def algorithm_const(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#49
  def digest_const?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#53
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#100
  def algorithm_name(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#65
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#129
  def build_cipher_arguments(node, algorithm_name, no_arguments); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#92
  def correction_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#77
  def message(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#96
  def openssl_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#118
  def replacement_args(node); end

  # source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#110
  def sanitize_arguments(arguments); end
end

# source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#34
RuboCop::Cop::Lint::DeprecatedOpenSSLConstant::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/deprecated_open_ssl_constant.rb#36
RuboCop::Cop::Lint::DeprecatedOpenSSLConstant::NO_ARG_ALGORITHM = T.let(T.unsafe(nil), Array)

# Checks constructors for disjunctive assignments (`||=`) that should
# be plain assignments.
#
# So far, this cop is only concerned with disjunctive assignment of
# instance variables.
#
# In ruby, an instance variable is nil until a value is assigned, so the
# disjunction is unnecessary. A plain assignment has the same effect.
#
# @example
#   # bad
#   def initialize
#   @x ||= 1
#   end
#
#   # good
#   def initialize
#   @x = 1
#   end
#
# source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#48
class RuboCop::Cop::Lint::DisjunctiveAssignmentInConstructor < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#53
  def on_def(node); end

  private

  # @param node [DefNode] a constructor definition
  #
  # source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#60
  def check(node); end

  # source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#66
  def check_body(body); end

  # @param lines [Array] the logical lines of the constructor
  #
  # source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#78
  def check_body_lines(lines); end

  # Add an offense if the LHS of the given disjunctive assignment is
  # an instance variable.
  #
  # For now, we only care about assignments to instance variables.
  #
  # @param node [Node] a disjunctive assignment
  #
  # source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#99
  def check_disjunctive_assignment(node); end
end

# source://rubocop//lib/rubocop/cop/lint/disjunctive_assignment_in_constructor.rb#51
RuboCop::Cop::Lint::DisjunctiveAssignmentInConstructor::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated bodies
# within `if/unless`, `case-when`, `case-in` and `rescue` constructs.
#
# With `IgnoreLiteralBranches: true`, branches are not registered
# as offenses if they return a basic literal value (string, symbol,
# integer, float, rational, complex, `true`, `false`, or `nil`), or
# return an array, hash, regexp or range that only contains one of
# the above basic literal values.
#
# With `IgnoreConstantBranches: true`, branches are not registered
# as offenses if they return a constant value.
#
# @example
#   # bad
#   if foo
#   do_foo
#   do_something_else
#   elsif bar
#   do_foo
#   do_something_else
#   end
#
#   # good
#   if foo || bar
#   do_foo
#   do_something_else
#   end
#
#   # bad
#   case x
#   when foo
#   do_foo
#   when bar
#   do_foo
#   else
#   do_something_else
#   end
#
#   # good
#   case x
#   when foo, bar
#   do_foo
#   else
#   do_something_else
#   end
#
#   # bad
#   begin
#   do_something
#   rescue FooError
#   handle_error
#   rescue BarError
#   handle_error
#   end
#
#   # good
#   begin
#   do_something
#   rescue FooError, BarError
#   handle_error
#   end
# @example IgnoreLiteralBranches: true
#   # good
#   case size
#   when "small" then 100
#   when "medium" then 250
#   when "large" then 1000
#   else 250
#   end
# @example IgnoreConstantBranches: true
#   # good
#   case size
#   when "small" then SMALL_SIZE
#   when "medium" then MEDIUM_SIZE
#   when "large" then LARGE_SIZE
#   else MEDIUM_SIZE
#   end
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#86
class RuboCop::Cop::Lint::DuplicateBranch < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#89
  def on_branching_statement(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#89
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#89
  def on_case_match(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#89
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#89
  def on_rescue(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#117
  def branches(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#121
  def consider_branch?(branch); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#147
  def const_branch?(branch); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#132
  def ignore_constant_branches?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#128
  def ignore_literal_branches?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#136
  def literal_branch?(branch); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#103
  def offense_range(duplicate_branch); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_branch.rb#87
RuboCop::Cop::Lint::DuplicateBranch::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated conditions
# used in case 'when' expressions.
#
# @example
#
#   # bad
#   case x
#   when 'first'
#   do_something
#   when 'first'
#   do_something_else
#   end
#
#   # good
#   case x
#   when 'first'
#   do_something
#   when 'second'
#   do_something_else
#   end
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_case_condition.rb#26
class RuboCop::Cop::Lint::DuplicateCaseCondition < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/duplicate_case_condition.rb#29
  def on_case(case_node); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_case_condition.rb#27
RuboCop::Cop::Lint::DuplicateCaseCondition::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated conditions used in if 'elsif'.
#
# @example
#   # bad
#   if x == 1
#   do_something
#   elsif x == 1
#   do_something_else
#   end
#
#   # good
#   if x == 1
#   do_something
#   elsif x == 2
#   do_something_else
#   end
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_elsif_condition.rb#23
class RuboCop::Cop::Lint::DuplicateElsifCondition < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/duplicate_elsif_condition.rb#26
  def on_if(node); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_elsif_condition.rb#24
RuboCop::Cop::Lint::DuplicateElsifCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for duplicated keys in hash literals.
# This cop considers both primitive types and constants for the hash keys.
#
# This cop mirrors a warning in Ruby 2.2.
#
# @example
#
#   # bad
#   hash = { food: 'apple', food: 'orange' }
#
#   # good
#   hash = { food: 'apple', other_food: 'orange' }
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_hash_key.rb#18
class RuboCop::Cop::Lint::DuplicateHashKey < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Duplication

  # source://rubocop//lib/rubocop/cop/lint/duplicate_hash_key.rb#23
  def on_hash(node); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_hash_key.rb#21
RuboCop::Cop::Lint::DuplicateHashKey::MSG = T.let(T.unsafe(nil), String)

# Checks for duplicated magic comments.
#
# @example
#
#   # bad
#
#   # encoding: ascii
#   # encoding: ascii
#
#   # good
#
#   # encoding: ascii
#
#   # bad
#
#   # frozen_string_literal: true
#   # frozen_string_literal: true
#
#   # good
#
#   # frozen_string_literal: true
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_magic_comment.rb#28
class RuboCop::Cop::Lint::DuplicateMagicComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/duplicate_magic_comment.rb#35
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/duplicate_magic_comment.rb#51
  def magic_comment_lines; end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_magic_comment.rb#65
  def register_offense(range); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_magic_comment.rb#33
RuboCop::Cop::Lint::DuplicateMagicComment::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated patterns used in `in` keywords.
#
# @example
#
#   # bad
#   case x
#   in 'first'
#   do_something
#   in 'first'
#   do_something_else
#   end
#
#   # good
#   case x
#   in 'first'
#   do_something
#   in 'second'
#   do_something_else
#   end
#
#   # bad - repeated alternate patterns with the same conditions don't depend on the order
#   case x
#   in foo | bar
#   first_method
#   in bar | foo
#   second_method
#   end
#
#   # good
#   case x
#   in foo | bar
#   first_method
#   in bar | baz
#   second_method
#   end
#
#   # bad - repeated hash patterns with the same conditions don't depend on the order
#   case x
#   in foo: a, bar: b
#   first_method
#   in bar: b, foo: a
#   second_method
#   end
#
#   # good
#   case x
#   in foo: a, bar: b
#   first_method
#   in bar: b, baz: c
#   second_method
#   end
#
#   # bad - repeated array patterns with elements in the same order
#   case x
#   in [foo, bar]
#   first_method
#   in [foo, bar]
#   second_method
#   end
#
#   # good
#   case x
#   in [foo, bar]
#   first_method
#   in [bar, foo]
#   second_method
#   end
#
#   # bad - repeated the same patterns and guard conditions
#   case x
#   in foo if bar
#   first_method
#   in foo if bar
#   second_method
#   end
#
#   # good
#   case x
#   in foo if bar
#   first_method
#   in foo if baz
#   second_method
#   end
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_match_pattern.rb#90
class RuboCop::Cop::Lint::DuplicateMatchPattern < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/duplicate_match_pattern.rb#97
  def on_case_match(case_node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/duplicate_match_pattern.rb#108
  def pattern_identity(pattern); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_match_pattern.rb#93
RuboCop::Cop::Lint::DuplicateMatchPattern::MSG = T.let(T.unsafe(nil), String)

# Checks for duplicated instance (or singleton) method
# definitions.
#
# @example
#
#   # bad
#   def foo
#   1
#   end
#
#   def foo
#   2
#   end
#
#   # bad
#   def foo
#   1
#   end
#
#   alias foo bar
#
#   # good
#   def foo
#   1
#   end
#
#   def bar
#   2
#   end
#
#   # good
#   def foo
#   1
#   end
#
#   alias bar foo
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#42
class RuboCop::Cop::Lint::DuplicateMethods < ::RuboCop::Cop::Base
  # @return [DuplicateMethods] a new instance of DuplicateMethods
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#47
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#88
  def alias_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#75
  def method_alias?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#79
  def on_alias(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#53
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#62
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#94
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#93
  def sym_name(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#107
  def check_const_receiver(node, name, const_name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#114
  def check_self_receiver(node, name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#198
  def found_attr(node, args, readable: T.unsafe(nil), writable: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#126
  def found_instance_method(node, name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#149
  def found_method(node, method_name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#139
  def found_sclass_method(node, name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#176
  def location(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#208
  def lookup_constant(node, const_name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#121
  def message_for_dup(node, method_name, key); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#168
  def method_key(node, method_name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#184
  def on_attr(node, attr_name, args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#240
  def possible_dsl?(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#226
  def qualified_name(enclosing, namespace, mod_name); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#250
  def source_location(node); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#45
RuboCop::Cop::Lint::DuplicateMethods::DEF_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#43
RuboCop::Cop::Lint::DuplicateMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/duplicate_methods.rb#44
RuboCop::Cop::Lint::DuplicateMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for duplicate elements in Regexp character classes.
#
# @example
#
#   # bad
#   r = /[xyx]/
#
#   # bad
#   r = /[0-9x0-9]/
#
#   # good
#   r = /[xy]/
#
#   # good
#   r = /[0-9x]/
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#21
class RuboCop::Cop::Lint::DuplicateRegexpCharacterClassElement < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#37
  def each_repeated_character_class_element_loc(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#29
  def on_regexp(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#102
  def escaped_octal?(string); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#54
  def group_expressions(node, expressions); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#110
  def interpolation_locs(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#106
  def octal?(char); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#71
  def pop_octal_digits(current_child, expressions); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#89
  def skip_expression?(expr); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#80
  def source_range(children); end

  # Since we blank interpolations with a space for every char of the interpolation, we would
  # mark every space (except the first) as duplicate if we do not skip regexp_parser nodes
  # that are within an interpolation.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#96
  def within_interpolation?(node, child); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#25
RuboCop::Cop::Lint::DuplicateRegexpCharacterClassElement::MSG_REPEATED_ELEMENT = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/duplicate_regexp_character_class_element.rb#27
RuboCop::Cop::Lint::DuplicateRegexpCharacterClassElement::OCTAL_DIGITS_AFTER_ESCAPE = T.let(T.unsafe(nil), Integer)

# Checks for duplicate ``require``s and ``require_relative``s.
#
# @example
#   # bad
#   require 'foo'
#   require 'bar'
#   require 'foo'
#
#   # good
#   require 'foo'
#   require 'bar'
#
#   # good
#   require 'foo'
#   require_relative 'foo'
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#26
class RuboCop::Cop::Lint::DuplicateRequire < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#39
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#45
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#35
  def require_call?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#30
RuboCop::Cop::Lint::DuplicateRequire::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#31
RuboCop::Cop::Lint::DuplicateRequire::REQUIRE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/duplicate_require.rb#32
RuboCop::Cop::Lint::DuplicateRequire::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Checks that there are no repeated exceptions
# used in 'rescue' expressions.
#
# @example
#   # bad
#   begin
#   something
#   rescue FirstException
#   handle_exception
#   rescue FirstException
#   handle_other_exception
#   end
#
#   # good
#   begin
#   something
#   rescue FirstException
#   handle_exception
#   rescue SecondException
#   handle_other_exception
#   end
#
# source://rubocop//lib/rubocop/cop/lint/duplicate_rescue_exception.rb#28
class RuboCop::Cop::Lint::DuplicateRescueException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode

  # source://rubocop//lib/rubocop/cop/lint/duplicate_rescue_exception.rb#33
  def on_rescue(node); end
end

# source://rubocop//lib/rubocop/cop/lint/duplicate_rescue_exception.rb#31
RuboCop::Cop::Lint::DuplicateRescueException::MSG = T.let(T.unsafe(nil), String)

# Checks if each_with_object is called with an immutable
# argument. Since the argument is the object that the given block shall
# make calls on to build something based on the enumerable that
# each_with_object iterates over, an immutable argument makes no sense.
# It's definitely a bug.
#
# @example
#
#   # bad
#   sum = numbers.each_with_object(0) { |e, a| a += e }
#
#   # good
#   num = 0
#   sum = numbers.each_with_object(num) { |e, a| a += e }
#
# source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#20
class RuboCop::Cop::Lint::EachWithObjectArgument < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#25
  def each_with_object?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#29
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#29
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#21
RuboCop::Cop::Lint::EachWithObjectArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/each_with_object_argument.rb#22
RuboCop::Cop::Lint::EachWithObjectArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for odd `else` block layout - like
# having an expression on the same line as the `else` keyword,
# which is usually a mistake.
#
# Its autocorrection tweaks layout to keep the syntax. So, this autocorrection
# is compatible correction for bad case syntax, but if your code makes a mistake
# with `elsif` and `else`, you will have to correct it manually.
#
# @example
#
#   # bad
#
#   if something
#   # ...
#   else do_this
#   do_that
#   end
#
#   # good
#
#   # This code is compatible with the bad case. It will be autocorrected like this.
#   if something
#   # ...
#   else
#   do_this
#   do_that
#   end
#
#   # This code is incompatible with the bad case.
#   # If `do_this` is a condition, `elsif` should be used instead of `else`.
#   if something
#   # ...
#   elsif do_this
#   do_that
#   end
#
# source://rubocop//lib/rubocop/cop/lint/else_layout.rb#41
class RuboCop::Cop::Lint::ElseLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/else_layout.rb#48
  def on_if(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/else_layout.rb#79
  def autocorrect(corrector, node, first_else); end

  # source://rubocop//lib/rubocop/cop/lint/else_layout.rb#59
  def check(node); end

  # source://rubocop//lib/rubocop/cop/lint/else_layout.rb#69
  def check_else(node); end
end

# source://rubocop//lib/rubocop/cop/lint/else_layout.rb#46
RuboCop::Cop::Lint::ElseLayout::MSG = T.let(T.unsafe(nil), String)

# Checks for blocks without a body.
# Such empty blocks are typically an oversight or we should provide a comment
# to clarify what we're aiming for.
#
# Empty lambdas and procs are ignored by default.
#
# NOTE: For backwards compatibility, the configuration that allows/disallows
# empty lambdas and procs is called `AllowEmptyLambdas`, even though it also
# applies to procs.
#
# @example
#   # bad
#   items.each { |item| }
#
#   # good
#   items.each { |item| puts item }
# @example AllowComments: true (default)
#   # good
#   items.each do |item|
#   # TODO: implement later (inner comment)
#   end
#
#   items.each { |item| } # TODO: implement later (inline comment)
# @example AllowComments: false
#   # bad
#   items.each do |item|
#   # TODO: implement later (inner comment)
#   end
#
#   items.each { |item| } # TODO: implement later (inline comment)
# @example AllowEmptyLambdas: true (default)
#   # good
#   allow(subject).to receive(:callable).and_return(-> {})
#
#   placeholder = lambda do
#   end
#   (callable || placeholder).call
#
#   proc { }
#
#   Proc.new { }
# @example AllowEmptyLambdas: false
#   # bad
#   allow(subject).to receive(:callable).and_return(-> {})
#
#   placeholder = lambda do
#   end
#   (callable || placeholder).call
#
#   proc { }
#
#   Proc.new { }
#
# source://rubocop//lib/rubocop/cop/lint/empty_block.rb#63
class RuboCop::Cop::Lint::EmptyBlock < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/empty_block.rb#66
  def on_block(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_block.rb#76
  def allow_comment?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_block.rb#83
  def allow_empty_lambdas?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_block.rb#87
  def comment_disables_cop?(comment); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_block.rb#64
RuboCop::Cop::Lint::EmptyBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for classes and metaclasses without a body.
# Such empty classes and metaclasses are typically an oversight or we should provide a comment
# to be clearer what we're aiming for.
#
# @example
#   # bad
#   class Foo
#   end
#
#   class Bar
#   class << self
#   end
#   end
#
#   class << obj
#   end
#
#   # good
#   class Foo
#   def do_something
#   # ... code
#   end
#   end
#
#   class Bar
#   class << self
#   attr_reader :bar
#   end
#   end
#
#   class << obj
#   attr_reader :bar
#   end
# @example AllowComments: false (default)
#   # bad
#   class Foo
#   # TODO: implement later
#   end
#
#   class Bar
#   class << self
#   # TODO: implement later
#   end
#   end
#
#   class << obj
#   # TODO: implement later
#   end
# @example AllowComments: true
#   # good
#   class Foo
#   # TODO: implement later
#   end
#
#   class Bar
#   class << self
#   # TODO: implement later
#   end
#   end
#
#   class << obj
#   # TODO: implement later
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_class.rb#72
class RuboCop::Cop::Lint::EmptyClass < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/empty_class.rb#76
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_class.rb#81
  def on_sclass(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_class.rb#87
  def body_or_allowed_comment_lines?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_class.rb#73
RuboCop::Cop::Lint::EmptyClass::CLASS_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/empty_class.rb#74
RuboCop::Cop::Lint::EmptyClass::METACLASS_MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `if`, `elsif` and `unless` branches without a body.
#
# NOTE: empty `else` branches are handled by `Style/EmptyElse`.
#
# @example
#   # bad
#   if condition
#   end
#
#   # bad
#   unless condition
#   end
#
#   # bad
#   if condition
#   do_something
#   elsif other_condition
#   end
#
#   # good
#   if condition
#   do_something
#   end
#
#   # good
#   unless condition
#   do_something
#   end
#
#   # good
#   if condition
#   do_something
#   elsif other_condition
#   do_something_else
#   end
# @example AllowComments: true (default)
#   # good
#   if condition
#   do_something
#   elsif other_condition
#   # noop
#   end
# @example AllowComments: false
#   # bad
#   if condition
#   do_something
#   elsif other_condition
#   # noop
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#63
class RuboCop::Cop::Lint::EmptyConditionalBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#70
  def on_if(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#156
  def all_branches_body_missing?(node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#83
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#142
  def branch_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#104
  def correct_other_branches(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#162
  def deletion_range(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#137
  def else_branch?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#131
  def empty_elsif_branch?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#123
  def empty_if_branch?(node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#89
  def remove_comments(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#96
  def remove_empty_branch(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#116
  def require_other_branches_correction?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_conditional_body.rb#68
RuboCop::Cop::Lint::EmptyConditionalBody::MSG = T.let(T.unsafe(nil), String)

# Checks for empty `ensure` blocks.
#
# @example
#
#   # bad
#   def some_method
#   do_something
#   ensure
#   end
#
#   # bad
#   begin
#   do_something
#   ensure
#   end
#
#   # good
#   def some_method
#   do_something
#   ensure
#   do_something_else
#   end
#
#   # good
#   begin
#   do_something
#   ensure
#   do_something_else
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_ensure.rb#35
class RuboCop::Cop::Lint::EmptyEnsure < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/empty_ensure.rb#40
  def on_ensure(node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_ensure.rb#38
RuboCop::Cop::Lint::EmptyEnsure::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of empty expressions.
#
# @example
#
#   # bad
#
#   foo = ()
#   if ()
#   bar
#   end
# @example
#
#   # good
#
#   foo = (some_expression)
#   if (some_expression)
#   bar
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_expression.rb#25
class RuboCop::Cop::Lint::EmptyExpression < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/empty_expression.rb#28
  def on_begin(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_expression.rb#36
  def empty_expression?(begin_node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_expression.rb#26
RuboCop::Cop::Lint::EmptyExpression::MSG = T.let(T.unsafe(nil), String)

# Enforces that Ruby source files are not empty.
#
# @example
#   # bad
#   # Empty file
#
#   # good
#   # File containing non commented source lines
# @example AllowComments: true (default)
#   # good
#   # File consisting only of comments
# @example AllowComments: false
#   # bad
#   # File consisting only of comments
#
# source://rubocop//lib/rubocop/cop/lint/empty_file.rb#23
class RuboCop::Cop::Lint::EmptyFile < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/empty_file.rb#28
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_file.rb#42
  def contains_only_comments?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_file.rb#38
  def empty_file?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/empty_file.rb#34
  def offending?; end
end

# source://rubocop//lib/rubocop/cop/lint/empty_file.rb#26
RuboCop::Cop::Lint::EmptyFile::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `in` pattern branches without a body.
#
# @example
#
#   # bad
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   end
#
#   # good
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   nil
#   end
# @example AllowComments: true (default)
#
#   # good
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   # noop
#   end
# @example AllowComments: false
#
#   # bad
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   # noop
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_in_pattern.rb#45
class RuboCop::Cop::Lint::EmptyInPattern < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/empty_in_pattern.rb#53
  def on_case_match(node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_in_pattern.rb#49
RuboCop::Cop::Lint::EmptyInPattern::MSG = T.let(T.unsafe(nil), String)

# Checks for empty interpolation.
#
# @example
#
#   # bad
#   "result is #{}"
#
#   # good
#   "result is #{some_result}"
#
# source://rubocop//lib/rubocop/cop/lint/empty_interpolation.rb#15
class RuboCop::Cop::Lint::EmptyInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/empty_interpolation.rb#21
  def on_interpolation(begin_node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_interpolation.rb#19
RuboCop::Cop::Lint::EmptyInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `when` branches without a body.
#
# @example
#
#   # bad
#   case foo
#   when bar
#   do_something
#   when baz
#   end
#
#   # good
#   case condition
#   when foo
#   do_something
#   when bar
#   nil
#   end
# @example AllowComments: true (default)
#
#   # good
#   case condition
#   when foo
#   do_something
#   when bar
#   # noop
#   end
# @example AllowComments: false
#
#   # bad
#   case condition
#   when foo
#   do_something
#   when bar
#   # do nothing
#   end
#
# source://rubocop//lib/rubocop/cop/lint/empty_when.rb#45
class RuboCop::Cop::Lint::EmptyWhen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp

  # source://rubocop//lib/rubocop/cop/lint/empty_when.rb#50
  def on_case(node); end
end

# source://rubocop//lib/rubocop/cop/lint/empty_when.rb#48
RuboCop::Cop::Lint::EmptyWhen::MSG = T.let(T.unsafe(nil), String)

# Checks for `return` from an `ensure` block.
# `return` from an ensure block is a dangerous code smell as it
# will take precedence over any exception being raised,
# and the exception will be silently thrown away as if it were rescued.
#
# If you want to rescue some (or all) exceptions, best to do it explicitly
#
# @example
#
#   # bad
#   def foo
#   do_something
#   ensure
#   cleanup
#   return self
#   end
#
#   # good
#   def foo
#   do_something
#   self
#   ensure
#   cleanup
#   end
#
#   # good
#   def foo
#   begin
#   do_something
#   rescue SomeException
#   # Let's ignore this exception
#   end
#   self
#   ensure
#   cleanup
#   end
#
# source://rubocop//lib/rubocop/cop/lint/ensure_return.rb#42
class RuboCop::Cop::Lint::EnsureReturn < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ensure_return.rb#48
  def on_ensure(node); end
end

# source://rubocop//lib/rubocop/cop/lint/ensure_return.rb#46
RuboCop::Cop::Lint::EnsureReturn::MSG = T.let(T.unsafe(nil), String)

# Emulates the following Ruby warnings in Ruby 2.6.
#
# [source,console]
# ----
# $ cat example.rb
# ERB.new('hi', nil, '-', '@output_buffer')
# $ ruby -rerb example.rb
# example.rb:1: warning: Passing safe_level with the 2nd argument of ERB.new is
# deprecated. Do not use it, and specify other arguments as keyword arguments.
# example.rb:1: warning: Passing trim_mode with the 3rd argument of ERB.new is
# deprecated. Use keyword argument like ERB.new(str, trim_mode:...) instead.
# example.rb:1: warning: Passing eoutvar with the 4th argument of ERB.new is
# deprecated. Use keyword argument like ERB.new(str, eoutvar: ...) instead.
# ----
#
# Now non-keyword arguments other than first one are softly deprecated
# and will be removed when Ruby 2.5 becomes EOL.
# `ERB.new` with non-keyword arguments is deprecated since ERB 2.2.0.
# Use `:trim_mode` and `:eoutvar` keyword arguments to `ERB.new`.
# This cop identifies places where `ERB.new(str, trim_mode, eoutvar)` can
# be replaced by `ERB.new(str, :trim_mode: trim_mode, eoutvar: eoutvar)`.
#
# @example
#   # Target codes supports Ruby 2.6 and higher only
#   # bad
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # good
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#
#   # Target codes supports Ruby 2.5 and lower only
#   # good
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # Target codes supports Ruby 2.6, 2.5 and lower
#   # bad
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # good
#   # Ruby standard library style
#   # https://github.com/ruby/ruby/commit/3406c5d
#   if ERB.instance_method(:initialize).parameters.assoc(:key) # Ruby 2.6+
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#   else
#   ERB.new(str, nil, '-', '@output_buffer')
#   end
#
#   # good
#   # Use `RUBY_VERSION` style
#   if RUBY_VERSION >= '2.6'
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#   else
#   ERB.new(str, nil, '-', '@output_buffer')
#   end
#
# source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#61
class RuboCop::Cop::Lint::ErbNewArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#81
  def erb_new_with_non_keyword_arguments(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#86
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#160
  def arguments_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#115
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#130
  def build_kwargs(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#126
  def correct_arguments?(arguments); end

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#104
  def message(positional_argument_index, arg_value); end

  # source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#147
  def override_by_legacy_args(kwargs, node); end
end

# source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#74
RuboCop::Cop::Lint::ErbNewArguments::MESSAGE_EOUTVAR = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#68
RuboCop::Cop::Lint::ErbNewArguments::MESSAGE_SAFE_LEVEL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#71
RuboCop::Cop::Lint::ErbNewArguments::MESSAGE_TRIM_MODE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/erb_new_arguments.rb#78
RuboCop::Cop::Lint::ErbNewArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for uses of flip-flop operator
# based on the Ruby Style Guide.
#
# Here is the history of flip-flops in Ruby.
# flip-flop operator is deprecated in Ruby 2.6.0 and
# the deprecation has been reverted by Ruby 2.7.0 and
# backported to Ruby 2.6.
# See: https://bugs.ruby-lang.org/issues/5400
#
# @example
#   # bad
#   (1..20).each do |x|
#   puts x if (x == 5) .. (x == 10)
#   end
#
#   # good
#   (1..20).each do |x|
#   puts x if (x >= 5) && (x <= 10)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/flip_flop.rb#25
class RuboCop::Cop::Lint::FlipFlop < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/flip_flop.rb#32
  def on_eflipflop(node); end

  # source://rubocop//lib/rubocop/cop/lint/flip_flop.rb#28
  def on_iflipflop(node); end
end

# source://rubocop//lib/rubocop/cop/lint/flip_flop.rb#26
RuboCop::Cop::Lint::FlipFlop::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of precise comparison of floating point numbers.
#
# Floating point values are inherently inaccurate, and comparing them for exact equality
# is almost never the desired semantics. Comparison via the `==/!=` operators checks
# floating-point value representation to be exactly the same, which is very unlikely
# if you perform any arithmetic operations involving precision loss.
#
#  # good - comparing against zero
#   x == 0.0
#   x != 0.0
#
#   # good
#   (x - 0.1).abs < Float::EPSILON
#
#   # good
#   tolerance = 0.0001
#   (x - 0.1).abs < tolerance
#
#   # Or some other epsilon based type of comparison:
#   # https://www.embeddeduse.com/2019/08/26/qt-compare-two-floats/
#
# @example
#   # bad
#   x == 0.1
#   x != 0.1
#
#   # good - using BigDecimal
#   x.to_d == 0.1.to_d
#
# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#35
class RuboCop::Cop::Lint::FloatComparison < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#44
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#91
  def check_numeric_returning_method(node); end

  # source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#75
  def check_send(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#53
  def float?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#68
  def literal_zero?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#38
RuboCop::Cop::Lint::FloatComparison::EQUALITY_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#40
RuboCop::Cop::Lint::FloatComparison::FLOAT_INSTANCE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#39
RuboCop::Cop::Lint::FloatComparison::FLOAT_RETURNING_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#36
RuboCop::Cop::Lint::FloatComparison::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/float_comparison.rb#42
RuboCop::Cop::Lint::FloatComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies Float literals which are, like, really really really
# really really really really really big. Too big. No-one needs Floats
# that big. If you need a float that big, something is wrong with you.
#
# @example
#
#   # bad
#   float = 3.0e400
#
#   # good
#   float = 42.9
#
# source://rubocop//lib/rubocop/cop/lint/float_out_of_range.rb#17
class RuboCop::Cop::Lint::FloatOutOfRange < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/float_out_of_range.rb#20
  def on_float(node); end
end

# source://rubocop//lib/rubocop/cop/lint/float_out_of_range.rb#18
RuboCop::Cop::Lint::FloatOutOfRange::MSG = T.let(T.unsafe(nil), String)

# This lint sees if there is a mismatch between the number of
# expected fields for format/sprintf/#% and what is actually
# passed as arguments.
#
# In addition it checks whether different formats are used in the same
# format string. Do not mix numbered, unnumbered, and named formats in
# the same format string.
#
# @example
#
#   # bad
#   format('A value: %s and another: %i', a_value)
#
#   # good
#   format('A value: %s and another: %i', a_value, another)
#
#   # bad
#   format('Unnumbered format: %s and numbered: %2$s', a_value, another)
#
#   # good
#   format('Numbered format: %1$s and numbered %2$s', a_value, another)
#
# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#27
class RuboCop::Cop::Lint::FormatParameterMismatch < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#90
  def called_on_string?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#39
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#127
  def count_format_matches(node); end

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#109
  def count_matches(node); end

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#131
  def count_percent_matches(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#119
  def countable_format?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#123
  def countable_percent?(node); end

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#143
  def expected_fields_count(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#158
  def format?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#136
  def format_method?(name, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#54
  def format_string?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#105
  def heredoc?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#58
  def invalid_format_string?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#81
  def matched_arguments_count?(expected, passed); end

  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#176
  def message(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#95
  def method_with_format_args?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#67
  def offending_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#166
  def percent?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#99
  def splat_args?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#162
  def sprintf?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#185
  def string_type?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#34
RuboCop::Cop::Lint::FormatParameterMismatch::KERNEL = T.let(T.unsafe(nil), String)

# http://rubular.com/r/CvpbxkcTzy
#
# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#29
RuboCop::Cop::Lint::FormatParameterMismatch::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#31
RuboCop::Cop::Lint::FormatParameterMismatch::MSG_INVALID = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#37
RuboCop::Cop::Lint::FormatParameterMismatch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#35
RuboCop::Cop::Lint::FormatParameterMismatch::SHOVEL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/format_parameter_mismatch.rb#36
RuboCop::Cop::Lint::FormatParameterMismatch::STRING_TYPES = T.let(T.unsafe(nil), Array)

# Prefer using `Hash#compare_by_identity` rather than using `object_id`
# for hash keys.
#
# This cop looks for hashes being keyed by objects' `object_id`, using
# one of these methods: `key?`, `has_key?`, `fetch`, `[]` and `[]=`.
#
# @example
#   # bad
#   hash = {}
#   hash[foo.object_id] = :bar
#   hash.key?(baz.object_id)
#
#   # good
#   hash = {}.compare_by_identity
#   hash[foo] = :bar
#   hash.key?(baz)
#
# source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#31
class RuboCop::Cop::Lint::HashCompareByIdentity < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#37
  def id_as_hash_key?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#41
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#41
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#34
RuboCop::Cop::Lint::HashCompareByIdentity::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/hash_compare_by_identity.rb#32
RuboCop::Cop::Lint::HashCompareByIdentity::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the ordering of a method call where
# the receiver of the call is a HEREDOC.
#
# @example
#   # bad
#   <<-SQL
#   bar
#   SQL
#   .strip_indent
#
#   <<-SQL
#   bar
#   SQL
#   .strip_indent
#   .trim
#
#   # good
#   <<~SQL
#   bar
#   SQL
#
#   <<~SQL.trim
#   bar
#   SQL
#
# source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#31
class RuboCop::Cop::Lint::HeredocMethodCallPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#37
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#37
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#97
  def all_on_same_line?(nodes); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#50
  def autocorrect(corrector, node, heredoc); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#77
  def call_after_heredoc_range(heredoc); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#107
  def call_end_pos(node); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#116
  def call_line_range(node); end

  # Returns nil if no range can be safely repositioned.
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#122
  def call_range_to_safely_reposition(node, heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#86
  def calls_on_multiple_lines?(node, _heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#82
  def correctly_positioned?(node, heredoc); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#111
  def heredoc_begin_line_range(heredoc); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#103
  def heredoc_end_pos(heredoc); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#73
  def heredoc_node?(node); end

  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#59
  def heredoc_node_descendent_receiver(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#67
  def send_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#146
  def trailing_comma?(call_source, call_line_source); end
end

# source://rubocop//lib/rubocop/cop/lint/heredoc_method_call_position.rb#35
RuboCop::Cop::Lint::HeredocMethodCallPosition::MSG = T.let(T.unsafe(nil), String)

# Prefer `equal?` over `==` when comparing `object_id`.
#
# `Object#equal?` is provided to compare objects for identity, and in contrast
# `Object#==` is provided for the purpose of doing value comparison.
#
# @example
#   # bad
#   foo.object_id == bar.object_id
#
#   # good
#   foo.equal?(bar)
#
# source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#18
class RuboCop::Cop::Lint::IdentityComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#24
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#40
  def compare_between_object_id_by_double_equal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#44
  def object_id_method?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#21
RuboCop::Cop::Lint::IdentityComparison::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/identity_comparison.rb#22
RuboCop::Cop::Lint::IdentityComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for implicit string concatenation of string literals
# which are on the same line.
#
# @example
#
#   # bad
#   array = ['Item 1' 'Item 2']
#
#   # good
#   array = ['Item 1Item 2']
#   array = ['Item 1' + 'Item 2']
#   array = [
#   'Item 1' \
#   'Item 2'
#   ]
#
# source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#21
class RuboCop::Cop::Lint::ImplicitStringConcatenation < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#32
  def on_dstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#86
  def display_str(node); end

  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#53
  def each_bad_cons(node); end

  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#68
  def ending_delimiter(str); end

  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#94
  def str_content(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#78
  def string_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#82
  def string_literals?(node1, node2); end
end

# source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#26
RuboCop::Cop::Lint::ImplicitStringConcatenation::FOR_ARRAY = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#28
RuboCop::Cop::Lint::ImplicitStringConcatenation::FOR_METHOD = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/implicit_string_concatenation.rb#24
RuboCop::Cop::Lint::ImplicitStringConcatenation::MSG = T.let(T.unsafe(nil), String)

# Checks for `IO.select` that is incompatible with Fiber Scheduler since Ruby 3.0.
#
# When an array of IO objects waiting for an exception (the third argument of `IO.select`)
# is used as an argument, there is no alternative API, so offenses are not registered.
#
# NOTE: When the method is successful the return value of `IO.select` is `[[IO]]`,
# and the return value of `io.wait_readable` and `io.wait_writable` are `self`.
# They are not autocorrected when assigning a return value because these types are different.
# It's up to user how to handle the return value.
#
# @example
#
#   # bad
#   IO.select([io], [], [], timeout)
#
#   # good
#   io.wait_readable(timeout)
#
#   # bad
#   IO.select([], [io], [], timeout)
#
#   # good
#   io.wait_writable(timeout)
#
# source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#34
class RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#41
  def io_select(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#46
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#69
  def preferred_method(read, write, timeout); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#63
  def scheduler_compatible?(io1, io2); end
end

# source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#37
RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/incompatible_io_select_with_fiber_scheduler.rb#38
RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `private` or `protected` access modifiers which are
# applied to a singleton method. These access modifiers do not make
# singleton methods private/protected. `private_class_method` can be
# used for that.
#
# @example
#
#   # bad
#   class C
#   private
#
#   def self.method
#   puts 'hi'
#   end
#   end
#
#   # good
#   class C
#   def self.method
#   puts 'hi'
#   end
#
#   private_class_method :method
#   end
#
#   # good
#   class C
#   class << self
#   private
#
#   def method
#   puts 'hi'
#   end
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#41
class RuboCop::Cop::Lint::IneffectiveAccessModifier < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#52
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#52
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#48
  def private_class_methods(param0); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#102
  def access_modifier?(node); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#59
  def check_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#106
  def correct_visibility?(node, modifier, ignored_methods); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#71
  def format_message(modifier); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#84
  def ineffective_modifier(node, ignored_methods = T.unsafe(nil), modifier = T.unsafe(nil), &block); end

  # source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#67
  def private_class_method_names(node); end
end

# source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#44
RuboCop::Cop::Lint::IneffectiveAccessModifier::ALTERNATIVE_PRIVATE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#45
RuboCop::Cop::Lint::IneffectiveAccessModifier::ALTERNATIVE_PROTECTED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/ineffective_access_modifier.rb#42
RuboCop::Cop::Lint::IneffectiveAccessModifier::MSG = T.let(T.unsafe(nil), String)

# Looks for error classes inheriting from `Exception`.
# It is configurable to suggest using either `StandardError` (default) or
# `RuntimeError` instead.
#
# @example EnforcedStyle: standard_error (default)
#   # bad
#
#   class C < Exception; end
#
#   C = Class.new(Exception)
#
#   # good
#
#   class C < StandardError; end
#
#   C = Class.new(StandardError)
# @example EnforcedStyle: runtime_error
#   # bad
#
#   class C < Exception; end
#
#   C = Class.new(Exception)
#
#   # good
#
#   class C < RuntimeError; end
#
#   C = Class.new(RuntimeError)
#
# source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#40
class RuboCop::Cop::Lint::InheritException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#53
  def class_new_call?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#59
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#70
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#87
  def exception_class?(class_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#91
  def inherit_exception_class_with_omitted_namespace?(class_node); end

  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#83
  def message(node); end

  # source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#99
  def preferred_base_class; end
end

# source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#44
RuboCop::Cop::Lint::InheritException::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#45
RuboCop::Cop::Lint::InheritException::PREFERRED_BASE_CLASS = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/inherit_exception.rb#50
RuboCop::Cop::Lint::InheritException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for interpolation in a single quoted string.
#
# @example
#
#   # bad
#   foo = 'something with #{interpolation} inside'
#
#   # good
#   foo = "something with #{interpolation} inside"
#
# source://rubocop//lib/rubocop/cop/lint/interpolation_check.rb#21
class RuboCop::Cop::Lint::InterpolationCheck < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/interpolation_check.rb#27
  def on_str(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/interpolation_check.rb#38
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/interpolation_check.rb#49
  def heredoc?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/interpolation_check.rb#24
RuboCop::Cop::Lint::InterpolationCheck::MSG = T.let(T.unsafe(nil), String)

# Emulates the following Ruby warning in Ruby 3.3.
#
# [source,ruby]
# ----
# $ ruby -e '0.times { it }'
# -e:1: warning: `it` calls without arguments will refer to the first block param in Ruby 3.4;
# use it() or self.it
# ----
#
# `it` calls without arguments will refer to the first block param in Ruby 3.4.
# So use `it()` or `self.it` to ensure compatibility.
#
# @example
#
#   # bad
#   do_something { it }
#
#   # good
#   do_something { it() }
#   do_something { self.it }
#
# source://rubocop//lib/rubocop/cop/lint/it_without_arguments_in_block.rb#27
class RuboCop::Cop::Lint::ItWithoutArgumentsInBlock < ::RuboCop::Cop::Base
  include ::RuboCop::AST::NodePattern::Macros

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/it_without_arguments_in_block.rb#48
  def deprecated_it_method?(node); end

  # source://rubocop//lib/rubocop/cop/lint/it_without_arguments_in_block.rb#33
  def on_block(node); end
end

# source://rubocop//lib/rubocop/cop/lint/it_without_arguments_in_block.rb#30
RuboCop::Cop::Lint::ItWithoutArgumentsInBlock::MSG = T.let(T.unsafe(nil), String)

# Checks uses of lambda without a literal block.
# It emulates the following warning in Ruby 3.0:
#
#   $ ruby -vwe 'lambda(&proc {})'
#   ruby 3.0.0p0 (2020-12-25 revision 95aff21468) [x86_64-darwin19]
#   -e:1: warning: lambda without a literal block is deprecated; use the proc without
#   lambda instead
#
# This way, proc object is never converted to lambda.
# Autocorrection replaces with compatible proc argument.
#
# @example
#
#   # bad
#   lambda(&proc { do_something })
#   lambda(&Proc.new { do_something })
#
#   # good
#   proc { do_something }
#   Proc.new { do_something }
#   lambda { do_something } # If you use lambda.
#
# source://rubocop//lib/rubocop/cop/lint/lambda_without_literal_block.rb#28
class RuboCop::Cop::Lint::LambdaWithoutLiteralBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/lambda_without_literal_block.rb#35
  def lambda_with_symbol_proc?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/lambda_without_literal_block.rb#39
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/lambda_without_literal_block.rb#31
RuboCop::Cop::Lint::LambdaWithoutLiteralBlock::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/lambda_without_literal_block.rb#32
RuboCop::Cop::Lint::LambdaWithoutLiteralBlock::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for literals used as the conditions or as
# operands in and/or expressions serving as the conditions of
# if/while/until/case-when/case-in.
#
# NOTE: Literals in `case-in` condition where the match variable is used in
# `in` are accepted as a pattern matching.
#
# @example
#
#   # bad
#   if 20
#   do_something
#   end
#
#   # bad
#   if some_var && true
#   do_something
#   end
#
#   # good
#   if some_var && some_condition
#   do_something
#   end
#
#   # good
#   # When using a boolean value for an infinite loop.
#   while true
#   break if condition
#   end
#
# source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#35
class RuboCop::Cop::Lint::LiteralAsCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#93
  def message(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#58
  def on_case(case_node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#73
  def on_case_match(case_match_node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#40
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#87
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#51
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#51
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#44
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#44
  def on_while_post(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#108
  def basic_literal?(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#138
  def check_case(case_node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#99
  def check_for_literal(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#120
  def check_node(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#147
  def condition(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#130
  def handle_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#116
  def primitive_array?(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#155
  def when_conditions_range(when_node); end
end

# source://rubocop//lib/rubocop/cop/lint/literal_as_condition.rb#38
RuboCop::Cop::Lint::LiteralAsCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for literal assignments in the conditions of `if`, `while`, and `until`.
# It emulates the following Ruby warning:
#
# [source,console]
# ----
# $ ruby -we 'if x = true; end'
# -e:1: warning: found `= literal' in conditional, should be ==
# ----
#
# As a lint cop, it cannot be determined if `==` is appropriate as intended,
# therefore this cop does not provide autocorrection.
#
# @example
#
#   # bad
#   if x = 42
#   do_something
#   end
#
#   # good
#   if x == 42
#   do_something
#   end
#
#   # good
#   if x = y
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#35
class RuboCop::Cop::Lint::LiteralAssignmentInCondition < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#39
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#39
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#39
  def on_while(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#62
  def all_literals?(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#79
  def offense_range(asgn_node, rhs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#75
  def parallel_assignment_with_splat_operator?(node); end

  # @yield [node]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#56
  def traverse_node(node, &block); end
end

# source://rubocop//lib/rubocop/cop/lint/literal_assignment_in_condition.rb#36
RuboCop::Cop::Lint::LiteralAssignmentInCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for interpolated literals.
#
# @example
#
#   # bad
#   "result is #{10}"
#
#   # good
#   "result is 10"
#
# source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#15
class RuboCop::Cop::Lint::LiteralInInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#24
  def on_interpolation(begin_node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#58
  def autocorrected_value(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#104
  def autocorrected_value_for_array(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#110
  def autocorrected_value_for_hash(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#80
  def autocorrected_value_for_string(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#88
  def autocorrected_value_for_symbol(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#121
  def autocorrected_value_in_hash(node); end

  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#95
  def autocorrected_value_in_hash_for_symbol(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#151
  def ends_heredoc_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#159
  def in_array_percent_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#44
  def offending?(node); end

  # Does node print its own source when converted to a string?
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#142
  def prints_as_self?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#147
  def space_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#52
  def special_keyword?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#22
RuboCop::Cop::Lint::LiteralInInterpolation::COMPOSITE = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/literal_in_interpolation.rb#21
RuboCop::Cop::Lint::LiteralInInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of `begin...end while/until something`.
#
# @example
#
#   # bad
#
#   # using while
#   begin
#   do_something
#   end while some_condition
#
#   # good
#
#   # while replacement
#   loop do
#   do_something
#   break unless some_condition
#   end
#
#   # bad
#
#   # using until
#   begin
#   do_something
#   end until some_condition
#
#   # good
#
#   # until replacement
#   loop do
#   do_something
#   break if some_condition
#   end
#
# source://rubocop//lib/rubocop/cop/lint/loop.rb#44
class RuboCop::Cop::Lint::Loop < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/loop.rb#53
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/lint/loop.rb#49
  def on_while_post(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/loop.rb#73
  def build_break_line(node); end

  # source://rubocop//lib/rubocop/cop/lint/loop.rb#69
  def keyword_and_condition_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/loop.rb#59
  def register_offense(node); end
end

# source://rubocop//lib/rubocop/cop/lint/loop.rb#47
RuboCop::Cop::Lint::Loop::MSG = T.let(T.unsafe(nil), String)

# cop disables on wide ranges of code, that latter contributors to
# a file wouldn't be aware of.
#
# @example
#   # Lint/MissingCopEnableDirective:
#   #   MaximumRangeSize: .inf
#
#   # good
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # rubocop:enable Layout/SpaceAroundOperators
#   # y = 1
#   # EOF
#
#   # bad
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # EOF
# @example
#   # Lint/MissingCopEnableDirective:
#   #   MaximumRangeSize: 2
#
#   # good
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # With the previous, there are 2 lines on which cop is disabled.
#   # rubocop:enable Layout/SpaceAroundOperators
#
#   # bad
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   x += 1
#   # Including this, that's 3 lines on which the cop is disabled.
#   # rubocop:enable Layout/SpaceAroundOperators
#
# source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#45
class RuboCop::Cop::Lint::MissingCopEnableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#51
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#70
  def acceptable_range?(cop, line_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#104
  def department_enabled?(cop, comment); end

  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#64
  def each_missing_enable; end

  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#87
  def max_range; end

  # source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#91
  def message(cop, comment, type = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#48
RuboCop::Cop::Lint::MissingCopEnableDirective::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/missing_cop_enable_directive.rb#49
RuboCop::Cop::Lint::MissingCopEnableDirective::MSG_BOUND = T.let(T.unsafe(nil), String)

# Checks for the presence of constructors and lifecycle callbacks
# without calls to `super`.
#
# This cop does not consider `method_missing` (and `respond_to_missing?`)
# because in some cases it makes sense to overtake what is considered a
# missing method. In other cases, the theoretical ideal handling could be
# challenging or verbose for no actual gain.
#
# Autocorrection is not supported because the position of `super` cannot be
# determined automatically.
#
# `Object` and `BasicObject` are allowed by this cop because of their
# stateless nature. However, sometimes you might want to allow other parent
# classes from this cop, for example in the case of an abstract class that is
# not meant to be called with `super`. In those cases, you can use the
# `AllowedParentClasses` option to specify which classes should be allowed
# *in addition to* `Object` and `BasicObject`.
#
# @example
#   # bad
#   class Employee < Person
#   def initialize(name, salary)
#   @salary = salary
#   end
#   end
#
#   # good
#   class Employee < Person
#   def initialize(name, salary)
#   super(name)
#   @salary = salary
#   end
#   end
#
#   # bad
#   Employee = Class.new(Person) do
#   def initialize(name, salary)
#   @salary = salary
#   end
#   end
#
#   # good
#   Employee = Class.new(Person) do
#   def initialize(name, salary)
#   super(name)
#   @salary = salary
#   end
#   end
#
#   # bad
#   class Parent
#   def self.inherited(base)
#   do_something
#   end
#   end
#
#   # good
#   class Parent
#   def self.inherited(base)
#   super
#   do_something
#   end
#   end
#
#   # good
#   class ClassWithNoParent
#   def initialize
#   do_something
#   end
#   end
# @example AllowedParentClasses: [MyAbstractClass]
#   # good
#   class MyConcreteClass < MyAbstractClass
#   def initialize
#   do_something
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#85
class RuboCop::Cop::Lint::MissingSuper < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#99
  def class_new_block(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#105
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#115
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#149
  def allowed_class?(node); end

  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#153
  def allowed_classes; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#127
  def callback_method_def?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#133
  def contains_super?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#137
  def inside_class_with_stateful_parent?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/missing_super.rb#123
  def offender?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#96
RuboCop::Cop::Lint::MissingSuper::CALLBACKS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#87
RuboCop::Cop::Lint::MissingSuper::CALLBACK_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#91
RuboCop::Cop::Lint::MissingSuper::CLASS_LIFECYCLE_CALLBACKS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#86
RuboCop::Cop::Lint::MissingSuper::CONSTRUCTOR_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#92
RuboCop::Cop::Lint::MissingSuper::METHOD_LIFECYCLE_CALLBACKS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/missing_super.rb#89
RuboCop::Cop::Lint::MissingSuper::STATELESS_CLASSES = T.let(T.unsafe(nil), Array)

# Checks for mixed-case character ranges since they include likely unintended characters.
#
# Offenses are registered for regexp character classes like `/[A-z]/`
# as well as range objects like `('A'..'z')`.
#
# NOTE: Range objects cannot be autocorrected.
#
# @example
#
#   # bad
#   r = /[A-z]/
#
#   # good
#   r = /[A-Za-z]/
#
# source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#28
class RuboCop::Cop::Lint::MixedCaseRange < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#58
  def each_unsafe_regexp_range(node); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#37
  def on_erange(node); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#37
  def on_irange(node); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#48
  def on_regexp(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#74
  def build_source_range(range_start, range_end); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#78
  def range_for(char); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#84
  def range_pairs(expr); end

  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#104
  def regexp_range(source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#94
  def skip_expression?(expr); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#98
  def skip_range?(range_start, range_end); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#88
  def unsafe_range?(range_start, range_end); end
end

# source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#32
RuboCop::Cop::Lint::MixedCaseRange::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/mixed_case_range.rb#35
RuboCop::Cop::Lint::MixedCaseRange::RANGES = T.let(T.unsafe(nil), Array)

# Do not mix named captures and numbered captures in a Regexp literal
# because numbered capture is ignored if they're mixed.
# Replace numbered captures with non-capturing groupings or
# named captures.
#
# @example
#   # bad
#   /(?<foo>FOO)(BAR)/
#
#   # good
#   /(?<foo>FOO)(?<bar>BAR)/
#
#   # good
#   /(?<foo>FOO)(?:BAR)/
#
#   # good
#   /(FOO)(BAR)/
#
# source://rubocop//lib/rubocop/cop/lint/mixed_regexp_capture_types.rb#24
class RuboCop::Cop::Lint::MixedRegexpCaptureTypes < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/mixed_regexp_capture_types.rb#27
  def on_regexp(node); end
end

# source://rubocop//lib/rubocop/cop/lint/mixed_regexp_capture_types.rb#25
RuboCop::Cop::Lint::MixedRegexpCaptureTypes::MSG = T.let(T.unsafe(nil), String)

# In math and Python, we can use `x < y < z` style comparison to compare
# multiple value. However, we can't use the comparison in Ruby. However,
# the comparison is not syntax error. This cop checks the bad usage of
# comparison operators.
#
# @example
#
#   # bad
#   x < y < z
#   10 <= x <= 20
#
#   # good
#   x < y && y < z
#   10 <= x && x <= 20
#
# source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#20
class RuboCop::Cop::Lint::MultipleComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#29
  def multiple_compare?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#33
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#24
RuboCop::Cop::Lint::MultipleComparison::COMPARISON_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#23
RuboCop::Cop::Lint::MultipleComparison::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#26
RuboCop::Cop::Lint::MultipleComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/multiple_comparison.rb#25
RuboCop::Cop::Lint::MultipleComparison::SET_OPERATION_OPERATORS = T.let(T.unsafe(nil), Array)

# Checks for nested method definitions.
#
# @example
#
#   # bad
#
#   # `bar` definition actually produces methods in the same scope
#   # as the outer `foo` method. Furthermore, the `bar` method
#   # will be redefined every time `foo` is invoked.
#   def foo
#   def bar
#   end
#   end
#
#   # good
#
#   def foo
#   bar = -> { puts 'hello' }
#   bar.call
#   end
#
#   # good
#
#   # `class_eval`, `instance_eval`, `module_eval`, `class_exec`, `instance_exec`, and
#   # `module_exec` blocks are allowed by default.
#
#   def foo
#   self.class.class_eval do
#   def bar
#   end
#   end
#   end
#
#   def foo
#   self.class.module_exec do
#   def bar
#   end
#   end
#   end
#
#   # good
#
#   def foo
#   class << self
#   def bar
#   end
#   end
#   end
# @example AllowedMethods: [] (default)
#   # bad
#   def do_something
#   has_many :articles do
#   def find_or_create_by_name(name)
#   end
#   end
#   end
# @example AllowedMethods: ['has_many']
#   # bad
#   def do_something
#   has_many :articles do
#   def find_or_create_by_name(name)
#   end
#   end
#   end
# @example AllowedPatterns: [] (default)
#   # bad
#   def foo(obj)
#   obj.do_baz do
#   def bar
#   end
#   end
#   end
# @example AllowedPatterns: ['baz']
#   # good
#   def foo(obj)
#   obj.do_baz do
#   def bar
#   end
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#91
class RuboCop::Cop::Lint::NestedMethodDefinition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#127
  def eval_call?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#132
  def exec_call?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#97
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#97
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#120
  def allowed_method_name?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#115
  def scoping_method_call?(child); end
end

# source://rubocop//lib/rubocop/cop/lint/nested_method_definition.rb#95
RuboCop::Cop::Lint::NestedMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for nested percent literals.
#
# @example
#
#   # bad
#
#   # The percent literal for nested_attributes is parsed as four tokens,
#   # yielding the array [:name, :content, :"%i[incorrectly", :"nested]"].
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: %i[name content %i[incorrectly nested]]
#   }
#
#   # good
#
#   # Neither is incompatible with the bad case, but probably the intended code.
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: [:name, :content, %i[incorrectly nested]]
#   }
#
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: [:name, :content, [:incorrectly, :nested]]
#   }
#
# source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#32
class RuboCop::Cop::Lint::NestedPercentLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral

  # source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#44
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#48
  def on_percent_literal(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#54
  def contains_percent_literals?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#35
RuboCop::Cop::Lint::NestedPercentLiteral::MSG = T.let(T.unsafe(nil), String)

# The array of regular expressions representing percent literals that,
# if found within a percent literal expression, will cause a
# NestedPercentLiteral violation to be emitted.
#
# source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#41
RuboCop::Cop::Lint::NestedPercentLiteral::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/nested_percent_literal.rb#42
RuboCop::Cop::Lint::NestedPercentLiteral::REGEXES = T.let(T.unsafe(nil), Array)

# Don't omit the accumulator when calling `next` in a `reduce` block.
#
# @example
#
#   # bad
#   result = (1..4).reduce(0) do |acc, i|
#   next if i.odd?
#   acc + i
#   end
#
#   # good
#   result = (1..4).reduce(0) do |acc, i|
#   next acc if i.odd?
#   acc + i
#   end
#
# source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#21
class RuboCop::Cop::Lint::NextWithoutAccumulator < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#24
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#38
  def on_block_body_of_reduce(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#24
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#45
  def parent_block_node(node); end
end

# source://rubocop//lib/rubocop/cop/lint/next_without_accumulator.rb#22
RuboCop::Cop::Lint::NextWithoutAccumulator::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of a `return` inside a `begin..end` block
# in assignment contexts.
# In this situation, the `return` will result in an exit from the current
# method, possibly leading to unexpected behavior.
#
# @example
#
#   # bad
#   @some_variable ||= begin
#   return some_value if some_condition_is_met
#
#   do_something
#   end
#
#   # good
#   @some_variable ||= begin
#   if some_condition_is_met
#   some_value
#   else
#   do_something
#   end
#   end
#
#   # good
#   some_variable = if some_condition_is_met
#   return if another_condition_is_met
#
#   some_value
#   else
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/lint/no_return_in_begin_end_blocks.rb#38
class RuboCop::Cop::Lint::NoReturnInBeginEndBlocks < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/no_return_in_begin_end_blocks.rb#41
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/no_return_in_begin_end_blocks.rb#41
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/no_return_in_begin_end_blocks.rb#41
  def on_or_asgn(node); end
end

# source://rubocop//lib/rubocop/cop/lint/no_return_in_begin_end_blocks.rb#39
RuboCop::Cop::Lint::NoReturnInBeginEndBlocks::MSG = T.let(T.unsafe(nil), String)

# Checks for non-atomic file operation.
# And then replace it with a nearly equivalent and atomic method.
#
# These can cause problems that are difficult to reproduce,
# especially in cases of frequent file operations in parallel,
# such as test runs with parallel_rspec.
#
# For examples: creating a directory if there is none, has the following problems
#
# An exception occurs when the directory didn't exist at the time of `exist?`,
# but someone else created it before `mkdir` was executed.
#
# Subsequent processes are executed without the directory that should be there
# when the directory existed at the time of `exist?`,
# but someone else deleted it shortly afterwards.
#
# @example
#   # bad - race condition with another process may result in an error in `mkdir`
#   unless Dir.exist?(path)
#   FileUtils.mkdir(path)
#   end
#
#   # good - atomic and idempotent creation
#   FileUtils.mkdir_p(path)
#
#   # bad - race condition with another process may result in an error in `remove`
#   if File.exist?(path)
#   FileUtils.remove(path)
#   end
#
#   # good - atomic and idempotent removal
#   FileUtils.rm_f(path)
#
# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#44
class RuboCop::Cop::Lint::NonAtomicFileOperation < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#76
  def explicit_not_force?(param0); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#71
  def force?(param0); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#80
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#66
  def receiver_and_method_name(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#61
  def send_exist_node(param0); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#97
  def allowable_use_with_if?(if_node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#121
  def autocorrect(corrector, node, range); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#132
  def autocorrect_replace_method(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#151
  def force_method?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#159
  def force_method_name?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#155
  def force_option?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#91
  def if_node_child?(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#112
  def message_change_force_method(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#116
  def message_remove_file_exist_check(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#101
  def register_offense(node, exist_node); end

  # source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#139
  def replacement_method(node); end
end

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#50
RuboCop::Cop::Lint::NonAtomicFileOperation::MAKE_FORCE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#51
RuboCop::Cop::Lint::NonAtomicFileOperation::MAKE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#49
RuboCop::Cop::Lint::NonAtomicFileOperation::MSG_CHANGE_FORCE_METHOD = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#47
RuboCop::Cop::Lint::NonAtomicFileOperation::MSG_REMOVE_FILE_EXIST_CHECK = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#54
RuboCop::Cop::Lint::NonAtomicFileOperation::RECURSIVE_REMOVE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#52
RuboCop::Cop::Lint::NonAtomicFileOperation::REMOVE_FORCE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#53
RuboCop::Cop::Lint::NonAtomicFileOperation::REMOVE_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/non_atomic_file_operation.rb#55
RuboCop::Cop::Lint::NonAtomicFileOperation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# `Dir[...]` and `Dir.glob(...)` do not make any guarantees about
# the order in which files are returned. The final order is
# determined by the operating system and file system.
# This means that using them in cases where the order matters,
# such as requiring files, can lead to intermittent failures
# that are hard to debug. To ensure this doesn't happen,
# always sort the list.
#
# `Dir.glob` and `Dir[]` sort globbed results by default in Ruby 3.0.
# So all bad cases are acceptable when Ruby 3.0 or higher are used.
#
# NOTE: This cop will be deprecated and removed when supporting only Ruby 3.0 and higher.
#
# @example
#
#   # bad
#   Dir["./lib/**/*.rb"].each do |file|
#   require file
#   end
#
#   # good
#   Dir["./lib/**/*.rb"].sort.each do |file|
#   require file
#   end
#
#   # bad
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb')) do |file|
#   require file
#   end
#
#   # good
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb')).sort.each do |file|
#   require file
#   end
#
#   # bad
#   Dir['./lib/**/*.rb'].each(&method(:require))
#
#   # good
#   Dir['./lib/**/*.rb'].sort.each(&method(:require))
#
#   # bad
#   Dir.glob(Rails.root.join('test', '*.rb'), &method(:require))
#
#   # good
#   Dir.glob(Rails.root.join('test', '*.rb')).sort.each(&method(:require))
#
#   # good - Respect intent if `sort` keyword option is specified in Ruby 3.0 or higher.
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb'), sort: false).each(&method(:require))
#
# source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#60
class RuboCop::Cop::Lint::NonDeterministicRequireOrder < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#172
  def loop_variable(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#155
  def method_require?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#65
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#89
  def on_block_pass(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#77
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#145
  def unsorted_dir_block?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#150
  def unsorted_dir_each?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#166
  def unsorted_dir_each_pass?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#160
  def unsorted_dir_glob_pass?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#177
  def var_is_required?(param0, param1); end

  private

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#107
  def correct_block(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#117
  def correct_block_pass(corrector, node); end

  # Returns range of last argument including comma and whitespace.
  #
  # @return [Parser::Source::Range]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#132
  def last_arg_range(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#136
  def unsorted_dir_loop?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#140
  def unsorted_dir_pass?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/non_deterministic_require_order.rb#63
RuboCop::Cop::Lint::NonDeterministicRequireOrder::MSG = T.let(T.unsafe(nil), String)

# Checks for non-local exits from iterators without a return
# value. It registers an offense under these conditions:
#
# * No value is returned,
# * the block is preceded by a method chain,
# * the block has arguments,
# * the method which receives the block is not `define_method`
# or `define_singleton_method`,
# * the return is not contained in an inner scope, e.g. a lambda or a
# method definition.
#
# @example
#
#   class ItemApi
#   rescue_from ValidationError do |e| # non-iteration block with arg
#   return { message: 'validation error' } unless e.errors # allowed
#   error_array = e.errors.map do |error| # block with method chain
#   return if error.suppress? # warned
#   return "#{error.param}: invalid" unless error.message # allowed
#   "#{error.param}: #{error.message}"
#   end
#   { message: 'validation error', errors: error_array }
#   end
#
#   def update_items
#   transaction do # block without arguments
#   return unless update_necessary? # allowed
#   find_each do |item| # block without method chain
#   return if item.stock == 0 # false-negative...
#   item.update!(foobar: true)
#   end
#   end
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#41
class RuboCop::Cop::Lint::NonLocalExitFromIterator < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#77
  def chained_send?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#80
  def define_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#46
  def on_return(return_node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#72
  def return_value?(return_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#68
  def scoped_node?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/non_local_exit_from_iterator.rb#42
RuboCop::Cop::Lint::NonLocalExitFromIterator::MSG = T.let(T.unsafe(nil), String)

# Warns the usage of unsafe number conversions. Unsafe
# number conversion can cause unexpected error if auto type conversion
# fails. Cop prefer parsing with number class instead.
#
# Conversion with `Integer`, `Float`, etc. will raise an `ArgumentError`
# if given input that is not numeric (eg. an empty string), whereas
# `to_i`, etc. will try to convert regardless of input (``''.to_i => 0``).
# As such, this cop is disabled by default because it's not necessarily
# always correct to raise if a value is not numeric.
#
# NOTE: Some values cannot be converted properly using one of the `Kernel`
# method (for instance, `Time` and `DateTime` values are allowed by this
# cop by default). Similarly, Rails' duration methods do not work well
# with `Integer()` and can be allowed with `AllowedMethods`. By default,
# there are no methods to allowed.
#
# @example
#
#   # bad
#
#   '10'.to_i
#   '10.2'.to_f
#   '10'.to_c
#   '1/3'.to_r
#   ['1', '2', '3'].map(&:to_i)
#   foo.try(:to_f)
#   bar.send(:to_c)
#
#   # good
#
#   Integer('10', 10)
#   Float('10.2')
#   Complex('10')
#   Rational('1/3')
#   ['1', '2', '3'].map { |i| Integer(i, 10) }
#   foo.try { |i| Float(i) }
#   bar.send { |i| Complex(i) }
# @example AllowedMethods: [] (default)
#
#   # bad
#   10.minutes.to_i
# @example AllowedMethods: [minutes]
#
#   # good
#   10.minutes.to_i
# @example AllowedPatterns: [] (default)
#
#   # bad
#   10.minutes.to_i
# @example AllowedPatterns: ['min*']
#
#   # good
#   10.minutes.to_i
# @example IgnoredClasses: [Time, DateTime] (default)
#
#   # good
#   Time.now.to_datetime.to_i
#
# source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#73
class RuboCop::Cop::Lint::NumberConversion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#107
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#107
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#93
  def to_method(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#98
  def to_method_symbol(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#165
  def allow_receiver?(receiver); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#177
  def allowed_method_name?(name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#187
  def conversion_method?(method_name); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#151
  def correct_method(node, receiver); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#155
  def correct_sym_method(to_method); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#134
  def handle_as_symbol(node); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#115
  def handle_conversion_method(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#195
  def ignored_class?(name); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#191
  def ignored_classes; end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#160
  def remove_parentheses(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#181
  def top_receiver(node); end
end

# source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#89
RuboCop::Cop::Lint::NumberConversion::CONVERSION_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#79
RuboCop::Cop::Lint::NumberConversion::CONVERSION_METHOD_CLASS_MAPPING = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#90
RuboCop::Cop::Lint::NumberConversion::METHODS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/number_conversion.rb#85
RuboCop::Cop::Lint::NumberConversion::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of numbered parameter assignment.
# It emulates the following warning in Ruby 2.7:
#
#   $ ruby -ve '_1 = :value'
#   ruby 2.7.2p137 (2020-10-01 revision 5445e04352) [x86_64-darwin19]
#   -e:1: warning: `_1' is reserved for numbered parameter; consider another name
#
# Assigning to a numbered parameter (from `_1` to `_9`) causes an error in Ruby 3.0.
#
#   $ ruby -ve '_1 = :value'
#   ruby 3.0.0p0 (2020-12-25 revision 95aff21468) [x86_64-darwin19]
#   -e:1: _1 is reserved for numbered parameter
#
# NOTE: The parametered parameters are from `_1` to `_9`. This cop checks `_0`, and over `_10`
# as well to prevent confusion.
#
# @example
#
#   # bad
#   _1 = :value
#
#   # good
#   non_numbered_parameter_name = :value
#
# source://rubocop//lib/rubocop/cop/lint/numbered_parameter_assignment.rb#30
class RuboCop::Cop::Lint::NumberedParameterAssignment < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/numbered_parameter_assignment.rb#35
  def on_lvasgn(node); end
end

# source://rubocop//lib/rubocop/cop/lint/numbered_parameter_assignment.rb#32
RuboCop::Cop::Lint::NumberedParameterAssignment::LVAR_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/numbered_parameter_assignment.rb#33
RuboCop::Cop::Lint::NumberedParameterAssignment::NUMBERED_PARAMETER_RANGE = T.let(T.unsafe(nil), Range)

# source://rubocop//lib/rubocop/cop/lint/numbered_parameter_assignment.rb#31
RuboCop::Cop::Lint::NumberedParameterAssignment::NUM_PARAM_MSG = T.let(T.unsafe(nil), String)

# Checks for unintended or-assignment to a constant.
#
# Constants should always be assigned in the same location. And its value
# should always be the same. If constants are assigned in multiple
# locations, the result may vary depending on the order of `require`.
#
# @example
#
#   # bad
#   CONST ||= 1
#
#   # good
#   CONST = 1
#
# source://rubocop//lib/rubocop/cop/lint/or_assignment_to_constant.rb#24
class RuboCop::Cop::Lint::OrAssignmentToConstant < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/or_assignment_to_constant.rb#29
  def on_or_asgn(node); end
end

# source://rubocop//lib/rubocop/cop/lint/or_assignment_to_constant.rb#27
RuboCop::Cop::Lint::OrAssignmentToConstant::MSG = T.let(T.unsafe(nil), String)

# Checks the proper ordering of magic comments and whether
# a magic comment is not placed before a shebang.
#
# @example
#   # bad
#
#   # frozen_string_literal: true
#   # encoding: ascii
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:UTF-8>]
#
#   # good
#
#   # encoding: ascii
#   # frozen_string_literal: true
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:US-ASCII>]
#
#   # good
#
#   #!/usr/bin/env ruby
#   # encoding: ascii
#   # frozen_string_literal: true
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:US-ASCII>]
#
# source://rubocop//lib/rubocop/cop/lint/ordered_magic_comments.rb#32
class RuboCop::Cop::Lint::OrderedMagicComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/ordered_magic_comments.rb#38
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/ordered_magic_comments.rb#55
  def autocorrect(corrector, encoding_line, frozen_string_literal_line); end

  # source://rubocop//lib/rubocop/cop/lint/ordered_magic_comments.rb#63
  def magic_comment_lines; end
end

# source://rubocop//lib/rubocop/cop/lint/ordered_magic_comments.rb#36
RuboCop::Cop::Lint::OrderedMagicComments::MSG = T.let(T.unsafe(nil), String)

# Looks for references of Regexp captures that are out of range
# and thus always returns nil.
#
# @example
#
#   /(foo)bar/ =~ 'foobar'
#
#   # bad - always returns nil
#
#   puts $2 # => nil
#
#   # good
#
#   puts $1 # => foo
#
# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#38
class RuboCop::Cop::Lint::OutOfRangeRegexpRef < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#55
  def after_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#71
  def on_in_pattern(node); end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#51
  def on_match_with_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#47
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#77
  def on_nth_ref(node); end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#65
  def on_when(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#102
  def check_regexp(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#122
  def nth_ref_receiver?(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#113
  def regexp_first_argument?(send_node); end

  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#93
  def regexp_patterns(in_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#118
  def regexp_receiver?(send_node); end
end

# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#39
RuboCop::Cop::Lint::OutOfRangeRegexpRef::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#42
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_ARGUMENT_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#44
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_CAPTURE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#41
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_RECEIVER_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/out_of_range_regexp_ref.rb#45
RuboCop::Cop::Lint::OutOfRangeRegexpRef::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Checks for space between the name of a called method and a left
# parenthesis.
#
# @example
#
#   # bad
#   do_something (foo)
#
#   # good
#   do_something(foo)
#   do_something (2 + 3) * 4
#   do_something (foo * bar).baz
#
# source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#18
class RuboCop::Cop::Lint::ParenthesesAsGroupedExpression < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#24
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#24
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#61
  def chained_calls?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#49
  def first_argument_block_type?(first_arg); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#57
  def first_argument_starts_with_left_parenthesis?(node); end

  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#86
  def space_range(expr, space_length); end

  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#70
  def spaces_before_left_parenthesis(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#66
  def ternary_expression?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#39
  def valid_context?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#53
  def valid_first_argument?(first_arg); end
end

# source://rubocop//lib/rubocop/cop/lint/parentheses_as_grouped_expression.rb#22
RuboCop::Cop::Lint::ParenthesesAsGroupedExpression::MSG = T.let(T.unsafe(nil), String)

# Checks for quotes and commas in %w, e.g. `%w('foo', "bar")`
#
# It is more likely that the additional characters are unintended (for
# example, mistranslating an array of literals to percent string notation)
# rather than meant to be part of the resulting strings.
#
# @example
#
#   # bad
#   %w('foo', "bar")
#
#   # good
#   %w(foo bar)
#
# source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#29
class RuboCop::Cop::Lint::PercentStringArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#40
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#44
  def on_percent_literal(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#61
  def contains_quotes_or_commas?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#34
RuboCop::Cop::Lint::PercentStringArray::LEADING_QUOTE = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#37
RuboCop::Cop::Lint::PercentStringArray::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#33
RuboCop::Cop::Lint::PercentStringArray::QUOTES_AND_COMMAS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/percent_string_array.rb#35
RuboCop::Cop::Lint::PercentStringArray::TRAILING_QUOTE = T.let(T.unsafe(nil), Regexp)

# Checks for colons and commas in %i, e.g. `%i(:foo, :bar)`
#
# It is more likely that the additional characters are unintended (for
# example, mistranslating an array of literals to percent string notation)
# rather than meant to be part of the resulting symbols.
#
# @example
#
#   # bad
#   %i(:foo, :bar)
#
#   # good
#   %i(foo bar)
#
# source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#19
class RuboCop::Cop::Lint::PercentSymbolArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#26
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#30
  def on_percent_literal(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#38
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#48
  def contains_colons_or_commas?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#58
  def non_alphanumeric_literal?(literal); end
end

# source://rubocop//lib/rubocop/cop/lint/percent_symbol_array.rb#23
RuboCop::Cop::Lint::PercentSymbolArray::MSG = T.let(T.unsafe(nil), String)

# Checks for `raise` or `fail` statements which are
# raising `Exception` class.
#
# You can specify a module name that will be an implicit namespace
# using `AllowedImplicitNamespaces` option. The cop cause a false positive
# for namespaced `Exception` when a namespace is omitted. This option can
# prevent the false positive by specifying a namespace to be omitted for
# `Exception`. Alternatively, make `Exception` a fully qualified class
# name with an explicit namespace.
#
# @example
#   # bad
#   raise Exception, 'Error message here'
#
#   # good
#   raise StandardError, 'Error message here'
# @example AllowedImplicitNamespaces: ['Gem']
#   # good
#   module Gem
#   def self.foo
#   raise Exception # This exception means `Gem::Exception`.
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#34
class RuboCop::Cop::Lint::RaiseException < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#41
  def exception?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#46
  def exception_new_with_message?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#51
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#85
  def allow_implicit_namespaces; end

  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#57
  def check(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#73
  def implicit_namespace?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#37
RuboCop::Cop::Lint::RaiseException::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/raise_exception.rb#38
RuboCop::Cop::Lint::RaiseException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `rand(1)` calls.
# Such calls always return `0`.
#
# @example
#
#   # bad
#   rand 1
#   Kernel.rand(-1)
#   rand 1.0
#   rand(-1.0)
#
#   # good
#   0 # just use 0 instead
#
# source://rubocop//lib/rubocop/cop/lint/rand_one.rb#19
class RuboCop::Cop::Lint::RandOne < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/rand_one.rb#28
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/rand_one.rb#24
  def rand_one?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/rand_one.rb#36
  def message(node); end
end

# source://rubocop//lib/rubocop/cop/lint/rand_one.rb#20
RuboCop::Cop::Lint::RandOne::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/rand_one.rb#21
RuboCop::Cop::Lint::RandOne::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# removed without causing any offenses to be reported. It's implemented
# as a cop in that it inherits from the Cop base class and calls
# add_offense. The unusual part of its implementation is that it doesn't
# have any on_* methods or an investigate method. This means that it
# doesn't take part in the investigation phase when the other cops do
# their work. Instead, it waits until it's called in a later stage of the
# execution. The reason it can't be implemented as a normal cop is that
# it depends on the results of all other cops to do its work.
#
# @example
#   # bad
#   # rubocop:disable Layout/LineLength
#   x += 1
#   # rubocop:enable Layout/LineLength
#
#   # good
#   x += 1
#
# source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#28
class RuboCop::Cop::Lint::RedundantCopDisableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [RedundantCopDisableDirective] a new instance of RedundantCopDisableDirective
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#37
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil), offenses = T.unsafe(nil)); end

  # Returns the value of attribute offenses_to_check.
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#35
  def offenses_to_check; end

  # Sets the attribute offenses_to_check
  #
  # @param value the value to set the attribute offenses_to_check to.
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#35
  def offenses_to_check=(_arg0); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#42
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#323
  def add_department_marker(department); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#229
  def add_offense_for_entire_comment(comment, cops); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#244
  def add_offense_for_some_cops(comment, cops); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#219
  def add_offenses(redundant_cops); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#306
  def all_cop_names; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#190
  def all_disabled?(comment); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#69
  def comment_range_with_surrounding_space(directive_comment_range, line_comment_range); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#57
  def cop_disabled_line_ranges; end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#264
  def cop_range(comment, cop); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#210
  def department_disabled?(cop, comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#315
  def department_marker?(department); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#293
  def describe(cop); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#215
  def directive_count(comment); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#92
  def directive_range_in_list(range, ranges); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#61
  def disabled_ranges; end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#132
  def each_already_disabled(cop, line_ranges); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#113
  def each_line_range(cop, line_ranges); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#106
  def each_redundant_disable(&block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#310
  def ends_its_line?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#202
  def expected_final_disable?(cop, line_range); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#166
  def find_redundant_all(range, next_range); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#161
  def find_redundant_cop(cop, range); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#176
  def find_redundant_department(cop, range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#182
  def followed_ranges?(range, next_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#194
  def ignore_offense?(line_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#258
  def leave_free_comment?(comment, range); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#271
  def matching_range(haystack, needle); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#302
  def message(cop_names); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#65
  def previous_line_blank?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#186
  def range_with_offense?(range, offenses = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#319
  def remove_department_marker(department); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#279
  def trailing_range?(ranges, range); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#32
RuboCop::Cop::Lint::RedundantCopDisableDirective::COP_NAME = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#33
RuboCop::Cop::Lint::RedundantCopDisableDirective::DEPARTMENT_MARKER = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_cop_disable_directive.rb#287
RuboCop::Cop::Lint::RedundantCopDisableDirective::SIMILAR_COP_NAMES_CACHE = T.let(T.unsafe(nil), Hash)

# removed.
#
# that cop checks whether any cop was actually enabled.
#
# @example
#
#   # bad
#   foo = 1
#   # rubocop:enable Layout/LineLength
#
#   # good
#   foo = 1
#
#   # bad
#   # rubocop:disable Style/StringLiterals
#   foo = "1"
#   # rubocop:enable Style/StringLiterals
#   baz
#   # rubocop:enable all
#
#   # good
#   # rubocop:disable Style/StringLiterals
#   foo = "1"
#   # rubocop:enable all
#   baz
#
# source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#39
class RuboCop::Cop::Lint::RedundantCopEnableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#46
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#122
  def all_or_name(name); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#78
  def comment_start(comment); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#82
  def cop_name_indention(comment, name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#126
  def department?(directive, name); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#73
  def range_of_offense(comment, name); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#97
  def range_to_remove(begin_pos, end_pos, comment); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#86
  def range_with_comma(comment, name); end

  # If the list of cops is comma-separated, but without a empty space after the comma,
  # we should **not** remove the prepending empty space, thus begin_pos += 1
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#116
  def range_with_comma_after(comment, start, begin_pos, end_pos); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#110
  def range_with_comma_before(start, begin_pos, end_pos); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#55
  def register_offense(comment, cop_names); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_cop_enable_directive.rb#44
RuboCop::Cop::Lint::RedundantCopEnableDirective::MSG = T.let(T.unsafe(nil), String)

# Sort globbed results by default in Ruby 3.0.
# This cop checks for redundant `sort` method to `Dir.glob` and `Dir[]`.
#
# @example
#
#   # bad
#   Dir.glob('./lib/**/*.rb').sort.each do |file|
#   end
#
#   Dir['./lib/**/*.rb'].sort.each do |file|
#   end
#
#   # good
#   Dir.glob('./lib/**/*.rb').each do |file|
#   end
#
#   Dir['./lib/**/*.rb'].each do |file|
#   end
#
# source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#30
class RuboCop::Cop::Lint::RedundantDirGlobSort < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#40
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#56
  def multiple_argument?(glob_method); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#38
RuboCop::Cop::Lint::RedundantDirGlobSort::GLOB_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#36
RuboCop::Cop::Lint::RedundantDirGlobSort::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_dir_glob_sort.rb#37
RuboCop::Cop::Lint::RedundantDirGlobSort::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for redundant quantifiers inside Regexp literals.
#
# It is always allowed when interpolation is used in a regexp literal,
# because it's unknown what kind of string will be expanded as a result:
#
# [source,ruby]
# ----
# /(?:a*#{interpolation})?/x
# ----
#
# @example
#   # bad
#   /(?:x+)+/
#
#   # good
#   /(?:x)+/
#
#   # good
#   /(?:x+)/
#
#   # bad
#   /(?:x+)?/
#
#   # good
#   /(?:x)*/
#
#   # good
#   /(?:x*)/
#
# source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#34
class RuboCop::Cop::Lint::RedundantRegexpQuantifiers < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#42
  def on_regexp(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#83
  def character_set?(expr); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#61
  def each_redundantly_quantified_pair(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#87
  def mergeable_quantifier(expr); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#103
  def merged_quantifier(exp1, exp2); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#119
  def message(group, child, replacement); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#115
  def quantifier_range(group, child); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#75
  def redundant_group?(expr); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#79
  def redundantly_quantifiable?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_regexp_quantifiers.rb#38
RuboCop::Cop::Lint::RedundantRegexpQuantifiers::MSG_REDUNDANT_QUANTIFIER = T.let(T.unsafe(nil), String)

# Checks for unnecessary `require` statement.
#
# The following features are unnecessary `require` statement because
# they are already loaded. e.g. Ruby 2.2:
#
#   ruby -ve 'p $LOADED_FEATURES.reject { |feature| %r|/| =~ feature }'
#   ruby 2.2.8p477 (2017-09-14 revision 59906) [x86_64-darwin13]
#   ["enumerator.so", "rational.so", "complex.so", "thread.rb"]
#
# Below are the features that each `TargetRubyVersion` targets.
#
#   * 2.0+ ... `enumerator`
#   * 2.1+ ... `thread`
#   * 2.2+ ... Add `rational` and `complex` above
#   * 2.5+ ... Add `pp` above
#   * 2.7+ ... Add `ruby2_keywords` above
#   * 3.1+ ... Add `fiber` above
#   * 3.2+ ... `set`
#
# This cop target those features.
#
# @example
#   # bad
#   require 'unloaded_feature'
#   require 'thread'
#
#   # good
#   require 'unloaded_feature'
#
# source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#38
class RuboCop::Cop::Lint::RedundantRequireStatement < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#61
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#57
  def pp_const?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#51
  def redundant_require_statement?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#91
  def need_to_require_pp?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#80
  def redundant_feature?(feature_name); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#42
RuboCop::Cop::Lint::RedundantRequireStatement::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#45
RuboCop::Cop::Lint::RedundantRequireStatement::PRETTY_PRINT_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#43
RuboCop::Cop::Lint::RedundantRequireStatement::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/redundant_require_statement.rb#44
RuboCop::Cop::Lint::RedundantRequireStatement::RUBY_22_LOADED_FEATURES = T.let(T.unsafe(nil), Array)

# Checks for redundant safe navigation calls.
# Use cases where a constant, named in camel case for classes and modules is `nil` are rare,
# and an offense is not detected when the receiver is a constant. The detection also applies
# to literal receivers, except for `nil`.
#
# For all receivers, the `instance_of?`, `kind_of?`, `is_a?`, `eql?`, `respond_to?`,
# and `equal?` methods are checked by default.
# These are customizable with `AllowedMethods` option.
#
# The `AllowedMethods` option specifies nil-safe methods,
# in other words, it is a method that is allowed to skip safe navigation.
# Note that the `AllowedMethod` option is not an option that specifies methods
# for which to suppress (allow) this cop's check.
#
# In the example below, the safe navigation operator (`&.`) is unnecessary
# because `NilClass` has methods like `respond_to?` and `is_a?`.
#
# @example
#   # bad
#   CamelCaseConst&.do_something
#
#   # bad
#   do_something if attrs&.respond_to?(:[])
#
#   # good
#   do_something if attrs.respond_to?(:[])
#
#   # bad
#   while node&.is_a?(BeginNode)
#   node = node.parent
#   end
#
#   # good
#   CamelCaseConst.do_something
#
#   # good
#   while node.is_a?(BeginNode)
#   node = node.parent
#   end
#
#   # good - without `&.` this will always return `true`
#   foo&.respond_to?(:to_a)
#
#   # bad - for `nil`s conversion methods return default values for the type
#   foo&.to_h || {}
#   foo&.to_h { |k, v| [k, v] } || {}
#   foo&.to_a || []
#   foo&.to_i || 0
#   foo&.to_f || 0.0
#   foo&.to_s || ''
#
#   # good
#   foo.to_h
#   foo.to_h { |k, v| [k, v] }
#   foo.to_a
#   foo.to_i
#   foo.to_f
#   foo.to_s
# @example AllowedMethods: [nil_safe_method]
#   # bad
#   do_something if attrs&.nil_safe_method(:[])
#
#   # good
#   do_something if attrs.nil_safe_method(:[])
#   do_something if attrs&.not_nil_safe_method(:[])
#
# source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#78
class RuboCop::Cop::Lint::RedundantSafeNavigation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#95
  def conversion_with_default?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#107
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#117
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#90
  def respond_to_nil_specific_method?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#133
  def assume_receiver_instance_exists?(receiver); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#139
  def check?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#149
  def condition?(parent, node); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#82
RuboCop::Cop::Lint::RedundantSafeNavigation::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#83
RuboCop::Cop::Lint::RedundantSafeNavigation::MSG_LITERAL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#85
RuboCop::Cop::Lint::RedundantSafeNavigation::NIL_SPECIFIC_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/lint/redundant_safe_navigation.rb#87
RuboCop::Cop::Lint::RedundantSafeNavigation::SNAKE_CASE = T.let(T.unsafe(nil), Regexp)

# Checks for unneeded usages of splat expansion.
#
# @example
#
#   # bad
#   a = *[1, 2, 3]
#   a = *'a'
#   a = *1
#   ['a', 'b', *%w(c d e), 'f', 'g']
#
#   # good
#   c = [1, 2, 3]
#   a = *c
#   a, b = *c
#   a, *b = *c
#   a = *1..10
#   a = ['a']
#   ['a', 'b', 'c', 'd', 'e', 'f', 'g']
#
#   # bad
#   do_something(*['foo', 'bar', 'baz'])
#
#   # good
#   do_something('foo', 'bar', 'baz')
#
#   # bad
#   begin
#   foo
#   rescue *[StandardError, ApplicationError]
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue StandardError, ApplicationError
#   bar
#   end
#
#   # bad
#   case foo
#   when *[1, 2, 3]
#   bar
#   else
#   baz
#   end
#
#   # good
#   case foo
#   when 1, 2, 3
#   bar
#   else
#   baz
#   end
# @example AllowPercentLiteralArrayArgument: true (default)
#
#   # good
#   do_something(*%w[foo bar baz])
# @example AllowPercentLiteralArrayArgument: false
#
#   # bad
#   do_something(*%w[foo bar baz])
#
# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#71
class RuboCop::Cop::Lint::RedundantSplatExpansion < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#83
  def array_new?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#91
  def literal_expansion(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#95
  def on_splat(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#203
  def allow_percent_literal_array_argument?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#131
  def array_new_inside_array_literal?(array_new_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#155
  def array_splat?(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#112
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#159
  def method_argument?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#163
  def part_of_an_array?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#170
  def redundant_brackets?(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#118
  def redundant_splat_expansion(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#178
  def remove_brackets(array); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#138
  def replacement_range_and_content(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#196
  def use_percent_literal_array_argument?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#75
RuboCop::Cop::Lint::RedundantSplatExpansion::ARRAY_PARAM_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#80
RuboCop::Cop::Lint::RedundantSplatExpansion::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#74
RuboCop::Cop::Lint::RedundantSplatExpansion::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#79
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_CAPITAL_I = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#77
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_CAPITAL_W = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#78
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_I = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_splat_expansion.rb#76
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_W = T.let(T.unsafe(nil), String)

# Checks for string conversion in string interpolation, `print`, `puts`, and `warn` arguments,
# which is redundant.
#
# @example
#
#   # bad
#   "result is #{something.to_s}"
#   print something.to_s
#   puts something.to_s
#   warn something.to_s
#
#   # good
#   "result is #{something}"
#   print something
#   puts something
#   warn something
#
# source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#23
class RuboCop::Cop::Lint::RedundantStringCoercion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#34
  def on_interpolation(begin_node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#42
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#32
  def to_s_without_args?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#54
  def register_offense(node, context); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#27
RuboCop::Cop::Lint::RedundantStringCoercion::MSG_DEFAULT = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#28
RuboCop::Cop::Lint::RedundantStringCoercion::MSG_SELF = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_string_coercion.rb#29
RuboCop::Cop::Lint::RedundantStringCoercion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for redundant `with_index`.
#
# @example
#   # bad
#   ary.each_with_index do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
#   # bad
#   ary.each.with_index do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
# source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#29
class RuboCop::Cop::Lint::RedundantWithIndex < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#37
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#37
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#60
  def redundant_with_index?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#70
  def message(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#78
  def with_index_range(send); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#33
RuboCop::Cop::Lint::RedundantWithIndex::MSG_EACH_WITH_INDEX = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_with_index.rb#34
RuboCop::Cop::Lint::RedundantWithIndex::MSG_WITH_INDEX = T.let(T.unsafe(nil), String)

# Checks for redundant `with_object`.
#
# @example
#   # bad
#   ary.each_with_object([]) do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
#   # bad
#   ary.each.with_object([]) do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
# source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#29
class RuboCop::Cop::Lint::RedundantWithObject < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#36
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#36
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#56
  def redundant_with_object?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#65
  def message(node); end

  # source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#73
  def with_object_range(send); end
end

# source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#33
RuboCop::Cop::Lint::RedundantWithObject::MSG_EACH_WITH_OBJECT = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/redundant_with_object.rb#34
RuboCop::Cop::Lint::RedundantWithObject::MSG_WITH_OBJECT = T.let(T.unsafe(nil), String)

# Checks if `include` or `prepend` is called in `refine` block.
# These methods are deprecated and should be replaced with `Refinement#import_methods`.
#
# It emulates deprecation warnings in Ruby 3.1.
#
# @example
#
#   # bad
#   refine Foo do
#   include Bar
#   end
#
#   # bad
#   refine Foo do
#   prepend Bar
#   end
#
#   # good
#   refine Foo do
#   import_methods Bar
#   end
#
# source://rubocop//lib/rubocop/cop/lint/refinement_import_methods.rb#34
class RuboCop::Cop::Lint::RefinementImportMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/refinement_import_methods.rb#42
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/refinement_import_methods.rb#37
RuboCop::Cop::Lint::RefinementImportMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/refinement_import_methods.rb#38
RuboCop::Cop::Lint::RefinementImportMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for regexp literals used as `match-current-line`.
# If a regexp literal is in condition, the regexp matches `$_` implicitly.
#
# @example
#   # bad
#   if /foo/
#   do_something
#   end
#
#   # good
#   if /foo/ =~ $_
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/lint/regexp_as_condition.rb#19
class RuboCop::Cop::Lint::RegexpAsCondition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/regexp_as_condition.rb#26
  def on_match_current_line(node); end
end

# source://rubocop//lib/rubocop/cop/lint/regexp_as_condition.rb#23
RuboCop::Cop::Lint::RegexpAsCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for expressions where there is a call to a predicate
# method with at least one argument, where no parentheses are used around
# the parameter list, and a boolean operator, && or ||, is used in the
# last argument.
#
# The idea behind warning for these constructs is that the user might
# be under the impression that the return value from the method call is
# an operand of &&/||.
#
# @example
#
#   # bad
#   if day.is? :tuesday && month == :jan
#   # ...
#   end
#
#   # good
#   if day.is?(:tuesday) && month == :jan
#   # ...
#   end
#
# source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#26
class RuboCop::Cop::Lint::RequireParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#31
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#31
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#54
  def check_predicate(predicate, node); end

  # source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#44
  def check_ternary(ternary, node); end
end

# source://rubocop//lib/rubocop/cop/lint/require_parentheses.rb#29
RuboCop::Cop::Lint::RequireParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks that a range literal is enclosed in parentheses when the end of the range is
# at a line break.
#
# NOTE: The following is maybe intended for `(42..)`. But, compatible is `42..do_something`.
# So, this cop does not provide autocorrection because it is left to user.
#
# [source,ruby]
# ----
# case condition
# when 42..
#   do_something
# end
# ----
#
# @example
#
#   # bad - Represents `(1..42)`, not endless range.
#   1..
#   42
#
#   # good - It's incompatible, but your intentions when using endless range may be:
#   (1..)
#   42
#
#   # good
#   1..42
#
#   # good
#   (1..42)
#
#   # good
#   (1..
#   42)
#
# source://rubocop//lib/rubocop/cop/lint/require_range_parentheses.rb#40
class RuboCop::Cop::Lint::RequireRangeParentheses < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/require_range_parentheses.rb#43
  def on_erange(node); end

  # source://rubocop//lib/rubocop/cop/lint/require_range_parentheses.rb#43
  def on_irange(node); end
end

# source://rubocop//lib/rubocop/cop/lint/require_range_parentheses.rb#41
RuboCop::Cop::Lint::RequireRangeParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks for uses a file requiring itself with `require_relative`.
#
# @example
#
#   # bad
#
#   # foo.rb
#   require_relative 'foo'
#   require_relative 'bar'
#
#   # good
#
#   # foo.rb
#   require_relative 'bar'
#
# source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#21
class RuboCop::Cop::Lint::RequireRelativeSelfPath < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#28
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#44
  def remove_ext(file_path); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#40
  def same_file?(file_path, required_feature); end
end

# source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#25
RuboCop::Cop::Lint::RequireRelativeSelfPath::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/require_relative_self_path.rb#26
RuboCop::Cop::Lint::RequireRelativeSelfPath::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `rescue` blocks targeting the Exception class.
#
# @example
#
#   # bad
#   begin
#   do_something
#   rescue Exception
#   handle_exception
#   end
#
#   # good
#   begin
#   do_something
#   rescue ArgumentError
#   handle_exception
#   end
#
# source://rubocop//lib/rubocop/cop/lint/rescue_exception.rb#23
class RuboCop::Cop::Lint::RescueException < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/rescue_exception.rb#26
  def on_resbody(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/rescue_exception.rb#35
  def targets_exception?(rescue_arg_node); end
end

# source://rubocop//lib/rubocop/cop/lint/rescue_exception.rb#24
RuboCop::Cop::Lint::RescueException::MSG = T.let(T.unsafe(nil), String)

# Check for arguments to `rescue` that will result in a `TypeError`
# if an exception is raised.
#
# @example
#   # bad
#   begin
#   bar
#   rescue nil
#   baz
#   end
#
#   # bad
#   def foo
#   bar
#   rescue 1, 'a', "#{b}", 0.0, [], {}
#   baz
#   end
#
#   # good
#   begin
#   bar
#   rescue
#   baz
#   end
#
#   # good
#   def foo
#   bar
#   rescue NameError
#   baz
#   end
#
# source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#37
class RuboCop::Cop::Lint::RescueType < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#60
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#44
  def on_resbody(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#69
  def correction(*exceptions); end

  # source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#80
  def invalid_exceptions(exceptions); end

  # source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#76
  def valid_exceptions(exceptions); end
end

# source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#42
RuboCop::Cop::Lint::RescueType::INVALID_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/rescue_type.rb#40
RuboCop::Cop::Lint::RescueType::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of a return with a value in a context
# where the value will be ignored. (initialize and setter methods)
#
# @example
#
#   # bad
#   def initialize
#   foo
#   return :qux if bar?
#   baz
#   end
#
#   def foo=(bar)
#   return 42
#   end
#
#   # good
#   def initialize
#   foo
#   return if bar?
#   baz
#   end
#
#   def foo=(bar)
#   return
#   end
#
# source://rubocop//lib/rubocop/cop/lint/return_in_void_context.rb#32
class RuboCop::Cop::Lint::ReturnInVoidContext < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/return_in_void_context.rb#35
  def on_return(return_node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/return_in_void_context.rb#51
  def non_void_context(return_node); end
end

# source://rubocop//lib/rubocop/cop/lint/return_in_void_context.rb#33
RuboCop::Cop::Lint::ReturnInVoidContext::MSG = T.let(T.unsafe(nil), String)

# The safe navigation operator returns nil if the receiver is
# nil. If you chain an ordinary method call after a safe
# navigation operator, it raises NoMethodError. We should use a
# safe navigation operator after a safe navigation operator.
# This cop checks for the problem outlined above.
#
# @example
#
#   # bad
#   x&.foo.bar
#   x&.foo + bar
#   x&.foo[bar]
#
#   # good
#   x&.foo&.bar
#   x&.foo || bar
#
# source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#22
class RuboCop::Cop::Lint::SafeNavigationChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::NilMethods
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#33
  def bad_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#40
  def on_send(node); end

  private

  # @param offense_range [Parser::Source::Range]
  # @param send_node [RuboCop::AST::SendNode]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#58
  def add_safe_navigation_operator(offense_range:, send_node:); end

  # @param corrector [RuboCop::Cop::Corrector]
  # @param offense_range [Parser::Source::Range]
  # @param send_node [RuboCop::AST::SendNode]
  #
  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#77
  def autocorrect(corrector, offense_range:, send_node:); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#86
  def brackets?(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#90
  def require_parentheses?(send_node); end
end

# source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#29
RuboCop::Cop::Lint::SafeNavigationChain::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/safe_navigation_chain.rb#30
RuboCop::Cop::Lint::SafeNavigationChain::PLUS_MINUS_METHODS = T.let(T.unsafe(nil), Array)

# Check to make sure that if safe navigation is used for a method
# call in an `&&` or `||` condition that safe navigation is used for all
# method calls on that same object.
#
# @example
#   # bad
#   foo&.bar && foo.baz
#
#   # bad
#   foo.bar || foo&.baz
#
#   # bad
#   foo&.bar && (foobar.baz || foo.baz)
#
#   # good
#   foo.bar && foo.baz
#
#   # good
#   foo&.bar || foo&.baz
#
#   # good
#   foo&.bar && (foobar.baz || foo&.baz)
#
# source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#29
class RuboCop::Cop::Lint::SafeNavigationConsistency < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::NilMethods
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#42
  def check(node); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#36
  def on_csend(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#61
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#67
  def location(node, unsafe_method_call); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#71
  def top_conditional_ancestor(node); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#82
  def unsafe_method_calls(method_calls, safe_nav_receiver); end
end

# source://rubocop//lib/rubocop/cop/lint/safe_navigation_consistency.rb#34
RuboCop::Cop::Lint::SafeNavigationConsistency::MSG = T.let(T.unsafe(nil), String)

# Checks to make sure safe navigation isn't used with `empty?` in
# a conditional.
#
# While the safe navigation operator is generally a good idea, when
# checking `foo&.empty?` in a conditional, `foo` being `nil` will actually
# do the opposite of what the author intends.
#
# @example
#   # bad
#   return if foo&.empty?
#   return unless foo&.empty?
#
#   # good
#   return if foo && foo.empty?
#   return unless foo && foo.empty?
#
# source://rubocop//lib/rubocop/cop/lint/safe_navigation_with_empty.rb#22
class RuboCop::Cop::Lint::SafeNavigationWithEmpty < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_with_empty.rb#32
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/lint/safe_navigation_with_empty.rb#28
  def safe_navigation_empty_in_conditional?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/lint/safe_navigation_with_empty.rb#25
RuboCop::Cop::Lint::SafeNavigationWithEmpty::MSG = T.let(T.unsafe(nil), String)

# Checks if a file which has a shebang line as
# its first line is granted execute permission.
#
# @example
#   # bad
#
#   # A file which has a shebang line as its first line is not
#   # granted execute permission.
#
#   #!/usr/bin/env ruby
#   puts 'hello, world'
#
#   # good
#
#   # A file which has a shebang line as its first line is
#   # granted execute permission.
#
#   #!/usr/bin/env ruby
#   puts 'hello, world'
#
#   # good
#
#   # A file which has not a shebang line as its first line is not
#   # granted execute permission.
#
#   puts 'hello, world'
#
# source://rubocop//lib/rubocop/cop/lint/script_permission.rb#33
class RuboCop::Cop::Lint::ScriptPermission < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/script_permission.rb#39
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/lint/script_permission.rb#55
  def autocorrect; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/script_permission.rb#59
  def executable?(processed_source); end

  # source://rubocop//lib/rubocop/cop/lint/script_permission.rb#66
  def format_message_from(processed_source); end
end

# source://rubocop//lib/rubocop/cop/lint/script_permission.rb#36
RuboCop::Cop::Lint::ScriptPermission::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/script_permission.rb#37
RuboCop::Cop::Lint::ScriptPermission::SHEBANG = T.let(T.unsafe(nil), String)

# Checks for self-assignments.
#
# @example
#   # bad
#   foo = foo
#   foo, bar = foo, bar
#   Foo = Foo
#   hash['foo'] = hash['foo']
#   obj.attr = obj.attr
#
#   # good
#   foo = bar
#   foo, bar = bar, foo
#   Foo = Bar
#   hash['foo'] = hash['bar']
#   obj.attr = obj.attr2
#
#   # good (method calls possibly can return different results)
#   hash[foo] = hash[foo]
#
# source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#26
class RuboCop::Cop::Lint::SelfAssignment < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#69
  def on_and_asgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#57
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#36
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#45
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#45
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#45
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#45
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#65
  def on_masgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#69
  def on_or_asgn(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#36
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#103
  def handle_attribute_assignment(node); end

  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#92
  def handle_key_assignment(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#77
  def multiple_self_assignment?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#87
  def rhs_matches_lhs?(rhs, lhs); end
end

# source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#29
RuboCop::Cop::Lint::SelfAssignment::ASSIGNMENT_TYPE_TO_RHS_TYPE = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/lint/self_assignment.rb#27
RuboCop::Cop::Lint::SelfAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for `send`, `public_send`, and `__send__` methods
# when using mix-in.
#
# `include` and `prepend` methods were private methods until Ruby 2.0,
# they were mixed-in via `send` method. This cop uses Ruby 2.1 or
# higher style that can be called by public methods.
# And `extend` method that was originally a public method is also targeted
# for style unification.
#
# @example
#   # bad
#   Foo.send(:include, Bar)
#   Foo.send(:prepend, Bar)
#   Foo.send(:extend, Bar)
#
#   # bad
#   Foo.public_send(:include, Bar)
#   Foo.public_send(:prepend, Bar)
#   Foo.public_send(:extend, Bar)
#
#   # bad
#   Foo.__send__(:include, Bar)
#   Foo.__send__(:prepend, Bar)
#   Foo.__send__(:extend, Bar)
#
#   # good
#   Foo.include Bar
#   Foo.prepend Bar
#   Foo.extend Bar
#
# source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#36
class RuboCop::Cop::Lint::SendWithMixinArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#53
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#46
  def send_with_mixin_argument?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#67
  def bad_location(node); end

  # source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#73
  def message(method, module_name, bad_method); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#77
  def mixin_method?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#41
RuboCop::Cop::Lint::SendWithMixinArgument::MIXIN_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#40
RuboCop::Cop::Lint::SendWithMixinArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#43
RuboCop::Cop::Lint::SendWithMixinArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/send_with_mixin_argument.rb#42
RuboCop::Cop::Lint::SendWithMixinArgument::SEND_METHODS = T.let(T.unsafe(nil), Array)

# Checks for shadowed arguments.
#
# This cop has `IgnoreImplicitReferences` configuration option.
# It means argument shadowing is used in order to pass parameters
# to zero arity `super` when `IgnoreImplicitReferences` is `true`.
#
# @example
#
#   # bad
#   do_something do |foo|
#   foo = 42
#   puts foo
#   end
#
#   def do_something(foo)
#   foo = 42
#   puts foo
#   end
#
#   # good
#   do_something do |foo|
#   foo = foo + 42
#   puts foo
#   end
#
#   def do_something(foo)
#   foo = foo + 42
#   puts foo
#   end
#
#   def do_something(foo)
#   puts foo
#   end
# @example IgnoreImplicitReferences: false (default)
#
#   # bad
#   def do_something(foo)
#   foo = 42
#   super
#   end
#
#   def do_something(foo)
#   foo = super
#   bar
#   end
# @example IgnoreImplicitReferences: true
#
#   # good
#   def do_something(foo)
#   foo = 42
#   super
#   end
#
#   def do_something(foo)
#   foo = super
#   bar
#   end
#
# source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#66
class RuboCop::Cop::Lint::ShadowedArgument < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#76
  def after_leaving_scope(scope, _variable_table); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#70
  def uses_var?(param0, param1); end

  private

  # Get argument references without assignments' references
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#161
  def argument_references(argument); end

  # Find the first argument assignment, which doesn't reference the
  # argument at the rhs. If the assignment occurs inside a branch or
  # block, it is impossible to tell whether it's executed, so precise
  # shadowing location is not known.
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#120
  def assignment_without_argument_usage(argument); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#82
  def check_argument(argument); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#171
  def ignore_implicit_references?; end

  # Check whether the given node is nested into block or conditional.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#152
  def node_within_block_or_conditional?(node, stop_search_node); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#144
  def reference_pos(node); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#95
  def shadowing_assignment(argument); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#72
    def joining_forces; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/shadowed_argument.rb#67
RuboCop::Cop::Lint::ShadowedArgument::MSG = T.let(T.unsafe(nil), String)

# Checks for a rescued exception that get shadowed by a
# less specific exception being rescued before a more specific
# exception is rescued.
#
# An exception is considered shadowed if it is rescued after its
# ancestor is, or if it and its ancestor are both rescued in the
# same `rescue` statement. In both cases, the more specific rescue is
# unnecessary because it is covered by rescuing the less specific
# exception. (ie. `rescue Exception, StandardError` has the same behavior
# whether `StandardError` is included or not, because all ``StandardError``s
# are rescued by `rescue Exception`).
#
# @example
#
#   # bad
#
#   begin
#   something
#   rescue Exception
#   handle_exception
#   rescue StandardError
#   handle_standard_error
#   end
#
#   # bad
#   begin
#   something
#   rescue Exception, StandardError
#   handle_error
#   end
#
#   # good
#
#   begin
#   something
#   rescue StandardError
#   handle_standard_error
#   rescue Exception
#   handle_exception
#   end
#
#   # good, however depending on runtime environment.
#   #
#   # This is a special case for system call errors.
#   # System dependent error code depends on runtime environment.
#   # For example, whether `Errno::EAGAIN` and `Errno::EWOULDBLOCK` are
#   # the same error code or different error code depends on environment.
#   # This good case is for `Errno::EAGAIN` and `Errno::EWOULDBLOCK` with
#   # the same error code.
#   begin
#   something
#   rescue Errno::EAGAIN, Errno::EWOULDBLOCK
#   handle_standard_error
#   end
#
# source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#61
class RuboCop::Cop::Lint::ShadowedException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#67
  def on_rescue(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#101
  def compare_exceptions(exception, other_exception); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#94
  def contains_multiple_levels_of_exceptions?(group); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#119
  def evaluate_exceptions(group); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#152
  def find_shadowing_rescue(rescues); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#84
  def offense_range(rescues); end

  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#90
  def rescued_groups_for(rescues); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#137
  def sorted?(rescued_groups); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#115
  def system_call_err?(error); end
end

# source://rubocop//lib/rubocop/cop/lint/shadowed_exception.rb#65
RuboCop::Cop::Lint::ShadowedException::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of local variable names from an outer scope
# in block arguments or block-local variables. This mirrors the warning
# given by `ruby -cw` prior to Ruby 2.6:
# "shadowing outer local variable - foo".
#
# NOTE: Shadowing of variables in block passed to `Ractor.new` is allowed
# because `Ractor` should not access outer variables.
# eg. following style is encouraged:
#
# [source,ruby]
# ----
# worker_id, pipe = env
# Ractor.new(worker_id, pipe) do |worker_id, pipe|
# end
# ----
#
# @example
#
#   # bad
#   def some_method
#   foo = 1
#
#   2.times do |foo| # shadowing outer `foo`
#   do_something(foo)
#   end
#   end
#
#   # good
#   def some_method
#   foo = 1
#
#   2.times do |bar|
#   do_something(bar)
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#41
class RuboCop::Cop::Lint::ShadowingOuterLocalVariable < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#53
  def before_declaring_variable(variable, variable_table); end

  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#89
  def find_conditional_node_from_ascendant(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#96
  def node_or_its_ascendant_conditional?(node); end

  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#45
  def ractor_block?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#65
  def same_conditions_node_different_branch?(variable, outer_local_variable); end

  # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#79
  def variable_node(variable); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#49
    def joining_forces; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/shadowing_outer_local_variable.rb#42
RuboCop::Cop::Lint::ShadowingOuterLocalVariable::MSG = T.let(T.unsafe(nil), String)

# Checks unexpected overrides of the `Struct` built-in methods
# via `Struct.new`.
#
# @example
#   # bad
#   Bad = Struct.new(:members, :clone, :count)
#   b = Bad.new([], true, 1)
#   b.members #=> [] (overriding `Struct#members`)
#   b.clone #=> true (overriding `Object#clone`)
#   b.count #=> 1 (overriding `Enumerable#count`)
#
#   # good
#   Good = Struct.new(:id, :name)
#   g = Good.new(1, "foo")
#   g.members #=> [:id, :name]
#   g.clone #=> #<struct Good id=1, name="foo">
#   g.count #=> 2
#
# source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#24
class RuboCop::Cop::Lint::StructNewOverride < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#38
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#33
  def struct_new(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#25
RuboCop::Cop::Lint::StructNewOverride::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#27
RuboCop::Cop::Lint::StructNewOverride::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#30
RuboCop::Cop::Lint::StructNewOverride::STRUCT_MEMBER_NAME_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/struct_new_override.rb#29
RuboCop::Cop::Lint::StructNewOverride::STRUCT_METHOD_NAMES = T.let(T.unsafe(nil), Array)

# Checks for `rescue` blocks with no body.
#
# @example
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   end
#
#   # good
#   def some_method
#   do_something
#   rescue
#   handle_exception
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   handle_exception
#   end
# @example AllowComments: true (default)
#
#   # good
#   def some_method
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
# @example AllowComments: false
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
# @example AllowNil: true (default)
#
#   # good
#   def some_method
#   do_something
#   rescue
#   nil
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # good
#   do_something rescue nil
# @example AllowNil: false
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   nil
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   nil
#   end
#
#   # bad
#   do_something rescue nil
#
# source://rubocop//lib/rubocop/cop/lint/suppressed_exception.rb#105
class RuboCop::Cop::Lint::SuppressedException < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/suppressed_exception.rb#108
  def on_resbody(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/suppressed_exception.rb#118
  def comment_between_rescue_and_end?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/suppressed_exception.rb#126
  def nil_body?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/suppressed_exception.rb#106
RuboCop::Cop::Lint::SuppressedException::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of literal strings converted to
# a symbol where a literal symbol could be used instead.
#
# There are two possible styles for this cop.
# `strict` (default) will register an offense for any incorrect usage.
# `consistent` additionally requires hashes to use the same style for
# every symbol key (ie. if any symbol key needs to be quoted it requires
# all keys to be quoted).
#
# @example
#   # bad
#   'string'.to_sym
#   :symbol.to_sym
#   'underscored_string'.to_sym
#   :'underscored_symbol'
#   'hyphenated-string'.to_sym
#   "string_#{interpolation}".to_sym
#
#   # good
#   :string
#   :symbol
#   :underscored_string
#   :underscored_symbol
#   :'hyphenated-string'
#   :"string_#{interpolation}"
# @example EnforcedStyle: strict (default)
#
#   # bad
#   {
#   'a': 1,
#   "b": 2,
#   'c-d': 3
#   }
#
#   # good (don't quote keys that don't require quoting)
#   {
#   a: 1,
#   b: 2,
#   'c-d': 3
#   }
# @example EnforcedStyle: consistent
#
#   # bad
#   {
#   a: 1,
#   'b-c': 2
#   }
#
#   # good (quote all keys if any need quoting)
#   {
#   'a': 1,
#   'b-c': 2
#   }
#
#   # good (no quoting required)
#   {
#   a: 1,
#   b: 2
#   }
#
# source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#68
class RuboCop::Cop::Lint::SymbolConversion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::SymbolHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#105
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#78
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#88
  def on_sym(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#147
  def correct_hash_key(node); end

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#166
  def correct_inconsistent_hash_keys(keys); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#139
  def in_alias?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#143
  def in_percent_literal_array?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#126
  def properly_quoted?(source, value); end

  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#122
  def register_offense(node, correction:, message: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#135
  def requires_quotes?(sym_node); end
end

# source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#73
RuboCop::Cop::Lint::SymbolConversion::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#74
RuboCop::Cop::Lint::SymbolConversion::MSG_CONSISTENCY = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/symbol_conversion.rb#76
RuboCop::Cop::Lint::SymbolConversion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Repacks Parser's diagnostics/errors
# into RuboCop's offenses.
#
# source://rubocop//lib/rubocop/cop/lint/syntax.rb#8
class RuboCop::Cop::Lint::Syntax < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/syntax.rb#9
  def on_other_file; end

  private

  # source://rubocop//lib/rubocop/cop/lint/syntax.rb#19
  def add_offense_from_diagnostic(diagnostic, ruby_version); end

  # source://rubocop//lib/rubocop/cop/lint/syntax.rb#29
  def add_offense_from_error(error); end

  # source://rubocop//lib/rubocop/cop/lint/syntax.rb#34
  def beautify_message(message); end

  # source://rubocop//lib/rubocop/cop/lint/syntax.rb#40
  def find_severity(_range, _severity); end
end

# Ensures that `to_enum`/`enum_for`, called for the current method,
# has correct arguments.
#
# @example
#   # bad
#   def foo(x, y = 1)
#   return to_enum(__callee__, x) # `y` is missing
#   end
#
#   # good
#   def foo(x, y = 1)
#   # Alternatives to `__callee__` are `__method__` and `:foo`.
#   return to_enum(__callee__, x, y)
#   end
#
#   # good
#   def foo(x, y = 1)
#   # It is also allowed if it is wrapped in some method like Sorbet.
#   return to_enum(T.must(__callee__), x, y)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#27
class RuboCop::Cop::Lint::ToEnumArguments < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#33
  def enum_conversion_call?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#38
  def method_name?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#47
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#43
  def passing_keyword_arg?(param0 = T.unsafe(nil), param1); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#76
  def argument_match?(send_arg, def_arg); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#61
  def arguments_match?(arguments, def_node); end
end

# source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#28
RuboCop::Cop::Lint::ToEnumArguments::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/to_enum_arguments.rb#30
RuboCop::Cop::Lint::ToEnumArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks to make sure `#to_json` includes an optional argument.
# When overriding `#to_json`, callers may invoke JSON
# generation via `JSON.generate(your_obj)`.  Since `JSON#generate` allows
# for an optional argument, your method should too.
#
# @example
#   class Point
#   attr_reader :x, :y
#
#   # bad, incorrect arity
#   def to_json
#   JSON.generate([x, y])
#   end
#
#   # good, preserving args
#   def to_json(*args)
#   JSON.generate([x, y], *args)
#   end
#
#   # good, discarding args
#   def to_json(*_args)
#   JSON.generate([x, y])
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/to_json.rb#31
class RuboCop::Cop::Lint::ToJSON < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/to_json.rb#36
  def on_def(node); end
end

# source://rubocop//lib/rubocop/cop/lint/to_json.rb#34
RuboCop::Cop::Lint::ToJSON::MSG = T.let(T.unsafe(nil), String)

# Checks for top level return with arguments. If there is a
# top-level return statement with an argument, then the argument is
# always ignored. This is detected automatically since Ruby 2.7.
#
# @example
#   # bad
#   return 1
#
#   # good
#   return
#
# source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#16
class RuboCop::Cop::Lint::TopLevelReturnWithArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#21
  def on_return(return_node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#35
  def remove_arguments(corrector, return_node); end

  # This cop works by validating the ancestors of the return node. A
  # top-level return node's ancestors should not be of block, def, or
  # defs type.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#42
  def top_level_return?(return_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#31
  def top_level_return_with_any_argument?(return_node); end
end

# source://rubocop//lib/rubocop/cop/lint/top_level_return_with_argument.rb#19
RuboCop::Cop::Lint::TopLevelReturnWithArgument::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing commas in attribute declarations, such as
# `#attr_reader`. Leaving a trailing comma will nullify the next method
# definition by overriding it with a getter method.
#
# @example
#
#   # bad
#   class Foo
#   attr_reader :foo,
#
#   def bar
#   puts "Unreachable."
#   end
#   end
#
#   # good
#   class Foo
#   attr_reader :foo
#
#   def bar
#   puts "No problem!"
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/lint/trailing_comma_in_attribute_declaration.rb#30
class RuboCop::Cop::Lint::TrailingCommaInAttributeDeclaration < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/trailing_comma_in_attribute_declaration.rb#36
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/trailing_comma_in_attribute_declaration.rb#46
  def trailing_comma_range(node); end
end

# source://rubocop//lib/rubocop/cop/lint/trailing_comma_in_attribute_declaration.rb#34
RuboCop::Cop::Lint::TrailingCommaInAttributeDeclaration::MSG = T.let(T.unsafe(nil), String)

# Checks for "triple quotes" (strings delimited by any odd number
# of quotes greater than 1).
#
# Ruby allows multiple strings to be implicitly concatenated by just
# being adjacent in a statement (ie. `"foo""bar" == "foobar"`). This sometimes
# gives the impression that there is something special about triple quotes, but
# in fact it is just extra unnecessary quotes and produces the same string. Each
# pair of quotes produces an additional concatenated empty string, so the result
# is still only the "actual" string within the delimiters.
#
# NOTE: Although this cop is called triple quotes, the same behavior is present
# for strings delimited by 5, 7, etc. quotation marks.
#
# @example
#   # bad
#   """
#   A string
#   """
#
#   # bad
#   '''
#   A string
#   '''
#
#   # good
#   "
#   A string
#   "
#
#   # good
#   <<STRING
#   A string
#   STRING
#
#   # good (but not the same spacing as the bad case)
#   'A string'
#
# source://rubocop//lib/rubocop/cop/lint/triple_quotes.rb#42
class RuboCop::Cop::Lint::TripleQuotes < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/triple_quotes.rb#47
  def on_dstr(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/triple_quotes.rb#65
  def empty_str_nodes(node); end
end

# source://rubocop//lib/rubocop/cop/lint/triple_quotes.rb#45
RuboCop::Cop::Lint::TripleQuotes::MSG = T.let(T.unsafe(nil), String)

# Checks for underscore-prefixed variables that are actually
# used.
#
# Since block keyword arguments cannot be arbitrarily named at call
# sites, the `AllowKeywordBlockArguments` will allow use of underscore-
# prefixed block keyword arguments.
#
# @example AllowKeywordBlockArguments: false (default)
#
#   # bad
#
#   [1, 2, 3].each do |_num|
#   do_something(_num)
#   end
#
#   query(:sales) do |_id:, revenue:, cost:|
#   {_id: _id, profit: revenue - cost}
#   end
#
#   # good
#
#   [1, 2, 3].each do |num|
#   do_something(num)
#   end
#
#   [1, 2, 3].each do |_num|
#   do_something # not using `_num`
#   end
# @example AllowKeywordBlockArguments: true
#
#   # good
#
#   query(:sales) do |_id:, revenue:, cost:|
#   {_id: _id, profit: revenue - cost}
#   end
#
# source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#43
class RuboCop::Cop::Lint::UnderscorePrefixedVariableName < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#50
  def after_leaving_scope(scope, _variable_table); end

  # source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#54
  def check_variable(variable); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#72
  def allowed_keyword_block_argument?(variable); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#46
    def joining_forces; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/underscore_prefixed_variable_name.rb#44
RuboCop::Cop::Lint::UnderscorePrefixedVariableName::MSG = T.let(T.unsafe(nil), String)

# Checks for a block that is known to need more positional
# block arguments than are given (by default this is configured for
# `Enumerable` methods needing 2 arguments). Optional arguments are allowed,
# although they don't generally make sense as the default value will
# be used. Blocks that have no receiver, or take splatted arguments
# (ie. `*args`) are always accepted.
#
# Keyword arguments (including `**kwargs`) do not get counted towards
# this, as they are not used by the methods in question.
#
# Method names and their expected arity can be configured like this:
#
# [source,yaml]
# ----
# Methods:
#   inject: 2
#   reduce: 2
# ----
#
# @example
#   # bad
#   values.reduce {}
#   values.min { |a| a }
#   values.sort { |a; b| a + b }
#
#   # good
#   values.reduce { |memo, obj| memo << obj }
#   values.min { |a, b| a <=> b }
#   values.sort { |*x| x[0] <=> x[1] }
#
# source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#41
class RuboCop::Cop::Lint::UnexpectedBlockArity < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#44
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#44
  def on_numblock(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#63
  def acceptable?(node); end

  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#75
  def arg_count(node); end

  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#71
  def expected_arity(method); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#67
  def included_method?(name); end

  # source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#59
  def methods; end
end

# source://rubocop//lib/rubocop/cop/lint/unexpected_block_arity.rb#42
RuboCop::Cop::Lint::UnexpectedBlockArity::MSG = T.let(T.unsafe(nil), String)

# Checks for using Fixnum or Bignum constant.
#
# @example
#
#   # bad
#   1.is_a?(Fixnum)
#   1.is_a?(Bignum)
#
#   # good
#   1.is_a?(Integer)
#
# source://rubocop//lib/rubocop/cop/lint/unified_integer.rb#16
class RuboCop::Cop::Lint::UnifiedInteger < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/unified_integer.rb#22
  def fixnum_or_bignum_const(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/unified_integer.rb#26
  def on_const(node); end
end

# source://rubocop//lib/rubocop/cop/lint/unified_integer.rb#19
RuboCop::Cop::Lint::UnifiedInteger::MSG = T.let(T.unsafe(nil), String)

# Looks for `reduce` or `inject` blocks where the value returned (implicitly or
# explicitly) does not include the accumulator. A block is considered valid as
# long as at least one return value includes the accumulator.
#
# If the accumulator is not included in the return value, then the entire
# block will just return a transformation of the last element value, and
# could be rewritten as such without a loop.
#
# Also catches instances where an index of the accumulator is returned, as
# this may change the type of object being retained.
#
# NOTE: For the purpose of reducing false positives, this cop only flags
# returns in `reduce` blocks where the element is the only variable in
# the expression (since we will not be able to tell what other variables
# relate to via static analysis).
#
# @example
#
#   # bad
#   (1..4).reduce(0) do |acc, el|
#   el * 2
#   end
#
#   # bad, may raise a NoMethodError after the first iteration
#   %w(a b c).reduce({}) do |acc, letter|
#   acc[letter] = true
#   end
#
#   # good
#   (1..4).reduce(0) do |acc, el|
#   acc + el * 2
#   end
#
#   # good, element is returned but modified using the accumulator
#   values.reduce do |acc, el|
#   el << acc
#   el
#   end
#
#   # good, returns the accumulator instead of the index
#   %w(a b c).reduce({}) do |acc, letter|
#   acc[letter] = true
#   acc
#   end
#
#   # good, at least one branch returns the accumulator
#   values.reduce(nil) do |result, value|
#   break result if something?
#   value
#   end
#
#   # good, recursive
#   keys.reduce(self) { |result, key| result[key] }
#
#   # ignored as the return value cannot be determined
#   enum.reduce do |acc, el|
#   x = foo(acc, el)
#   bar(x)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#65
class RuboCop::Cop::Lint::UnmodifiedReduceAccumulator < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#78
  def accumulator_index?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#83
  def element_modified?(param0, param1); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#104
  def expression_values(param0); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#93
  def lvar_used?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#115
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#115
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#70
  def reduce_with_block?(param0 = T.unsafe(nil)); end

  private

  # Determine if a return value is acceptable for the purposes of this cop
  # If it is an expression containing the accumulator, it is acceptable
  # Otherwise, it is only unacceptable if it contains the iterated element, since we
  # otherwise do not have enough information to prevent false positives.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#191
  def acceptable_return?(return_val, element_name); end

  # Exclude `begin` nodes inside a `dstr` from being collected by `return_values`
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#199
  def allowed_type?(parent_node); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#159
  def block_arg_name(node, index); end

  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#142
  def check_return_values(block_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#176
  def potential_offense?(return_values, block_body, element_name, accumulator_name); end

  # Return values in a block are either the value given to next,
  # the last line of a multiline block, or the only line of the block
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#128
  def return_values(block_body_node); end

  # Look for an index of the accumulator being returned, except where the index
  # is the element.
  # This is always an offense, in order to try to catch potential exceptions
  # due to type mismatches
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#167
  def returned_accumulator_index(return_values, accumulator_name, element_name); end

  # If the accumulator is used in any return value, the node is acceptable since
  # the accumulator has a chance to change each iteration
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#183
  def returns_accumulator_anywhere?(return_values, accumulator_name); end
end

# source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#66
RuboCop::Cop::Lint::UnmodifiedReduceAccumulator::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/unmodified_reduce_accumulator.rb#67
RuboCop::Cop::Lint::UnmodifiedReduceAccumulator::MSG_INDEX = T.let(T.unsafe(nil), String)

# Checks for unreachable code.
# The check are based on the presence of flow of control
# statement in non-final position in `begin` (implicit) blocks.
#
# @example
#
#   # bad
#   def some_method
#   return
#   do_something
#   end
#
#   # bad
#   def some_method
#   if cond
#   return
#   else
#   return
#   end
#   do_something
#   end
#
#   # good
#   def some_method
#   do_something
#   end
#
# source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#32
class RuboCop::Cop::Lint::UnreachableCode < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#50
  def flow_command?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#35
  def on_begin(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#35
  def on_kwbegin(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#82
  def check_case(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#76
  def check_if(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#60
  def flow_expression?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/unreachable_code.rb#33
RuboCop::Cop::Lint::UnreachableCode::MSG = T.let(T.unsafe(nil), String)

# Checks for loops that will have at most one iteration.
#
# A loop that can never reach the second iteration is a possible error in the code.
# In rare cases where only one iteration (or at most one iteration) is intended behavior,
# the code should be refactored to use `if` conditionals.
#
# NOTE: Block methods that are used with ``Enumerable``s are considered to be loops.
#
# `AllowedPatterns` can be used to match against the block receiver in order to allow
# code that would otherwise be registered as an offense (eg. `times` used not in an
# `Enumerable` context).
#
# @example
#   # bad
#   while node
#   do_something(node)
#   node = node.parent
#   break
#   end
#
#   # good
#   while node
#   do_something(node)
#   node = node.parent
#   end
#
#   # bad
#   def verify_list(head)
#   item = head
#   begin
#   if verify(item)
#   return true
#   else
#   return false
#   end
#   end while(item)
#   end
#
#   # good
#   def verify_list(head)
#   item = head
#   begin
#   if verify(item)
#   item = item.next
#   else
#   return false
#   end
#   end while(item)
#
#   true
#   end
#
#   # bad
#   def find_something(items)
#   items.each do |item|
#   if something?(item)
#   return item
#   else
#   raise NotFoundError
#   end
#   end
#   end
#
#   # good
#   def find_something(items)
#   items.each do |item|
#   if something?(item)
#   return item
#   end
#   end
#   raise NotFoundError
#   end
#
#   # bad
#   2.times { raise ArgumentError }
# @example AllowedPatterns: ['(exactly|at_least|at_most)\(\d+\)\.times'] (default)
#
#   # good
#   exactly(2).times { raise StandardError }
#
# source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#86
class RuboCop::Cop::Lint::UnreachableLoop < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#143
  def break_command?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#100
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#92
  def on_for(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#104
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#92
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#92
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#92
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#92
  def on_while_post(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#153
  def break_statement?(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#119
  def check(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#176
  def check_case(node); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#170
  def check_if(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#200
  def conditional_continue_keyword?(break_statement); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#110
  def loop_method?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#190
  def preceded_by_continue_statement?(break_statement); end

  # source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#130
  def statements(node); end
end

# source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#90
RuboCop::Cop::Lint::UnreachableLoop::CONTINUE_KEYWORDS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/unreachable_loop.rb#89
RuboCop::Cop::Lint::UnreachableLoop::MSG = T.let(T.unsafe(nil), String)

# Common functionality for cops handling unused arguments.
#
# source://rubocop//lib/rubocop/cop/mixin/unused_argument.rb#7
module RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/unused_argument.rb#10
  def after_leaving_scope(scope, _variable_table); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/unused_argument.rb#16
  def check_argument(variable); end
end

# Checks for unused block arguments.
#
# @example
#   # bad
#   do_something do |used, unused|
#   puts used
#   end
#
#   do_something do |bar|
#   puts :foo
#   end
#
#   define_method(:foo) do |bar|
#   puts :baz
#   end
#
#   # good
#   do_something do |used, _unused|
#   puts used
#   end
#
#   do_something do
#   puts :foo
#   end
#
#   define_method(:foo) do |_bar|
#   puts :baz
#   end
# @example IgnoreEmptyBlocks: true (default)
#   # good
#   do_something { |unused| }
# @example IgnoreEmptyBlocks: false
#   # bad
#   do_something { |unused| }
# @example AllowUnusedKeywordArguments: false (default)
#   # bad
#   do_something do |unused: 42|
#   foo
#   end
# @example AllowUnusedKeywordArguments: true
#   # good
#   do_something do |unused: 42|
#   foo
#   end
#
# source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#55
class RuboCop::Cop::Lint::UnusedBlockArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::Cop::AutoCorrector

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#162
  def allow_unused_keyword_arguments?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#81
  def allowed_block?(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#85
  def allowed_keyword_argument?(variable); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#99
  def augment_message(message, variable); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#65
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#69
  def check_argument(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#149
  def define_method_call?(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#156
  def empty_block?(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#166
  def ignore_empty_blocks?; end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#89
  def message(variable); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#132
  def message_for_lambda(variable, all_arguments); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#120
  def message_for_normal_block(variable, all_arguments); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#144
  def message_for_underscore_prefix(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#77
  def used_block_local?(variable); end

  # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#112
  def variable_type(variable); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/unused_block_argument.rb#59
    def joining_forces; end
  end
end

# Checks for unused method arguments.
#
# @example
#   # bad
#   def some_method(used, unused, _unused_but_allowed)
#   puts used
#   end
#
#   # good
#   def some_method(used, _unused, _unused_but_allowed)
#   puts used
#   end
# @example AllowUnusedKeywordArguments: false (default)
#   # bad
#   def do_something(used, unused: 42)
#   used
#   end
# @example AllowUnusedKeywordArguments: true
#   # good
#   def do_something(used, unused: 42)
#   used
#   end
# @example IgnoreEmptyMethods: true (default)
#   # good
#   def do_something(unused)
#   end
# @example IgnoreEmptyMethods: false
#   # bad
#   def do_something(unused)
#   end
# @example IgnoreNotImplementedMethods: true (default)
#   # good
#   def do_something(unused)
#   raise NotImplementedError
#   end
#
#   def do_something_else(unused)
#   fail "TODO"
#   end
# @example IgnoreNotImplementedMethods: false
#   # bad
#   def do_something(unused)
#   raise NotImplementedError
#   end
#
#   def do_something_else(unused)
#   fail "TODO"
#   end
#
# source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#61
class RuboCop::Cop::Lint::UnusedMethodArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#66
  def not_implemented?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#81
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#85
  def check_argument(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#93
  def ignored_method?(body); end

  # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#98
  def message(variable); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#71
    def autocorrect_incompatible_with; end

    # source://rubocop//lib/rubocop/cop/lint/unused_method_argument.rb#75
    def joining_forces; end
  end
end

# Identifies places where `URI.escape` can be replaced by
# `CGI.escape`, `URI.encode_www_form`, or `URI.encode_www_form_component`
# depending on your specific use case.
# Also this cop identifies places where `URI.unescape` can be replaced by
# `CGI.unescape`, `URI.decode_www_form`,
# or `URI.decode_www_form_component` depending on your specific use case.
#
# @example
#   # bad
#   URI.escape('http://example.com')
#   URI.encode('http://example.com')
#
#   # good
#   CGI.escape('http://example.com')
#   URI.encode_www_form([['example', 'param'], ['lang', 'en']])
#   URI.encode_www_form(page: 10, locale: 'en')
#   URI.encode_www_form_component('http://example.com')
#
#   # bad
#   URI.unescape(enc_uri)
#   URI.decode(enc_uri)
#
#   # good
#   CGI.unescape(enc_uri)
#   URI.decode_www_form(enc_uri)
#   URI.decode_www_form_component(enc_uri)
#
# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#32
class RuboCop::Cop::Lint::UriEscapeUnescape < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#57
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#51
  def uri_escape_unescape?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#33
RuboCop::Cop::Lint::UriEscapeUnescape::ALTERNATE_METHODS_OF_URI_ESCAPE = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#38
RuboCop::Cop::Lint::UriEscapeUnescape::ALTERNATE_METHODS_OF_URI_UNESCAPE = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#47
RuboCop::Cop::Lint::UriEscapeUnescape::METHOD_NAMES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#44
RuboCop::Cop::Lint::UriEscapeUnescape::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/uri_escape_unescape.rb#48
RuboCop::Cop::Lint::UriEscapeUnescape::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `URI.regexp` is obsolete and should
# not be used. Instead, use `URI::DEFAULT_PARSER.make_regexp`.
#
# @example
#   # bad
#   URI.regexp('http://example.com')
#
#   # good
#   URI::DEFAULT_PARSER.make_regexp('http://example.com')
#
# source://rubocop//lib/rubocop/cop/lint/uri_regexp.rb#16
class RuboCop::Cop::Lint::UriRegexp < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/uri_regexp.rb#23
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/lint/uri_regexp.rb#19
RuboCop::Cop::Lint::UriRegexp::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/uri_regexp.rb#21
RuboCop::Cop::Lint::UriRegexp::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/uri_regexp.rb#20
RuboCop::Cop::Lint::UriRegexp::URI_CONSTANTS = T.let(T.unsafe(nil), Array)

# Checks for redundant access modifiers, including those with no
# code, those which are repeated, and leading `public` modifiers in a
# class or module body. Conditionally-defined methods are considered as
# always being defined, and thus access modifiers guarding such methods
# are not redundant.
#
# This cop has `ContextCreatingMethods` option. The default setting value
# is an empty array that means no method is specified.
# This setting is an array of methods which, when called, are known to
# create its own context in the module's current access context.
#
# It also has `MethodCreatingMethods` option. The default setting value
# is an empty array that means no method is specified.
# This setting is an array of methods which, when called, are known to
# create other methods in the module's current access context.
#
# @example
#   # bad
#   class Foo
#   public # this is redundant (default access is public)
#
#   def method
#   end
#   end
#
#   # bad
#   class Foo
#   # The following is redundant (methods defined on the class'
#   # singleton class are not affected by the private modifier)
#   private
#
#   def self.method3
#   end
#   end
#
#   # bad
#   class Foo
#   protected
#
#   define_method(:method2) do
#   end
#
#   protected # this is redundant (repeated from previous modifier)
#
#   [1,2,3].each do |i|
#   define_method("foo#{i}") do
#   end
#   end
#   end
#
#   # bad
#   class Foo
#   private # this is redundant (no following methods are defined)
#   end
#
#   # good
#   class Foo
#   private # this is not redundant (a method is defined)
#
#   def method2
#   end
#   end
#
#   # good
#   class Foo
#   # The following is not redundant (conditionally defined methods are
#   # considered as always defining a method)
#   private
#
#   if condition?
#   def method
#   end
#   end
#   end
#
#   # good
#   class Foo
#   protected # this is not redundant (a method is defined)
#
#   define_method(:method2) do
#   end
#   end
# @example ContextCreatingMethods: concerning
#   # Lint/UselessAccessModifier:
#   #   ContextCreatingMethods:
#   #     - concerning
#
#   # good
#   require 'active_support/concern'
#   class Foo
#   concerning :Bar do
#   def some_public_method
#   end
#
#   private
#
#   def some_private_method
#   end
#   end
#
#   # this is not redundant because `concerning` created its own context
#   private
#
#   def some_other_private_method
#   end
#   end
# @example MethodCreatingMethods: delegate
#   # Lint/UselessAccessModifier:
#   #   MethodCreatingMethods:
#   #     - delegate
#
#   # good
#   require 'active_support/core_ext/module/delegation'
#   class Foo
#   # this is not redundant because `delegate` creates methods
#   private
#
#   delegate :method_a, to: :method_b
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#127
class RuboCop::Cop::Lint::UselessAccessModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#166
  def class_or_instance_eval?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#161
  def dynamic_method_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#139
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#133
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#133
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#139
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#133
  def on_sclass(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#156
  def static_method_definition?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#182
  def access_modifier?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#280
  def any_context_creating_methods?(child); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#257
  def any_method_definition?(child); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#149
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#196
  def check_child_nodes(node, unused, cur_vis); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#226
  def check_new_visibility(node, unused, new_vis, cur_vis); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#170
  def check_node(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#186
  def check_scope(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#215
  def check_send_node(node, cur_vis, unused); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#274
  def eval_call?(child); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#247
  def included_block?(block_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#251
  def method_definition?(child); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#270
  def start_of_new_scope?(child); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_access_modifier.rb#131
RuboCop::Cop::Lint::UselessAccessModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for every useless assignment to local variable in every
# scope.
# The basic idea for this cop was from the warning of `ruby -cw`:
#
# [source,console]
# ----
# assigned but unused variable - foo
# ----
#
# Currently this cop has advanced logic that detects unreferenced
# reassignments and properly handles varied cases such as branch, loop,
# rescue, ensure, etc.
#
# NOTE: Given the assignment `foo = 1, bar = 2`, removing unused variables
# can lead to a syntax error, so this case is not autocorrected.
#
# @example
#
#   # bad
#   def some_method
#   some_var = 1
#   do_something
#   end
#
#   # good
#   def some_method
#   some_var = 1
#   do_something(some_var)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#41
class RuboCop::Cop::Lint::UselessAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#52
  def after_leaving_scope(scope, _variable_table); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#158
  def autocorrect(corrector, assignment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#99
  def chained_assignment?(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#57
  def check_for_unused_assignments(variable); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#142
  def collect_variable_like_names(scope); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#75
  def message_for_useless_assignment(assignment); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#103
  def message_specification(assignment, variable); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#113
  def multiple_assignment_message(variable_name); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#81
  def offense_range(assignment); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#118
  def operator_assignment_message(scope, assignment); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#175
  def remove_exception_assignment_part(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#199
  def remove_local_variable_assignment_part(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#188
  def remove_trailing_character_from_operator(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#184
  def rename_variable_with_underscore(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#192
  def replace_named_capture_group_with_non_capturing_group(corrector, node, variable_name); end

  # TODO: More precise handling (rescue, ensure, nested begin, etc.)
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#132
  def return_value_node_of_scope(scope); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#89
  def sequential_assignment?(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#125
  def similar_name_message(variable); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#151
  def variable_like_method_invocation?(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#48
    def joining_forces; end
  end
end

# source://rubocop//lib/rubocop/cop/lint/useless_assignment.rb#46
RuboCop::Cop::Lint::UselessAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for useless `else` in `begin..end` without `rescue`.
#
# NOTE: This syntax is no longer valid on Ruby 2.6 or higher.
#
# @example
#
#   # bad
#   begin
#   do_something
#   else
#   do_something_else # This will never be run.
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   handle_errors
#   else
#   do_something_else
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_else_without_rescue.rb#27
class RuboCop::Cop::Lint::UselessElseWithoutRescue < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/useless_else_without_rescue.rb#30
  def on_new_investigation; end
end

# source://rubocop//lib/rubocop/cop/lint/useless_else_without_rescue.rb#28
RuboCop::Cop::Lint::UselessElseWithoutRescue::MSG = T.let(T.unsafe(nil), String)

# Checks for useless method definitions, specifically: empty constructors
# and methods just delegating to `super`.
#
# @example
#   # bad
#   def initialize
#   super
#   end
#
#   def method
#   super
#   end
#
#   # good - with default arguments
#   def initialize(x = Object.new)
#   super
#   end
#
#   # good
#   def initialize
#   super
#   initialize_internals
#   end
#
#   def method(*args)
#   super(:extra_arg, *args)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#38
class RuboCop::Cop::Lint::UselessMethodDefinition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#43
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#43
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#65
  def delegating?(node, def_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#57
  def method_definition_with_modifier?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#61
  def use_rest_or_optional_args?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_method_definition.rb#41
RuboCop::Cop::Lint::UselessMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for useless `rescue`s, which only reraise rescued exceptions.
#
# @example
#   # bad
#   def foo
#   do_something
#   rescue
#   raise
#   end
#
#   # bad
#   def foo
#   do_something
#   rescue => e
#   raise # or 'raise e', or 'raise $!', or 'raise $ERROR_INFO'
#   end
#
#   # good
#   def foo
#   do_something
#   rescue
#   do_cleanup
#   raise
#   end
#
#   # bad (latest rescue)
#   def foo
#   do_something
#   rescue ArgumentError
#   # noop
#   rescue
#   raise
#   end
#
#   # good (not the latest rescue)
#   def foo
#   do_something
#   rescue ArgumentError
#   raise
#   rescue
#   # noop
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#49
class RuboCop::Cop::Lint::UselessRescue < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#52
  def on_rescue(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#83
  def exception_objects(resbody_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#60
  def only_reraising?(resbody_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#75
  def use_exception_variable_in_ensure?(resbody_node); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_rescue.rb#50
RuboCop::Cop::Lint::UselessRescue::MSG = T.let(T.unsafe(nil), String)

# Looks for `ruby2_keywords` calls for methods that do not need it.
#
# `ruby2_keywords` should only be called on methods that accept an argument splat
# (`\*args`) but do not explicit keyword arguments (`k:` or `k: true`) or
# a keyword splat (`**kwargs`).
#
# @example
#   # good (splat argument without keyword arguments)
#   ruby2_keywords def foo(*args); end
#
#   # bad (no arguments)
#   ruby2_keywords def foo; end
#
#   # good
#   def foo; end
#
#   # bad (positional argument)
#   ruby2_keywords def foo(arg); end
#
#   # good
#   def foo(arg); end
#
#   # bad (double splatted argument)
#   ruby2_keywords def foo(**args); end
#
#   # good
#   def foo(**args); end
#
#   # bad (keyword arguments)
#   ruby2_keywords def foo(i:, j:); end
#
#   # good
#   def foo(i:, j:); end
#
#   # bad (splat argument with keyword arguments)
#   ruby2_keywords def foo(*args, i:, j:); end
#
#   # good
#   def foo(*args, i:, j:); end
#
#   # bad (splat argument with double splat)
#   ruby2_keywords def foo(*args, **kwargs); end
#
#   # good
#   def foo(*args, **kwargs); end
#
#   # bad (ruby2_keywords given a symbol)
#   def foo; end
#   ruby2_keywords :foo
#
#   # good
#   def foo; end
#
#   # bad (ruby2_keywords with dynamic method)
#   define_method(:foo) { |arg| }
#   ruby2_keywords :foo
#
#   # good
#   define_method(:foo) { |arg| }
#
# source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#66
class RuboCop::Cop::Lint::UselessRuby2Keywords < ::RuboCop::Cop::Base
  # Looks for statically or dynamically defined methods with a given name
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#72
  def method_definition(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#79
  def on_send(node); end

  private

  # `ruby2_keywords` is only allowed if there's a `restarg` and no keyword arguments
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#118
  def allowed_arguments(arguments); end

  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#109
  def find_method_definition(node, method_name); end

  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#91
  def inspect_def(node, def_node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#97
  def inspect_sym(node, sym_node); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#67
RuboCop::Cop::Lint::UselessRuby2Keywords::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/useless_ruby2_keywords.rb#68
RuboCop::Cop::Lint::UselessRuby2Keywords::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for setter call to local variable as the final
# expression of a function definition.
#
# @example
#
#   # bad
#   def something
#   x = Something.new
#   x.attr = 5
#   end
#
#   # good
#   def something
#   x = Something.new
#   x.attr = 5
#   x
#   end
#
# source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#31
class RuboCop::Cop::Lint::UselessSetterCall < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#37
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#37
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#59
  def setter_call_to_local_variable?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#63
  def last_expression(body); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#35
RuboCop::Cop::Lint::UselessSetterCall::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#34
RuboCop::Cop::Lint::UselessSetterCall::MSG = T.let(T.unsafe(nil), String)

# This class tracks variable assignments in a method body
# and if a variable contains object passed as argument at the end of
# the method.
#
# source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#72
class RuboCop::Cop::Lint::UselessSetterCall::MethodVariableTracker
  # @return [MethodVariableTracker] a new instance of MethodVariableTracker
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#73
  def initialize(body_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#159
  def constructor?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#78
  def contain_local_object?(variable_name); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#148
  def process_assignment(asgn_node, rhs_node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#96
  def process_assignment_node(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#138
  def process_binary_operator_assignment(op_asgn_node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#129
  def process_logical_operator_assignment(asgn_node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#110
  def process_multiple_assignment(masgn_node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_setter_call.rb#88
  def scan(node, &block); end
end

# Checks for uses of `Integer#times` that will never yield
# (when the integer ``<= 0``) or that will only ever yield once
# (`1.times`).
#
# @example
#   # bad
#   -5.times { do_something }
#   0.times { do_something }
#   1.times { do_something  }
#   1.times { |i| do_something(i) }
#
#   # good
#   do_something
#   do_something(1)
#
# source://rubocop//lib/rubocop/cop/lint/useless_times.rb#24
class RuboCop::Cop::Lint::UselessTimes < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#37
  def block_arg(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#42
  def block_reassigns_arg?(param0, param1); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#46
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#32
  def times_call?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#62
  def autocorrect(corrector, count, node, proc_name); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#84
  def autocorrect_block(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#80
  def autocorrect_block_pass(corrector, node, proc_name); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#94
  def fix_indentation(source, range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#72
  def never_process?(count, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#106
  def own_line?(node); end

  # source://rubocop//lib/rubocop/cop/lint/useless_times.rb#76
  def remove_node(corrector, node); end
end

# source://rubocop//lib/rubocop/cop/lint/useless_times.rb#28
RuboCop::Cop::Lint::UselessTimes::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/useless_times.rb#29
RuboCop::Cop::Lint::UselessTimes::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for operators, variables, literals, lambda, proc and nonmutating
# methods used in void context.
#
# `each` blocks are allowed to prevent false positives.
# For example, the expression inside the `each` block below.
# It's not void, especially when the receiver is an `Enumerator`:
#
# [source,ruby]
# ----
# enumerator = [1, 2, 3].filter
# enumerator.each { |item| item >= 2 } #=> [2, 3]
# ----
#
# @example CheckForMethodsWithNoSideEffects: false (default)
#   # bad
#   def some_method
#   some_num * 10
#   do_something
#   end
#
#   def some_method(some_var)
#   some_var
#   do_something
#   end
# @example CheckForMethodsWithNoSideEffects: true
#   # bad
#   def some_method(some_array)
#   some_array.sort
#   do_something(some_array)
#   end
#
#   # good
#   def some_method
#   do_something
#   some_num * 10
#   end
#
#   def some_method(some_var)
#   do_something
#   some_var
#   end
#
#   def some_method(some_array)
#   some_array.sort!
#   do_something(some_array)
#   end
#
# source://rubocop//lib/rubocop/cop/lint/void.rb#53
class RuboCop::Cop::Lint::Void < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/lint/void.rb#92
  def on_begin(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#82
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#92
  def on_kwbegin(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#82
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/lint/void.rb#222
  def autocorrect_nonmutating_send(corrector, node, suggestion); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#216
  def autocorrect_void_expression(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#204
  def autocorrect_void_op(corrector, node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#99
  def check_begin(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#113
  def check_expression(expr); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#154
  def check_literal(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#178
  def check_nonmutating(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#162
  def check_self(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#136
  def check_var(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#170
  def check_void_expression(node); end

  # source://rubocop//lib/rubocop/cop/lint/void.rb#125
  def check_void_op(node, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/void.rb#231
  def entirely_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/lint/void.rb#196
  def in_void_context?(node); end
end

# source://rubocop//lib/rubocop/cop/lint/void.rb#66
RuboCop::Cop::Lint::Void::BINARY_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#60
RuboCop::Cop::Lint::Void::CONST_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#63
RuboCop::Cop::Lint::Void::EXPRESSION_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#61
RuboCop::Cop::Lint::Void::LIT_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#77
RuboCop::Cop::Lint::Void::METHODS_REPLACEABLE_BY_EACH = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#79
RuboCop::Cop::Lint::Void::NONMUTATING_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#70
RuboCop::Cop::Lint::Void::NONMUTATING_METHODS_WITH_BANG_VERSION = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#64
RuboCop::Cop::Lint::Void::NONMUTATING_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#68
RuboCop::Cop::Lint::Void::OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#58
RuboCop::Cop::Lint::Void::OP_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#62
RuboCop::Cop::Lint::Void::SELF_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#67
RuboCop::Cop::Lint::Void::UNARY_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/lint/void.rb#59
RuboCop::Cop::Lint::Void::VAR_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/lint/void.rb#69
RuboCop::Cop::Lint::Void::VOID_CONTEXT_TYPES = T.let(T.unsafe(nil), Array)

# Common functionality for obtaining source ranges from regexp matches
#
# source://rubocop//lib/rubocop/cop/mixin/match_range.rb#6
module RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::RangeHelp

  private

  # Return a new `Range` covering the first matching group number for each
  # match of `regex` inside `range`
  #
  # source://rubocop//lib/rubocop/cop/mixin/match_range.rb#13
  def each_match_range(range, regex); end

  # For a `match` inside `range`, return a new `Range` covering the match
  #
  # source://rubocop//lib/rubocop/cop/mixin/match_range.rb#18
  def match_range(range, match); end
end

# Message Annotator class annotates a basic offense message
# based on params passed into initializer.
#
#  #=> 'Cop/CopName: message (http://example.org/styleguide)'
#
# @example
#   RuboCop::Cop::MessageAnnotator.new(
#   config, cop_name, cop_config, @options
#   ).annotate('message')
# @see #initialize
#
# source://rubocop//lib/rubocop/cop/message_annotator.rb#15
class RuboCop::Cop::MessageAnnotator
  # @option cop_config
  # @option cop_config
  # @option cop_config
  # @option options
  # @option options
  # @option options
  # @option options
  # @param config [RuboCop::Config] Check configs for all cops
  #   @note Message Annotator specifically checks the
  #   following config options for_all_cops
  #   :StyleGuideBaseURL [String] URL for styleguide
  #   :DisplayStyleGuide [Boolean] Include styleguide and reference URLs
  #   :ExtraDetails [Boolean] Include cop details
  #   :DisplayCopNames [Boolean] Include cop name
  # @param cop_name [String] for specific cop name
  # @param cop_config [Hash] configs for specific cop, from config#for_cop
  # @param options [Hash, nil] optional
  # @return [MessageAnnotator] a new instance of MessageAnnotator
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#47
  def initialize(config, cop_name, cop_config, options); end

  # Returns the annotated message,
  # based on params passed into initializer
  #
  # @return [String] annotated message
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#58
  def annotate(message); end

  # Returns the value of attribute config.
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#16
  def config; end

  # Returns the value of attribute cop_config.
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#16
  def cop_config; end

  # Returns the value of attribute cop_name.
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#16
  def cop_name; end

  # Returns the value of attribute options.
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#16
  def options; end

  # source://rubocop//lib/rubocop/cop/message_annotator.rb#68
  def urls; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#111
  def debug?; end

  # source://rubocop//lib/rubocop/cop/message_annotator.rb#124
  def details; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#115
  def display_cop_names?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#98
  def display_style_guide?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#107
  def extra_details?; end

  # source://rubocop//lib/rubocop/cop/message_annotator.rb#102
  def reference_urls; end

  # Returns the base style guide URL from AllCops or the specific department
  #
  # @return [String] style guide URL
  #
  # source://rubocop//lib/rubocop/cop/message_annotator.rb#91
  def style_guide_base_url; end

  # source://rubocop//lib/rubocop/cop/message_annotator.rb#74
  def style_guide_url; end

  class << self
    # Returns the value of attribute style_guide_urls.
    #
    # source://rubocop//lib/rubocop/cop/message_annotator.rb#21
    def style_guide_urls; end
  end
end

# This module handles measurement and reporting of complexity in methods.
#
# @api private
#
# source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#8
module RuboCop::Cop::MethodComplexity
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  extend ::RuboCop::AST::NodePattern::Macros
  extend ::RuboCop::ExcludeLimit

  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#37
  def define_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#24
  def on_block(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#17
  def on_def(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#17
  def on_defs(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#24
  def on_numblock(node); end

  private

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#42
  def check_complexity(node, method_name); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#61
  def complexity(body); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/mixin/method_complexity.rb#73
  def location(node); end
end

# Common code for cops that deal with preferred methods.
#
# source://rubocop//lib/rubocop/cop/mixin/method_preference.rb#6
module RuboCop::Cop::MethodPreference
  private

  # source://rubocop//lib/rubocop/cop/mixin/method_preference.rb#25
  def default_cop_config; end

  # source://rubocop//lib/rubocop/cop/mixin/method_preference.rb#9
  def preferred_method(method); end

  # source://rubocop//lib/rubocop/cop/mixin/method_preference.rb#13
  def preferred_methods; end
end

# source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#5
module RuboCop::Cop::Metrics; end

# Checks that the ABC size of methods is not higher than the
# configured maximum. The ABC size is based on assignments, branches
# (method calls), and conditions. See http://c2.com/cgi/wiki?AbcMetric
# and https://en.wikipedia.org/wiki/ABC_Software_Metric.
#
# Interpreting ABC size:
#
# * ``<= 17`` satisfactory
# * `18..30` unsatisfactory
# * `>` 30 dangerous
#
# You can have repeated "attributes" calls count as a single "branch".
# For this purpose, attributes are any method with no argument; no attempt
# is meant to distinguish actual `attr_reader` from other methods.
#
# This cop also takes into account `AllowedMethods` (defaults to `[]`)
# And `AllowedPatterns` (defaults to `[]`)
#
# @example CountRepeatedAttributes: false (default is true)
#
#   # `model` and `current_user`, referenced 3 times each,
#   # are each counted as only 1 branch each if
#   # `CountRepeatedAttributes` is set to 'false'
#
#   def search
#   @posts = model.active.visible_by(current_user)
#   .search(params[:q])
#   @posts = model.some_process(@posts, current_user)
#   @posts = model.another_process(@posts, current_user)
#
#   render 'pages/search/page'
#   end
#
# source://rubocop//lib/rubocop/cop/metrics/abc_size.rb#39
class RuboCop::Cop::Metrics::AbcSize < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  include ::RuboCop::Cop::MethodComplexity

  private

  # source://rubocop//lib/rubocop/cop/metrics/abc_size.rb#47
  def complexity(node); end
end

# source://rubocop//lib/rubocop/cop/metrics/abc_size.rb#42
RuboCop::Cop::Metrics::AbcSize::MSG = T.let(T.unsafe(nil), String)

# Checks if the length of a block exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
# The cop can be configured to ignore blocks passed to certain methods.
#
# You can set constructs you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', 'heredoc', and 'method_call'. Each construct
# will be counted as one line regardless of its actual size.
#
# NOTE: This cop does not apply for `Struct` definitions.
#
# NOTE: The `ExcludedMethods` configuration is deprecated and only kept
# for backwards compatibility. Please use `AllowedMethods` and `AllowedPatterns`
# instead. By default, there are no methods to allowed.
#
# @example CountAsOne: ['array', 'heredoc', 'method_call']
#
#   something do
#   array = [         # +1
#   1,
#   2
#   ]
#
#   hash = {          # +3
#   key: 'value'
#   }
#
#   msg = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#
#   foo(              # +1
#   1,
#   2
#   )
#   end                 # 6 points
#
# source://rubocop//lib/rubocop/cop/metrics/block_length.rb#44
class RuboCop::Cop::Metrics::BlockLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/metrics/block_length.rb#51
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/metrics/block_length.rb#51
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/block_length.rb#80
  def cop_label; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/block_length.rb#62
  def method_receiver_excluded?(node); end
end

# source://rubocop//lib/rubocop/cop/metrics/block_length.rb#49
RuboCop::Cop::Metrics::BlockLength::LABEL = T.let(T.unsafe(nil), String)

# Checks for excessive nesting of conditional and looping constructs.
#
# You can configure if blocks are considered using the `CountBlocks` and `CountModifierForms`
# options. When both are set to `false` (the default) blocks and modifier forms are not
# counted towards the nesting level. Set them to `true` to include these in the nesting level
# calculation as well.
#
# The maximum level of nesting allowed is configurable.
#
# source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#14
class RuboCop::Cop::Metrics::BlockNesting < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#19
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#28
  def check_nesting_level(node, max, current_level); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#52
  def consider_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#62
  def count_blocks?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#44
  def count_if_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#66
  def count_modifier_forms?; end

  # source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#58
  def message(max); end
end

# source://rubocop//lib/rubocop/cop/metrics/block_nesting.rb#15
RuboCop::Cop::Metrics::BlockNesting::NESTING_BLOCKS = T.let(T.unsafe(nil), Array)

# Checks if the length of a class exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
#
# You can set constructs you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', 'heredoc', and 'method_call'. Each construct
# will be counted as one line regardless of its actual size.
#
# NOTE: This cop also applies for `Struct` definitions.
#
# @example CountAsOne: ['array', 'heredoc', 'method_call']
#
#   class Foo
#   ARRAY = [         # +1
#   1,
#   2
#   ]
#
#   HASH = {          # +3
#   key: 'value'
#   }
#
#   MSG = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#
#   foo(              # +1
#   1,
#   2
#   )
#   end                 # 6 points
#
# source://rubocop//lib/rubocop/cop/metrics/class_length.rb#39
class RuboCop::Cop::Metrics::ClassLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength

  # source://rubocop//lib/rubocop/cop/metrics/class_length.rb#52
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/metrics/class_length.rb#42
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/metrics/class_length.rb#46
  def on_sclass(node); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/class_length.rb#70
  def message(length, max_length); end
end

# Checks for literals with extremely many entries. This is indicative of
# configuration or data that may be better extracted somewhere else, like
# a database, fetched from an API, or read from a non-code file (CSV,
# JSON, YAML, etc.).
#
# @example
#   # bad
#   # Huge Array literal
#   [1, 2, '...', 999_999_999]
#
#   # bad
#   # Huge Hash literal
#   { 1 => 1, 2 => 2, '...' => '...', 999_999_999 => 999_999_999}
#
#   # bad
#   # Huge Set "literal"
#   Set[1, 2, '...', 999_999_999]
#
#   # good
#   # Reasonably sized Array literal
#   [1, 2, '...', 10]
#
#   # good
#   # Reading huge Array from external data source
#   # File.readlines('numbers.txt', chomp: true).map!(&:to_i)
#
#   # good
#   # Reasonably sized Hash literal
#   { 1 => 1, 2 => 2, '...' => '...', 10 => 10}
#
#   # good
#   # Reading huge Hash from external data source
#   CSV.foreach('numbers.csv', headers: true).each_with_object({}) do |row, hash|
#   hash[row["key"].to_i] = row["value"].to_i
#   end
#
#   # good
#   # Reasonably sized Set "literal"
#   Set[1, 2, '...', 10]
#
#   # good
#   # Reading huge Set from external data source
#   SomeFramework.config_for(:something)[:numbers].to_set
#
# source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#50
class RuboCop::Cop::Metrics::CollectionLiteralLength < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#55
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#55
  def on_hash(node); end

  # source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#60
  def on_index(node); end

  # source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#64
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#70
  def collection_threshold; end
end

# source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#51
RuboCop::Cop::Metrics::CollectionLiteralLength::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/metrics/collection_literal_length.rb#53
RuboCop::Cop::Metrics::CollectionLiteralLength::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that the cyclomatic complexity of methods is not higher
# than the configured maximum. The cyclomatic complexity is the number of
# linearly independent paths through a method. The algorithm counts
# decision points and adds one.
#
# An if statement (or unless or ?:) increases the complexity by one. An
# else branch does not, since it doesn't add a decision point. The &&
# operator (or keyword and) can be converted to a nested if statement,
# and ||/or is shorthand for a sequence of ifs, so they also add one.
# Loops can be said to have an exit condition, so they add one.
# Blocks that are calls to builtin iteration methods
# (e.g. `ary.map{...}) also add one, others are ignored.
#
#   def each_child_node(*types)               # count begins: 1
#     unless block_given?                     # unless: +1
#       return to_enum(__method__, *types)
#
#     children.each do |child|                # each{}: +1
#       next unless child.is_a?(Node)         # unless: +1
#
#       yield child if types.empty? ||        # if: +1, ||: +1
#                      types.include?(child.type)
#     end
#
#     self
#   end                                       # total: 6
#
# source://rubocop//lib/rubocop/cop/metrics/cyclomatic_complexity.rb#32
class RuboCop::Cop::Metrics::CyclomaticComplexity < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  include ::RuboCop::Cop::MethodComplexity
  include ::RuboCop::Cop::Metrics::Utils::IteratingBlock

  private

  # source://rubocop//lib/rubocop/cop/metrics/cyclomatic_complexity.rb#42
  def complexity_score_for(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/cyclomatic_complexity.rb#49
  def count_block?(block); end
end

# source://rubocop//lib/rubocop/cop/metrics/cyclomatic_complexity.rb#37
RuboCop::Cop::Metrics::CyclomaticComplexity::COUNTED_NODES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/metrics/cyclomatic_complexity.rb#36
RuboCop::Cop::Metrics::CyclomaticComplexity::MSG = T.let(T.unsafe(nil), String)

# Checks if the length of a method exceeds some maximum value.
# Comment lines can optionally be allowed.
# The maximum allowed length is configurable.
#
# You can set constructs you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', 'heredoc', and 'method_call'. Each construct
# will be counted as one line regardless of its actual size.
#
# NOTE: The `ExcludedMethods` and `IgnoredMethods` configuration is
# deprecated and only kept for backwards compatibility.
# Please use `AllowedMethods` and `AllowedPatterns` instead.
# By default, there are no methods to allowed.
#
# @example CountAsOne: ['array', 'heredoc', 'method_call']
#
#   def m
#   array = [       # +1
#   1,
#   2
#   ]
#
#   hash = {        # +3
#   key: 'value'
#   }
#
#   <<~HEREDOC      # +1
#   Heredoc
#   content.
#   HEREDOC
#
#   foo(            # +1
#   1,
#   2
#   )
#   end               # 6 points
#
# source://rubocop//lib/rubocop/cop/metrics/method_length.rb#42
class RuboCop::Cop::Metrics::MethodLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/metrics/method_length.rb#56
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/metrics/method_length.rb#49
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/metrics/method_length.rb#49
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/metrics/method_length.rb#56
  def on_numblock(node); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/method_length.rb#65
  def cop_label; end
end

# source://rubocop//lib/rubocop/cop/metrics/method_length.rb#47
RuboCop::Cop::Metrics::MethodLength::LABEL = T.let(T.unsafe(nil), String)

# Checks if the length of a module exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
#
# You can set constructs you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', 'heredoc', and 'method_call'. Each construct
# will be counted as one line regardless of its actual size.
#
# @example CountAsOne: ['array', 'heredoc', 'method_call']
#
#   module M
#   ARRAY = [         # +1
#   1,
#   2
#   ]
#
#   HASH = {          # +3
#   key: 'value'
#   }
#
#   MSG = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#
#   foo(              # +1
#   1,
#   2
#   )
#   end                 # 6 points
#
# source://rubocop//lib/rubocop/cop/metrics/module_length.rb#37
class RuboCop::Cop::Metrics::ModuleLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength

  # source://rubocop//lib/rubocop/cop/metrics/module_length.rb#51
  def module_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/metrics/module_length.rb#44
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/metrics/module_length.rb#40
  def on_module(node); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/module_length.rb#55
  def message(length, max_length); end
end

# Checks for methods with too many parameters.
#
# The maximum number of parameters is configurable.
# Keyword arguments can optionally be excluded from the total count,
# as they add less complexity than positional or optional parameters.
#
# Any number of arguments for `initialize` method inside a block of
# `Struct.new` and `Data.define` like this is always allowed:
#
# [source,ruby]
# ----
# Struct.new(:one, :two, :three, :four, :five, keyword_init: true) do
#   def initialize(one:, two:, three:, four:, five:)
#   end
# end
# ----
#
# This is because checking the number of arguments of the `initialize` method
# does not make sense.
#
# NOTE: Explicit block argument `&block` is not counted to prevent
# erroneous change that is avoided by making block argument implicit.
#
# This cop also checks for the maximum number of optional parameters.
# This can be configured using the `MaxOptionalParameters` config option.
#
# @example Max: 3
#   # good
#   def foo(a, b, c = 1)
#   end
# @example Max: 2
#   # bad
#   def foo(a, b, c = 1)
#   end
# @example CountKeywordArgs: true (default)
#   # counts keyword args towards the maximum
#
#   # bad (assuming Max is 3)
#   def foo(a, b, c, d: 1)
#   end
#
#   # good (assuming Max is 3)
#   def foo(a, b, c: 1)
#   end
# @example CountKeywordArgs: false
#   # don't count keyword args towards the maximum
#
#   # good (assuming Max is 3)
#   def foo(a, b, c, d: 1)
#   end
# @example MaxOptionalParameters: 3 (default)
#   # good
#   def foo(a = 1, b = 2, c = 3)
#   end
# @example MaxOptionalParameters: 2
#   # bad
#   def foo(a = 1, b = 2, c = 3)
#   end
#
# source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#70
class RuboCop::Cop::Metrics::ParameterLists < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#121
  def argument_to_lambda_or_proc?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max_optional_parameters=(value); end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#104
  def on_args(node); end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#90
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#90
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#81
  def struct_new_or_data_define_block?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#125
  def args_count(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#141
  def count_keyword_args?; end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#137
  def max_optional_parameters; end

  # source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#133
  def max_params; end
end

# source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#74
RuboCop::Cop::Metrics::ParameterLists::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#77
RuboCop::Cop::Metrics::ParameterLists::NAMED_KEYWORD_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/metrics/parameter_lists.rb#75
RuboCop::Cop::Metrics::ParameterLists::OPTIONAL_PARAMETERS_MSG = T.let(T.unsafe(nil), String)

# Tries to produce a complexity score that's a measure of the
# complexity the reader experiences when looking at a method. For that
# reason it considers `when` nodes as something that doesn't add as much
# complexity as an `if` or a `&&`. Except if it's one of those special
# `case`/`when` constructs where there's no expression after `case`. Then
# the cop treats it as an `if`/`elsif`/`elsif`... and lets all the `when`
# nodes count. In contrast to the CyclomaticComplexity cop, this cop
# considers `else` nodes as adding complexity.
#
# @example
#
#   def my_method                   # 1
#   if cond                       # 1
#   case var                    # 2 (0.8 + 4 * 0.2, rounded)
#   when 1 then func_one
#   when 2 then func_two
#   when 3 then func_three
#   when 4..10 then func_other
#   end
#   else                          # 1
#   do_something until a && b   # 2
#   end                           # ===
#   end                             # 7 complexity points
#
# source://rubocop//lib/rubocop/cop/metrics/perceived_complexity.rb#29
class RuboCop::Cop::Metrics::PerceivedComplexity < ::RuboCop::Cop::Metrics::CyclomaticComplexity
  private

  # source://rubocop//lib/rubocop/cop/metrics/perceived_complexity.rb#36
  def complexity_score_for(node); end
end

# source://rubocop//lib/rubocop/cop/metrics/perceived_complexity.rb#32
RuboCop::Cop::Metrics::PerceivedComplexity::COUNTED_NODES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/metrics/perceived_complexity.rb#30
RuboCop::Cop::Metrics::PerceivedComplexity::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#6
module RuboCop::Cop::Metrics::Utils; end

# > ABC is .. a software size metric .. computed by counting the number
# > of assignments, branches and conditions for a section of code.
# > http://c2.com/cgi/wiki?AbcMetric
#
# We separate the *calculator* from the *cop* so that the calculation,
# the formula itself, is easier to test.
#
# source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#13
class RuboCop::Cop::Metrics::Utils::AbcSizeCalculator
  include ::RuboCop::AST::Sexp
  include ::RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount
  include ::RuboCop::Cop::Metrics::Utils::IteratingBlock
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount

  # @return [AbcSizeCalculator] a new instance of AbcSizeCalculator
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#30
  def initialize(node, discount_repeated_attributes: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#42
  def calculate; end

  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#53
  def calculate_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#65
  def else_branch?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#47
  def evaluate_branch_nodes(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#60
  def evaluate_condition_node(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#127
  def argument?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#86
  def assignment?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#123
  def branch?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#119
  def capturing_variable?(name); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#95
  def compound_assignment(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#131
  def condition?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#108
  def simple_assignment?(node); end

  # @yield [node]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#71
  def visit_depth_last(node, &block); end

  class << self
    # source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#30
    def calculate(node, discount_repeated_attributes: T.unsafe(nil)); end
  end
end

# > Branch -- an explicit forward program branch out of scope -- a
# > function call, class method call ..
# > http://c2.com/cgi/wiki?AbcMetric
#
# source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#21
RuboCop::Cop::Metrics::Utils::AbcSizeCalculator::BRANCH_NODES = T.let(T.unsafe(nil), Array)

# > Condition -- a logical/Boolean test, == != <= >= < > else case
# > default try catch ? and unary conditionals.
# > http://c2.com/cgi/wiki?AbcMetric
#
# source://rubocop//lib/rubocop/cop/metrics/utils/abc_size_calculator.rb#26
RuboCop::Cop::Metrics::Utils::AbcSizeCalculator::CONDITION_NODES = T.let(T.unsafe(nil), Array)

# Helps to calculate code length for the provided node.
#
# source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#8
class RuboCop::Cop::Metrics::Utils::CodeLengthCalculator
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [CodeLengthCalculator] a new instance of CodeLengthCalculator
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#16
  def initialize(node, processed_source, count_comments: T.unsafe(nil), foldable_types: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#24
  def calculate; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#182
  def another_args?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#42
  def build_foldable_checks(types); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#90
  def classlike_code_length(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#138
  def classlike_node?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#66
  def code_length(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#163
  def count_comments?; end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#126
  def each_top_level_descendant(node, types, &block); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#146
  def extract_body(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#142
  def foldable_node?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#121
  def heredoc_length(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#86
  def heredoc_node?(node); end

  # Returns true for lines that shall not be included in the count.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#159
  def irrelevant_line?(source_line); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#110
  def line_numbers_of_inner_nodes(node, *types); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#106
  def namespace_module?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#186
  def node_with_heredoc?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#60
  def normalize_foldable_types(types); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#167
  def omit_length(descendant); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#178
  def parenthesized?(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#190
  def source_from_node_with_heredoc(node); end
end

# source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#13
RuboCop::Cop::Metrics::Utils::CodeLengthCalculator::CLASSLIKE_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/metrics/utils/code_length_calculator.rb#12
RuboCop::Cop::Metrics::Utils::CodeLengthCalculator::FOLDABLE_TYPES = T.let(T.unsafe(nil), Array)

# Used to identify iterating blocks like `.map{}` and `.map(&:...)`
#
# source://rubocop//lib/rubocop/cop/metrics/utils/iterating_block.rb#8
module RuboCop::Cop::Metrics::Utils::IteratingBlock
  # Returns the name of the method called with a block
  # if node is a block node, or a block-pass node.
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/iterating_block.rb#37
  def block_method_name(node); end

  # Returns nil if node is neither a block node or a block-pass node.
  # Otherwise returns true/false if method call is a known iterating call
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/iterating_block.rb#53
  def iterating_block?(node); end

  # Returns true iff name is a known iterating type (e.g. :each, :transform_values)
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/iterating_block.rb#47
  def iterating_method?(name); end
end

# source://rubocop//lib/rubocop/cop/metrics/utils/iterating_block.rb#33
RuboCop::Cop::Metrics::Utils::IteratingBlock::KNOWN_ITERATING_METHODS = T.let(T.unsafe(nil), Set)

# Identifies repetitions `{c}send` calls with no arguments:
#
#   foo.bar
#   foo.bar # => repeated
#   foo.bar.baz.qux # => inner send repeated
#   foo.bar.baz.other # => both inner send repeated
#   foo.bar(2) # => not repeated
#
# It also invalidates sequences if a receiver is reassigned:
#
#   xx.foo.bar
#   xx.foo.baz      # => inner send repeated
#   self.xx = any   # => invalidates everything so far
#   xx.foo.baz      # => no repetition
#   self.xx.foo.baz # => all repeated
#
# @api private
#
# source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#25
module RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount
  include ::RuboCop::AST::Sexp
  extend ::RuboCop::AST::NodePattern::Macros

  # Plug into the calculator
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#30
  def initialize(node, discount_repeated_attributes: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#61
  def attribute_call?(param0 = T.unsafe(nil)); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#53
  def calculate_node(node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#43
  def discount_repeated_attributes?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#47
  def evaluate_branch_nodes(node); end

  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#92
  def root_node?(param0 = T.unsafe(nil)); end

  private

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#66
  def discount_repeated_attribute?(send_node); end

  # Returns the "known_attributes" for the `node` by walking the receiver tree
  # If at any step the subdirectory does not exist, it is yielded with the
  # associated key (method_name)
  # If the node is not a series of `(c)send` calls with no arguments,
  # then `nil` is yielded
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#103
  def find_attributes(node, &block); end

  # or `nil` if it is not a setter.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#126
  def setter_to_getter(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#80
  def update_repeated_attribute(node); end
end

# @api private
#
# source://rubocop//lib/rubocop/cop/metrics/utils/repeated_attribute_discount.rb#117
RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount::VAR_SETTER_TO_GETTER = T.let(T.unsafe(nil), Hash)

# Identifies repetitions `&.` on the same variable:
#
#  my_var&.foo
#  my_var&.bar # => repeated
#  my_var = baz # => reset
#  my_var&.qux # => not repeated
#
# @api private
#
# source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#15
module RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#20
  def discount_for_repeated_csend?(csend_node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#34
  def reset_on_lvasgn(node); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/metrics/utils/repeated_csend_discount.rb#16
  def reset_repeated_csend; end
end

# source://rubocop//lib/rubocop/cop/migration/department_name.rb#5
module RuboCop::Cop::Migration; end

# department name.
#
# source://rubocop//lib/rubocop/cop/migration/department_name.rb#8
class RuboCop::Cop::Migration::DepartmentName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#21
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#47
  def check_cop_name(name, comment, offset); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#69
  def contain_unexpected_character_for_department_name?(name); end

  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#43
  def disable_comment_offset; end

  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#73
  def qualified_legacy_cop_name(cop_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/migration/department_name.rb#63
  def valid_content_token?(content_token); end
end

# source://rubocop//lib/rubocop/cop/migration/department_name.rb#14
RuboCop::Cop::Migration::DepartmentName::DISABLE_COMMENT_FORMAT = T.let(T.unsafe(nil), Regexp)

# The token that makes up a disable comment.
# `DepartmentName/CopName` or` all`.
#
# source://rubocop//lib/rubocop/cop/migration/department_name.rb#19
RuboCop::Cop::Migration::DepartmentName::DISABLING_COPS_CONTENT_TOKEN = T.let(T.unsafe(nil), Regexp)

# source://rubocop//lib/rubocop/cop/migration/department_name.rb#12
RuboCop::Cop::Migration::DepartmentName::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking minimum body length.
#
# source://rubocop//lib/rubocop/cop/mixin/min_body_length.rb#6
module RuboCop::Cop::MinBodyLength
  private

  # source://rubocop//lib/rubocop/cop/mixin/min_body_length.rb#13
  def min_body_length; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/min_body_length.rb#9
  def min_body_length?(node); end
end

# Common functionality for checking minimum branches count.
#
# source://rubocop//lib/rubocop/cop/mixin/min_branches_count.rb#6
module RuboCop::Cop::MinBranchesCount
  private

  # source://rubocop//lib/rubocop/cop/mixin/min_branches_count.rb#29
  def if_conditional_branches(node, branches = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/min_branches_count.rb#22
  def min_branches_count; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/min_branches_count.rb#9
  def min_branches_count?(node); end
end

# Common code for indenting the first elements in multiline
# array literals, hash literals, and method definitions.
#
# source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#7
module RuboCop::Cop::MultilineElementIndentation
  private

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#42
  def check_expected_style(styles); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#26
  def check_first(first, left_brace, left_parenthesis, offset); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#80
  def detected_styles(actual_column, offset, left_parenthesis, left_brace); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#85
  def detected_styles_for_column(column, left_parenthesis, left_brace); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#10
  def each_argument_node(node, type); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#66
  def hash_pair_where_value_beginning_with(left_brace, first); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#98
  def incorrect_style_detected(styles, first, base_column_type); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#50
  def indent_base(left_brace, first, left_parenthesis); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#72
  def key_and_value_begin_on_same_line?(pair); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_indentation.rb#76
  def right_sibling_begins_on_subsequent_line?(pair); end
end

# Common functionality for checking for a line break before each
# element in a multi-line collection.
#
# source://rubocop//lib/rubocop/cop/mixin/multiline_element_line_breaks.rb#7
module RuboCop::Cop::MultilineElementLineBreaks
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_line_breaks.rb#23
  def all_on_same_line?(nodes, ignore_last: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_element_line_breaks.rb#10
  def check_line_breaks(_node, children, ignore_last: T.unsafe(nil)); end
end

# Common functionality for checking multiline method calls and binary
# operations.
#
# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#7
module RuboCop::Cop::MultilineExpressionIndentation
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#14
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#14
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#132
  def argument_in_method_call(node, kind); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#188
  def assignment_rhs(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#65
  def check(range, node, lhs, rhs); end

  # The correct indentation of `node` is usually `IndentationWidth`, with
  # one exception: prefix keywords.
  #
  # ```
  # while foo &&  # Here, `while` is called a "prefix keyword"
  #     bar       # This is called "special indentation"
  #   baz
  # end
  # ```
  #
  # Note that *postfix conditionals* do *not* get "special indentation".
  #
  # ```
  # next if foo &&
  #   bar # normal indentation, not special
  # ```
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#55
  def correct_indentation(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#160
  def disqualified_rhs?(candidate, ancestor); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#204
  def grouped_expression?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#73
  def incorrect_style_detected(range, node, lhs, rhs); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#85
  def indentation(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#122
  def indented_keyword_expression(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#208
  def inside_arg_list_parentheses?(node, ancestor); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#99
  def keyword_message_tail(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#107
  def kw_node_with_special_indentation(node); end

  # In a chain of method calls, we regard the top call node as the base
  # for indentation of all lines following the first. For example:
  # a.
  #   b c { block }.            <-- b is indented relative to a
  #   d                         <-- d is indented relative to a
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#32
  def left_hand_side(lhs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#198
  def not_for_this_cop?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#89
  def operation_description(node, rhs); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#146
  def part_of_assignment_rhs(node, candidate); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#184
  def part_of_block_body?(candidate, block_node); end

  # Returns true if `node` is a conditional whose `body` and `condition`
  # begin on the same line.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#217
  def postfix_conditional?(node); end

  # The []= operator and setters (a.b = c) are parsed as :send nodes.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#176
  def valid_method_rhs_candidate?(candidate, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#165
  def valid_rhs?(candidate, ancestor); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#180
  def valid_rhs_candidate?(candidate, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#221
  def within_node?(inner, outer); end
end

# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#11
RuboCop::Cop::MultilineExpressionIndentation::ASSIGNMENT_MESSAGE_TAIL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#10
RuboCop::Cop::MultilineExpressionIndentation::DEFAULT_MESSAGE_TAIL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#8
RuboCop::Cop::MultilineExpressionIndentation::KEYWORD_ANCESTOR_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#12
RuboCop::Cop::MultilineExpressionIndentation::KEYWORD_MESSAGE_TAIL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/mixin/multiline_expression_indentation.rb#9
RuboCop::Cop::MultilineExpressionIndentation::UNALIGNED_RHS_TYPES = T.let(T.unsafe(nil), Array)

# Autocorrection logic for the closing brace of a literal either
# on the same line as the last contained elements, or a new line.
#
# source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#7
class RuboCop::Cop::MultilineLiteralBraceCorrector
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  include ::RuboCop::Cop::RangeHelp

  # @return [MultilineLiteralBraceCorrector] a new instance of MultilineLiteralBraceCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#15
  def initialize(corrector, node, processed_source); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#21
  def call; end

  private

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#61
  def content_if_comment_present(corrector, node); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#51
  def correct_heredoc_argument_method_chain(corrector, end_range); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#46
  def correct_next_line_brace(corrector, end_range); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#42
  def correct_same_line_brace(corrector); end

  # Returns the value of attribute corrector.
  #
  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#40
  def corrector; end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#94
  def last_element_range_with_trailing_comma(node); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#103
  def last_element_trailing_comma_range(node); end

  # Returns the value of attribute node.
  #
  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#40
  def node; end

  # Returns the value of attribute processed_source.
  #
  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#40
  def processed_source; end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#90
  def remove_trailing_content_of_comment(corrector, range); end

  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#80
  def select_content_to_be_inserted_after_last_element(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#73
  def use_heredoc_argument_method_chain?(parent); end

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/multiline_literal_brace_corrector.rb#11
    def correct(corrector, node, processed_source); end
  end
end

# Common functionality for checking the closing brace of a literal is
# either on the same line as the last contained elements or a new line.
#
# source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#7
module RuboCop::Cop::MultilineLiteralBraceLayout
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  private

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#34
  def check(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#12
  def check_brace_layout(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#42
  def check_new_line(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#50
  def check_same_line(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#58
  def check_symmetrical(node); end

  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#86
  def children(node); end

  # This method depends on the fact that we have guarded
  # against implicit and empty literals.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#98
  def closing_brace_on_same_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#74
  def empty_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#82
  def ignored_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#78
  def implicit_literal?(node); end

  # Starting with the parent node and recursively for the parent node's
  # children, check if the node is a HEREDOC and if the HEREDOC ends below
  # or on the last line of the parent node.
  #
  # Example:
  #
  #   # node is `b: ...` parameter
  #   # last_line_heredoc?(node) => false
  #   foo(a,
  #     b: {
  #       a: 1,
  #       c: <<-EOM
  #         baz
  #       EOM
  #     }
  #   )
  #
  #   # node is `b: ...` parameter
  #   # last_line_heredoc?(node) => true
  #   foo(a,
  #     b: <<-EOM
  #       baz
  #     EOM
  #   )
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#126
  def last_line_heredoc?(node, parent = T.unsafe(nil)); end

  # Returns true for the case
  #   [a,
  #    b # comment
  #   ].some_method
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#26
  def new_line_needed_before_closing_brace?(node); end

  # This method depends on the fact that we have guarded
  # against implicit and empty literals.
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/multiline_literal_brace_layout.rb#92
  def opening_brace_on_same_line?(node); end
end

# source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#5
module RuboCop::Cop::Naming; end

# Makes sure that accessor methods are named properly. Applies
# to both instance and class methods.
#
# NOTE: Offenses are only registered for methods with the expected
# arity. Getters (`get_attribute`) must have no arguments to be
# registered, and setters (`set_attribute(value)`) must have exactly
# one.
#
# @example
#   # bad
#   def set_attribute(value)
#   end
#
#   # good
#   def attribute=(value)
#   end
#
#   # bad
#   def get_attribute
#   end
#
#   # good
#   def attribute
#   end
#
#   # accepted, incorrect arity for getter
#   def get_value(attr)
#   end
#
#   # accepted, incorrect arity for setter
#   def set_value
#   end
#
# source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#38
class RuboCop::Cop::Naming::AccessorMethodName < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#42
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#42
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#61
  def bad_reader_name?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#65
  def bad_writer_name?(node); end

  # source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#53
  def message(node); end
end

# source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#39
RuboCop::Cop::Naming::AccessorMethodName::MSG_READER = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/accessor_method_name.rb#40
RuboCop::Cop::Naming::AccessorMethodName::MSG_WRITER = T.let(T.unsafe(nil), String)

# Checks for non-ascii characters in identifier and constant names.
# Identifiers are always checked and whether constants are checked
# can be controlled using AsciiConstants config.
#
# @example
#   # bad
#   def καλημερα # Greek alphabet (non-ascii)
#   end
#
#   # bad
#   def こんにちはと言う # Japanese character (non-ascii)
#   end
#
#   # bad
#   def hello_🍣 # Emoji (non-ascii)
#   end
#
#   # good
#   def say_hello
#   end
#
#   # bad
#   신장 = 10 # Hangul character (non-ascii)
#
#   # good
#   height = 10
#
#   # bad
#   params[:عرض_gteq] # Arabic character (non-ascii)
#
#   # good
#   params[:width_gteq]
# @example AsciiConstants: true (default)
#   # bad
#   class Foö
#   end
#
#   FOÖ = "foo"
# @example AsciiConstants: false
#   # good
#   class Foö
#   end
#
#   FOÖ = "foo"
#
# source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#53
class RuboCop::Cop::Naming::AsciiIdentifiers < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#59
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#84
  def first_non_ascii_chars(string); end

  # source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#74
  def first_offense_range(identifier); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#70
  def should_check?(token); end
end

# source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#57
RuboCop::Cop::Naming::AsciiIdentifiers::CONSTANT_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/ascii_identifiers.rb#56
RuboCop::Cop::Naming::AsciiIdentifiers::IDENTIFIER_MSG = T.let(T.unsafe(nil), String)

# Makes sure that certain binary operator methods have their
# sole  parameter named `other`.
#
# @example
#
#   # bad
#   def +(amount); end
#
#   # good
#   def +(other); end
#
# source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#16
class RuboCop::Cop::Naming::BinaryOperatorParameterName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#29
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#25
  def op_method_candidate?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#45
  def op_method?(name); end
end

# source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#22
RuboCop::Cop::Naming::BinaryOperatorParameterName::EXCLUDED = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#19
RuboCop::Cop::Naming::BinaryOperatorParameterName::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/binary_operator_parameter_name.rb#21
RuboCop::Cop::Naming::BinaryOperatorParameterName::OP_LIKE_METHODS = T.let(T.unsafe(nil), Array)

# In Ruby 3.1, anonymous block forwarding has been added.
#
# This cop identifies places where `do_something(&block)` can be replaced
# by `do_something(&)`.
#
# It also supports the opposite style by alternative `explicit` option.
# You can specify the block variable name for autocorrection with `BlockForwardingName`.
# The default variable name is `block`. If the name is already in use, it will not be
# autocorrected.
#
# @example EnforcedStyle: anonymous (default)
#
#   # bad
#   def foo(&block)
#   bar(&block)
#   end
#
#   # good
#   def foo(&)
#   bar(&)
#   end
# @example EnforcedStyle: explicit
#
#   # bad
#   def foo(&)
#   bar(&)
#   end
#
#   # good
#   def foo(&block)
#   bar(&block)
#   end
#
# source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#40
class RuboCop::Cop::Naming::BlockForwarding < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#54
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#54
  def on_defs(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#114
  def anonymous_block_argument?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#87
  def block_argument_name_matched?(block_pass_node, last_argument); end

  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#146
  def block_forwarding_name; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#77
  def expected_block_forwarding_style?(node, last_argument); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#118
  def explicit_block_argument?(node); end

  # Prevents the following syntax error:
  #
  # # foo.rb
  # def foo(&)
  #   block_method do
  #     bar(&)
  #   end
  # end
  #
  # $ ruby -vc foo.rb
  # ruby 3.3.0 (2023-12-25 revision 5124f9ac75) [x86_64-darwin22]
  # foo.rb: foo.rb:4: anonymous block parameter is also used within block (SyntaxError)
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#106
  def invalidates_syntax?(block_pass_node); end

  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#122
  def register_offense(block_argument, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#138
  def use_block_argument_as_local_variable?(node, last_argument); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#110
  def use_kwarg_in_method_definition?(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#50
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/naming/block_forwarding.rb#48
RuboCop::Cop::Naming::BlockForwarding::MSG = T.let(T.unsafe(nil), String)

# Checks block parameter names for how descriptive they
# are. It is highly configurable.
#
# The `MinNameLength` config option takes an integer. It represents
# the minimum amount of characters the name must be. Its default is 1.
# The `AllowNamesEndingInNumbers` config option takes a boolean. When
# set to false, this cop will register offenses for names ending with
# numbers. Its default is false. The `AllowedNames` config option
# takes an array of permitted names that will never register an
# offense. The `ForbiddenNames` config option takes an array of
# restricted names that will always register an offense.
#
# @example
#   # bad
#   bar do |varOne, varTwo|
#   varOne + varTwo
#   end
#
#   # With `AllowNamesEndingInNumbers` set to false
#   foo { |num1, num2| num1 * num2 }
#
#   # With `MinNameLength` set to number greater than 1
#   baz { |a, b, c| do_stuff(a, b, c) }
#
#   # good
#   bar do |thud, fred|
#   thud + fred
#   end
#
#   foo { |speed, distance| speed * distance }
#
#   baz { |age, height, gender| do_stuff(age, height, gender) }
#
# source://rubocop//lib/rubocop/cop/naming/block_parameter_name.rb#38
class RuboCop::Cop::Naming::BlockParameterName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::UncommunicativeName

  # source://rubocop//lib/rubocop/cop/naming/block_parameter_name.rb#41
  def on_block(node); end
end

# Checks for class and module names with
# an underscore in them.
#
# `AllowedNames` config takes an array of permitted names.
# Its default value is `['module_parent']`.
# These names can be full class/module names or part of the name.
# eg. Adding `my_class` to the `AllowedNames` config will allow names like
# `my_class`, `my_class::User`, `App::my_class`, `App::my_class::User`, etc.
#
# @example
#   # bad
#   class My_Class
#   end
#   module My_Module
#   end
#
#   # good
#   class MyClass
#   end
#   module MyModule
#   end
#   class module_parent::MyModule
#   end
#
# source://rubocop//lib/rubocop/cop/naming/class_and_module_camel_case.rb#29
class RuboCop::Cop::Naming::ClassAndModuleCamelCase < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/naming/class_and_module_camel_case.rb#32
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/naming/class_and_module_camel_case.rb#32
  def on_module(node); end
end

# source://rubocop//lib/rubocop/cop/naming/class_and_module_camel_case.rb#30
RuboCop::Cop::Naming::ClassAndModuleCamelCase::MSG = T.let(T.unsafe(nil), String)

# Checks whether constant names are written using
# SCREAMING_SNAKE_CASE.
#
# To avoid false positives, it ignores cases in which we cannot know
# for certain the type of value that would be assigned to a constant.
#
# @example
#   # bad
#   InchInCm = 2.54
#   INCHinCM = 2.54
#   Inch_In_Cm = 2.54
#
#   # good
#   INCH_IN_CM = 2.54
#
# source://rubocop//lib/rubocop/cop/naming/constant_name.rb#20
class RuboCop::Cop::Naming::ConstantName < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#27
  def class_or_struct_return_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#68
  def literal_receiver?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#33
  def on_casgn(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#56
  def allowed_assignment?(value); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#73
  def allowed_conditional_expression_on_rhs?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#63
  def allowed_method_call_on_rhs?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/constant_name.rb#77
  def contains_constant?(node); end
end

# source://rubocop//lib/rubocop/cop/naming/constant_name.rb#21
RuboCop::Cop::Naming::ConstantName::MSG = T.let(T.unsafe(nil), String)

# Use POSIX character classes, so we allow accented characters rather
# than just standard ASCII characters
#
# source://rubocop//lib/rubocop/cop/naming/constant_name.rb#24
RuboCop::Cop::Naming::ConstantName::SNAKE_CASE = T.let(T.unsafe(nil), Regexp)

# Makes sure that Ruby source files have snake_case
# names. Ruby scripts (i.e. source files with a shebang in the
# first line) are ignored.
#
# The cop also ignores `.gemspec` files, because Bundler
# recommends using dashes to separate namespaces in nested gems
# (i.e. `bundler-console` becomes `Bundler::Console`). As such, the
# gemspec is supposed to be named `bundler-console.gemspec`.
#
# When `ExpectMatchingDefinition` (default: `false`) is `true`, the cop requires
# each file to have a class, module or `Struct` defined in it that matches
# the filename. This can be further configured using
# `CheckDefinitionPathHierarchy` (default: `true`) to determine whether the
# path should match the namespace of the above definition.
#
# When `IgnoreExecutableScripts` (default: `true`) is `true`, files that start
# with a shebang line are not considered by the cop.
#
# When `Regex` is set, the cop will flag any filename that does not match
# the regular expression.
#
# @example
#   # bad
#   lib/layoutManager.rb
#
#   anything/usingCamelCase
#
#   # good
#   lib/layout_manager.rb
#
#   anything/using_snake_case.rake
#
# source://rubocop//lib/rubocop/cop/naming/file_name.rb#39
class RuboCop::Cop::Naming::FileName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#56
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#49
  def struct_definition(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#134
  def allowed_acronyms; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#96
  def bad_filename_allowed?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#122
  def check_definition_path_hierarchy?; end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#169
  def defined_struct(node); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#126
  def definition_path_hierarchy_roots; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#118
  def expect_matching_definition?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#138
  def filename_good?(basename); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#147
  def find_class_or_module(node, namespace); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#165
  def find_definition(node); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#65
  def for_bad_filename(file_path); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#114
  def ignore_executable_scripts?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#202
  def match?(expected); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#206
  def match_acronym?(expected, name); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#174
  def match_namespace(node, namespace, expected); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#92
  def matching_class?(file_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#88
  def matching_definition?(file_path); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#100
  def no_definition_message(basename, file_path); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#106
  def other_message(basename); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#188
  def partial_matcher!(expected); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#77
  def perform_class_and_module_naming_checks(file_path, basename); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#130
  def regex; end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#240
  def to_module_name(basename); end

  # source://rubocop//lib/rubocop/cop/naming/file_name.rb#213
  def to_namespace(path); end
end

# source://rubocop//lib/rubocop/cop/naming/file_name.rb#43
RuboCop::Cop::Naming::FileName::MSG_NO_DEFINITION = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/file_name.rb#44
RuboCop::Cop::Naming::FileName::MSG_REGEX = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/file_name.rb#42
RuboCop::Cop::Naming::FileName::MSG_SNAKE_CASE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/file_name.rb#46
RuboCop::Cop::Naming::FileName::SNAKE_CASE = T.let(T.unsafe(nil), Regexp)

# Checks that your heredocs are using the configured case.
# By default it is configured to enforce uppercase heredocs.
#
# @example EnforcedStyle: uppercase (default)
#   # bad
#   <<-sql
#   SELECT * FROM foo
#   sql
#
#   # good
#   <<-SQL
#   SELECT * FROM foo
#   SQL
# @example EnforcedStyle: lowercase
#   # bad
#   <<-SQL
#   SELECT * FROM foo
#   SQL
#
#   # good
#   <<-sql
#   SELECT * FROM foo
#   sql
#
# source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#30
class RuboCop::Cop::Naming::HeredocDelimiterCase < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#37
  def on_heredoc(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#54
  def correct_case_delimiters?(node); end

  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#58
  def correct_delimiters(source); end

  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#50
  def message(_node); end
end

# source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_case.rb#35
RuboCop::Cop::Naming::HeredocDelimiterCase::MSG = T.let(T.unsafe(nil), String)

# Checks that your heredocs are using meaningful delimiters.
# By default it disallows `END` and `EO*`, and can be configured through
# forbidden listing additional delimiters.
#
# @example
#
#   # good
#   <<-SQL
#   SELECT * FROM foo
#   SQL
#
#   # bad
#   <<-END
#   SELECT * FROM foo
#   END
#
#   # bad
#   <<-EOS
#   SELECT * FROM foo
#   EOS
#
# source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_naming.rb#26
class RuboCop::Cop::Naming::HeredocDelimiterNaming < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc

  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_naming.rb#31
  def on_heredoc(node); end

  private

  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_naming.rb#51
  def forbidden_delimiters; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_naming.rb#41
  def meaningful_delimiters?(node); end
end

# source://rubocop//lib/rubocop/cop/naming/heredoc_delimiter_naming.rb#29
RuboCop::Cop::Naming::HeredocDelimiterNaming::MSG = T.let(T.unsafe(nil), String)

# Recommends the use of inclusive language instead of problematic terms.
# The cop can check the following locations for offenses:
#
# - identifiers
# - constants
# - variables
# - strings
# - symbols
# - comments
# - file paths
#
# Each of these locations can be individually enabled/disabled via configuration,
# for example CheckIdentifiers = true/false.
#
# Flagged terms are configurable for the cop. For each flagged term an optional
# Regex can be specified to identify offenses. Suggestions for replacing a flagged term can
# be configured and will be displayed as part of the offense message.
# An AllowedRegex can be specified for a flagged term to exempt allowed uses of the term.
# `WholeWord: true` can be set on a flagged term to indicate the cop should only match when
# a term matches the whole word (partial matches will not be offenses).
#
# The cop supports autocorrection when there is only one suggestion. When there are multiple
# suggestions, the best suggestion cannot be identified and will not be autocorrected.
#
# @example FlaggedTerms: { whitelist: { Suggestions: ['allowlist'] } }
#   # Suggest replacing identifier whitelist with allowlist
#
#   # bad
#   whitelist_users = %w(user1 user1)
#
#   # good
#   allowlist_users = %w(user1 user2)
# @example FlaggedTerms: { master: { Suggestions: ['main', 'primary', 'leader'] } }
#   # Suggest replacing master in an instance variable name with main, primary, or leader
#
#   # bad
#   @master_node = 'node1.example.com'
#
#   # good
#   @primary_node = 'node1.example.com'
# @example FlaggedTerms: { whitelist: { Regex: !ruby/regexp '/white[-_\s]?list' } }
#   # Identify problematic terms using a Regexp
#
#   # bad
#   white_list = %w(user1 user2)
#
#   # good
#   allow_list = %w(user1 user2)
# @example FlaggedTerms: { master: { AllowedRegex: 'master\'?s degree' } }
#   # Specify allowed uses of the flagged term as a string or regexp.
#
#   # bad
#   # They had a masters
#
#   # good
#   # They had a master's degree
# @example FlaggedTerms: { slave: { WholeWord: true } }
#   # Specify that only terms that are full matches will be flagged.
#
#   # bad
#   Slave
#
#   # good (won't be flagged despite containing `slave`)
#   TeslaVehicle
#
# source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#74
class RuboCop::Cop::Naming::InclusiveLanguage < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [InclusiveLanguage] a new instance of InclusiveLanguage
  #
  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#84
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#93
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#111
  def add_offenses_for_token(token, word_locations); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#167
  def add_to_flagged_term_hash(regex_string, term, term_definition); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#193
  def array_to_ignorecase_regex(strings); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#126
  def check_token?(type); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#243
  def create_message(word, message = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#217
  def create_multiple_word_message_for_file(words); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#213
  def create_single_word_message_for_file(word); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#189
  def ensure_regex_string(regex); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#160
  def extract_regexp(term, term_definition); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#251
  def find_flagged_term(word); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#265
  def format_suggestions(suggestions); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#197
  def investigate_filepath; end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#100
  def investigate_tokens; end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#231
  def mask_input(str); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#280
  def offense_range(token, word); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#130
  def preprocess_check_config; end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#144
  def preprocess_flagged_terms; end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#258
  def preprocess_suggestions(suggestions); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#179
  def process_allowed_regex(allowed); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#221
  def scan_for_words(input); end

  # source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#174
  def set_regexes(flagged_term_strings, allowed_strings); end
end

# source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#78
RuboCop::Cop::Naming::InclusiveLanguage::EMPTY_ARRAY = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#79
RuboCop::Cop::Naming::InclusiveLanguage::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#80
RuboCop::Cop::Naming::InclusiveLanguage::MSG_FOR_FILE_PATH = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/inclusive_language.rb#82
class RuboCop::Cop::Naming::InclusiveLanguage::WordLocation < ::Struct
  # Returns the value of attribute position
  #
  # @return [Object] the current value of position
  def position; end

  # Sets the attribute position
  #
  # @param value [Object] the value to set the attribute position to.
  # @return [Object] the newly set value
  def position=(_); end

  # Returns the value of attribute word
  #
  # @return [Object] the current value of word
  def word; end

  # Sets the attribute word
  #
  # @param value [Object] the value to set the attribute word to.
  # @return [Object] the newly set value
  def word=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Checks for memoized methods whose instance variable name
# does not match the method name. Applies to both regular methods
# (defined with `def`) and dynamic methods (defined with
# `define_method` or `define_singleton_method`).
#
# This cop can be configured with the EnforcedStyleForLeadingUnderscores
# directive. It can be configured to allow for memoized instance variables
# prefixed with an underscore. Prefixing ivars with an underscore is a
# convention that is used to implicitly indicate that an ivar should not
# be set or referenced outside of the memoization method.
#
# @example EnforcedStyleForLeadingUnderscores: disallowed (default)
#   # bad
#   # Method foo is memoized using an instance variable that is
#   # not `@foo`. This can cause confusion and bugs.
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @something if defined?(@something)
#   @something = calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= begin
#   calculate_expensive_thing
#   end
#   end
#
#   # good
#   def foo
#   helper_variable = something_we_need_to_calculate_foo
#   @foo ||= calculate_expensive_thing(helper_variable)
#   end
#
#   # good
#   define_method(:foo) do
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   return @foo if defined?(@foo)
#   @foo = calculate_expensive_thing
#   end
# @example EnforcedStyleForLeadingUnderscores: required
#   # bad
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   # bad
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @foo if defined?(@foo)
#   @foo = calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
# @example EnforcedStyleForLeadingUnderscores :optional
#   # bad
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @_foo ||= calculate_expensive_thing
#   end
#
# source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#148
class RuboCop::Cop::Naming::MemoizedInstanceVariableName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#197
  def defined_memoized?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#160
  def method_definition?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#205
  def on_defined?(node); end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#170
  def on_or_asgn(node); end

  private

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#242
  def find_definition(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#253
  def matches?(method_name, ivar_assign); end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#263
  def message(variable); end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#238
  def style_parameter_name; end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#271
  def suggested_var(method_name); end

  # source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#277
  def variable_name_candidates(method_name); end
end

# source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#157
RuboCop::Cop::Naming::MemoizedInstanceVariableName::DYNAMIC_DEFINE_METHODS = T.let(T.unsafe(nil), Set)

# source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#153
RuboCop::Cop::Naming::MemoizedInstanceVariableName::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/naming/memoized_instance_variable_name.rb#155
RuboCop::Cop::Naming::MemoizedInstanceVariableName::UNDERSCORE_REQUIRED = T.let(T.unsafe(nil), String)

# Makes sure that all methods use the configured style,
# snake_case or camelCase, for their names.
#
# This cop has `AllowedPatterns` configuration option.
#
#   Naming/MethodName:
#     AllowedPatterns:
#       - '\AonSelectionBulkChange\z'
#       - '\AonSelectionCleared\z'
#
# Method names matching patterns are always allowed.
#
# @example EnforcedStyle: snake_case (default)
#   # bad
#   def fooBar; end
#
#   # good
#   def foo_bar; end
# @example EnforcedStyle: camelCase
#   # bad
#   def foo_bar; end
#
#   # good
#   def fooBar; end
#
# source://rubocop//lib/rubocop/cop/naming/method_name.rb#31
class RuboCop::Cop::Naming::MethodName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#55
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#55
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#44
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#42
  def str_name(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#39
  def sym_name(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#64
  def attr_name(name_item); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#75
  def message(style); end

  # source://rubocop//lib/rubocop/cop/naming/method_name.rb#68
  def range_position(node); end
end

# source://rubocop//lib/rubocop/cop/naming/method_name.rb#36
RuboCop::Cop::Naming::MethodName::MSG = T.let(T.unsafe(nil), String)

# Checks method parameter names for how descriptive they
# are. It is highly configurable.
#
# The `MinNameLength` config option takes an integer. It represents
# the minimum amount of characters the name must be. Its default is 3.
# The `AllowNamesEndingInNumbers` config option takes a boolean. When
# set to false, this cop will register offenses for names ending with
# numbers. Its default is false. The `AllowedNames` config option
# takes an array of permitted names that will never register an
# offense. The `ForbiddenNames` config option takes an array of
# restricted names that will always register an offense.
#
# @example
#   # bad
#   def bar(varOne, varTwo)
#   varOne + varTwo
#   end
#
#   # With `AllowNamesEndingInNumbers` set to false
#   def foo(num1, num2)
#   num1 * num2
#   end
#
#   # With `MinNameLength` set to number greater than 1
#   def baz(a, b, c)
#   do_stuff(a, b, c)
#   end
#
#   # good
#   def bar(thud, fred)
#   thud + fred
#   end
#
#   def foo(speed, distance)
#   speed * distance
#   end
#
#   def baz(age_a, height_b, gender_c)
#   do_stuff(age_a, height_b, gender_c)
#   end
#
# source://rubocop//lib/rubocop/cop/naming/method_parameter_name.rb#46
class RuboCop::Cop::Naming::MethodParameterName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::UncommunicativeName

  # source://rubocop//lib/rubocop/cop/naming/method_parameter_name.rb#49
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/method_parameter_name.rb#49
  def on_defs(node); end
end

# Checks that predicate method names end with a question mark and
# do not start with a forbidden prefix.
#
# A method is determined to be a predicate method if its name starts with
# one of the prefixes listed in the `NamePrefix` configuration. The list
# defaults to `is_`, `has_`, and `have_` but may be overridden.
#
# Predicate methods must end with a question mark.
#
# When `ForbiddenPrefixes` is also set (as it is by default), predicate
# methods which begin with a forbidden prefix are not allowed, even if
# they end with a `?`. These methods should be changed to remove the
# prefix.
#
# @example NamePrefix: ['is_', 'has_', 'have_'] (default)
#   # bad
#   def is_even(value)
#   end
#
#   # When ForbiddenPrefixes: ['is_', 'has_', 'have_'] (default)
#   # good
#   def even?(value)
#   end
#
#   # When ForbiddenPrefixes: []
#   # good
#   def is_even?(value)
#   end
# @example NamePrefix: ['seems_to_be_']
#   # bad
#   def seems_to_be_even(value)
#   end
#
#   # When ForbiddenPrefixes: ['seems_to_be_']
#   # good
#   def even?(value)
#   end
#
#   # When ForbiddenPrefixes: []
#   # good
#   def seems_to_be_even?(value)
#   end
# @example AllowedMethods: ['is_a?'] (default)
#   # Despite starting with the `is_` prefix, this method is allowed
#   # good
#   def is_a?(value)
#   end
# @example AllowedMethods: ['is_even?']
#   # good
#   def is_even?(value)
#   end
# @example MethodDefinitionMacros: ['define_method', 'define_singleton_method'] (default)
#   # bad
#   define_method(:is_even) { |value| }
#
#   # good
#   define_method(:even?) { |value| }
# @example MethodDefinitionMacros: ['def_node_matcher']
#   # bad
#   def_node_matcher(:is_even) { |value| }
#
#   # good
#   # def_node_matcher(:even?) { |value| }
#
# source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#75
class RuboCop::Cop::Naming::PredicateName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#79
  def dynamic_method_define(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#98
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#98
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#85
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#112
  def validate_config; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#124
  def allowed_method_name?(method_name, prefix); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#132
  def expected_name(method_name, prefix); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#146
  def forbidden_prefixes; end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#142
  def message(method_name, new_name); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#154
  def method_definition_macros(macro_name); end

  # source://rubocop//lib/rubocop/cop/naming/predicate_name.rb#150
  def predicate_prefixes; end
end

# Makes sure that rescued exceptions variables are named as
# expected.
#
# The `PreferredName` config option takes a `String`. It represents
# the required name of the variable. Its default is `e`.
#
# NOTE: This cop does not consider nested rescues because it cannot
# guarantee that the variable from the outer rescue is not used within
# the inner rescue (in which case, changing the inner variable would
# shadow the outer variable).
#
# @example PreferredName: e (default)
#   # bad
#   begin
#   # do something
#   rescue MyException => exception
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => e
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => _e
#   # do something
#   end
# @example PreferredName: exception
#   # bad
#   begin
#   # do something
#   rescue MyException => e
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => exception
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => _exception
#   # do something
#   end
#
# source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#61
class RuboCop::Cop::Naming::RescuedExceptionsVariableName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#66
  def on_resbody(node); end

  private

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#96
  def autocorrect(corrector, node, range, offending_name, preferred_name); end

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#117
  def correct_node(corrector, node, offending_name, preferred_name); end

  # If the exception variable is reassigned, that assignment needs to be corrected.
  # Further `lvar` nodes will not be corrected though since they now refer to a
  # different variable.
  #
  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#143
  def correct_reassignment(corrector, node, offending_name, preferred_name); end

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#168
  def message(node); end

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#91
  def offense_range(resbody); end

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#152
  def preferred_name(variable_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#174
  def shadowed_variable_name?(node); end

  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#161
  def variable_name(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#106
  def variable_name_matches?(node, name); end
end

# source://rubocop//lib/rubocop/cop/naming/rescued_exceptions_variable_name.rb#64
RuboCop::Cop::Naming::RescuedExceptionsVariableName::MSG = T.let(T.unsafe(nil), String)

# Makes sure that all variables use the configured style,
# snake_case or camelCase, for their names.
#
# @example EnforcedStyle: snake_case (default)
#   # bad
#   fooBar = 1
#
#   # good
#   foo_bar = 1
# @example EnforcedStyle: camelCase
#   # bad
#   foo_bar = 1
#
#   # good
#   fooBar = 1
# @example AllowedIdentifiers: ['fooBar']
#   # good (with EnforcedStyle: snake_case)
#   fooBar = 1
# @example AllowedPatterns: ['_v\d+\z']
#   # good (with EnforcedStyle: camelCase)
#   :release_v1
#
# source://rubocop//lib/rubocop/cop/naming/variable_name.rb#31
class RuboCop::Cop::Naming::VariableName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedIdentifiers
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_arg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_blockarg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_kwarg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_kwoptarg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_kwrestarg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_lvar(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_optarg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#42
  def on_restarg(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#38
  def valid_name?(node, name, given_style = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/naming/variable_name.rb#62
  def message(style); end
end

# source://rubocop//lib/rubocop/cop/naming/variable_name.rb#36
RuboCop::Cop::Naming::VariableName::MSG = T.let(T.unsafe(nil), String)

# Makes sure that all numbered variables use the
# configured style, snake_case, normalcase, or non_integer,
# for their numbering.
#
# Additionally, `CheckMethodNames` and `CheckSymbols` configuration options
# can be used to specify whether method names and symbols should be checked.
# Both are enabled by default.
#
# @example AllowedPatterns: ['_v\d+\z']
#   # good
#   :some_sym_v1
# @example EnforcedStyle: snake_case
#   # bad
#   :some_sym1
#   variable1 = 1
#
#   def some_method1; end
#
#   def some_method_1(arg1); end
#
#   # good
#   :some_sym_1
#   variable_1 = 1
#
#   def some_method_1; end
#
#   def some_method_1(arg_1); end
# @example EnforcedStyle: non_integer
#   # bad
#   :some_sym1
#   :some_sym_1
#
#   variable1 = 1
#   variable_1 = 1
#
#   def some_method1; end
#
#   def some_method_1; end
#
#   def some_methodone(arg1); end
#   def some_methodone(arg_1); end
#
#   # good
#   :some_symone
#   :some_sym_one
#
#   variableone = 1
#   variable_one = 1
#
#   def some_methodone; end
#
#   def some_method_one; end
#
#   def some_methodone(argone); end
#   def some_methodone(arg_one); end
#
#   # In the following examples, we assume `EnforcedStyle: normalcase` (default).
# @example CheckMethodNames: true (default)
#   # bad
#   def some_method_1; end
# @example CheckMethodNames: false
#   # good
#   def some_method_1; end
# @example CheckSymbols: true (default)
#   # bad
#   :some_sym_1
# @example CheckSymbols: false
#   # good
#   :some_sym_1
# @example AllowedIdentifiers: [capture3]
#   # good
#   expect(Open3).to receive(:capture3)
# @example EnforcedStyle: normalcase (default)
#   # bad
#   :some_sym_1
#   variable_1 = 1
#
#   def some_method_1; end
#
#   def some_method1(arg_1); end
#
#   # good
#   :some_sym1
#   variable1 = 1
#
#   def some_method1; end
#
#   def some_method1(arg1); end
#
# source://rubocop//lib/rubocop/cop/naming/variable_number.rb#103
class RuboCop::Cop::Naming::VariableNumber < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedIdentifiers
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNumbering
  include ::RuboCop::Cop::AllowedPattern

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#114
  def on_arg(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#114
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#126
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#126
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#114
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#114
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#114
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#134
  def on_sym(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#110
  def valid_name?(node, name, given_style = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/naming/variable_number.rb#143
  def message(style); end
end

# source://rubocop//lib/rubocop/cop/naming/variable_number.rb#108
RuboCop::Cop::Naming::VariableNumber::MSG = T.let(T.unsafe(nil), String)

# Some common code shared between `NegatedIf` and
# `NegatedWhile` cops.
#
# source://rubocop//lib/rubocop/cop/mixin/negative_conditional.rb#7
module RuboCop::Cop::NegativeConditional
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/negative_conditional.rb#18
  def empty_condition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/negative_conditional.rb#15
  def single_negative?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/negative_conditional.rb#20
  def check_negative_conditional(node, message:, &block); end
end

# source://rubocop//lib/rubocop/cop/mixin/negative_conditional.rb#10
RuboCop::Cop::NegativeConditional::MSG = T.let(T.unsafe(nil), String)

# This module provides a list of methods that are:
# 1. In the NilClass by default
# 2. Added to NilClass by explicitly requiring any standard libraries
# 3. Cop's configuration parameter AllowedMethods.
#
# source://rubocop//lib/rubocop/cop/mixin/nil_methods.rb#9
module RuboCop::Cop::NilMethods
  include ::RuboCop::Cop::AllowedMethods

  private

  # source://rubocop//lib/rubocop/cop/mixin/nil_methods.rb#14
  def nil_methods; end

  # source://rubocop//lib/rubocop/cop/mixin/nil_methods.rb#18
  def other_stdlib_methods; end
end

# An offense represents a style violation detected by RuboCop.
#
# source://rubocop//lib/rubocop/cop/offense.rb#6
class RuboCop::Cop::Offense
  include ::Comparable

  # @api private
  # @return [Offense] a new instance of Offense
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#84
  def initialize(severity, location, message, cop_name, status = T.unsafe(nil), corrector = T.unsafe(nil)); end

  # Returns `-1`, `0`, or `+1`
  # if this offense is less than, equal to, or greater than `other`.
  #
  # @api public
  # @return [Integer] comparison result
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#230
  def <=>(other); end

  # @api public
  # @return [Boolean] returns `true` if two offenses contain same attributes
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#211
  def ==(other); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#160
  def column; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#170
  def column_length; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#194
  def column_range; end

  # @api public
  # @example
  #   'LineLength'
  # @return [String] a cop class name without department.
  #   i.e. type of the violation.
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#51
  def cop_name; end

  # @api public
  # @return [Boolean] whether this offense can be automatically corrected via
  #   autocorrect or a todo.
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#102
  def correctable?; end

  # @api public
  # @return [Boolean] whether this offense is automatically corrected via
  #   autocorrect or a todo.
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#113
  def corrected?; end

  # @api public
  # @return [Boolean] whether this offense is automatically disabled via a todo.
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#123
  def corrected_with_todo?; end

  # @api public
  # @return [Corrector | nil] the autocorrection for this offense, or `nil` when not available
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#62
  def corrector; end

  # @api public
  # @return [Boolean] whether this offense was locally disabled with a
  #   disable or todo where it occurred.
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#134
  def disabled?; end

  # @api public
  # @return [Boolean] returns `true` if two offenses contain same attributes
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#211
  def eql?(other); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#179
  def first_line; end

  # source://rubocop//lib/rubocop/cop/offense.rb#219
  def hash; end

  # @api public
  # @return [Parser::Source::Range] the range of the code that is highlighted
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#142
  def highlighted_area; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#189
  def last_column; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#184
  def last_line; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#155
  def line; end

  # @api public
  # @return [Parser::Source::Range] the location where the violation is detected.
  # @see https://www.rubydoc.info/gems/parser/Parser/Source/Range Parser::Source::Range
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#28
  def location; end

  # @api public
  # @example
  #   'Line is too long. [90/80]'
  # @return [String] human-readable message
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#39
  def message; end

  # Internally we use column number that start at 0, but when
  # outputting column numbers, we want them to start at 1. One
  # reason is that editors, such as Emacs, expect this.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#203
  def real_column; end

  # @api public
  # @return [RuboCop::Cop::Severity]
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#17
  def severity; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#165
  def source_line; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#54
  def status; end

  # This is just for debugging purpose.
  #
  # @api private
  #
  # source://rubocop//lib/rubocop/cop/offense.rb#148
  def to_s; end
end

# @api private
#
# source://rubocop//lib/rubocop/cop/offense.rb#10
RuboCop::Cop::Offense::COMPARISON_ATTRIBUTES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/offense.rb#81
RuboCop::Cop::Offense::NO_LOCATION = T.let(T.unsafe(nil), RuboCop::Cop::Offense::PseudoSourceRange)

# source://rubocop//lib/rubocop/cop/offense.rb#64
class RuboCop::Cop::Offense::PseudoSourceRange < ::Struct
  # Returns the value of attribute begin_pos
  #
  # @return [Object] the current value of begin_pos
  def begin_pos; end

  # Sets the attribute begin_pos
  #
  # @param value [Object] the value to set the attribute begin_pos to.
  # @return [Object] the newly set value
  def begin_pos=(_); end

  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def column; end

  # Sets the attribute column
  #
  # @param value [Object] the value to set the attribute column to.
  # @return [Object] the newly set value
  def column=(_); end

  # source://rubocop//lib/rubocop/cop/offense.rb#70
  def column_range; end

  # Returns the value of attribute end_pos
  #
  # @return [Object] the current value of end_pos
  def end_pos; end

  # Sets the attribute end_pos
  #
  # @param value [Object] the value to set the attribute end_pos to.
  # @return [Object] the newly set value
  def end_pos=(_); end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def first_line; end

  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def last_column; end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def last_line; end

  # source://rubocop//lib/rubocop/cop/offense.rb#74
  def length; end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def line; end

  # Sets the attribute line
  #
  # @param value [Object] the value to set the attribute line to.
  # @return [Object] the newly set value
  def line=(_); end

  # source://rubocop//lib/rubocop/cop/offense.rb#74
  def size; end

  # Returns the value of attribute source_line
  #
  # @return [Object] the current value of source_line
  def source_line; end

  # Sets the attribute source_line
  #
  # @param value [Object] the value to set the attribute source_line to.
  # @return [Object] the newly set value
  def source_line=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Common functionality for cops checking if and unless expressions.
#
# source://rubocop//lib/rubocop/cop/mixin/on_normal_if_unless.rb#6
module RuboCop::Cop::OnNormalIfUnless
  # source://rubocop//lib/rubocop/cop/mixin/on_normal_if_unless.rb#7
  def on_if(node); end
end

# This autocorrects gem dependency order
#
# source://rubocop//lib/rubocop/cop/correctors/ordered_gem_corrector.rb#6
class RuboCop::Cop::OrderedGemCorrector
  extend ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::RangeHelp

  class << self
    # Returns the value of attribute comments_as_separators.
    #
    # source://rubocop//lib/rubocop/cop/correctors/ordered_gem_corrector.rb#11
    def comments_as_separators; end

    # source://rubocop//lib/rubocop/cop/correctors/ordered_gem_corrector.rb#13
    def correct(processed_source, node, previous_declaration, comments_as_separators); end

    # Returns the value of attribute processed_source.
    #
    # source://rubocop//lib/rubocop/cop/correctors/ordered_gem_corrector.rb#11
    def processed_source; end

    private

    # source://rubocop//lib/rubocop/cop/correctors/ordered_gem_corrector.rb#26
    def declaration_with_comment(node); end
  end
end

# Common functionality for Bundler/OrderedGems and
# Gemspec/OrderedDependencies.
#
# source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#7
module RuboCop::Cop::OrderedGemNode
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#23
  def case_insensitive_out_of_order?(string_a, string_b); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#27
  def consecutive_lines(previous, current); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#55
  def find_gem_name(gem_node); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#18
  def gem_canonical_name(name); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#49
  def gem_name(declaration_node); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#10
  def get_source_range(node, comments_as_separators); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#32
  def register_offense(previous, current); end

  # source://rubocop//lib/rubocop/cop/mixin/ordered_gem_node.rb#61
  def treat_comments_as_separators; end
end

# Common functionality for handling parentheses.
#
# source://rubocop//lib/rubocop/cop/mixin/parentheses.rb#6
module RuboCop::Cop::Parentheses
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/parentheses.rb#9
  def parens_required?(node); end
end

# This autocorrects parentheses
#
# source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#6
class RuboCop::Cop::ParenthesesCorrector
  extend ::RuboCop::Cop::RangeHelp

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#12
    def correct(corrector, node); end

    private

    # Add a comma back after the heredoc identifier
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#74
    def add_heredoc_comma(corrector, node); end

    # If the node contains a heredoc, remove the comma too
    # It'll be added back in the right place later
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#64
    def extend_range_for_heredoc(node, range); end

    # If removing parentheses leaves a comma on its own line, remove all the whitespace
    # preceding it to prevent a syntax error.
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#41
    def handle_orphaned_comma(corrector, node); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#80
    def heredoc?(node); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#28
    def next_char_is_question_mark?(node); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#32
    def only_closing_paren_before_comma?(node); end

    # Get a range for the closing parenthesis and all whitespace to the left of it
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#51
    def parens_range(node); end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/correctors/parentheses_corrector.rb#24
    def ternary_condition?(node); end
  end
end

# Common functionality for handling percent arrays.
#
# source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#6
module RuboCop::Cop::PercentArray
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#26
  def allowed_bracket_array?(node); end

  # @param node [RuboCop::AST::ArrayNode]
  # @param elements [Array<String>]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#83
  def build_bracketed_array_with_appropriate_whitespace(elements:, node:); end

  # @param preferred_array_code [String]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#56
  def build_message_for_bracketed_array(preferred_array_code); end

  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#67
  def check_bracketed_array(node, literal_prefix); end

  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#36
  def check_percent_array(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#31
  def comments_in_array?(node); end

  # Override to determine values that are invalid in a percent array
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#22
  def invalid_percent_array_contents?(_node); end

  # Ruby does not allow percent arrays in an ambiguous block context.
  #
  # @example
  #
  #   foo %i[bar baz] { qux }
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#14
  def invalid_percent_array_context?(node); end

  # Provides whitespace between elements for building a bracketed array.
  #   %w[  a   b   c    ]
  #         ^^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#98
  def whitespace_between(node); end

  # Provides leading whitespace for building a bracketed array.
  #   %w[  a   b   c    ]
  #      ^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#111
  def whitespace_leading(node); end

  # Provides trailing whitespace for building a bracketed array.
  #   %w[  a   b   c    ]
  #                 ^^^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_array.rb#120
  def whitespace_trailing(node); end
end

# Common functionality for handling percent literals.
#
# source://rubocop//lib/rubocop/cop/mixin/percent_literal.rb#6
module RuboCop::Cop::PercentLiteral
  include ::RuboCop::Cop::RangeHelp

  private

  # source://rubocop//lib/rubocop/cop/mixin/percent_literal.rb#23
  def begin_source(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/percent_literal.rb#11
  def percent_literal?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/percent_literal.rb#17
  def process(node, *types); end

  # source://rubocop//lib/rubocop/cop/mixin/percent_literal.rb#27
  def type(node); end
end

# This autocorrects percent literals
#
# source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#6
class RuboCop::Cop::PercentLiteralCorrector
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util

  # @return [PercentLiteralCorrector] a new instance of PercentLiteralCorrector
  #
  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#11
  def initialize(config, preferred_delimiters); end

  # Returns the value of attribute config.
  #
  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#9
  def config; end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#16
  def correct(corrector, node, char); end

  # Returns the value of attribute preferred_delimiters.
  #
  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#9
  def preferred_delimiters; end

  private

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#46
  def autocorrect_multiline_words(node, escape, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#52
  def autocorrect_words(node, escape, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#34
  def delimiters_for(type); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#100
  def end_content(source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#30
  def escape_words?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#78
  def first_line?(node, previous_line_num); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#89
  def fix_escaped_content(word_node, escape, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#69
  def line_breaks(node, source, previous_line_num, base_line_num, node_index); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#38
  def new_contents(node, escape, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#82
  def process_lines(node, previous_line_num, base_line_num, source_in_lines); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#58
  def process_multiline_words(node, escape, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#96
  def substitute_escaped_delimiters(content, delimiters); end

  # source://rubocop//lib/rubocop/cop/correctors/percent_literal_corrector.rb#26
  def wrap_contents(corrector, node, contents, char, delimiters); end
end

# Common functionality for checking whether an AST node/token is aligned
# with something on a preceding or following line
#
# source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#7
module RuboCop::Cop::PrecedingFollowingAlignment
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#93
  def aligned_assignment?(range, line); end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#70
  def aligned_comment_lines; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#105
  def aligned_identical?(range, line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#81
  def aligned_operator?(range, line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#77
  def aligned_token?(range, line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#34
  def aligned_with_adjacent_line?(range, predicate); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#52
  def aligned_with_any_line?(line_ranges, range, indent = T.unsafe(nil), &predicate); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#42
  def aligned_with_any_line_range?(line_ranges, range, &predicate); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#98
  def aligned_with_append_operator?(range, line); end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#109
  def aligned_with_assignment(token, line_range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#56
  def aligned_with_line?(line_nos, range, indent = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#18
  def aligned_with_operator?(range); end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#22
  def aligned_with_preceding_assignment(token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#14
  def aligned_with_something?(range); end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#28
  def aligned_with_subsequent_assignment(token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#85
  def aligned_words?(range, line); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#10
  def allow_for_alignment?; end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#127
  def assignment_lines; end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#131
  def assignment_tokens; end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#147
  def relevant_assignment_lines(line_range); end

  # source://rubocop//lib/rubocop/cop/mixin/preceding_following_alignment.rb#174
  def remove_optarg_equals(asgn_tokens, processed_source); end
end

# Common functionality for handling percent literal delimiters.
#
# source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#6
class RuboCop::Cop::PreferredDelimiters
  # @return [PreferredDelimiters] a new instance of PreferredDelimiters
  #
  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#11
  def initialize(type, config, preferred_delimiters); end

  # Returns the value of attribute config.
  #
  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#7
  def config; end

  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#17
  def delimiters; end

  # Returns the value of attribute type.
  #
  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#7
  def type; end

  private

  # @raise [ArgumentError]
  #
  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#23
  def ensure_valid_preferred_delimiters; end

  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#30
  def preferred_delimiters; end

  # source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#45
  def preferred_delimiters_config; end
end

# source://rubocop//lib/rubocop/cop/mixin/preferred_delimiters.rb#9
RuboCop::Cop::PreferredDelimiters::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Array)

# This autocorrects punctuation
#
# source://rubocop//lib/rubocop/cop/correctors/punctuation_corrector.rb#6
class RuboCop::Cop::PunctuationCorrector
  class << self
    # source://rubocop//lib/rubocop/cop/correctors/punctuation_corrector.rb#12
    def add_space(corrector, token); end

    # source://rubocop//lib/rubocop/cop/correctors/punctuation_corrector.rb#8
    def remove_space(corrector, space_before); end

    # source://rubocop//lib/rubocop/cop/correctors/punctuation_corrector.rb#16
    def swap_comma(corrector, range); end
  end
end

module RuboCop::Cop::RSpec; end

class RuboCop::Cop::RSpec::MultipleExpectations < ::RuboCop::Cop::RSpec::Base
  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#78
  def aggregate_failures?(param0 = T.unsafe(nil), param1); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#89
  def aggregate_failures_block?(param0 = T.unsafe(nil)); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#86
  def expect?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#93
  def on_block(node); end

  private

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#109
  def example_with_aggregate_failures?(example_node); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#116
  def find_aggregate_failures(example_node); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#121
  def find_expectation(node, &block); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#132
  def flag_example(node, expectation_count:); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_expectations.rb#143
  def max_expectations; end
end

class RuboCop::Cop::RSpec::MultipleMemoizedHelpers < ::RuboCop::Cop::RSpec::Base
  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#91
  def on_block(node); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#102
  def on_new_investigation; end

  private

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#111
  def all_helpers(node); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#141
  def allow_subject?; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#109
  def example_group_memoized_helpers; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#116
  def helpers(node); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#137
  def max; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/multiple_memoized_helpers.rb#127
  def variable_nodes(node); end
end

class RuboCop::Cop::RSpec::NestedGroups < ::RuboCop::Cop::RSpec::Base
  # source://rubocop//lib/rubocop/cop/exclude_limit.rb#11
  def max=(value); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#107
  def on_top_level_group(node); end

  private

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#157
  def allowed_groups; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#134
  def count_up_nesting?(node, example_group); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#119
  def find_nested_example_groups(node, nesting: T.unsafe(nil), &block); end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#144
  def max_nesting; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#148
  def max_nesting_config; end

  # source://rubocop-rspec/3.0.4/lib/rubocop/cop/rspec/nested_groups.rb#140
  def message(nesting); end
end

# Methods that calculate and return Parser::Source::Ranges
#
# source://rubocop//lib/rubocop/cop/mixin/range_help.rb#6
module RuboCop::Cop::RangeHelp
  private

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#141
  def add_range(range1, range2); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#82
  def column_offset_between(base_range, range); end

  # A range containing only the contents of a literal with delimiters (e.g. in
  # `%i{1 2 3}` this will be the range covering `1 2 3` only).
  #
  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#32
  def contents_range(node); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#100
  def directions(side); end

  # Returns the column attribute of the range, except if the range is on
  # the first line and there's a byte order mark at the beginning of that
  # line, in which case 1 is subtracted from the column value. This gives
  # the column as it appears when viewing the file in an editor.
  #
  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#92
  def effective_column(range); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#109
  def final_pos(src, pos, increment, continuations, newlines, whitespace); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#117
  def move_pos(src, pos, step, condition, regexp); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#123
  def move_pos_str(src, pos, step, condition, needle); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#36
  def range_between(start_pos, end_pos); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#73
  def range_by_whole_lines(range, include_final_newline: T.unsafe(nil), buffer: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#134
  def range_with_comments(node); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#130
  def range_with_comments_and_lines(node); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#40
  def range_with_surrounding_comma(range, side = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#55
  def range_with_surrounding_space(range_positional = T.unsafe(nil), range: T.unsafe(nil), side: T.unsafe(nil), newlines: T.unsafe(nil), whitespace: T.unsafe(nil), continuations: T.unsafe(nil), buffer: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/range_help.rb#11
  def source_range(source_buffer, line_number, column, length = T.unsafe(nil)); end
end

# The Unicode codepoint
#
# source://rubocop//lib/rubocop/cop/mixin/range_help.rb#9
RuboCop::Cop::RangeHelp::BYTE_ORDER_MARK = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cop/mixin/range_help.rb#54
module RuboCop::Cop::RangeHelp::NOT_GIVEN; end

# Common functionality for handling Rational literals.
#
# source://rubocop//lib/rubocop/cop/mixin/rational_literal.rb#6
module RuboCop::Cop::RationalLiteral
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/rational_literal.rb#12
  def rational_literal?(param0 = T.unsafe(nil)); end
end

# Registry that tracks all cops by their badge and department.
#
# source://rubocop//lib/rubocop/cop/registry.rb#19
class RuboCop::Cop::Registry
  include ::Enumerable

  # @return [Registry] a new instance of Registry
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#51
  def initialize(cops = T.unsafe(nil), options = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/registry.rb#232
  def ==(other); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#97
  def contains_cop_matching?(names); end

  # source://rubocop//lib/rubocop/cop/registry.rb#179
  def cops; end

  # source://rubocop//lib/rubocop/cop/registry.rb#224
  def cops_for_department(department); end

  # @return [Boolean] Checks if given name is department
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#93
  def department?(name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#147
  def department_missing?(badge, name); end

  # @return [Array<Symbol>] list of departments for current cops.
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#72
  def departments; end

  # source://rubocop//lib/rubocop/cop/registry.rb#193
  def disabled(config); end

  # source://rubocop//lib/rubocop/cop/registry.rb#67
  def dismiss(cop); end

  # source://rubocop//lib/rubocop/cop/registry.rb#247
  def each(&block); end

  # source://rubocop//lib/rubocop/cop/registry.rb#189
  def enabled(config); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#197
  def enabled?(cop, config); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#213
  def enabled_pending_cop?(cop_cfg, config); end

  # source://rubocop//lib/rubocop/cop/registry.rb#63
  def enlist(cop); end

  # @param cop_name [String]
  # @return [Class, nil]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#253
  def find_by_cop_name(cop_name); end

  # When a cop name is given returns a single-element array with the cop class.
  # When a department name is given returns an array with all the cop classes
  # for that department.
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#260
  def find_cops_by_directive(directive); end

  # source://rubocop//lib/rubocop/cop/registry.rb#265
  def freeze; end

  # source://rubocop//lib/rubocop/cop/registry.rb#184
  def length; end

  # source://rubocop//lib/rubocop/cop/registry.rb#220
  def names; end

  # source://rubocop//lib/rubocop/cop/registry.rb#228
  def names_for_department(department); end

  # Returns the value of attribute options.
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#49
  def options; end

  # source://rubocop//lib/rubocop/cop/registry.rb#151
  def print_warning(name, path); end

  # Convert a user provided cop name into a properly namespaced name
  #
  # @example gives back a correctly qualified cop name
  #
  #   registry = RuboCop::Cop::Registry
  #   registry.qualified_cop_name('Layout/EndOfLine', '') # => 'Layout/EndOfLine'
  # @example fixes incorrect namespaces
  #
  #   registry = RuboCop::Cop::Registry
  #   registry.qualified_cop_name('Lint/EndOfLine', '') # => 'Layout/EndOfLine'
  # @example namespaces bare cop identifiers
  #
  #   registry = RuboCop::Cop::Registry
  #   registry.qualified_cop_name('EndOfLine', '') # => 'Layout/EndOfLine'
  # @example passes back unrecognized cop names
  #
  #   registry = RuboCop::Cop::Registry
  #   registry.qualified_cop_name('NotACop', '') # => 'NotACop'
  # @note Emits a warning if the provided name has an incorrect namespace
  # @param name [String] Cop name extracted from config
  # @param path [String, nil] Path of file that `name` was extracted from
  # @param warn [Boolean] Print a warning if no department given for `name`
  # @raise [AmbiguousCopName] if a bare identifier with two possible namespaces is provided
  # @return [String] Qualified cop name
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#133
  def qualified_cop_name(name, path, warn: T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/registry.rb#166
  def qualify_badge(badge); end

  # source://rubocop//lib/rubocop/cop/registry.rb#243
  def select(&block); end

  # source://rubocop//lib/rubocop/cop/registry.rb#236
  def sort!; end

  # @return [Hash{String => Array<Class>}]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#174
  def to_h; end

  # source://rubocop//lib/rubocop/cop/registry.rb#159
  def unqualified_cop_names; end

  # @return [Registry] Cops for that specific department.
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#78
  def with_department(department); end

  # @return [Registry] Cops not for a specific department.
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#84
  def without_department(department); end

  private

  # source://rubocop//lib/rubocop/cop/registry.rb#283
  def clear_enrollment_queue; end

  # source://rubocop//lib/rubocop/cop/registry.rb#279
  def initialize_copy(reg); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/registry.rb#309
  def registered?(badge); end

  # source://rubocop//lib/rubocop/cop/registry.rb#299
  def resolve_badge(given_badge, real_badge, source_path); end

  # source://rubocop//lib/rubocop/cop/registry.rb#295
  def with(cops); end

  class << self
    # source://rubocop//lib/rubocop/cop/registry.rb#22
    def all; end

    # Returns the value of attribute global.
    #
    # source://rubocop//lib/rubocop/cop/registry.rb#274
    def global; end

    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/registry.rb#44
    def qualified_cop?(name); end

    # source://rubocop//lib/rubocop/cop/registry.rb#26
    def qualified_cop_name(name, origin); end

    # source://rubocop//lib/rubocop/cop/registry.rb#40
    def reset!; end

    # Changes momentarily the global registry
    # Intended for testing purposes
    #
    # source://rubocop//lib/rubocop/cop/registry.rb#32
    def with_temporary_global(temp_global = T.unsafe(nil)); end
  end
end

# Ensure a require statement is present for a standard library determined
# by variable library_name
#
# source://rubocop//lib/rubocop/cop/mixin/require_library.rb#7
module RuboCop::Cop::RequireLibrary
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#12
  def ensure_required(corrector, node, library_name); end

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#33
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#24
  def remove_subsequent_requires(corrector, node, library_name); end

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#51
  def require_any_library?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#56
  def require_library_name?(param0 = T.unsafe(nil), param1); end

  private

  # source://rubocop//lib/rubocop/cop/mixin/require_library.rb#44
  def on_new_investigation; end
end

# source://rubocop//lib/rubocop/cop/mixin/require_library.rb#10
RuboCop::Cop::RequireLibrary::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# This class ensures a require statement is present for a standard library
# determined by the variable library_name
#
# source://rubocop//lib/rubocop/cop/correctors/require_library_corrector.rb#7
class RuboCop::Cop::RequireLibraryCorrector
  extend ::RuboCop::Cop::RangeHelp

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/require_library_corrector.rb#11
    def correct(corrector, node, library_name); end

    # source://rubocop//lib/rubocop/cop/correctors/require_library_corrector.rb#17
    def require_statement(library_name); end
  end
end

# Common functionality for checking `rescue` nodes.
#
# source://rubocop//lib/rubocop/cop/mixin/rescue_node.rb#6
module RuboCop::Cop::RescueNode
  # source://rubocop//lib/rubocop/cop/mixin/rescue_node.rb#7
  def modifier_locations; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/rescue_node.rb#13
  def rescue_modifier?(node); end

  # @deprecated Use ResbodyNode#exceptions instead
  #
  # source://rubocop//lib/rubocop/cop/mixin/rescue_node.rb#20
  def rescued_exceptions(resbody); end
end

# Common functionality for safe assignment. By safe assignment we mean
# putting parentheses around an assignment to indicate "I know I'm using an
# assignment as a condition. It's not a mistake."
#
# source://rubocop//lib/rubocop/cop/mixin/safe_assignment.rb#8
module RuboCop::Cop::SafeAssignment
  extend ::RuboCop::AST::NodePattern::Macros

  # source://rubocop//lib/rubocop/cop/mixin/safe_assignment.rb#14
  def empty_condition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/safe_assignment.rb#20
  def safe_assignment?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/mixin/safe_assignment.rb#17
  def setter_method?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/safe_assignment.rb#22
  def safe_assignment_allowed?; end
end

# source://rubocop//lib/rubocop/cop/security/compound_hash.rb#5
module RuboCop::Cop::Security; end

# Checks for implementations of the `hash` method which combine
# values using custom logic instead of delegating to `Array#hash`.
#
# Manually combining hashes is error prone and hard to follow, especially
# when there are many values. Poor implementations may also introduce
# performance or security concerns if they are prone to collisions.
# Delegating to `Array#hash` is clearer and safer, although it might be slower
# depending on the use case.
#
# @example
#
#   # bad
#   def hash
#   @foo ^ @bar
#   end
#
#   # good
#   def hash
#   [@foo, @bar].hash
#   end
#
# source://rubocop//lib/rubocop/cop/security/compound_hash.rb#30
class RuboCop::Cop::Security::CompoundHash < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#58
  def bad_hash_combinator?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#75
  def contained_in_hash_method?(node, &block); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#42
  def dynamic_hash_method_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#37
  def hash_method_definition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#63
  def monuple_hash?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#87
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#87
  def on_send(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#81
  def outer_bad_hash_combinator?(node); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#68
  def redundant_hash?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/compound_hash.rb#51
  def static_hash_method_definition?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/security/compound_hash.rb#31
RuboCop::Cop::Security::CompoundHash::COMBINATOR_IN_HASH_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/compound_hash.rb#32
RuboCop::Cop::Security::CompoundHash::MONUPLE_HASH_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/compound_hash.rb#34
RuboCop::Cop::Security::CompoundHash::REDUNDANT_HASH_MSG = T.let(T.unsafe(nil), String)

# Checks for the use of `Kernel#eval` and `Binding#eval`.
#
# @example
#
#   # bad
#
#   eval(something)
#   binding.eval(something)
#
# source://rubocop//lib/rubocop/cop/security/eval.rb#14
class RuboCop::Cop::Security::Eval < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/security/eval.rb#19
  def eval?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/eval.rb#23
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/security/eval.rb#15
RuboCop::Cop::Security::Eval::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/eval.rb#16
RuboCop::Cop::Security::Eval::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the first argument to `IO.read`, `IO.binread`, `IO.write`, `IO.binwrite`,
# `IO.foreach`, and `IO.readlines`.
#
# If argument starts with a pipe character (`'|'`) and the receiver is the `IO` class,
# a subprocess is created in the same way as `Kernel#open`, and its output is returned.
# `Kernel#open` may allow unintentional command injection, which is the reason these
# `IO` methods are a security risk.
# Consider to use `File.read` to disable the behavior of subprocess invocation.
#
# @example
#
#   # bad
#   IO.read(path)
#   IO.read('path')
#
#   # good
#   File.read(path)
#   File.read('path')
#   IO.read('| command') # Allow intentional command invocation.
#
# source://rubocop//lib/rubocop/cop/security/io_methods.rb#30
class RuboCop::Cop::Security::IoMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/security/io_methods.rb#36
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/security/io_methods.rb#33
RuboCop::Cop::Security::IoMethods::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/io_methods.rb#34
RuboCop::Cop::Security::IoMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of JSON class methods which have potential
# security issues.
#
# @example
#   # bad
#   JSON.load("{}")
#   JSON.restore("{}")
#
#   # good
#   JSON.parse("{}")
#
# source://rubocop//lib/rubocop/cop/security/json_load.rb#26
class RuboCop::Cop::Security::JSONLoad < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/security/json_load.rb#33
  def json_load(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/json_load.rb#37
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/security/json_load.rb#29
RuboCop::Cop::Security::JSONLoad::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/json_load.rb#30
RuboCop::Cop::Security::JSONLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of Marshal class methods which have
# potential security issues leading to remote code execution when
# loading from an untrusted source.
#
# @example
#   # bad
#   Marshal.load("{}")
#   Marshal.restore("{}")
#
#   # good
#   Marshal.dump("{}")
#
#   # okish - deep copy hack
#   Marshal.load(Marshal.dump({}))
#
# source://rubocop//lib/rubocop/cop/security/marshal_load.rb#21
class RuboCop::Cop::Security::MarshalLoad < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/security/marshal_load.rb#26
  def marshal_load(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/security/marshal_load.rb#31
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/security/marshal_load.rb#22
RuboCop::Cop::Security::MarshalLoad::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/marshal_load.rb#23
RuboCop::Cop::Security::MarshalLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of `Kernel#open` and `URI.open` with dynamic
# data.
#
# `Kernel#open` and `URI.open` enable not only file access but also process
# invocation by prefixing a pipe symbol (e.g., `open("| ls")`).
# So, it may lead to a serious security risk by using variable input to
# the argument of `Kernel#open` and `URI.open`. It would be better to use
# `File.open`, `IO.popen` or `URI.parse#open` explicitly.
#
# NOTE: `open` and `URI.open` with literal strings are not flagged by this
# cop.
#
# @example
#   # bad
#   open(something)
#   open("| #{something}")
#   open("| foo")
#   URI.open(something)
#
#   # good
#   File.open(something)
#   IO.popen(something)
#   URI.parse(something).open
#
#   # good (literal strings)
#   open("foo.text")
#   URI.open("http://example.com")
#
# source://rubocop//lib/rubocop/cop/security/open.rb#37
class RuboCop::Cop::Security::Open < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/security/open.rb#46
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/security/open.rb#42
  def open?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#75
  def composite_string?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#83
  def concatenated_string?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#79
  def interpolated_string?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#57
  def safe?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#67
  def safe_argument?(argument); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/security/open.rb#71
  def simple_string?(node); end
end

# source://rubocop//lib/rubocop/cop/security/open.rb#38
RuboCop::Cop::Security::Open::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/open.rb#39
RuboCop::Cop::Security::Open::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of YAML class methods which have
# potential security issues leading to remote code execution when
# loading from an untrusted source.
#
# NOTE: Ruby 3.1+ (Psych 4) uses `Psych.load` as `Psych.safe_load` by default.
#
# @example
#   # bad
#   YAML.load("--- !ruby/object:Foo {}") # Psych 3 is unsafe by default
#
#   # good
#   YAML.safe_load("--- !ruby/object:Foo {}", [Foo])                    # Ruby 2.5  (Psych 3)
#   YAML.safe_load("--- !ruby/object:Foo {}", permitted_classes: [Foo]) # Ruby 3.0- (Psych 3)
#   YAML.load("--- !ruby/object:Foo {}", permitted_classes: [Foo])      # Ruby 3.1+ (Psych 4)
#   YAML.dump(foo)
#
# source://rubocop//lib/rubocop/cop/security/yaml_load.rb#26
class RuboCop::Cop::Security::YAMLLoad < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/security/yaml_load.rb#37
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/security/yaml_load.rb#33
  def yaml_load(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/security/yaml_load.rb#29
RuboCop::Cop::Security::YAMLLoad::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/security/yaml_load.rb#30
RuboCop::Cop::Security::YAMLLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Severity class is simple value object about severity
#
# source://rubocop//lib/rubocop/cop/severity.rb#6
class RuboCop::Cop::Severity
  include ::Comparable

  # @api private
  # @raise [ArgumentError]
  # @return [Severity] a new instance of Severity
  #
  # source://rubocop//lib/rubocop/cop/severity.rb#30
  def initialize(name_or_code); end

  # source://rubocop//lib/rubocop/cop/severity.rb#62
  def <=>(other); end

  # source://rubocop//lib/rubocop/cop/severity.rb#50
  def ==(other); end

  # source://rubocop//lib/rubocop/cop/severity.rb#42
  def code; end

  # source://rubocop//lib/rubocop/cop/severity.rb#58
  def hash; end

  # source://rubocop//lib/rubocop/cop/severity.rb#46
  def level; end

  # @api public
  # @return [Symbol] severity.
  #   any of `:info`, `:refactor`, `:convention`, `:warning`, `:error` or `:fatal`.
  #
  # source://rubocop//lib/rubocop/cop/severity.rb#22
  def name; end

  # source://rubocop//lib/rubocop/cop/severity.rb#38
  def to_s; end

  class << self
    # source://rubocop//lib/rubocop/cop/severity.rb#24
    def name_from_code(code); end
  end
end

# @api private
#
# source://rubocop//lib/rubocop/cop/severity.rb#12
RuboCop::Cop::Severity::CODE_TABLE = T.let(T.unsafe(nil), Hash)

# source://rubocop//lib/rubocop/cop/severity.rb#9
RuboCop::Cop::Severity::NAMES = T.let(T.unsafe(nil), Array)

# Common functionality for cops checking for missing space after
# punctuation.
#
# source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#7
module RuboCop::Cop::SpaceAfterPunctuation
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#10
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#38
  def allowed_type?(token); end

  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#20
  def each_missing_space(tokens); end

  # The normal offset, i.e., the distance from the punctuation
  # token where a space should be, is 1.
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#49
  def offset; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#42
  def space_forbidden_before_rcurly?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#30
  def space_missing?(token1, token2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#34
  def space_required_before?(token); end
end

# source://rubocop//lib/rubocop/cop/mixin/space_after_punctuation.rb#8
RuboCop::Cop::SpaceAfterPunctuation::MSG = T.let(T.unsafe(nil), String)

# Common functionality for cops checking for space before
# punctuation.
#
# source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#7
module RuboCop::Cop::SpaceBeforePunctuation
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#12
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#22
  def each_missing_space(tokens); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#34
  def space_missing?(token1, token2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#38
  def space_required_after?(token); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#42
  def space_required_after_lcurly?; end
end

# source://rubocop//lib/rubocop/cop/mixin/space_before_punctuation.rb#10
RuboCop::Cop::SpaceBeforePunctuation::MSG = T.let(T.unsafe(nil), String)

# This autocorrects whitespace
#
# source://rubocop//lib/rubocop/cop/correctors/space_corrector.rb#6
class RuboCop::Cop::SpaceCorrector
  extend ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::SurroundingSpace

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/space_corrector.rb#36
    def add_space(processed_source, corrector, left_token, right_token); end

    # source://rubocop//lib/rubocop/cop/correctors/space_corrector.rb#12
    def empty_corrections(processed_source, corrector, empty_config, left_token, right_token); end

    # Returns the value of attribute processed_source.
    #
    # source://rubocop//lib/rubocop/cop/correctors/space_corrector.rb#10
    def processed_source; end

    # source://rubocop//lib/rubocop/cop/correctors/space_corrector.rb#24
    def remove_space(processed_source, corrector, left_token, right_token); end
  end
end

# Common functionality for modifier cops.
#
# source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#6
module RuboCop::Cop::StatementModifier
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::RangeHelp

  private

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#79
  def code_after(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#103
  def comment_disables_cop?(comment); end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#71
  def first_line_comment(node); end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#58
  def if_body_source(if_body); end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#44
  def length_in_modifier_form(node); end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#97
  def max_line_length; end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#67
  def method_source(if_body); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#38
  def modifier_fits_on_single_line?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#27
  def non_eligible_body?(body); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#34
  def non_eligible_condition?(condition); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#20
  def non_eligible_node?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#85
  def parenthesize?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#12
  def single_line_as_modifier?(node); end

  # source://rubocop//lib/rubocop/cop/mixin/statement_modifier.rb#51
  def to_modifier_form(node); end
end

# Classes that include this module just implement functions to determine
# what is an offense and how to do autocorrection. They get help with
# adding offenses for the faulty string nodes, and with filtering out
# nodes.
#
# source://rubocop//lib/rubocop/cop/mixin/string_help.rb#9
module RuboCop::Cop::StringHelp
  # source://rubocop//lib/rubocop/cop/mixin/string_help.rb#26
  def on_regexp(node); end

  # source://rubocop//lib/rubocop/cop/mixin/string_help.rb#10
  def on_str(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/string_help.rb#32
  def inside_interpolation?(node); end
end

# This autocorrects string literals
#
# source://rubocop//lib/rubocop/cop/correctors/string_literal_corrector.rb#6
class RuboCop::Cop::StringLiteralCorrector
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  class << self
    # source://rubocop//lib/rubocop/cop/correctors/string_literal_corrector.rb#10
    def correct(corrector, node, style); end
  end
end

# Common functionality for cops checking single/double quotes.
#
# source://rubocop//lib/rubocop/cop/mixin/string_literals_help.rb#6
module RuboCop::Cop::StringLiteralsHelp
  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/mixin/string_literals_help.rb#9
  def wrong_quotes?(src_or_node); end
end

# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#5
module RuboCop::Cop::Style; end

# Access modifiers should be declared to apply to a group of methods
# or inline before each method, depending on configuration.
# EnforcedStyle config covers only method definitions.
# Applications of visibility methods to symbols can be controlled
# using AllowModifiersOnSymbols config.
# Also, the visibility of `attr*` methods can be controlled using
# AllowModifiersOnAttrs config.
#
# In Ruby 3.0, `attr*` methods now return an array of defined method names
# as symbols. So we can write the modifier and `attr*` in inline style.
# AllowModifiersOnAttrs config allows `attr*` methods to be written in
# inline style without modifying applications that have been maintained
# for a long time in group style. Furthermore, developers who are not very
# familiar with Ruby may know that the modifier applies to `def`, but they
# may not know that it also applies to `attr*` methods. It would be easier
# to understand if we could write `attr*` methods in inline style.
#
# @example EnforcedStyle: group (default)
#   # bad
#   class Foo
#
#   private def bar; end
#   private def baz; end
#
#   end
#
#   # good
#   class Foo
#
#   private
#
#   def bar; end
#   def baz; end
#
#   end
# @example EnforcedStyle: inline
#   # bad
#   class Foo
#
#   private
#
#   def bar; end
#   def baz; end
#
#   end
#
#   # good
#   class Foo
#
#   private def bar; end
#   private def baz; end
#
#   end
# @example AllowModifiersOnSymbols: true (default)
#   # good
#   class Foo
#
#   private :bar, :baz
#
#   end
# @example AllowModifiersOnSymbols: false
#   # bad
#   class Foo
#
#   private :bar, :baz
#
#   end
# @example AllowModifiersOnAttrs: true (default)
#   # good
#   class Foo
#
#   public attr_reader :bar
#   protected attr_writer :baz
#   private attr_accessor :qux
#   private attr :quux
#
#   def public_method; end
#
#   private
#
#   def private_method; end
#
#   end
# @example AllowModifiersOnAttrs: false
#   # bad
#   class Foo
#
#   public attr_reader :bar
#   protected attr_writer :baz
#   private attr_accessor :qux
#   private attr :quux
#
#   end
#
# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#109
class RuboCop::Cop::Style::AccessModifierDeclarations < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#135
  def access_modifier_with_attr?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#130
  def access_modifier_with_symbol?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#140
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#195
  def access_modifier_is_inlined?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#199
  def access_modifier_is_not_inlined?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#177
  def allow_modifiers_on_attrs?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#173
  def allow_modifiers_on_symbols?(node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#158
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#269
  def def_source(node, def_node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#230
  def find_argument_less_modifier_node(node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#219
  def find_corresponding_def_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#187
  def group_style?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#191
  def inline_style?; end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#261
  def insert_inline_modifier(corrector, node, modifier_name); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#209
  def message(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#181
  def offense?(node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#265
  def remove_node(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#244
  def replace_def(corrector, node, def_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#203
  def right_siblings_same_inline_method?(node); end

  # source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#238
  def select_grouped_def_nodes(node); end
end

# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#127
RuboCop::Cop::Style::AccessModifierDeclarations::ALLOWED_NODE_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#115
RuboCop::Cop::Style::AccessModifierDeclarations::GROUP_STYLE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#120
RuboCop::Cop::Style::AccessModifierDeclarations::INLINE_STYLE_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/access_modifier_declarations.rb#125
RuboCop::Cop::Style::AccessModifierDeclarations::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for grouping of accessors in `class` and `module` bodies.
# By default it enforces accessors to be placed in grouped declarations,
# but it can be configured to enforce separating them in multiple declarations.
#
# NOTE: If there is a method call before the accessor method it is always allowed
# as it might be intended like Sorbet.
#
# @example EnforcedStyle: grouped (default)
#   # bad
#   class Foo
#   attr_reader :bar
#   attr_reader :bax
#   attr_reader :baz
#   end
#
#   # good
#   class Foo
#   attr_reader :bar, :bax, :baz
#   end
#
#   # good
#   class Foo
#   # may be intended comment for bar.
#   attr_reader :bar
#
#   sig { returns(String) }
#   attr_reader :bax
#
#   may_be_intended_annotation :baz
#   attr_reader :baz
#   end
# @example EnforcedStyle: separated
#   # bad
#   class Foo
#   attr_reader :bar, :baz
#   end
#
#   # good
#   class Foo
#   attr_reader :bar
#   attr_reader :baz
#   end
#
# source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#50
class RuboCop::Cop::Style::AccessorGrouping < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#59
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#59
  def on_module(node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#59
  def on_sclass(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#82
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#71
  def check(send_node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#114
  def class_send_elements(class_node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#157
  def group_accessors(node, accessors); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#96
  def groupable_accessor?(node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#134
  def groupable_sibling_accessors(send_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#126
  def grouped_style?; end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#143
  def message(send_node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#148
  def preferred_accessors(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#91
  def previous_line_comment?(node); end

  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#163
  def separate_accessors(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#130
  def separated_style?; end
end

# source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#56
RuboCop::Cop::Style::AccessorGrouping::GROUPED_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/accessor_grouping.rb#57
RuboCop::Cop::Style::AccessorGrouping::SEPARATED_MSG = T.let(T.unsafe(nil), String)

# Enforces the use of either `#alias` or `#alias_method`
# depending on configuration.
# It also flags uses of `alias :symbol` rather than `alias bareword`.
#
# However, it will always enforce `method_alias` when used `alias`
# in an instance method definition and in a singleton method definition.
# If used in a block, always enforce `alias_method`
# unless it is an `instance_eval` block.
#
# @example EnforcedStyle: prefer_alias (default)
#   # bad
#   alias_method :bar, :foo
#   alias :bar :foo
#
#   # good
#   alias bar foo
# @example EnforcedStyle: prefer_alias_method
#   # bad
#   alias :bar :foo
#   alias bar foo
#
#   # good
#   alias_method :bar, :foo
#
# source://rubocop//lib/rubocop/cop/style/alias.rb#31
class RuboCop::Cop::Style::Alias < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/alias.rb#52
  def on_alias(node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#41
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/alias.rb#86
  def add_offense_for_args(node, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/alias.rb#76
  def alias_keyword_possible?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/alias.rb#80
  def alias_method_possible?(node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#66
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/alias.rb#125
  def bareword?(sym_node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#129
  def correct_alias_method_to_alias(corrector, send_node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#136
  def correct_alias_to_alias_method(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#143
  def correct_alias_with_symbol_args(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#148
  def identifier(node); end

  # source://rubocop//lib/rubocop/cop/style/alias.rb#114
  def lexical_scope_type(node); end

  # In this expression, will `self` be the same as the innermost enclosing
  # class or module block (:lexical)? Or will it be something else
  # (:dynamic)? If we're in an instance_eval block, return that.
  #
  # source://rubocop//lib/rubocop/cop/style/alias.rb#97
  def scope_type(node); end
end

# source://rubocop//lib/rubocop/cop/style/alias.rb#35
RuboCop::Cop::Style::Alias::MSG_ALIAS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/alias.rb#36
RuboCop::Cop::Style::Alias::MSG_ALIAS_METHOD = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/alias.rb#37
RuboCop::Cop::Style::Alias::MSG_SYMBOL_ARGS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/alias.rb#39
RuboCop::Cop::Style::Alias::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `and` and `or`, and suggests using `&&` and
# `||` instead. It can be configured to check only in conditions or in
# all contexts.
#
# @example EnforcedStyle: conditionals (default)
#   # bad
#   if foo and bar
#   end
#
#   # good
#   foo.save && return
#
#   # good
#   foo.save and return
#
#   # good
#   if foo && bar
#   end
# @example EnforcedStyle: always
#   # bad
#   foo.save and return
#
#   # bad
#   if foo and bar
#   end
#
#   # good
#   foo.save && return
#
#   # good
#   if foo && bar
#   end
#
# source://rubocop//lib/rubocop/cop/style/and_or.rb#44
class RuboCop::Cop::Style::AndOr < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#51
  def on_and(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#56
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#51
  def on_or(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#56
  def on_until(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#56
  def on_until_post(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#56
  def on_while(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#56
  def on_while_post(node); end

  private

  # ! is a special case:
  # 'x and !obj.method arg' can be autocorrected if we
  # recurse down a level and add parens to 'obj.method arg'
  # however, 'not x' also parses as (send x :!)
  #
  # source://rubocop//lib/rubocop/cop/style/and_or.rb#117
  def correct_not(node, receiver, corrector); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#129
  def correct_other(node, corrector); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#95
  def correct_send(node, corrector); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#108
  def correct_setter(node, corrector); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/and_or.rb#143
  def correctable_send?(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#135
  def keep_operator_precedence(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#91
  def message(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#85
  def on_conditionals(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#66
  def process_logical_operator(node); end

  # source://rubocop//lib/rubocop/cop/style/and_or.rb#147
  def whitespace_before_arg(node); end
end

# source://rubocop//lib/rubocop/cop/style/and_or.rb#49
RuboCop::Cop::Style::AndOr::MSG = T.let(T.unsafe(nil), String)

# In Ruby 2.7, arguments forwarding has been added.
#
# This cop identifies places where `do_something(*args, &block)`
# can be replaced by `do_something(...)`.
#
# In Ruby 3.1, anonymous block forwarding has been added.
#
# This cop identifies places where `do_something(&block)` can be replaced
# by `do_something(&)`; if desired, this functionality can be disabled
# by setting `UseAnonymousForwarding: false`.
#
# In Ruby 3.2, anonymous args/kwargs forwarding has been added.
#
# This cop also identifies places where `use_args(*args)`/`use_kwargs(**kwargs)` can be
# replaced by `use_args(*)`/`use_kwargs(**)`; if desired, this functionality can be disabled
# by setting `UseAnonymousForwarding: false`.
#
# And this cop has `RedundantRestArgumentNames`, `RedundantKeywordRestArgumentNames`,
# and `RedundantBlockArgumentNames` options. This configuration is a list of redundant names
# that are sufficient for anonymizing meaningless naming.
#
# Meaningless names that are commonly used can be anonymized by default:
# e.g., `*args`, `**options`, `&block`, and so on.
#
# Names not on this list are likely to be meaningful and are allowed by default.
#
# This cop handles not only method forwarding but also forwarding to `super`.
#
# @example RedundantBlockArgumentNames: ['blk', 'block', 'proc'] (default)
#   # bad - But it is good with `EnforcedStyle: explicit` set for `Naming/BlockForwarding`.
#   def foo(&block)
#   bar(&block)
#   end
#
#   # good
#   def foo(&)
#   bar(&)
#   end
# @example UseAnonymousForwarding: true (default, only relevant for Ruby >= 3.2)
#   # bad
#   def foo(*args, **kwargs, &block)
#   args_only(*args)
#   kwargs_only(**kwargs)
#   block_only(&block)
#   end
#
#   # good
#   def foo(*, **, &)
#   args_only(*)
#   kwargs_only(**)
#   block_only(&)
#   end
# @example UseAnonymousForwarding: false (only relevant for Ruby >= 3.2)
#   # good
#   def foo(*args, **kwargs, &block)
#   args_only(*args)
#   kwargs_only(**kwargs)
#   block_only(&block)
#   end
# @example AllowOnlyRestArgument: true (default, only relevant for Ruby < 3.2)
#   # good
#   def foo(*args)
#   bar(*args)
#   end
#
#   def foo(**kwargs)
#   bar(**kwargs)
#   end
# @example AllowOnlyRestArgument: false (only relevant for Ruby < 3.2)
#   # bad
#   # The following code can replace the arguments with `...`,
#   # but it will change the behavior. Because `...` forwards block also.
#   def foo(*args)
#   bar(*args)
#   end
#
#   def foo(**kwargs)
#   bar(**kwargs)
#   end
# @example RedundantRestArgumentNames: ['args', 'arguments'] (default)
#   # bad
#   def foo(*args)
#   bar(*args)
#   end
#
#   # good
#   def foo(*)
#   bar(*)
#   end
# @example RedundantKeywordRestArgumentNames: ['kwargs', 'options', 'opts'] (default)
#   # bad
#   def foo(**kwargs)
#   bar(**kwargs)
#   end
#
#   # good
#   def foo(**)
#   bar(**)
#   end
# @example
#   # bad
#   def foo(*args, &block)
#   bar(*args, &block)
#   end
#
#   # bad
#   def foo(*args, **kwargs, &block)
#   bar(*args, **kwargs, &block)
#   end
#
#   # good
#   def foo(...)
#   bar(...)
#   end
#
# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#127
class RuboCop::Cop::Style::ArgumentsForwarding < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#146
  def on_def(node); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#146
  def on_defs(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#187
  def add_forward_all_offenses(node, send_classifications, forwardable_args); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#353
  def add_parens_if_missing(node, corrector); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#214
  def add_post_ruby_32_offenses(def_node, send_classifications, forwardable_args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#345
  def allow_only_rest_arguments?; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#337
  def arguments_range(node, first_node); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#265
  def classification_and_forwards(def_node, send_node, referenced_lvars, forwardable_args); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#250
  def classify_send_nodes(def_node, send_nodes, referenced_lvars, forwardable_args); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#497
  def explicit_block_name?; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#170
  def extract_forwardable_args(args); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#240
  def non_splat_or_block_pass_lvar_references(body); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#182
  def only_forwards_all?(send_classifications); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#294
  def outside_block?(node); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#174
  def redundant_forwardable_named_args(restarg, kwrestarg, blockarg); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#284
  def redundant_named_arg(arg, config_name, keyword); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#327
  def register_forward_all_offense(def_or_send, send_or_arguments, rest_or_splat); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#300
  def register_forward_args_offense(def_arguments_or_send, rest_arg_or_splat); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#316
  def register_forward_block_arg_offense(add_parens, def_arguments_or_send, block_arg); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#308
  def register_forward_kwargs_offense(add_parens, def_arguments_or_send, kwrest_arg_or_splat); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#349
  def use_anonymous_forwarding?; end

  class << self
    # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#142
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#135
RuboCop::Cop::Style::ArgumentsForwarding::ADDITIONAL_ARG_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#138
RuboCop::Cop::Style::ArgumentsForwarding::ARGS_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#140
RuboCop::Cop::Style::ArgumentsForwarding::BLOCK_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#134
RuboCop::Cop::Style::ArgumentsForwarding::FORWARDING_LVAR_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#137
RuboCop::Cop::Style::ArgumentsForwarding::FORWARDING_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#139
RuboCop::Cop::Style::ArgumentsForwarding::KWARGS_MSG = T.let(T.unsafe(nil), String)

# Classifies send nodes for possible rest/kwrest/all (including block) forwarding.
#
# source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#360
class RuboCop::Cop::Style::ArgumentsForwarding::SendNodeClassifier
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [SendNodeClassifier] a new instance of SendNodeClassifier
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#372
  def initialize(def_node, send_node, referenced_lvars, forwardable_args, **config); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#400
  def classification; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#367
  def extract_forwarded_kwrest_arg(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#394
  def forwarded_block_arg; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#370
  def forwarded_block_arg?(param0 = T.unsafe(nil), param1); end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#388
  def forwarded_kwrest_arg; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#382
  def forwarded_rest_arg; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#364
  def forwarded_rest_arg?(param0 = T.unsafe(nil), param1); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#468
  def additional_kwargs?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#464
  def additional_kwargs_or_forwarded_kwargs?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#478
  def allow_offense_for_no_block?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#449
  def any_arg_referenced?; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#433
  def arguments; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#412
  def can_forward_all?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#472
  def forward_additional_kwargs?; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#429
  def forwarded_rest_and_kwrest_args; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#491
  def missing_rest_arg_or_kwrest_arg?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#482
  def no_additional_args?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#457
  def no_post_splat_args?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#425
  def offensive_block_forwarding?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#445
  def referenced_block_arg?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#441
  def referenced_kwrest_arg?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#437
  def referenced_rest_arg?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#421
  def ruby_32_missing_rest_or_kwest?; end

  # source://rubocop//lib/rubocop/cop/style/arguments_forwarding.rb#453
  def target_ruby_version; end
end

# Enforces the use of `Array()` instead of explicit `Array` check or `[*var]`.
#
# The cop is disabled by default due to safety concerns.
#
# @example
#   # bad
#   paths = [paths] unless paths.is_a?(Array)
#   paths.each { |path| do_something(path) }
#
#   # bad (always creates a new Array instance)
#   [*paths].each { |path| do_something(path) }
#
#   # good (and a bit more readable)
#   Array(paths).each { |path| do_something(path) }
#
# source://rubocop//lib/rubocop/cop/style/array_coercion.rb#41
class RuboCop::Cop::Style::ArrayCoercion < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/array_coercion.rb#48
  def array_splat?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/array_coercion.rb#63
  def on_array(node); end

  # source://rubocop//lib/rubocop/cop/style/array_coercion.rb#74
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/style/array_coercion.rb#53
  def unless_array?(param0 = T.unsafe(nil)); end
end

# source://rubocop//lib/rubocop/cop/style/array_coercion.rb#45
RuboCop::Cop::Style::ArrayCoercion::CHECK_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/array_coercion.rb#44
RuboCop::Cop::Style::ArrayCoercion::SPLAT_MSG = T.let(T.unsafe(nil), String)

# Identifies usages of `arr[0]` and `arr[-1]` and suggests to change
# them to use `arr.first` and `arr.last` instead.
#
# The cop is disabled by default due to safety concerns.
#
# @example
#   # bad
#   arr[0]
#   arr[-1]
#
#   # good
#   arr.first
#   arr.last
#   arr[0] = 2
#   arr[0][-2]
#
# source://rubocop//lib/rubocop/cop/style/array_first_last.rb#28
class RuboCop::Cop::Style::ArrayFirstLast < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/array_first_last.rb#35
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/array_first_last.rb#58
  def brace_method?(node); end

  # source://rubocop//lib/rubocop/cop/style/array_first_last.rb#53
  def innermost_braces_node(node); end
end

# source://rubocop//lib/rubocop/cop/style/array_first_last.rb#31
RuboCop::Cop::Style::ArrayFirstLast::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/array_first_last.rb#32
RuboCop::Cop::Style::ArrayFirstLast::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# In Ruby 3.1, `Array#intersect?` has been added.
#
# This cop identifies places where `(array1 & array2).any?`
# can be replaced by `array1.intersect?(array2)`.
#
# The `array1.intersect?(array2)` method is faster than
# `(array1 & array2).any?` and is more readable.
#
# In cases like the following, compatibility is not ensured,
# so it will not be detected when using block argument.
#
# [source,ruby]
# ----
# ([1] & [1,2]).any? { |x| false }    # => false
# [1].intersect?([1,2]) { |x| false } # => true
# ----
#
# @example
#   # bad
#   (array1 & array2).any?
#   (array1 & array2).empty?
#
#   # good
#   array1.intersect?(array2)
#   !array1.intersect?(array2)
# @example AllCops:ActiveSupportExtensionsEnabled: false (default)
#   # good
#   (array1 & array2).present?
#   (array1 & array2).blank?
# @example AllCops:ActiveSupportExtensionsEnabled: true
#   # bad
#   (array1 & array2).present?
#   (array1 & array2).blank?
#
#   # good
#   array1.intersect?(array2)
#   !array1.intersect?(array2)
#
# source://rubocop//lib/rubocop/cop/style/array_intersect.rb#49
class RuboCop::Cop::Style::ArrayIntersect < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#65
  def active_support_bad_intersection_check?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#79
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#56
  def regular_bad_intersection_check?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#94
  def bad_intersection_check?(node); end

  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#106
  def message(receiver, argument, method_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/array_intersect.rb#102
  def straight?(method_name); end
end

# source://rubocop//lib/rubocop/cop/style/array_intersect.rb#73
RuboCop::Cop::Style::ArrayIntersect::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/array_intersect.rb#76
RuboCop::Cop::Style::ArrayIntersect::NEGATED_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/array_intersect.rb#77
RuboCop::Cop::Style::ArrayIntersect::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/array_intersect.rb#75
RuboCop::Cop::Style::ArrayIntersect::STRAIGHT_METHODS = T.let(T.unsafe(nil), Array)

# Checks for uses of "*" as a substitute for _join_.
#
# Not all cases can reliably checked, due to Ruby's dynamic
# types, so we consider only cases when the first argument is an
# array literal or the second is a string literal.
#
# @example
#
#   # bad
#   %w(foo bar baz) * ","
#
#   # good
#   %w(foo bar baz).join(",")
#
# source://rubocop//lib/rubocop/cop/style/array_join.rb#20
class RuboCop::Cop::Style::ArrayJoin < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/array_join.rb#27
  def join_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/array_join.rb#29
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/style/array_join.rb#23
RuboCop::Cop::Style::ArrayJoin::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/array_join.rb#24
RuboCop::Cop::Style::ArrayJoin::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#16
class RuboCop::Cop::Style::AsciiComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#21
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#51
  def allowed_non_ascii_chars; end

  # source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#42
  def first_non_ascii_chars(string); end

  # source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#32
  def first_offense_range(comment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#46
  def only_allowed_non_ascii_chars?(string); end
end

# source://rubocop//lib/rubocop/cop/style/ascii_comments.rb#19
RuboCop::Cop::Style::AsciiComments::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of Module#attr.
#
# @example
#   # bad - creates a single attribute accessor (deprecated in Ruby 1.9)
#   attr :something, true
#   attr :one, :two, :three # behaves as attr_reader
#
#   # good
#   attr_accessor :something
#   attr_reader :one, :two, :three
#
# source://rubocop//lib/rubocop/cop/style/attr.rb#17
class RuboCop::Cop::Style::Attr < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/attr.rb#74
  def class_eval?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/attr.rb#24
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/attr.rb#37
  def allowed_context?(node); end

  # source://rubocop//lib/rubocop/cop/style/attr.rb#47
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/attr.rb#43
  def define_attr_method?(node); end

  # source://rubocop//lib/rubocop/cop/style/attr.rb#59
  def message(node); end

  # source://rubocop//lib/rubocop/cop/style/attr.rb#63
  def replacement_method(node); end
end

# source://rubocop//lib/rubocop/cop/style/attr.rb#21
RuboCop::Cop::Style::Attr::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/attr.rb#22
RuboCop::Cop::Style::Attr::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for cases when you could use a block
# accepting version of a method that does automatic
# resource cleanup.
#
# @example
#
#   # bad
#   f = File.open('file')
#
#   # good
#   File.open('file') do |f|
#   # ...
#   end
#
#   # bad
#   f = Tempfile.open('temp')
#
#   # good
#   Tempfile.open('temp') do |f|
#   # ...
#   end
#
# source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#27
class RuboCop::Cop::Style::AutoResourceCleanup < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#32
  def file_open_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#36
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#46
  def cleanup?(node); end
end

# source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#28
RuboCop::Cop::Style::AutoResourceCleanup::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/auto_resource_cleanup.rb#29
RuboCop::Cop::Style::AutoResourceCleanup::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks if usage of %() or %Q() matches configuration.
#
# @example EnforcedStyle: bare_percent (default)
#   # bad
#   %Q(He said: "#{greeting}")
#   %q{She said: 'Hi'}
#
#   # good
#   %(He said: "#{greeting}")
#   %{She said: 'Hi'}
# @example EnforcedStyle: percent_q
#   # bad
#   %|He said: "#{greeting}"|
#   %/She said: 'Hi'/
#
#   # good
#   %Q|He said: "#{greeting}"|
#   %q/She said: 'Hi'/
#
# source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#26
class RuboCop::Cop::Style::BarePercentLiterals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#32
  def on_dstr(node); end

  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#36
  def on_str(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#63
  def add_offense_for_wrong_style(node, good, bad); end

  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#42
  def check(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#59
  def requires_bare_percent?(source); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#55
  def requires_percent_q?(source); end
end

# source://rubocop//lib/rubocop/cop/style/bare_percent_literals.rb#30
RuboCop::Cop::Style::BarePercentLiterals::MSG = T.let(T.unsafe(nil), String)

# Checks for BEGIN blocks.
#
# @example
#   # bad
#   BEGIN { test }
#
# source://rubocop//lib/rubocop/cop/style/begin_block.rb#12
class RuboCop::Cop::Style::BeginBlock < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/style/begin_block.rb#15
  def on_preexe(node); end
end

# source://rubocop//lib/rubocop/cop/style/begin_block.rb#13
RuboCop::Cop::Style::BeginBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for places where `attr_reader` and `attr_writer`
# for the same method can be combined into single `attr_accessor`.
#
# @example
#   # bad
#   class Foo
#   attr_reader :bar
#   attr_writer :bar
#   end
#
#   # good
#   class Foo
#   attr_accessor :bar
#   end
#
# source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#21
class RuboCop::Cop::Style::BisectedAttrAccessor < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#55
  def after_class(class_node); end

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#55
  def after_module(class_node); end

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#55
  def after_sclass(class_node); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#33
  def on_class(class_node); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#33
  def on_module(class_node); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#29
  def on_new_investigation; end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#33
  def on_sclass(class_node); end

  private

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#102
  def correct_reader(corrector, macro, node, range); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#114
  def correct_writer(corrector, macro, node, range); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#91
  def find_bisection(macros); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#74
  def find_macros(class_def); end

  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#98
  def register_offense(attr); end
end

# source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor.rb#27
RuboCop::Cop::Style::BisectedAttrAccessor::MSG = T.let(T.unsafe(nil), String)

# Representation of an `attr_reader`, `attr_writer` or `attr` macro
# for use by `Style/BisectedAttrAccessor`.
#
# @api private
#
# source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#10
class RuboCop::Cop::Style::BisectedAttrAccessor::Macro
  include ::RuboCop::Cop::VisibilityHelp

  # @api private
  # @return [Macro] a new instance of Macro
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#19
  def initialize(node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#49
  def all_bisected?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#29
  def attr_names; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#13
  def attrs; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#25
  def bisect(*names); end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#33
  def bisected_names; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#13
  def bisection; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#13
  def node; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#41
  def reader?; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#53
  def rest; end

  # @api private
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#37
  def visibility; end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#45
  def writer?; end

  class << self
    # @api private
    # @return [Boolean]
    #
    # source://rubocop//lib/rubocop/cop/style/bisected_attr_accessor/macro.rb#15
    def macro?(node); end
  end
end

# Looks for uses of block comments (=begin...=end).
#
# @example
#   # bad
#   =begin
#   Multiple lines
#   of comments...
#   =end
#
#   # good
#   # Multiple lines
#   # of comments...
#
# source://rubocop//lib/rubocop/cop/style/block_comments.rb#19
class RuboCop::Cop::Style::BlockComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/block_comments.rb#27
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/style/block_comments.rb#56
  def eq_end_part(comment, expr); end

  # source://rubocop//lib/rubocop/cop/style/block_comments.rb#48
  def parts(comment); end
end

# source://rubocop//lib/rubocop/cop/style/block_comments.rb#24
RuboCop::Cop::Style::BlockComments::BEGIN_LENGTH = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cop/style/block_comments.rb#25
RuboCop::Cop::Style::BlockComments::END_LENGTH = T.let(T.unsafe(nil), Integer)

# source://rubocop//lib/rubocop/cop/style/block_comments.rb#23
RuboCop::Cop::Style::BlockComments::MSG = T.let(T.unsafe(nil), String)

# Check for uses of braces or do/end around single line or
# multi-line blocks.
#
# Methods that can be either procedural or functional and cannot be
# categorised from their usage alone is ignored.
# `lambda`, `proc`, and `it` are their defaults.
# Additional methods can be added to the `AllowedMethods`.
#
# @example AllowedPatterns: ['map']
#
#   # good
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
# @example EnforcedStyle: semantic
#   # Prefer `do...end` over `{...}` for procedural blocks.
#
#   # return value is used/assigned
#   # bad
#   foo = map do |x|
#   x
#   end
#   puts (map do |x|
#   x
#   end)
#
#   # return value is not used out of scope
#   # good
#   map do |x|
#   x
#   end
#
#   # Prefer `{...}` over `do...end` for functional blocks.
#
#   # return value is not used out of scope
#   # bad
#   each { |x|
#   x
#   }
#
#   # return value is used/assigned
#   # good
#   foo = map { |x|
#   x
#   }
#   map { |x|
#   x
#   }.inspect
#
#   # The AllowBracesOnProceduralOneLiners option is allowed unless the
#   # EnforcedStyle is set to `semantic`. If so:
#
#   # If the AllowBracesOnProceduralOneLiners option is unspecified, or
#   # set to `false` or any other falsey value, then semantic purity is
#   # maintained, so one-line procedural blocks must use do-end, not
#   # braces.
#
#   # bad
#   collection.each { |element| puts element }
#
#   # good
#   collection.each do |element| puts element end
#
#   # If the AllowBracesOnProceduralOneLiners option is set to `true`, or
#   # any other truthy value, then one-line procedural blocks may use
#   # either style. (There is no setting for requiring braces on them.)
#
#   # good
#   collection.each { |element| puts element }
#
#   # also good
#   collection.each do |element| puts element end
# @example EnforcedStyle: braces_for_chaining
#   # bad
#   words.each do |word|
#   word.flip.flop
#   end.join("-")
#
#   # good
#   words.each { |word|
#   word.flip.flop
#   }.join("-")
# @example EnforcedStyle: always_braces
#   # bad
#   words.each do |word|
#   word.flip.flop
#   end
#
#   # good
#   words.each { |word|
#   word.flip.flop
#   }
# @example BracesRequiredMethods: ['sig']
#
#   # Methods listed in the BracesRequiredMethods list, such as 'sig'
#   # in this example, will require `{...}` braces. This option takes
#   # precedence over all other configurations except AllowedMethods.
#
#   # bad
#   sig do
#   params(
#   foo: string,
#   ).void
#   end
#   def bar(foo)
#   puts foo
#   end
#
#   # good
#   sig {
#   params(
#   foo: string,
#   ).void
#   }
#   def bar(foo)
#   puts foo
#   end
# @example AllowedMethods: ['lambda', 'proc', 'it' ] (default)
#
#   # good
#   foo = lambda do |x|
#   puts "Hello, #{x}"
#   end
#
#   foo = lambda do |x|
#   x * 100
#   end
# @example AllowedPatterns: [] (default)
#
#   # bad
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
# @example EnforcedStyle: line_count_based (default)
#   # bad - single line block
#   items.each do |item| item / 5 end
#
#   # good - single line block
#   items.each { |item| item / 5 }
#
#   # bad - multi-line block
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
#
#   # good - multi-line block
#   things.map do |thing|
#   something = thing.some_method
#   process(something)
#   end
#
# source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#168
class RuboCop::Cop::Style::BlockDelimiters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#194
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#194
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#179
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#459
  def array_or_range?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#208
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#463
  def begin_required?(block_node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#236
  def braces_for_chaining_message(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#400
  def braces_for_chaining_style?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#248
  def braces_required_message(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#377
  def braces_required_method?(method_name); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#381
  def braces_required_methods; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#410
  def braces_style?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#455
  def conditional?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#414
  def correction_would_break_code?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#309
  def end_of_chain(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#424
  def functional_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#420
  def functional_method?(method_name); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#326
  def get_blocks(node, &block); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#385
  def line_count_based_block_style?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#218
  def line_count_based_message(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#252
  def message(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#300
  def move_comment_before_block(corrector, comment, block_node, closing_brace); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#432
  def procedural_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#428
  def procedural_oneliners_may_have_braces?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#344
  def proper_block_style?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#316
  def remove_trailing_whitespace(corrector, range, comment); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#263
  def replace_braces_with_do_end(corrector, loc); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#279
  def replace_do_end_with_braces(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#356
  def require_braces?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#448
  def return_value_of_scope?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#436
  def return_value_used?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#389
  def semantic_block_style?(node); end

  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#226
  def semantic_message(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#364
  def special_method?(method_name); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#370
  def special_method_proper_block_style?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#296
  def whitespace_after?(range, length = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#292
  def whitespace_before?(range); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#322
  def with_block?(node); end
end

# source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#175
RuboCop::Cop::Style::BlockDelimiters::ALWAYS_BRACES_MESSAGE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/block_delimiters.rb#177
RuboCop::Cop::Style::BlockDelimiters::BRACES_REQUIRED_MESSAGE = T.let(T.unsafe(nil), String)

# Corrector to correct conditional assignment in `case` statements.
#
# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#604
class RuboCop::Cop::Style::CaseCorrector
  extend ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::Cop::Style::ConditionalCorrectorHelper

  class << self
    # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#609
    def correct(corrector, cop, node); end

    # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#619
    def move_assignment_inside_condition(corrector, node); end

    private

    # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#639
    def extract_branches(case_node); end

    # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#633
    def extract_tail_branches(node); end

    # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#649
    def move_branch_inside_condition(corrector, branch, condition, assignment, column); end
  end
end

# If `AllowOnSelfClass` option is enabled, the cop will ignore violations when the receiver of
# the case equality operator is `self.class`. Note intermediate variables are not accepted.
#
# @example
#   # bad
#   (1..100) === 7
#   /something/ === some_string
#
#   # good
#   something.is_a?(Array)
#   (1..100).include?(7)
#   /something/.match?(some_string)
# @example AllowOnConstant: false (default)
#   # bad
#   Array === something
# @example AllowOnConstant: true
#   # good
#   Array === something
# @example AllowOnSelfClass: false (default)
#   # bad
#   self.class === something
# @example AllowOnSelfClass: true
#   # good
#   self.class === something
#
# source://rubocop//lib/rubocop/cop/style/case_equality.rb#40
class RuboCop::Cop::Style::CaseEquality < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#47
  def case_equality?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#52
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#50
  def self_class?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#90
  def begin_replacement(lhs, rhs); end

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#96
  def const_replacement(lhs, rhs); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#65
  def offending_receiver?(node); end

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#72
  def replacement(lhs, rhs); end

  # source://rubocop//lib/rubocop/cop/style/case_equality.rb#100
  def send_replacement(lhs, rhs); end
end

# source://rubocop//lib/rubocop/cop/style/case_equality.rb#43
RuboCop::Cop::Style::CaseEquality::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/case_equality.rb#44
RuboCop::Cop::Style::CaseEquality::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `if-elsif` constructions
# can be replaced with `case-when`.
#
# @example MinBranchesCount: 3 (default)
#   # bad
#   if status == :active
#   perform_action
#   elsif status == :inactive || status == :hibernating
#   check_timeout
#   elsif status == :invalid
#   report_invalid
#   else
#   final_action
#   end
#
#   # good
#   case status
#   when :active
#   perform_action
#   when :inactive, :hibernating
#   check_timeout
#   when :invalid
#   report_invalid
#   else
#   final_action
#   end
# @example MinBranchesCount: 4
#   # good
#   if status == :active
#   perform_action
#   elsif status == :inactive || status == :hibernating
#   check_timeout
#   elsif status == :invalid
#   report_invalid
#   else
#   final_action
#   end
#
# source://rubocop//lib/rubocop/cop/style/case_like_if.rb#50
class RuboCop::Cop::Style::CaseLikeIf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MinBranchesCount
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#57
  def on_if(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#81
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#231
  def branch_conditions(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#249
  def class_reference?(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#166
  def collect_conditions(node, target, conditions); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#220
  def condition_from_binary_op(lhs, rhs, target); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#202
  def condition_from_equality_node(node, target); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#213
  def condition_from_include_or_cover_node(node, target); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#208
  def condition_from_match_node(node, target); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#185
  def condition_from_send_node(node, target); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#240
  def const_reference?(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#258
  def correction_range(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#253
  def deparenthesize(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#102
  def find_target(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#136
  def find_target_in_equality_node(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#148
  def find_target_in_include_or_cover_node(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#154
  def find_target_in_match_node(node); end

  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#121
  def find_target_in_send_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#274
  def regexp_with_named_captures?(node); end

  # Named captures work with `=~` (if regexp is on lhs) and with `match` (both sides)
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#263
  def regexp_with_working_captures?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/case_like_if.rb#96
  def should_check?(node); end
end

# source://rubocop//lib/rubocop/cop/style/case_like_if.rb#55
RuboCop::Cop::Style::CaseLikeIf::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of the character literal ?x.
# Starting with Ruby 1.9 character literals are
# essentially one-character strings, so this syntax
# is mostly redundant at this point.
#
# ? character literal can be used to express meta and control character.
# That's a good use case of ? literal so it doesn't count it as an offense.
#
# @example
#   # bad
#   ?x
#
#   # good
#   'x'
#
#   # good - control & meta escapes
#   ?\C-\M-d
#   "\C-\M-d" # same as above
#
# source://rubocop//lib/rubocop/cop/style/character_literal.rb#24
class RuboCop::Cop::Style::CharacterLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::StringHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/character_literal.rb#35
  def autocorrect(corrector, node); end

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  #
  # source://rubocop//lib/rubocop/cop/style/character_literal.rb#53
  def correct_style_detected; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/character_literal.rb#30
  def offense?(node); end

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  #
  # source://rubocop//lib/rubocop/cop/style/character_literal.rb#49
  def opposite_style_detected; end
end

# source://rubocop//lib/rubocop/cop/style/character_literal.rb#28
RuboCop::Cop::Style::CharacterLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks the style of children definitions at classes and
# modules. Basically there are two different styles:
#
# The compact style is only forced for classes/modules with one child.
#
# @example EnforcedStyle: nested (default)
#   # good
#   # have each child on its own line
#   class Foo
#   class Bar
#   end
#   end
# @example EnforcedStyle: compact
#   # good
#   # combine definitions as much as possible
#   class Foo::Bar
#   end
#
# source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#33
class RuboCop::Cop::Style::ClassAndModuleChildren < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#42
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#48
  def on_module(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#89
  def add_trailing_end(corrector, node, padding); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#170
  def autocorrect(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#159
  def check_compact_style(node, body); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#151
  def check_nested_style(node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#141
  def check_style(node, body); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#94
  def compact_definition(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#115
  def compact_identifier_name(node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#100
  def compact_node(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#180
  def compact_node_name?(node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#105
  def compact_replacement(node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#137
  def leading_spaces(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#176
  def needs_compacting?(body); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#62
  def nest_definition(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#54
  def nest_or_compact(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#120
  def remove_end(corrector, body); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#71
  def replace_namespace_keyword(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#80
  def split_on_double_colon(corrector, node, padding); end

  # source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#128
  def unindent(corrector, node); end
end

# source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#40
RuboCop::Cop::Style::ClassAndModuleChildren::COMPACT_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/class_and_module_children.rb#39
RuboCop::Cop::Style::ClassAndModuleChildren::NESTED_MSG = T.let(T.unsafe(nil), String)

# Enforces consistent use of `Object#is_a?` or `Object#kind_of?`.
#
# @example EnforcedStyle: is_a? (default)
#   # bad
#   var.kind_of?(Date)
#   var.kind_of?(Integer)
#
#   # good
#   var.is_a?(Date)
#   var.is_a?(Integer)
# @example EnforcedStyle: kind_of?
#   # bad
#   var.is_a?(Time)
#   var.is_a?(String)
#
#   # good
#   var.kind_of?(Time)
#   var.kind_of?(String)
#
# source://rubocop//lib/rubocop/cop/style/class_check.rb#26
class RuboCop::Cop::Style::ClassCheck < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/class_check.rb#45
  def message(node); end

  # source://rubocop//lib/rubocop/cop/style/class_check.rb#33
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/style/class_check.rb#33
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/style/class_check.rb#30
RuboCop::Cop::Style::ClassCheck::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/class_check.rb#31
RuboCop::Cop::Style::ClassCheck::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `Object#instance_of?` instead of class comparison
# for equality.
# `==`, `equal?`, and `eql?` custom method definitions are allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example
#   # bad
#   var.class == Date
#   var.class.equal?(Date)
#   var.class.eql?(Date)
#   var.class.name == 'Date'
#
#   # good
#   var.instance_of?(Date)
# @example AllowedMethods: ['==', 'equal?', 'eql?'] (default)
#   # good
#   def ==(other)
#   self.class == other.class && name == other.name
#   end
#
#   def equal?(other)
#   self.class.equal?(other.class) && name.equal?(other.name)
#   end
#
#   def eql?(other)
#   self.class.eql?(other.class) && name.eql?(other.name)
#   end
# @example AllowedPatterns: [] (default)
#   # bad
#   def eq(other)
#   self.class.eq(other.class) && name.eq(other.name)
#   end
# @example AllowedPatterns: ['eq']
#   # good
#   def eq(other)
#   self.class.eq(other.class) && name.eq(other.name)
#   end
#
# source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#52
class RuboCop::Cop::Style::ClassEqualityComparison < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#64
  def class_comparison_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#70
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#92
  def class_name(class_node, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#112
  def class_name_method?(method_name); end

  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#128
  def offense_range(receiver_node, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#116
  def require_cbase?(class_node); end

  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#124
  def trim_string_quotes(class_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#120
  def unable_to_determine_type?(class_node); end
end

# source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#61
RuboCop::Cop::Style::ClassEqualityComparison::CLASS_NAME_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#58
RuboCop::Cop::Style::ClassEqualityComparison::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/class_equality_comparison.rb#60
RuboCop::Cop::Style::ClassEqualityComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of the class/module name instead of
# self, when defining class/module methods.
#
# @example
#   # bad
#   class SomeClass
#   def SomeClass.class_method
#   # ...
#   end
#   end
#
#   # good
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/style/class_methods.rb#23
class RuboCop::Cop::Style::ClassMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/class_methods.rb#28
  def on_class(node); end

  # source://rubocop//lib/rubocop/cop/style/class_methods.rb#28
  def on_module(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/class_methods.rb#41
  def check_defs(name, node); end
end

# source://rubocop//lib/rubocop/cop/style/class_methods.rb#26
RuboCop::Cop::Style::ClassMethods::MSG = T.let(T.unsafe(nil), String)

# Enforces using `def self.method_name` or `class << self` to define class methods.
#
# @example EnforcedStyle: def_self (default)
#   # bad
#   class SomeClass
#   class << self
#   attr_accessor :class_accessor
#
#   def class_method
#   # ...
#   end
#   end
#   end
#
#   # good
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#
#   class << self
#   attr_accessor :class_accessor
#   end
#   end
#
#   # good - contains private method
#   class SomeClass
#   class << self
#   attr_accessor :class_accessor
#
#   private
#
#   def private_class_method
#   # ...
#   end
#   end
#   end
# @example EnforcedStyle: self_class
#   # bad
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#   end
#
#   # good
#   class SomeClass
#   class << self
#   def class_method
#   # ...
#   end
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#61
class RuboCop::Cop::Style::ClassMethodsDefinitions < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#81
  def on_defs(node); end

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#71
  def on_sclass(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#95
  def all_methods_public?(sclass_node); end

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#115
  def autocorrect_sclass(node, corrector); end

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#102
  def def_nodes(sclass_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#91
  def def_self_style?; end

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#141
  def extract_def_from_sclass(def_node, sclass_node); end

  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#152
  def indentation_diff(node1, node2); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#137
  def sclass_only_has_methods?(node); end
end

# source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#68
RuboCop::Cop::Style::ClassMethodsDefinitions::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/class_methods_definitions.rb#69
RuboCop::Cop::Style::ClassMethodsDefinitions::MSG_SCLASS = T.let(T.unsafe(nil), String)

# Checks for uses of class variables. Offenses
# are signaled only on assignment to class variables to
# reduce the number of offenses that would be reported.
#
# You have to be careful when setting a value for a class
# variable; if a class has been inherited, changing the
# value of a class variable also affects the inheriting
# classes. This means that it's almost always better to
# use a class instance variable instead.
#
# @example
#   # bad
#   class A
#   @@test = 10
#   end
#
#   class A
#   def self.test(name, value)
#   class_variable_set("@@#{name}", value)
#   end
#   end
#
#   class A; end
#   A.class_variable_set(:@@test, 10)
#
#   # good
#   class A
#   @test = 10
#   end
#
#   class A
#   def test
#   @@test # you can access class variable without offense
#   end
#   end
#
#   class A
#   def self.test(name)
#   class_variable_get("@@#{name}") # you can access without offense
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/style/class_vars.rb#48
class RuboCop::Cop::Style::ClassVars < ::RuboCop::Cop::Base
  # source://rubocop//lib/rubocop/cop/style/class_vars.rb#52
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/style/class_vars.rb#56
  def on_send(node); end
end

# source://rubocop//lib/rubocop/cop/style/class_vars.rb#49
RuboCop::Cop::Style::ClassVars::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/class_vars.rb#50
RuboCop::Cop::Style::ClassVars::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where custom logic on rejection nils from arrays
# and hashes can be replaced with `{Array,Hash}#{compact,compact!}`.
#
# @example
#   # bad
#   array.reject(&:nil?)
#   array.reject { |e| e.nil? }
#   array.select { |e| !e.nil? }
#   array.grep_v(nil)
#   array.grep_v(NilClass)
#
#   # good
#   array.compact
#
#   # bad
#   hash.reject!(&:nil?)
#   array.delete_if(&:nil?)
#   hash.reject! { |k, v| v.nil? }
#   array.delete_if { |e| e.nil? }
#   hash.select! { |k, v| !v.nil? }
#
#   # good
#   hash.compact!
# @example AllowedReceivers: ['params']
#   # good
#   params.reject(&:nil?)
#
# source://rubocop//lib/rubocop/cop/style/collection_compact.rb#44
class RuboCop::Cop::Style::CollectionCompact < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedReceivers
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#85
  def grep_v_with_nil?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#89
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#89
  def on_send(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#64
  def reject_method?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#57
  def reject_method_with_block_pass?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#74
  def select_method?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#129
  def good_method_name(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#106
  def offense_range(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#137
  def range(begin_pos_node, end_pos_node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/collection_compact.rb#123
  def to_enum_method?(node); end
end

# source://rubocop//lib/rubocop/cop/style/collection_compact.rb#50
RuboCop::Cop::Style::CollectionCompact::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/collection_compact.rb#51
RuboCop::Cop::Style::CollectionCompact::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/collection_compact.rb#52
RuboCop::Cop::Style::CollectionCompact::TO_ENUM_METHODS = T.let(T.unsafe(nil), Array)

# Enforces the use of consistent method names
# from the Enumerable module.
#
# You can customize the mapping from undesired method to desired method.
#
# e.g. to use `detect` over `find`:
#
#   Style/CollectionMethods:
#     PreferredMethods:
#       find: detect
#
# @example
#   # These examples are based on the default mapping for `PreferredMethods`.
#
#   # bad
#   items.collect
#   items.collect!
#   items.collect_concat
#   items.inject
#   items.detect
#   items.find_all
#   items.member?
#
#   # good
#   items.map
#   items.map!
#   items.flat_map
#   items.reduce
#   items.find
#   items.select
#   items.include?
#
# source://rubocop//lib/rubocop/cop/style/collection_methods.rb#43
class RuboCop::Cop::Style::CollectionMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MethodPreference
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#49
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#49
  def on_numblock(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#55
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#63
  def check_method_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#72
  def implicit_block?(node); end

  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#80
  def message(node); end

  # Some enumerable methods accept a bare symbol (ie. _not_ Symbol#to_proc) instead
  # of a block.
  #
  # source://rubocop//lib/rubocop/cop/style/collection_methods.rb#86
  def methods_accepting_symbol; end
end

# source://rubocop//lib/rubocop/cop/style/collection_methods.rb#47
RuboCop::Cop::Style::CollectionMethods::MSG = T.let(T.unsafe(nil), String)

# Checks for methods invoked via the `::` operator instead
# of the `.` operator (like `FileUtils::rmdir` instead of `FileUtils.rmdir`).
#
# @example
#   # bad
#   Timeout::timeout(500) { do_something }
#   FileUtils::rmdir(dir)
#   Marshal::dump(obj)
#
#   # good
#   Timeout.timeout(500) { do_something }
#   FileUtils.rmdir(dir)
#   Marshal.dump(obj)
#
# source://rubocop//lib/rubocop/cop/style/colon_method_call.rb#20
class RuboCop::Cop::Style::ColonMethodCall < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/colon_method_call.rb#26
  def java_type_node?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/colon_method_call.rb#35
  def on_send(node); end

  class << self
    # source://rubocop//lib/rubocop/cop/style/colon_method_call.rb#31
    def autocorrect_incompatible_with; end
  end
end

# source://rubocop//lib/rubocop/cop/style/colon_method_call.rb#23
RuboCop::Cop::Style::ColonMethodCall::MSG = T.let(T.unsafe(nil), String)

# Checks for class methods that are defined using the `::`
# operator instead of the `.` operator.
#
# @example
#   # bad
#   class Foo
#   def self::bar
#   end
#   end
#
#   # good
#   class Foo
#   def self.bar
#   end
#   end
#
# source://rubocop//lib/rubocop/cop/style/colon_method_definition.rb#22
class RuboCop::Cop::Style::ColonMethodDefinition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/colon_method_definition.rb#27
  def on_defs(node); end
end

# source://rubocop//lib/rubocop/cop/style/colon_method_definition.rb#25
RuboCop::Cop::Style::ColonMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for places where multiple consecutive loops over the same data
# can be combined into a single loop. It is very likely that combining them
# will make the code more efficient and more concise.
#
# @example
#   # bad
#   def method
#   items.each do |item|
#   do_something(item)
#   end
#
#   items.each do |item|
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   items.each do |item|
#   do_something(item)
#   do_something_else(item)
#   end
#   end
#
#   # bad
#   def method
#   for item in items do
#   do_something(item)
#   end
#
#   for item in items do
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   for item in items do
#   do_something(item)
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   each_slice(2) { |slice| do_something(slice) }
#   each_slice(3) { |slice| do_something(slice) }
#   end
#
# source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#59
class RuboCop::Cop::Style::CombinableLoops < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#64
  def on_block(node); end

  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#77
  def on_for(node); end

  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#64
  def on_numblock(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#88
  def collection_looping_method?(node); end

  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#105
  def combine_with_left_sibling(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#112
  def correct_end_of_block(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#93
  def same_collection_looping_block?(node, sibling); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#101
  def same_collection_looping_for?(node, sibling); end
end

# source://rubocop//lib/rubocop/cop/style/combinable_loops.rb#62
RuboCop::Cop::Style::CombinableLoops::MSG = T.let(T.unsafe(nil), String)

# Enforces using `` or %x around command literals.
#
# @example EnforcedStyle: backticks (default)
#   # bad
#   folders = %x(find . -type d).split
#
#   # bad
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
#
#   # good
#   folders = `find . -type d`.split
#
#   # good
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
# @example EnforcedStyle: mixed
#   # bad
#   folders = %x(find . -type d).split
#
#   # bad
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
#
#   # good
#   folders = `find . -type d`.split
#
#   # good
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
# @example EnforcedStyle: percent_x
#   # bad
#   folders = `find . -type d`.split
#
#   # bad
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
#
#   # good
#   folders = %x(find . -type d).split
#
#   # good
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
# @example AllowInnerBackticks: false (default)
#   # If `false`, the cop will always recommend using `%x` if one or more
#   # backticks are found in the command string.
#
#   # bad
#   `echo \`ls\``
#
#   # good
#   %x(echo `ls`)
# @example AllowInnerBackticks: true
#   # good
#   `echo \`ls\``
#
# source://rubocop//lib/rubocop/cop/style/command_literal.rb#78
class RuboCop::Cop::Style::CommandLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#85
  def on_xstr(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#146
  def allow_inner_backticks?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#122
  def allowed_backtick_literal?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#131
  def allowed_percent_x_literal?(node); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#109
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#159
  def backtick_literal?(node); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#97
  def check_backtick_literal(node, message); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#103
  def check_percent_x_literal(node, message); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#167
  def command_delimiter; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#150
  def contains_backtick?(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#142
  def contains_disallowed_backtick?(node); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#171
  def default_delimiter; end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#154
  def node_body(node); end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#163
  def preferred_delimiter; end

  # source://rubocop//lib/rubocop/cop/style/command_literal.rb#175
  def preferred_delimiters_config; end
end

# source://rubocop//lib/rubocop/cop/style/command_literal.rb#82
RuboCop::Cop::Style::CommandLiteral::MSG_USE_BACKTICKS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/command_literal.rb#83
RuboCop::Cop::Style::CommandLiteral::MSG_USE_PERCENT_X = T.let(T.unsafe(nil), String)

# Checks that comment annotation keywords are written according
# to guidelines.
#
# Annotation keywords can be specified by overriding the cop's `Keywords`
# configuration. Keywords are allowed to be single words or phrases.
#
# NOTE: With a multiline comment block (where each line is only a
# comment), only the first line will be able to register an offense, even
# if an annotation keyword starts another line. This is done to prevent
# incorrect registering of keywords (eg. `review`) inside a paragraph as an
# annotation.
#
# @example RequireColon: true (default)
#   # bad
#   # TODO make better
#
#   # good
#   # TODO: make better
#
#   # bad
#   # TODO:make better
#
#   # good
#   # TODO: make better
#
#   # bad
#   # fixme: does not work
#
#   # good
#   # FIXME: does not work
#
#   # bad
#   # Optimize does not work
#
#   # good
#   # OPTIMIZE: does not work
# @example RequireColon: false
#   # bad
#   # TODO: make better
#
#   # good
#   # TODO make better
#
#   # bad
#   # fixme does not work
#
#   # good
#   # FIXME does not work
#
#   # bad
#   # Optimize does not work
#
#   # good
#   # OPTIMIZE does not work
#
# source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#61
class RuboCop::Cop::Style::CommentAnnotation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#73
  def on_new_investigation; end

  private

  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#110
  def annotation_range(annotation); end

  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#114
  def correct_offense(corrector, range, keyword); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#102
  def first_comment_line?(comments, index); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#106
  def inline_comment?(comment); end

  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#124
  def keywords; end

  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#87
  def register_offense(annotation); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#120
  def requires_colon?; end
end

# source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#71
RuboCop::Cop::Style::CommentAnnotation::MISSING_NOTE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#65
RuboCop::Cop::Style::CommentAnnotation::MSG_COLON_STYLE = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/comment_annotation.rb#68
RuboCop::Cop::Style::CommentAnnotation::MSG_SPACE_STYLE = T.let(T.unsafe(nil), String)

# Checks for comments put on the same line as some keywords.
# These keywords are: `class`, `module`, `def`, `begin`, `end`.
#
# Note that some comments
# are allowed.
#
# Autocorrection removes comments from `end` keyword and keeps comments
# for `class`, `module`, `def` and `begin` above the keyword.
#
# @example
#   # bad
#   if condition
#   statement
#   end # end if
#
#   # bad
#   class X # comment
#   statement
#   end
#
#   # bad
#   def x; end # comment
#
#   # good
#   if condition
#   statement
#   end
#
#   # good
#   class X # :nodoc:
#   y
#   end
#
# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#45
class RuboCop::Cop::Style::CommentedKeyword < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#60
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#83
  def offensive?(comment); end

  # source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#70
  def register_offense(comment, matched_keyword); end

  # source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#89
  def source_line(comment); end
end

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#54
RuboCop::Cop::Style::CommentedKeyword::ALLOWED_COMMENTS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#55
RuboCop::Cop::Style::CommentedKeyword::ALLOWED_COMMENT_REGEXES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#51
RuboCop::Cop::Style::CommentedKeyword::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#52
RuboCop::Cop::Style::CommentedKeyword::KEYWORD_REGEXES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#49
RuboCop::Cop::Style::CommentedKeyword::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/commented_keyword.rb#58
RuboCop::Cop::Style::CommentedKeyword::REGEXP = T.let(T.unsafe(nil), Regexp)

# Enforces the use of `Comparable#clamp` instead of comparison by minimum and maximum.
#
# This cop supports autocorrection for `if/elsif/else` bad style only.
# Because `ArgumentError` occurs if the minimum and maximum of `clamp` arguments are reversed.
# When these are variables, it is not possible to determine which is the minimum and maximum:
#
# [source,ruby]
# ----
# [1, [2, 3].max].min # => 1
# 1.clamp(3, 1)       # => min argument must be smaller than max argument (ArgumentError)
# ----
#
# @example
#
#   # bad
#   [[x, low].max, high].min
#
#   # bad
#   if x < low
#   low
#   elsif high < x
#   high
#   else
#   x
#   end
#
#   # good
#   x.clamp(low, high)
#
# source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#35
class RuboCop::Cop::Style::ComparableClamp < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#61
  def array_min_max?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#47
  def if_elsif_else_condition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#78
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#100
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#108
  def autocorrect(corrector, node, prefer); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#117
  def min_condition?(if_condition, else_body); end
end

# source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#42
RuboCop::Cop::Style::ComparableClamp::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#43
RuboCop::Cop::Style::ComparableClamp::MSG_MIN_MAX = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/comparable_clamp.rb#44
RuboCop::Cop::Style::ComparableClamp::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `Array#push(item)` instead of `Array#concat([item])`
# to avoid redundant array literals.
#
# @example
#
#   # bad
#   list.concat([foo])
#   list.concat([bar, baz])
#   list.concat([qux, quux], [corge])
#
#   # good
#   list.push(foo)
#   list.push(bar, baz)
#   list.push(qux, quux, corge)
#
# source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#25
class RuboCop::Cop::Style::ConcatArrayLiterals < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#34
  def on_csend(node); end

  # source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#34
  def on_send(node); end

  private

  # source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#70
  def offense_range(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#87
  def percent_literals_includes_only_basic_literals?(node); end

  # source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#74
  def preferred_method(node); end
end

# source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#28
RuboCop::Cop::Style::ConcatArrayLiterals::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#29
RuboCop::Cop::Style::ConcatArrayLiterals::MSG_FOR_PERCENT_LITERALS = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/concat_array_literals.rb#31
RuboCop::Cop::Style::ConcatArrayLiterals::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Check for `if` and `case` statements where each branch is used for
# both the assignment and comparison of the same variable
# when using the return of the condition can be used instead.
#
# @example EnforcedStyle: assign_to_condition (default)
#   # bad
#   if foo
#   bar = 1
#   else
#   bar = 2
#   end
#
#   case foo
#   when 'a'
#   bar += 1
#   else
#   bar += 2
#   end
#
#   if foo
#   some_method
#   bar = 1
#   else
#   some_other_method
#   bar = 2
#   end
#
#   # good
#   bar = if foo
#   1
#   else
#   2
#   end
#
#   bar += case foo
#   when 'a'
#   1
#   else
#   2
#   end
#
#   bar << if foo
#   some_method
#   1
#   else
#   some_other_method
#   2
#   end
# @example EnforcedStyle: assign_inside_condition
#   # bad
#   bar = if foo
#   1
#   else
#   2
#   end
#
#   bar += case foo
#   when 'a'
#   1
#   else
#   2
#   end
#
#   bar << if foo
#   some_method
#   1
#   else
#   some_other_method
#   2
#   end
#
#   # good
#   if foo
#   bar = 1
#   else
#   bar = 2
#   end
#
#   case foo
#   when 'a'
#   bar += 1
#   else
#   bar += 2
#   end
#
#   if foo
#   some_method
#   bar = 1
#   else
#   some_other_method
#   bar = 2
#   end
#
# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#210
class RuboCop::Cop::Style::ConditionalAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # The shovel operator `<<` does not have its own type. It is a `send`
  # type.
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#228
  def assignment_type?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#309
  def candidate_condition?(param0 = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_and_asgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#264
  def on_case(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#274
  def on_case_match(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_casgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_cvasgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_gvasgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#250
  def on_if(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_ivasgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_lvasgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_masgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_op_asgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#236
  def on_or_asgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#244
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#315
  def allowed_single_line?(branches); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#386
  def allowed_statements?(branches); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#311
  def allowed_ternary?(assignment); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#319
  def assignment_node(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#363
  def assignment_types_match?(*nodes); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#378
  def autocorrect(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#304
  def candidate_node?(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#286
  def check_assignment_to_condition(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#369
  def check_node(node, branches); end

  # If `Layout/LineLength` is enabled, we do not want to introduce an
  # offense by autocorrecting this cop. Find the max configured line
  # length. Find the longest line of condition. Remove the assignment
  # from lines that contain the offending assignment because after
  # correcting, this will not be on the line anymore. Check if the length
  # of the longest line + the length of the corrected assignment is
  # greater than the max configured line length
  #
  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#402
  def correction_exceeds_line_limit?(node, branches); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#433
  def include_ternary?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#356
  def lhs_all_match?(branches); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#421
  def line_length_cop_enabled?; end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#414
  def longest_line(node, assignment); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#410
  def longest_line_exceeds_line_limit?(node, assignment); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#425
  def max_line_length; end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#340
  def move_assignment_inside_condition(corrector, node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#330
  def move_assignment_outside_condition(corrector, node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#429
  def single_line_conditions_only?; end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#352
  def ternary_condition?(node); end
end

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#219
RuboCop::Cop::Style::ConditionalAssignment::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#217
RuboCop::Cop::Style::ConditionalAssignment::ASSIGN_TO_CONDITION_MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#221
RuboCop::Cop::Style::ConditionalAssignment::ENABLED = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#220
RuboCop::Cop::Style::ConditionalAssignment::LINE_LENGTH = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#222
RuboCop::Cop::Style::ConditionalAssignment::MAX = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#216
RuboCop::Cop::Style::ConditionalAssignment::MSG = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#223
RuboCop::Cop::Style::ConditionalAssignment::SINGLE_LINE_CONDITIONS_ONLY = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#218
RuboCop::Cop::Style::ConditionalAssignment::VARIABLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# Helper module to provide common methods to classes needed for the
# ConditionalAssignment Cop.
#
# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#8
module RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#64
  def end_with_eq?(sym); end

  # `elsif` branches show up in the `node` as an `else`. We need
  # to recursively iterate over all `else` branches and consider all
  # but the last `node` an `elsif` branch and consider the last `node`
  # the actual `else` branch.
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#20
  def expand_elses(branch); end

  # `when` nodes contain the entire branch including the condition.
  # We only need the contents of the branch, not the condition.
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#28
  def expand_when_branches(when_branches); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#55
  def indent(cop, source); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#37
  def lhs(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#32
  def tail(branch); end

  private

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#109
  def assignment_rhs_exist?(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#70
  def expand_elsif(node, elsif_branches = T.unsafe(nil)); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#96
  def lhs_for_casgn(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#83
  def lhs_for_send(node); end

  # @return [Boolean]
  #
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#105
  def setter_method?(method_name); end
end

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#13
RuboCop::Cop::Style::ConditionalAssignmentHelper::ALIGN_WITH = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#12
RuboCop::Cop::Style::ConditionalAssignmentHelper::END_ALIGNMENT = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#11
RuboCop::Cop::Style::ConditionalAssignmentHelper::EQUAL = T.let(T.unsafe(nil), String)

# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#14
RuboCop::Cop::Style::ConditionalAssignmentHelper::KEYWORD = T.let(T.unsafe(nil), String)

# Helper module to provide common methods to ConditionalAssignment
# correctors
#
# source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#440
module RuboCop::Cop::Style::ConditionalCorrectorHelper
  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#461
  def assignment(node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#490
  def correct_branches(corrector, branches); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#467
  def correct_if_branches(corrector, cop, node); end

  # source://rubocop//lib/rubocop/cop/style/conditional_assignment.rb#441
  def remove_whitespace_in_branches(corrector, br