# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sqlite3` gem.
# Please instead update this file by running `bin/tapioca gem sqlite3`.


module Process
  extend ::SQLite3::ForkSafety::CoreExt
  extend ::ActiveSupport::ForkTracker::CoreExt
end

# source://sqlite3//lib/sqlite3/constants.rb#1
module SQLite3
  class << self
    def libversion; end
    def sqlcipher?; end
    def status(*_arg0); end
    def threadsafe; end

    # Was sqlite3 compiled with thread safety on?
    #
    # @return [Boolean]
    #
    # source://sqlite3//lib/sqlite3.rb#14
    def threadsafe?; end
  end
end

# source://sqlite3//lib/sqlite3/errors.rb#43
class SQLite3::AbortException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#81
class SQLite3::AuthorizationException < ::SQLite3::Exception; end

class SQLite3::Backup
  def initialize(_arg0, _arg1, _arg2, _arg3); end

  def finish; end
  def pagecount; end
  def remaining; end
  def step(_arg0); end
end

class SQLite3::Blob < ::String; end

# source://sqlite3//lib/sqlite3/errors.rb#45
class SQLite3::BusyException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#63
class SQLite3::CantOpenException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/constants.rb#2
module SQLite3::Constants; end

# CAPI3REF: Fundamental Datatypes
#
# ^(Every value in SQLite has one of five fundamental datatypes:
#
# <ul>
# <li> 64-bit signed integer
# <li> 64-bit IEEE floating point number
# <li> string
# <li> BLOB
# <li> NULL
# </ul>)^
#
# These constants are codes for each of those types.
#
# source://sqlite3//lib/sqlite3/constants.rb#39
module SQLite3::Constants::ColumnType; end

# source://sqlite3//lib/sqlite3/constants.rb#43
SQLite3::Constants::ColumnType::BLOB = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/constants.rb#41
SQLite3::Constants::ColumnType::FLOAT = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/constants.rb#40
SQLite3::Constants::ColumnType::INTEGER = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/constants.rb#44
SQLite3::Constants::ColumnType::NULL = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/constants.rb#42
SQLite3::Constants::ColumnType::TEXT = T.let(T.unsafe(nil), Integer)

# CAPI3REF: Result Codes
#
# Many SQLite functions return an integer result code from the set shown
# here in order to indicate success or failure.
#
# New error codes may be added in future versions of SQLite.
#
# source://sqlite3//lib/sqlite3/constants.rb#55
module SQLite3::Constants::ErrorCode; end

# Callback routine requested an abort
#
# source://sqlite3//lib/sqlite3/constants.rb#65
SQLite3::Constants::ErrorCode::ABORT = T.let(T.unsafe(nil), Integer)

# Authorization denied
#
# source://sqlite3//lib/sqlite3/constants.rb#103
SQLite3::Constants::ErrorCode::AUTH = T.let(T.unsafe(nil), Integer)

# The database file is locked
#
# source://sqlite3//lib/sqlite3/constants.rb#67
SQLite3::Constants::ErrorCode::BUSY = T.let(T.unsafe(nil), Integer)

# Unable to open the database file
#
# source://sqlite3//lib/sqlite3/constants.rb#85
SQLite3::Constants::ErrorCode::CANTOPEN = T.let(T.unsafe(nil), Integer)

# Abort due to constraint violation
#
# source://sqlite3//lib/sqlite3/constants.rb#95
SQLite3::Constants::ErrorCode::CONSTRAINT = T.let(T.unsafe(nil), Integer)

# The database disk image is malformed
#
# source://sqlite3//lib/sqlite3/constants.rb#79
SQLite3::Constants::ErrorCode::CORRUPT = T.let(T.unsafe(nil), Integer)

# sqlite_step() has finished executing
#
# source://sqlite3//lib/sqlite3/constants.rb#117
SQLite3::Constants::ErrorCode::DONE = T.let(T.unsafe(nil), Integer)

# (Internal Only) Database table is empty
#
# source://sqlite3//lib/sqlite3/constants.rb#89
SQLite3::Constants::ErrorCode::EMPTY = T.let(T.unsafe(nil), Integer)

# SQL error or missing database
#
# source://sqlite3//lib/sqlite3/constants.rb#59
SQLite3::Constants::ErrorCode::ERROR = T.let(T.unsafe(nil), Integer)

# Not used
#
# source://sqlite3//lib/sqlite3/constants.rb#105
SQLite3::Constants::ErrorCode::FORMAT = T.let(T.unsafe(nil), Integer)

# Insertion failed because database is full
#
# source://sqlite3//lib/sqlite3/constants.rb#83
SQLite3::Constants::ErrorCode::FULL = T.let(T.unsafe(nil), Integer)

# An internal logic error in SQLite
#
# source://sqlite3//lib/sqlite3/constants.rb#61
SQLite3::Constants::ErrorCode::INTERNAL = T.let(T.unsafe(nil), Integer)

# Operation terminated by sqlite_interrupt()
#
# source://sqlite3//lib/sqlite3/constants.rb#75
SQLite3::Constants::ErrorCode::INTERRUPT = T.let(T.unsafe(nil), Integer)

# Some kind of disk I/O error occurred
#
# source://sqlite3//lib/sqlite3/constants.rb#77
SQLite3::Constants::ErrorCode::IOERR = T.let(T.unsafe(nil), Integer)

# A table in the database is locked
#
# source://sqlite3//lib/sqlite3/constants.rb#69
SQLite3::Constants::ErrorCode::LOCKED = T.let(T.unsafe(nil), Integer)

# Data type mismatch
#
# source://sqlite3//lib/sqlite3/constants.rb#97
SQLite3::Constants::ErrorCode::MISMATCH = T.let(T.unsafe(nil), Integer)

# Library used incorrectly
#
# source://sqlite3//lib/sqlite3/constants.rb#99
SQLite3::Constants::ErrorCode::MISUSE = T.let(T.unsafe(nil), Integer)

# Uses OS features not supported on host
#
# source://sqlite3//lib/sqlite3/constants.rb#101
SQLite3::Constants::ErrorCode::NOLFS = T.let(T.unsafe(nil), Integer)

# A malloc() failed
#
# source://sqlite3//lib/sqlite3/constants.rb#71
SQLite3::Constants::ErrorCode::NOMEM = T.let(T.unsafe(nil), Integer)

# File opened that is not a database file
#
# source://sqlite3//lib/sqlite3/constants.rb#109
SQLite3::Constants::ErrorCode::NOTADB = T.let(T.unsafe(nil), Integer)

# (Internal Only) Table or record not found
#
# source://sqlite3//lib/sqlite3/constants.rb#81
SQLite3::Constants::ErrorCode::NOTFOUND = T.let(T.unsafe(nil), Integer)

# Notifications from sqlite3_log()
#
# source://sqlite3//lib/sqlite3/constants.rb#111
SQLite3::Constants::ErrorCode::NOTICE = T.let(T.unsafe(nil), Integer)

# Successful result
#
# source://sqlite3//lib/sqlite3/constants.rb#57
SQLite3::Constants::ErrorCode::OK = T.let(T.unsafe(nil), Integer)

# Access permission denied
#
# source://sqlite3//lib/sqlite3/constants.rb#63
SQLite3::Constants::ErrorCode::PERM = T.let(T.unsafe(nil), Integer)

# Database lock protocol error
#
# source://sqlite3//lib/sqlite3/constants.rb#87
SQLite3::Constants::ErrorCode::PROTOCOL = T.let(T.unsafe(nil), Integer)

# 2nd parameter to sqlite3_bind out of range
#
# source://sqlite3//lib/sqlite3/constants.rb#107
SQLite3::Constants::ErrorCode::RANGE = T.let(T.unsafe(nil), Integer)

# Attempt to write a readonly database
#
# source://sqlite3//lib/sqlite3/constants.rb#73
SQLite3::Constants::ErrorCode::READONLY = T.let(T.unsafe(nil), Integer)

# sqlite_step() has another row ready
#
# source://sqlite3//lib/sqlite3/constants.rb#115
SQLite3::Constants::ErrorCode::ROW = T.let(T.unsafe(nil), Integer)

# The database schema changed
#
# source://sqlite3//lib/sqlite3/constants.rb#91
SQLite3::Constants::ErrorCode::SCHEMA = T.let(T.unsafe(nil), Integer)

# Too much data for one row of a table
#
# source://sqlite3//lib/sqlite3/constants.rb#93
SQLite3::Constants::ErrorCode::TOOBIG = T.let(T.unsafe(nil), Integer)

# Warnings from sqlite3_log()
#
# source://sqlite3//lib/sqlite3/constants.rb#113
SQLite3::Constants::ErrorCode::WARNING = T.let(T.unsafe(nil), Integer)

module SQLite3::Constants::Open; end
SQLite3::Constants::Open::AUTOPROXY = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::CREATE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::DELETEONCLOSE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::EXCLUSIVE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::FULLMUTEX = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::MAIN_DB = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::MAIN_JOURNAL = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::MASTER_JOURNAL = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::MEMORY = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::NOMUTEX = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::PRIVATECACHE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::READONLY = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::READWRITE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::SHAREDCACHE = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::SUBJOURNAL = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::SUPER_JOURNAL = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::TEMP_DB = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::TEMP_JOURNAL = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::TRANSIENT_DB = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::URI = T.let(T.unsafe(nil), Integer)
SQLite3::Constants::Open::WAL = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/constants.rb#174
module SQLite3::Constants::Optimize; end

# Run ANALYZE on tables that might benefit. On by default.
#
# source://sqlite3//lib/sqlite3/constants.rb#180
SQLite3::Constants::Optimize::ANALYZE_TABLES = T.let(T.unsafe(nil), Integer)

# Check the size of all tables, not just tables that have not been recently used, to see if
# any have grown and shrunk significantly and hence might benefit from being re-analyzed. Off
# by default.
#
# source://sqlite3//lib/sqlite3/constants.rb#189
SQLite3::Constants::Optimize::CHECK_ALL_TABLES = T.let(T.unsafe(nil), Integer)

# Debugging mode. Do not actually perform any optimizations but instead return one line of
# text for each optimization that would have been done. Off by default.
#
# source://sqlite3//lib/sqlite3/constants.rb#177
SQLite3::Constants::Optimize::DEBUG = T.let(T.unsafe(nil), Integer)

# Useful for adding a bit to the default behavior, for example
#
#     db.optimize(Optimize::DEFAULT | Optimize::CHECK_ALL_TABLES)
#
# source://sqlite3//lib/sqlite3/constants.rb#195
SQLite3::Constants::Optimize::DEFAULT = T.let(T.unsafe(nil), Integer)

# When running ANALYZE, set a temporary PRAGMA analysis_limit to prevent excess run-time. On
# by default.
#
# source://sqlite3//lib/sqlite3/constants.rb#184
SQLite3::Constants::Optimize::LIMIT_ANALYZE = T.let(T.unsafe(nil), Integer)

# CAPI3REF: Status Parameters
#
# These integer constants designate various run-time status parameters
# that can be returned by SQLite3.status
#
# source://sqlite3//lib/sqlite3/constants.rb#126
module SQLite3::Constants::Status; end

# This parameter records the number of separate memory allocations currently checked out.
#
# source://sqlite3//lib/sqlite3/constants.rb#171
SQLite3::Constants::Status::MALLOC_COUNT = T.let(T.unsafe(nil), Integer)

# This parameter records the largest memory allocation request handed to sqlite3_malloc() or
# sqlite3_realloc() (or their internal equivalents). Only the value returned in the
# *pHighwater parameter to sqlite3_status() is of interest. The value written into the
# *pCurrent parameter is undefined.
#
# source://sqlite3//lib/sqlite3/constants.rb#155
SQLite3::Constants::Status::MALLOC_SIZE = T.let(T.unsafe(nil), Integer)

# This parameter is the current amount of memory checked out using sqlite3_malloc(), either
# directly or indirectly. The figure includes calls made to sqlite3_malloc() by the
# application and internal memory usage by the SQLite library. Auxiliary page-cache memory
# controlled by SQLITE_CONFIG_PAGECACHE is not included in this parameter. The amount returned
# is the sum of the allocation sizes as reported by the xSize method in sqlite3_mem_methods.
#
# source://sqlite3//lib/sqlite3/constants.rb#132
SQLite3::Constants::Status::MEMORY_USED = T.let(T.unsafe(nil), Integer)

# This parameter returns the number of bytes of page cache allocation which could not be
# satisfied by the SQLITE_CONFIG_PAGECACHE buffer and where forced to overflow to
# sqlite3_malloc(). The returned value includes allocations that overflowed because they where
# too large (they were larger than the "sz" parameter to SQLITE_CONFIG_PAGECACHE) and
# allocations that overflowed because no space was left in the page cache.
#
# source://sqlite3//lib/sqlite3/constants.rb#143
SQLite3::Constants::Status::PAGECACHE_OVERFLOW = T.let(T.unsafe(nil), Integer)

# This parameter records the largest memory allocation request handed to the pagecache memory
# allocator. Only the value returned in the *pHighwater parameter to sqlite3_status() is of
# interest. The value written into the *pCurrent parameter is undefined.
#
# source://sqlite3//lib/sqlite3/constants.rb#165
SQLite3::Constants::Status::PAGECACHE_SIZE = T.let(T.unsafe(nil), Integer)

# This parameter returns the number of pages used out of the pagecache memory allocator that
# was configured using SQLITE_CONFIG_PAGECACHE. The value returned is in pages, not in bytes.
#
# source://sqlite3//lib/sqlite3/constants.rb#136
SQLite3::Constants::Status::PAGECACHE_USED = T.let(T.unsafe(nil), Integer)

# The *pHighwater parameter records the deepest parser stack. The *pCurrent value is
# undefined. The *pHighwater value is only meaningful if SQLite is compiled with
# YYTRACKMAXSTACKDEPTH.
#
# source://sqlite3//lib/sqlite3/constants.rb#160
SQLite3::Constants::Status::PARSER_STACK = T.let(T.unsafe(nil), Integer)

# NOT USED
#
# source://sqlite3//lib/sqlite3/constants.rb#149
SQLite3::Constants::Status::SCRATCH_OVERFLOW = T.let(T.unsafe(nil), Integer)

# NOT USED
#
# source://sqlite3//lib/sqlite3/constants.rb#168
SQLite3::Constants::Status::SCRATCH_SIZE = T.let(T.unsafe(nil), Integer)

# NOT USED
#
# source://sqlite3//lib/sqlite3/constants.rb#146
SQLite3::Constants::Status::SCRATCH_USED = T.let(T.unsafe(nil), Integer)

# CAPI3REF: Text Encodings
#
# These constant define integer codes that represent the various
# text encodings supported by SQLite.
#
# source://sqlite3//lib/sqlite3/constants.rb#9
module SQLite3::Constants::TextRep; end

# Deprecated
#
# source://sqlite3//lib/sqlite3/constants.rb#19
SQLite3::Constants::TextRep::ANY = T.let(T.unsafe(nil), Integer)

# sqlite3_create_collation only
#
# source://sqlite3//lib/sqlite3/constants.rb#21
SQLite3::Constants::TextRep::DETERMINISTIC = T.let(T.unsafe(nil), Integer)

# Use native byte order
#
# source://sqlite3//lib/sqlite3/constants.rb#17
SQLite3::Constants::TextRep::UTF16 = T.let(T.unsafe(nil), Integer)

# IMP: R-51971-34154
#
# source://sqlite3//lib/sqlite3/constants.rb#15
SQLite3::Constants::TextRep::UTF16BE = T.let(T.unsafe(nil), Integer)

# IMP: R-03371-37637
#
# source://sqlite3//lib/sqlite3/constants.rb#13
SQLite3::Constants::TextRep::UTF16LE = T.let(T.unsafe(nil), Integer)

# IMP: R-37514-35566
#
# source://sqlite3//lib/sqlite3/constants.rb#11
SQLite3::Constants::TextRep::UTF8 = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/errors.rb#73
class SQLite3::ConstraintException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#57
class SQLite3::CorruptException < ::SQLite3::Exception; end

# The Database class encapsulates a single connection to a SQLite3 database.
# Its usage is very straightforward:
#
#   require 'sqlite3'
#
#   SQLite3::Database.new( "data.db" ) do |db|
#     db.execute( "select * from table" ) do |row|
#       p row
#     end
#   end
#
# It wraps the lower-level methods provided by the selected driver, and
# includes the Pragmas module for access to various pragma convenience
# methods.
#
# The Database class provides type translation services as well, by which
# the SQLite3 data types (which are all represented as strings) may be
# converted into their corresponding types (as defined in the schemas
# for their tables). This translation only occurs when querying data from
# the database--insertions and updates are all still typeless.
#
# Furthermore, the Database class has been designed to work well with the
# ArrayFields module from Ara Howard. If you require the ArrayFields
# module before performing a query, and if you have not enabled results as
# hashes, then the results will all be indexible by field name.
#
# Thread safety:
#
# When `SQLite3.threadsafe?` returns true, it is safe to share instances of
# the database class among threads without adding specific locking. Other
# object instances may require applications to provide their own locks if
# they are to be shared among threads.  Please see the README.md for more
# information.
#
# source://sqlite3//lib/sqlite3/database.rb#44
class SQLite3::Database
  include ::SQLite3::Pragmas

  # call-seq: SQLite3::Database.new(file, options = {})
  #
  # Create a new Database object that opens the given file.
  #
  # Supported permissions +options+:
  # - the default mode is <tt>READWRITE | CREATE</tt>
  # - +:readonly+: boolean (default false), true to set the mode to +READONLY+
  # - +:readwrite+: boolean (default false), true to set the mode to +READWRITE+
  # - +:flags+: set the mode to a combination of SQLite3::Constants::Open flags.
  #
  # Supported encoding +options+:
  # - +:utf16+: boolean (default false), is the filename's encoding UTF-16 (only needed if the filename encoding is not UTF_16LE or BE)
  #
  # Other supported +options+:
  # - +:strict+: boolean (default false), disallow the use of double-quoted string literals (see https://www.sqlite.org/quirks.html#double_quoted_string_literals_are_accepted)
  # - +:results_as_hash+: boolean (default false), return rows as hashes instead of arrays
  # - +:default_transaction_mode+: one of +:deferred+ (default), +:immediate+, or +:exclusive+. If a mode is not specified in a call to #transaction, this will be the default transaction mode.
  #
  # @return [Database] a new instance of Database
  #
  # source://sqlite3//lib/sqlite3/database.rb#97
  def initialize(file, options = T.unsafe(nil), zvfs = T.unsafe(nil)); end

  # Installs (or removes) a block that will be invoked for every access
  # to the database. If the block returns 0 (or +nil+), the statement
  # is allowed to proceed. Returning 1 causes an authorization error to
  # occur, and returning 2 causes the access to be silently denied.
  #
  # source://sqlite3//lib/sqlite3/database.rb#160
  def authorizer(&block); end

  def authorizer=(_arg0); end

  # Given a statement, return a result set.
  # This is not intended for general consumption
  #
  # source://sqlite3//lib/sqlite3/database.rb#697
  def build_result_set(stmt); end

  def busy_handler(*_arg0); end

  # Sets a #busy_handler that releases the GVL between retries,
  # but only retries up to the indicated number of +milliseconds+.
  # This is an alternative to #busy_timeout, which holds the GVL
  # while SQLite sleeps and retries.
  #
  # source://sqlite3//lib/sqlite3/database.rb#646
  def busy_handler_timeout=(milliseconds); end

  def busy_timeout(_arg0); end
  def busy_timeout=(_arg0); end
  def changes; end
  def close; end
  def closed?; end
  def collation(_arg0, _arg1); end

  # Returns the value of attribute collations.
  #
  # source://sqlite3//lib/sqlite3/database.rb#45
  def collations; end

  # Commits the current transaction. If there is no current transaction,
  # this will cause an error to be raised. This returns +true+, in order
  # to allow it to be used in idioms like
  # <tt>abort? and rollback or commit</tt>.
  #
  # source://sqlite3//lib/sqlite3/database.rb#622
  def commit; end

  def complete?(_arg0); end

  # Creates a new aggregate function for use in SQL statements. Aggregate
  # functions are functions that apply over every row in the result set,
  # instead of over just a single row. (A very common aggregate function
  # is the "count" function, for determining the number of rows that match
  # a query.)
  #
  # The new function will be added as +name+, with the given +arity+. (For
  # variable arity functions, use -1 for the arity.)
  #
  # The +step+ parameter must be a proc object that accepts as its first
  # parameter a FunctionProxy instance (representing the function
  # invocation), with any subsequent parameters (up to the function's arity).
  # The +step+ callback will be invoked once for each row of the result set.
  #
  # The +finalize+ parameter must be a +proc+ object that accepts only a
  # single parameter, the FunctionProxy instance representing the current
  # function invocation. It should invoke FunctionProxy#result= to
  # store the result of the function.
  #
  # Example:
  #
  #   db.create_aggregate( "lengths", 1 ) do
  #     step do |func, value|
  #       func[ :total ] ||= 0
  #       func[ :total ] += ( value ? value.length : 0 )
  #     end
  #
  #     finalize do |func|
  #       func.result = func[ :total ] || 0
  #     end
  #   end
  #
  #   puts db.get_first_value( "select lengths(name) from table" )
  #
  # See also #create_aggregate_handler for a more object-oriented approach to
  # aggregate functions.
  #
  # source://sqlite3//lib/sqlite3/database.rb#410
  def create_aggregate(name, arity, step = T.unsafe(nil), finalize = T.unsafe(nil), text_rep = T.unsafe(nil), &block); end

  # This is another approach to creating an aggregate function (see
  # #create_aggregate). Instead of explicitly specifying the name,
  # callbacks, arity, and type, you specify a factory object
  # (the "handler") that knows how to obtain all of that information. The
  # handler should respond to the following messages:
  #
  # +arity+:: corresponds to the +arity+ parameter of #create_aggregate. This
  #           message is optional, and if the handler does not respond to it,
  #           the function will have an arity of -1.
  # +name+:: this is the name of the function. The handler _must_ implement
  #          this message.
  # +new+:: this must be implemented by the handler. It should return a new
  #         instance of the object that will handle a specific invocation of
  #         the function.
  #
  # The handler instance (the object returned by the +new+ message, described
  # above), must respond to the following messages:
  #
  # +step+:: this is the method that will be called for each step of the
  #          aggregate function's evaluation. It should implement the same
  #          signature as the +step+ callback for #create_aggregate.
  # +finalize+:: this is the method that will be called to finalize the
  #              aggregate function's evaluation. It should implement the
  #              same signature as the +finalize+ callback for
  #              #create_aggregate.
  #
  # Example:
  #
  #   class LengthsAggregateHandler
  #     def self.arity; 1; end
  #     def self.name; 'lengths'; end
  #
  #     def initialize
  #       @total = 0
  #     end
  #
  #     def step( ctx, name )
  #       @total += ( name ? name.length : 0 )
  #     end
  #
  #     def finalize( ctx )
  #       ctx.result = @total
  #     end
  #   end
  #
  #   db.create_aggregate_handler( LengthsAggregateHandler )
  #   puts db.get_first_value( "select lengths(name) from A" )
  #
  # source://sqlite3//lib/sqlite3/database.rb#508
  def create_aggregate_handler(handler); end

  # Creates a new function for use in SQL statements. It will be added as
  # +name+, with the given +arity+. (For variable arity functions, use
  # -1 for the arity.)
  #
  # The block should accept at least one parameter--the FunctionProxy
  # instance that wraps this function invocation--and any other
  # arguments it needs (up to its arity).
  #
  # The block does not return a value directly. Instead, it will invoke
  # the FunctionProxy#result= method on the +func+ parameter and
  # indicate the return value that way.
  #
  # Example:
  #
  #   db.create_function( "maim", 1 ) do |func, value|
  #     if value.nil?
  #       func.result = nil
  #     else
  #       func.result = value.split(//).sort.join
  #     end
  #   end
  #
  #   puts db.get_first_value( "select maim(name) from table" )
  #
  # source://sqlite3//lib/sqlite3/database.rb#365
  def create_function(name, arity, text_rep = T.unsafe(nil), &block); end

  # Define an aggregate function named +name+ using a object template
  # object +aggregator+. +aggregator+ must respond to +step+ and +finalize+.
  # +step+ will be called with row information and +finalize+ must return the
  # return value for the aggregator function.
  #
  # _API Change:_ +aggregator+ must also implement +clone+. The provided
  # +aggregator+ object will serve as template that is cloned to provide the
  # individual instances of the aggregate function. Regular ruby objects
  # already provide a suitable +clone+.
  # The functions arity is the arity of the +step+ method.
  #
  # source://sqlite3//lib/sqlite3/database.rb#545
  def define_aggregator(name, aggregator); end

  def define_function(_arg0); end
  def define_function_with_flags(_arg0, _arg1); end
  def enable_load_extension(_arg0); end

  # call-seq: db.encoding
  #
  # Fetch the encoding set on this database
  #
  # source://sqlite3//lib/sqlite3/database.rb#152
  def encoding; end

  def errcode; end
  def errmsg; end

  # Executes the given SQL statement. If additional parameters are given,
  # they are treated as bind variables, and are bound to the placeholders in
  # the query.
  #
  # Note that if any of the values passed to this are hashes, then the
  # key/value pairs are each bound separately, with the key being used as
  # the name of the placeholder to bind the value to.
  #
  # The block is optional. If given, it will be invoked for each row returned
  # by the query. Otherwise, any results are accumulated into an array and
  # returned wholesale.
  #
  # See also #execute2, #query, and #execute_batch for additional ways of
  # executing statements.
  #
  # source://sqlite3//lib/sqlite3/database.rb#201
  def execute(sql, bind_vars = T.unsafe(nil), &block); end

  # Executes the given SQL statement, exactly as with #execute. However, the
  # first row returned (either via the block, or in the returned array) is
  # always the names of the columns. Subsequent rows correspond to the data
  # from the result set.
  #
  # Thus, even if the query itself returns no rows, this method will always
  # return at least one row--the names of the columns.
  #
  # See also #execute, #query, and #execute_batch for additional ways of
  # executing statements.
  #
  # source://sqlite3//lib/sqlite3/database.rb#226
  def execute2(sql, *bind_vars); end

  # Executes all SQL statements in the given string. By contrast, the other
  # means of executing queries will only execute the first statement in the
  # string, ignoring all subsequent statements. This will execute each one
  # in turn. The same bind parameters, if given, will be applied to each
  # statement.
  #
  # This always returns the result of the last statement.
  #
  # See also #execute_batch2 for additional ways of
  # executing statements.
  #
  # source://sqlite3//lib/sqlite3/database.rb#250
  def execute_batch(sql, bind_vars = T.unsafe(nil)); end

  # Executes all SQL statements in the given string. By contrast, the other
  # means of executing queries will only execute the first statement in the
  # string, ignoring all subsequent statements. This will execute each one
  # in turn. Bind parameters cannot be passed to #execute_batch2.
  #
  # If a query is made, all values will be returned as strings.
  # If no query is made, an empty array will be returned.
  #
  # Because all values except for 'NULL' are returned as strings,
  # a block can be passed to parse the values accordingly.
  #
  # See also #execute_batch for additional ways of
  # executing statements.
  #
  # source://sqlite3//lib/sqlite3/database.rb#283
  def execute_batch2(sql, &block); end

  def extended_result_codes=(_arg0); end

  # Returns the filename for the database named +db_name+.  +db_name+ defaults
  # to "main".  Main return `nil` or an empty string if the database is
  # temporary or in-memory.
  #
  # source://sqlite3//lib/sqlite3/database.rb#183
  def filename(db_name = T.unsafe(nil)); end

  # A convenience method for obtaining the first row of a result set, and
  # discarding all others. It is otherwise identical to #execute.
  #
  # See also #get_first_value.
  #
  # source://sqlite3//lib/sqlite3/database.rb#322
  def get_first_row(sql, *bind_vars); end

  # A convenience method for obtaining the first value of the first row of a
  # result set, and discarding all other values and rows. It is otherwise
  # identical to #execute.
  #
  # See also #get_first_row.
  #
  # source://sqlite3//lib/sqlite3/database.rb#331
  def get_first_value(sql, *bind_vars); end

  def interrupt; end
  def last_insert_row_id; end
  def load_extension(_arg0); end

  # Returns a Statement object representing the given SQL. This does not
  # execute the statement; it merely prepares the statement for execution.
  #
  # The Statement can then be executed using Statement#execute.
  #
  # source://sqlite3//lib/sqlite3/database.rb#169
  def prepare(sql); end

  # This is a convenience method for creating a statement, binding
  # parameters to it, and calling execute:
  #
  #   result = db.query( "select * from foo where a=?", [5])
  #   # is the same as
  #   result = db.prepare( "select * from foo where a=?" ).execute( 5 )
  #
  # You must be sure to call +close+ on the ResultSet instance that is
  # returned, or you could have problems with locks on the table. If called
  # with a block, +close+ will be invoked implicitly when the block
  # terminates.
  #
  # source://sqlite3//lib/sqlite3/database.rb#305
  def query(sql, bind_vars = T.unsafe(nil)); end

  # Returns +true+ if the database has been open in readonly mode
  # A helper to check before performing any operation
  #
  # @return [Boolean]
  #
  # source://sqlite3//lib/sqlite3/database.rb#638
  def readonly?; end

  # A boolean that indicates whether rows in result sets should be returned
  # as hashes or not. By default, rows are returned as arrays.
  #
  # source://sqlite3//lib/sqlite3/database.rb#77
  def results_as_hash; end

  # A boolean that indicates whether rows in result sets should be returned
  # as hashes or not. By default, rows are returned as arrays.
  #
  # source://sqlite3//lib/sqlite3/database.rb#77
  def results_as_hash=(_arg0); end

  # Rolls the current transaction back. If there is no current transaction,
  # this will cause an error to be raised. This returns +true+, in order
  # to allow it to be used in idioms like
  # <tt>abort? and rollback or commit</tt>.
  #
  # source://sqlite3//lib/sqlite3/database.rb#631
  def rollback; end

  def statement_timeout=(_arg0); end
  def total_changes; end
  def trace(*_arg0); end

  # Begins a new transaction. Note that nested transactions are not allowed
  # by SQLite, so attempting to nest a transaction will result in a runtime
  # exception.
  #
  # The +mode+ parameter may be either <tt>:deferred</tt>,
  # <tt>:immediate</tt>, or <tt>:exclusive</tt>.
  # If `nil` is specified, the default transaction mode, which was
  # passed to #initialize, is used.
  #
  # If a block is given, the database instance is yielded to it, and the
  # transaction is committed when the block terminates. If the block
  # raises an exception, a rollback will be performed instead. Note that if
  # a block is given, #commit and #rollback should never be called
  # explicitly or you'll get an error when the block terminates.
  #
  # If a block is not given, it is the caller's responsibility to end the
  # transaction explicitly, either by calling #commit, or by calling
  # #rollback.
  #
  # source://sqlite3//lib/sqlite3/database.rb#599
  def transaction(mode = T.unsafe(nil)); end

  def transaction_active?; end

  private

  def db_filename(_arg0); end
  def define_aggregator2(_arg0, _arg1); end
  def disable_quirk_mode; end
  def discard; end
  def exec_batch(_arg0, _arg1); end
  def open16(_arg0); end
  def open_v2(_arg0, _arg1, _arg2); end

  class << self
    # Without block works exactly as new.
    # With block, like new closes the database at the end, but unlike new
    # returns the result of the block instead of the database instance.
    #
    # source://sqlite3//lib/sqlite3/database.rb#53
    def open(*args); end

    # Quotes the given string, making it safe to use in an SQL statement.
    # It replaces all instances of the single-quote character with two
    # single-quote characters. The modified string is returned.
    #
    # source://sqlite3//lib/sqlite3/database.rb#70
    def quote(string); end
  end
end

# A helper class for dealing with custom functions (see #create_function,
# #create_aggregate, and #create_aggregate_handler). It encapsulates the
# opaque function object that represents the current invocation. It also
# provides more convenient access to the API functions that operate on
# the function object.
#
# This class will almost _always_ be instantiated indirectly, by working
# with the create methods mentioned above.
#
# source://sqlite3//lib/sqlite3/database.rb#669
class SQLite3::Database::FunctionProxy
  # Create a new FunctionProxy that encapsulates the given +func+ object.
  # If context is non-nil, the functions context will be set to that. If
  # it is non-nil, it must quack like a Hash. If it is nil, then none of
  # the context functions will be available.
  #
  # @return [FunctionProxy] a new instance of FunctionProxy
  #
  # source://sqlite3//lib/sqlite3/database.rb#676
  def initialize; end

  # Returns the value with the given key from the context. This is only
  # available to aggregate functions.
  #
  # source://sqlite3//lib/sqlite3/database.rb#683
  def [](key); end

  # Sets the value with the given key in the context. This is only
  # available to aggregate functions.
  #
  # source://sqlite3//lib/sqlite3/database.rb#689
  def []=(key, value); end

  # Returns the value of attribute result.
  #
  # source://sqlite3//lib/sqlite3/database.rb#670
  def result; end

  # Sets the attribute result
  #
  # @param value the value to set the attribute result to.
  #
  # source://sqlite3//lib/sqlite3/database.rb#670
  def result=(_arg0); end
end

# source://sqlite3//lib/sqlite3/errors.rb#67
class SQLite3::EmptyException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#4
class SQLite3::Exception < ::StandardError
  # A convenience for accessing the error code for this exception.
  #
  # source://sqlite3//lib/sqlite3/errors.rb#6
  def code; end

  # source://sqlite3//lib/sqlite3/errors.rb#15
  def message; end

  # If the error is associated with a SQL query, this is the query
  #
  # source://sqlite3//lib/sqlite3/errors.rb#9
  def sql; end

  # If the error is associated with a particular offset in a SQL query, this is the non-negative
  # offset. If the offset is not available, this will be -1.
  #
  # source://sqlite3//lib/sqlite3/errors.rb#13
  def sql_offset; end

  private

  # source://sqlite3//lib/sqlite3/errors.rb#19
  def sql_error; end
end

# based on Rails's active_support/fork_tracker.rb
#
# source://sqlite3//lib/sqlite3/fork_safety.rb#7
module SQLite3::ForkSafety
  class << self
    # source://sqlite3//lib/sqlite3/fork_safety.rb#33
    def discard; end

    # source://sqlite3//lib/sqlite3/fork_safety.rb#23
    def hook!; end

    # Call to suppress the fork-related warnings.
    #
    # source://sqlite3//lib/sqlite3/fork_safety.rb#55
    def suppress_warnings!; end

    # source://sqlite3//lib/sqlite3/fork_safety.rb#27
    def track(database); end
  end
end

# source://sqlite3//lib/sqlite3/fork_safety.rb#8
module SQLite3::ForkSafety::CoreExt
  # source://sqlite3//lib/sqlite3/fork_safety.rb#9
  def _fork; end
end

# source://sqlite3//lib/sqlite3/errors.rb#83
class SQLite3::FormatException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#61
class SQLite3::FullException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/resultset.rb#93
class SQLite3::HashResultSet < ::SQLite3::ResultSet
  # source://sqlite3//lib/sqlite3/resultset.rb#85
  def next; end
end

# source://sqlite3//lib/sqlite3/errors.rb#55
class SQLite3::IOException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#39
class SQLite3::InternalException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#53
class SQLite3::InterruptException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#47
class SQLite3::LockedException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#49
class SQLite3::MemoryException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#75
class SQLite3::MismatchException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#77
class SQLite3::MisuseException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#87
class SQLite3::NotADatabaseException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#59
class SQLite3::NotFoundException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#41
class SQLite3::PermissionException < ::SQLite3::Exception; end

# This module is intended for inclusion solely by the Database class. It
# defines convenience methods for the various pragmas supported by SQLite3.
#
# For a detailed description of these pragmas, see the SQLite3 documentation
# at http://sqlite.org/pragma.html.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#9
module SQLite3::Pragmas
  # source://sqlite3//lib/sqlite3/pragmas.rb#101
  def application_id; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#105
  def application_id=(integer); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#109
  def auto_vacuum; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#113
  def auto_vacuum=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#117
  def automatic_index; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#121
  def automatic_index=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#125
  def busy_timeout; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#129
  def busy_timeout=(milliseconds); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#133
  def cache_size; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#137
  def cache_size=(size); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#141
  def cache_spill; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#145
  def cache_spill=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#149
  def case_sensitive_like=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#153
  def cell_size_check; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#157
  def cell_size_check=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#161
  def checkpoint_fullfsync; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#165
  def checkpoint_fullfsync=(mode); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#169
  def collation_list(&block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#173
  def compile_options(&block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#177
  def count_changes; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#181
  def count_changes=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#185
  def data_version; end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#189
  def database_list(&block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#193
  def default_cache_size; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#197
  def default_cache_size=(size); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#201
  def default_synchronous; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#205
  def default_synchronous=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#209
  def default_temp_store; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#213
  def default_temp_store=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#217
  def defer_foreign_keys; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#221
  def defer_foreign_keys=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#225
  def encoding; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#229
  def encoding=(mode); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#233
  def foreign_key_check(*table, &block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#237
  def foreign_key_list(table, &block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#241
  def foreign_keys; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#245
  def foreign_keys=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#249
  def freelist_count; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#253
  def full_column_names; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#257
  def full_column_names=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#261
  def fullfsync; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#265
  def fullfsync=(mode); end

  # Returns +true+ or +false+ depending on the value of the named pragma.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#11
  def get_boolean_pragma(name); end

  # Return the value of the given pragma.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#51
  def get_enum_pragma(name); end

  # Returns the value of the given pragma as an integer.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#69
  def get_int_pragma(name); end

  # Requests the given pragma (and parameters), and if the block is given,
  # each row of the result set will be yielded to it. Otherwise, the results
  # are returned as an array.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#41
  def get_query_pragma(name, *params, &block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#269
  def ignore_check_constraints=(mode); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#273
  def incremental_vacuum(pages, &block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#277
  def index_info(index, &block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#281
  def index_list(table, &block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#285
  def index_xinfo(index, &block); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#289
  def integrity_check(*num_errors, &block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#293
  def journal_mode; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#297
  def journal_mode=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#301
  def journal_size_limit; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#305
  def journal_size_limit=(size); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#309
  def legacy_file_format; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#313
  def legacy_file_format=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#317
  def locking_mode; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#321
  def locking_mode=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#325
  def max_page_count; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#329
  def max_page_count=(size); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#333
  def mmap_size; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#337
  def mmap_size=(size); end

  # Attempt to optimize the database.
  #
  # To customize the optimization options, pass +bitmask+ with a combination
  # of the Constants::Optimize masks.
  #
  # See https://www.sqlite.org/pragma.html#pragma_optimize for more information.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#347
  def optimize(bitmask = T.unsafe(nil)); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#355
  def page_count; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#359
  def page_size; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#363
  def page_size=(size); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#367
  def parser_trace=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#371
  def query_only; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#375
  def query_only=(mode); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#379
  def quick_check(*num_errors, &block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#383
  def read_uncommitted; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#387
  def read_uncommitted=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#391
  def recursive_triggers; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#395
  def recursive_triggers=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#399
  def reverse_unordered_selects; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#403
  def reverse_unordered_selects=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#407
  def schema_cookie; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#411
  def schema_cookie=(cookie); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#415
  def schema_version; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#419
  def schema_version=(version); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#423
  def secure_delete; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#427
  def secure_delete=(mode); end

  # Sets the given pragma to the given boolean value. The value itself
  # may be +true+ or +false+, or any other commonly used string or
  # integer that represents truth.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#18
  def set_boolean_pragma(name, mode); end

  # Set the value of the given pragma to +mode+. The +mode+ parameter must
  # conform to one of the values in the given +enum+ array. Each entry in
  # the array is another array comprised of elements in the enumeration that
  # have duplicate values. See #synchronous, #default_synchronous,
  # #temp_store, and #default_temp_store for usage examples.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#60
  def set_enum_pragma(name, mode, enums); end

  # Set the value of the given pragma to the integer value of the +value+
  # parameter.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#75
  def set_int_pragma(name, value); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#431
  def short_column_names; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#435
  def short_column_names=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#439
  def shrink_memory; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#443
  def soft_heap_limit; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#447
  def soft_heap_limit=(mode); end

  # :yields: row
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#451
  def stats(&block); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#455
  def synchronous; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#459
  def synchronous=(mode); end

  # Returns information about +table+.  Yields each row of table information
  # if a block is provided.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#538
  def table_info(table); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#463
  def temp_store; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#467
  def temp_store=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#471
  def threads; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#475
  def threads=(count); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#479
  def user_cookie; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#483
  def user_cookie=(cookie); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#487
  def user_version; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#491
  def user_version=(version); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#495
  def vdbe_addoptrace=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#499
  def vdbe_debug=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#503
  def vdbe_listing=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#507
  def vdbe_trace; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#511
  def vdbe_trace=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#515
  def wal_autocheckpoint; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#519
  def wal_autocheckpoint=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#523
  def wal_checkpoint; end

  # source://sqlite3//lib/sqlite3/pragmas.rb#527
  def wal_checkpoint=(mode); end

  # source://sqlite3//lib/sqlite3/pragmas.rb#531
  def writable_schema=(mode); end

  private

  # Since SQLite 3.3.8, the table_info pragma has returned the default
  # value of the row as a quoted SQL value. This method essentially
  # unquotes those values.
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#588
  def tweak_default(hash); end

  # Compares two version strings
  #
  # source://sqlite3//lib/sqlite3/pragmas.rb#572
  def version_compare(v1, v2); end
end

# The enumeration of valid auto vacuum modes.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#86
SQLite3::Pragmas::AUTO_VACUUM_MODES = T.let(T.unsafe(nil), Array)

# The list of valid encodings.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#96
SQLite3::Pragmas::ENCODINGS = T.let(T.unsafe(nil), Array)

# The list of valid journaling modes.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#89
SQLite3::Pragmas::JOURNAL_MODES = T.let(T.unsafe(nil), Array)

# The list of valid locking modes.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#93
SQLite3::Pragmas::LOCKING_MODES = T.let(T.unsafe(nil), Array)

# The enumeration of valid synchronous modes.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#80
SQLite3::Pragmas::SYNCHRONOUS_MODES = T.let(T.unsafe(nil), Array)

# The enumeration of valid temp store modes.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#83
SQLite3::Pragmas::TEMP_STORE_MODES = T.let(T.unsafe(nil), Array)

# The list of valid WAL checkpoints.
#
# source://sqlite3//lib/sqlite3/pragmas.rb#99
SQLite3::Pragmas::WAL_CHECKPOINTS = T.let(T.unsafe(nil), Array)

# source://sqlite3//lib/sqlite3/errors.rb#65
class SQLite3::ProtocolException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#85
class SQLite3::RangeException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#51
class SQLite3::ReadOnlyException < ::SQLite3::Exception; end

# The ResultSet object encapsulates the enumerability of a query's output.
# It is a simple cursor over the data that the query returns. It will
# very rarely (if ever) be instantiated directly. Instead, clients should
# obtain a ResultSet instance via Statement#execute.
#
# source://sqlite3//lib/sqlite3/resultset.rb#9
class SQLite3::ResultSet
  include ::Enumerable

  # Create a new ResultSet attached to the given database, using the
  # given sql text.
  #
  # @return [ResultSet] a new instance of ResultSet
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#14
  def initialize(db, stmt); end

  # Closes the statement that spawned this result set.
  # <em>Use with caution!</em> Closing a result set will automatically
  # close any other result sets that were spawned from the same statement.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#65
  def close; end

  # Queries whether the underlying statement has been closed or not.
  #
  # @return [Boolean]
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#70
  def closed?; end

  # Returns the names of the columns returned by this result set.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#80
  def columns; end

  # Required by the Enumerable mixin. Provides an internal iterator over the
  # rows of the result set.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#48
  def each; end

  # Provides an internal iterator over the rows of the result set where
  # each row is yielded as a hash.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#56
  def each_hash; end

  # Query whether the cursor has reached the end of the result set or not.
  #
  # @return [Boolean]
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#27
  def eof?; end

  # Obtain the next row from the cursor. If there are no more rows to be
  # had, this will return +nil+.
  #
  # The returned value will be an array, unless Database#results_as_hash has
  # been set to +true+, in which case the returned value will be a hash.
  #
  # For arrays, the column names are accessible via the +fields+ property,
  # and the column types are accessible via the +types+ property.
  #
  # For hashes, the column names are the keys of the hash, and the column
  # types are accessible via the +types+ property.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#42
  def next; end

  # Return the next row as a hash
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#85
  def next_hash; end

  # Reset the cursor, so that a result set which has reached end-of-file
  # can be rewound and reiterated.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#21
  def reset(*bind_params); end

  # Returns the types of the columns returned by this result set.
  #
  # source://sqlite3//lib/sqlite3/resultset.rb#75
  def types; end
end

# source://sqlite3//lib/sqlite3/errors.rb#37
class SQLite3::SQLException < ::SQLite3::Exception; end

SQLite3::SQLITE_LOADED_VERSION = T.let(T.unsafe(nil), String)
SQLite3::SQLITE_PACKAGED_LIBRARIES = T.let(T.unsafe(nil), TrueClass)
SQLite3::SQLITE_PRECOMPILED_LIBRARIES = T.let(T.unsafe(nil), TrueClass)
SQLite3::SQLITE_VERSION = T.let(T.unsafe(nil), String)
SQLite3::SQLITE_VERSION_NUMBER = T.let(T.unsafe(nil), Integer)

# source://sqlite3//lib/sqlite3/errors.rb#69
class SQLite3::SchemaChangedException < ::SQLite3::Exception; end

# A statement represents a prepared-but-unexecuted SQL query. It will rarely
# (if ever) be instantiated directly by a client, and is most often obtained
# via the Database#prepare method.
#
# source://sqlite3//lib/sqlite3/statement.rb#14
class SQLite3::Statement
  include ::Enumerable

  # call-seq: SQLite3::Statement.new(db, sql)
  #
  # Create a new statement attached to the given Database instance, and which
  # encapsulates the given SQL text. If the text contains more than one
  # statement (i.e., separated by semicolons), then the #remainder property
  # will be set to the trailing text.
  #
  # @raise [ArgumentError]
  # @return [Statement] a new instance of Statement
  #
  # source://sqlite3//lib/sqlite3/statement.rb#28
  def initialize(db, sql); end

  # Returns true if the statement is currently active, meaning it has an
  # open result set.
  #
  # @return [Boolean]
  #
  # source://sqlite3//lib/sqlite3/statement.rb#111
  def active?; end

  def bind_param(_arg0, _arg1); end
  def bind_parameter_count; end

  # Binds the given variables to the corresponding placeholders in the SQL
  # text.
  #
  # See Database#execute for a description of the valid placeholder
  # syntaxes.
  #
  # Example:
  #
  #   stmt = db.prepare( "select * from table where a=? and b=?" )
  #   stmt.bind_params( 15, "hello" )
  #
  # See also #execute, #bind_param, Statement#bind_param, and
  # Statement#bind_params.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#52
  def bind_params(*bind_vars); end

  def clear_bindings!; end
  def close; end
  def closed?; end
  def column_count; end
  def column_decltype(_arg0); end
  def column_name(_arg0); end

  # Return an array of the column names for this statement. Note that this
  # may execute the statement in order to obtain the metadata; this makes it
  # a (potentially) expensive operation.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#118
  def columns; end

  def done?; end

  # source://sqlite3//lib/sqlite3/statement.rb#123
  def each; end

  # Execute the statement. This creates a new ResultSet object for the
  # statement's virtual machine. If a block was given, the new ResultSet will
  # be yielded to it; otherwise, the ResultSet will be returned.
  #
  # Any parameters will be bound to the statement using #bind_params.
  #
  # Example:
  #
  #   stmt = db.prepare( "select * from table" )
  #   stmt.execute do |result|
  #     ...
  #   end
  #
  # See also #bind_params, #execute!.
  #
  # @yield [results]
  #
  # source://sqlite3//lib/sqlite3/statement.rb#78
  def execute(*bind_vars); end

  # Execute the statement. If no block was given, this returns an array of
  # rows returned by executing the statement. Otherwise, each row will be
  # yielded to the block.
  #
  # Any parameters will be bound to the statement using #bind_params.
  #
  # Example:
  #
  #   stmt = db.prepare( "select * from table" )
  #   stmt.execute! do |row|
  #     ...
  #   end
  #
  # See also #bind_params, #execute.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#104
  def execute!(*bind_vars, &block); end

  def expanded_sql; end
  def memused; end

  # Performs a sanity check to ensure that the statement is not
  # closed. If it is, an exception is raised.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#142
  def must_be_open!; end

  # This is any text that followed the first valid SQL statement in the text
  # with which the statement was initialized. If there was no trailing text,
  # this will be the empty string.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#20
  def remainder; end

  def reset!; end
  def sql; end

  # Returns a Hash containing information about the statement.
  # The contents of the hash are implementation specific and may change in
  # the future without notice. The hash includes information about internal
  # statistics about the statement such as:
  #   - +fullscan_steps+: the number of times that SQLite has stepped forward
  # in a table as part of a full table scan
  #   - +sorts+: the number of sort operations that have occurred
  #   - +autoindexes+: the number of rows inserted into transient indices
  # that were created automatically in order to help joins run faster
  #   - +vm_steps+: the number of virtual machine operations executed by the
  # prepared statement
  #   - +reprepares+: the number of times that the prepare statement has been
  # automatically regenerated due to schema changes or changes to bound
  # parameters that might affect the query plan
  #   - +runs+: the number of times that the prepared statement has been run
  #   - +filter_misses+: the number of times that the Bloom filter returned
  # a find, and thus the join step had to be processed as normal
  #   - +filter_hits+: the number of times that a join step was bypassed
  # because a Bloom filter returned not-found
  #
  # source://sqlite3//lib/sqlite3/statement.rb#167
  def stat(key = T.unsafe(nil)); end

  def step; end

  # Return an array of the data types for each column in this statement. Note
  # that this may execute the statement in order to obtain the metadata; this
  # makes it a (potentially) expensive operation.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#134
  def types; end

  private

  # A convenience method for obtaining the metadata about the query. Note
  # that this will actually execute the SQL, which means it can be a
  # (potentially) expensive operation.
  #
  # source://sqlite3//lib/sqlite3/statement.rb#180
  def get_metadata; end

  def prepare(_arg0, _arg1); end
  def stat_for(_arg0); end
  def stats_as_hash; end
end

# source://sqlite3//lib/sqlite3/errors.rb#71
class SQLite3::TooBigException < ::SQLite3::Exception; end

# source://sqlite3//lib/sqlite3/errors.rb#79
class SQLite3::UnsupportedException < ::SQLite3::Exception; end

# (String) the version of the sqlite3 gem, e.g. "2.1.1"
#
# source://sqlite3//lib/sqlite3/version.rb#3
SQLite3::VERSION = T.let(T.unsafe(nil), String)

# a hash of descriptive metadata about the current version of the sqlite3 gem
#
# source://sqlite3//lib/sqlite3/version_info.rb#3
SQLite3::VERSION_INFO = T.let(T.unsafe(nil), Hash)

# source://sqlite3//lib/sqlite3/value.rb#4
class SQLite3::Value
  # @return [Value] a new instance of Value
  #
  # source://sqlite3//lib/sqlite3/value.rb#7
  def initialize(db, handle); end

  # Returns the value of attribute handle.
  #
  # source://sqlite3//lib/sqlite3/value.rb#5
  def handle; end

  # source://sqlite3//lib/sqlite3/value.rb#20
  def length(utf16 = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://sqlite3//lib/sqlite3/value.rb#12
  def null?; end

  # source://sqlite3//lib/sqlite3/value.rb#16
  def to_blob; end

  # source://sqlite3//lib/sqlite3/value.rb#28
  def to_f; end

  # source://sqlite3//lib/sqlite3/value.rb#32
  def to_i; end

  # source://sqlite3//lib/sqlite3/value.rb#36
  def to_int64; end

  # source://sqlite3//lib/sqlite3/value.rb#40
  def to_s(utf16 = T.unsafe(nil)); end

  # source://sqlite3//lib/sqlite3/value.rb#44
  def type; end
end

# source://sqlite3//lib/sqlite3/statement.rb#4
class String
  include ::Comparable

  # source://sqlite3//lib/sqlite3/statement.rb#5
  def to_blob; end
end
