# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `yard` gem.
# Please instead update this file by running `bin/tapioca gem yard`.


# source://yard//lib/yard.rb#61
::RUBY18 = T.let(T.unsafe(nil), FalseClass)

# source://yard//lib/yard.rb#62
::RUBY19 = T.let(T.unsafe(nil), TrueClass)

# source://yard//lib/yard/core_ext/array.rb#2
class Array
  include ::Enumerable

  # Places values before or after another object (by value) in
  # an array. This is used in tandem with the before and after
  # methods of the {Insertion} class.
  #
  # @example Places an item before another
  #   [1, 2, 3].place(4).before(3) # => [1, 2, 4, 3]
  # @example Places an item after another
  #   [:a, :b, :c].place(:x).after(:a) # => [:a, :x, :b, :c]
  # @param values [Array] value to insert
  # @return [Insertion] an insertion object to
  # @see Insertion#before
  # @see Insertion#after
  #
  # source://yard//lib/yard/core_ext/array.rb#15
  def place(*values); end
end

# source://yard//lib/yard/core_ext/file.rb#4
class File < ::IO
  class << self
    # Cleans a path by removing extraneous '..', '.' and '/' characters
    #
    # @example Clean a path
    #   File.cleanpath('a/b//./c/../e') # => "a/b/e"
    # @param path [String] the path to clean
    # @param rel_root [Boolean] allows relative path above root value
    # @return [String] the sanitized path
    #
    # source://yard//lib/yard/core_ext/file.rb#37
    def cleanpath(path, rel_root = T.unsafe(nil)); end

    # Forces opening a file (for writing) by first creating the file's directory
    #
    # @param file [String] the filename to open
    # @since 0.5.2
    #
    # source://yard//lib/yard/core_ext/file.rb#57
    def open!(file, *args, &block); end

    # Reads a file with binary encoding
    #
    # @return [String] the ascii-8bit encoded data
    # @since 0.5.3
    #
    # source://yard//lib/yard/core_ext/file.rb#66
    def read_binary(file); end

    # Turns a path +to+ into a relative path from starting
    # point +from+. The argument +from+ is assumed to be
    # a filename. To treat it as a directory, make sure it
    # ends in +File::SEPARATOR+ ('/' on UNIX filesystems).
    #
    # @param from [String] the starting filename
    #   (or directory with +from_isdir+ set to +true+).
    # @param to [String] the final path that should be made relative.
    # @return [String] the relative path from +from+ to +to+.
    #
    # source://yard//lib/yard/core_ext/file.rb#19
    def relative_path(from, to); end
  end
end

# source://yard//lib/yard/core_ext/file.rb#5
File::RELATIVE_PARENTDIR = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/core_ext/file.rb#6
File::RELATIVE_SAMEDIR = T.let(T.unsafe(nil), String)

# :stopdoc:
#
# source://yard//lib/yard/rubygems/backports/gem.rb#2
module Gem
  class << self
    # Returns the Gem::SourceIndex of specifications that are in the Gem.path
    #
    # source://yard//lib/yard/rubygems/backports/gem.rb#6
    def source_index; end
  end
end

# Cache is an alias for SourceIndex to allow older YAMLized source index
# objects to load properly.
#
# source://yard//lib/yard/rubygems/backports/source_index.rb#363
Gem::Cache = Gem::SourceIndex

# The SourceIndex object indexes all the gems available from a
# particular source (e.g. a list of gem directories, or a remote
# source).  A SourceIndex maps a gem full name to a gem
# specification.
#
# NOTE:: The class used to be named Cache, but that became
#        confusing when cached source fetchers where introduced. The
#        constant Gem::Cache is an alias for this class to allow old
#        YAMLized source index objects to load properly.
#
# source://yard//lib/yard/rubygems/backports/source_index.rb#21
class Gem::SourceIndex
  include ::Enumerable

  # Constructs a source index instance from the provided specifications, which
  # is a Hash of gem full names and Gem::Specifications.
  # --
  # TODO merge @gems and @prerelease_gems and provide a separate method
  # #prerelease_gems
  #
  # @return [SourceIndex] a new instance of SourceIndex
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#102
  def initialize(specifications = T.unsafe(nil)); end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#348
  def ==(other); end

  # Add a gem specification to the source index.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#193
  def add_spec(gem_spec, name = T.unsafe(nil)); end

  # Add gem specifications to the source index.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#202
  def add_specs(*gem_specs); end

  # TODO: remove method
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#109
  def all_gems; end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#352
  def dump; end

  # Iterate over the specifications in the source index.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#218
  def each(&block); end

  # Find a gem by an exact match on the short name.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#256
  def find_name(gem_name, requirement = T.unsafe(nil)); end

  # The signature for the given gem specification.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#242
  def gem_signature(gem_full_name); end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#34
  def gems; end

  # The signature for the source index.  Changes in the signature indicate a
  # change in the index.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#233
  def index_signature; end

  # Returns an Array specifications for the latest released versions
  # of each gem in this index.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#143
  def latest_specs(include_prerelease = T.unsafe(nil)); end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#248
  def length; end

  # Reconstruct the source index from the specifications in +spec_dirs+.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#124
  def load_gems_in(*spec_dirs); end

  # Returns an Array of Gem::Specifications that are not up to date.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#330
  def outdated; end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#113
  def prerelease_gems; end

  # An array including only the prerelease gemspecs
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#179
  def prerelease_specs; end

  # Replaces the gems in the source index from specifications in the
  # directories this source index was created from.  Raises an exception if
  # this source index wasn't created from a directory (via from_gems_in or
  # from_installed_gems, or having spec_dirs set).
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#322
  def refresh!; end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#117
  def released_gems; end

  # An array including only the released gemspecs
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#186
  def released_specs; end

  # Remove a gem specification named +full_name+.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#211
  def remove_spec(full_name); end

  # Search for a gem by Gem::Dependency +gem_pattern+.  If +only_platform+
  # is true, only gems matching Gem::Platform.local will be returned.  An
  # Array of matching Gem::Specification objects is returned.
  #
  # For backwards compatibility, a String or Regexp pattern may be passed as
  # +gem_pattern+, and a Gem::Requirement for +platform_only+.  This
  # behavior is deprecated and will be removed.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#270
  def search(gem_pattern, platform_only = T.unsafe(nil)); end

  # source://yard//lib/yard/rubygems/backports/source_index.rb#248
  def size; end

  # Directories to use to refresh this SourceIndex when calling refresh!
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#39
  def spec_dirs; end

  # Directories to use to refresh this SourceIndex when calling refresh!
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#39
  def spec_dirs=(_arg0); end

  # The gem specification given a full gem spec name.
  #
  # source://yard//lib/yard/rubygems/backports/source_index.rb#225
  def specification(full_name); end

  class << self
    # Creates a new SourceIndex from the ruby format gem specifications in
    # +spec_dirs+.
    #
    # source://yard//lib/yard/rubygems/backports/source_index.rb#80
    def from_gems_in(*spec_dirs); end

    # Factory method to construct a source index instance for a given
    # path.
    #
    # deprecated::
    #   If supplied, from_installed_gems will act just like
    #   +from_gems_in+.  This argument is deprecated and is provided
    #   just for backwards compatibility, and should not generally
    #   be used.
    #
    # return::
    #   SourceIndex instance
    #
    # source://yard//lib/yard/rubygems/backports/source_index.rb#61
    def from_installed_gems(*deprecated); end

    # Returns a list of directories from Gem.path that contain specifications.
    #
    # source://yard//lib/yard/rubygems/backports/source_index.rb#72
    def installed_spec_directories; end

    # Loads a ruby-format specification from +file_name+ and returns the
    # loaded spec.
    #
    # source://yard//lib/yard/rubygems/backports/source_index.rb#90
    def load_specification(file_name); end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#17
class IRB::SLex
  # @return [SLex] a new instance of SLex
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#25
  def initialize; end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#60
  def create(token, preproc = T.unsafe(nil), postproc = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#29
  def def_rule(token, preproc = T.unsafe(nil), postproc = T.unsafe(nil), &block); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#36
  def def_rules(*tokens, &block); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#77
  def inspect; end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#64
  def match(token); end

  # need a check?
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#51
  def postproc(token); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#45
  def preproc(token, proc); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#56
  def search(token); end
end

# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#18
IRB::SLex::DOUT = T.let(T.unsafe(nil), IRB::Notifier::CompositeNotifier)

# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#20
IRB::SLex::D_DEBUG = T.let(T.unsafe(nil), IRB::Notifier::LeveledNotifier)

# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#21
IRB::SLex::D_DETAIL = T.let(T.unsafe(nil), IRB::Notifier::LeveledNotifier)

# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#19
IRB::SLex::D_WARN = T.let(T.unsafe(nil), IRB::Notifier::LeveledNotifier)

# ----------------------------------------------------------------------
#
#   class Node -
#
# ----------------------------------------------------------------------
#
# source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#86
class IRB::SLex::Node
  # if postproc is nil, this node is an abstract node.
  # if postproc is non-nil, this node is a real node.
  #
  # @return [Node] a new instance of Node
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#89
  def initialize(preproc = T.unsafe(nil), postproc = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#113
  def create_subnode(chrs, preproc = T.unsafe(nil), postproc = T.unsafe(nil)); end

  # chrs: String
  #       character array
  #       io must have getc()/ungetc(); and ungetc() must be
  #       able to be called arbitrary number of times.
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#161
  def match(chrs, op = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#198
  def match_io(io, op = T.unsafe(nil)); end

  # Returns the value of attribute postproc.
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#96
  def postproc; end

  # Sets the attribute postproc
  #
  # @param value the value to set the attribute postproc to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#96
  def postproc=(_arg0); end

  # Returns the value of attribute preproc.
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#95
  def preproc; end

  # Sets the attribute preproc
  #
  # @param value the value to set the attribute preproc to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#95
  def preproc=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/irb/slex.rb#98
  def search(chrs, opt = T.unsafe(nil)); end
end

# The Insertion class inserts a value before or after another
# value in a list.
#
# @example
#   Insertion.new([1, 2, 3], 4).before(3) # => [1, 2, 4, 3]
#
# source://yard//lib/yard/core_ext/insertion.rb#7
class Insertion
  # Creates an insertion object on a list with a value to be
  # inserted. To finalize the insertion, call {#before} or
  # {#after} on the object.
  #
  # @param list [Array] the list to perform the insertion on
  # @param value [Object] the value to insert
  # @return [Insertion] a new instance of Insertion
  #
  # source://yard//lib/yard/core_ext/insertion.rb#14
  def initialize(list, value); end

  # Inserts the value after +val+.
  #
  # @example If subsections are ignored
  #   Insertion.new([1, [2], 3], :X).after(1) # => [1, [2], :X, 3]
  # @param val [Object] the object the value will be inserted after
  # @param recursive [Boolean] look inside sublists
  #
  # source://yard//lib/yard/core_ext/insertion.rb#30
  def after(val, recursive = T.unsafe(nil)); end

  # Alias for {#after} with +recursive+ set to true
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/core_ext/insertion.rb#38
  def after_any(val); end

  # Inserts the value before +val+
  #
  # @param val [Object] the object the value will be inserted before
  # @param recursive [Boolean] look inside sublists
  #
  # source://yard//lib/yard/core_ext/insertion.rb#22
  def before(val, recursive = T.unsafe(nil)); end

  # Alias for {#before} with +recursive+ set to true
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/core_ext/insertion.rb#34
  def before_any(val); end

  private

  # This method performs the actual insertion
  #
  # @param val [Object] the value to insert
  # @param rel [Fixnum] the relative index (0 or 1) of where the object
  #   should be placed
  # @param recursive [Boolean] look inside sublists
  # @param list [Array] the list to place objects into
  #
  # source://yard//lib/yard/core_ext/insertion.rb#49
  def insertion(val, rel, recursive = T.unsafe(nil), list = T.unsafe(nil)); end
end

# source://yard//lib/yard/core_ext/module.rb#2
class Module
  # Returns the class name of a full module namespace path
  #
  # @example
  #   module A::B::C; class_name end # => "C"
  # @return [String] the last part of a module path
  #
  # source://yard//lib/yard/core_ext/module.rb#8
  def class_name; end
end

class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin

  private

  # source://yard//lib/yard/globals.rb#8
  def P(namespace, name = T.unsafe(nil), type = T.unsafe(nil)); end

  # source://yard//lib/yard/globals.rb#20
  def log; end
end

# Keep track of Ruby version for compatibility code
#
# @deprecated Use {YARD.ruby18?} or {YARD.ruby19?} instead.
#
# source://yard//lib/yard.rb#61
RUBY18 = T.let(T.unsafe(nil), FalseClass)

# source://yard//lib/yard.rb#62
RUBY19 = T.let(T.unsafe(nil), TrueClass)

# @private
#
# source://yard//lib/yard/server/rack_adapter.rb#93
class Rack::Request
  # source://rack/3.1.7/lib/rack/request.rb#62
  def initialize(env); end

  # source://rack/3.1.7/lib/rack/request.rb#76
  def delete_param(k); end

  # source://rack/3.1.7/lib/rack/request.rb#67
  def params; end

  # source://rack/3.1.7/lib/rack/request.rb#67
  def query; end

  # source://rack/3.1.7/lib/rack/request.rb#71
  def update_param(k, v); end

  # Returns the value of attribute version_supplied.
  #
  # source://yard//lib/yard/server/rack_adapter.rb#94
  def version_supplied; end

  # Sets the attribute version_supplied
  #
  # @param value the value to set the attribute version_supplied to.
  #
  # source://yard//lib/yard/server/rack_adapter.rb#94
  def version_supplied=(_arg0); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/server/rack_adapter.rb#96
  def xhr?; end

  class << self
    # source://rack/3.1.7/lib/rack/request.rb#31
    def forwarded_priority; end

    # source://rack/3.1.7/lib/rack/request.rb#31
    def forwarded_priority=(_arg0); end

    # source://rack/3.1.7/lib/rack/request.rb#18
    def ip_filter; end

    # source://rack/3.1.7/lib/rack/request.rb#18
    def ip_filter=(_arg0); end

    # source://rack/3.1.7/lib/rack/request.rb#40
    def x_forwarded_proto_priority; end

    # source://rack/3.1.7/lib/rack/request.rb#40
    def x_forwarded_proto_priority=(_arg0); end
  end
end

# source://yard//lib/yard/core_ext/string.rb#2
class String
  include ::Comparable

  # Splits text into tokens the way a shell would, handling quoted
  # text as a single token. Use '\"' and "\'" to escape quotes and
  # '\\' to escape a backslash.
  #
  # @return [Array] an array representing the tokens
  #
  # source://yard//lib/yard/core_ext/string.rb#8
  def shell_split; end
end

# A subclass of Hash where all keys are converted into Symbols, and
# optionally, all String values are converted into Symbols.
#
# source://yard//lib/yard/core_ext/symbol_hash.rb#4
class SymbolHash < ::Hash
  # Creates a new SymbolHash object
  #
  # @param symbolize_value [Boolean] converts any String values into Symbols
  #   if this is set to +true+.
  # @return [SymbolHash] a new instance of SymbolHash
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#9
  def initialize(symbolize_value = T.unsafe(nil)); end

  # Accessed a symbolized key
  #
  # @param key [#to_sym] the key to access
  # @return [Object] the value associated with the key
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#49
  def [](key); end

  # Assigns a value to a symbolized key
  #
  # @param key [#to_sym] the key
  # @param value [Object] the value to be assigned. If this is a String and
  #   values are set to be symbolized, it will be converted into a Symbol.
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#42
  def []=(key, value); end

  # Deleted a key and value associated with it
  #
  # @param key [#to_sym] the key to delete
  # @return [void]
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#54
  def delete(key); end

  # Tests if a symbolized key exists
  #
  # @param key [#to_sym] the key to test
  # @return [Boolean] whether the key exists
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#59
  def has_key?(key); end

  # Tests if a symbolized key exists
  #
  # @param key [#to_sym] the key to test
  # @return [Boolean] whether the key exists
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#59
  def key?(key); end

  # Merges the contents of another hash into a new SymbolHash object
  #
  # @param hash [Hash] the hash of objects to copy
  # @return [SymbolHash] a new SymbolHash containing the merged data
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#74
  def merge(hash); end

  # Updates the object with the contents of another Hash object.
  # This method modifies the original SymbolHash object
  #
  # @param hash [Hash] the hash object to copy the values from
  # @return [SymbolHash] self
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#67
  def merge!(hash); end

  # Updates the object with the contents of another Hash object.
  # This method modifies the original SymbolHash object
  #
  # @param hash [Hash] the hash object to copy the values from
  # @return [SymbolHash] self
  #
  # source://yard//lib/yard/core_ext/symbol_hash.rb#67
  def update(hash); end

  class << self
    # @overload []
    # @overload []
    #
    # source://yard//lib/yard/core_ext/symbol_hash.rb#28
    def [](*hsh); end
  end
end

# @private
#
# source://yard//lib/yard/server/webrick_adapter.rb#42
class WEBrick::HTTPRequest
  # Returns the value of attribute version_supplied.
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#43
  def version_supplied; end

  # Sets the attribute version_supplied
  #
  # @param value the value to set the attribute version_supplied to.
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#43
  def version_supplied=(_arg0); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#44
  def xhr?; end
end

# Gem::YARDoc provides methods to generate YARDoc and yri data for installed gems
# upon gem installation.
#
# This file is automatically required by RubyGems 1.9 and newer.
#
# source://yard//lib/yard.rb#2
module YARD
  class << self
    # Loads gems that match the name 'yard-*' (recommended) or 'yard_*' except
    # those listed in +~/.yard/ignored_plugins+. This is called immediately
    # after YARD is loaded to allow plugin support.
    #
    # @deprecated Use {Config.load_plugins}
    # @return [Boolean] true if all plugins loaded successfully, false otherwise.
    #
    # source://yard//lib/yard.rb#31
    def load_plugins; end

    # An alias to {Parser::SourceParser}'s parsing method
    #
    # @example Parse a glob of files
    #   YARD.parse('lib/**/*.rb')
    # @see Parser::SourceParser.parse
    #
    # source://yard//lib/yard.rb#20
    def parse(*args); end

    # An alias to {Parser::SourceParser}'s parsing method
    #
    # @example Parse a string of input
    #   YARD.parse_string('class Foo; end')
    # @see Parser::SourceParser.parse_string
    #
    # source://yard//lib/yard.rb#27
    def parse_string(*args); end

    # @return [Boolean] whether YARD is being run in Ruby 1.8 mode
    #
    # source://yard//lib/yard.rb#44
    def ruby18?; end

    # @return [Boolean] whether YARD is being run in Ruby 1.9 mode
    #
    # source://yard//lib/yard.rb#47
    def ruby19?; end

    # @return [Boolean] whether YARD is being run in Ruby 2.0
    #
    # source://yard//lib/yard.rb#50
    def ruby2?; end

    # @return [Boolean] whether YARD is being run in Ruby 3.1
    #
    # source://yard//lib/yard.rb#56
    def ruby31?; end

    # @return [Boolean] whether YARD is being run in Ruby 3.0
    #
    # source://yard//lib/yard.rb#53
    def ruby3?; end

    # @return [Boolean] whether YARD is being run inside of Windows
    #
    # source://yard//lib/yard.rb#34
    def windows?; end
  end
end

# Namespace for command-line interface components
#
# source://yard//lib/yard/autoload.rb#6
module YARD::CLI; end

# Abstract base class for CLI utilities. Provides some helper methods for
# the option parser
#
# @abstract
# @since 0.6.0
#
# source://yard//lib/yard/cli/command.rb#11
class YARD::CLI::Command
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/command.rb#16
  def description; end

  protected

  # Adds a set of common options to the tail of the OptionParser
  #
  # @param opts [OptionParser] the option parser object
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/command.rb#24
  def common_options(opts); end

  # Loads a Ruby script. If <tt>Config.options[:safe_mode]</tt> is enabled,
  # this method will do nothing.
  #
  # @param file [String] the path to the script to load
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/command.rb#68
  def load_script(file); end

  # Parses the option and gracefully handles invalid switches
  #
  # @param opts [OptionParser] the option parser object
  # @param args [Array<String>] the arguments passed from input. This
  #   array will be modified.
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/command.rb#55
  def parse_options(opts, args); end

  # Callback when an unrecognize option is parsed
  #
  # @param err [OptionParser::ParseError] the exception raised by the
  #   option parser
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/command.rb#80
  def unrecognized_option(err); end

  class << self
    # Helper method to run the utility on an instance.
    #
    # @see #run
    # @since 0.6.0
    #
    # source://yard//lib/yard/cli/command.rb#14
    def run(*args); end
  end
end

# This class parses a command name out of the +yard+ CLI command and calls
# that command in the form:
#
#   $ yard command_name [options]
#
# If no command or arguments are specified, or if the arguments immediately
# begin with a +--opt+ (not +--help+), the {default_command} will be used
# (which itself defaults to +:doc+).
#
# == Adding a Command
#
# To add a custom command via plugin, create a mapping in {commands} from
# the Symbolic command name to the {Command} class that implements the
# command. To implement a command, see the documentation for the {Command}
# class.
#
# @see Command
# @see commands
# @see default_command
#
# source://yard//lib/yard/cli/command_parser.rb#23
class YARD::CLI::CommandParser
  # @return [CommandParser] a new instance of CommandParser
  #
  # source://yard//lib/yard/cli/command_parser.rb#56
  def initialize; end

  # Runs the {Command} object matching the command name of the first
  # argument.
  #
  # @return [void]
  #
  # source://yard//lib/yard/cli/command_parser.rb#63
  def run(*args); end

  private

  # source://yard//lib/yard/cli/command_parser.rb#80
  def commands; end

  # source://yard//lib/yard/cli/command_parser.rb#82
  def list_commands; end

  class << self
    # @return [Hash{Symbol => Command}] the mapping of command names to
    #   command classes to parse the user command.
    #
    # source://yard//lib/yard/cli/command_parser.rb#27
    def commands; end

    # @return [Hash{Symbol => Command}] the mapping of command names to
    #   command classes to parse the user command.
    #
    # source://yard//lib/yard/cli/command_parser.rb#27
    def commands=(_arg0); end

    # @return [Symbol] the default command name to use when no options
    #   are specified or
    #
    # source://yard//lib/yard/cli/command_parser.rb#31
    def default_command; end

    # @return [Symbol] the default command name to use when no options
    #   are specified or
    #
    # source://yard//lib/yard/cli/command_parser.rb#31
    def default_command=(_arg0); end

    # Convenience method to create a new CommandParser and call {#run}
    #
    # @return [void]
    #
    # source://yard//lib/yard/cli/command_parser.rb#54
    def run(*args); end
  end
end

# CLI command to view or edit configuration options
#
# @since 0.6.2
#
# source://yard//lib/yard/cli/config.rb#6
class YARD::CLI::Config < ::YARD::CLI::Command
  # @return [Config] a new instance of Config
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#26
  def initialize; end

  # @return [Boolean] whether to append values to existing key
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#20
  def append; end

  # @return [Boolean] whether to append values to existing key
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#20
  def append=(_arg0); end

  # @return [Boolean] whether the value being set should be inside a list
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#17
  def as_list; end

  # @return [Boolean] whether the value being set should be inside a list
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#17
  def as_list=(_arg0); end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#36
  def description; end

  # @return [String, nil] command to use when configuring ~/.gemrc file.
  #   If the string is nil, configuration should not occur.
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#24
  def gem_install_cmd; end

  # @return [String, nil] command to use when configuring ~/.gemrc file.
  #   If the string is nil, configuration should not occur.
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#24
  def gem_install_cmd=(_arg0); end

  # @return [Symbol, nil] the key to view/edit, if any
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#8
  def key; end

  # @return [Symbol, nil] the key to view/edit, if any
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#8
  def key=(_arg0); end

  # @return [Boolean] whether to reset the {#key}
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#14
  def reset; end

  # @return [Boolean] whether to reset the {#key}
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#14
  def reset=(_arg0); end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#40
  def run(*args); end

  # @return [Array, nil] the list of values to set (or single value), if modifying
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#11
  def values; end

  # @return [Array, nil] the list of values to set (or single value), if modifying
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#11
  def values=(_arg0); end

  private

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#57
  def configure_gemrc; end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#111
  def encode_value(value); end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#103
  def encode_values; end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#97
  def list_configuration; end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#78
  def modify_item; end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#120
  def optparse(*args); end

  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/config.rb#92
  def view_item; end
end

# CLI command to return the objects that were added/removed from 2 versions
# of a project (library, gem, working copy).
#
# @since 0.6.0
#
# source://yard//lib/yard/cli/diff.rb#11
class YARD::CLI::Diff < ::YARD::CLI::Command
  # @return [Diff] a new instance of Diff
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#12
  def initialize; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#24
  def description; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#28
  def run(*args); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#83
  def added_objects(registry1, registry2); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#78
  def all_objects; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#233
  def cleanup(gemfile); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#175
  def expand_and_parse(gemfile, io); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#187
  def expand_gem(gemfile, io); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#181
  def generate_yardoc(dir); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#118
  def load_gem_data(gemfile); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#102
  def load_git_commit(commit); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#87
  def modified_objects(registry1, registry2); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#239
  def optparse(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#98
  def removed_objects(registry1, registry2); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/diff.rb#225
  def require_rubygems; end
end

# Display one object
#
# @since 0.8.6
#
# source://yard//lib/yard/cli/display.rb#6
class YARD::CLI::Display < ::YARD::CLI::Yardoc
  # @return [Display] a new instance of Display
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#9
  def initialize(*args); end

  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#7
  def description; end

  # @return [String] the output data for all formatted objects
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#27
  def format_objects; end

  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#61
  def output_options(opts); end

  # Parses commandline options.
  #
  # @param args [Array<String>] each tokenized argument
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#46
  def parse_arguments(*args); end

  # Runs the commandline utility, parsing arguments and displaying an object
  # from the {Registry}.
  #
  # @param args [Array<String>] the list of arguments.
  # @return [void]
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#21
  def run(*args); end

  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/display.rb#33
  def wrap_layout(contents); end
end

# @since 0.6.0
#
# source://yard//lib/yard/cli/gems.rb#5
class YARD::CLI::Gems < ::YARD::CLI::Command
  # @return [Gems] a new instance of Gems
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#6
  def initialize; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#11
  def description; end

  # Runs the commandline utility, parsing arguments and generating
  # YARD indexes for gems.
  #
  # @param args [Array<String>] the list of arguments
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#18
  def run(*args); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#47
  def add_gems(gems); end

  # Builds .yardoc files for all non-existing gems
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#27
  def build_gems; end

  # Parses options
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/gems.rb#61
  def optparse(*args); end
end

# A command-line utility to generate Graphviz graphs from
# a set of objects
#
# @see Graph#run
# @since 0.6.0
#
# source://yard//lib/yard/cli/graph.rb#24
class YARD::CLI::Graph < ::YARD::CLI::YardoptsCommand
  # Creates a new instance of the command-line utility
  #
  # @return [Graph] a new instance of Graph
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#34
  def initialize; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#42
  def description; end

  # The set of objects to include in the graph.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#31
  def objects; end

  # The options parsed out of the commandline.
  # Default options are:
  #   :format => :dot
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#28
  def options; end

  # Runs the command-line utility.
  #
  # @example
  #   grapher = Graph.new
  #   grapher.run('--private')
  # @param args [Array<String>] each tokenized argument
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#52
  def run(*args); end

  private

  # Parses commandline options.
  #
  # @param args [Array<String>] each tokenized argument
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#69
  def optparse(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/graph.rb#65
  def unrecognized_option(err); end
end

# Options to pass to the {Graph} CLI.
#
# source://yard//lib/yard/cli/graph.rb#5
class YARD::CLI::GraphOptions < ::YARD::Templates::TemplateOptions
  # @return [String] any contents to pass to the digraph
  #
  # source://yard//lib/yard/cli/graph.rb#16
  def contents; end

  # @return [String] any contents to pass to the digraph
  #
  # source://yard//lib/yard/cli/graph.rb#16
  def contents=(_arg0); end

  # @return [Boolean] whether to show the object dependencies
  #
  # source://yard//lib/yard/cli/graph.rb#13
  def dependencies; end

  # @return [Boolean] whether to show the object dependencies
  #
  # source://yard//lib/yard/cli/graph.rb#13
  def dependencies=(_arg0); end

  # @return [:dot] the default output format
  #
  # source://yard//lib/yard/options.rb#82
  def format; end

  # source://yard//lib/yard/options.rb#82
  def format=(_arg0); end

  # @return [Boolean] whether to list the full class diagram
  #
  # source://yard//lib/yard/cli/graph.rb#10
  def full; end

  # @return [Boolean] whether to list the full class diagram
  #
  # source://yard//lib/yard/cli/graph.rb#10
  def full=(_arg0); end
end

# Handles help for commands
#
# @since 0.6.0
#
# source://yard//lib/yard/cli/help.rb#6
class YARD::CLI::Help < ::YARD::CLI::Command
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/help.rb#7
  def description; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/help.rb#9
  def run(*args); end
end

# CLI command to support internationalization (a.k.a. i18n).
# I18n feature is based on gettext technology.
# This command generates .pot file from docstring and extra
# documentation.
#
# @since 0.8.0
# @todo Support msgminit and msgmerge features?
#
# source://yard//lib/yard/cli/i18n.rb#13
class YARD::CLI::I18n < ::YARD::CLI::Yardoc
  # @return [I18n] a new instance of I18n
  # @since 0.8.0
  #
  # source://yard//lib/yard/cli/i18n.rb#14
  def initialize; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/cli/i18n.rb#19
  def description; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/cli/i18n.rb#23
  def run(*args); end

  private

  # @since 0.8.0
  #
  # source://yard//lib/yard/cli/i18n.rb#44
  def general_options(opts); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/cli/i18n.rb#61
  def generate_pot(relative_base_path); end
end

# Lists all constant and method names in the codebase. Uses {Yardoc} --list.
#
# source://yard//lib/yard/cli/list.rb#5
class YARD::CLI::List < ::YARD::CLI::Command
  # source://yard//lib/yard/cli/list.rb#6
  def description; end

  # Runs the commandline utility, parsing arguments and displaying a
  # list of objects
  #
  # @param args [Array<String>] the list of arguments.
  # @return [void]
  #
  # source://yard//lib/yard/cli/list.rb#13
  def run(*args); end
end

# Lists all markup types
#
# @since 0.8.6
#
# source://yard//lib/yard/cli/markup_types.rb#6
class YARD::CLI::MarkupTypes < ::YARD::CLI::Command
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/markup_types.rb#7
  def description; end

  # Runs the commandline utility, parsing arguments and displaying a
  # list of markup types
  #
  # @param args [Array<String>] the list of arguments.
  # @return [void]
  # @since 0.8.6
  #
  # source://yard//lib/yard/cli/markup_types.rb#14
  def run(*args); end
end

# A local documentation server
#
# @since 0.6.0
#
# source://yard//lib/yard/cli/server.rb#7
class YARD::CLI::Server < ::YARD::CLI::Command
  # Creates a new instance of the Server command line utility
  #
  # @return [Server] a new instance of Server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#29
  def initialize; end

  # @return [YARD::Server::Adapter] the adapter to use for loading the web server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#18
  def adapter; end

  # @return [YARD::Server::Adapter] the adapter to use for loading the web server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#18
  def adapter=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#41
  def description; end

  # @return [Hash] a list of library names and yardoc files to serve
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#15
  def libraries; end

  # @return [Hash] a list of library names and yardoc files to serve
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#15
  def libraries=(_arg0); end

  # @return [Hash] a list of options to pass to the doc server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#9
  def options; end

  # @return [Hash] a list of options to pass to the doc server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#9
  def options=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#45
  def run(*args); end

  # @return [Array<String>] a list of scripts to load
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/server.rb#22
  def scripts; end

  # @return [Array<String>] a list of scripts to load
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/server.rb#22
  def scripts=(_arg0); end

  # @return [Hash] a list of options to pass to the web server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#12
  def server_options; end

  # @return [Hash] a list of options to pass to the web server
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#12
  def server_options=(_arg0); end

  # @return [Array<String>] a list of template paths to register
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/server.rb#26
  def template_paths; end

  # @return [Array<String>] a list of template paths to register
  # @since 0.6.2
  #
  # source://yard//lib/yard/cli/server.rb#26
  def template_paths=(_arg0); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#131
  def add_gems; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#140
  def add_gems_from_gemfile(gemfile = T.unsafe(nil)); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#76
  def add_libraries(args); end

  # @param library [String] The library name.
  # @param dir [String, nil] The argument provided on the CLI after the
  #   library name. Is supposed to point to either a project directory
  #   with a Yard options file, or a yardoc db.
  # @return [LibraryVersion, nil]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#115
  def create_library_version_if_yardopts_exist(library, dir); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#249
  def extract_db_from_options_file(options_file); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#239
  def generate_doc_for_first_time(libver); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#56
  def load_scripts; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#60
  def load_template_paths; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#156
  def optparse(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/server.rb#66
  def select_adapter; end
end

# @since 0.6.0
#
# source://yard//lib/yard/cli/stats.rb#5
class YARD::CLI::Stats < ::YARD::CLI::Yardoc
  include ::YARD::Templates::Helpers::BaseHelper

  # @param parse [Boolean] whether to parse and load registry (see {#parse})
  # @return [Stats] a new instance of Stats
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#18
  def initialize(parse = T.unsafe(nil)); end

  # @return [Array<CodeObjects::Base>] all the parsed objects in the registry,
  #   removing any objects that are not visible (private, protected) depending
  #   on the arguments passed to the command.
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#108
  def all_objects; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#25
  def description; end

  # Prints a statistic to standard out. This method is optimized for
  # getting Integer values, though it allows any data to be printed.
  #
  # @param name [String] the statistic name
  # @param data [Integer, String] the numeric (or any) data representing
  #   the statistic. If +data+ is an Integer, it should represent the
  #   total objects of a type.
  # @param undoc [Integer, nil] number of undocumented objects for the type
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#162
  def output(name, data, undoc = T.unsafe(nil)); end

  # @return [Boolean] whether to parse and load registry
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#15
  def parse; end

  # @return [Boolean] whether to parse and load registry
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#15
  def parse=(_arg0); end

  # Prints statistics for different object types
  #
  # To add statistics for a specific type, add a method +#stats_for_TYPE+
  # to this class that calls {#output}.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#54
  def print_statistics; end

  # Prints list of undocumented objects
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#79
  def print_undocumented_objects; end

  # Runs the commandline utility, parsing arguments and generating
  # output if set.
  #
  # @param args [Array<String>] the list of arguments
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#34
  def run(*args); end

  # Statistics for attributes
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#135
  def stats_for_attributes; end

  # Statistics for classes
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#125
  def stats_for_classes; end

  # Statistics for constants
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#130
  def stats_for_constants; end

  # Statistics for files
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#113
  def stats_for_files; end

  # Statistics for methods
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#144
  def stats_for_methods; end

  # Statistics for modules
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#120
  def stats_for_modules; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#199
  def general_options(opts); end

  # Parses commandline options.
  #
  # @param args [Array<String>] each tokenized argument
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#185
  def optparse(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/stats.rb#176
  def type_statistics(type); end
end

# Maintains the order in which +stats_for_+ statistics methods should be
# printed.
#
# @see #print_statistics
# @since 0.6.0
#
# source://yard//lib/yard/cli/stats.rb#12
YARD::CLI::Stats::STATS_ORDER = T.let(T.unsafe(nil), Array)

# A tool to view documentation in the console like `ri`
#
# source://yard//lib/yard/cli/yri.rb#7
class YARD::CLI::YRI < ::YARD::CLI::Command
  # @return [YRI] a new instance of YRI
  #
  # source://yard//lib/yard/cli/yri.rb#31
  def initialize; end

  # source://yard//lib/yard/cli/yri.rb#41
  def description; end

  # Runs the command-line utility.
  #
  # @example
  #   YRI.new.run('String#reverse')
  # @param args [Array<String>] each tokenized argument
  #
  # source://yard//lib/yard/cli/yri.rb#50
  def run(*args); end

  protected

  # Caches the .yardoc file where an object can be found in the {CACHE_FILE}
  #
  # @return [void]
  #
  # source://yard//lib/yard/cli/yri.rb#85
  def cache_object(name, path); end

  # Locates an object by name starting in the cached paths and then
  # searching through any search paths.
  #
  # @param name [String] the full name of the object
  # @return [CodeObjects::Base] an object if found
  # @return [nil] if no object is found
  #
  # source://yard//lib/yard/cli/yri.rb#113
  def find_object(name); end

  # @param object [CodeObjects::Base] the object to print.
  # @return [String] the formatted output for an object.
  #
  # source://yard//lib/yard/cli/yri.rb#98
  def print_object(object); end

  # Prints the command usage
  #
  # @return [void]
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yri.rb#78
  def print_usage; end

  private

  # Adds paths in {SEARCH_PATHS_FILE}
  #
  # @since 0.5.1
  #
  # source://yard//lib/yard/cli/yri.rb#181
  def add_default_paths; end

  # Adds all RubyGems yardoc files to search paths
  #
  # @return [void]
  #
  # source://yard//lib/yard/cli/yri.rb#161
  def add_gem_paths; end

  # Loads {CACHE_FILE}
  #
  # @return [void]
  #
  # source://yard//lib/yard/cli/yri.rb#151
  def load_cache; end

  # Parses commandline options.
  #
  # @param args [Array<String>] each tokenized argument
  #
  # source://yard//lib/yard/cli/yri.rb#190
  def optparse(*args); end

  # Tries to load the object with name. If successful, caches the object
  # with the cache_path
  #
  # @param name [String] the object path
  # @param cache_path [String] the location of the yardoc
  #   db containing the object to cache for future lookups.
  #   No caching is done if this is nil.
  # @return [void]
  #
  # source://yard//lib/yard/cli/yri.rb#143
  def try_load_object(name, cache_path); end

  class << self
    # Helper method to run the utility on an instance.
    #
    # @see #run
    #
    # source://yard//lib/yard/cli/yri.rb#29
    def run(*args); end
  end
end

# The location in {YARD::CONFIG_DIR} where the YRI cache file is loaded
# from.
#
# source://yard//lib/yard/cli/yri.rb#10
YARD::CLI::YRI::CACHE_FILE = T.let(T.unsafe(nil), String)

# Default search paths that should be loaded dynamically into YRI. These paths
# take precedence over all other paths ({SEARCH_PATHS_FILE} and RubyGems
# paths). To add a path, call:
#
#   DEFAULT_SEARCH_PATHS.push("/path/to/.yardoc")
#
# @return [Array<String>] a list of extra search paths
# @since 0.6.0
#
# source://yard//lib/yard/cli/yri.rb#25
YARD::CLI::YRI::DEFAULT_SEARCH_PATHS = T.let(T.unsafe(nil), Array)

# A file containing all paths, delimited by newlines, to search for
# yardoc databases.
#
# @since 0.5.1
#
# source://yard//lib/yard/cli/yri.rb#15
YARD::CLI::YRI::SEARCH_PATHS_FILE = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/cli/yardoc.rb#145
class YARD::CLI::Yardoc < ::YARD::CLI::YardoptsCommand
  # Creates a new instance of the commandline utility
  #
  # @return [Yardoc] a new instance of Yardoc
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#207
  def initialize; end

  # The list of all objects to process. Override this method to change
  # which objects YARD should generate documentation for.
  #
  # @deprecated To hide methods use the +@private+ tag instead.
  # @return [Array<CodeObjects::Base>] a list of code objects to process
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#330
  def all_objects; end

  # Keep track of which APIs are to be shown
  #
  # @return [Array<String>] a list of APIs
  # @since 0.8.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#180
  def apis; end

  # Keep track of which APIs are to be shown
  #
  # @return [Array<String>] a list of APIs
  # @since 0.8.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#180
  def apis=(_arg0); end

  # @return [Array<String>] a list of assets to copy after generation
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#197
  def assets; end

  # @return [Array<String>] a list of assets to copy after generation
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#197
  def assets=(_arg0); end

  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#234
  def description; end

  # @return [Array<String>] list of excluded paths (regexp matches)
  # @since 0.5.3
  #
  # source://yard//lib/yard/cli/yardoc.rb#155
  def excluded; end

  # @return [Array<String>] list of excluded paths (regexp matches)
  # @since 0.5.3
  #
  # source://yard//lib/yard/cli/yardoc.rb#155
  def excluded=(_arg0); end

  # @return [Boolean] whether yard exits with error status code if a warning occurs
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#204
  def fail_on_warning; end

  # @return [Boolean] whether yard exits with error status code if a warning occurs
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#204
  def fail_on_warning=(_arg0); end

  # @return [Array<String>] list of Ruby source files to process
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#151
  def files; end

  # @return [Array<String>] list of Ruby source files to process
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#151
  def files=(_arg0); end

  # @return [Boolean] whether to generate output
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#166
  def generate; end

  # @return [Boolean] whether to generate output
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#166
  def generate=(_arg0); end

  # @return [Boolean] whether markup option was specified
  # @since 0.7.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#201
  def has_markup; end

  # @return [Boolean] whether markup option was specified
  # @since 0.7.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#201
  def has_markup=(_arg0); end

  # Keep track of which APIs are to be hidden
  #
  # @return [Array<String>] a list of APIs to be hidden
  # @since 0.8.7
  #
  # source://yard//lib/yard/cli/yardoc.rb#185
  def hidden_apis; end

  # Keep track of which APIs are to be hidden
  #
  # @return [Array<String>] a list of APIs to be hidden
  # @since 0.8.7
  #
  # source://yard//lib/yard/cli/yardoc.rb#185
  def hidden_apis=(_arg0); end

  # @return [Array<Symbol>] a list of tags to hide from templates
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#189
  def hidden_tags; end

  # @return [Array<Symbol>] a list of tags to hide from templates
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#189
  def hidden_tags=(_arg0); end

  # @return [Boolean] whether to print a list of objects
  # @since 0.5.5
  #
  # source://yard//lib/yard/cli/yardoc.rb#170
  def list; end

  # @return [Boolean] whether to print a list of objects
  # @since 0.5.5
  #
  # source://yard//lib/yard/cli/yardoc.rb#170
  def list=(_arg0); end

  # @return [Hash] the hash of options passed to the template.
  # @see Templates::Engine#render
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#148
  def options; end

  # Parses commandline arguments
  #
  # @param args [Array<String>] the list of arguments
  # @return [Boolean] whether or not arguments are valid
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yardoc.rb#291
  def parse_arguments(*args); end

  # Runs the commandline utility, parsing arguments and generating
  # output if set.
  #
  # @param args [Array<String>] the list of arguments. If the list only
  #   contains a single nil value, skip calling of {#parse_arguments}
  # @return [void]
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#244
  def run(*args); end

  # @return [Boolean] whether objects should be serialized to .yardoc db
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#163
  def save_yardoc; end

  # @return [Boolean] whether objects should be serialized to .yardoc db
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#163
  def save_yardoc=(_arg0); end

  # @return [Boolean] whether to print statistics after parsing
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#193
  def statistics; end

  # @return [Boolean] whether to print statistics after parsing
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#193
  def statistics=(_arg0); end

  # @return [Boolean] whether to use the existing yardoc db if the
  #   .yardoc already exists. Also makes use of file checksums to
  #   parse only changed files.
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#160
  def use_cache; end

  # @return [Boolean] whether to use the existing yardoc db if the
  #   .yardoc already exists. Also makes use of file checksums to
  #   parse only changed files.
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#160
  def use_cache=(_arg0); end

  # Keep track of which visibilities are to be shown
  #
  # @return [Array<Symbol>] a list of visibilities
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yardoc.rb#175
  def visibilities; end

  # Keep track of which visibilities are to be shown
  #
  # @return [Array<Symbol>] a list of visibilities
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yardoc.rb#175
  def visibilities=(_arg0); end

  private

  # Adds verifier rule for APIs
  #
  # @return [void]
  # @since 0.8.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#474
  def add_api_verifier; end

  # Adds a set of extra documentation files to be processed
  #
  # @param files [Array<String>] the set of documentation files
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#413
  def add_extra_files(*files); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#507
  def add_tag(tag_data, factory_method = T.unsafe(nil)); end

  # Adds verifier rule for visibilities
  #
  # @return [void]
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yardoc.rb#466
  def add_visibility_verifier; end

  # Applies the specified locale to collected objects
  #
  # @return [void]
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardoc.rb#494
  def apply_locale; end

  # Copies any assets to the output directory
  #
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#389
  def copy_assets; end

  # @param file [String] the filename to validate
  # @param check_exists [Boolean] whether the file should exist on disk
  # @return [Boolean] whether the file is allowed to be used
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#425
  def extra_file_valid?(file, check_exists = T.unsafe(nil)); end

  # Adds general options
  #
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#541
  def general_options(opts); end

  # Parses commandline options.
  #
  # @param args [Array<String>] each tokenized argument
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#516
  def optparse(*args); end

  # Adds output options
  #
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#586
  def output_options(opts); end

  # Parses the file arguments into Ruby files and extra files, which are
  # separated by a '-' element.
  #
  # @example Parses a set of Ruby source files
  #   parse_files %w(file1 file2 file3)
  # @example Parses a set of Ruby files with a separator and extra files
  #   parse_files %w(file1 file2 - extrafile1 extrafile2)
  # @param files [Array<String>] the list of files to parse
  # @return [void]
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#446
  def parse_files(*files); end

  # Prints a list of all objects
  #
  # @return [void]
  # @since 0.5.5
  #
  # source://yard//lib/yard/cli/yardoc.rb#403
  def print_list; end

  # Generates output for objects
  #
  # @param checksums [Hash, nil] if supplied, a list of checksums for files.
  # @return [void]
  # @since 0.5.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#340
  def run_generate(checksums); end

  # Runs a list of objects against the {Verifier} object passed into the
  # template and returns the subset of verified objects.
  #
  # @param list [Array<CodeObjects::Base>] a list of code objects
  # @return [Array<CodeObjects::Base>] a list of code objects that match
  #   the verifier. If no verifier is supplied, all objects are returned.
  #
  # source://yard//lib/yard/cli/yardoc.rb#502
  def run_verifier(list); end

  # Adds tag options
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/cli/yardoc.rb#753
  def tag_options(opts); end

  # Verifies that the markup options are valid before parsing any code.
  # Failing early is better than failing late.
  #
  # @return [Boolean] whether the markup provider was successfully loaded.
  # @since 0.2.1
  #
  # source://yard//lib/yard/cli/yardoc.rb#364
  def verify_markup_options; end
end

# Default options used in +yard doc+ command.
#
# source://yard//lib/yard/cli/yardoc.rb#8
class YARD::CLI::YardocOptions < ::YARD::Templates::TemplateOptions
  # @return [CodeObjects::ExtraFileObject] the file object being rendered.
  #   The +object+ key is not used so that a file may be rendered in the context
  #   of an object's namespace (for generating links).
  #
  # source://yard//lib/yard/cli/yardoc.rb#48
  def file; end

  # @return [CodeObjects::ExtraFileObject] the file object being rendered.
  #   The +object+ key is not used so that a file may be rendered in the context
  #   of an object's namespace (for generating links).
  #
  # source://yard//lib/yard/cli/yardoc.rb#48
  def file=(_arg0); end

  # @return [Array<CodeObjects::ExtraFileObject>] the list of extra files rendered along with objects
  #
  # source://yard//lib/yard/options.rb#82
  def files; end

  # source://yard//lib/yard/options.rb#82
  def files=(_arg0); end

  # @return [Symbol] the default output format (:html).
  #
  # source://yard//lib/yard/options.rb#82
  def format; end

  # source://yard//lib/yard/options.rb#82
  def format=(_arg0); end

  # @return [Numeric] An index value for rendering sequentially related templates
  #
  # source://yard//lib/yard/cli/yardoc.rb#39
  def index; end

  # @return [Numeric] An index value for rendering sequentially related templates
  #
  # source://yard//lib/yard/cli/yardoc.rb#39
  def index=(_arg0); end

  # @return [CodeObjects::Base] an extra item to send to a template that is not
  #   the main rendered object
  #
  # source://yard//lib/yard/cli/yardoc.rb#43
  def item; end

  # @return [CodeObjects::Base] an extra item to send to a template that is not
  #   the main rendered object
  #
  # source://yard//lib/yard/cli/yardoc.rb#43
  def item=(_arg0); end

  # @return [String] the current locale
  #
  # source://yard//lib/yard/cli/yardoc.rb#51
  def locale; end

  # @return [String] the current locale
  #
  # source://yard//lib/yard/cli/yardoc.rb#51
  def locale=(_arg0); end

  # @return [Array<CodeObjects::Base>] the list of code objects to render
  #   the templates with.
  #
  # source://yard//lib/yard/cli/yardoc.rb#36
  def objects; end

  # @return [Array<CodeObjects::Base>] the list of code objects to render
  #   the templates with.
  #
  # source://yard//lib/yard/cli/yardoc.rb#36
  def objects=(_arg0); end

  # @return [Boolean] whether the data should be rendered in a single page,
  #   if the template supports it.
  #
  # source://yard//lib/yard/options.rb#82
  def onefile; end

  # source://yard//lib/yard/options.rb#82
  def onefile=(_arg0); end

  # @return [CodeObjects::ExtraFileObject] the README file object rendered
  #   along with objects
  #
  # source://yard//lib/yard/cli/yardoc.rb#32
  def readme; end

  # @return [CodeObjects::ExtraFileObject] the README file object rendered
  #   along with objects
  #
  # source://yard//lib/yard/cli/yardoc.rb#32
  def readme=(_arg0); end

  # @return [Serializers::Base] the default serializer for generating output
  #   to disk.
  #
  # source://yard//lib/yard/options.rb#82
  def serializer; end

  # source://yard//lib/yard/options.rb#82
  def serializer=(_arg0); end

  # @return [String] the default title appended to each generated page
  #
  # source://yard//lib/yard/options.rb#82
  def title; end

  # source://yard//lib/yard/options.rb#82
  def title=(_arg0); end

  # @return [Verifier] the default verifier object to filter queries
  #
  # source://yard//lib/yard/options.rb#82
  def verifier; end

  # source://yard//lib/yard/options.rb#82
  def verifier=(_arg0); end
end

# Abstract base class for command that reads .yardopts file
#
# @abstract
# @since 0.8.3
#
# source://yard//lib/yard/cli/yardopts_command.rb#10
class YARD::CLI::YardoptsCommand < ::YARD::CLI::Command
  # Creates a new command that reads .yardopts
  #
  # @return [YardoptsCommand] a new instance of YardoptsCommand
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#25
  def initialize; end

  # The options file name (defaults to {DEFAULT_YARDOPTS_FILE})
  #
  # @return [String] the filename to load extra options from
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#22
  def options_file; end

  # The options file name (defaults to {DEFAULT_YARDOPTS_FILE})
  #
  # @return [String] the filename to load extra options from
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#22
  def options_file=(_arg0); end

  # Parses commandline arguments
  #
  # @param args [Array<String>] the list of arguments
  # @return [Boolean] whether or not arguments are valid
  # @since 0.5.6
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#36
  def parse_arguments(*args); end

  # @return [Boolean] whether to parse options from .document
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#18
  def use_document_file; end

  # @return [Boolean] whether to parse options from .document
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#18
  def use_document_file=(_arg0); end

  # @return [Boolean] whether to parse options from .yardopts
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#15
  def use_yardopts_file; end

  # @return [Boolean] whether to parse options from .yardopts
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#15
  def use_yardopts_file=(_arg0); end

  protected

  # Adds --[no-]yardopts / --[no-]document
  #
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#48
  def yardopts_options(opts); end

  private

  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#92
  def parse_rdoc_document_file(file = T.unsafe(nil)); end

  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#96
  def parse_yardopts(file = T.unsafe(nil)); end

  # Parses out the yardopts/document options
  #
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#78
  def parse_yardopts_options(*args); end

  # Reads a .document file in the directory to get source file globs
  #
  # @return [Array<String>] an array of files parsed from .document
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#102
  def support_rdoc_document_file!(file = T.unsafe(nil)); end

  # Parses the .yardopts file for default yard options
  #
  # @return [Array<String>] an array of options parsed from .yardopts
  # @since 0.8.3
  #
  # source://yard//lib/yard/cli/yardopts_command.rb#70
  def yardopts(file = T.unsafe(nil)); end
end

# The configuration filename to load extra options from
#
# @since 0.8.3
#
# source://yard//lib/yard/cli/yardopts_command.rb#12
YARD::CLI::YardoptsCommand::DEFAULT_YARDOPTS_FILE = T.let(T.unsafe(nil), String)

# @deprecated Use {Config::CONFIG_DIR}
#
# source://yard//lib/yard.rb#13
YARD::CONFIG_DIR = T.let(T.unsafe(nil), String)

# A "code object" is defined as any entity in the Ruby language.
# Classes, modules, methods, class variables and constants are the
# major objects, but DSL languages can create their own by inheriting
# from {CodeObjects::Base}.
#
# source://yard//lib/yard/autoload.rb#29
module YARD::CodeObjects
  extend ::YARD::CodeObjects::NamespaceMapper
end

# All builtin Ruby classes and modules.
#
# source://yard//lib/yard/code_objects/base.rb#91
YARD::CodeObjects::BUILTIN_ALL = T.let(T.unsafe(nil), Array)

# All builtin Ruby classes for inheritance tree.
#
# @note MatchingData is a 1.8.x legacy class
#
# source://yard//lib/yard/code_objects/base.rb#78
YARD::CodeObjects::BUILTIN_CLASSES = T.let(T.unsafe(nil), Array)

# All builtin Ruby exception classes for inheritance tree.
#
# source://yard//lib/yard/code_objects/base.rb#67
YARD::CodeObjects::BUILTIN_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# Hash of {BUILTIN_EXCEPTIONS} as keys and true as value (for O(1) lookups)
#
# source://yard//lib/yard/code_objects/base.rb#94
YARD::CodeObjects::BUILTIN_EXCEPTIONS_HASH = T.let(T.unsafe(nil), Hash)

# All builtin Ruby modules for mixin handling.
#
# source://yard//lib/yard/code_objects/base.rb#87
YARD::CodeObjects::BUILTIN_MODULES = T.let(T.unsafe(nil), Array)

# +Base+ is the superclass of all code objects recognized by YARD. A code
# object is any entity in the Ruby language (class, method, module). A
# DSL might subclass +Base+ to create a new custom object representing
# a new entity type.
#
# == Registry Integration
# Any created object associated with a namespace is immediately registered
# with the registry. This allows the Registry to act as an identity map
# to ensure that no object is represented by more than one Ruby object
# in memory. A unique {#path} is essential for this identity map to work
# correctly.
#
# == Custom Attributes
# Code objects allow arbitrary custom attributes to be set using the
# {#[]=} assignment method.
#
# == Namespaces
# There is a special type of object called a "namespace". These are subclasses
# of the {NamespaceObject} and represent Ruby entities that can have
# objects defined within them. Classically these are modules and classes,
# though a DSL might create a custom {NamespaceObject} to describe a
# specific set of objects.
#
# == Separators
# Custom classes with different separator tokens should define their own
# separators using the {NamespaceMapper.register_separator} method. The
# standard Ruby separators have already been defined ('::', '#', '.', etc).
#
# @abstract This class should not be used directly. Instead, create a
#   subclass that implements {#path}, {#sep} or {#type}. You might also
#   need to register custom separators if {#sep} uses alternate separator
#   tokens.
# @see Registry
# @see #path
# @see #[]=
# @see NamespaceObject
# @see NamespaceMapper.register_separator
#
# source://yard//lib/yard/code_objects/base.rb#133
class YARD::CodeObjects::Base
  # Creates a new code object
  #
  # @example Create a method in the root namespace
  #   CodeObjects::Base.new(:root, '#method') # => #<yardoc method #method>
  # @example Create class Z inside namespace X::Y
  #   CodeObjects::Base.new(P("X::Y"), :Z) # or
  #   CodeObjects::Base.new(Registry.root, "X::Y")
  # @param namespace [NamespaceObject] the namespace the object belongs in,
  #   {Registry.root} or :root should be provided if it is associated with
  #   the top level namespace.
  # @param name [Symbol, String] the name (or complex path) of the object.
  # @return [Base] the newly created object
  # @yield [self] a block to perform any extra initialization on the object
  # @yieldparam self [Base] the newly initialized code object
  #
  # source://yard//lib/yard/code_objects/base.rb#238
  def initialize(namespace, name, *_arg2); end

  # Tests if another object is equal to this, including a proxy
  #
  # @param other [Base, Proxy] if other is a {Proxy}, tests if
  #   the paths are equal
  # @return [Boolean] whether or not the objects are considered the same
  #
  # source://yard//lib/yard/code_objects/base.rb#323
  def ==(other); end

  # Accesses a custom attribute on the object
  #
  # @param key [#to_s] the name of the custom attribute
  # @return [Object, nil] the custom attribute or nil if not found.
  # @see #[]=
  #
  # source://yard//lib/yard/code_objects/base.rb#343
  def [](key); end

  # Sets a custom attribute on the object
  #
  # @param key [#to_s] the name of the custom attribute
  # @param value [Object] the value to associate
  # @return [void]
  # @see #[]
  #
  # source://yard//lib/yard/code_objects/base.rb#356
  def []=(key, value); end

  # Associates a file with a code object, optionally adding the line where it was defined.
  # By convention, '<stdin>' should be used to associate code that comes form standard input.
  #
  # @param file [String] the filename ('<stdin>' for standard input)
  # @param line [Fixnum, nil] the line number where the object lies in the file
  # @param has_comments [Boolean] whether or not the definition has comments associated. This
  #   will allow {#file} to return the definition where the comments were made instead
  #   of any empty definitions that might have been parsed before (module namespaces for instance).
  # @raise [ArgumentError]
  #
  # source://yard//lib/yard/code_objects/base.rb#290
  def add_file(file, line = T.unsafe(nil), has_comments = T.unsafe(nil)); end

  # Add tags to the {#docstring}
  #
  # @see Docstring#add_tag
  # @since 0.8.4
  #
  # source://yard//lib/yard/code_objects/base.rb#561
  def add_tag(*tags); end

  # The non-localized documentation string associated with the object
  #
  # @return [Docstring] the documentation string
  # @since 0.8.4
  #
  # source://yard//lib/yard/code_objects/base.rb#166
  def base_docstring; end

  # Copies all data in this object to another code object, except for
  # uniquely identifying information (path, namespace, name, scope).
  #
  # @param other [Base] the object to copy data to
  # @return [Base] the other object
  # @since 0.8.0
  #
  # source://yard//lib/yard/code_objects/base.rb#263
  def copy_to(other); end

  # The documentation string associated with the object
  #
  # @param locale [String, I18n::Locale] (I18n::Locale.default)
  #   the locale of the documentation string.
  # @return [Docstring] the documentation string
  #
  # source://yard//lib/yard/code_objects/base.rb#405
  def docstring(locale = T.unsafe(nil)); end

  # Attaches a docstring to a code object by parsing the comments attached to the statement
  # and filling the {#tags} and {#docstring} methods with the parsed information.
  #
  # @param comments [String, Array<String>, Docstring] the comments attached to the code object to be parsed
  #   into a docstring and meta tags.
  #
  # source://yard//lib/yard/code_objects/base.rb#427
  def docstring=(comments); end

  # Marks whether or not the method is conditionally defined at runtime
  #
  # @return [Boolean] true if the method is conditionally defined at runtime
  #
  # source://yard//lib/yard/code_objects/base.rb#170
  def dynamic; end

  # Marks whether or not the method is conditionally defined at runtime
  #
  # @return [Boolean] true if the method is conditionally defined at runtime
  #
  # source://yard//lib/yard/code_objects/base.rb#170
  def dynamic=(_arg0); end

  # Is the object defined conditionally at runtime?
  #
  # @return [Boolean]
  # @see #dynamic
  #
  # source://yard//lib/yard/code_objects/base.rb#178
  def dynamic?; end

  # Tests if another object is equal to this, including a proxy
  #
  # @param other [Base, Proxy] if other is a {Proxy}, tests if
  #   the paths are equal
  # @return [Boolean] whether or not the objects are considered the same
  #
  # source://yard//lib/yard/code_objects/base.rb#323
  def eql?(other); end

  # Tests if another object is equal to this, including a proxy
  #
  # @param other [Base, Proxy] if other is a {Proxy}, tests if
  #   the paths are equal
  # @return [Boolean] whether or not the objects are considered the same
  #
  # source://yard//lib/yard/code_objects/base.rb#323
  def equal?(other); end

  # Returns the filename the object was first parsed at, taking
  # definitions with docstrings first.
  #
  # @return [String] a filename
  # @return [nil] if there is no file associated with the object
  #
  # source://yard//lib/yard/code_objects/base.rb#307
  def file; end

  # The files the object was defined in. To add a file, use {#add_file}.
  #
  # @return [Array<Array(String, Integer)>] a list of files
  # @see #add_file
  #
  # source://yard//lib/yard/code_objects/base.rb#137
  def files; end

  # Renders the object using the {Templates::Engine templating system}.
  #
  # @example Formats a class in plaintext
  #   puts P('MyClass').format
  # @example Formats a method in html with rdoc markup
  #   puts P('MyClass#meth').format(:format => :html, :markup => :rdoc)
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a set of options to pass to the template
  # @return [String] the rendered template
  # @see Templates::Engine#render
  #
  # source://yard//lib/yard/code_objects/base.rb#505
  def format(options = T.unsafe(nil)); end

  # @return [String] the group this object is associated with
  # @since 0.6.0
  #
  # source://yard//lib/yard/code_objects/base.rb#174
  def group; end

  # @return [String] the group this object is associated with
  # @since 0.6.0
  #
  # source://yard//lib/yard/code_objects/base.rb#174
  def group=(_arg0); end

  # Tests if the {#docstring} has a tag
  #
  # @return [Boolean]
  # @see Docstring#has_tag?
  #
  # source://yard//lib/yard/code_objects/base.rb#556
  def has_tag?(name); end

  # @return [Integer] the object's hash value (for equality checking)
  #
  # source://yard//lib/yard/code_objects/base.rb#334
  def hash; end

  # Inspects the object, returning the type and path
  #
  # @return [String] a string describing the object
  #
  # source://yard//lib/yard/code_objects/base.rb#513
  def inspect; end

  # Returns the line the object was first parsed at (or nil)
  #
  # @return [Fixnum] the line where the object was first defined.
  # @return [nil] if there is no line associated with the object
  #
  # source://yard//lib/yard/code_objects/base.rb#315
  def line; end

  # @overload dynamic_attr_name
  # @overload dynamic_attr_name=
  #
  # source://yard//lib/yard/code_objects/base.rb#373
  def method_missing(meth, *args, &block); end

  # The name of the object
  #
  # @param prefix [Boolean] whether to show a prefix. Implement
  #   this in a subclass to define how the prefix is showed.
  # @return [Symbol] if prefix is false, the symbolized name
  # @return [String] if prefix is true, prefix + the name as a String.
  #   This must be implemented by the subclass.
  #
  # source://yard//lib/yard/code_objects/base.rb#278
  def name(prefix = T.unsafe(nil)); end

  # The namespace the object is defined in. If the object is in the
  # top level namespace, this is {Registry.root}
  #
  # @return [NamespaceObject] the namespace object
  #
  # source://yard//lib/yard/code_objects/base.rb#142
  def namespace; end

  # Sets the namespace the object is defined in.
  #
  # @param obj [NamespaceObject, :root, nil] the new namespace (:root
  #   for {Registry.root}). If obj is nil, the object is unregistered
  #   from the Registry.
  #
  # source://yard//lib/yard/code_objects/base.rb#522
  def namespace=(obj); end

  # The namespace the object is defined in. If the object is in the
  # top level namespace, this is {Registry.root}
  #
  # @return [NamespaceObject] the namespace object
  #
  # source://yard//lib/yard/code_objects/base.rb#142
  def parent; end

  # Sets the namespace the object is defined in.
  #
  # @param obj [NamespaceObject, :root, nil] the new namespace (:root
  #   for {Registry.root}). If obj is nil, the object is unregistered
  #   from the Registry.
  #
  # source://yard//lib/yard/code_objects/base.rb#522
  def parent=(obj); end

  # Represents the unique path of the object. The default implementation
  # joins the path of {#namespace} with {#name} via the value of {#sep}.
  # Custom code objects should ensure that the path is unique to the code
  # object by either overriding {#sep} or this method.
  #
  # @example The path of an instance method
  #   MethodObject.new(P("A::B"), :c).path # => "A::B#c"
  # @return [String] the unique path of the object
  # @see #sep
  #
  # source://yard//lib/yard/code_objects/base.rb#453
  def path; end

  # @param other [Base, String] another code object (or object path)
  # @return [String] the shortest relative path from this object to +other+
  # @since 0.5.3
  #
  # source://yard//lib/yard/code_objects/base.rb#475
  def relative_path(other); end

  # @return [Boolean] whether or not this object is a RootObject
  #
  # source://yard//lib/yard/code_objects/base.rb#567
  def root?; end

  # Override this method with a custom component separator. For instance,
  # {MethodObject} implements sep as '#' or '.' (depending on if the
  # method is instance or class respectively). {#path} depends on this
  # value to generate the full path in the form: namespace.path + sep + name
  #
  # @return [String] the component that separates the namespace path
  #   and the name (default is {NSEP})
  #
  # source://yard//lib/yard/code_objects/base.rb#576
  def sep; end

  # The one line signature representing an object. For a method, this will
  # be of the form "def meth(arguments...)". This is usually the first
  # source line.
  #
  # @return [String] a line of source
  #
  # source://yard//lib/yard/code_objects/base.rb#159
  def signature; end

  # The one line signature representing an object. For a method, this will
  # be of the form "def meth(arguments...)". This is usually the first
  # source line.
  #
  # @return [String] a line of source
  #
  # source://yard//lib/yard/code_objects/base.rb#159
  def signature=(_arg0); end

  # The source code associated with the object
  #
  # @return [String, nil] source, if present, or nil
  #
  # source://yard//lib/yard/code_objects/base.rb#146
  def source; end

  # Attaches source code to a code object with an optional file location
  #
  # @param statement [#source, String] the +Parser::Statement+ holding the source code or the raw source
  #   as a +String+ for the definition of the code object only (not the block)
  #
  # source://yard//lib/yard/code_objects/base.rb#388
  def source=(statement); end

  # Language of the source code associated with the object. Defaults to
  # +:ruby+.
  #
  # @return [Symbol] the language type
  #
  # source://yard//lib/yard/code_objects/base.rb#152
  def source_type; end

  # Language of the source code associated with the object. Defaults to
  # +:ruby+.
  #
  # @return [Symbol] the language type
  #
  # source://yard//lib/yard/code_objects/base.rb#152
  def source_type=(_arg0); end

  # Gets a tag from the {#docstring}
  #
  # @see Docstring#tag
  #
  # source://yard//lib/yard/code_objects/base.rb#548
  def tag(name); end

  # Gets a list of tags from the {#docstring}
  #
  # @see Docstring#tags
  #
  # source://yard//lib/yard/code_objects/base.rb#552
  def tags(name = T.unsafe(nil)); end

  # @note Override this method if your object has a special title that does
  #   not match the {#path} attribute value. This title will be used
  #   when linking or displaying the object.
  # @return [String] the display title for an object
  # @see 0.8.4
  #
  # source://yard//lib/yard/code_objects/base.rb#468
  def title; end

  # @return [nil] this object does not turn into an array
  #
  # source://yard//lib/yard/code_objects/base.rb#337
  def to_ary; end

  # Represents the unique path of the object. The default implementation
  # joins the path of {#namespace} with {#name} via the value of {#sep}.
  # Custom code objects should ensure that the path is unique to the code
  # object by either overriding {#sep} or this method.
  #
  # @example The path of an instance method
  #   MethodObject.new(P("A::B"), :c).path # => "A::B#c"
  # @return [String] the unique path of the object
  # @see #sep
  #
  # source://yard//lib/yard/code_objects/base.rb#453
  def to_s; end

  # Default type is the lowercase class name without the "Object" suffix.
  # Override this method to provide a custom object type
  #
  # @return [Symbol] the type of code object this represents
  #
  # source://yard//lib/yard/code_objects/base.rb#437
  def type; end

  # @return [Symbol] the visibility of an object (:public, :private, :protected)
  #
  # source://yard//lib/yard/code_objects/base.rb#181
  def visibility; end

  # @return [Symbol] the visibility of an object (:public, :private, :protected)
  #
  # source://yard//lib/yard/code_objects/base.rb#183
  def visibility=(v); end

  protected

  # Override this method if your code object subclass does not allow
  # copying of certain attributes.
  #
  # @return [Array<String>] the list of instance variable names (without
  #   "@" prefix) that should be copied when {#copy_to} is called
  # @see #copy_to
  # @since 0.8.0
  #
  # source://yard//lib/yard/code_objects/base.rb#587
  def copyable_attributes; end

  private

  # Formats source code by removing leading indentation
  #
  # @param source [String] the source code to format
  # @return [String] formatted source
  #
  # source://yard//lib/yard/code_objects/base.rb#599
  def format_source(source); end

  # source://yard//lib/yard/code_objects/base.rb#606
  def translate_docstring(locale); end

  class << self
    # Compares the class with subclasses
    #
    # @param other [Object] the other object to compare classes with
    # @return [Boolean] true if other is a subclass of self
    #
    # source://yard//lib/yard/code_objects/base.rb#219
    def ===(other); end

    # Allocates a new code object
    #
    # @raise [ArgumentError]
    # @return [Base]
    # @see #initialize
    # @yield [obj]
    #
    # source://yard//lib/yard/code_objects/base.rb#189
    def new(namespace, name, *args, &block); end
  end
end

# Regular expression to match constant name
#
# source://yard//lib/yard/code_objects/base.rb#52
YARD::CodeObjects::CONSTANTMATCH = T.let(T.unsafe(nil), Regexp)

# Regular expression to match the beginning of a constant
#
# source://yard//lib/yard/code_objects/base.rb#55
YARD::CodeObjects::CONSTANTSTART = T.let(T.unsafe(nil), Regexp)

# Class method separator
#
# source://yard//lib/yard/code_objects/base.rb#46
YARD::CodeObjects::CSEP = T.let(T.unsafe(nil), String)

# Regex-quoted class method separator
#
# source://yard//lib/yard/code_objects/base.rb#49
YARD::CodeObjects::CSEPQ = T.let(T.unsafe(nil), String)

# A ClassObject represents a Ruby class in source code. It is a {ModuleObject}
# with extra inheritance semantics through the superclass.
#
# source://yard//lib/yard/code_objects/class_object.rb#7
class YARD::CodeObjects::ClassObject < ::YARD::CodeObjects::NamespaceObject
  # Creates a new class object in +namespace+ with +name+
  #
  # @return [ClassObject] a new instance of ClassObject
  # @see Base.new
  #
  # source://yard//lib/yard/code_objects/class_object.rb#15
  def initialize(namespace, name, *args, &block); end

  # Returns the list of constants matching the options hash.
  #
  # @option opts
  # @option opts
  # @param opts [Hash] the options hash to match
  # @return [Array<ConstantObject>] the list of constant that matched
  #
  # source://yard//lib/yard/code_objects/class_object.rb#101
  def constants(opts = T.unsafe(nil)); end

  # Returns the inheritance tree of the object including self.
  #
  # @param include_mods [Boolean] whether or not to include mixins in the
  #   inheritance tree.
  # @return [Array<NamespaceObject>] the list of code objects that make up
  #   the inheritance tree.
  #
  # source://yard//lib/yard/code_objects/class_object.rb#45
  def inheritance_tree(include_mods = T.unsafe(nil)); end

  # Returns only the constants that were inherited.
  #
  # @return [Array<ConstantObject>] the list of inherited constant objects
  #
  # source://yard//lib/yard/code_objects/class_object.rb#109
  def inherited_constants; end

  # Returns only the methods that were inherited.
  #
  # @return [Array<MethodObject>] the list of inherited method objects
  #
  # source://yard//lib/yard/code_objects/class_object.rb#79
  def inherited_meths(opts = T.unsafe(nil)); end

  # Whether or not the class is a Ruby Exception
  #
  # @return [Boolean] whether the object represents a Ruby exception
  #
  # source://yard//lib/yard/code_objects/class_object.rb#35
  def is_exception?; end

  # Returns the list of methods matching the options hash. Returns
  # all methods if hash is empty.
  #
  # @option opts
  # @option opts
  # @param opts [Hash] the options hash to match
  # @return [Array<MethodObject>] the list of methods that matched
  #
  # source://yard//lib/yard/code_objects/class_object.rb#66
  def meths(opts = T.unsafe(nil)); end

  # The {ClassObject} that this class object inherits from in Ruby source.
  #
  # @return [ClassObject] a class object that is the superclass of this one
  #
  # source://yard//lib/yard/code_objects/class_object.rb#10
  def superclass; end

  # Sets the superclass of the object
  #
  # @param object [Base, Proxy, String, Symbol, nil] the superclass value
  # @return [void]
  #
  # source://yard//lib/yard/code_objects/class_object.rb#125
  def superclass=(object); end
end

# Represents a class variable inside a namespace. The path is expressed
# in the form "A::B::@@classvariable"
#
# source://yard//lib/yard/code_objects/class_variable_object.rb#7
class YARD::CodeObjects::ClassVariableObject < ::YARD::CodeObjects::Base
  # @return [String] the class variable's value
  #
  # source://yard//lib/yard/code_objects/class_variable_object.rb#9
  def value; end

  # @return [String] the class variable's value
  #
  # source://yard//lib/yard/code_objects/class_variable_object.rb#9
  def value=(_arg0); end
end

# A list of code objects. This array acts like a set (no unique items)
# but also disallows any {Proxy} objects from being added.
#
# source://yard//lib/yard/code_objects/base.rb#6
class YARD::CodeObjects::CodeObjectList < ::Array
  # Creates a new object list associated with a namespace
  #
  # @param owner [NamespaceObject] the namespace the list should be associated with
  # @return [CodeObjectList]
  #
  # source://yard//lib/yard/code_objects/base.rb#11
  def initialize(owner = T.unsafe(nil)); end

  # Adds a new value to the list
  #
  # @param value [Base] a code object to add
  # @return [CodeObjectList] self
  #
  # source://yard//lib/yard/code_objects/base.rb#19
  def <<(value); end

  # Adds a new value to the list
  #
  # @param value [Base] a code object to add
  # @return [CodeObjectList] self
  #
  # source://yard//lib/yard/code_objects/base.rb#19
  def push(value); end
end

# A +ConstantObject+ represents a Ruby constant (not a module or class).
# To access the constant's (source code) value, use {#value}.
#
# source://yard//lib/yard/code_objects/constant_object.rb#7
class YARD::CodeObjects::ConstantObject < ::YARD::CodeObjects::Base
  # The source code representing the constant's value
  #
  # @return [String] the value the constant is set to
  #
  # source://yard//lib/yard/code_objects/constant_object.rb#10
  def value; end

  # source://yard//lib/yard/code_objects/constant_object.rb#12
  def value=(value); end
end

# Represents an instance method of a module that was mixed into the class
# scope of another namespace.
#
# @see MethodObject
#
# source://yard//lib/yard/code_objects/extended_method_object.rb#7
class YARD::CodeObjects::ExtendedMethodObject
  # Sets up a delegate for {MethodObject} obj.
  #
  # @param obj [MethodObject] the instance method to treat as a mixed in
  #   class method on another namespace.
  # @return [ExtendedMethodObject] a new instance of ExtendedMethodObject
  #
  # source://yard//lib/yard/code_objects/extended_method_object.rb#17
  def initialize(obj); end

  # Sends all methods to the {MethodObject} assigned in {#initialize}
  #
  # @see #initialize
  # @see MethodObject
  #
  # source://yard//lib/yard/code_objects/extended_method_object.rb#22
  def method_missing(sym, *args, &block); end

  # @return [Symbol] always +:class+
  #
  # source://yard//lib/yard/code_objects/extended_method_object.rb#11
  def scope; end
end

# An ExtraFileObject represents an extra documentation file (README or other
# file). It is not strictly a CodeObject (does not inherit from `Base`) although
# it implements `path`, `name` and `type`, and therefore should be structurally
# compatible with most CodeObject interfaces.
#
# source://yard//lib/yard/code_objects/extra_file_object.rb#7
class YARD::CodeObjects::ExtraFileObject
  # Creates a new extra file object.
  #
  # @param filename [String] the location on disk of the file
  # @param contents [String] the file contents. If not set, the contents
  #   will be read from disk using the +filename+.
  # @return [ExtraFileObject] a new instance of ExtraFileObject
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#18
  def initialize(filename, contents = T.unsafe(nil)); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#64
  def ==(other); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#30
  def attributes; end

  # Sets the attribute attributes
  #
  # @param value the value to set the attribute attributes to.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#9
  def attributes=(_arg0); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#39
  def contents; end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#44
  def contents=(contents); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#64
  def eql?(other); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#64
  def equal?(other); end

  # Returns the value of attribute filename.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#8
  def filename; end

  # Sets the attribute filename
  #
  # @param value the value to set the attribute filename to.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#8
  def filename=(_arg0); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#70
  def hash; end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#57
  def inspect; end

  # @since 0.8.3
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#12
  def locale; end

  # @param locale [String] the locale name to be translated.
  # @return [void]
  # @since 0.8.3
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#52
  def locale=(locale); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#10
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#10
  def name=(_arg0); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#10
  def path; end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#35
  def title; end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#57
  def to_s; end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#62
  def type; end

  private

  # source://yard//lib/yard/code_objects/extra_file_object.rb#74
  def ensure_parsed; end

  # @param data [String] the file contents
  #
  # source://yard//lib/yard/code_objects/extra_file_object.rb#81
  def parse_contents(data); end

  # source://yard//lib/yard/code_objects/extra_file_object.rb#129
  def translate(data); end
end

# Instance method separator
#
# source://yard//lib/yard/code_objects/base.rb#40
YARD::CodeObjects::ISEP = T.let(T.unsafe(nil), String)

# Regex-quoted instance method separator
#
# source://yard//lib/yard/code_objects/base.rb#43
YARD::CodeObjects::ISEPQ = T.let(T.unsafe(nil), String)

# Regular expression to match a fully qualified method def (self.foo, Class.foo).
#
# source://yard//lib/yard/code_objects/base.rb#64
YARD::CodeObjects::METHODMATCH = T.let(T.unsafe(nil), Regexp)

# Regular expression to match a method name
#
# source://yard//lib/yard/code_objects/base.rb#61
YARD::CodeObjects::METHODNAMEMATCH = T.let(T.unsafe(nil), Regexp)

# A MacroObject represents a docstring defined through +@!macro NAME+ and can be
# reused by specifying the tag +@!macro NAME+. You can also provide the
# +attached+ type flag to the macro definition to have it attached to the
# specific DSL method so it will be implicitly reused.
#
# Macros are fully described in the {file:docs/Tags.md#macro Tags Overview}
# document.
#
# @example Creating a basic named macro
#   # @!macro prop
#   #   @!method $1(${3-})
#   #   @return [$2] the value of the $0
#   property :foo, String, :a, :b
#
#   # @!macro prop
#   property :bar, Numeric, :value
# @example Creating a macro that is attached to the method call
#   # @!macro [attach] prop2
#   #   @!method $1(value)
#   property :foo
#
#   # Extra data added to docstring
#   property :bar
#
# source://yard//lib/yard/code_objects/macro_object.rb#29
class YARD::CodeObjects::MacroObject < ::YARD::CodeObjects::Base
  # @return [Boolean] whether this macro is attached to a method
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#148
  def attached?; end

  # Expands the macro using
  #
  # @example Expanding a Macro
  #   macro.expand(%w(property foo bar), 'property :foo, :bar', '') #=>
  #   "...macro data interpolating this line of code..."
  # @param call_params [Array<String>] a list of tokens that are passed
  #   to the method call
  # @param full_source [String] the full method call (not including the block)
  # @param block_source [String] the source passed in the block of the method
  #   call, if there is a block.
  # @see expand
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#166
  def expand(call_params = T.unsafe(nil), full_source = T.unsafe(nil), block_source = T.unsafe(nil)); end

  # @return [String] the macro data stored on the object
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#141
  def macro_data; end

  # @return [String] the macro data stored on the object
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#141
  def macro_data=(_arg0); end

  # @return [CodeObjects::Base] the method object that this macro is
  #   attached to.
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#145
  def method_object; end

  # @return [CodeObjects::Base] the method object that this macro is
  #   attached to.
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#145
  def method_object=(_arg0); end

  # Overrides {Base#path} so the macro path is ".macro.MACRONAME"
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#151
  def path; end

  # Overrides the separator to be '.'
  #
  # source://yard//lib/yard/code_objects/macro_object.rb#154
  def sep; end

  class << self
    # Applies a macro on a docstring by creating any macro data inside of
    # the docstring first. Equivalent to calling {find_or_create} and {apply_macro}
    # on the new macro object.
    #
    # @param docstring [Docstring] the docstring to create a macro out of
    # @param call_params [Array<String>] the method name and parameters
    #   to the method call. These arguments will fill $0-N
    # @param full_source [String] the full source line (excluding block)
    #   interpolated as $*
    # @param block_source [String] Currently unused. Will support
    #   interpolating the block data as a variable.
    # @return [String] the expanded macro data
    # @see find_or_create
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#119
    def apply(docstring, call_params = T.unsafe(nil), full_source = T.unsafe(nil), block_source = T.unsafe(nil), _method_object = T.unsafe(nil)); end

    # Applies a macro to a docstring, interpolating the macro's data on the
    # docstring and appending any extra local docstring data that was in
    # the original +docstring+ object.
    #
    # @param macro [MacroObject] the macro object
    # @param call_params [Array<String>] the method name and parameters
    #   to the method call. These arguments will fill $0-N
    # @param full_source [String] the full source line (excluding block)
    #   interpolated as $*
    # @param block_source [String] Currently unused. Will support
    #   interpolating the block data as a variable.
    # @return [String] the expanded macro data
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#135
    def apply_macro(macro, docstring, call_params = T.unsafe(nil), full_source = T.unsafe(nil), block_source = T.unsafe(nil)); end

    # Creates a new macro and fills in the relevant properties.
    #
    # @param macro_name [String] the name of the macro, must be unique.
    # @param data [String] the data the macro should expand when re-used
    # @param method_object [CodeObjects::Base] an object to attach this
    #   macro to. If supplied, {#attached?} will be true
    # @return [MacroObject] the newly created object
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#39
    def create(macro_name, data, method_object = T.unsafe(nil)); end

    # Parses a given docstring and determines if the macro is "new" or
    # not. If the macro has $variable names or if it has a @!macro tag
    # with the [new] or [attached] flag, it is considered new.
    #
    # If a new macro is found, the macro is created and registered. Otherwise
    # the macro name is searched and returned. If a macro is not found,
    # nil is returned.
    #
    # @param macro_name [#to_s] the name of the macro
    # @param method_object [CodeObjects::Base] an optional method to attach
    #   the macro to. Only used if the macro is being created, otherwise
    #   this argument is ignored.
    # @return [MacroObject] the newly created or existing macro, depending
    #   on whether the @!macro tag was a new tag or not.
    # @return [nil] if the +data+ has no macro tag or if the macro is
    #   not new and no macro by the macro name is found.
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#70
    def create_docstring(macro_name, data, method_object = T.unsafe(nil)); end

    # Expands +macro_data+ using the interpolation parameters.
    #
    # Interpolation rules:
    # * $0, $1, $2, ... = the Nth parameter in +call_params+
    # * $* = the full statement source (excluding block)
    # * Also supports $!{N-M} ranges, as well as negative indexes on N or M
    # * Use \$ to escape the variable name in a macro.
    #
    # @param macro_data [String] the macro data to expand (taken from {#macro_data})
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#92
    def expand(macro_data, call_params = T.unsafe(nil), full_source = T.unsafe(nil), block_source = T.unsafe(nil)); end

    # Finds a macro using +macro_name+
    #
    # @param macro_name [#to_s] the name of the macro
    # @return [MacroObject] if a macro is found
    # @return [nil] if there is no registered macro by that name
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#50
    def find(macro_name); end

    # Parses a given docstring and determines if the macro is "new" or
    # not. If the macro has $variable names or if it has a @!macro tag
    # with the [new] or [attached] flag, it is considered new.
    #
    # If a new macro is found, the macro is created and registered. Otherwise
    # the macro name is searched and returned. If a macro is not found,
    # nil is returned.
    #
    # @param macro_name [#to_s] the name of the macro
    # @param method_object [CodeObjects::Base] an optional method to attach
    #   the macro to. Only used if the macro is being created, otherwise
    #   this argument is ignored.
    # @return [MacroObject] the newly created or existing macro, depending
    #   on whether the @!macro tag was a new tag or not.
    # @return [nil] if the +data+ has no macro tag or if the macro is
    #   not new and no macro by the macro name is found.
    #
    # source://yard//lib/yard/code_objects/macro_object.rb#70
    def find_or_create(macro_name, data, method_object = T.unsafe(nil)); end
  end
end

# source://yard//lib/yard/code_objects/macro_object.rb#30
YARD::CodeObjects::MacroObject::MACRO_MATCH = T.let(T.unsafe(nil), Regexp)

# Represents a Ruby method in source
#
# source://yard//lib/yard/code_objects/method_object.rb#7
class YARD::CodeObjects::MethodObject < ::YARD::CodeObjects::Base
  # Creates a new method object in +namespace+ with +name+ and an instance
  # or class +scope+
  #
  # If scope is +:module+, this object is instantiated as a public
  # method in +:class+ scope, but also creates a new (empty) method
  # as a private +:instance+ method on the same class or module.
  #
  # @param namespace [NamespaceObject] the namespace
  # @param name [String, Symbol] the method name
  # @param scope [Symbol] +:instance+, +:class+, or +:module+
  # @return [MethodObject] a new instance of MethodObject
  #
  # source://yard//lib/yard/code_objects/method_object.rb#37
  def initialize(namespace, name, scope = T.unsafe(nil), &block); end

  # Returns all alias names of the object
  #
  # @return [Array<MethodObject>] the alias names
  #
  # source://yard//lib/yard/code_objects/method_object.rb#149
  def aliases; end

  # Returns the read/writer info for the attribute if it is one
  #
  # @return [SymbolHash] if there is information about the attribute
  # @return [nil] if the method is not an attribute
  # @since 0.5.3
  #
  # source://yard//lib/yard/code_objects/method_object.rb#93
  def attr_info; end

  # @return [Boolean] whether or not the method is the #initialize constructor method
  #
  # source://yard//lib/yard/code_objects/method_object.rb#78
  def constructor?; end

  # Whether the object is explicitly defined in source or whether it was
  # inferred by a handler. For instance, attribute methods are generally
  # inferred and therefore not explicitly defined in source.
  #
  # @return [Boolean] whether the object is explicitly defined in source.
  #
  # source://yard//lib/yard/code_objects/method_object.rb#18
  def explicit; end

  # Whether the object is explicitly defined in source or whether it was
  # inferred by a handler. For instance, attribute methods are generally
  # inferred and therefore not explicitly defined in source.
  #
  # @return [Boolean] whether the object is explicitly defined in source.
  #
  # source://yard//lib/yard/code_objects/method_object.rb#18
  def explicit=(_arg0); end

  # Tests if the object is defined as an alias of another method
  #
  # @return [Boolean] whether the object is an alias
  #
  # source://yard//lib/yard/code_objects/method_object.rb#126
  def is_alias?; end

  # Tests if the object is defined as an attribute in the namespace
  #
  # @return [Boolean] whether the object is an attribute
  #
  # source://yard//lib/yard/code_objects/method_object.rb#114
  def is_attribute?; end

  # Tests boolean {#explicit} value.
  #
  # @return [Boolean] whether the method is explicitly defined in source
  #
  # source://yard//lib/yard/code_objects/method_object.rb#134
  def is_explicit?; end

  # @return [Boolean] whether or not this method was created as a module
  #   function
  # @since 0.8.0
  #
  # source://yard//lib/yard/code_objects/method_object.rb#85
  def module_function?; end

  # Returns the name of the object.
  #
  # @example The name of an instance method (with prefix)
  #   an_instance_method.name(true) # => "#mymethod"
  # @example The name of a class method (with prefix)
  #   a_class_method.name(true) # => "mymethod"
  # @param prefix [Boolean] whether or not to show the prefix
  # @return [String] returns {#sep} + +name+ for an instance method if
  #   prefix is true
  # @return [Symbol] the name without {#sep} if prefix is set to false
  #
  # source://yard//lib/yard/code_objects/method_object.rb#175
  def name(prefix = T.unsafe(nil)); end

  # @return [MethodObject] the object that this method overrides
  # @return [nil] if it does not override a method
  # @since 0.6.0
  #
  # source://yard//lib/yard/code_objects/method_object.rb#141
  def overridden_method; end

  # Returns the list of parameters parsed out of the method signature
  # with their default values.
  #
  # @return [Array<Array(String, String)>] a list of parameter names followed
  #   by their default values (or nil)
  #
  # source://yard//lib/yard/code_objects/method_object.rb#25
  def parameters; end

  # Returns the list of parameters parsed out of the method signature
  # with their default values.
  #
  # @return [Array<Array(String, String)>] a list of parameter names followed
  #   by their default values (or nil)
  #
  # source://yard//lib/yard/code_objects/method_object.rb#25
  def parameters=(_arg0); end

  # Override path handling for instance methods in the root namespace
  # (they should still have a separator as a prefix).
  #
  # @return [String] the path of a method
  #
  # source://yard//lib/yard/code_objects/method_object.rb#161
  def path; end

  # @return [Boolean] whether the method is a reader attribute
  # @since 0.5.3
  #
  # source://yard//lib/yard/code_objects/method_object.rb#107
  def reader?; end

  # The scope of the method (+:class+ or +:instance+)
  #
  # @return [Symbol] the scope
  #
  # source://yard//lib/yard/code_objects/method_object.rb#11
  def scope; end

  # Changes the scope of an object from :instance or :class
  #
  # @param v [Symbol] the new scope
  #
  # source://yard//lib/yard/code_objects/method_object.rb#58
  def scope=(v); end

  # Override separator to differentiate between class and instance
  # methods.
  #
  # @return [String] "#" for an instance method, "." for class
  #
  # source://yard//lib/yard/code_objects/method_object.rb#182
  def sep; end

  # @return [Boolean] whether the method is a writer attribute
  # @since 0.5.3
  #
  # source://yard//lib/yard/code_objects/method_object.rb#100
  def writer?; end

  protected

  # source://yard//lib/yard/code_objects/method_object.rb#192
  def copyable_attributes; end
end

# Represents a Ruby module.
#
# source://yard//lib/yard/code_objects/module_object.rb#6
class YARD::CodeObjects::ModuleObject < ::YARD::CodeObjects::NamespaceObject
  # Returns the inheritance tree of mixins.
  #
  # @param include_mods [Boolean] if true, will include mixed in
  #   modules (which is likely what is wanted).
  # @return [Array<NamespaceObject>] a list of namespace objects
  #
  # source://yard//lib/yard/code_objects/module_object.rb#12
  def inheritance_tree(include_mods = T.unsafe(nil)); end
end

# Regular expression to match namespaces (const A or complex path A::B)
#
# source://yard//lib/yard/code_objects/base.rb#58
YARD::CodeObjects::NAMESPACEMATCH = T.let(T.unsafe(nil), Regexp)

# Namespace separator
#
# source://yard//lib/yard/code_objects/base.rb#34
YARD::CodeObjects::NSEP = T.let(T.unsafe(nil), String)

# Regex-quoted namespace separator
#
# source://yard//lib/yard/code_objects/base.rb#37
YARD::CodeObjects::NSEPQ = T.let(T.unsafe(nil), String)

# This module controls registration and accessing of namespace separators
# for {Registry} lookup.
#
# @since 0.9.1
#
# source://yard//lib/yard/code_objects/namespace_mapper.rb#8
module YARD::CodeObjects::NamespaceMapper
  # Clears the map of separators.
  #
  # @return [void]
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#55
  def clear_separators; end

  # Gets or sets the default separator value to use when no
  # separator for the namespace can be determined.
  #
  # @example
  #   default_separator "::"
  # @param value [String, nil] the default separator, or nil to return the
  #   value
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#68
  def default_separator(value = T.unsafe(nil)); end

  # Registers a separator with an optional set of valid types that
  # must follow the separator lexically.
  #
  # Calls all callbacks defined by {NamespaceMapper.on_invalidate} after
  # the separator is registered.
  #
  # @example Registering separators for a method object
  #   # Anything after a "#" denotes a method object
  #   register_separator "#", :method
  #   # Anything after a "." denotes a method object
  #   register_separator ".", :method
  # @param sep [String] the separator string for the namespace
  # @param valid_types [Array<Symbol>] a list of object types that
  #   must follow the separator. If the list is empty, any type can
  #   follow the separator.
  # @see .on_invalidate
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#27
  def register_separator(sep, *valid_types); end

  # @return [Array<String>] all of the registered separators
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#80
  def separators; end

  # @param type [String] the type to return separators for
  # @return [Array<Symbol>] a list of separators registered to a type
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#97
  def separators_for_type(type); end

  # @return [Regexp] the regexp match of all separators
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#85
  def separators_match; end

  # @param sep [String] the separator to return types for
  # @return [Array<Symbol>] a list of types registered to a separator
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#91
  def types_for_separator(sep); end

  # Unregisters a separator by a type.
  #
  # @param type [Symbol] the type to unregister
  # @see #register_separator
  # @since 0.9.1
  #
  # source://yard//lib/yard/code_objects/namespace_mapper.rb#43
  def unregister_separator_by_type(type); end

  class << self
    # @return [String] the default separator when no separator can begin
    #   determined.
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#137
    def default_separator; end

    # @return [String] the default separator when no separator can begin
    #   determined.
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#137
    def default_separator=(_arg0); end

    # Invalidates all separators
    #
    # @return [void]
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#125
    def invalidate; end

    # @return [Hash] a mapping of types to separators
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#114
    def map; end

    # @return [Regexp] the full list of separators as a regexp match
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#131
    def map_match; end

    # Adds a callback that triggers when a new separator is registered or
    # the cache is cleared by invalidation.
    #
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#107
    def on_invalidate(&block); end

    # @return [Hash] a reverse mapping of separators to types
    # @since 0.9.1
    #
    # source://yard//lib/yard/code_objects/namespace_mapper.rb#119
    def rev_map; end
  end
end

# A "namespace" is any object that can store other objects within itself.
# The two main Ruby objects that can act as namespaces are modules
# ({ModuleObject}) and classes ({ClassObject}).
#
# source://yard//lib/yard/code_objects/namespace_object.rb#9
class YARD::CodeObjects::NamespaceObject < ::YARD::CodeObjects::Base
  # Creates a new namespace object inside +namespace+ with +name+.
  #
  # @return [NamespaceObject] a new instance of NamespaceObject
  # @see Base#initialize
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#56
  def initialize(namespace, name, *args, &block); end

  # A hash containing two keys, :class and :instance, each containing
  # a hash of objects and their alias names.
  #
  # @return [Hash] a list of methods
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#44
  def aliases; end

  # A hash containing two keys, class and instance, each containing
  # the attribute name with a { :read, :write } hash for the read and
  # write objects respectively.
  #
  # @example The attributes of an object
  #   >> Registry.at('YARD::Docstring').attributes
  #   => {
  #   :class => { },
  #   :instance => {
  #   :ref_tags => {
  #   :read => #<yardoc method YARD::Docstring#ref_tags>,
  #   :write => nil
  #   },
  #   :object => {
  #   :read => #<yardoc method YARD::Docstring#object>,
  #   :write => #<yardoc method YARD::Docstring#object=>
  #   },
  #   ...
  #   }
  #   }
  # @return [Hash] a list of methods
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#39
  def attributes; end

  # Looks for a child that matches the attributes specified by +opts+.
  #
  # @example Finds a child by name and scope
  #   namespace.child(:name => :to_s, :scope => :instance)
  #   # => #<yardoc method MyClass#to_s>
  # @return [Base, nil] the first matched child object, or nil
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#86
  def child(opts = T.unsafe(nil)); end

  # The list of objects defined in this namespace
  #
  # @return [Array<Base>] a list of objects
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#16
  def children; end

  # Only the class attributes
  #
  # @return [Hash] a list of method names and their read/write objects
  # @see #attributes
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#69
  def class_attributes; end

  # Class mixins
  #
  # @return [Array<ModuleObject>] a list of mixins
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#48
  def class_mixins; end

  # Returns all constants in the namespace
  #
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [Array<ConstantObject>] a list of constant objects
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#164
  def constants(opts = T.unsafe(nil)); end

  # Returns class variables defined in this namespace.
  #
  # @return [Array<ClassVariableObject>] a list of class variable objects
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#186
  def cvars; end

  # @return [Array<String>] a list of ordered group names inside the namespace
  # @since 0.6.0
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#12
  def groups; end

  # @return [Array<String>] a list of ordered group names inside the namespace
  # @since 0.6.0
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#12
  def groups=(_arg0); end

  # Returns constants included from any mixins
  #
  # @return [Array<ConstantObject>] a list of constant objects
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#172
  def included_constants; end

  # Returns methods included from any mixins that match the attributes
  # specified by +opts+. If no options are specified, returns all included
  # methods.
  #
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @see #meths
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#144
  def included_meths(opts = T.unsafe(nil)); end

  # Only the instance attributes
  #
  # @return [Hash] a list of method names and their read/write objects
  # @see #attributes
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#76
  def instance_attributes; end

  # Instance mixins
  #
  # @return [Array<ModuleObject>] a list of mixins
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#52
  def instance_mixins; end

  # Returns all methods that match the attributes specified by +opts+. If
  # no options are provided, returns all methods.
  #
  # @example Finds all private and protected class methods
  #   namespace.meths(:visibility => [:private, :protected], :scope => :class)
  #   # => [#<yardoc method MyClass.privmeth>, #<yardoc method MyClass.protmeth>]
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [Array<MethodObject>] a list of method objects
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#113
  def meths(opts = T.unsafe(nil)); end

  # Returns for specific scopes. If no scopes are provided, returns all mixins.
  #
  # @param scopes [Array<Symbol>] a list of scopes (:class, :instance) to
  #   return mixins for. If this is empty, all scopes will be returned.
  # @return [Array<ModuleObject>] a list of mixins
  #
  # source://yard//lib/yard/code_objects/namespace_object.rb#194
  def mixins(*scopes); end
end

# @private
#
# source://yard//lib/yard/code_objects/proxy.rb#8
YARD::CodeObjects::PROXY_MATCH = T.let(T.unsafe(nil), Regexp)

# The Proxy class is a way to lazily resolve code objects in
# cases where the object may not yet exist. A proxy simply stores
# an unresolved path until a method is called on the object, at which
# point it does a lookup using {Registry.resolve}. If the object is
# not found, a warning is raised and {ProxyMethodError} might be raised.
#
# @example Creates a Proxy to the String class from a module
#   # When the String class is parsed this method will
#   # begin to act like the String ClassObject.
#   Proxy.new(mymoduleobj, "String")
# @see Registry.resolve
# @see ProxyMethodError
#
# source://yard//lib/yard/code_objects/proxy.rb#24
class YARD::CodeObjects::Proxy
  # Creates a new Proxy
  #
  # @raise [ArgumentError] if namespace is not a NamespaceObject
  # @return [Proxy] self
  #
  # source://yard//lib/yard/code_objects/proxy.rb#34
  def initialize(namespace, name, type = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#118
  def <=>(other); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#127
  def ==(other); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#113
  def ===(other); end

  # Returns the class name of the object the proxy is mimicking, if
  # resolved. Otherwise returns +Proxy+.
  #
  # @return [Class] the resolved object's class or +Proxy+
  #
  # source://yard//lib/yard/code_objects/proxy.rb#142
  def class; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#127
  def equal?(other); end

  # @return [Integer] the object's hash value (for equality checking)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#137
  def hash; end

  # Returns a text representation of the Proxy
  #
  # @return [String] the object's #inspect method or P(OBJECTPATH)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#91
  def inspect; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#161
  def instance_of?(klass); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#108
  def is_a?(klass); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#166
  def kind_of?(klass); end

  # Dispatches the method to the resolved object.
  #
  # @raise [ProxyMethodError] if the proxy cannot find the real object
  #
  # source://yard//lib/yard/code_objects/proxy.rb#178
  def method_missing(meth, *args, &block); end

  # The name of the object
  #
  # @param prefix [Boolean] whether to show a prefix. Implement
  #   this in a subclass to define how the prefix is showed.
  # @return [Symbol] if prefix is false, the symbolized name
  # @return [String] if prefix is true, prefix + the name as a String.
  #   This must be implemented by the subclass.
  #
  # source://yard//lib/yard/code_objects/proxy.rb#85
  def name(prefix = T.unsafe(nil)); end

  # Returns the value of attribute namespace.
  #
  # source://yard//lib/yard/code_objects/proxy.rb#27
  def namespace; end

  # Returns the value of attribute namespace.
  #
  # source://yard//lib/yard/code_objects/proxy.rb#27
  def parent; end

  # If the proxy resolves to an object, returns its path, otherwise
  # guesses at the correct path using the original namespace and name.
  #
  # @return [String] the assumed path of the proxy (or the real path
  #   of the resolved object)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#100
  def path; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#171
  def respond_to?(meth, include_private = T.unsafe(nil)); end

  # This class is never a root object
  #
  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#200
  def root?; end

  # If the proxy resolves to an object, returns its path, otherwise
  # guesses at the correct path using the original namespace and name.
  #
  # @return [String] the assumed path of the proxy (or the real path
  #   of the resolved object)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#100
  def title; end

  # If the proxy resolves to an object, returns its path, otherwise
  # guesses at the correct path using the original namespace and name.
  #
  # @return [String] the assumed path of the proxy (or the real path
  #   of the resolved object)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#100
  def to_s; end

  # If the proxy resolves to an object, returns its path, otherwise
  # guesses at the correct path using the original namespace and name.
  #
  # @return [String] the assumed path of the proxy (or the real path
  #   of the resolved object)
  #
  # source://yard//lib/yard/code_objects/proxy.rb#100
  def to_str; end

  # Returns the type of the proxy. If it cannot be resolved at the
  # time of the call, it will either return the inferred proxy type
  # (see {#type=}) or +:proxy+
  #
  # @return [Symbol] the Proxy's type
  # @see #type=
  #
  # source://yard//lib/yard/code_objects/proxy.rb#151
  def type; end

  # Allows a parser to infer the type of the proxy by its path.
  #
  # @param type [#to_sym] the proxy's inferred type
  # @return [void]
  #
  # source://yard//lib/yard/code_objects/proxy.rb#158
  def type=(type); end

  private

  # source://yard//lib/yard/code_objects/proxy.rb#228
  def proxy_path; end

  # @note this method fixes a bug in 1.9.2: http://gist.github.com/437136
  #
  # source://yard//lib/yard/code_objects/proxy.rb#205
  def to_ary; end

  # Attempts to find the object that this unresolved object
  # references by checking if any objects by this name are
  # registered all the way up the namespace tree.
  #
  # @return [Base, nil] the registered code object or nil
  #
  # source://yard//lib/yard/code_objects/proxy.rb#212
  def to_obj; end

  class << self
    # source://yard//lib/yard/code_objects/proxy.rb#25
    def ===(other); end
  end
end

# A special type of +NoMethodError+ when raised from a {Proxy}
#
# source://yard//lib/yard/code_objects/proxy.rb#5
class YARD::CodeObjects::ProxyMethodError < ::NoMethodError; end

# Represents the root namespace object (the invisible Ruby module that
# holds all top level modules, class and other objects).
#
# source://yard//lib/yard/code_objects/root_object.rb#6
class YARD::CodeObjects::RootObject < ::YARD::CodeObjects::ModuleObject
  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/root_object.rb#12
  def equal?(other); end

  # source://yard//lib/yard/code_objects/root_object.rb#16
  def hash; end

  # source://yard//lib/yard/code_objects/root_object.rb#8
  def inspect; end

  # source://yard//lib/yard/code_objects/root_object.rb#7
  def path; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/code_objects/root_object.rb#9
  def root?; end

  # source://yard//lib/yard/code_objects/root_object.rb#10
  def title; end
end

# This class maintains all system-wide configuration for YARD and handles
# the loading of plugins. To access options call {options}, and to load
# a plugin use {load_plugin}. All other public methods are used by YARD
# during load time.
#
# == User Configuration Files
#
# Persistent user configuration files can be stored in the file
# +~/.yard/config+, which is read when YARD first loads. The file should
# be formatted as YAML, and should contain a map of keys and values.
#
# Although you can specify any key-value mapping in the configuration file,
# YARD defines special keys specified in {DEFAULT_CONFIG_OPTIONS}.
#
# An example of a configuration file is listed below:
#
#     !!!yaml
#     load_plugins: true # Auto-load plugins when YARD starts
#     ignored_plugins:
#       - yard-broken
#       - broken2 # yard- prefix not necessary
#     autoload_plugins:
#       - yard-rspec
#
# == Automatic Loading of Plugins
#
# YARD 0.6.2 will no longer automatically load all plugins by default. This
# option can be reset by setting 'load_plugins' to true in the configuration
# file. In addition, you can specify a set of specific plugins to load on
# load through the 'autoload_plugins' list setting. This setting is
# independent of the 'load_plugins' value and will always be processed.
#
# == Ignored Plugins File
#
# YARD 0.5 and below used a +~/.yard/ignored_plugins+ file to specify
# plugins to be ignored at load time. Ignored plugins in 0.6.2 and above
# should now be specified in the main configuration file, though YARD
# will support the +ignored_plugins+ file until 0.7.x.
#
# == Safe Mode
#
# YARD supports running in safe-mode. By doing this, it will avoid executing
# any user code such as require files or queries. Plugins will still be
# loaded with safe mode on, because plugins are properly namespaced with
# a 'yard-' prefix, must be installed as a gem, and therefore cannot be
# touched by the user. To specify safe mode, use the +safe_mode+ key.
#
# == Plugin Specific Configuration
#
# Additional settings can be defined within the configuration file
# specifically to provide configuration for a plugin. A plugin that utilizes
# the YARD configuration is strongly encouraged to utilize namespacing of
# their configuration content.
#
#     !!!yaml
#     load_plugins: true # Auto-load plugins when YARD starts
#     ignored_plugins:
#       - yard-broken
#       - broken2 # yard- prefix not necessary
#     autoload_plugins:
#       - yard-rspec
#     # Plugin Specific Configuration
#     yard-sample-plugin:
#       show-results-inline: true
#
# As the configuration is available system wide, it can be
# accessed within the plugin code.
#
#
#     if YARD::Config.options['yard-sample-plugin'] and
#       YARD::Config.options['yard-sample-plugin']['show-results-inline']
#       # ... perform the action that places the results inline ...
#     else
#       # ... do the default behavior of not showing the results inline ...
#     end
#
# When accessing the configuration, be aware that this file is user managed
# so configuration keys and values may not be present. Make no assumptions and
# instead ensure that you check for the existence of keys before proceeding to
# retrieve values.
#
# @see options
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#86
class YARD::Config
  class << self
    # Legacy support for {IGNORED_PLUGINS}
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#221
    def add_ignored_plugins_file; end

    # @return [Array<String>] arguments from commandline and yardopts file
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#268
    def arguments; end

    # Loads settings from {CONFIG_FILE}. This method is called by YARD at
    # load time and should not be called by the user.
    #
    # @return [void]
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#119
    def load; end

    # Load plugins set in :autoload_plugins
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#189
    def load_autoload_plugins; end

    # Load plugins from {arguments}
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#194
    def load_commandline_plugins; end

    # Check for command-line safe_mode switch in {arguments}
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#204
    def load_commandline_safemode; end

    # Load gem plugins if :load_plugins is true
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#169
    def load_gem_plugins; end

    # Loads an individual plugin by name. It is not necessary to include the
    # +yard-+ plugin prefix here.
    #
    # @param name [String] the name of the plugin (with or without +yard-+ prefix)
    # @return [Boolean] whether the plugin was successfully loaded
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#157
    def load_plugin(name); end

    # Print a warning if the plugin failed to load
    #
    # @return [false]
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#214
    def load_plugin_failed(name, exception); end

    # Loads gems that match the name 'yard-*' (recommended) or 'yard_*' except
    # those listed in +~/.yard/ignored_plugins+. This is called immediately
    # after YARD is loaded to allow plugin support.
    #
    # @return [Boolean] true if all plugins loaded successfully, false otherwise.
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#146
    def load_plugins; end

    # The system-wide configuration options for YARD
    #
    # @return [SymbolHash] a map a key-value pair settings.
    # @see DEFAULT_CONFIG_OPTIONS
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#91
    def options; end

    # The system-wide configuration options for YARD
    #
    # @return [SymbolHash] a map a key-value pair settings.
    # @see DEFAULT_CONFIG_OPTIONS
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#91
    def options=(_arg0); end

    # Loads the YAML configuration file into memory
    #
    # @return [Hash] the contents of the YAML file from disk
    # @see CONFIG_FILE
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#236
    def read_config_file; end

    # Saves settings to {CONFIG_FILE}.
    #
    # @return [void]
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#135
    def save; end

    # Sanitizes and normalizes a plugin name to include the 'yard-' prefix.
    #
    # @param name [String] the plugin name
    # @return [String] the sanitized and normalized plugin name.
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#252
    def translate_plugin_name(name); end

    # Translates plugin names to add yard- prefix.
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#228
    def translate_plugin_names; end

    # Temporarily loads .yardopts file into @yardopts
    #
    # @since 0.6.2
    #
    # source://yard//lib/yard/config.rb#259
    def with_yardopts; end
  end
end

# The location where YARD stores user-specific settings
#
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#95
YARD::Config::CONFIG_DIR = T.let(T.unsafe(nil), String)

# The main configuration YAML file.
#
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#98
YARD::Config::CONFIG_FILE = T.let(T.unsafe(nil), String)

# Default configuration options
#
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#105
YARD::Config::DEFAULT_CONFIG_OPTIONS = T.let(T.unsafe(nil), Hash)

# File listing all ignored plugins
#
# @deprecated Set `ignored_plugins` in the {CONFIG_FILE} instead.
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#102
YARD::Config::IGNORED_PLUGINS = T.let(T.unsafe(nil), String)

# The prefix used for YARD plugins. Name your gem with this prefix
# to allow it to be used as a plugin.
#
# @since 0.6.2
#
# source://yard//lib/yard/config.rb#114
YARD::Config::YARD_PLUGIN_PREFIX = T.let(T.unsafe(nil), Regexp)

# A documentation string, or "docstring" for short, encapsulates the
# comments and metadata, or "tags", of an object. Meta-data is expressed
# in the form +@tag VALUE+, where VALUE can span over multiple lines as
# long as they are indented. The following +@example+ tag shows how tags
# can be indented:
#
#   # @example My example
#   #   a = "hello world"
#   #   a.reverse
#   # @version 1.0
#
# Tags can be nested in a documentation string, though the {Tags::Tag}
# itself is responsible for parsing the inner tags.
#
# source://yard//lib/yard/docstring.rb#16
class YARD::Docstring < ::String
  # Creates a new docstring with the raw contents attached to an optional
  # object. Parsing will be done by the {DocstringParser} class.
  #
  # @example
  #   Docstring.new("hello world\n@return Object return", someobj)
  # @note To properly parse directives with proper parser context within
  #   handlers, you should not use this method to create a Docstring.
  #   Instead, use the {parser}, which takes a handler object that
  #   can pass parser state onto directives. If a Docstring is created
  #   with this method, directives do not have access to any parser
  #   state, and may not function as expected.
  # @param content [String] the raw comments to be parsed into a docstring
  #   and associated meta-data.
  # @param object [CodeObjects::Base] an object to associate the docstring
  #   with.
  # @return [Docstring] a new instance of Docstring
  #
  # source://yard//lib/yard/docstring.rb#103
  def initialize(content = T.unsafe(nil), object = T.unsafe(nil)); end

  # Adds another {Docstring}, copying over tags.
  #
  # @param other [Docstring, String] the other docstring (or string) to
  #   add.
  # @return [Docstring] a new docstring with both docstrings combines
  #
  # source://yard//lib/yard/docstring.rb#116
  def +(other); end

  # Adds a tag or reftag object to the tag list. If you want to parse
  # tag data based on the {Tags::DefaultFactory} tag factory, use
  # {DocstringParser} instead.
  #
  # @param tags [Tags::Tag, Tags::RefTag] list of tag objects to add
  # @return [void]
  #
  # source://yard//lib/yard/docstring.rb#242
  def add_tag(*tags); end

  # @return [String] the raw documentation (including raw tag text)
  #
  # source://yard//lib/yard/docstring.rb#53
  def all; end

  # Replaces the docstring with new raw content. Called by {#all=}.
  #
  # @param content [String] the raw comments to be parsed
  #
  # source://yard//lib/yard/docstring.rb#132
  def all=(content, parse = T.unsafe(nil)); end

  # Returns true if the docstring has no content that is visible to a template.
  #
  # @param only_visible_tags [Boolean] whether only {Tags::Library.visible_tags}
  #   should be checked, or if all tags should be considered.
  # @return [Boolean] whether or not the docstring has content
  #
  # source://yard//lib/yard/docstring.rb#310
  def blank?(only_visible_tags = T.unsafe(nil)); end

  # Deletes all tags where the block returns true
  #
  # @return [void]
  # @since 0.7.0
  # @yieldparam tag [Tags::Tag] the tag that is being tested
  # @yieldreturn [Boolean] true if the tag should be deleted
  #
  # source://yard//lib/yard/docstring.rb#300
  def delete_tag_if(&block); end

  # Delete all tags with +name+
  #
  # @param name [String] the tag name
  # @return [void]
  # @since 0.7.0
  #
  # source://yard//lib/yard/docstring.rb#291
  def delete_tags(name); end

  # Deep-copies a docstring
  #
  # @note This method creates a new docstring with new tag lists, but does
  #   not create new individual tags. Modifying the tag objects will still
  #   affect the original tags.
  # @return [Docstring] a new copied docstring
  # @since 0.7.0
  #
  # source://yard//lib/yard/docstring.rb#153
  def dup; end

  # Returns true if at least one tag by the name +name+ was declared
  #
  # @param name [String] the tag name to search for
  # @return [Boolean] whether or not the tag +name+ was declared
  #
  # source://yard//lib/yard/docstring.rb#283
  def has_tag?(name); end

  # @return [Boolean] whether the docstring was started with "##"
  #
  # source://yard//lib/yard/docstring.rb#56
  def hash_flag; end

  # source://yard//lib/yard/docstring.rb#57
  def hash_flag=(v); end

  # @return [Fixnum] the first line of the {#line_range}
  # @return [nil] if there is no associated {#line_range}
  #
  # source://yard//lib/yard/docstring.rb#167
  def line; end

  # @return [Range] line range in the {#object}'s file where the docstring was parsed from
  #
  # source://yard//lib/yard/docstring.rb#50
  def line_range; end

  # @return [Range] line range in the {#object}'s file where the docstring was parsed from
  #
  # source://yard//lib/yard/docstring.rb#50
  def line_range=(_arg0); end

  # @return [CodeObjects::Base] the object that owns the docstring.
  #
  # source://yard//lib/yard/docstring.rb#47
  def object; end

  # @return [CodeObjects::Base] the object that owns the docstring.
  #
  # source://yard//lib/yard/docstring.rb#47
  def object=(_arg0); end

  # @return [Array<Tags::RefTag>] the list of reference tags
  #
  # source://yard//lib/yard/docstring.rb#44
  def ref_tags; end

  # Replaces the docstring with new raw content. Called by {#all=}.
  #
  # @param content [String] the raw comments to be parsed
  #
  # source://yard//lib/yard/docstring.rb#132
  def replace(content, parse = T.unsafe(nil)); end

  # Resolves unresolved other docstring reference if there is
  # unresolved reference. Does nothing if there is no unresolved
  # reference.
  #
  # Normally, you don't need to call this method
  # explicitly. Resolving unresolved reference is done implicitly.
  #
  # @return [void]
  #
  # source://yard//lib/yard/docstring.rb#328
  def resolve_reference; end

  # Gets the first line of a docstring to the period or the first paragraph.
  #
  # @return [String] The first line or paragraph of the docstring; always ends with a period.
  #
  # source://yard//lib/yard/docstring.rb#173
  def summary; end

  # Convenience method to return the first tag
  # object in the list of tag objects of that name
  #
  # @example
  #   doc = Docstring.new("@return zero when nil")
  #   doc.tag(:return).text  # => "zero when nil"
  # @param name [#to_s] the tag name to return data for
  # @return [Tags::Tag] the first tag in the list of {#tags}
  #
  # source://yard//lib/yard/docstring.rb#265
  def tag(name); end

  # Returns a list of tags specified by +name+ or all tags if +name+ is not specified.
  #
  # @param name [#to_s] the tag name to return data for, or nil for all tags
  # @return [Array<Tags::Tag>] the list of tags by the specified tag name
  #
  # source://yard//lib/yard/docstring.rb#273
  def tags(name = T.unsafe(nil)); end

  # Reformats and returns a raw representation of the tag data using the
  # current tag and docstring data, not the original text.
  #
  # @return [String] the updated raw formatted docstring data
  # @since 0.7.0
  # @todo Add Tags::Tag#to_raw and refactor
  #
  # source://yard//lib/yard/docstring.rb#207
  def to_raw; end

  # source://yard//lib/yard/docstring.rb#125
  def to_s; end

  private

  # Maps valid reference tags
  #
  # @return [Array<Tags::RefTag>] the list of valid reference tags
  #
  # source://yard//lib/yard/docstring.rb#344
  def convert_ref_tags; end

  # Parses out comments split by newlines into a new code object
  #
  # @param comments [String] the newline delimited array of comments. If the comments
  #   are passed as a String, they will be split by newlines.
  # @return [String] the non-metadata portion of the comments to
  #   be used as a docstring
  #
  # source://yard//lib/yard/docstring.rb#369
  def parse_comments(comments); end

  # A stable sort_by method.
  #
  # @param list [Enumerable] the list to sort.
  # @return [Array] a stable sorted list.
  #
  # source://yard//lib/yard/docstring.rb#382
  def stable_sort_by(list); end

  class << self
    # @note Plugin developers should make sure to reset this value
    #   after parsing finishes. This can be done via the
    #   {Parser::SourceParser.after_parse_list} callback. This will
    #   ensure that YARD can properly parse multiple projects in
    #   the same process.
    # @return [Class<DocstringParser>] the parser class used to parse
    #   text and optional meta-data from docstrings. Defaults to
    #   {DocstringParser}.
    # @see DocstringParser
    # @see Parser::SourceParser.after_parse_list
    #
    # source://yard//lib/yard/docstring.rb#28
    def default_parser; end

    # @note Plugin developers should make sure to reset this value
    #   after parsing finishes. This can be done via the
    #   {Parser::SourceParser.after_parse_list} callback. This will
    #   ensure that YARD can properly parse multiple projects in
    #   the same process.
    # @return [Class<DocstringParser>] the parser class used to parse
    #   text and optional meta-data from docstrings. Defaults to
    #   {DocstringParser}.
    # @see DocstringParser
    # @see Parser::SourceParser.after_parse_list
    #
    # source://yard//lib/yard/docstring.rb#28
    def default_parser=(_arg0); end

    # Creates a new docstring without performing any parsing through
    # a {DocstringParser}. This method is called by +DocstringParser+
    # when creating the new docstring object.
    #
    # @param text [String] the textual portion of the docstring
    # @param tags [Array<Tags::Tag>] the list of tag objects in the docstring
    # @param object [CodeObjects::Base, nil] the object associated with the
    #   docstring. May be nil.
    # @param raw_data [String] the complete docstring, including all
    #   original formatting and any unparsed tags/directives.
    # @param ref_object [CodeObjects::Base, nil] a reference object used for
    #   the base set of documentation / tag information.
    #
    # source://yard//lib/yard/docstring.rb#77
    def new!(text, tags = T.unsafe(nil), object = T.unsafe(nil), raw_data = T.unsafe(nil), ref_object = T.unsafe(nil)); end

    # Creates a parser object using the current {default_parser}.
    # Equivalent to:
    #   Docstring.default_parser.new(*args)
    #
    # @param args arguments are passed to the {DocstringParser}
    #   class. See {DocstringParser#initialize} for details on
    #   arguments.
    # @return [DocstringParser] the parser object used to parse a
    #   docstring.
    #
    # source://yard//lib/yard/docstring.rb#38
    def parser(*args); end
  end
end

# Matches a tag at the start of a comment line
#
# @deprecated Use {DocstringParser::META_MATCH}
#
# source://yard//lib/yard/docstring.rb#61
YARD::Docstring::META_MATCH = T.let(T.unsafe(nil), Regexp)

# Parses text and creates a {Docstring} object to represent documentation
# for a {CodeObjects::Base}. To create a new docstring, you should initialize
# the parser and call {#parse} followed by {#to_docstring}.
#
# == Subclassing Notes
#
# The DocstringParser can be subclassed and substituted during parsing by
# setting the {Docstring.default_parser} attribute with the name of the
# subclass. This allows developers to change the way docstrings are
# parsed, allowing for completely different docstring syntaxes.
#
# @example Creating a Docstring with a DocstringParser
#   DocstringParser.new.parse("text here").to_docstring
# @example Creating a Custom DocstringParser
#   # Parses docstrings backwards!
#   class ReverseDocstringParser
#   def parse_content(content)
#   super(content.reverse)
#   end
#   end
#
#   # Set the parser as default when parsing
#   YARD::Docstring.default_parser = ReverseDocstringParser
# @see #parse_content
# @since 0.8.0
#
# source://yard//lib/yard/docstring_parser.rb#29
class YARD::DocstringParser
  # Creates a new parser to parse docstring data
  #
  # @param library [Tags::Library] a tag library for recognizing
  #   tags.
  # @return [DocstringParser] a new instance of DocstringParser
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#80
  def initialize(library = T.unsafe(nil)); end

  # Creates a new directive using the registered {#library}
  #
  # @return [Tags::Directive] the directive object that is created
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#231
  def create_directive(tag_name, tag_buf); end

  # Creates a {Tags::RefTag}
  #
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#225
  def create_ref_tag(tag_name, name, object_name); end

  # Creates a tag from the {Tags::DefaultFactory tag factory}.
  #
  # To add an already created tag object, append it to {#tags}.
  #
  # @param tag_name [String] the tag name
  # @param tag_buf [String] the text attached to the tag with newlines removed.
  # @return [Tags::Tag, Tags::RefTag] a tag
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#208
  def create_tag(tag_name, tag_buf = T.unsafe(nil)); end

  # @return [Array<Tags::Directive>] a list of directives identified
  #   by the parser. This list will not be passed on to the
  #   Docstring object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#44
  def directives; end

  # @return [Array<Tags::Directive>] a list of directives identified
  #   by the parser. This list will not be passed on to the
  #   Docstring object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#44
  def directives=(_arg0); end

  # @return [Handlers::Base, nil] the handler parsing this
  #   docstring. May be nil if this docstring parser is not
  #   initialized through
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#65
  def handler; end

  # @return [Handlers::Base, nil] the handler parsing this
  #   docstring. May be nil if this docstring parser is not
  #   initialized through
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#65
  def handler=(_arg0); end

  # @return [Tags::Library] the tag library being used to
  #   identify registered tags in the docstring.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#69
  def library; end

  # @return [Tags::Library] the tag library being used to
  #   identify registered tags in the docstring.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#69
  def library=(_arg0); end

  # @return [CodeObjects::Base, nil] the object associated with
  #   the docstring being parsed. May be nil if the docstring is
  #   not attached to any object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#55
  def object; end

  # @return [CodeObjects::Base, nil] the object associated with
  #   the docstring being parsed. May be nil if the docstring is
  #   not attached to any object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#55
  def object=(_arg0); end

  # Parses all content and returns itself.
  #
  # @param content [String] the docstring text to parse
  # @param object [CodeObjects::Base] the object that the docstring
  #   is attached to. Will be passed to directives to act on
  #   this object.
  # @param handler [Handlers::Base, nil] the handler object that is
  #   parsing this object. May be nil if this parser is not being
  #   called from a {Parser::SourceParser} context.
  # @return [self] the parser object. To get the docstring,
  #   call {#to_docstring}.
  # @see #to_docstring
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#112
  def parse(content, object = T.unsafe(nil), handler = T.unsafe(nil)); end

  # Parses a given block of text.
  #
  # @note Subclasses can override this method to perform custom
  #   parsing of content data.
  # @param content [String] the content to parse
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#128
  def parse_content(content); end

  # Call post processing callbacks on parser.
  # This is called implicitly by parser. Use this when
  # manually configuring a {Docstring} object.
  #
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#195
  def post_process; end

  # @return [String] the complete input string to the parser.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#35
  def raw_text; end

  # @return [String] the complete input string to the parser.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#35
  def raw_text=(_arg0); end

  # @return [CodeObjects::Base, nil] the object referenced by
  #   the docstring being parsed. May be nil if the docstring doesn't
  #   refer to any object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#60
  def reference; end

  # @return [CodeObjects::Base, nil] the object referenced by
  #   the docstring being parsed. May be nil if the docstring doesn't
  #   refer to any object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#60
  def reference=(_arg0); end

  # @return [OpenStruct] any arbitrary state to be passed between
  #   tags during parsing. Mainly used by directives to coordinate
  #   behaviour (so that directives can be aware of other directives
  #   used in a docstring).
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#50
  def state; end

  # @return [OpenStruct] any arbitrary state to be passed between
  #   tags during parsing. Mainly used by directives to coordinate
  #   behaviour (so that directives can be aware of other directives
  #   used in a docstring).
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#50
  def state=(_arg0); end

  # Backward compatibility to detect old tags that should be specified
  # as directives in 0.8 and onward.
  #
  # @return [Boolean]
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#251
  def tag_is_directive?(tag_name); end

  # @return [Array<Tags::Tag>] the list of meta-data tags identified
  #   by the parser
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#39
  def tags; end

  # @return [Array<Tags::Tag>] the list of meta-data tags identified
  #   by the parser
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#39
  def tags=(_arg0); end

  # @return [String] the parsed text portion of the docstring,
  #   with tags removed.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#32
  def text; end

  # @return [String] the parsed text portion of the docstring,
  #   with tags removed.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#32
  def text=(_arg0); end

  # @return [Docstring] translates parsed text into
  #   a Docstring object.
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#94
  def to_docstring; end

  private

  # Calls all {after_parse} callbacks
  #
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#323
  def call_after_parse_callbacks; end

  # Calls the {Tags::Directive#after_parse} callback on all the
  # created directives.
  #
  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#318
  def call_directives_after_parse; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#304
  def detect_reference(content); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/docstring_parser.rb#300
  def namespace; end

  class << self
    # Creates a callback that is called after a docstring is successfully
    # parsed. Use this method to perform sanity checks on a docstring's
    # tag data, or add any extra tags automatically to a docstring.
    #
    # @return [void]
    # @since 0.8.0
    # @yield [parser] a block to be called after a docstring is parsed
    # @yieldparam parser [DocstringParser] the docstring parser object
    #   with all directives and tags created.
    # @yieldreturn [void]
    #
    # source://yard//lib/yard/docstring_parser.rb#265
    def after_parse(&block); end

    # @return [Array<Proc>] the {after_parse} callback proc objects
    # @since 0.8.0
    #
    # source://yard//lib/yard/docstring_parser.rb#270
    def after_parse_callbacks; end
  end
end

# The regular expression to match the tag syntax
#
# @since 0.8.0
#
# source://yard//lib/yard/docstring_parser.rb#72
YARD::DocstringParser::META_MATCH = T.let(T.unsafe(nil), Regexp)

# source://yard//lib/yard/gem_index.rb#6
module YARD::GemIndex
  private

  # source://yard//lib/yard/gem_index.rb#25
  def all; end

  # source://yard//lib/yard/gem_index.rb#17
  def each(&block); end

  # source://yard//lib/yard/gem_index.rb#9
  def find_all_by_name(*args); end

  class << self
    # source://yard//lib/yard/gem_index.rb#25
    def all; end

    # source://yard//lib/yard/gem_index.rb#17
    def each(&block); end

    # source://yard//lib/yard/gem_index.rb#9
    def find_all_by_name(*args); end
  end
end

# Handlers are called during the data processing part of YARD's
# parsing phase. This allows YARD as well as any custom extension to
# analyze source and generate {CodeObjects} to be stored for later use.
#
# source://yard//lib/yard/autoload.rb#66
module YARD::Handlers; end

# Handlers are pluggable semantic parsers for YARD's code generation
# phase. They allow developers to control what information gets
# generated by YARD, giving them the ability to, for instance, document
# any Ruby DSLs that a customized framework may use. A good example
# of this would be the ability to document and generate meta data for
# the 'describe' declaration of the RSpec testing framework by simply
# adding a handler for such a keyword. Similarly, any Ruby API that
# takes advantage of class level declarations could add these to the
# documentation in a very explicit format by treating them as first-
# class objects in any outputted documentation.
#
# == Overview of a Typical Handler Scenario
#
# Generally, a handler class will declare a set of statements which
# it will handle using the {handles} class declaration. It will then
# implement the {#process} method to do the work. The processing would
# usually involve the manipulation of the {#namespace}, {#owner}
# {CodeObjects::Base code objects} or the creation of new ones, in
# which case they should be registered by {#register}, a method that
# sets some basic attributes for the new objects.
#
# Handlers are usually simple and take up to a page of code to process
# and register a new object or add new attributes to the current +namespace+.
#
# == Setting up a Handler for Use
#
# A Handler is automatically registered when it is subclassed from the
# base class. The only other thing that needs to be done is to specify
# which statement the handler will process. This is done with the +handles+
# declaration, taking either a {Parser::Ruby::Legacy::RubyToken}, {String} or `Regexp`.
# Here is a simple example which processes module statements.
#
#   class MyModuleHandler < YARD::Handlers::Base
#     handles TkMODULE
#
#     def process
#       # do something
#     end
#   end
#
# == Processing Handler Data
#
# The goal of a specific handler is really up to the developer, and as
# such there is no real guideline on how to process the data. However,
# it is important to know where the data is coming from to be able to use
# it.
#
# === +statement+ Attribute
#
# The +statement+ attribute pertains to the {Parser::Ruby::Legacy::Statement} object
# containing a set of tokens parsed in by the parser. This is the main set
# of data to be analyzed and processed. The comments attached to the statement
# can be accessed by the {Parser::Ruby::Legacy::Statement#comments} method, but generally
# the data to be processed will live in the +tokens+ attribute. This list
# can be converted to a +String+ using +#to_s+ to parse the data with
# regular expressions (or other text processing mechanisms), if needed.
#
# === +namespace+ Attribute
#
# The +namespace+ attribute is a {CodeObjects::NamespaceObject namespace object}
# which represents the current namespace that the parser is in. For instance:
#
#   module SomeModule
#     class MyClass
#       def mymethod; end
#     end
#   end
#
# If a handler was to parse the 'class MyClass' statement, it would
# be necessary to know that it belonged inside the SomeModule module.
# This is the value that +namespace+ would return when processing such
# a statement. If the class was then entered and another handler was
# called on the method, the +namespace+ would be set to the 'MyClass'
# code object.
#
# === +owner+ Attribute
#
# The +owner+ attribute is similar to the +namespace+ attribute in that
# it also follows the scope of the code during parsing. However, a namespace
# object is loosely defined as a module or class and YARD has the ability
# to parse beyond module and class blocks (inside methods, for instance),
# so the +owner+ attribute would not be limited to modules and classes.
#
# To put this into context, the example from above will be used. If a method
# handler was added to the mix and decided to parse inside the method body,
# the +owner+ would be set to the method object but the namespace would remain
# set to the class. This would allow the developer to process any method
# definitions set inside a method (def x; def y; 2 end end) by adding them
# to the correct namespace (the class, not the method).
#
# In summary, the distinction between +namespace+ and +owner+ can be thought
# of as the difference between first-class Ruby objects (namespaces) and
# second-class Ruby objects (methods).
#
# === +visibility+ and +scope+ Attributes
#
# Mainly needed for parsing methods, the +visibility+ and +scope+ attributes
# refer to the public/protected/private and class/instance values (respectively)
# of the current parsing position.
#
# == Parsing Blocks in Statements
#
# In addition to parsing a statement and creating new objects, some
# handlers may wish to continue parsing the code inside the statement's
# block (if there is one). In this context, a block means the inside
# of any statement, be it class definition, module definition, if
# statement or classic 'Ruby block'.
#
# For example, a class statement would be "class MyClass" and the block
# would be a list of statements including the method definitions inside
# the class. For a class handler, the programmer would execute the
# {#parse_block} method to continue parsing code inside the block, with
# the +namespace+ now pointing to the class object the handler created.
#
# YARD has the ability to continue into any block: class, module, method,
# even if statements. For this reason, the block parsing method must be
# invoked explicitly out of efficiency sake.
#
# @abstract Subclass this class to provide a handler for YARD to use
#   during the processing phase.
# @see CodeObjects::Base
# @see CodeObjects::NamespaceObject
# @see handles
# @see #namespace
# @see #owner
# @see #register
# @see #parse_block
#
# source://yard//lib/yard/handlers/base.rb#149
class YARD::Handlers::Base
  include ::YARD::CodeObjects
  include ::YARD::Parser

  # @return [Base] a new instance of Base
  #
  # source://yard//lib/yard/handlers/base.rb#276
  def initialize(source_parser, stmt); end

  # Aborts a handler by raising {Handlers::HandlerAborted}.
  # An exception will only be logged in debugging mode for
  # this kind of handler exit.
  #
  # @raise [Handlers::HandlerAborted]
  # @since 0.8.4
  #
  # source://yard//lib/yard/handlers/base.rb#355
  def abort!; end

  # @abstract Implement this method to return the parameters in a method call
  #   statement. It should return an empty list if the statement is not a
  #   method call.
  # @raise [NotImplementedError]
  # @return [Array<String>] a list of argument names
  #
  # source://yard//lib/yard/handlers/base.rb#581
  def call_params; end

  # @abstract Implement this method to return the method being called in
  #   a method call. It should return nil if the statement is not a method
  #   call.
  # @raise [NotImplementedError]
  # @return [String] the method name being called
  # @return [nil] if the statement is not a method call
  #
  # source://yard//lib/yard/handlers/base.rb#590
  def caller_method; end

  # Ensures that a specific +object+ has been parsed and loaded into the
  # registry. This is necessary when adding data to a namespace, for instance,
  # since the namespace may not have been processed yet (it can be located
  # in a file that has not been handled).
  #
  # Calling this method defers the handler until all other files have been
  # processed. If the object gets resolved, the rest of the handler continues,
  # otherwise an exception is raised.
  #
  # @example Adding a mixin to the String class programmatically
  #   ensure_loaded! P('String')
  #   # "String" is now guaranteed to be loaded
  #   P('String').mixins << P('MyMixin')
  # @param object [Proxy, CodeObjects::Base] the object to resolve.
  # @param max_retries [Integer] the number of times to defer the handler
  #   before raising a +NamespaceMissingError+.
  # @raise [NamespaceMissingError] if the object is not resolved within
  #   +max_retries+ attempts, this exception is raised and the handler
  #   finishes processing.
  #
  # source://yard//lib/yard/handlers/base.rb#561
  def ensure_loaded!(object, max_retries = T.unsafe(nil)); end

  # Returns the value of attribute extra_state.
  #
  # source://yard//lib/yard/handlers/base.rb#348
  def extra_state; end

  # Returns the value of attribute globals.
  #
  # source://yard//lib/yard/handlers/base.rb#347
  def globals; end

  # Returns the value of attribute namespace.
  #
  # source://yard//lib/yard/handlers/base.rb#341
  def namespace; end

  # Sets the attribute namespace
  #
  # @param value the value to set the attribute namespace to.
  #
  # source://yard//lib/yard/handlers/base.rb#342
  def namespace=(v); end

  # Returns the value of attribute owner.
  #
  # source://yard//lib/yard/handlers/base.rb#339
  def owner; end

  # Sets the attribute owner
  #
  # @param value the value to set the attribute owner to.
  #
  # source://yard//lib/yard/handlers/base.rb#340
  def owner=(v); end

  # Parses the semantic "block" contained in the statement node.
  #
  # @abstract Subclasses should call {Processor#process parser.process}
  # @raise [NotImplementedError]
  #
  # source://yard//lib/yard/handlers/base.rb#304
  def parse_block(*_arg0); end

  # @return [Processor] the processor object that manages all global state
  #   during handling.
  #
  # source://yard//lib/yard/handlers/base.rb#310
  def parser; end

  # The main handler method called by the parser on a statement
  # that matches the {handles} declaration.
  #
  # Subclasses should override this method to provide the handling
  # functionality for the class.
  #
  # @raise [NotImplementedError]
  # @return [Array<CodeObjects::Base>, CodeObjects::Base, Object] If this method returns a code object (or a list of them),
  #   they are passed to the +#register+ method which adds basic
  #   attributes. It is not necessary to return any objects and in
  #   some cases you may want to explicitly avoid the returning of
  #   any objects for post-processing by the register method.
  # @see handles
  # @see #register
  #
  # source://yard//lib/yard/handlers/base.rb#297
  def process; end

  # Executes a given block with specific state values for {#owner},
  # {#namespace} and {#scope}.
  #
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @yield a block to execute with the given state values.
  #
  # source://yard//lib/yard/handlers/base.rb#370
  def push_state(opts = T.unsafe(nil)); end

  # Do some post processing on a list of code objects.
  # Adds basic attributes to the list of objects like
  # the filename, line number, {CodeObjects::Base#dynamic},
  # source code and {CodeObjects::Base#docstring},
  # but only if they don't exist.
  #
  # @param objects [Array<CodeObjects::Base>] the list of objects to post-process.
  # @return [CodeObjects::Base, Array<CodeObjects::Base>] returns whatever is passed in, for chainability.
  #
  # source://yard//lib/yard/handlers/base.rb#407
  def register(*objects); end

  # Registers any docstring found for the object and expands macros
  #
  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#450
  def register_docstring(object, docstring = T.unsafe(nil), stmt = T.unsafe(nil)); end

  # Registers the object as dynamic if the object is defined inside
  # a method or block (owner != namespace)
  #
  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#537
  def register_dynamic(object); end

  # Ensures that the object's namespace is loaded before attaching it
  # to the namespace.
  #
  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#429
  def register_ensure_loaded(object); end

  # Registers the file/line of the declaration with the object
  #
  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#441
  def register_file_info(object, file = T.unsafe(nil), line = T.unsafe(nil), comments = T.unsafe(nil)); end

  # Registers the object as being inside a specific group
  #
  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#473
  def register_group(object, group = T.unsafe(nil)); end

  # Registers the same method information on the module function, if
  # the object was defined as a module function.
  #
  # @param object [CodeObjects::Base] the possible module function object
  #   to copy data for
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#523
  def register_module_function(object); end

  # @param object [CodeObjects::Base] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#499
  def register_source(object, source = T.unsafe(nil), type = T.unsafe(nil)); end

  # Registers any transitive tags from the namespace on the object
  #
  # @param object [CodeObjects::Base, nil] the object to register
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#487
  def register_transitive_tags(object); end

  # Registers visibility on a method object. If the object does not
  # respond to setting visibility, nothing is done.
  #
  # @param object [#visibility=] the object to register
  # @param visibility [Symbol] the visibility to set on the object
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/base.rb#511
  def register_visibility(object, visibility = T.unsafe(nil)); end

  # Returns the value of attribute scope.
  #
  # source://yard//lib/yard/handlers/base.rb#345
  def scope; end

  # Sets the attribute scope
  #
  # @param value the value to set the attribute scope to.
  #
  # source://yard//lib/yard/handlers/base.rb#346
  def scope=(v); end

  # @return [Object] the statement object currently being processed. Usually
  #   refers to one semantic language statement, though the strict definition
  #   depends on the parser used.
  #
  # source://yard//lib/yard/handlers/base.rb#315
  def statement; end

  # Returns the value of attribute visibility.
  #
  # source://yard//lib/yard/handlers/base.rb#343
  def visibility; end

  # Sets the attribute visibility
  #
  # @param value the value to set the attribute visibility to.
  #
  # source://yard//lib/yard/handlers/base.rb#344
  def visibility=(v); end

  class << self
    # Clear all registered subclasses. Testing purposes only
    #
    # @return [void]
    #
    # source://yard//lib/yard/handlers/base.rb#159
    def clear_subclasses; end

    # @return [Array] a list of matchers for the handler object.
    # @see handles?
    #
    # source://yard//lib/yard/handlers/base.rb#211
    def handlers; end

    # Declares the statement type which will be processed
    # by this handler.
    #
    # A match need not be unique to a handler. Multiple
    # handlers can process the same statement. However,
    # in this case, care should be taken to make sure that
    # {#parse_block} would only be executed by one of
    # the handlers, otherwise the same code will be parsed
    # multiple times and slow YARD down.
    #
    # @param matches [Parser::Ruby::Legacy::RubyToken, Symbol, String, Regexp] statements that match the declaration will be
    #   processed by this handler. A {String} match is
    #   equivalent to a +/\Astring/+ regular expression
    #   (match from the beginning of the line), and all
    #   token matches match only the first token of the
    #   statement.
    #
    # source://yard//lib/yard/handlers/base.rb#192
    def handles(*matches); end

    # This class is implemented by {Ruby::Base} and {Ruby::Legacy::Base}.
    # To implement a base handler class for another language, implement
    # this method to return true if the handler should process the given
    # statement object. Use {handlers} to enumerate the matchers declared
    # for the handler class.
    #
    # @param statement a statement object or node (depends on language type)
    # @raise [NotImplementedError]
    # @return [Boolean] whether or not this handler object should process
    #   the given statement
    #
    # source://yard//lib/yard/handlers/base.rb#205
    def handles?(statement); end

    # Declares that a handler should only be called when inside a filename
    # by its basename or a regex match for the full path.
    #
    # @param filename [String, Regexp] a matching filename or regex
    # @return [void]
    # @since 0.6.2
    #
    # source://yard//lib/yard/handlers/base.rb#235
    def in_file(filename); end

    # @private
    #
    # source://yard//lib/yard/handlers/base.rb#169
    def inherited(subclass); end

    # @return [Boolean] whether the filename matches the declared file
    #   match for a handler. If no file match is specified, returns true.
    # @since 0.6.2
    #
    # source://yard//lib/yard/handlers/base.rb#242
    def matches_file?(filename); end

    # Declares that the handler should only be called when inside a
    # {CodeObjects::NamespaceObject}, not a method body.
    #
    # @return [void]
    #
    # source://yard//lib/yard/handlers/base.rb#219
    def namespace_only; end

    # @return [Boolean] whether the handler should only be processed inside
    #   a namespace.
    #
    # source://yard//lib/yard/handlers/base.rb#225
    def namespace_only?; end

    # Generates a +process+ method, equivalent to +def process; ... end+.
    # Blocks defined with this syntax will be wrapped inside an anonymous
    # module so that the handler class can be extended with mixins that
    # override the +process+ method without alias chaining.
    #
    # @return [void]
    # @see #process
    # @since 0.5.4
    #
    # source://yard//lib/yard/handlers/base.rb#269
    def process(&block); end

    # Returns all registered handler subclasses.
    #
    # @return [Array<Base>] a list of handlers
    #
    # source://yard//lib/yard/handlers/base.rb#165
    def subclasses; end
  end
end

# CRuby Handlers
#
# @since 0.8.0
#
# source://yard//lib/yard/autoload.rb#74
module YARD::Handlers::C; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/alias_handler.rb#2
class YARD::Handlers::C::AliasHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/alias_handler.rb#3
YARD::Handlers::C::AliasHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/attribute_handler.rb#2
class YARD::Handlers::C::AttributeHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/attribute_handler.rb#3
YARD::Handlers::C::AttributeHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/base.rb#5
class YARD::Handlers::C::Base < ::YARD::Handlers::Base
  include ::YARD::Parser::C
  include ::YARD::Handlers::Common::MethodHandler
  include ::YARD::Handlers::C::HandlerMethods

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#77
  def ensure_variable_defined!(var, max_retries = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#64
  def namespace_for_variable(var); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#94
  def namespaces; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#60
  def override_comments; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#104
  def parse_block(opts = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#113
  def process_file(file, object); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#98
  def processed_files; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#38
  def register_docstring(object, docstring = T.unsafe(nil), stmt = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#42
  def register_file_info(object, file = T.unsafe(nil), line = T.unsafe(nil), comments = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#46
  def register_source(object, source = T.unsafe(nil), type = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#50
  def register_visibility(object, visibility = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#56
  def symbols; end

  private

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/base.rb#158
  def remove_var_prefix(var); end

  class << self
    # @return [Boolean] whether the handler handles this statement
    # @since 0.8.0
    #
    # source://yard//lib/yard/handlers/c/base.rb#10
    def handles?(statement, processor); end

    # @since 0.8.0
    #
    # source://yard//lib/yard/handlers/c/base.rb#28
    def statement_class(type = T.unsafe(nil)); end
  end
end

# Generated by update_error_map.rb (Copy+past results)
#
# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/base.rb#131
YARD::Handlers::C::Base::ERROR_CLASS_NAMES = T.let(T.unsafe(nil), Hash)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/class_handler.rb#2
class YARD::Handlers::C::ClassHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/class_handler.rb#3
YARD::Handlers::C::ClassHandler::MATCH1 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/class_handler.rb#9
YARD::Handlers::C::ClassHandler::MATCH2 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/constant_handler.rb#2
class YARD::Handlers::C::ConstantHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/constant_handler.rb#3
YARD::Handlers::C::ConstantHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/handler_methods.rb#5
module YARD::Handlers::C::HandlerMethods
  include ::YARD::Parser::C
  include ::YARD::CodeObjects
  include ::YARD::Handlers::Common::MethodHandler

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#86
  def handle_alias(var_name, new_name, old_name); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#75
  def handle_attribute(var_name, name, read, write); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#10
  def handle_class(var_name, class_name, parent, in_module = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#109
  def handle_constants(type, var_name, const_name, value); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#46
  def handle_method(scope, var_name, name, func_name, _source_file = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#33
  def handle_module(var_name, module_name, in_module = T.unsafe(nil)); end

  private

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#123
  def find_constant_docstring(object); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#154
  def find_method_body(object, symbol); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/handler_methods.rb#196
  def record_parameters(object, symbol, src); end
end

# Handles the Init_Libname() method
#
# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/init_handler.rb#3
class YARD::Handlers::C::InitHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/init_handler.rb#4
YARD::Handlers::C::InitHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/method_handler.rb#2
class YARD::Handlers::C::MethodHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/method_handler.rb#3
YARD::Handlers::C::MethodHandler::MATCH1 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/method_handler.rb#14
YARD::Handlers::C::MethodHandler::MATCH2 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/method_handler.rb#18
YARD::Handlers::C::MethodHandler::MATCH3 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/mixin_handler.rb#2
class YARD::Handlers::C::MixinHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/mixin_handler.rb#3
YARD::Handlers::C::MixinHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/module_handler.rb#2
class YARD::Handlers::C::ModuleHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/module_handler.rb#3
YARD::Handlers::C::ModuleHandler::MATCH1 = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/module_handler.rb#4
YARD::Handlers::C::ModuleHandler::MATCH2 = T.let(T.unsafe(nil), Regexp)

# Parses comments
#
# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/override_comment_handler.rb#3
class YARD::Handlers::C::OverrideCommentHandler < ::YARD::Handlers::C::Base
  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/override_comment_handler.rb#24
  def register_docstring(object, docstring = T.unsafe(nil), stmt = T.unsafe(nil)); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/handlers/c/override_comment_handler.rb#28
  def register_file_info(object, file = T.unsafe(nil), line = T.unsafe(nil), comments = T.unsafe(nil)); end
end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/path_handler.rb#2
class YARD::Handlers::C::PathHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/path_handler.rb#3
YARD::Handlers::C::PathHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/struct_handler.rb#2
class YARD::Handlers::C::StructHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/struct_handler.rb#3
YARD::Handlers::C::StructHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# Keeps track of function bodies for symbol lookup during Ruby method declarations
#
# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/symbol_handler.rb#3
class YARD::Handlers::C::SymbolHandler < ::YARD::Handlers::C::Base; end

# @since 0.8.0
#
# source://yard//lib/yard/handlers/c/symbol_handler.rb#4
YARD::Handlers::C::SymbolHandler::MATCH = T.let(T.unsafe(nil), Regexp)

# Shared logic between C and Ruby handlers.
#
# source://yard//lib/yard/autoload.rb#68
module YARD::Handlers::Common; end

# Shared functionality between Ruby and C method handlers.
#
# source://yard//lib/yard/handlers/common/method_handler.rb#6
module YARD::Handlers::Common::MethodHandler
  # @param obj [MethodObject]
  #
  # source://yard//lib/yard/handlers/common/method_handler.rb#8
  def add_predicate_return_tag(obj); end
end

# Raise this error when a handler should exit before completing.
# The exception will be silenced, allowing the next handler(s) in the
# queue to be executed.
#
# @since 0.8.4
#
# source://yard//lib/yard/handlers/base.rb#8
class YARD::Handlers::HandlerAborted < ::RuntimeError; end

# Raised during processing phase when a handler needs to perform
# an operation on an object's namespace but the namespace could
# not be resolved.
#
# source://yard//lib/yard/handlers/base.rb#13
class YARD::Handlers::NamespaceMissingError < ::YARD::Parser::UndocumentableError
  # @return [NamespaceMissingError] a new instance of NamespaceMissingError
  #
  # source://yard//lib/yard/handlers/base.rb#18
  def initialize(object); end

  # The object the error occurred on
  #
  # @return [CodeObjects::Base] a code object
  #
  # source://yard//lib/yard/handlers/base.rb#16
  def object; end

  # The object the error occurred on
  #
  # @return [CodeObjects::Base] a code object
  #
  # source://yard//lib/yard/handlers/base.rb#16
  def object=(_arg0); end
end

# Iterates over all statements in a file and delegates them to the
# {Handlers::Base} objects that are registered to handle the statement.
#
# This class is passed to each handler and keeps overall processing state.
# For example, if the {#visibility} is set in a handler, all following
# statements will have access to this state. This allows "public",
# "protected" and "private" statements to be handled in classes and modules.
# In addition, the {#namespace} can be set during parsing to control
# where objects are being created from. You can also access extra stateful
# properties that any handler can set during the duration of the post
# processing of a file from {#extra_state}. If you need to access state
# across different files, look at {#globals}.
#
# @see Handlers::Base
#
# source://yard//lib/yard/handlers/processor.rb#19
class YARD::Handlers::Processor
  # Creates a new Processor for a +file+.
  #
  # @param parser [Parser::SourceParser] the parser used to initialize the processor
  # @return [Processor] a new instance of Processor
  #
  # source://yard//lib/yard/handlers/processor.rb#91
  def initialize(parser); end

  # Share state across different handlers inside of a file.
  # This attribute is similar to {#visibility}, {#scope}, {#namespace}
  # and {#owner}, in that they all maintain state across all handlers
  # for the entire source file. Use this attribute to store any data
  # your handler might need to save during the parsing of a file. If
  # you need to save state across files, see {#globals}.
  #
  # @return [OpenStruct] an open structure that can store arbitrary data
  # @see #globals
  #
  # source://yard//lib/yard/handlers/processor.rb#87
  def extra_state; end

  # Share state across different handlers inside of a file.
  # This attribute is similar to {#visibility}, {#scope}, {#namespace}
  # and {#owner}, in that they all maintain state across all handlers
  # for the entire source file. Use this attribute to store any data
  # your handler might need to save during the parsing of a file. If
  # you need to save state across files, see {#globals}.
  #
  # @return [OpenStruct] an open structure that can store arbitrary data
  # @see #globals
  #
  # source://yard//lib/yard/handlers/processor.rb#87
  def extra_state=(_arg0); end

  # @return [String] the filename
  #
  # source://yard//lib/yard/handlers/processor.rb#40
  def file; end

  # @return [String] the filename
  #
  # source://yard//lib/yard/handlers/processor.rb#40
  def file=(_arg0); end

  # Searches for all handlers in {Base.subclasses} that match the +statement+
  #
  # @param statement the statement object to match.
  # @return [Array<Base>] a list of handlers to process the statement with.
  #
  # source://yard//lib/yard/handlers/processor.rb#150
  def find_handlers(statement); end

  # Handlers can share state for the entire post processing stage through
  # this attribute. Note that post processing stage spans multiple files.
  # To share state only within a single file, use {#extra_state}
  #
  # @example Sharing state among two handlers
  #   class Handler1 < YARD::Handlers::Ruby::Base
  #   handles :class
  #   process { globals.foo = :bar }
  #   end
  #
  #   class Handler2 < YARD::Handlers::Ruby::Base
  #   handles :method
  #   process { puts globals.foo }
  #   end
  # @return [OpenStruct] global shared state for post-processing stage
  # @see #extra_state
  #
  # source://yard//lib/yard/handlers/processor.rb#76
  def globals; end

  # Handlers can share state for the entire post processing stage through
  # this attribute. Note that post processing stage spans multiple files.
  # To share state only within a single file, use {#extra_state}
  #
  # @example Sharing state among two handlers
  #   class Handler1 < YARD::Handlers::Ruby::Base
  #   handles :class
  #   process { globals.foo = :bar }
  #   end
  #
  #   class Handler2 < YARD::Handlers::Ruby::Base
  #   handles :method
  #   process { puts globals.foo }
  #   end
  # @return [OpenStruct] global shared state for post-processing stage
  # @see #extra_state
  #
  # source://yard//lib/yard/handlers/processor.rb#76
  def globals=(_arg0); end

  # @return [CodeObjects::NamespaceObject] the current namespace
  #
  # source://yard//lib/yard/handlers/processor.rb#43
  def namespace; end

  # @return [CodeObjects::NamespaceObject] the current namespace
  #
  # source://yard//lib/yard/handlers/processor.rb#43
  def namespace=(_arg0); end

  # @return [CodeObjects::Base, nil] unlike the namespace, the owner
  #   is a non-namespace object that should be stored between statements.
  #   For instance, when parsing a method body, the {CodeObjects::MethodObject}
  #   is set as the owner, in case any extra method information is processed.
  #
  # source://yard//lib/yard/handlers/processor.rb#55
  def owner; end

  # @return [CodeObjects::Base, nil] unlike the namespace, the owner
  #   is a non-namespace object that should be stored between statements.
  #   For instance, when parsing a method body, the {CodeObjects::MethodObject}
  #   is set as the owner, in case any extra method information is processed.
  #
  # source://yard//lib/yard/handlers/processor.rb#55
  def owner=(_arg0); end

  # Continue parsing the remainder of the files in the +globals.ordered_parser+
  # object. After the remainder of files are parsed, processing will continue
  # on the current file.
  #
  # @return [void]
  # @see Parser::OrderedParser
  #
  # source://yard//lib/yard/handlers/processor.rb#139
  def parse_remaining_files; end

  # @return [Symbol] the parser type (:ruby, :ruby18, :c)
  #
  # source://yard//lib/yard/handlers/processor.rb#58
  def parser_type; end

  # @return [Symbol] the parser type (:ruby, :ruby18, :c)
  #
  # source://yard//lib/yard/handlers/processor.rb#58
  def parser_type=(_arg0); end

  # Processes a list of statements by finding handlers to process each
  # one.
  #
  # @param statements [Array] a list of statements
  # @return [void]
  #
  # source://yard//lib/yard/handlers/processor.rb#109
  def process(statements); end

  # @return [Symbol] the current scope (class, instance)
  #
  # source://yard//lib/yard/handlers/processor.rb#49
  def scope; end

  # @return [Symbol] the current scope (class, instance)
  #
  # source://yard//lib/yard/handlers/processor.rb#49
  def scope=(_arg0); end

  # @return [Symbol] the current visibility (public, private, protected)
  #
  # source://yard//lib/yard/handlers/processor.rb#46
  def visibility; end

  # @return [Symbol] the current visibility (public, private, protected)
  #
  # source://yard//lib/yard/handlers/processor.rb#46
  def visibility=(_arg0); end

  private

  # Returns the handler base class
  #
  # @return [Base] the base class
  #
  # source://yard//lib/yard/handlers/processor.rb#171
  def handler_base_class; end

  # The module holding the handlers to be loaded
  #
  # @return [Module] the module containing the handlers depending on
  #   {#parser_type}.
  #
  # source://yard//lib/yard/handlers/processor.rb#179
  def handler_base_namespace; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/handlers/processor.rb#160
  def handles?(handler, statement); end

  # Loads handlers from {#handler_base_namespace}. This ensures that
  # Ruby1.9 handlers are never loaded into 1.8; also lowers the amount
  # of modules that are loaded
  #
  # @return [void]
  #
  # source://yard//lib/yard/handlers/processor.rb#187
  def load_handlers; end

  class << self
    # @private
    # @return [Hash] a list of registered parser type extensions
    # @since 0.6.0
    #
    # source://yard//lib/yard/handlers/processor.rb#32
    def namespace_for_handler; end

    # Registers a new namespace for handlers of the given type.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/handlers/processor.rb#23
    def register_handler_namespace(type, ns); end
  end
end

# All Ruby handlers
#
# source://yard//lib/yard/autoload.rb#92
module YARD::Handlers::Ruby; end

# Handles alias and alias_method calls
#
# source://yard//lib/yard/handlers/ruby/alias_handler.rb#3
class YARD::Handlers::Ruby::AliasHandler < ::YARD::Handlers::Ruby::Base; end

# Handles +attr_*+ statements in modules/classes
#
# source://yard//lib/yard/handlers/ruby/attribute_handler.rb#3
class YARD::Handlers::Ruby::AttributeHandler < ::YARD::Handlers::Ruby::Base
  protected

  # Strips out any non-essential arguments from the attr statement.
  #
  # @param params [Array<Parser::Ruby::AstNode>] a list of the parameters
  #   in the attr call.
  # @raise [Parser::UndocumentableError] if the arguments are not valid.
  # @return [Array<String>] the validated attribute names
  #
  # source://yard//lib/yard/handlers/ruby/attribute_handler.rb#75
  def validated_attribute_names(params); end
end

# This is the base handler class for the new-style (1.9) Ruby parser.
# All handlers that subclass this base class will be used when the
# new-style parser is used. For implementing legacy handlers, see
# {Legacy::Base}.
#
# @abstract See {Handlers::Base} for subclassing information.
# @see Handlers::Base
# @see Legacy::Base
#
# source://yard//lib/yard/handlers/ruby/base.rb#65
class YARD::Handlers::Ruby::Base < ::YARD::Handlers::Base
  include ::YARD::Parser::Ruby
  extend ::YARD::Parser::Ruby

  # source://yard//lib/yard/handlers/ruby/base.rb#144
  def call_params; end

  # source://yard//lib/yard/handlers/ruby/base.rb#155
  def caller_method; end

  # source://yard//lib/yard/handlers/ruby/base.rb#135
  def parse_block(inner_node, opts = T.unsafe(nil)); end

  class << self
    # @return [Boolean] whether or not an {AstNode} object should be
    #   handled by this handler
    #
    # source://yard//lib/yard/handlers/ruby/base.rb#113
    def handles?(node); end

    # Matcher for handling a node with a specific meta-type. An {AstNode}
    # has a {AstNode#type} to define its type but can also be associated
    # with a set of types. For instance, +:if+ and +:unless+ are both
    # of the meta-type +:condition+.
    #
    # A meta-type is any method on the {AstNode} class ending in "?",
    # though you should not include the "?" suffix in your declaration.
    # Some examples are: "condition", "call", "literal", "kw", "token",
    # "ref".
    #
    # @example Handling any conditional statement (if, unless)
    #   handles meta_type(:condition)
    # @param type [Symbol] the meta-type to match. A meta-type can be
    #   any method name + "?" that {AstNode} responds to.
    # @return [void]
    #
    # source://yard//lib/yard/handlers/ruby/base.rb#105
    def meta_type(type); end

    # Matcher for handling any type of method call. Method calls can
    # be expressed by many {AstNode} types depending on the syntax
    # with which it is called, so YARD allows you to use this matcher
    # to simplify matching a method call.
    #
    # @example Match the "describe" method call
    #   handles method_call(:describe)
    #
    #   # The following will be matched:
    #   # describe(...)
    #   # object.describe(...)
    #   # describe "argument" do ... end
    # @param name [#to_s] matches the method call of this name
    # @return [void]
    #
    # source://yard//lib/yard/handlers/ruby/base.rb#86
    def method_call(name = T.unsafe(nil)); end
  end
end

# Matches if/unless conditions inside classes and attempts to process only
# one branch (by evaluating the condition if possible).
#
# @example A simple class conditional
#   class Foo
#   if 0
#   # This method is ignored
#   def xyz; end
#   end
#   end
#
# source://yard//lib/yard/handlers/ruby/class_condition_handler.rb#12
class YARD::Handlers::Ruby::ClassConditionHandler < ::YARD::Handlers::Ruby::Base
  protected

  # Parses the condition part of the if/unless statement
  #
  # @return [true, false, nil] true if the condition can be definitely
  #   parsed to true, false if not, and nil if the condition cannot be
  #   parsed with certainty (it's dynamic)
  #
  # source://yard//lib/yard/handlers/ruby/class_condition_handler.rb#36
  def parse_condition; end

  # source://yard//lib/yard/handlers/ruby/class_condition_handler.rb#87
  def parse_else_block; end

  # source://yard//lib/yard/handlers/ruby/class_condition_handler.rb#83
  def parse_then_block; end
end

# Handles class declarations
#
# source://yard//lib/yard/handlers/ruby/class_handler.rb#3
class YARD::Handlers::Ruby::ClassHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::StructHandlerMethods

  private

  # source://yard//lib/yard/handlers/ruby/class_handler.rb#73
  def create_struct_superclass(superclass, superclass_def); end

  # Extract the parameters from the Struct.new AST node, returning them as a list
  # of strings
  #
  # @param superclass [MethodCallNode] the AST node for the Struct.new call
  # @return [Array<String>] the member names to generate methods for
  #
  # source://yard//lib/yard/handlers/ruby/class_handler.rb#67
  def extract_parameters(superclass); end

  # source://yard//lib/yard/handlers/ruby/class_handler.rb#92
  def parse_struct_superclass(klass, superclass); end

  # source://yard//lib/yard/handlers/ruby/class_handler.rb#98
  def parse_superclass(superclass); end

  # source://yard//lib/yard/handlers/ruby/class_handler.rb#82
  def struct_superclass_name(superclass); end
end

# Handles a class variable (@@variable)
#
# source://yard//lib/yard/handlers/ruby/class_variable_handler.rb#3
class YARD::Handlers::Ruby::ClassVariableHandler < ::YARD::Handlers::Ruby::Base; end

# Handles any lone comment statement in a Ruby file
#
# source://yard//lib/yard/handlers/ruby/comment_handler.rb#3
class YARD::Handlers::Ruby::CommentHandler < ::YARD::Handlers::Ruby::Base; end

# Handles any constant assignment
#
# source://yard//lib/yard/handlers/ruby/constant_handler.rb#3
class YARD::Handlers::Ruby::ConstantHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::StructHandlerMethods

  private

  # Extract the parameters from the Struct.new AST node, returning them as a list
  # of strings
  #
  # @param superclass [MethodCallNode] the AST node for the Struct.new call
  # @return [Array<String>] the member names to generate methods for
  #
  # source://yard//lib/yard/handlers/ruby/constant_handler.rb#49
  def extract_parameters(superclass); end

  # source://yard//lib/yard/handlers/ruby/constant_handler.rb#21
  def process_constant(statement); end

  # source://yard//lib/yard/handlers/ruby/constant_handler.rb#33
  def process_structclass(statement); end
end

# Handles automatic detection of dsl-style methods
#
# source://yard//lib/yard/handlers/ruby/dsl_handler.rb#6
class YARD::Handlers::Ruby::DSLHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::DSLHandlerMethods
end

# source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#5
module YARD::Handlers::Ruby::DSLHandlerMethods
  include ::YARD::CodeObjects
  include ::YARD::Parser

  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#14
  def handle_comments; end

  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#48
  def register_docstring(object, docstring = T.unsafe(nil), stmt = T.unsafe(nil)); end

  private

  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#72
  def find_attached_macro; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#54
  def implicit_docstring?; end

  # @return [Boolean] whether caller method matches a macro or
  #   its alias names.
  #
  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#85
  def macro_name_matches(macro); end

  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#59
  def method_name; end

  # source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#68
  def method_signature; end
end

# source://yard//lib/yard/handlers/ruby/dsl_handler_methods.rb#9
YARD::Handlers::Ruby::DSLHandlerMethods::IGNORE_METHODS = T.let(T.unsafe(nil), Hash)

# Helper methods to assist with processing decorators.
#
# source://yard//lib/yard/handlers/ruby/decorator_handler_methods.rb#3
module YARD::Handlers::Ruby::DecoratorHandlerMethods
  # @overload process_decorator
  #
  # source://yard//lib/yard/handlers/ruby/decorator_handler_methods.rb#43
  def process_decorator(*nodes, &block); end

  private

  # @yield [method, node, name.to_sym]
  #
  # source://yard//lib/yard/handlers/ruby/decorator_handler_methods.rb#78
  def process_decorator_parameter(node, opts = T.unsafe(nil), &block); end
end

# Handles 'raise' calls inside methods
#
# source://yard//lib/yard/handlers/ruby/exception_handler.rb#3
class YARD::Handlers::Ruby::ExceptionHandler < ::YARD::Handlers::Ruby::Base; end

# Handles 'extend' call to include modules into the class scope of another
#
# @see MixinHandler
#
# source://yard//lib/yard/handlers/ruby/extend_handler.rb#4
class YARD::Handlers::Ruby::ExtendHandler < ::YARD::Handlers::Ruby::MixinHandler
  # source://yard//lib/yard/handlers/ruby/extend_handler.rb#8
  def scope; end

  private

  # source://yard//lib/yard/handlers/ruby/extend_handler.rb#12
  def process_mixin(mixin); end
end

# To implement a custom handler matcher, subclass this class and implement
# {#matches?} to return whether a node matches the handler.
#
# @example A Custom Handler Matcher Extension
#   # Implements a handler that checks for a specific string
#   # in the node's source.
#   class MyExtension < HandlesExtension
#   def matches?(node) node.source.include?(name) end
#   end
#
#   # This handler will handle any node where the source includes 'foo'
#   class MyHandler < Handlers::Ruby::Base
#   handles MyExtension.new('foo')
#   end
#
# source://yard//lib/yard/handlers/ruby/base.rb#19
class YARD::Handlers::Ruby::HandlesExtension
  # Creates a new extension with a specific matcher value +name+
  #
  # @param name [Object] the matcher value to check against {#matches?}
  # @return [HandlesExtension] a new instance of HandlesExtension
  #
  # source://yard//lib/yard/handlers/ruby/base.rb#22
  def initialize(name); end

  # Tests if the node matches the handler
  #
  # @param node [Parser::Ruby::AstNode] a Ruby node
  # @raise [NotImplementedError]
  # @return [Boolean] whether the +node+ matches the handler
  #
  # source://yard//lib/yard/handlers/ruby/base.rb#27
  def matches?(node); end

  protected

  # @return [String] the extension matcher value
  #
  # source://yard//lib/yard/handlers/ruby/base.rb#34
  def name; end
end

# Handlers for old Ruby 1.8 parser
#
# source://yard//lib/yard/autoload.rb#93
module YARD::Handlers::Ruby::Legacy; end

# Handles alias and alias_method calls
#
# source://yard//lib/yard/handlers/ruby/legacy/alias_handler.rb#3
class YARD::Handlers::Ruby::Legacy::AliasHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles +attr_*+ statements in modules/classes
#
# source://yard//lib/yard/handlers/ruby/legacy/attribute_handler.rb#3
class YARD::Handlers::Ruby::Legacy::AttributeHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# This is the base handler for the legacy parser. To implement a legacy
# handler, subclass this class.
#
# @abstract See {Handlers::Base} for subclassing information.
#
# source://yard//lib/yard/handlers/ruby/legacy/base.rb#9
class YARD::Handlers::Ruby::Legacy::Base < ::YARD::Handlers::Base
  include ::YARD::Parser::Ruby::Legacy::RubyToken

  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#44
  def call_params; end

  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#53
  def caller_method; end

  # Parses a statement's block with a set of state values. If the
  # statement has no block, nothing happens. A description of state
  # values can be found at {Handlers::Base#push_state}
  #
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] State options
  # @see Handlers::Base#push_state #push_state
  #
  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#35
  def parse_block(opts = T.unsafe(nil)); end

  private

  # Extracts method information for macro expansion only
  #
  # @return [Array<String,Array<Array<String>>>] the method name followed by method
  #   arguments (name and optional value)
  # @todo This is a duplicate implementation of {MethodHandler}. Refactor.
  #
  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#68
  def extract_method_details; end

  # The string value of a token. For example, the return value for the symbol :sym
  # would be :sym. The return value for a string +"foo #{ bar}"+ would be the literal
  # +"foo #{ bar}"+ without any interpolation. The return value of the identifier
  # 'test' would be the same value: 'test'. Here is a list of common types and
  # their return values:
  #
  # @example
  #   tokval(TokenList.new('"foo"').first) => "foo"
  #   tokval(TokenList.new(':foo').first) => :foo
  #   tokval(TokenList.new('CONSTANT').first, RubyToken::TkId) => "CONSTANT"
  #   tokval(TokenList.new('identifier').first, RubyToken::TkId) => "identifier"
  #   tokval(TokenList.new('3.25').first) => 3.25
  #   tokval(TokenList.new('/xyz/i').first) => /xyz/i
  # @param token [Token] The token of the class
  # @param accepted_types [Array<Class<Token>>, Symbol] The allowed token types that this token can be. Defaults to [{TkVal}].
  #   A list of types would be, for example, [+TkSTRING+, +TkSYMBOL+], to return
  #   the token's value if it is either of those types. If +TkVal+ is accepted,
  #   +TkNode+ is also accepted.
  #
  #   Certain symbol keys are allowed to specify multiple types in one fell swoop.
  #   These symbols are:
  #   :string       => +TkSTRING+, +TkDSTRING+, +TkDXSTRING+ and +TkXSTRING+
  #   :attr         => +TkSYMBOL+ and +TkSTRING+
  #   :identifier   => +TkIDENTIFIER, +TkFID+ and +TkGVAR+.
  #   :number       => +TkFLOAT+, +TkINTEGER+
  # @return [Object] if the token is one of the accepted types, in its real value form.
  #   It should be noted that identifiers and constants are kept in String form.
  # @return [nil] if the token is not any of the specified accepted types
  #
  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#112
  def tokval(token, *accepted_types); end

  # Returns a list of symbols or string values from a statement.
  # The list must be a valid comma delimited list, and values
  # will only be returned to the end of the list only.
  #
  # Example:
  #   attr_accessor :a, 'b', :c, :d => ['a', 'b', 'c', 'd']
  #   attr_accessor 'a', UNACCEPTED_TYPE, 'c' => ['a', 'c']
  #
  # The tokval list of a {Parser::Ruby::Legacy::TokenList} of the above
  # code would be the {#tokval} value of :a, 'b',
  # :c and :d.
  #
  # It should also be noted that this function stops immediately at
  # any ruby keyword encountered:
  #   "attr_accessor :a, :b, :c if x == 5"  => ['a', 'b', 'c']
  #
  # @param tokenlist [TokenList] The list of tokens to process.
  # @param accepted_types [Array<Class<Token>>] passed to {#tokval}
  # @return [Array<String>] the list of tokvalues in the list.
  # @return [Array<EMPTY>] if there are no symbols or Strings in the list
  # @see #tokval
  #
  # source://yard//lib/yard/handlers/ruby/legacy/base.rb#178
  def tokval_list(tokenlist, *accepted_types); end

  class << self
    # @return [Boolean] whether or not a {Parser::Ruby::Legacy::Statement} object should be handled
    #   by this handler.
    #
    # source://yard//lib/yard/handlers/ruby/legacy/base.rb#15
    def handles?(stmt); end
  end
end

# Matches if/unless conditions inside classes and attempts to process only
# one branch (by evaluating the condition if possible).
#
# @example A simple class conditional
#   class Foo
#   if 0
#   # This method is ignored
#   def xyz; end
#   end
#   end
# @since 0.5.4
#
# source://yard//lib/yard/handlers/ruby/legacy/class_condition_handler.rb#4
class YARD::Handlers::Ruby::Legacy::ClassConditionHandler < ::YARD::Handlers::Ruby::Legacy::Base
  protected

  # Parses the condition part of the if/unless statement
  #
  # @return [true, false, nil] true if the condition can be definitely
  #   parsed to true, false if not, and nil if the condition cannot be
  #   parsed with certainty (it's dynamic)
  # @since 0.5.5
  #
  # source://yard//lib/yard/handlers/ruby/legacy/class_condition_handler.rb#29
  def parse_condition; end

  # @since 0.5.5
  #
  # source://yard//lib/yard/handlers/ruby/legacy/class_condition_handler.rb#73
  def parse_else_block; end

  # @since 0.5.5
  #
  # source://yard//lib/yard/handlers/ruby/legacy/class_condition_handler.rb#68
  def parse_then_block; end
end

# Handles class declarations
#
# source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ClassHandler < ::YARD::Handlers::Ruby::Legacy::Base
  include ::YARD::Handlers::Ruby::StructHandlerMethods

  private

  # source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#74
  def create_struct_superclass(superclass, superclass_def); end

  # Extracts the parameter list from the Struct.new declaration and returns it
  # formatted as a list of member names. Expects the user will have used symbols
  # to define the struct member names
  #
  # @param superstring [String] the string declaring the superclass
  # @return [Array<String>] a list of member names
  #
  # source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#69
  def extract_parameters(superstring); end

  # source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#95
  def parse_struct_subclass(klass, superclass_def); end

  # source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#102
  def parse_superclass(superclass); end

  # source://yard//lib/yard/handlers/ruby/legacy/class_handler.rb#83
  def struct_superclass_name(superclass); end
end

# Handles a class variable (@@variable)
#
# source://yard//lib/yard/handlers/ruby/legacy/class_variable_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ClassVariableHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# source://yard//lib/yard/handlers/ruby/legacy/class_variable_handler.rb#4
YARD::Handlers::Ruby::Legacy::ClassVariableHandler::HANDLER_MATCH = T.let(T.unsafe(nil), Regexp)

# Handles any lone comment statement in a Ruby file
#
# source://yard//lib/yard/handlers/ruby/legacy/comment_handler.rb#3
class YARD::Handlers::Ruby::Legacy::CommentHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles any constant assignment
#
# source://yard//lib/yard/handlers/ruby/legacy/constant_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ConstantHandler < ::YARD::Handlers::Ruby::Legacy::Base
  include ::YARD::Handlers::Ruby::StructHandlerMethods

  private

  # source://yard//lib/yard/handlers/ruby/legacy/constant_handler.rb#25
  def extract_parameters(parameters); end

  # source://yard//lib/yard/handlers/ruby/legacy/constant_handler.rb#20
  def process_structclass(classname, parameters); end
end

# source://yard//lib/yard/handlers/ruby/legacy/constant_handler.rb#5
YARD::Handlers::Ruby::Legacy::ConstantHandler::HANDLER_MATCH = T.let(T.unsafe(nil), Regexp)

# Handles automatic detection of dsl-style methods
#
# source://yard//lib/yard/handlers/ruby/legacy/dsl_handler.rb#7
class YARD::Handlers::Ruby::Legacy::DSLHandler < ::YARD::Handlers::Ruby::Legacy::Base
  include ::YARD::Handlers::Ruby::DSLHandlerMethods
end

# Handles 'raise' calls inside methods
#
# source://yard//lib/yard/handlers/ruby/legacy/exception_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ExceptionHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles 'extend' call to include modules into the class scope of another
#
# @see MixinHandler
#
# source://yard//lib/yard/handlers/ruby/legacy/extend_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ExtendHandler < ::YARD::Handlers::Ruby::Legacy::MixinHandler
  # source://yard//lib/yard/handlers/ruby/legacy/extend_handler.rb#7
  def scope; end

  private

  # source://yard//lib/yard/handlers/ruby/legacy/extend_handler.rb#11
  def process_mixin(mixin); end
end

# Handles a method definition
#
# source://yard//lib/yard/handlers/ruby/legacy/method_handler.rb#3
class YARD::Handlers::Ruby::Legacy::MethodHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles the 'include' statement to mixin a module in the instance scope
#
# source://yard//lib/yard/handlers/ruby/legacy/mixin_handler.rb#3
class YARD::Handlers::Ruby::Legacy::MixinHandler < ::YARD::Handlers::Ruby::Legacy::Base
  private

  # @raise [YARD::Parser::UndocumentableError]
  #
  # source://yard//lib/yard/handlers/ruby/legacy/mixin_handler.rb#26
  def process_mixin(mixin); end
end

# Handles module_function calls to turn methods into public class methods.
# Also creates a private instance copy of the method.
#
# source://yard//lib/yard/handlers/ruby/legacy/module_function_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ModuleFunctionHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles the declaration of a module
#
# source://yard//lib/yard/handlers/ruby/legacy/module_handler.rb#3
class YARD::Handlers::Ruby::Legacy::ModuleHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Sets visibility of a class method to private.
#
# source://yard//lib/yard/handlers/ruby/legacy/private_class_method_handler.rb#3
class YARD::Handlers::Ruby::Legacy::PrivateClassMethodHandler < ::YARD::Handlers::Ruby::Legacy::Base
  private

  # source://yard//lib/yard/handlers/ruby/legacy/private_class_method_handler.rb#15
  def privatize_class_method(name); end
end

# Sets visibility of a constant (class, module, const)
#
# source://yard//lib/yard/handlers/ruby/legacy/private_constant_handler.rb#3
class YARD::Handlers::Ruby::Legacy::PrivateConstantHandler < ::YARD::Handlers::Ruby::Legacy::Base
  private

  # source://yard//lib/yard/handlers/ruby/legacy/private_constant_handler.rb#15
  def privatize_constant(name); end
end

# Handles 'private', 'protected', and 'public' calls.
#
# source://yard//lib/yard/handlers/ruby/legacy/visibility_handler.rb#3
class YARD::Handlers::Ruby::Legacy::VisibilityHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# Handles 'yield' calls
#
# source://yard//lib/yard/handlers/ruby/legacy/yield_handler.rb#3
class YARD::Handlers::Ruby::Legacy::YieldHandler < ::YARD::Handlers::Ruby::Legacy::Base; end

# source://yard//lib/yard/handlers/ruby/base.rb#37
class YARD::Handlers::Ruby::MethodCallWrapper < ::YARD::Handlers::Ruby::HandlesExtension
  # @return [Boolean]
  #
  # source://yard//lib/yard/handlers/ruby/base.rb#38
  def matches?(node); end
end

# Handles a conditional inside a method
#
# source://yard//lib/yard/handlers/ruby/method_condition_handler.rb#3
class YARD::Handlers::Ruby::MethodConditionHandler < ::YARD::Handlers::Ruby::Base; end

# Handles a method definition
#
# source://yard//lib/yard/handlers/ruby/method_handler.rb#3
class YARD::Handlers::Ruby::MethodHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Common::MethodHandler

  # source://yard//lib/yard/handlers/ruby/method_handler.rb#69
  def format_args; end
end

# Handles the 'include' statement to mixin a module in the instance scope
#
# source://yard//lib/yard/handlers/ruby/mixin_handler.rb#3
class YARD::Handlers::Ruby::MixinHandler < ::YARD::Handlers::Ruby::Base
  protected

  # @raise [YARD::Parser::UndocumentableError]
  #
  # source://yard//lib/yard/handlers/ruby/mixin_handler.rb#25
  def process_mixin(mixin); end

  # source://yard//lib/yard/handlers/ruby/mixin_handler.rb#50
  def recipient(mixin); end
end

# Handles module_function calls to turn methods into public class methods.
# Also creates a private instance copy of the method.
#
# source://yard//lib/yard/handlers/ruby/module_function_handler.rb#4
class YARD::Handlers::Ruby::ModuleFunctionHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::DecoratorHandlerMethods

  # source://yard//lib/yard/handlers/ruby/module_function_handler.rb#34
  def make_module_function(instance_method, namespace); end
end

# Handles the declaration of a module
#
# source://yard//lib/yard/handlers/ruby/module_handler.rb#3
class YARD::Handlers::Ruby::ModuleHandler < ::YARD::Handlers::Ruby::Base; end

# Sets visibility of a class method to private.
#
# source://yard//lib/yard/handlers/ruby/private_class_method_handler.rb#3
class YARD::Handlers::Ruby::PrivateClassMethodHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::DecoratorHandlerMethods
end

# Sets visibility of a constant (class, module, const)
#
# source://yard//lib/yard/handlers/ruby/private_constant_handler.rb#6
class YARD::Handlers::Ruby::PrivateConstantHandler < ::YARD::Handlers::Ruby::Base
  private

  # source://yard//lib/yard/handlers/ruby/private_constant_handler.rb#28
  def privatize_constant(node); end
end

# Sets visibility of a class method to public.
#
# source://yard//lib/yard/handlers/ruby/public_class_method_handler.rb#3
class YARD::Handlers::Ruby::PublicClassMethodHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::DecoratorHandlerMethods
end

# Helper methods to parse @attr_* tags on a class.
#
# @deprecated The use of +@attr+ tags are deprecated since 0.8.0 in favour of
#   the +@!attribute+ directive. This module should not be relied on.
# @since 0.5.6
#
# source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#7
module YARD::Handlers::Ruby::StructHandlerMethods
  include ::YARD::CodeObjects

  # Creates the auto-generated docstring for the getter method of a struct's
  # member. This is used so the generated documentation will look just like that
  # of an attribute defined using attr_accessor.
  #
  # @param klass [ClassObject] the class whose members we're working with
  # @param member [String] the name of the member we're generating documentation for
  # @return [String] a docstring to be attached to the getter method for this member
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#62
  def add_reader_tags(klass, new_method, member); end

  # Creates the auto-generated docstring for the setter method of a struct's
  # member. This is used so the generated documentation will look just like that
  # of an attribute defined using attr_accessor.
  #
  # @param klass [ClassObject] the class whose members we're working with
  # @param member [String] the name of the member we're generating documentation for
  # @return [String] a docstring to be attached to the setter method for this member
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#77
  def add_writer_tags(klass, new_method, member); end

  # Creates the given member methods and attaches them to the given ClassObject.
  #
  # @param klass [ClassObject] the class to generate attributes for
  # @param members [Array<String>] a list of member names
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#134
  def create_attributes(klass, members); end

  # Creates and registers a class object with the given name and superclass name.
  # Returns it for further use.
  #
  # @param classname [String] the name of the class
  # @param superclass [String] the name of the superclass
  # @return [ClassObject] the class object for further processing/method attaching
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#92
  def create_class(classname, superclass); end

  # Determines whether to create an attribute method based on the class's
  # tags.
  #
  # @param klass [ClassObject] the class whose tags we're searching
  # @param member [String] the name of the struct member we need
  # @param type [Symbol] (:read) reader method, or writer method?
  # @return [Boolean] should the attribute be created?
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#38
  def create_member_method?(klass, member, type = T.unsafe(nil)); end

  # Creates the getter (reader) method and attaches it to the class as an attribute.
  # Also sets up the docstring to prettify the documentation output.
  #
  # @param klass [ClassObject] the class to attach the method to
  # @param member [String] the name of the member we're generating a method for
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#121
  def create_reader(klass, member); end

  # Creates the setter (writer) method and attaches it to the class as an attribute.
  # Also sets up the docstring to prettify the documentation output.
  #
  # @param klass [ClassObject] the class to attach the method to
  # @param member [String] the name of the member we're generating a method for
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#104
  def create_writer(klass, member); end

  # Extracts the user's defined @member tag for a given class and its member. Returns
  # nil if the user did not define a @member tag for this struct entry.
  #
  # @param klass [ClassObject] the class whose tags we're searching
  # @param member [String] the name of the struct member we need
  # @param type [Symbol] reader method, or writer method?
  # @return [Tags::Tag, nil] the tag matching the request, or nil if not found
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#17
  def member_tag_for_member(klass, member, type = T.unsafe(nil)); end

  # Retrieves all members defined in @attr* tags
  #
  # @param klass [ClassObject] the class with the attributes
  # @return [Array<String>] the list of members defined as attributes on the class
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#26
  def members_from_tags(klass); end

  # Gets the return type for the member in a nicely formatted string. Used
  # to be injected into auto-generated docstrings.
  #
  # @param member_tag [Tags::Tag] the tag object to check for types
  # @return [String] the user-declared type of the struct member, or [Object] if
  #   the user did not define a type for this member.
  # @since 0.5.6
  #
  # source://yard//lib/yard/handlers/ruby/struct_handler_methods.rb#51
  def return_type_from_tag(member_tag); end
end

# source://yard//lib/yard/handlers/ruby/base.rb#53
class YARD::Handlers::Ruby::TestNodeWrapper < ::YARD::Handlers::Ruby::HandlesExtension
  # @return [Boolean]
  #
  # source://yard//lib/yard/handlers/ruby/base.rb#54
  def matches?(node); end
end

# Handles 'private', 'protected', and 'public' calls.
#
# source://yard//lib/yard/handlers/ruby/visibility_handler.rb#3
class YARD::Handlers::Ruby::VisibilityHandler < ::YARD::Handlers::Ruby::Base
  include ::YARD::Handlers::Ruby::DecoratorHandlerMethods

  # @return [Boolean]
  #
  # source://yard//lib/yard/handlers/ruby/visibility_handler.rb#31
  def is_attribute_method?(node); end
end

# Handles 'yield' calls
#
# source://yard//lib/yard/handlers/ruby/yield_handler.rb#3
class YARD::Handlers::Ruby::YieldHandler < ::YARD::Handlers::Ruby::Base; end

# Namespace for internationalization (i18n)
#
# @since 0.8.0
#
# source://yard//lib/yard/autoload.rb#151
module YARD::I18n; end

# +Locale+ is a unit of translation. It has {#name} and a set of
# messages.
#
# @since 0.8.2
#
# source://yard//lib/yard/i18n/locale.rb#8
class YARD::I18n::Locale
  # Creates a locale for +name+ locale.
  #
  # @param name [String] the locale name.
  # @return [Locale] a new instance of Locale
  # @since 0.8.2
  #
  # source://yard//lib/yard/i18n/locale.rb#34
  def initialize(name); end

  # Loads translation messages from +locale_directory+/{#name}.po.
  #
  # @param locale_directory [String] the directory path that has
  #   {#name}.po.
  # @return [Boolean] +true+ if PO file exists, +false+ otherwise.
  # @since 0.8.2
  #
  # source://yard//lib/yard/i18n/locale.rb#44
  def load(locale_directory); end

  # @return [String] the name of the locale. It used IETF language
  #   tag format +[language[_territory][.codeset][@modifier]]+.
  # @see http://tools.ietf.org/rfc/bcp/bcp47.txt BCP 47 - Tags for Identifying Languages
  # @since 0.8.2
  #
  # source://yard//lib/yard/i18n/locale.rb#29
  def name; end

  # @param message [String] the translation target message.
  # @return [String] translated message. If translation isn't
  #   registered, the +message+ is returned.
  # @since 0.8.2
  #
  # source://yard//lib/yard/i18n/locale.rb#62
  def translate(message); end

  class << self
    # @return [String, nil] the default locale name.
    # @since 0.8.4
    #
    # source://yard//lib/yard/i18n/locale.rb#15
    def default; end

    # @return [String, nil] the default locale name.
    # @since 0.8.4
    #
    # source://yard//lib/yard/i18n/locale.rb#20
    def default=(locale); end
  end
end

# +Message+ is a translation target message. It has message ID as
# {#id} and some properties {#locations} and {#comments}.
#
# @since 0.8.1
#
# source://yard//lib/yard/i18n/message.rb#10
class YARD::I18n::Message
  # Creates a translate target message for message ID +id+.
  #
  # @param id [String] the message ID of the translate target message.
  # @return [Message] a new instance of Message
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#24
  def initialize(id); end

  # @param other [Message] the +Message+ to be compared.
  # @return [Boolean] checks whether this message is equal to another.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#49
  def ==(other); end

  # Adds a comment for the message.
  #
  # @param comment [String] the comment for the message to be added.
  # @return [void]
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#43
  def add_comment(comment); end

  # Adds location information for the message.
  #
  # @param path [String] the path where the message appears.
  # @param line [Integer] the line number where the message appears.
  # @return [void]
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#35
  def add_location(path, line); end

  # @return [Set] the set of comments for the messages.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#19
  def comments; end

  # @return [String] the message ID of the translation target message.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#12
  def id; end

  # path and line number where the message is appeared.
  #
  # @return [Set] the set of locations. Location is an array of
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/message.rb#16
  def locations; end
end

# Acts as a container for {Message} objects.
#
# @since 0.8.1
#
# source://yard//lib/yard/i18n/messages.rb#7
class YARD::I18n::Messages
  include ::Enumerable

  # Creates a new container.
  #
  # @return [Messages] a new instance of Messages
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/messages.rb#11
  def initialize; end

  # Checks if this messages list is equal to another messages list.
  #
  # @param other [Messages] the container to compare.
  # @return [Boolean] whether +self+ and +other+ is equivalence or not.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/messages.rb#45
  def ==(other); end

  # @param id [String] the message ID to perform a lookup on.
  # @return [Message, nil] a registered message for the given +id+,
  #   or nil if no message for the ID is found.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/messages.rb#27
  def [](id); end

  # Enumerates each {Message} in the container.
  #
  # @return [void]
  # @since 0.8.1
  # @yieldparam message [Message] the next message object in
  #   the enumeration.
  #
  # source://yard//lib/yard/i18n/messages.rb#20
  def each(&block); end

  # Registers a {Message}, the message ID of which is +id+. If
  # corresponding +Message+ is already registered, the previously
  # registered object is returned.
  #
  # @param id [String] the ID of the message to be registered.
  # @return [Message] the registered +Message+.
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/messages.rb#37
  def register(id); end

  protected

  # @return [Hash{String=>Message}] the set of message objects
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/messages.rb#53
  def messages; end
end

# The +PotGenerator+ generates POT format string from
# {CodeObjects::Base} and {CodeObjects::ExtraFileObject}.
#
# == POT and PO
#
# POT is an acronym for "Portable Object Template". POT is a
# template file to create PO file. The extension for POT is
# ".pot". PO file is an acronym for "Portable Object". PO file has
# many parts of message ID (msgid) that is translation target
# message and message string (msgstr) that is translated message
# of message ID. If you want to translate "Hello" in English into
# "Bonjour" in French, "Hello" is the msgid ID and "Bonjour" is
# msgstr. The extension for PO is ".po".
#
# == How to extract msgids
#
# The +PotGenerator+ has two parse methods:
#
# * {#parse_objects} for {CodeObjects::Base}
# * {#parse_files} for {CodeObjects::ExtraFileObject}
#
# {#parse_objects} extracts msgids from docstring and tags of
# {CodeObjects::Base} objects. The docstring of
# {CodeObjects::Base} object is parsed and a paragraph is
# extracted as a msgid. Tag name and tag text are extracted as
# msgids from a tag.
#
# {#parse_files} extracts msgids from
# {CodeObjects::ExtraFileObject} objects. The file content of
# {CodeObjects::ExtraFileObject} object is parsed and a paragraph
# is extracted as a msgid.
#
# == Usage
#
# To create a .pot file by +PotGenerator+, instantiate a
# +PotGenerator+ with a relative working directory path from a
# directory path that has created .pot file, parse
# {CodeObjects::Base} objects and {CodeObjects::ExtraFileObject}
# objects, generate a POT and write the generated POT to a .pot
# file. The relative working directory path is ".." when the
# working directory path is "."  and the POT is wrote into
# "po/yard.pot".
#
# @example Generate a .pot file
#   po_file_path = "po/yard.pot"
#   po_file_directory_pathname = Pathname.new(po_file_path).directory)
#   working_directory_pathname = Pathname.new(".")
#   relative_base_path = working_directory_pathname.relative_path_from(po_file_directory_pathname).to_s
#   # relative_base_path -> ".."
#   generator = YARD::I18n::PotGenerator.new(relative_base_path)
#   generator.parse_objects(objects)
#   generator.parse_files(files)
#   pot = generator.generate
#   po_file_directory_pathname.mkpath
#   File.open(po_file_path, "w") do |pot_file|
#   pot_file.print(pot)
#   end
# @see http://www.gnu.org/software/gettext/manual/html_node/PO-Files.html GNU gettext manual about details of PO file
# @since 0.8.0
#
# source://yard//lib/yard/i18n/pot_generator.rb#65
class YARD::I18n::PotGenerator
  # Creates a POT generator that uses +relative_base_path+ to
  # generate locations for a msgid. +relative_base_path+ is
  # prepended to all locations.
  #
  # @param relative_base_path [String] a relative working
  #   directory path from a directory path that has created .pot
  #   file.
  # @return [PotGenerator] a new instance of PotGenerator
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#79
  def initialize(relative_base_path); end

  # Generates POT from +@messages+.
  #
  # One PO file entry is generated from a +Message+ in
  # +@messages+.
  #
  # Locations of the +Message+ are used to generate the reference
  # line that is started with "#: ". +relative_base_path+ passed
  # when the generator is created is prepended to each path in location.
  #
  # Comments of the +Message+ are used to generate the
  # translator-comment line that is started with "# ".
  #
  # @return [String] POT format string
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#122
  def generate; end

  # Extracted messages.
  #
  # @return [Messages]
  # @since 0.8.1
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#70
  def messages; end

  # Parses {CodeObjects::ExtraFileObject} objects and stores
  # extracted msgids into {#messages}.
  #
  # @param files [Array<CodeObjects::ExtraFileObject>] a list
  #   of {CodeObjects::ExtraFileObject} objects to be parsed.
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#103
  def parse_files(files); end

  # Parses {CodeObjects::Base} objects and stores extracted msgids
  # into {#messages}
  #
  # @param objects [Array<CodeObjects::Base>] a list of
  #   {CodeObjects::Base} to be parsed.
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#91
  def parse_objects(objects); end

  private

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#160
  def current_time; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#183
  def escape_message_id(message_id); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#194
  def extract_documents(object); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#268
  def extract_paragraphs(file); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#235
  def extract_tag_documents(tag); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#242
  def extract_tag_name(tag); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#255
  def extract_tag_text(tag); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#168
  def generate_message(pot, message); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#164
  def generate_pot_creation_date_value; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#136
  def header; end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/pot_generator.rb#190
  def register_message(id); end
end

# Provides some convenient features for translating a text.
#
# @since 0.8.0
#
# source://yard//lib/yard/i18n/text.rb#5
class YARD::I18n::Text
  # Creates a text object that has translation related features for
  # the input text.
  #
  # @option options
  # @param input [#each_line] a text to be translated.
  # @param options [Hash] a customizable set of options
  # @return [Text] a new instance of Text
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/text.rb#12
  def initialize(input, options = T.unsafe(nil)); end

  # Extracts translation target messages from +@input+.
  #
  # @return [void]
  # @since 0.8.0
  # @yield [:attribute, name, value, line_no] the block that
  #   receives extracted an attribute in header. It may called many
  #   times.
  # @yield [:paragraph, text, start_line_no] the block that
  #   receives extracted a paragraph in body. Paragraph is a text
  #   block separated by one or more empty lines. Empty line is a
  #   line that contains only zero or more whitespaces. It may
  #   called many times.
  # @yieldparam text [String] the text of extracted paragraph.
  # @yieldparam start_line_no [Integer] the start line number of
  #   extracted paragraph.
  # @yieldparam name [String] the name of extracted attribute.
  # @yieldparam value [String] the value of extracted attribute.
  # @yieldparam line_no [Integer] the defined line number of extracted
  #   attribute.
  #
  # source://yard//lib/yard/i18n/text.rb#35
  def extract_messages; end

  # Translates into +locale+.
  #
  # @param locale [Locale] the translation target locale.
  # @return [String] translated text.
  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/text.rb#52
  def translate(locale); end

  private

  # @since 0.8.0
  # @yield [part]
  #
  # source://yard//lib/yard/i18n/text.rb#134
  def emit_attribute_event(match_data, line_no); end

  # @since 0.8.0
  # @yield [part]
  #
  # source://yard//lib/yard/i18n/text.rb#147
  def emit_empty_line_event(line, line_no); end

  # @since 0.8.0
  # @yield [part]
  #
  # source://yard//lib/yard/i18n/text.rb#125
  def emit_markup_event(line, line_no); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/text.rb#156
  def emit_paragraph_event(paragraph, paragraph_start_line, line_no, &block); end

  # @since 0.8.0
  #
  # source://yard//lib/yard/i18n/text.rb#76
  def parse(&block); end
end

# Handles console logging for info, warnings and errors.
# Uses the stdlib Logger class in Ruby for all the backend logic.
#
# source://yard//lib/yard/logging.rb#8
class YARD::Logger
  include ::YARD::Logger::Severity

  # Creates a new logger
  #
  # @private
  # @return [Logger] a new instance of Logger
  #
  # source://yard//lib/yard/logging.rb#82
  def initialize(pipe, *args); end

  # Displays an unformatted line to the logger output stream.
  #
  # @param msg [String] the message to display
  # @return [void]
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#205
  def <<(msg = T.unsafe(nil)); end

  # Prints the backtrace +exc+ to the logger as error data.
  #
  # @param exc [Array<String>] the backtrace list
  # @param level_meth [Symbol] the level to log backtrace at
  # @return [void]
  #
  # source://yard//lib/yard/logging.rb#216
  def backtrace(exc, level_meth = T.unsafe(nil)); end

  # Captures the duration of a block of code for benchmark analysis. Also
  # calls {#progress} on the message to display it to the user.
  #
  # @param msg [String] the message to display
  # @param nontty_log [Symbol, nil] the level to log as if the output
  #   stream is not a TTY. Use +nil+ for no alternate logging.
  # @return [void]
  # @todo Implement capture storage for reporting of benchmarks
  # @yield a block of arbitrary code to benchmark
  #
  # source://yard//lib/yard/logging.rb#234
  def capture(msg, nontty_log = T.unsafe(nil)); end

  # Clears the progress indicator in the TTY display.
  #
  # @return [void]
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#186
  def clear_progress; end

  # Changes the debug level to DEBUG if $DEBUG is set and writes a debugging message.
  # Logs a message with the debug severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def debug(message); end

  # Sets the logger level for the duration of the block
  #
  # @example
  #   log.enter_level(Logger::ERROR) do
  #   YARD.parse_string "def x; end"
  #   end
  # @param new_level [Fixnum] the logger level for the duration of the block.
  #   values can be found in Ruby's Logger class.
  # @yield the block with the logger temporarily set to +new_level+
  #
  # source://yard//lib/yard/logging.rb#142
  def enter_level(new_level = T.unsafe(nil)); end

  # Logs a message with the error severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def error(message); end

  # Logs a message with the fatal severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def fatal(message); end

  # Logs a message with the info severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def info(message); end

  # @return [IO] the IO object being logged to
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#49
  def io; end

  # @return [IO] the IO object being logged to
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#49
  def io=(_arg0); end

  # @return [DEBUG, INFO, WARN, ERROR, FATAL, UNKNOWN] the logging level
  #
  # source://yard//lib/yard/logging.rb#57
  def level; end

  # @return [DEBUG, INFO, WARN, ERROR, FATAL, UNKNOWN] the logging level
  #
  # source://yard//lib/yard/logging.rb#57
  def level=(_arg0); end

  # Logs a message with a given severity
  #
  # @param severity [DEBUG, INFO, WARN, ERROR, FATAL, UNKNOWN] the severity level
  # @param message [String] the message to log
  #
  # source://yard//lib/yard/logging.rb#122
  def log(severity, message); end

  # Displays an unformatted line to the logger output stream.
  #
  # @param msg [String] the message to display
  # @return [void]
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#205
  def print(msg = T.unsafe(nil)); end

  # Displays a progress indicator for a given message. This progress report
  # is only displayed on TTY displays, otherwise the message is passed to
  # the +nontty_log+ level.
  #
  # @param msg [String] the message to log
  # @param nontty_log [Symbol, nil] the level to log as if the output
  #   stream is not a TTY. Use +nil+ for no alternate logging.
  # @return [void]
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#161
  def progress(msg, nontty_log = T.unsafe(nil)); end

  # Displays an unformatted line to the logger output stream, adding
  # a newline.
  #
  # @param msg [String] the message to display
  # @return [void]
  # @since 0.8.2
  #
  # source://yard//lib/yard/logging.rb#197
  def puts(msg = T.unsafe(nil)); end

  # @return [Boolean] whether backtraces should be shown (by default
  #   this is on).
  #
  # source://yard//lib/yard/logging.rb#53
  def show_backtraces; end

  # Sets the attribute show_backtraces
  #
  # @param value the value to set the attribute show_backtraces to.
  #
  # source://yard//lib/yard/logging.rb#54
  def show_backtraces=(_arg0); end

  # @return [Boolean] whether progress indicators should be shown when
  #   logging CLIs (by default this is off).
  #
  # source://yard//lib/yard/logging.rb#64
  def show_progress; end

  # Sets the attribute show_progress
  #
  # @param value the value to set the attribute show_progress to.
  #
  # source://yard//lib/yard/logging.rb#70
  def show_progress=(_arg0); end

  # Logs a message with the unknown severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def unknown(message); end

  # Remembers when a warning occurs and writes a warning message.
  # Logs a message with the warn severity level.
  #
  # @param message [String] the message to log
  # @return [void]
  # @see #log
  #
  # source://yard//lib/yard/logging.rb#103
  def warn(message); end

  # Warns that the Ruby environment does not support continuations. Applies
  # to JRuby, Rubinius and MacRuby. This warning will only display once
  # per Ruby process.
  #
  # @deprecated Continuations are no longer needed by YARD 0.8.0+.
  # @private
  # @return [void]
  #
  # source://yard//lib/yard/logging.rb#250
  def warn_no_continuations; end

  # @return [Boolean] whether a warn message has been emitted. Used for status tracking.
  #
  # source://yard//lib/yard/logging.rb#60
  def warned; end

  # @return [Boolean] whether a warn message has been emitted. Used for status tracking.
  #
  # source://yard//lib/yard/logging.rb#60
  def warned=(_arg0); end

  private

  # source://yard//lib/yard/logging.rb#255
  def clear_line; end

  class << self
    # @private
    #
    # source://yard//lib/yard/logging.rb#101
    def create_log_method(name); end

    # The logger instance
    #
    # @return [Logger] the logger instance
    #
    # source://yard//lib/yard/logging.rb#76
    def instance(pipe = T.unsafe(nil)); end
  end
end

# The list of characters displayed beside the progress bar to indicate
# "movement".
#
# @since 0.8.2
#
# source://yard//lib/yard/logging.rb#45
YARD::Logger::PROGRESS_INDICATORS = T.let(T.unsafe(nil), Array)

# Log severity levels
#
# source://yard//lib/yard/logging.rb#10
module YARD::Logger::Severity; end

# Debugging log level
#
# source://yard//lib/yard/logging.rb#12
YARD::Logger::Severity::DEBUG = T.let(T.unsafe(nil), Integer)

# Error log level
#
# source://yard//lib/yard/logging.rb#21
YARD::Logger::Severity::ERROR = T.let(T.unsafe(nil), Integer)

# Fatal log level
#
# source://yard//lib/yard/logging.rb#24
YARD::Logger::Severity::FATAL = T.let(T.unsafe(nil), Integer)

# Information log level
#
# source://yard//lib/yard/logging.rb#15
YARD::Logger::Severity::INFO = T.let(T.unsafe(nil), Integer)

# @private
#
# source://yard//lib/yard/logging.rb#30
YARD::Logger::Severity::SEVERITIES = T.let(T.unsafe(nil), Hash)

# Unknown log level
#
# source://yard//lib/yard/logging.rb#27
YARD::Logger::Severity::UNKNOWN = T.let(T.unsafe(nil), Integer)

# Warning log level
#
# source://yard//lib/yard/logging.rb#18
YARD::Logger::Severity::WARN = T.let(T.unsafe(nil), Integer)

# An OpenStruct compatible struct class that allows for basic access of attributes
# via +struct.attr_name+ and +struct.attr_name = value+.
#
# source://yard//lib/yard/open_struct.rb#4
class YARD::OpenStruct
  # @return [OpenStruct] a new instance of OpenStruct
  #
  # source://yard//lib/yard/open_struct.rb#5
  def initialize(hash = T.unsafe(nil)); end

  # source://yard//lib/yard/open_struct.rb#25
  def ==(other); end

  # source://yard//lib/yard/open_struct.rb#41
  def [](key); end

  # source://yard//lib/yard/open_struct.rb#37
  def []=(key, value); end

  # source://yard//lib/yard/open_struct.rb#33
  def dig(*keys); end

  # source://yard//lib/yard/open_struct.rb#45
  def each_pair(&block); end

  # source://yard//lib/yard/open_struct.rb#29
  def hash; end

  # source://yard//lib/yard/open_struct.rb#49
  def marshal_dump; end

  # source://yard//lib/yard/open_struct.rb#53
  def marshal_load(data); end

  # @private
  #
  # source://yard//lib/yard/open_struct.rb#10
  def method_missing(name, *args); end

  # source://yard//lib/yard/open_struct.rb#21
  def to_h; end

  private

  # source://yard//lib/yard/open_struct.rb#59
  def __cache_lookup__(name); end
end

# Generalized options class for passing around large amounts of options between objects.
#
# The options class exists for better visibility and documentability of options being
# passed through to other objects. Because YARD has parser and template architectures
# that are heavily reliant on options, it is necessary to make these option keys easily
# visible and understood by developers. Since the options class is more than just a
# basic Hash, the subclass can provide aliasing and convenience methods to simplify
# option property access, and, if needed, support backward-compatibility for deprecated
# key names.
#
# == Hash and OpenStruct-like Access
#
# Although the options class allows for Hash-like access (<tt>opts[:key]</tt>), the recommended
# mechanism for accessing an option key will be via standard method calls on attributes
#
# The options class can also act as an open ended key value storage structure (like a
# Hash or OpenStruct), and allows for setting and getting of unregistered option keys.
# This methodology is not recommended, however, and is only supported for backward
# compatibility inside YARD. Whenever possible, developers should define all keys used
# by an options class.
#
# == Declaring Default Values
#
# Note that the options class can contain default value definitions for certain options,
# but to initialize these defaults, {#reset_defaults} must be called manually after
# initialization; the options object is always created empty until defaults are applied.
#
# @abstract Subclasses should define (and document) custom attributes that are expected
#   to be made available as option keys.
# @example Defining an Options class with custom option keys
#   class TemplateOptions < YARD::Options
#   # @return [Symbol] the output format to generate templates in
#   attr_accessor :format
#
#   # @return [Symbol] the template to use when generating output
#   attr_accessor :template
#   end
# @example Initializing default option values
#   class TemplateOptions < YARD::Options
#   def reset_defaults
#   super
#   self.format = :html
#   self.template = :default
#   self.highlight = true
#   # ...
#   end
#   end
# @example Using +default_attr+ to create default attributes
#   class TemplateOptions < YARD::Options
#   default_attr :format, :html
#   default_attr :template, :default
#   default_attr :highlight, true
#   end
# @example Deprecating an option while still supporting it
#   class TemplateOptions < YARD::Options
#   # @return [Boolean] if syntax highlighting should be performed on code blocks.
#   #   Defaults to true.
#   attr_accessor :highlight
#
#   # @deprecated Use {#highlight} instead.
#   # @return [Boolean] if no syntax highlighting should be performs on code blocks.
#   #   Defaults to false.
#   attr_accessor :no_highlight
#   def no_highlight=(value) @highlight = !value end
#   def no_highlight; !highlight end
#   end
#
# source://yard//lib/yard/options.rb#69
class YARD::Options
  # @return [Boolean] whether another Options object equals the
  #   keys and values of this options object
  #
  # source://yard//lib/yard/options.rb#157
  def ==(other); end

  # Delegates calls with Hash syntax to actual method with key name
  #
  # @example Calling on an option key with Hash syntax
  #   options[:format] # equivalent to: options.format
  # @param key [Symbol, String] the option name to access
  # @return the value of the option named +key+
  #
  # source://yard//lib/yard/options.rb#91
  def [](key); end

  # Delegates setter calls with Hash syntax to the attribute setter with the key name
  #
  # @example Setting an option with Hash syntax
  #   options[:format] = :html # equivalent to: options.format = :html
  # @param key [Symbol, String] the option to set
  # @param value [Object] the value to set for the option
  # @return [Object] the value being set
  #
  # source://yard//lib/yard/options.rb#100
  def []=(key, value); end

  # Deletes an option value for +key+
  #
  # @param key [Symbol, String] the key to delete a value for
  # @return [Object] the value that was deleted
  #
  # source://yard//lib/yard/options.rb#207
  def delete(key); end

  # Yields over every option key and value
  #
  # @return [void]
  # @yield [key, value] every option key and value
  # @yieldparam key [Symbol] the option key
  # @yieldparam value [Object] the option value
  #
  # source://yard//lib/yard/options.rb#143
  def each; end

  # Inspects the object
  #
  # source://yard//lib/yard/options.rb#151
  def inspect; end

  # Creates a new options object and sets options hash or object value
  # onto that object.
  #
  # @param opts [Options, Hash]
  # @return [Options] the newly created options object
  # @see #update
  #
  # source://yard//lib/yard/options.rb#123
  def merge(opts); end

  # Handles setting and accessing of unregistered keys similar
  # to an OpenStruct object.
  #
  # @note It is not recommended to set and access unregistered keys on
  #   an Options object. Instead, register the attribute before using it.
  #
  # source://yard//lib/yard/options.rb#170
  def method_missing(meth, *args, &block); end

  # Resets all values to their defaults.
  #
  # @abstract Subclasses should override this method to perform custom
  #   value initialization if not using {default_attr}. Be sure to call
  #   +super+ so that default initialization can take place.
  # @return [void]
  #
  # source://yard//lib/yard/options.rb#188
  def reset_defaults; end

  # @return [Hash] Converts options object to an options hash. All keys
  #   will be symbolized.
  #
  # source://yard//lib/yard/options.rb#129
  def to_hash; end

  # Updates values from an options hash or options object on this object.
  # All keys passed should be key names defined by attributes on the class.
  #
  # @example Updating a set of options on an Options object
  #   opts.update(:template => :guide, :type => :fulldoc)
  # @param opts [Hash, Options]
  # @return [self]
  #
  # source://yard//lib/yard/options.rb#109
  def update(opts); end

  class << self
    # Defines an attribute named +key+ and sets a default value for it
    #
    # @example Defining a default option key
    #   default_attr :name, 'Default Name'
    #   default_attr :time, lambda { Time.now }
    # @param key [Symbol] the option key name
    # @param default [Object, Proc] the default object value. If the default
    #   value is a proc, it is executed upon initialization.
    #
    # source://yard//lib/yard/options.rb#80
    def default_attr(key, default); end
  end
end

# The parser namespace holds all parsing engines used by YARD.
# Currently only Ruby and C (Ruby) parsers are implemented.
#
# source://yard//lib/yard/autoload.rb#161
module YARD::Parser; end

# Represents the abstract base parser class that parses source code in
# a specific way. A parser should implement {#parse}, {#tokenize} and
# {#enumerator}.
#
# == Registering a Custom Parser
# To register a parser, see {SourceParser.register_parser_type}
#
# @abstract
# @see #parse
# @see #tokenize
# @see #enumerator
# @since 0.5.6
#
# source://yard//lib/yard/parser/base.rb#16
class YARD::Parser::Base
  # This default constructor does nothing. The subclass is responsible for
  # storing the source contents and filename if they are required.
  #
  # @param source [String] the source contents
  # @param filename [String] the name of the file if from disk
  # @raise [NotImplementedError]
  # @return [Base] a new instance of Base
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/base.rb#26
  def initialize(source, filename); end

  # This method should be implemented to return a list of semantic tokens
  # representing the source code to be post-processed. Otherwise the method
  # should return nil.
  #
  # @abstract
  # @return [Array] a list of semantic tokens representing the source code
  #   to be post-processed
  # @return [nil] if no post-processing should be done
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/base.rb#52
  def enumerator; end

  # This method should be implemented to parse the source and return itself.
  #
  # @abstract
  # @raise [NotImplementedError]
  # @return [Base] this method should return itself
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/base.rb#33
  def parse; end

  # This method should be implemented to tokenize given source
  #
  # @abstract
  # @raise [NotImplementedError]
  # @return [Array] a list/tree of lexical tokens
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/base.rb#40
  def tokenize; end

  class << self
    # Convenience method to create a new parser and {#parse}
    #
    # @since 0.5.6
    #
    # source://yard//lib/yard/parser/base.rb#18
    def parse(source, filename = T.unsafe(nil)); end
  end
end

# CRuby Parsing components
#
# source://yard//lib/yard/autoload.rb#162
module YARD::Parser::C; end

# source://yard//lib/yard/parser/c/statement.rb#41
class YARD::Parser::C::BodyStatement < ::YARD::Parser::C::Statement
  # Returns the value of attribute comments.
  #
  # source://yard//lib/yard/parser/c/statement.rb#42
  def comments; end

  # Sets the attribute comments
  #
  # @param value the value to set the attribute comments to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#42
  def comments=(_arg0); end
end

# source://yard//lib/yard/parser/c/c_parser.rb#5
class YARD::Parser::C::CParser < ::YARD::Parser::Base
  # @return [CParser] a new instance of CParser
  #
  # source://yard//lib/yard/parser/c/c_parser.rb#6
  def initialize(source, file = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#24
  def enumerator; end

  # source://yard//lib/yard/parser/c/c_parser.rb#19
  def parse; end

  # @raise [NotImplementedError]
  #
  # source://yard//lib/yard/parser/c/c_parser.rb#28
  def tokenize; end

  private

  # source://yard//lib/yard/parser/c/c_parser.rb#213
  def advance(num = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#216
  def advance_loop; end

  # source://yard//lib/yard/parser/c/c_parser.rb#195
  def attach_comment(statement); end

  # source://yard//lib/yard/parser/c/c_parser.rb#214
  def back(num = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#225
  def char(num = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#96
  def consume_body_statements; end

  # source://yard//lib/yard/parser/c/c_parser.rb#136
  def consume_comment(add_comment = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#59
  def consume_directive; end

  # source://yard//lib/yard/parser/c/c_parser.rb#47
  def consume_quote(type = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#73
  def consume_toplevel_statement; end

  # source://yard//lib/yard/parser/c/c_parser.rb#169
  def consume_until(end_char, bracket_level = T.unsafe(nil), brace_level = T.unsafe(nil), add_comment = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#132
  def consume_whitespace; end

  # source://yard//lib/yard/parser/c/c_parser.rb#227
  def nextchar(num = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#220
  def nextline; end

  # source://yard//lib/yard/parser/c/c_parser.rb#34
  def parse_toplevel; end

  # source://yard//lib/yard/parser/c/c_parser.rb#226
  def prevchar(num = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/c_parser.rb#118
  def strip_non_statement_data; end

  # source://yard//lib/yard/parser/c/c_parser.rb#229
  def struct; end
end

# source://yard//lib/yard/parser/c/statement.rb#51
class YARD::Parser::C::Comment < ::YARD::Parser::C::Statement
  include ::YARD::Parser::C::CommentParser

  # @return [Comment] a new instance of Comment
  #
  # source://yard//lib/yard/parser/c/statement.rb#58
  def initialize(source, file = T.unsafe(nil), line = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/c/statement.rb#62
  def comments; end

  # Returns the value of attribute overrides.
  #
  # source://yard//lib/yard/parser/c/statement.rb#55
  def overrides; end

  # Sets the attribute overrides
  #
  # @param value the value to set the attribute overrides to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#55
  def overrides=(_arg0); end

  # Returns the value of attribute statement.
  #
  # source://yard//lib/yard/parser/c/statement.rb#56
  def statement; end

  # Sets the attribute statement
  #
  # @param value the value to set the attribute statement to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#56
  def statement=(_arg0); end

  # Returns the value of attribute type.
  #
  # source://yard//lib/yard/parser/c/statement.rb#54
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#54
  def type=(_arg0); end
end

# source://yard//lib/yard/parser/c/comment_parser.rb#5
module YARD::Parser::C::CommentParser
  protected

  # source://yard//lib/yard/parser/c/comment_parser.rb#8
  def parse_comments(comments); end

  private

  # source://yard//lib/yard/parser/c/comment_parser.rb#42
  def parse_callseq(comments); end

  # source://yard//lib/yard/parser/c/comment_parser.rb#30
  def parse_overrides(comments); end

  # source://yard//lib/yard/parser/c/comment_parser.rb#87
  def parse_types(types); end

  # source://yard//lib/yard/parser/c/comment_parser.rb#126
  def remove_private_comments(comment); end
end

# source://yard//lib/yard/parser/c/statement.rb#5
class YARD::Parser::C::Statement
  # @return [Statement] a new instance of Statement
  #
  # source://yard//lib/yard/parser/c/statement.rb#16
  def initialize(source, file = T.unsafe(nil), line = T.unsafe(nil)); end

  # Returns the value of attribute comments_hash_flag.
  #
  # source://yard//lib/yard/parser/c/statement.rb#14
  def comments_hash_flag; end

  # Sets the attribute comments_hash_flag
  #
  # @param value the value to set the attribute comments_hash_flag to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#14
  def comments_hash_flag=(_arg0); end

  # source://yard//lib/yard/parser/c/statement.rb#26
  def comments_range; end

  # Returns the value of attribute file.
  #
  # source://yard//lib/yard/parser/c/statement.rb#8
  def file; end

  # Sets the attribute file
  #
  # @param value the value to set the attribute file to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#8
  def file=(_arg0); end

  # source://yard//lib/yard/parser/c/statement.rb#30
  def first_line; end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/c/statement.rb#12
  def group; end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/c/statement.rb#12
  def group=(_arg0); end

  # Returns the value of attribute line.
  #
  # source://yard//lib/yard/parser/c/statement.rb#7
  def line; end

  # Sets the attribute line
  #
  # @param value the value to set the attribute line to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#7
  def line=(_arg0); end

  # source://yard//lib/yard/parser/c/statement.rb#22
  def line_range; end

  # source://yard//lib/yard/parser/c/statement.rb#36
  def show; end

  # source://yard//lib/yard/parser/c/statement.rb#30
  def signature; end

  # Returns the value of attribute source.
  #
  # source://yard//lib/yard/parser/c/statement.rb#6
  def source; end

  # Sets the attribute source
  #
  # @param value the value to set the attribute source to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#6
  def source=(_arg0); end
end

# source://yard//lib/yard/parser/c/statement.rb#45
class YARD::Parser::C::ToplevelStatement < ::YARD::Parser::C::Statement
  # Returns the value of attribute block.
  #
  # source://yard//lib/yard/parser/c/statement.rb#46
  def block; end

  # Sets the attribute block
  #
  # @param value the value to set the attribute block to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#46
  def block=(_arg0); end

  # Returns the value of attribute comments.
  #
  # source://yard//lib/yard/parser/c/statement.rb#48
  def comments; end

  # Sets the attribute comments
  #
  # @param value the value to set the attribute comments to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#48
  def comments=(_arg0); end

  # Returns the value of attribute declaration.
  #
  # source://yard//lib/yard/parser/c/statement.rb#47
  def declaration; end

  # Sets the attribute declaration
  #
  # @param value the value to set the attribute declaration to.
  #
  # source://yard//lib/yard/parser/c/statement.rb#47
  def declaration=(_arg0); end
end

# Responsible for parsing a list of files in order. The
# {#parse} method of this class can be called from the
# {SourceParser#globals} globals state list to re-enter
# parsing for the remainder of files in the list recursively.
#
# @see Processor#parse_remaining_files
#
# source://yard//lib/yard/parser/source_parser.rb#20
class YARD::Parser::OrderedParser
  # Creates a new OrderedParser with the global state and a list
  # of files to parse.
  #
  # @note OrderedParser sets itself as the +ordered_parser+ key on
  #   global_state for later use in {Handlers::Processor}.
  # @param global_state [OpenStruct] a structure containing all global
  #   state during parsing
  # @param files [Array<String>] the list of files to parse
  # @return [OrderedParser] a new instance of OrderedParser
  #
  # source://yard//lib/yard/parser/source_parser.rb#32
  def initialize(global_state, files); end

  # @return [Array<String>] the list of remaining files to parse
  #
  # source://yard//lib/yard/parser/source_parser.rb#22
  def files; end

  # @return [Array<String>] the list of remaining files to parse
  #
  # source://yard//lib/yard/parser/source_parser.rb#22
  def files=(_arg0); end

  # Parses the remainder of the {#files} list.
  #
  # @see Processor#parse_remaining_files
  #
  # source://yard//lib/yard/parser/source_parser.rb#41
  def parse; end
end

# Raised when the parser sees a Ruby syntax error
#
# source://yard//lib/yard/parser/source_parser.rb#12
class YARD::Parser::ParserSyntaxError < ::YARD::Parser::UndocumentableError; end

# Ruby parsing components.
#
# source://yard//lib/yard/autoload.rb#171
module YARD::Parser::Ruby
  # Builds and s-expression by creating {AstNode} objects with
  # the type provided by the first argument.
  #
  # @example An implicit list of keywords
  #   ast = s(s(:kw, "if"), s(:kw, "else"))
  #   ast.type # => :list
  # @example A method call
  #   s(:command, s(:var_ref, "mymethod"))
  # @overload s
  # @overload s
  # @see AstNode#initialize
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#25
  def s(*args); end
end

# An AST node is characterized by a type and a list of children. It
# is most easily represented by the s-expression {#s} such as:
#   # AST for "if true; 5 end":
#   s(s(:if, s(:var_ref, s(:kw, "true")), s(s(:int, "5")), nil))
#
# The node type is not considered part of the list, only its children.
# So +ast[0]+ does not refer to the type, but rather the first child
# (or object). Items that are not +AstNode+ objects can be part of the
# list, like Strings or Symbols representing names. To return only
# the AstNode children of the node, use {#children}.
#
# source://yard//lib/yard/parser/ruby/ast_node.rb#41
class YARD::Parser::Ruby::AstNode < ::Array
  # Creates a new AST node
  #
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param type [Symbol] the type of node being created
  # @param arr [Array<AstNode>] the child nodes
  # @param opts [Hash] any extra line options
  # @return [AstNode] a new instance of AstNode
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#153
  def initialize(type, arr, opts = T.unsafe(nil)); end

  # @private
  # @return [Boolean] whether the node is equal to another by checking
  #   the list and type
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#167
  def ==(other); end

  # @return [Boolean] whether the node has a block
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#261
  def block?; end

  # @return [Boolean] whether the node is a method call
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#241
  def call?; end

  # @return [Array<AstNode>] the {AstNode} children inside the node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#199
  def children; end

  # Returns the value of attribute docstring.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def comments; end

  # Returns the value of attribute docstring_hash_flag.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#42
  def comments_hash_flag; end

  # Returns the value of attribute docstring_range.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def comments_range; end

  # @return [Boolean] whether the node is a if/elsif/else condition
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#251
  def condition?; end

  # @return [Boolean] whether the node is a method definition
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#246
  def def?; end

  # Returns the value of attribute docstring.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def docstring; end

  # Sets the attribute docstring
  #
  # @param value the value to set the attribute docstring to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def docstring=(_arg0); end

  # Returns the value of attribute docstring_hash_flag.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#42
  def docstring_hash_flag; end

  # Sets the attribute docstring_hash_flag
  #
  # @param value the value to set the attribute docstring_hash_flag to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#42
  def docstring_hash_flag=(_arg0); end

  # Returns the value of attribute docstring_range.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def docstring_range; end

  # Sets the attribute docstring_range
  #
  # @param value the value to set the attribute docstring_range to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def docstring_range=(_arg0); end

  # @return [String] the filename the node was parsed from
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#76
  def file; end

  # Sets the attribute file
  #
  # @param value the value to set the attribute file to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#49
  def file=(_arg0); end

  # @return [String] the first line of source represented by the node.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#278
  def first_line; end

  # @return [String] the full source that the node was parsed from
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#82
  def full_source; end

  # Sets the attribute full_source
  #
  # @param value the value to set the attribute full_source to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#49
  def full_source=(_arg0); end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#47
  def group; end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#47
  def group=(_arg0); end

  # @return [Boolean] whether the node has a {#line_range} set
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#268
  def has_line?; end

  # @return [String] inspects the object
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#323
  def inspect; end

  # Searches through the node and all descendants and returns the
  # first node with a type matching any of +node_types+, otherwise
  # returns the original node (self).
  #
  # @example Returns the first method definition in a block of code
  #   ast = YARD.parse_string("if true; def x; end end").ast
  #   ast.jump(:def)
  #   # => s(:def, s(:ident, "x"), s(:params, nil, nil, nil, nil,
  #   #      nil), s(s(:void_stmt, )))
  # @example Returns first 'def' or 'class' statement
  #   ast = YARD.parse_string("class X; def y; end end")
  #   ast.jump(:def, :class).first
  #   # =>
  # @example If the node types are not present in the AST
  #   ast = YARD.parse("def x; end")
  #   ast.jump(:def)
  # @param node_types [Array<Symbol>] a set of node types to match
  # @return [AstNode] the matching node, if one was found
  # @return [self] if no node was found
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#193
  def jump(*node_types); end

  # @return [Boolean] whether the node is a keyword
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#236
  def kw?; end

  # @return [Fixnum] the starting line number of the node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#273
  def line; end

  # @return [Range] the line range in {#full_source} represented
  #   by the node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#70
  def line_range; end

  # Sets the attribute line_range
  #
  # @param value the value to set the attribute line_range to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#49
  def line_range=(_arg0); end

  # @return [Boolean] whether the node is a literal value
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#231
  def literal?; end

  # @return [Boolean] whether the node is a loop
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#256
  def loop?; end

  # @return [AstNode, nil] the node's parent or nil if it is a root node.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#59
  def parent; end

  # @return [AstNode, nil] the node's parent or nil if it is a root node.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#59
  def parent=(_arg0); end

  # @return [nil] pretty prints the node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#290
  def pretty_print(q); end

  # @return [Boolean] whether the node is a reference (variable,
  #   constant name)
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#226
  def ref?; end

  # @return [String] the first line of source the node represents
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#285
  def show; end

  # @return [String] the parse of {#full_source} that the node represents
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#89
  def source; end

  # Sets the attribute source
  #
  # @param value the value to set the attribute source to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def source=(_arg0); end

  # @return [Range] the character range in {#full_source} represented
  #   by the node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#63
  def source_range; end

  # Sets the attribute source_range
  #
  # @param value the value to set the attribute source_range to.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#49
  def source_range=(_arg0); end

  # Returns the value of attribute source.
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#43
  def to_s; end

  # @return [Boolean] whether the node is a token
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#220
  def token?; end

  # Traverses the object and yields each node (including descendants) in order.
  #
  # @return [void]
  # @yield each descendant node in order
  # @yieldparam self, [AstNode] or a child/descendant node
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#208
  def traverse; end

  # @return [Symbol] the node's unique symbolic type
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#56
  def type; end

  # @return [Symbol] the node's unique symbolic type
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#56
  def type=(_arg0); end

  # Resets node state in tree
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#331
  def unfreeze; end

  private

  # Resets line information
  #
  # @return [void]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#341
  def reset_line_info; end

  class << self
    # Finds the node subclass that should be instantiated for a specific
    # node type
    #
    # @param type [Symbol] the node type to find a subclass for
    # @return [Class] a subclass of AstNode to instantiate the node with.
    #
    # source://yard//lib/yard/parser/ruby/ast_node.rb#111
    def node_class_for(type); end
  end
end

# List of all known keywords
#
# @return [Hash]
#
# source://yard//lib/yard/parser/ruby/ast_node.rb#96
YARD::Parser::Ruby::AstNode::KEYWORDS = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/ast_node.rb#530
class YARD::Parser::Ruby::ClassNode < ::YARD::Parser::Ruby::KeywordNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#533
  def block; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#531
  def class_name; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#532
  def superclass; end
end

# Represents a lone comment block in source
#
# source://yard//lib/yard/parser/ruby/ast_node.rb#548
class YARD::Parser::Ruby::CommentNode < ::YARD::Parser::Ruby::AstNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#549
  def comments; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#549
  def docstring; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#550
  def docstring=(value); end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#554
  def first_line; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#553
  def source; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#515
class YARD::Parser::Ruby::ConditionalNode < ::YARD::Parser::Ruby::KeywordNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#517
  def condition; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#516
  def condition?; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#520
  def else_block; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#518
  def then_block; end

  private

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#527
  def cmod?; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#376
class YARD::Parser::Ruby::KeywordNode < ::YARD::Parser::Ruby::AstNode
  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#377
  def kw?; end
end

# Handles Ruby parsing in Ruby 1.8.
#
# source://yard//lib/yard/autoload.rb#172
module YARD::Parser::Ruby::Legacy; end

# Lexical analyzer for Ruby source
#
# @private
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#314
class YARD::Parser::Ruby::Legacy::RubyLex
  include ::YARD::Parser::Ruby::Legacy::RubyToken
  include ::IRB

  # @return [RubyLex] a new instance of RubyLex
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#437
  def initialize(content); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#472
  def char_no; end

  # Returns the value of attribute continue.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#430
  def continue; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1116
  def dedent(str); end

  # Returns the value of attribute exception_on_syntax_error.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#463
  def exception_on_syntax_error; end

  # Sets the attribute exception_on_syntax_error
  #
  # @param value the value to set the attribute exception_on_syntax_error to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#463
  def exception_on_syntax_error=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#476
  def get_read; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#480
  def getc; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#484
  def getc_of_rests; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#488
  def gets; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1272
  def identify_comment; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#945
  def identify_gvar; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1062
  def identify_here_document; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#980
  def identify_identifier; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1145
  def identify_number(start); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1126
  def identify_quotation(initial_char); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1207
  def identify_string(ltype, quoted = T.unsafe(nil), opener = T.unsafe(nil), initial_char = T.unsafe(nil)); end

  # Returns the value of attribute indent.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#465
  def indent; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#510
  def lex; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#586
  def lex_init; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#759
  def lex_int2; end

  # Returns the value of attribute lex_state.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#431
  def lex_state; end

  # io functions
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#468
  def line_no; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#506
  def peek(i = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#502
  def peek_equal?(str); end

  # Returns the value of attribute read_auto_clean_up.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#462
  def read_auto_clean_up; end

  # Sets the attribute read_auto_clean_up
  #
  # @param value the value to set the attribute read_auto_clean_up to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#462
  def read_auto_clean_up=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1295
  def read_escape; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#1257
  def skip_inner_expression; end

  # Returns the value of attribute skip_space.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#461
  def skip_space; end

  # Sets the attribute skip_space
  #
  # @param value the value to set the attribute skip_space to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#461
  def skip_space=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#526
  def token; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#498
  def ungetc(c = T.unsafe(nil)); end

  class << self
    # @return [Boolean]
    #
    # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#433
    def debug?; end
  end
end

# , "when"
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#552
YARD::Parser::Ruby::Legacy::RubyLex::ACCEPTS_COLON = T.let(T.unsafe(nil), Array)

# Read an input stream character by character. We allow for unlimited
# ungetting of characters just read.
#
# We simplify the implementation greatly by reading the entire input
# into a buffer initially, and then simply traversing it using
# pointers.
#
# We also have to allow for the <i>here document diversion</i>. This
# little gem comes about when the lexer encounters a here
# document. At this point we effectively need to split the input
# stream into two parts: one to read the body of the here document,
# the other to read the rest of the input line where the here
# document was initially encountered. For example, we might have
#
#   do_something(<<-A, <<-B)
#     stuff
#     for
#   A
#     stuff
#     for
#   B
#
# When the lexer encounters the <<A, it reads until the end of the
# line, and keeps it around for later. It then reads the body of the
# here document.  Once complete, it needs to read the rest of the
# original line, but then skip the here document body.
#
# @private
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#343
class YARD::Parser::Ruby::Legacy::RubyLex::BufferedReader
  # @return [BufferedReader] a new instance of BufferedReader
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#346
  def initialize(content); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#365
  def column; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#419
  def divert_read_from(reserve); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#400
  def get_read; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#369
  def getc; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#388
  def getc_already_read; end

  # Returns the value of attribute line_num.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#344
  def line_num; end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#406
  def peek(at); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#415
  def peek_equal(str); end

  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#392
  def ungetc(_ch); end
end

# , "when"
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#553
YARD::Parser::Ruby::Legacy::RubyLex::DEINDENT_CLAUSE = T.let(T.unsafe(nil), Array)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#580
YARD::Parser::Ruby::Legacy::RubyLex::DLtype2Token = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#548
YARD::Parser::Ruby::Legacy::RubyLex::ENINDENT_CLAUSE = T.let(T.unsafe(nil), Array)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#571
YARD::Parser::Ruby::Legacy::RubyLex::Ltype2Token = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#555
YARD::Parser::Ruby::Legacy::RubyLex::PERCENT_LTYPE = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#564
YARD::Parser::Ruby::Legacy::RubyLex::PERCENT_PAREN = T.let(T.unsafe(nil), Hash)

# Legacy Ruby parser
#
# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#8
class YARD::Parser::Ruby::Legacy::RubyParser < ::YARD::Parser::Base
  # @return [RubyParser] a new instance of RubyParser
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#9
  def initialize(source, _filename); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#26
  def encoding_line; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#22
  def enumerator; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#13
  def parse; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#27
  def shebang_line; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_parser.rb#18
  def tokenize; end
end

# Legacy lexical tokenizer module.
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#6
module YARD::Parser::Ruby::Legacy::RubyToken
  # @private
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#125
  def Token(token, value = T.unsafe(nil)); end

  # @private
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#119
  def set_token_position(line, char); end

  class << self
    # @private
    #
    # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#275
    def def_token(token_n, super_token = T.unsafe(nil), reading = T.unsafe(nil), *opts); end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#10
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_ARG = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#7
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_BEG = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#13
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_CLASS = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#12
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_DOT = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#9
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_END = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#11
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_FNAME = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#8
YARD::Parser::Ruby::Legacy::RubyToken::EXPR_MID = T.let(T.unsafe(nil), Symbol)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#308
YARD::Parser::Ruby::Legacy::RubyToken::NEWLINE_TOKEN = T.let(T.unsafe(nil), YARD::Parser::Ruby::Legacy::RubyToken::TkNL)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::OPASGN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkALIAS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkAMPER < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkAND < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkANDOP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkAREF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkASET < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkASSIGN < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkASSOC < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkAT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkUnknownChar; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBACKQUOTE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBACKSLASH < ::YARD::Parser::Ruby::Legacy::RubyToken::TkUnknownChar; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBACK_REF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBEGIN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBITAND < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBITNOT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBITOR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBITXOR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkBREAK < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# Represents a block
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#54
class YARD::Parser::Ruby::Legacy::RubyToken::TkBlockContents < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#55
  def text; end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCASE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCLASS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCMP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCOLON < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCOLON2 < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCOLON3 < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCOMMA < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCOMMENT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkCONSTANT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDEF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDEFINED < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDIV < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDO < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDOLLAR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkUnknownChar; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDOT < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDOT2 < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDOT3 < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDREGEXP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkNode; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDSTRING < ::YARD::Parser::Ruby::Legacy::RubyToken::TkNode; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkDXSTRING < ::YARD::Parser::Ruby::Legacy::RubyToken::TkNode; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkELSE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkELSIF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkEND < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkEND_OF_SCRIPT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkWhitespace; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkENSURE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkEQ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkEQQ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#115
class YARD::Parser::Ruby::Legacy::RubyToken::TkError < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkFALSE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkFID < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkFLOAT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkFOR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkGEQ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkGT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkGVAR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkIDENTIFIER < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkIF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkIF_MOD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkIN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkINTEGER < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkIVAR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# Represents a Ruby identifier
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#72
class YARD::Parser::Ruby::Legacy::RubyToken::TkId < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # @return [TkId] a new instance of TkId
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#73
  def initialize(line_no, char_no, name); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#77
  def name; end
end

# Represents a Ruby keyword
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#81
class YARD::Parser::Ruby::Legacy::RubyToken::TkKW < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLABEL < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLBRACE < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLBRACK < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLEQ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLPAREN < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLSHFT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkLT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkMATCH < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkMINUS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkMOD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkMODULE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkMULT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNEQ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNEXT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNIL < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNL < ::YARD::Parser::Ruby::Legacy::RubyToken::TkWhitespace; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNMATCH < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNOT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNOTOP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkNTH_REF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#63
class YARD::Parser::Ruby::Legacy::RubyToken::TkNode < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # Returns the value of attribute node.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#64
  def node; end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#98
class YARD::Parser::Ruby::Legacy::RubyToken::TkOPASGN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  # @return [TkOPASGN] a new instance of TkOPASGN
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#99
  def initialize(line_no, char_no, op); end

  # Returns the value of attribute op.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#104
  def op; end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkOR < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkOROP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#92
class YARD::Parser::Ruby::Legacy::RubyToken::TkOp < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#93
  def name; end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkPLUS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkPOW < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkQUESTION < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRBRACE < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRBRACK < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkREDO < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkREGEXP < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRESCUE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRETRY < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRETURN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRPAREN < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkRSHFT < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# { reading => token_class }
# { reading => [token_class, *opt] }
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#271
YARD::Parser::Ruby::Legacy::RubyToken::TkReading2Token = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSELF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSEMICOLON < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSPACE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkWhitespace; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSTAR < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSTRING < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSUPER < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSYMBEG < ::YARD::Parser::Ruby::Legacy::RubyToken::TkId; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkSYMBOL < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# Represents an end statement
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#59
class YARD::Parser::Ruby::Legacy::RubyToken::TkStatementEnd < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#60
  def text; end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#272
YARD::Parser::Ruby::Legacy::RubyToken::TkSymbol2Token = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkTHEN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkTRUE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUMINUS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUNDEF < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUNLESS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUNLESS_MOD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUNTIL < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUNTIL_MOD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkUPLUS < ::YARD::Parser::Ruby::Legacy::RubyToken::TkOp
  class << self
    def op_name; end
  end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#107
class YARD::Parser::Ruby::Legacy::RubyToken::TkUnknownChar < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # @return [TkUnknownChar] a new instance of TkUnknownChar
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#108
  def initialize(line_no, char_no, _id); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#112
  def name; end
end

# Represents a Ruby value
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#85
class YARD::Parser::Ruby::Legacy::RubyToken::TkVal < ::YARD::Parser::Ruby::Legacy::RubyToken::Token
  # @return [TkVal] a new instance of TkVal
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#86
  def initialize(line_no, char_no, value = T.unsafe(nil)); end
end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkWHEN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkWHILE < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkWHILE_MOD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# Represents whitespace
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#68
class YARD::Parser::Ruby::Legacy::RubyToken::TkWhitespace < ::YARD::Parser::Ruby::Legacy::RubyToken::Token; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkXSTRING < ::YARD::Parser::Ruby::Legacy::RubyToken::TkVal; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TkYIELD < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::Tk__FILE__ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::Tk__LINE__ < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TklBEGIN < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#281
class YARD::Parser::Ruby::Legacy::RubyToken::TklEND < ::YARD::Parser::Ruby::Legacy::RubyToken::TkKW; end

# Represents a token in the Ruby lexer
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#16
class YARD::Parser::Ruby::Legacy::RubyToken::Token
  # Creates a new Token object
  #
  # @param line_no [Integer] the line number to initialize the token to
  # @param char_no [Integer] the char number to initialize the token to
  # @return [Token] a new instance of Token
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#37
  def initialize(line_no, char_no); end

  # @return [Integer] the character number in the file/stream the token
  #   is located.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#23
  def char_no; end

  # @return [Symbol] the lexical state at the token
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#29
  def lex_state; end

  # @return [Symbol] the lexical state at the token
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#29
  def lex_state=(_arg0); end

  # @return [Integer] the line number in the file/stream the token is
  #   located.
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#19
  def line_no; end

  # Chainable way to sets the text attribute
  #
  # @param text [String] the new text
  # @return [Token] this token object
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#47
  def set_text(text); end

  # @return [String] the token text value
  #
  # source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#26
  def text; end
end

# @private
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#32
YARD::Parser::Ruby::Legacy::RubyToken::Token::NO_TEXT = T.let(T.unsafe(nil), String)

# @private
#
# source://yard//lib/yard/parser/ruby/legacy/ruby_lex.rb#147
YARD::Parser::Ruby::Legacy::RubyToken::TokenDefinitions = T.let(T.unsafe(nil), Array)

# source://yard//lib/yard/parser/ruby/legacy/statement.rb#4
class YARD::Parser::Ruby::Legacy::Statement
  # @return [Statement] a new instance of Statement
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#14
  def initialize(tokens, block = T.unsafe(nil), comments = T.unsafe(nil)); end

  # Returns the value of attribute block.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#5
  def block; end

  # Returns the value of attribute comments.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#5
  def comments; end

  # Returns the value of attribute comments_hash_flag.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#12
  def comments_hash_flag; end

  # Sets the attribute comments_hash_flag
  #
  # @param value the value to set the attribute comments_hash_flag to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#12
  def comments_hash_flag=(_arg0); end

  # Returns the value of attribute comments_range.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#6
  def comments_range; end

  # Sets the attribute comments_range
  #
  # @param value the value to set the attribute comments_range to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#6
  def comments_range=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#21
  def first_line; end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#10
  def group; end

  # @deprecated Groups are now defined by directives
  # @see Tags::GroupDirective
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#10
  def group=(_arg0); end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#34
  def inspect; end

  # @return [Fixnum] the first line of Ruby source
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#46
  def line; end

  # @return [Range<Fixnum>] the first to last lines of Ruby source
  # @since 0.5.4
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#52
  def line_range; end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#41
  def show; end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#21
  def signature; end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#27
  def source(include_block = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#27
  def to_s(include_block = T.unsafe(nil)); end

  # Returns the value of attribute tokens.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#5
  def tokens; end

  private

  # source://yard//lib/yard/parser/ruby/legacy/statement.rb#58
  def clean_tokens(tokens); end
end

# source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#4
class YARD::Parser::Ruby::Legacy::StatementList < ::Array
  include ::YARD::Parser::Ruby::Legacy::RubyToken

  # Creates a new statement list
  #
  # @param content [TokenList, String] the tokens to create the list from
  # @return [StatementList] a new instance of StatementList
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#17
  def initialize(content); end

  # Returns the value of attribute encoding_line.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#7
  def encoding_line; end

  # Sets the attribute encoding_line
  #
  # @param value the value to set the attribute encoding_line to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#7
  def encoding_line=(_arg0); end

  # Returns the value of attribute shebang_line.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#7
  def shebang_line; end

  # Sets the attribute shebang_line
  #
  # @param value the value to set the attribute shebang_line to.
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#7
  def shebang_line=(_arg0); end

  private

  # Handles the balancing of parentheses and blocks
  #
  # @param tk [RubyToken::Token] the token to process
  # @return [Boolean] whether or not the current statement's parentheses and blocks
  #   are balanced after +tk+
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#362
  def balances?(tk); end

  # Returns the next statement in the token stream
  #
  # @return [Statement] the next statement
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#45
  def next_statement; end

  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#34
  def parse_statements; end

  # Returns the next token in the stream that's not a space
  #
  # @return [RubyToken::Token] the next non-space token
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#388
  def peek_no_space; end

  # Processes a token in a block
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#194
  def process_block_token(tk); end

  # Processes a complex block-opening token;
  # that is, a block opener such as +while+ or +for+
  # that is followed by an expression
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#293
  def process_complex_block_opener(tk); end

  # Processes a comment token that comes before a statement
  #
  # @param tk [RubyToken::Token] the token to process
  # @return [Boolean] whether or not +tk+ was processed as an initial comment
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#213
  def process_initial_comment(tk); end

  # Processes a simple block-opening token;
  # that is, a block opener such as +begin+ or +do+
  # that isn't followed by an expression
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#268
  def process_simple_block_opener(tk); end

  # Processes a token that closes a statement
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#305
  def process_statement_end(tk); end

  # Processes a single token
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#130
  def process_token(tk); end

  # Adds a token to the current statement,
  # unless it's a newline, semicolon, or comment
  #
  # @param tk [RubyToken::Token] the token to process
  #
  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#380
  def push_token(tk); end

  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#111
  def sanitize_block; end

  # source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#96
  def sanitize_statement_end; end
end

# The following list of tokens will require a block to be opened
# if used at the beginning of a statement.
#
# source://yard//lib/yard/parser/ruby/legacy/statement_list.rb#11
YARD::Parser::Ruby::Legacy::StatementList::OPEN_BLOCK_TOKENS = T.let(T.unsafe(nil), Array)

# source://yard//lib/yard/parser/ruby/legacy/token_list.rb#4
class YARD::Parser::Ruby::Legacy::TokenList < ::Array
  include ::YARD::Parser::Ruby::Legacy::RubyToken

  # @return [TokenList] a new instance of TokenList
  #
  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#7
  def initialize(content = T.unsafe(nil)); end

  # @param tokens [TokenList, Token, String] A list of tokens. If the token is a string, it
  #   is parsed with {RubyLex}.
  #
  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#21
  def <<(*tokens); end

  # @param tokens [TokenList, Token, String] A list of tokens. If the token is a string, it
  #   is parsed with {RubyLex}.
  #
  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#21
  def push(*tokens); end

  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#37
  def squeeze(type = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#11
  def to_s(full_statement = T.unsafe(nil), show_block = T.unsafe(nil)); end

  private

  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#53
  def convert_token(lex, tk); end

  # source://yard//lib/yard/parser/ruby/legacy/token_list.rb#44
  def parse_content(content); end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#372
class YARD::Parser::Ruby::LiteralNode < ::YARD::Parser::Ruby::AstNode
  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#373
  def literal?; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#541
class YARD::Parser::Ruby::LoopNode < ::YARD::Parser::Ruby::KeywordNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#544
  def block; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#543
  def condition; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#542
  def loop?; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#438
class YARD::Parser::Ruby::MethodCallNode < ::YARD::Parser::Ruby::AstNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#464
  def block; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#462
  def block_param; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#439
  def call?; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#442
  def method_name(name_only = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#440
  def namespace; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#453
  def parameters(include_block_param = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#474
  def call_has_paren?; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#470
  def index_adjust; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#479
class YARD::Parser::Ruby::MethodDefinitionNode < ::YARD::Parser::Ruby::AstNode
  def block(n = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#481
  def def?; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#480
  def kw?; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#484
  def method_name(name_only = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#482
  def namespace; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#489
  def parameters(include_block_param = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#495
  def signature; end

  private

  # source://yard//lib/yard/parser/ruby/ast_node.rb#510
  def index_adjust; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#536
class YARD::Parser::Ruby::ModuleNode < ::YARD::Parser::Ruby::KeywordNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#538
  def block; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#537
  def module_name; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#380
class YARD::Parser::Ruby::ParameterNode < ::YARD::Parser::Ruby::AstNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#430
  def args_forward; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#426
  def block_param; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#414
  def double_splat_param; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#396
  def named_params; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#406
  def splat_param; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#410
  def unnamed_end_params; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#385
  def unnamed_optional_params; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#381
  def unnamed_required_params; end
end

# source://yard//lib/yard/parser/ruby/ast_node.rb#360
class YARD::Parser::Ruby::ReferenceNode < ::YARD::Parser::Ruby::AstNode
  # source://yard//lib/yard/parser/ruby/ast_node.rb#367
  def namespace; end

  # source://yard//lib/yard/parser/ruby/ast_node.rb#363
  def path; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/parser/ruby/ast_node.rb#361
  def ref?; end
end

# Internal parser class
#
# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#27
class YARD::Parser::Ruby::RipperParser < ::Ripper
  # @return [RipperParser] a new instance of RipperParser
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#32
  def initialize(source, filename, *args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def ast; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def charno; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def comments; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#29
  def encoding_line; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#64
  def enumerator; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def file; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#68
  def file_encoding; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#29
  def frozen_string_line; end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_BEGIN(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_CHAR(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_END(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on___end__(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_alias(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_alias_error(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_arg_ambiguous(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_arg_paren(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_args_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_args_add_block(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_args_add_star(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_args_forward(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_args_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_aryptn(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_assign(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_assign_error(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_assoc_splat(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_backref(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_backtick(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_begin(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_binary(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_block_var(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_blockarg(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_brace_block(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_break(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_call(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_case(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_class(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_class_name_error(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_comma(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_command(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_command_call(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_const(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_const_path_field(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_const_ref(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_cvar(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_def(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_defined(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_defs(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_do_block(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_dot2(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_dot3(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_else(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_elsif(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_embexpr_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_embexpr_end(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_embvar(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_ensure(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_excessed_comma(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_fcall(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_field(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_float(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_fndptn(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_for(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_gvar(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_heredoc_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_heredoc_dedent(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_heredoc_end(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_hshptn(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_ident(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_if(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#449
  def on_if_mod(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_ifop(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#222
  def on_ignored_nl(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_ignored_sp(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_imaginary(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_in(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_int(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_ivar(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#209
  def on_kw(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_kwrest_param(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_label_end(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_lbrace(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_lparen(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_magic_comment(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_massign(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_method_add_arg(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_method_add_block(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_mlhs_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_mlhs_add_post(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_mlhs_add_star(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_mlhs_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_mlhs_paren(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_module(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_mrhs_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_mrhs_add_star(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_mrhs_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_mrhs_new_from_args(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_next(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#222
  def on_nl(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_nokw_param(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#209
  def on_op(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_opassign(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_operator_ambiguous(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_param_error(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_paren(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_period(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#474
  def on_qsymbols_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_qsymbols_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#462
  def on_qsymbols_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#474
  def on_qwords_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_qwords_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#462
  def on_qwords_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_rational(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_rbrace(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_redo(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_regexp_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_regexp_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_regexp_end(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_regexp_literal(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_regexp_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_rescue_mod(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_rest_param(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_retry(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_return(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_return0(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_rparen(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_sclass(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_semicolon(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_stmts_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_stmts_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_string_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_string_concat(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_string_dvar(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_string_embexpr(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_super(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_symbeg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_symbol(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_symbol_literal(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#474
  def on_symbols_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_symbols_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#462
  def on_symbols_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_tlambda(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_tlambeg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_top_const_field(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_tstring_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_tstring_content(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_tstring_end(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_undef(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_unless(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#449
  def on_unless_mod(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_until(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#449
  def on_until_mod(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_var_alias(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_var_field(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_var_ref(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#177
  def on_vcall(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_when(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_while(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#449
  def on_while_mod(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_word_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_word_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#474
  def on_words_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#199
  def on_words_beg(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#462
  def on_words_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#188
  def on_words_sep(tok); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#162
  def on_xstring_add(list, item); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_xstring_literal(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#155
  def on_xstring_new(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_yield(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_yield0(*args); end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#170
  def on_zsuper(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#55
  def parse; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def root; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#29
  def shebang_line; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#28
  def tokens; end

  private

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#667
  def add_comment(line, node = T.unsafe(nil), before_node = T.unsafe(nil), into = T.unsafe(nil)); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#271
  def add_token(token, data); end

  # @return [Boolean]
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#611
  def comment_starts_line?(charno); end

  # @raise [ParserSyntaxError]
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#606
  def compile_error(msg); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#693
  def freeze_tree(node = T.unsafe(nil)); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#620
  def insert_comments; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#377
  def on_aref(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#385
  def on_aref_field(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#391
  def on_array(other); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#352
  def on_assoc_new(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#364
  def on_assoclist_from_args(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#360
  def on_bare_assoc_hash(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#347
  def on_body_stmt(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#347
  def on_bodystmt(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#542
  def on_comment(comment); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#441
  def on_const_path_ref(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#419
  def on_dyna_symbol(sym); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#592
  def on_embdoc(text); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#586
  def on_embdoc_beg(text); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#597
  def on_embdoc_end(text); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#356
  def on_hash(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#534
  def on_label(data); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#497
  def on_lambda(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#409
  def on_lbracket(tok); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#515
  def on_params(*args); end

  # @raise [ParserSyntaxError]
  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#606
  def on_parse_error(msg); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#343
  def on_program(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#414
  def on_rbracket(tok); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#506
  def on_rescue(exc, *args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#232
  def on_sp(tok); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#501
  def on_string_content(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#484
  def on_string_literal(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#429
  def on_top_const_ref(*args); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#368
  def on_unary(op, val); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#511
  def on_void_stmt; end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#237
  def visit_event(node); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#251
  def visit_event_arr(node); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#259
  def visit_ns_token(token, data, ast_token = T.unsafe(nil)); end
end

# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#133
YARD::Parser::Ruby::RipperParser::AST_TOKENS = T.let(T.unsafe(nil), Array)

# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#136
YARD::Parser::Ruby::RipperParser::COMMENT_SKIP_NODE_TYPES = T.let(T.unsafe(nil), Array)

# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#78
YARD::Parser::Ruby::RipperParser::MAPPINGS = T.let(T.unsafe(nil), Hash)

# @since 0.5.6
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#131
YARD::Parser::Ruby::RipperParser::REV_MAPPINGS = T.let(T.unsafe(nil), Hash)

# Ruby 1.9 parser
#
# source://yard//lib/yard/parser/ruby/ruby_parser.rb#12
class YARD::Parser::Ruby::RubyParser < ::YARD::Parser::Base
  # @return [RubyParser] a new instance of RubyParser
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#13
  def initialize(source, filename); end

  # Ruby 1.9 parser
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#21
  def encoding_line; end

  # Ruby 1.9 parser
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#19
  def enumerator; end

  # Ruby 1.9 parser
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#22
  def frozen_string_line; end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#17
  def parse; end

  # Ruby 1.9 parser
  #
  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#20
  def shebang_line; end

  # source://yard//lib/yard/parser/ruby/ruby_parser.rb#18
  def tokenize; end
end

# Supports {#each} enumeration over a source's tokens, yielding
# the token and a possible {CodeObjects::Base} associated with the
# constant or identifier token.
#
# source://yard//lib/yard/parser/ruby/token_resolver.rb#8
class YARD::Parser::Ruby::TokenResolver
  include ::Enumerable
  include ::YARD::CodeObjects::NamespaceMapper

  # Creates a token resolver for given source.
  #
  # @param source [String] the source code to tokenize
  # @param namespace [CodeObjects::Base] the object/namespace to resolve from
  # @raise [ParserSyntaxError]
  # @return [TokenResolver] a new instance of TokenResolver
  #
  # source://yard//lib/yard/parser/ruby/token_resolver.rb#16
  def initialize(source, namespace = T.unsafe(nil)); end

  # Iterates over each token, yielding the token and a possible code
  # object that is associated with the token.
  #
  # @example Yielding code objects
  #   r = TokenResolver.new("A::B::C")
  #   r.each do |tok, obj|
  #   if obj
  #   puts "#{tok[0]} -> #{obj.path.inspect}"
  #   else
  #   puts "No object: #{tok.inspect}"
  #   end
  #   end
  #
  #   # Prints:
  #   # :const -> "A"
  #   # No object: [:op, "::"]
  #   # :const -> "A::B"
  #   # No object: [:op, "::"]
  #   # :const -> "A::B::C"
  # @yieldparam token [Array(Symbol,String,Array(Integer,Integer))] the
  #   current token object being iterated
  # @yieldparam object [CodeObjects::Base, nil] the fully qualified code
  #   object associated with the current token, or nil if there is no object
  #   for the yielded token.
  #
  # source://yard//lib/yard/parser/ruby/token_resolver.rb#46
  def each; end

  protected

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#94
  def last_sep; end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#95
  def last_sep=(v); end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#94
  def next_object; end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#95
  def next_object=(v); end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#94
  def object; end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#95
  def object=(v); end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#94
  def skip_group; end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#95
  def skip_group=(v); end

  private

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#112
  def lookup(toktype, name); end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#134
  def object_resolved_types(obj = T.unsafe(nil)); end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#106
  def pop_state; end

  # source://yard//lib/yard/parser/ruby/token_resolver.rb#102
  def push_state; end

  class << self
    # source://yard//lib/yard/parser/ruby/token_resolver.rb#92
    def state_attr(*attrs); end
  end
end

# Responsible for parsing a source file into the namespace. Parsing
# also invokes handlers to process the parsed statements and generate
# any code objects that may be recognized.
#
# == Custom Parsers
# SourceParser allows custom parsers to be registered and called when
# a certain filetype is recognized. To register a parser and hook it
# up to a set of file extensions, call {register_parser_type}
#
# @see register_parser_type
# @see Handlers::Base
# @see CodeObjects::Base
#
# source://yard//lib/yard/parser/source_parser.rb#63
class YARD::Parser::SourceParser
  # @overload initialize
  # @return [SourceParser] a new instance of SourceParser
  #
  # source://yard//lib/yard/parser/source_parser.rb#406
  def initialize(parser_type = T.unsafe(nil), globals1 = T.unsafe(nil), globals2 = T.unsafe(nil)); end

  # @return [String] the contents of the file to be parsed
  # @since 0.7.0
  #
  # source://yard//lib/yard/parser/source_parser.rb#399
  def contents; end

  # @return [String] the filename being parsed by the parser.
  #
  # source://yard//lib/yard/parser/source_parser.rb#386
  def file; end

  # @return [String] the filename being parsed by the parser.
  #
  # source://yard//lib/yard/parser/source_parser.rb#386
  def file=(_arg0); end

  # @return [OpenStruct] an open struct containing arbitrary global state
  #   shared between files and handlers.
  # @since 0.7.0
  #
  # source://yard//lib/yard/parser/source_parser.rb#395
  def globals; end

  # The main parser method. This should not be called directly. Instead,
  # use the class methods {parse} and {parse_string}.
  #
  # @param content [String, #read, Object] the source file to parse
  # @return [Object, nil] the parser object used to parse the source
  #
  # source://yard//lib/yard/parser/source_parser.rb#418
  def parse(content = T.unsafe(nil)); end

  # @return [Symbol] the parser type associated with the parser instance.
  #   This should be set by the {#initialize constructor}.
  #
  # source://yard//lib/yard/parser/source_parser.rb#390
  def parser_type; end

  # Tokenizes but does not parse the block of code using the current {#parser_type}
  #
  # @param content [String] the block of code to tokenize
  # @return [Array] a list of tokens
  #
  # source://yard//lib/yard/parser/source_parser.rb#462
  def tokenize(content); end

  private

  # Searches for encoding line and forces encoding
  #
  # @since 0.5.3
  #
  # source://yard//lib/yard/parser/source_parser.rb#471
  def convert_encoding(content); end

  # @since 0.5.6
  #
  # source://yard//lib/yard/parser/source_parser.rb#515
  def parser_class; end

  # source://yard//lib/yard/parser/source_parser.rb#500
  def parser_type=(value); end

  # Guesses the parser type to use depending on the file extension.
  #
  # @param filename [String] the filename to use to guess the parser type
  # @return [Symbol] a parser type that matches the filename
  #
  # source://yard//lib/yard/parser/source_parser.rb#508
  def parser_type_for_filename(filename); end

  # Runs a {Handlers::Processor} object to post process the parsed statements.
  #
  # @return [void]
  #
  # source://yard//lib/yard/parser/source_parser.rb#490
  def post_process; end

  class << self
    # Registers a callback to be called after an individual file is parsed.
    # The block passed to this method will be called on subsequent parse
    # calls.
    #
    # To register a callback that is called after the entire list of files
    # is processed, see {after_parse_list}.
    #
    # @example Printing the length of each file after it is parsed
    #   SourceParser.after_parse_file do |parser|
    #   puts "#{parser.file} is #{parser.contents.size} characters"
    #   end
    #   YARD.parse('lib/**/*.rb')
    #   # prints:
    #   "lib/foo.rb is 1240 characters"
    #   "lib/foo_bar.rb is 248 characters"
    # @return [Proc] the yielded block
    # @see before_parse_file
    # @see after_parse_list
    # @since 0.7.0
    # @yield [parser] the yielded block is called once after each file
    #   that is parsed. This might happen many times for a single codebase.
    # @yieldparam parser [SourceParser] the parser object that parsed
    #   the file.
    # @yieldreturn [void] the return value for the block is ignored.
    #
    # source://yard//lib/yard/parser/source_parser.rb#324
    def after_parse_file(&block); end

    # @return [Array<Proc>] the list of callbacks to be called after
    #   parsing a file. Should only be used for testing.
    # @since 0.7.0
    #
    # source://yard//lib/yard/parser/source_parser.rb#352
    def after_parse_file_callbacks; end

    # Registers a callback to be called after a list of files is parsed
    # via {parse}. The block passed to this method will be called on
    # subsequent parse calls.
    #
    # @example Printing results after parsing occurs
    #   SourceParser.after_parse_list do
    #   puts "Finished parsing!"
    #   end
    #   YARD.parse
    #   # Prints "Finished parsing!" after parsing files
    # @return [Proc] the yielded block
    # @see before_parse_list
    # @see before_parse_file
    # @since 0.7.0
    # @yield [files, globals] the yielded block is called once before
    #   parsing all files
    # @yieldparam files [Array<String>] the list of files that will be parsed.
    # @yieldparam globals [OpenStruct] a global structure to store arbitrary
    #   state for post processing (see {Handlers::Processor#globals})
    # @yieldreturn [void] the return value for the block is ignored.
    #
    # source://yard//lib/yard/parser/source_parser.rb#258
    def after_parse_list(&block); end

    # @return [Array<Proc>] the list of callbacks to be called after
    #   parsing a list of files. Should only be used for testing.
    # @since 0.7.0
    #
    # source://yard//lib/yard/parser/source_parser.rb#338
    def after_parse_list_callbacks; end

    # Registers a callback to be called before an individual file is parsed.
    # The block passed to this method will be called on subsequent parse
    # calls.
    #
    # To register a callback that is called before the entire list of files
    # is processed, see {before_parse_list}.
    #
    # @example Cancel parsing of any test_*.rb files
    #   SourceParser.before_parse_file do |parser|
    #   return false if parser.file =~ /^test_.+\.rb$/
    #   end
    # @example Installing a simple callback
    #   SourceParser.before_parse_file do |parser|
    #   puts "I'm parsing #{parser.file}"
    #   end
    #   YARD.parse('lib/**/*.rb')
    #   # prints:
    #   "I'm parsing lib/foo.rb"
    #   "I'm parsing lib/foo_bar.rb"
    #   "I'm parsing lib/last_file.rb"
    # @return [Proc] the yielded block
    # @see before_parse_list
    # @see after_parse_file
    # @since 0.7.0
    # @yield [parser] the yielded block is called once before each
    #   file that is parsed. This might happen many times for a single
    #   codebase.
    # @yieldparam parser [SourceParser] the parser object that will {#parse}
    #   the file.
    # @yieldreturn [Boolean] if the block returns +false+, parsing for
    #   the file is cancelled.
    #
    # source://yard//lib/yard/parser/source_parser.rb#295
    def before_parse_file(&block); end

    # @return [Array<Proc>] the list of callbacks to be called before
    #   parsing a file. Should only be used for testing.
    # @since 0.7.0
    #
    # source://yard//lib/yard/parser/source_parser.rb#345
    def before_parse_file_callbacks; end

    # Registers a callback to be called before a list of files is parsed
    # via {parse}. The block passed to this method will be called on
    # subsequent parse calls.
    #
    # @example Setting global state
    #   SourceParser.before_parse_list do |files, globals|
    #   globals.method_count = 0
    #   end
    #   SourceParser.after_parse_list do |files, globals|
    #   puts "Found #{globals.method_count} methods"
    #   end
    #   class MyCountHandler < Handlers::Ruby::Base
    #   handles :def, :defs
    #   process { globals.method_count += 1 }
    #   end
    #   YARD.parse
    #   # Prints: "Found 37 methods"
    # @example Installing a simple callback
    #   SourceParser.before_parse_list do |files, globals|
    #   puts "Starting to parse..."
    #   end
    #   YARD.parse('lib/**/*.rb')
    #   # prints "Starting to parse..."
    # @example Using a global callback to cancel parsing
    #   SourceParser.before_parse_list do |files, globals|
    #   return false if files.include?('foo.rb')
    #   end
    #
    #   YARD.parse(['foo.rb', 'bar.rb']) # callback cancels this method
    #   YARD.parse('bar.rb') # parses normally
    # @return [Proc] the yielded block
    # @see before_parse_file
    # @see after_parse_list
    # @since 0.7.0
    # @yield [files, globals] the yielded block is called once before
    #   parsing all files
    # @yieldparam files [Array<String>] the list of files that will be parsed.
    # @yieldparam globals [OpenStruct] a global structure to store arbitrary
    #   state for post processing (see {Handlers::Processor#globals})
    # @yieldreturn [Boolean] if the block returns +false+, parsing is
    #   cancelled.
    #
    # source://yard//lib/yard/parser/source_parser.rb#234
    def before_parse_list(&block); end

    # @return [Array<Proc>] the list of callbacks to be called before
    #   parsing a list of files. Should only be used for testing.
    # @since 0.7.0
    #
    # source://yard//lib/yard/parser/source_parser.rb#331
    def before_parse_list_callbacks; end

    # Parses a path or set of paths
    #
    # @param paths [String, Array<String>] a path, glob, or list of paths to
    #   parse
    # @param excluded [Array<String, Regexp>] a list of excluded path matchers
    # @param level [Fixnum] the logger level to use during parsing. See
    #   {YARD::Logger}
    # @return [void]
    #
    # source://yard//lib/yard/parser/source_parser.rb#99
    def parse(paths = T.unsafe(nil), excluded = T.unsafe(nil), level = T.unsafe(nil)); end

    # Parses a string +content+
    #
    # @param content [String] the block of code to parse
    # @param ptype [Symbol] the parser type to use. See {parser_type}.
    # @return the parser object that was used to parse +content+
    #
    # source://yard//lib/yard/parser/source_parser.rb#123
    def parse_string(content, ptype = T.unsafe(nil)); end

    # @return [Symbol] the default parser type (defaults to :ruby)
    #
    # source://yard//lib/yard/parser/source_parser.rb#85
    def parser_type; end

    # source://yard//lib/yard/parser/source_parser.rb#87
    def parser_type=(value); end

    # @private
    # @return [Hash] a list of registered parser type extensions
    # @since 0.5.6
    #
    # source://yard//lib/yard/parser/source_parser.rb#163
    def parser_type_extensions; end

    # source://yard//lib/yard/parser/source_parser.rb#164
    def parser_type_extensions=(value); end

    # Finds a parser type that is registered for the extension. If no
    # type is found, the default Ruby type is returned.
    #
    # @return [Symbol] the parser type to be used for the extension
    # @since 0.5.6
    #
    # source://yard//lib/yard/parser/source_parser.rb#171
    def parser_type_for_extension(extension); end

    # @private
    # @return [Hash{Symbol=>Object}] a list of registered parser types
    # @since 0.5.6
    #
    # source://yard//lib/yard/parser/source_parser.rb#157
    def parser_types; end

    # source://yard//lib/yard/parser/source_parser.rb#158
    def parser_types=(value); end

    # Registers a new parser type.
    #
    # @example Registering a parser for "java" files
    #   SourceParser.register_parser_type :java, JavaParser, 'java'
    # @param type [Symbol] a symbolic name for the parser type
    # @param parser_klass [Base] a class that implements parsing and tokenization
    # @param extensions [Array<String>, String, Regexp] a list of extensions or a
    #   regex to match against the file extension
    # @return [void]
    # @see Parser::Base
    #
    # source://yard//lib/yard/parser/source_parser.rb#146
    def register_parser_type(type, parser_klass, extensions = T.unsafe(nil)); end

    # Tokenizes but does not parse the block of code
    #
    # @param content [String] the block of code to tokenize
    # @param ptype [Symbol] the parser type to use. See {parser_type}.
    # @return [Array] a list of tokens
    #
    # source://yard//lib/yard/parser/source_parser.rb#132
    def tokenize(content, ptype = T.unsafe(nil)); end

    # Returns the validated parser type. Basically, enforces that :ruby
    # type is never set if the Ripper library is not available
    #
    # @param type [Symbol] the parser type to set
    # @private
    # @return [Symbol] the validated parser type
    #
    # source://yard//lib/yard/parser/source_parser.rb#184
    def validated_parser_type(type); end

    private

    # Parses a list of files in a queue.
    #
    # @param files [Array<String>] a list of files to queue for parsing
    # @return [void]
    #
    # source://yard//lib/yard/parser/source_parser.rb#364
    def parse_in_order(*files); end
  end
end

# The default glob of files to be parsed.
#
# @since 0.9.0
#
# source://yard//lib/yard/parser/source_parser.rb#70
YARD::Parser::SourceParser::DEFAULT_PATH_GLOB = T.let(T.unsafe(nil), Array)

# Byte order marks for various encodings
#
# @since 0.7.0
#
# source://yard//lib/yard/parser/source_parser.rb#74
YARD::Parser::SourceParser::ENCODING_BYTE_ORDER_MARKS = T.let(T.unsafe(nil), Hash)

# source://yard//lib/yard/parser/source_parser.rb#65
YARD::Parser::SourceParser::ENCODING_LINE = T.let(T.unsafe(nil), Regexp)

# source://yard//lib/yard/parser/source_parser.rb#66
YARD::Parser::SourceParser::FROZEN_STRING_LINE = T.let(T.unsafe(nil), Regexp)

# source://yard//lib/yard/parser/source_parser.rb#64
YARD::Parser::SourceParser::SHEBANG_LINE = T.let(T.unsafe(nil), Regexp)

# Raised when an object is recognized but cannot be documented. This
# generally occurs when the Ruby syntax used to declare an object is
# too dynamic in nature.
#
# source://yard//lib/yard/parser/source_parser.rb#9
class YARD::Parser::UndocumentableError < ::RuntimeError; end

# The root path for YARD source libraries
#
# source://yard//lib/yard.rb#4
YARD::ROOT = T.let(T.unsafe(nil), String)

# Holds Rake tasks used by YARD
#
# source://yard//lib/yard/autoload.rb#192
module YARD::Rake; end

# The rake task to run {CLI::Yardoc} and generate documentation.
#
# source://yard//lib/yard/rake/yardoc_task.rb#8
class YARD::Rake::YardocTask < ::Rake::TaskLib
  # Creates a new task with name +name+.
  #
  # @param name [String, Symbol] the name of the rake task
  # @return [YardocTask] a new instance of YardocTask
  # @yield a block to allow any options to be modified on the task
  # @yieldparam _self [YardocTask] the task object to allow any parameters
  #   to be changed.
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#50
  def initialize(name = T.unsafe(nil)); end

  # Runs a +Proc+ after the task
  #
  # @return [Proc] a proc to call after running the task
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#36
  def after; end

  # Runs a +Proc+ after the task
  #
  # @return [Proc] a proc to call after running the task
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#36
  def after=(_arg0); end

  # Runs a +Proc+ before the task
  #
  # @return [Proc] a proc to call before running the task
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#32
  def before; end

  # Runs a +Proc+ before the task
  #
  # @return [Proc] a proc to call before running the task
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#32
  def before=(_arg0); end

  # The Ruby source files (and any extra documentation files separated by '-')
  # to process.
  #
  # @example Task files assignment
  #   YARD::Rake::YardocTask.new do |t|
  #   t.files   = ['app/**/*.rb', 'lib/**/*.rb', '-', 'doc/FAQ.md', 'doc/Changes.md']
  #   end
  # @return [Array<String>] a list of files
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#28
  def files; end

  # The Ruby source files (and any extra documentation files separated by '-')
  # to process.
  #
  # @example Task files assignment
  #   YARD::Rake::YardocTask.new do |t|
  #   t.files   = ['app/**/*.rb', 'lib/**/*.rb', '-', 'doc/FAQ.md', 'doc/Changes.md']
  #   end
  # @return [Array<String>] a list of files
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#28
  def files=(_arg0); end

  # The name of the task
  #
  # @return [String] the task name
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#11
  def name; end

  # The name of the task
  #
  # @return [String] the task name
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#11
  def name=(_arg0); end

  # Options to pass to {CLI::Yardoc}
  #
  # @return [Array<String>] the options passed to the commandline utility
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#15
  def options; end

  # Options to pass to {CLI::Yardoc}
  #
  # @return [Array<String>] the options passed to the commandline utility
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#15
  def options=(_arg0); end

  # Options to pass to {CLI::Stats}
  #
  # @return [Array<String>] the options passed to the stats utility
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#19
  def stats_options; end

  # Options to pass to {CLI::Stats}
  #
  # @return [Array<String>] the options passed to the stats utility
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#19
  def stats_options=(_arg0); end

  # @return [Verifier, Proc] an optional {Verifier} to run against all objects
  #   being generated. Any object that the verifier returns false for will be
  #   excluded from documentation. This attribute can also be a lambda.
  # @see Verifier
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#42
  def verifier; end

  # @return [Verifier, Proc] an optional {Verifier} to run against all objects
  #   being generated. Any object that the verifier returns false for will be
  #   excluded from documentation. This attribute can also be a lambda.
  # @see Verifier
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#42
  def verifier=(_arg0); end

  protected

  # Defines the rake task
  #
  # @return [void]
  #
  # source://yard//lib/yard/rake/yardoc_task.rb#68
  def define; end
end

# The +Registry+ is the centralized data store for all {CodeObjects} created
# during parsing. The storage is a key value store with the object's path
# (see {CodeObjects::Base#path}) as the key and the object itself as the value.
# Object paths must be unique to be stored in the Registry. All lookups for
# objects are done on the singleton Registry instance using the {Registry.at}
# or {Registry.resolve} methods.
#
# == Saving / Loading a Registry
# The registry is saved to a "yardoc file" (actually a directory), which can
# be loaded back to perform any lookups. See {Registry.load!} and
# {Registry.save} for information on saving and loading of a yardoc file.
#
# == Threading Notes
# The registry class is a singleton class that is accessed directly in many
# places across YARD. To mitigate threading issues, YARD (0.6.5+) makes
# the Registry thread local. This means all access to a registry for a specific
# object set must occur in the originating thread.
#
# @example Loading the Registry
#   Registry.load!('/path/to/yardocfile') # loads all objects into memory
#   Registry.at('YARD::CodeObjects::Base').docstring
#   # => "+Base+ is the superclass of all code objects ..."
# @example Getting an object by a specific path
#   Registry.at('YARD::CodeObjects::Base#docstring')
# @example Performing a lookup on a method anywhere in the inheritance tree
#   Registry.resolve(P('YARD::CodeObjects::Base'), '#docstring', true)
#
# source://yard//lib/yard/registry.rb#32
module YARD::Registry
  extend ::Enumerable

  class << self
    # Returns the object at a specific path.
    #
    # @param path [String, :root] the pathname to look for. If +path+ is +root+,
    #   returns the {root} object.
    # @return [CodeObjects::Base] the object at path
    # @return [nil] if no object is found
    #
    # source://yard//lib/yard/registry.rb#261
    def [](path); end

    # Returns all objects in the registry that match one of the types provided
    # in the +types+ list (if +types+ is provided).
    #
    # @example Returns all objects
    #   Registry.all
    # @example Returns all classes and modules
    #   Registry.all(:class, :module)
    # @param types [Array<Symbol>] an optional list of types to narrow the
    #   objects down by. Equivalent to performing a select:
    #   +Registry.all.select {|o| types.include(o.type) }+
    # @return [Array<CodeObjects::Base>] the list of objects found
    # @see CodeObjects::Base#type
    #
    # source://yard//lib/yard/registry.rb#237
    def all(*types); end

    # Returns the object at a specific path.
    #
    # @param path [String, :root] the pathname to look for. If +path+ is +root+,
    #   returns the {root} object.
    # @return [CodeObjects::Base] the object at path
    # @return [nil] if no object is found
    #
    # source://yard//lib/yard/registry.rb#261
    def at(path); end

    # @param data [String] data to checksum
    # @return [String] the SHA1 checksum for data
    #
    # source://yard//lib/yard/registry.rb#318
    def checksum_for(data); end

    # @return [Hash{String => String}] a set of checksums for files
    #
    # source://yard//lib/yard/registry.rb#312
    def checksums; end

    # Clears the registry
    #
    # @return [void]
    #
    # source://yard//lib/yard/registry.rb#200
    def clear; end

    # Deletes an object from the registry
    #
    # @param object [CodeObjects::Base] the object to remove
    # @return [void]
    #
    # source://yard//lib/yard/registry.rb#194
    def delete(object); end

    # Deletes the yardoc file from disk
    #
    # @return [void]
    #
    # source://yard//lib/yard/registry.rb#176
    def delete_from_disk; end

    # Iterates over {all} with no arguments
    #
    # source://yard//lib/yard/registry.rb#221
    def each(&block); end

    # The registry singleton instance.
    #
    # @deprecated use Registry.methodname directly.
    # @return [Registry] returns the registry instance
    #
    # source://yard//lib/yard/registry.rb#363
    def instance; end

    # Loads the registry and/or parses a list of files
    #
    # @example Loads the yardoc file or parses files 'a', 'b' and 'c' (but not both)
    #   Registry.load(['a', 'b', 'c'])
    # @example Reparses files 'a' and 'b' regardless of whether yardoc file exists
    #   Registry.load(['a', 'b'], true)
    # @param files [String, Array] if +files+ is an Array, it should represent
    #   a list of files that YARD should parse into the registry. If reload is
    #   set to false and the yardoc file already exists, these files are skipped.
    #   If files is a String, it should represent the yardoc file to load
    #   into the registry.
    # @param reparse [Boolean] if reparse is false and a yardoc file already
    #   exists, any files passed in will be ignored.
    # @raise [ArgumentError] if files is not a String or Array
    # @return [Registry] the registry object (for chaining)
    #
    # source://yard//lib/yard/registry.rb#109
    def load(files = T.unsafe(nil), reparse = T.unsafe(nil)); end

    # Loads a yardoc file and forces all objects cached on disk into
    # memory. Equivalent to calling {load_yardoc} followed by {load_all}
    #
    # @param file [String] the yardoc file to load
    # @return [Registry] the registry object (for chaining)
    # @see #load_yardoc
    # @see #load_all
    # @since 0.5.1
    #
    # source://yard//lib/yard/registry.rb#144
    def load!(file = T.unsafe(nil)); end

    # Forces all objects cached on disk into memory
    #
    # @example Loads all objects from disk
    #   Registry.load
    #   Registry.all.count #=> 0
    #   Registry.load_all
    #   Registry.all.count #=> 17
    # @return [Registry] the registry object (for chaining)
    # @since 0.5.1
    #
    # source://yard//lib/yard/registry.rb#159
    def load_all; end

    # Loads a yardoc file directly
    #
    # @param file [String] the yardoc file to load.
    # @return [Registry] the registry object (for chaining)
    #
    # source://yard//lib/yard/registry.rb#130
    def load_yardoc(file = T.unsafe(nil)); end

    # @param name [String] the locale name.
    # @return [I18n::Locale] the locale object for +name+.
    # @since 0.8.3
    #
    # source://yard//lib/yard/registry.rb#271
    def locale(name); end

    # Creates a pessmistic transactional lock on the database for writing.
    # Use with {YARD.parse} to ensure the database is not written multiple
    # times.
    #
    # @see locked_for_writing?
    #
    # source://yard//lib/yard/registry.rb#209
    def lock_for_writing(file = T.unsafe(nil), &block); end

    # @return [Boolean] whether the database is currently locked for writing
    #
    # source://yard//lib/yard/registry.rb#214
    def locked_for_writing?(file = T.unsafe(nil)); end

    # Returns the paths of all of the objects in the registry.
    #
    # @param reload [Boolean] whether to load entire database
    # @return [Array<String>] all of the paths in the registry.
    #
    # source://yard//lib/yard/registry.rb#252
    def paths(reload = T.unsafe(nil)); end

    # Gets/sets the directory that has LANG.po files
    #
    # @return [String] the directory that has .po files
    #
    # source://yard//lib/yard/registry.rb#353
    def po_dir; end

    # Gets/sets the directory that has LANG.po files
    #
    # @return [String] the directory that has .po files
    #
    # source://yard//lib/yard/registry.rb#351
    def po_dir=(dir); end

    # The assumed types of a list of paths. This method is used by CodeObjects::Base
    #
    # @deprecated The registry no longer globally tracks proxy types.
    # @private
    # @return [{String => Symbol}] a set of unresolved paths and their assumed type
    #
    # source://yard//lib/yard/registry.rb#341
    def proxy_types; end

    # Registers a new object with the registry
    #
    # @param object [CodeObjects::Base] the object to register
    # @return [CodeObjects::Base] the registered object
    #
    # source://yard//lib/yard/registry.rb#186
    def register(object); end

    # Attempts to find an object by name starting at +namespace+, performing
    # a lookup similar to Ruby's method of resolving a constant in a namespace.
    #
    # @example Looks for a constant in the root namespace
    #   Registry.resolve(nil, 'CONSTANT')
    # @example Looks for a class method respecting the inheritance tree
    #   Registry.resolve(myclass, 'mymethod', true)
    # @example Looks for instance method #reverse starting from A::B::C
    #   Registry.resolve(P("A::B::C"), "#reverse")
    # @example Looks for a constant but returns a proxy if not found
    #   Registry.resolve(P('A::B::C'), 'D', false, true) # => #<yardoc proxy A::B::C::D>
    # @example Looks for a complex path from a namespace
    #   Registry.resolve(P('A::B'), 'B::D') # => #<yardoc class A::B::D>
    # @param inheritance [Boolean] Follows inheritance chain (mixins, superclass)
    #   when performing name resolution if set to +true+.
    # @param namespace [CodeObjects::NamespaceObject, nil] the starting namespace
    #   (module or class). If +nil+ or +:root+, starts from the {root} object.
    # @param name [String, Symbol] the name (or complex path) to look for from
    #   +namespace+.
    # @param proxy_fallback [Boolean] If +true+, returns a proxy representing
    #   the unresolved path (namespace + name) if no object is found.
    # @param type [Symbol, nil] the {CodeObjects::Base#type} that the resolved
    #   object must be equal to. No type checking if nil.
    # @return [CodeObjects::Base] the object if it is found
    # @return [CodeObjects::Proxy] a Proxy representing the object if
    #   +proxy_fallback+ is +true+.
    # @return [nil] if +proxy_fallback+ is +false+ and no object was found.
    # @see P
    #
    # source://yard//lib/yard/registry.rb#303
    def resolve(namespace, name, inheritance = T.unsafe(nil), proxy_fallback = T.unsafe(nil), type = T.unsafe(nil)); end

    # The root namespace object.
    #
    # @return [CodeObjects::RootObject] the root object in the namespace
    #
    # source://yard//lib/yard/registry.rb#266
    def root; end

    # Saves the registry to +file+
    #
    # @param file [String] the yardoc file to save to
    # @return [Boolean] true if the file was saved
    #
    # source://yard//lib/yard/registry.rb#170
    def save(merge = T.unsafe(nil), file = T.unsafe(nil)); end

    # Whether or not the Registry storage should load everything into a
    # single object database (for disk efficiency), or spread them out
    # (for load time efficiency).
    #
    # @note Setting this attribute to nil will offload the decision to
    #   the {RegistryStore storage adapter}.
    # @return [Boolean, nil] if this value is set to nil, the storage
    #   adapter will decide how to store the data.
    #
    # source://yard//lib/yard/registry.rb#335
    def single_object_db; end

    # Whether or not the Registry storage should load everything into a
    # single object database (for disk efficiency), or spread them out
    # (for load time efficiency).
    #
    # @note Setting this attribute to nil will offload the decision to
    #   the {RegistryStore storage adapter}.
    # @return [Boolean, nil] if this value is set to nil, the storage
    #   adapter will decide how to store the data.
    #
    # source://yard//lib/yard/registry.rb#334
    def single_object_db=(v); end

    # Gets/sets the yardoc filename
    #
    # @return [String] the yardoc filename
    # @see DEFAULT_YARDOC_FILE
    #
    # source://yard//lib/yard/registry.rb#88
    def yardoc_file; end

    # Gets/sets the yardoc filename
    #
    # @return [String] the yardoc filename
    # @see DEFAULT_YARDOC_FILE
    #
    # source://yard//lib/yard/registry.rb#86
    def yardoc_file=(v); end

    # Returns the .yardoc file associated with a gem.
    #
    # @param gem [String] the name of the gem to search for
    # @param ver_require [String] an optional Gem version requirement
    # @param for_writing [Boolean] whether or not the method should search
    #   for writable locations
    # @return [String] if +for_writing+ is set to +true+, returns the best
    #   location suitable to write the .yardoc file. Otherwise, the first
    #   existing location associated with the gem's .yardoc file.
    # @return [nil] if +for_writing+ is set to false and no yardoc file
    #   is found, returns nil.
    #
    # source://yard//lib/yard/registry.rb#53
    def yardoc_file_for_gem(gem, ver_require = T.unsafe(nil), for_writing = T.unsafe(nil)); end

    private

    # source://yard//lib/yard/registry.rb#390
    def global_yardoc_file(spec, for_writing = T.unsafe(nil)); end

    # source://yard//lib/yard/registry.rb#410
    def local_yardoc_file(spec, for_writing = T.unsafe(nil)); end

    # source://yard//lib/yard/registry.rb#403
    def old_global_yardoc_file(spec, for_writing = T.unsafe(nil)); end

    # Attempts to resolve a name in a namespace
    #
    # @param namespace [CodeObjects::NamespaceObject] the starting namespace
    # @param name [String] the name to look for
    # @param type [Symbol, nil] the {CodeObjects::Base#type} that the resolved
    #   object must be equal to
    #
    # source://yard//lib/yard/registry.rb#375
    def partial_resolve(namespace, name, type = T.unsafe(nil)); end

    # @since 0.9.1
    #
    # source://yard//lib/yard/registry.rb#434
    def thread_local_resolver; end

    # @since 0.6.5
    #
    # source://yard//lib/yard/registry.rb#424
    def thread_local_store; end

    # @since 0.6.5
    #
    # source://yard//lib/yard/registry.rb#429
    def thread_local_store=(value); end
  end
end

# source://yard//lib/yard/registry.rb#35
YARD::Registry::DEFAULT_PO_DIR = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/registry.rb#33
YARD::Registry::DEFAULT_YARDOC_FILE = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/registry.rb#34
YARD::Registry::LOCAL_YARDOC_INDEX = T.let(T.unsafe(nil), String)

# Handles all logic for complex lexical and inherited object resolution.
# Used by {Registry.resolve}, so there is no need to use this class
# directly.
#
# @see Registry.resolve
# @since 0.9.1
#
# source://yard//lib/yard/registry_resolver.rb#9
class YARD::RegistryResolver
  include ::YARD::CodeObjects::NamespaceMapper

  # Creates a new resolver object for a registry.
  #
  # @param registry [Registry] only set this if customizing the registry
  #   object
  # @return [RegistryResolver] a new instance of RegistryResolver
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#16
  def initialize(registry = T.unsafe(nil)); end

  # Performs a lookup on a given path in the registry. Resolution will occur
  # in a similar way to standard Ruby identifier resolution, doing lexical
  # lookup, as well as (optionally) through the inheritance chain. A proxy
  # object can be returned if the lookup fails for future resolution. The
  # proxy will be type hinted with the +type+ used in the original lookup.
  #
  # @example A lookup on a method through the inheritance tree
  #   resolver.lookup_by_math("A::B#foo", inheritance: true)
  # @example A lookup from root
  #   resolver.lookup_by_path("A::B::C")
  # @example A lookup from the A::B namespace
  #   resolver.lookup_by_path("C", namespace: P("A::B"))
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [CodeObjects::Base, CodeObjects::Proxy, nil] the first object
  #   that matches the path lookup. If proxy_fallback is provided, a proxy
  #   object will be returned in the event of no match, otherwise nil will
  #   be returned.
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#50
  def lookup_by_path(path, opts = T.unsafe(nil)); end

  private

  # Collects and returns all inherited namespaces for a given object
  #
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#181
  def collect_namespaces(object); end

  # Performs a lexical lookup from a namespace for a path and a type hint.
  #
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#104
  def lookup_path_direct(namespace, path, type); end

  # Performs a lookup through the inheritance chain on a path with a type hint.
  #
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#121
  def lookup_path_inherited(namespace, path, type); end

  # @return [Regexp] the regexp that can be used to split a string on all
  #   occurrences of separator tokens
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#206
  def split_on_separators_match; end

  # @return [Regexp] the regexp match of the default separator
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#194
  def starts_with_default_separator_match; end

  # @return [Regexp] the regexp that matches strings starting with
  #   a separator
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#200
  def starts_with_separator_match; end

  # return [Boolean] if the obj's type matches the provided type.
  #
  # @since 0.9.1
  #
  # source://yard//lib/yard/registry_resolver.rb#99
  def validate(obj, type); end
end

# The data store for the {Registry}.
#
# @see Registry
# @see Serializers::YardocSerializer
#
# source://yard//lib/yard/registry_store.rb#9
class YARD::RegistryStore
  # @return [RegistryStore] a new instance of RegistryStore
  #
  # source://yard//lib/yard/registry_store.rb#14
  def initialize; end

  # Gets a {CodeObjects::Base} from the store
  #
  # @param key [String, Symbol] the path name of the object to look for.
  #   If it is empty or :root, returns the {#root} object.
  # @return [CodeObjects::Base, nil] a code object or nil if none is found
  #
  # source://yard//lib/yard/registry_store.rb#33
  def [](key); end

  # Associates an object with a path
  #
  # @param key [String, Symbol] the path name (:root or '' for root object)
  # @param value [CodeObjects::Base] the object to store
  # @return [CodeObjects::Base] returns +value+
  #
  # source://yard//lib/yard/registry_store.rb#55
  def []=(key, value); end

  # Returns the value of attribute checksums.
  #
  # source://yard//lib/yard/registry_store.rb#12
  def checksums; end

  # Deletes an object at a given path
  #
  # @param key [#to_sym] the key to delete
  # @return [void]
  #
  # source://yard//lib/yard/registry_store.rb#75
  def delete(key); end

  # Deletes the .yardoc database on disk
  #
  # @param force [Boolean] if force is not set to true, the file/directory
  #   will only be removed if it ends with .yardoc. This helps with
  #   cases where the directory might have been named incorrectly.
  # @return [Boolean] true if the .yardoc database was deleted, false
  #   otherwise.
  #
  # source://yard//lib/yard/registry_store.rb#218
  def destroy(force = T.unsafe(nil)); end

  # Returns the value of attribute file.
  #
  # source://yard//lib/yard/registry_store.rb#12
  def file; end

  # Gets a {CodeObjects::Base} from the store
  #
  # @param key [String, Symbol] the path name of the object to look for.
  #   If it is empty or :root, returns the {#root} object.
  # @return [CodeObjects::Base, nil] a code object or nil if none is found
  #
  # source://yard//lib/yard/registry_store.rb#33
  def get(key); end

  # Gets all path names from the store. Loads the entire database
  # if +reload+ is +true+
  #
  # @param reload [Boolean] if false, does not load the entire database
  #   before a lookup.
  # @return [Array<Symbol>] the path names of all the code objects
  #
  # source://yard//lib/yard/registry_store.rb#88
  def keys(reload = T.unsafe(nil)); end

  # @param file [String, nil] the name of the yardoc db to load
  # @return [Boolean] whether the database was loaded
  #
  # source://yard//lib/yard/registry_store.rb#128
  def load(file = T.unsafe(nil)); end

  # Loads the .yardoc file and loads all cached objects into memory
  # automatically.
  #
  # @param file [String, nil] the name of the yardoc db to load
  # @return [Boolean] whether the database was loaded
  # @see #load_all
  # @since 0.5.1
  #
  # source://yard//lib/yard/registry_store.rb#142
  def load!(file = T.unsafe(nil)); end

  # Loads all cached objects into memory
  #
  # @return [void]
  #
  # source://yard//lib/yard/registry_store.rb#153
  def load_all; end

  # @param name [String] the locale name.
  # @return [I18n::Locale] the locale object for +name+.
  # @since 0.8.3
  #
  # source://yard//lib/yard/registry_store.rb#122
  def locale(name); end

  # Creates a pessmistic transactional lock on the database for writing.
  # Use with {YARD.parse} to ensure the database is not written multiple
  # times.
  #
  # @param file [String] if supplied, the path to the database
  # @see #locked_for_writing?
  #
  # source://yard//lib/yard/registry_store.rb#201
  def lock_for_writing(file = T.unsafe(nil), &block); end

  # @param file [String] if supplied, the path to the database
  # @return [Boolean] whether the database is currently locked for writing
  #
  # source://yard//lib/yard/registry_store.rb#207
  def locked_for_writing?(file = T.unsafe(nil)); end

  # @param type [Symbol] the type to look for
  # @return [Array<String>] a list of object paths with a given
  #   {CodeObjects::Base#type}
  # @since 0.8.0
  #
  # source://yard//lib/yard/registry_store.rb#102
  def paths_for_type(type, reload = T.unsafe(nil)); end

  # @deprecated The registry no longer tracks proxy types
  #
  # source://yard//lib/yard/registry_store.rb#11
  def proxy_types; end

  # Associates an object with a path
  #
  # @param key [String, Symbol] the path name (:root or '' for root object)
  # @param value [CodeObjects::Base] the object to store
  # @return [CodeObjects::Base] returns +value+
  #
  # source://yard//lib/yard/registry_store.rb#55
  def put(key, value); end

  # @return [CodeObjects::RootObject] the root object
  #
  # source://yard//lib/yard/registry_store.rb#117
  def root; end

  # Saves the database to disk
  #
  # @param merge [Boolean] if true, merges the data in memory with the
  #   data on disk, otherwise the data on disk is deleted.
  # @param file [String, nil] if supplied, the name of the file to save to
  # @return [Boolean] whether the database was saved
  #
  # source://yard//lib/yard/registry_store.rb#177
  def save(merge = T.unsafe(nil), file = T.unsafe(nil)); end

  # Gets all code objects from the store. Loads the entire database
  # if +reload+ is +true+
  #
  # @param reload [Boolean] if false, does not load the entire database
  #   before a lookup.
  # @return [Array<CodeObjects::Base>] all the code objects
  #
  # source://yard//lib/yard/registry_store.rb#96
  def values(reload = T.unsafe(nil)); end

  # @param type [Symbol] the type to look for
  # @return [Array<CodeObjects::Base>] a list of objects with a given
  #   {CodeObjects::Base#type}
  # @since 0.8.0
  #
  # source://yard//lib/yard/registry_store.rb#111
  def values_for_type(type, reload = T.unsafe(nil)); end

  protected

  # source://yard//lib/yard/registry_store.rb#243
  def checksums_path; end

  # source://yard//lib/yard/registry_store.rb#251
  def load_yardoc; end

  # source://yard//lib/yard/registry_store.rb#247
  def object_types_path; end

  # source://yard//lib/yard/registry_store.rb#234
  def objects_path; end

  # @deprecated The registry no longer tracks proxy types
  #
  # source://yard//lib/yard/registry_store.rb#239
  def proxy_types_path; end

  private

  # source://yard//lib/yard/registry_store.rb#319
  def all_disk_objects; end

  # source://yard//lib/yard/registry_store.rb#291
  def load_checksums; end

  # source://yard//lib/yard/registry_store.rb#313
  def load_locale(name); end

  # source://yard//lib/yard/registry_store.rb#281
  def load_object_types; end

  # @deprecated The registry no longer tracks proxy types
  #
  # source://yard//lib/yard/registry_store.rb#276
  def load_proxy_types; end

  # source://yard//lib/yard/registry_store.rb#299
  def load_root; end

  # source://yard//lib/yard/registry_store.rb#271
  def load_yardoc_old; end

  # source://yard//lib/yard/registry_store.rb#332
  def write_checksums; end

  # source://yard//lib/yard/registry_store.rb#338
  def write_complete_lock; end

  # source://yard//lib/yard/registry_store.rb#328
  def write_object_types; end

  # @deprecated The registry no longer tracks proxy types
  #
  # source://yard//lib/yard/registry_store.rb#324
  def write_proxy_types; end
end

# Namespace for components that serialize to various endpoints
#
# source://yard//lib/yard/autoload.rb#196
module YARD::Serializers; end

# The abstract base serializer. Serializers allow templates to be
# rendered to various endpoints. For instance, a {FileSystemSerializer}
# would allow template contents to be written to the filesystem
#
# To implement a custom serializer, override the following methods:
# * {#serialize}
# * {#serialized_path}
#
# Optionally, a serializer can implement before and after filters:
# * {#before_serialize}
# * {#after_serialize}
#
# @abstract Override this class to implement a custom serializer.
#
# source://yard//lib/yard/serializers/base.rb#17
class YARD::Serializers::Base
  # Creates a new serializer with options
  #
  # @param opts [Hash] the options to assign to {#options}
  # @return [Base] a new instance of Base
  #
  # source://yard//lib/yard/serializers/base.rb#28
  def initialize(opts = T.unsafe(nil)); end

  # Called after serialization.
  #
  # @abstract Should run code after serialization.
  # @param data [String] the data that was serialized.
  # @return [void]
  #
  # source://yard//lib/yard/serializers/base.rb#80
  def after_serialize(data); end

  # Called before serialization.
  #
  # @abstract Should run code before serialization. Should return false
  #   if serialization should not occur.
  # @return [Boolean] whether or not serialization should occur
  #
  # source://yard//lib/yard/serializers/base.rb#73
  def before_serialize; end

  # Returns whether an object has been serialized
  #
  # @abstract This method should return whether the endpoint already exists.
  #   For instance, a file system serializer would check if the file exists
  #   on disk. You will most likely use +#basepath+ and {#serialized_path} to
  #   get the endpoint's location.
  # @param object [CodeObjects::Base] the object to check existence of
  # @return [Boolean] whether the endpoint exists.
  # @since 0.6.0
  #
  # source://yard//lib/yard/serializers/base.rb#62
  def exists?(object); end

  # All serializer options are saved so they can be passed to other serializers.
  #
  # @return [SymbolHash] the serializer options
  #
  # source://yard//lib/yard/serializers/base.rb#21
  def options; end

  # Serializes an object.
  #
  # @abstract This method should implement the logic that serializes
  #   +data+ to the respective endpoint. This method should also call
  #   the before and after callbacks {#before_serialize} and {#after_serialize}
  # @param object [CodeObjects::Base, String] the object to serialize the
  #   data for. The object can also be a string (for non-object serialization)
  # @param data [String] the contents that should be serialized
  #
  # source://yard//lib/yard/serializers/base.rb#42
  def serialize(object, data); end

  # The serialized path of an object
  #
  # @abstract This method should return the path of the object on the
  #   endpoint. For instance, for a file serializer, this should return
  #   the filename that represents the object on disk.
  # @param object [CodeObjects::Base] the object to return a path for
  # @return [String] the serialized path of an object
  #
  # source://yard//lib/yard/serializers/base.rb#51
  def serialized_path(object); end
end

# Implements a serializer that reads from and writes to the filesystem.
#
# source://yard//lib/yard/serializers/file_system_serializer.rb#5
class YARD::Serializers::FileSystemSerializer < ::YARD::Serializers::Base
  # Creates a new FileSystemSerializer with options
  #
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [FileSystemSerializer] a new instance of FileSystemSerializer
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#28
  def initialize(opts = T.unsafe(nil)); end

  # The base path to write data to.
  #
  # @return [String] a base path
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#8
  def basepath; end

  # source://yard//lib/yard/serializers/file_system_serializer.rb#10
  def basepath=(value); end

  # Checks the disk for an object and returns whether it was serialized.
  #
  # @param object [CodeObjects::Base] the object to check
  # @return [Boolean] whether an object has been serialized to disk
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#71
  def exists?(object); end

  # The extension of the filename (defaults to +html+)
  #
  # @return [String] the extension of the file. Empty string for no extension.
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#17
  def extension; end

  # source://yard//lib/yard/serializers/file_system_serializer.rb#19
  def extension=(value); end

  # Serializes object with data to its serialized path (prefixed by the +#basepath+).
  #
  # @return [String] the written data (for chaining)
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#38
  def serialize(object, data); end

  # Implements the serialized path of a code object.
  #
  # @param object [CodeObjects::Base, CodeObjects::ExtraFileObject, String] the object to get a path for. The path of a string is the string itself.
  # @return [String] if object is a String, returns
  #   object, otherwise the path on disk (without the basepath).
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#50
  def serialized_path(object); end

  private

  # Builds a filename mapping from object paths to filesystem path names.
  # Needed to handle case sensitive YARD objects mapped into a case
  # insensitive filesystem. Uses with {#mapped_name} to determine the
  # mapping name for a given object.
  #
  # @note In order to use filesystem name mapping, you must initialize
  #   the serializer object after preparing the {YARD::Registry}.
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#84
  def build_filename_map; end

  # Remove special chars from filenames.
  # Windows disallows \ / : * ? " < > | but we will just remove any
  # non alphanumeric (plus period, underscore and dash).
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#111
  def encode_path_components(*components); end

  # @return [String] the filesystem mapped name of a given object.
  #
  # source://yard//lib/yard/serializers/file_system_serializer.rb#102
  def mapped_name(object); end
end

# Serializes an object to a process (like less)
#
# @example Serializing to a pager (less)
#   serializer = ProcessSerializer.new('less')
#   serializer.serialize(object, "data!")
#
# source://yard//lib/yard/serializers/process_serializer.rb#9
class YARD::Serializers::ProcessSerializer < ::YARD::Serializers::Base
  # Creates a new ProcessSerializer for the shell command +cmd+
  #
  # @param cmd [String] the command that will accept data on stdin
  # @return [ProcessSerializer] a new instance of ProcessSerializer
  #
  # source://yard//lib/yard/serializers/process_serializer.rb#13
  def initialize(cmd); end

  # Overrides serialize behaviour and writes data to standard input
  # of the associated command
  #
  # source://yard//lib/yard/serializers/process_serializer.rb#19
  def serialize(_object, data); end
end

# A serializer that writes data to standard output.
#
# source://yard//lib/yard/serializers/stdout_serializer.rb#5
class YARD::Serializers::StdoutSerializer < ::YARD::Serializers::Base
  # Creates a serializer to print text to stdout
  #
  # @param wrap [Fixnum, nil] if wrap is a number, wraps text to +wrap+
  #   columns, otherwise no wrapping is done.
  # @return [StdoutSerializer] a new instance of StdoutSerializer
  #
  # source://yard//lib/yard/serializers/stdout_serializer.rb#10
  def initialize(wrap = T.unsafe(nil)); end

  # Overrides serialize behaviour to write data to standard output
  #
  # source://yard//lib/yard/serializers/stdout_serializer.rb#15
  def serialize(_object, data); end

  private

  # Wraps text to a specific column length
  #
  # @param text [String] the text to wrap
  # @param _length [Fixnum] the column length to wrap to
  # @return [String] the wrapped text
  #
  # source://yard//lib/yard/serializers/stdout_serializer.rb#26
  def word_wrap(text, _length = T.unsafe(nil)); end
end

# source://yard//lib/yard/serializers/yardoc_serializer.rb#32
class YARD::Serializers::YardocSerializer < ::YARD::Serializers::FileSystemSerializer
  # @return [YardocSerializer] a new instance of YardocSerializer
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#33
  def initialize(yfile); end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#40
  def checksums_path; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#45
  def complete?; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#42
  def complete_lock_path; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#101
  def deserialize(path, is_path = T.unsafe(nil)); end

  # Creates a pessmistic transactional lock on the database for writing.
  # Use with {YARD.parse} to ensure the database is not written multiple
  # times.
  #
  # @see #locked_for_writing?
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#54
  def lock_for_writing; end

  # @return [Boolean] whether the database is currently locked for writing
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#62
  def locked_for_writing?; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#41
  def object_types_path; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#37
  def objects_path; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#43
  def processing_path; end

  # @deprecated The registry no longer tracks proxy types
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#39
  def proxy_types_path; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#93
  def serialize(object); end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#66
  def serialized_path(object); end

  private

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#114
  def dump(object); end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#119
  def internal_dump(object, first_object = T.unsafe(nil)); end
end

# Namespace for classes and modules that handle serving documentation over HTTP
#
# == Implementing a Custom Server
# To customize the YARD server, see the {Adapter} and {Router} classes.
#
# == Rack Middleware
# If you want to use the YARD server as a Rack middleware, see the documentation
# in {RackMiddleware}.
#
# @since 0.6.0
#
# source://yard//lib/yard/autoload.rb#214
module YARD::Server
  class << self
    # Registers a static path to be used in static asset lookup.
    #
    # @param path [String] the pathname to register
    # @return [void]
    # @since 0.6.2
    #
    # source://yard//lib/yard/server.rb#8
    def register_static_path(path); end
  end
end

# This class implements the bridge between the {Router} and the server
# backend for a specific server type. YARD implements concrete adapters
# for WEBrick and Rack respectively, though other adapters can be made
# for other server architectures.
#
# == Subclassing Notes
# To create a concrete adapter class, implement the {#start} method to
# initiate the server backend.
#
# @abstract
# @since 0.6.0
#
# source://yard//lib/yard/server/adapter.rb#23
class YARD::Server::Adapter
  # Creates a new adapter object
  #
  # @option opts
  # @option opts
  # @option opts
  # @param libs [Hash{String=>Array<LibraryVersion>}] a list of libraries,
  #   see {#libraries} for formulating this list.
  # @param opts [Hash] extra options to pass to the adapter
  # @return [Adapter] a new instance of Adapter
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#71
  def initialize(libs, opts = T.unsafe(nil), server_opts = T.unsafe(nil)); end

  # Adds a library to the {#libraries} mapping for a given library object.
  #
  # @example Adding a new library to an adapter
  #   adapter.add_library LibraryVersion.new('mylib', '1.0', '/path/to/.yardoc')
  # @param library [LibraryVersion] a library to add
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#88
  def add_library(library); end

  # @return [String] the location where static files are located, if any.
  #   To set this field on initialization, pass +:DocumentRoot+ to the
  #   +server_opts+ argument in {#initialize}
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#27
  def document_root; end

  # @return [String] the location where static files are located, if any.
  #   To set this field on initialization, pass +:DocumentRoot+ to the
  #   +server_opts+ argument in {#initialize}
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#27
  def document_root=(_arg0); end

  # @return [Hash{String=>Array<LibraryVersion>}] a map of libraries.
  # @see LibraryVersion LibraryVersion for information on building a list of libraries
  # @see #add_library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#32
  def libraries; end

  # @return [Hash{String=>Array<LibraryVersion>}] a map of libraries.
  # @see LibraryVersion LibraryVersion for information on building a list of libraries
  # @see #add_library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#32
  def libraries=(_arg0); end

  # @return [Hash] options passed and processed by adapters. The actual
  #   options mostly depend on the adapters themselves.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#36
  def options; end

  # @return [Hash] options passed and processed by adapters. The actual
  #   options mostly depend on the adapters themselves.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#36
  def options=(_arg0); end

  # @return [Router] the router object used to route URLs to commands
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#43
  def router; end

  # @return [Router] the router object used to route URLs to commands
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#43
  def router=(_arg0); end

  # @return [Hash] a set of options to pass to the server backend. Note
  #   that +:DocumentRoot+ also sets the {#document_root}.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#40
  def server_options; end

  # @return [Hash] a set of options to pass to the server backend. Note
  #   that +:DocumentRoot+ also sets the {#document_root}.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#40
  def server_options=(_arg0); end

  # Implement this method to connect your adapter to your server.
  #
  # @abstract
  # @raise [NotImplementedError]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/adapter.rb#95
  def start; end

  class << self
    # Performs any global initialization for the adapter.
    #
    # @note If you subclass this method, make sure to call +super+.
    # @return [void]
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/adapter.rb#48
    def setup; end

    # Performs any global shutdown procedures for the adapter.
    #
    # @note If you subclass this method, make sure to call +super+.
    # @return [void]
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/adapter.rb#56
    def shutdown; end
  end
end

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#16
YARD::Server::CR = T.let(T.unsafe(nil), String)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#18
YARD::Server::CRLF = T.let(T.unsafe(nil), String)

# Commands implement specific kinds of server responses which are routed
# to by the {Router} class. To implement a custom command, subclass {Commands::Base}.
#
# @since 0.6.0
#
# source://yard//lib/yard/autoload.rb#219
module YARD::Server::Commands; end

# This is the base command class used to implement custom commands for
# a server. A command will be routed to by the {Router} class and return
# a Rack-style response.
#
# == Attribute Initializers
# All attributes can be initialized via options passed into the {#initialize}
# method. When creating a custom command, the {Adapter#options} will
# automatically be mapped to attributes by the same name on your class.
#
#   class MyCommand < Base
#     attr_accessor :myattr
#   end
#
#   Adapter.new(libs, {:myattr => 'foo'}).start
#
#   # when a request comes in, cmd.myattr == 'foo'
#
# == Subclassing Notes
# To implement a custom command, override the {#run} method, not {#call}.
# In your implementation, you should set the body and status for requests.
# See details in the +#run+ method documentation.
#
# Note that if your command deals directly with libraries, you should
# consider subclassing the more specific {LibraryCommand} class instead.
#
# @abstract
# @see #run
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/base.rb#34
class YARD::Server::Commands::Base
  # Creates a new command object, setting attributes named by keys
  # in the options hash. After initialization, the options hash
  # is saved in {#command_options} for further inspection.
  #
  # @example Creating a Command
  #   cmd = DisplayObjectCommand.new(:caching => true, :library => mylib)
  #   cmd.library # => mylib
  #   cmd.command_options # => {:caching => true, :library => mylib}
  # @param opts [Hash] the options hash, saved to {#command_options}
  #   after initialization.
  # @return [Base] a new instance of Base
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#75
  def initialize(opts = T.unsafe(nil)); end

  # @return [Adapter] the server adapter
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#41
  def adapter; end

  # @return [Adapter] the server adapter
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#41
  def adapter=(_arg0); end

  # @return [String] the response body. Defaults to empty string.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#61
  def body; end

  # @return [String] the response body. Defaults to empty string.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#61
  def body=(_arg0); end

  # @return [Boolean] whether to cache
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#44
  def caching; end

  # @return [Boolean] whether to cache
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#44
  def caching=(_arg0); end

  # The main method called by a router with a request object.
  #
  # @note This command should not be overridden by subclasses. Implement
  #   the callback method {#run} instead.
  # @param request [Adapter Dependent] the request object
  # @return [Array(Numeric,Hash,Array<String>)] a Rack-style response
  #   of status, headers, and body wrapped in an array.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#89
  def call(request); end

  # @return [Hash] the options passed to the command's constructor
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#38
  def command_options; end

  # @return [Hash] the options passed to the command's constructor
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#38
  def command_options=(_arg0); end

  # @return [Hash{String => String}] response headers
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#55
  def headers; end

  # @return [Hash{String => String}] response headers
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#55
  def headers=(_arg0); end

  # @return [String] the path after the command base URI
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#52
  def path; end

  # @return [String] the path after the command base URI
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#52
  def path=(_arg0); end

  # @return [Rack::Request] request object
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#49
  def request; end

  # @return [Rack::Request] request object
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#49
  def request=(_arg0); end

  # Subclass this method to implement a custom command. This method
  # should set the {#status} and {#body}, and optionally modify the
  # {#headers}. Note that +#status+ defaults to 200.
  #
  # @abstract
  # @example A custom command
  #   class ErrorCommand < Base
  #   def run
  #   self.body = 'ERROR! The System is down!'
  #   self.status = 500
  #   self.headers['Content-Type'] = 'text/plain'
  #   end
  #   end
  # @raise [NotImplementedError]
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#128
  def run; end

  # @return [Numeric] status code. Defaults to 200 per request
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#58
  def status; end

  # @return [Numeric] status code. Defaults to 200 per request
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#58
  def status=(_arg0); end

  protected

  # Override this method to implement custom caching mechanisms for
  #
  # @example Caching to memory
  #   $memory_cache = {}
  #   def cache(data)
  #   $memory_cache[path] = data
  #   end
  # @param data [String] the data to cache
  # @return [String] the same cached data (for chaining)
  # @see StaticCaching
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#165
  def cache(data); end

  # Sets the body and headers for a 404 response. Does not modify the
  # body if already set.
  #
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#180
  def not_found; end

  # Sets the headers and status code for a redirection to a given URL
  #
  # @param url [String] the URL to redirect to
  # @raise [FinishRequest] causes the request to terminate.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#192
  def redirect(url); end

  # Renders a specific object if provided, or a regular template rendering
  # if object is not provided.
  #
  # @param object [CodeObjects::Base, nil] calls {CodeObjects::Base#format} if
  #   an object is provided, or {Templates::Engine.render} if object is nil. Both
  #   receive +#options+ as an argument.
  # @return [String] the resulting output to display
  # @since 0.6.0
  # @todo This method is dependent on +#options+, it should be in {LibraryCommand}.
  #
  # source://yard//lib/yard/server/commands/base.rb#144
  def render(object = T.unsafe(nil)); end

  private

  # Add a conservative cache control policy to reduce load on
  # requests served with "?1234567890" style timestamp query strings.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/base.rb#202
  def add_cache_control; end
end

# Displays a README or extra file.
#
# @since 0.6.0
# @todo Implement better support for detecting binary (image) filetypes
#
# source://yard//lib/yard/server/commands/display_file_command.rb#8
class YARD::Server::Commands::DisplayFileCommand < ::YARD::Server::Commands::LibraryCommand
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_file_command.rb#9
  def index; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_file_command.rb#9
  def index=(_arg0); end

  # @raise [NotFoundError]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_file_command.rb#11
  def run; end
end

# Displays documentation for a specific object identified by the path
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/display_object_command.rb#6
class YARD::Server::Commands::DisplayObjectCommand < ::YARD::Server::Commands::LibraryCommand
  include ::YARD::Server::DocServerHelper

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_object_command.rb#36
  def index; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_object_command.rb#47
  def not_found; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_object_command.rb#9
  def run; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/display_object_command.rb#54
  def object_path; end
end

# Displays an object wrapped in frames
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/frames_command.rb#6
class YARD::Server::Commands::FramesCommand < ::YARD::Server::Commands::DisplayObjectCommand
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/frames_command.rb#7
  def run; end
end

# This is the base command for all commands that deal directly with libraries.
# Some commands do not, but most (like {DisplayObjectCommand}) do. If your
# command deals with libraries directly, subclass this class instead.
# See {Base} for notes on how to subclass a command.
#
# @abstract
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/library_command.rb#32
class YARD::Server::Commands::LibraryCommand < ::YARD::Server::Commands::Base
  # @return [LibraryCommand] a new instance of LibraryCommand
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#63
  def initialize(opts = T.unsafe(nil)); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#68
  def call(request); end

  # @return [Boolean] whether to reparse data
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#53
  def incremental; end

  # @return [Boolean] whether to reparse data
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#53
  def incremental=(_arg0); end

  # @return [LibraryVersion] the object containing library information
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#41
  def library; end

  # @return [LibraryVersion] the object containing library information
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#41
  def library=(_arg0); end

  # @return [LibraryOptions] default options for the library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#44
  def options; end

  # @return [LibraryOptions] default options for the library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#44
  def options=(_arg0); end

  # @return [Serializers::Base] the serializer used to perform file linking
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#47
  def serializer; end

  # @return [Serializers::Base] the serializer used to perform file linking
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#47
  def serializer=(_arg0); end

  # @return [Boolean] whether router should route for multiple libraries
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#50
  def single_library; end

  # @return [Boolean] whether router should route for multiple libraries
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#50
  def single_library=(_arg0); end

  # @return [Boolean] whether or not this adapter calls +fork+ when serving
  #   library requests. Defaults to false.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#57
  def use_fork; end

  # @return [Boolean] whether or not this adapter calls +fork+ when serving
  #   library requests. Defaults to false.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#57
  def use_fork=(_arg0); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#96
  def call_with_fork(request, &block); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#83
  def call_without_fork(request); end

  # @return [Boolean]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#109
  def can_fork?; end

  # Hack to load a custom fulldoc template object that does
  # not do any rendering/generation. We need this to access the
  # generate_*_list methods.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#171
  def fulldoc_template; end

  # @raise [LibraryNotPreparedError]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#147
  def load_yardoc; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#159
  def not_prepared; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#118
  def restore_template_info; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#113
  def save_default_template_info; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#123
  def setup_library; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#130
  def setup_yardopts; end
end

# source://yard//lib/yard/server/commands/library_command.rb#35
YARD::Server::Commands::LibraryCommand::CAN_FORK = T.let(T.unsafe(nil), TrueClass)

# Returns the index of libraries served by the server.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/library_index_command.rb#13
class YARD::Server::Commands::LibraryIndexCommand < ::YARD::Server::Commands::Base
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#14
  def options; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#14
  def options=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#16
  def run; end
end

# @since 0.6.0
#
# source://yard//lib/yard/server/commands/library_index_command.rb#5
class YARD::Server::Commands::LibraryIndexOptions < ::YARD::CLI::YardocOptions
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#6
  def adapter; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#6
  def adapter=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#6
  def libraries; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_index_command.rb#6
  def libraries=(_arg0); end

  # source://yard//lib/yard/options.rb#82
  def serialize; end

  # source://yard//lib/yard/options.rb#82
  def serialize=(_arg0); end

  # source://yard//lib/yard/options.rb#82
  def template; end

  # source://yard//lib/yard/options.rb#82
  def template=(_arg0); end

  # source://yard//lib/yard/options.rb#82
  def type; end

  # source://yard//lib/yard/options.rb#82
  def type=(_arg0); end
end

# @since 0.6.0
#
# source://yard//lib/yard/server/commands/library_command.rb#7
class YARD::Server::Commands::LibraryOptions < ::YARD::CLI::YardocOptions
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#8
  def adapter; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#14
  def command; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#14
  def command=(_arg0); end

  # @since 0.6.0
  # @yield [:adapter, adapter]
  #
  # source://yard//lib/yard/server/commands/library_command.rb#17
  def each(&block); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#15
  def frames; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#15
  def frames=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#9
  def library; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#12
  def serialize; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#11
  def serializer; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/library_command.rb#10
  def single_library; end
end

# Returns a list of objects of a specific type
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/list_command.rb#6
class YARD::Server::Commands::ListCommand < ::YARD::Server::Commands::LibraryCommand
  include ::YARD::Templates::Helpers::BaseHelper

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/list_command.rb#9
  def run; end
end

# Serves requests from the root of the server
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/root_request_command.rb#6
class YARD::Server::Commands::RootRequestCommand < ::YARD::Server::Commands::Base
  include ::YARD::Server::HTTPUtils
  include ::YARD::Server::Commands::StaticFileHelpers

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/root_request_command.rb#9
  def run; end
end

# Performs a search over the objects inside of a library and returns
# the results as HTML or plaintext
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/search_command.rb#7
class YARD::Server::Commands::SearchCommand < ::YARD::Server::Commands::LibraryCommand
  include ::YARD::Templates::Helpers::BaseHelper
  include ::YARD::Templates::Helpers::ModuleHelper
  include ::YARD::Server::DocServerHelper

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#12
  def query; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#12
  def query=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#12
  def results; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#12
  def results=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#14
  def run; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#26
  def visible_results; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#58
  def search_for_object; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#47
  def serve_normal; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#37
  def serve_xhr; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/search_command.rb#32
  def url_for(object); end
end

# Serves static content when no other router matches a request
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/static_file_command.rb#6
class YARD::Server::Commands::StaticFileCommand < ::YARD::Server::Commands::LibraryCommand
  include ::YARD::Server::HTTPUtils
  include ::YARD::Server::Commands::StaticFileHelpers

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/static_file_command.rb#17
  def run; end
end

# Defines the paths used to search for static assets. To define an
# extra path, use {YARD::Server.register_static_path} rather than
# modifying this constant directly. Also note that files in the
# document root will always take precedence over these paths.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/static_file_command.rb#15
YARD::Server::Commands::StaticFileCommand::STATIC_PATHS = T.let(T.unsafe(nil), Array)

# Include this module to get access to {#static_template_file?}
# and {favicon?} helpers.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/commands/static_file_helpers.rb#8
module YARD::Server::Commands::StaticFileHelpers
  include ::YARD::Server::HTTPUtils

  # Serves an empty favicon.
  #
  # @raise [FinishRequest] finalizes an empty body if the path matches
  #   /favicon.ico so browsers don't complain.
  # @return [Boolean]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/static_file_helpers.rb#14
  def favicon?; end

  # Attempts to route a path to a static template file.
  #
  # @raise [FinishRequest] if a file was found and served
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/static_file_helpers.rb#26
  def static_template_file?; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/commands/static_file_helpers.rb#42
  def find_file(adapter, url); end

  class << self
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/commands/static_file_helpers.rb#42
    def find_file(adapter, url); end
  end
end

# A module that is mixed into {Templates::Template} in order to customize
# certain template methods.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/doc_server_helper.rb#6
module YARD::Server::DocServerHelper
  # @param path_components [Array<String>] components of a URL
  # @return [String] the absolute path from any mounted base URI.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#61
  def abs_url(*path_components); end

  # @example The base path for a library 'foo'
  #   base_path('docs') # => 'docs/foo'
  # @param path [String] the path prefix for a base path URI
  # @return [String] the base URI for a library with an extra +path+ prefix
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#69
  def base_path(path); end

  # @return [String] a timestamp for a given file
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#78
  def mtime(file); end

  # @return [String] a URL for a file with a timestamp
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#84
  def mtime_url(file); end

  # @return [Router] convenience method for accessing the router
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#75
  def router; end

  # Modifies {Templates::Helpers::HtmlHelper#url_for} to return a URL instead
  # of a disk location.
  #
  # @param obj [String, CodeObjects::Base] the object (or object path) to link to
  # @param anchor [String] the anchor to link to
  # @param relative [Boolean] use a relative or absolute link
  # @return [String] the URL location of the object
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#11
  def url_for(obj, anchor = T.unsafe(nil), relative = T.unsafe(nil)); end

  # Modifies {Templates::Helpers::HtmlHelper#url_for_file} to return a URL instead
  # of a disk location.
  #
  # @param filename [String, CodeObjects::ExtraFileObject] the filename to link to
  # @param anchor [String] optional anchor
  # @return [String] the URL pointing to the file
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#24
  def url_for_file(filename, anchor = T.unsafe(nil)); end

  # Returns the frames URL for the page
  #
  # @return [String] the URL pointing to the frames page
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#43
  def url_for_frameset; end

  # Returns the URL for the alphabetic index page
  #
  # @return [String] the URL pointing to the first main page the
  #   user should see.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#55
  def url_for_index; end

  # Modifies {Templates::Helpers::HtmlHelper#url_for_list} to return a URL
  # based on the list prefix instead of a HTML filename.
  #
  # @param type [String, Symbol] the list type to generate a URL for
  # @return [String] the URL pointing to the list
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#37
  def url_for_list(type); end

  # Returns the main URL, first checking a readme and then linking to the index
  #
  # @return [String] the URL pointing to the first main page the
  #   user should see.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_helper.rb#49
  def url_for_main; end
end

# A custom {Serializers::Base serializer} which returns resource URLs instead of
# static relative paths to files on disk.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/doc_server_serializer.rb#6
class YARD::Server::DocServerSerializer < ::YARD::Serializers::FileSystemSerializer
  # @return [DocServerSerializer] a new instance of DocServerSerializer
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_serializer.rb#7
  def initialize(_command = T.unsafe(nil)); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_serializer.rb#11
  def serialized_path(object); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/doc_server_serializer.rb#31
  def urlencode(name); end
end

# Short circuits a request by raising an error. This exception is caught
# by {Commands::Base#call} to immediately end a request and return a response.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/adapter.rb#6
class YARD::Server::FinishRequest < ::RuntimeError; end

# HTTPUtils provides utility methods for working with the HTTP protocol.
#
# This module is generally used internally by WEBrick
#
# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#25
module YARD::Server::HTTPUtils
  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#443
  def _escape(str, regex); end

  # :stopdoc:
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#441
  def _make_regex(str); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#442
  def _make_regex!(str); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#449
  def _unescape(str, regex); end

  # Removes quotes and escapes from +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#223
  def dequote(str); end

  # Escapes HTTP reserved and unwise characters in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#467
  def escape(str); end

  # Escapes 8 bit characters in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#508
  def escape8bit(str); end

  # Escapes form reserved characters in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#481
  def escape_form(str); end

  # Escapes path +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#497
  def escape_path(str); end

  # Loads Apache-compatible mime.types in +file+.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#112
  def load_mime_types(file); end

  # Returns the mime type of +filename+ from the list in +mime_tab+.  If no
  # mime type was found application/octet-stream is returned.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#134
  def mime_type(filename, mime_tab); end

  # Normalizes a request path.  Raises an exception if the path cannot be
  # normalized.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#31
  def normalize_path(path); end

  # Parses form data in +io+ with the given +boundary+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#395
  def parse_form_data(io, boundary); end

  # Parses an HTTP header +raw+ into a hash of header fields with an Array
  # of values.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#145
  def parse_header(raw); end

  # Parses the query component of a URI in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#371
  def parse_query(str); end

  # Parses q values in +value+ as used in Accept headers.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#202
  def parse_qvalues(value); end

  # Parses a Range header value +ranges_specifier+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#184
  def parse_range_header(ranges_specifier); end

  # Quotes and escapes quotes in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#233
  def quote(str); end

  # Splits a header value +str+ according to HTTP specification.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#175
  def split_header_value(str); end

  # Unescapes HTTP reserved and unwise characters in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#474
  def unescape(str); end

  # Unescapes form reserved characters in +str+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#490
  def unescape_form(str); end

  class << self
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#443
    def _escape(str, regex); end

    # :stopdoc:
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#441
    def _make_regex(str); end

    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#442
    def _make_regex!(str); end

    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#449
    def _unescape(str, regex); end

    # Removes quotes and escapes from +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#223
    def dequote(str); end

    # Escapes HTTP reserved and unwise characters in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#467
    def escape(str); end

    # Escapes 8 bit characters in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#508
    def escape8bit(str); end

    # Escapes form reserved characters in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#481
    def escape_form(str); end

    # Escapes path +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#497
    def escape_path(str); end

    # Loads Apache-compatible mime.types in +file+.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#112
    def load_mime_types(file); end

    # Returns the mime type of +filename+ from the list in +mime_tab+.  If no
    # mime type was found application/octet-stream is returned.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#134
    def mime_type(filename, mime_tab); end

    # Normalizes a request path.  Raises an exception if the path cannot be
    # normalized.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#31
    def normalize_path(path); end

    # Parses form data in +io+ with the given +boundary+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#395
    def parse_form_data(io, boundary); end

    # Parses an HTTP header +raw+ into a hash of header fields with an Array
    # of values.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#145
    def parse_header(raw); end

    # Parses the query component of a URI in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#371
    def parse_query(str); end

    # Parses q values in +value+ as used in Accept headers.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#202
    def parse_qvalues(value); end

    # Parses a Range header value +ranges_specifier+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#184
    def parse_range_header(ranges_specifier); end

    # Quotes and escapes quotes in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#233
    def quote(str); end

    # Splits a header value +str+ according to HTTP specification.
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#175
    def split_header_value(str); end

    # Unescapes HTTP reserved and unwise characters in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#474
    def unescape(str); end

    # Unescapes form reserved characters in +str+
    #
    # @since 0.6.0
    #
    # source://yard//lib/yard/server/http_utils.rb#490
    def unescape_form(str); end
  end
end

# Default mime types
#
# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#47
YARD::Server::HTTPUtils::DefaultMimeTypes = T.let(T.unsafe(nil), Hash)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#459
YARD::Server::HTTPUtils::ESCAPED = T.let(T.unsafe(nil), Regexp)

# Stores multipart form data.  FormData objects are created when
# WEBrick::HTTPUtils.parse_form_data is called.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#242
class YARD::Server::HTTPUtils::FormData < ::String
  # Creates a new FormData object.
  #
  # +args+ is an Array of form data entries.  One FormData will be created
  # for each entry.
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you
  #
  # @return [FormData] a new instance of FormData
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#267
  def initialize(*args); end

  # Adds +str+ to this FormData which may be the body, a header or a
  # header entry.
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#300
  def <<(str); end

  # Retrieves the header at the first entry in +key+
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#286
  def [](*key); end

  # Adds +data+ at the end of the chain of entries
  #
  # This is called by WEBrick::HTTPUtils.parse_form_data for you.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#320
  def append_data(data); end

  # Yields each entry in this FormData
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#335
  def each_data; end

  # The filename of the form data part
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#254
  def filename; end

  # The filename of the form data part
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#254
  def filename=(_arg0); end

  # Returns all the FormData as an Array
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#347
  def list; end

  # The name of the form data part
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#249
  def name; end

  # The name of the form data part
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#249
  def name=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#256
  def next_data=(_arg0); end

  # Returns all the FormData as an Array
  # A FormData will behave like an Array
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#347
  def to_ary; end

  # This FormData's body
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#363
  def to_s; end

  protected

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/http_utils.rb#256
  def next_data; end
end

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#244
YARD::Server::HTTPUtils::FormData::EmptyHeader = T.let(T.unsafe(nil), Hash)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#243
YARD::Server::HTTPUtils::FormData::EmptyRawHeader = T.let(T.unsafe(nil), Array)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#458
YARD::Server::HTTPUtils::NONASCII = T.let(T.unsafe(nil), Regexp)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#456
YARD::Server::HTTPUtils::UNESCAPED = T.let(T.unsafe(nil), Regexp)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#457
YARD::Server::HTTPUtils::UNESCAPED_FORM = T.let(T.unsafe(nil), Regexp)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#460
YARD::Server::HTTPUtils::UNESCAPED_PCHAR = T.let(T.unsafe(nil), Regexp)

# @since 0.6.0
#
# source://yard//lib/yard/server/http_utils.rb#17
YARD::Server::LF = T.let(T.unsafe(nil), String)

# This exception is raised when {LibraryVersion#prepare!} fails, or discovers
# that the library is not "prepared" to be served by
#
# @since 0.6.0
#
# source://yard//lib/yard/server/library_version.rb#9
class YARD::Server::LibraryNotPreparedError < ::RuntimeError; end

# A library version encapsulates a library's documentation at a specific version.
# Although the version is optional, this allows for creating multiple documentation
# points for a specific library, each representing a unique version. The term
# "library" used in other parts of the YARD::Server documentation refers to
# objects of this class unless otherwise noted.
#
# A library points to a location where a {#yardoc_file} is located so that
# its documentation may be loaded and served. Optionally, a {#source_path} is
# given to point to a location where any extra files (and {YARD::CLI::Yardoc .yardopts})
# should be loaded from. Both of these methods may not be known immediately,
# since the yardoc file may not be built until later. Resolving the yardoc
# file and source path are dependent on the specific library "source type" used.
# Source types (known as "library source") are discussed in detail below.
#
# == Using with Adapters
# A list of libraries need to be passed into adapters upon creation. In
# most cases, you will never do this manually, but if you use a {RackMiddleware},
# you will need to pass in this list yourself. To build this list of libraries,
# you should create a hash of library names mapped to an *Array* of LibraryVersion
# objects. For example:
#
#   {'mylib' => [LibraryVersion.new('mylib', '1.0', ...),
#                LibraryVersion.new('mylib', '2.0', ...)]}
#
# Note that you can also use {Adapter#add_library} for convenience.
#
# The "array" part is required, even for just one library version.
#
# == Library Sources
# The {#source} method represents the library source type, ie. where the
# library "comes from". It might come from "disk", or it might come from a
# "gem" (technically the disk, but a separate type nonetheless). In these
# two cases, the yardoc file sits somewhere on your filesystem, though
# it may also be built dynamically if it does not yet exist. This behaviour
# is controlled through the {#prepare!} method, which prepares the yardoc file
# given a specific library source. We will see how this works in detail in
# the following section.
#
# == Implementing a Custom Library Source
# YARD can be extended to support custom library sources in order to
# build or retrieve a yardoc file at runtime from many different locations.
#
# To implement this behaviour, 3 methods can be added to the +LibraryVersion+
# class, +#load_yardoc_from_SOURCE+, +#yardoc_file_for_SOURCE+, and
# +#source_path_for_SOURCE+. In all cases, "SOURCE" represents the source
# type used in {#source} when creating the library object. The
# +#yardoc_file_for_SOURCE+ and +#source_path_for_SOURCE+ methods are called upon
# creation and should return the location where the source code for the library
# lives. The load method is called from {#prepare!} if there is no yardoc file
# and should set {#yardoc_file}. Below is a full example for
# implementing a custom library source, +:http+, which reads packaged .yardoc
# databases from zipped archives off of an HTTP server.
#
# Note that only +#load_yardoc_from_SOURCE+ is required. The other two
# methods are optional and can be set manually (via {#source_path=} and
# {#yardoc_file=}) on the object at any time.
#
# @example Implementing a Custom Library Source
#   # Adds the source type "http" for .yardoc files zipped on HTTP servers
#   class LibraryVersion
#   def load_yardoc_from_http
#   Thread.new do
#   # zip/unzip method implementations are not shown
#   download_zip_file("http://mysite.com/yardocs/#{self}.zip")
#   unzip_file_to("/path/to/yardocs/#{self}")
#   end
#
#   # tell the server it's not ready yet (but it might be next time)
#   raise LibraryNotPreparedError
#   end
#
#   def yardoc_file_for_http
#   "/path/to/yardocs/#{self}/.yardoc"
#   end
#
#   def source_path_for_http
#   File.dirname(yardoc_file)
#   end
#   end
#
#   # Creating a library of this source type:
#   LibraryVersion.new('name', '1.0', nil, :http)
# @since 0.6.0
#
# source://yard//lib/yard/server/library_version.rb#94
class YARD::Server::LibraryVersion
  # @param name [String] the name of the library
  # @param version [String] the specific (usually, but not always, numeric) library
  #   version
  # @param yardoc [String] the location of the yardoc file, or nil if it is
  #   generated later
  # @param source [Symbol] the location of the files used to build the yardoc.
  #   Builtin source types are +:disk+ or +:gem+.
  # @return [LibraryVersion] a new instance of LibraryVersion
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#134
  def initialize(name, version = T.unsafe(nil), yardoc = T.unsafe(nil), source = T.unsafe(nil)); end

  # @return [Boolean] whether another LibraryVersion is equal to this one
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#153
  def ==(other); end

  # @return [Boolean] whether another LibraryVersion is equal to this one
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#153
  def eql?(other); end

  # @return [Boolean] whether another LibraryVersion is equal to this one
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#153
  def equal?(other); end

  # @return [Gem::Specification] a gemspec object for a given library. Used
  #   for :gem source types.
  # @return [nil] if there is no installed gem for the library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#191
  def gemspec; end

  # @return [Fixnum] used for Hash mapping.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#150
  def hash; end

  # @return [String] the name of the library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#96
  def name; end

  # @return [String] the name of the library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#96
  def name=(_arg0); end

  # Prepares a library to be displayed by the server. This callback is
  # performed before each request on a library to ensure that it is loaded
  # and ready to be viewed. If any steps need to be performed prior to loading,
  # they are performed through this method (though they should be implemented
  # through the +load_yardoc_from_SOURCE+ method).
  #
  # @note You should not directly override this method. Instead, implement
  #   +load_yardoc_from_SOURCENAME+ when implementing loading for a specific
  #   source type. See the {LibraryVersion} documentation for "Implementing
  #   a Custom Library Source"
  # @raise [LibraryNotPreparedError] if the library is not ready to be
  #   displayed. Usually when raising this error, you would simultaneously
  #   begin preparing the library for subsequent requests, although this
  #   is not necessary.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#182
  def prepare!; end

  # @return [Boolean] whether the library has been completely processed
  #   and is ready to be served
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#162
  def ready?; end

  # @return [Symbol] the source type representing where the yardoc should be
  #   loaded from. Defaults are +:disk+ and +:gem+, though custom sources
  #   may be implemented. This value is used to inform {#prepare!} about how
  #   to load the necessary data in order to display documentation for an object.
  # @see LibraryVersion LibraryVersion documentation for "Implementing a Custom Library Source"
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#116
  def source; end

  # @return [Symbol] the source type representing where the yardoc should be
  #   loaded from. Defaults are +:disk+ and +:gem+, though custom sources
  #   may be implemented. This value is used to inform {#prepare!} about how
  #   to load the necessary data in order to display documentation for an object.
  # @see LibraryVersion LibraryVersion documentation for "Implementing a Custom Library Source"
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#116
  def source=(_arg0); end

  # @return [String] the location of the source code for a library. This
  #   value is filled by calling +#source_path_for_SOURCE+ on this class.
  # @return [nil] if there is no source code
  # @see LibraryVersion LibraryVersion documentation for "Implementing a Custom Library Source"
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#122
  def source_path; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#125
  def source_path=(_arg0); end

  # @param url_format [Boolean] if true, returns the string in a URI-compatible
  #   format (for appending to a URL). Otherwise, it is given in a more human
  #   readable format.
  # @return [String] the string representation of the library.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#145
  def to_s(url_format = T.unsafe(nil)); end

  # @return [String] the version of the specific library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#99
  def version; end

  # @return [String] the version of the specific library
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#99
  def version=(_arg0); end

  # @note To implement a custom yardoc file getter, implement
  # @return [String] the location of the yardoc file used to load the object
  #   information from.
  # @return [nil] if no yardoc file exists yet. In this case, {#prepare!} will
  #   be called on this library to build the yardoc file.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#106
  def yardoc_file; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#109
  def yardoc_file=(_arg0); end

  protected

  # Called when a library of source type "disk" is to be prepared. In this
  # case, the {#yardoc_file} should already be set, but the library may not
  # be prepared. Run preparation if not done.
  #
  # @raise [LibraryNotPreparedError] if the yardoc file has not been
  #   prepared.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#206
  def load_yardoc_from_disk; end

  # Called when a library of source type "gem" is to be prepared. In this
  # case, the {#yardoc_file} needs to point to the correct location for
  # the installed gem. The yardoc file is built if it has not been done.
  #
  # @raise [LibraryNotPreparedError] if the gem does not have an existing
  #   yardoc file.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#226
  def load_yardoc_from_gem; end

  # @return [String] the source path for a disk source
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#243
  def source_path_for_disk; end

  # @return [String] the source path for a gem source
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#248
  def source_path_for_gem; end

  # @return [String] the yardoc file for a gem source
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#253
  def yardoc_file_for_gem; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#261
  def load_source_path; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#266
  def load_yardoc_file; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/library_version.rb#271
  def serializer; end
end

# Raises an error if a resource is not found. This exception is caught by
# {Commands::Base#call} to immediately end a request and return a 404 response
# code. If a message is provided, the body is set to the exception message.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/adapter.rb#11
class YARD::Server::NotFoundError < ::RuntimeError; end

# A server adapter to respond to requests using the Rack server infrastructure.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/rack_adapter.rb#52
class YARD::Server::RackAdapter < ::YARD::Server::Adapter
  include ::YARD::Server::HTTPUtils

  # Responds to Rack requests and builds a response with the {Router}.
  #
  # @return [Array(Numeric,Hash,Array)] the Rack-style response
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/rack_adapter.rb#57
  def call(env); end

  # Starts the Rack server. This method will pass control to the server and
  # block.
  #
  # @return [void]
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/rack_adapter.rb#70
  def start; end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/rack_adapter.rb#79
  def print_start_message(server); end
end

# This class wraps the {RackAdapter} into a Rack-compatible middleware.
# See {#initialize} for a list of options to pass via Rack's +#use+ method.
#
# @example Using the RackMiddleware in a Rack application
#   libraries = {:mylib => [YARD::Server::LibraryVersion.new('mylib', nil, '/path/to/.yardoc')]}
#   use YARD::Server::RackMiddleware, :libraries => libraries
# @note You must pass a +:libraries+ option to the RackMiddleware via +#use+. To
#   read about how to return a list of libraries, see {LibraryVersion} or look
#   at the example below.
# @since 0.6.0
#
# source://yard//lib/yard/server/rack_adapter.rb#25
class YARD::Server::RackMiddleware
  # Creates a new Rack-based middleware for serving YARD documentation.
  #
  # @option opts
  # @option opts
  # @option opts
  # @param app the next Rack middleware in the stack
  # @param opts [Hash] a customizable set of options
  # @return [RackMiddleware] a new instance of RackMiddleware
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/rack_adapter.rb#35
  def initialize(app, opts = T.unsafe(nil)); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/rack_adapter.rb#41
  def call(env); end
end

# source://yard//lib/yard/server/rack_adapter.rb#8
YARD::Server::RackServer = Rackup::Server

# A router class implements the logic used to recognize a request for a specific
# URL and run specific {Commands::Base commands}.
#
# == Subclassing Notes
# To create a custom router, subclass this class and pass it into the adapter
# options through {Adapter#initialize} or by directly modifying {Adapter#router}.
#
# The most general customization is to change the URL prefixes recognized by
# routing, which can be done by overriding {#docs_prefix}, {#list_prefix},
# {#static_prefix}, and {#search_prefix}.
#
# == Implementing Custom Caching
# By default, the Router class performs static disk-based caching on all
# requests through the +#check_static_cache+. To override this behaviour,
# or create your own caching mechanism, mixin your own custom module with
# this method implemented as per {StaticCaching#check_static_cache}.
#
# @example Creating a subclassed router
#   # Adds 'my' to all routing prefixes
#   class MyRouter < YARD::Server::Router
#   def docs_prefix; 'mydocs' end
#   def list_prefix; 'mylist' end
#   def static_prefix; 'mystatic' end
#   def search_prefix; 'mysearch' end
#   end
#
#   # Using it:
#   WebrickAdapter.new(libraries, :router => MyRouter).start
# @since 0.6.0
#
# source://yard//lib/yard/server/router.rb#32
class YARD::Server::Router
  include ::YARD::Server::StaticCaching
  include ::YARD::Server::Commands

  # Creates a new router for a specific adapter
  #
  # @param adapter [Adapter] the adapter to route requests to
  # @return [Router] a new instance of Router
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#45
  def initialize(adapter); end

  # @return [Adapter] the adapter used by the router
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#40
  def adapter; end

  # @return [Adapter] the adapter used by the router
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#40
  def adapter=(_arg0); end

  # Perform routing on a specific request, serving the request as a static
  # file through {Commands::RootRequestCommand} if no route is found.
  #
  # @param request [Adapter Dependent] the request object
  # @return [Array(Numeric,Hash,Array)] the Rack-style server response data
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#54
  def call(request); end

  # @return [String] the URI prefix for all object documentation requests
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#63
  def docs_prefix; end

  # @return [String] the URI prefix for all class/method/file list requests
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#66
  def list_prefix; end

  # @return [Array(LibraryVersion, Array<String>)] the library followed
  #   by the rest of the path components in the request path. LibraryVersion
  #   will be nil if no matching library was found.
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#79
  def parse_library_from_path(paths); end

  # @return [Adapter Dependent] the request data coming in with the routing
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#37
  def request; end

  # @return [Adapter Dependent] the request data coming in with the routing
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#37
  def request=(_arg0); end

  # @return [String] the URI prefix for all search requests
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#69
  def search_prefix; end

  # @return [String] the URI prefix for all static assets (templates)
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#72
  def static_prefix; end

  protected

  # Adds extra :library/:path option keys to the adapter options.
  # Use this method when passing options to a command.
  #
  # @param library [LibraryVersion] the library to route for
  # @param paths [Array<String>] path components (split by '/')
  # @return [Hash] finalized options
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#181
  def final_options(library, paths); end

  # Performs routing algorithm to find which prefix is called, first
  # parsing out library name/version information.
  #
  # @return [Array(Numeric,Hash,Array<String>)] the Rack-style response
  # @return [nil] if no route is matched
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#105
  def route(path = T.unsafe(nil)); end

  # Routes requests from {#docs_prefix} and calls the appropriate command
  #
  # @param library [LibraryVersion] the library to route for
  # @param paths [Array<String>] path components (split by '/')
  # @return [Array(Numeric,Hash,Array<String>)] the Rack-style response
  # @return [nil] if no route is matched
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#128
  def route_docs(library, paths); end

  # Routes for the index of a library / multiple libraries
  #
  # @return [Array(Numeric,Hash,Array<String>)] the Rack-style response
  # @return [nil] if no route is matched
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#146
  def route_index; end

  # Routes requests from {#list_prefix} and calls the appropriate command
  #
  # @param library [LibraryVersion] the library to route for
  # @param paths [Array<String>] path components (split by '/')
  # @return [Array(Numeric,Hash,Array<String>)] the Rack-style response
  # @return [nil] if no route is matched
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#157
  def route_list(library, paths); end

  # Routes requests from {#search_prefix} and calls the appropriate command
  #
  # @param library [LibraryVersion] the library to route for
  # @param paths [Array<String>] path components (split by '/')
  # @return [Array(Numeric,Hash,Array<String>)] the Rack-style response
  # @return [nil] if no route is matched
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#165
  def route_search(library, paths); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/router.rb#170
  def route_static(library, paths); end
end

# Implements static caching for requests.
#
# @see Router Router documentation for "Caching"
# @since 0.6.0
#
# source://yard//lib/yard/server/static_caching.rb#7
module YARD::Server::StaticCaching
  # Called by a router to return the cached object. By default, this
  # method performs disk-based caching. To perform other forms of caching,
  # implement your own +#check_static_cache+ method and mix the module into
  # the Router class.
  #
  # Note that caching does not occur here. This method simply checks for
  # the existence of cached data. To actually cache a response, see
  # {Commands::Base#cache}.
  #
  # @example Implementing In-Memory Cache Checking
  #   module MemoryCaching
  #   def check_static_cache
  #   # $memory_cache is filled by {Commands::Base#cache}
  #   cached_data = $memory_cache[request.path]
  #   if cached_data
  #   [200, {'Content-Type' => 'text/html'}, [cached_data]]
  #   else
  #   nil
  #   end
  #   end
  #   end
  #
  #   class YARD::Server::Router; include MemoryCaching; end
  # @return [Array(Numeric,Hash,Array)] the Rack-style response
  # @return [nil] if no cache is available and routing should continue
  # @see Commands::Base#cache
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/static_caching.rb#34
  def check_static_cache; end
end

# The main adapter to initialize a WEBrick server.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/webrick_adapter.rb#7
class YARD::Server::WebrickAdapter < ::YARD::Server::Adapter
  # Initializes a WEBrick server. If {Adapter#server_options} contains a
  # +:daemonize+ key set to true, the server will be daemonized.
  #
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#10
  def start; end
end

# The main WEBrick servlet implementation, accepting only GET requests.
#
# @since 0.6.0
#
# source://yard//lib/yard/server/webrick_adapter.rb#20
class YARD::Server::WebrickServlet < ::WEBrick::HTTPServlet::AbstractServlet
  # @return [WebrickServlet] a new instance of WebrickServlet
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#23
  def initialize(server, adapter); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#21
  def adapter; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#21
  def adapter=(_arg0); end

  # @private
  # @since 0.6.0
  #
  # source://yard//lib/yard/server/webrick_adapter.rb#29
  def do_GET(request, response); end
end

# Stubs marshal dumps and acts a delegate class for an object by path
#
# @private
#
# source://yard//lib/yard/serializers/yardoc_serializer.rb#6
class YARD::StubProxy
  # @return [StubProxy] a new instance of StubProxy
  #
  # source://yard//lib/yard/serializers/yardoc_serializer.rb#13
  def initialize(path, transient = T.unsafe(nil)); end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#9
  def _dump(_depth); end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#11
  def hash; end

  # source://yard//lib/yard/serializers/yardoc_serializer.rb#18
  def method_missing(meth, *args, &block); end

  class << self
    # source://yard//lib/yard/serializers/yardoc_serializer.rb#10
    def _load(str); end
  end
end

# source://yard//lib/yard/serializers/yardoc_serializer.rb#28
YARD::StubProxy::FILELEN = T.let(T.unsafe(nil), Integer)

# The root path for YARD builtin templates
#
# source://yard//lib/yard.rb#10
YARD::TEMPLATE_ROOT = T.let(T.unsafe(nil), String)

# Namespace for Tag components
#
# source://yard//lib/yard/autoload.rb#248
module YARD::Tags; end

# Defines an attribute with a given name, using indented block data as the
# attribute's docstring. If the type specifier is supplied with "r", "w", or
# "rw", the attribute is made readonly, writeonly or readwrite respectively.
# A readwrite attribute is the default, if no type is specified. The comment
# containing this directive does not need to be attached to any source, but
# if it is, that source code will be used as the method's source.
#
# To define a regular method, see {tag:!method}
#
# @example Defining a simple readonly attribute
#   # @!attribute [r] count
#   #   @return [Fixnum] the size of the list
# @example Defining a simple readwrite attribute
#   # @!attribute name
#   #   @return [String] the name of the user
# @note This directive should only be used if there is no explicit +attr_*+
#   declaration for the attribute in any source files (i.e., the attribute
#   is declared dynamically via meta-programming). In all other cases, add
#   documentation to the attribute declaration itself.
# @note For backwards compatibility support, you do not need to indent
#   the attribute's docstring text. If an +@!attribute+ directive is seen with
#   no indented block, the entire docstring is used as the new attribute's
#   docstring text.
# @see tag:!method
# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#460
class YARD::Tags::AttributeDirective < ::YARD::Tags::MethodDirective
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#461
  def after_parse; end

  protected

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#469
  def method_name; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#475
  def method_signature; end

  private

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#485
  def create_attribute_data(object); end

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#515
  def readable?; end

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#511
  def writable?; end
end

# source://yard//lib/yard/tags/default_factory.rb#4
class YARD::Tags::DefaultFactory
  # Parses tag text and creates a new tag with descriptive text
  #
  # @param tag_name the name of the tag to parse
  # @param text [String] the raw tag text
  # @return [Tag] a tag object with the tag_name and text values filled
  #
  # source://yard//lib/yard/tags/default_factory.rb#13
  def parse_tag(tag_name, text); end

  # Parses tag text and creates a new tag with a key name and descriptive text
  #
  # @param tag_name the name of the tag to parse
  # @param text [String] the raw tag text
  # @return [Tag] a tag object with the tag_name, name and text values filled
  #
  # source://yard//lib/yard/tags/default_factory.rb#22
  def parse_tag_with_name(tag_name, text); end

  # source://yard//lib/yard/tags/default_factory.rb#89
  def parse_tag_with_options(tag_name, text); end

  # source://yard//lib/yard/tags/default_factory.rb#70
  def parse_tag_with_title_and_text(tag_name, text); end

  # Parses tag text and creates a new tag with formally declared types and
  # descriptive text
  #
  # @param tag_name the name of the tag to parse
  # @param text [String] the raw tag text
  # @raise [TagFormatError]
  # @return [Tag] a tag object with the tag_name, types and text values filled
  #
  # source://yard//lib/yard/tags/default_factory.rb#33
  def parse_tag_with_types(tag_name, text); end

  # Parses tag text and creates a new tag with formally declared types, a key
  # name and descriptive text
  #
  # @param tag_name the name of the tag to parse
  # @param text [String] the raw tag text
  # @return [Tag] a tag object with the tag_name, name, types and text values filled
  #
  # source://yard//lib/yard/tags/default_factory.rb#45
  def parse_tag_with_types_and_name(tag_name, text); end

  # Parses tag text and creates a new tag with formally declared types, a title
  # on the first line and descriptive text
  #
  # @param tag_name the name of the tag to parse
  # @param text [String] the raw tag text
  # @return [Tag] a tag object with the tag_name, name, types and text values filled
  #
  # source://yard//lib/yard/tags/default_factory.rb#57
  def parse_tag_with_types_and_title(tag_name, text); end

  # source://yard//lib/yard/tags/default_factory.rb#75
  def parse_tag_with_types_name_and_default(tag_name, text); end

  private

  # Extracts the name from raw tag text returning the name and remaining value
  #
  # @param text [String] the raw tag text
  # @return [Array] an array holding the name as the first element and the
  #   value as the second element
  #
  # source://yard//lib/yard/tags/default_factory.rb#101
  def extract_name_from_text(text); end

  # @raise [TagFormatError]
  #
  # source://yard//lib/yard/tags/default_factory.rb#105
  def extract_title_and_desc_from_text(text); end

  # Parses a [], <>, {} or () block at the beginning of a line of text
  # into a list of comma delimited values.
  #
  # @example
  #   obj.parse_types('[String, Array<Hash, String>, nil]') # => [nil, ['String', 'Array<Hash, String>', 'nil'], ""]
  #   obj.parse_types('b<String> A string') # => ['b', ['String'], 'A string']
  # @return [Array(String, Array<String>, String)] the text before the type
  #   list (or nil), followed by the type list parsed into an array of
  #   strings, followed by the text following the type list.
  #
  # source://yard//lib/yard/tags/default_factory.rb#129
  def extract_types_and_name_from_text(text, opening_types = T.unsafe(nil), closing_types = T.unsafe(nil)); end

  # source://yard//lib/yard/tags/default_factory.rb#138
  def extract_types_and_name_from_text_unstripped(text, opening_types = T.unsafe(nil), closing_types = T.unsafe(nil)); end
end

# source://yard//lib/yard/tags/default_factory.rb#6
YARD::Tags::DefaultFactory::TYPELIST_CLOSING_CHARS = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/tags/default_factory.rb#5
YARD::Tags::DefaultFactory::TYPELIST_OPENING_CHARS = T.let(T.unsafe(nil), String)

# source://yard//lib/yard/tags/default_tag.rb#4
class YARD::Tags::DefaultTag < ::YARD::Tags::Tag
  # @return [DefaultTag] a new instance of DefaultTag
  #
  # source://yard//lib/yard/tags/default_tag.rb#7
  def initialize(tag_name, text, types = T.unsafe(nil), name = T.unsafe(nil), defaults = T.unsafe(nil)); end

  # Returns the value of attribute defaults.
  #
  # source://yard//lib/yard/tags/default_tag.rb#5
  def defaults; end
end

# The base directive class. Subclass this class to create a custom
# directive, registering it with {Library.define_directive}. Directive
# classes are executed via the {#call} method, which perform all directive
# processing on the object.
#
# If processing occurs within a handler, the {#handler} attribute is
# available to access more information about parsing context and state.
# Handlers are only available when parsing from {Parser::SourceParser},
# not when parsing directly from {DocstringParser}. If the docstring is
# attached to an object declaration, {#object} will be set and available
# to modify the generated code object directly. Note that both of these
# attributes may be nil, and directives should test their existence
# before attempting to use them.
#
# @abstract Subclasses should implement {#call}.
# @see Library.define_directive
# @since 0.8.0
#
# source://yard//lib/yard/tags/directives.rb#22
class YARD::Tags::Directive
  # @param tag [Tag] the meta-data tag containing all input to the docstring
  # @param parser [DocstringParser] the docstring parser object
  # @return [Directive] a new instance of Directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#54
  def initialize(tag, parser); end

  # Called after parsing all directives and tags in the docstring. Used
  # to perform any cleanup after all directives perform their main task.
  #
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#73
  def after_parse; end

  # Called when processing the directive. Subclasses should implement
  # this method to perform all functionality of the directive.
  #
  # @abstract implement this method to perform all data processing for
  #   the directive.
  # @raise [NotImplementedError]
  # @return [void]
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#68
  def call; end

  # Set this field to replace the directive definition inside of a docstring
  # with arbitrary text. For instance, the {MacroDirective} uses this field
  # to expand its macro data in place of the call to a +@!macro+.
  #
  # @return [String] the text to expand in the original docstring in place
  #   of this directive definition.
  # @return [nil] if no expansion should take place for this directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#33
  def expanded_text; end

  # Set this field to replace the directive definition inside of a docstring
  # with arbitrary text. For instance, the {MacroDirective} uses this field
  # to expand its macro data in place of the call to a +@!macro+.
  #
  # @return [String] the text to expand in the original docstring in place
  #   of this directive definition.
  # @return [nil] if no expansion should take place for this directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#33
  def expanded_text=(_arg0); end

  # @return [Handlers::Base, nil] the handler object the docstring parser
  #   might be attached to. May be nil. Only available when parsing
  #   through {Parser::SourceParser}.
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#48
  def handler; end

  # @return [CodeObjects::Base, nil] the object the parent docstring is
  #   attached to. May be nil.
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#42
  def object; end

  # @return [DocstringParser] the parser that is parsing all tag
  #   information out of the docstring
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#37
  def parser=(_arg0); end

  # @return [Tag] the meta-data tag containing data input to the directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#24
  def tag; end

  # @return [Tag] the meta-data tag containing data input to the directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#24
  def tag=(_arg0); end

  protected

  # @return [Boolean]
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#79
  def inside_directive?; end

  # @return [DocstringParser] the parser that is parsing all tag
  #   information out of the docstring
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#37
  def parser; end
end

# Ends a group listing definition. Group definition automatically end
# when class or module blocks are closed, and defining a new group overrides
# the last group definition, but occasionally you need to end the current
# group to return to the default listing. Use {tag:!group} to begin a
# group listing.
#
# @example
#   class Controller
#   # @!group Callbacks
#
#   def before_filter; end
#   def after_filter; end
#
#   # @!endgroup
#
#   def index; end
#   end
# @see tag:!group
# @since 0.6.0
#
# source://yard//lib/yard/tags/directives.rb#104
class YARD::Tags::EndGroupDirective < ::YARD::Tags::Directive
  # @since 0.6.0
  #
  # source://yard//lib/yard/tags/directives.rb#105
  def call; end
end

# Defines a group listing. All methods (and attributes) seen after this
# directive are placed into a group with the given description as the
# group name. The group listing is used by templates to organize methods
# and attributes into respective logical groups. To end a group listing
# use {tag:!endgroup}.
#
# @example
#   # @!group Callbacks
#
#   def before_filter; end
#   def after_filter; end
# @note A group definition only applies to the scope it is defined in.
#   If a new class or module is opened after the directive, this directive
#   will not apply to methods in that class or module.
# @see tag:!endgroup
# @since 0.6.0
#
# source://yard//lib/yard/tags/directives.rb#127
class YARD::Tags::GroupDirective < ::YARD::Tags::Directive
  # @since 0.6.0
  #
  # source://yard//lib/yard/tags/directives.rb#128
  def call; end
end

# Keeps track of all the registered meta-data tags and directives.
# Also allows for defining of custom tags and customizing the tag parsing
# syntax.
#
# == Defining Custom Meta-Data Tags
#
# To define a custom tag, use {define_tag}. You should pass the tag
# name and the factory method to use when creating the tag. If you do not
# provide a factory method to use, it will default to {DefaultFactory#parse_tag}
#
# You can also define tag objects manually by simply implementing a "tagname_tag"
# method that returns a {Tag} object, but they will not take advantage of tag factory
# parsing:
#
#   def mytag_tag(text)
#     Tag.new(:mytag, text)
#   end
#
# == Defining Custom Directives
#
# Directives can be defined by calling the {define_directive} method, taking
# the directive name, an optional tag factory parser method (to parse the
# data in the directive into a temporary {Tag} object) and a {Directive} subclass
# that performs the directive processing. For more information on creating a
# Directive subclass, see the {Directive} class documentation.
#
# Similar to tags, Directives can also be defined manually, in this case using
# the method name "mydirective_directive" and returning a new {Directive} object:
#
#   def mydirective_directive(tag, parser)
#     MyDirective.new(tag, parser)
#   end
#
# == Namespaced Tags
#
# In YARD 0.8.0+, tags can be namespaced using the '.' character. It is recommended
# to namespace project specific tags, like +@yard.tag_name+, so that tags do not
# collide with other plugins or new built-in tags.
#
# == Adding/Changing the Tag Syntax
#
# If you have specialized tag parsing needs you can substitute the {#factory}
# object with your own by setting {Library.default_factory= Library.default_factory}
# to a new class with its own parsing methods before running YARD. This is useful
# if you want to change the syntax of existing tags (@see, @since, etc.)
#
# @example Defining a custom tag
#   define_tag "Parameter", :param, :with_types_and_name
#   define_tag "Author", :author
# @example Defining a custom directive
#   define_directive :method, :with_title_and_text, MethodDirective
# @see DefaultFactory
# @see define_tag
# @see define_directive
# @see Directive
#
# source://yard//lib/yard/tags/library.rb#59
class YARD::Tags::Library
  # @return [Library] a new instance of Library
  #
  # source://yard//lib/yard/tags/library.rb#260
  def initialize(factory = T.unsafe(nil)); end

  # Marks a class/module/method as abstract with optional
  # implementor information.
  #
  # @example
  #   # @abstract Subclass and override {#run} to implement
  #   #   a custom Threadable class.
  #   class Runnable
  #   def run; raise NotImplementedError end
  #   end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def abstract_tag(text); end

  # Declares the API that the object belongs to. Does not display in
  # output, but useful for performing queries (+yardoc --query+). Any text is
  # allowable in this tag, and there are no predefined values.
  #
  # @example
  #   class Post
  #   # @api private
  #   def reset_table!; table.flush end
  #   end
  # @note This tag is *transitive*. If it is applied on a
  #   namespace (module or class), it will immediately be
  #   applied to all children objects of that namespace unless
  #   it is redefined on the child object.
  # @note The special name +@api private+ does display a notice in
  #   documentation if it is listed, letting users know that the
  #   method is not to be used by external components.
  #
  # source://yard//lib/yard/tags/library.rb#168
  def api_tag(text); end

  # Declares a readonly attribute on a Struct or class.
  #
  # @deprecated Use the more powerful {tag:!attribute} directive instead.
  # @example
  #   # @attr_reader [String] name the name of the structure
  #   # @attr_reader [Fixnum] size the size of the structure
  #   class MyStruct < Struct; end
  # @note This attribute is only applicable on class docstrings
  #
  # source://yard//lib/yard/tags/library.rb#168
  def attr_reader_tag(text); end

  # Declares a readwrite attribute on a Struct or class.
  #
  # @deprecated Use the more powerful {tag:!attribute} directive instead.
  # @example
  #   # @attr [String] name the name of the structure
  #   # @attr [Fixnum] size the size of the structure
  #   class MyStruct < Struct; end
  # @note This attribute is only applicable on class docstrings
  #
  # source://yard//lib/yard/tags/library.rb#168
  def attr_tag(text); end

  # Declares a writeonly attribute on a Struct or class.
  #
  # @deprecated Use the more powerful {tag:!attribute} directive instead.
  # @example
  #   # @attr_reader [String] name the name of the structure
  #   # @attr_reader [Fixnum] size the size of the structure
  #   class MyStruct < Struct; end
  # @note This attribute is only applicable on class docstrings
  #
  # source://yard//lib/yard/tags/library.rb#168
  def attr_writer_tag(text); end

  # source://yard//lib/yard/tags/library.rb#202
  def attribute_directive(tag, parser); end

  # List the author or authors of a class, module, or method.
  #
  # @example
  #   # @author Foo Bar <foo@bar.com>
  #   class MyClass; end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def author_tag(text); end

  # Marks a method/class as deprecated with an optional description.
  # The description should be used to inform users of the recommended
  # migration path, and/or any useful information about why the object
  # was marked as deprecated.
  #
  # @example Deprecate a method with a replacement API
  #   # @deprecated Use {#bar} instead.
  #   def foo; end
  # @example Deprecate a method with no replacement
  #   class Thread
  #   # @deprecated Exiting a thread in this way is not reliable and
  #   #   can cause a program crash.
  #   def kill; end
  #   end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def deprecated_tag(text); end

  # Creates a new directive with tag information and a docstring parser
  # object.
  #
  # @param tag_name [String] the name of the tag
  # @param tag_buf [String] the tag data
  # @param parser [DocstringParser] the parser object parsing the docstring
  # @return [Directive] the newly created directive
  #
  # source://yard//lib/yard/tags/library.rb#290
  def directive_create(tag_name, tag_buf, parser); end

  # source://yard//lib/yard/tags/library.rb#202
  def endgroup_directive(tag, parser); end

  # Show an example snippet of code for an object. The first line
  # is an optional title.
  #
  # @example
  #   # @example Reverse a String
  #   #   "mystring".reverse #=> "gnirtsym"
  #   def reverse; end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def example_tag(text); end

  # A factory class to handle parsing of tags, defaults to {default_factory}
  #
  # source://yard//lib/yard/tags/library.rb#258
  def factory; end

  # A factory class to handle parsing of tags, defaults to {default_factory}
  #
  # source://yard//lib/yard/tags/library.rb#258
  def factory=(_arg0); end

  # source://yard//lib/yard/tags/library.rb#202
  def group_directive(tag, parser); end

  # @param tag_name [#to_s] the name of the tag to look for
  # @return [Boolean] whether a directive by the given name is registered in
  #   the library.
  #
  # source://yard//lib/yard/tags/library.rb#280
  def has_directive?(tag_name); end

  # @param tag_name [#to_s] the name of the tag to look for
  # @return [Boolean] whether a tag by the given name is registered in
  #   the library.
  #
  # source://yard//lib/yard/tags/library.rb#267
  def has_tag?(tag_name); end

  # source://yard//lib/yard/tags/library.rb#202
  def macro_directive(tag, parser); end

  # source://yard//lib/yard/tags/library.rb#202
  def method_directive(tag, parser); end

  # Adds an emphasized note at the top of the docstring for the object
  #
  # @example
  #   # @note This method should only be used in outer space.
  #   def eject; end
  # @see tag:todo
  #
  # source://yard//lib/yard/tags/library.rb#168
  def note_tag(text); end

  # Describe an options hash in a method. The tag takes the
  # name of the options parameter first, followed by optional types,
  # the option key name, a default value for the key and a
  # description of the option. The default value should be placed within
  # parentheses and is optional (can be omitted).
  #
  # Note that a +@param+ tag need not be defined for the options
  # hash itself, though it is useful to do so for completeness.
  #
  # @example
  #   # @param [Hash] opts the options to create a message with.
  #   # @option opts [String] :subject The subject
  #   # @option opts [String] :from ('nobody') From address
  #   # @option opts [String] :to Recipient email
  #   # @option opts [String] :body ('') The email's body
  #   def send_email(opts = {}) end
  # @note For keyword parameters, use +@param+, not +@option+.
  #
  # source://yard//lib/yard/tags/library.rb#168
  def option_tag(text); end

  # Describe that your method can be used in various
  # contexts with various parameters or return types. The first
  # line should declare the new method signature, and the following
  # indented tag data will be a new documentation string with its
  # own tags adding metadata for such an overload.
  #
  # @example
  #   # @overload set(key, value)
  #   #   Sets a value on key
  #   #   @param key [Symbol] describe key param
  #   #   @param value [Object] describe value param
  #   # @overload set(value)
  #   #   Sets a value on the default key +:foo+
  #   #   @param value [Object] describe value param
  #   def set(*args) end
  #
  # source://yard//lib/yard/tags/library.rb#161
  def overload_tag(text); end

  # Documents a single method parameter (either regular or keyword) with a given name, type
  # and optional description.
  #
  # @example
  #   # @param url [String] the URL of the page to download
  #   # @param directory [String] the name of the directory to save to
  #   def load_page(url, directory: 'pages') end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def param_tag(text); end

  # source://yard//lib/yard/tags/library.rb#202
  def parse_directive(tag, parser); end

  # Declares that the _logical_ visibility of an object is private.
  # In other words, it specifies that this method should be marked
  # private but cannot due to Ruby's visibility restrictions. This
  # exists for classes, modules and constants that do not obey Ruby's
  # visibility rules. For instance, an inner class might be considered
  # "private", though Ruby would make no such distinction.
  #
  # This tag is meant to be used in conjunction with the +--no-private+
  # command-line option, and is required to actually remove these objects
  # from documentation output. See {file:README.md} for more information on
  # switches.
  #
  # If you simply want to set the API visibility of a method, you should
  # look at the {tag:api} tag instead.
  #
  # @example
  #   # @private
  #   class InteralImplementation; end
  # @note This method is not recommended for hiding undocumented or
  #   "unimportant" methods. This tag should only be used to mark objects
  #   private when Ruby visibility rules cannot do so. In Ruby 1.9.3, you
  #   can use +private_constant+ to declare constants (like classes or
  #   modules) as private, and should be used instead of +@private+.
  # @note This tag is *transitive*. If it is applied on a
  #   namespace (module or class), it will immediately be
  #   applied to all children objects of that namespace unless
  #   it is redefined on the child object.
  # @see tag:api
  #
  # source://yard//lib/yard/tags/library.rb#168
  def private_tag(text); end

  # Describes that a method may raise a given exception, with
  # an optional description of what it may mean.
  #
  # @example
  #   # @raise [AccountBalanceError] if the account does not have
  #   #   sufficient funds to perform the transaction
  #   def withdraw(amount) end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def raise_tag(text); end

  # Describes the return value (and type or types) of a method.
  # You can list multiple return tags for a method in the case
  # where a method has distinct return cases. In this case, each
  # case should begin with "if ...".
  #
  # @example A regular return value
  #   # @return [Fixnum] the size of the file
  #   def size; @file.size end
  # @example A method returns an Array or a single object
  #   # @return [String] if a single object was returned
  #   #   from the database.
  #   # @return [Array<String>] if multiple objects were
  #   #   returned.
  #   def find(query) end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def return_tag(text); end

  # Sets the scope of a DSL method. Only applicable to DSL method
  # calls. Acceptable values are 'class' or 'instance'
  #
  # source://yard//lib/yard/tags/library.rb#202
  def scope_directive(tag, parser); end

  # "See Also" references for an object. Accepts URLs or
  # other code objects with an optional description at the end.
  # Note that the URL or object will be automatically linked by
  # YARD and does not need to be formatted with markup.
  #
  # @example
  #   # Synchronizes system time using NTP.
  #   # @see http://ntp.org/documentation.html NTP Documentation
  #   # @see NTPHelperMethods
  #   class NTPUpdater; end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def see_tag(text); end

  # Lists the version that the object was first added.
  #
  # @example
  #   # @since 1.2.4
  #   def clear_routes; end
  # @note This tag is *transitive*. If it is applied on a
  #   namespace (module or class), it will immediately be
  #   applied to all children objects of that namespace unless
  #   it is redefined on the child object.
  #
  # source://yard//lib/yard/tags/library.rb#168
  def since_tag(text); end

  # Creates a new {Tag} object with a given tag name and data
  #
  # @return [Tag] the newly created tag object
  #
  # source://yard//lib/yard/tags/library.rb#273
  def tag_create(tag_name, tag_buf); end

  # Marks a TODO note in the object being documented.
  # For reference, objects with TODO items can be enumerated
  # from the command line with a simple command:
  #
  #   !!!sh
  #   mocker$ yard list --query '@todo'
  #   lib/mocker/mocker.rb:15: Mocker
  #   lib/mocker/report/html.rb:5: Mocker::Report::Html
  #
  # YARD can also be used to enumerate the TODO items from
  # a short script:
  #
  #   !!!ruby
  #   require 'yard'
  #   YARD::Registry.load!.all.each do |o|
  #     puts o.tag(:todo).text if o.tag(:todo)
  #   end
  #
  # @example
  #   # @todo Add support for Jabberwocky service.
  #   #   There is an open source Jabberwocky library available
  #   #   at http://jbrwcky.org that can be easily integrated.
  #   class Wonderlander; end
  # @see tag:note
  #
  # source://yard//lib/yard/tags/library.rb#168
  def todo_tag(text); end

  # Lists the version of a class, module or method. This is
  # similar to a library version, but at finer granularity.
  # In some cases, version of specific modules, classes, methods
  # or generalized components might change independently between
  # releases. A version tag is used to infer the API compatibility
  # of a specific object.
  #
  # @example
  #   # The public REST API for http://jbrwcky.org
  #   # @version 2.0
  #   class JabberwockyAPI; end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def version_tag(text); end

  # Sets the visibility of a DSL method. Only applicable to
  # DSL method calls. Acceptable values are public, protected, or private.
  #
  # source://yard//lib/yard/tags/library.rb#202
  def visibility_directive(tag, parser); end

  # Describes what a method might yield to a given block.
  # The types specifier list should not list types, but names
  # of the parameters yielded to the block. If you define
  # parameters with +@yieldparam+, you do not need to define
  # the parameters in the type specification of +@yield+ as
  # well.
  #
  # @example
  #   # For a block {|a,b,c| ... }
  #   # @yield [a, b, c] Gives 3 random numbers to the block
  #   def provide3values(&block) yield(42, 42, 42) end
  # @see tag:yieldparam
  # @see tag:yieldreturn
  #
  # source://yard//lib/yard/tags/library.rb#168
  def yield_tag(text); end

  # Defines a parameter yielded by a block. If you define the
  # parameters with +@yieldparam+, you do not need to define
  # them via +@yield+ as well.
  #
  # @example
  #   # @yieldparam [String] name the name that is yielded
  #   def with_name(name) yield(name) end
  #
  # source://yard//lib/yard/tags/library.rb#168
  def yieldparam_tag(text); end

  # Documents the value and type that the block is expected
  # to return to the method.
  #
  # @example
  #   # @yieldreturn [Fixnum] the number to add 5 to.
  #   def add5_block(&block) 5 + yield end
  # @see tag:return
  #
  # source://yard//lib/yard/tags/library.rb#168
  def yieldreturn_tag(text); end

  private

  # @return [Directive]
  #
  # source://yard//lib/yard/tags/library.rb#244
  def directive_call(tag, parser); end

  # source://yard//lib/yard/tags/library.rb#233
  def send_to_factory(tag_name, meth, text); end

  class << self
    # Replace the factory object responsible for parsing tags by setting
    # this to an object (or class) that responds to +parse_TAGNAME+ methods
    # where +TAGNAME+ is the name of the tag.
    #
    # You should set this value before performing any source parsing with
    # YARD, otherwise your factory class will not be used.
    #
    # @example
    #   YARD::Tags::Library.default_factory = MyFactory
    # @see DefaultFactory
    #
    # source://yard//lib/yard/tags/library.rb#83
    def default_factory; end

    # Replace the factory object responsible for parsing tags by setting
    # this to an object (or class) that responds to +parse_TAGNAME+ methods
    # where +TAGNAME+ is the name of the tag.
    #
    # You should set this value before performing any source parsing with
    # YARD, otherwise your factory class will not be used.
    #
    # @example
    #   YARD::Tags::Library.default_factory = MyFactory
    # @see DefaultFactory
    #
    # source://yard//lib/yard/tags/library.rb#87
    def default_factory=(factory); end

    # @overload define_directive
    #
    # source://yard//lib/yard/tags/library.rb#196
    def define_directive(tag, tag_meth = T.unsafe(nil), directive_class = T.unsafe(nil)); end

    # Convenience method to define a new tag using one of {Tag}'s factory methods, or the
    # regular {DefaultFactory#parse_tag} factory method if none is supplied.
    #
    # @param label [#to_s] the label used when displaying the tag in templates
    # @param tag [#to_s] the tag name to create
    # @param meth [#to_s, Class<Tag>] the {Tag} factory method to call when
    #   creating the tag or the name of the class to directly create a tag for
    #
    # source://yard//lib/yard/tags/library.rb#157
    def define_tag(label, tag, meth = T.unsafe(nil)); end

    # source://yard//lib/yard/tags/library.rb#220
    def directive_method_name(tag_name); end

    # Returns the factory method used to parse the tag text for a specific tag
    #
    # @param tag [Symbol] the tag name
    # @return [Symbol] the factory method name for the tag
    # @return [Class<Tag>, Symbol] the Tag class to use to parse the tag
    #   or the method to call on the factory class
    # @return [nil] if the tag is freeform text
    # @since 0.6.0
    #
    # source://yard//lib/yard/tags/library.rb#99
    def factory_method_for(tag); end

    # Returns the factory method used to parse the tag text for a specific
    # directive
    #
    # @param directive [Symbol] the directive name
    # @return [Symbol] the factory method name for the tag
    # @return [Class<Tag>, Symbol] the Tag class to use to parse the tag or
    #   the methods to call on the factory class
    # @return [nil] if the tag is freeform text
    # @since 0.8.0
    #
    # source://yard//lib/yard/tags/library.rb#112
    def factory_method_for_directive(directive); end

    # @return [Library] the main Library instance object.
    #
    # source://yard//lib/yard/tags/library.rb#67
    def instance; end

    # @return [SymbolHash{Symbol=>String}] the map of tag names and their
    #   respective display labels.
    #
    # source://yard//lib/yard/tags/library.rb#63
    def labels; end

    # Sorts the labels lexically by their label name, often used when displaying
    # the tags.
    #
    # @return [Array<Symbol>, String] the sorted labels as an array of the tag name and label
    #
    # source://yard//lib/yard/tags/library.rb#142
    def sorted_labels; end

    # source://yard//lib/yard/tags/library.rb#216
    def tag_method_name(tag_name); end

    # Sets the list of tags that should apply to any children inside the
    # namespace they are defined in. For instance, a "@since" tag should
    # apply to all methods inside a module it is defined in. Transitive
    # tags can be overridden by directly defining a tag on the child object.
    #
    # @return [Array<Symbol>] a list of transitive tags
    # @since 0.6.0
    #
    # source://yard//lib/yard/tags/library.rb#136
    def transitive_tags; end

    # Sets the list of tags that should apply to any children inside the
    # namespace they are defined in. For instance, a "@since" tag should
    # apply to all methods inside a module it is defined in. Transitive
    # tags can be overridden by directly defining a tag on the child object.
    #
    # @return [Array<Symbol>] a list of transitive tags
    # @since 0.6.0
    #
    # source://yard//lib/yard/tags/library.rb#136
    def transitive_tags=(_arg0); end

    # Sets the list of tags to display when rendering templates. The order of
    # tags in the list is also significant, as it represents the order that
    # tags are displayed in templates.
    #
    # You can use the {Array#place} to insert new tags to be displayed in
    # the templates at specific positions:
    #
    #   Library.visible_tags.place(:mytag).before(:return)
    #
    # @return [Array<Symbol>] a list of ordered tags
    # @since 0.6.0
    #
    # source://yard//lib/yard/tags/library.rb#127
    def visible_tags; end

    # Sets the list of tags to display when rendering templates. The order of
    # tags in the list is also significant, as it represents the order that
    # tags are displayed in templates.
    #
    # You can use the {Array#place} to insert new tags to be displayed in
    # the templates at specific positions:
    #
    #   Library.visible_tags.place(:mytag).before(:return)
    #
    # @return [Array<Symbol>] a list of ordered tags
    # @since 0.6.0
    #
    # source://yard//lib/yard/tags/library.rb#127
    def visible_tags=(_arg0); end

    private

    # source://yard//lib/yard/tags/library.rb#226
    def tag_or_directive_method_name(tag_name, type = T.unsafe(nil)); end
  end
end

# Defines a block of text to be expanded whenever the macro is called by name
# in subsequent docstrings. The macro data can be any arbitrary text data, be
# it regular documentation, meta-data tags or directives.
#
# == Defining a Macro
#
# A macro must first be defined in order to be used. Note that a macro is also
# expanded upon definition if it defined on an object (the docstring of a
# method, class, module or constant object as opposed to a free standing
# comment). To define a macro, use the "new" or "attach" identifier in the
# types specifier list. A macro will also automatically be created if an
# indented macro data block is given, so the keywords are not strictly needed.
#
# === Anonymous Macros
#
# In addition to standard named macros, macros can be defined anonymously if
# no name is given. In this case, they can not be re-used in future docstrings,
# but they will expand in the first definition. This is useful when needing
# to take advantage of the macro expansion variables (described below).
#
# == Using a Macro
#
# To re-use a macro in another docstring after it is defined, simply use
# <tt>@!macro the_name</tt> with no indented block of macro data. The resulting
# data will be expanded in place.
#
# == Attaching a Macro to a DSL Method
#
# Macros can be defined to auto-expand on DSL-style class method calls. To
# define a macro to be auto expanded in this way, use the "attach" keyword
# in the type specifier list ("new" is implied).
#
# Attached macros can also be attached directly on the class method declaration
# that provides the DSL method to its subclasses. The syntax in either case
# is the same.
#
# == Macro Expansion Variables
#
# In the case of using macros on DSL-style method calls, a number of expansion
# variables can be used for interpolation inside of the macro data. The variables,
# similar in syntax to Ruby's global variables, are as follows:
#
# * $0 - the method name being called
# * $1, $2, $3, ... - the Nth argument in the method call
# * $& - the full source line
#
# The following example shows what the expansion variables might hold for a given
# DSL method call:
#
#   property :foo, :a, :b, :c, String
#   # $0 => "property"
#   # $1 => "foo"
#   # $2 => "a"
#   # $& => "property :foo, :a, :b, :c, String"
#
# === Ranges
#
# Ranges are also acceptable with the syntax <tt>${N-M}</tt>. Negative values
# on either N or M are valid, and refer to indexes from the end of the list.
# Consider a DSL method that creates a method using the first argument with
# argument names following, ending with the return type of the method. This
# could be documented as:
#
#     # @!macro dsl_method
#     #   @!method $1(${2--2})
#     #   @return [${-1}] the return value of $0
#     create_method_with_args :foo, :a, :b, :c, String
#
# As described, the method is using the signature <tt>foo(a, b, c)</tt> and the return
# type from the last argument, +String+. When using ranges, tokens are joined
# with commas. Note that this includes using $0:
#
#     !!!plain
#     $0-1 # => Interpolates to "create_method_with_args, foo"
#
# If you want to separate them with spaces, use <tt>$1 $2 $3 $4 ...</tt>. Note that
# if the token cannot be expanded, it will return the empty string (not an error),
# so it would be safe to list <tt>$1 $2 ... $10</tt>, for example.
#
# === Escaping Interpolation
#
# Interpolation can be escaped by prefixing the +$+ with +\\\+, like so:
#
#     # @!macro foo
#     #   I have \$2.00 USD.
#
# @example Defining a simple macro
#   # @!macro [new] returnself
#   #   @return [self] returns itself
# @example Using a simple macro in multiple docstrings
#   # Documentation for map
#   # ...
#   # @macro returnself
#   def map; end
#
#   # Documentation for filter
#   # ...
#   # @macro returnself
#   def filter; end
# @example Attaching a macro to a class method (for DSL usage)
#   class Resource
#   # Defines a new property
#   # @param [String] name the property name
#   # @param [Class] type the property's type
#   # @!macro [attach] property
#   #   @return [$2] the $1 property
#   def self.property(name, type) end
#   end
#
#   class Post < Resource
#   property :title, String
#   property :view_count, Integer
#   end
# @example Attaching a macro directly to a DSL method
#   class Post < Resource
#   # @!macro [attach] property
#   #   @return [$2] the $1 property
#   property :title, String
#
#   # Macro will expand on this definition too
#   property :view_count, Integer
#   end
# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#257
class YARD::Tags::MacroDirective < ::YARD::Tags::Directive
  # @raise [TagFormatError]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#258
  def call; end

  private

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#287
  def anonymous?; end

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#276
  def attach?; end

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#282
  def class_method?; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#291
  def expand(macro_data); end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#307
  def find_or_create; end

  # @return [Boolean]
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#271
  def new?; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#331
  def warn; end
end

# Defines a method object with a given method signature, using indented
# block data as the method's docstring. The signature is similar to the
# {tag:overload} tag. The comment containing this directive does not need
# to be attached to any source, but if it is, that source code will be
# used as the method's source.
#
# To define an attribute method, see {tag:!attribute}
#
# @example Defining a simple method
#   # @!method quit(username, message = "Quit")
#   #   Sends a quit message to the server for a +username+.
#   #   @param [String] username the username to quit
#   #   @param [String] message the quit message
#   quit_message_method
# @example Attaching multiple methods to the same source
#   # @!method method1
#   # @!method method2
#   create_methods :method1, :method2
# @note This directive should only be used if there is no explicit
#   declaration for the method in any source files (i.e., the method
#   is declared dynamically via meta-programming). In all other cases, add
#   documentation to the method definition itself.
# @note For backwards compatibility support, you do not need to indent
#   the method's docstring text. If a +@!method+ directive is seen with
#   no indented block, the entire docstring is used as the new method's
#   docstring text.
# @see tag:!attribute
# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#367
class YARD::Tags::MethodDirective < ::YARD::Tags::Directive
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#372
  def after_parse; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#370
  def call; end

  protected

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#412
  def create_object; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#380
  def method_name; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#389
  def method_signature; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#393
  def sanitized_tag_signature; end

  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#402
  def use_indented_text; end
end

# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#368
YARD::Tags::MethodDirective::SCOPE_MATCH = T.let(T.unsafe(nil), Regexp)

# source://yard//lib/yard/tags/option_tag.rb#4
class YARD::Tags::OptionTag < ::YARD::Tags::Tag
  # @return [OptionTag] a new instance of OptionTag
  #
  # source://yard//lib/yard/tags/option_tag.rb#7
  def initialize(tag_name, name, pair); end

  # Returns the value of attribute pair.
  #
  # source://yard//lib/yard/tags/option_tag.rb#5
  def pair; end

  # Sets the attribute pair
  #
  # @param value the value to set the attribute pair to.
  #
  # source://yard//lib/yard/tags/option_tag.rb#5
  def pair=(_arg0); end
end

# source://yard//lib/yard/tags/overload_tag.rb#4
class YARD::Tags::OverloadTag < ::YARD::Tags::Tag
  # @return [OverloadTag] a new instance of OverloadTag
  #
  # source://yard//lib/yard/tags/overload_tag.rb#7
  def initialize(tag_name, text); end

  # Returns the value of attribute docstring.
  #
  # source://yard//lib/yard/tags/overload_tag.rb#5
  def docstring; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/tags/overload_tag.rb#15
  def has_tag?(name); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/tags/overload_tag.rb#36
  def is_a?(other); end

  # @return [Boolean]
  #
  # source://yard//lib/yard/tags/overload_tag.rb#36
  def kind_of?(other); end

  # source://yard//lib/yard/tags/overload_tag.rb#28
  def method_missing(*args, &block); end

  # source://yard//lib/yard/tags/overload_tag.rb#23
  def name(prefix = T.unsafe(nil)); end

  # source://yard//lib/yard/tags/overload_tag.rb#17
  def object=(value); end

  # Returns the value of attribute parameters.
  #
  # source://yard//lib/yard/tags/overload_tag.rb#5
  def parameters; end

  # Returns the value of attribute signature.
  #
  # source://yard//lib/yard/tags/overload_tag.rb#5
  def signature; end

  # source://yard//lib/yard/tags/overload_tag.rb#13
  def tag(name); end

  # source://yard//lib/yard/tags/overload_tag.rb#14
  def tags(name = T.unsafe(nil)); end

  # source://yard//lib/yard/tags/overload_tag.rb#32
  def type; end

  private

  # source://yard//lib/yard/tags/overload_tag.rb#53
  def parse_signature; end

  # source://yard//lib/yard/tags/overload_tag.rb#43
  def parse_tag(text); end
end

# Parses a block of code as if it were present in the source file at that
# location. This directive is useful if a class has dynamic meta-programmed
# behaviour that cannot be recognized by YARD.
#
# You can specify the language of the code block using the types
# specification list. By default, the code language is "ruby".
#
# @example Documenting dynamic module inclusion
#   class User
#   # includes "UserMixin" and extends "UserMixin::ClassMethods"
#   # using the UserMixin.included callback.
#   # @!parse include UserMixin
#   # @!parse extend UserMixin::ClassMethods
#   end
# @example Declaring a method as an attribute
#   # This should really be an attribute
#   # @!parse attr_reader :foo
#   def object; @parent.object end
# @example Parsing C code
#   # @!parse [c]
#   #   void Init_Foo() {
#   #     rb_define_method(rb_cFoo, "method", method, 0);
#   #   }
# @since 0.8.0
#
# source://yard//lib/yard/tags/directives.rb#544
class YARD::Tags::ParseDirective < ::YARD::Tags::Directive
  # @since 0.8.0
  #
  # source://yard//lib/yard/tags/directives.rb#545
  def call; end
end

# source://yard//lib/yard/tags/ref_tag.rb#4
module YARD::Tags::RefTag
  # Returns the value of attribute owner.
  #
  # source://yard//lib/yard/tags/ref_tag.rb#5
  def owner; end

  # Sets the attribute owner
  #
  # @param value the value to set the attribute owner to.
  #
  # source://yard//lib/yard/tags/ref_tag.rb#5
  def owner=(_arg0); end
end

# source://yard//lib/yard/tags/ref_tag_list.rb#4
class YARD::Tags::RefTagList
  # @return [RefTagList] a new instance of RefTagList
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#7
  def initialize(tag_name, owner, name = T.unsafe(nil)); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def name=(_arg0); end

  # Returns the value of attribute owner.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def owner; end

  # Sets the attribute owner
  #
  # @param value the value to set the attribute owner to.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def owner=(_arg0); end

  # Returns the value of attribute tag_name.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def tag_name; end

  # Sets the attribute tag_name
  #
  # @param value the value to set the attribute tag_name to.
  #
  # source://yard//lib/yard/tags/ref_tag_list.rb#5
  def tag_name=(_arg0); end

  # source://yard//lib/yard/tags/ref_tag_list.rb#13
  def tags; end
end

# Modifies the current parsing scope (class or instance). If this
# directive is defined on a docstring attached to an object definition,
# it is applied only to that object. Otherwise, it applies the scope
# to all future objects in the namespace.
#
# @example Modifying the scope of a DSL method
#   # @!scope class
#   cattr_accessor :subclasses
# @example Modifying the scope of a set of methods
#   # @!scope class
#
#   # Documentation for method1
#   def method1; end
#
#   # Documentation for method2
#   def method2; end
# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#578
class YARD::Tags::ScopeDirective < ::YARD::Tags::Directive
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#579
  def call; end
end

# Represents a metadata tag value (+@tag+). Tags can have any combination of
# {#types}, {#name} and {#text}, or none of the above.
#
# @example Programmatic tag creation
#   # The following docstring syntax:
#   #   @param [String, nil] arg an argument
#   #
#   # is equivalent to:
#   Tag.new(:param, 'an argument', ['String', 'nil'], 'arg')
#
# source://yard//lib/yard/tags/tag.rb#13
class YARD::Tags::Tag
  # Creates a new tag object with a tag name and text. Optionally, formally declared types
  # and a key name can be specified.
  #
  # Types are mainly for meta tags that rely on type information, such as +param+, +return+, etc.
  #
  # Key names are for tags that declare meta data for a specific key or name, such as +param+,
  # +raise+, etc.
  #
  # @param tag_name [#to_s] the tag name to create the tag for
  # @param text [String] the descriptive text for this tag
  # @param types [Array<String>] optional type list of formally declared types
  #   for the tag
  # @param name [String] optional key name which the tag refers to
  # @return [Tag] a new instance of Tag
  #
  # source://yard//lib/yard/tags/tag.rb#45
  def initialize(tag_name, text, types = T.unsafe(nil), name = T.unsafe(nil)); end

  # Provides a plain English summary of the type specification, or nil
  # if no types are provided or parsable.
  #
  # @return [String] a plain English description of the associated types
  # @return [nil] if no types are provided or not parsable
  #
  # source://yard//lib/yard/tags/tag.rb#66
  def explain_types; end

  # @return [String] a name associated with the tag
  # @return [nil] if no tag name is supplied
  #
  # source://yard//lib/yard/tags/tag.rb#27
  def name; end

  # @return [String] a name associated with the tag
  # @return [nil] if no tag name is supplied
  #
  # source://yard//lib/yard/tags/tag.rb#27
  def name=(_arg0); end

  # @return [CodeObjects::Base] the associated object
  #
  # source://yard//lib/yard/tags/tag.rb#30
  def object; end

  # @return [CodeObjects::Base] the associated object
  #
  # source://yard//lib/yard/tags/tag.rb#30
  def object=(_arg0); end

  # @return [String] the name of the tag
  #
  # source://yard//lib/yard/tags/tag.rb#15
  def tag_name; end

  # @return [String] the name of the tag
  #
  # source://yard//lib/yard/tags/tag.rb#15
  def tag_name=(_arg0); end

  # @return [String] the tag text associated with the tag
  # @return [nil] if no tag text is supplied
  #
  # source://yard//lib/yard/tags/tag.rb#19
  def text; end

  # @return [String] the tag text associated with the tag
  # @return [nil] if no tag text is supplied
  #
  # source://yard//lib/yard/tags/tag.rb#19
  def text=(_arg0); end

  # Convenience method to access the first type specified. This should mainly
  # be used for tags that only specify one type.
  #
  # @return [String] the first of the list of specified types
  # @see #types
  #
  # source://yard//lib/yard/tags/tag.rb#57
  def type; end

  # @return [Array<String>] a list of types associated with the tag
  # @return [nil] if no types are associated with the tag
  #
  # source://yard//lib/yard/tags/tag.rb#23
  def types; end

  # @return [Array<String>] a list of types associated with the tag
  # @return [nil] if no types are associated with the tag
  #
  # source://yard//lib/yard/tags/tag.rb#23
  def types=(_arg0); end
end

# source://yard//lib/yard/tags/tag_format_error.rb#4
class YARD::Tags::TagFormatError < ::RuntimeError; end

# source://yard//lib/yard/tags/types_explainer.rb#6
class YARD::Tags::TypesExplainer
  class << self
    # Provides a plain English summary of the type specification, or nil
    # if no types are provided or parsable.
    #
    # @param types [Array<String>] a list of types to parse and summarize
    # @return [String] a plain English description of the associated types
    # @return [nil] if no types are provided or not parsable
    #
    # source://yard//lib/yard/tags/types_explainer.rb#9
    def explain(*types); end

    # Provides a plain English summary of the type specification, or nil
    # if no types are provided or parsable.
    #
    # @param types [Array<String>] a list of types to parse and summarize
    # @raise [SyntaxError] if the types are not parsable
    # @return [String] a plain English description of the associated types
    # @return [nil] if no types are provided or not parsable
    #
    # source://yard//lib/yard/tags/types_explainer.rb#17
    def explain!(*types); end

    private

    def new(*_arg0); end
  end
end

# @private
#
# source://yard//lib/yard/tags/types_explainer.rb#58
class YARD::Tags::TypesExplainer::CollectionType < ::YARD::Tags::TypesExplainer::Type
  # @return [CollectionType] a new instance of CollectionType
  #
  # source://yard//lib/yard/tags/types_explainer.rb#61
  def initialize(name, types); end

  # source://yard//lib/yard/tags/types_explainer.rb#66
  def to_s(_singular = T.unsafe(nil)); end

  # Returns the value of attribute types.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#59
  def types; end

  # Sets the attribute types
  #
  # @param value the value to set the attribute types to.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#59
  def types=(_arg0); end
end

# @private
#
# source://yard//lib/yard/tags/types_explainer.rb#72
class YARD::Tags::TypesExplainer::FixedCollectionType < ::YARD::Tags::TypesExplainer::CollectionType
  # source://yard//lib/yard/tags/types_explainer.rb#73
  def to_s(_singular = T.unsafe(nil)); end
end

# @private
#
# source://yard//lib/yard/tags/types_explainer.rb#79
class YARD::Tags::TypesExplainer::HashCollectionType < ::YARD::Tags::TypesExplainer::Type
  # @return [HashCollectionType] a new instance of HashCollectionType
  #
  # source://yard//lib/yard/tags/types_explainer.rb#82
  def initialize(name, key_types, value_types); end

  # Returns the value of attribute key_types.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#80
  def key_types; end

  # Sets the attribute key_types
  #
  # @param value the value to set the attribute key_types to.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#80
  def key_types=(_arg0); end

  # source://yard//lib/yard/tags/types_explainer.rb#88
  def to_s(_singular = T.unsafe(nil)); end

  # Returns the value of attribute value_types.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#80
  def value_types; end

  # Sets the attribute value_types
  #
  # @param value the value to set the attribute value_types to.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#80
  def value_types=(_arg0); end
end

# @private
#
# source://yard//lib/yard/tags/types_explainer.rb#96
class YARD::Tags::TypesExplainer::Parser
  include ::YARD::CodeObjects

  # @return [Parser] a new instance of Parser
  #
  # source://yard//lib/yard/tags/types_explainer.rb#117
  def initialize(string); end

  # source://yard//lib/yard/tags/types_explainer.rb#121
  def parse; end

  class << self
    # source://yard//lib/yard/tags/types_explainer.rb#113
    def parse(string); end
  end
end

# source://yard//lib/yard/tags/types_explainer.rb#99
YARD::Tags::TypesExplainer::Parser::TOKENS = T.let(T.unsafe(nil), Hash)

# @private
#
# source://yard//lib/yard/tags/types_explainer.rb#26
class YARD::Tags::TypesExplainer::Type
  # @return [Type] a new instance of Type
  #
  # source://yard//lib/yard/tags/types_explainer.rb#29
  def initialize(name); end

  # Returns the value of attribute name.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#27
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://yard//lib/yard/tags/types_explainer.rb#27
  def name=(_arg0); end

  # source://yard//lib/yard/tags/types_explainer.rb#33
  def to_s(singular = T.unsafe(nil)); end

  private

  # source://yard//lib/yard/tags/types_explainer.rb#45
  def list_join(list); end
end

# Modifies the current parsing visibility (public, protected, or private).
# If this directive is defined on a docstring attached to an object
# definition, it is applied only to that object. Otherwise, it applies
# the visibility to all future objects in the namespace.
#
# @example Modifying the visibility of a DSL method
#   # @!visibility private
#   cattr_accessor :subclasses
# @example Modifying the visibility of a set of methods
#   # Note that Ruby's "protected" is recommended over this directive
#   # @!visibility protected
#
#   # Documentation for method1
#   def method1; end
#
#   # Documentation for method2
#   def method2; end
# @since 0.7.0
#
# source://yard//lib/yard/tags/directives.rb#610
class YARD::Tags::VisibilityDirective < ::YARD::Tags::Directive
  # @since 0.7.0
  #
  # source://yard//lib/yard/tags/directives.rb#611
  def call; end
end

# Namespace for templating system
#
# source://yard//lib/yard/autoload.rb#271
module YARD::Templates; end

# This module manages all creation, handling and rendering of {Template}
# objects.
#
# * To create a template object at a path, use {template}.
# * To render a template, call {render}.
# * To register a template path in the lookup paths, call {register_template_path}.
#
# source://yard//lib/yard/templates/engine.rb#11
module YARD::Templates::Engine
  class << self
    # Passes a set of objects to the +:fulldoc+ template for full documentation generation.
    # This is called by {CLI::Yardoc} to most commonly perform HTML
    # documentation generation.
    #
    # @param objects [Array<CodeObjects::Base>] a list of {CodeObjects::Base}
    #   objects to pass to the template
    # @param options [Hash] (see {render})
    # @return [void]
    #
    # source://yard//lib/yard/templates/engine.rb#100
    def generate(objects, options = T.unsafe(nil)); end

    # Registers a new template path in {template_paths}
    #
    # @param path [String] a new template path
    # @return [void]
    #
    # source://yard//lib/yard/templates/engine.rb#20
    def register_template_path(path); end

    # Renders a template on a {CodeObjects::Base code object} using
    # a set of default (overridable) options. Either the +:object+
    # or +:type+ keys must be provided.
    #
    # If a +:serializer+ key is provided and +:serialize+ is not set to
    # false, the rendered contents will be serialized through the {Serializers::Base}
    # object. See {with_serializer}.
    #
    # @example Renders an object with html formatting
    #   Engine.render(:format => :html, :object => obj)
    # @example Renders without an object
    #   Engine.render(:type => :fulldoc, :otheropts => somevalue)
    # @option options
    # @option options
    # @option options
    # @param options [Hash] the options hash
    # @return [String] the rendered template
    #
    # source://yard//lib/yard/templates/engine.rb#81
    def render(options = T.unsafe(nil)); end

    # Creates a template module representing the path. Searches on disk
    # for the first directory named +path+ (joined by '/') within the
    # template paths and builds a template module for. All other matching
    # directories in other template paths will be included in the
    # generated module as mixins (for overriding).
    #
    # @param path [Array<String, Symbol>] a list of path components
    # @raise [ArgumentError] if the path does not exist within one of the
    #   {template_paths} on disk.
    # @return [Template] the module representing the template
    #
    # source://yard//lib/yard/templates/engine.rb#34
    def template(*path); end

    # Forces creation of a template at +path+ within a +full_path+.
    #
    # @param path [String] the path name of the template
    # @param full_paths [Array<String>] the full path on disk of the template
    # @return [Template] the template module representing the +path+
    #
    # source://yard//lib/yard/templates/engine.rb#52
    def template!(path, full_paths = T.unsafe(nil)); end

    # @return [Array<String>] the list of registered template paths
    #
    # source://yard//lib/yard/templates/engine.rb#14
    def template_paths; end

    # @return [Array<String>] the list of registered template paths
    #
    # source://yard//lib/yard/templates/engine.rb#14
    def template_paths=(_arg0); end

    # Serializes the results of a block with a +serializer+ object.
    #
    # @param object [CodeObjects::Base] the code object to serialize
    # @param serializer [Serializers::Base] the serializer object
    # @see Serializers::Base
    # @yield a block whose result will be serialize
    # @yieldreturn [String] the contents to serialize
    #
    # source://yard//lib/yard/templates/engine.rb#114
    def with_serializer(object, serializer); end

    private

    # Searches through the registered {template_paths} and returns
    # all full directories that have the +path+ within them on disk.
    #
    # @param from_template [Template] if provided, allows a relative
    #   path to be specified from this template's full path.
    # @param path [String] the path component to search for in the
    #   {template_paths}
    # @return [Array<String>] a list of full paths that are existing
    #   candidates for a template module
    #
    # source://yard//lib/yard/templates/engine.rb#160
    def find_template_paths(from_template, path); end

    # Sets default options on the options hash
    #
    # @option options
    # @option options
    # @option options
    # @param options [Hash] the options hash
    # @return [void]
    #
    # source://yard//lib/yard/templates/engine.rb#140
    def set_default_options(options = T.unsafe(nil)); end

    # The name of the module that represents a +path+
    #
    # @param path [String] the path to generate a module name for
    # @return [String] the module name
    #
    # source://yard//lib/yard/templates/engine.rb#175
    def template_module_name(path); end
  end
end

# @since 0.5.4
#
# source://yard//lib/yard/templates/erb_cache.rb#5
module YARD::Templates::ErbCache
  class << self
    # @since 0.5.4
    #
    # source://yard//lib/yard/templates/erb_cache.rb#17
    def clear!; end

    # @since 0.5.4
    #
    # source://yard//lib/yard/templates/erb_cache.rb#6
    def method_for(filename); end
  end
end

# Namespace for template helpers
#
# source://yard//lib/yard/autoload.rb#272
module YARD::Templates::Helpers; end

# The base helper module included in all templates.
#
# source://yard//lib/yard/templates/helpers/base_helper.rb#4
module YARD::Templates::Helpers::BaseHelper
  # @example
  #   s = format_object_title ModuleObject.new(:root, :MyModuleName)
  #   s # => "Module: MyModuleName"
  # @param object [CodeObjects::Base] the object to retrieve a title for
  # @return [String] the page title name for a given object
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#196
  def format_object_title(object); end

  # @example Formatted type of an exception class
  #   o = ClassObject.new(:root, :MyError)
  #   o.superclass = P('RuntimeError')
  #   format_object_type(o) # => "Exception"
  # @example Formatted type of a method
  #   o = MethodObject.new(:root, :to_s)
  #   format_object_type(o) # => "Method"
  # @param object [CodeObjects::Base] the object to retrieve the type for
  # @return [String] the human-readable formatted {CodeObjects::Base#type #type}
  #   for the object
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#182
  def format_object_type(object); end

  # Indents and formats source code
  #
  # @param value [String] the input source code
  # @return [String] formatted source code
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#209
  def format_source(value); end

  # Formats a list of return types for output and links each type.
  #
  # @example Formatting types
  #   format_types(['String', 'Array']) #=> "(String, Array)"
  # @example Formatting types without surrounding brackets
  #   format_types(['String', 'Array'], false) #=> "String, Array"
  # @param list [Array<String>] a list of types
  # @param brackets [Boolean] whether to surround the types in brackets
  # @return [String] the formatted list of Ruby types
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#168
  def format_types(list, brackets = T.unsafe(nil)); end

  # An object that keeps track of global state throughout the entire template
  # rendering process (including any sub-templates).
  #
  # @return [OpenStruct] a struct object that stores state
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#20
  def globals; end

  # Escapes text. This is used a lot by the HtmlHelper and there should
  # be some helper to "clean up" text for whatever, this is it.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#38
  def h(text); end

  # Links to an extra file
  #
  # @param filename [String] the filename to link to
  # @param title [String] the title of the link
  # @param anchor [String] optional anchor
  # @return [String] the link to the file
  # @since 0.5.5
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#152
  def link_file(filename, title = T.unsafe(nil), anchor = T.unsafe(nil)); end

  # Include a file as a docstring in output
  #
  # @param file [String] the filename to include
  # @return [String] the file's contents
  # @since 0.7.0
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#113
  def link_include_file(file); end

  # Includes an object's docstring into output.
  #
  # @param obj [CodeObjects::Base] the object to include
  # @return [String] the object's docstring (no tags)
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#105
  def link_include_object(obj); end

  # Links to an object with an optional title
  #
  # @param obj [CodeObjects::Base] the object to link to
  # @param title [String] the title to use for the link
  # @return [String] the linked object
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#122
  def link_object(obj, title = T.unsafe(nil)); end

  # Links to a URL
  #
  # @param url [String] the URL to link to
  # @param title [String] the optional title to display the link as
  # @param params [Hash] optional parameters for the link
  # @return [String] the linked URL
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#141
  def link_url(url, title = T.unsafe(nil), params = T.unsafe(nil)); end

  # Links objects or URLs. This method will delegate to the correct +link_+
  # method depending on the arguments passed in.
  #
  # @example Linking a URL
  #   linkify('http://example.com')
  # @example Including docstring contents of an object
  #   linkify('include:YARD::Docstring')
  # @example Linking to an extra file
  #   linkify('file:README')
  # @example Linking an object by path
  #   linkify('YARD::Docstring')
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#55
  def linkify(*args); end

  # Returns the value of attribute object.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#5
  def object; end

  # Sets the attribute object
  #
  # @param value the value to set the attribute object to.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#5
  def object=(_arg0); end

  # @return [CodeObjects::Base] the object representing the current generated
  #   page. Might not be the current {#object} when inside sub-templates.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#11
  def owner; end

  # Runs a list of objects against the {Verifier} object passed into the
  # template and returns the subset of verified objects.
  #
  # @param list [Array<CodeObjects::Base>] a list of code objects
  # @return [Array<CodeObjects::Base>] a list of code objects that match
  #   the verifier. If no verifier is supplied, all objects are returned.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#30
  def run_verifier(list); end

  # Returns the value of attribute serializer.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#5
  def serializer; end

  # Sets the attribute serializer
  #
  # @param value the value to set the attribute serializer to.
  #
  # source://yard//lib/yard/templates/helpers/base_helper.rb#5
  def serializer=(_arg0); end
end

# Helpers for various object types
#
# source://yard//lib/yard/templates/helpers/filter_helper.rb#5
module YARD::Templates::Helpers::FilterHelper
  # @return [Boolean] whether an object is a class
  #
  # source://yard//lib/yard/templates/helpers/filter_helper.rb#17
  def is_class?(object); end

  # @return [Boolean] whether an object is a method
  #
  # source://yard//lib/yard/templates/helpers/filter_helper.rb#7
  def is_method?(object); end

  # @return [Boolean] whether an object is a module
  #
  # source://yard//lib/yard/templates/helpers/filter_helper.rb#22
  def is_module?(object); end

  # @return [Boolean] whether an object is a namespace
  #
  # source://yard//lib/yard/templates/helpers/filter_helper.rb#12
  def is_namespace?(object); end
end

# The helper module for HTML templates.
#
# source://yard//lib/yard/templates/helpers/html_helper.rb#7
module YARD::Templates::Helpers::HtmlHelper
  include ::YARD::Templates::Helpers::MarkupHelper
  include ::YARD::Templates::Helpers::ModuleHelper
  include ::YARD::Templates::Helpers::HtmlSyntaxHighlightHelper

  # @param object [CodeObjects::Base] the object to get an anchor for
  # @return [String] the anchor for a specific object
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#347
  def anchor_for(object); end

  # Returns the current character set. The default value can be overridden
  # by setting the +LANG+ environment variable or by overriding this
  # method. In Ruby 1.9 you can also modify this value by setting
  # +Encoding.default_external+.
  #
  # @return [String] the current character set
  # @since 0.5.4
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#574
  def charset; end

  # Formats a list of objects and links them
  #
  # @return [String] a formatted list of objects
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#458
  def format_object_name_list(objects); end

  # Formats a list of types from a tag.
  #
  # @param typelist [Array<String>, FalseClass] the list of types to be formatted.
  # @param brackets [Boolean] omits the surrounding
  #   brackets if +brackets+ is set to +false+.
  # @return [String] the list of types formatted
  #   as [Type1, Type2, ...] with the types linked
  #   to their respective descriptions.
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#476
  def format_types(typelist, brackets = T.unsafe(nil)); end

  # Escapes HTML entities
  #
  # @param text [String] the text to escape
  # @return [String] the HTML with escaped entities
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#23
  def h(text); end

  # Converts Asciidoc to HTML
  #
  # @param text [String] input Asciidoc text
  # @return [String] output HTML
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#109
  def html_markup_asciidoc(text); end

  # Converts HTML to HTML
  #
  # @param text [String] input html
  # @return [String] output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#168
  def html_markup_html(text); end

  # Converts Markdown to HTML
  #
  # @param text [String] input Markdown text
  # @return [String] output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#78
  def html_markup_markdown(text); end

  # @return [String] the same text with no markup
  # @since 0.6.6
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#160
  def html_markup_none(text); end

  # Converts org-mode to HTML
  #
  # @param text [String] input org-mode text
  # @return [String] output HTML
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#102
  def html_markup_org(text); end

  # Converts plaintext to pre-formatted HTML
  #
  # @param text [String] the input text
  # @return [String] the output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#146
  def html_markup_pre(text); end

  # Converts RDoc formatting (SimpleMarkup) to HTML
  #
  # @param text [String] the input RDoc formatted text
  # @return [String] output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#136
  def html_markup_rdoc(text); end

  # Highlights Ruby source. Similar to {#html_syntax_highlight}, but
  # this method is meant to be called from {#htmlify} when markup is
  # set to "ruby".
  #
  # @param source [String] the Ruby source
  # @return [String] the highlighted HTML
  # @since 0.7.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#179
  def html_markup_ruby(source); end

  # Converts plaintext to regular HTML
  #
  # @param text [String] the input text
  # @return [String] the output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#154
  def html_markup_text(text); end

  # Converts Textile to HTML
  #
  # @param text [String] the input Textile text
  # @return [String] output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#118
  def html_markup_textile(text); end

  # Converts plaintext to strict Textile (hard breaks)
  #
  # @param text [String] the input textile data
  # @return [String] the output HTML
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#128
  def html_markup_textile_strict(text); end

  # Syntax highlights +source+ in language +type+.
  #
  # @note To support a specific language +type+, implement the method
  #   +html_syntax_highlight_TYPE+ in this class.
  # @param source [String] the source code to highlight
  # @param type [Symbol, String] the language type (:ruby, :plain, etc). Use
  #   :plain for no syntax highlighting.
  # @return [String] the highlighted source
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#199
  def html_syntax_highlight(source, type = T.unsafe(nil)); end

  # @return [String] unhighlighted source
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#210
  def html_syntax_highlight_plain(source); end

  # Turns text into HTML using +markup+ style formatting.
  #
  # @param text [String] the text to format
  # @param markup [Symbol] examples are +:markdown+, +:textile+, +:rdoc+.
  #   To add a custom markup type, see {MarkupHelper}
  # @return [String] the HTML
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#57
  def htmlify(text, markup = T.unsafe(nil)); end

  # @return [String] HTMLified text as a single line (paragraphs removed)
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#184
  def htmlify_line(*args); end

  # Inserts an include link while respecting inlining
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#296
  def insert_include(text, markup = T.unsafe(nil)); end

  # Links to an extra file
  #
  # @param filename [String] the filename to link to
  # @param title [String] the title of the link
  # @param anchor [String] optional anchor
  # @return [String] the link to the file
  # @since 0.5.5
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#270
  def link_file(filename, title = T.unsafe(nil), anchor = T.unsafe(nil)); end

  # Include a file as a docstring in output
  #
  # @param file [String] the filename to include
  # @return [String] the file's contents
  # @since 0.7.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#282
  def link_include_file(file); end

  # Includes an object's docstring into output.
  #
  # @param obj [CodeObjects::Base] the object to include
  # @return [String] the object's docstring (no tags)
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#291
  def link_include_object(obj); end

  # Links to an object with an optional title
  #
  # @param obj [CodeObjects::Base] the object to link to
  # @param title [String] the title to use for the link
  # @return [String] the linked object
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#301
  def link_object(obj, title = T.unsafe(nil), anchor = T.unsafe(nil), relative = T.unsafe(nil)); end

  # Links to a URL
  #
  # @param url [String] the URL to link to
  # @param title [String] the optional title to display the link as
  # @param params [Hash] optional parameters for the link
  # @return [String] the linked URL
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#332
  def link_url(url, title = T.unsafe(nil), params = T.unsafe(nil)); end

  # source://yard//lib/yard/templates/helpers/html_helper.rb#400
  def mtime(_file); end

  # Returns the URL for an object.
  #
  # @param obj [String, CodeObjects::Base] the object (or object path) to link to
  # @param anchor [String] the anchor to link to
  # @param relative [Boolean] use a relative or absolute link
  # @return [String] the URL location of the object
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#368
  def mtime_url(obj, anchor = T.unsafe(nil), relative = T.unsafe(nil)); end

  # Resolves any text in the form of +{Name}+ to the object specified by
  # Name. Also supports link titles in the form +{Name title}+.
  #
  # @example Linking to an instance method
  #   resolve_links("{MyClass#method}") # => "<a href='...'>MyClass#method</a>"
  # @example Linking to a class with a title
  #   resolve_links("{A::B::C the C class}") # => "<a href='...'>the c class</a>"
  # @param text [String] the text to resolve links in
  # @return [String] HTML with linkified references
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#225
  def resolve_links(text); end

  # Formats the signature of method +meth+.
  #
  # @param meth [CodeObjects::MethodObject] the method object to list
  #   the signature of
  # @param link [Boolean] whether to link the method signature to the details view
  # @param show_extras [Boolean] whether to show extra meta-data (visibility, attribute info)
  # @param full_attr_name [Boolean] whether to show the full attribute name
  #   ("name=" instead of "name")
  # @return [String] the formatted method signature
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#529
  def signature(meth, link = T.unsafe(nil), show_extras = T.unsafe(nil), full_attr_name = T.unsafe(nil)); end

  # Get the return types for a method signature.
  #
  # @param meth [CodeObjects::MethodObject] the method object
  # @param link [Boolean] whether to link the types
  # @return [String] the signature types
  # @since 0.5.3
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#492
  def signature_types(meth, link = T.unsafe(nil)); end

  # Returns the URL for an object.
  #
  # @param obj [String, CodeObjects::Base] the object (or object path) to link to
  # @param anchor [String] the anchor to link to
  # @param relative [Boolean] use a relative or absolute link
  # @return [String] the URL location of the object
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#368
  def url_for(obj, anchor = T.unsafe(nil), relative = T.unsafe(nil)); end

  # Returns the URL for a specific file
  #
  # @param filename [String, CodeObjects::ExtraFileObject] the filename to link to
  # @param anchor [String] optional anchor
  # @return [String] the URL pointing to the file
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#407
  def url_for_file(filename, anchor = T.unsafe(nil)); end

  # Returns the URL for the frameset page
  #
  # @return [String] the URL pointing to the frames page
  # @since 0.8.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#434
  def url_for_frameset; end

  # Returns the URL for the alphabetic index page
  #
  # @return [String] the URL pointing to the first main page the
  #   user should see.
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#450
  def url_for_index; end

  # Returns the URL for a list type
  #
  # @param type [String, Symbol] the list type to generate a URL for
  # @return [String] the URL pointing to the list
  # @since 0.8.0
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#426
  def url_for_list(type); end

  # Returns the URL for the main page (README or alphabetic index)
  #
  # @return [String] the URL pointing to the first main page the
  #   user should see.
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#442
  def url_for_main; end

  private

  # Converts a {CodeObjects::MethodObject} into an overload object
  #
  # @since 0.5.3
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#609
  def convert_method_to_overload(meth); end

  # Parses code block's HTML attributes in order to detect the programming
  # language of what's enclosed in that code block.
  #
  # @param pre_html_attrs [String, nil] HTML attribute list of +pre+ element
  # @param code_html_attrs [String, nil] HTML attribute list of +code+
  #   element
  # @return [String, nil] detected programming language
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#664
  def detect_lang_in_codeblock_attributes(pre_html_attrs, code_html_attrs); end

  # Parses code blocks out of html and performs syntax highlighting
  # on code inside of the blocks.
  #
  # @param html [String] the html to search for code in
  # @return [String] highlighted html
  # @see #html_syntax_highlight
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#640
  def parse_codeblocks(html); end

  # Parses !!!lang out of codeblock, returning the codeblock language
  # followed by the source code.
  #
  # @param source [String] the source code whose language to determine
  # @return [Array(String, String)] the language, if any, and the
  #   remaining source
  # @since 0.7.5
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#624
  def parse_lang_for_codeblock(source); end

  # Converts a set of hash options into HTML attributes for a tag
  #
  # @param opts [Hash{String => String}] the tag options
  # @return [String] the tag attributes of an HTML tag
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#603
  def tag_attrs(opts = T.unsafe(nil)); end

  # Escapes a URL
  #
  # @param text [String] the URL
  # @return [String] the escaped URL
  #
  # source://yard//lib/yard/templates/helpers/html_helper.rb#31
  def urlencode(text); end

  class << self
    # Escapes a URL
    #
    # @param text [String] the URL
    # @return [String] the escaped URL
    #
    # source://yard//lib/yard/templates/helpers/html_helper.rb#31
    def urlencode(text); end
  end
end

# @private
#
# source://yard//lib/yard/templates/helpers/html_helper.rb#15
YARD::Templates::Helpers::HtmlHelper::ASCIIDOC_ATTRIBUTES = T.let(T.unsafe(nil), Hash)

# @private
#
# source://yard//lib/yard/templates/helpers/html_helper.rb#12
YARD::Templates::Helpers::HtmlHelper::URLMATCH = T.let(T.unsafe(nil), Regexp)

# Helper methods for syntax highlighting.
#
# source://yard//lib/yard/templates/helpers/html_syntax_highlight_helper.rb#6
module YARD::Templates::Helpers::HtmlSyntaxHighlightHelper
  include ::YARD::Templates::Helpers::ModuleHelper

  # Highlights Ruby source
  #
  # @param source [String] the Ruby source code
  # @return [String] the highlighted Ruby source
  #
  # source://yard//lib/yard/templates/helpers/html_syntax_highlight_helper.rb#12
  def html_syntax_highlight_ruby(source); end

  private

  # source://yard//lib/yard/templates/helpers/html_syntax_highlight_helper.rb#63
  def clean_token_object(token_obj); end

  # source://yard//lib/yard/templates/helpers/html_syntax_highlight_helper.rb#45
  def html_syntax_highlight_ruby_legacy(source); end

  # source://yard//lib/yard/templates/helpers/html_syntax_highlight_helper.rb#22
  def html_syntax_highlight_ruby_ripper(source); end
end

# Namespace for markup providers
#
# source://yard//lib/yard/autoload.rb#273
module YARD::Templates::Helpers::Markup; end

# source://yard//lib/yard/templates/helpers/markup/rdoc_markdown.rb#13
class YARD::Templates::Helpers::Markup::RDocMarkdown < ::YARD::Templates::Helpers::Markup::RDocMarkup
  # @return [RDocMarkdown] a new instance of RDocMarkdown
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markdown.rb#14
  def initialize(text); end

  # source://yard//lib/yard/templates/helpers/markup/rdoc_markdown.rb#18
  def fix_typewriter(html); end
end

# source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#12
class YARD::Templates::Helpers::Markup::RDocMarkup
  # @return [RDocMarkup] a new instance of RDocMarkup
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#41
  def initialize(text); end

  # Returns the value of attribute from_path.
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#35
  def from_path; end

  # Sets the attribute from_path
  #
  # @param value the value to set the attribute from_path to.
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#35
  def from_path=(_arg0); end

  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#50
  def to_html; end

  private

  # Don't allow -- to turn into &#8212; element. The chances of this being
  # some --option is far more likely than the typographical meaning.
  #
  # @todo Refactor into own SimpleMarkup subclass
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#87
  def fix_dash_dash(text); end

  # Fixes RDoc behaviour with ++ only supporting alphanumeric text.
  #
  # @todo Refactor into own SimpleMarkup subclass
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#66
  def fix_typewriter(text); end
end

# source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#12
YARD::Templates::Helpers::Markup::RDocMarkup::MARKUP = RDoc::Markup

# source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#13
class YARD::Templates::Helpers::Markup::RDocMarkupToHtml < ::RDoc::Markup::ToHtml
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#16
  def initialize; end

  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#100
  def accept_paragraph(*args); end

  # Returns the value of attribute from_path.
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#93
  def from_path; end

  # Sets the attribute from_path
  #
  # @param value the value to set the attribute from_path to.
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#93
  def from_path=(_arg0); end

  # Disable auto-link of URLs
  #
  # source://yard//lib/yard/templates/helpers/markup/rdoc_markup.rb#96
  def handle_special_HYPERLINK(special); end
end

# Helper methods for loading and managing markup types.
#
# source://yard//lib/yard/templates/helpers/markup_helper.rb#7
module YARD::Templates::Helpers::MarkupHelper
  # Attempts to load the first valid markup provider in {MARKUP_PROVIDERS}.
  # If a provider is specified, immediately try to load it.
  #
  # On success this sets `@markup_provider` and `@markup_class` to
  # the provider name and library constant class/module respectively for
  # the loaded provider.
  #
  # On failure this method will inform the user that no provider could be
  # found and exit the program.
  #
  # @return [Boolean] whether the markup provider was successfully loaded.
  #
  # source://yard//lib/yard/templates/helpers/markup_helper.rb#87
  def load_markup_provider(type = T.unsafe(nil)); end

  # Gets the markup provider class/module constant for a markup type
  # Call {#load_markup_provider} before using this method.
  #
  # @param type [Symbol] the markup type (:rdoc, :markdown, etc.)
  # @return [Class] the markup class
  #
  # source://yard//lib/yard/templates/helpers/markup_helper.rb#158
  def markup_class(type = T.unsafe(nil)); end

  # Strips any shebang lines on the file contents that pertain to
  # markup or preprocessing data.
  #
  # @deprecated Use {CodeObjects::ExtraFileObject#contents} instead
  # @return [String] the file contents minus any preprocessing tags
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/markup_helper.rb#149
  def markup_file_contents(contents); end

  # Checks for a shebang or looks at the file extension to determine
  # the markup type for the file contents. File extensions are registered
  # for a markup type in {MARKUP_EXTENSIONS}.
  #
  # A shebang should be on the first line of a file and be in the form:
  #
  #   #!markup_type
  #
  # Standard markup types are text, html, rdoc, markdown, textile
  #
  # @param contents [String] Unused. Was necessary prior to 0.7.0.
  #   Newer versions of YARD use {CodeObjects::ExtraFileObject#contents}
  # @return [Symbol] the markup type recognized for the file
  # @see MARKUP_EXTENSIONS
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/helpers/markup_helper.rb#133
  def markup_for_file(contents, filename); end

  # Gets the markup provider name for a markup type
  # Call {#load_markup_provider} before using this method.
  #
  # @param type [Symbol] the markup type (:rdoc, :markdown, etc.)
  # @return [Symbol] the markup provider name (usually the gem name of the library)
  #
  # source://yard//lib/yard/templates/helpers/markup_helper.rb#168
  def markup_provider(type = T.unsafe(nil)); end

  class << self
    # Clears the markup provider cache information. Mainly used for testing.
    #
    # @return [void]
    #
    # source://yard//lib/yard/templates/helpers/markup_helper.rb#11
    def clear_markup_cache; end

    # @private
    # @return [Hash{Symbol=>{(:provider,:class)=>Object}}] the cached markup providers
    # @since 0.6.4
    #
    # source://yard//lib/yard/templates/helpers/markup_helper.rb#18
    def markup_cache; end

    # @private
    # @return [Hash{Symbol=>{(:provider,:class)=>Object}}] the cached markup providers
    # @since 0.6.4
    #
    # source://yard//lib/yard/templates/helpers/markup_helper.rb#18
    def markup_cache=(_arg0); end
  end
end

# Returns a list of extensions for various markup types. To register
# extensions for a type, add them to the array of extensions for the
# type.
#
# @since 0.6.0
#
# source://yard//lib/yard/templates/helpers/markup_helper.rb#61
YARD::Templates::Helpers::MarkupHelper::MARKUP_EXTENSIONS = T.let(T.unsafe(nil), Hash)

# Contains the Regexp object that matches the shebang line of extra
# files to detect the markup type.
#
# source://yard//lib/yard/templates/helpers/markup_helper.rb#74
YARD::Templates::Helpers::MarkupHelper::MARKUP_FILE_SHEBANG = T.let(T.unsafe(nil), Regexp)

# The default list of markup providers for each markup type
#
# source://yard//lib/yard/templates/helpers/markup_helper.rb#24
YARD::Templates::Helpers::MarkupHelper::MARKUP_PROVIDERS = T.let(T.unsafe(nil), Hash)

# Helper methods for method objects.
#
# source://yard//lib/yard/templates/helpers/method_helper.rb#5
module YARD::Templates::Helpers::MethodHelper
  # @return [String] formatted arguments for a method
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#7
  def format_args(object); end

  # @return [String] formatted block if one exists
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#35
  def format_block(object); end

  # @return [String] formats source of an object
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#57
  def format_code(object, _show_lines = T.unsafe(nil)); end

  # @return [String] formats source code of a constant value
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#68
  def format_constant(value); end

  # @return [String] formats line numbers for source code of an object
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#50
  def format_lines(object); end

  # @return [String] formatted and linked return types for a method
  #
  # source://yard//lib/yard/templates/helpers/method_helper.rb#28
  def format_return_types(object); end
end

# Helper methods for managing module objects.
#
# source://yard//lib/yard/templates/helpers/module_helper.rb#6
module YARD::Templates::Helpers::ModuleHelper
  # Prunes the method listing by running the verifier and removing attributes/aliases
  #
  # @param list [Array<CodeObjects::Base>] a list of methods
  # @param hide_attributes [Boolean] whether to prune attribute methods from the list
  # @return [Array<CodeObjects::Base>] a pruned list of methods
  #
  # source://yard//lib/yard/templates/helpers/module_helper.rb#11
  def prune_method_listing(list, hide_attributes = T.unsafe(nil)); end
end

# Helper methods for text template formats.
#
# source://yard//lib/yard/templates/helpers/text_helper.rb#6
module YARD::Templates::Helpers::TextHelper
  # @return [String] aligns text to the right
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#39
  def align_right(text, spacer = T.unsafe(nil), col = T.unsafe(nil)); end

  # @return [String] escapes text
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#8
  def h(text); end

  # @return [String] returns a horizontal rule for output
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#45
  def hr(col = T.unsafe(nil), sep = T.unsafe(nil)); end

  # @return [String] indents +text+ by +len+ characters.
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#29
  def indent(text, len = T.unsafe(nil)); end

  # @return [String] the formatted signature for a method
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#50
  def signature(meth); end

  # @return [String] aligns a title to the right
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#34
  def title_align_right(text, col = T.unsafe(nil)); end

  # @return [String] wraps text at +col+ columns.
  #
  # source://yard//lib/yard/templates/helpers/text_helper.rb#24
  def wrap(text, col = T.unsafe(nil)); end

  private

  # source://yard//lib/yard/templates/helpers/text_helper.rb#98
  def resolve_links(text); end
end

# Helpers for UML template format
#
# source://yard//lib/yard/templates/helpers/uml_helper.rb#5
module YARD::Templates::Helpers::UMLHelper
  # Formats the path of an object for Graphviz syntax
  #
  # @param object [CodeObjects::Base] an object to format the path of
  # @return [String] the encoded path
  #
  # source://yard//lib/yard/templates/helpers/uml_helper.rb#20
  def format_path(object); end

  # Encodes text in escaped Graphviz syntax
  #
  # @param text [String] text to encode
  # @return [String] the encoded text
  #
  # source://yard//lib/yard/templates/helpers/uml_helper.rb#27
  def h(text); end

  # Tidies data by formatting and indenting text
  #
  # @param data [String] pre-formatted text
  # @return [String] tidied text.
  #
  # source://yard//lib/yard/templates/helpers/uml_helper.rb#34
  def tidy(data); end

  # Official UML visibility prefix syntax for an object given its visibility
  #
  # @param object [CodeObjects::Base] the object to retrieve visibility for
  # @return [String] the UML visibility prefix
  #
  # source://yard//lib/yard/templates/helpers/uml_helper.rb#9
  def uml_visibility(object); end
end

# Abstracts the structure for a section and its subsections into an ordered
# list of sections and subsections.
#
# @since 0.6.0
#
# source://yard//lib/yard/templates/section.rb#7
class YARD::Templates::Section < ::Array
  # @return [Section] a new instance of Section
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#10
  def initialize(name, *args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#45
  def <<(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#34
  def ==(other); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#21
  def [](*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#74
  def any(item); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#15
  def dup; end

  # @return [Boolean]
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#30
  def eql?(other); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#54
  def inspect; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#8
  def name; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#8
  def name=(_arg0); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#60
  def place(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#45
  def push(*args); end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#64
  def to_a; end

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#50
  def unshift(*args); end

  private

  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/section.rb#84
  def parse_sections(args); end
end

# source://yard//lib/yard/templates/template.rb#6
module YARD::Templates::Template
  include ::YARD::Templates::ErbCache
  include ::YARD::Templates::Helpers::BaseHelper
  include ::YARD::Templates::Helpers::MethodHelper

  mixes_in_class_methods ::YARD::Templates::Template::ClassMethods

  # source://yard//lib/yard/templates/template.rb#186
  def initialize(opts = T.unsafe(nil)); end

  # Loads a template specified by path. If +:template+ or +:format+ is
  # specified in the {#options} hash, they are prepended and appended
  # to the path respectively.
  #
  # @param path [Array<String, Symbol>] the path of the template
  # @return [Template] the loaded template module
  #
  # source://yard//lib/yard/templates/template.rb#204
  def T(*path); end

  # Returns the value of attribute class.
  #
  # source://yard//lib/yard/templates/template.rb#7
  def class; end

  # Sets the attribute class
  #
  # @param value the value to set the attribute class to.
  #
  # source://yard//lib/yard/templates/template.rb#7
  def class=(_arg0); end

  # @param section [String, Symbol] the section name
  # @return [String] the contents of the ERB rendered section
  # @yield calls subsections to be rendered
  #
  # source://yard//lib/yard/templates/template.rb#285
  def erb(section, &block); end

  # Returns the contents of a file. If +allow_inherited+ is set to +true+,
  # use +{{{__super__}}}+ inside the file contents to insert the contents
  # of the file from an inherited template. For instance, if +templates/b+
  # inherits from +templates/a+ and file "test.css" exists in both directories,
  # both file contents can be retrieved by having +templates/b/test.css+ look
  # like:
  #
  #   {{{__super__}}}
  #   ...
  #   body { css styles here }
  #   p.class { other styles }
  #
  # @param basename [String] the name of the file
  # @param allow_inherited [Boolean] whether inherited templates can
  #   be inserted with +{{{__super__}}}+
  # @raise [ArgumentError]
  # @return [String] the contents of a file identified by +basename+. All
  #   template paths (including any mixed in templates) are searched for
  #   the file
  # @see ClassMethods#find_file
  # @see ClassMethods#find_nth_file
  #
  # source://yard//lib/yard/templates/template.rb#312
  def file(basename, allow_inherited = T.unsafe(nil)); end

  # Initialization called on the template. Override this in a 'setup.rb'
  # file in the template's path to implement a template
  #
  # @example A default set of sections
  #   def init
  #   sections :section1, :section2, [:subsection1, :etc]
  #   end
  # @see #sections
  #
  # source://yard//lib/yard/templates/template.rb#239
  def init; end

  # source://yard//lib/yard/templates/template.rb#342
  def inspect; end

  # Returns the value of attribute options.
  #
  # source://yard//lib/yard/templates/template.rb#8
  def options; end

  # source://yard//lib/yard/templates/template.rb#337
  def options=(value); end

  # Runs a template on +sects+ using extra options. This method should
  # not be called directly. Instead, call the class method {ClassMethods#run}
  #
  # @param opts [Hash, nil] any extra options to apply to sections
  # @param sects [Section, Array] a section list of sections to render
  # @param start_at [Fixnum] the index in the section list to start from
  # @param break_first [Boolean] if true, renders only the first section
  # @return [String] the rendered sections joined together
  # @yield [opts] calls for the subsections to be rendered
  # @yieldparam opts [Hash] any extra options to yield
  #
  # source://yard//lib/yard/templates/template.rb#252
  def run(opts = T.unsafe(nil), sects = T.unsafe(nil), start_at = T.unsafe(nil), break_first = T.unsafe(nil), &block); end

  # Returns the value of attribute section.
  #
  # source://yard//lib/yard/templates/template.rb#7
  def section; end

  # Sets the attribute section
  #
  # @param value the value to set the attribute section to.
  #
  # source://yard//lib/yard/templates/template.rb#7
  def section=(_arg0); end

  # Sets the sections (and subsections) to be rendered for the template
  #
  # @example Sets a set of erb sections
  #   sections :a, :b, :c # searches for a.erb, b.erb, c.erb
  # @example Sets a set of method and erb sections
  #   sections :a, :b, :c # a is a method, the rest are erb files
  # @example Sections with subsections
  #   sections :header, [:name, :children]
  #   # the above will call header.erb and only renders the subsections
  #   # if they are yielded by the template (see #yieldall)
  # @param args [Array<Symbol, String, Template, Array>] the sections
  #   to use to render the template. For symbols and strings, the
  #   section will be executed as a method (if one exists), or rendered
  #   from the file "name.erb" where name is the section name. For
  #   templates, they will have {Template::ClassMethods#run} called on them.
  #   Any subsections can be yielded to using yield or {#yieldall}
  #
  # source://yard//lib/yard/templates/template.rb#226
  def sections(*args); end

  # Calls the ERB file from the last inherited template with {#section}.erb
  #
  # @param sect [Symbol, String] if provided, uses a specific section name
  # @return [String] the rendered ERB file in any of the inherited template
  #   paths.
  #
  # source://yard//lib/yard/templates/template.rb#330
  def superb(sect = T.unsafe(nil), &block); end

  # Yields all subsections with any extra options
  #
  # @param opts [Hash] extra options to be applied to subsections
  #
  # source://yard//lib/yard/templates/template.rb#278
  def yieldall(opts = T.unsafe(nil), &block); end

  protected

  # source://yard//lib/yard/templates/template.rb#348
  def erb_file_for(section); end

  # source://yard//lib/yard/templates/template.rb#352
  def erb_with(content, filename = T.unsafe(nil)); end

  private

  # source://yard//lib/yard/templates/template.rb#399
  def add_options(opts = T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://yard//lib/yard/templates/template.rb#378
  def cache(section); end

  # source://yard//lib/yard/templates/template.rb#388
  def cache_filename(section); end

  # source://yard//lib/yard/templates/template.rb#364
  def render_section(section, &block); end

  # source://yard//lib/yard/templates/template.rb#393
  def set_ivars; end

  # source://yard//lib/yard/templates/template.rb#412
  def with_section; end

  class << self
    # Extra includes are mixins that are included after a template is created. These
    # mixins can be registered by plugins to operate on templates and override behaviour.
    #
    # Note that this array can be filled with modules or proc objects. If a proc object
    # is given, the proc will be called with the {Template#options} hash containing
    # relevant template information like the object, format, and more. The proc should
    # return a module or nil if there is none.
    #
    # @example Adding in extra mixins to include on a template
    #   Template.extra_includes << MyHelper
    # @example Conditionally including a mixin if the format is html
    #   Template.extra_includes << proc {|opts| MyHelper if opts.format == :html }
    # @return [Array<Module, Proc>] a list of modules to be automatically included
    #   into any new template module
    #
    # source://yard//lib/yard/templates/template.rb#25
    def extra_includes; end

    # Extra includes are mixins that are included after a template is created. These
    # mixins can be registered by plugins to operate on templates and override behaviour.
    #
    # Note that this array can be filled with modules or proc objects. If a proc object
    # is given, the proc will be called with the {Template#options} hash containing
    # relevant template information like the object, format, and more. The proc should
    # return a module or nil if there is none.
    #
    # @example Adding in extra mixins to include on a template
    #   Template.extra_includes << MyHelper
    # @example Conditionally including a mixin if the format is html
    #   Template.extra_includes << proc {|opts| MyHelper if opts.format == :html }
    # @return [Array<Module, Proc>] a list of modules to be automatically included
    #   into any new template module
    #
    # source://yard//lib/yard/templates/template.rb#25
    def extra_includes=(_arg0); end

    # Includes the {extra_includes} modules into the template object.
    #
    # @param template [Template] the template object to mixin the extra includes.
    # @param options [SymbolHash] the options hash containing all template information
    # @return [void]
    #
    # source://yard//lib/yard/templates/template.rb#38
    def include_extra(template, options); end

    # @private
    # @private
    #
    # source://yard//lib/yard/templates/template.rb#29
    def included(klass); end
  end
end

# source://yard//lib/yard/templates/template.rb#59
module YARD::Templates::Template::ClassMethods
  # source://yard//lib/yard/templates/template.rb#81
  def initialize(path, full_paths); end

  # Alias for creating a {Section} with arguments
  #
  # @see Section#initialize
  # @since 0.6.0
  #
  # source://yard//lib/yard/templates/template.rb#149
  def S(*args); end

  # Alias for creating {Engine.template}.
  #
  # source://yard//lib/yard/templates/template.rb#142
  def T(*path); end

  # Searches for a file identified by +basename+ in the template's
  # path as well as any mixed in template paths. Equivalent to calling
  # {ClassMethods#find_nth_file} with index of 1.
  #
  # @param basename [String] the filename to search for
  # @return [String] the full path of a file on disk with filename
  #   +basename+ in one of the template's paths.
  # @see find_nth_file
  #
  # source://yard//lib/yard/templates/template.rb#98
  def find_file(basename); end

  # Searches for the nth file (where n = +index+) identified
  # by basename in the template's path and any mixed in template paths.
  #
  # @param basename [String] the filename to search for
  # @param index [Fixnum] the nth existing file to return
  # @return [String] the full path of the nth file on disk with
  #   filename +basename+ in one of the template paths
  #
  # source://yard//lib/yard/templates/template.rb#109
  def find_nth_file(basename, index = T.unsafe(nil)); end

  # Returns the value of attribute full_path.
  #
  # source://yard//lib/yard/templates/template.rb#60
  def full_path; end

  # Sets the attribute full_path
  #
  # @param value the value to set the attribute full_path to.
  #
  # source://yard//lib/yard/templates/template.rb#60
  def full_path=(_arg0); end

  # @note This method caches path results. Paths should not be modified
  #   after this method is called; call {#reset_full_paths} to reset cache.
  # @return [Array<String>] a list of full paths
  #
  # source://yard//lib/yard/templates/template.rb#65
  def full_paths; end

  # @return [Boolean]
  #
  # source://yard//lib/yard/templates/template.rb#122
  def is_a?(klass); end

  # Creates a new template object to be rendered with {Template#run}
  #
  # source://yard//lib/yard/templates/template.rb#128
  def new(*args); end

  # Returns the value of attribute path.
  #
  # source://yard//lib/yard/templates/template.rb#60
  def path; end

  # Sets the attribute path
  #
  # @param value the value to set the attribute path to.
  #
  # source://yard//lib/yard/templates/template.rb#60
  def path=(_arg0); end

  # Resets cache for {#full_paths}
  #
  # source://yard//lib/yard/templates/template.rb#77
  def reset_full_paths; end

  # source://yard//lib/yard/templates/template.rb#135
  def run(*args); end

  private

  # source://yard//lib/yard/templates/template.rb#170
  def include_inherited(full_paths); end

  # source://yard//lib/yard/templates/template.rb#157
  def include_parent; end

  # source://yard//lib/yard/templates/template.rb#176
  def load_setup_rb; end
end

# An Options class containing default options for base template rendering. For
# options specific to generation of HTML output, see {CLI::YardocOptions}.
#
# @see CLI::YardocOptions
#
# source://yard//lib/yard/templates/template_options.rb#9
class YARD::Templates::TemplateOptions < ::YARD::Options
  # @return [OpenStruct] an open struct containing any global state across all
  #   generated objects in a template.
  #
  # source://yard//lib/yard/options.rb#82
  def __globals; end

  # @return [String] the default return type for a method with no return tags
  #
  # source://yard//lib/yard/options.rb#82
  def default_return; end

  # @return [String] the default return type for a method with no return tags
  #
  # source://yard//lib/yard/options.rb#82
  def default_return=(_arg0); end

  # @example A list of mixin path names (including wildcards)
  #   opts.embed_mixins #=> ['ClassMethods', '*Helper', 'YARD::*']
  # @return [Array<String>] an array of module name wildcards to embed into
  #   class documentation as if their methods were defined directly in the class.
  #   Useful for modules like ClassMethods. If the name contains '::', the module
  #   is matched against the full mixin path, otherwise only the module name is used.
  #
  # source://yard//lib/yard/options.rb#82
  def embed_mixins; end

  # @example A list of mixin path names (including wildcards)
  #   opts.embed_mixins #=> ['ClassMethods', '*Helper', 'YARD::*']
  # @return [Array<String>] an array of module name wildcards to embed into
  #   class documentation as if their methods were defined directly in the class.
  #   Useful for modules like ClassMethods. If the name contains '::', the module
  #   is matched against the full mixin path, otherwise only the module name is used.
  #
  # source://yard//lib/yard/options.rb#82
  def embed_mixins=(_arg0); end

  # @param mixin [CodeObjects::Base] accepts any code object, but returns
  #   nil unless the object is a module.
  # @return [Boolean] whether a mixin matches the embed_mixins list
  # @return [nil] if the mixin is not a module object
  #
  # source://yard//lib/yard/templates/template_options.rb#77
  def embed_mixins_match?(mixin); end

  # @return [Symbol] the template output format
  #
  # source://yard//lib/yard/options.rb#82
  def format; end

  # @return [Symbol] the template output format
  #
  # source://yard//lib/yard/options.rb#82
  def format=(_arg0); end

  # @return [OpenStruct] an open struct containing any global state across all
  #   generated objects in a template.
  #
  # source://yard//lib/yard/options.rb#82
  def globals; end

  # @return [OpenStruct] an open struct containing any global state across all
  #   generated objects in a template.
  #
  # source://yard//lib/yard/options.rb#82
  def globals=(_arg0); end

  # @return [Boolean] whether void methods should show "void" in their signature
  #
  # source://yard//lib/yard/options.rb#82
  def hide_void_return; end

  # @return [Boolean] whether void methods should show "void" in their signature
  #
  # source://yard//lib/yard/options.rb#82
  def hide_void_return=(_arg0); end

  # @return [Boolean] whether code blocks should be syntax highlighted
  #
  # source://yard//lib/yard/options.rb#82
  def highlight; end

  # @return [Boolean] whether code blocks should be syntax highlighted
  #
  # source://yard//lib/yard/options.rb#82
  def highlight=(_arg0); end

  # @return [Boolean] whether the page is the "index"
  #
  # source://yard//lib/yard/templates/template_options.rb#63
  def index; end

  # @return [Boolean] whether the page is the "index"
  #
  # source://yard//lib/yard/templates/template_options.rb#63
  def index=(_arg0); end

  # @return [Symbol] the markup format to use when parsing docstrings
  #
  # source://yard//lib/yard/options.rb#82
  def markup; end

  # @return [Symbol] the markup format to use when parsing docstrings
  #
  # source://yard//lib/yard/options.rb#82
  def markup=(_arg0); end

  # @return [Class] the markup provider class for the markup format
  #
  # source://yard//lib/yard/templates/template_options.rb#29
  def markup_provider; end

  # @return [Class] the markup provider class for the markup format
  #
  # source://yard//lib/yard/templates/template_options.rb#29
  def markup_provider=(_arg0); end

  # @deprecated use {#highlight} instead.
  # @return [Boolean] whether highlighting should be ignored
  #
  # source://yard//lib/yard/templates/template_options.rb#56
  def no_highlight; end

  # source://yard//lib/yard/templates/template_options.rb#57
  def no_highlight=(value); end

  # @return [CodeObjects::Base] the main object being generated in the template
  #
  # source://yard//lib/yard/templates/template_options.rb#37
  def object; end

  # @return [CodeObjects::Base] the main object being generated in the template
  #
  # source://yard//lib/yard/templates/template_options.rb#37
  def object=(_arg0); end

  # @return [CodeObjects::Base] the owner of the generated object
  #
  # source://yard//lib/yard/templates/template_options.rb#40
  def owner; end

  # @return [CodeObjects::Base] the owner of the generated object
  #
  # source://yard//lib/yard/templates/template_options.rb#40
  def owner=(_arg0); end

  # @return [String] the title of a given page
  #
  # source://yard//lib/yard/templates/template_options.rb#60
  def page_title; end

  # @return [String] the title of a given page
  #
  # source://yard//lib/yard/templates/template_options.rb#60
  def page_title=(_arg0); end

  # @return [Boolean] whether serialization should be performed
  #
  # source://yard//lib/yard/options.rb#82
  def serialize; end

  # @return [Boolean] whether serialization should be performed
  #
  # source://yard//lib/yard/options.rb#82
  def serialize=(_arg0); end

  # @return [Serializers::Base] the serializer used to generate links and serialize
  #   output. Serialization output only occurs if {#serialize} is +true+.
  #
  # source://yard//lib/yard/templates/template_options.rb#50
  def serializer; end

  # @return [Serializers::Base] the serializer used to generate links and serialize
  #   output. Serialization output only occurs if {#serialize} is +true+.
  #
  # source://yard//lib/yard/templates/template_options.rb#50
  def serializer=(_arg0); end

  # @return [Symbol] the template name used to render output
  #
  # source://yard//lib/yard/options.rb#82
  def template; end

  # @return [Symbol] the template name used to render output
  #
  # source://yard//lib/yard/options.rb#82
  def template=(_arg0); end

  # @return [Symbol] the template type used to generate output
  #
  # source://yard//lib/yard/templates/template_options.rb#43
  def type; end

  # @return [Symbol] the template type used to generate output
  #
  # source://yard//lib/yard/templates/template_options.rb#43
  def type=(_arg0); end

  # @return [Verifier] the verifier object
  #
  # source://yard//lib/yard/templates/template_options.rb#88
  def verifier; end

  # @return [Verifier] the verifier object
  #
  # source://yard//lib/yard/templates/template_options.rb#88
  def verifier=(_arg0); end
end

# source://yard//lib/yard/version.rb#5
YARD::VERSION = T.let(T.unsafe(nil), String)

# Similar to a Proc, but runs a set of Ruby expressions using a small
# DSL to make tag lookups easier.
#
# The syntax is as follows:
# * All syntax is Ruby compatible
# * +object+ (+o+ for short) exist to access the object being verified
# * +@TAGNAME+ is translated into +object.tag('TAGNAME')+
# * +@@TAGNAME+ is translated into +object.tags('TAGNAME')+
# * +object+ can be omitted as target for method calls (it is implied)
#
# @example Create a verifier to check for objects that don't have @private tags
#   verifier = Verifier.new('!@private')
#   verifier.call(object) # => true (no @private tag)
# @example Create a verifier to find any return tag with an empty description
#   Verifier.new('@return.text.empty?')
#   # Equivalent to:
#   Verifier.new('object.tag(:return).text.empty?')
# @example Check if there are any @param tags
#   Verifier.new('@@param.empty?')
#   # Equivalent to:
#   Verifier.new('object.tags(:param).empty?')
# @example Using +object+ or +o+ to look up object attributes directly
#   Verifier.new('object.docstring == "hello world"')
#   # Equivalent to:
#   Verifier.new('o.docstring == "hello world"')
# @example Without using +object+ or +o+
#   Verifier.new('tag(:return).size == 1 || has_tag?(:author)')
# @example Specifying multiple expressions
#   Verifier.new('@return', '@param', '@yield')
#   # Equivalent to:
#   Verifier.new('@return && @param && @yield')
#
# source://yard//lib/yard/verifier.rb#34
class YARD::Verifier
  # Creates a verifier from a set of expressions
  #
  # @param expressions [Array<String>] a list of Ruby expressions to
  #   parse.
  # @return [Verifier] a new instance of Verifier
  #
  # source://yard//lib/yard/verifier.rb#48
  def initialize(*expressions); end

  # Adds a set of expressions and recompiles the verifier
  #
  # @param expressions [Array<String>] a list of expressions
  # @return [void]
  # @since 0.5.6
  #
  # source://yard//lib/yard/verifier.rb#58
  def add_expressions(*expressions); end

  # Tests the expressions on the object.
  #
  # @note If the object is a {CodeObjects::Proxy} the result will always be true.
  # @param object [CodeObjects::Base] the object to verify
  # @return [Boolean] the result of the expressions
  #
  # source://yard//lib/yard/verifier.rb#76
  def call(object); end

  # @return [Array<String>] a list of all expressions the verifier checks for
  # @since 0.5.6
  #
  # source://yard//lib/yard/verifier.rb#37
  def expressions; end

  # source://yard//lib/yard/verifier.rb#39
  def expressions=(value); end

  # Passes any method calls to the object from the {#call}
  #
  # source://yard//lib/yard/verifier.rb#63
  def method_missing(sym, *args, &block); end

  # Runs a list of objects against the verifier and returns the subset
  # of verified objects.
  #
  # @param list [Array<CodeObjects::Base>] a list of code objects
  # @return [Array<CodeObjects::Base>] a list of code objects that match
  #   the verifier.
  #
  # source://yard//lib/yard/verifier.rb#91
  def run(list); end

  protected

  # @return [CodeObjects::Base] the current object being tested
  #
  # source://yard//lib/yard/verifier.rb#98
  def o; end

  # @return [CodeObjects::Base] the current object being tested
  #
  # source://yard//lib/yard/verifier.rb#98
  def object; end

  private

  # Creates the +__execute+ method by evaluating the expressions
  # as Ruby code
  #
  # @return [void]
  #
  # source://yard//lib/yard/verifier.rb#130
  def create_method_from_expressions; end

  # Modifies nil to not throw NoMethodErrors. This allows
  # syntax like object.tag(:return).text to work if the #tag
  # call returns nil, which means users don't need to perform
  # stringent nil checking
  #
  # @return [void]
  #
  # source://yard//lib/yard/verifier.rb#112
  def modify_nilclass; end

  # Parses a single expression, handling some of the DSL syntax.
  #
  # The syntax "@tag" should be turned into object.tag(:tag),
  # and "@@tag" should be turned into object.tags(:tag)
  #
  # @return [String] the parsed expression
  #
  # source://yard//lib/yard/verifier.rb#145
  def parse_expression(expr); end

  # Returns the state of NilClass back to normal
  #
  # @return [void]
  #
  # source://yard//lib/yard/verifier.rb#120
  def unmodify_nilclass; end
end

# @private
#
# source://yard//lib/yard/verifier.rb#104
YARD::Verifier::NILCLASS_METHODS = T.let(T.unsafe(nil), Array)
