# Summary

* [Style](style/README.md)
    * [Whitespace](style/whitespace.md)
    * [Comments](style/comments.md)
    * [Braces, semicolons, commas](style/braces.md)
    * [Naming](style/naming/README.md)
        * [Ownership variants](style/naming/ownership.md)
        * [Containers/wrappers](style/naming/containers.md)
        * [Conversions](style/naming/conversions.md)
        * [Iterators](style/naming/iterators.md)
    * [Imports](style/imports.md)
    * [Organization](style/organization.md)
* [Guidelines by Rust feature](features/README.md)
    * [Let binding](features/let.md)
    * [Pattern matching](features/match.md)
    * [Loops](features/loops.md)
    * [Functions and methods](features/functions-and-methods/README.md)
        * [Input](features/functions-and-methods/input.md)
        * [Output](features/functions-and-methods/output.md)
        * [For convenience](features/functions-and-methods/convenience.md)
    * [Types](features/types/README.md)
        * [Conversions](features/types/conversions.md)
        * [The newtype pattern](features/types/newtype.md)
    * [Traits](features/traits/README.md)
        * [For generics](features/traits/generics.md)
        * [For objects](features/traits/objects.md)
        * [For overloading](features/traits/overloading.md)
        * [For extensions](features/traits/extensions.md)
        * [For reuse](features/traits/reuse.md)
        * [Common traits](features/traits/common.md)
    * [Modules](features/modules.md)
    * [Crates](features/crates.md)
* [Ownership and resources](ownership/README.md)
    * [Constructors](ownership/constructors.md)
    * [Builders](ownership/builders.md)
    * [Destructors](ownership/destructors.md)
    * [RAII](ownership/raii.md)
    * [Cells and smart pointers](ownership/cell-smart.md)
* [Errors](errors/README.md)
    * [Signaling](errors/signaling.md)
    * [Handling](errors/handling.md)
    * [Propagation](errors/propagation.md)
    * [Ergonomics](errors/ergonomics.md)
* [Safety and guarantees](safety/README.md)
    * [Using unsafe](safety/unsafe.md)
    * [Library guarantees](safety/lib-guarantees.md)
* [Testing](testing/README.md)
    * [Unit testing](testing/unit.md)
* [FFI, platform-specific code](platform.md)
* [APIs for a changing Rust](changing/README.md)
    * [Pre-1.0 changes](changing/pre-1-0.md)
    * [Post-1.0 changes](changing/post-1-0.md)
    * [Timing unclear](changing/unclear.md)
