# Security policy

## Reporting a vulnerability

We love responsible reports of (potential) security issues in Zulip,
whether in the latest release or our development branch.

Our security contact is security@zulip.com. Reporters should expect a
response within 24 hours.

Please include details on the issue and how you'd like to be credited
in our release notes when we publish the fix.

Our [security model][security-model] document may be a helpful
resource.

## Security announcements

We send security announcements to our [announcement mailing
list](https://groups.google.com/g/zulip-announce). If you are running
Zulip in production, you should subscribe, by clicking "Join group" at
the top of that page.

## Supported versions

Zulip provides security support for the latest major release, in the
form of minor security/maintenance releases.

We work hard to make [upgrades][upgrades] reliable, so that there's no
reason to run older major releases.

See also our documentation on the [Zulip release
lifecycle][release-lifecycle].

[security-model]: https://zulip.readthedocs.io/en/latest/production/security-model.html
[upgrades]: https://zulip.readthedocs.io/en/stable/production/upgrade.html#upgrading-to-a-release
[release-lifecycle]: https://zulip.readthedocs.io/en/latest/overview/release-lifecycle.html
