# Generated by Django 4.2.8 on 2024-01-25 05:49

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps
from django.db.models import F


def update_legacy_plan_next_invoice_date(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    CustomerPlan = apps.get_model("corporate", "CustomerPlan")
    CustomerPlan.TIER_SELF_HOSTED_LEGACY = 101

    # For legacy plans, set next_invoice_date = end_date.
    CustomerPlan.objects.filter(tier=CustomerPlan.TIER_SELF_HOSTED_LEGACY).update(
        next_invoice_date=F("end_date")
    )


class Migration(migrations.Migration):
    dependencies = [
        ("corporate", "0034_customer_discount_required_tier"),
    ]

    operations = [
        migrations.RunPython(update_legacy_plan_next_invoice_date),
    ]
