# Zulip Code of Conduct

Like the technical community as a whole, the Zulip team and community is
made up of a mixture of professionals and volunteers from all over the
world, working on every aspect of the mission, including mentorship,
teaching, and connecting people.

Diversity is one of our huge strengths, but it can also lead to
communication issues and unhappiness. To that end, we have a few ground
rules that we ask people to adhere to. This code applies equally to
founders, mentors, and those seeking help and guidance.

This isn't an exhaustive list of things that you can't do. Rather, take it
in the spirit in which it's intended --- a guide to make it easier to enrich
all of us and the technical communities in which we participate.

## Expected behavior

The following behaviors are expected and requested of all community members:

- Participate. In doing so, you contribute to the health and longevity of
  the community.
- Exercise consideration and respect in your speech and actions.
- Attempt collaboration before conflict. Assume good faith.
- Refrain from demeaning, discriminatory, or harassing behavior and speech.
- Take action or alert community leaders if you notice a dangerous
  situation, someone in distress, or violations of this code, even if they
  seem inconsequential.
- Community event venues may be shared with members of the public; be
  respectful to all patrons of these locations.

## Unacceptable behavior

The following behaviors are considered harassment and are unacceptable
within the Zulip community:

- Jokes or derogatory language that singles out members of any race,
  ethnicity, culture, national origin, color, immigration status, social and
  economic class, educational level, language proficiency, sex, sexual
  orientation, gender identity and expression, age, size, family status,
  political belief, religion, and mental and physical ability.
- Violence, threats of violence, or violent language directed against
  another person.
- Disseminating or threatening to disseminate another person's personal
  information.
- Personal insults of any sort.
- Posting or displaying sexually explicit or violent material.
- Inappropriate photography or recording.
- Deliberate intimidation, stalking, or following (online or in person).
- Unwelcome sexual attention. This includes sexualized comments or jokes,
  inappropriate touching or groping, and unwelcomed sexual advances.
- Sustained disruption of community events, including talks and
  presentations.
- Advocating for, or encouraging, any of the behaviors above.

## Reporting and enforcement

Harassment and other code of conduct violations reduce the value of the
community for everyone. If someone makes you or anyone else feel unsafe or
unwelcome, please report it to the community organizers at
zulip-code-of-conduct@googlegroups.com as soon as possible. You can make a
report either personally or anonymously.

If a community member engages in unacceptable behavior, the community
organizers may take any action they deem appropriate, up to and including a
temporary ban or permanent expulsion from the community without warning (and
without refund in the case of a paid event).

If someone outside the development community (e.g., a user of the Zulip
software) engages in unacceptable behavior that affects someone in the
community, we still want to know. Even if we don't have direct control over
the violator, the community organizers can still support the people
affected, reduce the chance of a similar violation in the future, and take
any direct action we can.

The nature of reporting means it can only help after the fact. If you see
something you can do while a violation is happening, do it. A lot of the
harms of harassment and other violations can be mitigated by the victim
knowing that the other people present are on their side.

All reports will be kept confidential. In some cases, we may determine that a
public statement will need to be made. In such cases, the identities of all
victims and reporters will remain confidential unless those individuals
instruct us otherwise.

## Scope

We expect all community participants (contributors, paid or otherwise,
sponsors, and other guests) to abide by this Code of Conduct in all
community venues, online and in-person, as well as in all private
communications pertaining to community business.

This Code of Conduct and its related procedures also applies to unacceptable
behavior occurring outside the scope of community activities when such
behavior has the potential to adversely affect the safety and well-being of
community members.

## License and attribution

This Code of Conduct is adapted from the
[Django Code of Conduct](https://www.djangoproject.com/conduct/), and is
under a
[Creative Commons BY-SA](https://creativecommons.org/licenses/by-sa/4.0/)
license.

## Moderating the Zulip community

Anyone can help moderate the Zulip community by helping make sure that folks are
aware of the [community guidelines](https://zulip.com/development-community/)
and this Code of Conduct, and that we maintain a positive and respectful
atmosphere.

Here are some guidelines for you how can help:

- Be friendly! Welcoming folks, thanking them for their feedback, ideas and effort,
  and just trying to keep the atmosphere warm make the whole community function
  more smoothly. New participants who feel accepted, listened to and respected
  are likely to treat others the same way.

- Be familiar with the [community
  guidelines](https://zulip.com/development-community/), and cite them liberally
  when a user violates them. Be polite but firm. Some examples:

  - @user please note that there is no need to @-mention @\_**Tim Abbott** when
    you ask a question. As noted in the [guidelines for this
    community](https://zulip.com/development-community/):

    > Use @-mentions sparingly… there is generally no need to @-mention a
    > core contributor unless you need their timely attention.

  - @user, please keep in mind the following [community
    guideline](https://zulip.com/development-community/):

    > Don’t ask the same question in multiple places. Moderators read every
    > public stream, and make sure every question gets a reply.

    I’ve gone ahead and moved the other copy of this message to this thread.

  - If asked a question in a direct message that is better discussed in a public
    stream:
    > Hi @user! Please start by reviewing
    > https://zulip.com/development-community/#community-norms to learn how to
    > get help in this community.

- Users sometimes think chat.zulip.org is a testing instance. When this happens,
  kindly direct them to use the **#test here** stream.

- If you see a message that’s posted in the wrong place, go ahead and move it if
  you have permissions to do so, even if you don’t plan to respond to it.
  Leaving the “Send automated notice to new topic” option enabled helps make it
  clear what happened to the person who sent the message.

  If you are responding to a message that's been moved, mention the user in your
  reply, so that the mention serves as a notification of the new location for
  their conversation.

- If a user is posting spam, please report it to an administrator. They will:

  - Change the user's name to `<name> (spammer)` and deactivate them.
  - Delete any spam messages they posted in public streams.

- We care very much about maintaining a respectful tone in our community. If you
  see someone being mean or rude, point out that their tone is inappropriate,
  and ask them to communicate their perspective in a respectful way in the
  future. If you don’t feel comfortable doing so yourself, feel free to ask a
  member of Zulip's core team to take care of the situation.

- Try to assume the best intentions from others (given the range of
  possibilities presented by their visible behavior), and stick with a friendly
  and positive tone even when someone’s behavior is poor or disrespectful.
  Everyone has bad days and stressful situations that can result in them
  behaving not their best, and while we should be firm about our community
  rules, we should also enforce them with kindness.
