# Asking great questions

A well-formed question helps you learn, respects the person answering, and makes
efficient use of time for everyone involved. Asking the right question, to the
right person, in the right way, at the right time, is a skill which requires a
lifetime of fine-tuning. This page offers some guidelines and resources that the
[Zulip community](https://zulip.com/development-community/) has found helpful in this pursuit.

## Where to ask your question

It is almost always best to ask questions and have a conversation in a public
channel, rather than in direct messages. You’ll get better and faster answers
since many people can help, and it makes it possible for others to benefit from
the discussion.

The [Zulip community
guide](https://zulip.com/development-community/#where-do-i-send-my-message)
offers guidelines on how the major public channels in the community are used.
Don’t stress too much about picking the right place if you’re not sure, as
moderators can [move your question thread to a different
channel](https://zulip.com/help/move-content-to-another-stream) if needed.

## How to ask a great question

Spending some extra time and effort to carefully formulate your question is well
worthwhile, as it makes it much more likely that you'll get the information you
need to move forward. There are a few wonderfully thoughtful blog posts that
explain what it means to ask a good question:

- [Try, Then Ask](https://www.mattringel.com/2013/09/30/you-must-try-and-then-you-must-ask/)
- [We Aren’t Just Making Code, We’re Making History](https://www.harihareswara.net/sumana/2016/10/12/0)
- [How to Ask Good Questions](https://jvns.ca/blog/good-questions/)

In brief, to formulate a great question, you should:

- Try to solve your own problem first, including reading through relevant
  documentation and code.
- Identify the precise point on which you feel stuck.
- Formulate a clear question, which includes an appropriate amount of context
  and a specific request for help.

When your question is answered, follow through on the advice you receive, and (when
appropriate) summarize the resolution of your problem so that others can learn
from your experience.

You can find additional helpful tips in our guide to [what makes a great Zulip
contributor](contributing.md#what-makes-a-great-zulip-contributor).

## Follow the community guidelines

As always, be sure to follow the [Zulip community
norms](https://zulip.com/development-community/). In particular, check out [the
section on getting help](https://zulip.com/development-community/#getting-help)
before you post.
