# How we communicate

The primary communication forum for the Zulip community is the Zulip server
hosted at [chat.zulip.org](https://chat.zulip.org/). If you are not familiar
with it, start by reading the [Zulip development community
section](contributing.md#zulip-development-community) of the contributing guide.
The guidelines here also apply to how we communicate on GitHub issues and pull
requests, but other pages in this section go into greater detail about
expectations that are specific to pull requests.

We are deeply committed to maintaining a respectful, collaborative atmosphere in
across all interactions in the Zulip community. To get a feel for what that
means to us, please review the [code of conduct](../code-of-conduct.md) for our
community.

Beyond that, the following guidelines should help you communicate effectively to
express your perspective, and support and encourage other participants in the
community. By incorporating these patterns of behavior, we'll be able to reach
better decisions as a group, and learn and have fun along the way.

## Providing suggestions and feedback

- Aim to present your feedback precisely, with reasoning, and in as objective a
  fashion as you can manage. E.g., “This button really jumps out at me in a way
  that’s distracting; maybe it’s because of the color has a higher contrast than
  the surrounding components?” is better than, “Can we make that color less
  dark?”.

- Clarify your feedback if there are follow-up questions or points of confusion.
  However, avoid simply repeating the same points, as it does not move us closer
  to making the best decisions we can.

- When relevant, highlight information you have beyond your personal opinion.
  E.g., “I moderate a community, and often have to answer questions about how
  this works,” is more helpful than, “This is confusing.”

- In addition to offering constructive feedback, call out specific things that
  someone is doing well. This helps folks feel good about their work, and also
  helps them learn. E.g., “I particularly like the test you added, because...”

- When asking someone to do something, explain the reasoning behind your
  request. This is more motivating, and educates folks on what to do next time.

- If you are not certain about a suggestion you're making, it often works well
  to frame it as a question. E.g., “Would this be clearer if we...?” or “Could
  we...?”.

- Invite others to disagree or contribute additional thoughts, especially if you
  might be considered an authority in the area being discussed. When more folks
  feel comfortable speaking up, we are better able to identify problems and
  fine-tune solutions.

## Handling disagreements

- Always treat other participants in the discussion with respect, regardless of
  whether you agree with their ideas. Ad hominem attacks are never appropriate.

- Approach discussions with a perspective of curiosity. If someone has expressed
  an opinion you find odd or surprising, ask them to explain in more detail
  where they are coming from.

- If you think someone is factually mistaken, consider how they might have reached
  their conclusion, and aim to get to a shared understanding. For example:

  - “I wasn't able to replicate this -- is it possible you are on an old Zulip
    server?”, rather than “This bug report is wrong.”
  - “Using this function won't work here, because...” instead of “That's the
    wrong function.”

- If you disagree with someone on the core team, the best way to make progress
  is usually to state your opinions and reasoning clearly and respectfully, and
  then let the other core team members catch up on the conversation. Other
  project members may find your argument persuasive, and may have ideas that
  address your concerns.

## Expressing your appreciation

There are many ways to contribute to the Zulip community, and it's important to
express our appreciation for all the different ways in which folks jump in to
help. It helps motivate others, builds consensus towards decisions, and creates
a more positive atmosphere in the community.

For many community participants, it takes stepping out their comfort zone to try
something for the first time, such as submitting a pull request, answering a
question in the development community, or suggesting a new feature. It's
especially important to thank and encourage folks who are stretching themselves
to try something new.

- Remember to say “thanks” when responding to a question or suggestion. For
  example:

  - “Thanks for the report! ... ” when someone reports a bug.
  - “Thanks for reviewing my PR! ... ”

- Express your appreciation for the work that went into a pull request, even
  when it turns out that the approach taken in the PR is not successful. E.g.,
  “Thanks for working on this! ... ”

- Try especially hard to express your appreciation for others' contributions,
  effort and ideas when you are also providing negative (constructive) feedback
  on their work.

- You can use a variety of channels to express your appreciation. A comment
  directly in a Zulip thread or on a pull request is often best, but in some
  cases you may also want to send a friendly direct message. For example:

  - “I've noticed that you've been answering lots of questions in #**development
    help** lately. Thanks so much for doing that!”
  - “Thanks for moving those messages into a new topic -- the discussion was
    getting really tangled!”

- Sometimes a quick emoji reaction can help someone feel that their work is
  appreciated. 🎉

- Look over the message you just sent. Did you forget to say “thanks”? It's easy
  to edit your message, or send a quick follow-up.
