# Suggesting features and improvements

If you have ideas for how to make Zulip better, we'd love to hear from you! Many
improvements start with a user's suggestion. The best way to suggest a feature
or an improvement is by starting a conversation in the [Zulip development
community](https://zulip.com/development-community/). It's a great way to engage
interactively with members of the community, and explore how best to improve
Zulip for you and other users.

Usually, if the discussion leads to a concrete proposal, Zulip's product team
will follow up by filing a GitHub issue to track the idea. Many conversations do
not immediately lead to a GitHub issue, and that's OK! Sometimes the time is not
right to pin down a plan, or more ideas need to come in before a great proposal
emerges. Regardless of whether a discussion results in immediate action, we
appreciate the time everyone takes to make suggestions and brainstorm ideas.

## What to include in your proposal

- Describe your idea. It's absolutely fine to bring up a problem without
  suggesting a concrete solution.
- Provide context on how the change you are proposing would help you or your
  organization. It is often helpful to describe how you are using Zulip (e.g.,
  "I work at a small startup", or "I'm teaching a class"). This lets us combine
  our Zulip expertise with your requirements to come up with a great design for
  a feature.
- If you are aware of a related issue in GitHub or a prior conversation in the
  development community, please include a link.

## Starting a conversation about a suggested feature or improvement

Steps and best practices for starting a conversation:

1. [**Join** the Zulip development
   community](https://zulip.com/development-community/) if you don't already
   have an account.
2. Pick an **appropriate channel** to discuss your idea:
   - [#feedback](https://chat.zulip.org/#narrow/channel/137-feedback) for suggestions for
     the Zulip web app or server. Use this channel if you aren't sure which channel is
     most appropriate.
   - [#mobile](https://chat.zulip.org/#narrow/channel/48-mobile) for suggestions
     for the mobile apps.
   - [#desktop](https://chat.zulip.org/#narrow/channel/16-desktop) for suggestions
     that are specific to the Zulip desktop app.
   - [#zulip-terminal](https://chat.zulip.org/#narrow/channel/206-zulip-terminal)
     for suggestions for the terminal app.
   - [#production
     help](https://chat.zulip.org/#narrow/channel/31-production-help) for suggestions
     related to self-hosting Zulip.
3. **[Start a new topic](https://zulip.com/help/starting-a-new-topic)** for
   discussing your suggestions, using a brief summary of your idea as the
   name of the topic.

If you aren't sure where to post or how to name your topic, don't worry!
Moderators can always rename the topic, or move the thread to another channel.

Members of the development community will jump in to discuss your idea. You can
help by participating in the discussion, including replying to any follow-up
questions, and helping develop the proposal. The discussion may conclude with an
issue being filed in GitHub to track the plan that was developed.

## Filing a GitHub issue

Filing a GitHub issue can be effective when you have a very specific proposal
for a feature or improvement. Steps and best practices for filing an issue:

1. File the issue in the **appropriate [Zulip
   repository](https://github.com/zulip)**. The most commonly used repositories
   are:
   - [zulip/zulip](https://github.com/zulip/zulip/issues) for suggestions for the
     Zulip web app or server. A good default if you aren't sure which repository
     to use.
   - [zulip/zulip-mobile](https://github.com/zulip/zulip-mobile/issues) for
     suggestions for the mobile apps.
   - [zulip/zulip-desktop](https://github.com/zulip/zulip-desktop/issues) for
     suggestions that are specific to the Zulip desktop app.
   - [zulip/zulip-terminal](https://github.com/zulip/zulip-terminal/issues) for
     suggestions for the terminal app.
2. Do a **quick search** of the repository to see if there is already a similar
   request. If there is, add a comment explaining why you would also appreciate
   the proposed change, and make any additional suggestions you might have. Do
   not file a new issue.
3. If you are aware of a related discussion in the Zulip development community,
   please **cross-link** between the issue and the discussion thread. [Link to a
   specific
   message](https://zulip.com/help/link-to-a-message-or-conversation#get-a-link-to-a-specific-message)
   in the discussion thread, as message links will still work even if the topic is
   renamed or resolved.
