# Welcome to the Zulip documentation!

Welcome! Zulip's documentation is split into four parts:

- [Help center documentation](https://zulip.com/help/), for users and
  administrators of Zulip organizations.
- [Installation documentation](production/install.md), for
  installing and maintaining a production self-hosted Zulip installation.
- [API documentation](https://zulip.com/api/), for writing
  integrations or bots using the Zulip API.
- [Contributor documentation](contributing/contributing.md), for
  developing the Zulip software, translating, submitting bug reports,
  or making other contributions to the project.

Zulip has well over 150,000 words of documentation. If you can't find
what you're looking for, please [let us
know](https://zulip.com/development-community/)! Further information on
the Zulip project and its features can be found at
<https://zulip.com>.

This site contains our installation and contributor documentation. If
this is your first time here, you may want to start with [Production
installation](production/install.md) or [Contributing guide](contributing/contributing.md).

Contents:

- {ref}`Overview <overview>`
- {ref}`Zulip in production <zulip-in-production>`
- {ref}`Contributing to Zulip <contributing-to-zulip>`
- {ref}`Development environment <development-environment>`
- {ref}`Developer tutorials <developer-tutorials>`
- {ref}`Git guide <git-guide>`
- {ref}`Code testing <code-testing>`
- {ref}`Subsystem documentation <subsystem-documentation>`
- {ref}`Writing documentation <writing-documentation>`
- {ref}`Translating Zulip <translating>`
- {ref}`Outreach programs <outreach>`

(overview)=

```{toctree}
---
maxdepth: 3
---

Zulip homepage <https://zulip.com/>
overview/index
```

(zulip-in-production)=

```{toctree}
---
maxdepth: 3
---

production/index
```

(contributing-to-zulip)=

```{toctree}
---
maxdepth: 3
---

contributing/index
```

(development-environment)=

```{toctree}
---
maxdepth: 3
---

development/index
```

(developer-tutorials)=

```{toctree}
---
maxdepth: 3
---

tutorials/index
```

(git-guide)=

```{toctree}
---
maxdepth: 3
---

git/index
```

(code-testing)=

```{toctree}
---
maxdepth: 3
---

testing/index
```

(subsystem-documentation)=

```{toctree}
---
maxdepth: 3
---

subsystems/index
```

(writing-documentation)=

```{toctree}
---
maxdepth: 3
---

documentation/index
```

(translating)=

```{toctree}
---
maxdepth: 3
---

translating/index
```

(outreach)=

```{toctree}
---
maxdepth: 3
---

outreach/index

Index <https://zulip.readthedocs.io/en/latest/>
```
