# Mentoring

Mentoring an outreach program participant is a great way to help bring up the
next generation of open-source contributors and support the Zulip community. The
experience of watching your mentee's skills develop can be truly rewarding, and
we encourage you to give it a try.

Signing up to mentor means committing to being reliable source of support on your
mentee's open-source journey over the course of the program. By signing up,
you're committing to dedicating roughly 3-5 hours a week to the program.

Mentors generally have weekly calls with their mentees to answer any questions
and help make sure that everything is on track. You are also expected to help
program administrators keep an eye on your mentee's progress, and flag any
concerns you might have.

Mentors can refer to the excellent [GSoC Mentor
Guide](https://google.github.io/gsocguides/mentor/) for detailed guidance,
including GSoC's expectations, and best practices that can apply to any program.

## Who can mentor

In order to mentor with Zulip, you need to have spent significant time working
on Zulip yourself. You need to be familiar with what it takes to get work
integrated, so that you can help your mentee with this process. We encourage
anyone who has successfully completed a mentorship program with Zulip as a
participant to give mentorship a try!

Note that you do _not_ need to have any expertise in the part of the
codebase that your mentee is working in. We have seen many successful
mentor-mentee relationships where the mentor was new to the parts of
the codebase that were the focus of the project.

You also do not need to be a currently active contributor to Zulip. Our
expectations and patterns of getting work done have been quite consistent over
time, and it should be easy for you to catch up on anything that's changed since
you were actively involved.

## Supporting your mentee

At the start of the program, please read our [guide](experience.md) for program
participants to understand Zulip's expectations for your mentee.

What exactly you focus on in your mentorship will vary from week to week, and
will depend on what your mentee needs. It might be any combination of:

- Helping your mentee plan, chunk, and prioritize their work.

- [Manually testing](../contributing/code-reviewing.md#manual-testing) UI
  changes and helping find bugs or identify corner cases needing
  further discussion.

- Providing early feedback on visual and technical design questions.

- Helping your mentee figure out how to test their changes.

- Helping your mentee break their PRs into [coherent
  commits](../contributing/commit-discipline.md).

- Doing [code review](../contributing/code-reviewing.md) of your
  mentee's work.

- Helping with the technical design of projects and making sure
  they're aware of useful and relevant reference materials.

- Pair programming with your mentee to share useful tricks.

- Emotional support when things feel like they aren't going well.

It might seem challenging to review code if you're not an expert on
your mentee’s focus area. Don't let yourself be intimidated!
Reviewing changes to code your don't fully understand is a common
experience in software development, and you can still provide valuable
feedback.

If you don’t understand something about the changes being made, there
is a good chance others would also find it confusing. Asking your
mentee for an explanation will itself be valuable feedback on what
parts of the PR need to be commented or rewritten in a more clear way.

### Establishing communication patterns

Over the course of the program, you will interact with your mentee both
synchronously (e.g., on calls, pair programming, and/or via chat in the
development community), and asynchronously (in the development community and on
GitHub).

It's important to ensure that there are regular opportunities for synchronous
interactions, which are the best way to resolve some types of questions and
concerns, and will help your mentee feel supported.

Please schedule at least one synchronous interaction opportunity with your
mentee per week. A weekly call is highly recommended, as calls can be especially
helpful for getting a feel for how your mentee is doing, and lowering the bar
for asking questions and sharing concerns. A good pattern might be a weekly
call, plus 1-2 other regular time slots when you and your mentee check in in the
development community.

## Managing challenges

We rely on you to proactively flag your concerns to Zulip's program
administrators as early as possible. Situations you should bring up include:

- Lack of communication from your mentee, e.g., missing a scheduled call,
  missing multiple [check-ins](./experience.md#communication-and-check-ins), lack
  of response to PR reviews, etc.

- If your mentee's rate of progress on their projects is not commensurate with
  the hours of work they are supposed to be dedicating to the project.

- If you are not seeing improvement in response to the feedback you give.

- If your mentee seems to be struggling, deeply frustrated, or otherwise is not
  having a good experience with the program.

- Any significant questions or concerns raised by your mentee that you cannot
  resolve, which for some reason your mentee cannot raise directly.

- If it turns out that cannot dedicate sufficient time to support your mentee
  for all or part of the remaining duration of the program. As long as Zulip's
  program administrators are informed, we can make sure someone else covers for
  you.
