# Outreach programs overview

This page describes what it's like to participate in a Zulip outreach program,
such as [Google Summer of Code (GSoC)](https://summerofcode.withgoogle.com/) or
[Outreachy](https://www.outreachy.org/).

## About Zulip

[Zulip](https://zulip.com) is the only modern team chat app that is ideal for both
live and asynchronous conversations. Zulip has a web app, a cross-platform
mobile app for iOS and Android, cross-platform desktop and terminal apps, and
over 100 native integrations. The entire Zulip codebase is 100% open source.

Zulip has been gaining in popularity since it was [released as open source
software][oss-release] in late 2015, with code contributions from [over 1000
people](https://zulip.com/team/) from all around the world. Thousands of people
use Zulip every day, and your work on Zulip will have meaningful impact
on their experience.

[oss-release]: https://blogs.dropbox.com/tech/2015/09/open-sourcing-zulip-a-dropbox-hack-week-project/

As an organization, we value engaged, responsive mentorship and making sure our
product quality is extremely high. You can expect to receive disciplined code
reviews by highly experienced engineers. Since Zulip is a team chat product,
your internship experience with the Zulip project will be highly interactive.

> _“The experience of working with Zulip for the summer was really phenomenal and
> taught me a lot about software development and working with a community. Zulip
> has one of the best open source communities out there who are super friendly
> and welcoming. You learn a lot just by watching others work and talk.”_ – Sai
> Rohitth Chiluka, Zulip GSoC 2021 participant

As part of our commitment to mentorship, Zulip has over 160,000 words of
[documentation for
developers](../index.md#welcome-to-the-zulip-documentation), much of it
designed to explain not just how Zulip works, but why Zulip works the way that
it does. To learn more about our mission and values, check out [this blog
post](https://blog.zulip.com/2021/04/28/why-zulip-is-on-github-sponsors/)!

## Outreach program experience

Zulip has been a [GSoC](https://summerofcode.withgoogle.com/) mentoring
organization since 2016, and we accept 12-20 GSoC participants each summer. We
have also mentored several interns through the
[Outreachy](https://www.outreachy.org/) program, and hundreds of Google Code-In
participants.

Zulip operates under a **group mentorship** model. While you will have an
assigned mentor, you will also get lots of feedback from other members of the
[Zulip development community](https://zulip.com/development-community/) by
posting your questions and ideas in public channels. We encourage outreach
program participants to help each other out as well!

Program participants work on a variety of issues in their areas of interest,
from major features to small bugs. You will see your work integrated into Zulip
throughout the program, and even experience the impact of the changes yourself
in the [development community chat](https://zulip.com/development-community/).

Many program participants stay involved with the project past the
official end of the program. A number of folks who get started as participants
go on to mentor the next cohort, and several have joined Zulip's team of core
maintainers.

To learn more about the experience of doing an outreach program with Zulip:

- Check out our blog posts about Zulip's
  [2023](https://blog.zulip.com/2024/01/24/google-summer-of-code-2023/),
  [2022](https://blog.zulip.com/2022/11/02/google-summer-of-code-2022/), and
  [2021](https://blog.zulip.com/2021/09/30/google-summer-of-code-2021/) Google
  Summer of Code programs.

- Watch our [3-minute video](https://youtu.be/h4s-JUei3Z0) about what it's like
  to do GSoC with Zulip.

- Watch our [Having a Great GSoC](https://youtu.be/dPUAEZVBrJg) Google Summer of
  Code Community Talk.

- Read our [guide](experience.md) to having an amazing experience with Zulip's
  outreach programs.

> _“It has been the best summer I've ever had! I'm thankful to my mentors, my
> peers, Zulip, and Google for providing me an opportunity of getting involved
> in the community! You have helped and supported me to become a better software
> developer and a passionate open-source contributor.”_ – Sarthak Garg, Zulip
> GSoC 2021 participant
