# Finnish translation style guide

## Guidelines

Tervetuloa!

Before you start, take a look these instructions we have gathered here
for you to help on your translation journey.

### Word order

Consider translating the same thing with the easiest Finnish possible.
It's not mandatory to follow the English text word by word, as long as
the message is clear.

Eg.

- Click the button below to create the organization and register your
  account. -> Luo organisaatio ja rekisteröi tilisi napsauttamalla
  alla olevaa painiketta.

- Sent! Your message is outside your current narrow. -> Lähetetty!
  Viesti on nykyisen näkymäsi ulkopuolella.

### Grammatical case (Sijamuodot)

Translate using the UI to be sure what is the correct grammatical
case. Basic form of a word might not always be suitable for the
purpose.

Eg.

- Topics marked as resolved -> Ratkaistut aiheet (versus Aiheet, jotka on merkitty ratkaistuiksi)
- View Shortcuts -> Katsel**un** pikanäppäimet

### Loan word (Lainasanat)

Even though it's common to use words formed directly from English, try
to consider also users without IT background, people that don't speak
English and accessibility. User interface should contain these with
minimum amount, but for technical error messages could be preferred.
There are some amount of software related words that are widely used
as loan words.

See section [Terms](#terms) for more details.

### **_Please_**, in error messages

As it might appeal to use correspondence _Ole hyvä ja_, it's not
commonly used in Finnish. We are strict and used to more direct
messaging. Let's not translate _please_ and use instruction format
only. No Finn is going to be offended by this.

Eg.

- Please enter at most 10 emails. -> Lisää korkeintaan 10 sähköpostia.

But

- Yes, please! -> Kyllä, kiitos!

### Zulip word inflection

- in/from Zulip - **Zulipissa** / **Zulipista** / **Zulipin**
- Zulip organization - **Zulip-organisaatio**
- Zulip app - **Zulip-sovellus**

### Your -expression

Finnish language has _form of ownership_ so there shouldn't be need to
thanslate _your_ as _sinun_ but rather use _si_ ending. It might be
considered to leave out as well.

Eg.

- Your organization -> Organisaatio**si**
- Your account -> Tili**si**

But

- You do have active accounts in the following organization(s). ->
  Sinulla ei ole aktiivista tiliä seuraavissa organisaatio(i)ssa.

### Comma

Use commas in whole sentences where it is required. You can use these instructions as help.
[Kotimaisten kielten keskus - pilkku.](http://www.kielitoimistonohjepankki.fi/haku/pilkku/ohje/86)

## Terms

- Administrator - **Järjestelmänvalvoja**
- App - **Sovellus**
- Authorization - **Valtuus**
- Avatar - **Avatar**
- Beta - **Beta**
- Change - **Muuta**
- Cheat sheet - **Lunttilappu**
- Click - **Napsauta**
- Configure - **Määritä**
- Deactivate - **Poista käytöstä**
- Domain - **Verkkotunnus**
- Export - **Poiminta**
- Filter - **Suodata**
- Full member - **Täysivaltainen jäsen**
- Host - **Isäntä**
- Help Center - **Tukikeskus**
- ID - **Tunnus**
- Integraatio - **Integraatio**
- Interactive - **Interaktiivinen**
- Invalid - **Virheellinen**
- Moderator - **Moderaattori**
- Mute - **Mykistää**
- Narrow - **Rajaa hakua**
- Notification - **Ilmoitus**
- Topic - **Aihe**
- Organization - **Organisaatio**
- Permission - **Lupa**
- Pin - **Kiinnitä**
- Picker - **Valitsin**
- Plan - **Tilaus**
- DM (direct messages) - **SV (suoraviesti)** - Short version is needed in mobile.
- Reset - **Nollata**
- Save - **Tallenna**
- Stream - **Kanava**
- Subscriber - **Tilaaja**
- Subscription - **Tilaus**
- Subscribe a stream - **Tilaa kanava**
- Subdomain - **Aliverkkotunnus**
- Shortcuts - **Pikanäppäimet**
- Unsubscribe - **Peru tilaus**
- Unsupported - **Ei-tuettu**
- Unresolve - **Merkitse ratkaisemattomaksi**
- Webhook - **Webhook**
- Whoops - **Hupsista**
- Widget - **Widgetti**

## Other

Some translations can be tricky, so please don't hesitate to ask the
community or to contribute to this guide! Thanks for your effort!
