# Hindi translation style guide (हिन्दी अनुवाद शैली मार्गदर्शक)

- Use _आप_ as the second-person pronoun. Don't use तुम or तू.
  (See [chat thread](https://chat.zulip.org/#narrow/channel/58-translation/topic/Hindi.20Translation/near/1762384).)

- Imperative, active, and continuous verbs, e.g., _manage streams_ -
  _चैनल प्रबंधित करें_, not _चैनल प्रबंधन_.

- Warm and friendly phrasing whenever appropriate.

- No slang or regional phrases that could be unclear or too informal.

- Balance common verbs and nouns with specific IT-related translations
  of English terms - this can be tricky, try to check how other
  resources were translated (e.g., Gmail, Microsoft websites, Facebook)
  to decide what wouldn't sound awkward / rude in Hindi.

Some terms are very tricky to translate, so be sure to communicate
with other Hindi speakers in the community. It's all about making
Zulip friendly and usable.

## Terms (शर्तें)

- Message - **संदेश**
- Direct message (DM) - **सीधा संदेश**
- Stream - **धारा**: the use of the literal Hindi word for stream
  "प्रवाह" is very confusing and not the correct metaphor for Hindi
  speaking people. The correct term would be "धारा".
- Topic - **विषय**
- Private/invite-only stream - **निजी / केवल-आमंत्रण धारा**
- Public stream - **सार्वजनिक धारा**
- Bot - **बॉट**
- Integration - **एकीकरण**
- Notification - **अधिसूचना**
- Alert word - **सतर्क शब्द**
- View - **राय**
- Filter - **छानना**: as used with narrowing (see below).
- Home - **मुख पृष्ठ**: we never use the term "घर" (literally home) in Hindi.
- Emoji - **इमोजी**

## Phrases (वाक्यांश)

- Subscribe/Unsubscribe to a stream - **एक धारा में सदस्यता लें/सदस्यता समाप्त करें**
- Narrow to - **अकेले फ़िल्टर करें**: this is _filter only_, because there's no other
  word that's common enough in Hindi for _to narrow_.
- Mute/Unmute - **शांत/अशांत**
- Deactivate/Reactivate - **निष्क्रिय करें / पुन: सक्रिय करें**
- Search - **खोज करें/ढूंढें**
- Pin - **ठीक करना**
- Mention/@mention - **ज़िक्र करना / @ज़िक्र करना**
- Invalid - **अमान्य**
- Customization - **अनुकूलन**
- I want - **मुझे चाहिए**
- User - **उपयोगकर्ता**
- Person/People - **व्यक्ति/लोग**: "लोग" is the correct plural for
  "व्यक्ति", but when talking of _लोग_ referring to it as a crowd, we use
  "भीड़" instead.

## Others (अन्य)

- We - **हम**
- Message table - **संदेश बोर्ड**
- Enter/Intro - **दर्ज / परिचय**
