# Polish translation style guide

Use semi-formal Polish for translation, some specifics:

- Informal "you" (_ty_) instead of more formal approaches (e.g., plural
  "you" (_wy_), using any formal titles like _Państwo_, _Pan/Pani_).

- Gender-neutral forms of verbs, e.g., _unsubscribed_ - _odsubskrybowano_,
  not \*odsubskrybowałeś".

- Imperative, active and continuous verbs, e.g., _manage streams_ -
  _zarządzaj kanałami_, not _zarządź kanałami_.

- Not using reflexive _się_, e.g., _log out_ would be simply _wyloguj_,
  not _wyloguj się_.

- Warm and friendly phrasing whenever appropriate.

- No slang or regional phrases that could be unclear or too informal,
  e.g., _zajawka_.

- Consistent usage of Zulip-specific terms and common verbs for
  actions, even if it means repeating - this is one of the key aspects
  of "semi-formal", as synonyms would be often more appropriate in
  written Polish.

- Mindful usage of long words and phrases - it's sometimes hard to
  translate English to Polish concisely, be mindful of how it looks on
  the frontend after translating.

- Balance common verbs and nouns with specific IT-related translations
  of English terms - this can be tricky, try to check how other
  resources were translated (e.g., Gmail, Microsoft websites, Facebook)
  to decide what wouldn't sound awkward in Polish.

Some terms are very tricky to translate, so be sure to communicate
with other Polish speakers in the community. It's all about making
Zulip friendly and usable.

## Special terms used in Zulip

**alert word**: powiadomienie, "ostrzeżenie" could mean something negative
and alert words in Zulip are used to help users find relevant content

example:

You can set your own alert words for Zulip messages.

> Możesz ustawić powiadomienia dla wybranych fraz w Zulipie.

**Combined feed**: wszystkie wiadomości

example:

You can see all messages in unmuted streams and topics with "Combined feed".

> Możesz zobaczyć pełną listę wiadomości poprzez widok "Wszystkie wiadomości".

**bot**: bot

example:

You can add bots to your Zulip.

> Możesz dodać boty do swojego Zulipa.

**customization**: personalizacja, _kastomizacja_ could be too awkward
and _dostosowanie do potrzeb klienta_ is too long

example:

You can personalize Zulip in many ways, e.g., by pinning certain streams.

> Możesz spersonalizować Zulipa na wiele sposobów, np. przypinając niektóre kanały.

**emoji**: emoji, both in singular and plural, _ikona emoji_ is a pleonasm

example:

Zulip supports emoji both in messages and as reactions.

> Zulip wspiera używanie emoji w wiadomościach i jako reakcje.

**filter**: filtr (noun) and filtrowanie (verb)

example:

You can filter the messages by searching for relevant terms.

> Możesz przefiltrować wiadomości poprzez wyszukiwanie.

**group DM**: czat grupowy, different from _wiadomość_ since the usage
of _czat grupowy_ seems more common

example:

You can start a group DM with users in your organization.

> Możesz rozpocząć czat grupowy z użytkownikami w Twojej organizacji.

**integration**: integracja

example:

Zulip supports multiple third-party integrations.

> Zulip wspiera wiele zewnętrznych integracji.

**I want**: chcę

example:

I want to change my password.

> Chcę zmienić hasło.

**invalid**: niepoprawny/a

example:

Invalid command.

> Niepoprawna instrukcja.

**me**: me, no translation since it's used as `/me`

example:

You can use `/me` to write a reaction message.

> Możesz napisać wiadomość w formie komentarza poprzez użycie `me`.

**mention**: oznaczenie (noun) and oznaczyć (verb)

example:

You can mention other Zulip users by using @.

> Możesz oznaczyć innych użytkowników Zulipa używając @.

**message**: wiadomość

example:

You got a new message.

> Masz nową wiadomość.

**message table**: lista wiadomości

example:

The middle column in Zulip is a message table of all messages in current narrow.

> Środkowa kolumna w Zulipie zawiera listę wiadomości w wybranym widoku.

**muting a stream/topic**: wyciszenie kanału/wątku
**unmuting a stream/topic**: wyłącz wyciszenie kanału/wątku

example:

You can mute any topic in Zulip through the left-side panel.

> Możesz wyciszyć dowolny wątek w Zulipie używając menu kontekstowego po lewej.

**narrow**: widok (noun) and zawęzić (verb)

example:

You can narrow the messages to any stream, topic or search results.

> Możesz zawęzić wiadomości do wybranego kanału, wątku lub wyników wyszukiwania.

**notification**: powiadomienie

example:

Turn on notifications.

> Włącz powiadomienia.

**person**: osoba, najczęściej użytkownik
**people**: osoby, najczęściej użytkownicy

**pinning**: przypięcie (noun) and przypiąć (verb)

example:

You can pin streams in the left-side panel.

> Możesz przypiąć wybrane kanały w menu kontekstowym po lewej.

**direct message**: Wiadomość bezpośrednia

example:

You can send a direct message to other users in your organization.

> Możesz wysłać bezpośrednią wiadomość do innych użytkowników w Twojej organizacji.

**DM**: DM, translation could be confusing

example:

Direct messages are often abbreviated to DM.

> Wiadomości bezpośrednie są też nazywane DMami, od angielskiego "direct message".

**private stream**: prywatny kanał
**public stream**: publiczny kanał

example:

Join a private stream.

> Dołącz do prywatnego kanału.

**search**: wyszukiwanie (noun) and wyszukaj (verb)

example:

Zulip allows you to search messages in all streams and topics you are
subscribed to.

> Zulip pozwala na wyszukiwanie wiadomości we wszystkich subskrybowanych kanałach
> i wątkach.

**starred message**: oznaczona wiadomość (noun)
**star**: oznaczyć

example:

You starred this message.

> Ta wiadomość została oznaczona.

**stream**: kanał, similar to a tv channel - _strumień_ sounds a bit artificial

example:

You can create new streams in Zulip.

> Możesz tworzyć nowe kanały w Zulipie.

**subscribing to a stream**: (za)subskrybowanie kanału (noun) and
(za)subskrybować kanał (verb), perfective form depending on the
context

examples:

Subscribe to a stream.

> Zasubskrybuj kanał.

You are not subscribed to this stream.

> Nie subskrybujesz tego kanału.

**topic**: wątek

example:

Add a new topic.

> Dodaj nowy wątek.

**unsubscribing from a stream**: odsubskrybowanie kanału (noun) and
odsubskrybować kanał (verb)

example:

You have unsubscribed from this stream.

> Odsubskrybowano kanał.

**user**: użytkownik

example:

Zulip supports an unlimited number of users in an organization.

> Zulip nie limituje liczby użytkowników w organizacji.

**view**: widok, see: **narrow**
