# Spanish translation style guide

Use informal Spanish for translation:

- Informal "you" (_tú_) instead of formal form _usted_. Many top software
  companies (e.g., Google) use the informal one, because it's much more common in
  the daily language and avoids making translations look like they were written
  by machines.

- Imperative, active, and continuous verbs, e.g., _manage streams_ -
  _gestionar canales_, not _gestión de canales_.

- Not using reflexive _se_ e.g., _log out_ should be _salir_, not _salirse_,
  whenever the infinitive form is possible without making the translation
  awkward.

- Warm and friendly phrasing whenever appropriate.

- No slang or regional phrases that could be unclear or too informal.

- Balance common verbs and nouns with specific IT-related translations
  of English terms - this can be tricky, try to check how other
  resources were translated (e.g., Gmail, Microsoft websites, Facebook)
  to decide what wouldn't sound awkward / rude in Spanish.

- Latest RAE rule ("solo" should
  [**never**](https://www.rae.es/espanol-al-dia/el-adverbio-solo-y-los-pronombres-demostrativos-sin-tilde)
  have accent, even when it can be replaced with "solamente").

Some terms are very tricky to translate, so be sure to communicate
with other Spanish speakers in the community. It's all about making
Zulip friendly and usable.

## Términos

- Message - **Mensaje**
- Direct message (DM) - **Mensaje directo (MD)**
- Group DM - **Mensaje directo grupal**: many users may not associate "MD" with
  _direct message_ in a group context, so it's better to use the unabbreviated
  form rather than "MD grupal".
- Stream - **Canal**: the use of the literal Spanish word for stream
  "Flujo" is very confusing and not the correct metaphor for Spanish
  speaking people. The correct term would be "canal" (_channel_).
- Topic - **Tema**
- Private/invite-only stream - **Canal privado/limitado por invitación**: (lit.
  _channel limited by invitation_)
- Public stream - **Canal público**
- Bot - **Bot**
- Embedded bot - **Bot integrado**
- Interactive bot - **Bot interactivo**
- Integration - **Integración**
- Notification - **Notificación**
- Alert word - **Alerta**: this is only _alert_. Nonetheless, adding _word_ may
  make the term confusing (something like _danger!_ could be a "palabra de
  alerta" as well). Google Alerts uses "alerta" in its Spanish translation.
- View - **Vista**
- Filter - **Filtro**: as used with narrowing (see below).
- Home - **Inicio**: we never use the term "Hogar" (literally home) in Spanish.
- Emoji - **Emoticono** (plural: **emoticonos**)
- Slash command - **/comando**
- Webhook - **Webhook**
- Endpoint - **Endpoint**

## Frases

- Subscribe/Unsubscribe to a stream - **Suscribir a/Desuscribir de un canal**
- Narrow to - **Buscar solo**: this translates to _search only_. We use this
  term because there's no other word that's common enough in Spanish for
  _to narrow_ except for "filtrar", but this word can be incorrectly
  interpreted as _filter out_. We should stick to a term that we can use
  unambiguously and consistently for all instances of _Narrow to_.
- Mute/Unmute - **Silenciar/No silenciar**
- Deactivate/Reactivate - **Desactivar/Reactivar**
- Search - **Buscar**
- Pin - **Fijar** (lit. _to fixate_)
- Mention/@mention - **Mencionar/@mención**
- Invalid - **Inválido**
- Customization - **Personalización**
- I want - **Yo quiero**
- User - **Usuario**
- Person/People - **Persona/Personas**: "personas" is the correct plural for
  "person", but when talking of _people_ referring to it as a crowd, we use
  "gente" instead.

## Otros

- You - **Tú**: also "vosotros" if it's in plural.
- We - **Nosotros**
- Message table - **Tablón de mensajes**
- Enter/Intro - **Enter/Intro**
