# Urdu translation style guide(انداذِ ترجمہ کا رہنما)

Use semi-formal Urdu for translation:

- Formal "you" (_آپ_) instead of informal form _تم_. Many top software
  companies (e.g., Google, Facebook, Microsoft) use the formal one, because it's typically
  considered rude to use the informal one without an established acquaintance with someone.

- Imperative, active, and continuous verbs, e.g., _manage streams_ -
  _سٹریمس کی رہنمائ کریں_, not _سٹریمس کی رہنمائ_.

- Warm and friendly phrasing whenever appropriate.

- No slang or regional phrases that could be unclear or too informal.

- Balance common verbs and nouns with specific IT-related translations
  of English terms - this can be tricky, try to check how other
  resources were translated (e.g., Gmail, Microsoft websites, Facebook)
  to decide what wouldn't sound awkward/rude in Urdu.

Some terms are very tricky to translate, so be sure to communicate
with other Urdu speakers in the community. It's all about making
Zulip friendly and usable.

## Terms(اصطلاحات)

- Message - **پیغام**
- Direct message (DM) - **براہ راست پیغام**
- Stream - **سٹریم**
- Topic - **موضوع**
- Private/invite-only stream - **ذاتی / دعوت کی ضرورت والی سٹریم**
- Public stream - **عوامی سٹریم**
- Bot - **بوٹ**
- Integration - **انضمام**
- Notification - **اطلاع**
- Alert word - **الفاظِ چوکس**: this literally translate to "word(s) to remain vigilant of".
- View - **دیکھیں**
- Filter - **فلٹر**: as used with narrowing (see below).
- Home - **ھُوم**: using the literal translation--"گھر" (literally home)--would seem out of place.
- Emoji - **ایموجی**

## Phrases (فِقْرے)

- Narrow to - **محدود کریں**: the literal Urdu translation is "تنگ کریں" which may end up being
  interpreted as its more common meaning which is incorrect here. The correct phrase is
  "محدود کریں".
- Subscribe/Unsubscribe to a stream - **سٹریم کو سبسکرائب ی / اَنسبسکرائب**
- Mute/Unmute - **خاموش کریں / نا خاموسش کریں**
- Deactivate/Reactivate - **فعال کریں/غیر فعال کریں**
- Search - **تلاش کریں**
- Pin - **پن کریں**
- Mention/@mention - **زکر کریں / @زکر کریں**
- Invalid - **غلط**
- Customization - **ضرورت کے مطابق بنانا**
- I want - **مجھےچاھءے**
- User - **صارف**
- Person/People - **شخص / لوگ**

## Others(مختلف دیگر)

- We - **ہم**
- Message table - **پیغام بورڈ**
- Enter/Intro - **تعارف / درج**
