# Reading list

Here you can find a list of relevant resources that you may find useful for
learning new skills, or polishing the ones you already have.

The topics cover a wide variety of topics, from basic Python coding to
general developing guidelines.

Feel free to create a pull request in Zulip's [GitHub repository](https://github.com/zulip/zulip/) with any interesting books, articles or
videos you would like to see in this list.

Some titles have been shortened for organizational purposes.

## General programming/IT

_Book_ - [Clean Code: A Handbook of Agile Software Craftsmanship](https://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882) _(Not free!)_

_Books_ - [Free programming books list](https://github.com/vhf/free-programming-books)

_Blog_ - [Free Code Camp blog](https://medium.freecodecamp.com)

_Blog_ - [Idle Words talks transcripts](https://idlewords.com/talks)

_Tutorial_ - [HTTP Can Do That?!, by Sumana Harihareswara (PyCon 2016)](https://youtu.be/HsLrXt2l-kg)

_Video_ - [Minimum Viable Documentation, by Matthew Lyon (WriteTheDocs 2014)](https://youtu.be/bEZcodengwk)

_Video_ - [NoOps, by Kelsey Hightower (DepOpsDays 2016)](https://youtu.be/ajT90pC3ris)

_Video_ - [The mind behind Linux (TED interview)](https://youtu.be/o8NPllzkFhE)

_Tutorial_ - [Learn code the hard way](https://learncodethehardway.org)

_Tutorial_ - [What happens when...](https://github.com/alex/what-happens-when)

_Article_ - [An Interview With Linus Torvalds](https://techcrunch.com/2012/04/19/an-interview-with-millenium-technology-prize-finalist-linus-torvalds)

_Article_ - [Effective Learning Strategies for Programmers](https://akaptur.com/blog/2015/10/10/effective-learning-strategies-for-programmers/)

_Article_ - [Readme Driven Development](https://tom.preston-werner.com/2010/08/23/readme-driven-development.html)

_Article_ - [Systematic Debugging](https://akaptur.com/blog/2013/07/24/systematic-debugging)

_Paper_ - [Floating-Point Arithmetic](https://docs.oracle.com/cd/E19957-01/806-3568/ncg_goldberg.html)

## Python

_Video_ - [Intro to Python for beginners, by Jessica McKellar (PyCon 2013)](https://youtu.be/rkx5_MRAV3A)

_Video_ - [Breaking the rules, by Jessica McKellar (PyCon Sweden)](https://youtu.be/C0fnHhY9UOc)

_Video_ - [Build & break a Python sandbox, by Jessica McKellar (PyCon 2014)](https://pyvideo.org/pycon-us-2014/building-and-breaking-a-python-sandbox.html)

_Video_ - [Cache me if you can, by Guillaume Ardaud (PyCon 2014)](https://pyvideo.org/pycon-us-2014/cache-me-if-you-can-memcached-caching-patterns.html)

_Video_ - [Loop like a native, by Ned Batchelder (PyCon 2013)](https://youtu.be/EnSu9hHGq5o)

_Video_ - [Modern Dictionaries, by Raymond Hettinger (SF Python)](https://youtu.be/p33CVV29OG8)

_Video_ - [Python Language, by Guido van Rossum (PyCon 2016)](https://youtu.be/YgtL4S7Hrwo)

_Video_ - [The Mighty Dictionary, by Brandon Rhodes (PyCon 2010)](https://pyvideo.org/pycon-us-2010/the-mighty-dictionary-55.html)

_Article_ - [Static types in Python, oh my(py)!](https://blog.zulip.org/2016/10/13/static-types-in-python-oh-mypy)

_Guide_ - [The Hitchhiker’s Guide to Python!](https://docs.python-guide.org/)

## Java/Android

_Course_ - [Android Development for Beginners](https://www.udacity.com/course/android-development-for-beginners--ud837)

_Blog_ - [Java Tutorials for Beginners](https://www.geeksforgeeks.org/java/)

## JavaScript/ECMAScript

_Tutorial_ - [clean-code-javascript Software engineering principles](https://github.com/ryanmcdermott/clean-code-javascript)

_Course_ - [React native and redux course](https://www.udemy.com/course/the-complete-react-native-and-redux-course/) (_Not free!_)

_Video_ - [TypeScript vs. CoffeeScript vs. ES6](https://www.youtube.com/watch?v=Ae4h9GC9cCg)

## TypeScript

_Tutorial_ - [TypeScript handbook section on base types](https://www.typescriptlang.org/docs/handbook/basic-types.html)

_Book_ - [TypeScript Deep Dive](https://basarat.gitbooks.io/typescript/)

_Guide_ - [TypeScript Declaration Files Introduction](https://www.typescriptlang.org/docs/handbook/declaration-files/introduction.html)

## Git/version control systems (VCS)

You may want to take a look first at our [Git and GitHub guide](../git/index.md).

## Computer science/algorithms

_Blog_ - [GeeksforGeeks](https://www.geeksforgeeks.org)

_Book_ [Introduction to Algorithms](https://mitpress.mit.edu/books/introduction-algorithms) (_Not free!_)

_Blog_ - [Setosa data visualization and visual explanations](https://setosa.io)

_Course_ - [Algorithms, Part I](https://www.coursera.org/learn/algorithms-part1)

_Course_ - [Open Source Society University](https://ossu.firebaseapp.com)

_Course_ - [MIT CSAIL 6.828: Operative Systems Engineering](https://pdos.csail.mit.edu/6.828/2016)

## Community experience

_Book_ - [Producing Open Source Software](https://producingoss.com/en/)

_Article_ - [Advice on Starting And Running A New Open Source Project](https://www.harihareswara.net/sumana/2016/08/04/1)

_Article_ - [How to ask good questions](https://jvns.ca/blog/good-questions)

_Article_ - [Notes for New FLOSS Contributors](https://www.harihareswara.net/sumana/2016/10/12/0)

_Article_ - [To be mentored](https://trueskawka.github.io/zulip/outreachy/blog/2017/01/02/to-be-mentored.html)

_Article_ - [To mentor](https://trueskawka.github.io/zulip/outreachy/gci/blog/2017/01/03/to-mentor.html)

[List of good projects for new contributors](https://github.com/MunGell/awesome-for-beginners)

## Competitions/camps

[CodeForces](https://codeforces.com)

[Free Code Camp](https://www.freecodecamp.com)

## Massive open online courses (MOOC) platforms

[Coursera](https://www.coursera.org)

[edX](https://www.edx.org)

[MIT OpenCourseWare](https://ocw.mit.edu)

[Udacity](https://www.udacity.com)
