# Screenshot and GIF software

The following list documents different screenshotting & GIF-making techniques and
free software. We encourage you to make use of these when making front-end pull
requests, as other contributors can see the changes you have made without having
to check out your branch.

## Screenshot tools by platform

### Browser

- Firefox can take screenshots without any plugins (stable feature starting from v57)
  - You can find it under `page actions / Take a screenshot`
  - It is capable of screenshotting the entire page, visible area and individual DOM elements
- [LightShot Screenshot](https://app.prntscr.com/en/index.html) (Chrome, Firefox, IE & Opera)
- [Chrome Capture](https://chrome.google.com/webstore/detail/chrome-capture-screenshot/ggaabchcecdbomdcnbahdfddfikjmphe?hl=en)

### macOS

- Command-Shift-3 to capture the entire screen
- Command-Shift-4 and drag cursor to select a specific area
- Command-Shift-5 and select suitable option to capture or record screen (macOS Mojave)
- [LightShot Screenshot](https://app.prntscr.com/en/index.html)
- [Gyazo](https://gyazo.com/en)

### Windows

- PrtScn to copy the screen to the clipboard
- Windows-PrtScn to save the screen to a file
- Snipping Tool (inbuilt)
- [LightShot Screenshot](https://app.prntscr.com/en/index.html)
- [Gyazo](https://gyazo.com/en)
- [ScreenToGif](https://www.screentogif.com/)

### Linux

- gnome-screenshot (inbuilt, you can use Ctrl-Shift-PrtScn as a shortcut for its “select an area to grab” feature)

## GIF tools by platform

### Browser

- [GIPHY](https://giphy.com)
- [Chrome Capture](https://chrome.google.com/webstore/detail/chrome-capture/ggaabchcecdbomdcnbahdfddfikjmphe?hl=en)
  (Tip: Use Alt+i to interact with the page while recording)

### macOS

- [QuickTime](https://support.apple.com/en-in/HT201066)
- [GIPHY](https://giphy.com/apps/giphycapture)
- [CloudApp](https://www.getcloudapp.com)
- [Kap](https://getkap.co)
- [Gifski](https://sindresorhus.com/gifski)
- [Gyazo GIF](https://gyazo.com/en)

### Windows

- [ScreenToGif](https://www.screentogif.com)
- [Gyazo GIF](https://gyazo.com/en)
- [Monosnap](https://www.monosnap.com/welcome)

### Linux

- [Peek](https://github.com/phw/peek)
- [SilentCast](https://github.com/colinkeenan/silentcast)
