# Zulip communities directory

{!communities-directory-intro.md!}

## Eligibility

In order to be eligible for listing in the communities directory, an
organization must be open to the public. Your organization is eligible
if users are allowed to [join without an invitation][join-without-invite]
and/or the [public access option](/help/public-access-option) is enabled.

The directory will be organized by [organization type](/help/organization-type),
so it is highly recommended that you make sure the appropriate category
is selected.

To prevent spam, Zulip reserves the right to use editorial discretion.
Giving Zulip permission to promote your organization in the communities
directory does not guarantee that it will be listed.

### Self-hosted Zulip communities

Zulip plans to develop support for self-hosted Zulip communities that
have registered their servers with the [Zulip mobile push
notification service][push-notifications] to sign-up for the Zulip
communities directory.

Until that feature is developed, if you administer a self-hosted Zulip
community and would like to be listed in the directory, please contact
[Zulip support](mailto:support@zulip.com). Changing the setting in your
Zulip organization will not send any information to the Zulip project
at this time, even if you use the Zulip mobile push notifications
service.

[join-without-invite]: /help/restrict-account-creation#set-whether-invitations-are-required-to-join
[communities-directory-permission]: /help/communities-directory#give-permission-to-be-in-the-zulip-communities-directory
[push-notifications]: https://zulip.readthedocs.io/en/stable/production/mobile-push-notifications.html

## Change whether your organization may be listed in the Zulip communities directory

{!admin-only.md!}

{!communities-directory-instructions.md!}

!!! tip ""

    Organizations that are not open to the public will not be listed at this time.
    If you administer a non-public organization, please check the box to request
    to be listed in the future.

## Related articles

* [Create your organization profile](/help/create-your-organization-profile)
* [Public access option](/help/public-access-option)
* [Linking to the Zulip website](/help/linking-to-zulip-website)
* [Support the Zulip project](/help/support-zulip-project)
* [Restrict account creation](/help/restrict-account-creation)
* [Moderating open organizations](/help/moderating-open-organizations)
* [Organization type](/help/organization-type)
