# Configure home view

The home view in Zulip is the view you reach after logging in
to the Zulip web app. You can also navigate to the home view via
keyboard shortcuts.

The home views available in Zulip are
[**Inbox**](/help/inbox),
[Recent conversations](/help/recent-conversations), and
[Combined feed](/help/combined-feed). See
[Reading strategies](/help/reading-strategies) for recommendations
on how to use these views.

You can configure which view is set as your home view, and whether
the <kbd>Esc</kbd> key navigates to the home view. Also, you can
always reach the home view by using the <kbd>Ctrl</kbd> + <kbd>[</kbd>
shortcut.

## Change home view

Organization administrators can [configure the home view for their
organization](/help/configure-default-new-user-settings) to
[**Inbox**](/help/inbox),
[**Recent conversations**](/help/recent-conversations), or
[**Combined feed**](/help/combined-feed).

- The **Inbox** view works best if you regularly clear all unread messages in
channels you follow.

- **Recent conversations** works well for getting an overview of recent activity.

- **Combined feed** is convenient for low-traffic organizations, or for skimming
  messages as they come in.

You can customize your personal home view regardless of
organization settings:

{start_tabs}

{settings_tab|preferences}

1. Under **Navigation**, click on the **Home view** dropdown
   and select a view.

1. To see your changes in action, open a new Zulip tab, or use a keyboard
   shortcut twice to exit the settings and navigate to your home view
   (<kbd>Ctrl</kbd> + <kbd>[</kbd> or <kbd>Esc</kbd> if enabled).

!!! tip ""

    You can also hover over your desired home view in the left sidebar, and
    choose the option to **make it your home view** in the **ellipsis**
    (<i class="zulip-icon zulip-icon-more-vertical"></i>) menu.

{end_tabs}

## Configure whether <kbd>Esc</kbd> navigates to the home view

Zulip has a number of [keyboard shortcuts](/help/keyboard-shortcuts)
designed to enhance the user experience in the app.

By default, the <kbd>Esc</kbd> key shortcut will ultimately navigate to
your home view. You can disable this key binding if you would prefer.
This will not disable other <kbd>Esc</kbd> key shortcuts used in Zulip,
and will not affect the behavior of the <kbd>Ctrl</kbd> + <kbd>[</kbd>
shortcut.

### Toggle whether <kbd>Esc</kbd> navigates to the home view

{start_tabs}

{settings_tab|preferences}

1. Under **Navigation**, toggle **Escape key navigates to
   home view**, as desired.

{end_tabs}

## Related articles

* [Reading strategies](/help/reading-strategies)
* [Recent conversations](/help/recent-conversations)
* [Combined feed](/help/combined-feed)
* [Keyboard shortcuts](/help/keyboard-shortcuts)
