# Create a channel

By default, all users other than guests can create channels. Administrators can
[restrict the ability to create a channel](/help/configure-who-can-create-channels) to specific
[roles](/help/roles-and-permissions).

If you are an administrator setting up channels for the first time, check out our
[guide to setting up channels for a new organization](/help/create-channels).

## Create a channel

{!create-a-channel-instructions.md!}

## Channel options

There are several parameters you can set while creating a channel. All but
**Announce channel** you can change later.

* **Channel name**: Appears in the left sidebar for subscribed users. The
  channel name can be in any language, and can include spaces and other
  punctuation.

* **Channel description**: Helps users decide whether to subscribe when they
  are browsing channels.

* **Announce new channel in the [channel configured by your organization](/help/configure-automated-notices#new-channel-announcements)**:
  Posts a message in the "new channels" topic advertising the new channel.

* **Who can access the channel?**: See [Channel permissions](/help/channel-permissions).

* **Default channel for new users**: Whether new users will be [automatically
  subscribed](/help/set-default-channels-for-new-users) to the new channel.

* **Who can post to the channel?**: See [Channel permissions](/help/channel-permissions).

* **Who can unsubscribe others from this channel?**: See
  [Restrict channel membership management](/help/configure-who-can-invite-to-channels#configure-who-can-remove-users).

* **Message retention period**: See
  [Message retention policy](/help/message-retention-policy#configure-message-retention-policy-for-individual-channels).

* **Choose subscribers**: You can copy the membership from an existing channel or
  [user group](/help/user-groups), add all users, or enter users one by one.

## Related articles

* [Create channels for a new organization](/help/create-channels)
* [Channel permissions](/help/channel-permissions)
* [Set default channels for new users](/help/set-default-channels-for-new-users)
* [Introduction to channels](/help/introduction-to-channels)
