# Direct messages

**Direct messages (DMs)** are conversations with other users that happen outside
of a [channel](/help/introduction-to-channels). DMs work well for one-off messages,
usually with just one or two others.

If you find yourself frequently conversing with the same person or group, it
often works better to [create a private channel](/help/create-a-channel) for your
conversations. This lets you organize your discussion into topics, and add or
remove participants as needed.

## Send a DM

{!send-dm.md!}

## Access a DM

If using Zulip in a browser or desktop, there are several ways to access an existing DM conversation.

* Click on **Direct messages** near the top of the left sidebar to access
  recent DM conversations.

* Click on any user in the right sidebar.

* Start typing a user's name in the [search](/help/search-for-messages) bar.
  You'll be able to select DMs with that user.

* Open the compose box, and enter a list of users on the **To:**
  line. Type <kbd>Ctrl</kbd> + <kbd>.</kbd> to open that conversation.

## Find a direct message conversation

{start_tabs}

{tab|desktop-web}

1. If the **DIRECT MESSAGES** section in the left sidebar is collapsed, click on
   the **DIRECT MESSAGES** heading to expand it.
1. At the bottom of the list of your recent direct messages, click **more
   conversations**. If you don't see this link, you are already viewing all of
   your direct message conversations.
1. Type the name of a participant in the conversation you're looking for.

{end_tabs}

## Access all DMs

{start_tabs}

{tab|desktop-web}

1. In the left sidebar, click the **Direct message feed**
   (<i class="fa fa-align-right"></i>) icon to the right of the
   **Direct messages** label, or use the <kbd>Shift</kbd> + <kbd>P</kbd>
   keyboard shortcut.

{tab|mobile}

1. Tap the **Direct messages**
   ( <img src="/static/images/help/mobile-dm-tab-icon.svg" alt="direct messages" class="help-center-icon"/> )
   tab at the bottom of the app.

{end_tabs}


## Related articles

* [Typing notifications](/help/typing-notifications)
* [Open the compose box](/help/open-the-compose-box)
