# Emoji reactions

Emoji reactions let you quickly respond to a message. For example, 👍 is
commonly used to express agreement or confirm that you've [read the
message](/help/read-receipts). Any emoji can be used as a reaction, including
[custom emoji](/help/custom-emoji). Reactions appear at the bottom of the
message.

## Add a new reaction

{start_tabs}

{tab|desktop-web}

{!message-actions.md!}

1. Click the **smiley face** (<i class="zulip-icon zulip-icon-smile"></i>) icon.

    !!! warn ""

        For messages that you've sent, click on the **ellipsis**
        (<i class="zulip-icon zulip-icon-more-vertical-spread"></i>) and then
        **Add emoji reaction**.

1. Select an emoji. Type to search, use the arrow keys, or click on an emoji
   with your mouse.

!!! tip ""

    To add multiple reactions without closing the emoji picker, hold the
    <kbd>Shift</kbd> key while selecting emoji.

!!! keyboard_tip ""

    You can react to the selected message with <img alt=":thumbs_up:"
    class="emoji" src="/static/generated/emoji/images/emoji/unicode/1f44d.png"
    title="thumbs up"/> by using the <kbd>+</kbd> shortcut.

{tab|mobile}

{!message-long-press-menu.md!}

1. Tap **Add a reaction**.

1. Start typing the name of the emoji you want to use, and select an emoji from
   the list of suggestions.

{end_tabs}

## Add or remove an existing reaction

{start_tabs}

{tab|desktop-web}

1. Click on an existing emoji reaction to add or remove your reaction.

!!! tip ""

    To make it easy to see which reactions you have added, they are
    highlighted in a different color.

!!! keyboard_tip ""

    You can also toggle the first emoji reaction on the selected message by
    using the <kbd>=</kbd> shortcut.

{tab|mobile}

1. Tap on an existing emoji reaction to add or remove your reaction.

!!! tip ""

    To make it easy to see which reactions you have added, they are
    highlighted in a different color.

{end_tabs}


## Viewing who reacted to a message

For messages where few users have reacted, the names of users who have reacted
are displayed directly on the message if the [option to do
so](#toggle-whether-names-of-reacting-users-are-displayed) is enabled.

### View who reacted to a message

{start_tabs}

{tab|desktop-web}

1. Hover over an emoji reaction to see who reacted with that emoji.

{tab|mobile}

{!message-long-press-menu.md!}

1. Tap **See who reacted**.

!!! tip ""

    You can also long-press an existing emoji reaction to see who reacted with
    that emoji.

{end_tabs}

### Toggle whether names of reacting users are displayed

{start_tabs}

{settings_tab|preferences}

1. Under **Emoji**, toggle **Display names of reacting users when few users have
   reacted to a message**.

{end_tabs}

## View your messages with reactions

To see how others have responded to your messages, you can view all your
messages which have received at least one reaction.

{start_tabs}

{tab|desktop-web}

1. Click on <i class="zulip-icon zulip-icon-smile"></i>**Reactions** in the left
   sidebar. If the **views** section is collapsed, click on
   the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>),
   and select <i class="zulip-icon zulip-icon-smile"></i>**Reactions**.

1. Browse your reactions. You can click on a message recipient bar to go
   to the [conversation](/help/reading-conversations) where you sent the message.

!!! tip ""

    You can also [search all messages with reactions](/help/search-for-messages) using the
    `has:reaction` filter.

{end_tabs}


## Related articles

* [Add custom emoji](/help/custom-emoji)
* [Emoji in messages](/help/emoji-and-emoticons)
