# Follow a topic

Zulip lets you follow topics you are interested in. You can follow or unfollow
any topic. You can also configure Zulip to automatically follow topics you start
or participate in. Participating in a topic means sending a message,
[reacting](/help/emoji-reactions) with an emoji, or participating in a
[poll](/help/create-a-poll). You can also automatically follow topics where you
are [mentioned](/help/mention-a-user-or-group).

It's easy to prioritize catching up on followed topics. You can:

- [Configure](/help/follow-a-topic#configure-notifications-for-followed-topics)
  how you get notified about new messages for topics you follow.

- Use the <kbd>Shift</kbd> + <kbd>N</kbd> [keyboard
  shortcut](/help/keyboard-shortcuts) to go to the next unread followed topic.

- Filter the [**inbox**](/help/inbox) and [**recent
  conversations**](/help/recent-conversations) views to only show followed
  topics.

- See which topics you are following in the **left sidebar**.

You can use followed topics for a variety of workflows:

{!followed-topic-workflows.md!}

## Follow or unfollow a topic

{start_tabs}

{tab|desktop-web}

{!configure-topic-notifications-desktop-web.md!}

{end_tabs}

## Catch up on followed topics

{start_tabs}

{tab|desktop-web}

{!go-to-inbox.md!}

1. Filter the view to the topics you follow by selecting **Followed topics**
   from the dropdown in the upper left of the **inbox** view.

1. Click on a conversation you're interested in to view it. You can also use
   the arrow keys to select a conversation, and press <kbd>Enter</kbd>.

1. Return to **Inbox** when done to select the next conversation. You can use
   the **back** button in your browser or the desktop app, <kbd>Shift</kbd> +
   <kbd>I</kbd>, or <kbd>Esc</kbd> if **Inbox** is configured as you [home
   view](/help/configure-home-view).

!!! keyboard_tip ""

    You can also use <kbd>Shift</kbd> + <kbd>N</kbd> from any location to go
    to the next unread followed topic.

{end_tabs}

## Search for messages in followed topics

{start_tabs}

{tab|desktop-web}

1. Click the **search** (<i class="search_icon zulip-icon
   zulip-icon-search"></i>) icon in the top bar to open the search box.

1. Type `is:followed`, or start typing and select **Followed topics** from the
   typeahead.

1. _(optional)_ Enter additional search terms or
   [filters](/help/search-for-messages).

1. Press <kbd>Enter</kbd>.

!!! keyboard_tip ""

    You can also use the <kbd>/</kbd> or <kbd>Ctrl</kbd> + <kbd>K</kbd>
    keyboard shortcut to start searching messages.

{end_tabs}

!!! tip ""

    To get a feed of unread messages in all the topics you follow, search for
    `is:followed is:unread`.


## Configure notifications for followed topics

You can configure custom notifications for followed topics. You can also
[configure the unread count
badge](/help/desktop-notifications#unread-count-badge) to include unread
messages just in followed topics, without counting other channel messages.

{!configure-notifications-for-followed-topics.md!}

## Automatically follow topics

{!automatically-follow-topics.md!}

## Manage configured topics

{start_tabs}

{tab|desktop-web}

{!manage-configured-topics-desktop-web.md!}

{end_tabs}

## Related articles

* [Reading strategies](/help/reading-strategies)
* [Topic notifications](/help/topic-notifications)
* [Channel notifications](/help/channel-notifications)
* [Mute or unmute a topic](/help/mute-a-topic)
* [Mute or unmute a channel](/help/mute-a-channel)
