# Message formatting

[//]: # (All screenshots here require line-height: 22px and font-size: 16px in .message-content.)
[//]: # (Requires some additional fiddling for the LaTeX picture, inline code span, and maybe a few others.)

Zulip uses Markdown to allow you to easily format your messages. Even if you've
never heard of Markdown, you are probably familiar with basic Markdown
formatting, such as using `*` at the start of a line in a bulleted list, or
around text to indicate emphasis.

Formatting buttons in the compose box make it easy to format your message. For
those who prefer to type the formatting they need, this page provides an
overview of all the formatting available in Zulip. There is a convenient
[message formatting reference](#message-formatting-reference) in the Zulip
app that you can use whenever you need a reminder of the formatting syntax
below.

* [Text emphasis](#text-emphasis)
* [Bulleted lists](#bulleted-lists)
* [Numbered lists](#numbered-lists)
* [Links](#links)
* [Code blocks](#code-blocks)
* [LaTeX](#latex)
* [Quotes](#quotes)
* [Spoilers](#spoilers)
* [Emoji and emoticons](#emoji-and-emoticons)
* [Mention a user or group](#mention-a-user-or-group)
* [/me action messages](#me-action-messages)
* [Global times](#global-times)
* [Tables](#tables)
* [Collaborative to-do lists](#collaborative-to-do-lists)
* [Paragraph and section formatting](#paragraph-and-section-formatting)

## Text emphasis

{!emphasis-intro.md!}

{!emphasis-examples.md!}

!!! tip ""

    You can also use buttons or keyboard shortcuts (<kbd>Ctrl</kbd> +
    <kbd>B</kbd> or <kbd>Ctrl</kbd> + <kbd>I</kbd>) to make text bold or italic.
    [Learn more](/help/text-emphasis).

## Bulleted lists

{!bulleted-lists-intro.md!}

{!bulleted-lists-examples.md!}

!!! tip ""

    You can also use the **Bulleted list**
    (<i class="zulip-icon zulip-icon-unordered-list"></i>)
    button in the compose box to insert bulleted list formatting.
    [Learn more](/help/bulleted-lists).

## Numbered lists

{!numbered-lists-intro.md!}

{!numbered-lists-examples.md!}

!!! tip ""

    You can also use the **Numbered list**
    (<i class="zulip-icon zulip-icon-ordered-list"></i>)
    button in the compose box to insert numbered list formatting.
    [Learn more](/help/numbered-lists).

## Links

{!links-intro.md!}

{!links-examples.md!}

!!! tip ""

    You can also use the **Link**
    (<i class="zulip-icon zulip-icon-link"></i>)
    button or a keyboard shortcut (<kbd>Ctrl</kbd> + <kbd>Shift</kbd> +
    <kbd>L</kbd>) to insert a link. [Learn more](/help/insert-a-link).

## Code blocks

{!code-blocks-intro.md!}

{!code-blocks-examples.md!}

!!! tip ""

    You can also use the **Code** (<i class="zulip-icon zulip-icon-code"></i>)
    button in the compose box to insert code formatting.
    [Learn more](/help/code-blocks).

## LaTeX

{!latex-intro.md!}

{!latex-examples.md!}

!!! tip ""

    You can also use the **LaTeX** (<i class="zulip-icon zulip-icon-math"></i>)
    button in the compose box to insert LaTeX formatting.
    [Learn more](/help/latex).

## Quotes

{!quotes-intro.md!}

{!quotes-examples.md!}

!!! tip ""

    There is a handy option to [quote and reply](/help/quote-and-reply) to a
    message in Zulip.
    You can also use the **Quote** (<i class="zulip-icon zulip-icon-quote"></i>)
    button in the compose box to insert quote formatting.
    [Learn more](/help/format-a-quote).

## Spoilers

{!spoilers-intro.md!}

{!spoilers-examples.md!}

!!! tip ""

    You can also use the **Spoiler**
    (<i class="zulip-icon zulip-icon-spoiler"></i>) button in the compose
    box to insert spoiler formatting. [Learn more](/help/spoilers).

## Emoji and emoticons

{!emoji-and-emoticons-intro.md!}

{!emoji-and-emoticons-examples.md!}

## Mention a user or group

{!mentions-intro.md!}

{!mentions-examples.md!}

## /me action messages

{!me-action-messages-intro.md!}

{!me-action-messages-examples.md!}

## Global times

{!global-times-intro.md!}

{!global-times-examples.md!}

!!! tip ""

    You can also use the **Add global time**
    (<i class="zulip-icon zulip-icon-time"></i>) button in the compose
    box to select a time from the date picker. [Learn more](/help/global-times).

## Tables

{!tables-intro.md!}

{!tables-examples.md!}

## Collaborative to-do lists

{!to-do-lists-intro.md!}

{!to-do-lists-examples.md!}

## Paragraph and section formatting

{!paragraphs-and-sections-intro.md!}

{!paragraphs-and-sections-examples.md!}

## Message formatting reference

A summary of the formatting syntax above is available in the Zulip app.

{start_tabs}

{tab|desktop-web}

{relative|help|message-formatting}

!!! tip ""

    You can also [open the compose box](/help/open-the-compose-box), and click
    the **question mark** (<i class="zulip-icon zulip-icon-question"></i>) icon
    at the bottom of the compose box.

{end_tabs}

## Related articles

* [Create a poll](/help/create-a-poll)
* [Mention a user or group](/help/mention-a-user-or-group)
* [Preview messages before sending](/help/preview-your-message-before-sending)
* [Resize the compose box](/help/resize-the-compose-box)
* [Messaging tips & tricks](/help/messaging-tips)
