# Setting up your organization

Welcome to Zulip! This page will guide you through trying out Zulip,
migrating your organization from other team chat tools (if needed),
getting everything set up, and inviting others to join.

If you are joining an existing organization, we recommend checking out
our guide to [Getting started with Zulip][getting-started].

[getting-started]: /help/getting-started-with-zulip

If you encounter any problems as you're getting started, please drop
by our [friendly development community](/development-community/) and let
us know!

## Trying out Zulip

{!trying-out-zulip.md!}

## Choosing between Zulip Cloud and self-hosting

{!cloud-vs-self-hosting-intro.md!}

### Advantages of Zulip Cloud

{!advantages-of-zulip-cloud.md!}

### Advantages of self-hosting Zulip

{!advantages-of-self-hosting-zulip.md!}

## Migrating from other chat tools

{!migrating-from-other-chat-tools.md!}

## Create your organization profile

{!organization-profile-intro.md!}

### Edit organization profile

{!edit-organization-profile.md!}

### Add a wide logo

{!add-a-wide-logo.md!}

## Customize organization settings

{!customize-organization-settings.md!}

## Create channels

{!create-channels-intro.md!}

### How to create a channel

{start_tabs}

{relative|channel|all}

1. Click **Create channel** on the right.

1. Fill out the requested info, and click **Create**.

{end_tabs}

For more details about channel settings, see [Create a
channel](/help/create-a-channel#channel-options).

### Tips for creating channels

{!tips-for-creating-channels.md!}

## Customize settings for new users

{!customize-settings-for-new-users.md!}

## Invite users to join

!!! tip ""
     Before inviting users, you may want to [delete any test messages][delete-message]
     or [topics](/help/delete-a-topic).

[delete-message]: /help/delete-a-message#delete-a-message-completely

### How to invite users to join

{!how-to-invite-users-to-join.md!}

To get everyone off to a good start, you may wish to share the guide
to [Getting started with Zulip](/help/getting-started-with-zulip).

!!! tip ""
    You can link to your Zulip organization with a [nice badge](/help/linking-to-zulip).

## Create user groups

User groups allow you to [mention](/help/mention-a-user-or-group) multiple
users at once, [notifying](/help/dm-mention-alert-notifications) them about a message. For example, you may choose to create user groups for teams in your organization.

### How to create a user group

{!how-to-create-a-user-group.md!}

## Set up integrations

{!set-up-integrations.md!}

## Further reading

* [Getting started with Zulip](/help/getting-started-with-zulip)
* [Introduction to topics](/help/introduction-to-topics)
* [Moderating open organizations](/help/moderating-open-organizations)
* [Setting up Zulip for a class](/help/setting-up-zulip-for-a-class)
