# Import your settings

When you create a Zulip account using an email address already associated with
an account in another Zulip organization, on Zulip Cloud or the same self-hosted
Zulip installation, you can import your user settings from an existing account.
It's a convenient way to preserve the user settings that you've already customized.

!!! tip ""

    Settings that may not apply to all organizations, such as custom profile
    fields, will not be imported.

The import will include your:

- [Name and avatar](/#settings/profile)
- [Privacy settings](/#settings/account-and-privacy)
- [Preferences](/#settings/preferences)
- [Notification settings](/#settings/notifications)
- Tutorial completion status.

### Import your settings

{start_tabs}

1. Follow the instructions for [joining a Zulip organization](/help/join-a-zulip-organization).

1. From the dropdown list under **Import settings from an existing Zulip account**,
   select the account from which you would like to import your settings.

1. Complete the registration form, and click **Sign up**.

1. _(recommended)_ [Review your settings](/help/review-your-settings).

{end_tabs}

## Related articles

* [Joining a Zulip organization](/help/join-a-zulip-organization)
* [Review your settings](/help/review-your-settings)
