## Guides
* [Getting started with Zulip](/help/getting-started-with-zulip)
* [Setting up your organization](/help/getting-your-organization-started-with-zulip)
* [Moderating open organizations](/help/moderating-open-organizations)
* [Setting up Zulip for a class](/help/setting-up-zulip-for-a-class)
* [Using Zulip for a class](/help/using-zulip-for-a-class)
* [Using Zulip via email](/help/using-zulip-via-email)

## Getting started
* [Joining an organization](/help/join-a-zulip-organization)
* [Set up your account](/help/set-up-your-account)
* [Introduction to topics](/help/introduction-to-topics)
* [Starting a new topic](/help/introduction-to-topics#how-to-start-a-new-topic)
* [Finding a conversation to read](/help/finding-a-conversation-to-read)
* [Reading conversations](/help/reading-conversations)
* [Starting a new direct message](/help/starting-a-new-direct-message)
* [Replying to messages](/help/replying-to-messages)
* [Messaging tips & tricks](/help/messaging-tips)
* [Keyboard shortcuts](/help/keyboard-shortcuts)

## Setting up your organization
* [Trying out Zulip](/help/trying-out-zulip)
* [Zulip Cloud or self-hosting?](/help/zulip-cloud-or-self-hosting)
* [Migrating from other chat tools](/help/migrating-from-other-chat-tools)
* [Create your organization profile](/help/create-your-organization-profile)
* [Customize organization settings](/help/customize-organization-settings)
* [Create channels](/help/create-channels)
* [Customize settings for new users](/help/customize-settings-for-new-users)
* [Invite users to join](/help/invite-users-to-join)
* [Create user groups](/help/create-user-groups)
* [Set up integrations](/help/set-up-integrations)

## Account basics
* [Edit your profile](/help/edit-your-profile)
* [Change your name](/help/change-your-name)
* [Change your email address](/help/change-your-email-address)
* [Change your profile picture](/help/change-your-profile-picture)
* [Change your password](/help/change-your-password)
* [Configure email visibility](/help/configure-email-visibility)
* [Logging in](/help/logging-in)
* [Logging out](/help/logging-out)
* [Switching between organizations](/help/switching-between-organizations)
* [Import your settings](/help/import-your-settings)
* [Review your settings](/help/review-your-settings)
* [Deactivate your account](/help/deactivate-your-account)

## Preferences
* [Dark theme](/help/dark-theme)
* [Font size](/help/font-size)
* [Change your language](/help/change-your-language)
* [Change your time zone](/help/change-your-timezone)
* [Change the time format](/help/change-the-time-format)
* [Configure emoticon translations](/help/configure-emoticon-translations)
* [Configure home view](/help/configure-home-view)
* [Enable full width display](/help/enable-full-width-display)
* [Manage your uploaded files](/help/manage-your-uploaded-files)

## Writing messages
* [Message formatting](/help/format-your-message-using-markdown)
* [Mention a user or group](/help/mention-a-user-or-group)
* [Link to a channel, topic, or message](/help/link-to-a-message-or-conversation)
* [Format a quote](/help/format-a-quote)
* [Quote and reply](/help/quote-and-reply)
* [Emoji and emoticons](/help/emoji-and-emoticons)
* [Insert a link](/help/insert-a-link)
* [Share and upload files](/help/share-and-upload-files)
* [Animated GIFs](/help/animated-gifs-from-giphy)
* [Text emphasis](/help/text-emphasis)
* [Paragraph and section formatting](/help/paragraph-and-section-formatting)
* [Bulleted lists](/help/bulleted-lists)
* [Numbered lists](/help/numbered-lists)
* [Tables](/help/tables)
* [Code blocks](/help/code-blocks)
* [LaTeX](/help/latex)
* [Spoilers](/help/spoilers)
* [/me action messages](/help/me-action-messages)
* [Polls](/help/create-a-poll)
* [Collaborative to-do lists](/help/collaborative-to-do-lists)
* [Global times](/help/global-times)
* [Start a call](/help/start-a-call)

## Sending messages
* [Open the compose box](/help/open-the-compose-box)
* [Mastering the compose box](/help/mastering-the-compose-box)
* [Resize the compose box](/help/resize-the-compose-box)
* [Typing notifications](/help/typing-notifications)
* [Preview messages before sending](/help/preview-your-message-before-sending)
* [Verify a message was sent](/help/verify-your-message-was-successfully-sent)
* [Edit a message](/help/edit-a-message)
* [Delete a message](/help/delete-a-message)
* [Draft messages](/help/view-and-edit-your-message-drafts)
* [Schedule a message](/help/schedule-a-message)
* [Message a channel by email](/help/message-a-channel-by-email)

## Reading messages
* [Reading strategies](/help/reading-strategies)
* [Inbox](/help/inbox)
* [Recent conversations](/help/recent-conversations)
* [Combined feed](/help/combined-feed)
* [Channel feed](/help/channel-feed)
* [Left sidebar](/help/left-sidebar)
* [Message actions](/help/message-actions)
* [Marking messages as read](/help/marking-messages-as-read)
* [Marking messages as unread](/help/marking-messages-as-unread)
* [Configure unread message counters](/help/configure-unread-message-counters)
* [Emoji reactions](/help/emoji-reactions)
* [View your mentions](/help/view-your-mentions)
* [Star a message](/help/star-a-message)
* [View images and videos](/help/view-images-and-videos)
* [View messages sent by a user](/help/view-messages-sent-by-a-user)
* [Link to a message or conversation](/help/link-to-a-message-or-conversation)
* [Searching for messages](/help/search-for-messages)
* [Printing messages](/help/printing-messages)
* [View message Markdown source](/help/view-the-markdown-source-of-a-message)
* [View when message was sent](/help/view-the-exact-time-a-message-was-sent)
* [View a message's edit history](/help/view-a-messages-edit-history)
* [Collapse a message](/help/collapse-a-message)
* [Read receipts](/help/read-receipts)

## People
* [User list](/help/user-list)
* [Status and availability](/help/status-and-availability)
* [User cards](/help/user-cards)
* [View someone's profile](/help/view-someones-profile)
* [Direct messages](/help/direct-messages)
* [User groups](/help/user-groups)
* [Find administrators](/help/find-administrators)

## Channels
* [Introduction to channels](/help/introduction-to-channels)
* [Create a channel](/help/create-a-channel)
* [Pin a channel](/help/pin-a-channel)
* [Change the color of a channel](/help/change-the-color-of-a-channel)
* [Unsubscribe from a channel](/help/unsubscribe-from-a-channel)
* [Manage inactive channels](/help/manage-inactive-channels)
* [Move content to another channel](/help/move-content-to-another-channel)
* [View channel subscribers](/help/view-channel-subscribers)

## Topics
* [Introduction to topics](/help/introduction-to-topics)
* [Rename a topic](/help/rename-a-topic)
* [Resolve a topic](/help/resolve-a-topic)
* [Move content to another topic](/help/move-content-to-another-topic)
* [Delete a topic](/help/delete-a-topic)

## Notifications
* [Channel notifications](/help/channel-notifications)
* [Topic notifications](/help/topic-notifications)
* [Follow a topic](/help/follow-a-topic)
* [DMs, mentions, and alerts](/help/dm-mention-alert-notifications)
* [Mute or unmute a channel](/help/mute-a-channel)
* [Mute or unmute a topic](/help/mute-a-topic)
* [Mute a user](/help/mute-a-user)
* [Email notifications](/help/email-notifications)
* [Desktop notifications](/help/desktop-notifications)
* [Mobile notifications](/help/mobile-notifications)
* [Do not disturb](/help/do-not-disturb)

## Apps
* [Download apps for every platform](https://zulip.com/apps/)
* [Desktop installation guides](/help/desktop-app-install-guide)
* [Supported browsers](/help/supported-browsers)
* [Configure how links open](/help/configure-how-links-open)
* [Connect through a proxy](/help/connect-through-a-proxy)
* [Use a custom certificate](/help/custom-certificates)

# Zulip administration

## Organization basics
* [Review your organization's settings](/help/review-your-organization-settings)
* [Organization type](/help/organization-type)
* [Communities directory](/help/communities-directory)
* [Import from Mattermost](/help/import-from-mattermost)
* [Import from Slack](/help/import-from-slack)
* [Import from Rocket.Chat](/help/import-from-rocketchat)
* [Configure authentication methods](/help/configure-authentication-methods)
* [SAML authentication](/help/saml-authentication)
* [SCIM provisioning](/help/scim)
* [Export your organization](/help/export-your-organization)
* [Change organization URL](/help/change-organization-url)
* [Deactivate your organization](/help/deactivate-your-organization)
* [Usage statistics](/help/analytics)
* [Linking to your organization](/help/linking-to-zulip)
* [GDPR compliance](/help/gdpr-compliance)

## Users
* [Roles and permissions](/help/roles-and-permissions)
* [Invite new users](/help/invite-new-users)
* [Restrict account creation](/help/restrict-account-creation)
* [Guest users](/help/guest-users)
* [Manage a user](/help/manage-a-user)
* [Deactivate or reactivate a user](/help/deactivate-or-reactivate-a-user)
* [Custom profile fields](/help/custom-profile-fields)
* [Configure default new user settings](/help/configure-default-new-user-settings)
* [Configure organization language](/help/configure-organization-language)
* [Manage user groups](/help/manage-user-groups)
* [Change a user's role](/help/change-a-users-role)
* [Change a user's name](/help/change-a-users-name)
* [Manage a user's channel subscriptions](/help/manage-user-channel-subscriptions)
* [Restrict name and email changes](/help/restrict-name-and-email-changes)
* [Restrict profile picture changes](/help/restrict-profile-picture-changes)
* [Restrict permissions of new members](/help/restrict-permissions-of-new-members)

## Channel management
* [Create a channel](/help/create-a-channel)
* [Channel permissions](/help/channel-permissions)
* [Public access option](/help/public-access-option)
* [Channel posting policy](/help/channel-posting-policy)
* [Restrict channel creation](/help/configure-who-can-create-channels)
* [Restrict channel membership management](/help/configure-who-can-invite-to-channels)
* [Add or remove users from a channel](/help/add-or-remove-users-from-a-channel)
* [Set default channels for new users](/help/set-default-channels-for-new-users)
* [Rename a channel](/help/rename-a-channel)
* [Change a channel's description](/help/change-the-channel-description)
* [Change the privacy of a channel](/help/change-the-privacy-of-a-channel)
* [Delete or archive a channel](/help/archive-a-channel)

## Organization settings
* [Custom emoji](/help/custom-emoji)
* [Add a custom linkifier](/help/add-a-custom-linkifier)
* [Require topics in channel messages](/help/require-topics)
* [Restrict direct messages](/help/restrict-direct-messages)
* [Restrict wildcard mentions](/help/restrict-wildcard-mentions)
* [Restrict moving messages](/help/restrict-moving-messages)
* [Restrict message editing](/help/restrict-message-editing-and-deletion)
* [Disable message edit history](/help/disable-message-edit-history)
* [Image, video and website previews](/help/allow-image-link-previews)
* [Hide message content in emails](/help/hide-message-content-in-emails)
* [Message retention policy](/help/message-retention-policy)
* [Weekly digest emails](/help/digest-emails)
* [Disable welcome emails](/help/disable-welcome-emails)
* [Configure automated notices](/help/configure-automated-notices)
* [Configure multi-language search](/help/configure-multi-language-search)

## Bots & integrations
* [Bots overview](/help/bots-overview)
* [Integrations overview](/help/integrations-overview)
* [Add a bot or integration](/help/add-a-bot-or-integration)
* [Generate integration URL](/help/generate-integration-url)
* [Edit a bot](/help/edit-a-bot)
* [Deactivate or reactivate a bot](/help/deactivate-or-reactivate-a-bot)
* [Request an integration](/help/request-an-integration)
* [Restrict bot creation](/help/restrict-bot-creation)
* [View your bots](/help/view-your-bots)
* [View all bots in your organization](/help/view-all-bots-in-your-organization)

## Support
* [View Zulip version](/help/view-zulip-version)
* [Zulip Cloud billing](/help/zulip-cloud-billing)
* [Self-hosted billing](/help/self-hosted-billing)
* [Support the Zulip project](/help/support-zulip-project)
* [Linking to the Zulip website](/help/linking-to-zulip-website)
* [Contact support](/help/contact-support)
