# Keyboard shortcuts

Everything in Zulip can be done with the mouse, but mastering a few keyboard
shortcuts will change your experience of the app. Start with the basics below,
and use the convenient [**keyboard shortcuts reference**](#keyboard-shortcuts-reference)
in the Zulip app to add more to your repertoire as needed.

* [The basics](#the-basics)
* [Search](#search)
* [Scrolling](#scrolling)
* [Navigation](#navigation)
* [Composing messages](#composing-messages)
* [Message actions](#message-actions)
* [Drafts](#drafts)
* [Menus](#menus)
* [Channel settings](#channel-settings)

## The basics

* **Reply to message**: <kbd>R</kbd> or <kbd>Enter</kbd> — Reply to the
  selected message (outlined in blue).

* **New channel message**: <kbd>C</kbd> — Start a new topic in the current
  channel.

* **New direct message**: <kbd>X</kbd>

* **Paste formatted text**: <kbd>Ctrl</kbd> + <kbd>V</kbd>

* **Paste as plain text**: <kbd data-mac-following-key="⌥">Ctrl</kbd> +
  <kbd>Shift</kbd> + <kbd>V</kbd>. You can also paste formatted text with
  <kbd>Ctrl</kbd> + <kbd>V</kbd>, and press <kbd>Ctrl</kbd> + <kbd>Z</kbd> to
  remove formatting.

* **Cancel compose and save draft**: <kbd>Esc</kbd> or <kbd>Ctrl</kbd> +
  <kbd>[</kbd> — Close the compose box and save the unsent message as a
  draft.

* **View drafts**: <kbd>D</kbd> — Use the arrow keys and <kbd>Enter</kbd>
  to restore a draft. Press <kbd>D</kbd> again to close.

* **Next message**: <kbd class="arrow-key">↓</kbd> or <kbd>J</kbd>

* **Last message**: <kbd>End</kbd> or <kbd>Shift</kbd> + <kbd>G</kbd> —
  Also marks all messages in the current view as read.

* **Next unread topic**: <kbd>N</kbd>

* **Next unread followed topic**: <kbd>Shift</kbd> + <kbd>N</kbd>

* **Next unread direct message**: <kbd>P</kbd>

* **Search messages**: <kbd>/</kbd>

* **Toggle keyboard shortcuts view**: <kbd>?</kbd>

* **Go to your home view**: <kbd>Ctrl</kbd> + <kbd>[</kbd> (or
  <kbd>Esc</kbd>, [if enabled][disable-escape])
  until you are in your [home view](/help/configure-home-view).

[disable-escape]: /help/configure-home-view#configure-whether-esc-navigates-to-the-home-view
## Search

* **Search messages**: <kbd>/</kbd> or <kbd>Ctrl</kbd> + <kbd>K</kbd>

* **Filter channels**: <kbd>Q</kbd>

* **Search people**: <kbd>W</kbd>

## Scrolling

* **Last message**: <kbd>End</kbd> or <kbd>Shift</kbd> + <kbd>G</kbd> —
  Also marks all messages in the current view as read.

* **First message**: <kbd>Home</kbd>

* **Previous message**: <kbd class="arrow-key">↑</kbd> or <kbd>K</kbd>

* **Next message**: <kbd class="arrow-key">↓</kbd> or <kbd>J</kbd>

* **Scroll up**: <kbd>PgUp</kbd> or <kbd>Shift</kbd> + <kbd>K</kbd>

* **Scroll down**: <kbd>PgDn</kbd>, <kbd>Shift</kbd> + <kbd>J</kbd>, or
  <kbd>Spacebar</kbd>

## Navigation

* **Go back through viewing history**: <kbd data-mac-key="⌘">Alt</kbd> +
  <kbd class="arrow-key">←</kbd>

* **Go forward through viewing history**: <kbd data-mac-key="⌘">Alt</kbd> +
  <kbd class="arrow-key">→</kbd>

* **Go to next unread topic**: <kbd>N</kbd>

* **Go to next unread direct message**: <kbd>P</kbd>

* **Go to topic or DM conversation**: <kbd>S</kbd>

* **Go to channel feed from topic view**: <kbd>S</kbd>

* **Go to direct message feed**: <kbd>Shift</kbd> + <kbd>P</kbd>

* **Zoom to message in conversation context**: <kbd>Z</kbd> — This view does not mark messages as read.

* **Cycle between channel views**: <kbd>Shift</kbd> + <kbd>A</kbd>
  (previous) and <kbd>Shift</kbd> + <kbd>D</kbd> (next)

* **Go to combined feed**: <kbd>A</kbd> — Shows all unmuted messages.

* **Go to the conversation you are composing to**: <kbd>Ctrl</kbd> + <kbd>.</kbd>

## Composing messages

* **New channel message**: <kbd>C</kbd> — For starting a new topic in a
  channel.

* **New direct message**: <kbd>X</kbd>

* **Reply to message**: <kbd>R</kbd> or <kbd>Enter</kbd> — Reply to the
  selected message (outlined in blue). Same behavior as clicking on the
  message.

* **Quote and reply to message**: <kbd>></kbd>

* **Reply directly to sender**: <kbd>Shift</kbd> + <kbd>R</kbd>

* **Reply @-mentioning sender**: <kbd>@</kbd>

### In the compose box

* **Send message**: <kbd>Enter</kbd>, <kbd>Tab</kbd> then <kbd>Enter</kbd>,
  and/or <kbd>Ctrl</kbd> + <kbd>Enter</kbd>, depending on your settings. See
  [enable enter to send](/help/mastering-the-compose-box#toggle-between-ctrl-enter-and-enter-to-send-a-message).

* **Insert new line**: <kbd>Enter</kbd>, or <kbd>Shift</kbd> + <kbd>Enter</kbd>,
  depending on your settings. See
  [enable enter to send](/help/mastering-the-compose-box#toggle-between-ctrl-enter-and-enter-to-send-a-message).

* **Insert italic text**: `*italic*` or <kbd>Ctrl</kbd> + <kbd>I</kbd>

* **Insert bold text**: `**bold**` or <kbd>Ctrl</kbd> + <kbd>B</kbd>

* **Insert link**: `[Zulip website](https://zulip.org)` or <kbd>Ctrl</kbd> +
  <kbd>Shift</kbd> + <kbd>L</kbd>

* **Toggle preview mode**: <kbd>Alt</kbd> + <kbd>P</kbd>

* **Cancel compose and save draft**: <kbd>Esc</kbd> or <kbd>Ctrl</kbd> +
  <kbd>[</kbd> — Close the compose box and save the unsent message as a draft.

## Message actions

* **Edit last message**: <kbd class="arrow-key">←</kbd> — Open the last
  editable message in the current view (if any).

### For a selected message (outlined in blue)

* **Edit message or view original message**: <kbd>E</kbd>

* **Show message sender's user card**: <kbd>U</kbd>

* **View read receipts**: <kbd>Shift</kbd> + <kbd>V</kbd> — Same shortcut
  also closes the read receipts menu (if open).

* **View image**: <kbd>V</kbd>

* **Move message and (optionally) other messages in the same topic**: <kbd>M</kbd>

* **View message edit and move history**: <kbd>Shift</kbd> +
  <kbd>H</kbd>. Message edit history [must be
  enabled](/help/disable-message-edit-history).

* **Star message**: <kbd>Ctrl</kbd> + <kbd>S</kbd>

* **React with <img alt=":thumbs_up:" class="emoji"
  src="/static/generated/emoji/images/emoji/unicode/1f44d.png"
  title="thumbs up"/>**: <kbd>+</kbd>

* **Toggle first emoji reaction**: <kbd>=</kbd>

* **Mark as unread from selected message**: <kbd>Shift</kbd> + <kbd>U</kbd>

* **Collapse/show message**: <kbd>-</kbd>

* **Toggle topic mute**: <kbd>Shift</kbd> + <kbd>M</kbd>. This works in both
  message views and views that list topics (e.g., [inbox](/help/inbox), [recent
  conversations](/help/recent-conversations)). Learn about [muted
  topics](/help/mute-a-topic).

## Recent conversations

* **View recent conversations**: <kbd>T</kbd>

* **Search recent conversations**: <kbd>T</kbd>

* **Escape from recent conversations search**: <kbd>Esc</kbd> or arrow keys

* **Navigate recent conversations**: Use arrow keys or vim keys
  (<kbd>J</kbd>, <kbd>K</kbd>, <kbd>L</kbd>, <kbd>H</kbd>).

Use <kbd>Enter</kbd> to engage with elements.

## Drafts

* **Toggle drafts view**: <kbd>D</kbd>

### Within the drafts view

* **Edit selected draft**: <kbd>Enter</kbd>

* **Delete selected draft**: <kbd>Backspace</kbd>

Keyboard navigation (e.g., arrow keys) works as expected.

## Menus

* **Toggle shortcuts help**: <kbd>?</kbd>

* **Toggle gear menu**: <kbd>G</kbd>

* **Open personal menu**: <kbd>G</kbd> + <kbd class="arrow-key">→</kbd>

* **Open help menu**: <kbd>G</kbd> + <kbd class="arrow-key">←</kbd>

### For a selected message (outlined in blue)

* **Toggle emoji reactions menu**: <kbd>:</kbd>

* **Toggle message actions menu**: <kbd>I</kbd>

## Channel settings

* **Scroll through channels**: <kbd class="arrow-key">↑</kbd> and
  <kbd class="arrow-key">↓</kbd>

    !!! tip ""

        Pressing <kbd class="arrow-key">↑</kbd> from the first channel
        in the list moves you to the **Filter channels** input.

* **Switch between tabs**: <kbd class="arrow-key">←</kbd> and
  <kbd class="arrow-key">→</kbd> — Switch between the **Subscribed**
  and **All channels** tabs.

* **Create new channel**: <kbd>N</kbd>

### For a selected channel

* **View channel messages**: <kbd>Shift</kbd> + <kbd>V</kbd>

* **Toggle subscription**: <kbd>Shift</kbd> + <kbd>S</kbd>


## Keyboard shortcuts reference

A summary of the keyboard shortcuts above is available in the Zulip app.

{start_tabs}

{tab|desktop-web}

{relative|help|keyboard-shortcuts}

!!! keyboard_tip ""

    You can also use <kbd>?</kbd> to open the keyboard shortcuts reference.

{end_tabs}

## Related articles

* [Reading strategies](/help/reading-strategies)
