# Left sidebar

The left sidebar in the Zulip web and desktop apps helps you navigate your
conversations. It has three main sections:

- **Views** provide various ways to get an overview of your messages.
- The **direct messages** section shows your [direct
  message](/help/direct-messages) conversations.
- The **channels** section shows the [channels](/help/introduction-to-channels)
  you are subscribed to.

You can customize how channels are organized within the **channels**
section by:

- [Pinning channels](/help/pin-a-channel) so that they appear in the top section.
- [Changing channel colors](/help/change-the-color-of-a-channel).
- [Configuring](/help/manage-inactive-channels) whether inactive channels are
  sorted at the bottom.

You can also [configure](#configure-where-channel-links-in-the-left-sidebar-go)
where clicking on channel links in the left sidebar takes you.

## Adjust what information is shown

There are many ways you can adjust the left sidebar to help you focus on the
information you need in the moment.

### Expand or collapse the views section

{start_tabs}

1. Click the triangle to the left of **VIEWS** in the left sidebar.

{end_tabs}

### Expand or collapse the direct messages section

{start_tabs}

1. Click the triangle to the left of **DIRECT MESSAGES** in the left sidebar.

{end_tabs}

### Show more direct message conversations

{start_tabs}

1. If the **DIRECT MESSAGES** section in the left sidebar is collapsed, click the triangle to the
   left of **DIRECT MESSAGES** to expand it.

1. Click **more conversations** at the bottom of the list of recent DM conversations.

!!! tip ""

    To return to the channel list in the left sidebar, click **back to channels**.

{end_tabs}


### Show all topics in a channel

{start_tabs}

1. Click on a channel in the left sidebar.

1. Click **show all topics** at the bottom of the list of recent topics in the
   selected channel.

!!! tip ""

     To return to the channel list in the left sidebar, click **BACK TO
     CHANNELS**.

{end_tabs}

### Hide or show the left sidebar

{start_tabs}

1. Above the left sidebar, click the <i class="fa fa-reorder"></i> icon.

{end_tabs}

## Configure where channel links in the left sidebar go

{!configure-channel-links.md!}

## Related articles
* [Reading strategies](/help/reading-strategies)
* [Configuring unread message counters](/help/configure-unread-message-counters)
* [Inbox](/help/inbox)
* [Recent conversations](/help/recent-conversations)
* [Combined feed](/help/combined-feed)
* [Channel feed](/help/channel-feed)
* [View your mentions](/help/view-your-mentions)
* [Star a message](/help/star-a-message)
