# Marking messages as read

Zulip automatically keeps track of which messages you have and haven't read.
Unread messages have a line along the left side, which fades when the message
gets marked as read.

Zulip offers tools to manually mark one or more messages as read, and you can
configure whether messages are marked as read automatically when you scroll.

## Configure whether messages are automatically marked as read

You can choose how messages are automatically marked as read in the Zulip web
and mobile apps. You can configure the mobile app differently from the
web/desktop app.

- **Always**: Messages are marked as read whenever you scroll through them in
  the app. You may be used to this from other chat applications.
- **Never**: Messages are marked as read only
  [manually](#mark-all-messages-as-read). For example, if you often need to
  follow up on messages at your computer after reading them in the mobile app,
  you can choose this option for the mobile app.
- **Only in conversation views**: In Zulip, a **conversation** is a [direct
  message](/help/direct-messages) thread (one-on-one or with a group), or a
  [topic in a channel](/help/introduction-to-topics). This option makes it
  convenient to preview new messages in a channel, or skim [Combined
  feed](/help/combined-feed), and later read each topic in detail.

{start_tabs}

{tab|desktop-web}

{settings_tab|preferences}

1. Under **Navigation**, click on the **Automatically mark messages as
   read** dropdown, and select **Always**, **Never** or **Only in
   [conversation](/help/reading-conversations) views**.

{tab|mobile}

{!mobile-profile-menu.md!}

1. Tap **Settings**.

1. Tap **Mark messages as read on scroll**.

1. Select **Always**, **Never** or **Only in
   [conversation](/help/reading-conversations) views**.

{end_tabs}

## Mark a message as read

{start_tabs}

{tab|desktop-web}

1. Select the message using the **blue box** to mark it as read. You can scroll
   the **blue box** using the mouse, or with [keyboard navigation
   shortcuts](/help/keyboard-shortcuts#navigation).

{end_tabs}

## Mark all messages as read

You can manually **mark all messages as read**, or **mark all messages in a
channel or topic as read**.

{start_tabs}

{tab|via-left-sidebar}

1. Hover over a channel, topic, or **Combined feed** in the left sidebar.

1. Click on the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>).

1. Click **Mark all messages as read**.

!!! tip ""

    You can also mark all messages in your current view as read by
    jumping to the bottom with the **Scroll to bottom**
    (<i class="fa fa-chevron-down"></i>) button or the <kbd>End</kbd> shortcut.

{tab|via-inbox-view}

{!go-to-inbox.md!}

1. Hover over a channel or topic in the left sidebar.

1. Click on the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>).

1. Click **Mark all messages as read**.

{tab|via-recent-conversations}

{!go-to-recent-conversations.md!}

1. Click on an unread messages counter in the **Topic** column to mark all
   messages in that topic as read.

{tab|mobile}

1. Tap a channel, topic, or the **Combined feed**
   (<img src="/static/images/help/mobile-globe-icon.svg" alt="globe" class="help-center-icon"/>)
   tab.

2. Tap **Mark channel as read**, **Mark topic as read**, or **Mark all as read**
   near the top right corner of the app.

!!! tip ""

    You can also press and hold a topic until the long-press menu appears, and
    select **Mark topic as read**.

{end_tabs}

## Related articles

* [Marking messages as unread](/help/marking-messages-as-unread)
* [Reading strategies](/help/reading-strategies)
* [Read receipts](/help/read-receipts)
