# Mastering the compose box

## Composing to a different conversation

When composing a message, Zulip lets you view a different
[conversation](/help/reading-conversations) from the one you are composing to.
For example, you can start a new topic without changing your view, send a
direct message about the topic you're viewing, or look up a related discussion.

In this context, the parts of the message view that are outside of the
conversation you are composing to are faded for clarity.

### Change where you are composing to

No matter where you start composing your message, it's easy to change where it
will be sent.

{start_tabs}

{tab|channel-compose}

{!start-composing.md!}

1. Select any channel from the dropdown in the top left of the compose box. You can
   start typing to filter channels.

1. Enter a topic name. Auto-complete will provide suggestions for previously
   used topics.

{tab|dm-compose}

{!start-composing.md!}

1. Select **Direct message** from the dropdown in the top left of the compose
   box.

1. Start typing the name of the person you want to message, and
   select their name from the list of suggestions. You can continue
   adding as many message recipients as you like.

{end_tabs}


### Go to conversation

Zulip lets you jump to the [conversation](/help/reading-conversations) you're
currently composing to.

{start_tabs}

1. [Open the compose box](/help/open-the-compose-box).

1. Click the highlighted **Go to conversation** (<i class="zulip-icon
   zulip-icon-chevron-right"></i>) button at the top of the compose box. It will
   be clickable only if you're viewing a different conversation from the one you
   are composing to.

!!! keyboard_tip ""

    Use <kbd>Ctrl</kbd> + <kbd>.</kbd> to go to the conversation you're
    composing to.

{end_tabs}

### Automatically go to conversation where you sent a message

{start_tabs}

{settings_tab|preferences}

1. Under **Navigation**, toggle **Automatically go to conversation
where you sent a message**, as desired.

{end_tabs}

## Toggle between <kbd>Ctrl</kbd> + <kbd>Enter</kbd> and <kbd>Enter</kbd> to send a message

By default, the <kbd>Enter</kbd> key adds a new line to your message,
and <kbd>Ctrl</kbd> + <kbd>Enter</kbd> sends your message.

This is convenient for typing multi-line messages, which are more common in
Zulip than in most other chat products. However, you can also configure
Zulip so that the <kbd>Enter</kbd> key sends your message.

!!! tip ""

    <kbd>Shift</kbd> + <kbd>Enter</kbd> always adds a new line, regardless
    of whether **<kbd>Enter</kbd> to send** is enabled.

### Enable <kbd>Enter</kbd> to send

{start_tabs}

{!start-composing.md!}

1. Click on the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>)
   in the bottom right corner of the compose box, next to the **Send**
   (<i class="zulip-icon zulip-icon-send"></i>) button.

1. Select **<kbd>Enter</kbd> to send**.

{end_tabs}

### Enable **<kbd>Ctrl</kbd> + <kbd>Enter</kbd> to send**

{start_tabs}

{!start-composing.md!}

1. Click on the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>)
   in the bottom right corner of the compose box, next to the **Send**
   (<i class="zulip-icon zulip-icon-send"></i>) button.

1. Select **<kbd>Ctrl</kbd> + <kbd>Enter</kbd> to send**.

{end_tabs}

## Related articles

* [Resize the compose box](/help/resize-the-compose-box)
* [Message formatting](/help/format-your-message-using-markdown)
* [Preview messages before sending](/help/preview-your-message-before-sending)
* [Messaging tips and tricks](/help/messaging-tips)
