# Reading strategies

In Zulip, channels determine who gets a message. Topics tell you what
the message is about. If you are not yet familiar with Zulip's topics,
we recommend first reading about [channels](introduction-to-channels) and
[topics](/help/introduction-to-topics).

This article describes a few ways to efficiently read through messages
in Zulip.

## Conversation by conversation

{!conversation-definition.md!}

{!conversation-recommendation.md!}

### Finding a conversation to read

#### From the Inbox view

{!inbox-intro.md!}

{!inbox-instructions.md!}

#### From Recent conversations

{!recent-conversations.md!}

#### From the left sidebar

{!left-sidebar-conversations.md!}

### Reading conversations

{!reading-conversations.md!}

### Following, muting and unmuting conversations

You can improve your workflow for catching up on messages by taking advantage of
[following topics](/help/follow-a-topic), as well as muting and unmuting
[channels](/help/mute-a-channel) and [topics](/help/mute-a-topic). Some example
workflows:

{!followed-topic-workflows.md!}

## Combined views

### Combined feed

{!combined-feed.md!}

### Direct message feed

You can see all your direct messages in one place.

{start_tabs}

{tab|desktop-web}

1. Click on the **Direct message feed** (<i class="fa fa-align-right"></i>)
   icon next to **DIRECT MESSAGES** in the left sidebar.

1. Read your direct messages, starting from your first unread message. You can
   scroll using your mouse, the arrow keys, <kbd>End</kbd>, or page up/down.

1. You can click on a conversation in the left sidebar or a message recipient
   bar to view that conversation.

!!! keyboard_tip ""

    Use the <kbd>Shift</kbd> + <kbd>P</kbd> keyboard shortcut to go to
    **Direct message feed**.

{end_tabs}

### Channel view

Sometimes it's useful to scroll through all the messages in a channel,
especially in situations where you just want a general idea of what's going
on.

{start_tabs}

{tab|desktop-web}

1. Find the channel you want to read in the left sidebar. If you don't see it
   right away, you can search for a channel by clicking on **CHANNELS** in the
   left sidebar, or using the <kbd>Q</kbd> [keyboard
   shortcut](/help/keyboard-shortcuts).

1. Click on the channel name in the left sidebar.

1. Read messages in the channel, starting from your first unread message. You can
  scroll using your mouse, the arrow keys, <kbd>End</kbd>, or page up/down.

1. You can click on a topic in the left sidebar or a message recipient bar to
   view that topic.

{end_tabs}

## Special views

### Mentions

The mentions view lets you quickly find all the places where you were
[mentioned](/help/mention-a-user-or-group). Reviewing your mentions can be a
good way to start your day.

{!view-mentions.md!}

### Starred messages

You can [star messages](/help/star-a-message) that you plan to follow up on later.

#### View starred messages

{!view-starred-messages.md!}

## Related articles

* [Getting started with Zulip](/help/getting-started-with-zulip)
* [Recent conversations](/help/recent-conversations)
* [Searching for messages](/help/search-for-messages)
* [Marking messages as read](/help/marking-messages-as-read)
* [Marking messages as unread](/help/marking-messages-as-unread)
